//
// CI Training
//

#include "stagesetup.h"

// Characters
#define CHR_CARRINGTON 0x00

// Objects
#define OBJ_CAMSPY      0x26
#define OBJ_LIGHTSWITCH 0x34
#define OBJ_HOVERCRATE  0x93

// Stage flags
#define STAGEFLAG_IN_TRAINING            0x00000001
#define STAGEFLAG_HOLO_FAILED            0x00000002
#define STAGEFLAG_DEVICE_ABORTING        0x00000004
#define STAGEFLAG_TRIGGER_DEVICE_SUCCESS 0x00000008
#define STAGEFLAG_TRIGGER_DEVICE_FAILURE 0x00000010
#define STAGEFLAG_HOLO_ABORTING          0x00000020
#define STAGEFLAG_TRIGGER_HOLO_SUCCESS   0x00000040
#define STAGEFLAG_TRIGGER_HOLO_FAILURE   0x00000080
#define STAGEFLAG_TRIGGER_UPLINK         0x00000100
#define STAGEFLAG_TRIGGER_ECMMINE        0x00000200
#define STAGEFLAG_TRIGGER_CAMSPY         0x00000400
#define STAGEFLAG_TRIGGER_NIGHTVISION    0x00000800
#define STAGEFLAG_TRIGGER_DOORDECODER    0x00001000
#define STAGEFLAG_TRIGGER_RTRACKER       0x00002000
#define STAGEFLAG_TRIGGER_IR             0x00004000
#define STAGEFLAG_TRIGGER_XRAY           0x00008000
#define STAGEFLAG_TRIGGER_DISGUISE       0x00010000
#define STAGEFLAG_TRIGGER_CLOAK          0x00020000
#define STAGEFLAG_IN_HOLO1               0x00040000
#define STAGEFLAG_IN_HOLO2               0x00080000
#define STAGEFLAG_IN_HOLO3               0x00100000
#define STAGEFLAG_IN_HOLO4               0x00200000
#define STAGEFLAG_IN_HOLO5               0x00400000
#define STAGEFLAG_IN_HOLO6               0x00800000
#define STAGEFLAG_IN_HOLO7               0x01000000
#define STAGEFLAG_GENERAL_PURPOSE        0x02000000
#define STAGEFLAG_TRIGGER_CANNOTEXIT_MSG 0x04000000
#define STAGEFLAG_CONSIDER_WARP          0x08000000
#define STAGEFLAG_CLOAK_COMPLETE         0x10000000
#define STAGEFLAG_CLOAK_FAILED           0x20000000
#define STAGEFLAG_DISGUISE_FAILED        0x40000000
#define STAGEFLAG_DISGUISE_COMPLETE      0x80000000

// AI Lists
#define AILIST_MOVE_TO_DEVICEROOM             0x0401
#define AILIST_MOVE_TO_HOLOROOM               0x0402
#define AILIST_HOLO4_GUARD1                   0x0403
#define AILIST_HOLO4_GUARD2                   0x0404
#define AILIST_HOLO4_GUARD3                   0x0405
#define AILIST_HOLO5_INIT_GUARD1              0x0406
#define AILIST_HOLO5_GUARD1                   0x0407
#define AILIST_HOLO5_INIT_GUARD2              0x0408
#define AILIST_HOLO5_GUARD2                   0x0409
#define AILIST_HOLO5_INIT_GUARD3              0x040a
#define AILIST_HOLO5_GUARD3                   0x040b
#define AILIST_HOLO6_INIT_GUARD1              0x040c
#define AILIST_HOLO6_INIT_GUARD2              0x040d
#define AILIST_HOLO6_INIT_GUARD3              0x040e
#define AILIST_HOLO6_INIT_GUARD4              0x040f
#define AILIST_HOLO7_INIT_GUARD4              0x0410
#define AILIST_HOLO7_INIT_GUARD5              0x0411
#define AILIST_HOLO7_INIT_GUARD1              0x0412
#define AILIST_HOLO7_INIT_GUARD2              0x0413
#define AILIST_HOLO7_INIT_GUARD3              0x0414
#define AILIST_HOLO_GUARD_UNARMED_UNALERT     0x0415
#define AILIST_HOLO_GUARD_UNARMED_ALERT       0x0416
#define AILIST_HOLO_GUARD_UNARMED_ALERT2      0x0417
#define AILIST_HOLO_GUARD_ARMED_UNALERT       0x0418
#define AILIST_HOLO_GUARD_ARMED_ALERT         0x0419
#define AILIST_HOLO3_CHECK_DONE               0x041c
#define AILIST_INIT_COLLEAGUE_WHEN_SIGHTED    0x041d
#define AILIST_COLLEAGUE                      0x041e
#define AILIST_GRIMSHAW_DISGUISE              0x0429
#define AILIST_CARRINGTON_CLOAK               0x042a
#define AILIST_INIT_CARRINGTON                0x042b
#define AILIST_CARRINGTON_TOUR                0x042c
#define AILIST_DEVICEGIRL_REPLY_TO_CARRINGTON 0x042e
#define AILIST_HOLO1_CHECK_DONE               0x0430
#define AILIST_HOLO3_OBJECT1                  0x0435
#define AILIST_HOLO3_OBJECT2                  0x0436
#define AILIST_HOLO1_SWITCH1                  0x0437
#define AILIST_HOLO1_SWITCH2                  0x0438
#define AILIST_HOLO1_SWITCH3                  0x0439
#define AILIST_HOLO1_MONITOR_SWITCHES         0x043a

// Pads
#define PAD_OUTSIDE_JO_OFFICE 0x0053
#define PAD_CARRINGTON_OFFICE 0x00f6
#define PAD_DEVICEROOM        0x0121
#define PAD_HOLOROOM          0x0273

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	door(0x0100, MODEL_INSTFRONTDOOR, 0x018d, 0x10000600, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_INSTFRONTDOOR, 0x018e, 0x10000600, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_INSTFRONTDOOR, 0x018f, 0x10000600, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_INSTFRONTDOOR, 0x0190, 0x10000600, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CIDOOR1_REF, 0x0156, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CIDOOR1_REF, 0x0157, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x75, 2)
	tag(0x76, 2)
	door(0x0100, MODEL_CIDOOR1_REF, 0x0158, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CIDOOR1_REF, 0x0159, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x8a, 1)
	door(0x0100, MODEL_CIDOOR1_REF, 0x015b, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CIDOOR1_REF, 0x015c, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x31, 1)
	door(0x0100, MODEL_CIDOOR1_REF, 0x015a, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x89, 1)
	door(0x0100, MODEL_CIDOOR1_REF, 0x015d, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x91, 2)
	tag(0x92, 1)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x018c, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_CI_SOFA, 0x0212, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CI_SOFA, 0x0213, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CI_SOFA, 0x0214, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CI_SOFA, 0x0215, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CI_SOFA, 0x0216, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CI_SOFA, 0x0217, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CI_SOFA, 0x0218, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_CI_SOFA, 0x0219, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AIRBASE_SAFEDOOR, 0x025b, 0x000205e8, 0x00200002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000fa0, 0x00000000, 0x00000000, 0x0fff0000)
	glass(0x0100, MODEL_WINDOW, 0x019f, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x019e, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x019d, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x019c, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01a0, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01a1, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01a2, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01a3, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01a8, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01a9, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01aa, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01ab, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01ac, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01ad, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01ae, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01af, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01b7, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01b8, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01b9, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01ba, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01bb, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01bc, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01bd, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01be, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01bf, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01c3, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c4, 0x04020362, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c5, 0x04020362, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c6, 0x04020362, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c7, 0x04020362, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01d1, 0x04000362, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x80, 6)
	tag(0x81, 6)
	tag(0x82, 6)
	tag(0x83, 6)
	tag(0x43, 1)
	lift(0x0100, MODEL_CI_LIFT, 0x0193, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0193, 0x0194, 0xffffffff, 0x00000001, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x16000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x015e, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x015f, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0160, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0161, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-4, -5, 0, 0)
	link_objects(-4, -6, 0, 0)
	link_objects(-4, -7, 0, 1)
	link_objects(-4, -8, 0, 1)
	tag(0x84, 6)
	tag(0x85, 6)
	tag(0x86, 6)
	tag(0x87, 6)
	tag(0x44, 1)
	lift(0x0100, MODEL_CI_LIFT, 0x0195, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0195, 0x0196, 0xffffffff, 0x00000001, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x16000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0164, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0165, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0162, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0163, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-4, -5, 0, 0)
	link_objects(-4, -6, 0, 0)
	link_objects(-4, -7, 0, 1)
	link_objects(-4, -8, 0, 1)
	tag(0x00, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x021b, 0x000205e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x021a, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1b, 1)
	singlemonitor(0x0100, MODEL_GOODPC, 0x021c, 0x000204e1, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x01, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x021f, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x021d, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x10, 1)
	singlemonitor(0x0100, MODEL_GOODPC, 0x021e, 0x000004e1, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x02, 1)
	stdobject(0x00b3, MODEL_DD_CHAIR, 0x0220, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x0222, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x0f, 1)
	singlemonitor(0x0100, MODEL_GOODPC, 0x0221, 0x000004e1, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x33, -1)
	tag(0x0d, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0223, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x0225, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x0e, 1)
	singlemonitor(0x0100, MODEL_GOODPC, 0x0224, 0x000004e1, 0x00020000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x7f, 1)
	singlemonitor(0x0100, MODEL_GOODPC, 0x022d, 0x000204e1, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	require_object_holographed(0x0000000e, 0x00000000, 0x00000000)
	tag(0x05, 18)
	tag(0x06, 18)
	tag(0x07, 18)
	tag(0x08, 18)
	tag(0x09, 18)
	tag(0x0a, 18)
	tag(0x0b, 18)
	tag(0x0c, 18)
	tag(0x11, 18)
	tag(0x12, 18)
	tag(0x13, 18)
	tag(0x14, 18)
	tag(0x15, 18)
	tag(0x16, 18)
	tag(0x17, 18)
	tag(0x18, 18)
	tag(0x19, 18)
	tag(0x1a, 18)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_TARGET, 0x00d6, 0x000005e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	chr(0x00002000, 0x00, PAD_CARRINGTON_OFFICE, BODY_CARRINGTON, HEAD_CARRINGTON, AILIST_INIT_CARRINGTON, -1, -1, 1000, 4, 0x00000000, 0x00000000, TEAM_20, SQUADRON_05, -1, 0, 0x02000000)
	chr(0x00002000, 0x01, 0x00f8, BODY_CIFEMTECH, HEAD_SECRETARY, 0x0420, -1, -1, 1000, 4, 0x00000000, 0x00000000, TEAM_20, SQUADRON_05, -1, 0, 0x02000000)
	chr(0x00002000, 0x02, 0x00fa, BODY_CILABTECH, HEAD_CHRIST, 0x0424, -1, -1, 1000, 4, 0x00000000, 0x00000000, TEAM_20, SQUADRON_05, -1, 0, 0x02000000)
	chr(0x00002000, 0x03, 0x00f7, BODY_CILABTECH, HEAD_MARK2, 0x0421, -1, -1, 1000, 6, 0x00000000, 0x00000000, TEAM_20, SQUADRON_05, -1, 0, 0x02000000)
	chr(0x00002000, 0x04, 0x00f9, BODY_CIFEMTECH, HEAD_SECRETARY, 0x0422, -1, -1, 1000, 6, 0x00000000, 0x00000000, TEAM_20, SQUADRON_05, -1, 0, 0x02000000)
	chr(0x00002000, 0x05, 0x00fb, BODY_CILABTECH, HEAD_BRIAN, 0x0423, -1, -1, 1000, 6, 0x00000000, 0x00000000, TEAM_20, SQUADRON_05, -1, 0, 0x02000000)
	chr(0x00006000, 0x06, 0x00fd, BODY_CILABTECH, HEAD_RUSS, 0x0425, -1, -1, 0, 0, 0xc8000000, 0x00000100, TEAM_ENEMY, SQUADRON_0D, 0x01, 0, 0x00020000)
	chr(0x00006000, 0x07, 0x00fc, BODY_CILABTECH, HEAD_BEAU1, 0x0426, -1, -1, 0, 0, 0xc8000000, 0x00000100, TEAM_ENEMY, SQUADRON_0D, 0x00, 0, 0x00020000)
	chr(0x00006000, 0x08, 0x00fe, BODY_CIFEMTECH, HEAD_SECRETARY, 0x0427, -1, -1, 0, 0, 0xc8000000, 0x00000100, TEAM_ENEMY, SQUADRON_0D, 0x02, 0, 0x00020000)
	tag(0x1e, 8)
	tag(0x1f, 8)
	tag(0x20, 8)
	tag(0x21, 8)
	tag(0x22, 8)
	tag(0x23, 8)
	tag(0x24, 8)
	tag(0x25, 8)
	weapon(0x0100, MODEL_CHRWPPK, 0x0115, 0x00100008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_LAPTOPGUN, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRTT33, 0x0116, 0x00100008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_LAPTOPGUN, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRSKORPION, 0x0117, 0x00100008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_LAPTOPGUN, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRKALASH, 0x0118, 0x00100008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_LAPTOPGUN, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRUZI, 0x0119, 0x00100008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_LAPTOPGUN, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRMP5K, 0x011a, 0x00100008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_LAPTOPGUN, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRM16, 0x011b, 0x00100008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_LAPTOPGUN, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRFNP90, 0x011c, 0x00100008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_LAPTOPGUN, 0x00ffffff, 0x00000000)
	tag(0x7a, 1)
	glass(0x0100, MODEL_DD_WINDOW, 0x01c8, 0x04020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x79, 1)
	glass(0x0100, MODEL_DD_WINDOW, 0x01c9, 0x04020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x78, 1)
	glass(0x0100, MODEL_DD_WINDOW, 0x01ca, 0x04020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x7e, 1)
	glass(0x0100, MODEL_DD_WINDOW, 0x01cb, 0x04020962, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x7b, 1)
	glass(0x0100, MODEL_DD_WINDOW, 0x01cc, 0x04020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x7c, 1)
	glass(0x0100, MODEL_DD_WINDOW, 0x01cd, 0x04020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x7d, 1)
	glass(0x0100, MODEL_DD_WINDOW, 0x01ce, 0x04020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x77, 1)
	glass(0x0100, MODEL_DD_WINDOW, 0x01cf, 0x04020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x01d0, 0x04020b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	stdobject(0x0100, MODEL_DD_DESK, 0x0229, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2f, 1)
	weapon(0x0100, MODEL_CHRDATATHIEF, 0xffff, 0x00100008, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DATAUPLINK, 0x00ffffff, 0x00000000)
	stdobject(0x0100, MODEL_DD_DESK, 0x0228, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0226, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x30, 1)
	singlemonitor(0x0180, MODEL_GOODPC, 0x0227, 0x000004e1, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x2e, 1)
	weapon(0x0180, MODEL_CHRECMMINE, 0xffff, 0x00100001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_ECMMINE, 0x00ffffff, 0x00000000)
	tag(0x32, 1)
	multimonitor(0x0140, MODEL_CIHUB, 0x0239, 0x00000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000)
	tag(0x26, 1)
	weapon(0x0100, MODEL_CHREYESPY, 0xffff, 0x00100001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CAMSPY, 0x00ffffff, 0x00000000)
	tag(0x27, 1)
	weapon(0x0180, MODEL_CHRNIGHTSIGHT, 0xffff, 0x00100001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_NIGHTVISION, 0x00ffffff, 0x00000000)
	tag(0x34, 1)
	stdobject(0x0100, MODEL_LIGHTSWITCH, 0x023a, 0x10000002, 0x00080000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x28, 1)
	weapon(0x0200, MODEL_CHRDOORDECODER, 0xffff, 0x00100001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DOORDECODER, 0x00ffffff, 0x00000000)
	tag(0x35, 1)
	multimonitor(0x0100, MODEL_CIHUB, 0x023b, 0x00000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000)
	tag(0x88, 1)
	stdobject(0x0200, MODEL_CHRDOORDECODER, 0x0130, 0x00020408, 0x00080001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2c, 1)
	weapon(0x0180, MODEL_RUSSDAR, 0xffff, 0x00100001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_RTRACKER, 0x00ffffff, 0x00000000)
	tag(0x36, 1)
	weapon(0x0180, MODEL_MISC_IRSPECS, 0xffff, 0x00100001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_IRSCANNER, 0x00ffffff, 0x00000000)
	tag(0x29, 1)
	weapon(0x0180, MODEL_XRAYSPECS, 0xffff, 0x00100001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_XRAYSCANNER, 0x00ffffff, 0x00000000)
	tag(0x38, 1)
	multimonitor(0x0099, MODEL_CIHUB, 0x023c, 0x00000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000)
	tag(0x39, 1)
	multimonitor(0x0099, MODEL_CIHUB, 0x023d, 0x00000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000)
	tag(0x2a, 1)
	weapon(0x0180, MODEL_CHRBRIEFCASE, 0xffff, 0x00100001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DISGUISE41, 0x00ffffff, 0x00000000)
	tag(0x2b, 1)
	weapon(0x0180, MODEL_MISC_IRSPECS, 0xffff, 0x00100001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_IRSCANNER, 0x00ffffff, 0x00000000)
	tag(0x2d, 1)
	weapon(0x0180, MODEL_CHRCLOAKER, 0xffff, 0x00100001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CLOAKINGDEVICE, 0x00ffffff, 0x00000000)
	tag(0x3c, 1)
	weapon(0x0180, MODEL_CHRCLOAKER, 0x0003, 0x00104001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CLOAKINGDEVICE, 0x00ffffff, 0x00000000)
	tag(0x3d, 1)
	door(0x0100, MODEL_DD_GRATE, 0x0185, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00100005, 0x00000040, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x3e, 1)
	door(0x0100, MODEL_DEVICESECRETDOOR, 0x0186, 0x36000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00100005, 0x00000040, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x3f, 1)
	door(0x0100, MODEL_DD_GRATE, 0x0187, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00100005, 0x00000040, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x40, 1)
	door(0x0100, MODEL_CARRINGTONSECRETDOOR, 0x0188, 0x16000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00100005, 0x00000040, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x3a, 1)
	door(0x0100, MODEL_LASDOOR, 0x0189, 0x06000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0400000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x3b, 1)
	door(0x0100, MODEL_LASDOOR, 0x018a, 0x06000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0400000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	camera(0x00c0, MODEL_CCTV_PD, 0x027b, 0x30020102, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x011f0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x41, 1)
	door(0x0100, MODEL_DD_GRATE, 0x018b, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00007fff, 0x00014000, 0x00000666, 0x000c0004, 0x00000040, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000a00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x37, 1)
	door(0x0100, MODEL_SECRETINDOOR, 0x0192, 0x10000000, 0x00000000, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000040, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x93, 1)
	hover_prop(0x00eb, MODEL_HOVERCRATE1, 0x0141, 0x35100101, 0x80102300, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x02010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	hoverbike(0x0100, MODEL_HOVBIKE, 0x01f9, 0x05120101, 0x00304300, 0x02000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x01010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x42, 1)
	stdobject(0x0100, MODEL_DROPSHIP, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	door(0x0100, MODEL_CH_SHUTTER1, 0x0166, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000fd70, 0x0000e666, 0x00007fff, 0x00014000, 0x00000222, 0x00000004, 0x00000020, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CH_SHUTTER1, 0x0167, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000fd70, 0x0000e666, 0x00007fff, 0x00014000, 0x00000222, 0x00000004, 0x00000020, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0168, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0169, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x016a, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x016b, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x016c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x016d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x016e, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x016f, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0170, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0171, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0172, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0173, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0174, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0175, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0176, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0177, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0178, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0179, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x017b, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x017c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x017d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x017e, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x017f, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0180, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CH_SHUTTER1, 0x0181, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000222, 0x00000004, 0x00000040, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CH_SHUTTER1, 0x0182, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000222, 0x00000004, 0x00000040, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0183, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x0184, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000222, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01d6, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01e1, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01e2, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01e5, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01e6, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01e8, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01e9, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01ea, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01eb, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01ec, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01ed, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01ee, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01ef, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01f0, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01f1, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01f3, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01f4, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01f5, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01f6, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01f7, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01fa, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01fb, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01fc, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01fd, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01fe, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0200, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0201, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0202, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0204, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x46, 1)
	singlemonitor(0x0100, MODEL_GOODPC, 0x022a, 0x000004e1, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x45, 1)
	multimonitor(0x0100, MODEL_CIHUB, 0x023e, 0x00000002, 0x00020000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000)
	tag(0x47, 1)
	singlemonitor(0x0100, MODEL_GOODPC, 0x022b, 0x000004e8, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x48, 1)
	multimonitor(0x00cc, MODEL_CIHUB, 0x0240, 0x00000002, 0x00020000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000)
	tag(0x49, 1)
	multimonitor(0x00cc, MODEL_CIHUB, 0x0241, 0x00000002, 0x00020000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000)
	tag(0x4a, 1)
	multimonitor(0x00cc, MODEL_CIHUB, 0x0242, 0x00000002, 0x00020000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000)
	tag(0x4b, 1)
	multimonitor(0x00cc, MODEL_CIHUB, 0x0243, 0x00000002, 0x00020000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000)
	tag(0x4c, 1)
	multimonitor(0x0100, MODEL_CIHUB, 0x0247, 0x00000002, 0x00020000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000)
	tag(0x4d, 1)
	multimonitor(0x0100, MODEL_CIHUB, 0x0246, 0x00000002, 0x00020000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000)
	tag(0x4e, 1)
	multimonitor(0x0100, MODEL_CIHUB, 0x0245, 0x00000002, 0x00020000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000)
	tag(0x4f, 1)
	multimonitor(0x0100, MODEL_CIHUB, 0x0244, 0x00000002, 0x00020000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000)
	tag(0x54, 1)
	multimonitor(0x0100, MODEL_CIHUB, 0x024c, 0x00000002, 0x00020000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000)
	tag(0x55, 1)
	multimonitor(0x0100, MODEL_CIHUB, 0x024d, 0x00000002, 0x00020000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000)
	tag(0x56, 1)
	multimonitor(0x0100, MODEL_CIHUB, 0x024e, 0x00000002, 0x00020000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000)
	tag(0x57, 1)
	multimonitor(0x0100, MODEL_CIHUB, 0x024f, 0x00000002, 0x00020000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000)
	tag(0x58, 15)
	tag(0x59, 15)
	tag(0x5a, 15)
	tag(0x5b, 15)
	tag(0x5c, 15)
	tag(0x5d, 15)
	tag(0x5e, 15)
	tag(0x5f, 15)
	tag(0x60, 15)
	tag(0x61, 15)
	tag(0x62, 15)
	tag(0x63, 15)
	tag(0x64, 15)
	tag(0x73, 15)
	tag(0x74, 15)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0205, 0x000205e1, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0206, 0x000205e1, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0207, 0x000205e1, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0208, 0x000205e1, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0209, 0x000205e1, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x020a, 0x000205e1, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x020b, 0x000205e1, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x020c, 0x000205e1, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x020d, 0x000205e1, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x020e, 0x000205e1, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01d2, 0x000205e1, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x01d3, 0x000205e1, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x020f, 0x000205e1, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0210, 0x000205e1, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0211, 0x000205e1, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x67, 12)
	tag(0x68, 12)
	tag(0x69, 12)
	tag(0x6a, 12)
	tag(0x6b, 12)
	tag(0x6c, 12)
	tag(0x6d, 12)
	tag(0x6e, 12)
	tag(0x6f, 12)
	tag(0x70, 12)
	tag(0x71, 12)
	tag(0x72, 12)
	door(0x0100, MODEL_LASDOOR, 0x027c, 0x06000500, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0400000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x027d, 0x06000500, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0400000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x027e, 0x06000500, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0400000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x027f, 0x06000500, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0400000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0280, 0x06000500, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0400000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0281, 0x06000500, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0400000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0282, 0x06000500, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0400000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0283, 0x06000500, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0400000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0284, 0x06000500, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0400000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0285, 0x06000500, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0400000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0286, 0x06000500, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0400000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0287, 0x06000500, 0x00020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0400000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x65, 1)
	multimonitor(0x00cc, MODEL_CIHUB, 0x0250, 0x00000002, 0x00020000, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000)
	tag(0x66, 1)
	multimonitor(0x00cc, MODEL_CIHUB, 0x0251, 0x00000002, 0x00020000, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000)
	tag(0x8b, 1)
	autogun(0x00a6, MODEL_CI_ROOFGUN, 0x0235, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00750000, 0x00000000, 0x00005555, 0xffffaaab, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000aaa, 0x00320000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x8c, 1)
	autogun(0x00a6, MODEL_CI_ROOFGUN, 0x0234, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x007f0000, 0x00000000, 0x00005555, 0xffffaaab, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000aaa, 0x00320000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x8d, 1)
	autogun(0x00a6, MODEL_CI_ROOFGUN, 0x0233, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00970000, 0x00000000, 0x00005555, 0xffffaaab, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000aaa, 0x00320000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x8e, 1)
	multimonitor(0x0099, MODEL_CIHUB, 0x0236, 0x00000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(0x8f, 1)
	multimonitor(0x0099, MODEL_CIHUB, 0x0237, 0x00000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(0x90, 1)
	multimonitor(0x0099, MODEL_CIHUB, 0x0238, 0x00000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	endprops
};

/**
 * Wait until seeing player (without cloak) then assign colleague.
 */
u8 func041d_init_collegue_when_sighted[] = {
	restart_timer

	beginloop(0x04)
		if_chr_sees_player(/*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	if_stage_flag_eq(STAGEFLAG_TRIGGER_CLOAK, TRUE, /*goto*/ 0x2f)
	set_ailist(CHR_SELF, AILIST_COLLEAGUE)

	label(0x2f)
	goto_first(0x04)

	endlist
};

u8 func041e_colleague[] = {
	set_returnlist(CHR_SELF, AILIST_COLLEAGUE)
	if_alertness(1, OPERATOR_LESS_THAN, /*goto*/ 0x04)
	if_alertness(2, OPERATOR_LESS_THAN, /*goto*/ 0x7c)
	if_alertness(3, OPERATOR_LESS_THAN, /*goto*/ 0x7d)

	beginloop(0x04)
		// Wait until player in sight and not doing idle animations already
		if_target_in_sight(/*goto*/ 0x2f)
		if_chr_idle(/*goto*/ 0x06)
		if_self_flag_bankx_eq(CHRFLAG1_DOINGIDLEANIMATION, FALSE, BANK_1, /*goto*/ 0x7f)
		chr_do_animation(0x0227, 0, -1, 0x14, 0x00, CHR_SELF, 2)
		reloop(0x04)

		// Player not in sight - 2 in 255 chance of doing a bored animation
		label(0x7f)
		call_rng
		if_rand_gt(1, /*goto*/ 0x06)
		set_ailist(CHR_SELF, GAILIST_DO_BORED_ANIMATION)
		label(0x06)
		reloop(0x04)

		// Player is in sight - prepare to talk
		label(0x2f)
		restart_timer
		label(0x08)
		if_self_flag_bankx_eq(CHRFLAG1_DOINGIDLEANIMATION, TRUE, BANK_1, /*goto*/ 0x06)
		try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

		beginloop(0x09)
			if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
			if_timer_gt(60, /*goto*/ 0x06)
		endloop(0x09)

		label(0x06)
		if_self_flag_bankx_eq(CHRFLAG1_DOINGIDLEANIMATION, TRUE, BANK_1, /*goto*/ 0x7f)
		do_preset_animation(3)
		goto_next(0x2f)

		label(0x7f)
		chr_do_animation(ANIM_SITTING_0265, 0, -1, 0x14, 0x00, CHR_SELF, 2)
		label(0x2f)
		play_cistaff_quip(BANK_0, CHANNEL_6)
		restart_timer

		beginloop(0x57)
			if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
		endloop(0x57)

		label(0x06)
		if_morale_lt(6, /*goto*/ 0x06)
		goto_next(0x7e)

		label(0x06)
		restart_timer
		stop_chr
		try_face_entity(0x0200, 0x0000, /*goto*/ 0x59)

		beginloop(0x59)
			if_target_in_sight(/*goto*/ 0x06)
		endloop(0x59)

		label(0x06)
		if_timer_gt(120, /*goto*/ 0x06)
		goto_first(0x59)

		label(0x06)
		if_player_looking_at_something_maybe(0x14, 0x01, 0x00, /*goto*/ 0x06)
		goto_first(0x59)

		label(0x06)
		do_preset_animation(-1)
		label(0x06)
		play_cistaff_quip(BANK_1, CHANNEL_6)
		restart_timer

		beginloop(0x5b)
			if_sound_finished(CHANNEL_6, /*goto*/ 0x7e)
		endloop(0x5b)

		label(0x7e)
		if_self_flag_bankx_eq(CHRFLAG1_DOINGIDLEANIMATION, TRUE, BANK_1, /*goto*/ 0x7f)
		stop_chr
		label(0x7f)
		set_alertness(1)
		label(0x7c)
		restart_timer

		beginloop(0x0a)
			if_timer_lt(600, /*goto*/ 0x2f)
			if_target_in_sight(/*goto*/ 0x06)
			goto_next(0x2f)

			label(0x06)
			if_player_looking_at_something_maybe(0x14, 0x01, 0x00, /*goto*/ 0x30)
			label(0x2f)
			if_chr_idle(/*goto*/ 0x06)
			if_self_flag_bankx_eq(CHRFLAG1_DOINGIDLEANIMATION, FALSE, BANK_1, /*goto*/ 0x7f)
			set_ailist(CHR_SELF, GAILIST_DO_SITTING_ANIMATION)
			reloop(0x04)

			label(0x7f)
			call_rng
			if_rand_gt(1, /*goto*/ 0x06)
			set_ailist(CHR_SELF, GAILIST_DO_BORED_ANIMATION)
			label(0x06)
		endloop(0x0a)

		label(0x30)
		if_self_flag_bankx_eq(CHRFLAG1_DOINGIDLEANIMATION, TRUE, BANK_1, /*goto*/ 0x7f)
		do_preset_animation(-1)
		goto_next(0x06)

		label(0x7f)
		chr_do_animation(ANIM_SITTING_0265, 0, -1, 0x14, 0x00, CHR_SELF, 2)
		label(0x06)
		play_cistaff_quip(BANK_2, CHANNEL_6)
		restart_timer

		beginloop(0x5c)
			if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
		endloop(0x5c)

		label(0x06)
		if_self_flag_bankx_eq(CHRFLAG1_DOINGIDLEANIMATION, TRUE, BANK_1, /*goto*/ 0x7f)
		stop_chr
		label(0x7f)
		set_alertness(2)
		label(0x7d)
		yield
		if_chr_idle(/*goto*/ 0x06)
		if_self_flag_bankx_eq(CHRFLAG1_DOINGIDLEANIMATION, FALSE, BANK_1, /*goto*/ 0x7f)
		set_ailist(CHR_SELF, GAILIST_DO_SITTING_ANIMATION)
	endloop(0x04)

	label(0x7f)
	call_rng
	if_rand_gt(1, /*goto*/ 0x06)
	set_ailist(CHR_SELF, GAILIST_DO_BORED_ANIMATION)

	label(0x06)
	goto_first(0x7d)

	endlist
};

u8 func041f_colleague1[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_morale(0)
	set_ailist(CHR_SELF, AILIST_COLLEAGUE)
	endlist
};

u8 func0420_colleague2[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_morale(1)
	set_ailist(CHR_SELF, AILIST_COLLEAGUE)
	endlist
};

u8 func0421_colleague3[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_morale(2)
	set_ailist(CHR_SELF, AILIST_COLLEAGUE)
	endlist
};

u8 func0422_colleague4[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_morale(3)
	set_ailist(CHR_SELF, AILIST_COLLEAGUE)
	endlist
};

u8 func0423_colleague5[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_morale(4)
	set_ailist(CHR_SELF, AILIST_COLLEAGUE)
	endlist
};

u8 func0424_colleague6[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_morale(5)
	set_ailist(CHR_SELF, AILIST_COLLEAGUE)
	endlist
};

u8 func0425_colleague7[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_morale(6)
	set_ailist(CHR_SELF, AILIST_COLLEAGUE)
	endlist
};

u8 func0426_colleague8[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_morale(7)
	set_ailist(CHR_SELF, AILIST_COLLEAGUE)
	endlist
};

u8 func0427_colleague9[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_morale(8)
	set_ailist(CHR_SELF, AILIST_COLLEAGUE)
	endlist
};

u8 func0428_colleague10[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_morale(9)
	set_ailist(CHR_SELF, AILIST_COLLEAGUE)
	endlist
};

u8 func1001_set_jo_team[] = {
	yield
	set_chr_team(CHR_BOND, TEAM_32)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1002_devicetraining_camspy[] = {
	label(0x80)
	beginloop(0x0f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_CAMSPY, TRUE, /*goto*/ 0x81)
	endloop(0x0f)

	label(0x81)
	hide_object(0x0e)
	lock_door(0x31, 0x40)
	lock_door(0x8a, 0x40)
	lock_door(0x89, 0x40)
	show_object(OBJ_CAMSPY)
	move_object_to_pad(OBJ_CAMSPY, 0x011d)
	unset_object_flag(OBJ_CAMSPY, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(OBJ_CAMSPY, OBJFLAG2_INVISIBLE)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	close_door(0x31)
	close_door(0x8a)
	close_door(0x89)
	yield
	show_object(0x0e)

	label(0x8c)
		remove_hudmsgs
		show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(20)) // "Collect CamSpy from table to begin."
		restart_timer

		beginloop(0x86)
			if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
			if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
			if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
			if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
			goto_next(0x59)
			label(0x57)
			set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
			label(0x59)
			if_chr_has_object(CHR_BOND, OBJ_CAMSPY, /*goto*/ 0x2f)
			if_timer_gt(1200, /*goto*/ 0x06)
		endloop(0x86)

		label(0x06)
	goto_first(0x8c)

	label(0x2f)
	label(0x8d)
		remove_hudmsgs
		if_chr_weapon_equipped(CHR_BOND, WEAPON_CAMSPY, /*goto*/ 0x2f)
		show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(57)) // "Select the CamSpy. - Hold A Button. - Use Control Stick to change selection. - Highlight CamSpy and release A Button."
		restart_timer

		beginloop(0x8e)
			if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
			if_chr_has_weapon_equipped(CHR_BOND, WEAPON_CAMSPY, /*goto*/ 0x2f)
			if_timer_gt(1200, /*goto*/ 0x06)
		endloop(0x8e)

		label(0x06)
	goto_first(0x8d)

	label(0x2f)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(21)) // "Locate Info Room PC and holograph it."

	beginloop(0x82)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_door_state(0x31, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_door_state(0x8a, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_door_state(0x89, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_training_pc_holographed(/*goto*/ 0x09)
	endloop(0x82)

	label(0x09)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(22)) // "Info Room PC successfully holographed."
	restart_timer

	beginloop(0x0c)
		if_timer_gt(240, /*goto*/ 0x83)
	endloop(0x0c)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_FAILURE)
	goto_next(0x84)

	label(0x83)
	dprint 'd','o','n','e',0,
	yield
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_SUCCESS)
	set_savefile_flag(SAVEFILEFLAG_CI_CAMSPY_DONE)
	label(0x84)
	if_chr_in_room(CHR_BOND, 0x00, 0x001e, /*goto*/ 0x90)
	label(0x90)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	unlock_door(0x31, 0x40)
	unlock_door(0x8a, 0x40)
	unlock_door(0x89, 0x40)
	remove_hudmsgs
	hide_object(OBJ_CAMSPY)
	goto_first(0x0f)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1003_devicetraining_nightvision[] = {
	label(0x80)

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_NIGHTVISION, TRUE, /*goto*/ 0x81)
	endloop(0x08)

	label(0x81)
	set_lights_state(0x0030, 0x01, 0x00, 0x00, 0x00)
	set_lights_state(0x002e, 0x01, 0x00, 0x00, 0x00)
	set_lights_state(0x002f, 0x01, 0x00, 0x00, 0x00)
	set_lights_state(0x0020, 0x01, 0x00, 0x00, 0x00)
	set_lights_state(0x0024, 0x01, 0x00, 0x00, 0x00)
	set_lights_state(0x0025, 0x01, 0x00, 0x00, 0x00)
	set_lights_state(0x0026, 0x01, 0x00, 0x00, 0x00)
	set_lights_state(0x0022, 0x01, 0x00, 0x00, 0x00)
	set_stage_flag(STAGEFLAG_IN_TRAINING)
	lock_door(0x31, 0x40)
	lock_door(0x8a, 0x40)
	lock_door(0x89, 0x40)
	show_object(0x27)
	move_object_to_pad(0x27, 0x011d)
	unset_object_flag(0x27, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(0x27, OBJFLAG2_INVISIBLE)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	close_door(0x31)
	close_door(0x8a)
	close_door(0x89)

	label(0x8c)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(8)) // "Collect Night Vision from table to begin."
	restart_timer

	beginloop(0x86)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_chr_has_object(CHR_BOND, 0x27, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x86)

	label(0x06)
	goto_first(0x8c)

	label(0x2f)
	label(0x8d)
	remove_hudmsgs
	if_chr_weapon_equipped(CHR_BOND, WEAPON_NIGHTVISION, /*goto*/ 0x2f)
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(58)) // "Select the Night Vision. - Hold A Button. - Use Control Stick to change selection. - Highlight Night Vision and release A Button."
	restart_timer

	beginloop(0x8e)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_has_weapon_equipped(CHR_BOND, WEAPON_NIGHTVISION, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x8e)

	label(0x06)
	goto_first(0x8d)

	label(0x2f)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(9)) // "Activate the Night Vision. Locate the light switch. Turn the lights back on."

	beginloop(0x82)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_chr_activated_object(CHR_ANY, OBJ_LIGHTSWITCH, /*goto*/ 0x2f)
	endloop(0x82)

	label(0x2f)
	play_sound(0x00ba, -1)
	set_lights_state(0x0030, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x002e, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x002f, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0020, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0024, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0025, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0026, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0022, 0x01, 0xff, 0x00, 0x00)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(23)) // "Lights have been reactivated."
	restart_timer

	beginloop(0x0d)
		if_timer_gt(240, /*goto*/ 0x83)
	endloop(0x0d)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_FAILURE)
	goto_next(0x84)

	label(0x83)
	set_savefile_flag(SAVEFILEFLAG_CI_NIGHTVISION_DONE)
	dprint 'd','o','n','e',0,
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_SUCCESS)
	set_lights_state(0x0030, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x002e, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x002f, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0020, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0024, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0025, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0026, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0022, 0x01, 0xff, 0x00, 0x00)
	yield
	label(0x84)
	if_chr_in_room(CHR_BOND, 0x00, 0x001e, /*goto*/ 0x90)
	label(0x90)
	unlock_door(0x31, 0x40)
	unlock_door(0x8a, 0x40)
	unlock_door(0x89, 0x40)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	remove_hudmsgs
	hide_object(0x27)

	beginloop(0x59)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_NIGHTVISION, FALSE, /*goto*/ 0x2f)
	endloop(0x59)

	label(0x2f)
	goto_first(0x08)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1004_devicetraining_doordecoder[] = {
	label(0x80)

	beginloop(0x0f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_DOORDECODER, TRUE, /*goto*/ 0x81)
	endloop(0x0f)

	label(0x81)
	set_object_flag2(0x88, OBJFLAG2_INVISIBLE)
	set_stage_flag(STAGEFLAG_IN_TRAINING)
	lock_door(0x31, 0x40)
	lock_door(0x8a, 0x40)
	lock_door(0x89, 0x40)
	show_object(0x28)
	move_object_to_pad(0x28, 0x011d)
	unset_object_flag(0x28, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(0x28, OBJFLAG2_INVISIBLE)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	close_door(0x31)
	close_door(0x8a)
	close_door(0x89)
	label(0x8c)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(24)) // "Collect Door Decoder from table to begin."
	restart_timer

	beginloop(0x86)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_chr_has_object(CHR_BOND, 0x28, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x86)

	label(0x06)
	goto_first(0x8c)

	label(0x2f)
	label(0x8d)
	remove_hudmsgs
	if_chr_weapon_equipped(CHR_BOND, WEAPON_DOORDECODER, /*goto*/ 0x2f)
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(59)) // "Select the Door Decoder. - Hold A Button. - Use Control Stick to change selection. - Highlight Door Decoder and release A Button."
	restart_timer

	beginloop(0x8e)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_weapon_equipped(CHR_BOND, WEAPON_DOORDECODER, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x8e)

	label(0x06)
	goto_first(0x8d)

	label(0x2f)
	if_chr_activated_object(CHR_BOND, 0x35, /*goto*/ 0x2f)
	label(0x2f)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(25)) // "Use Decoder on door pad to unlock it."

	beginloop(0x82)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_door_state(0x31, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_door_state(0x8a, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_door_state(0x89, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_chr_activated_object(CHR_BOND, 0x35, /*goto*/ 0x09)
	endloop(0x82)

	label(0x09)
	if_chr_weapon_equipped(CHR_BOND, WEAPON_DOORDECODER, /*goto*/ 0x06)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(26)) // "You need to be holding the Door Decoder."
	restart_timer

	beginloop(0x0e)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(60, /*goto*/ 0x2f)
	endloop(0x0e)

	label(0x2f)
	goto_first(0x82)

	label(0x06)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(27)) // "Decoder attached. Initiating cracking routines..."
	unset_object_flag2(0x88, OBJFLAG2_INVISIBLE)
	assign_sound(0x8144, CHANNEL_1)
	play_sound_from_object(CHANNEL_1, 0x35, 0x012c, 0x0190)
	restart_timer

	beginloop(0x0c)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(240, /*goto*/ 0x2f)
	endloop(0x0c)

	label(0x2f)
	mute_channel(CHANNEL_1)
	assign_sound(0x8145, CHANNEL_1)
	control_sound_from_object(CHANNEL_1, 0x35, TRUE)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(28)) // "Decoding complete. Door has been unlocked."
	unlock_door(0x41, 0x40)
	restart_timer

	beginloop(0x0d)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(240, /*goto*/ 0x83)
	endloop(0x0d)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_FAILURE)
	goto_next(0x84)

	label(0x83)
	set_savefile_flag(SAVEFILEFLAG_CI_DOORDECODER_DONE)
	dprint 'd','o','n','e',0,
	yield
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_SUCCESS)
	unset_object_flag2(0x88, OBJFLAG2_INVISIBLE)
	label(0x84)
	if_chr_in_room(CHR_BOND, 0x00, 0x001e, /*goto*/ 0x90)
	label(0x90)
	mute_channel(CHANNEL_1)
	unlock_door(0x31, 0x40)
	unlock_door(0x8a, 0x40)
	unlock_door(0x89, 0x40)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	remove_hudmsgs
	hide_object(0x28)
	goto_first(0x0f)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1005_devicetraining_xray[] = {
	label(0x80)
	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_XRAY, TRUE, /*goto*/ 0x81)
	endloop(0x08)

	label(0x81)
	lock_door(0x31, 0x40)
	lock_door(0x8a, 0x40)
	lock_door(0x89, 0x40)
	dprint 't','r','a','i','n','i','n','g',0,
	show_object(0x29)
	move_object_to_pad(0x29, 0x011d)
	unset_object_flag(0x29, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(0x29, OBJFLAG2_INVISIBLE)
	unset_object_flag2(0x38, OBJFLAG2_00000001)
	unset_object_flag2(0x39, OBJFLAG2_00000001)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	close_door(0x31)
	close_door(0x8a)
	close_door(0x89)
	if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
	if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
	if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
	goto_next(0x59)

	label(0x57)
	set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	label(0x59)
	label(0x8c)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(35)) // "Collect X-Ray Scanner from table to begin."
	restart_timer

	beginloop(0x86)
		if_chr_has_weapon_equipped(CHR_BOND, WEAPON_XRAYSCANNER, /*goto*/ 0x2f)
		set_object_flag(0x38, OBJFLAG_CANNOT_ACTIVATE)
		set_object_flag(0x39, OBJFLAG_CANNOT_ACTIVATE)
		goto_next(0x30)

		label(0x2f)
		unset_object_flag(0x38, OBJFLAG_CANNOT_ACTIVATE)
		unset_object_flag(0x39, OBJFLAG_CANNOT_ACTIVATE)
		label(0x30)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_chr_has_object(CHR_BOND, 0x29, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x86)

	label(0x06)
	goto_first(0x8c)

	label(0x8d)
	remove_hudmsgs
	if_chr_weapon_equipped(CHR_BOND, WEAPON_XRAYSCANNER, /*goto*/ 0x2f)
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(60)) // "Select the X-Ray Scanner. - Hold A Button. - Use Control Stick to change selection. - Highlight X-Ray Scanner and release A Button."
	restart_timer

	beginloop(0x8e)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_has_weapon_equipped(CHR_BOND, WEAPON_XRAYSCANNER, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x8e)

	label(0x06)
	goto_first(0x8d)

	label(0x2f)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(36)) // "Find hidden switches to shut down laser grid."

	beginloop(0x82)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_chr_has_weapon_equipped(CHR_BOND, WEAPON_XRAYSCANNER, /*goto*/ 0x2f)
		set_object_flag(0x38, OBJFLAG_CANNOT_ACTIVATE)
		set_object_flag(0x39, OBJFLAG_CANNOT_ACTIVATE)
		goto_next(0x30)

		label(0x2f)
		unset_object_flag(0x38, OBJFLAG_CANNOT_ACTIVATE)
		unset_object_flag(0x39, OBJFLAG_CANNOT_ACTIVATE)
		label(0x30)
		if_chr_activated_object(CHR_BOND, 0x38, /*goto*/ 0x5b)
		if_chr_activated_object(CHR_BOND, 0x39, /*goto*/ 0x5c)
	endloop(0x82)

	label(0x5b)
	if_object_flag2(0x38, OBJFLAG2_00000001, /*goto*/ 0x87)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(41)) // "Laser Grid 1 has been deactivated."
	set_object_image(0x38, 0x00, 0x12)
	set_object_flag2(0x38, OBJFLAG2_00000001)
	open_door(0x3a)
	label(0x87)
	restart_timer

	beginloop(0x89)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x85)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x85)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x85)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x89)

	label(0x5c)
	if_object_flag2(0x39, OBJFLAG2_00000001, /*goto*/ 0x88)
	set_object_image(0x39, 0x00, 0x12)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(42)) // "Laser Grid 2 has been deactivated."
	set_object_flag2(0x39, OBJFLAG2_00000001)
	open_door(0x3b)
	label(0x88)
	restart_timer

	beginloop(0x8a)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x8a)

	label(0x8b)
	hide_object(0x3a)
	goto_next(0x06)

	label(0x07)
	hide_object(0x3b)
	goto_next(0x06)

	label(0x06)
	if_object_flag2(0x38, OBJFLAG2_00000001, /*goto*/ 0x2f)
	goto_first(0x82)

	label(0x2f)
	if_object_flag2(0x39, OBJFLAG2_00000001, /*goto*/ 0x2f)
	goto_first(0x82)

	label(0x09)
	restart_timer

	beginloop(0x5b)
		if_timer_gt(120, /*goto*/ 0x2f)
	endloop(0x5b)

	label(0x2f)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(37)) // "All laser grids have been deactivated."
	restart_timer

	beginloop(0x0e)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(240, /*goto*/ 0x83)
	endloop(0x0e)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_FAILURE)
	goto_next(0x84)

	label(0x83)
	set_savefile_flag(SAVEFILEFLAG_CI_XRAY_DONE)
	dprint 'd','o','n','e',0,
	yield
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_SUCCESS)
	label(0x84)
	if_chr_in_room(CHR_BOND, 0x00, 0x001e, /*goto*/ 0x90)
	label(0x90)
	unlock_door(0x31, 0x40)
	unlock_door(0x8a, 0x40)
	unlock_door(0x89, 0x40)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	remove_hudmsgs
	hide_object(0x29)
	goto_first(0x08)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1006_devicetraining_disguise[] = {
	label(0x80)
	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_DISGUISE, TRUE, /*goto*/ 0x81)
	endloop(0x08)

	label(0x81)
	unset_chr_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISED)
	unset_stage_flag(STAGEFLAG_DISGUISE_FAILED)
	unset_stage_flag(STAGEFLAG_DISGUISE_COMPLETE)
	lock_door(0x31, 0x40)
	lock_door(0x8a, 0x40)
	lock_door(0x89, 0x40)
	dprint 't','r','a','i','n','i','n','g',0,
	show_object(0x2a)
	move_object_to_pad(0x2a, 0x011d)
	unset_object_flag(0x2a, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(0x2a, OBJFLAG2_INVISIBLE)
	set_ailist(0x03, AILIST_GRIMSHAW_DISGUISE)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	close_door(0x31)
	close_door(0x8a)
	close_door(0x89)
	if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
	if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
	if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
	goto_next(0x59)

	label(0x57)
	set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	label(0x59)
	label(0x8c)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(38)) // "Collect Disguise from table to begin."
	restart_timer

	beginloop(0x86)
		if_stage_flag_eq(STAGEFLAG_DISGUISE_FAILED, TRUE, /*goto*/ 0x0a)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)
		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_chr_has_object(CHR_BOND, 0x2a, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x86)

	label(0x06)
	goto_first(0x8c)

	label(0x2f)
	label(0x8d)
	remove_hudmsgs
	if_chr_has_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISED, /*goto*/ 0x2f)
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(61)) // "Select the Disguise. - Hold A Button. - Use Control Stick to change selection. - Highlight Disguise and release A Button."
	restart_timer

	beginloop(0x8e)
		if_stage_flag_eq(STAGEFLAG_DISGUISE_FAILED, TRUE, /*goto*/ 0x0a)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_has_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISED, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x8e)

	label(0x06)
	goto_first(0x8d)

	label(0x2f)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(39)) // "Fool someone into giving you Cloaking Device."

	beginloop(0x82)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_door_state(0x31, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_door_state(0x8a, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_door_state(0x89, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_stage_flag_eq(STAGEFLAG_DISGUISE_COMPLETE, TRUE, /*goto*/ 0x09)
		if_stage_flag_eq(STAGEFLAG_DISGUISE_FAILED, TRUE, /*goto*/ 0x0a)
	endloop(0x82)

	label(0x09)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(40)) // "Cloaking Device successfully retrieved."
	restart_timer

	beginloop(0x0e)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(240, /*goto*/ 0x83)
	endloop(0x0e)

	label(0x0a)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(47)) // "You're meant to use the Disguise, remember?"
	restart_timer

	beginloop(0x0f)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		label(0x59)
		if_timer_gt(240, /*goto*/ 0x85)
	endloop(0x0f)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_FAILURE)
	goto_next(0x84)

	label(0x83)
	set_savefile_flag(SAVEFILEFLAG_CI_DISGUISE_DONE)
	dprint 'd','o','n','e',0,
	yield
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_SUCCESS)
	label(0x84)
	if_chr_in_room(CHR_BOND, 0x00, 0x001e, /*goto*/ 0x90)
	label(0x90)
	unlock_door(0x31, 0x40)
	unlock_door(0x8a, 0x40)
	unlock_door(0x89, 0x40)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	remove_hudmsgs
	hide_object(0x2a)

	beginloop(0x6d)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_DISGUISE, FALSE, /*goto*/ 0x2f)
	endloop(0x6d)

	label(0x2f)
	set_ailist(0x03, AILIST_INIT_COLLEAGUE_WHEN_SIGHTED)
	goto_first(0x08)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1007_devicetrainign_ir[] = {
	label(0x80)
	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_IR, TRUE, /*goto*/ 0x81)
	endloop(0x08)

	label(0x81)
	if_chr_activated_object(CHR_BOND, 0x37, /*goto*/ 0x2f)
	label(0x2f)
	lock_door(0x31, 0x40)
	lock_door(0x8a, 0x40)
	lock_door(0x89, 0x40)
	dprint 't','r','a','i','n','i','n','g',0,
	show_object(0x2b)
	move_object_to_pad(0x2b, 0x011d)
	unset_object_flag(0x2b, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(0x2b, OBJFLAG2_INVISIBLE)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	close_door(0x31)
	close_door(0x8a)
	close_door(0x89)
	if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
	if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
	if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
	goto_next(0x59)

	label(0x57)
	set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	label(0x59)
	label(0x8c)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(32)) // "Collect IR Scanner from table to begin."
	restart_timer

	beginloop(0x86)
		if_chr_has_weapon_equipped(CHR_BOND, WEAPON_IRSCANNER, /*goto*/ 0x2f)
		set_object_flag(0x37, OBJFLAG_CANNOT_ACTIVATE)
		goto_next(0x30)
		label(0x2f)
		unset_object_flag(0x37, OBJFLAG_CANNOT_ACTIVATE)
		label(0x30)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)
		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_chr_has_object(CHR_BOND, 0x2b, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x86)

	label(0x06)
	goto_first(0x8c)

	label(0x2f)
	label(0x8d)
	remove_hudmsgs
	if_chr_has_weapon_equipped(CHR_BOND, WEAPON_IRSCANNER, /*goto*/ 0x2f)
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(62)) // "Select the IR Scanner. - Hold A Button. - Use Control Stick to change selection. - Highlight IR Scanner and release A Button."
	restart_timer

	beginloop(0x8e)
		if_chr_has_weapon_equipped(CHR_BOND, WEAPON_IRSCANNER, /*goto*/ 0x2f)
		set_object_flag(0x37, OBJFLAG_CANNOT_ACTIVATE)
		goto_next(0x30)

		label(0x2f)
		unset_object_flag(0x37, OBJFLAG_CANNOT_ACTIVATE)
		label(0x30)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_has_weapon_equipped(CHR_BOND, WEAPON_IRSCANNER, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x8e)

	label(0x06)
	goto_first(0x8d)

	label(0x2f)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(33)) // "Locate secret door using IR Scanner."

	beginloop(0x82)
		if_chr_has_weapon_equipped(CHR_BOND, WEAPON_IRSCANNER, /*goto*/ 0x2f)
		set_object_flag(0x37, OBJFLAG_CANNOT_ACTIVATE)
		goto_next(0x30)
		label(0x2f)
		unset_object_flag(0x37, OBJFLAG_CANNOT_ACTIVATE)
		label(0x30)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_door_state(0x31, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_door_state(0x8a, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_door_state(0x89, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_chr_activated_object(CHR_BOND, 0x37, /*goto*/ 0x09)
	endloop(0x82)

	label(0x09)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(34)) // "Secret door has been successfully located."
	restart_timer

	beginloop(0x0e)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(240, /*goto*/ 0x83)
	endloop(0x0e)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_FAILURE)
	goto_next(0x84)

	label(0x83)
	set_savefile_flag(SAVEFILEFLAG_CI_IR_DONE)
	dprint 'd','o','n','e',0,
	yield
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_SUCCESS)
	label(0x84)
	if_chr_in_room(CHR_BOND, 0x00, 0x001e, /*goto*/ 0x90)
	label(0x90)
	unlock_door(0x31, 0x40)
	unlock_door(0x8a, 0x40)
	unlock_door(0x89, 0x40)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	remove_hudmsgs
	hide_object(0x2b)
	goto_first(0x08)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1008_devicetraining_rtracker[] = {
	label(0x80)
	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_RTRACKER, TRUE, /*goto*/ 0x81)
	endloop(0x08)

	label(0x81)
	lock_door(0x31, 0x40)
	lock_door(0x8a, 0x40)
	lock_door(0x89, 0x40)
	dprint 't','r','a','i','n','i','n','g',0,
	show_object(0x2c)
	move_object_to_pad(0x2c, 0x011d)
	unset_object_flag(0x2c, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(0x2c, OBJFLAG2_INVISIBLE)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	close_door(0x31)
	close_door(0x8a)
	close_door(0x89)
	if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
	if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
	if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
	goto_next(0x59)

	label(0x57)
	set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	label(0x59)
	label(0x8c)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(29)) // "Collect Tracker from table to begin."
	restart_timer

	beginloop(0x86)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_chr_has_object(CHR_BOND, 0x2c, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x86)

	label(0x06)
	goto_first(0x8c)

	label(0x2f)
	label(0x8d)
	remove_hudmsgs
	if_chr_has_weapon_equipped(CHR_BOND, WEAPON_RTRACKER, /*goto*/ 0x2f)
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(63)) // "Select the Tracker. - Hold A Button. - Use Control Stick to change selection. - Highlight Tracker and release A Button."
	restart_timer

	beginloop(0x8e)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_has_weapon_equipped(CHR_BOND, WEAPON_RTRACKER, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x8e)

	label(0x06)
	goto_first(0x8d)

	label(0x2f)
	unset_object_flag(0x36, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(0x36, OBJFLAG2_INVISIBLE)
	show_object(0x36)
	move_object_to_pad(0x36, 0x011e)
	set_object_flag3(0x36, OBJFLAG3_RTRACKED_YELLOW)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(30)) // "Locate IR Scanner using Tracker."

	beginloop(0x82)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_door_state(0x31, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_door_state(0x8a, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_door_state(0x89, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_chr_has_object(CHR_BOND, 0x36, /*goto*/ 0x09)
	endloop(0x82)

	label(0x09)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(31)) // "IR Scanner has been successfully located."
	restart_timer

	beginloop(0x0e)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(240, /*goto*/ 0x83)
	endloop(0x0e)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_FAILURE)
	goto_next(0x84)

	label(0x83)
	set_savefile_flag(SAVEFILEFLAG_CI_RTRACKER_DONE)
	dprint 'd','o','n','e',0,
	yield
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_SUCCESS)
	label(0x84)
	if_chr_in_room(CHR_BOND, 0x00, 0x001e, /*goto*/ 0x90)
	label(0x90)
	unlock_door(0x31, 0x40)
	unlock_door(0x8a, 0x40)
	unlock_door(0x89, 0x40)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	remove_hudmsgs
	hide_object(0x2c)
	hide_object(0x36)
	goto_first(0x08)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1009_devicetraining_cloak[] = {
	label(0x80)
	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_CLOAK, TRUE, /*goto*/ 0x81)
	endloop(0x08)

	label(0x81)
	deactivate_alarm
	unset_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	lock_door(0x31, 0x40)
	lock_door(0x8a, 0x40)
	lock_door(0x89, 0x40)
	dprint 't','r','a','i','n','i','n','g',0,
	restart_timer
	show_object(0x2d)
	move_object_to_pad(0x2d, 0x011d)
	unset_stage_flag(STAGEFLAG_CLOAK_FAILED)
	unset_stage_flag(STAGEFLAG_CLOAK_COMPLETE)
	unset_object_flag(0x2d, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(0x2d, OBJFLAG2_INVISIBLE)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	close_door(0x31)
	close_door(0x8a)
	close_door(0x89)
	if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
	if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
	if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
	goto_next(0x59)

	label(0x57)
	set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	label(0x59)
	label(0x8c)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(51)) // "Collect Cloaking Device from table to begin."
	restart_timer

	beginloop(0x86)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_stage_flag_eq(STAGEFLAG_CLOAK_COMPLETE, TRUE, /*goto*/ 0x09)
		if_stage_flag_eq(STAGEFLAG_CLOAK_FAILED, TRUE, /*goto*/ 0x0a)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_chr_has_object(CHR_BOND, 0x2d, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x86)

	label(0x06)
	goto_first(0x8c)

	label(0x2f)
	set_ailist(CHR_CARRINGTON, AILIST_CARRINGTON_CLOAK)
	label(0x8d)
	remove_hudmsgs
	if_chr_has_weapon_equipped(CHR_BOND, WEAPON_CLOAKINGDEVICE, /*goto*/ 0x2f)
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(64)) // "Select the Cloaking Device. - Hold A Button. - Use Control Stick to change selection. - Highlight Device and release A Button."
	restart_timer

	beginloop(0x8e)
		if_stage_flag_eq(STAGEFLAG_CLOAK_COMPLETE, TRUE, /*goto*/ 0x09)
		if_stage_flag_eq(STAGEFLAG_CLOAK_FAILED, TRUE, /*goto*/ 0x0a)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_has_weapon_equipped(CHR_BOND, WEAPON_CLOAKINGDEVICE, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x8e)

	label(0x06)
	goto_first(0x8d)

	label(0x2f)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(52)) // "Use Cloaking Device and locate Carrington."

	beginloop(0x82)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_door_state(0x31, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_door_state(0x8a, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_door_state(0x89, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x85)
		if_stage_flag_eq(STAGEFLAG_CLOAK_COMPLETE, TRUE, /*goto*/ 0x09)
		if_stage_flag_eq(STAGEFLAG_CLOAK_FAILED, TRUE, /*goto*/ 0x0a)
	endloop(0x82)

	label(0x09)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(54)) // "Mission complete - Device Training passed!"
	restart_timer

	beginloop(0x0e)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)
		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(240, /*goto*/ 0x83)
	endloop(0x0e)

	label(0x0a)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(55)) // "Mission failed - you have been detected."
	restart_timer

	beginloop(0x0f)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(240, /*goto*/ 0x85)
	endloop(0x0f)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_FAILURE)
	goto_next(0x84)

	label(0x83)
	set_savefile_flag(SAVEFILEFLAG_CI_CLOAK_DONE)
	dprint 'd','o','n','e',0,
	yield
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_SUCCESS)
	label(0x84)
	if_chr_in_room(CHR_BOND, 0x00, 0x001e, /*goto*/ 0x90)
	label(0x90)
	unlock_door(0x31, 0x40)
	unlock_door(0x8a, 0x40)
	unlock_door(0x89, 0x40)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	remove_hudmsgs
	hide_object(0x2d)

	beginloop(0x5c)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_CLOAK, FALSE, /*goto*/ 0x2f)
	endloop(0x5c)

	label(0x2f)
	set_ailist(CHR_CARRINGTON, AILIST_INIT_COLLEAGUE_WHEN_SIGHTED)
	goto_first(0x08)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100a_devicetraining_ecmmine[] = {
	label(0x80)
	beginloop(0x0f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_ECMMINE, TRUE, /*goto*/ 0x81)
	endloop(0x0f)

	label(0x81)
	lock_door(0x31, 0x40)
	lock_door(0x8a, 0x40)
	lock_door(0x89, 0x40)
	show_object(0x2e)
	move_object_to_pad(0x2e, 0x011d)
	unset_object_flag(0x2e, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(0x2e, OBJFLAG2_INVISIBLE)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	close_door(0x31)
	close_door(0x8a)
	close_door(0x89)
	if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
	if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
	if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
	goto_next(0x59)

	label(0x57)
	set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	label(0x59)
	label(0x8c)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(16)) // "Collect ECM Mine from table to begin."
	restart_timer

	beginloop(0x86)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_chr_has_object(CHR_BOND, 0x2e, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x86)

	label(0x06)
	goto_first(0x8c)

	label(0x2f)
	label(0x8d)
	remove_hudmsgs
	if_chr_weapon_equipped(CHR_BOND, WEAPON_ECMMINE, /*goto*/ 0x2f)
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(65)) // "Select the ECM Mine. - Hold A Button. - Use Control Stick to change selection. - Highlight ECM Mine and release A Button."
	restart_timer

	beginloop(0x8e)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_weapon_equipped(CHR_BOND, WEAPON_ECMMINE, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x8e)

	label(0x06)
	goto_first(0x8d)

	label(0x2f)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(17)) // "Locate Hub and throw ECM Mine onto Hub."

	beginloop(0x82)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_ammo_quantity_lt(CHR_BOND, AMMOTYPE_ECM_MINE, 1, /*goto*/ 0x2f)
	endloop(0x82)

	label(0x2f)
	yield
	yield
	yield
	yield
	yield
	if_weapon_thrown(WEAPON_ECMMINE, /*goto*/ 0x06)
	goto_first(0x82)

	label(0x06)
	restart_timer

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_weapon_thrown_on_object(WEAPON_ECMMINE, 0x32, /*goto*/ 0x09)
		if_timer_gt(120, /*goto*/ 0x0a)
	endloop(0x08)

	label(0x09)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(19)) // "ECM Mine has been placed correctly."
	restart_timer

	beginloop(0x0c)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_timer_gt(240, /*goto*/ 0x83)
	endloop(0x0c)

	label(0x0a)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(18)) // "ECM Mine has been placed incorrectly."
	restart_timer

	beginloop(0x0d)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_timer_gt(240, /*goto*/ 0x85)
	endloop(0x0d)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_FAILURE)
	goto_next(0x84)

	label(0x83)
	set_savefile_flag(SAVEFILEFLAG_CI_ECMMINE_DONE)
	dprint 'd','o','n','e',0,
	yield
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_SUCCESS)
	label(0x84)
	if_chr_in_room(CHR_BOND, 0x00, 0x001e, /*goto*/ 0x90)
	label(0x90)
	unlock_door(0x31, 0x40)
	unlock_door(0x8a, 0x40)
	unlock_door(0x89, 0x40)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	remove_hudmsgs
	hide_object(0x2e)
	goto_first(0x0f)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100b_devicetraining_uplink[] = {
	label(0x80)
	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_UPLINK, TRUE, /*goto*/ 0x81)
	endloop(0x08)

	label(0x81)
	lock_door(0x31, 0x40)
	lock_door(0x8a, 0x40)
	lock_door(0x89, 0x40)
	unset_stage_flag(STAGEFLAG_DEVICE_ABORTING)
	unset_stage_flag(STAGEFLAG_TRIGGER_DEVICE_SUCCESS)
	unset_stage_flag(STAGEFLAG_TRIGGER_DEVICE_FAILURE)
	show_object(0x2f)
	move_object_to_pad(0x2f, 0x0131)
	unset_object_flag(0x2f, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(0x2f, OBJFLAG2_INVISIBLE)
	dprint 't','r','a','i','n','i','n','g',0,
	close_door(0x31)
	close_door(0x8a)
	close_door(0x89)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x8c)
	if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x8c)
	if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x8c)
	label(0x8c)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(10)) // "Collect Data Uplink from table to begin."
	restart_timer

	beginloop(0x86)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)
		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_chr_has_object(CHR_BOND, 0x2f, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x86)

	label(0x06)
	goto_first(0x8c)

	label(0x2f)
	label(0x8d)
	remove_hudmsgs
	if_chr_weapon_equipped(CHR_BOND, WEAPON_DATAUPLINK, /*goto*/ 0x2f)
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(56)) // "Select the Uplink. - Hold A Button. - Use Control Stick to change selection. - Highlight Data Uplink and release A Button."
	restart_timer

	beginloop(0x8e)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)
		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_weapon_equipped(CHR_BOND, WEAPON_DATAUPLINK, /*goto*/ 0x2f)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x8e)

	label(0x06)
	goto_first(0x8d)

	label(0x2f)
	if_chr_activated_object(CHR_BOND, 0x30, /*goto*/ 0x2f)
	label(0x2f)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(11)) // "Stand next to the terminal and use the Uplink."

	beginloop(0x82)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x30, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
	endloop(0x82)

	label(0x2f)
	if_chr_weapon_equipped(CHR_BOND, WEAPON_DATAUPLINK, /*goto*/ 0x2f)
	play_sound(0x8116, -1)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(12)) // "You need to be holding the Data Uplink."
	goto_first(0x82)

	label(0x2f)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(13)) // "Connection established..."
	restart_timer

	label(0x08)
	yield
	if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
	if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
	if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
	if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
	goto_next(0x59)

	label(0x57)
	set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	label(0x59)
	assign_sound(0x01bf, CHANNEL_5)
	control_sound_from_object(CHANNEL_5, 0x30, TRUE)
	label(0x14)
	yield
	if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
	if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
	if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
	if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
	goto_next(0x59)

	label(0x57)
	set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	label(0x59)
	if_timer_gt(400, /*goto*/ 0x06)
	if_chr_distance_to_pad_gt(CHR_BOND, 400, 0x0227, /*goto*/ 0x09)
	if_chr_weapon_equipped(CHR_BOND, WEAPON_DATAUPLINK, /*goto*/ 0x2f)
	goto_first(0x09)

	label(0x2f)
	goto_first(0x14)

	label(0x06)
	restart_timer
	mute_channel(CHANNEL_5)
	assign_sound(0x01c1, CHANNEL_7)
	control_sound_from_object(CHANNEL_7, 0x30, TRUE)
	remove_hudmsgs
	show_hudmsg(CHR_TARGET, L_DISH(14)) // "Terminal has been successfully hacked."

	beginloop(0x15)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(240, /*goto*/ 0x06)
	endloop(0x15)

	label(0x06)
	goto_next(0x83)

	label(0x09)
	remove_hudmsgs
	show_hudmsg(CHR_BOND, L_DISH(15)) // "Connection broken - too far from PC."
	mute_channel(CHANNEL_5)
	assign_sound(0x01c0, CHANNEL_6)
	control_sound_from_object(CHANNEL_6, 0x30, TRUE)
	restart_timer

	beginloop(0x16)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x90)
		if_chr_activated_object(CHR_BOND, 0x31, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x8a, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x89, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x16)

	label(0x06)
	mute_channel(CHANNEL_6)
	goto_first(0x82)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_FAILURE)
	goto_next(0x84)

	label(0x83)
	set_savefile_flag(SAVEFILEFLAG_CI_UPLINK_DONE)
	dprint 'd','o','n','e',0,
	set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_SUCCESS)
	yield
	goto_next(0x84)

	label(0x84)
	if_chr_in_room(CHR_BOND, 0x00, 0x001e, /*goto*/ 0x90)
	label(0x90)
	unlock_door(0x31, 0x40)
	unlock_door(0x8a, 0x40)
	unlock_door(0x89, 0x40)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	remove_hudmsgs
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_7)
	dprint 'a','b','o','r','t','e','d',0,
	hide_object(0x2f)
	goto_first(0x08)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101a_move_jo_to_training_room[] = {
	// Wait for flag to be set while not in training
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_CONSIDER_WARP, TRUE, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_UPLINK, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_ECMMINE, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_CAMSPY, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_NIGHTVISION, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_DOORDECODER, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_RTRACKER, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_IR, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_XRAY, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_DISGUISE, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_CLOAK, TRUE, /*goto*/ 0x2f)
		goto_next(0x06)
		label(0x2f)
	endloop(0x04)

	label(0x06)
	unset_stage_flag(STAGEFLAG_CONSIDER_WARP)
	if_chr_in_room(CHR_BOND, 0x00, 0x001e, /*goto*/ 0x2f)
	goto_next(0x30)

	// In room
	label(0x2f)
	reloop(0x04)

	// Not in room
	label(0x30)
	revoke_control(CHR_BOND, 0)
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 5000)
	restart_timer

	beginloop(0x08)
		if_timer_gt(30, /*goto*/ 0x2f)
	endloop(0x08)

	label(0x2f)
	if_chr_in_room(CHR_BOND, 0x00, 0x0016, /*goto*/ 0x2f)
	if_chr_in_room(CHR_BOND, 0x00, 0x0017, /*goto*/ 0x2f)
	if_chr_in_room(CHR_BOND, 0x00, 0x0018, /*goto*/ 0x2f)
	if_chr_in_room(CHR_BOND, 0x00, 0x0019, /*goto*/ 0x2f)
	if_chr_in_room(CHR_BOND, 0x00, 0x0014, /*goto*/ 0x2f)
	enter_camera_and_move_to_pad(0x0151)
	set_ailist(CHR_P1P2, AILIST_MOVE_TO_DEVICEROOM)
	goto_next(0x06)

	label(0x2f)
	enter_camera_and_move_to_pad(0x020a)
	set_ailist(CHR_P1P2, AILIST_MOVE_TO_HOLOROOM)

	label(0x06)
	yield
	yield
	yield
	yield
	enter_firstperson
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 90)
	restart_timer

	beginloop(0x09)
		if_timer_gt(90, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	grant_control(CHR_BOND)
	enter_firstperson
	unset_stage_flag(STAGEFLAG_CONSIDER_WARP)
	goto_first(0x04)

	endlist
};

u8 func0401_move_to_deviceroom[] = {
	chr_move_to_pad(CHR_SELF, PAD_DEVICEROOM, 0x01, /*goto*/ 0x06)
	label(0x06)
	stop_chr
	yield
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0402_move_to_holoroom[] = {
	chr_move_to_pad(CHR_SELF, PAD_HOLOROOM, 0x01, /*goto*/ 0x06)
	label(0x06)
	stop_chr
	yield
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0429_grimshaw_disguise[] = {
	set_returnlist(CHR_SELF, AILIST_GRIMSHAW_DISGUISE)
	dprint 'I','n','i','t','i','a','l','i','s','e','a',0,
	restart_timer

	beginloop(0x0f)
		if_timer_gt(60, /*goto*/ 0x8f)
	endloop(0x0f)

	beginloop(0x8f)
		if_stage_flag_eq(STAGEFLAG_CONSIDER_WARP, FALSE, /*goto*/ 0x04)
	endloop(0x8f)

	// Wait until Jo in sight
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x0d)
		if_target_in_sight(/*goto*/ 0x2f)
		if_chr_idle(/*goto*/ 0x06)
		label(0x7f)
		call_rng
		if_rand_gt(1, /*goto*/ 0x06)
		set_ailist(CHR_SELF, GAILIST_DO_BORED_ANIMATION)
		label(0x06)
	endloop(0x04)

	label(0x2f)
	dprint 'I','n','i','t','i','a','l','i','s','e','b',0,
	restart_timer
	label(0x08)
	if_self_flag_bankx_eq(CHRFLAG1_DOINGIDLEANIMATION, TRUE, BANK_1, /*goto*/ 0x06)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x0d)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	dprint 'I','n','i','t','i','a','l','i','s','e','c',0,
	do_preset_animation(3)
	play_cistaff_quip(BANK_0, CHANNEL_6)
	restart_timer

	beginloop(0x57)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x0d)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x57)

	label(0x06)
	dprint 'I','n','i','t','i','a','l','i','s','e','d',0,
	restart_timer

	beginloop(0x58)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x0d)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x58)

	label(0x06)
	speak(CHR_BOND, L_DISH(43), 0x1517, CHANNEL_6, COLOR_09_BLUE) // "I'm here to pick up the equipment."

	beginloop(0x59)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x0d)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x59)

	label(0x06)
	restart_timer

	beginloop(0x5b)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x0d)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x5b)

	label(0x06)
	if_chr_has_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISED, /*goto*/ 0x2f)
	do_preset_animation(-1)
	speak(CHR_TARGET, L_DISH(44), 0x1518, CHANNEL_6, COLOR_05_GREEN) // "Go away, Joanna. You're not fooling anybody!"

	beginloop(0x5c)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x0d)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x5c)

	label(0x06)
	set_stage_flag(STAGEFLAG_DISGUISE_FAILED)
	goto_next(0x0d)

	label(0x2f)
	do_preset_animation(-1)
	speak(CHR_TARGET, L_DISH(45), 0x1519, CHANNEL_6, COLOR_05_GREEN) // "Here you go. Don't drop it now."

	beginloop(0x5d)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x0d)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x5d)

	label(0x06)
	give_object_to_chr(0x3c, CHR_BOND)
	set_stage_flag(STAGEFLAG_DISGUISE_COMPLETE)
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100c_cloak_detection[] = {
	beginloop(0x04)
		deactivate_alarm
		dprint 'I','N','I','T','Y',0,
		if_stage_flag_eq(STAGEFLAG_TRIGGER_CLOAK, TRUE, /*goto*/ 0x8f)
		reloop(0x04)

		beginloop(0x8f)
			dprint 'L','O','O','P','Y',0,
			if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x5d)
			if_chr_distance_to_pad_lt(CHR_BOND, 200, 0x027b, /*goto*/ 0x06)
		endloop(0x8f)

		beginloop(0x5d)
			dprint 'W','A','I','T','Y',0,
			if_stage_flag_eq(STAGEFLAG_TRIGGER_CLOAK, FALSE, /*goto*/ 0x30)
		endloop(0x5d)

		label(0x30)
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
	endloop(0x04)

	label(0x06)
	dprint 'G','O','T','T','H','R','U',0,
	if_chr_has_hiddenflag(CHR_BOND, CHRHFLAG_CLOAKED, /*goto*/ 0x30)
	activate_alarm
	yield
	restart_timer

	beginloop(0x09)
		if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x59)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	set_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	speak(CHR_TARGET, L_DISH(48), 0x151a, CHANNEL_6, COLOR_05_GREEN) // "You'll have to do better than that, Joanna."
	show_hudmsg(CHR_BOND, L_DISH(50)) // "You have been detected by the camera."
	restart_timer

	beginloop(0x0a)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_CLOAK, FALSE, /*goto*/ 0x30)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	set_stage_flag(STAGEFLAG_CLOAK_FAILED)
	restart_timer

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_CLOAK, FALSE, /*goto*/ 0x30)
		if_timer_gt(120, /*goto*/ 0x59)
	endloop(0x08)

	label(0x59)
	deactivate_alarm

	beginloop(0x5a)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_CLOAK, FALSE, /*goto*/ 0x30)
	endloop(0x5a)

	label(0x30)
	deactivate_alarm
	restart_timer

	beginloop(0x5c)
		yield
		dprint 'W','A','I','T','F','I','N',0,
		if_timer_gt(60, /*goto*/ 0x2f)
	endloop(0x5c)

	label(0x2f)
	goto_first(0x04)

	label(0x06)
	goto_first(0x8f)

	endlist
};

u8 func042a_carrington_cloak[] = {
	set_returnlist(CHR_SELF, AILIST_CARRINGTON_CLOAK)

	beginloop(0x8f)
		chr_move_to_pad(CHR_SELF, PAD_CARRINGTON_OFFICE, 0x01, /*goto*/ 0x06)
	endloop(0x8f)

	label(0x06)
	dprint 'I','n','i','t','i','a','l','i','s','e','a',0,

	beginloop(0x04)
		if_target_in_sight(/*goto*/ 0x2f)
		if_chr_idle(/*goto*/ 0x06)
		label(0x7f)
		call_rng
		if_rand_gt(1, /*goto*/ 0x06)
		set_ailist(CHR_SELF, GAILIST_DO_BORED_ANIMATION)

		label(0x06)
	endloop(0x04)

	label(0x2f)
	set_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	close_door(0x40)
	dprint 'I','n','i','t','i','a','l','i','s','e','b',0,
	restart_timer
	label(0x08)
	if_self_flag_bankx_eq(CHRFLAG1_DOINGIDLEANIMATION, TRUE, BANK_1, /*goto*/ 0x06)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	dprint 'I','n','i','t','i','a','l','i','s','e','c',0,
	restart_timer
	chr_do_animation(ANIM_WALK_BACKWARDS, -1, -1, 0x10, 0x10, CHR_SELF, 2)
	restart_timer

	beginloop(0x57)
		if_timer_gt(30, /*goto*/ 0x06)
	endloop(0x57)

	label(0x06)
	do_preset_animation(-1)
	speak(CHR_BOND, L_DISH(49), 0x151b, CHANNEL_6, COLOR_06_WHITE) // "Joanna, where did you spring from?"

	beginloop(0x59)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x59)

	label(0x06)
	restart_timer

	beginloop(0x5b)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x5b)

	label(0x06)
	do_preset_animation(-1)
	speak(CHR_TARGET, L_DISH(53), 0x151c, CHANNEL_6, COLOR_06_WHITE) // "I think we can safely say your training is now complete!"

	beginloop(0x5c)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x5c)

	label(0x06)
	stop_chr
	set_stage_flag(STAGEFLAG_CLOAK_COMPLETE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100e_training_unlockables[] = {
	beginloop(0x04)
		if_savefile_flag_is_set(SAVEFILEFLAG_CI_UPLINK_DONE, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	unlock_door(0x3e, 0x40)

	beginloop(0x08)
		if_savefile_flag_is_set(SAVEFILEFLAG_CI_ECMMINE_DONE, /*goto*/ 0x2f)
	endloop(0x08)

	label(0x2f)
	unlock_door(0x3d, 0x40)
	unlock_door(0x3f, 0x40)
	goto_next(0x2f)

	beginloop(0x09)
		if_savefile_flag_is_set(SAVEFILEFLAG_CI_CAMSPY_DONE, /*goto*/ 0x2f)
	endloop(0x09)

	label(0x2f)
	unset_object_flag2(OBJ_LIGHTSWITCH, OBJFLAG2_INVISIBLE)

	beginloop(0x0a)
		if_savefile_flag_is_set(SAVEFILEFLAG_CI_NIGHTVISION_DONE, /*goto*/ 0x2f)
	endloop(0x0a)

	label(0x2f)
	set_lights_state(0x0030, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x002e, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x002f, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0020, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0024, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0025, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0026, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0022, 0x01, 0xff, 0x00, 0x00)

	beginloop(0x0b)
		if_savefile_flag_is_set(SAVEFILEFLAG_CI_DOORDECODER_DONE, /*goto*/ 0x2f)
	endloop(0x0b)

	label(0x2f)
	unlock_door(0x41, 0x40)

	beginloop(0x0e)
		if_savefile_flag_is_set(SAVEFILEFLAG_CI_IR_DONE, /*goto*/ 0x2f)
	endloop(0x0e)

	label(0x2f)
	unlock_door(0x37, 0x40)

	beginloop(0x0f)
		if_savefile_flag_is_set(SAVEFILEFLAG_CI_XRAY_DONE, /*goto*/ 0x2f)
	endloop(0x0f)

	label(0x2f)
	hide_object(0x3a)
	hide_object(0x3b)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define do_door_proxy(eepromflag, pad, door) \
	/* If training flag is done, open/close a door automatically as Jo nears it */ \
	beginloop(0x04) \
		if_savefile_flag_is_set(eepromflag, /*goto*/ 0x2f) \
		reloop(0x04) \
 \
		label(0x2f) \
		if_chr_distance_to_pad_lt(CHR_BOND, 350, pad, /*goto*/ 0x06) \
		close_door(door) \
		reloop(0x04) \
 \
		label(0x06) \
		if_door_state(door, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2f) \
		open_door(door) \
		set_object_flag(door, OBJFLAG_40000000) \
		restart_timer \
 \
		beginloop(0x08) \
			if_timer_gt(120, /*goto*/ 0x2f) \
		endloop(0x08) \
 \
		label(0x2f) \
	endloop(0x04)



u8 func100f_doorproxy_unused1[] = {
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Unreachable
	do_door_proxy(SAVEFILEFLAG_CI_ECMMINE_DONE, 0x0185, 0x3d)
	endlist
};

u8 func1010_doorproxy[] = {
	do_door_proxy(SAVEFILEFLAG_CI_UPLINK_DONE, 0x0186, 0x3e)
	endlist
};

u8 func1010_doorproxy_unused2[] = {
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Unreachable
	do_door_proxy(SAVEFILEFLAG_CI_ECMMINE_DONE, 0x0187, 0x3f)
	endlist
};

u8 func1012_cloak_doorproxy[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_CLOAK, TRUE, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x2f)
		if_stage_flag_eq(STAGEFLAG_CLOAK_FAILED, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_DEVICE_ABORTING, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_DEVICE_SUCCESS, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_DEVICE_FAILURE, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 350, 0x0188, /*goto*/ 0x06)
		close_door(0x40)
		label(0x2f)
	endloop(0x04)

	label(0x06)
	if_door_state(0x40, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2f)
	open_door(0x40)
	set_object_flag(0x40, OBJFLAG_40000000)
	restart_timer

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x2f)
	endloop(0x08)

	label(0x2f)
	goto_first(0x04)

	endlist
};

u8 func101b_ir_door[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_IR, TRUE, /*goto*/ 0x06)
		if_savefile_flag_is_set(SAVEFILEFLAG_CI_IR_DONE, /*goto*/ 0x2f)
		label(0x06)
		reloop(0x04)

		label(0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 350, 0x0192, /*goto*/ 0x06)
		close_door(0x37)
	endloop(0x04)

	label(0x06)
	if_door_state(0x37, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2f)
	open_door(0x37)
	set_object_flag(0x37, OBJFLAG_40000000)
	restart_timer

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x2f)
	endloop(0x08)

	label(0x2f)
	goto_first(0x04)

	endlist
};

u8 func042b_init_carrington[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	yield
	set_morale(0)
	if_savefile_flag_is_unset(SAVEFILEFLAG_CI_TOUR_STARTED, /*goto*/ 0x06)
	set_savefile_flag(SAVEFILEFLAG_CI_TOUR_DONE)
	dprint 'E','E','P','R','O','M',' ','S','E','T',0,

	beginloop(0x08)
		chr_move_to_pad(CHR_SELF, PAD_CARRINGTON_OFFICE, 0x01, /*goto*/ 0x2f)
	endloop(0x08)

	label(0x2f)
	set_ailist(CHR_SELF, 0x041e)

	label(0x06)
	dprint 'E','E','P','R','O','M',' ','N','O','T','S','E','T',0,
	if_savefile_flag_is_unset(SAVEFILEFLAG_CI_TOUR_DONE, /*goto*/ 0x8f)
	goto_first(0x08)

	beginloop(0x8f)
		chr_move_to_pad(CHR_SELF, PAD_OUTSIDE_JO_OFFICE, 0x01, /*goto*/ 0x2f)
	endloop(0x8f)

	label(0x2f)
	stop_chr
	set_ailist(CHR_SELF, AILIST_CARRINGTON_TOUR)
	endlist
};

u8 func1019_setup_carrington[] = {
	beginloop(0x04)
		if_chr_has_hiddenflag(CHR_CARRINGTON, CHRHFLAG_10000000, /*goto*/ 0x06)
		if_savefile_flag_is_set(SAVEFILEFLAG_CI_TOUR_STARTED, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2f)
	set_ailist(CHR_CARRINGTON, AILIST_INIT_CARRINGTON)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func042c_carrington_tour[] = {
	set_returnlist(CHR_SELF, AILIST_CARRINGTON_TOUR)
	set_self_chrflag(CHRCFLAG_00040000)
	restart_timer
	try_face_entity(ENTITYTYPE_PAD, 0x0054, /*goto*/ 0x04)

	beginloop(0x04)
		dprint 'F','A','C','E',' ','P','A','D',0,
		if_timer_gt(1200, /*goto*/ 0x2f)
		if_chr_sees_player(/*goto*/ 0x2f)
		if_chr_idle(/*goto*/ 0x06)
		label(0x7f)
		call_rng
		if_rand_gt(1, /*goto*/ 0x06)
		set_ailist(CHR_SELF, GAILIST_DO_BORED_ANIMATION)

		label(0x06)
	endloop(0x04)

	label(0x2f)
	if_chr_sees_player(/*goto*/ 0x06)
	try_jog_to_target(/*goto*/ 0x08)

	beginloop(0x08)
		if_chr_sees_player(/*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_10000000)
	set_savefile_flag(SAVEFILEFLAG_CI_TOUR_STARTED)
	do_preset_animation(-1)
	remove_hudmsgs
	speak(CHR_TARGET, L_DISH(66), 0x8029, CHANNEL_6, COLOR_06_WHITE) // "Joanna, it's good to see you."
	restart_timer

	beginloop(0x57)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x57)

	label(0x06)
	do_preset_animation(-1)
	speak(CHR_TARGET, L_DISH(67), 0x151d, CHANNEL_6, COLOR_06_WHITE) // "Come with me. I'll walk you round the training rooms."
	restart_timer

	beginloop(0x59)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x59)

	label(0x06)
	walk_to_pad(0x0064)

	beginloop(0x5b)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x5b)

	label(0x06)
	stop_chr
	restart_timer
	try_face_entity(ENTITYTYPE_PAD, 0x0068, /*goto*/ 0x5c)

	beginloop(0x5c)
		if_timer_lt(60, /*goto*/ 0x06)
		if_chr_sees_player(/*goto*/ 0x2f)
		label(0x06)
	endloop(0x5c)

	label(0x2f)
	if_distance_to_target_lt(500, /*goto*/ 0x2f)
	goto_first(0x5c)

	label(0x2f)
	do_preset_animation(-1)
	remove_hudmsgs
	speak(CHR_TARGET, L_DISH(68), 0x1520, CHANNEL_6, COLOR_06_WHITE) // "The information center is through this door."
	restart_timer

	beginloop(0x5d)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x5d)

	label(0x06)
	walk_to_pad(0x0065)

	beginloop(0x62)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x62)

	label(0x06)
	stop_chr

	beginloop(0x63)
		if_chr_sees_player(/*goto*/ 0x2f)
	endloop(0x63)

	label(0x2f)
	if_distance_to_target_lt(500, /*goto*/ 0x2f)
	goto_first(0x63)

	label(0x2f)
	set_ailist(0x01, GAILIST_IDLE)
	do_preset_animation(-1)
	speak(CHR_TARGET, L_DISH(69), 0x151f, CHANNEL_6, COLOR_06_WHITE) // "In here we have the device lab."
	restart_timer

	beginloop(0x64)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x64)

	label(0x06)
	restart_timer
	try_face_entity(ENTITYTYPE_CHR, 0x01, /*goto*/ 0x65)

	beginloop(0x65)
		if_timer_gt(40, /*goto*/ 0x06)
	endloop(0x65)

	label(0x06)
	do_preset_animation(-1)
	play_sound(0x8028, CHANNEL_6)
	set_ailist(0x01, AILIST_DEVICEGIRL_REPLY_TO_CARRINGTON)
	restart_timer

	beginloop(0x66)
		if_timer_gt(20, /*goto*/ 0x06)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x66)

	label(0x06)
	mute_channel(CHANNEL_6)
	stop_chr
	yield
	yield

	beginloop(0x68)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x68)

	label(0x06)
	walk_to_pad(0x0020)

	beginloop(0x69)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x69)

	label(0x06)
	stop_chr

	beginloop(0x6a)
		if_chr_sees_player(/*goto*/ 0x2f)
	endloop(0x6a)

	label(0x2f)
	if_distance_to_target_lt(500, /*goto*/ 0x2f)
	goto_first(0x6a)

	label(0x2f)
	do_preset_animation(-1)
	speak(CHR_TARGET, L_DISH(70), 0x1521, CHANNEL_6, COLOR_06_WHITE) // "This leads to the simulant training room."
	restart_timer

	beginloop(0x6b)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x6b)

	label(0x06)
	stop_chr
	yield
	yield

	beginloop(0x6c)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x6c)

	label(0x06)
	walk_to_pad(0x0010)

	beginloop(0x6d)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x6d)

	label(0x06)
	stop_chr

	beginloop(0x6e)
		if_chr_sees_player(/*goto*/ 0x2f)
	endloop(0x6e)

	label(0x2f)
	if_distance_to_target_lt(500, /*goto*/ 0x2f)
	goto_first(0x6e)

	label(0x2f)
	do_preset_animation(-1)
	speak(CHR_TARGET, L_DISH(71), 0x151e, CHANNEL_6, COLOR_06_WHITE) // "This is the firing range, Jo."
	restart_timer

	beginloop(0x6f)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x6f)

	label(0x06)
	restart_timer
	try_face_entity(ENTITYTYPE_CHR, 0x01, /*goto*/ 0x70)

	beginloop(0x70)
		if_timer_gt(40, /*goto*/ 0x06)
	endloop(0x70)

	label(0x06)
	restart_timer

	beginloop(0x71)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x71)

	label(0x06)
	stop_chr
	yield
	yield

	beginloop(0x72)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x72)

	label(0x06)
	label(0x06)
	walk_to_pad(0x0009)

	beginloop(0x73)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x73)

	label(0x06)
	stop_chr

	beginloop(0x74)
		if_chr_sees_player(/*goto*/ 0x2f)
	endloop(0x74)

	label(0x2f)
	if_distance_to_target_lt(500, /*goto*/ 0x2f)
	goto_first(0x74)

	label(0x2f)
	do_preset_animation(-1)
	speak(CHR_TARGET, L_DISH(72), 0x1522, CHANNEL_6, COLOR_06_WHITE) // "This corridor leads down to the hangar."
	restart_timer

	beginloop(0x75)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x75)

	label(0x06)
	restart_timer
	set_target_chr(CHR_BOND)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x79)

	beginloop(0x79)
		if_timer_gt(120, /*goto*/ 0x2f)
	endloop(0x79)

	label(0x2f)
	do_preset_animation(-1)
	speak(CHR_TARGET, L_DISH(124), 0x17dc, CHANNEL_6, COLOR_06_WHITE) // "Okay, Jo, I'll leave you to prepare for the mission."

	beginloop(0x7a)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2f)
	endloop(0x7a)

	label(0x2f)
	set_savefile_flag(SAVEFILEFLAG_CI_TOUR_DONE)
	walk_to_pad(PAD_CARRINGTON_OFFICE)

	beginloop(0x76)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x76)

	label(0x06)
	set_ailist(CHR_SELF, 0x041e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func042d_unused[] = {
	set_alertness(1)
	set_self_chrflag(CHRCFLAG_00040000)
	restart_timer
	try_face_entity(ENTITYTYPE_CHR, CHR_CARRINGTON, /*goto*/ 0x5f)

	beginloop(0x5f)
		if_timer_gt(40, /*goto*/ 0x06)
	endloop(0x5f)

	label(0x06)

	beginloop(0x60)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x60)

	label(0x06)
	assign_sound(0x802d, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)

	beginloop(0x61)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x61)

	label(0x06)
	set_ailist(CHR_SELF, 0x041e)
	endlist
};

u8 func042e_devicegirl_reply_to_carrington[] = {
	set_alertness(1)
	set_self_chrflag(CHRCFLAG_00040000)
	restart_timer
	try_face_entity(ENTITYTYPE_CHR, CHR_CARRINGTON, /*goto*/ 0x5f)

	beginloop(0x5f)
		if_timer_gt(40, /*goto*/ 0x06)
	endloop(0x5f)

	label(0x06)

	beginloop(0x60)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x60)

	label(0x06)
	yield
	yield
	yield
	assign_sound(0x177d, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)

	beginloop(0x61)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	endloop(0x61)

	label(0x06)
	set_ailist(CHR_SELF, 0x041e)
	endlist
};

u8 func1013_msg_hovercrate[] = {
#if VERSION >= VERSION_PAL_FINAL
	beginloop(0x8f)
		if_savefile_flag_is_unset(SAVEFILEFLAG_HOWTO_HOVERCRATE, /*goto*/ 0x04)
	endloop(0x8f)

	beginloop(0x04)
		if_savefile_flag_is_set(SAVEFILEFLAG_HOWTO_HOVERCRATE, /*goto*/ 0x06)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x0141, /*goto*/ 0x2f)
	endloop(0x04)
#else
	if_savefile_flag_is_unset(SAVEFILEFLAG_CI_TOUR_STARTED, /*goto*/ 0x04)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x04)
		if_savefile_flag_is_set(SAVEFILEFLAG_CI_TOUR_STARTED, /*goto*/ 0x06)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x0141, /*goto*/ 0x2f)
	endloop(0x04)
#endif

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2f)
#if VERSION >= VERSION_PAL_FINAL
	set_savefile_flag(SAVEFILEFLAG_HOWTO_HOVERCRATE)
#endif
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(73)) // "HOVERCRATE Press B Button next to Hovcrate to grab it..."
	restart_timer

	beginloop(0x08)
		if_timer_gt(240, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(74)) // "Press B Button when crate grabbed to release it."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1014_msg_hoverbike[] = {
#if VERSION >= VERSION_PAL_FINAL
	beginloop(0x8f)
		if_savefile_flag_is_unset(SAVEFILEFLAG_HOWTO_HOVERBIKE, /*goto*/ 0x04)
	endloop(0x8f)

	beginloop(0x04)
		if_savefile_flag_is_set(SAVEFILEFLAG_HOWTO_HOVERBIKE, /*goto*/ 0x06)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x01f9, /*goto*/ 0x2f)
	endloop(0x04)
#else
	if_savefile_flag_is_unset(SAVEFILEFLAG_CI_TOUR_STARTED, /*goto*/ 0x04)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x04)
		if_savefile_flag_is_set(SAVEFILEFLAG_CI_TOUR_STARTED, /*goto*/ 0x06)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x01f9, /*goto*/ 0x2f)
	endloop(0x04)
#endif

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2f)
#if VERSION >= VERSION_PAL_FINAL
	set_savefile_flag(SAVEFILEFLAG_HOWTO_HOVERBIKE)
#endif
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(75)) // "HOVERBIKE Double tap B Button next to Hovbike to ride it..."
	restart_timer

	beginloop(0x08)
		if_timer_gt(240, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(76)) // "Double tap B Button when on Hovbike to dismount."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1015_msg_doors[] = {
#if VERSION >= VERSION_PAL_FINAL
	beginloop(0x8f)
		if_savefile_flag_is_unset(SAVEFILEFLAG_HOWTO_DOORS, /*goto*/ 0x04)
	endloop(0x8f)

	beginloop(0x04)
		if_savefile_flag_is_set(SAVEFILEFLAG_HOWTO_DOORS, /*goto*/ 0x06)
	endloop(0x04)
#else
	if_savefile_flag_is_unset(SAVEFILEFLAG_CI_TOUR_STARTED, /*goto*/ 0x04)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x04)
		if_savefile_flag_is_set(SAVEFILEFLAG_CI_TOUR_STARTED, /*goto*/ 0x06)
	endloop(0x04)
#endif

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2f)
#if VERSION >= VERSION_PAL_FINAL
	set_savefile_flag(SAVEFILEFLAG_HOWTO_DOORS)
#endif
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(77)) // "OPENING DOORS Press B Button next to door to open it."
	restart_timer

	beginloop(0x08)
		if_timer_gt(240, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(78)) // "B Button will also activate any object nearby."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1016_msg_elevators[] = {
#if VERSION >= VERSION_PAL_FINAL
	beginloop(0x8f)
		if_savefile_flag_is_unset(SAVEFILEFLAG_HOWTO_ELEVATORS, /*goto*/ 0x04)
	endloop(0x8f)

	beginloop(0x04)
		if_savefile_flag_is_set(SAVEFILEFLAG_HOWTO_ELEVATORS, /*goto*/ 0x06)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x0160, /*goto*/ 0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x0162, /*goto*/ 0x2f)
	endloop(0x04)
#else
	if_savefile_flag_is_unset(SAVEFILEFLAG_CI_TOUR_STARTED, /*goto*/ 0x04)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x04)
		if_savefile_flag_is_set(SAVEFILEFLAG_CI_TOUR_STARTED, /*goto*/ 0x06)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x0160, /*goto*/ 0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x0162, /*goto*/ 0x2f)
	endloop(0x04)
#endif

	label(0x2f)
#if VERSION >= VERSION_PAL_FINAL
	set_savefile_flag(SAVEFILEFLAG_HOWTO_ELEVATORS)
#endif
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(79)) // "ELEVATORS Press B Button next to door to call elevator."
	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1017_msg_terminals[] = {
#if VERSION >= VERSION_PAL_FINAL
	beginloop(0x8f)
		if_savefile_flag_is_unset(SAVEFILEFLAG_HOWTO_TERMINALS, /*goto*/ 0x04)
	endloop(0x8f)

	beginloop(0x04)
		if_savefile_flag_is_set(SAVEFILEFLAG_HOWTO_TERMINALS, /*goto*/ 0x06)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x0227, /*goto*/ 0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x022a, /*goto*/ 0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x021c, /*goto*/ 0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x021e, /*goto*/ 0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x0221, /*goto*/ 0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x0224, /*goto*/ 0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x023e, /*goto*/ 0x2f)
	endloop(0x04)
#else
	if_savefile_flag_is_unset(SAVEFILEFLAG_CI_TOUR_STARTED, /*goto*/ 0x04)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x04)
		if_savefile_flag_is_set(SAVEFILEFLAG_CI_TOUR_STARTED, /*goto*/ 0x06)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x0227, /*goto*/ 0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x022a, /*goto*/ 0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x021c, /*goto*/ 0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x021e, /*goto*/ 0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x0221, /*goto*/ 0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x0224, /*goto*/ 0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 250, 0x023e, /*goto*/ 0x2f)
	endloop(0x04)
#endif

	label(0x2f)
#if VERSION >= VERSION_PAL_FINAL
	set_savefile_flag(SAVEFILEFLAG_HOWTO_TERMINALS)
#endif
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(114)) // "TERMINALS - Press B Button next to terminal to use it."
	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1018_lightswitch[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_NIGHTVISION, FALSE, /*goto*/ 0x2f)
		if_chr_has_weapon_equipped(CHR_BOND, WEAPON_NIGHTVISION, /*goto*/ 0x2f)
		set_object_flag2(OBJ_LIGHTSWITCH, OBJFLAG2_INVISIBLE)
		reloop(0x04)

		label(0x2f)
		unset_object_flag2(OBJ_LIGHTSWITCH, OBJFLAG2_INVISIBLE)
	endloop(0x04)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101c_holo1_main[] = {
	label(0x80)
	hide_object(0x48)
	hide_object(0x49)
	hide_object(0x4a)
	hide_object(0x4b)
	hide_object(0x4c)
	hide_object(0x4d)
	hide_object(0x4e)
	hide_object(0x4f)

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO1, TRUE, /*goto*/ 0x81)
	endloop(0x08)

	label(0x81)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	restart_timer

	beginloop(0x13)
		if_timer_gt(30, /*goto*/ 0x2f)
	endloop(0x13)

	label(0x2f)
	lock_door(0x75, 0x40)
	lock_door(0x76, 0x40)
	close_door(0x75)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	if_chr_activated_object(CHR_BOND, 0x75, /*goto*/ 0x2f)
	if_chr_activated_object(CHR_BOND, 0x76, /*goto*/ 0x2f)
	label(0x2f)
	unset_stage_flag(STAGEFLAG_HOLO_ABORTING)
	unset_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	unset_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	unset_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	hide_object(0x45)
	show_object(0x48)
	show_object(0x49)
	show_object(0x4a)
	show_object(0x4b)
	show_object(0x4c)
	show_object(0x4d)
	show_object(0x4e)
	show_object(0x4f)
	unset_object_flag2(0x48, OBJFLAG2_00000001)
	unset_object_flag2(0x49, OBJFLAG2_00000001)
	unset_object_flag2(0x4a, OBJFLAG2_00000001)
	unset_object_flag2(0x4b, OBJFLAG2_00000001)
	unset_object_flag2(0x4c, OBJFLAG2_00000001)
	unset_object_flag2(0x4d, OBJFLAG2_00000001)
	unset_object_flag2(0x4e, OBJFLAG2_00000001)
	unset_object_flag2(0x4f, OBJFLAG2_00000001)
	hide_chr(0x04)
	dprint 't','r','a','i','n','i','n','g',0,
	label(0x91)
	if_object_flag2(0x4c, OBJFLAG2_00000001, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	if_object_flag2(0x4d, OBJFLAG2_00000001, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	if_object_flag2(0x4e, OBJFLAG2_00000001, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	if_object_flag2(0x4f, OBJFLAG2_00000001, /*goto*/ 0x2f)
	label(0x06)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(100)) // "Get the access codes by examining terminals. - Use the codes on the wall terminals."
	goto_next(0x06)

	label(0x2f)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(115)) // "Now activate the red terminals on the wall."
	label(0x06)
	restart_timer

	beginloop(0x82)
		if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x90)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_HOLO_SUCCESS, TRUE, /*goto*/ 0x83)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_HOLO_FAILURE, TRUE, /*goto*/ 0x85)
		if_chr_activated_object(CHR_BOND, 0x75, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x76, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(1200, /*goto*/ 0x2f)
	endloop(0x82)

	label(0x2f)
	goto_first(0x91)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	goto_next(0x84)

	label(0x83)
	set_savefile_flag(SAVEFILEFLAG_CI_HOLO1_DONE)
	dprint 'd','o','n','e',0,
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	yield
	goto_next(0x84)

	label(0x84)
	if_chr_in_room(CHR_BOND, 0x00, 0x001e, /*goto*/ 0x90)
	label(0x90)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	unlock_door(0x75, 0x40)
	unlock_door(0x76, 0x40)
	remove_hudmsgs
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_7)
	show_chr(0x04)
	dprint 'a','b','o','r','t','e','d',0,
	hide_object(0x48)
	hide_object(0x49)
	hide_object(0x4a)
	hide_object(0x4b)
	hide_object(0x4c)
	hide_object(0x4d)
	hide_object(0x4e)
	hide_object(0x4f)
	show_object(0x45)
	remove_hudmsgs
	goto_first(0x08)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define holo1_some_terminal(object, function) \
	beginloop(0x8f) \
		if_stage_flag_eq(STAGEFLAG_IN_HOLO1, TRUE, /*goto*/ 0x2f) \
	endloop(0x8f) \
 \
	label(0x2f) \
	set_object_image(object, 0x00, 0x12) \
	unset_object_flag2(object, OBJFLAG2_00040000) \
 \
	beginloop(0x04) \
		if_chr_activated_object(CHR_ANY, object, /*goto*/ 0x2f) \
		reloop(0x04) \
 \
		label(0x2f) \
		if_object_flag2(object, OBJFLAG2_00000001, /*goto*/ 0x2f) \
	endloop(0x04) \
 \
	label(0x2f) \
	set_object_image(object, 0x00, 0x13) \
	set_object_flag2(object, OBJFLAG2_00040000) \
	assign_sound(0x043a, CHANNEL_7) \
	control_sound_from_object(CHANNEL_7, object, TRUE) \
	set_returnlist(CHR_SELF, function) \
	set_ailist(CHR_SELF, AILIST_HOLO1_CHECK_DONE)



u8 func101d_holo1_switch1[] = {
	holo1_some_terminal(0x4c, AILIST_HOLO1_SWITCH1)
	endlist
};

u8 func101e_holo1_switch2[] = {
	holo1_some_terminal(0x4d, AILIST_HOLO1_SWITCH2)
	endlist
};

u8 func101f_holo1_switch3[] = {
	holo1_some_terminal(0x4e, AILIST_HOLO1_SWITCH3)
	endlist
};

u8 func1020_holo1_monitor_switches[] = {
	beginloop(0x8f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO1, TRUE, /*goto*/ 0x2f)
	endloop(0x8f)

	label(0x2f)
	set_object_image(0x4f, 0x00, 0x12)
	unset_object_flag2(0x4f, OBJFLAG2_00040000)

	beginloop(0x04)
		if_chr_activated_object(CHR_ANY, 0x4f, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x2f)
		if_object_flag2(0x4f, OBJFLAG2_00000001, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	set_object_image(0x4f, 0x00, 0x13)
	set_object_flag2(0x4f, OBJFLAG2_00040000)
	assign_sound(0x043a, CHANNEL_7)
	control_sound_from_object(CHANNEL_7, 0x4f, TRUE)
	set_returnlist(CHR_SELF, AILIST_HOLO1_MONITOR_SWITCHES)
	set_ailist(CHR_SELF, AILIST_HOLO1_CHECK_DONE)
	endlist
};

#define holo1_code_thing_p1(object1, object2, pad) \
	yield \
	yield \
	yield \
 \
	beginloop(0x04) \
		if_stage_flag_eq(STAGEFLAG_IN_HOLO1, TRUE, /*goto*/ 0x2f) \
		reloop(0x04) \
 \
		label(0x2f) \
		if_object_in_good_condition(object1, /*goto*/ 0x2f) \
		reloop(0x04) \
 \
		label(0x2f) \
		if_object_flag2(object1, OBJFLAG2_00000001, /*goto*/ 0x2f) \
		if_chr_distance_to_pad_lt(CHR_BOND, 400, pad, /*goto*/ 0x09) \
		label(0x2f) \
		if_chr_looking_at_object(CHR_BOND, object1, /*goto*/ 0x2f) \
	endloop(0x04) \
 \
	label(0x09)



#define holo1_code_thing_p2(object1, object2, hint, msg) \
	remove_hudmsgs \
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, hint) \
	goto_first(0x04) \
 \
	label(0x2f) \
	set_object_image(object2, 0x00, 0x12) \
	set_object_image(object1, 0x00, 0x13) \
	remove_hudmsgs \
	show_hudmsg(CHR_BOND, msg) \
	assign_sound(0x81b0, CHANNEL_7) \
	control_sound_from_object(CHANNEL_7, object1, TRUE) \
	restart_timer \
 \
	beginloop(0x57) \
		if_timer_gt(60, /*goto*/ 0x2f) \
	goto_first(0x57) \
 \
	label(0x2f) \
	set_object_flag2(object2, OBJFLAG2_00000001) \
 \
	beginloop(0x59) \
		if_stage_flag_eq(STAGEFLAG_TRIGGER_HOLO_SUCCESS, TRUE, /*goto*/ 0x2f) \
		if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x2f) \
		reloop(0x59) \
 \
		label(0x2f) \
		if_stage_flag_eq(STAGEFLAG_IN_HOLO1, FALSE, /*goto*/ 0x2f) \
	endloop(0x59) \
 \
	label(0x2f) \
	goto_first(0x8f)



u8 func1021_holo1_code1[] = {
	label(0x8f)
	set_object_image(0x48, 0x00, 0x12)
	unset_object_flag2(0x4c, OBJFLAG2_00000001)

	holo1_code_thing_p1(0x48, 0x4c, 0x0240)

	set_object_flag2(0x48, OBJFLAG2_00000001)
	set_object_flag2(0x4c, OBJFLAG2_00000001)

	// 0x1c55 = "LOOK UP - Press Down C Button to look up at the target."
	// 0x1c65 = "Code 1 has been obtained."
	holo1_code_thing_p2(0x48, 0x4c, 0x1c55, 0x1c65)

	endlist
};

u8 func1021_holo1_code2[] = {
	label(0x8f)
	set_object_image(0x49, 0x00, 0x12)
	unset_object_flag2(0x4d, OBJFLAG2_00000001)

	holo1_code_thing_p1(0x49, 0x4d, 0x0241)

	set_object_flag2(0x49, OBJFLAG2_00000001)

	// 0x1c56 = "LOOK DOWN - Press Up C Button to look down at the target."
	// 0x1c66 = "Code 2 has been obtained."
	holo1_code_thing_p2(0x49, 0x4d, 0x1c56, 0x1c66)
	endlist
};

u8 func1021_holo1_code3[] = {
	label(0x8f)
	unset_object_flag2(0x4e, OBJFLAG2_00000001)
	set_object_image(0x4a, 0x00, 0x12)

	holo1_code_thing_p1(0x4a, 0x4e, 0x0242)

	set_object_flag2(0x4a, OBJFLAG2_00000001)

	// 0x1c55 = "LOOK UP - Press Down C Button to look up at the target."
	// 0x1c67 = "Code 3 has been obtained."
	holo1_code_thing_p2(0x4a, 0x4e, 0x1c55, 0x1c67)
	endlist
};

u8 func1021_holo1_code4[] = {
	label(0x8f)
	unset_object_flag2(0x4f, OBJFLAG2_00000001)
	set_object_image(0x4b, 0x00, 0x12)

	holo1_code_thing_p1(0x4b, 0x4f, 0x0243)

	set_object_flag2(0x4b, OBJFLAG2_00000001)

	// 0x1c55 = "LOOK UP - Press Down C Button to look up at the target."
	// 0x1c68 = "Code 4 has been obtained."
	holo1_code_thing_p2(0x4b, 0x4f, 0x1c55, 0x1c68)
	endlist
};

u8 func0430_holo1_check_done[] = {
	label(0x04)
	yield
	if_object_flag2(0x4c, OBJFLAG2_00040000, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	dprint 'D','O','H','1',0,
	if_object_flag2(0x4d, OBJFLAG2_00040000, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	dprint 'D','O','H','2',0,
	if_object_flag2(0x4e, OBJFLAG2_00040000, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	dprint 'D','O','H','3',0,
	if_object_flag2(0x4f, OBJFLAG2_00040000, /*goto*/ 0x2f)
	goto_next(0x06)

	// All flags are set
	label(0x2f)
	dprint 'D','O','H','4',0,
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(106)) // "Holoprogram 1 has been completed successfully."
	restart_timer

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x2f)
	endloop(0x08)

	label(0x2f)
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)

	label(0x06)

	beginloop(0x57)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO1, FALSE, /*goto*/ 0x2f)
	endloop(0x57)

	label(0x2f)
	return

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1022_holo2_main[] = {
	label(0x80)
	hide_object(0x54)
	hide_object(0x55)
	hide_object(0x56)
	hide_object(0x57)

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO2, TRUE, /*goto*/ 0x81)
	endloop(0x08)

	label(0x81)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	restart_timer

	beginloop(0x13)
		if_timer_gt(30, /*goto*/ 0x2f)
	endloop(0x13)

	label(0x2f)
	lock_door(0x75, 0x40)
	lock_door(0x76, 0x40)
	close_door(0x75)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	if_chr_activated_object(CHR_BOND, 0x75, /*goto*/ 0x2f)
	if_chr_activated_object(CHR_BOND, 0x76, /*goto*/ 0x2f)
	label(0x2f)
	unset_object_flag2(0x54, OBJFLAG2_00000001)
	unset_object_flag2(0x55, OBJFLAG2_00000001)
	unset_object_flag2(0x56, OBJFLAG2_00000001)
	unset_object_flag2(0x57, OBJFLAG2_00000001)
	set_object_image(0x54, 0x00, 0x14)
	set_object_image(0x55, 0x00, 0x14)
	set_object_image(0x56, 0x00, 0x14)
	set_object_image(0x57, 0x00, 0x14)
	unset_stage_flag(STAGEFLAG_HOLO_ABORTING)
	unset_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	unset_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	unset_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	hide_object(0x45)
	show_object(0x54)
	show_object(0x55)
	show_object(0x56)
	show_object(0x57)
	hide_chr(0x04)
	dprint 't','r','a','i','n','i','n','g',0,
	label(0x2f)
	label(0x91)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(99)) // "Activate all of the wall switches. - Be quick, as they will quickly reset."
	restart_timer

	beginloop(0x82)
		if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x90)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_HOLO_FAILURE, TRUE, /*goto*/ 0x85)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_HOLO_SUCCESS, TRUE, /*goto*/ 0x83)
		if_chr_activated_object(CHR_BOND, 0x75, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x76, /*goto*/ 0x57)
		goto_next(0x59)
		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(1200, /*goto*/ 0x2f)
	endloop(0x82)

	label(0x2f)
	goto_first(0x91)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	goto_next(0x90)

	label(0x83)
	set_savefile_flag(SAVEFILEFLAG_CI_HOLO2_DONE)
	dprint 'd','o','n','e',0,
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	yield
	goto_next(0x84)

	label(0x84)
	remove_hudmsgs
	label(0x90)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	unlock_door(0x75, 0x40)
	unlock_door(0x76, 0x40)
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_7)
	show_chr(0x04)
	dprint 'a','b','o','r','t','e','d',0,
	hide_object(0x54)
	hide_object(0x55)
	hide_object(0x56)
	hide_object(0x57)
	show_object(0x45)
	restart_timer

	beginloop(0x09)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	remove_hudmsgs
	goto_first(0x08)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define holo2_do_thing(object, function) \
	restart_timer \
	beginloop(0x04) \
		if_chr_activated_object(CHR_ANY, object, /*goto*/ 0x2f) \
		if_object_flag2(object, OBJFLAG2_00000001, /*goto*/ 0x06) \
		reloop(0x04) \
 \
		label(0x06) \
		if_timer_gt(300, /*goto*/ 0x06) \
		reloop(0x04) \
 \
		label(0x06) \
		set_object_image(object, 0x00, 0x14) \
		unset_object_flag2(object, OBJFLAG2_00000001) \
	endloop(0x04) \
 \
	label(0x2f) \
	assign_sound(0x043a, CHANNEL_7) \
	control_sound_from_object(CHANNEL_7, object, TRUE) \
	set_object_image(object, 0x00, 0x13) \
	set_object_flag2(object, OBJFLAG2_00000001) \
	set_returnlist(CHR_SELF, function) \
	set_ailist(CHR_SELF, 0x041b)



u8 func1023_holo2_object1[] = {
	holo2_do_thing(0x54, 0x0431)
	endlist
};

u8 func1024_holo2_object2[] = {
	holo2_do_thing(0x55, 0x0432)
	endlist
};

u8 func1025_holo2_object3[] = {
	holo2_do_thing(0x56, 0x0433)
	endlist
};

u8 func1026_holo2_object4[] = {
	holo2_do_thing(0x57, 0x0434)
	endlist
};

u8 func041b_holo2_part1[] = {
	beginloop(0x8f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO2, TRUE, /*goto*/ 0x04)
	endloop(0x8f)

	label(0x04)
	yield
	if_object_flag2(0x54, OBJFLAG2_00000001, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	if_object_flag2(0x55, OBJFLAG2_00000001, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	if_object_flag2(0x56, OBJFLAG2_00000001, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	if_object_flag2(0x57, OBJFLAG2_00000001, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(87)) // "Holoprogram 2 has been completed successfully."
	restart_timer

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x2f)
	endloop(0x08)

	label(0x2f)
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	label(0x06)
	return
	endlist
};

u8 func042f_holo2_part2[] = {
	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO2, TRUE, /*goto*/ 0x04)
	endloop(0x08)

	beginloop(0x04)
		if_player_looking_at_something_maybe(0x14, 0x01, 0x00, /*goto*/ 0x06)
		goto_next(0x2f)

		label(0x06)
	endloop(0x04)

	label(0x2f)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x09)
	set_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	set_stage_flag(STAGEFLAG_HOLO_FAILED)
	restart_timer
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(105)) // "Training failed - you must face forward."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	set_object_image(0x54, 0x00, 0x12)
	set_object_image(0x55, 0x00, 0x12)
	set_object_image(0x56, 0x00, 0x12)
	set_object_image(0x57, 0x00, 0x12)

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x2f)
	endloop(0x08)

	label(0x2f)
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)

	beginloop(0x09)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO2, FALSE, /*goto*/ 0x2f)
	endloop(0x09)

	label(0x2f)
	goto_first(0x08)

	endlist
};

u8 func1027_holo3_main[] = {
	label(0x80)
	hide_object(0x58)
	hide_object(0x59)
	hide_object(0x5a)
	hide_object(0x5b)
	hide_object(0x5c)
	hide_object(0x5d)
	hide_object(0x5e)
	hide_object(0x5f)
	hide_object(0x60)
	hide_object(0x61)
	hide_object(0x62)
	hide_object(0x63)
	hide_object(0x64)
	hide_object(0x73)
	hide_object(0x74)
	hide_object(0x65)
	hide_object(0x66)
	hide_object(0x67)
	hide_object(0x68)
	hide_object(0x69)
	hide_object(0x6a)
	hide_object(0x6b)
	hide_object(0x6c)
	hide_object(0x6d)
	hide_object(0x6e)
	hide_object(0x6f)
	hide_object(0x70)
	hide_object(0x71)
	hide_object(0x72)

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO3, TRUE, /*goto*/ 0x81)
	endloop(0x08)

	label(0x81)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	restart_timer

	beginloop(0x13)
		if_timer_gt(30, /*goto*/ 0x2f)
	endloop(0x13)

	label(0x2f)
	lock_door(0x75, 0x40)
	lock_door(0x76, 0x40)
	close_door(0x75)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	if_chr_activated_object(CHR_BOND, 0x75, /*goto*/ 0x2f)
	if_chr_activated_object(CHR_BOND, 0x76, /*goto*/ 0x2f)
	label(0x2f)
	unset_object_flag2(0x65, OBJFLAG2_00000001)
	unset_object_flag2(0x66, OBJFLAG2_00000001)
	set_object_image(0x65, 0x00, 0x14)
	set_object_image(0x66, 0x00, 0x14)
	unset_stage_flag(STAGEFLAG_HOLO_ABORTING)
	unset_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	unset_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	unset_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	hide_object(0x45)
	show_object(0x58)
	show_object(0x59)
	show_object(0x5a)
	show_object(0x5b)
	show_object(0x5c)
	show_object(0x5d)
	show_object(0x5e)
	show_object(0x5f)
	show_object(0x60)
	show_object(0x61)
	show_object(0x62)
	show_object(0x63)
	show_object(0x64)
	show_object(0x73)
	show_object(0x74)
	show_object(0x65)
	show_object(0x66)
	show_object(0x67)
	show_object(0x68)
	show_object(0x69)
	show_object(0x6a)
	show_object(0x6b)
	show_object(0x6c)
	show_object(0x6d)
	show_object(0x6e)
	show_object(0x6f)
	show_object(0x70)
	show_object(0x71)
	show_object(0x72)
	hide_chr(0x04)
	open_door(0x67)
	open_door(0x68)
	open_door(0x69)
	open_door(0x6a)
	open_door(0x6b)
	open_door(0x6c)
	open_door(0x6d)
	open_door(0x6e)
	open_door(0x6f)
	open_door(0x70)
	open_door(0x71)
	open_door(0x72)
	yield
	close_door(0x67)
	close_door(0x68)
	close_door(0x69)
	close_door(0x6a)
	close_door(0x6b)
	close_door(0x6c)
	close_door(0x6d)
	close_door(0x6e)
	close_door(0x6f)
	close_door(0x70)
	close_door(0x71)
	close_door(0x72)
	dprint 't','r','a','i','n','i','n','g',0,
	label(0x2f)
	label(0x91)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(98)) // "Activate all the switches."
	restart_timer

	beginloop(0x82)
		if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x90)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_HOLO_FAILURE, TRUE, /*goto*/ 0x85)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_HOLO_SUCCESS, TRUE, /*goto*/ 0x83)
		if_chr_activated_object(CHR_BOND, 0x75, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x76, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(1200, /*goto*/ 0x2f)
	endloop(0x82)

	label(0x2f)
	goto_first(0x91)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	goto_next(0x84)

	label(0x83)
	set_savefile_flag(SAVEFILEFLAG_CI_HOLO3_DONE)
	dprint 'd','o','n','e',0,
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	yield
	goto_next(0x84)

	label(0x84)
	label(0x90)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	unlock_door(0x75, 0x40)
	unlock_door(0x76, 0x40)
	remove_hudmsgs
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_7)
	show_chr(0x04)
	dprint 'a','b','o','r','t','e','d',0,
	hide_object(0x58)
	hide_object(0x59)
	hide_object(0x5a)
	hide_object(0x5b)
	hide_object(0x5c)
	hide_object(0x5d)
	hide_object(0x5e)
	hide_object(0x5f)
	hide_object(0x60)
	hide_object(0x61)
	hide_object(0x62)
	hide_object(0x63)
	hide_object(0x64)
	hide_object(0x73)
	hide_object(0x74)
	hide_object(0x65)
	hide_object(0x66)
	hide_object(0x67)
	hide_object(0x68)
	hide_object(0x69)
	hide_object(0x6a)
	hide_object(0x6b)
	hide_object(0x6c)
	hide_object(0x6d)
	hide_object(0x6e)
	hide_object(0x6f)
	hide_object(0x70)
	hide_object(0x71)
	hide_object(0x72)
	show_object(0x45)
	restart_timer

	beginloop(0x09)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	remove_hudmsgs
	goto_first(0x08)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102a_holo3_part1[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO3, TRUE, /*goto*/ 0x2f)
	reloop(0x04)

		label(0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 300, 0x0123, /*goto*/ 0x09)
	endloop(0x04)

	label(0x09)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x06)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(95)) // "DUCK - Hold R Button, then press Down C Button to duck."
	restart_timer

	beginloop(0x0a)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	goto_first(0x04)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102b_holo3_part2[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO3, TRUE, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x2f)
		if_chr_distance_to_pad_lt(CHR_BOND, 300, 0x0124, /*goto*/ 0x09)
	endloop(0x04)

	label(0x09)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x06)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(96)) // "CROUCH - When ducking, hold R Button, then press Down C Button to duck."
	restart_timer

	beginloop(0x0a)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	goto_first(0x04)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102c_holo3_object1[] = {
	beginloop(0x04)
		if_chr_activated_object(CHR_ANY, 0x65, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	assign_sound(0x043a, CHANNEL_7)
	control_sound_from_object(CHANNEL_7, 0x65, TRUE)
	set_object_image(0x65, 0x00, 0x13)
	set_object_flag2(0x65, OBJFLAG2_00000001)
	set_returnlist(CHR_SELF, AILIST_HOLO3_OBJECT1)
	set_ailist(CHR_SELF, AILIST_HOLO3_CHECK_DONE)
	endlist
};

u8 func102d_holo3_object2[] = {
	beginloop(0x04)
		if_chr_activated_object(CHR_ANY, 0x66, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	assign_sound(0x043a, CHANNEL_7)
	control_sound_from_object(CHANNEL_7, 0x65, TRUE)
	set_object_image(0x66, 0x00, 0x13)
	set_object_flag2(0x66, OBJFLAG2_00000001)
	set_returnlist(CHR_SELF, AILIST_HOLO3_OBJECT2)
	set_ailist(CHR_SELF, AILIST_HOLO3_CHECK_DONE)
	endlist
};

u8 func041c_holo3_check_done[] = {
	label(0x04)
	yield
	if_object_flag2(0x65, OBJFLAG2_00000001, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	if_object_flag2(0x66, OBJFLAG2_00000001, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x06)
	set_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(97)) // "Holoprogram 3 has been completed successfully."
	restart_timer

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x2f)
	endloop(0x08)

	label(0x2f)
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	label(0x06)
	return
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1028_holo4_main[] = {
	label(0x80)

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO4, TRUE, /*goto*/ 0x81)
	endloop(0x08)

	label(0x81)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	lock_door(0x75, 0x40)
	lock_door(0x76, 0x40)
	close_door(0x75)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	if_chr_activated_object(CHR_BOND, 0x75, /*goto*/ 0x2f)
	if_chr_activated_object(CHR_BOND, 0x76, /*goto*/ 0x2f)
	label(0x2f)
	unset_stage_flag(STAGEFLAG_HOLO_ABORTING)
	unset_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	unset_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	unset_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	hide_object(0x45)
	hide_chr(0x04)
	try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x0274, AILIST_HOLO4_GUARD1, 0x00002210, /*goto*/ 0x08)
	label(0x08)
	dprint 't','r','a','i','n','i','n','g',0,
	label(0x91)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x2f)
	remove_hudmsgs
	if_chr_has_chrflag(0x0d, CHRCFLAG_00000040, /*goto*/ 0x61)
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(107)) // "Unarmed combat - knock out the target. - Press Z Button repeatedly to punch."
	goto_next(0x2f)

	label(0x61)
	if_chr_has_chrflag(0x0e, CHRCFLAG_00000040, /*goto*/ 0x62)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(108)) // "Now try against a moving target..."
	goto_next(0x2f)

	label(0x62)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(109)) // "And finally against a target that fights back."
	goto_next(0x2f)

	label(0x2f)
	restart_timer

	beginloop(0x82)
		if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x90)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_HOLO_FAILURE, TRUE, /*goto*/ 0x85)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_HOLO_SUCCESS, TRUE, /*goto*/ 0x83)
		if_chr_activated_object(CHR_BOND, 0x75, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x76, /*goto*/ 0x57)
		goto_next(0x59)
		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(1200, /*goto*/ 0x2f)
	endloop(0x82)

	label(0x2f)
	goto_first(0x91)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	goto_next(0x84)

	label(0x83)
	set_savefile_flag(SAVEFILEFLAG_CI_HOLO4_DONE)
	dprint 'd','o','n','e',0,
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	yield
	goto_next(0x84)
	label(0x84)
	label(0x90)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	unlock_door(0x75, 0x40)
	unlock_door(0x76, 0x40)
	remove_hudmsgs
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_7)
	show_chr(0x04)
	remove_chr(0x0d)
	remove_chr(0x0e)
	remove_chr(0x0f)
	dprint 'a','b','o','r','t','e','d',0,
	show_object(0x45)
	label(0x06)
	remove_hudmsgs

	beginloop(0x6d)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO4, FALSE, /*goto*/ 0x2f)
	endloop(0x6d)

	label(0x2f)
	goto_first(0x08)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0403_holo4_guard1[] = {
	set_chr_id(0x0d)
	set_shotlist(AILIST_HOLO4_GUARD1)

	beginloop(0x04)
		if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2f)
		if_chr_dying(CHR_SELF, /*goto*/ 0x2f)
		if_chr_unloaded(CHR_SELF, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	set_self_chrflag(CHRCFLAG_00000040)
	try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x0277, AILIST_HOLO4_GUARD2, 0x00002210, /*goto*/ 0x08)
	label(0x08)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(108)) // "Now try against a moving target..."
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0404_holo4_guard2[] = {
	set_chr_id(0x0e)
	set_shotlist(AILIST_HOLO4_GUARD2)
	label(0x04)
	yield
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2f)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2f)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	set_self_chrflag(CHRCFLAG_00000040)
	try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x027a, AILIST_HOLO4_GUARD3, 0x00002210, /*goto*/ 0x0a)
	label(0x0a)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(109)) // "And finally against a target that fights back."
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x06)
	if_distance_to_target_lt(500, /*goto*/ 0x2f)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x08)

	beginloop(0x08)
		if_distance_to_target_lt(500, /*goto*/ 0x2f)
	endloop(0x08)

	label(0x2f)
	restart_timer
	retreat(SPEED_RUN, 1)

	beginloop(0x09)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	goto_first(0x04)

	endlist
};

u8 func0405_holo4_guard3[] = {
	set_chr_id(0x0f)
	set_shotlist(AILIST_HOLO4_GUARD3)
	restart_timer

	beginloop(0x04)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_ailist(CHR_SELF, AILIST_HOLO_GUARD_UNARMED_UNALERT)
	endlist
};

u8 func1033_holo4_part1[] = {
	beginloop(0x8f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO4, TRUE, /*goto*/ 0x04)
	endloop(0x8f)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x57)
		if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x57)
		if_chr_death_animation_finished(0x0d, /*goto*/ 0x2f)
		if_chr_dying(0x0d, /*goto*/ 0x2f)
		if_chr_unloaded(0x0d, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	yield
	yield
	yield
	yield
	yield
	if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x57)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x57)
	if_chr_death_animation_finished(0x0e, /*goto*/ 0x2f)
	if_chr_dying(0x0e, /*goto*/ 0x2f)
	if_chr_unloaded(0x0e, /*goto*/ 0x2f)
	goto_first(0x04)

	label(0x2f)
	yield
	yield
	yield
	yield
	yield
	if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x57)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x57)
	if_chr_death_animation_finished(0x0f, /*goto*/ 0x2f)
	if_chr_dying(0x0f, /*goto*/ 0x2f)
	if_chr_unloaded(0x0f, /*goto*/ 0x2f)
	goto_first(0x04)

	label(0x2f)
	restart_timer
	set_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(88)) // "Holoprogram 4 has been completed successfully."

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x57)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)

	beginloop(0x57)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO4, FALSE, /*goto*/ 0x2f)
	endloop(0x57)

	label(0x2f)
	goto_first(0x8f)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1029_holo5_main[] = {
	label(0x80)

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO5, TRUE, /*goto*/ 0x81)
	endloop(0x08)

	label(0x81)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	lock_door(0x75, 0x40)
	lock_door(0x76, 0x40)
	close_door(0x75)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	if_chr_activated_object(CHR_BOND, 0x75, /*goto*/ 0x2f)
	if_chr_activated_object(CHR_BOND, 0x76, /*goto*/ 0x2f)
	label(0x2f)
	unset_stage_flag(STAGEFLAG_HOLO_ABORTING)
	unset_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	unset_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	unset_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	hide_object(0x45)
	hide_chr(0x04)
	try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x0126, AILIST_HOLO5_INIT_GUARD1, 0x00002210, /*goto*/ 0x06)
	label(0x06)
	yield
	dprint 't','r','a','i','n','i','n','g',0,
	label(0x91)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x2f)
	remove_hudmsgs
	if_chr_has_chrflag(0x10, CHRCFLAG_00000040, /*goto*/ 0x61)
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(92)) // "Disarm this live target if you can."
	goto_next(0x2f)

	label(0x61)
	if_chr_has_chrflag(0x11, CHRCFLAG_00000040, /*goto*/ 0x62)
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(93)) // "Knock out this target - stealth is the key."
	goto_next(0x2f)

	label(0x62)
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(94)) // "And the final guard..."
	goto_next(0x2f)

	label(0x2f)
	restart_timer

	beginloop(0x82)
		if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x90)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_HOLO_FAILURE, TRUE, /*goto*/ 0x85)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_HOLO_SUCCESS, TRUE, /*goto*/ 0x83)
		if_chr_activated_object(CHR_BOND, 0x75, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x76, /*goto*/ 0x57)
		goto_next(0x59)
		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(1200, /*goto*/ 0x2f)
	endloop(0x82)

	label(0x2f)
	goto_first(0x91)

	label(0x2f)
	goto_first(0x82)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	goto_next(0x84)

	label(0x83)
	set_savefile_flag(SAVEFILEFLAG_CI_HOLO5_DONE)
	dprint 'd','o','n','e',0,
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	yield
	goto_next(0x84)

	label(0x84)
	label(0x90)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	unlock_door(0x75, 0x40)
	unlock_door(0x76, 0x40)
	remove_hudmsgs
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_7)
	show_chr(0x04)
	remove_chr(0x10)
	remove_chr(0x11)
	remove_chr(0x12)
	dprint 'a','b','o','r','t','e','d',0,
	show_object(0x45)
	remove_hudmsgs

	beginloop(0x6d)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO5, FALSE, /*goto*/ 0x2f)
	endloop(0x6d)

	label(0x2f)
	goto_first(0x08)

	endlist
};

u8 func0406_holo5_init_guard1[] = {
	set_alertness(100)
	set_chr_id(0x10)
	try_equip_weapon(MODEL_CHRFALCON2, WEAPON_FALCON2, 0x40000000, /*goto*/ 0x06)
	label(0x06)
	set_ailist(CHR_SELF, AILIST_HOLO5_GUARD1)
	endlist
};

u8 func0407_holo5_guard1[] = {
	set_self_flag_bankx(CHRFLAG0_80000000, BANK_0)
	dprint 'C','R','E','A','T','E','D',' ','4',0,
	set_shotlist(AILIST_HOLO5_GUARD1)
	set_chr_maxdamage(CHR_SELF, 300)
	add_health_or_armor(300)
	label(0x04)
	yield
	label(0x2f)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x30)
	if_chr_dying(CHR_SELF, /*goto*/ 0x30)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x30)
	if_has_gun(CHR_SELF, /*goto*/ 0x06)
	label(0x2f)
	set_self_flag_bankx(CHRFLAG0_00008000, BANK_0)
	set_self_chrflag(CHRCFLAG_00000040)
	set_shotlist(GAILIST_IDLE)
	goto_next(0x0a)
	label(0x30)
	restart_timer
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)

	beginloop(0x62)
		if_timer_gt(60, /*goto*/ 0x63)
	endloop(0x62)

	label(0x63)
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	set_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x0a)
	set_self_chrflag(CHRCFLAG_00000040)
	set_self_flag_bankx(CHRFLAG0_00008000, BANK_0)
	surrender
	show_hudmsg(CHR_BOND, L_DISH(90)) // "Guard has been successfully disarmed."

	beginloop(0x59)
		try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x0272, AILIST_HOLO5_INIT_GUARD2, 0x00002210, /*goto*/ 0x2f)
	endloop(0x59)

	label(0x2f)
	set_shotlist(GAILIST_IDLE)

	beginloop(0x0b)
	endloop(0x0b)

	label(0x06)
	if_distance_to_target_lt(300, /*goto*/ 0x2f)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x08)

	beginloop(0x08)
		if_distance_to_target_lt(300, /*goto*/ 0x2f)
	endloop(0x08)

	label(0x2f)
	restart_timer
	retreat(SPEED_RUN, 1)

	beginloop(0x09)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	goto_first(0x04)

	endlist
};

u8 func0408_holo5_init_guard2[] = {
	set_chr_maxdamage(CHR_SELF, 200)
	set_alertness(100)
	set_chr_id(0x11)
	try_equip_weapon(MODEL_CHRFALCON2, WEAPON_FALCON2, 0x40000000, /*goto*/ 0x06)
	label(0x06)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(93)) // "Knock out this target - stealth is the key."
	set_ailist(CHR_SELF, AILIST_HOLO5_GUARD2)
	endlist
};

u8 func0409_holo5_guard2[] = {
	dprint 'C','R','E','A','T','E','D',' ','5',0,
	set_shotlist(AILIST_HOLO5_GUARD2)
	label(0x04)
	yield
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2f)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2f)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2f)
	restart_timer
	assign_path(0)
	start_path
	label(0x08)
	yield
	dprint 'O','n',' ','P','a','t','r','o','l',0,
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2f)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2f)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2f)
	if_target_in_sight(/*goto*/ 0x09)
	unset_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_alertness(0)
	goto_first(0x08)

	label(0x06)
	label(0x09)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x0a)

	beginloop(0x0a)
		if_chr_sees_player(/*goto*/ 0x06)
		goto_first(0x04)

		label(0x06)
	endloop(0x0a)

	label(0x2f)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_00000040)

	beginloop(0x57)
		try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x0125, AILIST_HOLO5_INIT_GUARD3, 0x00002210, /*goto*/ 0x06)
	endloop(0x57)

	label(0x06)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040a_holo5_init_guard3[] = {
	set_reaction_speed(100)
	set_chr_id(0x12)
	try_equip_weapon(MODEL_CHRFALCON2, WEAPON_FALCON2, 0x40000000, /*goto*/ 0x06)
	label(0x06)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(94)) // "And the final guard..."
	set_alertness(100)
	set_ailist(CHR_SELF, AILIST_HOLO5_GUARD3)
	endlist
};

u8 func040b_holo5_guard3[] = {
	dprint 'C','R','E','A','T','E','D',' ','6',0,
	set_shotlist(AILIST_HOLO_GUARD_ARMED_UNALERT)
	restart_timer

	beginloop(0x08)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	set_ailist(CHR_SELF, AILIST_HOLO_GUARD_ARMED_UNALERT)

	beginloop(0x04)
		if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2f)
		if_chr_dying(CHR_SELF, /*goto*/ 0x2f)
		if_chr_unloaded(CHR_SELF, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	restart_timer
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(89)) // "Holoprogram 5 has been completed successfully."

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1034_holo5_part1[] = {
	beginloop(0x8f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO5, TRUE, /*goto*/ 0x2f)
	endloop(0x8f)

	label(0x2f)
	yield
	yield
	yield
	yield

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0d)
		if_chr_has_flag_bankx(0x10, CHRFLAG0_00008000, BANK_0, /*goto*/ 0x2f)
		dprint 'C','H','R',' ','4','F','D',0,
		label(0x06)
	endloop(0x04)

	label(0x2f)
	yield
	yield
	yield
	yield
	if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x0d)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0d)
	if_chr_death_animation_finished(0x11, /*goto*/ 0x2f)
	if_chr_dying(0x11, /*goto*/ 0x2f)
	if_chr_unloaded(0x11, /*goto*/ 0x2f)
	goto_first(0x04)

	label(0x2f)
	dprint 'C','H','R',' ','5','F','D',0,
	yield
	yield
	yield
	yield
	if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x0d)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0d)
	if_chr_death_animation_finished(0x12, /*goto*/ 0x2f)
	if_chr_dying(0x12, /*goto*/ 0x2f)
	if_chr_unloaded(0x12, /*goto*/ 0x2f)
	goto_first(0x04)

	label(0x2f)
	dprint 'C','H','R',' ','6','F','D',0,
	restart_timer
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0d)
	set_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(89)) // "Holoprogram 5 has been completed successfully."

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x0d)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)

	beginloop(0x0d)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO5, FALSE, /*goto*/ 0x2f)
	endloop(0x0d)

	label(0x2f)
	goto_first(0x8f)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102e_holo6_main[] = {
	label(0x80)

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO6, TRUE, /*goto*/ 0x81)
	endloop(0x08)

	label(0x81)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	lock_door(0x75, 0x40)
	lock_door(0x76, 0x40)
	close_door(0x75)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	if_chr_activated_object(CHR_BOND, 0x75, /*goto*/ 0x2f)
	if_chr_activated_object(CHR_BOND, 0x76, /*goto*/ 0x2f)
	label(0x2f)
	unset_stage_flag(STAGEFLAG_HOLO_ABORTING)
	unset_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	unset_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	unset_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	hide_object(0x45)
	hide_chr(0x04)

	beginloop(0x57)
		try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x0127, AILIST_HOLO6_INIT_GUARD1, 0x00002210, /*goto*/ 0x59)
	endloop(0x57)

	beginloop(0x59)
		try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x0128, AILIST_HOLO6_INIT_GUARD2, 0x00002210, /*goto*/ 0x5b)
	endloop(0x59)

	beginloop(0x5b)
		try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x0129, AILIST_HOLO6_INIT_GUARD3, 0x00002210, /*goto*/ 0x5c)
	endloop(0x5b)

	beginloop(0x5c)
		try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x012a, AILIST_HOLO6_INIT_GUARD4, 0x00002210, /*goto*/ 0x5d)
	endloop(0x5c)

	label(0x5d)
	dprint 't','r','a','i','n','i','n','g',0,
	label(0x2f)
	label(0x91)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x2f)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(110)) // "Defeat all enemies without getting hit."
	label(0x2f)
	restart_timer

	beginloop(0x82)
		if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x90)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_HOLO_FAILURE, TRUE, /*goto*/ 0x85)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_HOLO_SUCCESS, TRUE, /*goto*/ 0x83)
		if_chr_activated_object(CHR_BOND, 0x75, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x76, /*goto*/ 0x57)
		goto_next(0x59)
		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(1200, /*goto*/ 0x2f)
	endloop(0x82)

	label(0x2f)
	goto_first(0x91)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	goto_next(0x84)

	label(0x83)
	set_savefile_flag(SAVEFILEFLAG_CI_HOLO6_DONE)
	dprint 'd','o','n','e',0,
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	yield
	goto_next(0x84)

	label(0x84)
	label(0x90)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	unlock_door(0x75, 0x40)
	unlock_door(0x76, 0x40)
	remove_hudmsgs
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_7)
	show_chr(0x04)
	remove_chr(0x13)
	remove_chr(0x14)
	remove_chr(0x15)
	remove_chr(0x16)
	dprint 'a','b','o','r','t','e','d',0,
	show_object(0x45)
	label(0x06)
	remove_hudmsgs

	beginloop(0x6d)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO6, FALSE, /*goto*/ 0x2f)
	endloop(0x6d)

	label(0x2f)
	goto_first(0x08)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040c_holo6_init_guard1[] = {
	set_chr_id(0x13)
	set_ailist(CHR_SELF, AILIST_HOLO_GUARD_UNARMED_UNALERT)
	endlist
};

u8 func040d_holo6_init_guard2[] = {
	set_chr_id(0x14)
	set_ailist(CHR_SELF, AILIST_HOLO_GUARD_UNARMED_UNALERT)
	endlist
};

u8 func040e_holo6_init_guard3[] = {
	set_chr_id(0x15)
	set_ailist(CHR_SELF, AILIST_HOLO_GUARD_UNARMED_UNALERT)
	endlist
};

u8 func040f_holo6_init_guard4[] = {
	set_chr_id(0x16)
	set_ailist(CHR_SELF, AILIST_HOLO_GUARD_UNARMED_UNALERT)
	endlist
};

u8 func0415_holo_guard_unarmed_unalert[] = {
	set_alertness(100)
	set_chr_maxdamage(CHR_SELF, 100)
	yield
	yield
	yield
	rebuild_teams
	rebuild_squadrons
	yield
	yield
	yield
	yield
	set_action(MA_NORMAL, FALSE)
	set_shotlist(AILIST_HOLO_GUARD_UNARMED_ALERT)
	restart_timer

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x04)
		if_player_looking_at_something_maybe(0x28, 0x01, 0x00, /*goto*/ 0x04)
	endloop(0x08)

	beginloop(0x04)
		if_distance_to_target_lt(500, /*goto*/ 0x06)
		call_rng
		if_rand_lt(1, /*goto*/ 0x06)
		label(0x2f)
	endloop(0x04)

	label(0x06)
	set_ailist(CHR_SELF, AILIST_HOLO_GUARD_UNARMED_ALERT)
	endlist
};

u8 func0416_holo_guard_unarmed_alert[] = {
	set_shotlist(AILIST_HOLO_GUARD_UNARMED_ALERT)
	set_action(MA_UNARMEDATTACK, FALSE)
	if_chr_injured_target(CHR_SELF, /*goto*/ 0x09)
	label(0x8f)
	restart_timer
	try_run_to_target(/*goto*/ 0x08)

	beginloop(0x08)
		if_chr_stopped(/*goto*/ 0x06)
		if_distance_to_target_lt(300, /*goto*/ 0x2f)
		if_timer_gt(15, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	goto_first(0x8f)

	label(0x2f)
	set_returnlist(CHR_SELF, AILIST_HOLO_GUARD_UNARMED_ALERT)
	set_ailist(CHR_SELF, AILIST_HOLO_GUARD_UNARMED_ALERT2)

	label(0x09)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0a)
	set_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	set_stage_flag(STAGEFLAG_HOLO_FAILED)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(111)) // "Training failed - you have been hit."
	restart_timer
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x5e)
		if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x2f)
		if_timer_gt(180, /*goto*/ 0x2f)
	endloop(0x5e)

	label(0x2f)
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	label(0x0a)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0416_holo_guard_unarmed_alert2[] = {
	set_action(MA_UNARMEDATTACK, FALSE)
	restart_timer

	beginloop(0x04)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x57)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x57)
		if_distance_to_target_gt(100, /*goto*/ 0x2f)
		if_in_disarm_range(/*goto*/ 0x2f)
		if_timer_gt(120, /*goto*/ 0x10)
	endloop(0x04)

	label(0x2f)
	if_distance_to_target_gt(400, /*goto*/ 0x10)
	if_distance_to_target_lt(100, /*goto*/ 0x06)
	restart_timer
	try_run_to_target(/*goto*/ 0x08)

	beginloop(0x08)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x57)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x57)
		if_timer_gt(20, /*goto*/ 0x10)
		if_chr_stopped(/*goto*/ 0x10)
		if_target_is_player(/*goto*/ 0x0e)
		label(0x0e)
		if_distance_to_target_gt(400, /*goto*/ 0x10)
		if_distance_to_target_lt(100, /*goto*/ 0x06)
	endloop(0x08)

	label(0x2f)
	restart_timer
	goto_first(0x04)

	label(0x06)
	restart_timer
	if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
	if_jo_ccw_direction_gt(246, /*goto*/ 0x06)
	stop_chr
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x57)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x57)
		if_distance_to_target_gt(400, /*goto*/ 0x10)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_jo_ccw_direction_gt(246, /*goto*/ 0x06)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x09)

	label(0x2f)
	restart_timer
	goto_first(0x04)

	label(0x06)
	try_punch_or_kick(/*goto*/ 0x2f)
	restart_timer
	goto_first(0x04)

	label(0x2f)

	beginloop(0x0a)
		if_timer_gt(180, /*goto*/ 0x06)
		if_chr_injured_target(CHR_SELF, /*goto*/ 0x2f)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	if_chr_injured_target(CHR_SELF, /*goto*/ 0x2f)
	say_quip(CHR_BOND, 0x16, 0x19, 0x03, 0x00, BANK_0, 0x00, 0x00)
	say_quip(CHR_BOND, 0x17, 0x19, 0x03, 0x01, BANK_0, 0x00, 0x00)
	goto_next(0x06)

	label(0x2f)
	say_quip(CHR_BOND, 0x15, 0x19, 0x02, 0x00, BANK_0, 0x00, 0x00)
	say_quip(CHR_BOND, 0x15, 0x19, 0x03, 0x01, BANK_0, 0x00, 0x00)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0f)
	set_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	set_stage_flag(STAGEFLAG_HOLO_FAILED)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(111)) // "Training failed - you have been hit."
	restart_timer
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x5e)
		if_timer_gt(180, /*goto*/ 0x2f)
	endloop(0x5e)

	label(0x2f)
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	label(0x0f)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	label(0x57)
	label(0x10)
	return
	endlist
};

u8 func041a_handle_holo_failure[] = {
	beginloop(0x8f)
		if_stage_flag_eq(STAGEFLAG_HOLO_FAILED, TRUE, /*goto*/ 0x2f)
	endloop(0x8f)

	label(0x2f)
	restart_timer

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x2f)
		if_timer_gt(180, /*goto*/ 0x2f)
	endloop(0x08)

	label(0x2f)
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	label(0x09)
	unset_stage_flag(STAGEFLAG_HOLO_FAILED)
	goto_first(0x8f)

	endlist
};

u8 func102f_holo1_part1[] = {
	beginloop(0x8f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO6, TRUE, /*goto*/ 0x04)
	endloop(0x8f)

	beginloop(0x04)
		yield
		yield
		yield
		dprint 'N','O',' ','D','E','A','D',0,
		if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x0d)
		if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0d)
		if_chr_dying(0x13, /*goto*/ 0x2f)
		if_chr_death_animation_finished(0x13, /*goto*/ 0x2f)
		if_chr_unloaded(0x13, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	yield
	yield
	yield
	yield
	dprint 'C','H','R',' ','7','F','D',0,
	if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x0d)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0d)
	if_chr_dying(0x14, /*goto*/ 0x2f)
	if_chr_death_animation_finished(0x14, /*goto*/ 0x2f)
	if_chr_unloaded(0x14, /*goto*/ 0x2f)
	goto_first(0x04)

	label(0x2f)
	yield
	yield
	yield
	yield
	dprint 'C','H','R',' ','8','F','D',0,
	if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x0d)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0d)
	if_chr_dying(0x15, /*goto*/ 0x2f)
	if_chr_death_animation_finished(0x15, /*goto*/ 0x2f)
	if_chr_unloaded(0x15, /*goto*/ 0x2f)
	goto_first(0x04)

	label(0x2f)
	yield
	yield
	yield
	yield
	dprint 'C','H','R',' ','9','F','D',0,
	if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x0d)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0d)
	if_chr_dying(0x16, /*goto*/ 0x2f)
	if_chr_death_animation_finished(0x16, /*goto*/ 0x2f)
	if_chr_unloaded(0x16, /*goto*/ 0x2f)
	goto_first(0x04)

	label(0x2f)
	dprint 'C','H','R',' ','1','0','F','D',0,
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0d)
	set_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(112)) // "Holoprogram 6 has been completed successfully."
	restart_timer

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x2f)
	endloop(0x08)

	label(0x2f)
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)

	beginloop(0x0d)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO6, FALSE, /*goto*/ 0x2f)
	endloop(0x0d)

	label(0x2f)
	goto_first(0x8f)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1030_holo7_main[] = {
	label(0x80)

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO7, TRUE, /*goto*/ 0x81)
	endloop(0x08)

	label(0x81)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	lock_door(0x75, 0x40)
	lock_door(0x76, 0x40)
	close_door(0x75)
	unset_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
	if_chr_activated_object(CHR_BOND, 0x75, /*goto*/ 0x2f)
	if_chr_activated_object(CHR_BOND, 0x76, /*goto*/ 0x2f)
	label(0x2f)
	unset_stage_flag(STAGEFLAG_HOLO_ABORTING)
	unset_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	unset_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	unset_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	hide_object(0x45)
	hide_chr(0x04)

	beginloop(0x57)
		try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x012b, AILIST_HOLO7_INIT_GUARD1, 0x00002210, /*goto*/ 0x59)
	endloop(0x57)

	beginloop(0x59)
		try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x012c, AILIST_HOLO7_INIT_GUARD2, 0x00002210, /*goto*/ 0x5b)
	endloop(0x59)

	beginloop(0x5b)
		try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x012d, AILIST_HOLO7_INIT_GUARD3, 0x00002210, /*goto*/ 0x5c)
	endloop(0x5b)

	beginloop(0x5c)
		try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x012e, AILIST_HOLO7_INIT_GUARD4, 0x00002210, /*goto*/ 0x5d)
	endloop(0x5c)

	beginloop(0x5d)
		try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x012f, AILIST_HOLO7_INIT_GUARD5, 0x00002210, /*goto*/ 0x5e)
	endloop(0x5d)

	label(0x5e)
	dprint 't','r','a','i','n','i','n','g',0,
	label(0x2f)
	label(0x91)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x2f)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(110)) // "Defeat all enemies without getting hit."
	label(0x2f)
	restart_timer

	beginloop(0x82)
		dprint 't','r','a','n',' ','l','o','o','p',0,
		if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x90)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_HOLO_FAILURE, TRUE, /*goto*/ 0x85)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_HOLO_SUCCESS, TRUE, /*goto*/ 0x83)
		if_chr_activated_object(CHR_BOND, 0x75, /*goto*/ 0x57)
		if_chr_activated_object(CHR_BOND, 0x76, /*goto*/ 0x57)
		goto_next(0x59)

		label(0x57)
		set_stage_flag(STAGEFLAG_TRIGGER_CANNOTEXIT_MSG)
		label(0x59)
		if_timer_gt(1200, /*goto*/ 0x2f)
	endloop(0x82)

	label(0x2f)
	goto_first(0x91)

	label(0x85)
	dprint 'f','a','i','l',0,
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	goto_next(0x84)

	label(0x83)
	set_savefile_flag(SAVEFILEFLAG_CI_HOLO7_DONE)
	dprint 'd','o','n','e',0,
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)
	yield
	goto_next(0x84)

	label(0x84)
	label(0x90)
	set_stage_flag(STAGEFLAG_CONSIDER_WARP)
	unlock_door(0x75, 0x40)
	unlock_door(0x76, 0x40)
	remove_hudmsgs
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_7)
	show_chr(0x04)
	remove_chr(0x19)
	remove_chr(0x1a)
	remove_chr(0x1b)
	remove_chr(0x17)
	remove_chr(0x18)
	dprint 'a','b','o','r','t','e','d',0,
	show_object(0x45)
	remove_hudmsgs

	beginloop(0x6d)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO7, FALSE, /*goto*/ 0x2f)
	endloop(0x6d)

	label(0x2f)
	goto_first(0x08)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0412_holo7_init_guard1[] = {
	set_self_flag_bankx(CHRFLAG0_80000000, BANK_0)
	set_chr_id(0x19)
	try_equip_weapon(MODEL_CHRFALCON2, WEAPON_FALCON2, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	set_ailist(CHR_SELF, AILIST_HOLO_GUARD_ARMED_UNALERT)
	endlist
};

u8 func0413_holo7_init_guard2[] = {
	set_self_flag_bankx(CHRFLAG0_80000000, BANK_0)
	set_chr_id(0x1a)
	try_equip_weapon(MODEL_CHRFALCON2, WEAPON_FALCON2, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	set_ailist(CHR_SELF, AILIST_HOLO_GUARD_ARMED_UNALERT)
	endlist
};

u8 func0414_holo7_init_guard3[] = {
	set_self_flag_bankx(CHRFLAG0_80000000, BANK_0)
	set_chr_id(0x1b)
	try_equip_weapon(MODEL_CHRFALCON2, WEAPON_FALCON2, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	set_ailist(CHR_SELF, AILIST_HOLO_GUARD_ARMED_UNALERT)
	endlist
};

u8 func0410_holo7_init_guard4[] = {
	set_chr_id(0x17)
	set_ailist(CHR_SELF, AILIST_HOLO_GUARD_UNARMED_UNALERT)
	endlist
};

u8 func0411_holo7_init_guard5[] = {
	set_chr_id(0x18)
	set_ailist(CHR_SELF, AILIST_HOLO_GUARD_UNARMED_UNALERT)
	endlist
};

u8 func0418_holo_guard_armed_unalert[] = {
	set_accuracy(50)
	set_reaction_speed(20)
	set_chr_maxdamage(CHR_SELF, 40)
	yield
	yield
	yield
	rebuild_teams
	rebuild_squadrons
	set_action(MA_NORMAL, FALSE)
	set_shotlist(AILIST_HOLO_GUARD_UNARMED_ALERT)
	restart_timer

	beginloop(0x04)
		if_distance_to_target_lt(500, /*goto*/ 0x06)
		if_timer_gt(300, /*goto*/ 0x2f)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x06)
	endloop(0x04)

	label(0x2f)
	call_rng
	goto_next(0x06)

	label(0x2f)
	goto_first(0x04)

	label(0x06)
	set_ailist(CHR_SELF, AILIST_HOLO_GUARD_ARMED_ALERT)
	endlist
};

u8 func0419_holo_guard_armed_alert[] = {
	set_shotlist(AILIST_HOLO_GUARD_ARMED_ALERT)
	if_has_gun(CHR_SELF, /*goto*/ 0x2f)
	increase_squadron_alertness(100)
	set_returnlist(CHR_SELF, AILIST_HOLO_GUARD_UNARMED_ALERT)
	set_ailist(CHR_SELF, AILIST_HOLO_GUARD_UNARMED_ALERT)
	label(0x2f)
	label(0x8f)
	try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x04)

	beginloop(0x04)
		if_in_disarm_range(/*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x08)

	beginloop(0x08)
		if_chr_injured_target(CHR_SELF, /*goto*/ 0x2f)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	goto_first(0x8f)

	say_quip(CHR_BOND, 0x15, 0x19, 0x02, 0x00, BANK_0, 0x00, 0x00)
	say_quip(CHR_BOND, 0x15, 0x19, 0x03, 0x01, BANK_0, 0x00, 0x00)
	label(0x2f)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0d)
	set_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	set_stage_flag(STAGEFLAG_HOLO_FAILED)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(111)) // "Training failed - you have been hit."
	restart_timer
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x5e)
		if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x2f)
		if_timer_gt(180, /*goto*/ 0x2f)
	endloop(0x5e)

	label(0x2f)
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1031_holo7_part1[] = {
	beginloop(0x8f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO7, TRUE, /*goto*/ 0x04)
	endloop(0x8f)

	beginloop(0x04)
		yield
		yield
		yield
		yield
		if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x0d)
		if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0d)
		if_chr_dying(0x19, /*goto*/ 0x2f)
		if_chr_death_animation_finished(0x19, /*goto*/ 0x2f)
		if_chr_unloaded(0x19, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	yield
	yield
	yield
	yield
	yield
	if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x0d)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0d)
	if_chr_dying(0x1a, /*goto*/ 0x2f)
	if_chr_death_animation_finished(0x1a, /*goto*/ 0x2f)
	if_chr_unloaded(0x1a, /*goto*/ 0x2f)
	goto_first(0x04)

	label(0x2f)
	yield
	yield
	yield
	yield
	yield
	if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x0d)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0d)
	if_chr_dying(0x1b, /*goto*/ 0x2f)
	if_chr_death_animation_finished(0x1b, /*goto*/ 0x2f)
	if_chr_unloaded(0x1b, /*goto*/ 0x2f)
	goto_first(0x04)

	label(0x2f)
	yield
	yield
	yield
	yield
	yield
	if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x0d)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0d)
	if_chr_dying(0x17, /*goto*/ 0x2f)
	if_chr_death_animation_finished(0x17, /*goto*/ 0x2f)
	if_chr_unloaded(0x17, /*goto*/ 0x2f)
	goto_first(0x04)

	label(0x2f)
	yield
	yield
	yield
	yield
	yield
	if_stage_flag_eq(STAGEFLAG_HOLO_ABORTING, TRUE, /*goto*/ 0x0d)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0d)
	if_chr_dying(0x18, /*goto*/ 0x2f)
	if_chr_death_animation_finished(0x18, /*goto*/ 0x2f)
	if_chr_unloaded(0x18, /*goto*/ 0x2f)
	goto_first(0x04)

	label(0x2f)
	if_stage_flag_eq(STAGEFLAG_GENERAL_PURPOSE, TRUE, /*goto*/ 0x0d)
	set_stage_flag(STAGEFLAG_GENERAL_PURPOSE)
	remove_hudmsgs
	show_hudmsg_middle(0x01, COLOR_04_ORANGE, L_DISH(113)) // "Holoprogram 7 has been completed successfully."
	restart_timer

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x2f)
	endloop(0x08)

	label(0x2f)
	set_stage_flag(STAGEFLAG_TRIGGER_HOLO_SUCCESS)

	beginloop(0x0d)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO7, FALSE, /*goto*/ 0x2f)
	endloop(0x0d)

	label(0x2f)
	goto_first(0x8f)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1035_manage_music[] = {
	beginloop(0x8f)
		if_stage_flag_eq(STAGEFLAG_IN_TRAINING, TRUE, /*goto*/ 0x2f)
		reloop(0x8f)

		label(0x2f)
		play_music_track(MUSIC_CI_TRAINING)

		beginloop(0x08)
			if_stage_flag_eq(STAGEFLAG_IN_TRAINING, FALSE, /*goto*/ 0x06)
		endloop(0x08)

		label(0x06)
		restart_music
		reset_ambience
	endloop(0x8f)

	endlist
};

#define do_gun_msg(object, text) \
	beginloop(0x03) \
		if_chr_activated_object(CHR_ANY, object, /*goto*/ 0x2f) \
		reloop(0x03) \
 \
		label(0x2f) \
		show_hudmsg(CHR_BOND, text) \
		restart_timer \
 \
		beginloop(0x08) \
			if_timer_gt(120, /*goto*/ 0x06) \
		endloop(0x08) \
 \
		label(0x06) \
	endloop(0x03)



u8 func1038_msg_pp7[] = {
	do_gun_msg(0x1e, L_DISH(116)) // "PP7"
	endlist
};

u8 func1039_msg_tt33[] = {
	do_gun_msg(0x1f, L_DISH(117)) // "TT33"
	endlist
};

u8 func103a_msg_skorpion[] = {
	do_gun_msg(0x20, L_DISH(118)) // "Skorpion"
	endlist
};

u8 func103b_msg_ak47[] = {
	do_gun_msg(0x21, L_DISH(119)) // "AK47"
	endlist
};

u8 func103c_msg_uzi9mm[] = {
	do_gun_msg(0x22, L_DISH(120)) // "Uzi 9mm"
	endlist
};

u8 func103d_msg_mp5k[] = {
	do_gun_msg(0x23, L_DISH(121)) // "MP5K"
	endlist
};

u8 func103e_msg_m16[] = {
	do_gun_msg(0x24, L_DISH(122)) // "M-16"
	endlist
};

u8 func103f_msg_fnp90[] = {
	do_gun_msg(0x25, L_DISH(123)) // "FNP90"
	endlist
};

u8 func1000_jo_typing[] = {
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	camera_movement(0x0484)
	cmd0175(60)
	if_controller_button_pressed(/*goto*/ 0x7b)
	set_music_track(MUSIC_CI_INTRO)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x0485, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	restart_timer
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 110)

	beginloop(0x57)
		if_controller_button_pressed(/*goto*/ 0x7b)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x57)

	label(0x06)
	play_sound(0x8116, CHANNEL_5)

	beginloop(0x59)
		if_controller_button_pressed(/*goto*/ 0x7b)
		if_timer_gt(175, /*goto*/ 0x06)
	endloop(0x59)

	label(0x06)
	play_sound(0x8118, CHANNEL_6)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2f)
		goto_next(0x7b)

		label(0x2f)
		if_controller_button_pressed(/*goto*/ 0x7b)
		label(0x2f)
	endloop(0x08)

	label(0x7b)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x0485, -2, -1, 0x06, 0x00, CHR_BOND, 2)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	enter_firstperson
	passive_mode(TRUE)
	fade_to_color(0x00000000, 0)
	yield
	yield
	yield
	yield
	restart_default_music
	reset_ambience
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1040_lift_door_sounds[] = {
	// Disable autoguns
	yield
	set_autoturret_type(0x8b, 0x02)
	set_autoturret_type(0x8c, 0x02)
	set_autoturret_type(0x8d, 0x02)
	restart_timer

	beginloop(0x57)
		if_timer_gt(120, /*goto*/ 0x2f)
	endloop(0x57)

	label(0x2f)
	set_object_flag(0x8b, OBJFLAG_DEACTIVATED)
	set_object_flag(0x8c, OBJFLAG_DEACTIVATED)
	set_object_flag(0x8d, OBJFLAG_DEACTIVATED)

	// Play sounds when lift doors activated
	beginloop(0x8f)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, 0x80, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_P1P2, 0x81, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_P1P2, 0x82, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_P1P2, 0x83, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_P1P2, 0x84, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_P1P2, 0x85, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_P1P2, 0x86, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_P1P2, 0x87, /*goto*/ 0x2f)
		reloop(0x8f)

		label(0x2f)
		play_sound(0x81b0, -1)
		restart_timer

		beginloop(0x08)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x08)

		label(0x06)
	endloop(0x8f)

	endlist
};

s32 intro[] = {
	spawn(0x00f5)
	outfit(OUTFIT_DEFAULT)
	endintro
};

s32 path00[] = {
	0x002f,
	0x002d,
	-1,
};

u8 func1032_setup_lifts[] = {
	activate_lift(1, 0x43)
	activate_lift(2, 0x44)
	set_lights_state(0x0007, 0x01, 0x32, 0x00, 0x00)
	set_lights_state(0x0008, 0x01, 0x32, 0x00, 0x00)
	set_lights_state(0x0009, 0x01, 0x32, 0x00, 0x00)
	set_lights_state(0x000a, 0x01, 0x19, 0x00, 0x00)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1042_check_jo_in_training_room[] = {
	beginloop(0x04)
		// Wait until player in training
		dprint 'C','H','K','1',0,
		if_stage_flag_eq(STAGEFLAG_TRIGGER_UPLINK, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_ECMMINE, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_CAMSPY, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_NIGHTVISION, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_DOORDECODER, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_RTRACKER, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_IR, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_XRAY, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_DISGUISE, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_CLOAK, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO1, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO2, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO3, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO4, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO5, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO6, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO7, TRUE, /*goto*/ 0x2f)
		reloop(0x04)

		// And has exited the training rooms
		// 0x0014 = lobby outside holo room
		// 0x001d = entry to device training room
		// 0x001a = entry to information room
		// 0x000b = entry to carrington's office
		label(0x2f)
		if_chr_in_room(CHR_BOND, 0x00, 0x0014, /*goto*/ 0x30)
		if_chr_in_room(CHR_BOND, 0x00, 0x001d, /*goto*/ 0x2f)
		if_chr_in_room(CHR_BOND, 0x00, 0x001a, /*goto*/ 0x2f)
		if_chr_in_room(CHR_BOND, 0x00, 0x000b, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x30)
		set_stage_flag(STAGEFLAG_TRIGGER_HOLO_FAILURE)
		label(0x2f)
		set_stage_flag(STAGEFLAG_TRIGGER_DEVICE_FAILURE)
		label(0x06)
		dprint 'C','H','K','2',0,
		yield
		yield
		yield
		yield

		label(0x57)
		dprint 'C','H','K','3',0,
		yield
		if_stage_flag_eq(STAGEFLAG_CONSIDER_WARP, TRUE, /*goto*/ 0x2f)
		goto_first(0x57)

		label(0x2f)
		label(0x59)
		dprint 'C','H','K','4',0,
		yield
		if_stage_flag_eq(STAGEFLAG_CONSIDER_WARP, FALSE, /*goto*/ 0x2f)
		goto_first(0x59)

		label(0x2f)
		dprint 'C','H','K','5',0,
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
	endloop(0x04)

	// Unreachable
	label(0x5b)
	restart_timer
	label(0x5c)
	dprint 'C','H','K','6',0,
	yield
	if_timer_gt(60, /*goto*/ 0x2f)
	goto_first(0x5c)
	label(0x2f)
	goto_first(0x04)

	endlist
};

u8 func1041_setup_lighting[] = {
	yield
	misc_command(0x0045, 0x06, 0x01)
	misc_command(0x0046, 0x06, 0x01)
	misc_command(0x0047, 0x06, 0x01)
	misc_command(0x0048, 0x06, 0x01)
	misc_command(0x0055, 0x06, 0x01)
	misc_command(0x0056, 0x06, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1043_remove_hovercrate[] = {
	yield
	beginloop(0x8f)
		if_object_in_room(OBJ_HOVERCRATE, 0x0016, /*goto*/ 0x08)
		if_object_in_room(OBJ_HOVERCRATE, 0x0017, /*goto*/ 0x08)
		if_object_in_room(OBJ_HOVERCRATE, 0x0018, /*goto*/ 0x08)
		if_object_in_room(OBJ_HOVERCRATE, 0x0019, /*goto*/ 0x08)
		goto_first(0x8f)

		label(0x08)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO1, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO2, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO3, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO4, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO5, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO6, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_IN_HOLO7, TRUE, /*goto*/ 0x2f)
		goto_first(0x8f)

		label(0x2f)
		move_object_to_pad(OBJ_HOVERCRATE, 0x0141)
	endloop(0x8f)

	endlist
};

struct ailist ailists[] = {
	{ func1000_jo_typing,                      0x1000 },
	{ func1001_set_jo_team,                    0x1001 },
	{ func1002_devicetraining_camspy,          0x1002 },
	{ func1003_devicetraining_nightvision,     0x1003 },
	{ func1004_devicetraining_doordecoder,     0x1004 },
	{ func1005_devicetraining_xray,            0x1005 },
	{ func1006_devicetraining_disguise,        0x1006 },
	{ func1007_devicetrainign_ir,              0x1007 },
	{ func1008_devicetraining_rtracker,        0x1008 },
	{ func1009_devicetraining_cloak,           0x1009 },
	{ func100a_devicetraining_ecmmine,         0x100a },
	{ func100b_devicetraining_uplink,          0x100b },
	{ func100c_cloak_detection,                0x100c },
	{ func100e_training_unlockables,           0x100e },
	{ func100f_doorproxy_unused1,              0x100f },
	{ func1010_doorproxy,                      0x1010 },
	{ func1010_doorproxy_unused2,              0x1011 },
	{ func1012_cloak_doorproxy,                0x1012 },
	{ func1013_msg_hovercrate,                 0x1013 },
	{ func1014_msg_hoverbike,                  0x1014 },
	{ func1015_msg_doors,                      0x1015 },
	{ func1016_msg_elevators,                  0x1016 },
	{ func1017_msg_terminals,                  0x1017 },
	{ func1018_lightswitch,                    0x1018 },
	{ func1019_setup_carrington,               0x1019 },
	{ func101a_move_jo_to_training_room,       0x101a },
	{ func101b_ir_door,                        0x101b },
	{ func101c_holo1_main,                     0x101c },
	{ func101d_holo1_switch1,                  0x101d },
	{ func101e_holo1_switch2,                  0x101e },
	{ func101f_holo1_switch3,                  0x101f },
	{ func1020_holo1_monitor_switches,         0x1020 },
	{ func1021_holo1_code1,                    0x1021 },
	{ func1021_holo1_code2,                    0x1021 },
	{ func1021_holo1_code3,                    0x1021 },
	{ func1021_holo1_code4,                    0x1021 },
	{ func1022_holo2_main,                     0x1022 },
	{ func1023_holo2_object1,                  0x1023 },
	{ func1024_holo2_object2,                  0x1024 },
	{ func1025_holo2_object3,                  0x1025 },
	{ func1026_holo2_object4,                  0x1026 },
	{ func1027_holo3_main,                     0x1027 },
	{ func1028_holo4_main,                     0x1028 },
	{ func1029_holo5_main,                     0x1029 },
	{ func102a_holo3_part1,                    0x102a },
	{ func102b_holo3_part2,                    0x102b },
	{ func102c_holo3_object1,                  0x102c },
	{ func102d_holo3_object2,                  0x102d },
	{ func102e_holo6_main,                     0x102e },
	{ func102f_holo1_part1,                    0x102f },
	{ func1030_holo7_main,                     0x1030 },
	{ func1031_holo7_part1,                    0x1031 },
	{ func1032_setup_lifts,                    0x1032 },
	{ func1033_holo4_part1,                    0x1033 },
	{ func1034_holo5_part1,                    0x1034 },
	{ func1035_manage_music,                   0x1035 },
	{ func041a_handle_holo_failure,            0x1037 },
	{ func1038_msg_pp7,                        0x1038 },
	{ func1039_msg_tt33,                       0x1039 },
	{ func103a_msg_skorpion,                   0x103a },
	{ func103b_msg_ak47,                       0x103b },
	{ func103c_msg_uzi9mm,                     0x103c },
	{ func103d_msg_mp5k,                       0x103d },
	{ func103e_msg_m16,                        0x103e },
	{ func103f_msg_fnp90,                      0x103f },
	{ func1040_lift_door_sounds,               0x1040 },
	{ func1041_setup_lighting,                 0x1041 },
	{ func1042_check_jo_in_training_room,      0x1042 },
	{ func1043_remove_hovercrate,              0x1043 },
	{ func041b_holo2_part1,                    0x041b },
	{ func041c_holo3_check_done,               0x041c },
	{ func0430_holo1_check_done,               0x0430 },
	{ func0401_move_to_deviceroom,             0x0401 },
	{ func0402_move_to_holoroom,               0x0402 },
	{ func041e_colleague,                      0x041e },
	{ func041d_init_collegue_when_sighted,     0x041d },
	{ func041f_colleague1,                     0x041f },
	{ func0420_colleague2,                     0x0420 },
	{ func0421_colleague3,                     0x0421 },
	{ func0422_colleague4,                     0x0422 },
	{ func0423_colleague5,                     0x0423 },
	{ func0424_colleague6,                     0x0424 },
	{ func0425_colleague7,                     0x0425 },
	{ func0426_colleague8,                     0x0426 },
	{ func0427_colleague9,                     0x0427 },
	{ func0428_colleague10,                    0x0428 },
	{ func0429_grimshaw_disguise,              0x0429 },
	{ func042a_carrington_cloak,               0x042a },
	{ func042b_init_carrington,                0x042b },
	{ func042c_carrington_tour,                0x042c },
	{ func042f_holo2_part2,                    0x042f },
	{ func042d_unused,                         0x042d },
	{ func042e_devicegirl_reply_to_carrington, 0x042e },
	{ func0403_holo4_guard1,                   0x0403 },
	{ func0404_holo4_guard2,                   0x0404 },
	{ func0405_holo4_guard3,                   0x0405 },
	{ func0406_holo5_init_guard1,              0x0406 },
	{ func0407_holo5_guard1,                   0x0407 },
	{ func0408_holo5_init_guard2,              0x0408 },
	{ func0409_holo5_guard2,                   0x0409 },
	{ func040a_holo5_init_guard3,              0x040a },
	{ func040b_holo5_guard3,                   0x040b },
	{ func040c_holo6_init_guard1,              0x040c },
	{ func040d_holo6_init_guard2,              0x040d },
	{ func040e_holo6_init_guard3,              0x040e },
	{ func040f_holo6_init_guard4,              0x040f },
	{ func0410_holo7_init_guard4,              0x0410 },
	{ func0411_holo7_init_guard5,              0x0411 },
	{ func0412_holo7_init_guard1,              0x0412 },
	{ func0413_holo7_init_guard2,              0x0413 },
	{ func0414_holo7_init_guard3,              0x0414 },
	{ func0415_holo_guard_unarmed_unalert,     0x0415 },
	{ func0416_holo_guard_unarmed_alert,       0x0416 },
	{ func0416_holo_guard_unarmed_alert2,      0x0417 },
	{ func0418_holo_guard_armed_unalert,       0x0418 },
	{ func0419_holo_guard_armed_alert,         0x0419 },
	{ func041a_handle_holo_failure,            0x041a },
	{ func1023_holo2_object1,                  0x0431 },
	{ func1024_holo2_object2,                  0x0432 },
	{ func1025_holo2_object3,                  0x0433 },
	{ func1026_holo2_object4,                  0x0434 },
	{ func102c_holo3_object1,                  0x0435 },
	{ func102d_holo3_object2,                  0x0436 },
	{ func101d_holo1_switch1,                  0x0437 },
	{ func101e_holo1_switch2,                  0x0438 },
	{ func101f_holo1_switch3,                  0x0439 },
	{ func1020_holo1_monitor_switches,         0x043a },
	{ NULL, 0 },
};

struct path paths[] = {
	{ path00, 0, PATHTYPE_CIRCULAR },
	{ NULL, 0, 0 },
};

