//
// G5 Building
//

#include "stagesetup.h"

// Characters
#define CHR_CLOAK_1A          0x00 // first room
#define CHR_CLOAK_1B          0x01 // first room
#define CHR_LIGHTSWITCH_GUARD 0x02
#define CHR_CLOAK_2A          0x03 // second room
#define CHR_CLOAK_2B          0x04 // second room
#define CHR_CLOAK_2C          0x05 // second room
#define CHR_CLOAK_2D          0x06 // second room
#define CHR_CASS              0x18
#define CHR_TRENT             0x19
#define CHR_STRIPES           0x1a
#define CHR_BLONDE            0x1b
#define CHR_INTRO_VICTIM      0x1d

// Objects
#define OBJ_GENERATOR    0x01
#define OBJ_LASERSWITCH1 0x03
#define OBJ_LASERSWITCH2 0x04
#define OBJ_LASERSWITCH3 0x05
#define OBJ_LASERSWITCH4 0x06
#define OBJ_SAFEDOOR     0x0b
#define OBJ_BACKUPDISK   0x0c
#define OBJ_KEYCARD1     0x0e
#define OBJ_KEYCARD2     0x0f
#define OBJ_DECODER      0x10
#define OBJ_SAFEKEYPAD   0x11
#define OBJ_ALARM1       0x12
#define OBJ_ALARM2       0x13
#define OBJ_ESCAPEDOOR1  0x18
#define OBJ_ESCAPEDOOR2  0x1b
#define OBJ_LASER_1A     0x22
#define OBJ_LASER_1B     0x23
#define OBJ_LASER_1C     0x24
#define OBJ_LASER_1D     0x25
#define OBJ_LASER_2A     0x26
#define OBJ_LASER_2B     0x27
#define OBJ_LASER_2C     0x28
#define OBJ_LASER_2D     0x29
#define OBJ_LASER_3A     0x2a
#define OBJ_LASER_3B     0x2b
#define OBJ_LASER_3C     0x2c
#define OBJ_LASER_3D     0x2d
#define OBJ_LASER_4A     0x2e
#define OBJ_LASER_4B     0x2f
#define OBJ_LASER_4C     0x30
#define OBJ_LASER_4D     0x31
#define OBJ_MINE1        0x38
#define OBJ_MINE2        0x39
#define OBJ_NBOMB_CRATE  0x3c
#define OBJ_LIGHTSWITCH  0x3d
#define OBJ_CROSSBOW     0x3e
#define OBJ_CMP150_BOND  0x47
#define OBJ_CMP150_COOP  0x48
// Stage flags
#define STAGEFLAG_CLOAK1_ONE_REMAINING   0x00000002
#define STAGEFLAG_CLOAK2_ONE_REMAINING   0x00000004
#define STAGEFLAG_MEETING_FINISHED       0x00000008
#define STAGEFLAG_CONSPIRATORS_ALERTED   0x00000010
#define STAGEFLAG_VISITED_TOP_DOOR       0x00000020
#define STAGEFLAG_SAFEKEYPAD_DESTROYED   0x00000040
#define STAGEFLAG_LIGHTS_OFF             0x00000080
#define STAGEFLAG_GENERATOR_SHUT_DOWN    0x00000100
#define STAGEFLAG_GENERATOR_SHUT_DOWN2   0x00000200 // redundant
#define STAGEFLAG_GENERATOR_DESTROYED    0x00000400
#define STAGEFLAG_LASERSET1_DISABLED     0x00000800
#define STAGEFLAG_LASERSET2_DISABLED     0x00001000
#define STAGEFLAG_00002000               0x00002000
#define STAGEFLAG_LASERSET4_DISABLED     0x00004000
#define STAGEFLAG_LASERSWITCH1_DESTROYED 0x00008000
#define STAGEFLAG_LASERSWITCH2_DESTROYED 0x00010000
#define STAGEFLAG_LASERSWITCH3_DESTROYED 0x00020000
#define STAGEFLAG_LASERSWITCH4_DESTROYED 0x00040000
#define STAGEFLAG_ALL_LASERS_DISABLED    0x00080000
#define STAGEFLAG_DECODER_ATTACHED       0x00200000
#define STAGEFLAG_LASERSET3_DISABLED     0x00800000
#define STAGEFLAG_MEETING_STARTED        0x01000000
#define STAGEFLAG_BACKUP_COLLECTED       0x08000000
#define STAGEFLAG_MEETING_HOLOGRAPHED    0x10000000
#define STAGEFLAG_20000000               0x20000000
#define STAGEFLAG_ALARM_SOUNDING         0x40000000
#define STAGEFLAG_EXITED_BUILDING        0x80000000

// AI Lists
#define AILIST_WALK_FROM_MEETING 0x0403
#define AILIST_RUN_FROM_MEETING  0x0404
#define AILIST_CLOAK2_HIDE       0x0405
#define AILIST_INIT_TYPE1_GUARD  0x0406
#define AILIST_INIT_CLOAK1_GUARD 0x0408
#define AILIST_INTRO             0x040d
#define AILIST_MEETING_CUTSCENE  0x040e
#define AILIST_OUTRO             0x040f
#define AILIST_CLOAK_GUARD       0x0412
#define AILIST_CLOAK2_GUARD      0x0414

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x1801)
	briefing(1, 0x1800)
	briefing(2, 0x1802)
	briefing(3, 0x1803)

	beginobjective(0, L_DEPO(9), (DIFFBIT_PA | DIFFBIT_PD)) // "Disable damping field generator"
		complete_flags(STAGEFLAG_GENERATOR_SHUT_DOWN)
		fail_flags(STAGEFLAG_GENERATOR_DESTROYED)
	endobjective

	beginobjective(1, L_DEPO(10), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Deactivate laser grid systems"
		complete_flags(STAGEFLAG_ALL_LASERS_DISABLED)
		complete_flags(STAGEFLAG_LASERSET1_DISABLED)
		complete_flags(STAGEFLAG_LASERSET2_DISABLED)
		complete_flags(STAGEFLAG_LASERSET3_DISABLED)
		complete_flags(STAGEFLAG_LASERSET4_DISABLED)
		fail_flags(STAGEFLAG_LASERSWITCH1_DESTROYED)
		fail_flags(STAGEFLAG_LASERSWITCH2_DESTROYED)
		fail_flags(STAGEFLAG_LASERSWITCH3_DESTROYED)
		fail_flags(STAGEFLAG_LASERSWITCH4_DESTROYED)
	endobjective

	beginobjective(2, L_DEPO(11), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Holograph meeting conspirators"
		complete_flags(STAGEFLAG_MEETING_HOLOGRAPHED)
		fail_flags(STAGEFLAG_20000000)
		fail_flags(STAGEFLAG_CONSPIRATORS_ALERTED)
		fail_flags(STAGEFLAG_00002000)
	endobjective

	beginobjective(3, L_DEPO(12), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Retrieve Dr. Caroll backup from safe"
		complete_flags(STAGEFLAG_BACKUP_COLLECTED)
		fail_flags(STAGEFLAG_SAFEKEYPAD_DESTROYED)
	endobjective

	beginobjective(4, L_DEPO(13), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Exit building"
		complete_flags(STAGEFLAG_EXITED_BUILDING)
	endobjective

	// First cloak room
	chr(0x00000100, CHR_CLOAK_1A, 0x007e, BODY_G5_SWAT_GUARD, HEAD_RANDOM, GAILIST_IDLE, 0x007e, -1, 200, 100, 0x00000600, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, CHR_CLOAK_1A, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRCROSSBOW, CHR_CLOAK_1A, 0x20004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CROSSBOW, 0x00ffffff, 0x00000000)
	tag(OBJ_CROSSBOW, -1)

	chr(0x00000100, CHR_CLOAK_1B, 0x007f, BODY_G5_SWAT_GUARD, HEAD_RANDOM, GAILIST_IDLE, 0x007f, -1, 200, 100, 0x00000600, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, CHR_CLOAK_1B, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	tag(OBJ_KEYCARD1, 1)
	key(0x0080, MODEL_KEYCARD, CHR_CLOAK_1A, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000004)
	rename_object(-1, 0x0045, L_DEPO(14), L_DEPO(15), L_DEPO(16), L_DEPO(17), L_DEPO(18), 0x0000, 0x0000) // "Obtain alpha key card."

	// Between cloak rooms
	chr(0x00004a00, 0x02, 0x005f, BODY_G5_GUARD, HEAD_RANDOM, GAILIST_UNALERTED, 0x0080, -1, 2000, 100, 0x80028204, 0x00000100, TEAM_NONCOMBAT, SQUADRON_04, -1, 0, 0x00010000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0002, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	// Second cloak room
	chr(0x00000000, 0x03, 0x005e, BODY_G5_SWAT_GUARD, HEAD_RANDOM, AILIST_CLOAK2_HIDE, 0x006e, -1, 1, 15, 0x000a8204, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0003, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000000, 0x04, 0x005d, BODY_G5_SWAT_GUARD, HEAD_RANDOM, AILIST_CLOAK2_HIDE, 0x006f, -1, 1, 15, 0x000a8204, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0004, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000000, 0x05, 0x0072, BODY_G5_SWAT_GUARD, HEAD_RANDOM, AILIST_CLOAK2_HIDE, 0x0070, -1, 1, 10, 0x000a8204, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0005, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000000, 0x06, 0x0013, BODY_G5_SWAT_GUARD, HEAD_RANDOM, AILIST_CLOAK2_HIDE, 0x0071, -1, 1, 10, 0x000a8204, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0006, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	tag(OBJ_KEYCARD2, 1)
	key(0x0080, MODEL_KEYCARD, 0x0003, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000010)
	rename_object(-1, 0x0046, L_DEPO(19), L_DEPO(20), L_DEPO(21), L_DEPO(22), L_DEPO(23), 0x0000, 0x0000) // "Obtain alpha key card."

	// Rest of stage
	chr(0x00000200, 0x08, 0x002f, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, 0x007b, -1, 200, 100, 0x800a8204, 0x00000000, TEAM_NONCOMBAT, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0008, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000300, 0x09, 0x0079, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, 0x007c, -1, 200, 100, 0x800a8204, 0x00000000, TEAM_NONCOMBAT, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0009, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000300, 0x0a, 0x007a, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, 0x007d, -1, 200, 100, 0x800a8204, 0x00000000, TEAM_NONCOMBAT, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x0b, 0x0026, BODY_G5_GUARD, HEAD_RANDOM, 0x040c, 0x0029, -1, 100, 100, 0x800a8204, 0x00000000, TEAM_NONCOMBAT, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000600, 0x07, 0x005c, BODY_G5_GUARD, HEAD_BEAU1, 0x0409, -1, -1, 200, 100, 0xc0008601, 0x00000000, TEAM_NONCOMBAT, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0007, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000600, 0x0c, 0x005b, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, 0x0073, -1, 200, 100, 0xc000c680, 0x00008000, TEAM_NONCOMBAT, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000600, 0x0d, 0x001f, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, 0x0073, -1, 200, 100, 0xc000c680, 0x00008000, TEAM_NONCOMBAT, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000600, 0x0e, 0x0067, BODY_G5_GUARD, HEAD_RANDOM, 0x040a, 0x0073, -1, 200, 100, 0xc000c680, 0x00008000, TEAM_NONCOMBAT, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000600, 0x0f, 0x0039, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, 0x0074, -1, 200, 100, 0x8004c080, 0x00000000, TEAM_NONCOMBAT, SQUADRON_06, -1, 0, 0x02000700)
	weapon(0x0100, MODEL_CHRCMP150, 0x000f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000600, 0x10, 0x0068, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, 0x0074, -1, 200, 100, 0x8004c080, 0x00000000, TEAM_NONCOMBAT, SQUADRON_06, -1, 0, 0x02000700)
	weapon(0x0100, MODEL_CHRCMP150, 0x0010, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000600, 0x11, 0x0069, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, 0x0074, -1, 200, 100, 0x8004c080, 0x00000000, TEAM_NONCOMBAT, SQUADRON_06, -1, 0, 0x02000700)
	weapon(0x0100, MODEL_CHRCMP150, 0x0011, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

#if VERSION >= VERSION_PAL_FINAL
	// ....... v
	chr(0x00000600, 0x12, 0x003f, BODY_G5_GUARD, HEAD_RANDOM, 0x040b, -1, -1, 200, 100, 0xa080c080, 0x00000000, TEAM_NONCOMBAT, SQUADRON_06, -1, 0, 0x02000700)
#else
	chr(0x00000200, 0x12, 0x003f, BODY_G5_GUARD, HEAD_RANDOM, 0x040b, -1, -1, 200, 100, 0xa080c080, 0x00000000, TEAM_NONCOMBAT, SQUADRON_06, -1, 0, 0x02000700)
#endif
	weapon(0x0100, MODEL_CHRCMP150, 0x0012, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

#if VERSION >= VERSION_PAL_FINAL
	chr(0x00000600, 0x13, 0x006a, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 200, 100, 0xa080c080, 0x00000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
#else
	chr(0x00000200, 0x13, 0x006a, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 200, 100, 0xa080c080, 0x00000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
#endif
	weapon(0x0100, MODEL_CHRCMP150, 0x0013, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

#if VERSION >= VERSION_PAL_FINAL
	chr(0x00000600, 0x14, 0x006b, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 200, 100, 0xc000c080, 0x00000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
#else
	chr(0x00000200, 0x14, 0x006b, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 200, 100, 0xc000c080, 0x00000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
#endif
	weapon(0x0100, MODEL_CHRCMP150, 0x0014, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

#if VERSION >= VERSION_PAL_FINAL
	chr(0x00000600, 0x15, 0x006c, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 200, 100, 0xc000c080, 0x00000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
#else
	chr(0x00000200, 0x15, 0x006c, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 200, 100, 0xc000c080, 0x00000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
#endif
	weapon(0x0100, MODEL_CHRCMP150, 0x0015, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

#if VERSION >= VERSION_PAL_FINAL
	chr(0x00000600, 0x16, 0x006d, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 200, 100, 0xc000c080, 0x00000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
#else
	chr(0x00000200, 0x16, 0x006d, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 200, 100, 0xc000c080, 0x00000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
#endif
	weapon(0x0100, MODEL_CHRCMP150, 0x0016, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00000200, 0x17, 0x0082, BODY_G5_GUARD, HEAD_RANDOM, AILIST_INIT_TYPE1_GUARD, -1, -1, 200, 100, 0xa0802000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0017, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	tag(0x0d, 1)
	chr(0x00000400, CHR_CASS, 0x0088, BODY_CASSANDRA, HEAD_CASSANDRA, 0x0410, -1, -1, 200, 100, 0x0000c080, 0x00000000, TEAM_ENEMY, SQUADRON_02, 0x4a, 0, 0x00010000)
	chr(0x00000400, CHR_BLONDE, 0x0087, BODY_MRBLONDE, HEAD_MRBLONDE, 0x0410, -1, -1, 200, 100, 0x0000c080, 0x00000000, TEAM_ENEMY, SQUADRON_02, 0x4b, 0, 0x00010000)
	chr(0x00000400, CHR_INTRO_VICTIM, 0x0009, BODY_G5_GUARD, HEAD_RANDOM, 0x0410, -1, -1, 1000, 100, 0x0000c200, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, CHR_INTRO_VICTIM, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000500, CHR_TRENT, 0x003b, BODY_TRENT, HEAD_TRENT, 0x0411, -1, -1, 200, 100, 0x0000c080, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	chr(0x00000500, CHR_STRIPES, 0x003c, BODY_STRIPES, HEAD_JON, 0x0411, -1, -1, 200, 100, 0x0000c080, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	tag(OBJ_GENERATOR, 1)
	multimonitor(0x0100, MODEL_PD_CONSOLE, 0x00d0, 0x000001e1, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030000)
	tag(0x3f, 1)
	door(0x0100, MODEL_DOOR2_G5, 0x009c, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00060000, 0x00000010, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x009d, 0x10000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00060000, 0x00000010, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x40, -1)
	door(0x0100, MODEL_DOOR2_G5, 0x00a2, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x00a3, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x00a4, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x00a5, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x00a6, 0x10000000, 0x08000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00060000, 0x00000020, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x00a7, 0x10000000, 0x10000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00060000, 0x00000020, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x00a8, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x00a9, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x00b3, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x00b4, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x00aa, 0x10000000, 0x28000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00060000, 0x00000020, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x00ab, 0x10000000, 0x30000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00060000, 0x00000020, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x00ac, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2_G5, 0x00ad, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00060000, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x34, 4)
	tag(0x35, 4)
	tag(0x36, 4)
	tag(0x37, 4)
	door(0x0100, MODEL_DOOR1A_G5, 0x0099, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000004, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR1ATRI_G5, 0x0098, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0001f8ac, 0x0002a0e5, 0x0000434a, 0x0003491f, 0x000010d2, 0x00000000, 0x00000004, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR1B_G5, 0x009a, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000004, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR1ATRI_G5, 0x009b, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0001f8ac, 0x0002a0e5, 0x0000434a, 0x0003491f, 0x000010d2, 0x00000000, 0x00000004, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffd, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x33, 1)
	door(0x0100, MODEL_DOOR1A_G5, 0x00a0, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000004, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR1ATRI_G5, 0x00a1, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0001f8ac, 0x0002a0e5, 0x0000434a, 0x0003491f, 0x000010d2, 0x00000000, 0x00000004, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR1B_G5, 0x009f, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000004, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR1ATRI_G5, 0x009e, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0001f8ac, 0x0002a0e5, 0x0000434a, 0x0003491f, 0x000010d2, 0x00000000, 0x00000004, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffd, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x43, -4)
	tag(0x44, -4)
	tag(0x45, -4)
	tag(0x46, -4)
	tag(0x3a, 1)
	door(0x0100, MODEL_DOOR4A_G5, 0x00b5, 0x00000400, 0x00000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0000ffff, 0x00014000, 0x00001999, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR4B_G5, 0x00b6, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x0000ffff, 0x00014000, 0x00001999, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x41, 1)
	door(0x0100, MODEL_G5CARLIFTDOOR, 0x00b7, 0x00000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000020, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_G5CARLIFTDOOR, 0x00b8, 0x00000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00080000, 0x00000020, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x42, -1)

	tag(OBJ_BACKUPDISK, 1)
	stdobject(0x0100, MODEL_ZIGGYCARD, 0x004c, 0x012404e8, 0x00004000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	rename_object(-1, 0x0044, L_DEPO(30), L_DEPO(31), L_DEPO(32), L_DEPO(33), L_DEPO(34), 0x0000, 0x0000) // "Obtain DAT tape."

	tag(OBJ_DECODER, 1)
	stdobject(0x0200, MODEL_CHRDOORDECODER, 0x0050, 0x00420408, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)

	tag(OBJ_LIGHTSWITCH, 1)
	singlemonitor(0x0019, MODEL_G5_LASER_SWITCH, 0x00ed, 0x00000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff06)
	tag(0x03, 1)
	singlemonitor(0x0019, MODEL_G5_LASER_SWITCH, 0x00e6, 0x00000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff13)
	tag(0x04, 1)
	singlemonitor(0x0019, MODEL_G5_LASER_SWITCH, 0x00e8, 0x00000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff13)
	tag(0x05, 1)
	singlemonitor(0x0019, MODEL_G5_LASER_SWITCH, 0x00e9, 0x00000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff13)
	tag(0x06, 1)
	singlemonitor(0x0019, MODEL_G5_LASER_SWITCH, 0x00ea, 0x00000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff13)
	tag(0x12, 1)
	singlemonitor(0x0019, MODEL_G5_ALARM, 0x00e7, 0x00000002, 0x00204000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff04)
	tag(0x13, 1)
	singlemonitor(0x0019, MODEL_G5_ALARM, 0x00eb, 0x00000002, 0x00204000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff04)
	tag(OBJ_SAFEKEYPAD, 1)
	singlemonitor(0x0019, MODEL_G5_LASER_SWITCH, 0x00ec, 0x00000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff01)
	tag(OBJ_SAFEDOOR, 1)
	door(0x0100, MODEL_G5SAFEDOOR, 0x00c2, 0x10000010, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x00500000, 0x00500000, 0x00001999, 0x00000005, 0x00000040, 0x00000e10, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)

	tag(OBJ_CMP150_BOND, 1)
	weapon(0x0100, MODEL_CHRCMP150, 0xffff, 0x40000000, 0x00000000, 0x00400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REMOTEMINE, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x0022, L_DEPO(66), L_DEPO(67), L_DEPO(68), L_DEPO(69), L_DEPO(70), 0x0000, 0x0000) // ""

	tag(OBJ_CMP150_COOP, 1)
	weapon(0x0100, MODEL_CHRCMP150, 0xffff, 0x40000000, 0x00000000, 0x00400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REMOTEMINE, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x0022, L_DEPO(66), L_DEPO(67), L_DEPO(68), L_DEPO(69), L_DEPO(70), 0x0000, 0x0000) // ""

	glass(0x0100, MODEL_WINDOW, 0x00c0, 0x00000f62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x00c1, 0x00000f62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x00be, 0x00000f62, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x22, 4)
	tag(0x23, 4)
	tag(0x24, 4)
	tag(0x25, 4)
	door(0x0100, MODEL_LASDOOR, 0x00d1, 0x46000400, 0x02020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x00d2, 0x46000400, 0x02020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x00d3, 0x46000400, 0x02020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x00d4, 0x46000400, 0x02020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x26, 4)
	tag(0x27, 4)
	tag(0x28, 4)
	tag(0x29, 4)
	door(0x0100, MODEL_LASDOOR, 0x00d5, 0x46000400, 0x02020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x00d6, 0x46000400, 0x02020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x00d7, 0x46000400, 0x02020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x00d8, 0x46000400, 0x02020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x2a, 4)
	tag(0x2b, 4)
	tag(0x2c, 4)
	tag(0x2d, 4)
	door(0x0100, MODEL_LASDOOR, 0x00d9, 0x46000400, 0x02020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x00da, 0x46000400, 0x02020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x00db, 0x46000400, 0x02020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x00dc, 0x46000400, 0x02020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x2e, 4)
	tag(0x2f, 4)
	tag(0x30, 4)
	tag(0x31, 4)
	door(0x0100, MODEL_LASDOOR, 0x00dd, 0x46000400, 0x02020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x00de, 0x46000400, 0x02020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x00df, 0x46000400, 0x02020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x00e0, 0x46000400, 0x02020000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffd, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(OBJ_ESCAPEDOOR1, 2)
	link_scenery(1, 0, 2)
	door(0x0100, MODEL_G5_ESCDOORUP, 0x00f0, 0x13500d00, 0x20304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00010000, 0x03e80000, 0x03e80000, 0x00010000, 0x00000000, 0x00000080, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_G5_ESCDOORUPBOOM, 0x00f1, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(OBJ_ESCAPEDOOR2, 2)
	link_scenery(1, 0, 2)
	door(0x0100, MODEL_G5_ESCDOORDOWN, 0x00ee, 0x13500d00, 0x20304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00010000, 0x03e80000, 0x03e80000, 0x00010000, 0x00000000, 0x00000080, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_G5_ESCDOORDOWNBOOM, 0x00ef, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)

	tag(OBJ_MINE1, 1)
	remote_mine(0x0100, MODEL_CHRREMOTEMINE, 0x0077, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x22000000, 0x00000001, 0x00000000)

	tag(OBJ_MINE2, 1)
	remote_mine(0x0100, MODEL_CHRREMOTEMINE, 0x0078, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x22000000, 0x00000001, 0x00000000)

	stdobject(0x0100, MODEL_DUMPSTER, 0x00f9, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DUMPSTER, 0x00fa, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DUMPSTER, 0x00fb, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DUMPSTER, 0x00fc, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0028, MODEL_BAFTA, 0x004d, 0x002000e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0133, MODEL_G5SMALLCHAIR, 0x00f3, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0133, MODEL_G5SMALLCHAIR, 0x00f4, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0133, MODEL_G5SMALLCHAIR, 0x00f5, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0133, MODEL_G5SMALLCHAIR, 0x00f6, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0133, MODEL_G5SMALLCHAIR, 0x00f7, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x4a, 1)
	stdobject(0x0185, MODEL_G5BIGCHAIR, 0x00f8, 0x000004e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x4b, 1)
	stdobject(0x0133, MODEL_G5SMALLCHAIR, 0x00f2, 0x000004e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x00c8, 0x000005e1, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x00c9, 0x000005e1, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x00ca, 0x000005e1, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x00cb, 0x000005e1, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x00cc, 0x000005e1, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x00cd, 0x000005e1, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x00ce, 0x000005e1, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x00cf, 0x000005e1, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000)

	tag(0x3c, 1)
	weapon(0x0080, MODEL_MULTI_AMMO_CRATE, 0x0095, 0x00000101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_NBOMB, 0x00ffffff, 0x00000000)

	tag(0x3b, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x0096, 0x00000001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x49, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x0056, 0x00000001, 0x000000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	endprops
};

s32 intro[] = {
	intro_weapon(WEAPON_FALCON2_SILENCER, -1)
	ammo(AMMOTYPE_PISTOL, 100)
	ammo(AMMOTYPE_NBOMB, 6)
	outfit(OUTFIT_LEATHER)
	intro_weapon(WEAPON_DOORDECODER, -1)
	intro_weapon(WEAPON_CAMSPY, -1)
	spawn(0x0083)
	endintro
};

s32 path00[] = {
	0x0015,
	0x0014,
	0x0019,
	0x0018,
	0x0019,
	0x0014,
	-1,
};

s32 path01[] = {
	0x0023,
	0x0025,
	0x0020,
	0x001a,
	0x001c,
	0x001a,
	0x0020,
	0x0025,
	-1,
};

s32 path02[] = {
	0x0037,
	0x003f,
	0x0043,
	0x0041,
	0x0040,
	0x0042,
	0x0045,
	0x0046,
	0x0045,
	0x0042,
	0x0040,
	0x0041,
	0x0043,
	0x003f,
	-1,
};

s32 path03[] = {
	0x0027,
	0x0028,
	0x0029,
	0x002a,
	0x002d,
	0x002e,
	0x002d,
	0x002a,
	0x0029,
	0x0028,
	0x0027,
	0x0026,
	-1,
};

u8 func0409_start_path00[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(5)
	set_reaction_speed(30)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	assign_path(0)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func040a_start_path01[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(5)
	set_reaction_speed(30)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	assign_path(1)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func040b_start_path02[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(5)
	set_reaction_speed(30)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	assign_path(2)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func040c_start_path03[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(5)
	set_reaction_speed(30)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	assign_path(3)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func1008_check_generator[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_GENERATOR, /*goto*/ 0x08)
		if_object_in_good_condition(OBJ_GENERATOR, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_GENERATOR_SHUT_DOWN, TRUE, /*goto*/ 0x2c)

		// Destroyed
		mute_channel(CHANNEL_4)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x06)
		show_hudmsg(CHR_BOND, L_DEPO(24)) // "Mission critical object destroyed."
		set_stage_flag(STAGEFLAG_GENERATOR_DESTROYED)
		label(0x06)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x2c)
		reloop(0x04)

		// Generator activated
		label(0x08)
		if_stage_flag_eq(STAGEFLAG_GENERATOR_SHUT_DOWN2, TRUE, /*goto*/ 0x09)
		set_object_image(OBJ_GENERATOR, 0x00, 0x14)
		set_object_image(OBJ_GENERATOR, 0x01, 0x14)
		mute_channel(CHANNEL_4)
		mute_channel(CHANNEL_0)
		assign_sound(0x8147, CHANNEL_0)
		control_sound_from_object(CHANNEL_0, OBJ_GENERATOR, TRUE)
		show_hudmsg(CHR_P1P2, L_DEPO(25)) // "Damping field generator shut down."
		set_stage_flag(STAGEFLAG_GENERATOR_SHUT_DOWN2)
		set_stage_flag(STAGEFLAG_GENERATOR_SHUT_DOWN)
		reloop(0x04)

		label(0x09)
		show_hudmsg(CHR_P1P2, L_DEPO(26)) // "Generator cannot be restarted."
	endloop(0x04)

	endlist
};

u8 func1003_laser_switch_1[] = {
	assign_sound(0x8119, CHANNEL_0)
	play_sound_from_object(CHANNEL_0, OBJ_LASER_1A, 0x012c, 0x0190)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_LASERSWITCH1, /*goto*/ 0x08)
		if_object_in_good_condition(OBJ_LASERSWITCH1, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_LASERSET1_DISABLED, TRUE, /*goto*/ 0x2c)
		show_hudmsg(CHR_BOND, L_DEPO(24)) // "Mission critical object destroyed."
		set_stage_flag(STAGEFLAG_LASERSWITCH1_DESTROYED)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x2c)
		reloop(0x04)

		// Activated/deactivated
		label(0x08)
		if_stage_flag_eq(STAGEFLAG_LASERSET1_DISABLED, TRUE, /*goto*/ 0x09)

		// Deactivated
		set_object_image(OBJ_LASERSWITCH1, 0x00, 0x14)
		show_hudmsg(CHR_P1P2, L_DEPO(27)) // "Laser grid unit shut down."
		set_stage_flag(STAGEFLAG_LASERSET1_DISABLED)
		open_door(OBJ_LASER_1A)
		open_door(OBJ_LASER_1B)
		open_door(OBJ_LASER_1C)
		open_door(OBJ_LASER_1D)
		yield
		set_object_flag(OBJ_LASER_1A, OBJFLAG_40000000)
		set_object_flag(OBJ_LASER_1B, OBJFLAG_40000000)
		set_object_flag(OBJ_LASER_1C, OBJFLAG_40000000)
		set_object_flag(OBJ_LASER_1D, OBJFLAG_40000000)
		assign_sound(0x043f, CHANNEL_7)
		play_sound_from_entity(CHANNEL_7, OBJ_LASERSWITCH1, 0x012c, 0x0190, 0x00)
		mute_channel(CHANNEL_0)
		assign_sound(0x01cd, CHANNEL_0)
		play_sound_from_entity(CHANNEL_0, OBJ_LASER_1A, 0x012c, 0x0190, 0x00)
		goto_next(0x0a)

		// Activated
		label(0x09)
		show_hudmsg(CHR_P1P2, L_DEPO(28)) // "Laser grid unit activated."
		unset_stage_flag(STAGEFLAG_LASERSET1_DISABLED)
		set_object_image(OBJ_LASERSWITCH1, 0x00, 0x13)
		close_door(OBJ_LASER_1A)
		close_door(OBJ_LASER_1B)
		close_door(OBJ_LASER_1C)
		close_door(OBJ_LASER_1D)
		assign_sound(0x043f, CHANNEL_7)
		play_sound_from_entity(CHANNEL_7, OBJ_LASERSWITCH1, 0x012c, 0x0190, 0x00)
		assign_sound(0x8119, CHANNEL_0)
		play_sound_from_object(CHANNEL_0, OBJ_LASER_1A, 0x012c, 0x0190)
		goto_next(0x0a)
		label(0x0a)
		restart_timer

		beginloop(0x0b)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x0b)

		label(0x06)
	endloop(0x04)

	endlist
};

u8 func1004_laser_switch_2[] = {
	assign_sound(0x8119, CHANNEL_1)
	play_sound_from_object(CHANNEL_1, OBJ_LASER_2A, 0x012c, 0x0190)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_LASERSWITCH2, /*goto*/ 0x08)
		if_object_in_good_condition(OBJ_LASERSWITCH2, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_LASERSET2_DISABLED, TRUE, /*goto*/ 0x2c)
		show_hudmsg(CHR_BOND, L_DEPO(24)) // "Mission critical object destroyed."
		set_stage_flag(STAGEFLAG_LASERSWITCH2_DESTROYED)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x2c)
		reloop(0x04)

		// Activated/deactivated
		label(0x08)
		dprint 'S','W','I','T','C','H',' ','2',0,
		if_stage_flag_eq(STAGEFLAG_LASERSET2_DISABLED, TRUE, /*goto*/ 0x09)

		// Deactivated
		set_object_image(OBJ_LASERSWITCH2, 0x00, 0x14)
		show_hudmsg(CHR_P1P2, L_DEPO(27)) // "Laser grid unit shut down."
		set_stage_flag(STAGEFLAG_LASERSET2_DISABLED)
		open_door(OBJ_LASER_2A)
		open_door(OBJ_LASER_2B)
		open_door(OBJ_LASER_2C)
		open_door(OBJ_LASER_2D)
		yield
		set_object_flag(OBJ_LASER_2A, OBJFLAG_40000000)
		set_object_flag(OBJ_LASER_2B, OBJFLAG_40000000)
		set_object_flag(OBJ_LASER_2C, OBJFLAG_40000000)
		set_object_flag(OBJ_LASER_2D, OBJFLAG_40000000)
		assign_sound(0x043f, CHANNEL_7)
		play_sound_from_entity(CHANNEL_7, OBJ_LASERSWITCH2, 0x012c, 0x0190, 0x00)
		mute_channel(CHANNEL_1)
		assign_sound(0x01cd, CHANNEL_1)
		play_sound_from_entity(CHANNEL_1, OBJ_LASER_2A, 0x012c, 0x0190, 0x00)
		goto_next(0x0a)

		// Activated
		label(0x09)
		set_object_image(OBJ_LASERSWITCH2, 0x00, 0x13)
		show_hudmsg(CHR_P1P2, L_DEPO(28)) // "Laser grid unit activated."
		unset_stage_flag(STAGEFLAG_LASERSET2_DISABLED)
		close_door(OBJ_LASER_2A)
		close_door(OBJ_LASER_2B)
		close_door(OBJ_LASER_2C)
		close_door(OBJ_LASER_2D)
		assign_sound(0x043f, CHANNEL_7)
		play_sound_from_entity(CHANNEL_7, OBJ_LASERSWITCH2, 0x012c, 0x0190, 0x00)
		assign_sound(0x8119, CHANNEL_1)
		play_sound_from_object(CHANNEL_1, OBJ_LASER_2A, 0x012c, 0x0190)
		goto_next(0x0a)
		label(0x0a)
		restart_timer

		beginloop(0x0b)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x0b)

		label(0x06)
	endloop(0x04)

	endlist
};

u8 func1005_laser_switch_3[] = {
	assign_sound(0x8119, CHANNEL_2)
	play_sound_from_object(CHANNEL_2, OBJ_LASER_3A, 0x012c, 0x0190)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_LASERSWITCH3, /*goto*/ 0x08)
		if_object_in_good_condition(OBJ_LASERSWITCH3, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_LASERSET3_DISABLED, TRUE, /*goto*/ 0x2c)
		show_hudmsg(CHR_BOND, L_DEPO(24)) // "Mission critical object destroyed."
		set_stage_flag(STAGEFLAG_LASERSWITCH3_DESTROYED)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x2c)
		reloop(0x04)

		// Activated/deactivated
		label(0x08)
		if_stage_flag_eq(STAGEFLAG_LASERSET3_DISABLED, TRUE, /*goto*/ 0x09)

		// Deactivated
		set_object_image(OBJ_LASERSWITCH3, 0x00, 0x14)
		show_hudmsg(CHR_P1P2, L_DEPO(27)) // "Laser grid unit shut down."
		set_stage_flag(STAGEFLAG_LASERSET3_DISABLED)
		open_door(OBJ_LASER_3A)
		open_door(OBJ_LASER_3B)
		open_door(OBJ_LASER_3C)
		open_door(OBJ_LASER_3D)
		yield
		set_object_flag(OBJ_LASER_3A, OBJFLAG_40000000)
		set_object_flag(OBJ_LASER_3B, OBJFLAG_40000000)
		set_object_flag(OBJ_LASER_3C, OBJFLAG_40000000)
		set_object_flag(OBJ_LASER_3D, OBJFLAG_40000000)
		assign_sound(0x043f, CHANNEL_7)
		play_sound_from_entity(CHANNEL_7, OBJ_LASERSWITCH3, 0x012c, 0x0190, 0x00)
		mute_channel(CHANNEL_2)
		assign_sound(0x01cd, CHANNEL_2)
		play_sound_from_entity(CHANNEL_2, OBJ_LASER_3A, 0x012c, 0x0190, 0x00)
		goto_next(0x0a)

		// Activated
		label(0x09)
		set_object_image(OBJ_LASERSWITCH3, 0x00, 0x13)
		show_hudmsg(CHR_P1P2, L_DEPO(28)) // "Laser grid unit activated."
		unset_stage_flag(STAGEFLAG_LASERSET3_DISABLED)
		close_door(OBJ_LASER_3A)
		close_door(OBJ_LASER_3B)
		close_door(OBJ_LASER_3C)
		close_door(OBJ_LASER_3D)
		assign_sound(0x043f, CHANNEL_7)
		play_sound_from_entity(CHANNEL_7, OBJ_LASERSWITCH3, 0x012c, 0x0190, 0x00)
		assign_sound(0x8119, CHANNEL_2)
		play_sound_from_object(CHANNEL_2, OBJ_LASER_3A, 0x012c, 0x0190)
		goto_next(0x0a)
		label(0x0a)
		restart_timer

		beginloop(0x0b)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x0b)

		label(0x06)
	endloop(0x04)

	endlist
};

u8 func1006_laser_switch_4[] = {
	assign_sound(0x811a, CHANNEL_3)
	play_sound_from_object(CHANNEL_3, OBJ_LASER_4A, 0x012c, 0x0190)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_LASERSWITCH4, /*goto*/ 0x08)
		if_object_in_good_condition(OBJ_LASERSWITCH4, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_LASERSET4_DISABLED, TRUE, /*goto*/ 0x2c)
		show_hudmsg(CHR_BOND, L_DEPO(24)) // "Mission critical object destroyed."
		set_stage_flag(STAGEFLAG_LASERSWITCH4_DESTROYED)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x2c)
		reloop(0x04)

		// Activated/deactivated
		label(0x08)
		if_stage_flag_eq(STAGEFLAG_LASERSET4_DISABLED, TRUE, /*goto*/ 0x09)

		// Deactivated
		set_object_image(OBJ_LASERSWITCH4, 0x00, 0x14)
		show_hudmsg(CHR_P1P2, L_DEPO(27)) // "Laser grid unit shut down."
		set_stage_flag(STAGEFLAG_LASERSET4_DISABLED)
		open_door(OBJ_LASER_4A)
		open_door(OBJ_LASER_4B)
		open_door(OBJ_LASER_4C)
		open_door(OBJ_LASER_4D)
		yield
		set_object_flag(OBJ_LASER_4A, OBJFLAG_40000000)
		set_object_flag(OBJ_LASER_4B, OBJFLAG_40000000)
		set_object_flag(OBJ_LASER_4C, OBJFLAG_40000000)
		set_object_flag(OBJ_LASER_4D, OBJFLAG_40000000)
		assign_sound(0x043f, CHANNEL_7)
		play_sound_from_entity(CHANNEL_7, OBJ_LASERSWITCH4, 0x012c, 0x0190, 0x00)
		mute_channel(CHANNEL_3)
		assign_sound(0x01cd, CHANNEL_3)
		play_sound_from_entity(CHANNEL_3, OBJ_LASER_4A, 0x012c, 0x0190, 0x00)
		goto_next(0x0a)

		// Activated
		label(0x09)
		set_object_image(OBJ_LASERSWITCH4, 0x00, 0x13)
		show_hudmsg(CHR_P1P2, L_DEPO(28)) // "Laser grid unit activated."
		unset_stage_flag(STAGEFLAG_LASERSET4_DISABLED)
		close_door(OBJ_LASER_4A)
		close_door(OBJ_LASER_4B)
		close_door(OBJ_LASER_4C)
		close_door(OBJ_LASER_4D)
		assign_sound(0x043f, CHANNEL_7)
		play_sound_from_entity(CHANNEL_7, OBJ_LASERSWITCH4, 0x012c, 0x0190, 0x00)
		assign_sound(0x811a, CHANNEL_3)
		play_sound_from_object(CHANNEL_3, OBJ_LASER_4A, 0x012c, 0x0190)
		goto_next(0x0a)
		label(0x0a)
		restart_timer

		beginloop(0x0b)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x0b)

		label(0x06)
	endloop(0x04)

	endlist
};

u8 func1007_init_lasers[] = {
	yield

	// Wait for cutscene to finish
	beginloop(0x8f)
		if_camera_animating(/*goto*/ 0x2c)
		goto_next(0x06)
		label(0x2c)
	endloop(0x8f)

	label(0x06)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0d)

	// SA/PA - bring up lasers
	close_door(OBJ_LASER_1A)
	close_door(OBJ_LASER_2A)
	close_door(OBJ_LASER_3A)
	close_door(OBJ_LASER_4A)
	close_door(OBJ_LASER_1B)
	close_door(OBJ_LASER_2B)
	close_door(OBJ_LASER_3B)
	close_door(OBJ_LASER_4B)
	close_door(OBJ_LASER_1C)
	close_door(OBJ_LASER_2C)
	close_door(OBJ_LASER_3C)
	close_door(OBJ_LASER_4C)
	close_door(OBJ_LASER_1D)
	close_door(OBJ_LASER_2D)
	close_door(OBJ_LASER_3D)
	close_door(OBJ_LASER_4D)

	// Wait until all lasers disabled, show message and set flag
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_LASERSET1_DISABLED, FALSE, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_LASERSET2_DISABLED, FALSE, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_LASERSET3_DISABLED, FALSE, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_LASERSET4_DISABLED, FALSE, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_ALL_LASERS_DISABLED, TRUE, /*goto*/ 0x2c)
		show_hudmsg(CHR_BOND, L_DEPO(29)) // "All laser grid systems shut down."
		set_stage_flag(STAGEFLAG_ALL_LASERS_DISABLED)
		label(0x2c)
	endloop(0x04)

	// Agent - take down lasers
	label(0x0d)
	set_object_image(OBJ_LASERSWITCH1, 0x00, 0x14)
	set_object_image(OBJ_LASERSWITCH2, 0x00, 0x14)
	set_object_image(OBJ_LASERSWITCH3, 0x00, 0x14)
	set_object_image(OBJ_LASERSWITCH4, 0x00, 0x14)
	open_door(OBJ_LASER_1A)
	open_door(OBJ_LASER_2A)
	open_door(OBJ_LASER_3A)
	open_door(OBJ_LASER_4A)
	open_door(OBJ_LASER_1B)
	open_door(OBJ_LASER_2B)
	open_door(OBJ_LASER_3B)
	open_door(OBJ_LASER_4B)
	open_door(OBJ_LASER_1C)
	open_door(OBJ_LASER_2C)
	open_door(OBJ_LASER_3C)
	open_door(OBJ_LASER_4C)
	open_door(OBJ_LASER_1D)
	open_door(OBJ_LASER_2D)
	open_door(OBJ_LASER_3D)
	open_door(OBJ_LASER_4D)
	yield
	set_object_flag(OBJ_LASER_1A, OBJFLAG_40000000)
	set_object_flag(OBJ_LASER_2A, OBJFLAG_40000000)
	set_object_flag(OBJ_LASER_3A, OBJFLAG_40000000)
	set_object_flag(OBJ_LASER_4A, OBJFLAG_40000000)
	set_object_flag(OBJ_LASER_1B, OBJFLAG_40000000)
	set_object_flag(OBJ_LASER_2B, OBJFLAG_40000000)
	set_object_flag(OBJ_LASER_3B, OBJFLAG_40000000)
	set_object_flag(OBJ_LASER_4B, OBJFLAG_40000000)
	set_object_flag(OBJ_LASER_1C, OBJFLAG_40000000)
	set_object_flag(OBJ_LASER_2C, OBJFLAG_40000000)
	set_object_flag(OBJ_LASER_3C, OBJFLAG_40000000)
	set_object_flag(OBJ_LASER_4C, OBJFLAG_40000000)
	set_object_flag(OBJ_LASER_1D, OBJFLAG_40000000)
	set_object_flag(OBJ_LASER_2D, OBJFLAG_40000000)
	set_object_flag(OBJ_LASER_3D, OBJFLAG_40000000)
	set_object_flag(OBJ_LASER_4D, OBJFLAG_40000000)
	set_stage_flag(STAGEFLAG_LASERSET1_DISABLED)
	set_stage_flag(STAGEFLAG_LASERSET2_DISABLED)
	set_stage_flag(STAGEFLAG_LASERSET3_DISABLED)
	set_stage_flag(STAGEFLAG_LASERSET4_DISABLED)
	set_stage_flag(STAGEFLAG_ALL_LASERS_DISABLED)
	label(0x0e)
	yield
	open_door(OBJ_LASER_1A)
	open_door(OBJ_LASER_2A)
	open_door(OBJ_LASER_3A)
	open_door(OBJ_LASER_4A)
	open_door(OBJ_LASER_1B)
	open_door(OBJ_LASER_2B)
	open_door(OBJ_LASER_3B)
	open_door(OBJ_LASER_4B)
	open_door(OBJ_LASER_1C)
	open_door(OBJ_LASER_2C)
	open_door(OBJ_LASER_3C)
	open_door(OBJ_LASER_4C)
	open_door(OBJ_LASER_1D)
	open_door(OBJ_LASER_2D)
	open_door(OBJ_LASER_3D)
	open_door(OBJ_LASER_4D)
	yield
	mute_channel(CHANNEL_0)
	mute_channel(CHANNEL_1)
	mute_channel(CHANNEL_2)
	mute_channel(CHANNEL_3)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1009_spawner_during_decode[] = {
	// Wait for alarm or decoder attached
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_DECODER_ATTACHED, TRUE, /*goto*/ 0x06)
		if_alarm_active(/*goto*/ 0x61)
	endloop(0x04)

	// Decoder is attached
	label(0x06)
	yield
	yield

	// Wait 8.3 seconds
	restart_timer

	beginloop(0x08)
		if_timer_gt(500, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	activate_alarm

	// Spawn two swat guards
	label(0x61)
	try_spawn_chr_at_pad(BODY_G5_SWAT_GUARD, HEAD_RANDOM, 0x0058, 0x0401, 0x00000200, /*goto*/ 0x06)
	label(0x06)
	try_spawn_chr_at_pad(BODY_G5_SWAT_GUARD, HEAD_RANDOM, 0x003f, 0x0402, 0x00000200, /*goto*/ 0x06)
	label(0x06)

	// Every half second, use RNG to decide whether to consider spawning more.
	// 55/255 chance of passing.
	label(0x09)
		restart_timer
		call_rng

		beginloop(0x0a)
			if_rand_gt(200, /*goto*/ 0x06)
			if_timer_gt(30, /*goto*/ 0x2c)
		endloop(0x0a)

		label(0x2c)
		reloop(0x09)

		label(0x06)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x55)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x56)
		if_num_chrs_in_squadron_gt(5, 0x09, /*goto*/ 0x2c)
		if_kill_count_gt(50, /*goto*/ 0x2c)
		goto_next(0x57)

		// Agent
		label(0x55)
		if_num_chrs_in_squadron_gt(3, 0x09, /*goto*/ 0x2c)
		if_kill_count_gt(50, /*goto*/ 0x2c)
		goto_next(0x57)

		// Special Agent
		label(0x56)
		if_num_chrs_in_squadron_gt(4, 0x09, /*goto*/ 0x2c)
		if_kill_count_gt(50, /*goto*/ 0x2c)
		goto_next(0x57)

		// All difficulties
		label(0x57)
		call_rng
		if_rand_gt(128, /*goto*/ 0x0b)
		if_stage_flag_eq(STAGEFLAG_VISITED_TOP_DOOR, TRUE, /*goto*/ 0x2c)
		try_spawn_chr_at_pad(BODY_G5_SWAT_GUARD, HEAD_RANDOM, 0x0058, 0x0401, 0x00000200, /*goto*/ 0x06)
		label(0x06)
		goto_next(0x0d)

		label(0x2c)
		dprint 'S','Q','U','A','D',' ','F','U','L','L',0,
		reloop(0x09)

		label(0x0b)
		try_spawn_chr_at_pad(BODY_G5_SWAT_GUARD, HEAD_RANDOM, 0x003f, 0x0402, 0x00000200, /*goto*/ 0x06)
		label(0x06)
		label(0x0d)
		restart_timer

		beginloop(0x0e)
			if_timer_gt(30, /*goto*/ 0x06)
		endloop(0x0e)

		label(0x06)
	endloop(0x09)

	endlist
};

#define init_swat \
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_00400000) \
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1) \
	set_chr_dodge_rating(2, 0x0a) \
	set_accuracy(15) \
	set_reaction_speed(25) \
	set_chr_maxdamage(CHR_SELF, 40) \
	add_health_or_armor(0) \
	set_recovery_speed(0) \
	set_shield(0) \
	try_equip_weapon(MODEL_CHRDY357, WEAPON_DY357MAGNUM, 0x10000000, /*goto*/ 0x06) \
	label(0x06) \
	set_chr_team(CHR_SELF, TEAM_ENEMY) \
	set_squadron(SQUADRON_09) \
	set_chr_chrflag(CHR_SELF, CHRCFLAG_KILLCOUNTABLE) \
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0) \
	set_self_flag_bankx(CHRFLAG0_00008000, BANK_0) \
	set_alertness(90) \
	set_self_chrflag(CHRCFLAG_00000200) \
	rebuild_teams \
	rebuild_squadrons \
	run_to_pad(0x004e)



u8 func0401_init_swat1[] = {
	init_swat

	beginloop(0x08)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x2c)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x2c)
		if_chr_in_room(CHR_SELF, 0x00, 0x0050, /*goto*/ 0x06)
	endloop(0x08)

	label(0x2c)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)

	label(0x06)
	set_returnlist(CHR_SELF, GAILIST_UNALERTED)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

/**
 * Same as above, but guards with this function will become unalerted if they
 * lose sight of Jo regardless of what room they're in.
 */
u8 func0402_init_swat2[] = {
	init_swat

	beginloop(0x08)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x2c)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x2c)
		if_chr_in_room(CHR_SELF, 0x00, 0x0050, /*goto*/ 0x06)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x08)

	label(0x2c)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)

	label(0x06)
	set_returnlist(CHR_SELF, GAILIST_UNALERTED)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

u8 func100a_give_keycards[] = {
	set_object_flag(OBJ_KEYCARD1, OBJFLAG_UNCOLLECTABLE)
	set_object_flag2(OBJ_KEYCARD1, OBJFLAG2_INVISIBLE)
	set_object_flag(OBJ_KEYCARD2, OBJFLAG_UNCOLLECTABLE)
	set_object_flag2(OBJ_KEYCARD2, OBJFLAG2_INVISIBLE)
	set_object_flag2(OBJ_CROSSBOW, OBJFLAG2_INVISIBLE)
	set_object_flag(OBJ_CROSSBOW, OBJFLAG_UNCOLLECTABLE)

	set_chr_chrflag(CHR_CLOAK_1A, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_CLOAK_1B, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_CLOAK_2A, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_CLOAK_2B, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_CLOAK_2C, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_CLOAK_2D, CHRCFLAG_KILLCOUNTABLE)

	// Wait for trigger
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_CLOAK1_ONE_REMAINING, TRUE, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	if_chr_dying(CHR_CLOAK_1A, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_CLOAK_1A, /*goto*/ 0x06)
	if_chr_unloaded(CHR_CLOAK_1A, /*goto*/ 0x06)

	// First cloacked guard is alive
	give_object_to_chr(OBJ_KEYCARD1, CHR_CLOAK_1A)
	give_object_to_chr(OBJ_CROSSBOW, CHR_CLOAK_1A)
	set_target_chr(CHR_CLOAK_1A)
	goto_next(0x2c)

	// First cloaked guard is dead
	label(0x06)
	give_object_to_chr(OBJ_KEYCARD1, CHR_CLOAK_1B)
	give_object_to_chr(OBJ_CROSSBOW, CHR_CLOAK_1B)
	set_target_chr(CHR_CLOAK_1B)

	label(0x2c)
	unset_object_flag(OBJ_KEYCARD1, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(OBJ_KEYCARD1, OBJFLAG2_INVISIBLE)
	unset_object_flag2(OBJ_CROSSBOW, OBJFLAG2_INVISIBLE)
	unset_object_flag(OBJ_CROSSBOW, OBJFLAG_UNCOLLECTABLE)

	// Wait for the chr who holds the keycard to die
	beginloop(0x55)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x08)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x2c)
		if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x2c)
	endloop(0x55)

	label(0x2c)
	set_object_flag2(OBJ_CROSSBOW, OBJFLAG2_INVISIBLE)
	set_object_flag(OBJ_CROSSBOW, OBJFLAG_UNCOLLECTABLE)
	hide_object(OBJ_CROSSBOW)

	beginloop(0x08)
		dprint 'C','H','E','C','K',' ','D','E','A','D',0,
		if_stage_flag_eq(STAGEFLAG_CLOAK2_ONE_REMAINING, TRUE, /*goto*/ 0x2c)
	endloop(0x08)

	// Second room
	label(0x2c)
	if_chr_dying(CHR_CLOAK_2A, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_CLOAK_2A, /*goto*/ 0x06)
	if_chr_unloaded(CHR_CLOAK_2A, /*goto*/ 0x06)

	// 2A alive
	give_object_to_chr(OBJ_KEYCARD2, CHR_CLOAK_2A)
	dprint 'G','I','V','E',' ','T','O','4',0,
	goto_next(0x2c)

	// 2A dead
	label(0x06)
	if_chr_dying(CHR_CLOAK_2B, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_CLOAK_2B, /*goto*/ 0x06)
	if_chr_unloaded(CHR_CLOAK_2B, /*goto*/ 0x06)
	give_object_to_chr(OBJ_KEYCARD2, CHR_CLOAK_2B)
	dprint 'G','I','V','E',' ','T','O','5',0,
	goto_next(0x2c)

	// 2B dead
	label(0x06)
	if_chr_dying(CHR_CLOAK_2C, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_CLOAK_2C, /*goto*/ 0x06)
	if_chr_unloaded(CHR_CLOAK_2C, /*goto*/ 0x06)
	give_object_to_chr(OBJ_KEYCARD2, CHR_CLOAK_2C)
	dprint 'G','I','V','E',' ','T','O','6',0,
	goto_next(0x2c)

	// 2C dead
	label(0x06)
	give_object_to_chr(OBJ_KEYCARD2, CHR_CLOAK_2D)
	dprint 'G','I','V','E',' ','T','O','7',0,

	label(0x2c)
	unset_object_flag(OBJ_KEYCARD2, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(OBJ_KEYCARD2, OBJFLAG2_INVISIBLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100b_check_backup_collected[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_has_object(CHR_P1P2, OBJ_BACKUPDISK, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	set_stage_flag(STAGEFLAG_BACKUP_COLLECTED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1002_set_ai[] = {
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func1400_setup_counterop[] = {
	yield
	set_chr_team(CHR_ANTI, TEAM_ENEMY)

	// On counterop SA and PA, give Joanna a CMP150
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x06)
	give_object_to_chr(OBJ_CMP150_BOND, CHR_BOND)
	give_object_to_chr(OBJ_CMP150_COOP, CHR_COOP)
	label(0x06)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func100e_check_conspirators_alerted[] = {
	// Wait for alarm
	beginloop(0x04)
		if_alarm_active(/*goto*/ 0x06)
		reloop(0x04)

		// These objects are doors
		label(0x06)
		unset_object_flag2(0x3f, OBJFLAG2_AICANNOTUSE)
		unset_object_flag2(0x40, OBJFLAG2_AICANNOTUSE)
		unset_object_flag2(0x41, OBJFLAG2_AICANNOTUSE)
		unset_object_flag2(0x42, OBJFLAG2_AICANNOTUSE)
		unset_object_flag2(0x43, OBJFLAG2_AICANNOTUSE)
		unset_object_flag2(0x44, OBJFLAG2_AICANNOTUSE)
		unset_object_flag2(0x45, OBJFLAG2_AICANNOTUSE)
		unset_object_flag2(0x46, OBJFLAG2_AICANNOTUSE)
		unset_object_flag2(0x34, OBJFLAG2_AICANNOTUSE)
		unset_object_flag2(0x35, OBJFLAG2_AICANNOTUSE)
		unset_object_flag2(0x36, OBJFLAG2_AICANNOTUSE)
		unset_object_flag2(0x37, OBJFLAG2_AICANNOTUSE)

		set_stage_flag(STAGEFLAG_ALARM_SOUNDING)
		if_stage_flag_eq(STAGEFLAG_MEETING_STARTED, TRUE, /*goto*/ 0x06)
		set_stage_flag(STAGEFLAG_CONSPIRATORS_ALERTED)
		set_ailist(CHR_CASS, AILIST_RUN_FROM_MEETING)
		set_ailist(0x1c, AILIST_RUN_FROM_MEETING) // chr doesn't exist
		set_ailist(CHR_BLONDE, AILIST_RUN_FROM_MEETING)
		show_hudmsg(CHR_BOND, L_DEPO(41)) // "Conspirators have been alerted."

		// Wait until alarm not active
		label(0x06)

		beginloop(0x55)
			if_alarm_active(/*goto*/ 0x2c)
			goto_next(0x06)
			label(0x2c)
		endloop(0x55)

		label(0x06)
		unset_stage_flag(STAGEFLAG_ALARM_SOUNDING)
	endloop(0x04)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100f_alarm_switches[] = {
	// Wait until player activated alarm switch
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_ALARM1, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, OBJ_ALARM2, /*goto*/ 0x2c)
		reloop(0x04)

		label(0x2c)
		if_stage_flag_eq(STAGEFLAG_ALARM_SOUNDING, TRUE, /*goto*/ 0x06)
		show_hudmsg(CHR_P1P2, L_DEPO(42)) // "Alarm activated."
		set_stage_flag(STAGEFLAG_ALARM_SOUNDING)
		activate_alarm
		reloop(0x04)

		label(0x06)
		show_hudmsg(CHR_P1P2, L_DEPO(43)) // "Alarm deactivated."
		unset_stage_flag(STAGEFLAG_ALARM_SOUNDING)
		deactivate_alarm
	endloop(0x04)

	endlist
};

u8 func1010_safe_cracking[] = {
	// Wait for player to activate keypad or for it to be destroyed
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_object_in_good_condition(OBJ_SAFEKEYPAD, /*goto*/ 0x2c)
		show_hudmsg(CHR_BOND, L_DEPO(64)) // "Mission critical object destroyed."
		set_stage_flag(STAGEFLAG_SAFEKEYPAD_DESTROYED)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x2c)
		if_chr_activated_object(CHR_P1P2, OBJ_SAFEKEYPAD, /*goto*/ 0x2c)
		reloop(0x04)

		label(0x2c)
		if_chr_weapon_equipped(CHR_P1P2, WEAPON_DOORDECODER, /*goto*/ 0x2c)
		show_hudmsg(CHR_P1P2, L_DEPO(44)) // "Safe door is locked."
	endloop(0x04)

	label(0x2c)
	show_hudmsg(CHR_P1P2, L_DEPO(45)) // "Door Decoder attached."
	remove_weapon_from_inventory(WEAPON_DOORDECODER)
	move_object_to_pad(OBJ_DECODER, 0x0075)
	set_stage_flag(STAGEFLAG_DECODER_ATTACHED)
	assign_sound(0x8144, CHANNEL_1)
	play_sound_from_object(CHANNEL_1, OBJ_SAFEKEYPAD, 0x012c, 0x0190)
	restart_timer

	beginloop(0x09)
		if_timer_gt(180, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	speak(CHR_BOND, L_DEPO(38), 0x7754, CHANNEL_5, COLOR_00_GREEN) // "INTRUDER ALERT - all security to the vault."
	play_x_music(CHANNEL_10, 180)
	yield
	set_countdown_timer(60)
	show_hudmsg(CHR_P1P2, L_DEPO(36)) // "Initiating cracking routines."
	yield
	show_countdown_timer
	start_countdown_timer
	restart_timer

	beginloop(0x5e)
		if_timer_gt(180, /*goto*/ 0x2c)
	endloop(0x5e)

	label(0x2c)
	activate_alarm

	beginloop(0x08)
		if_object_in_good_condition(OBJ_SAFEKEYPAD, /*goto*/ 0x2c)
		show_hudmsg(CHR_BOND, L_DEPO(64)) // "Mission critical object destroyed."
		set_stage_flag(STAGEFLAG_SAFEKEYPAD_DESTROYED)
		hide_countdown_timer
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x2c)
		if_countdown_timer_lt(1, /*goto*/ 0x06)
	endloop(0x08)

	// Unlock
	label(0x06)
	mute_channel(CHANNEL_1)
	assign_sound(0x8145, CHANNEL_1)
	control_sound_from_object(CHANNEL_1, OBJ_SAFEKEYPAD, TRUE)
	show_hudmsg(CHR_P1P2, L_DEPO(37)) // "Door Decoder finished - door unlocked."
	unlock_door(OBJ_SAFEDOOR, 0x40)
	unset_object_flag2(OBJ_SAFEDOOR, OBJFLAG2_AICANNOTUSE)
	open_door(OBJ_SAFEDOOR)
	hide_countdown_timer
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1012_check_for_end[] = {
	// Wait until player on ending catwalk
	beginloop(0x08)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0060, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0061, /*goto*/ 0x06)
		reloop(0x08)

		label(0x06)
		if_chr_death_animation_finished(CHR_P1P2, /*goto*/ 0x2c)
		if_chr_dying(CHR_P1P2, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_P1P2, /*goto*/ 0x2c)
		goto_next(0x06)
		label(0x2c)
	endloop(0x08)

	label(0x06)
	set_stage_flag(STAGEFLAG_EXITED_BUILDING)
	dprint 'I','N',' ','T','H','E',' ','E','L','E','V','A','T','O','R','\n',0,
	set_invincible(CHR_BOND)
	yield
	yield
	revoke_control(CHR_BOND, 4)
	hide_countdown_timer
	stop_countdown_timer
	if_all_objectives_complete(/*goto*/ 0x53)
	show_hudmsg(CHR_BOND, L_DEPO(51)) // "Objectives incomplete - MISSION FAILED."
	label(0x2c)
	restart_timer

	beginloop(0x52)
		if_timer_gt(280, /*goto*/ 0x2c)
	endloop(0x52)

	label(0x2c)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Objectives complete
	label(0x53)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2c)
	if_chr_dying(CHR_BOND, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x2c)
	goto_next(0x06)

	label(0x2c)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2c)
	if_chr_dying(CHR_COOP, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x2c)
	goto_next(0x06)

	label(0x2c)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Mission complete
	label(0x06)
	set_ailist(CHR_SELF, AILIST_OUTRO)
	endlist
};

u8 func1013_check_escape_doors[] = {
	beginloop(0x04)
		if_object_in_good_condition(OBJ_ESCAPEDOOR1, /*goto*/ 0x06)
		goto_next(0x2c)
		label(0x06)
		if_object_in_good_condition(OBJ_ESCAPEDOOR2, /*goto*/ 0x06)
		label(0x2c)
		dprint 'S','T','A','R','T',' ','A','L','A','R','M','\n',0,
		activate_alarm
		set_ailist(CHR_SELF, GAILIST_IDLE)
		reloop(0x04)

		label(0x06)
	endloop(0x04)

	endlist
};

u8 func1014_check_camspy_location[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(0x00, /*camspy*/ 0x02, 0x0094, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	if_stage_flag_eq(STAGEFLAG_CONSPIRATORS_ALERTED, TRUE, /*goto*/ 0x2c)
	set_stage_flag(STAGEFLAG_MEETING_HOLOGRAPHED)

	label(0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100c_check_for_meeting_trigger[] = {
	// Wait until meeting started then start cutscene
	beginloop(0x00)
		if_stage_flag_eq(STAGEFLAG_MEETING_HOLOGRAPHED, TRUE, /*goto*/ 0x06)
	endloop(0x00)

	label(0x06)
	dprint 's','h','o','t',' ','1',0,
	set_ailist(CHR_SELF, AILIST_MEETING_CUTSCENE)
	endlist
};

u8 func0403_walk_from_meeting[] = {
	walk_to_pad(0x0085)

	beginloop(0x04)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	remove_chr(CHR_SELF)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0404_run_from_meeting[] = {
	run_to_pad(0x0085)

	beginloop(0x04)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	remove_chr(CHR_SELF)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1001_objectives_failed_msg[] = {
	yield
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

/**
 * Monitor the laser states and unset the stage flags when they become enabled
 * (ie. door is closed). This seems redundant because the flags are unset when
 * the switches are used. Maybe they close after a long timeout or something.
 */
u8 func1017_check_lasers_closed[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_ALL_LASERS_DISABLED, TRUE, /*goto*/ 0x08)
		if_stage_flag_eq(STAGEFLAG_MEETING_HOLOGRAPHED, TRUE, /*goto*/ 0x08)
		if_door_state(OBJ_LASER_1A, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2c)
		unset_stage_flag(STAGEFLAG_LASERSET1_DISABLED)
		label(0x2c)
		if_door_state(OBJ_LASER_2A, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2c)
		unset_stage_flag(STAGEFLAG_LASERSET2_DISABLED)
		label(0x2c)
		if_door_state(OBJ_LASER_3A, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2c)
		unset_stage_flag(STAGEFLAG_LASERSET3_DISABLED)
		label(0x2c)
		if_door_state(OBJ_LASER_4A, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2c)
		unset_stage_flag(STAGEFLAG_LASERSET4_DISABLED)
		label(0x2c)
	endloop(0x04)

	label(0x08)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040d_intro[] = {
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_G5_INTRO)
	camera_movement(0x0165)
	cmd0175(60)

	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x0166, -1, -1, 0x06, 0x00, CHR_BOND, 4)

	set_chr_chrflag(CHR_INTRO_VICTIM, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_INTRO_VICTIM, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_INTRO_VICTIM, CHRHFLAG_00020000)
	chr_do_animation(0x0167, -1, -1, 0x06, 0x00, CHR_INTRO_VICTIM, 4)

	restart_timer
	set_cutscene_weapon(CHR_BOND, WEAPON_FALCON2_SILENCER, WEAPON_NONE)
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 110)

	beginloop(0x55)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(74, /*goto*/ 0x06)
	endloop(0x55)

	label(0x06)
	play_sound(0x0161, CHANNEL_7)

	beginloop(0x56)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(100, /*goto*/ 0x06)
	endloop(0x56)

	label(0x06)
	play_sound(0x0085, CHANNEL_7)

	beginloop(0x57)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(172, /*goto*/ 0x06)
	endloop(0x57)

	label(0x06)
	play_sound(0x0163, CHANNEL_7)

	beginloop(0x58)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(173, /*goto*/ 0x06)
	endloop(0x58)

	label(0x06)
	play_sound(0x0164, CHANNEL_6)

	beginloop(0x59)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(278, /*goto*/ 0x06)
	endloop(0x59)

	label(0x06)
	play_sound(0x0161, CHANNEL_7)

	beginloop(0x5a)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(312, /*goto*/ 0x06)
	endloop(0x5a)

	label(0x06)
	play_sound(0x0162, CHANNEL_7)

	beginloop(0x5b)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(356, /*goto*/ 0x06)
	endloop(0x5b)

	label(0x06)
	play_sound(0x0163, CHANNEL_7)

	beginloop(0x5c)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(396, /*goto*/ 0x06)
	endloop(0x5c)

	label(0x06)
	play_sound(0x0164, CHANNEL_7)

	beginloop(0x5d)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(434, /*goto*/ 0x06)
	endloop(0x5d)

	label(0x06)
	play_sound(0x0161, CHANNEL_7)

	beginloop(0x5e)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(478, /*goto*/ 0x06)
	endloop(0x5e)

	label(0x06)
	play_sound(0x0162, CHANNEL_7)

	beginloop(0x60)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(515, /*goto*/ 0x06)
	endloop(0x60)

	label(0x06)
	play_sound(0x0163, CHANNEL_7)

	beginloop(0x61)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(560, /*goto*/ 0x06)
	endloop(0x61)

	label(0x06)
	play_sound(0x0164, CHANNEL_7)

	beginloop(0x65)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(568, /*goto*/ 0x06)
	endloop(0x65)

	label(0x06)
	play_sound(0x0162, CHANNEL_6)

	beginloop(0x62)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(595, /*goto*/ 0x06)
	endloop(0x62)

	label(0x06)
	play_sound(0x0161, CHANNEL_7)

	beginloop(0x63)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(630, /*goto*/ 0x06)
	endloop(0x63)

	label(0x06)
	play_sound(0x0162, CHANNEL_7)

	beginloop(0x66)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(638, /*goto*/ 0x06)
	endloop(0x66)

	label(0x06)
	play_sound(0x0163, CHANNEL_6)

	beginloop(0x68)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(670, /*goto*/ 0x06)
	endloop(0x68)

	label(0x06)
	play_sound(0x002e, CHANNEL_7)

	beginloop(0x67)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(670, /*goto*/ 0x06)
	endloop(0x67)

	label(0x06)
	play_sound(0x0045, CHANNEL_6)
	chr_drop_weapon(CHR_INTRO_VICTIM)

	beginloop(0x69)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(672, /*goto*/ 0x06)
	endloop(0x69)

	label(0x06)
	play_sound(0x0087, CHANNEL_5)

	beginloop(0x64)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(702, /*goto*/ 0x06)
	endloop(0x64)

	label(0x06)
	play_sound(0x0164, CHANNEL_6)

	beginloop(0x6a)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(718, /*goto*/ 0x06)
	endloop(0x6a)

	label(0x06)
	play_sound(0x007a, CHANNEL_7)

	beginloop(0x6b)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(722, /*goto*/ 0x06)
	endloop(0x6b)

	label(0x06)
	play_sound(0x007c, CHANNEL_6)

	beginloop(0x6c)
		if_controller_button_pressed(/*goto*/ 0x54)
		if_timer_gt(764, /*goto*/ 0x06)
	endloop(0x6c)

	label(0x06)
	play_sound(0x0082, CHANNEL_5)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2c)
		goto_next(0x54)
		label(0x2c)
		if_controller_button_pressed(/*goto*/ 0x54)
		label(0x2c)
	endloop(0x08)

	label(0x54)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x0166, -2, -1, 0x06, 0x00, CHR_BOND, 2)

	unset_chr_chrflag(CHR_INTRO_VICTIM, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_INTRO_VICTIM, CHRHFLAG_00020000)
	set_chr_chrflag(CHR_INTRO_VICTIM, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_INTRO_VICTIM, CHRCFLAG_00010000)
	chr_do_animation(0x0167, -2, -1, 0x06, 0x00, CHR_INTRO_VICTIM, 2)

	restart_default_music
	reset_ambience
	enter_firstperson
	chr_do_animation(0x022a, -1, -1, 0x06, 0x00, CHR_INTRO_VICTIM, 2)
	chr_drop_weapon(CHR_INTRO_VICTIM)
	yield
	set_ailist(CHR_CLOAK_1A, AILIST_INIT_CLOAK1_GUARD)
	set_ailist(CHR_CLOAK_1B, AILIST_INIT_CLOAK1_GUARD)
	yield
	kill(CHR_INTRO_VICTIM)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

// Used in both mid and outro cutscenes
#define wait_until(time, loopid) \
	beginloop(loopid) \
		if_controller_button_pressed(/*goto*/ 0x54) \
		if_timer_gt(time, /*goto*/ 0x06) \
	endloop(loopid) \
 \
	label(0x06)



u8 func040e_meeting_cutscene[] = {
	deactivate_alarm
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_G5_MIDCUTSCENE)
	camera_movement(0x0191)
	set_stage_flag(STAGEFLAG_MEETING_STARTED)
	set_ailist(CHR_BLONDE, GAILIST_IDLE)
	set_ailist(CHR_CASS, GAILIST_IDLE)
	set_ailist(CHR_TRENT, GAILIST_IDLE)
	set_ailist(CHR_STRIPES, GAILIST_IDLE)

	set_chr_chrflag(CHR_BLONDE, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_BLONDE, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_BLONDE, CHRHFLAG_00020000)
	chr_do_animation(0x0192, -1, -1, 0x06, 0x00, CHR_BLONDE, 4)

	set_chr_chrflag(CHR_CASS, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_CASS, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_CASS, CHRHFLAG_00020000)
	chr_do_animation(0x0193, -1, -1, 0x06, 0x00, CHR_CASS, 4)

	set_chr_chrflag(CHR_TRENT, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_TRENT, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_TRENT, CHRHFLAG_00020000)
	chr_do_animation(0x0194, -1, -1, 0x06, 0x00, CHR_TRENT, 4)

	set_chr_chrflag(CHR_STRIPES, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_STRIPES, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_STRIPES, CHRHFLAG_00020000)
	chr_do_animation(0x0195, -1, -1, 0x06, 0x00, CHR_STRIPES, 4)
	restart_timer

	beginloop(0x55)
		if_timer_gt(240, /*goto*/ 0x06)
	endloop(0x55)

	label(0x06)
	speak(CHR_BOND, L_DEPO(72), 0x740c, CHANNEL_5, COLOR_04_ORANGE) // "We've recovered the sapient from Carrington and al..."

	wait_until(752, 0x56)
	play_sound(0x0161, CHANNEL_6)

	wait_until(760, 0x57)
	speak(CHR_BOND, L_DEPO(73), 0x740d, CHANNEL_7, COLOR_03_RED) // "This will reduce its efficiency. My team will have..."

	wait_until(813, 0x58)
	play_sound(0x0162, CHANNEL_6)

	wait_until(864, 0x59)
	play_sound(0x0163, CHANNEL_5)

	wait_until(1183, 0x5a)
	play_sound(0x0164, CHANNEL_6)

	wait_until(1466, 0x5b)
	play_sound(0x0161, CHANNEL_6)

	// Someone screwed up the labelling here...
	// 5c was probably supposed to go here.
	yield
	if_controller_button_pressed(/*goto*/ 0x54)
	if_timer_gt(1594, /*goto*/ 0x06)
	goto_first(0x5c)
	label(0x06)
	play_sound(0x0162, CHANNEL_6)

	wait_until(1638, 0x5c)
	play_sound(0x0593, CHANNEL_6)

	wait_until(1684, 0x5d)
	speak(CHR_BOND, L_DEPO(74), 0x740e, CHANNEL_5, COLOR_04_ORANGE) // "No one could have predicted that! And I resent bei..."

	wait_until(1780, 0x5e)
	play_sound_from_object2(CHANNEL_6, 0x3a, 0x01d5, 0x00, 0x00)

	wait_until(2050, 0x60)
	play_sound_from_object2(CHANNEL_7, 0x3a, 0x00ec, 0x00, 0x00)

	wait_until(2070, 0x5f)
	open_door(0x3a)
	play_sound_from_object2(0x0a, 0x3a, 0x81b0, 0x00, 0x00)

	wait_until(2195, 0x61)
	play_sound(0x0171, CHANNEL_6)

	wait_until(2227, 0x62)
	play_sound(0x0172, CHANNEL_5)

	wait_until(2272, 0x63)
	play_sound(0x0173, CHANNEL_7)

	wait_until(2291, 0x64)
	play_sound(0x0161, CHANNEL_7)

	wait_until(2316, 0x65)
	speak(CHR_BOND, L_DEPO(75), 0x740f, CHANNEL_7, COLOR_03_RED) // "The President turned down your request for the loa..."

	wait_until(2342, 0x67)
	play_sound(0x0162, CHANNEL_6)
	close_door(0x3a)

	wait_until(2387, 0x68)
	play_sound(0x0163, CHANNEL_5)

	wait_until(2406, 0x69)
	play_sound(0x0163, CHANNEL_6)

	wait_until(2521, 0x6a)
	play_sound(0x0161, CHANNEL_5)

	wait_until(2547, 0x6b)
	play_sound(0x0162, CHANNEL_6)

	wait_until(2584, 0x6c)
	play_sound(0x0163, CHANNEL_7)

	wait_until(2586, 0x6d)
	play_sound(0x0164, CHANNEL_5)

	wait_until(2617, 0x6e)
	play_sound(0x0164, CHANNEL_5)

	wait_until(2662, 0x70)
	play_sound(0x0162, CHANNEL_6)

	wait_until(2668, 0x71)
	play_sound(0x0161, CHANNEL_5)

	wait_until(2692, 0x6f)
	speak(CHR_BOND, L_DEPO(76), 0x7410, CHANNEL_7, COLOR_03_RED) // "Could it be you overestimated your influence over ..."

	wait_until(2705, 0x72)
	play_sound(0x0161, CHANNEL_6)

	wait_until(2713, 0x73)
	play_sound(0x0162, CHANNEL_5)

	wait_until(2796, 0x74)
	play_sound(0x0161, CHANNEL_6)

	wait_until(2937, 0x75)
	play_sound(0x0164, CHANNEL_6)

	wait_until(2971, 0x76)
	play_sound(0x0162, CHANNEL_6)

	wait_until(3000, 0x77)
	play_sound(0x0162, CHANNEL_6)

	wait_until(3046, 0x78)
	play_sound(0x0163, CHANNEL_5)

	wait_until(3048, 0x79)
	speak(CHR_BOND, L_DEPO(77), 0x7411, CHANNEL_7, COLOR_05_GREEN) // "No! Perhaps I underestimated his resolve. We have ..."

	wait_until(3186, 0x7a)
	play_sound(0x0164, CHANNEL_6)

	wait_until(3378, 0x7b)
	play_sound(0x0162, CHANNEL_6)

	wait_until(3429, 0x7c)
	play_sound(0x0161, CHANNEL_6)

	wait_until(3481, 0x7d)
	play_sound(0x0162, CHANNEL_6)

	wait_until(3557, 0x7e)
	play_sound(0x0164, CHANNEL_6)

	wait_until(3628, 0x7f)
	play_sound(0x0163, CHANNEL_6)

	wait_until(3813, 0x80)
	play_sound(0x0161, CHANNEL_6)

	wait_until(3916, 0x81)
	play_sound(0x0162, CHANNEL_6)

	wait_until(4070, 0x82)
	speak(CHR_BOND, L_DEPO(78), 0x7412, CHANNEL_7, COLOR_04_ORANGE) // "Ha! Assuming you don't get any interference. If Ca..."

	wait_until(4312, 0x84)
	play_sound(0x0163, CHANNEL_6)

	wait_until(4370, 0x85)
	play_sound(0x0164, CHANNEL_5)

	wait_until(4440, 0x86)
	play_sound(0x0161, CHANNEL_6)

	wait_until(4510, 0x87)
	play_sound(0x0162, CHANNEL_6)

	wait_until(4555, 0x88)
	play_sound(0x0161, CHANNEL_7)

	wait_until(4560, 0x83)
	speak(CHR_BOND, L_DEPO(79), 0x7413, CHANNEL_5, COLOR_05_GREEN) // "There will be no outside help for Mr. Carrington. ..."

	wait_until(4636, 0x89)
	play_sound(0x0163, CHANNEL_7)

	wait_until(5017, 0x8a)
	play_sound(0x0164, CHANNEL_7)

	wait_until(5272, 0x8b)
	speak(CHR_BOND, L_DEPO(80), 0x7414, CHANNEL_5, COLOR_03_RED) // "Then the devices we gave you are working correctly..."

	wait_until(5360, 0x8c)
	play_sound(0x0163, CHANNEL_6)

	wait_until(5509, 0x8d)
	play_sound(0x0164, CHANNEL_6)

	wait_until(5897, 0x8e)
	play_sound(0x0161, CHANNEL_6)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2c)
		goto_next(0x54)
		label(0x2c)
		label(0x2c)
	endloop(0x08)

	label(0x54)
	label(0x06)
	restart_default_music
	reset_ambience
	enter_firstperson
	set_stage_flag(STAGEFLAG_MEETING_FINISHED)
	mute_channel(CHANNEL_10)
	mute_channel(CHANNEL_7)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_5)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	restart_timer
	label(0x06)
	set_ailist(CHR_CASS, AILIST_WALK_FROM_MEETING)

	beginloop(0x0e)
		if_timer_gt(140, /*goto*/ 0x06)
	endloop(0x0e)

	label(0x06)
	set_ailist(CHR_TRENT, AILIST_WALK_FROM_MEETING)

	beginloop(0x0f)
		if_timer_gt(300, /*goto*/ 0x06)
	endloop(0x0f)

	label(0x06)
	chr_move_to_pad(0x1e, 0x003c, 0x01, /*goto*/ 0x2c) // invalid chr?
	label(0x2c)
	set_ailist(CHR_BLONDE, AILIST_WALK_FROM_MEETING)
	set_ailist(CHR_STRIPES, AILIST_WALK_FROM_MEETING)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040f_outro_from_menu[] = {
	hide_object(OBJ_MINE1)
	hide_object(OBJ_MINE2)
	set_ailist(CHR_SELF, AILIST_OUTRO)
	endlist
};

u8 func040f_outro[] = {
	camera_movement(0x0196)
	set_music_track(MUSIC_G5_OUTRO)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0xf1, CHRCFLAG_HIDDEN)
	set_ailist(CHR_P1P2, GAILIST_IDLE)
	set_chr_chrflag(CHR_P1P2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_P1P2, CHRHFLAG_00020000)
	chr_do_animation(0x0197, -1, -1, 0x06, 0x00, CHR_P1P2, 4)
	set_chr_hudpiece_visible(CHR_P1P2, TRUE)
	restart_timer
	deactivate_alarm
	show_nonessential_chrs(FALSE)
	set_cutscene_weapon(CHR_P1P2, -1, -1)
	yield
	set_cutscene_weapon(CHR_P1P2, -1, 0x03)

	wait_until(20, 0x55)
	play_sound(0x0171, CHANNEL_6)

	wait_until(38, 0x57)
	play_sound(0x0173, CHANNEL_7)

	wait_until(69, 0x58)
	play_sound(0x0174, CHANNEL_6)

	wait_until(88, 0x5a)
	play_sound(0x0172, CHANNEL_6)

	wait_until(103, 0x5b)
	play_sound(0x0173, CHANNEL_7)

	wait_until(134, 0x5c)
	play_sound(0x0174, CHANNEL_6)

	wait_until(142, 0x5e)

	wait_until(162, 0x60)
	play_sound(0x0173, CHANNEL_7)

	wait_until(185, 0x61)
	play_sound(0x0174, CHANNEL_6)

	wait_until(204, 0x62)
	play_sound(0x0171, CHANNEL_7)

	wait_until(220, 0x63)
	play_sound(0x0172, CHANNEL_6)

	wait_until(256, 0x64)
	play_sound(0x0173, CHANNEL_7)

	wait_until(262, 0x65)
	play_sound(0x0174, CHANNEL_6)

	enable_rain(2)
	wait_until(273, 0x68)
	play_sound(0x0172, CHANNEL_7)

	wait_until(318, 0x6a)
	play_sound(0x0174, CHANNEL_6)

	wait_until(344, 0x6b)
	play_sound(0x0171, CHANNEL_7)

	wait_until(362, 0x6c)
	play_sound(0x0172, CHANNEL_6)

	wait_until(390, 0x6d)
	play_sound(0x0163, CHANNEL_7)

	wait_until(404, 0x6e)
	play_sound(0x0161, CHANNEL_6)

	wait_until(420, 0x70)
	play_sound(0x0162, CHANNEL_6)

	wait_until(468, 0x71)
	play_sound(0x0163, CHANNEL_7)

	wait_until(488, 0x72)
	play_sound(0x0164, CHANNEL_6)

	wait_until(679, 0x74)
	play_sound(0x0161, CHANNEL_6)

	wait_until(728, 0x56)

	wait_until(768, 0x73)
	speak(CHR_P1P2, L_DEPO(81), 0x7415, CHANNEL_7, COLOR_09_BLUE) // "Agent Dark reporting in! Prepare to receive a down..."

	wait_until(1280, 0x59)

	wait_until(1310, 0x75)
	speak(CHR_P1P2, L_DEPO(82), 0x7416, CHANNEL_7, COLOR_06_WHITE) // "No time for that now, Agent Dark. There's been a d..."

	wait_until(1780, 0x76)
	play_sound(0x0162, CHANNEL_6)

	wait_until(1841, 0x77)
	play_sound(0x0163, CHANNEL_6)

	wait_until(1883, 0x78)
	play_sound(0x0164, CHANNEL_6)

	wait_until(2600, 0x5d)

	wait_until(2630, 0x79)
	speak(CHR_P1P2, L_DEPO(83), 0x7417, CHANNEL_7, COLOR_09_BLUE) // "Area 51? But what about the President?"

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2c)
		goto_next(0x54)
		label(0x2c)
		if_controller_button_pressed(/*goto*/ 0x54)
		label(0x2c)
	endloop(0x08)

	label(0x54)
	label(0x06)
	set_chr_hudpiece_visible(CHR_P1P2, FALSE)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1018_intro_from_menu[] = {
	set_returnlist(CHR_SELF, GAILIST_END_CINEMA)
	set_ailist(CHR_SELF, AILIST_INTRO)
	endlist
};

u8 func1019_generator_hum[] = {
	yield
	assign_sound(0x8146, CHANNEL_4)
	play_sound_from_object(CHANNEL_4, OBJ_GENERATOR, 0x0640, 0x0898)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Not entirely sure what this does. It's probably the guards in the laser
 * switch area, and it probably controls which ones will run for the alarm.
 */
u8 func101a_init_laser_switch_guards[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x08)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x09)

	// Perfect Agent
	set_chr_flag_bankx(0x0c, CHRFLAG0_CAN_RUN_FOR_ALARM, BANK_0)
	set_chr_flag_bankx(0x0d, CHRFLAG0_CAN_RUN_FOR_ALARM, BANK_0)
	set_chr_flag_bankx(0x0e, CHRFLAG0_CAN_RUN_FOR_ALARM, BANK_0)
	goto_next(0x06)

	// Agent
	label(0x08)
	set_chr_flag_bankx(0x0e, CHRFLAG0_CAN_RUN_FOR_ALARM, BANK_0)
	set_chr_flag_bankx(0x0e, CHRFLAG0_UNSURPRISABLE, BANK_0)
	goto_next(0x06)

	// Special Agent
	label(0x09)
	set_chr_flag_bankx(0x0e, CHRFLAG0_CAN_RUN_FOR_ALARM, BANK_0)
	set_chr_flag_bankx(0x0d, CHRFLAG0_CAN_RUN_FOR_ALARM, BANK_0)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0412_cloak_guard[] = {
	set_morale(0)
	set_shotlist(AILIST_CLOAK_GUARD)
	set_chr_cloaked(CHR_SELF, TRUE, FALSE)
	if_chr_dying(CHR_SELF, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x03)

	// Dead
	label(0x06)
	goto_next(0x10)

	// Choose target
	label(0x03)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		label(0x06)
		restart_timer
		cmd0139(70, 0x02, TRUE)

		// Wait 3 seconds or until stopped
		beginloop(0x55)
			if_timer_gt(180, /*goto*/ 0x06)
			if_chr_stopped(/*goto*/ 0x06)
		endloop(0x55)

		// 50% chance of attacking immediately, 50% at 2 seconds
		label(0x06)
		stop_chr
		call_rng
		if_rand_gt(128, /*goto*/ 0x06)
		restart_timer

		beginloop(0x0e)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x0e)

		// Attacking
		label(0x06)
		if_morale_lt(3, /*goto*/ 0x2c)
		goto_next(0x06)

		label(0x2c)
		if_player_looking_at_something_maybe(0x0f, 0x01, 0x00, /*goto*/ 0x0e)
		label(0x06)
		if_in_disarm_range(/*goto*/ 0x2c)
		goto_next(0x0d)
		label(0x0e)
		add_morale(1)
		label(0x2c)
		restart_timer
		set_chr_cloaked(CHR_SELF, FALSE, TRUE)
		label(0x0a)
		label(0x2c)
		try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x2c)
		label(0x2c)
		try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x0b)

		beginloop(0x0b)
			if_chr_stopped(/*goto*/ 0x0c)
		endloop(0x0b)

		label(0x0c)
		set_morale(0)
		set_chr_cloaked(CHR_SELF, TRUE, TRUE)
		label(0x0d)
	goto_first(0x03)

	label(0x10)
	if_chr_has_hiddenflag(CHR_SELF, CHRHFLAG_CLOAKED, /*goto*/ 0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2c)
	set_chr_cloaked(CHR_SELF, FALSE, TRUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0413_cloak1_guard[] = {
	yield
	set_shotlist(AILIST_CLOAK_GUARD)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	label(0x06)
	set_reaction_speed(100)
	set_shotlist(AILIST_CLOAK_GUARD)
	restart_timer

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_distance_to_target_lt(400, /*goto*/ 0x06)
		if_jo_front_direction_lt(30, /*goto*/ 0x06)
		if_chr_in_view(/*goto*/ 0x06)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x2c)
		if_timer_gt(180, /*goto*/ 0x06)
		label(0x2c)
	endloop(0x04)

	label(0x06)
	unset_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_00040000)
	set_chr_cloaked(CHR_SELF, TRUE, TRUE)
	set_ailist(CHR_SELF, AILIST_CLOAK_GUARD)
	endlist
};

u8 func0414_init_cloak2_guard[] = {
	stop_chr
	set_shotlist(AILIST_CLOAK_GUARD)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(5)
	set_reaction_speed(25)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	unset_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_00040000)
	set_chr_cloaked(CHR_SELF, TRUE, TRUE)
	set_ailist(CHR_SELF, AILIST_CLOAK_GUARD)
	endlist
};

u8 func101b_cloak2_entry[] = {
	// Wait until in glass area of second cloak room
	beginloop(0x08)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x001a, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	lock_door(0x34, 0x10)
	lock_door(0x35, 0x10)
	lock_door(0x36, 0x10)
	lock_door(0x37, 0x10)
	set_object_flag2(0x34, OBJFLAG2_LOCKEDBACK)
	set_object_flag2(0x35, OBJFLAG2_LOCKEDBACK)
	set_object_flag2(0x36, OBJFLAG2_LOCKEDFRONT)
	set_object_flag2(0x37, OBJFLAG2_LOCKEDBACK)
	close_door(0x34)
	close_door(0x35)
	close_door(0x36)
	close_door(0x37)
	if_stage_flag_eq(STAGEFLAG_LIGHTS_OFF, TRUE, /*goto*/ 0x2c)
	play_sound(0x8147, -1)
	restart_timer
	set_lights_state(0x000b, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x000c, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x000d, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x000e, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x0010, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x000f, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x0011, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x0012, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x0013, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x0014, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x0015, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x0017, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x0018, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x0001, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x0003, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x0004, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x0005, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x0006, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x0007, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x0008, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x0009, 0x03, 0xff, 0x06, 0x78)
	set_lights_state(0x000a, 0x03, 0xff, 0x06, 0x78)

	// Wait 2 seconds
	beginloop(0x09)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	set_lights_state(0x000b, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x000c, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x000d, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x000e, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x0010, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x000f, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x0011, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x0012, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x0013, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x0014, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x0015, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x0017, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x0018, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x0001, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x0003, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x0004, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x0005, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x0006, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x0007, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x0008, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x0009, 0x01, 0x0a, 0x00, 0x00)
	set_lights_state(0x000a, 0x01, 0x0a, 0x00, 0x00)
	goto_next(0x07)

	label(0x2c)
	play_sound(0x8148, -1)
	set_lights_state(0x000b, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x000c, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x000d, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x000e, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0010, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x000f, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0011, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0012, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0013, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0014, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0015, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0017, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0018, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0001, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0003, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0004, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0005, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0006, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0007, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0008, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0009, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x000a, 0x03, 0x06, 0xff, 0x78)

	// Wait 2 seconds
	restart_timer

	beginloop(0x0a)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	set_lights_state(0x000b, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x000c, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x000d, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x000e, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0010, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x000f, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0011, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0012, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0013, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0014, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0015, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0017, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0018, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0001, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0003, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0004, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0005, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0006, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0007, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0008, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x0009, 0x01, 0xff, 0x00, 0x00)
	set_lights_state(0x000a, 0x01, 0xff, 0x00, 0x00)

	label(0x07)
	unset_chr_chrflag(CHR_CLOAK_2A, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_CLOAK_2B, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_CLOAK_2C, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_CLOAK_2D, CHRCFLAG_HIDDEN)
	set_ailist(CHR_CLOAK_2A, AILIST_CLOAK2_GUARD)
	set_ailist(CHR_CLOAK_2B, AILIST_CLOAK2_GUARD)
	set_ailist(CHR_CLOAK_2C, AILIST_CLOAK2_GUARD)
	set_ailist(CHR_CLOAK_2D, AILIST_CLOAK2_GUARD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0405_cloak2_hide[] = {
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101c_check_visited_top_door[] = {
	// Wait until decoder attached
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_DECODER_ATTACHED, TRUE, /*goto*/ 0x08)
	endloop(0x04)

	// Wait until player gone near top fire escape door
	beginloop(0x08)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_distance_to_pad_lt(CHR_P1P2, 400, 0x0058, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	set_stage_flag(STAGEFLAG_VISITED_TOP_DOOR)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101d_init_mines[] = {
	yield
	set_object_flag2(OBJ_MINE1, OBJFLAG2_00020000)
	set_object_flag2(OBJ_MINE2, OBJFLAG2_00020000)
	set_object_flag2(OBJ_MINE1, OBJFLAG2_INVISIBLE)
	set_object_flag2(OBJ_MINE2, OBJFLAG2_INVISIBLE)
	unset_object_flag(OBJ_MINE1, OBJFLAG_00000100)
	unset_object_flag(OBJ_MINE2, OBJFLAG_00000100)
	set_chr_team(CHR_ANTI, TEAM_ENEMY)

	label(0x06)
	if_savefile_flag_is_unset(SAVEFILEFLAG_G5_MINE, /*goto*/ 0x06)

	hide_object(OBJ_MINE1)
	dprint 'E','P','R','O','M','F','L','A','G',' ','N','O','T','S','E','T',0,
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	dprint 'E','P','R','O','M','F','L','A','G',' ','S','E','T',0,
	hide_object(OBJ_MINE2)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define init_guard(accuracy, reaction, function) \
	set_chr_dodge_rating(2, 0x0a) \
	set_accuracy(accuracy) \
	set_reaction_speed(reaction) \
	set_chr_maxdamage(CHR_SELF, 40) \
	add_health_or_armor(0) \
	set_recovery_speed(0) \
	set_shield(0) \
	set_ailist(CHR_SELF, function)



u8 func0406_init_type1_guard[] = {
	init_guard(5, 30, GAILIST_UNALERTED)
	endlist
};

// Never assigned
u8 func0407_init_type2_guard[] = {
	init_guard(15, 25, GAILIST_UNALERTED)
	endlist
};

u8 func0408_init_cloak1_guard[] = {
	init_guard(5, 25, 0x0413)
	endlist
};

u8 func101e_msg_nowaythrough[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_stage_flag_eq(STAGEFLAG_LASERSET1_DISABLED, FALSE, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_LASERSET2_DISABLED, FALSE, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_LASERSET3_DISABLED, FALSE, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_LASERSET4_DISABLED, FALSE, /*goto*/ 0x2c)
		reloop(0x04)

		label(0x2c)
		if_chr_in_room(CHR_P1P2, 0x00, 0x002f, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	speak(CHR_P1P2, L_DEPO(60), 0x73b4, CHANNEL_6, COLOR_09_BLUE) // "There's no way through while those lasers are acti..."
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101f_msg_meetingroomahead[] = {
	restart_timer

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_MEETING_HOLOGRAPHED, TRUE, /*goto*/ 0x0d)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x004c, /*goto*/ 0x2c)
		reloop(0x04)

		label(0x2c)
		if_chr_y(CHR_P1P2, 300, OPERATOR_LESS_THAN, /*goto*/ 0x06)
		goto_next(0x2c)
		label(0x06)
	endloop(0x04)

	label(0x2c)
	speak(CHR_P1P2, L_DEPO(61), 0x73b5, CHANNEL_6, COLOR_09_BLUE) // "That must be the meeting room up ahead. Time to us..."

	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1020_msg_heavilyencrypted[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0050, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	speak(CHR_P1P2, L_DEPO(62), 0x817c, CHANNEL_6, COLOR_09_BLUE) // "The safe's heavily encrypted. The decoder's gonna ..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1021_blow_mines[] = {
	// Wait for backup collected
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_stage_flag_eq(STAGEFLAG_BACKUP_COLLECTED, TRUE, /*goto*/ 0x2c)
	endloop(0x04)

	// Wait 2 seconds
	label(0x2c)
	restart_timer

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x2c)
	endloop(0x08)

	label(0x2c)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2c)
	speak(CHR_P1P2, L_DEPO(63), 0x73b7, CHANNEL_6, COLOR_09_BLUE) // "Time to leave! Let's get to the door I set up earl..."
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Agent
	label(0x2c)
	if_object_in_good_condition(OBJ_ESCAPEDOOR1, /*goto*/ 0x2c)
	goto_next(0x0d)

	label(0x2c)
	if_object_in_good_condition(OBJ_ESCAPEDOOR2, /*goto*/ 0x2c)
	goto_next(0x0d)

	label(0x2c)
	speak(CHR_P1P2, L_DEPO(65), 0x81a2, CHANNEL_6, COLOR_09_BLUE) // "Stand back, Joanna. We'll create your escape route..."
	restart_timer

	beginloop(0x09)
		if_timer_gt(120, /*goto*/ 0x2c)
	endloop(0x09)

	label(0x2c)
	destroy_object(OBJ_MINE1)
	destroy_object(OBJ_MINE2)
	restart_timer

	beginloop(0x0a)
		if_timer_gt(240, /*goto*/ 0x2c)
	endloop(0x0a)

	label(0x2c)
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1022_light_switch[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_LIGHTSWITCH, /*goto*/ 0x2c)
		reloop(0x04)

		label(0x2c)
		if_stage_flag_eq(STAGEFLAG_LIGHTS_OFF, TRUE, /*goto*/ 0x2c)

		// Turning lights off
		set_stage_flag(STAGEFLAG_LIGHTS_OFF)
		assign_sound(0x043f, CHANNEL_7)
		play_sound_from_entity(CHANNEL_7, OBJ_LIGHTSWITCH, 0x012c, 0x0190, 0x00)
		yield
		set_object_image(OBJ_LIGHTSWITCH, 0x00, 0x14)
		play_sound(0x8147, -1)
		set_lights_state(0x000b, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x000c, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x000d, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x000e, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x0010, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x000f, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x0011, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x0012, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x0013, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x0014, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x0015, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x0017, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x0018, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x0001, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x0003, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x0004, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x0005, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x0006, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x0007, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x0008, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x0009, 0x03, 0xff, 0x06, 0x78)
		set_lights_state(0x000a, 0x03, 0xff, 0x06, 0x78)

		restart_timer

		beginloop(0x09)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x09)

		label(0x06)
		set_lights_state(0x000b, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x000c, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x000d, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x000e, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x0010, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x000f, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x0011, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x0012, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x0013, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x0014, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x0015, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x0017, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x0018, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x0001, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x0003, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x0004, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x0005, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x0006, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x0007, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x0008, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x0009, 0x01, 0x0a, 0x00, 0x00)
		set_lights_state(0x000a, 0x01, 0x0a, 0x00, 0x00)
		goto_first(0x04)

		// Turning lights on
		label(0x2c)
		unset_stage_flag(STAGEFLAG_LIGHTS_OFF)
		assign_sound(0x043f, CHANNEL_7)
		play_sound_from_entity(CHANNEL_7, OBJ_LIGHTSWITCH, 0x012c, 0x0190, 0x00)
		yield
		play_sound(0x8148, -1)
		set_object_image(0x3d, 0x00, 0x06)
		set_lights_state(0x000b, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x000c, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x000d, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x000e, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x0010, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x000f, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x0011, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x0012, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x0013, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x0014, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x0015, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x0017, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x0018, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x0001, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x0003, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x0004, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x0005, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x0006, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x0007, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x0008, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x0009, 0x03, 0x06, 0xff, 0x78)
		set_lights_state(0x000a, 0x03, 0x06, 0xff, 0x78)

		restart_timer

		beginloop(0x0a)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x0a)

		label(0x06)
		set_lights_state(0x000b, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x000c, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x000d, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x000e, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x0010, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x000f, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x0011, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x0012, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x0013, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x0014, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x0015, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x0017, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x0018, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x0001, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x0003, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x0004, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x0005, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x0006, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x0007, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x0008, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x0009, 0x01, 0xff, 0x00, 0x00)
		set_lights_state(0x000a, 0x01, 0xff, 0x00, 0x00)
	endloop(0x04)

	endlist
};

u8 func1023_hide_nbomb_crate[] = {
	if_savefile_flag_is_unset(SAVEFILEFLAG_G5_MINE, /*goto*/ 0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	hide_object(OBJ_NBOMB_CRATE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Opens the laser doors in response to the stageflags changing.
 */
u8 unregistered_function[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_LASERSET1_DISABLED, FALSE, /*goto*/ 0x2c)
		if_door_state(OBJ_LASER_1A, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2c)
		open_door(OBJ_LASER_1A)
		open_door(OBJ_LASER_1B)
		open_door(OBJ_LASER_1C)
		open_door(OBJ_LASER_1D)
		label(0x2c)
		if_stage_flag_eq(STAGEFLAG_LASERSET2_DISABLED, FALSE, /*goto*/ 0x2c)
		if_door_state(OBJ_LASER_2A, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2c)
		open_door(OBJ_LASER_2A)
		open_door(OBJ_LASER_2B)
		open_door(OBJ_LASER_2C)
		open_door(OBJ_LASER_2D)
		label(0x2c)
		if_stage_flag_eq(STAGEFLAG_LASERSET3_DISABLED, FALSE, /*goto*/ 0x2c)
		if_door_state(OBJ_LASER_3A, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2c)
		open_door(OBJ_LASER_3A)
		open_door(OBJ_LASER_3B)
		open_door(OBJ_LASER_3C)
		open_door(OBJ_LASER_3D)
		label(0x2c)
		if_stage_flag_eq(STAGEFLAG_LASERSET4_DISABLED, FALSE, /*goto*/ 0x2c)
		if_door_state(OBJ_LASER_4A, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2c)
		open_door(OBJ_LASER_4A)
		open_door(OBJ_LASER_4B)
		open_door(OBJ_LASER_4C)
		open_door(OBJ_LASER_4D)
		label(0x2c)
	endloop(0x04)

	endlist
};

/**
 * I'm guessing co op buddies etc would get stuck in locked rooms after the
 * player has passed through them. So this just unlocks the doors once they've
 * been opened for the first time.
 */
u8 func1026_unlock_doors[] = {
	// If Velvet and counter op don't exist, return
	yield
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2c)
	goto_next(0x04)
	label(0x2c)
	if_chr_death_animation_finished(CHR_ANTI, /*goto*/ 0x0a)

	// Wait until some door is not closed (so... opening, I guess?)
	beginloop(0x04)
		if_door_state(0x43, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2c)
		if_door_state(0x44, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2c)
		if_door_state(0x45, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2c)
		if_door_state(0x46, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2c)
	endloop(0x04)

	// Unlock those doors
	label(0x2c)
	unlock_door(0x43, 0x04)
	unlock_door(0x44, 0x04)
	unlock_door(0x45, 0x04)
	unlock_door(0x46, 0x04)

	// New set of doors - wait until not closed
	beginloop(0x08)
		if_door_state(0x34, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2c)
		if_door_state(0x35, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2c)
		if_door_state(0x36, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2c)
		if_door_state(0x37, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2c)
	endloop(0x08)

	// Unlock them
	label(0x2c)
	unlock_door(0x34, 0x04)
	unlock_door(0x35, 0x04)
	unlock_door(0x36, 0x04)
	unlock_door(0x37, 0x04)

	// Third set of doors
	beginloop(0x09)
		if_door_state(0x3f, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2c)
		if_door_state(0x40, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x2c)
	endloop(0x09)

	label(0x2c)
	unlock_door(0x3f, 0x10)
	unlock_door(0x40, 0x10)

	label(0x0a)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0410_invincible[] = {
	label(0x04)
	yield
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0411_hide[] = {
	label(0x04)
	yield
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1027_cloak1_check_one_remaining[] = {
	// Wait until either cloak guard dying (in first room)
	beginloop(0x04)
		if_chr_dying(CHR_CLOAK_1A, /*goto*/ 0x2c)
		if_chr_death_animation_finished(CHR_CLOAK_1A, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_CLOAK_1A, /*goto*/ 0x2c)
		if_chr_dying(CHR_CLOAK_1B, /*goto*/ 0x2c)
		if_chr_death_animation_finished(CHR_CLOAK_1B, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_CLOAK_1B, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	set_stage_flag(STAGEFLAG_CLOAK1_ONE_REMAINING)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1028_cloak2_check_one_remaining[] = {
	// Count number of dead cloak guards in second room
	beginloop(0x04)
		set_morale(0)
		if_chr_dying(CHR_CLOAK_2A, /*goto*/ 0x2c)
		if_chr_death_animation_finished(CHR_CLOAK_2A, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_CLOAK_2A, /*goto*/ 0x2c)
		goto_next(0x06)

		label(0x2c)
		add_morale(1)
		label(0x06)
		if_chr_dying(CHR_CLOAK_2B, /*goto*/ 0x2c)
		if_chr_death_animation_finished(CHR_CLOAK_2B, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_CLOAK_2B, /*goto*/ 0x2c)
		goto_next(0x06)

		label(0x2c)
		add_morale(1)
		label(0x06)
		if_chr_dying(CHR_CLOAK_2C, /*goto*/ 0x2c)
		if_chr_death_animation_finished(CHR_CLOAK_2C, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_CLOAK_2C, /*goto*/ 0x2c)
		goto_next(0x06)

		label(0x2c)
		add_morale(1)
		label(0x06)
		if_chr_dying(CHR_CLOAK_2D, /*goto*/ 0x2c)
		if_chr_death_animation_finished(CHR_CLOAK_2D, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_CLOAK_2D, /*goto*/ 0x2c)
		goto_next(0x06)

		label(0x2c)
		add_morale(1)
		label(0x06)
		if_morale_lt(3, /*goto*/ 0x2c)
		set_stage_flag(STAGEFLAG_CLOAK2_ONE_REMAINING)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x2c)
	endloop(0x04)

	endlist
};

u8 func1029_set_secret_weapon_props[] = {
	yield
	set_object_flag3(OBJ_NBOMB_CRATE, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(OBJ_CROSSBOW, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102a_8174[] = {
	// Wait until some door opening
	beginloop(0x08)
		if_door_state(0x3f, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2c)
	endloop(0x08)

	label(0x2c)
	set_chr_hiddenflag(0x07, CHRHFLAG_08000000)
	set_chr_hiddenflag(0x0c, CHRHFLAG_08000000)
	set_chr_hiddenflag(0x0d, CHRHFLAG_08000000)
	set_chr_hiddenflag(0x0e, CHRHFLAG_08000000)
	set_chr_hiddenflag(0x0f, CHRHFLAG_08000000)
	set_chr_hiddenflag(0x10, CHRHFLAG_08000000)
	set_chr_hiddenflag(0x11, CHRHFLAG_08000000)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102b_81bc[] = {
	// Wait until some door opening
	beginloop(0x08)
		if_door_state(0x3f, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2c)
	endloop(0x08)

	label(0x2c)
	set_chr_team(0x08, TEAM_ENEMY)
	set_chr_team(0x09, TEAM_ENEMY)
	set_chr_team(0x0a, TEAM_ENEMY)
	set_chr_team(0x0b, TEAM_ENEMY)
	set_chr_team(0x07, TEAM_ENEMY)
	set_chr_team(0x0c, TEAM_ENEMY)
	set_chr_team(0x0d, TEAM_ENEMY)
	set_chr_team(0x0e, TEAM_ENEMY)
	set_chr_team(0x0f, TEAM_ENEMY)
	set_chr_team(0x10, TEAM_ENEMY)
	set_chr_team(0x11, TEAM_ENEMY)
	set_chr_team(0x12, TEAM_ENEMY)
	set_chr_team(0x13, TEAM_ENEMY)
	set_chr_team(0x14, TEAM_ENEMY)
	set_chr_team(0x15, TEAM_ENEMY)
	set_chr_team(0x16, TEAM_ENEMY)
	set_chr_team(0x17, TEAM_ENEMY)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * I suspect Rare screwed up here. I think the lightswitch guard starts off as
 * an ally so that he won't respond to Jo making noise in the first cloak room.
 * Then when he becomes alerted to you (such as you shooting near him) he'd
 * become an enemy.
 *
 * However, it's checking if the alertness is less than, so this condition
 * passes immediately and he becomes an enemy. This could be why he's sometimes
 * left his pad by the time you leave the first room.
 */
u8 func102c_set_lightswitch_guard_team[] = {
	beginloop(0x08)
		if_chr_alertness_lt(99, CHR_LIGHTSWITCH_GUARD, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	set_chr_team(CHR_LIGHTSWITCH_GUARD, TEAM_ENEMY)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

struct ailist ailists[] = {
	{ func0401_init_swat1,                 0x0401 },
	{ func0402_init_swat2,                 0x0402 },
	{ func0403_walk_from_meeting,          0x0403 },
	{ func0404_run_from_meeting,           0x0404 },
	{ func0405_cloak2_hide,                0x0405 },
	{ func0406_init_type1_guard,           0x0406 },
	{ func0407_init_type2_guard,           0x0407 },
	{ func0408_init_cloak1_guard,          0x0408 },
	{ func0409_start_path00,               0x0409 },
	{ func040a_start_path01,               0x040a },
	{ func040b_start_path02,               0x040b },
	{ func040c_start_path03,               0x040c },
	{ func1400_setup_counterop,            0x1400 },
	{ func1001_objectives_failed_msg,      0x1001 },
	{ func1002_set_ai,                     0x1002 },
	{ func1003_laser_switch_1,             0x1003 },
	{ func1004_laser_switch_2,             0x1004 },
	{ func1005_laser_switch_3,             0x1005 },
	{ func1006_laser_switch_4,             0x1006 },
	{ func1007_init_lasers,                0x1007 },
	{ func1008_check_generator,            0x1008 },
	{ func1009_spawner_during_decode,      0x1009 },
	{ func100a_give_keycards,              0x100a },
	{ func100b_check_backup_collected,     0x100b },
	{ func100c_check_for_meeting_trigger,  0x100c },
	{ func100e_check_conspirators_alerted, 0x100e },
	{ func100f_alarm_switches,             0x100f },
	{ func1010_safe_cracking,              0x1010 },
	{ func1012_check_for_end,              0x1012 },
	{ func1013_check_escape_doors,         0x1013 },
	{ func1014_check_camspy_location,      0x1014 },
	{ func1017_check_lasers_closed,        0x1017 },
	{ func1018_intro_from_menu,            0x1018 },
	{ func1019_generator_hum,              0x1019 },
	{ func101a_init_laser_switch_guards,   0x101a },
	{ func101b_cloak2_entry,               0x101b },
	{ func101c_check_visited_top_door,     0x101c },
	{ func101d_init_mines,                 0x101d },
	{ func101e_msg_nowaythrough,           0x101e },
	{ func101f_msg_meetingroomahead,       0x101f },
	{ func1020_msg_heavilyencrypted,       0x1020 },
	{ func1021_blow_mines,                 0x1021 },
	{ func1022_light_switch,               0x1022 },
	{ func1023_hide_nbomb_crate,           0x1023 },
	{ func1026_unlock_doors,               0x1026 },
	{ func1027_cloak1_check_one_remaining, 0x1027 },
	{ func1028_cloak2_check_one_remaining, 0x1028 },
	{ func1029_set_secret_weapon_props,    0x1029 },
	{ func102a_8174,                       0x102a },
	{ func102b_81bc,                       0x102b },
	{ func102c_set_lightswitch_guard_team, 0x102c },
	{ func040d_intro,                      0x040d },
	{ func040e_meeting_cutscene,           0x040e },
	{ func040f_outro,                      0x040f },
	{ func0410_invincible,                 0x0410 },
	{ func0411_hide,                       0x0411 },
	{ func0412_cloak_guard,                0x0412 },
	{ func0413_cloak1_guard,               0x0413 },
	{ func0414_init_cloak2_guard,          0x0414 },
	{ func1018_intro_from_menu,            0x0c00 },
	{ func040e_meeting_cutscene,           0x0c01 },
	{ func040f_outro_from_menu,            0x0c02 },
	{ NULL, 0 },
};

struct path paths[] = {
	{ path00, 0, PATHTYPE_CIRCULAR },
	{ path01, 1, PATHTYPE_CIRCULAR },
	{ path02, 2, PATHTYPE_CIRCULAR },
	{ path03, 3, PATHTYPE_CIRCULAR },
	{ NULL, 0, 0 },
};

