//
// Pelagic II
//

#include "stagesetup.h"

// Characters
#define CHR_ELVIS       0x00
#define CHR_INTRO_GUARD 0x02
#define CHR_PILOT1      0x3c
#define CHR_PILOT2      0x3e
#define CHR_PILOT3      0x3f
#define CHR_LABTECH1    0x4e
#define CHR_LABTECH3    0x4f
#define CHR_LABTECH2    0x50
#define CHR_ANGRY_PILOT 0x60

// Objects
#define OBJ_BADHATCHSWITCH1 0x08
#define OBJ_BADHATCHSWITCH2 0x09
#define OBJ_BADHATCHSWITCH3 0x0a
#define OBJ_BADHATCHSWITCH4 0x0b
#define OBJ_HATCHSWITCH1    0x0c
#define OBJ_HATCHSWITCH2    0x0d
#define OBJ_HATCHSWITCH3    0x0e
#define OBJ_HATCHSWITCH4    0x0f
#define OBJ_REACTOR_SWITCH  0x13
#define OBJ_RESEARCHDATA1   0x14
#define OBJ_RESEARCHDATA2   0x15
#define OBJ_RESEARCHDATA3   0x16
#define OBJ_LIFT_SWITCH     0x17
#define OBJ_MOONPOOL_SWITCH 0x1a
#define OBJ_OUTRO_SUBMARINE 0x1b
#define OBJ_OUTRO_GRATE     0x1c
#define OBJ_OUTRO_CRATE1    0x1d
#define OBJ_OUTRO_CRATE2    0x1e
#define OBJ_REACTOR_HATCH   0x26

// Stage flags
#define STAGEFLAG_ELVIS_WARPED_FROM_START    0x00000001
#define STAGEFLAG_TRIGGER_ANGRY_PILOT        0x00000002
#define STAGEFLAG_MOONPOOL_SWITCH_DESTROYED  0x00000004
#define STAGEFLAG_GPS_DISABLED               0x00000100
#define STAGEFLAG_AUTOPILOT_DISABLED         0x00000200
#define STAGEFLAG_00000400                   0x00000400
#define STAGEFLAG_REACTOR_HATCH_OPEN         0x00000800
#define STAGEFLAG_REACTOR_SHUT_DOWN          0x00001000
#define STAGEFLAG_LOCATED_DIVING_AREA        0x00002000
#define STAGEFLAG_COLLECTED_RESEARCH_DATA    0x00004000
#define STAGEFLAG_LABTECH_DEAD               0x00008000
#define STAGEFLAG_SAID_PULLTHEPLUG           0x00010000
#define STAGEFLAG_SAID_SWITCHTHINGOFF        0x00020000
#define STAGEFLAG_PILOT_DEAD                 0x00040000
#define STAGEFLAG_00080000                   0x00080000
#define STAGEFLAG_MOONPOOL_ACTIVATED         0x00100000
#define STAGEFLAG_LIFT_UNLOCKED              0x00200000
#define STAGEFLAG_HATCHSWITCH1_ACTIVATED     0x00400000
#define STAGEFLAG_HATCHSWITCH2_ACTIVATED     0x00800000
#define STAGEFLAG_HATCHSWITCH3_ACTIVATED     0x01000000
#define STAGEFLAG_HATCHSWITCH4_ACTIVATED     0x02000000
#define STAGEFLAG_HATCHSWITCHES_RESETTING    0x04000000
#define STAGEFLAG_MET_ELVIS                  0x08000000
#define STAGEFLAG_ELVIS_APPEARED_AT_MOONPOOL 0x10000000
#define STAGEFLAG_ELVIS_DEAD                 0x20000000
#define STAGEFLAG_JO_KILLED_A_PILOT          0x40000000
#define STAGEFLAG_REACTOR_SWITCH_DESTROYED   0x80000000

// AI Lists
#define AILIST_PILOT                 0x0401
#define AILIST_INIT_PILOT            0x0402
#define AILIST_PILOT_DYING           0x0403
#define AILIST_ANGRY_PILOT           0x0404
#define AILIST_GUARD_UNALERTED       0x0408
#define AILIST_LABTECH1              0x040b
#define AILIST_LABTECH2              0x040c
#define AILIST_LABTECH3              0x040d
#define AILIST_INIT_LABTECH1         0x040e
#define AILIST_INIT_LABTECH2         0x040f
#define AILIST_INIT_LABTECH3         0x0410
#define AILIST_LABTECH_ALERTED       0x0411
#define AILIST_HIDE                  0x0412
#define AILIST_GUARD_ALERTED         0x0413
#define AILIST_OUTRO                 0x0414
#define AILIST_ELVIS_AT_START        0x0415
#define AILIST_ELVIS_LEADING         0x0416
#define AILIST_ELVIS_PREPARE_LEADING 0x0417
#define AILIST_ELVIS_AT_MOONPOOL     0x0418

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x1601)
	briefing(1, 0x1600)
	briefing(2, 0x1602)
	briefing(3, 0x1603)

	beginobjective(0, L_DAM(6), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Disable primary power source"
		complete_flags(STAGEFLAG_REACTOR_SHUT_DOWN)
		fail_flags(STAGEFLAG_REACTOR_SWITCH_DESTROYED)
	endobjective

	beginobjective(1, L_DAM(7), (DIFFBIT_PA | DIFFBIT_PD)) // "Secure laboratories and research data"
		complete_flags(STAGEFLAG_COLLECTED_RESEARCH_DATA)
		fail_flags(STAGEFLAG_LABTECH_DEAD)
	endobjective

	beginobjective(2, L_DAM(5), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Deactivate GPS and autopilot"
		complete_flags(STAGEFLAG_GPS_DISABLED)
		complete_flags(STAGEFLAG_AUTOPILOT_DISABLED)
		fail_flags(STAGEFLAG_00000400)
		fail_flags(STAGEFLAG_PILOT_DEAD)
		fail_flags(STAGEFLAG_JO_KILLED_A_PILOT)
	endobjective

	beginobjective(3, L_DAM(8), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Activate Moon Pool lift"
		complete_flags(STAGEFLAG_MOONPOOL_ACTIVATED)
		fail_flags(STAGEFLAG_MOONPOOL_SWITCH_DESTROYED)
	endobjective

	beginobjective(4, L_DAM(9), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Rendezvous and escape with Elvis"
		complete_flags(STAGEFLAG_LOCATED_DIVING_AREA)
		fail_flags(STAGEFLAG_ELVIS_DEAD)
	endobjective

	chr(0x00010400, 0x00, 0x0024, BODY_THEKING, HEAD_ELVIS_GOGS, GAILIST_IDLE, -1, -1, 1000, 200, 0x00002000, 0xc0300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAIANPISTOL, 0x0000, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_PHOENIX, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x02, 0x0027, BODY_PELAGIC_GUARD, HEAD_MOTO, GAILIST_IDLE, -1, -1, 1000, 200, 0x00002000, 0x00300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0002, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FARSIGHTXR20, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2e, 0x014e, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc000a601, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2d, 0x014d, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, 0x0214, -1, 1000, 100, 0xc0042000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2f, 0x014f, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, 0x0215, -1, 1000, 100, 0xc40c2000, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x30, 0x0150, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, 0x0215, -1, 1000, 100, 0xc40c2008, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0030, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x31, 0x0151, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, 0x0215, -1, 1000, 100, 0xc40c2000, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0031, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x32, 0x0152, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, 0x0215, -1, 1000, 100, 0xc40c2008, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0032, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x33, 0x0153, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, 0x0216, -1, 1000, 100, 0xc40c2400, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0033, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x34, 0x0154, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, 0x0216, -1, 1000, 100, 0xc40c2000, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0034, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x35, 0x0155, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, 0x0216, -1, 1000, 100, 0xc40c2008, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0035, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x38, 0x0158, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, 0x0217, -1, 1000, 7, 0xc40c2400, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0038, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x39, 0x0159, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, 0x0217, -1, 1000, 7, 0xc40c2000, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0039, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x3a, 0x015a, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, 0x0217, -1, 1000, 100, 0xc40c2000, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x003a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x3b, 0x015b, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, 0x0217, -1, 1000, 100, 0xc40c2000, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x003b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x36, 0x0156, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, 0x0218, -1, 1000, 100, 0xc00c8609, 0x00000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0036, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x37, 0x0157, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, 0x0218, -1, 1000, 100, 0xc00c8601, 0x00000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0037, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x51, 0x0002, BODY_PELAGIC_GUARD, HEAD_RANDOM, 0x0405, -1, -1, 1000, 100, 0x8c000000, 0x02000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0051, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x52, 0x0027, BODY_PELAGIC_GUARD, HEAD_RANDOM, 0x0405, -1, -1, 1000, 100, 0xc8000000, 0x02000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0052, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x53, 0x0028, BODY_PELAGIC_GUARD, HEAD_RANDOM, 0x0405, -1, -1, 1000, 100, 0xa8800000, 0x02000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0053, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x57, 0x00df, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 100, 0xcc080000, 0x02000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0057, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x58, 0x00dc, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 100, 0xcc080000, 0x02000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0058, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x59, 0x00eb, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 100, 0xcc080000, 0x02000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0059, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x5a, 0x00e8, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 100, 0xcc080000, 0x02000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x005a, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x5b, 0x0142, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, 0x0213, -1, 100, 100, 0x8d002000, 0x00004000, TEAM_NONCOMBAT, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x005b, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x5c, 0x0143, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, 0x0213, -1, 100, 100, 0x8d002000, 0x00004000, TEAM_NONCOMBAT, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x005c, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x5d, 0x0144, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, 0x0213, -1, 100, 100, 0x8d002000, 0x00004000, TEAM_NONCOMBAT, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x005d, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x5e, 0x0145, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, 0x0213, -1, 100, 100, 0x8d002000, 0x00004000, TEAM_NONCOMBAT, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x005e, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x03, 0x011f, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0xc0088400, 0x00000000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0003, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x04, 0x0120, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0004, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x24, 0x0140, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0024, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x25, 0x0141, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0025, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x05, 0x0121, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0005, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x06, 0x0122, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0006, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x07, 0x0123, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0007, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x08, 0x0124, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0008, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x09, 0x0125, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0009, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x0a, 0x0126, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0b, 0x0127, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x0c, 0x0128, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0d, 0x0129, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x0e, 0x012a, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0f, 0x012b, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x10, 0x012c, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0010, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x11, 0x012d, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0011, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x12, 0x012e, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0012, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x13, 0x012f, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0013, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x14, 0x0130, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0014, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x15, 0x0131, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0015, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x16, 0x0132, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0016, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x17, 0x0133, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0017, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x18, 0x0134, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x40082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0018, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x19, 0x0135, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x40082000, 0x00000000, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0019, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x1a, 0x0136, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1b, 0x0137, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x1c, 0x0138, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1d, 0x0139, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x1e, 0x013a, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1f, 0x013b, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x20, 0x013c, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0020, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x21, 0x013d, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0021, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x22, 0x013e, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0022, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x23, 0x013f, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 10, 0x50082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0023, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2c, 0x014c, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc8008000, 0x00000080, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2b, 0x014b, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc8008000, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2a, 0x014a, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc8008000, 0x00000000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x29, 0x0149, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc8008000, 0x00000000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0029, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x54, 0x0004, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 100, 100, 0xc8008000, 0x02000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0054, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x28, 0x0148, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc8008000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0028, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x27, 0x0147, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc8008000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0027, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x26, 0x0146, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc8008000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0026, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x45, 0x0165, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc000c000, 0x00000000, TEAM_04, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0045, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x46, 0x0166, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc000c000, 0x00000000, TEAM_04, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0046, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00010400, 0x3c, 0x015c, BODY_PILOTAF1, HEAD_RANDOM, AILIST_INIT_PILOT, -1, -1, 1000, 10, 0x4000c000, 0x00000000, TEAM_04, SQUADRON_02, -1, 0, 0x00000000)
	chr(0x00010400, 0x3e, 0x015e, BODY_PILOTAF1, HEAD_RANDOM, AILIST_INIT_PILOT, -1, -1, 1000, 10, 0x4000c000, 0x00000000, TEAM_04, SQUADRON_02, -1, 0, 0x00000000)
	chr(0x00010400, 0x3f, 0x015f, BODY_PILOTAF1, HEAD_RANDOM, AILIST_INIT_PILOT, -1, -1, 1000, 10, 0x4000c000, 0x00000000, TEAM_04, SQUADRON_02, -1, 0, 0x00000000)
	chr(0x00000200, 0x41, 0x0161, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc000c000, 0x00000000, TEAM_04, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0041, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x42, 0x0162, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc000c000, 0x00000000, TEAM_04, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0042, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x43, 0x0163, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc000c000, 0x00000000, TEAM_04, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0043, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x44, 0x0164, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc000c000, 0x00000000, TEAM_04, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0044, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x47, 0x0167, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc4080000, 0x00000000, TEAM_04, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0047, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x48, 0x0168, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc4080000, 0x00000000, TEAM_04, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0048, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x49, 0x0169, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc4080000, 0x00000000, TEAM_04, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0049, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x4a, 0x016a, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc4080000, 0x00000000, TEAM_04, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x004a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x4b, 0x016b, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc4080000, 0x00000000, TEAM_04, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x004b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x4c, 0x016c, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc4080000, 0x00000000, TEAM_04, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x004c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x4d, 0x016d, BODY_PELAGIC_GUARD, HEAD_RANDOM, AILIST_GUARD_UNALERTED, -1, -1, 1000, 100, 0xc4080000, 0x00000080, TEAM_04, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x004d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x55, 0x0012, BODY_PELAGIC_GUARD, HEAD_RANDOM, 0x0407, -1, -1, 100, 100, 0xc4080000, 0x02000000, TEAM_04, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0055, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x56, 0x0014, BODY_PELAGIC_GUARD, HEAD_RANDOM, 0x0407, -1, -1, 100, 100, 0xc4080000, 0x02000000, TEAM_04, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0056, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00010400, 0x4e, 0x0209, BODY_DD_LABTECH, HEAD_RANDOM, AILIST_INIT_LABTECH1, 0x00d8, -1, 1000, 100, 0xc0008601, 0x00000000, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	chr(0x00010400, 0x50, 0x0055, BODY_DD_LABTECH, HEAD_RANDOM, AILIST_INIT_LABTECH2, 0x0089, -1, 1000, 100, 0xc0008601, 0x00000000, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x01000000)
	chr(0x00010400, 0x4f, 0x0057, BODY_DD_LABTECH, HEAD_RANDOM, AILIST_INIT_LABTECH3, 0x008b, -1, 1000, 100, 0xc0008601, 0x00000000, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x02000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x00f0, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x00f1, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x00f2, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x00f3, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x00f4, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR2, 0x00f5, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x00f6, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x00f7, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x00f8, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x00f9, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x00fa, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x29, 1)
	door(0x0100, MODEL_PELAGICDOOR2, 0x00fb, 0x10000400, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000080, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x2a, 1)
	door(0x0100, MODEL_PELAGICDOOR2, 0x00fc, 0x10000400, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000080, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x2b, 1)
	door(0x0100, MODEL_PELAGICDOOR2, 0x010a, 0x10000400, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000080, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x2c, 1)
	door(0x0100, MODEL_PELAGICDOOR2, 0x0112, 0x10000400, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000080, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x2d, 1)
	door(0x0100, MODEL_PELAGICDOOR2, 0x0101, 0x10000400, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000080, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x00fd, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x00fe, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x00ff, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x0100, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x18, 2)
	tag(0x19, 2)
	door(0x0100, MODEL_BIGPELAGICDOOR, 0x0103, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_BIGPELAGICDOOR, 0x0102, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x0104, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x0105, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x0106, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x0107, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x0108, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x0109, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x010b, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x010c, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x010d, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x010e, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x010f, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x0110, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x0111, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x0113, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x0114, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x0115, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x0116, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x0117, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x0118, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x0119, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x011a, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x011c, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_PELAGICDOOR, 0x011b, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00020000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x012c0320, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0180, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x017f, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x017e, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x017d, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x017c, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x017b, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x017a, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0179, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0178, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0177, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0176, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0175, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0174, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0173, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0172, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0171, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0170, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x016f, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x016e, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0181, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0182, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0186, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0187, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0185, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0183, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0189, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0188, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x018b, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0184, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x018a, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x018c, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x018d, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x018e, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x018f, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0191, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0192, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0193, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0194, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0195, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0196, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0197, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0198, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0199, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x019a, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x019b, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x019c, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x019d, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x019e, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x019f, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01a0, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01a1, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01a2, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01a3, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01a4, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01a5, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01a6, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01a7, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01a8, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01ab, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01ac, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01ad, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01ae, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01af, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01b0, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01b1, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01b2, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01b3, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01b4, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01b6, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01b7, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01b8, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01b9, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01ba, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01bb, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01bc, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01bd, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01be, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01c1, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01c2, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01c3, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01c4, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01c5, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01c6, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01c7, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01c8, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01d4, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01d5, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01d6, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01d7, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01d8, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01d9, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01da, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01db, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01dc, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01dd, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01de, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01df, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01e0, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01e1, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01e2, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x01e3, 0x004001e1, 0x00000200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x01e6, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x01e7, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x01e8, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x01e9, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x01ea, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x01eb, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x01ec, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x01f1, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x01ed, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x01ee, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x01ef, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x01f0, 0x000205e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x00, 8)
	tag(0x01, 8)
	tag(0x02, 8)
	tag(0x03, 8)
	tag(0x04, 8)
	tag(0x05, 8)
	tag(0x06, 8)
	tag(0x07, 8)
	multimonitor(0x0099, MODEL_COMHUB, 0x01f2, 0x00020002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x13131300)
	multimonitor(0x0099, MODEL_COMHUB, 0x01f3, 0x00020002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x13131300)
	multimonitor(0x0099, MODEL_COMHUB, 0x01f4, 0x00020002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x13131300)
	multimonitor(0x0099, MODEL_COMHUB, 0x01f5, 0x00020002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x13131300)
	multimonitor(0x0099, MODEL_COMHUB, 0x01f6, 0x00020002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x13131300)
	multimonitor(0x0099, MODEL_COMHUB, 0x01f7, 0x00020002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x13131300)
	multimonitor(0x0099, MODEL_COMHUB, 0x01f8, 0x00020002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x13131300)
	multimonitor(0x0099, MODEL_COMHUB, 0x01f9, 0x00020002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x13131300)
	tag(0x08, 1)
	tag(0x09, 1)
	tag(0x0a, 1)
	tag(0x0b, 1)
	tag(0x0c, 1)
	tag(0x0d, 1)
	tag(0x0e, 1)
	tag(0x0f, 1)
	tag(0x13, 1)
	multimonitor(0x0099, MODEL_COMHUB, 0x01fa, 0x000000e2, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x13131300)
	tag(0x14, 1)
	key(0x0080, MODEL_CHRBRIEFCASE, 0x004e, 0x01244000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	rename_object(-1, 0x43, L_DAM(22), L_DAM(23), L_DAM(24), L_DAM(25), L_DAM(26), 0x0000, 0x0000) // ""
	tag(0x15, 1)
	key(0x0080, MODEL_CHRBRIEFCASE, 0x0050, 0x01244000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	rename_object(-1, 0x43, L_DAM(22), L_DAM(23), L_DAM(24), L_DAM(25), L_DAM(26), 0x0000, 0x0000) // ""
	tag(0x16, 1)
	key(0x0080, MODEL_CHRBRIEFCASE, 0x004f, 0x01244000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	rename_object(-1, 0x43, L_DAM(22), L_DAM(23), L_DAM(24), L_DAM(25), L_DAM(26), 0x0000, 0x0000) // ""
	tag(0x21, 5)
	tag(0x22, 5)
	tag(0x23, 5)
	tag(0x24, 5)
	tag(0x25, 5)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x01fb, 0x10000002, 0x00204000, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff14)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x01fc, 0x10000002, 0x00204000, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff14)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x01fd, 0x10000002, 0x00204000, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff14)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x01fe, 0x10000002, 0x00204000, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff14)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x01ff, 0x10000002, 0x00204000, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff14)
	tag(0x17, 1)
#if VERSION >= VERSION_PAL_FINAL
	// ............................................................... v
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x0200, 0x10000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
#else
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x0200, 0x10000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
#endif
	tag(0x1a, 1)
#if VERSION >= VERSION_PAL_FINAL
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x0201, 0x10000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
#else
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x0201, 0x10000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
#endif
	camera(0x00c0, MODEL_CCTV_PD, 0x0219, 0x0000000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x01f70000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00004000, 0x00000000, 0x00000000, 0x0000001e, 0x00000000, 0x000002bc, 0x00000000)
	camera(0x00c0, MODEL_CCTV_PD, 0x021a, 0x0000000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x00dd0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00004000, 0x00000000, 0x00000000, 0x0000001e, 0x00000000, 0x000002bc, 0x00000000)
	camera(0x00c0, MODEL_CCTV_PD, 0x021b, 0x0000000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x000a0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000238e, 0x00000000, 0x00000000, 0x0000001e, 0x00000000, 0x000002bc, 0x00000000)
	camera(0x00c0, MODEL_CCTV_PD, 0x021c, 0x0000000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x01120000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000002bc, 0x00000000)
	tag(0x1b, 1)
	stdobject(0x0100, MODEL_SUBMARINE, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1c, 1)
	stdobject(0x0100, MODEL_DD_GRATE, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1d, 1)
	stdobject(0x0065, MODEL_A51_CRATE1, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1e, 1)
	stdobject(0x0065, MODEL_A51_CRATE1, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x26, 1)
	stdobject(0x0100, MODEL_COREHATCH, 0x011e, 0x004005f1, 0x00004300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x021f, 0x00000062, 0x00002001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0220, 0x00000062, 0x00002001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0221, 0x00000062, 0x00002001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0222, 0x00000062, 0x00002001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0223, 0x00000062, 0x00002001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0224, 0x00000062, 0x00002001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x1f, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x021d, 0x00000001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x20, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x021e, 0x00000001, 0x000000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x27, 2)
	tag(0x28, 2)
	weapon(0x0100, MODEL_CHRFALCON2SCOPE, 0x0034, 0x20004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2_SILENCER, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRFALCON2SCOPE, 0x0034, 0x20004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2_SILENCER, 0x00ffffff, 0x00000000)
	link_collectibles(-1, -2)
	endprops
};

s32 intro[] = {
	outfit(OUTFIT_WETSUIT)
	intro_weapon(WEAPON_FALCON2_SILENCER, -1)
	ammo(AMMOTYPE_PISTOL, 100)
	intro_weapon(WEAPON_LAPTOPGUN, -1)
	ammo(AMMOTYPE_SMG, 100)
	ammo(AMMOTYPE_NBOMB, 3)
	intro_weapon(WEAPON_XRAYSCANNER, -1)
	intro_weapon(WEAPON_NBOMB, -1)
	spawn(0x0046)
	endintro
};

s32 path00[] = {
	0x0002,
	0x0001,
	0x0024,
	0x0027,
	0x002b,
	0x0028,
	0x002d,
	0x002e,
	0x002c,
	-1,
};

s32 path01[] = {
	0x0004,
	0x0008,
	0x000a,
	0x0006,
	0x0007,
	0x000b,
	-1,
};

s32 path02[] = {
	0x0012,
	0x0010,
	0x0011,
	0x0014,
	0x0015,
	0x0016,
	0x0017,
	0x0013,
	-1,
};

s32 path03[] = {
	0x00dd,
	0x00de,
	0x00df,
	0x00e0,
	0x00d9,
	0x00db,
	0x00dc,
	-1,
};

s32 path04[] = {
	0x00e8,
	0x00e7,
	0x00e6,
	0x00e5,
	0x00eb,
	0x00ea,
	0x00e9,
	-1,
};

struct path paths[] = {
	{ path00, 0, PATHTYPE_CIRCULAR },
	{ path01, 1, PATHTYPE_BACKANDFORTH },
	{ path02, 2, PATHTYPE_CIRCULAR },
	{ path03, 3, PATHTYPE_CIRCULAR },
	{ path04, 4, PATHTYPE_CIRCULAR },
	{ NULL, 0, 0 },
};

u8 func1001_objectives_failed_msg[] = {
	yield
	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_01000000)
	set_chr_chrflag(CHR_LABTECH1, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_LABTECH2, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_LABTECH3, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_PILOT1, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_PILOT2, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_PILOT3, CHRCFLAG_04000000)
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

u8 func1400_setup_counterop[] = {
	yield
	set_chr_team(CHR_ANTI, TEAM_ENEMY)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func0408_guard_unalerted[] = {
	set_chr_cloaked(CHR_SELF, FALSE, TRUE)
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(18)
	set_reaction_speed(60)
	set_chr_maxdamage(CHR_SELF, 70)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func1002_intro[] = {
	set_music_track(MUSIC_PELAGIC_INTRO)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	camera_movement(0x02ce)
	cmd0175(60)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x02cf, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	chr_do_animation(0x02d0, -1, -1, 0x06, 0x00, CHR_ELVIS, 4)
	set_chr_chrflag(CHR_INTRO_GUARD, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_INTRO_GUARD, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_INTRO_GUARD, CHRHFLAG_00020000)
	chr_do_animation(0x02d1, -1, -1, 0x06, 0x00, CHR_INTRO_GUARD, 4)
	restart_timer
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_FALCON2_SILENCER, WEAPON_NONE)

	#define wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0x39) \
			if_timer_gt(time, /*goto*/ 0x04) \
		endloop(loopid) \
		label(0x04)



	wait_until(342, 0x3b)
	play_sound(0x0171, CHANNEL_7)

	wait_until(390, 0x3c)
	play_sound(0x0172, CHANNEL_6)

	wait_until(438, 0x3d)
	play_sound(0x0173, CHANNEL_5)

	wait_until(484, 0x48)
	play_sound(0x0174, CHANNEL_7)

	wait_until(532, 0x4a)
	play_sound(0x0175, CHANNEL_5)

	wait_until(574, 0x4b)
	play_sound(0x0176, CHANNEL_7)

	wait_until(616, 0x49)
	play_sound(0x0177, CHANNEL_6)

	wait_until(660, 0x4c)
	play_sound(0x0178, CHANNEL_6)

	wait_until(712, 0x4d)
	play_sound(0x0171, CHANNEL_5)

	wait_until(760, 0x4e)
	play_sound(0x0172, CHANNEL_7)

	wait_until(812, 0x4f)
	play_sound(0x0173, CHANNEL_6)

	wait_until(1386, 0x50)
	play_sound(0x0171, CHANNEL_5)

	wait_until(1482, 0x51)
	play_sound(0x0172, CHANNEL_7)

	wait_until(1628, 0x52)
	play_sound(0x0173, CHANNEL_6)

	wait_until(1698, 0x53)
	play_sound(0x0174, CHANNEL_5)

	wait_until(1860, 0x54)
	play_sound(0x05a8, CHANNEL_7)

	wait_until(2180, 0x55)
	play_sound(0x05a9, CHANNEL_6)

	wait_until(2260, 0x57)
	play_sound(0x05aa, CHANNEL_7)

	wait_until(2274, 0x58)
	play_sound(0x0175, CHANNEL_6)

	wait_until(2280, 0x59)
	play_sound(0x0176, CHANNEL_5)

	wait_until(2294, 0x56)
	play_sound(0x0177, CHANNEL_5)

	wait_until(2298, 0x5a)
	play_sound(0x0171, CHANNEL_7)

	wait_until(2316, 0x5b)
	play_sound(0x0178, CHANNEL_6)

	wait_until(2474, 0x5c)
	play_sound(0x0172, CHANNEL_5)

	wait_until(2489, 0x5d)
	play_sound(0x01db, CHANNEL_7)

	wait_until(2572, 0x5e)
	play_sound(0x0171, CHANNEL_6)

	wait_until(2616, 0x5f)
	play_sound(0x0173, CHANNEL_5)

	wait_until(2644, 0x60)
	play_sound(0x0172, CHANNEL_5)

	beginloop(0x0b)
		if_camera_animating(/*goto*/ 0x07)
		goto_next(0x39)

		label(0x07)
		if_controller_button_pressed(/*goto*/ 0x39)
		label(0x07)
	endloop(0x0b)

	label(0x39)
	mute_channel(CHANNEL_10)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x02cf, -2, -1, 0x06, 0x00, CHR_BOND, 2)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	chr_do_animation(0x02d0, -2, -1, 0x06, 0x00, CHR_ELVIS, 2)
	unset_chr_chrflag(CHR_INTRO_GUARD, CHRCFLAG_UNPLAYABLE)
	hide_chr(CHR_INTRO_GUARD)
	enter_firstperson
	yield
	set_ailist(CHR_ELVIS, AILIST_ELVIS_AT_START)
	restart_timer

	beginloop(0x0c)
		if_timer_gt(60, /*goto*/ 0x04)
	endloop(0x0c)

	label(0x04)
	restart_default_music
	reset_ambience
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0c01_outro[] = {
	camera_movement(0x02e2)
	set_music_track(MUSIC_PELAGIC_OUTRO)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0xf1, CHRCFLAG_HIDDEN)
	set_ailist(CHR_P1P2, GAILIST_IDLE)
	set_chr_chrflag(CHR_P1P2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_P1P2, CHRHFLAG_00020000)
	chr_do_animation(0x02e3, -1, -1, 0x06, 0x00, CHR_P1P2, 4)
	set_ailist(CHR_ELVIS, GAILIST_IDLE)
	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	chr_do_animation(0x02e4, -1, -1, 0x06, 0x00, CHR_ELVIS, 4)

	show_object(OBJ_OUTRO_SUBMARINE)
	set_object_flag2(OBJ_OUTRO_SUBMARINE, OBJFLAG2_04000000)
	set_object_flag3(OBJ_OUTRO_SUBMARINE, OBJFLAG3_00000010)
	object_do_animation(0x02e5, OBJ_OUTRO_SUBMARINE, 0x04, 0xffff)

	show_object(OBJ_OUTRO_GRATE)
	set_object_flag2(OBJ_OUTRO_GRATE, OBJFLAG2_04000000)
	set_object_flag3(OBJ_OUTRO_GRATE, OBJFLAG3_00000010)
	object_do_animation(0x02e6, OBJ_OUTRO_GRATE, 0x04, 0xffff)

	show_object(OBJ_OUTRO_CRATE1)
	set_object_flag2(OBJ_OUTRO_CRATE1, OBJFLAG2_04000000)
	set_object_flag3(OBJ_OUTRO_CRATE1, OBJFLAG3_00000010)
	object_do_animation(0x02e7, OBJ_OUTRO_CRATE1, 0x04, 0xffff)

	show_object(OBJ_OUTRO_CRATE2)
	set_object_flag2(OBJ_OUTRO_CRATE2, OBJFLAG2_04000000)
	set_object_flag3(OBJ_OUTRO_CRATE2, OBJFLAG3_00000010)
	object_do_animation(0x02e8, OBJ_OUTRO_CRATE2, 0x04, 0xffff)

	set_cutscene_weapon(CHR_P1P2, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_P1P2, WEAPON_NONE, WEAPON_NONE)
	set_cutscene_weapon(CHR_ELVIS, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_ELVIS, WEAPON_NONE, WEAPON_NONE)
	show_nonessential_chrs(FALSE)
	restart_timer

	wait_until(46, 0x3c)
	play_sound(0x0171, CHANNEL_10)

	wait_until(160, 0x3d)
	play_sound(0x0172, CHANNEL_10)
	play_sound_from_object2(0x0a, OBJ_OUTRO_SUBMARINE, 0x042d, 0x00, 0x00)

	wait_until(180, 0x3b)
	speak(CHR_BOND, L_DAM(39), 0x7465, CHANNEL_10, COLOR_06_WHITE) // "Right. The diving operation has been disrupted on ..."

	wait_until(200, 0x48)
	play_sound(0x0173, CHANNEL_10)

	wait_until(232, 0x49)
	play_sound(0x0174, CHANNEL_10)

	wait_until(254, 0x4a)
	play_sound(0x0172, CHANNEL_10)

	wait_until(272, 0x66)

	wait_until(374, 0x4b)
	play_sound(0x0172, CHANNEL_10)

	wait_until(415, 0x4c)
	play_sound(0x0173, CHANNEL_10)

	wait_until(454, 0x4d)
	play_sound(0x0174, CHANNEL_10)

	wait_until(532, 0x4e)
	play_sound(0x0171, CHANNEL_10)

	wait_until(570, 0x4f)
	speak(CHR_BOND, L_DAM(40), 0x7466, CHANNEL_10, COLOR_09_BLUE) // "I hope the government don't want to use this ship ..."

	wait_until(582, 0x50)
	play_sound(0x0171, CHANNEL_10)

	wait_until(666, 0x51)
	play_sound(0x0172, CHANNEL_10)

	wait_until(706, 0x52)
	play_sound(0x0173, CHANNEL_10)

	wait_until(736, 0x64)
	play_sound(0x05a8, CHANNEL_10)

	wait_until(806, 0x53)
	play_sound(0x809f, CHANNEL_10)

	wait_until(854, 0x54)
	play_sound(0x0174, CHANNEL_10)

	wait_until(876, 0x55)
	play_sound(0x0173, CHANNEL_10)

	wait_until(906, 0x56)
	play_sound(0x0172, CHANNEL_10)

	wait_until(926, 0x57)
	play_sound(0x80a2, CHANNEL_10)

	wait_until(950, 0x58)
	speak(CHR_BOND, L_DAM(41), 0x7467, CHANNEL_10, COLOR_06_WHITE) // "Do you think we were a little heavy-handed?"

	wait_until(1088, 0x59)
	play_sound(0x80a3, CHANNEL_10)

	wait_until(1152, 0x5a)
	play_sound(0x0176, CHANNEL_10)

	wait_until(1190, 0x5b)
	speak(CHR_BOND, L_DAM(42), 0x7468, CHANNEL_10, COLOR_09_BLUE) // "Naaahhhh."

	wait_until(1228, 0x5c)
	play_sound(0x0174, CHANNEL_10)

	wait_until(1258, 0x5d)
	play_sound(0x0172, CHANNEL_10)

	wait_until(1260, 0x5e)
	play_sound(0x05b4, CHANNEL_10)

	wait_until(1300, 0x5f)
	play_sound(0x05b6, CHANNEL_10)
	play_sound(0x0171, CHANNEL_10)

	wait_until(1309, 0x65)
	play_sound(0x0172, CHANNEL_10)

	wait_until(1358, 0x60)
	play_sound(0x0171, CHANNEL_10)

	wait_until(1382, 0x61)
	play_sound(0x8098, CHANNEL_10)

	wait_until(1480, 0x62)
	play_sound(0x80a3, CHANNEL_10)

	wait_until(1480, 0x63)
	play_sound_from_object2(0x0a, OBJ_OUTRO_GRATE, 0x00c1, 0x00, 0x00)

	wait_until(1500, 0x67)
	play_sound_from_object2(0x0a, OBJ_OUTRO_SUBMARINE, 0x042d, 0x00, 0x00)

	wait_until(1590, 0x68)
	play_sound_from_object2(0x0a, OBJ_OUTRO_SUBMARINE, 0x0434, 0x00, 0x00)

	beginloop(0x0b)
		if_camera_animating(/*goto*/ 0x07)
		goto_next(0x39)

		label(0x07)
		if_controller_button_pressed(/*goto*/ 0x39)
		label(0x07)
	endloop(0x0b)

	label(0x39)
	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_P1P2, CHRHFLAG_00020000)
	chr_do_animation(0x02cf, -2, -1, 0x06, 0x00, CHR_P1P2, 2)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	chr_do_animation(0x02d0, -2, -1, 0x06, 0x00, CHR_ELVIS, 2)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 unregistered_function1[] = {
	label(0x00)
	yield
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1004_msg_controlledfrom[] = {
	restart_timer
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0027, /*goto*/ 0x07)
	endloop(0x00)

	label(0x07)
	speak(CHR_P1P2, L_DAM(11), 0x73d1, CHANNEL_6, COLOR_09_BLUE) // "This must be where the sub's controlled from."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1005_msg_withoutautopilot[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x007e, /*goto*/ 0x07)
	endloop(0x00)

	label(0x07)
	speak(CHR_P1P2, L_DAM(12), 0x73d2, CHANNEL_6, COLOR_09_BLUE) // "Without the autopilot and the GPS, the ship will w..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1006_msg_conductoperations[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x007f, /*goto*/ 0x07)
	endloop(0x00)

	label(0x07)
	speak(CHR_P1P2, L_DAM(13), 0x73d3, CHANNEL_6, COLOR_09_BLUE) // "They'll be unable to conduct any operations withou..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 unregistered_function2[] = {
	// These are invalid object IDs
	beginloop(0x00)
		if_object_in_good_condition(0x11, /*goto*/ 0x07)
		goto_next(0x04)

		label(0x07)
		if_object_in_good_condition(0x10, /*goto*/ 0x07)
		goto_next(0x04)

		label(0x07)
	endloop(0x00)

	label(0x04)
	show_hudmsg(CHR_BOND, L_DAM(16)) // "Critical mission object has been destroyed."
	set_stage_flag(STAGEFLAG_00000400)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1009_open_reactor_hatch[] = {
	// Wait for all switches active
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_stage_flag_eq(STAGEFLAG_HATCHSWITCH1_ACTIVATED, TRUE, /*goto*/ 0x07)
		reloop(0x00)

		label(0x07)
		if_stage_flag_eq(STAGEFLAG_HATCHSWITCH2_ACTIVATED, TRUE, /*goto*/ 0x07)
		reloop(0x00)

		label(0x07)
		if_stage_flag_eq(STAGEFLAG_HATCHSWITCH3_ACTIVATED, TRUE, /*goto*/ 0x07)
		reloop(0x00)

		label(0x07)
		if_stage_flag_eq(STAGEFLAG_HATCHSWITCH4_ACTIVATED, TRUE, /*goto*/ 0x07)
	endloop(0x00)

	label(0x07)
	hide_object(OBJ_REACTOR_HATCH)
	set_object_flag2(OBJ_REACTOR_HATCH, OBJFLAG2_INVISIBLE)
	show_hudmsg(CHR_P1P2, L_DAM(17)) // "Reactor shutdown control hatch opened."
	set_stage_flag(STAGEFLAG_REACTOR_HATCH_OPEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100a_reactor_switch[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_object_in_good_condition(OBJ_REACTOR_SWITCH, /*goto*/ 0x07)
		show_hudmsg(CHR_BOND, L_DAM(36)) // "Critical mission object has been destroyed."
		set_stage_flag(STAGEFLAG_REACTOR_SWITCH_DESTROYED)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x07)
		if_chr_activated_object(CHR_P1P2, OBJ_REACTOR_SWITCH, /*goto*/ 0x07)
		reloop(0x00)

		label(0x07)
		if_stage_flag_eq(STAGEFLAG_REACTOR_HATCH_OPEN, TRUE, /*goto*/ 0x07)
	endloop(0x00)

	label(0x07)
	mute_channel(CHANNEL_0)
	mute_channel(CHANNEL_1)
	assign_sound(0x8147, CHANNEL_0)
	control_sound_from_object(CHANNEL_0, OBJ_REACTOR_SWITCH, TRUE)
	set_lights_state(0x007f, 0x03, 0xff, 0x06, 0x78)
	set_object_image(OBJ_REACTOR_SWITCH, 0x00, 0x12)
	set_object_image(OBJ_REACTOR_SWITCH, 0x01, 0x12)
	set_object_image(OBJ_REACTOR_SWITCH, 0x02, 0x12)
	show_hudmsg(CHR_P1P2, L_DAM(18)) // "Reactor has been shut down."
	set_stage_flag(STAGEFLAG_REACTOR_SHUT_DOWN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100b_check_diving_area_located[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_stage_flag_eq(STAGEFLAG_MET_ELVIS, TRUE, /*goto*/ 0x07)
		reloop(0x00)

		label(0x07)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0064, /*goto*/ 0x07)
		reloop(0x00)

		label(0x07)
		if_chr_distance_to_pad_lt(CHR_P1P2, 600, 0x0095, /*goto*/ 0x07)
		if_chr_distance_to_pad_lt(CHR_P1P2, 600, 0x0096, /*goto*/ 0x07)
	endloop(0x00)

	label(0x07)
	show_hudmsg(CHR_P1P2, L_DAM(19)) // "Diving control center has been located."
	set_stage_flag(STAGEFLAG_LOCATED_DIVING_AREA)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100c_check_end_level[] = {
	beginloop(0x6f)
		if_objective_complete(0, /*goto*/ 0x07)
		reloop(0x6f)

		label(0x07)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x07)
		if_objective_complete(1, /*goto*/ 0x07)
		reloop(0x6f)

		label(0x07)
		if_objective_complete(2, /*goto*/ 0x07)
		reloop(0x6f)

		label(0x07)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x07)
		if_objective_complete(3, /*goto*/ 0x07)
	endloop(0x6f)

	label(0x07)

	beginloop(0x3b)
		if_stage_flag_eq(STAGEFLAG_ELVIS_WARPED_FROM_START, TRUE, /*goto*/ 0x07)
	endloop(0x3b)

	label(0x07)
	if_stage_flag_eq(STAGEFLAG_ELVIS_APPEARED_AT_MOONPOOL, TRUE, /*goto*/ 0x00)
	set_stage_flag(STAGEFLAG_ELVIS_APPEARED_AT_MOONPOOL)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_ELVIS, AILIST_ELVIS_AT_MOONPOOL)

	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0064, /*goto*/ 0x07)
		reloop(0x00)

		label(0x07)
		if_chr_distance_to_pad_lt(CHR_P1P2, 600, 0x0095, /*goto*/ 0x07)
		if_chr_distance_to_pad_lt(CHR_P1P2, 600, 0x0096, /*goto*/ 0x07)
		reloop(0x00)

		label(0x07)
		if_all_objectives_complete(/*goto*/ 0x07)
	endloop(0x00)

	label(0x07)
	restart_timer

	beginloop(0x0b)
		if_timer_gt(120, /*goto*/ 0x07)
	endloop(0x0b)

	label(0x07)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x07)
	if_chr_dying(CHR_BOND, /*goto*/ 0x07)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x07)
	goto_next(0x08)

	label(0x07)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x07)
	if_chr_dying(CHR_COOP, /*goto*/ 0x07)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x07)

	// Jo or Velvet alive
	label(0x08)
	if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x08)
	if_chr_dying(CHR_ELVIS, /*goto*/ 0x08)
	if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x08)

	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x07)
	if_chr_dying(CHR_BOND, /*goto*/ 0x07)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x07)
	goto_next(0x04)

	// Both players dead - this check is redundant
	label(0x07)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x07)
	if_chr_dying(CHR_COOP, /*goto*/ 0x07)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x07)
	goto_next(0x04)

	// Both players dead
	label(0x07)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Mission complete
	label(0x04)
	set_invincible(CHR_BOND)
	set_ailist(CHR_SELF, AILIST_OUTRO)

	// Elvis dead
	label(0x08)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100e_check_labtech_dead[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x0b)

	beginloop(0x00)
		if_chr_death_animation_finished(CHR_LABTECH1, /*goto*/ 0x07)
		if_chr_dying(CHR_LABTECH1, /*goto*/ 0x07)
		if_chr_death_animation_finished(CHR_LABTECH2, /*goto*/ 0x07)
		if_chr_dying(CHR_LABTECH2, /*goto*/ 0x07)
		if_chr_death_animation_finished(CHR_LABTECH3, /*goto*/ 0x07)
		if_chr_dying(CHR_LABTECH3, /*goto*/ 0x07)
	endloop(0x00)

	label(0x07)
	show_hudmsg(CHR_BOND, L_DAM(20)) // "Critical mission personnel killed."
	set_stage_flag(STAGEFLAG_LABTECH_DEAD)
	label(0x0b)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100f_check_researchdata_collected[] = {
	beginloop(0x00)
		if_chr_has_object(CHR_BOND, OBJ_RESEARCHDATA1, /*goto*/ 0x07)
		if_chr_has_object(CHR_COOP, OBJ_RESEARCHDATA1, /*goto*/ 0x07)
		reloop(0x00)

		label(0x07)
		if_chr_has_object(CHR_BOND, OBJ_RESEARCHDATA2, /*goto*/ 0x07)
		if_chr_has_object(CHR_COOP, OBJ_RESEARCHDATA2, /*goto*/ 0x07)
		reloop(0x00)

		label(0x07)
		if_chr_has_object(CHR_BOND, OBJ_RESEARCHDATA3, /*goto*/ 0x07)
		if_chr_has_object(CHR_COOP, OBJ_RESEARCHDATA3, /*goto*/ 0x07)
	endloop(0x00)

	label(0x07)
	show_hudmsg(CHR_BOND, L_DAM(21)) // "Research data has been secured."
	set_stage_flag(STAGEFLAG_COLLECTED_RESEARCH_DATA)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define init_path(pathid) \
	set_chr_dodge_rating(2, 0x0a) \
	set_accuracy(18) \
	set_reaction_speed(60) \
	set_chr_maxdamage(CHR_SELF, 70) \
	add_health_or_armor(0) \
	set_recovery_speed(0) \
	set_shield(0) \
	assign_path(pathid) \
	start_path \
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)



u8 func0405_start_path00[] = {
	init_path(0)
	endlist
};

u8 func0409_start_path03[] = {
	set_chr_cloaked(CHR_SELF, FALSE, TRUE)
	init_path(3)
	endlist
};

u8 func040a_start_path04[] = {
	set_chr_cloaked(CHR_SELF, FALSE, TRUE)
	init_path(4)
	endlist
};

u8 func0406_start_path01[] = {
	init_path(1)
	endlist
};

u8 func0407_start_path02[] = {
	init_path(2)
	endlist
};

#define labtech_logic(function, pad1, pad2, pad3) \




u8 func040e_init_labtech1[] = {
	set_self_chrflag(CHRCFLAG_04000000)
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_LABTECH1)
	endlist
};

u8 func040b_labtech1[] = {
	set_shotlist(AILIST_LABTECH1)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x07)
	if_chr_dying(CHR_SELF, /*goto*/ 0x07)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x07)
	goto_next(0x04)

	// Dying
	label(0x07)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x04)

	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x0f)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x0f)
		if_chr_stopped(/*goto*/ 0x04)
		goto_next(0x07)
		label(0x04)
		if_chr_idle(/*goto*/ 0x07)
		call_rng
		if_rand_lt(128, /*goto*/ 0x27)
		call_rng
		if_rand_lt(86, /*goto*/ 0x3b)
		if_rand_lt(172, /*goto*/ 0x3c)

		chr_do_animation(ANIM_OPERATE_0206, -1, -1, 0x02, 0x10, CHR_SELF, 2)
		goto_next(0x07)

		label(0x3b)
		chr_do_animation(ANIM_OPERATE_0204, -1, -1, 0x02, 0x10, CHR_SELF, 2)
		goto_next(0x07)

		label(0x3c)
		chr_do_animation(ANIM_OPERATE_0205, -1, -1, 0x02, 0x10, CHR_SELF, 2)
		goto_next(0x07)

		label(0x27)
		call_rng
		if_rand_lt(86, /*goto*/ 0x3b)
		if_rand_lt(172, /*goto*/ 0x3c)

		if_chr_distance_to_pad_lt(CHR_SELF, 200, 0x0209, /*goto*/ 0x3b)
		walk_to_pad(0x0209)
		goto_next(0x07)

		label(0x3b)
		if_chr_distance_to_pad_lt(CHR_SELF, 200, 0x020a, /*goto*/ 0x3c)
		walk_to_pad(0x020a)
		goto_next(0x07)

		label(0x3c)
		if_chr_distance_to_pad_lt(CHR_SELF, 200, 0x020b, /*goto*/ 0x07)
		walk_to_pad(0x020b)
		goto_next(0x07)

		label(0x07)
	endloop(0x00)

	label(0x0f)
	set_ailist(CHR_SELF, AILIST_LABTECH_ALERTED)
	endlist
};

u8 func040f_init_labtech2[] = {
	set_self_chrflag(CHRCFLAG_04000000)
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_LABTECH2)
	endlist
};

u8 func040c_labtech2[] = {
	set_shotlist(AILIST_LABTECH2)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x07)
	if_chr_dying(CHR_SELF, /*goto*/ 0x07)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x07)
	goto_next(0x04)

	// Dying
	label(0x07)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x04)

	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x0f)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x0f)
		if_chr_stopped(/*goto*/ 0x04)
		goto_next(0x07)
		label(0x04)
		if_chr_idle(/*goto*/ 0x07)
		call_rng
		if_rand_lt(128, /*goto*/ 0x27)
		call_rng
		if_rand_lt(86, /*goto*/ 0x3b)
		if_rand_lt(172, /*goto*/ 0x3c)

		chr_do_animation(ANIM_OPERATE_0206, -1, -1, 0x02, 0x10, CHR_SELF, 2)
		goto_next(0x07)

		label(0x3b)
		chr_do_animation(ANIM_OPERATE_0204, -1, -1, 0x02, 0x10, CHR_SELF, 2)
		goto_next(0x07)

		label(0x3c)
		chr_do_animation(ANIM_OPERATE_0205, -1, -1, 0x02, 0x10, CHR_SELF, 2)
		goto_next(0x07)

		label(0x27)
		call_rng
		if_rand_lt(86, /*goto*/ 0x3b)
		if_rand_lt(172, /*goto*/ 0x3c)

		if_chr_distance_to_pad_lt(CHR_SELF, 200, 0x020c, /*goto*/ 0x3b)
		walk_to_pad(0x020c)
		goto_next(0x07)

		label(0x3b)
		if_chr_distance_to_pad_lt(CHR_SELF, 200, 0x020d, /*goto*/ 0x3c)
		walk_to_pad(0x020d)
		goto_next(0x07)

		label(0x3c)
		if_chr_distance_to_pad_lt(CHR_SELF, 200, 0x020e, /*goto*/ 0x07)
		walk_to_pad(0x020e)
		goto_next(0x07)

		label(0x07)
	endloop(0x00)

	label(0x0f)
	set_ailist(CHR_SELF, AILIST_LABTECH_ALERTED)
	endlist
};

u8 func0410_init_labtech3[] = {
	set_self_chrflag(CHRCFLAG_04000000)
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_LABTECH3)
	endlist
};

u8 func040d_labtech3[] = {
	// @bug: Wrong onshot function. Under normal gameplay this labtech has 1HP
	// anyway and will die in one shot. Theroetically, if you use PD mode with
	// max health and shoot him with a weak weapon then he will start running to
	// lab tech 1's pads.
	set_shotlist(AILIST_LABTECH1)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x07)
	if_chr_dying(CHR_SELF, /*goto*/ 0x07)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x07)
	goto_next(0x04)

	// Dying
	label(0x07)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x04)

	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x0f)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x10)
		if_chr_stopped(/*goto*/ 0x04)
		goto_next(0x07)
		label(0x04)
		if_chr_idle(/*goto*/ 0x07)
		call_rng
		if_rand_lt(128, /*goto*/ 0x27)
		call_rng
		if_rand_lt(86, /*goto*/ 0x3b)
		if_rand_lt(172, /*goto*/ 0x3c)

		chr_do_animation(ANIM_OPERATE_0206, -1, -1, 0x02, 0x10, CHR_SELF, 2)
		goto_next(0x07)

		label(0x3b)
		chr_do_animation(ANIM_OPERATE_0204, -1, -1, 0x02, 0x10, CHR_SELF, 2)
		goto_next(0x07)

		label(0x3c)
		chr_do_animation(ANIM_OPERATE_0205, -1, -1, 0x02, 0x10, CHR_SELF, 2)
		goto_next(0x07)

		label(0x27)
		call_rng
		if_rand_lt(86, /*goto*/ 0x3b)
		if_rand_lt(172, /*goto*/ 0x3c)

		if_chr_distance_to_pad_lt(CHR_SELF, 200, 0x020f, /*goto*/ 0x3b)
		walk_to_pad(0x020f)
		goto_next(0x07)

		label(0x3b)
		if_chr_distance_to_pad_lt(CHR_SELF, 200, 0x0210, /*goto*/ 0x3c)
		walk_to_pad(0x0210)
		goto_next(0x07)

		label(0x3c)
		if_chr_distance_to_pad_lt(CHR_SELF, 200, 0x0211, /*goto*/ 0x07)
		walk_to_pad(0x0211)
		goto_next(0x07)

		label(0x07)
	endloop(0x00)

	label(0x10)
	set_alertness(100)

	label(0x0f)
	set_ailist(CHR_SELF, AILIST_LABTECH_ALERTED)
	endlist
};

u8 func0411_labtech_alerted[] = {
	restart_timer
	label(0x0b)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x0c)

	beginloop(0x0c)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x04)
		if_timer_gt(60, /*goto*/ 0x04)
	endloop(0x0c)

	label(0x04)
	if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x04)
	set_alertness(100)
	dprint 'T','A','L','K',' ','1','\n',0,
	say_quip(CHR_BOND, 0x2a, 0xff, 0x02, 0xff, BANK_1, 0x00, 0x00)
	chr_do_animation(ANIM_SURRENDER_002E, 0, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x3e)
		if_timer_gt(90, /*goto*/ 0x04)
	endloop(0x3e)

	// Already alert (eg. by gunfire)
	label(0x04)
	try_set_chrpreset_to_unalerted_teammate(0, /*goto*/ 0x3f)
	goto_next(0x42)

	label(0x3f)
	try_run_to_chr(CHR_PRESET, /*goto*/ 0x40)
	goto_next(0x42)

	beginloop(0x40)
		if_detected_chr(CHR_PRESET, /*goto*/ 0x41)
		if_chr_stopped(/*goto*/ 0x41)
	endloop(0x40)

	label(0x41)
	increase_squadron_alertness(100)
	say_quip(CHR_BOND, 0x10, 0xff, 0x02, 0xff, BANK_0, 0x00, 0x00)

	label(0x42)
	go_to_target_pad(SPEED_RUN)

	beginloop(0x10)
		if_chr_stopped(/*goto*/ 0x13)
	endloop(0x10)

	label(0x13)
	restart_timer
	if_chr_sees_player(/*goto*/ 0x07)
	goto_next(0x00)

	label(0x07)
	set_target_chr(CHR_P1P2)
	if_distance_to_target_lt(300, /*goto*/ 0x04)

	label(0x00)
	chr_do_animation(ANIM_COWER_0229, -1, -1, 0x10, 0x0a, CHR_SELF, 2)

	beginloop(0x11)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_timer_gt(1200, /*goto*/ 0x0d)
		if_chr_sees_player(/*goto*/ 0x07)
		goto_next(0x00)

		label(0x07)
		if_distance_to_target_lt(300, /*goto*/ 0x04)
		label(0x00)
		if_chr_stopped(/*goto*/ 0x07)
	endloop(0x11)

	label(0x07)
	goto_first(0x13)

	label(0x0d)
	goto_first(0x42)

	label(0x04)
	retreat(SPEED_RUN, 2)
	restart_timer

	beginloop(0x14)
		if_timer_gt(600, /*goto*/ 0x07)
	endloop(0x14)

	label(0x07)
	goto_first(0x13)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0412_hide[] = {
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1010_alarm_responders[] = {
	yield
	yield
	set_chr_hiddenflag(0x57, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x58, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x59, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x5a, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x5b, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x5c, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x5d, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x5e, CHRHFLAG_CLOAKED)
	hide_chr(0x57)
	hide_chr(0x58)
	hide_chr(0x59)
	hide_chr(0x5a)
	hide_chr(0x5b)
	hide_chr(0x5c)
	hide_chr(0x5d)
	hide_chr(0x5e)
	set_chr_hiddenflag(0x04, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x25, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x06, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x08, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x0a, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x0c, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x0e, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x10, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x12, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x14, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x16, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x18, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x1a, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x1c, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x1e, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x20, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(0x22, CHRHFLAG_CLOAKED)
	hide_chr(0x04)
	hide_chr(0x25)
	hide_chr(0x06)
	hide_chr(0x08)
	hide_chr(0x0a)
	hide_chr(0x0c)
	hide_chr(0x0e)
	hide_chr(0x10)
	hide_chr(0x12)
	hide_chr(0x14)
	hide_chr(0x16)
	hide_chr(0x18)
	hide_chr(0x1a)
	hide_chr(0x1c)
	hide_chr(0x1e)
	hide_chr(0x20)
	hide_chr(0x22)

	beginloop(0x00)
		if_alarm_active(/*goto*/ 0x07)
	endloop(0x00)

	label(0x07)
	show_chr(0x57)
	show_chr(0x58)
	show_chr(0x59)
	show_chr(0x5a)
	show_chr(0x5b)
	show_chr(0x5c)
	show_chr(0x5d)
	show_chr(0x5e)
	set_chr_team(0x57, TEAM_ENEMY)
	set_chr_team(0x58, TEAM_ENEMY)
	set_chr_team(0x59, TEAM_ENEMY)
	set_chr_team(0x5a, TEAM_ENEMY)
	set_chr_team(0x5b, TEAM_ENEMY)
	set_chr_team(0x5c, TEAM_ENEMY)
	set_chr_team(0x5d, TEAM_ENEMY)
	set_chr_team(0x5e, TEAM_ENEMY)
	rebuild_teams
	rebuild_squadrons
	yield
	show_chr(0x04)
	show_chr(0x25)
	show_chr(0x06)
	show_chr(0x08)
	show_chr(0x0a)
	show_chr(0x0c)
	show_chr(0x0e)
	show_chr(0x10)
	show_chr(0x12)
	show_chr(0x14)
	show_chr(0x16)
	show_chr(0x18)
	show_chr(0x1a)
	show_chr(0x1c)
	show_chr(0x1e)
	show_chr(0x20)
	show_chr(0x22)
	set_chr_team(0x04, TEAM_ENEMY)
	set_chr_team(0x25, TEAM_ENEMY)
	set_chr_team(0x06, TEAM_ENEMY)
	set_chr_team(0x08, TEAM_ENEMY)
	set_chr_team(0x0a, TEAM_ENEMY)
	set_chr_team(0x0c, TEAM_ENEMY)
	set_chr_team(0x0e, TEAM_ENEMY)
	set_chr_team(0x10, TEAM_ENEMY)
	set_chr_team(0x12, TEAM_ENEMY)
	set_chr_team(0x14, TEAM_ENEMY)
	set_chr_team(0x16, TEAM_ENEMY)
	set_chr_team(0x18, TEAM_ENEMY)
	set_chr_team(0x1a, TEAM_ENEMY)
	set_chr_team(0x1c, TEAM_ENEMY)
	set_chr_team(0x1e, TEAM_ENEMY)
	set_chr_team(0x20, TEAM_ENEMY)
	set_chr_team(0x22, TEAM_ENEMY)
	rebuild_teams
	rebuild_squadrons
	yield
	set_ailist(0x57, 0x0409)
	set_ailist(0x58, 0x0409)
	set_ailist(0x59, 0x040a)
	set_ailist(0x5a, 0x040a)
	set_ailist(0x5b, AILIST_GUARD_ALERTED)
	set_ailist(0x5c, AILIST_GUARD_ALERTED)
	set_ailist(0x5d, AILIST_GUARD_ALERTED)
	set_ailist(0x5e, AILIST_GUARD_ALERTED)
	set_ailist(0x04, AILIST_GUARD_UNALERTED)
	set_ailist(0x25, AILIST_GUARD_UNALERTED)
	set_ailist(0x06, AILIST_GUARD_UNALERTED)
	set_ailist(0x08, AILIST_GUARD_UNALERTED)
	set_ailist(0x0a, AILIST_GUARD_UNALERTED)
	set_ailist(0x0c, AILIST_GUARD_UNALERTED)
	set_ailist(0x0e, AILIST_GUARD_UNALERTED)
	set_ailist(0x10, AILIST_GUARD_UNALERTED)
	set_ailist(0x12, AILIST_GUARD_UNALERTED)
	set_ailist(0x14, AILIST_GUARD_UNALERTED)
	set_ailist(0x16, AILIST_GUARD_UNALERTED)
	set_ailist(0x18, AILIST_GUARD_UNALERTED)
	set_ailist(0x1a, AILIST_GUARD_UNALERTED)
	set_ailist(0x1c, AILIST_GUARD_UNALERTED)
	set_ailist(0x1e, AILIST_GUARD_UNALERTED)
	set_ailist(0x20, AILIST_GUARD_UNALERTED)
	set_ailist(0x22, AILIST_GUARD_UNALERTED)
	yield
	unset_chr_chrflag(0x57, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x58, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x59, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x5a, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x5b, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x5c, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x5d, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x5e, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x57, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x58, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x59, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x5a, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x5b, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x5c, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x5d, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x5e, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x04, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x25, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x06, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x08, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x0a, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x0c, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x0e, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x10, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x12, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x14, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x16, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x18, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x1a, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x1c, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x1e, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x20, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x22, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x04, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x25, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x06, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x08, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x0a, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x0c, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x0e, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x10, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x12, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x14, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x16, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x18, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x1a, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x1c, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x1e, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x20, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x22, CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0402_init_pilot[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_PILOT)
	endlist
};

u8 func0401_pilot_dying[] = {
	unset_stage_flag(STAGEFLAG_SAID_PULLTHEPLUG)
	unset_stage_flag(STAGEFLAG_SAID_SWITCHTHINGOFF)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0401_pilot[] = {
	set_shotlist(AILIST_PILOT)
	if_chr_dying(CHR_SELF, /*goto*/ 0x07)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x07)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x07)
	goto_next(0x00)

	// Dying
	label(0x07)
	set_ailist(CHR_SELF, AILIST_PILOT_DYING)

	// Alive - wait for player to arrive
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x07)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x04)
	endloop(0x00)

	// Seen player
	label(0x07)
	say_quip(CHR_BOND, 0x08, 0xfe, 0x0a, 0xff, BANK_0, 0x00, 0x00)

	label(0x04)
	increase_squadron_alertness(100)
	surrender

	beginloop(0x0b)
		// Wait for Jo nearby
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_distance_to_target_lt(200, /*goto*/ 0x07)
		reloop(0x0b)

		// and for Jo's room entry speech to finish
		label(0x07)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x07)
		reloop(0x0b)

		// and for Jo to be in view
		label(0x07)
		if_chr_in_view(/*goto*/ 0x07)
	endloop(0x0b)

	label(0x07)
	if_stage_flag_eq(STAGEFLAG_AUTOPILOT_DISABLED, TRUE, /*goto*/ 0x08)
	if_stage_flag_eq(STAGEFLAG_SAID_PULLTHEPLUG, FALSE, /*goto*/ 0x07)
	goto_next(0x04)

	label(0x08)
	if_chr_death_animation_finished(CHR_ANGRY_PILOT, /*goto*/ 0x09)
	if_chr_dying(CHR_ANGRY_PILOT, /*goto*/ 0x09)
	if_chr_unloaded(CHR_ANGRY_PILOT, /*goto*/ 0x09)
	goto_first(0x0b)

	// Angry pilot dead or hasn't been chosen yet
	label(0x09)
	if_stage_flag_eq(STAGEFLAG_GPS_DISABLED, TRUE, /*goto*/ 0x04)
	if_stage_flag_eq(STAGEFLAG_SAID_SWITCHTHINGOFF, FALSE, /*goto*/ 0x08)

	// GPS disabled
	label(0x04)
	say_quip(CHR_BOND, 0x08, 0xfe, 0x0a, 0xff, BANK_0, 0x00, 0x00)
	goto_first(0x0b)

	label(0x07)
	speak(CHR_TARGET, L_DAM(43), 0x7325, CHANNEL_7, COLOR_09_BLUE) // "Pull the plug on that now."
	set_stage_flag(STAGEFLAG_SAID_PULLTHEPLUG)
	goto_next(0x0c)

	label(0x08)
	speak(CHR_TARGET, L_DAM(44), 0x7326, CHANNEL_7, COLOR_09_BLUE) // "Switch this thing off."
	set_stage_flag(STAGEFLAG_SAID_SWITCHTHINGOFF)
	goto_next(0x0c)

	beginloop(0x0c)
		if_sound_finished(CHANNEL_7, /*goto*/ 0x07)
	endloop(0x0c)

	label(0x07)
	set_self_flag_bankx(CHRFLAG0_08000000, BANK_0)
	if_stage_flag_eq(STAGEFLAG_SAID_SWITCHTHINGOFF, FALSE, /*goto*/ 0x07)
	speak(CHR_TARGET, L_DAM(45), 0x128e, CHANNEL_6, COLOR_04_ORANGE) // "I'll shut it down."
	goto_next(0x08)

	label(0x07)
	speak(CHR_TARGET, L_DAM(46), 0x1280, CHANNEL_6, COLOR_04_ORANGE) // "Please don't hurt me."
	label(0x08)
	do_preset_animation(-1)

	beginloop(0x0f)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x08)
	endloop(0x0f)

	// Choose which pad to walk to
	label(0x08)
	if_stage_flag_eq(STAGEFLAG_SAID_SWITCHTHINGOFF, TRUE, /*goto*/ 0x07)
	walk_to_pad(0x015d)
	goto_next(0x0d)

	label(0x07)
	walk_to_pad(0x0160)

	// Walking to pad
	beginloop(0x0d)
		if_chr_stopped(/*goto*/ 0x07)
	endloop(0x0d)

	// Push button
	label(0x07)
	chr_do_animation(ANIM_PUSH_BUTTON, 0, -1, 0x10, 0x10, CHR_SELF, 2)
	restart_timer

	beginloop(0x0e)
		if_chr_stopped(/*goto*/ 0x07)
		if_timer_gt(60, /*goto*/ 0x08)
	endloop(0x0e)

	label(0x08)
	speak(CHR_SELF, -1, 0x8118, CHANNEL_9, COLOR_00_GREEN)

	beginloop(0x10)
		if_chr_stopped(/*goto*/ 0x07)
	endloop(0x10)

	label(0x07)
	if_stage_flag_eq(STAGEFLAG_AUTOPILOT_DISABLED, TRUE, /*goto*/ 0x07)
	show_hudmsg(CHR_TARGET, L_DAM(14)) // "Autopilot system has been deactivated."
	set_stage_flag(STAGEFLAG_TRIGGER_ANGRY_PILOT)
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	set_stage_flag(STAGEFLAG_AUTOPILOT_DISABLED)
	surrender
	goto_first(0x0b)

	label(0x07)
	show_hudmsg(CHR_TARGET, L_DAM(15)) // "GPS system has been deactivated."
	set_stage_flag(STAGEFLAG_GPS_DISABLED)
	surrender
	goto_first(0x0b)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1011_check_pilots_dead[] = {
	beginloop(0x00)
		if_stage_flag_eq(STAGEFLAG_00080000, TRUE, /*goto*/ 0x08)
		if_chr_dying(CHR_PILOT1, /*goto*/ 0x07)
		if_chr_death_animation_finished(CHR_PILOT1, /*goto*/ 0x07)
		if_chr_unloaded(CHR_PILOT1, /*goto*/ 0x07)
		reloop(0x00)

		label(0x07)
		if_chr_dying(CHR_PILOT2, /*goto*/ 0x07)
		if_chr_death_animation_finished(CHR_PILOT2, /*goto*/ 0x07)
		if_chr_unloaded(CHR_PILOT2, /*goto*/ 0x07)
		reloop(0x00)

		label(0x07)
		if_chr_dying(CHR_PILOT3, /*goto*/ 0x07)
		if_chr_death_animation_finished(CHR_PILOT3, /*goto*/ 0x07)
		if_chr_unloaded(CHR_PILOT3, /*goto*/ 0x07)
	endloop(0x00)

	// All pilots dead
	label(0x07)

	// Flag is set
	label(0x08)
	if_stage_flag_eq(STAGEFLAG_AUTOPILOT_DISABLED, FALSE, /*goto*/ 0x07)
	if_stage_flag_eq(STAGEFLAG_GPS_DISABLED, FALSE, /*goto*/ 0x07)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x07)
	show_hudmsg(CHR_BOND, L_DAM(27)) // "Critical mission personnel have been killed."
	set_stage_flag(STAGEFLAG_PILOT_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Choose a pilot to become angry. One of the three is selected at random. If
 * the selected pilot is dead, try the next one and so on in order 1, 2, 3.
 */
u8 func1012_choose_angry_pilot[] = {
	set_chr_chrflag(CHR_PILOT1, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_PILOT2, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_PILOT3, CHRCFLAG_KILLCOUNTABLE)

	beginloop(0x00)
		if_kill_count_gt(0, /*goto*/ 0x08)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_ANGRY_PILOT, TRUE, /*goto*/ 0x07)
	endloop(0x00)

	// Triggered
	label(0x07)
	call_rng
	if_rand_lt(86, /*goto*/ 0x3b)
	if_rand_lt(172, /*goto*/ 0x3c)

	beginloop(0x03)
		if_kill_count_gt(0, /*goto*/ 0x08)
		if_chr_dying(CHR_PILOT1, /*goto*/ 0x3b)
		if_chr_death_animation_finished(CHR_PILOT1, /*goto*/ 0x3b)
		if_chr_unloaded(CHR_PILOT1, /*goto*/ 0x3b)
		if_chr_has_flag_bankx(CHR_PILOT1, CHRFLAG0_08000000, BANK_0, /*goto*/ 0x3b)
		set_ailist(CHR_PILOT1, AILIST_ANGRY_PILOT)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x3b)
		if_chr_dying(CHR_PILOT2, /*goto*/ 0x3c)
		if_chr_death_animation_finished(CHR_PILOT2, /*goto*/ 0x3c)
		if_chr_unloaded(CHR_PILOT2, /*goto*/ 0x3c)
		if_chr_has_flag_bankx(CHR_PILOT2, CHRFLAG0_08000000, BANK_0, /*goto*/ 0x3c)
		set_ailist(CHR_PILOT2, AILIST_ANGRY_PILOT)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x3c)
		if_chr_dying(CHR_PILOT3, /*goto*/ 0x04)
		if_chr_death_animation_finished(CHR_PILOT3, /*goto*/ 0x04)
		if_chr_unloaded(CHR_PILOT3, /*goto*/ 0x04)
		if_chr_has_flag_bankx(CHR_PILOT3, CHRFLAG0_08000000, BANK_0, /*goto*/ 0x04)
		set_ailist(CHR_PILOT3, AILIST_ANGRY_PILOT)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x04)
	endloop(0x03)

	// Killed a pilot
	label(0x08)
	show_hudmsg(CHR_BOND, L_DAM(35)) // "Civilians have been killed."
	set_stage_flag(STAGEFLAG_JO_KILLED_A_PILOT)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0404_angry_pilot[] = {
	set_chr_id(CHR_ANGRY_PILOT)
	set_accuracy(90)
	set_reaction_speed(100)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	rebuild_teams
	rebuild_squadrons
	unset_self_flag_bankx(CHRFLAG0_00100000, BANK_0)
	set_self_chrflag(CHRCFLAG_00000040)
	set_shotlist(AILIST_ANGRY_PILOT)
	if_chr_dying(CHR_SELF, /*goto*/ 0x07)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x07)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x07)
	goto_next(0x04)

	// Dying
	label(0x07)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x04)
	set_self_flag_bankx(CHRFLAG0_00000004, BANK_0)
	speak(CHR_TARGET, L_DAM(47), 0x14dd, CHANNEL_7, COLOR_04_ORANGE) // "Die, you traitors."
	chr_do_animation(ANIM_DRAW_PISTOL_0245, -1, 120, 0x06, 0x00, CHR_SELF, 3)
	try_equip_weapon(MODEL_CHRDY357, WEAPON_DY357MAGNUM, 0x00000000, /*goto*/ 0x6c)

	beginloop(0x6c)
		if_chr_stopped(/*goto*/ 0x03)
	endloop(0x6c)

	label(0x03)
	if_kill_count_gt(1, /*goto*/ 0x08)
	goto_next(0x04)

	// Jo killed a pilot
	label(0x08)
	set_stage_flag(STAGEFLAG_00080000)

	// Select another pilot as target
	label(0x04)
	if_chr_dying(CHR_PILOT1, /*goto*/ 0x3b)
	if_chr_death_animation_finished(CHR_PILOT1, /*goto*/ 0x3b)
	if_chr_unloaded(CHR_PILOT1, /*goto*/ 0x3b)
	if_chr_has_flag_bankx(CHR_PILOT1, CHRFLAG0_00000004, BANK_0, /*goto*/ 0x3b)
	set_target_chr(CHR_PILOT1)
	goto_next(0x00)

	label(0x3b)
	if_chr_dying(CHR_PILOT2, /*goto*/ 0x3c)
	if_chr_death_animation_finished(CHR_PILOT2, /*goto*/ 0x3c)
	if_chr_unloaded(CHR_PILOT2, /*goto*/ 0x3c)
	if_chr_has_flag_bankx(CHR_PILOT2, CHRFLAG0_00000004, BANK_0, /*goto*/ 0x3c)
	set_target_chr(CHR_PILOT2)
	goto_next(0x00)

	label(0x3c)
	if_chr_dying(CHR_PILOT3, /*goto*/ 0x04)
	if_chr_death_animation_finished(CHR_PILOT3, /*goto*/ 0x04)
	if_chr_unloaded(CHR_PILOT3, /*goto*/ 0x04)
	if_chr_has_flag_bankx(CHR_PILOT3, CHRFLAG0_00000004, BANK_0, /*goto*/ 0x04)
	set_target_chr(CHR_PILOT3)
	goto_next(0x00)

	// No other pilots
	label(0x04)
	call_rng
	if_rand_lt(128, /*goto*/ 0x3b)
	set_target_chr(CHR_COOP)
	if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x3b)
	goto_next(0x00)
	label(0x3b)
	set_target_chr(CHR_BOND)

	// Got target (other pilot or Jo)
	label(0x00)
	if_target_is_player(/*goto*/ 0x07)
	goto_next(0x04)
	label(0x07)
	set_shotlist(GAILIST_ALERTED)
	set_ailist(CHR_SELF, GAILIST_ALERTED)

	label(0x04)
	restart_timer
	try_run_to_target(/*goto*/ 0x6d)

	beginloop(0x6d)
		if_in_disarm_range(/*goto*/ 0x07)
		if_timer_gt(120, /*goto*/ 0x04)
	endloop(0x6d)

	label(0x04)
	goto_first(0x00)

	label(0x07)
	try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x04)
	label(0x04)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x6e)

	beginloop(0x6e)
		if_chr_stopped(/*goto*/ 0x07)
	endloop(0x6e)

	label(0x07)
	goto_first(0x03)

	endlist
};

u8 func1013_lift_switch[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_LIFT_SWITCH, /*goto*/ 0x07)
	endloop(0x00)

	label(0x07)
	show_hudmsg(CHR_P1P2, L_DAM(28)) // "Lift door has been unlocked."
	unlock_door(0x18, 0x02)
	unlock_door(0x19, 0x02)
	open_door(0x18)
	open_door(0x19)
	set_stage_flag(STAGEFLAG_LIFT_UNLOCKED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1014_moonpool_switch[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_object_in_good_condition(OBJ_MOONPOOL_SWITCH, /*goto*/ 0x08)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x10)
		show_hudmsg(CHR_P1P2, L_DAM(36)) // "Critical mission object has been destroyed."
		set_stage_flag(STAGEFLAG_MOONPOOL_SWITCH_DESTROYED)

		label(0x10)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x08)
		if_chr_activated_object(CHR_P1P2, OBJ_MOONPOOL_SWITCH, /*goto*/ 0x07)
	endloop(0x00)

	label(0x07)
	label(0x07)
	show_hudmsg(CHR_P1P2, L_DAM(29)) // "Lift has been activated."
	set_stage_flag(STAGEFLAG_MOONPOOL_ACTIVATED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0413_guard_alerted[] = {
	set_chr_cloaked(CHR_SELF, FALSE, TRUE)
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(18)
	set_reaction_speed(60)
	set_chr_maxdamage(CHR_SELF, 70)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

u8 func1015_shuffle_hatchswitches[] = {
	yield
	shuffle_pelagic_switches
	yield
	yield
	set_object_image(OBJ_BADHATCHSWITCH1, 0x00, 0x12)
	yield
	set_object_image(OBJ_BADHATCHSWITCH2, 0x00, 0x12)
	yield
	set_object_image(OBJ_BADHATCHSWITCH3, 0x00, 0x12)
	yield
	set_object_image(OBJ_BADHATCHSWITCH4, 0x00, 0x12)
	yield
	set_object_image(OBJ_HATCHSWITCH1, 0x00, 0x13)
	yield
	set_object_image(OBJ_HATCHSWITCH2, 0x00, 0x13)
	yield
	set_object_image(OBJ_HATCHSWITCH3, 0x00, 0x13)
	yield
	set_object_image(OBJ_HATCHSWITCH4, 0x00, 0x13)
	yield
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define hatchswitch_logic(switch, flag) \
	yield \
	yield \
 \
	beginloop(0x00) \
		chr_toggle_p1p2(CHR_SELF) \
		if_chr_activated_object(CHR_P1P2, switch, /*goto*/ 0x07) \
	endloop(0x00) \
 \
	label(0x07) \
	assign_sound(0x043a, CHANNEL_7) \
	control_sound_from_object(CHANNEL_7, switch, TRUE) \
	set_object_image(switch, 0x00, 0x14) \
	set_stage_flag(flag) \
 \
	beginloop(0x0b) \
		if_stage_flag_eq(STAGEFLAG_HATCHSWITCHES_RESETTING, TRUE, /*goto*/ 0x07) \
	endloop(0x0b) \
 \
	label(0x07) \
	set_object_image(switch, 0x00, 0x13) \
	yield \
	yield \
	yield \
	yield \
	yield \
	unset_stage_flag(STAGEFLAG_HATCHSWITCH1_ACTIVATED) \
	unset_stage_flag(STAGEFLAG_HATCHSWITCH2_ACTIVATED) \
	unset_stage_flag(STAGEFLAG_HATCHSWITCH3_ACTIVATED) \
	unset_stage_flag(STAGEFLAG_HATCHSWITCH4_ACTIVATED) \
	goto_first(0x00)



u8 func1016_hatchswitch1[] = {
	hatchswitch_logic(OBJ_HATCHSWITCH1, STAGEFLAG_HATCHSWITCH1_ACTIVATED)
	endlist
};

u8 func1017_hatchswitch2[] = {
	hatchswitch_logic(OBJ_HATCHSWITCH2, STAGEFLAG_HATCHSWITCH2_ACTIVATED)
	endlist
};

u8 func1018_hatchswitch3[] = {
	hatchswitch_logic(OBJ_HATCHSWITCH3, STAGEFLAG_HATCHSWITCH3_ACTIVATED)
	endlist
};

u8 func1019_hatchswitch4[] = {
	hatchswitch_logic(OBJ_HATCHSWITCH4, STAGEFLAG_HATCHSWITCH4_ACTIVATED)
	endlist
};

u8 func101a_badhatchswitches[] = {
	yield
	yield

	beginloop(0x00)
		if_chr_activated_object(CHR_P1P2, OBJ_BADHATCHSWITCH1, /*goto*/ 0x0b)
		if_chr_activated_object(CHR_P1P2, OBJ_BADHATCHSWITCH2, /*goto*/ 0x0c)
		if_chr_activated_object(CHR_P1P2, OBJ_BADHATCHSWITCH3, /*goto*/ 0x0d)
		if_chr_activated_object(CHR_P1P2, OBJ_BADHATCHSWITCH4, /*goto*/ 0x0e)
	endloop(0x00)

	// 1
	label(0x0b)
	assign_sound(0x043a, CHANNEL_7)
	control_sound_from_object(CHANNEL_7, OBJ_BADHATCHSWITCH1, TRUE)
	yield
	assign_sound(0x01c0, CHANNEL_6)
	control_sound_from_object(CHANNEL_6, OBJ_BADHATCHSWITCH1, FALSE)
	set_object_image(OBJ_BADHATCHSWITCH1, 0x00, 0x0f)
	goto_next(0x04)

	// 2
	label(0x0c)
	assign_sound(0x043a, CHANNEL_7)
	control_sound_from_object(CHANNEL_7, OBJ_BADHATCHSWITCH2, TRUE)
	yield
	assign_sound(0x01c0, CHANNEL_6)
	control_sound_from_object(CHANNEL_6, OBJ_BADHATCHSWITCH2, FALSE)
	set_object_image(OBJ_BADHATCHSWITCH2, 0x00, 0x0f)
	goto_next(0x04)

	// 3
	label(0x0d)
	assign_sound(0x043a, CHANNEL_7)
	control_sound_from_object(CHANNEL_7, OBJ_BADHATCHSWITCH3, TRUE)
	yield
	assign_sound(0x01c0, CHANNEL_6)
	control_sound_from_object(CHANNEL_6, OBJ_BADHATCHSWITCH3, FALSE)
	set_object_image(OBJ_BADHATCHSWITCH3, 0x00, 0x0f)
	goto_next(0x04)

	// 4
	label(0x0e)
	assign_sound(0x043a, CHANNEL_7)
	control_sound_from_object(CHANNEL_7, OBJ_BADHATCHSWITCH4, TRUE)
	yield
	assign_sound(0x01c0, CHANNEL_6)
	control_sound_from_object(CHANNEL_6, OBJ_BADHATCHSWITCH4, FALSE)
	set_object_image(OBJ_BADHATCHSWITCH4, 0x00, 0x0f)
	goto_next(0x04)

	label(0x04)
	show_hudmsg(CHR_P1P2, L_DAM(31)) // "Unlocking sequence has been reset."
	set_stage_flag(STAGEFLAG_HATCHSWITCHES_RESETTING)
	restart_timer

	beginloop(0x10)
		if_timer_gt(120, /*goto*/ 0x04)
	endloop(0x10)

	label(0x04)
	mute_channel(CHANNEL_6)
	unset_stage_flag(STAGEFLAG_HATCHSWITCHES_RESETTING)
	set_object_image(OBJ_BADHATCHSWITCH1, 0x00, 0x12)
	set_object_image(OBJ_BADHATCHSWITCH2, 0x00, 0x12)
	set_object_image(OBJ_BADHATCHSWITCH3, 0x00, 0x12)
	set_object_image(OBJ_BADHATCHSWITCH4, 0x00, 0x12)
	goto_first(0x00)

	endlist
};

u8 func101b_reactor_hum[] = {
	yield
	assign_sound(0x8146, CHANNEL_1)
	play_sound_from_object(CHANNEL_1, OBJ_REACTOR_SWITCH, 0x07d0, 0x0bb8)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0415_elvis_at_start[] = {
	set_shotlist(AILIST_ELVIS_AT_START)
	if_chr_dying(CHR_SELF, /*goto*/ 0x07)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x07)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x07)
	goto_next(0x04)

	// Dying
	label(0x07)
	if_sound_finished(CHANNEL_6, /*goto*/ 0x08)
	mute_channel(CHANNEL_6)
	label(0x08)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x04)
	stop_chr
	set_chr_maxdamage(CHR_SELF, 1)
	restart_timer

	beginloop(0x0b)
		if_timer_gt(120, /*goto*/ 0x07)
	endloop(0x0b)

	label(0x07)
	do_preset_animation(-1)
	speak(CHR_TARGET, L_DAM(32), 0x14dc, CHANNEL_6, COLOR_06_WHITE) // "You go on ahead, Jo. I'll secure the perimeter. We..."

	beginloop(0x0c)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x07)
	endloop(0x0c)

	label(0x07)
	jog_to_pad(0x0040)

	beginloop(0x0d)
		if_chr_stopped(/*goto*/ 0x07)
	endloop(0x0d)

	label(0x3b)
	restart_timer
	label(0x0e)
	stop_chr
	if_self_flag_bankx_eq(CHRFLAG1_DONE_SEARCH_ANIM, TRUE, BANK_1, /*goto*/ 0x07)
	call_rng
	if_rand_gt(128, /*goto*/ 0x07)

	// 50% chance of doing an idle animation
	call_rng
	if_rand_lt(64, /*goto*/ 0x44)
	if_rand_lt(128, /*goto*/ 0x45)
	if_rand_lt(196, /*goto*/ 0x46)

	set_self_flag_bankx(CHRFLAG1_DONE_SEARCH_ANIM, BANK_1)
	chr_do_animation(ANIM_SMOKE_CIGARETTE, 0, -1, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x4c)

	label(0x44)
	chr_do_animation(ANIM_SCRATCH_HEAD, 0, -1, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x4c)

	label(0x45)
	chr_do_animation(ANIM_YAWN, 0, -1, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x4c)

	label(0x46)
	chr_do_animation(ANIM_GRAB_CROTCH, 0, -1, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x4c)

	label(0x47)
	chr_do_animation(ANIM_TWO_GUN_HOLD, 0, 100, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x4c)

	// 50% chance
	label(0x07)
	unset_self_flag_bankx(CHRFLAG1_DONE_SEARCH_ANIM, BANK_1)
	if_chr_in_room(CHR_SELF, 0x00, 0x0029, /*goto*/ 0x04)
	set_padpreset(0x0040)
	goto_next(0x07)

	label(0x04)
	call_rng
	if_rand_lt(64, /*goto*/ 0x44)
	if_rand_lt(128, /*goto*/ 0x45)
	if_rand_lt(196, /*goto*/ 0x46)
	try_set_target_pad_to_something(0x08, /*goto*/ 0x07)
	label(0x44)
	try_set_target_pad_to_something(0x02, /*goto*/ 0x07)
	label(0x45)
	try_set_target_pad_to_something(0x04, /*goto*/ 0x07)
	label(0x46)
	try_set_target_pad_to_something(0x08, /*goto*/ 0x07)
	goto_next(0x4c)
	label(0x07)
	go_to_target_pad(SPEED_WALK)

	beginloop(0x4c)
		if_chr_in_room(CHR_BOND, 0x00, 0x0029, /*goto*/ 0x04)
		if_chr_in_room(CHR_BOND, 0x00, 0x002a, /*goto*/ 0x04)
		if_chr_in_room(CHR_BOND, 0x00, 0x002b, /*goto*/ 0x04)
		if_chr_in_room(CHR_BOND, 0x00, 0x0030, /*goto*/ 0x04)
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x07)
		if_chr_in_room(CHR_COOP, 0x00, 0x0029, /*goto*/ 0x04)
		if_chr_in_room(CHR_COOP, 0x00, 0x002a, /*goto*/ 0x04)
		if_chr_in_room(CHR_COOP, 0x00, 0x002b, /*goto*/ 0x04)
		if_chr_in_room(CHR_COOP, 0x00, 0x0030, /*goto*/ 0x04)
		label(0x07)
		goto_next(0x10)

		label(0x04)
		if_chr_stopped(/*goto*/ 0x4b)
	endloop(0x4c)

	label(0x4b)
	goto_first(0x3b)

	label(0x04)
	label(0x10)
	yield
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x07)

	// SA and PA
	chr_move_to_pad(CHR_ELVIS, 0x0020, 0x01, /*goto*/ 0x04)
	goto_first(0x10)

	// Agent
	label(0x07)
	chr_move_to_pad(CHR_ELVIS, 0x0096, 0x01, /*goto*/ 0x04)
	goto_first(0x10)

	label(0x04)
	stop_chr
	set_stage_flag(STAGEFLAG_ELVIS_WARPED_FROM_START)
	set_chr_chrflag(CHR_SELF, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_SELF, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	add_health_or_armor(2000)
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Elvis leading the way from the moon pool to the diving area.
 */
u8 func0416_elvis_leading[] = {
	set_shotlist(AILIST_ELVIS_LEADING)
	if_chr_dying(CHR_SELF, /*goto*/ 0x07)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x07)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x07)
	goto_next(0x04)

	// Dying
	label(0x07)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x04)
	if_just_injured(CHR_SELF, /*goto*/ 0x07)
	goto_next(0x04)

	// Injured
	label(0x07)
	say_quip(CHR_BOND, 0x29, 0xff, 0x03, 0xff, BANK_1, 0x00, 0x00)

	beginloop(0x3a)
		if_chr_stopped(/*goto*/ 0x04)
	endloop(0x3a)

	label(0x04)
	if_enemy_distance_lt_and_los(2540, /*goto*/ 0x0b)
	set_padpreset(0x0096)
	label(0x12)
	label(0x04)
	run_to_pad(0x0096)
	restart_timer

	beginloop(0x00)
		if_timer_gt(1200, /*goto*/ 0x08)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x0b)
		label(0x07)
		dprint 'G','O',' ','T','O',' ','P','A','D','\n',0,
		if_chr_stopped(/*goto*/ 0x04)
	endloop(0x00)

	label(0x08)
	goto_first(0x12)

	label(0x07)
	goto_first(0x03)

	label(0x04)
	stop_chr

	beginloop(0x0c)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x0b)
		label(0x07)
		dprint 'A','T',' ','P','A','D','\n',0,
	endloop(0x0c)

	label(0x0b)
	dprint 'D','E','T','E','C','T','E','D','\n',0,
	call_rng
	if_rand_lt(85, /*goto*/ 0x3b)
	if_rand_lt(170, /*goto*/ 0x3c)
	say_quip(CHR_BOND, 0x26, 0xff, 0x03, 0xff, BANK_1, 0x00, 0x00)
	goto_next(0x07)

	label(0x3b)
	say_quip(CHR_BOND, 0x27, 0xff, 0x03, 0xff, BANK_1, 0x00, 0x00)
	goto_next(0x07)

	label(0x3c)
	say_quip(CHR_BOND, 0x28, 0xff, 0x03, 0xff, BANK_1, 0x00, 0x00)

	label(0x07)
	set_shotlist(AILIST_ELVIS_LEADING)
	set_returnlist(CHR_SELF, AILIST_ELVIS_LEADING)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	endlist
};

u8 func101c_check_elvis_dead[] = {
	beginloop(0x00)
		if_chr_death_animation_finished(CHR_ELVIS, /*goto*/ 0x07)
		if_chr_dying(CHR_ELVIS, /*goto*/ 0x07)
		if_chr_unloaded(CHR_ELVIS, /*goto*/ 0x07)
	endloop(0x00)

	label(0x07)
	show_hudmsg(CHR_BOND, L_DAM(33)) // "Elvis has been killed."
	set_stage_flag(STAGEFLAG_ELVIS_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0418_elvis_at_moonpool[] = {
	// @bug? If Elvis has enough health, and you can shoot him before he talks,
	// he'll jump straight to leading the way without enabling AIVSAI on
	// everyone. This may allow him to run past guards without engaging in
	// combat.
	set_shotlist(AILIST_ELVIS_LEADING)

	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x07)
	endloop(0x00)

	label(0x07)
	if_chr_dying(CHR_SELF, /*goto*/ 0x07)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x07)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x07)
	do_preset_animation(-1)
	set_stage_flag(STAGEFLAG_MET_ELVIS)
	speak(CHR_P1P2, L_DAM(34), 0x81a4, CHANNEL_6, COLOR_06_WHITE) // "Joanna... What took you so long? Follow me - let's..."

	beginloop(0x0b)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x07)
	endloop(0x0b)

	label(0x07)
	set_ailist(CHR_SELF, AILIST_ELVIS_PREPARE_LEADING)
	endlist
};

u8 func0417_elvis_prepare_leading[] = {
	// Allow all other chrs to engage in combat with Elvis
	set_chr_flag_bankx(0x03, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x04, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x05, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x06, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x07, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x08, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x09, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x0a, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x0b, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x0c, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x0d, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x0e, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x0f, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x10, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x11, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x12, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x13, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x14, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x15, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x16, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x17, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x18, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x19, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x1a, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x1b, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x1c, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x1d, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x1e, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x1f, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x20, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x21, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x22, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x23, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x24, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x25, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x26, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x27, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x28, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x29, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x2a, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x2b, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x2c, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x2d, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x2e, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x2f, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x30, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x31, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x32, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x33, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x34, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x35, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x36, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x37, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x38, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x39, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x3a, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x3b, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(CHR_PILOT1, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x3d, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(CHR_PILOT2, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(CHR_PILOT3, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x40, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x41, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x42, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x43, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x44, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x45, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x46, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x47, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x48, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x49, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x4a, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x4b, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x4c, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x4d, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x51, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x52, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x53, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x54, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x55, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x56, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x57, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x58, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x59, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x5a, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x5b, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x5c, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x5d, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x5e, CHRFLAG0_AIVSAI, BANK_0)
	set_ailist(CHR_SELF, AILIST_ELVIS_LEADING)
	endlist
};

u8 func101d_alarm_switches[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, 0x21, /*goto*/ 0x07)
		if_chr_activated_object(CHR_P1P2, 0x22, /*goto*/ 0x07)
		if_chr_activated_object(CHR_P1P2, 0x23, /*goto*/ 0x07)
		if_chr_activated_object(CHR_P1P2, 0x24, /*goto*/ 0x07)
		if_chr_activated_object(CHR_P1P2, 0x25, /*goto*/ 0x07)
	endloop(0x00)

	label(0x07)
	if_alarm_active(/*goto*/ 0x07)
	activate_alarm
	show_hudmsg(CHR_P1P2, L_DAM(37)) // "Alarm has been activated."
	goto_next(0x0c)

	label(0x07)
	deactivate_alarm
	show_hudmsg(CHR_BOND, L_DAM(38)) // "Alarm has been deactivated."
	goto_next(0x0c)

	label(0x0c)
	restart_timer

	beginloop(0x0d)
		if_timer_gt(120, /*goto*/ 0x07)
	endloop(0x0d)

	label(0x07)
	goto_first(0x00)

	// @bug: This function is surely not meant to be assigned here. But it has
	// no consequences because the function will bail because CHR_SELF doesn't
	// exist.
	set_ailist(CHR_SELF, AILIST_ELVIS_LEADING)
	endlist
};

u8 func101e_alarm_images[] = {
	beginloop(0x00)
		if_alarm_active(/*goto*/ 0x07)
	endloop(0x00)

	label(0x07)
	set_object_flag(0x27, OBJFLAG_UNCOLLECTABLE)
	set_object_flag(0x28, OBJFLAG_UNCOLLECTABLE)
	set_object_flag2(0x27, OBJFLAG2_INVISIBLE)
	set_object_flag2(0x28, OBJFLAG2_INVISIBLE)
	set_object_image(0x21, 0x00, 0x0f)
	set_object_image(0x22, 0x00, 0x0f)
	set_object_image(0x23, 0x00, 0x0f)
	set_object_image(0x24, 0x00, 0x0f)
	set_object_image(0x25, 0x00, 0x0f)

	beginloop(0x0b)
		if_alarm_active(/*goto*/ 0x07)
		goto_next(0x04)

		label(0x07)
	endloop(0x0b)

	label(0x04)
	set_object_image(0x21, 0x00, 0x14)
	set_object_image(0x22, 0x00, 0x14)
	set_object_image(0x23, 0x00, 0x14)
	set_object_image(0x24, 0x00, 0x14)
	set_object_image(0x25, 0x00, 0x14)
	goto_first(0x00)

	endlist
};

u8 func101f_unlock_doors[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0b)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x0c)

	// PA
	unlock_door(0x2c, 0x80)
	unlock_door(0x2d, 0x80)

	// SA + PA
	label(0x0c)
	unlock_door(0x29, 0x80)
	unlock_door(0x2a, 0x80)
	unlock_door(0x2b, 0x80)

	// A + SA + PA
	label(0x0b)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1020_setup_rtracker[] = {
	yield
	set_object_flag3(0x27, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(0x28, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1421_setup_lighting[] = {
	yield
	misc_command(0x0060, 0x06, 0x01)
	misc_command(0x0061, 0x06, 0x01)
	misc_command(0x0063, 0x05, 0x01)
	misc_command(0x0064, 0x05, 0x01)
	misc_command(0x0064, 0x06, 0x01)
	misc_command(0x0065, 0x05, 0x01)
	misc_command(0x0067, 0x05, 0x01)
	misc_command(0x0067, 0x06, 0x01)
	misc_command(0x0068, 0x05, 0x01)
	misc_command(0x0068, 0x06, 0x01)
	misc_command(0x0069, 0x05, 0x01)
	misc_command(0x0069, 0x06, 0x01)
	misc_command(0x006a, 0x05, 0x01)
	misc_command(0x006a, 0x06, 0x01)
	misc_command(0x006b, 0x05, 0x01)
	misc_command(0x006b, 0x06, 0x01)
	misc_command(0x006d, 0x05, 0x01)
	misc_command(0x006d, 0x06, 0x01)
	misc_command(0x006e, 0x05, 0x01)
	misc_command(0x006e, 0x06, 0x01)
	misc_command(0x006f, 0x05, 0x01)
	misc_command(0x006f, 0x06, 0x01)
	misc_command(0x0070, 0x05, 0x01)
	misc_command(0x0070, 0x06, 0x01)
	misc_command(0x0071, 0x05, 0x01)
	misc_command(0x0071, 0x06, 0x01)
	misc_command(0x0072, 0x05, 0x01)
	misc_command(0x0072, 0x06, 0x01)
	misc_command(0x0073, 0x05, 0x01)
	misc_command(0x0077, 0x05, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

struct ailist ailists[] = {
	{ func1400_setup_counterop,              0x1400 },
	{ func1001_objectives_failed_msg,        0x1001 },
	{ func1002_intro,                        0x1002 },
	{ func1004_msg_controlledfrom,           0x1004 },
	{ func1005_msg_withoutautopilot,         0x1005 },
	{ func1006_msg_conductoperations,        0x1006 },
	{ func1009_open_reactor_hatch,           0x1009 },
	{ func100a_reactor_switch,               0x100a },
	{ func100b_check_diving_area_located,    0x100b },
	{ func100c_check_end_level,              0x100c },
	{ func100e_check_labtech_dead,           0x100e },
	{ func100f_check_researchdata_collected, 0x100f },
	{ func1010_alarm_responders,             0x1010 },
	{ func1011_check_pilots_dead,            0x1011 },
	{ func1012_choose_angry_pilot,           0x1012 },
	{ func1013_lift_switch,                  0x1013 },
	{ func1014_moonpool_switch,              0x1014 },
	{ func1015_shuffle_hatchswitches,        0x1015 },
	{ func1016_hatchswitch1,                 0x1016 },
	{ func1017_hatchswitch2,                 0x1017 },
	{ func1018_hatchswitch3,                 0x1018 },
	{ func1019_hatchswitch4,                 0x1019 },
	{ func101a_badhatchswitches,             0x101a },
	{ func101b_reactor_hum,                  0x101b },
	{ func101c_check_elvis_dead,             0x101c },
	{ func101d_alarm_switches,               0x101d },
	{ func101e_alarm_images,                 0x101e },
	{ func101f_unlock_doors,                 0x101f },
	{ func1020_setup_rtracker,               0x1020 },
	{ func1421_setup_lighting,               0x1421 },
	{ func1002_intro,                        0x0c00 },
	{ func0c01_outro,                        0x0c01 },
	{ func0408_guard_unalerted,              0x0408 },
	{ func0405_start_path00,                 0x0405 },
	{ func0401_pilot,                        0x0401 },
	{ func0402_init_pilot,                   0x0402 },
	{ func0401_pilot_dying,                  0x0403 },
	{ func0404_angry_pilot,                  0x0404 },
	{ func0c01_outro,                        0x0414 },
	{ func0415_elvis_at_start,               0x0415 },
	{ func0416_elvis_leading,                0x0416 },
	{ func0417_elvis_prepare_leading,        0x0417 },
	{ func0418_elvis_at_moonpool,            0x0418 },
	{ func0406_start_path01,                 0x0406 },
	{ func0407_start_path02,                 0x0407 },
	{ func0409_start_path03,                 0x0409 },
	{ func040a_start_path04,                 0x040a },
	{ func040b_labtech1,                     0x040b },
	{ func040c_labtech2,                     0x040c },
	{ func040d_labtech3,                     0x040d },
	{ func040e_init_labtech1,                0x040e },
	{ func040f_init_labtech2,                0x040f },
	{ func0410_init_labtech3,                0x0410 },
	{ func0411_labtech_alerted,              0x0411 },
	{ func0412_hide,                         0x0412 },
	{ func0413_guard_alerted,                0x0413 },
	{ NULL, 0 },
};

