//
// Extraction
//

#include "stagesetup.h"

// Characters
#define CHR_DRCAROLL      0x00
#define CHR_RLSHOCK       0x0e
#define CHR_TECH1         0x0f
#define CHR_TECH2         0x10
#define CHR_TOPGUARD1     0x11
#define CHR_TOPGUARD2     0x12
#define CHR_TOPGUARD3     0x13
#define CHR_TOPGUARD4     0x14
#define CHR_TOPGUARD5     0x15
#define CHR_CASS          0x1c
#define CHR_MRBLONDE      0x1d
#define CHR_INTRO_GUARD   0x1e
#define CHR_OUTRO_GUARD1  0x1f
#define CHR_OUTRO_GUARD2  0x20
#define CHR_SPECIAL_SHOCK 0x22 // guy who appears if foyer completed perfectly

// Objects
#define OBJ_TOPROOMDOOR    0x05
#define OBJ_LIGHTSWITCH    0x0a
#define OBJ_HOVERCOPTER    0x0b
#define OBJ_NIGHTVISION    0x0e
#define OBJ_JUMPSHIP       0x10
#define OBJ_ROCKETAMMO1    0x14
#define OBJ_ROCKETAMMO2    0x15
#define OBJ_GRENADE        0x1a
#define OBJ_DRAGON         0x1b
#define OBJ_DY357          0x1c
#define OBJ_ROCKETLAUNCHER 0x1f

// Stage flags
#define STAGEFLAG_ELEVATOR_PC_DESTROYED     0x00000001
#define STAGEFLAG_TRIGGER_CANTLEAVEANY_MSG  0x00000002
#define STAGEFLAG_TOP_BODYGUARDS_DEAD       0x00000004
#define STAGEFLAG_ACCESSED_FOYER_ELEVATOR   0x00000100
#define STAGEFLAG_ELEVATOR_UNLOCKED         0x00000200
#define STAGEFLAG_HOVERCOPTER_DESTROYED     0x00000400
#define STAGEFLAG_OBJECTIVE_BODYGUARDS_DEAD 0x00000800
#define STAGEFLAG_REACHED_HELIPAD           0x00001000
#define STAGEFLAG_FOYER_LIGHTS_RESTORED     0x00002000
#define STAGEFLAG_DRCAROLL_DEAD             0x00004000
#define STAGEFLAG_DRCAROLL_ATTACKED         0x00008000
#define STAGEFLAG_DRCAROLL_DAMAGED          0x00010000
#define STAGEFLAG_TECHS_RUNNING             0x00020000
#define STAGEFLAG_CHOPPER_GO_TO_ROOF        0x00040000
#define STAGEFLAG_ENTERING_TOP_ROOM         0x00080000
#define STAGEFLAG_TOP_GUARDS_ATTACKING      0x00200000
#define STAGEFLAG_TOP_LIGHTS_OFF            0x00400000
#define STAGEFLAG_00800000                  0x00800000 // unset in intro, not used elsewhere
#define STAGEFLAG_HOVERCOPTER_ON_ROOF       0x01000000
#define STAGEFLAG_CASS_SHIELD_DAMAGED       0x02000000
#define STAGEFLAG_FOYER_LIGHTS_OFF          0x04000000
#define STAGEFLAG_SAID_SURRENDER_OR_DIE     0x10000000
#define STAGEFLAG_SAID_GIVE_UP              0x20000000
#define STAGEFLAG_SAID_FINAL_WARNING        0x40000000
#define STAGEFLAG_TECHS_FINISHED            0x80000000

// AI Lists
#define AILIST_DRCAROLL_FOLLOWING 0x0401
#define AILIST_INIT_DRCAROLL      0x0404
#define AILIST_GENERAL_COMBAT     0x0406
#define AILIST_CASS_OUTRO         0x0407
#define AILIST_HOVERCOPTER        0x0408
#define AILIST_INIT_TECH1         0x040b
#define AILIST_INIT_TECH2         0x040c
#define AILIST_CASS               0x040d
#define AILIST_TOP_GUARD          0x040f
#define AILIST_INIT_TOP_GUARD     0x0410
#define AILIST_TOP_GUARD_BLINDED  0x0411
#define AILIST_OUTRO              0x0412
#define AILIST_DEFEND_PAD         0x0413
#define AILIST_INIT_SHOCK         0x0414

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x0601)
	briefing(1, 0x0600)
	briefing(2, 0x0602)
	briefing(3, 0x0603)

	beginobjective(0, L_ARK(9), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Access foyer elevator"
		complete_flags(STAGEFLAG_ACCESSED_FOYER_ELEVATOR)
	endobjective

	beginobjective(1, L_ARK(10), (DIFFBIT_PA | DIFFBIT_PD)) // "Reactivate office elevator"
		complete_flags(STAGEFLAG_ELEVATOR_UNLOCKED)
		fail_flags(STAGEFLAG_ELEVATOR_PC_DESTROYED)
	endobjective

	beginobjective(2, L_ARK(11), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Destroy dataDyne hovercopter"
		complete_flags(STAGEFLAG_HOVERCOPTER_DESTROYED)
	endobjective

	beginobjective(3, L_ARK(12), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Defeat Cassandra's bodyguards"
		complete_flags(STAGEFLAG_OBJECTIVE_BODYGUARDS_DEAD)
	endobjective

	beginobjective(4, L_ARK(13), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Rendezvous at helipad"
		complete_flags(STAGEFLAG_REACHED_HELIPAD)
		fail_flags(STAGEFLAG_DRCAROLL_DEAD)
	endobjective

	vent_fan(0x0100, MODEL_DD_FANROOF, 0x0087, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_DD_FANROOF, 0x0088, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_DD_FANROOF, 0x0089, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_DD_FANROOF, 0x008a, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_DD_FANWALL, 0x008b, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000222, 0x00000000, 0x00000002, 0x01000000)
	tag(0x0b, 1)
	armed_vehicle(0x004c, MODEL_DD_HOVERCOPTER, 0x0190, 0x20000008, 0x00000110, 0x00008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AILIST_HOVERCOPTER, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x10, 1)
	stdobject(0x0100, MODEL_DDJUMPSHIP, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x0c, 2)
	tag(0x0d, 2)
	door(0x0100, MODEL_DOOR4A_G5, 0x0224, 0x00000400, 0x00000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001200, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR4B_G5, 0x0223, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DECODOOR, 0x021e, 0x10000400, 0x28000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000040, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DECODOOR, 0x021f, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0221, 0x04000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000040, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0222, 0x04000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000040, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_SECRETDOOR, 0x0220, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x02140000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_SECRETDOOR, 0x00ae, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x02140000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x0092, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x0093, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000004, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x0094, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x0095, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x0096, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x0097, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x0098, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x0099, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a4, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a5, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x009a, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x009b, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x009c, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x009d, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x009e, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x009f, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a0, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a3, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a1, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x00000005, 0x00000040, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a2, 0x30000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x00000005, 0x00000040, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_SERVICEDOOR, 0x00a6, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_SERVICEDOOR, 0x00a7, 0x10000400, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x11, 1)
	door(0x0100, MODEL_DD_SERVICEDOOR, 0x00a8, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x04, 1)
	door(0x0100, MODEL_DD_SERVICEDOOR, 0x00a9, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x000c0000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_SERVICEDOOR, 0x00ad, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x000c0000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x05, 1)
	door(0x0100, MODEL_DD_WINDDOOR, 0x00aa, 0x34000000, 0x28000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_WINDDOOR, 0x00ab, 0x94000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_WINDDOOR, 0x00ac, 0x94000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x20, 6)
	tag(0x21, 6)
	tag(0x22, 6)
	tag(0x23, 6)
	tag(0x1d, 1)
	lift(0x0100, MODEL_DD_LIFTR, 0x011d, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x011d, 0x0259, 0xffffffff, 0x00000001, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x16000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x008c, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x008d, 0x04000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000002, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x008e, 0x04000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000002, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x021c, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-4, -5, 0, 0)
	link_objects(-2, -6, 0, 1)
	tag(0x24, 8)
	tag(0x25, 8)
	tag(0x26, 8)
	tag(0x27, 8)
	tag(0x02, 4)
	tag(0x03, 4)
	tag(0x1e, 1)
	lift(0x0100, MODEL_DD_LIFTR, 0x011e, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x011e, 0x0120, 0xffffffff, 0x00000001, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x16000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x008f, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000001, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0090, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000001, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0091, 0x04000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000002, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x021d, 0x04000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000002, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-4, -5, 0, 0)
	link_objects(-4, -6, 0, 1)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00af, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00b0, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00b1, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00b2, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00b3, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00b4, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00b5, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00b6, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00b7, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00b8, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00b9, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00ba, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00bc, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00bd, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00be, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00bf, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c0, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c1, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x023a, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x023b, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x023c, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x023d, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x023e, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x023f, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010f, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0110, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x024d, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x024e, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x024f, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x0250, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x0251, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x0252, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x0253, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x0254, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x0255, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW_FOYER, 0x024b, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW_FOYER, 0x024c, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00d2, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00d3, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00d4, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00d5, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00d6, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00d7, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00d8, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00d9, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00da, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00db, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00dc, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00dd, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00de, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00df, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e0, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e1, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e2, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e3, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e4, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e5, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e6, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e7, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e8, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e9, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ea, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00eb, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ec, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ed, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ee, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ef, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f0, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f1, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f2, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f3, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f4, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f6, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f5, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f7, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f8, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f9, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00fa, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00fb, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00fc, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00fd, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00fe, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ff, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0100, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0101, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0102, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0103, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0104, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0105, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0106, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0107, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010b, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010c, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010d, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010e, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x00c4, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00c5, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00c2, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00c7, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00c8, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00c9, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x00c6, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x00ca, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x0256, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x0257, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01a0, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x019f, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x01, 1)
	singlemonitor(0x0100, MODEL_PC1, 0x019e, 0x000004e1, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01a1, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01a2, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_PC1, 0x01a3, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01a4, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01a5, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_PC1, 0x01a6, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01a7, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01a8, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_PC1, 0x01a9, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01ac, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01ab, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_PC1, 0x01aa, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	stdobject(0x0100, MODEL_DD_DESK, 0x01ad, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_LIGHTSWITCH2, 0x012e, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01af, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_PC1, 0x01b1, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_PC1, 0x01b2, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x00cb, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01b3, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01b4, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_PC1, 0x01b5, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00cc, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00cd, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0225, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x0226, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x0228, 0x000005e8, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_PC1, 0x022a, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_PC1, 0x022b, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x0232, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x0233, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x0234, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x0235, 0x000005e8, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x0236, 0x000005e8, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x0237, 0x000005e8, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x0238, 0x000005e8, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x0239, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x01ce, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x01cf, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_BLASTSHIELD, 0x01d0, 0x000005e8, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BLASTSHIELD, 0x01d1, 0x000005e8, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x022f, 0x000005e8, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_QUADPOD, 0x01b6, 0x000005e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1f, 1)
	weapon(0x0100, MODEL_CHRDYROCKET, 0x01c4, 0x40420101, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_ROCKETLAUNCHER, 0x00ffffff, 0x00000000)
	camera2(0x0000, 0xffff9931, 0xfffea6ce, 0x00003a3e, 0x00410000, 0x00000000, 0x0000001b)
	tag(0x06, -1)
	camera2(0x0000, 0xffffba1e, 0xfffeba56, 0xffff7356, 0x01560000, 0x00000000, 0x0000001b)
	tag(0x07, -1)
	camera2(0x0000, 0xffff5d8a, 0xfffeba56, 0x00000924, 0x01499eb8, 0x00000000, 0x0000001b)
	tag(0x08, -1)
	camera2(0x0000, 0xffff85c6, 0xffff3b3e, 0xffff6672, 0xfffcdbc7, 0x00000000, 0x000001cc)
	tag(0x09, -1)
	tag(0x0e, 1)
	stdobject(0x0100, MODEL_CHRNIGHTSIGHT, 0xffff, 0x012405e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	rename_object(-1, 0x2d, L_ARK(27), L_ARK(28), L_ARK(29), L_ARK(30), L_ARK(31), 0x0000, 0x0000) // "Obtain Night Vision."
	tag(0x17, 1)
	stdobject(0x0100, MODEL_CHRNIGHTSIGHT, 0xffff, 0x012405e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	rename_object(-1, 0x2d, L_ARK(27), L_ARK(28), L_ARK(29), L_ARK(30), L_ARK(31), 0x0000, 0x0000) // "Obtain Night Vision."
	chr(0x00000400, 0x00, 0x0210, BODY_DRCAROLL, HEAD_RANDOM, AILIST_INIT_DRCAROLL, -1, -1, 1000, 100, 0x00000000, 0x00000000, TEAM_ALLY, SQUADRON_00, -1, 0, 0x00000000)
	chr(0x00000200, 0x01, 0x0215, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK, -1, -1, 1000, 7, 0x00014400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0001, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x02, 0x021b, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK, -1, -1, 1000, 7, 0x00014400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0002, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x03, 0x0214, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK, -1, -1, 1000, 8, 0x00014400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0003, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x04, 0x0213, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK, -1, -1, 1000, 9, 0x00014400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0004, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x05, 0x0216, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK, -1, -1, 1000, 8, 0x00012400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0005, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRDY357, 0x0005, 0x20004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DY357MAGNUM, 0x00ffffff, 0x00000000)
	tag(0x1c, -1)
	chr(0x00000200, 0x06, 0x0211, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK, -1, -1, 1000, 8, 0x00014400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0006, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x07, 0x0212, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK, -1, -1, 1000, 8, 0x00014400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0007, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x08, 0x0217, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK, -1, -1, 1000, 8, 0x00014400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0008, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x09, 0x0218, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK, -1, -1, 1000, 9, 0x00012400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0009, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0a, 0x0219, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK, -1, -1, 1000, 9, 0x80012400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0b, 0x01be, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK, -1, -1, 1000, 100, 0x80004400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0c, 0x01bf, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK, -1, -1, 1000, 100, 0x80004400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0d, 0x01c0, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK, -1, -1, 1000, 100, 0x80004400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x0e, 0x01c1, BODY_DDSHOCK, HEAD_DDSHOCK, GAILIST_IDLE, -1, -1, 50, 100, 0x8000a000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00010400, 0x0f, 0x01c2, BODY_OFFICEWORKER, HEAD_RANDOM, AILIST_INIT_TECH1, -1, -1, 50, 9, 0x00004400, 0x00000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
	chr(0x00010400, 0x10, 0x01c3, BODY_OFFICEWORKER, HEAD_RANDOM, AILIST_INIT_TECH2, -1, -1, 50, 9, 0x00004400, 0x00000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
	chr(0x00000401, 0x11, 0x01c5, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_TOP_GUARD, -1, -1, 1000, 100, 0x80004400, 0x00000000, TEAM_NONCOMBAT, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0011, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000401, 0x12, 0x01c6, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_TOP_GUARD, -1, -1, 1000, 100, 0x80004400, 0x00000000, TEAM_NONCOMBAT, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0012, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000401, 0x13, 0x01c7, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_TOP_GUARD, -1, -1, 1000, 100, 0x80004400, 0x00000000, TEAM_NONCOMBAT, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0013, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000401, 0x14, 0x01c8, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_TOP_GUARD, -1, -1, 1000, 100, 0x80004400, 0x00000000, TEAM_NONCOMBAT, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0014, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000401, 0x15, 0x01cc, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_INIT_TOP_GUARD, -1, -1, 1000, 100, 0x80002400, 0x00000000, TEAM_NONCOMBAT, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0015, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00010400, 0x1c, 0x01c9, BODY_CASSANDRA, HEAD_CASSANDRA, AILIST_CASS, -1, -1, 1000, 100, 0x00004400, 0x00000000, TEAM_NONCOMBAT, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000400, 0x1d, 0x0206, BODY_MRBLONDE, HEAD_MRBLONDE, GAILIST_INVINCIBLE_AND_IDLE, -1, -1, 1000, 100, 0x00004400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000400, 0x1e, 0x0204, BODY_DDSHOCK, HEAD_DARLING, GAILIST_INVINCIBLE_AND_IDLE, -1, -1, 1000, 100, 0x00000000, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	chr(0x00000400, 0x1f, 0x0207, BODY_FEM_GUARD, HEAD_RANDOM, GAILIST_INVINCIBLE_AND_IDLE, -1, -1, 1000, 100, 0x00004400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x001f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000400, 0x20, 0x0203, BODY_FEM_GUARD, HEAD_RANDOM, GAILIST_INVINCIBLE_AND_IDLE, -1, -1, 1000, 100, 0x00002400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0020, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x16, 0x0070, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_DEFEND_PAD, 0x006a, -1, 1000, 100, 0x80004400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0016, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x17, 0x0081, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_DEFEND_PAD, 0x006a, -1, 1000, 100, 0x80004400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0017, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x18, 0x0071, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_GENERAL_COMBAT, 0x006a, -1, 1000, 100, 0x80004400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0018, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x19, 0x0048, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_GENERAL_COMBAT, 0x006a, -1, 1000, 100, 0x80004400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x0019, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1a, 0x0047, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_DEFEND_PAD, 0x0044, -1, 1000, 100, 0x80004400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x001a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1b, 0x004a, BODY_FEM_GUARD, HEAD_RANDOM, AILIST_DEFEND_PAD, 0x0044, -1, 1000, 100, 0x80004400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSHOTGUN, 0x001b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SHOTGUN, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x22, 0x007e, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK, -1, -1, 1000, 9, 0x80012400, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0022, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	key(0x0080, MODEL_KEYCARD, 0x0022, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000040)
	rename_object(-1, 0x4c, L_ARK(55), L_ARK(56), L_ARK(57), L_ARK(58), L_ARK(59), 0x0000, 0x0000) // "Obtain alpha key card."
	link_scenery(1, 0, 2)
	door(0x0100, MODEL_DD_AC_UNEXP, 0x019b, 0x13520d00, 0x20304300, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00010000, 0x03e80000, 0x03e80000, 0x00010000, 0x00000000, 0x00000080, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_DD_AC_EXP, 0x019d, 0x031204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 2)
	door(0x0100, MODEL_DD_ACBOT_UNEXP, 0x019a, 0x13500d00, 0x20304300, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00010000, 0x03e80000, 0x03e80000, 0x00010000, 0x00000000, 0x00000080, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_DD_ACBOT_EXP, 0x019c, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0130, 0x00020101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0131, 0x00020101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0132, 0x00020101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0133, 0x00020101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_STONEDESK, 0x0124, 0x000205e1, 0x00204000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	multimonitor(0x0099, MODEL_COMHUB, 0x012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(0x0a, 1)
	stdobject(0x0100, MODEL_LIGHTSWITCH, 0x012d, 0x00000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0111, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0112, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0113, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0114, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0119, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x011a, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0117, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0118, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ce, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00cf, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00d0, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00d1, 0x14000b63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tag(0x18, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x0078, 0x00000001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x19, 1)
	tag(0x1a, 1)
	weapon(0x0100, MODEL_CHRGRENADE, 0x01d2, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_GRENADE, 0x00ffffff, 0x00000000)
	tag(0x1b, 1)
	weapon(0x0100, MODEL_CHRDRAGON, 0x01d3, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	tag(0x14, 1)
	weapon(0x0100, MODEL_MULTI_AMMO_CRATE, 0x0204, 0x00000101, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_ROCKETLAUNCHER, 0x00ffffff, 0x00000000)
	tag(0x15, 1)
	weapon(0x0100, MODEL_MULTI_AMMO_CRATE, 0x0207, 0x00000101, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_ROCKETLAUNCHER, 0x00ffffff, 0x00000000)
	endprops
};

s32 intro[] = {
	intro_weapon(WEAPON_FALCON2_SCOPE, -1)
	ammo(AMMOTYPE_PISTOL, 50)
	ammo(AMMOTYPE_RIFLE, 160)
	ammo(AMMOTYPE_MAGNUM, 2)
	ammo(AMMOTYPE_ROCKET, 1)
	outfit(OUTFIT_DEFAULT)
	spawn(0x025a)
	endintro
};

s32 path00[] = {
	0x018f,
	0x018e,
	0x0191,
	0x0190,
	-1,
};

s32 path01[] = {
	0x0192,
	0x0193,
	0x0194,
	0x0195,
	-1,
};

s32 path02[] = {
	0x0196,
	0x0197,
	0x0198,
	0x0199,
	-1,
};

struct path paths[] = {
	{ path00, 0, PATHTYPE_BACKANDFORTH },
	{ path01, 1, PATHTYPE_BACKANDFORTH },
	{ path02, 2, PATHTYPE_BACKANDFORTH },
	{ NULL, 0, 0 },
};

/**
 * @unused
 */
u8 func0403_stop_and_idle[] = {
	stop_chr

	beginloop(0x00)
	endloop(0x00)

	endlist
};

u8 func0404_init_drcaroll[] = {
	set_self_chrflag(CHRCFLAG_01000000)
	set_shield(100)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0402_start_drcaroll[] = {
	stop_chr
	set_ailist(CHR_SELF, AILIST_DRCAROLL_FOLLOWING)
	endlist
};

u8 func0401_drcaroll_following[] = {
	set_shotlist(AILIST_DRCAROLL_FOLLOWING)
	set_self_chrflag(CHRCFLAG_00040000)
	stop_chr
	set_target_chr(CHR_BOND)
	try_jog_to_target(/*goto*/ 0x00)
	label(0x00)
	yield
	set_target_chr(CHR_BOND)
	if_chr_dying(CHR_SELF, /*goto*/ 0x00)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x00)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x00)
	goto_next(0x20)

	label(0x00)
	set_shotlist(GAILIST_IDLE)
	restart_timer

	beginloop(0x0b)
		if_timer_gt(15, /*goto*/ 0x00)
	endloop(0x0b)

	label(0x00)
	say_quip(CHR_TARGET, 0x06, 0xff, 0x03, 0xff, BANK_1, 0x00, 0x00)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	set_target_chr(CHR_BOND)
	set_shield(100)
	set_chr_maxdamage(CHR_SELF, 100)
	label(0x20)
	dprint 'b','4',' ','s','h','i','e','l','d',' ','c','h','e','c','k','\n',0,
	try_unset_chr_flag_bank3_02000000(CHR_SELF, /*goto*/ 0x00)
	goto_next(0x02)

	label(0x00)
	restart_timer
	say_quip(CHR_TARGET, 0x04, 0xff, 0x03, 0xff, BANK_1, 0x00, 0x00)

	beginloop(0x0d)
		if_num_times_shot_lt(1, /*goto*/ 0x00)
		if_timer_lt(20, /*goto*/ 0x00)
		label(0x00)
		if_chr_stopped(/*goto*/ 0x02)
	endloop(0x0d)

	label(0x02)
		stop_chr
		restart_timer

		beginloop(0x03)
			if_chr_y(CHR_TARGET, -1910, OPERATOR_LESS_THAN, /*goto*/ 0x20)
			label(0x20)
			dprint 't','a','r','g','e','t','\n',0,
			if_chr_sees_player(/*goto*/ 0x00)
			goto_next(0x04)

			label(0x00)
			if_timer_gt(1250, /*goto*/ 0x20)
			if_distance_to_target_gt(200, /*goto*/ 0x04)
		endloop(0x03)

		label(0x20)
		call_rng
		if_rand_lt(64, /*goto*/ 0x20)
		say_quip(CHR_TARGET, 0x02, 0xff, 0x02, 0xff, BANK_1, 0x00, 0x00)
		goto_first(0x02)

		label(0x20)
		say_quip(CHR_TARGET, 0x03, 0xff, 0x02, 0xff, BANK_1, 0x00, 0x00)
		goto_first(0x02)

		label(0x00)
		say_quip(CHR_TARGET, 0x07, 0xff, 0x02, 0xff, BANK_1, 0x00, 0x00)
	goto_first(0x02)

	label(0x04)
		restart_timer
		if_chr_y(CHR_DRCAROLL, -2100, OPERATOR_LESS_THAN, /*goto*/ 0x20)
		try_run_to_target(/*goto*/ 0x05)
		label(0x20)
		if_distance_to_target_lt(200, /*goto*/ 0x20)
		try_run_to_target(/*goto*/ 0x05)
		label(0x20)
		try_jog_to_target(/*goto*/ 0x05)

		beginloop(0x05)
			if_chr_in_room(CHR_TARGET, 0x00, 0x0094, /*goto*/ 0x00)
			goto_next(0x20)

			label(0x00)
			label(0x20)
			label(0x00)
			if_distance_to_target_lt(200, /*goto*/ 0x06)
			if_chr_stopped(/*goto*/ 0x06)
			if_timer_gt(360, /*goto*/ 0x20)
		endloop(0x05)

		label(0x20)
		say_quip(CHR_TARGET, 0x03, 0xff, 0x02, 0xff, BANK_1, 0x00, 0x00)
		goto_first(0x04)

		label(0x00)
		say_quip(CHR_TARGET, 0x07, 0xff, 0x02, 0xff, BANK_1, 0x00, 0x00)
	goto_first(0x04)

	label(0x06)
	goto_first(0x02)

	label(0x07)
	try_run_to_target(/*goto*/ 0x08)

	beginloop(0x08)
	endloop(0x08)

	label(0x09)
	goto_first(0x02)

	// Unreachable
	// Attempts to teleport Dr Caroll up the elevator shaft from foyer
	label(0x5c)
	dprint 'D','R',' ','C','H','A','N','G','E','L','I','S','T','\n',0,
	if_chr_death_animation_finished(CHR_DRCAROLL, /*goto*/ 0x20)
	if_chr_dying(CHR_DRCAROLL, /*goto*/ 0x20)
	if_chr_unloaded(CHR_DRCAROLL, /*goto*/ 0x20)
	chr_move_to_pad(CHR_DRCAROLL, 0x0079, 0x00, /*goto*/ 0x00)
	dprint 'T','E','L','E','P','O','R','T',' ','F','A','I','L','\n',0,
	label(0x00)
	goto_first(0x02)

	label(0x20)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Waiting at the door to the top room while you clear it out.
 */
u8 func0405_drcaroll_waiting[] = {
	if_chr_dying(CHR_DRCAROLL, /*goto*/ 0x20)
	if_chr_death_animation_finished(CHR_DRCAROLL, /*goto*/ 0x20)
	if_chr_unloaded(CHR_DRCAROLL, /*goto*/ 0x20)
	goto_next(0x00)

	label(0x20)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x00)
	dprint 'D','R',' ','C','H','A','N','G','E','L','I','S','T','\n',0,
	set_chr_hiddenflag(CHR_DRCAROLL, CHRHFLAG_00100000)
	chr_move_to_pad(CHR_DRCAROLL, 0x01ca, 0x00, /*goto*/ 0x00)
	dprint 'M','O','V','E',' ','F','A','I','L','\n',0,
	label(0x00)
	stop_chr

	beginloop(0x1f)
		if_stage_flag_eq(STAGEFLAG_TOP_BODYGUARDS_DEAD, TRUE, /*goto*/ 0x00)
	endloop(0x1f)

	label(0x00)
	set_ailist(CHR_SELF, AILIST_DRCAROLL_FOLLOWING)
	endlist
};

u8 func100c_foyer_lights_timer[] = {
	beginloop(0x1f)
		if_stage_flag_eq(STAGEFLAG_FOYER_LIGHTS_OFF, TRUE, /*goto*/ 0x20)
	endloop(0x1f)

	label(0x20)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2e)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2f)

	// PA
	set_countdown_timer(60)
	start_countdown_timer
	show_countdown_timer
	goto_next(0x0e)

	// Agent
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Unreachable
	set_countdown_timer(60)
	start_countdown_timer
	show_countdown_timer
	goto_next(0x0e)

	// SA
	label(0x2f)
	set_countdown_timer(90)
	start_countdown_timer
	show_countdown_timer

	beginloop(0x0e)
		if_countdown_timer_lt(1, /*goto*/ 0x0f)
	endloop(0x0e)

	label(0x0f)
	set_stage_flag(STAGEFLAG_FOYER_LIGHTS_RESTORED)
	hide_countdown_timer
	stop_countdown_timer
	set_lights_state(0x0019, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x001a, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x001b, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x001c, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x001d, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x001e, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x001f, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0020, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0021, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0017, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0018, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0016, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0022, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0023, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0024, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0025, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0026, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0027, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0028, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0029, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x002a, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x002b, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x002c, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x002d, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x002e, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x002f, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0030, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0031, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0032, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0033, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0034, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0035, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0036, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0015, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x000f, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x000e, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0010, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0011, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0012, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0013, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x0014, 0x01, 0x64, 0x00, 0x00)
	set_lights_state(0x000d, 0x01, 0x64, 0x00, 0x00)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0410_init_top_guard[] = {
	set_shotlist(AILIST_TOP_GUARD)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x20)

	// SA and PA
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(80)
	set_reaction_speed(10)
	set_chr_maxdamage(CHR_SELF, 10)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	goto_next(0x00)

	// Agent
	label(0x20)
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(12)
	set_reaction_speed(10)
	set_chr_maxdamage(CHR_SELF, 10)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)

	label(0x00)
	beginloop(0x8d)
		if_stage_flag_eq(STAGEFLAG_ENTERING_TOP_ROOM, TRUE, /*goto*/ 0x20)
	endloop(0x8d)

	label(0x20)
	set_ailist(CHR_SELF, AILIST_TOP_GUARD)
	endlist
};

u8 func040f_top_guard[] = {
	if_just_injured(CHR_SELF, /*goto*/ 0x20)
	goto_next(0x00)

	label(0x20)
	set_stage_flag(STAGEFLAG_CASS_SHIELD_DAMAGED)

	beginloop(0x21)
		if_chr_stopped(/*goto*/ 0x00)
	endloop(0x21)

	label(0x00)
	try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x1f)

	beginloop(0x1f)
		if_distance_to_target_lt(200, /*goto*/ 0x20)
		if_stage_flag_eq(STAGEFLAG_CASS_SHIELD_DAMAGED, TRUE, /*goto*/ 0x00)
		if_stage_flag_eq(STAGEFLAG_TOP_GUARDS_ATTACKING, TRUE, /*goto*/ 0x00)
		set_target_chr(CHR_PRESET)
	endloop(0x1f)

	label(0x00)
	set_ailist(CHR_SELF, AILIST_GENERAL_COMBAT)

	label(0x20)
	set_stage_flag(STAGEFLAG_CASS_SHIELD_DAMAGED)
	set_ailist(CHR_SELF, AILIST_GENERAL_COMBAT)
	endlist
};

u8 func0411_top_guard_blinded[] = {
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x20)
	if_chr_dying(CHR_SELF, /*goto*/ 0x20)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x20)
	goto_next(0x00)

	label(0x20)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x00)
	chr_do_animation(ANIM_BLINDED, 0, -1, 0x10, 0x10, CHR_SELF, 2)
	say_quip(CHR_BOND, 0x11, 0x64, 0x02, 0xff, BANK_1, 0x00, 0x00)

	beginloop(0x1f)
		if_chr_stopped(/*goto*/ 0x00)
	endloop(0x1f)

	label(0x00)
	set_ailist(CHR_SELF, AILIST_GENERAL_COMBAT)
	endlist
};

u8 func0406_general_combat[] = {
	set_self_chrflag(CHRCFLAG_00000040)
	set_shotlist(AILIST_GENERAL_COMBAT)
	if_has_gun(CHR_SELF, /*goto*/ 0x20)

	// No gun
	set_shotlist(GAILIST_ALERTED)
	set_ailist(CHR_SELF, GAILIST_ALERTED)

	// Has gun
	label(0x20)
	if_chr_dying(CHR_SELF, /*goto*/ 0x00)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x00)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x00)
	goto_next(0x20)

	// Dying - wait a few frames then say quip
	label(0x00)
	set_shotlist(GAILIST_IDLE)
	restart_timer

	beginloop(0x0b)
		if_timer_gt(15, /*goto*/ 0x00)
	endloop(0x0b)

	label(0x00)
	say_quip(CHR_BOND, 0x19, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive with gun
	label(0x20)
	if_just_injured(CHR_SELF, /*goto*/ 0x00)
	goto_next(0x21)

	// Just got injured
	label(0x00)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_PSYCHOSISED)
	restart_timer

	beginloop(0x0c)
		if_self_flag_bankx_eq(CHRFLAG0_SAID_INJURY_QUIP, TRUE, BANK_0, /*goto*/ 0x00)
		if_num_times_shot_lt(1, /*goto*/ 0x00)
		if_timer_lt(20, /*goto*/ 0x00)
		say_quip(CHR_BOND, 0x0d, 0x28, 0x03, 0x00, BANK_0, 0x00, 0x00)
		say_quip(CHR_BOND, 0x0e, 0x28, 0x03, 0x01, BANK_0, 0x00, 0x00)
		set_self_flag_bankx(CHRFLAG0_SAID_INJURY_QUIP, BANK_0)
		label(0x00)
		if_chr_stopped(/*goto*/ 0x21)
	endloop(0x0c)

	// Not injured, or injury recovery finished
	label(0x21)
	set_self_chrflag(CHRCFLAG_00000040)

	label(0x14)
		if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x00)
		label(0x20)
		try_chr_kneel_and_shoot_thing(0x0220, 0x0000, /*goto*/ 0x10)
		label(0x00)
		kneel

		beginloop(0x10)
			if_stage_flag_eq(STAGEFLAG_FOYER_LIGHTS_RESTORED, TRUE, /*goto*/ 0x00)
			goto_next(0x20)

			// Lights restored
			label(0x00)
			set_view_distance(100)

			label(0x20)
			chr_toggle_p1p2(CHR_SELF)
			set_target_chr(CHR_P1P2)
			if_stage_flag_eq(STAGEFLAG_FOYER_LIGHTS_RESTORED, TRUE, /*goto*/ 0x00)
			if_target_in_sight(/*goto*/ 0x15)
			goto_next(0x20)

			label(0x00)
			if_chr_sees_player(/*goto*/ 0x15)
			label(0x20)
			if_near_miss(/*goto*/ 0x18)
			if_stage_flag_eq(STAGEFLAG_FOYER_LIGHTS_RESTORED, TRUE, /*goto*/ 0x00)
			if_enemy_distance_lt_and_los(500, /*goto*/ 0x20)
			goto_next(0x5e)

			label(0x00)
			if_enemy_distance_lt_and_los(2540, /*goto*/ 0x20)
			goto_next(0x5e)

			label(0x20)
			if_target_is_player(/*goto*/ 0x5e)
			goto_next(0x15)

			label(0x5e)
			set_target_chr(CHR_P1P2)
			reloop(0x10)

			label(0x00)
			if_target_in_sight(/*goto*/ 0x15)
			if_stage_flag_eq(STAGEFLAG_FOYER_LIGHTS_RESTORED, TRUE, /*goto*/ 0x00)
			if_enemy_distance_lt_and_los(500, /*goto*/ 0x20)
			goto_next(0x5e)

			label(0x00)
			if_enemy_distance_lt_and_los(2540, /*goto*/ 0x20)
			goto_next(0x5e)

			label(0x20)
			if_target_is_player(/*goto*/ 0x5e)
			goto_next(0x15)

			label(0x5e)
			set_target_chr(CHR_P1P2)
		endloop(0x10)

		label(0x15)
		set_chr_hiddenflag(CHR_BOND, CHRHFLAG_PSYCHOSISED)
		if_self_flag_bankx_eq(CHRFLAG1_00000001, TRUE, BANK_1, /*goto*/ 0x2a)
		if_distance_to_target_lt(250, /*goto*/ 0x29)
		if_self_flag_bankx_eq(CHRFLAG0_00000004, TRUE, BANK_0, /*goto*/ 0x20)
		set_self_flag_bankx(CHRFLAG0_00000004, BANK_0)
		if_stage_flag_eq(STAGEFLAG_FOYER_LIGHTS_RESTORED, TRUE, /*goto*/ 0x00)
		say_quip(CHR_BOND, 0x1b, 0xff, 0x02, 0xff, BANK_0, 0x00, 0x00)
		goto_next(0x20)

		label(0x00)
		say_quip(CHR_BOND, 0x0b, 0xff, 0x02, 0xff, BANK_0, 0x00, 0x00)
		label(0x20)
		if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x17)
		try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x12)
		goto_next(0x13)

		beginloop(0x12)
			if_chr_stopped(/*goto*/ 0x13)
		endloop(0x12)

		label(0x13)
		if_chr_injured_target(CHR_SELF, /*goto*/ 0x20)
		say_quip(CHR_BOND, 0x16, 0x19, 0x03, 0x00, BANK_0, 0x00, 0x00)
		say_quip(CHR_BOND, 0x17, 0x19, 0x03, 0x01, BANK_0, 0x00, 0x00)
		goto_next(0x00)

		label(0x20)
		say_quip(CHR_BOND, 0x15, 0x19, 0x02, 0x00, BANK_0, 0x00, 0x00)
		say_quip(CHR_BOND, 0x15, 0x19, 0x03, 0x01, BANK_0, 0x00, 0x00)
		label(0x00)
	goto_first(0x14)

	label(0x18)
	restart_timer
	if_self_flag_bankx_eq(CHRFLAG0_00000004, TRUE, BANK_0, /*goto*/ 0x1c)
	set_self_flag_bankx(CHRFLAG0_00000004, BANK_0)
	if_stage_flag_eq(STAGEFLAG_FOYER_LIGHTS_RESTORED, TRUE, /*goto*/ 0x1c)
	say_quip(CHR_BOND, 0x12, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)

	beginloop(0x1c)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		call_rng
		if_target_in_sight(/*goto*/ 0x19)
		if_timer_gt(60, /*goto*/ 0x1e)
		if_rand_lt(4, /*goto*/ 0x1e)
	endloop(0x1c)

	label(0x1e)
	if_chr_sees_player(/*goto*/ 0x19)
	goto_first(0x14)

	label(0x19)
	goto_first(0x15)

	label(0x1a)
	restart_timer

	beginloop(0x1b)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x19)
		if_timer_gt(300, /*goto*/ 0x00)
	endloop(0x1b)

	label(0x00)
	goto_first(0x14)

	label(0x19)
	goto_first(0x15)

	label(0x17)
	try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x16)
	label(0x16)
	say_quip(CHR_BOND, 0x00, 0x19, 0x02, 0x01, BANK_0, 0x00, 0x00)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x00)
	goto_next(0x20)
	label(0x00)
	goto_first(0x12)

	label(0x20)
	goto_first(0x13)

	label(0x29)
	try_jog_to_target(/*goto*/ 0x20)
	label(0x20)
	dprint 'U','N',' ','E','N','T','R','Y','\n',0,
	set_returnlist(CHR_SELF, AILIST_GENERAL_COMBAT)
	set_ailist(CHR_SELF, GAILIST_HAND_COMBAT)

	label(0x2a)
	label(0x20)
	if_target_is_player(/*goto*/ 0x20)
	set_shotlist(GAILIST_COMBAT_WITH_TARGET)
	set_returnlist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	label(0x20)
	set_shotlist(GAILIST_ALERTED)
	set_returnlist(CHR_SELF, GAILIST_ALERTED)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

u8 func0408_hovercopter[] = {
	set_target_chr(CHR_BOND)
	chopper_arm_weapons
	move_object_to_pad(OBJ_HOVERCOPTER, 0x0199)
	begin_hovercar_path(0x02)
	restart_timer
	set_chr_maxdamage(CHR_SELF, 42320)

	beginloop(0x1f)
		if_timer_gt(120, /*goto*/ 0x42)
	endloop(0x1f)

	label(0x42)
	yield
	if_chr_y(CHR_TARGET, -1850, OPERATOR_LESS_THAN, /*goto*/ 0x52)
	if_chr_y(CHR_TARGET, -1200, OPERATOR_LESS_THAN, /*goto*/ 0x53)
	goto_next(0x54)

	// Low combat (lowest floor)
	label(0x21)
	begin_hovercar_path(0x00)

	beginloop(0x22)
		dprint 'L','O','W','\n',0,
		if_chr_y(CHR_TARGET, -1850, OPERATOR_LESS_THAN, /*goto*/ 0x00)
		if_chr_y(CHR_TARGET, -1200, OPERATOR_LESS_THAN, /*goto*/ 0x53)
		if_stage_flag_eq(STAGEFLAG_CHOPPER_GO_TO_ROOF, FALSE, /*goto*/ 0x00)
		goto_next(0x54)

		label(0x00)
		set_target_chr(CHR_BOND)
		if_chr_sees_player(/*goto*/ 0x43)
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x20)
		set_target_chr(CHR_COOP)
		if_chr_sees_player(/*goto*/ 0x43)
		set_target_chr(CHR_BOND)
		label(0x20)
	endloop(0x22)

	// Mid combat (second floor and Cass's office floor)
	label(0x23)
	begin_hovercar_path(0x01)

	beginloop(0x24)
		dprint 'M','I','D','\n',0,
		if_chr_y(CHR_TARGET, -1850, OPERATOR_LESS_THAN, /*goto*/ 0x52)
		dprint 'M','I','D','0','\n',0,
		if_chr_y(CHR_TARGET, -1200, OPERATOR_LESS_THAN, /*goto*/ 0x00)
		dprint 'M','I','D','1','\n',0,
		if_stage_flag_eq(STAGEFLAG_CHOPPER_GO_TO_ROOF, FALSE, /*goto*/ 0x00)
		dprint 'M','I','D','2','\n',0,
		goto_next(0x54)

		label(0x00)
		dprint 'M','I','D','3','\n',0,
		set_target_chr(CHR_BOND)
		if_chr_sees_player(/*goto*/ 0x48)
		dprint 'N','O','T','V','I','S','\n',0,
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x20)
		set_target_chr(CHR_COOP)

		// @bug: This should go to 0x48. Instead it goes to the low code path,
		// which doesn't appear to have any side effects except that the
		// hovercopter will say the low line ("surrender or die") on the mid
		// level if Velvet is the first player it sees.
		if_chr_sees_player(/*goto*/ 0x43)
		set_target_chr(CHR_BOND)
		label(0x20)
	endloop(0x24)

	// High combat (roof)
	label(0x25)
	begin_hovercar_path(0x02)

	beginloop(0x26)
		set_target_chr(CHR_BOND)
		dprint 'T','O','P','\n',0,
		if_chr_y(CHR_TARGET, -1850, OPERATOR_LESS_THAN, /*goto*/ 0x52)
		if_chr_y(CHR_TARGET, -1200, OPERATOR_LESS_THAN, /*goto*/ 0x53)
		set_target_chr(CHR_BOND)
		if_chr_sees_player(/*goto*/ 0x4d)
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x20)
		set_target_chr(CHR_COOP)
		if_chr_sees_player(/*goto*/ 0x4d)
		label(0x20)
		set_target_chr(CHR_BOND)
		label(0x00)
	endloop(0x26)

	// Change to high
	label(0x54)
	dprint 'C','H','A','N','G','E',' ','T','O',' ','H','I','G','H','\n',0,
	label(0x27)
	yield
	goto_next(0x00)
	label(0x00)
	if_chr_sees_player(/*goto*/ 0x20)
	move_object_to_pad(OBJ_HOVERCOPTER, 0x0199)
	label(0x20)
	goto_first(0x25)

	// Change to low
	label(0x52)
	dprint 'C','H','A','N','G','E',' ','T','O',' ','L','O','W','\n',0,
	if_chr_sees_player(/*goto*/ 0x20)
	move_object_to_pad(OBJ_HOVERCOPTER, 0x0190)
	label(0x20)
	goto_first(0x21)

	// Change to mid
	label(0x53)
	dprint 'C','H','A','N','G','E',' ','T','O',' ','M','I','D','\n',0,
	if_chr_sees_player(/*goto*/ 0x20)
	move_object_to_pad(OBJ_HOVERCOPTER, 0x0195)
	label(0x20)
	goto_first(0x23)

	// Low shooting
	label(0x43)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x44)
	goto_first(0x22)

	label(0x44)
	yield
	if_chr_sees_player(/*goto*/ 0x47)
	restart_timer

	beginloop(0x45)
		if_timer_gt(480, /*goto*/ 0x46)
		if_chr_sees_player(/*goto*/ 0x47)
	endloop(0x45)

	label(0x46)
	stop_chr
	goto_first(0x22)

	label(0x47)
	if_stage_flag_eq(STAGEFLAG_SAID_SURRENDER_OR_DIE, TRUE, /*goto*/ 0x20)
	play_sound(0x7b0b, -1)
	set_stage_flag(STAGEFLAG_SAID_SURRENDER_OR_DIE)
	label(0x20)
	goto_first(0x44)

	// Mid shooting
	label(0x48)
	dprint 'S','H','O','O','T',' ','M','I','D','\n',0,
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x49)
	goto_first(0x24)

	label(0x49)
	yield
	if_chr_sees_player(/*goto*/ 0x4c)
	restart_timer

	beginloop(0x4a)
		if_timer_gt(180, /*goto*/ 0x4b)
		if_chr_sees_player(/*goto*/ 0x4c)
	endloop(0x4a)

	label(0x4b)
	stop_chr
	goto_first(0x24)

	label(0x4c)
	if_stage_flag_eq(STAGEFLAG_SAID_GIVE_UP, TRUE, /*goto*/ 0x20)
	play_sound(0x7b0d, -1)
	set_stage_flag(STAGEFLAG_SAID_GIVE_UP)
	label(0x20)
	goto_first(0x49)

	// High shooting (roof)
	label(0x4d)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x00)
	label(0x00)
	set_stage_flag(STAGEFLAG_HOVERCOPTER_ON_ROOF)
	if_stage_flag_eq(STAGEFLAG_SAID_FINAL_WARNING, TRUE, /*goto*/ 0x20)
	play_sound(0x7b0c, -1)
	set_stage_flag(STAGEFLAG_SAID_FINAL_WARNING)
	label(0x20)
	stop_chr
	restart_timer

	beginloop(0x29)
		if_timer_gt(180, /*goto*/ 0x00)
	endloop(0x29)

	label(0x00)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x00)
	goto_first(0x26)

	label(0x00)
	restart_timer
	label(0x4e)
	yield
	if_chr_sees_player(/*goto*/ 0x51)
	restart_timer

	beginloop(0x4f)
		if_timer_gt(480, /*goto*/ 0x50)
		if_chr_sees_player(/*goto*/ 0x51)
	endloop(0x4f)

	label(0x50)
	stop_chr
	goto_first(0x26)

	label(0x51)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x20)
	if_timer_gt(500, /*goto*/ 0x27)
	label(0x20)
	goto_first(0x4e)

	label(0x27)
	restart_timer
	hovercopter_fire_rocket(0) // left side
	goto_first(0x4e)

	// Unreachable - the hovercopter only fires rockets from the left side
	label(0x28)
	restart_timer
	hovercopter_fire_rocket(1) // right side
	goto_first(0x4e)

	endlist
};

u8 func1002_check_accessed_foyer_elevator[] = {
	beginloop(0x21)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_y(CHR_TARGET, -8155, OPERATOR_LESS_THAN, /*goto*/ 0x20)
		if_chr_distance_to_pad_lt(CHR_TARGET, 300, 0x021a, /*goto*/ 0x00)
		label(0x20)
	goto_first(0x21)

	label(0x00)
	set_stage_flag(STAGEFLAG_ACCESSED_FOYER_ELEVATOR)
	show_hudmsg(CHR_TARGET, L_ARK(33)) // "Foyer elevator accessed."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1003_check_end_level[] = {
	beginloop(0x21)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_distance_to_pad_lt(CHR_P1P2, 200, 0x0002, /*goto*/ 0x00)
		reloop(0x21)

		label(0x00)
		if_chr_y(CHR_P1P2, 30, OPERATOR_LESS_THAN, /*goto*/ 0x20)
		goto_next(0x00)
		label(0x20)
		reloop(0x21)

		label(0x00)
		set_stage_flag(STAGEFLAG_REACHED_HELIPAD)
		yield
		if_all_objectives_complete(/*goto*/ 0x20)
	endloop(0x21)

	label(0x20)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x20)
	if_chr_dying(CHR_BOND, /*goto*/ 0x20)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x20)
	goto_next(0x00)

	label(0x20)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x20)
	if_chr_dying(CHR_COOP, /*goto*/ 0x20)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x20)
	goto_next(0x00)

	label(0x20)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x00)
	set_invincible(CHR_BOND)
	set_ailist(CHR_SELF, AILIST_OUTRO)
	endlist
};

u8 func1004_elevator_unlocking[] = {
	yield
	if_difficulty_gt(DIFF_SA, /*goto*/ 0x1f)
	unlock_door(0x02, 0x01)
	unlock_door(0x03, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x1f)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_activated_object(CHR_TARGET, 0x01, /*goto*/ 0x20)
		if_object_in_good_condition(0x01, /*goto*/ 0x00)
		goto_next(0x28)
		label(0x00)
	endloop(0x1f)

	// Computer destroyed
	label(0x28)
	if_stage_flag_eq(STAGEFLAG_ELEVATOR_UNLOCKED, TRUE, /*goto*/ 0x00)
	set_stage_flag(STAGEFLAG_ELEVATOR_PC_DESTROYED)
	show_hudmsg(CHR_BOND, L_ARK(45)) // "Critical mission object destroyed."
	label(0x00)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Computer activated
	label(0x20)
	show_hudmsg(CHR_TARGET, L_ARK(14)) // "Accessing elevator controls..."
	assign_sound(0x8116, CHANNEL_6)
	control_sound_from_object(CHANNEL_6, 0x01, TRUE)
	restart_timer

	beginloop(0x22)
		if_timer_gt(15, /*goto*/ 0x00)
	endloop(0x22)

	label(0x00)
	mute_channel(CHANNEL_6)

	beginloop(0x23)
		if_timer_gt(40, /*goto*/ 0x00)
	endloop(0x23)

	label(0x00)

	beginloop(0x24)
		if_timer_gt(60, /*goto*/ 0x00)
	endloop(0x24)

	label(0x00)

	beginloop(0x25)
		if_timer_gt(80, /*goto*/ 0x00)
	endloop(0x25)

	label(0x00)
	restart_timer

	beginloop(0x21)
		if_timer_gt(120, /*goto*/ 0x00)
	endloop(0x21)

	label(0x00)
	play_sound(0x81b0, -1)
	unlock_door(0x02, 0x01)
	unlock_door(0x03, 0x01)
	show_hudmsg(CHR_TARGET, L_ARK(34)) // "Office elevator door has been unlocked."
	set_stage_flag(STAGEFLAG_ELEVATOR_UNLOCKED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1005_check_bodyguards_dead[] = {
	#define if_alive_goto_00(chr, goto) \
		if_chr_death_animation_finished(chr, goto) \
		if_chr_dying(chr, goto) \
		if_chr_unloaded(chr, goto) \
		goto_next(0x00) \
		label(goto)



	beginloop(0x1f)
		if_alive_goto_00(CHR_TOPGUARD5, 0x21)
		if_alive_goto_00(CHR_TOPGUARD4, 0x22)
		if_alive_goto_00(CHR_TOPGUARD3, 0x23)
		if_alive_goto_00(CHR_TOPGUARD2, 0x24)
		if_alive_goto_00(CHR_TOPGUARD1, 0x20)

		set_stage_flag(STAGEFLAG_TOP_BODYGUARDS_DEAD)
		unlock_door(OBJ_TOPROOMDOOR, 0x02)
		unset_object_flag2(OBJ_TOPROOMDOOR, OBJFLAG2_AICANNOTUSE)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x26)

		if_alive_goto_00(0x16, 0x20)
		if_alive_goto_00(0x17, 0x20)
		if_alive_goto_00(0x18, 0x20)
		if_alive_goto_00(0x19, 0x20)
		if_alive_goto_00(0x1a, 0x20)

		if_chr_death_animation_finished(0x1b, /*goto*/ 0x20)
		if_chr_dying(0x1b, /*goto*/ 0x20)
		if_chr_unloaded(0x1b, /*goto*/ 0x20)
		goto_next(0x00)

		label(0x00)
	endloop(0x1f)

	label(0x20)
	label(0x26)
	show_hudmsg(CHR_BOND, L_ARK(36)) // "Cassandra's bodyguards have been defeated."
	set_stage_flag(STAGEFLAG_OBJECTIVE_BODYGUARDS_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1006_check_hovercopter_destroyed[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x26)

	beginloop(0x1f)
		if_object_in_good_condition(OBJ_HOVERCOPTER, /*goto*/ 0x00)
		show_hudmsg(CHR_BOND, L_ARK(35)) // "DataDyne Hovercopter eliminated."
		set_stage_flag(STAGEFLAG_HOVERCOPTER_DESTROYED)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x00)
	endloop(0x1f)

	label(0x26)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100e_drcaroll_warnings[] = {
	beginloop(0x1f)
		if_chr_death_animation_finished(CHR_DRCAROLL, /*goto*/ 0x21)
		if_chr_dying(CHR_DRCAROLL, /*goto*/ 0x21)
		if_chr_unloaded(CHR_DRCAROLL, /*goto*/ 0x21)
		if_stage_flag_eq(STAGEFLAG_DRCAROLL_ATTACKED, TRUE, /*goto*/ 0x00)
		if_chr_shield_lt(CHR_DRCAROLL, 100, /*goto*/ 0x30)

		// Attacked message already shown
		label(0x00)
		if_stage_flag_eq(STAGEFLAG_DRCAROLL_DAMAGED, TRUE, /*goto*/ 0x00)
		if_just_injured(CHR_DRCAROLL, /*goto*/ 0x31)

		label(0x00)
		if_chr_death_animation_finished(CHR_DRCAROLL, /*goto*/ 0x00)
		if_chr_dying(CHR_DRCAROLL, /*goto*/ 0x00)
		if_chr_unloaded(CHR_DRCAROLL, /*goto*/ 0x00)
		reloop(0x1f)

		// Dead
		label(0x21)
		label(0x00)
		show_hudmsg(CHR_BOND, L_ARK(16)) // "Dr. Caroll has been killed!"
		set_stage_flag(STAGEFLAG_DRCAROLL_DEAD)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		// Shield under 100
		label(0x30)
		show_hudmsg(CHR_BOND, L_ARK(17)) // "Dr. Caroll is under attack!"
		set_stage_flag(STAGEFLAG_DRCAROLL_ATTACKED)
		reloop(0x1f)

		label(0x31)
		show_hudmsg(CHR_BOND, L_ARK(18)) // "Dr. Caroll has been damaged!"
		set_stage_flag(STAGEFLAG_DRCAROLL_DAMAGED)
	endloop(0x1f)

	endlist
};

u8 func1007_noop[] = {
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1008_trigger_hovercopter_roof[] = {
	// Wait until techs running, then wait 7 seconds, then set flag that allows
	// the hovercopter to go to the roof.
	beginloop(0x1f)
		if_timer_gt(420, /*goto*/ 0x21)
		if_timer_gt(0, /*goto*/ 0x20)
		if_stage_flag_eq(STAGEFLAG_TECHS_RUNNING, TRUE, /*goto*/ 0x00)
		label(0x20)
		reloop(0x1f)

		label(0x00)
		restart_timer
	endloop(0x1f)

	label(0x21)
	set_stage_flag(STAGEFLAG_CHOPPER_GO_TO_ROOF)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1009_init_top_room[] = {
	set_chr_chrflag(CHR_TOPGUARD1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_TOPGUARD2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_TOPGUARD3, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_TOPGUARD4, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_TOPGUARD5, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_CASS, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)

	beginloop(0x1f)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0039, /*goto*/ 0x00)
		if_chr_activated_object(CHR_P1P2, OBJ_TOPROOMDOOR, /*goto*/ 0x00)
	endloop(0x1f)

	label(0x00)
	set_object_flag(OBJ_TOPROOMDOOR, OBJFLAG_CANNOT_ACTIVATE)
	set_chr_target_chr(CHR_CASS, CHR_P1P2)
	set_chr_target_chr(CHR_TOPGUARD1, CHR_P1P2)
	set_chr_target_chr(CHR_TOPGUARD2, CHR_P1P2)
	set_chr_target_chr(CHR_TOPGUARD3, CHR_P1P2)
	set_chr_target_chr(CHR_TOPGUARD4, CHR_P1P2)
	set_chr_target_chr(CHR_TOPGUARD5, CHR_P1P2)
	unset_chr_chrflag(CHR_TOPGUARD1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_TOPGUARD2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_TOPGUARD3, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_TOPGUARD4, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_TOPGUARD5, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_team(CHR_CASS, TEAM_ENEMY)
	set_chr_team(CHR_TOPGUARD1, TEAM_ENEMY)
	set_chr_team(CHR_TOPGUARD2, TEAM_ENEMY)
	set_chr_team(CHR_TOPGUARD3, TEAM_ENEMY)
	set_chr_team(CHR_TOPGUARD4, TEAM_ENEMY)
	set_chr_team(CHR_TOPGUARD5, TEAM_ENEMY)
	set_stage_flag(STAGEFLAG_ENTERING_TOP_ROOM)
	restart_timer

	beginloop(0x21)
		if_timer_gt(60, /*goto*/ 0x00)
	endloop(0x21)

	label(0x00)
	beginloop(0x21)
		if_chr_shield_lt(CHR_CASS, 100, /*goto*/ 0x20)
	endloop(0x21)

	label(0x20)
	set_stage_flag(STAGEFLAG_CASS_SHIELD_DAMAGED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040b_init_tech1[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, 0x0409)
	endlist
};

u8 func0409_tech_conversation[] = {
	set_shotlist(GAILIST_IDLE)

	beginloop(0x01)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_activated_object(CHR_TARGET, 0x11, /*goto*/ 0x00)
		if_door_state(0x11, DOORSTATE_OPEN, /*goto*/ 0x00)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x33)
		dprint 'T','E','C','H',' ','1',' ','L','O','O','P','\n',0,
		set_chr_chrflag(CHR_TECH1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
		set_chr_chrflag(CHR_TECH2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
		set_chr_chrflag(CHR_RLSHOCK, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	endloop(0x01)

	// Player activated door or door is fully open
	label(0x00)
	set_chrpreset(CHR_TARGET)
	set_chr_team(CHR_TECH1, TEAM_ENEMY)
	set_chr_team(CHR_TECH2, TEAM_ENEMY)
	set_chr_team(CHR_RLSHOCK, TEAM_ENEMY)
	rebuild_teams
	rebuild_squadrons
	unset_chr_chrflag(CHR_TECH1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_TECH2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_RLSHOCK, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_RLSHOCK, GAILIST_UNALERTED)
	restart_timer
	chr_do_animation(0x0204, -1, -1, 0x02, 0x14, 0x10, 2)

	beginloop(0x28)
		if_saw_injury(0x00, /*goto*/ 0x33)
		if_saw_death(0x00, /*goto*/ 0x33)
		if_timer_gt(30, /*goto*/ 0x20)
	endloop(0x28)

	label(0x20)
	dprint 'T','E','C','H',' ','2',' ','L','O','O','P','\n',0,
	chr_do_animation(ANIM_TALKING_00A0, 0, -1, 0x10, 0x14, CHR_SELF, 2)
	speak(CHR_PRESET, L_ARK(37), 0x811d, CHANNEL_7, COLOR_06_WHITE) // "That's not how it goes."
	restart_timer

	beginloop(0x21)
		if_saw_injury(0x00, /*goto*/ 0x33)
		if_saw_death(0x00, /*goto*/ 0x33)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x33)
		if_target_in_sight(/*goto*/ 0x33)
		pause_timer
		if_sound_finished(CHANNEL_7, /*goto*/ 0x20)
		reloop(0x21)

		label(0x20)
		resume_timer
		if_timer_gt(20, /*goto*/ 0x20)
	goto_first(0x21)

	label(0x20)
	chr_do_animation(ANIM_TWO_GUN_HOLD, 0, -1, 0x10, 0x14, CHR_SELF, 2)
	chr_do_animation(ANIM_TALKING_00A0, -1, -1, 0x02, 0x14, 0x10, 2)
	speak(CHR_PRESET, L_ARK(38), 0x8120, CHANNEL_7, COLOR_08_RED) // "Yes, it is."

	beginloop(0x22)
		if_saw_injury(0x00, /*goto*/ 0x33)
		if_saw_death(0x00, /*goto*/ 0x33)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x33)
		if_target_in_sight(/*goto*/ 0x33)
		pause_timer
		if_sound_finished(CHANNEL_7, /*goto*/ 0x20)
		reloop(0x22)

		label(0x20)
		resume_timer
		if_timer_gt(40, /*goto*/ 0x20)
	endloop(0x22)

	label(0x20)
	chr_do_animation(ANIM_TALKING_00A0, 0, -1, 0x10, 0x14, CHR_SELF, 2)
	chr_do_animation(0x0205, -1, -1, 0x02, 0x14, 0x10, 2)
	speak(CHR_PRESET, L_ARK(39), 0x811e, CHANNEL_7, COLOR_06_WHITE) // "Give it to me - you're doing it wrong."

	beginloop(0x23)
		if_saw_injury(0x00, /*goto*/ 0x33)
		if_saw_death(0x00, /*goto*/ 0x33)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x33)
		if_target_in_sight(/*goto*/ 0x33)
		pause_timer
		if_sound_finished(CHANNEL_7, /*goto*/ 0x20)
		reloop(0x23)

		label(0x20)
		resume_timer
		if_timer_gt(60, /*goto*/ 0x20)
	endloop(0x23)

	label(0x20)
	chr_do_animation(ANIM_TWO_GUN_HOLD, 0, -1, 0x10, 0x14, CHR_SELF, 2)
	chr_do_animation(ANIM_TALKING_00A0, -1, -1, 0x02, 0x14, 0x10, 2)
	speak(CHR_PRESET, L_ARK(40), 0x8121, CHANNEL_7, COLOR_08_RED) // "Stop annoying me."

	beginloop(0x24)
		if_saw_injury(0x00, /*goto*/ 0x33)
		if_saw_death(0x00, /*goto*/ 0x33)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x33)
		if_target_in_sight(/*goto*/ 0x33)
		pause_timer
		if_sound_finished(CHANNEL_7, /*goto*/ 0x20)
		reloop(0x24)

		label(0x20)
		resume_timer
		if_timer_gt(80, /*goto*/ 0x20)
	endloop(0x24)

	label(0x20)
	chr_do_animation(ANIM_TWO_GUN_HOLD, 0, -1, 0x10, 0x14, CHR_SELF, 2)
	chr_do_animation(ANIM_TALKING_00A0, -1, -1, 0x02, 0x14, CHR_RLSHOCK, 2)
	chr_do_animation(0x0206, -1, -1, 0x02, 0x14, 0x10, 2)
	speak(CHR_PRESET, L_ARK(41), 0x8123, CHANNEL_7, COLOR_09_BLUE) // "Will you just hurry up!"

	beginloop(0x25)
		if_saw_injury(0x00, /*goto*/ 0x33)
		if_saw_death(0x00, /*goto*/ 0x33)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x33)
		if_target_in_sight(/*goto*/ 0x33)
		pause_timer
		if_sound_finished(CHANNEL_7, /*goto*/ 0x20)
		reloop(0x25)

		label(0x20)
		resume_timer
		if_timer_gt(100, /*goto*/ 0x20)
	endloop(0x25)

	label(0x20)
	set_stage_flag(STAGEFLAG_TECHS_FINISHED)
	stop_chr

	beginloop(0x26)
		if_saw_injury(0x00, /*goto*/ 0x33)
		if_saw_death(0x00, /*goto*/ 0x33)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x33)
		if_chr_sees_player(/*goto*/ 0x20)
	endloop(0x26)

	label(0x20)
	label(0x33)
	dprint 'C','H','O','P','P','E','R',' ','C','A','N',' ','G','O','\n',0,
	if_stage_flag_eq(STAGEFLAG_TECHS_RUNNING, TRUE, /*goto*/ 0x00)
	set_stage_flag(STAGEFLAG_TECHS_RUNNING)
	label(0x00)
	increase_squadron_alertness(100)
	open_door(0x04)
	restart_timer
	speak(CHR_TARGET, L_ARK(42), 0x811f, CHANNEL_7, COLOR_06_WHITE) // "Oh, no...too late."
	chr_do_animation(ANIM_SURRENDER_002E, 0, 193, 0x18, 0x10, CHR_SELF, 2)

	beginloop(0x34)
		if_timer_gt(60, /*goto*/ 0x35)
	endloop(0x34)

	label(0x35)
	jog_to_pad(0x01cd)

	beginloop(0x36)
		if_chr_stopped(/*goto*/ 0x37)
	endloop(0x36)

	label(0x37)
	restart_timer
	surrender
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Unreachable
	chr_do_animation(ANIM_COWER_0229, -1, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x38)
		if_chr_idle(/*goto*/ 0x5e)
		goto_next(0x20)

		label(0x5e)
		reloop(0x38)

		label(0x20)
		restart_timer
	endloop(0x38)

	label(0x00)
	remove_chr(CHR_SELF)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040d_cass_necklace[] = {
	remove_cass_necklace(CHR_CASS)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040c_init_tech2[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, 0x040a)
	endlist
};

u8 func040a_tech2[] = {
	set_shotlist(GAILIST_IDLE)
	stop_chr

	beginloop(0x1f)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_stage_flag_eq(STAGEFLAG_TECHS_FINISHED, TRUE, /*goto*/ 0x20)
		if_target_in_sight(/*goto*/ 0x33)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x33)
	endloop(0x1f)

	label(0x20)
	stop_chr

	beginloop(0x21)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x00)
		reloop(0x21)

		label(0x00)
		label(0x33)
		dprint 'C','H','O','P','P','E','R',' ','C','A','N',' ','G','O','\n',0,
		if_stage_flag_eq(STAGEFLAG_TECHS_RUNNING, TRUE, /*goto*/ 0x00)
		set_stage_flag(STAGEFLAG_TECHS_RUNNING)
		label(0x00)
		increase_squadron_alertness(100)
		open_door(0x04)
		yield
		restart_timer
		chr_do_animation(0x0205, 0, -1, 0x18, 0x0a, CHR_SELF, 2)

		// @bug: Duplicate label. I suspect the goto first 0x21 below is
		// supposed to go here. The only possible side effect is the tech may
		// restart his animation repeatedly.
		label(0x21)
		yield
		if_sound_finished(CHANNEL_7, /*goto*/ 0x20)
	endloop(0x21)

	label(0x20)
	chr_do_animation(ANIM_SURRENDER_002E, 0, -1, 0x18, 0x0a, CHR_SELF, 2)
	speak(CHR_TARGET, L_ARK(43), 0x8122, CHANNEL_7, COLOR_08_RED) // "She's here..."

	beginloop(0x22)
		if_sound_finished(CHANNEL_7, /*goto*/ 0x35)
	endloop(0x22)

	label(0x35)
	jog_to_pad(0x002a)

	beginloop(0x36)
		if_chr_stopped(/*goto*/ 0x37)
	endloop(0x36)

	label(0x37)
	restart_timer
	surrender
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Unreachable
	chr_do_animation(ANIM_COWER_0229, -1, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x38)
		if_chr_idle(/*goto*/ 0x5e)
		goto_next(0x20)

		label(0x5e)
		reloop(0x38)

		label(0x20)
		restart_timer
	endloop(0x38)

	label(0x00)
	remove_chr(CHR_SELF)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040d_cass[] = {
	set_shield(100)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_CASS, CHRCFLAG_UNEXPLODABLE)
	set_target_chr(CHR_P1P2)

	beginloop(0x3b)
		if_stage_flag_eq(STAGEFLAG_ENTERING_TOP_ROOM, TRUE, /*goto*/ 0x3a)
	endloop(0x3b)

	label(0x3a)
	open_door(OBJ_TOPROOMDOOR)
	set_target_chr(CHR_PRESET)
	if_num_human_players_lt(2, /*goto*/ 0x20)
	goto_next(0x89)

	// 1 player - do force walk (enter room)
	label(0x20)
	revoke_control(CHR_BOND, 0)
	force_walk(CHR_BOND, 0x0019, 40, 55, 0, 46)

	beginloop(0x23)
		open_door(OBJ_TOPROOMDOOR)
		if_force_walk_finished(CHR_BOND, /*goto*/ 0x24)
	endloop(0x23)

	// Second force walk (turn to face Cass)
	label(0x24)
	force_walk(CHR_BOND, 0x0018, 0, 65, 65, 0)
	open_door(OBJ_TOPROOMDOOR)

	beginloop(0x25)
		if_force_walk_finished(CHR_BOND, /*goto*/ 0x26)
	endloop(0x25)

	label(0x26)
	unset_object_flag(OBJ_TOPROOMDOOR, OBJFLAG_CANNOT_ACTIVATE)
	grant_control(CHR_BOND)
	close_door(OBJ_TOPROOMDOOR)
	if_chr_in_room(CHR_BOND, 0x00, 0x0045, /*goto*/ 0x20)
	lock_door(OBJ_TOPROOMDOOR, 0x02)

	// 2 players, or force walk failed
	label(0x20)
	if_chr_death_animation_finished(CHR_DRCAROLL, /*goto*/ 0x20)
	if_chr_dying(CHR_DRCAROLL, /*goto*/ 0x20)
	if_chr_unloaded(CHR_DRCAROLL, /*goto*/ 0x20)
	set_ailist(CHR_DRCAROLL, 0x0405)
	label(0x20)
	goto_next(0x00)

	label(0x89)
	unset_object_flag(OBJ_TOPROOMDOOR, OBJFLAG_CANNOT_ACTIVATE)
	restart_timer

	beginloop(0x8a)
		if_stage_flag_eq(STAGEFLAG_CASS_SHIELD_DAMAGED, TRUE, /*goto*/ 0x5b)
		if_timer_gt(120, /*goto*/ 0x00)
	endloop(0x8a)

	label(0x00)
	restart_timer
	speak(CHR_TARGET, L_ARK(32), 0x80ff, CHANNEL_6, COLOR_04_ORANGE) // "We meet again, girl!"
	chr_do_animation(ANIM_TALKING_00A0, 0, 193, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x27)
		if_stage_flag_eq(STAGEFLAG_CASS_SHIELD_DAMAGED, TRUE, /*goto*/ 0x5b)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x00)
	endloop(0x27)

	label(0x00)
	restart_timer
	speak(CHR_TARGET, L_ARK(20), 0x80fe, CHANNEL_6, COLOR_04_ORANGE) // "You've become quite an annoyance..."
	chr_do_animation(ANIM_TALKING_00A3, 0, 193, 0x10, 0x14, CHR_SELF, 2)

	beginloop(0x28)
		if_stage_flag_eq(STAGEFLAG_CASS_SHIELD_DAMAGED, TRUE, /*goto*/ 0x5b)
		if_timer_gt(300, /*goto*/ 0x00)
	endloop(0x28)

	label(0x5b)
	restart_timer

	beginloop(0x29)
		if_timer_gt(60, /*goto*/ 0x20)
	endloop(0x29)

	label(0x20)
	speak(CHR_TARGET, L_ARK(44), 0x8101, CHANNEL_6, COLOR_04_ORANGE) // "Get her!"
	chr_do_animation(ANIM_TALKING_00A3, 0, 193, 0x10, 0x10, CHR_SELF, 2)
	goto_next(0x20)

	label(0x00)
	restart_timer
	speak(CHR_TARGET, L_ARK(21), 0x8100, CHANNEL_6, COLOR_04_ORANGE) // "Good night, Ms. Dark."
	chr_do_animation(ANIM_TALKING_00A0, 0, 193, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x2a)
		if_timer_gt(150, /*goto*/ 0x20)
	endloop(0x2a)

	label(0x20)
	set_lights_state(0x0044, 0x07, 0x00, 0x00, 0x00)
	set_lights_state(0x0039, 0x07, 0x00, 0x00, 0x00)
	set_lights_state(0x003c, 0x07, 0x00, 0x00, 0x00)
	set_lights_state(0x003d, 0x07, 0x00, 0x00, 0x00)
	set_lights_state(0x003e, 0x07, 0x00, 0x00, 0x00)
	set_lights_state(0x003b, 0x07, 0x00, 0x00, 0x00)
	set_lights_state(0x0042, 0x07, 0x00, 0x00, 0x00)
	set_lights_state(0x003f, 0x07, 0x00, 0x00, 0x00)
	set_lights_state(0x003a, 0x07, 0x00, 0x00, 0x00)
	set_lights_state(0x0041, 0x07, 0x00, 0x00, 0x00)
	set_lights_state(0x0040, 0x07, 0x00, 0x00, 0x00)
	set_stage_flag(STAGEFLAG_TOP_LIGHTS_OFF)
	set_stage_flag(STAGEFLAG_TOP_GUARDS_ATTACKING)
	walk_to_pad(0x000f)
	restart_timer

	beginloop(0x2b)
		if_timer_gt(60, /*goto*/ 0x00)
	endloop(0x2b)

	label(0x00)
	play_sound(0x8102, CHANNEL_7)

	beginloop(0x2c)
		if_timer_gt(120, /*goto*/ 0x00)
	endloop(0x2c)

	label(0x00)
	play_x_music(CHANNEL_10, 60)

	beginloop(0x3f)
		if_timer_gt(180, /*goto*/ 0x00)
	endloop(0x3f)

	label(0x00)
	set_stage_flag(STAGEFLAG_TRIGGER_CANTLEAVEANY_MSG)
	label(0x3d)
	label(0x00)
	label(0x00)
	set_stage_flag(STAGEFLAG_TOP_GUARDS_ATTACKING)

	// Wait until Jo not in top room
	beginloop(0x2c)
		if_chr_in_room(CHR_SELF, 0x00, 0x003a, /*goto*/ 0x20)
		if_chr_in_room(CHR_SELF, 0x00, 0x003b, /*goto*/ 0x20)
		goto_next(0x00)

		label(0x20)
		reloop(0x2c)

		// And not in sight
		label(0x00)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_within_units_of_sight(30, /*goto*/ 0x20)
		set_target_chr(CHR_ANTI)
		if_within_units_of_sight(30, /*goto*/ 0x20)
		goto_next(0x2d)

		label(0x20)
	endloop(0x2c)

	label(0x2d)
	set_chr_hiddenflag(CHR_CASS, CHRHFLAG_00100000)
	remove_cass_necklace(CHR_CASS)
	chr_move_to_pad(CHR_CASS, 0x0205, 0x00, /*goto*/ 0x00)
	dprint 'M','O','V','E',' ','F','A','I','L','\n',0,
	label(0x00)
	dprint 'M','O','V','E',' ','G','O','O','D','\n',0,
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x20)
	label(0x20)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101f_unlock_top_door[] = {
	beginloop(0x1f)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x003b, /*goto*/ 0x20)
	endloop(0x1f)

	label(0x20)
	unlock_door(OBJ_TOPROOMDOOR, 0x02)
	unset_object_flag2(OBJ_TOPROOMDOOR, OBJFLAG2_AICANNOTUSE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * @unused
 */
u8 func040e_noop2[] = {
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100a_lightswitch[] = {
	beginloop(0x1f)
		if_chr_activated_object(CHR_ANY, OBJ_LIGHTSWITCH, /*goto*/ 0x20)
		reloop(0x1f)

		label(0x20)
		play_sound(0x00ba, -1)
		if_stage_flag_eq(STAGEFLAG_TOP_LIGHTS_OFF, TRUE, /*goto*/ 0x00)
		set_lights_state(0x0044, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x0039, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x003c, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x003d, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x003e, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x003b, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x0042, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x003f, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x003a, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x0041, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x0040, 0x07, 0x00, 0x00, 0x00)
		set_stage_flag(STAGEFLAG_TOP_LIGHTS_OFF)
		reloop(0x1f)

		label(0x00)
		unset_stage_flag(STAGEFLAG_TOP_LIGHTS_OFF)
		set_lights_state(0x0044, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x0039, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x003c, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x003d, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x003e, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x003b, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x0042, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x003f, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x003a, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x0041, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x0040, 0x06, 0x00, 0x00, 0x00)
	endloop(0x1f)

	endlist
};

u8 func100b_check_top_lights_on[] = {
	beginloop(0x1f)
		if_stage_flag_eq(STAGEFLAG_TOP_GUARDS_ATTACKING, TRUE, /*goto*/ 0x00)
		endloop(0x1f)

		label(0x00)
		if_stage_flag_eq(STAGEFLAG_TOP_LIGHTS_OFF, TRUE, /*goto*/ 0x00)
		goto_next(0x20)

		label(0x00)
	endloop(0x1f)

	label(0x20)
	set_stage_flag(STAGEFLAG_CASS_SHIELD_DAMAGED)
	set_ailist(CHR_TOPGUARD1, AILIST_TOP_GUARD_BLINDED)
	set_ailist(CHR_TOPGUARD2, AILIST_TOP_GUARD_BLINDED)
	set_ailist(CHR_TOPGUARD3, AILIST_TOP_GUARD_BLINDED)
	set_ailist(CHR_TOPGUARD4, AILIST_TOP_GUARD_BLINDED)
	set_ailist(CHR_TOPGUARD5, AILIST_TOP_GUARD_BLINDED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100c_foyer_lights[] = {
	restart_timer
	beginloop(0x21)
		if_stage_flag_eq(STAGEFLAG_FOYER_LIGHTS_OFF, TRUE, /*goto*/ 0x00)
		if_timer_gt(980, /*goto*/ 0x00)
	endloop(0x21)

	label(0x00)
	set_lights_state(0x0019, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x001a, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x001b, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x001c, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x001d, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x001e, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x001f, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0020, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0021, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0017, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0018, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0016, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0022, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0023, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0024, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0025, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0026, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0027, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0028, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0029, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x002a, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x002b, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x002c, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x002d, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x002e, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x002f, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0030, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0031, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0032, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0033, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0034, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0035, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0036, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x0015, 0x03, 0x64, 0x02, 0x78)
	set_lights_state(0x000f, 0x03, 0x64, 0x02, 0xf0)
	set_lights_state(0x000e, 0x03, 0x64, 0x02, 0xf0)
	set_lights_state(0x0010, 0x03, 0x64, 0x02, 0xf0)
	set_lights_state(0x0011, 0x03, 0x64, 0x02, 0xf0)
	set_lights_state(0x0012, 0x03, 0x64, 0x02, 0xf0)
	set_lights_state(0x0013, 0x03, 0x64, 0x02, 0xf0)
	set_lights_state(0x0014, 0x03, 0x64, 0x02, 0xf0)
	set_lights_state(0x000d, 0x03, 0x64, 0x02, 0xf0)
	restart_timer

	beginloop(0x22)
		if_timer_gt(240, /*goto*/ 0x00)
	endloop(0x22)

	label(0x00)
	set_lights_state(0x0019, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x001a, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x001b, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x001c, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x001d, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x001e, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x001f, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0020, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0021, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0017, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0018, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0016, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0022, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0023, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0024, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0025, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0026, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0027, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0028, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0029, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x002a, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x002b, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x002c, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x002d, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x002e, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x002f, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0030, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0031, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0032, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0033, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0034, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0035, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0036, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0015, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x000f, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x000e, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0010, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0011, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0012, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0013, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x0014, 0x01, 0x02, 0x00, 0x00)
	set_lights_state(0x000d, 0x01, 0x02, 0x00, 0x00)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1400_setup_counterop[] = {
	yield
	set_chr_team(CHR_ANTI, TEAM_ENEMY)
	give_object_to_chr(OBJ_NIGHTVISION, CHR_BOND)
	give_object_to_chr(OBJ_NIGHTVISION, CHR_COOP)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func100d_intro[] = {
	set_music_track(MUSIC_EXTRACTION_INTRO)
	camera_movement(0x0138)
	cmd0175(60)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x0139, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	set_chr_chrflag(0x00, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(0x00, CHRHFLAG_00020000)
	chr_do_animation(0x013d, -1, -1, 0x06, 0x00, CHR_DRCAROLL, 4)
	set_chr_chrflag(CHR_INTRO_GUARD, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_INTRO_GUARD, CHRHFLAG_00020000)
	chr_do_animation(0x013a, -1, -1, 0x06, 0x00, CHR_INTRO_GUARD, 4)
	unset_stage_flag(STAGEFLAG_00800000)
	restart_timer
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 110)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_FALCON2_SCOPE, WEAPON_NONE)
	if_controller_button_pressed(/*goto*/ 0x00)

	#define wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0x5d) \
			if_timer_gt(time, /*goto*/ 0x00) \
		endloop(loopid) \
		label(0x00)



	wait_until(20, 0x61)
	open_door(0x0c)

	wait_until(120, 0x60)
	play_sound(0x0161, -1)

	wait_until(350, 0x62)
	play_sound(0x042f, -1)

	wait_until(450, 0x63)
	play_sound(0x0427, -1)

	wait_until(540, 0x64)
	speak(CHR_BOND, L_ARK(60), 0x7bf3, CHANNEL_7, COLOR_06_WHITE) // "Sound the alarm - she's here!"

	wait_until(640, 0x65)
	speak(CHR_BOND, L_ARK(61), 0x73f4, CHANNEL_7, COLOR_09_BLUE) // "Lights out!"

	wait_until(690, 0x66)
	play_sound(0x0428, -1)

	wait_until(720, 0x67)
	play_sound(0x0250, 10)

	wait_until(850, 0x68)
	play_sound(0x0430, -1)

	wait_until(880, 0x69)
	play_sound(0x0429, -1)

	wait_until(890, 0x6a)
	close_door(0x0c)

	wait_until(1000, 0x6b)
	speak(CHR_BOND, L_ARK(62), 0x73f5, CHANNEL_7, COLOR_09_BLUE) // "What the...?"

	beginloop(0x21)
		if_camera_animating(/*goto*/ 0x20)
		goto_next(0x5d)

		label(0x20)
	endloop(0x21)

	label(0x5d)
	set_stage_flag(STAGEFLAG_FOYER_LIGHTS_OFF)
	mute_channel(CHANNEL_10)
	mute_channel(CHANNEL_7)

	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x0139, -2, -1, 0x06, 0x00, CHR_BOND, 2)

	unset_chr_chrflag(CHR_DRCAROLL, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_DRCAROLL, CHRHFLAG_00020000)
	chr_do_animation(0x013d, -2, -1, 0x06, 0x00, CHR_DRCAROLL, 2)

	unset_chr_chrflag(CHR_INTRO_GUARD, CHRCFLAG_UNPLAYABLE)
	set_chr_chrflag(CHR_INTRO_GUARD, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_hiddenflag(CHR_INTRO_GUARD, CHRHFLAG_00020000)
	set_chr_chrflag(CHR_INTRO_GUARD, CHRCFLAG_00010000)
	chr_do_animation(0x013a, -2, -1, 0x06, 0x00, CHR_INTRO_GUARD, 2)

	restart_default_music
	reset_ambience
	enter_firstperson
	yield
	chr_do_animation(0x020c, -1, -1, 0x06, 0x00, CHR_INTRO_GUARD, 2)
	set_ailist(CHR_DRCAROLL, 0x0402)
	yield
	kill(CHR_INTRO_GUARD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0412_outro[] = {
	set_music_track(MUSIC_EXTRACTION_OUTRO)
	set_sfx_track(MUSIC_EXTRACTION_OUTRO_SFX)
	camera_movement(0x0157)
	set_object_flag2(OBJ_HOVERCOPTER, OBJFLAG2_INVISIBLE)
	hide_object(OBJ_HOVERCOPTER)
	set_ailist(CHR_P1P2, GAILIST_IDLE)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0xf1, CHRCFLAG_HIDDEN)
	dprint 'c','u','t',' ','s','c','e','n','e',' ','2',0,
	set_chr_chrflag(CHR_P1P2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_CASS, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	remove_cass_necklace(CHR_CASS)
	set_chr_chrflag(CHR_MRBLONDE, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_OUTRO_GUARD1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_OUTRO_GUARD2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_DRCAROLL, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)

	set_ailist(CHR_DRCAROLL, GAILIST_IDLE)
	set_chr_chrflag(CHR_DRCAROLL, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_DRCAROLL, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_DRCAROLL, CHRHFLAG_00020000)
	chr_do_animation(0x015d, -1, -1, 0x06, 0x00, CHR_DRCAROLL, 4)

	set_ailist(CHR_CASS, AILIST_CASS_OUTRO)
	set_chr_chrflag(CHR_CASS, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_CASS, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_CASS, CHRHFLAG_00020000)
	chr_do_animation(0x0159, -1, -1, 0x06, 0x00, CHR_CASS, 4)

	set_ailist(CHR_MRBLONDE, GAILIST_IDLE)
	set_chr_chrflag(CHR_MRBLONDE, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_MRBLONDE, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_MRBLONDE, CHRHFLAG_00020000)
	chr_do_animation(0x015a, -1, -1, 0x06, 0x00, CHR_MRBLONDE, 4)

	set_ailist(CHR_OUTRO_GUARD1, GAILIST_IDLE)
	set_chr_chrflag(CHR_OUTRO_GUARD1, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_OUTRO_GUARD1, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_OUTRO_GUARD1, CHRHFLAG_00020000)
	chr_do_animation(0x015b, -1, -1, 0x06, 0x00, CHR_OUTRO_GUARD1, 4)

	set_ailist(CHR_OUTRO_GUARD2, GAILIST_IDLE)
	set_chr_chrflag(CHR_OUTRO_GUARD2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_OUTRO_GUARD2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_OUTRO_GUARD2, CHRHFLAG_00020000)
	chr_do_animation(0x015c, -1, -1, 0x06, 0x00, CHR_OUTRO_GUARD2, 4)

	show_object(OBJ_JUMPSHIP)
	set_object_flag3(OBJ_JUMPSHIP, OBJFLAG3_00000010)
	set_object_flag2(OBJ_JUMPSHIP, OBJFLAG2_04000000)
	object_do_animation(0x015e, OBJ_JUMPSHIP, 0x04, 0xffff)
	set_ailist(CHR_P1P2, GAILIST_IDLE)
	set_chr_chrflag(CHR_P1P2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_P1P2, CHRHFLAG_00020000)
	chr_do_animation(0x0158, -1, -1, 0x06, 0x00, CHR_P1P2, 4)
	show_nonessential_chrs(FALSE)
	restart_timer
	set_cutscene_weapon(CHR_P1P2, -1, -1)
	yield
	set_cutscene_weapon(CHR_P1P2, -1, WEAPON_FALCON2_SCOPE)

	#define outro_wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0x5d) \
			if_timer_gt(time, /*goto*/ 0x00) \
		endloop(loopid) \
		label(0x00)



	outro_wait_until(0, 0x5f)
	outro_wait_until(20, 0x5f)
	outro_wait_until(47, 0x7e)
	outro_wait_until(90, 0x7f)

	outro_wait_until(120, 0x60)
	speak(CHR_P1P2, L_ARK(63), 0x73f6, CHANNEL_7, COLOR_04_ORANGE) // "Going somewhere?"

	outro_wait_until(188, 0x61)
	play_sound(0x01d9, -1)

	outro_wait_until(350, 0x62)
	speak(CHR_P1P2, L_ARK(64), 0x73f7, CHANNEL_7, COLOR_09_BLUE) // "Something I can do for you, old woman?"

	outro_wait_until(500, 0x63)
	speak(CHR_P1P2, L_ARK(65), 0x73f8, CHANNEL_7, COLOR_04_ORANGE) // "Return our sapient immediately! You don't know wha..."

	outro_wait_until(720, 0x64)
	play_sound(0x0424, -1)

	outro_wait_until(740, 0x65)
	speak(CHR_P1P2, L_ARK(66), 0x73f9, CHANNEL_7, COLOR_09_BLUE) // "Yes I do. I'm leaving."

	outro_wait_until(858, 0x73)

	outro_wait_until(980, 0x66)
	speak(CHR_P1P2, L_ARK(67), 0x73fa, CHANNEL_7, COLOR_04_ORANGE) // "One more chance! Give it back, and you could come ..."

	outro_wait_until(990, 0x68)
	play_sound(0x804f, -1)

	outro_wait_until(1220, 0x69)

	outro_wait_until(1240, 0x6a)

	outro_wait_until(1348, 0x6b)
	play_sound(0x80c8, -1)

	outro_wait_until(1380, 0x80)
	play_sound(0x80c9, -1)

	outro_wait_until(1400, 0x81)
	set_chr_shooting_in_cutscene(CHR_OUTRO_GUARD1, TRUE)

	yield
	yield
	set_chr_shooting_in_cutscene(CHR_OUTRO_GUARD1, FALSE)

	outro_wait_until(1420, 0x82)
	set_chr_shooting_in_cutscene(CHR_OUTRO_GUARD2, TRUE)

	yield
	yield
	set_chr_shooting_in_cutscene(CHR_OUTRO_GUARD2, FALSE)

	outro_wait_until(1425, 0x6c)
	speak(CHR_P1P2, L_ARK(68), 0x73fb, CHANNEL_7, COLOR_09_BLUE) // "Sorry! Gotta shoot."

	outro_wait_until(1447, 0x6d)
	play_sound(0x80ca, -1)

	outro_wait_until(1486, 0x83)
	play_sound(0x80cb, -1)

	outro_wait_until(1505, 0x6e)
	play_sound(0x8055, CHANNEL_10)

	outro_wait_until(1520, 0x6f)
	play_sound(0x8055, CHANNEL_10)

	outro_wait_until(1526, 0x70)
	set_chr_shooting_in_cutscene(CHR_BOND, TRUE)

	yield
	yield
	set_chr_shooting_in_cutscene(CHR_BOND, FALSE)

	outro_wait_until(1538, 0x84)
	set_chr_shooting_in_cutscene(CHR_BOND, TRUE)

	yield
	yield
	set_chr_shooting_in_cutscene(CHR_BOND, FALSE)

	outro_wait_until(1554, 0x71)
	play_sound(0x000d, CHANNEL_10)

	outro_wait_until(1600, 0x74)
	play_sound(0x000e, CHANNEL_10)

	outro_wait_until(1734, 0x72)
	play_sound(0x808d, CHANNEL_10)

	outro_wait_until(1890, 0x75)
	play_sound(0x0425, -1)

	outro_wait_until(1940, 0x77)
	speak(CHR_P1P2, L_ARK(69), 0x73fc, CHANNEL_7, COLOR_03_RED) // "You must get the sapient back. We cannot proceed w..."

	outro_wait_until(1944, 0x76)
	play_sound(0x80c4, -1)

	outro_wait_until(1970, 0x85)
	play_sound(0x80c5, -1)

	outro_wait_until(2008, 0x86)
	play_sound(0x80c6, -1)

	outro_wait_until(2190, 0x78)
	speak(CHR_P1P2, L_ARK(70), 0x73fd, CHANNEL_7, COLOR_04_ORANGE) // "I know that!"

	outro_wait_until(2300, 0x79)
	play_sound(0x80c7, -1)

	outro_wait_until(2317, 0x87)
	play_sound(0x042e, -1)

	outro_wait_until(2324, 0x88)
	play_sound(0x80c4, -1)

	outro_wait_until(2340, 0x7a)
	play_sound(0x80c7, -1)

	outro_wait_until(2344, 0x7b)

	outro_wait_until(2393, 0x7c)
	speak(CHR_P1P2, L_ARK(71), 0x73fe, CHANNEL_7, COLOR_04_ORANGE) // "I also know who to talk to... Mr. Carrington."

	outro_wait_until(2497, 0x7d)

	beginloop(0x21)
		if_camera_animating(/*goto*/ 0x20)
		goto_next(0x5d)
		label(0x20)
		if_controller_button_pressed(/*goto*/ 0x5d)
	endloop(0x21)

	label(0x5d)
	hide_object(OBJ_JUMPSHIP)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0413_defend_pad[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(12)
	set_reaction_speed(10)
	set_chr_maxdamage(CHR_SELF, 10)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	set_shotlist(AILIST_GENERAL_COMBAT)

	beginloop(0x1f)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x21)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x21)
		if_distance_from_target_to_pad_lt(200, PAD_PRESET, /*goto*/ 0x22)
	endloop(0x1f)

	label(0x21)
	set_ailist(CHR_SELF, AILIST_GENERAL_COMBAT)

	label(0x22)
	go_to_target_pad(SPEED_RUN)

	beginloop(0x23)
		if_chr_stopped(/*goto*/ 0x00)
		if_chr_sees_player(/*goto*/ 0x00)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x00)
	endloop(0x23)

	label(0x00)
	set_ailist(CHR_SELF, AILIST_GENERAL_COMBAT)
	endlist
};

u8 func100f_move_rocket_ammo[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x00)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Agent only
	label(0x00)
	move_object_to_pad(OBJ_ROCKETAMMO1, 0x000f)
	move_object_to_pad(OBJ_ROCKETAMMO2, 0x000d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040d_cass_outro[] = {
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1001_objectives_failed_msg[] = {
	yield
	set_chr_chrflag(CHR_TECH1, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_TECH2, CHRCFLAG_04000000)
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

u8 func0414_init_shock[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(12)
	set_reaction_speed(10)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(10)
	set_shield(0)
	set_ailist(CHR_SELF, AILIST_GENERAL_COMBAT)
	endlist
};

/**
 * @unused
 */
u8 func0415_init_10hp[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(12)
	set_reaction_speed(10)
	set_chr_maxdamage(CHR_SELF, 10)
	add_health_or_armor(40)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, AILIST_GENERAL_COMBAT)
	endlist
};

u8 func1012_msg_lockeddown[] = {
	beginloop(0x1f)
		if_chr_in_room(CHR_BOND, 0x00, 0x0023, /*goto*/ 0x20)
	endloop(0x1f)

	label(0x20)
	speak(CHR_BOND, L_ARK(51), 0x8176, CHANNEL_6, COLOR_09_BLUE) // "They've locked down the ground floor - get to the ..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1013_msg_thatcopter[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x26)

	beginloop(0x1f)
		if_stage_flag_eq(STAGEFLAG_SAID_SURRENDER_OR_DIE, TRUE, /*goto*/ 0x20)
	endloop(0x1f)

	label(0x20)
	restart_timer

	beginloop(0x21)
		if_timer_gt(300, /*goto*/ 0x20)
	endloop(0x21)

	label(0x20)
	speak(CHR_BOND, L_ARK(52), 0x8177, CHANNEL_6, COLOR_09_BLUE) // "That copter needs to be taken out, or the jumpship..."

	label(0x26)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1014_msg_cantleaveany[] = {
	beginloop(0x1f)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_CANTLEAVEANY_MSG, TRUE, /*goto*/ 0x20)
	endloop(0x1f)

	label(0x20)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x26)
	if_chr_dying(CHR_BOND, /*goto*/ 0x26)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x26)
	restart_timer

	beginloop(0x21)
		if_timer_gt(120, /*goto*/ 0x20)
	endloop(0x21)

	label(0x20)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x26)
	if_chr_dying(CHR_BOND, /*goto*/ 0x26)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x26)
	speak(CHR_BOND, L_ARK(53), 0x73aa, CHANNEL_6, COLOR_09_BLUE) // "I can't leave any bodyguards standing."

	label(0x26)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x27)
	if_chr_dying(CHR_BOND, /*goto*/ 0x27)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x27)

	beginloop(0x5f)
		if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x27)
		if_chr_dying(CHR_BOND, /*goto*/ 0x27)
		if_chr_unloaded(CHR_BOND, /*goto*/ 0x27)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x20)
	endloop(0x5f)

	label(0x20)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x27)
	mute_channel(CHANNEL_6)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1015_msg_jumpshipwaiting[] = {
	beginloop(0x1f)
		if_objective_failed(0, /*goto*/ 0x00)
		if_objective_failed(1, /*goto*/ 0x00)
		if_objective_failed(2, /*goto*/ 0x00)
		if_objective_failed(3, /*goto*/ 0x00)
		if_objective_failed(4, /*goto*/ 0x00)
		if_chr_in_room(CHR_BOND, 0x00, 0x0002, /*goto*/ 0x20)
	endloop(0x1f)

	label(0x20)
	speak(CHR_BOND, L_ARK(54), 0x8178, CHANNEL_6, COLOR_09_BLUE) // "Don't keep the jumpship waiting - get back to the ..."

	label(0x00)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1016_msg_make_foyer_guards_alerted[] = {
	beginloop(0x1f)
		if_stage_flag_eq(STAGEFLAG_ACCESSED_FOYER_ELEVATOR, TRUE, /*goto*/ 0x20)
	endloop(0x1f)

	#define if_alive_set_alerted(chr) \
		if_chr_death_animation_finished(chr, /*goto*/ 0x20) \
		if_chr_dying(chr, /*goto*/ 0x20) \
		if_chr_unloaded(chr, /*goto*/ 0x20) \
		set_ailist(chr, GAILIST_ALERTED) \
		increase_chr_alertness(100, chr) \
		label(0x20)



	label(0x20)
	if_alive_set_alerted(0x01)
	if_alive_set_alerted(0x02)
	if_alive_set_alerted(0x03)
	if_alive_set_alerted(0x04)
	if_alive_set_alerted(0x05)
	if_alive_set_alerted(0x06)
	if_alive_set_alerted(0x07)
	if_alive_set_alerted(0x08)
	if_alive_set_alerted(0x09)
	if_alive_set_alerted(0x0a)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1017_remove_special_shock[] = {
	beginloop(0x1f)
		if_stage_flag_eq(STAGEFLAG_DRCAROLL_ATTACKED, TRUE, /*goto*/ 0x00)
		if_stage_flag_eq(STAGEFLAG_FOYER_LIGHTS_RESTORED, TRUE, /*goto*/ 0x00)

		if_chr_death_animation_finished(0x01, /*goto*/ 0x20)
		if_chr_dying(0x01, /*goto*/ 0x20)
		if_chr_unloaded(0x01, /*goto*/ 0x20)
		reloop(0x1f)
		label(0x20)

		if_chr_death_animation_finished(0x02, /*goto*/ 0x20)
		if_chr_dying(0x02, /*goto*/ 0x20)
		if_chr_unloaded(0x02, /*goto*/ 0x20)
		reloop(0x1f)
		label(0x20)

		if_chr_death_animation_finished(0x03, /*goto*/ 0x20)
		if_chr_dying(0x03, /*goto*/ 0x20)
		if_chr_unloaded(0x03, /*goto*/ 0x20)
		reloop(0x1f)
		label(0x20)

		if_chr_death_animation_finished(0x04, /*goto*/ 0x20)
		if_chr_dying(0x04, /*goto*/ 0x20)
		if_chr_unloaded(0x04, /*goto*/ 0x20)
		reloop(0x1f)
		label(0x20)

		if_chr_death_animation_finished(0x05, /*goto*/ 0x20)
		if_chr_dying(0x05, /*goto*/ 0x20)
		if_chr_unloaded(0x05, /*goto*/ 0x20)
		reloop(0x1f)
		label(0x20)

		if_chr_death_animation_finished(0x06, /*goto*/ 0x20)
		if_chr_dying(0x06, /*goto*/ 0x20)
		if_chr_unloaded(0x06, /*goto*/ 0x20)
		reloop(0x1f)
		label(0x20)

		if_chr_death_animation_finished(0x07, /*goto*/ 0x20)
		if_chr_dying(0x07, /*goto*/ 0x20)
		if_chr_unloaded(0x07, /*goto*/ 0x20)
		reloop(0x1f)
		label(0x20)

		if_chr_death_animation_finished(0x08, /*goto*/ 0x20)
		if_chr_dying(0x08, /*goto*/ 0x20)
		if_chr_unloaded(0x08, /*goto*/ 0x20)
		reloop(0x1f)
		label(0x20)

		if_chr_death_animation_finished(0x09, /*goto*/ 0x20)
		if_chr_dying(0x09, /*goto*/ 0x20)
		if_chr_unloaded(0x09, /*goto*/ 0x20)
		reloop(0x1f)
		label(0x20)

		if_chr_death_animation_finished(0x0a, /*goto*/ 0x20)
		if_chr_dying(0x0a, /*goto*/ 0x20)
		if_chr_unloaded(0x0a, /*goto*/ 0x20)
	endloop(0x1f)

	label(0x20)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x00)
	remove_chr(CHR_SPECIAL_SHOCK)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1018_give_magnum[] = {
	beginloop(0x1f)
		if_chr_has_hiddenflag(CHR_BOND, CHRHFLAG_PSYCHOSISED, /*goto*/ 0x00)
	endloop(0x1f)

	// This seems wrong. The magnum is actually given to the special shock...
	label(0x00)
	give_object_to_chr(OBJ_DY357, CHR_MRBLONDE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1419_start_lifts[] = {
	activate_lift(2, 0x1d)
	activate_lift(1, 0x1e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101a_set_rocketlauncher_flag[] = {
	yield
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x20)

	// SA and PA
	set_object_flag2(OBJ_ROCKETLAUNCHER, OBJFLAG2_AICANNOTUSE)

	label(0x20)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101b_lift_door_sounds[] = {
	beginloop(0x8d)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, 0x23, /*goto*/ 0x20)
		if_chr_activated_object(CHR_P1P2, 0x27, /*goto*/ 0x5e)
		if_chr_activated_object(CHR_P1P2, 0x20, /*goto*/ 0x20)
		if_chr_activated_object(CHR_P1P2, 0x24, /*goto*/ 0x25)
		if_chr_activated_object(CHR_P1P2, 0x21, /*goto*/ 0x5e)
		if_chr_activated_object(CHR_P1P2, 0x25, /*goto*/ 0x26)
		if_chr_activated_object(CHR_P1P2, 0x22, /*goto*/ 0x5e)
		if_chr_activated_object(CHR_P1P2, 0x26, /*goto*/ 0x5e)
		reloop(0x8d)

		label(0x25)
		if_door_locked(0x24, 0x01, /*goto*/ 0x5e)
		goto_next(0x20)

		label(0x26)
		if_door_locked(0x25, 0x01, /*goto*/ 0x5e)
		goto_next(0x20)

		label(0x20)
		play_sound(0x81b0, -1)
		goto_next(0x00)

		label(0x5e)
		play_sound(0x05dd, -1)
		label(0x00)
		restart_timer

		beginloop(0x21)
			if_timer_gt(120, /*goto*/ 0x00)
		endloop(0x21)

		label(0x00)
	endloop(0x8d)

	endlist
};

u8 func141c_setup_portals[] = {
	yield
	set_portal_flag(0x008e, 0x08)
	set_portal_flag(0x008f, 0x08)
	set_portal_flag(0x0084, 0x08)
	set_portal_flag(0x0090, 0x08)
	set_portal_flag(0x0091, 0x08)
	set_portal_flag(0x0093, 0x08)
	set_portal_flag(0x0096, 0x08)
	set_portal_flag(0x0095, 0x08)
	set_portal_flag(0x0099, 0x08)
	set_portal_flag(0x00b6, 0x08)
	set_portal_flag(0x00bf, 0x08)
	set_portal_flag(0x00be, 0x08)
	set_portal_flag(0x00c0, 0x08)
	set_portal_flag(0x00c2, 0x08)
	set_portal_flag(0x00c4, 0x08)
	set_portal_flag(0x00c8, 0x08)
	set_portal_flag(0x00c7, 0x08)
	set_portal_flag(0x00c9, 0x08)
	set_portal_flag(0x00cd, 0x08)
	set_portal_flag(0x00ce, 0x08)
	set_portal_flag(0x00d2, 0x08)
	set_portal_flag(0x00e0, 0x08)
	set_portal_flag(0x00dc, 0x08)
	set_portal_flag(0x00de, 0x08)
	set_portal_flag(0x00e3, 0x08)
	set_portal_flag(0x00e5, 0x08)
	set_portal_flag(0x00e7, 0x08)
	set_portal_flag(0x00fb, 0x08)
	set_portal_flag(0x00fa, 0x08)
	set_portal_flag(0x00fc, 0x08)
	set_portal_flag(0x00ff, 0x08)
	set_portal_flag(0x0100, 0x08)
	set_portal_flag(0x0103, 0x08)
	set_portal_flag(0x0102, 0x08)
	set_portal_flag(0x0104, 0x08)
	set_portal_flag(0x0109, 0x08)
	set_portal_flag(0x010c, 0x08)
	set_portal_flag(0x0119, 0x08)
	set_portal_flag(0x0112, 0x08)
	set_portal_flag(0x0117, 0x08)
	set_portal_flag(0x0120, 0x08)
	set_portal_flag(0x011e, 0x08)
	set_portal_flag(0x011c, 0x08)
	set_portal_flag(0x0108, 0x08)
	set_portal_flag(0x006f, 0x08)
	set_portal_flag(0x007d, 0x08)
	set_portal_flag(0x0080, 0x08)
	set_portal_flag(0x0081, 0x08)
	set_portal_flag(0x0075, 0x08)
	set_portal_flag(0x0078, 0x08)
	set_portal_flag(0x0079, 0x08)
	set_portal_flag(0x0006, 0x08)
	set_portal_flag(0x0004, 0x08)
	set_portal_flag(0x0008, 0x08)
	set_portal_flag(0x000a, 0x08)
	set_portal_flag(0x0001, 0x08)
	set_portal_flag(0x0005, 0x08)
	set_portal_flag(0x0000, 0x08)
	set_portal_flag(0x0003, 0x08)
	set_portal_flag(0x0007, 0x08)
	set_portal_flag(0x0013, 0x08)
	set_portal_flag(0x0009, 0x08)
	set_portal_flag(0x00b1, 0x08)
	set_portal_flag(0x00ef, 0x08)
	set_portal_flag(0x00ee, 0x08)
	set_portal_flag(0x0121, 0x08)
	set_portal_flag(0x00e8, 0x08)
	set_portal_flag(0x00e9, 0x08)
	set_portal_flag(0x00ea, 0x08)
	set_portal_flag(0x00ec, 0x08)
	set_portal_flag(0x00eb, 0x08)
	set_portal_flag(0x00ed, 0x08)
	set_portal_flag(0x009d, 0x08)
	set_portal_flag(0x00af, 0x08)
	set_portal_flag(0x00a1, 0x08)
	set_portal_flag(0x005a, 0x08)
	set_portal_flag(0x005c, 0x08)
	set_portal_flag(0x005d, 0x08)
	set_portal_flag(0x0060, 0x08)
	set_portal_flag(0x0034, 0x08)
	set_portal_flag(0x0030, 0x08)
	set_portal_flag(0x002e, 0x08)
	set_portal_flag(0x002b, 0x08)
	set_portal_flag(0x0028, 0x08)
	set_portal_flag(0x0025, 0x08)
	set_portal_flag(0x0036, 0x08)
	set_portal_flag(0x0038, 0x08)
	set_portal_flag(0x004f, 0x08)
	set_portal_flag(0x0051, 0x08)
	set_portal_flag(0x0052, 0x08)
	set_portal_flag(0x0057, 0x08)
	set_portal_flag(0x0058, 0x08)
	set_portal_flag(0x0031, 0x08)
	set_portal_flag(0x002f, 0x08)
	set_portal_flag(0x0023, 0x08)
	set_portal_flag(0x00a6, 0x08)
	set_portal_flag(0x00a3, 0x08)
	set_portal_flag(0x00a2, 0x08)
	set_portal_flag(0x00a4, 0x08)
	set_portal_flag(0x0087, 0x08)
	set_portal_flag(0x00b9, 0x08)
	set_portal_flag(0x00b4, 0x08)
	set_portal_flag(0x00b2, 0x08)
	set_portal_flag(0x00b3, 0x08)
	set_portal_flag(0x00bd, 0x08)
	set_portal_flag(0x00f4, 0x08)
	set_portal_flag(0x00f2, 0x08)
	set_portal_flag(0x00f0, 0x08)
	set_portal_flag(0x00f8, 0x08)
	set_portal_flag(0x00f1, 0x08)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func141e_setup_lighting[] = {
	yield
	misc_command(0x0000, 0x00, 0x00)
	misc_command(0x0000, 0x01, 0x00)
	misc_command(0x0000, 0x02, 0x01)
	misc_command(0x0000, 0x03, 0x00)
	misc_command(0x0000, 0x04, 0x00)
	misc_command(0x0002, 0x05, 0x01)
	misc_command(0x0002, 0x06, 0x01)
	misc_command(0x0003, 0x05, 0x01)
	misc_command(0x0003, 0x06, 0x01)
	misc_command(0x0004, 0x05, 0x01)
	misc_command(0x0004, 0x06, 0x01)
	misc_command(0x0005, 0x06, 0x01)
	misc_command(0x0006, 0x06, 0x01)
	misc_command(0x0007, 0x06, 0x01)
	misc_command(0x0008, 0x06, 0x01)
	misc_command(0x0009, 0x06, 0x01)
	misc_command(0x000a, 0x06, 0x01)
	misc_command(0x000b, 0x06, 0x01)
	misc_command(0x000c, 0x06, 0x01)
	misc_command(0x000d, 0x06, 0x01)
	misc_command(0x000e, 0x06, 0x01)
	misc_command(0x000f, 0x06, 0x01)
	misc_command(0x0010, 0x06, 0x01)
	misc_command(0x0011, 0x06, 0x01)
	misc_command(0x0012, 0x06, 0x01)
	misc_command(0x0013, 0x06, 0x01)
	misc_command(0x0014, 0x06, 0x01)
	misc_command(0x003a, 0x05, 0x01)
	misc_command(0x00a2, 0x06, 0x01)
	misc_command(0x00a4, 0x06, 0x01)
	misc_command(0x00a5, 0x06, 0x01)
	misc_command(0x00a7, 0x06, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101d_setup_rtracker[] = {
	yield
	set_object_flag3(OBJ_GRENADE, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(OBJ_DRAGON, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

struct ailist ailists[] = {
	{ func0401_drcaroll_following,            0x0401 },
	{ func0402_start_drcaroll,                0x0402 },
	{ func0403_stop_and_idle,                 0x0403 },
	{ func0404_init_drcaroll,                 0x0404 },
	{ func0409_tech_conversation,             0x0409 },
	{ func040a_tech2,                         0x040a },
	{ func040b_init_tech1,                    0x040b },
	{ func040c_init_tech2,                    0x040c },
	{ func040d_cass,                          0x040d },
	{ func040e_noop2,                         0x040e },
	{ func0405_drcaroll_waiting,              0x0405 },
	{ func0411_top_guard_blinded,             0x0411 },
	{ func0412_outro,                         0x0412 },
	{ func0414_init_shock,                    0x0414 },
	{ func0415_init_10hp,                     0x0415 },
	{ func1400_setup_counterop,               0x1400 },
	{ func1001_objectives_failed_msg,         0x1001 },
	{ func1002_check_accessed_foyer_elevator, 0x1002 },
	{ func1003_check_end_level,               0x1003 },
	{ func1004_elevator_unlocking,            0x1004 },
	{ func1005_check_bodyguards_dead,         0x1005 },
	{ func1006_check_hovercopter_destroyed,   0x1006 },
	{ func1007_noop,                          0x1007 },
	{ func1008_trigger_hovercopter_roof,      0x1008 },
	{ func1009_init_top_room,                 0x1009 },
	{ func100a_lightswitch,                   0x100a },
	{ func100b_check_top_lights_on,           0x100b },
	{ func100c_foyer_lights,                  0x100c },
	{ func100d_intro,                         0x100d },
	{ func100e_drcaroll_warnings,             0x100e },
	{ func100f_move_rocket_ammo,              0x100f },
	{ func100c_foyer_lights_timer,            0x1010 },
	{ func040d_cass_necklace,                 0x1011 },
	{ func1012_msg_lockeddown,                0x1012 },
	{ func1013_msg_thatcopter,                0x1013 },
	{ func1014_msg_cantleaveany,              0x1014 },
	{ func1015_msg_jumpshipwaiting,           0x1015 },
	{ func1016_msg_make_foyer_guards_alerted, 0x1016 },
	{ func1017_remove_special_shock,          0x1017 },
	{ func1018_give_magnum,                   0x1018 },
	{ func1419_start_lifts,                   0x1419 },
	{ func101a_set_rocketlauncher_flag,       0x101a },
	{ func101b_lift_door_sounds,              0x101b },
	{ func141c_setup_portals,                 0x141c },
	{ func101d_setup_rtracker,                0x101d },
	{ func141e_setup_lighting,                0x141e },
	{ func101f_unlock_top_door,               0x101f },
	{ func040d_cass_outro,                    0x0407 },
	{ func0406_general_combat,                0x0406 },
	{ func040f_top_guard,                     0x040f },
	{ func0410_init_top_guard,                0x0410 },
	{ func0413_defend_pad,                    0x0413 },
	{ func0408_hovercopter,                   0x0408 },
	{ func100d_intro,                         0x0c00 },
	{ func0412_outro,                         0x0c01 },
	{ NULL, 0 },
};

