//
// Defection
//

#include "stagesetup.h"

// Characters
#define CHR_CASS       0x24
#define CHR_SECRETARY  0x25
#define CHR_PROGRAMMER 0x26

// Objects
#define OBJ_NECKLACE        0x00
#define OBJ_SECURITYHUB     0x03
#define OBJ_EXTCOMMSHUB     0x04
#define OBJ_PC              0x0c
#define OBJ_DOORSWITCH      0x0d
#define OBJ_OFFICEDOOR1     0x0e
#define OBJ_OFFICEDOOR2     0x0f
#define OBJ_LIGHTSWITCH     0x14
#define OBJ_JUMPSHIP1       0x17
#define OBJ_ROPE            0x18
#define OBJ_BANNER1         0x19
#define OBJ_BANNER2         0x1a
#define OBJ_JUMPSHIP2       0x1b
#define OBJ_HOVERTAXI1      0x1c
#define OBJ_HOVERTAXI2      0x1e
#define OBJ_HOVERCOP1       0x1f
#define OBJ_HOVERCOP2       0x20
#define OBJ_HOVERCAR1       0x21
#define OBJ_HOVERCAR2       0x22
#define OBJ_HOVERMOTO1      0x23
#define OBJ_HOVERMOTO2      0x24
#define OBJ_HOVERTRUCK1     0x25
#define OBJ_HOVERTRUCK2     0x26
#define OBJ_HOVERCAB1       0x27
#define OBJ_HOVERCAB2       0x28
#define OBJ_HOVERCOP3       0x29
#define OBJ_HOVERCAR3       0x2a
#define OBJ_HOVERMOTO3      0x2b
#define OBJ_HOVERCAB3       0x2c
#define OBJ_HOVERTRUCK3     0x2d
#define OBJ_LABLIFTDOOR1    0x2e
#define OBJ_LABLIFTDOOR2    0x2f
#define OBJ_POLICECAR       0x30
#define OBJ_ECMMINE_BOND    0x31
#define OBJ_DATAUPLINK_BOND 0x32
#define OBJ_SECRETDOOR      0x33
#define OBJ_ECMMINE_COOP    0x3e
#define OBJ_DATAUPLINK_COOP 0x3f
#define OBJ_LAPTOPGUNDOOR   0x40
#define OBJ_LAPTOPGUN       0x43
#define OBJ_LIFT1           0x4e
#define OBJ_LIFT2           0x4f
#define OBJ_CAMERA1         0x50
#define OBJ_CAMERA2         0x51
#define OBJ_CAMERA3         0x52
#define OBJ_CAMERA4         0x53
#define OBJ_CAMERA5         0x54
#define OBJ_CAMERA6         0x55
#define OBJ_LIFT1DOOR1      0x56
#define OBJ_LIFT1DOOR2      0x57
#define OBJ_LIFT1DOOR3      0x58
#define OBJ_LIFT1DOOR4      0x59
#define OBJ_LIFT2DOOR1      0x5a
#define OBJ_LIFT2DOOR2      0x5b
#define OBJ_LIFT2DOOR3      0x5c
#define OBJ_LIFT2DOOR4      0x5d
#define OBJ_FALCONSIL1      0x61
#define OBJ_FALCONSIL2      0x62
#define OBJ_PCMONITOR       0x63

// Stage flags
#define STAGEFLAG_TALKED_TO_PROGRAMMER     0x00000001
#define STAGEFLAG_SECRETARY_SAW_COOP       0x00000002
#define STAGEFLAG_STOP_INTRO               0x00000004
#define STAGEFLAG_SECURITY_DISABLED        0x00000008
#define STAGEFLAG_TRIGGER_INTRO            0x00000010
#define STAGEFLAG_SECURITYHUB_COMPLETE     0x00000100
#define STAGEFLAG_EXTCOMMSHUB_COMPLETE     0x00000200
#define STAGEFLAG_SECURITYHUB_MINES_WASTED 0x00000400
#define STAGEFLAG_EXTCOMMSHUB_MINES_WASTED 0x00000800
#define STAGEFLAG_LIGHTS_OFF               0x00001000
#define STAGEFLAG_CIVILIANS_KILLED         0x00002000
#define STAGEFLAG_OFFICE_DOOR_UNLOCKED     0x00004000
#define STAGEFLAG_PROGRAMMER_DEAD          0x00010000
#define STAGEFLAG_PROGRAMMER_WALKING       0x00020000
#define STAGEFLAG_DELETED_WITHOUT_DOWNLOAD 0x00040000
#define STAGEFLAG_PROGRAMMER_LOGGED_IN     0x00080000
#define STAGEFLAG_PROGRAMMER_RAN_TO_GUARD  0x00100000
#define STAGEFLAG_PERSONALITY_DELETED      0x00200000
#define STAGEFLAG_PROGRAMMER_INJURED       0x00400000
#define STAGEFLAG_DOWNLOAD_COMPLETE        0x00800000
#define STAGEFLAG_LAB_LIFT_LOCATED         0x02000000
#define STAGEFLAG_PC_DESTROYED             0x04000000
#define STAGEFLAG_SECURITYHUB_DESTROYED    0x08000000
#define STAGEFLAG_EXTCOMMSHUB_DESTROYED    0x10000000
#define STAGEFLAG_DOORSWITCH_DESTROYED     0x20000000
#define STAGEFLAG_SECETARY_SAW_JO_OR_COOP  0x40000000
#define STAGEFLAG_LAB_ELEVATOR_CLOSED      0x80000000

// AI Lists
#define AILIST_INIT_HOVERCAR      0x0404
#define AILIST_CASS               0x040f
#define AILIST_INIT_CASS          0x0410
#define AILIST_SECRETARY          0x0411
#define AILIST_INIT_SECRETARY     0x0412
#define AILIST_PROGRAMMER         0x0414
#define AILIST_OUTRO              0x0416
#define AILIST_INIT_DD_GUARD      0x0417
#define AILIST_INIT_SHOCK_GUARD   0x0418
#define AILIST_INTRO_0419         0x0419
#define AILIST_INTRO_041A         0x041a
#define AILIST_INTRO_041B         0x041b
#define AILIST_INTRO_041C         0x041c
#define AILIST_INTRO_041E         0x041e
#define AILIST_INTRO_041F         0x041f
#define AILIST_INTRO_041D         0x041d
#define AILIST_INTRO_0420         0x0420
#define AILIST_INTRO_0421         0x0421
#define AILIST_INTRO              0x0422
#define AILIST_INTRO_0423         0x0423
#define AILIST_INTRO_0424         0x0424
#define AILIST_INTRO_0425         0x0425
#define AILIST_INTRO_0426         0x0426
#define AILIST_INTRO_0427         0x0427
#define AILIST_INTRO_0428         0x0428
#define AILIST_INTRO_0429         0x0429
#define AILIST_INTRO_042A         0x042a
#define AILIST_INTRO_042B         0x042b
#define AILIST_INTRO_042C         0x042c
#define AILIST_INTRO_042D         0x042d
#define AILIST_SURRENDERING_GUARD 0x042f
#define AILIST_INIT_FALCON_GUARD  0x0430

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x0201)
	briefing(1, 0x0200)
	briefing(2, 0x0202)
	briefing(3, 0x0203)

	beginobjective(0, L_AME(16), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Disable internal security hub"
		complete_flags(STAGEFLAG_SECURITYHUB_COMPLETE)
		fail_flags(STAGEFLAG_SECURITYHUB_MINES_WASTED)
		fail_flags(STAGEFLAG_SECURITYHUB_DESTROYED)
	endobjective

	beginobjective(1, L_AME(17), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Obtain keycode necklace"
		require_object_collected(OBJ_NECKLACE)
		fail_flags(STAGEFLAG_DOORSWITCH_DESTROYED)
		fail_flags(STAGEFLAG_CIVILIANS_KILLED)
	endobjective

	beginobjective(2, L_AME(18), (DIFFBIT_PA | DIFFBIT_PD)) // "Download project files"
		complete_flags(STAGEFLAG_DOWNLOAD_COMPLETE)
		fail_flags(STAGEFLAG_PROGRAMMER_DEAD)
		fail_flags(STAGEFLAG_DELETED_WITHOUT_DOWNLOAD)
		fail_flags(STAGEFLAG_PC_DESTROYED)
	endobjective

	beginobjective(3, L_AME(19), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Disable external comms hub"
		complete_flags(STAGEFLAG_EXTCOMMSHUB_COMPLETE)
		fail_flags(STAGEFLAG_EXTCOMMSHUB_MINES_WASTED)
		fail_flags(STAGEFLAG_EXTCOMMSHUB_DESTROYED)
	endobjective

	beginobjective(4, L_AME(20), DIFFBIT_A) // "Gain entrance to laboratory"
		complete_flags(STAGEFLAG_LAB_LIFT_LOCATED)
		fail_flags(STAGEFLAG_CIVILIANS_KILLED)
	endobjective

	beginobjective(5, L_AME(20), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Gain entrance to laboratory"
		complete_flags(STAGEFLAG_LAB_LIFT_LOCATED)
	endobjective

	tag(0x3d, 1)
	vent_fan(0x0100, MODEL_DD_FANROOF, 0x0095, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_DD_FANROOF, 0x0096, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_DD_FANROOF, 0x0097, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_DD_FANROOF, 0x0098, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_DD_FANWALL, 0x0099, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000222, 0x00000000, 0x00000002, 0x01000000)
	tag(0x2e, 1)
	door(0x0100, MODEL_DOOR4A_G5, 0x022b, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001200, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR4B_G5, 0x022c, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x2f, -1)
	door(0x0100, MODEL_DD_DECODOOR, 0x0226, 0x10000400, 0x080000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000020, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DECODOOR, 0x0226, 0x10000400, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DECODOOR, 0x0227, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0229, 0x04000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000040, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x022a, 0x04000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000040, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x33, 1)
	door(0x0100, MODEL_DD_SECRETDOOR, 0x0228, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x02140000, 0x00000020, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_SECRETDOOR, 0x00bc, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x02140000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a0, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a1, 0x10000400, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000004, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a2, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a3, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a4, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a5, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a6, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a7, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00b2, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00b3, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a8, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00a9, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00aa, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00ab, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00ac, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00ad, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00ae, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00b1, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0e, 2)
	tag(0x0f, 2)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00af, 0x10000000, 0x28000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x00000005, 0x00000001, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x00b0, 0x30000000, 0x30000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x00000005, 0x00000001, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_SERVICEDOOR, 0x00b4, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_SERVICEDOOR, 0x00b5, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_SERVICEDOOR, 0x00b6, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_SERVICEDOOR, 0x00b7, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x000c0000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x40, 1)
	door(0x0100, MODEL_DD_SERVICEDOOR, 0x00bb, 0x10000400, 0x30000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x000c0000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_WINDDOOR, 0x00b8, 0x14000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_WINDDOOR, 0x00b9, 0x34000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_WINDDOOR, 0x00ba, 0x94000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x56, 6)
	tag(0x57, 6)
	tag(0x58, 6)
	tag(0x59, 6)
	tag(0x4e, 1)
	lift(0x0100, MODEL_DD_LIFTR, 0x0256, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0256, 0x012f, 0x012e0130, 0x00000001, 0x00000002, 0x00000003, 0x00000004, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x16000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0224, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x009c, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x009b, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x009a, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-4, -5, 0, 0)
	link_objects(-4, -6, 0, 1)
	link_objects(-4, -7, 0, 2)
	link_objects(-4, -8, 0, 3)
	tag(0x5a, 6)
	tag(0x5b, 6)
	tag(0x5c, 6)
	tag(0x5d, 6)
	tag(0x4f, 1)
	lift(0x0100, MODEL_DD_LIFTR, 0x012d, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x012d, 0x012c, 0x012b0255, 0x00000001, 0x00000002, 0x00000003, 0x00000004, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x16000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x009d, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x009e, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x009f, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LIFTDOOR, 0x0225, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001c00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-4, -5, 0, 0)
	link_objects(-4, -6, 0, 1)
	link_objects(-4, -7, 0, 2)
	link_objects(-4, -8, 0, 3)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00bd, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00be, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00bf, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c0, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c1, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c2, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c3, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c4, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c5, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c6, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c7, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00c8, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00ca, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00cb, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00cc, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00cd, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00ce, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x00cf, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x0235, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x0236, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x0237, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x0238, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x0239, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x023a, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x011b, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x011c, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00df, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e0, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e1, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e2, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e3, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e4, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e5, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e6, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e7, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0123, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0124, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0125, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0126, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0127, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0128, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0129, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x012a, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e8, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00e9, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ea, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00eb, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ec, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ed, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ee, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ef, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f0, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f1, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f2, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f3, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f4, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f5, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f6, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f7, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f8, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00f9, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00fa, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00fb, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00fc, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00fd, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00fe, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x00ff, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0100, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0101, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0102, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0103, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0105, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0106, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0107, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0108, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0109, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010a, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010b, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010c, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010d, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010e, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x010f, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0110, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0111, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0112, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0113, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0114, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0104, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0117, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0118, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0119, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x011a, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x0248, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x0249, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x024a, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x024b, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x024c, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x024d, 0x04000a62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x024e, 0x04000a62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x024f, 0x04000a62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW, 0x0250, 0x04000a62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW_FOYER, 0x0251, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_DD_WINDOW_FOYER, 0x0252, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x00d3, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x00d4, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00d5, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00d2, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x37, 1)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00d7, 0x000205e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00d8, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x38, 1)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00d9, 0x000205e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x00d6, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x00da, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x0253, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x0254, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3b, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01a4, 0x000205e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01a3, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_PC1, 0x01a2, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff23)
	tag(0x3c, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01a5, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01a6, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_PC1, 0x01a7, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff23)
	tag(0x3a, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01a8, 0x000205e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01a9, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_PC1, 0x01aa, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff20)
	tag(0x39, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01ab, 0x000205e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01ac, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_PC1, 0x01ad, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff21)
	tag(0x5e, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01b0, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01af, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_PC1, 0x01ae, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff23)
	stdobject(0x0100, MODEL_DD_DESK, 0x01b1, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01ba, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01bb, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x63, 1)
	singlemonitor(0x0100, MODEL_PC1, 0x01bc, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x0d, 1)
	stdobject(0x0100, MODEL_LIGHTSWITCH2, 0x013e, 0x00000001, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01b3, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01b4, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_PC1, 0x01b5, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff08)
	stdobject(0x0100, MODEL_DD_DESK, 0x01b2, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x0c, 1)
	singlemonitor(0x0100, MODEL_PC1, 0x01b6, 0x000004e1, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x00db, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x36, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01b7, 0x000205e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01b8, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_PC1, 0x01b9, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff20)
	tag(0x35, 1)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00dc, 0x000205e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x00dd, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x022d, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x022e, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0232, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x0231, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_PC1, 0x0230, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff23)
	singlemonitor(0x0100, MODEL_PC1, 0x0233, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff23)
	singlemonitor(0x0100, MODEL_PC1, 0x0234, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	chr(0x00000200, 0x06, 0x0011, BODY_DD_GUARD, HEAD_RANDOM, 0x040a, 0x001d, -1, 1000, 9, 0x80804608, 0x00008080, TEAM_ENEMY, SQUADRON_01, -1, 3, 0x02001400)
	weapon(0x0100, MODEL_CHRCMP150, 0x0006, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x05, 0x01c0, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_DD_GUARD, 0x001e, -1, 1000, 100, 0x88a04608, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x02001400)
	weapon(0x0100, MODEL_CHRCMP150, 0x0005, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x08, 0x0028, BODY_DD_GUARD, HEAD_RANDOM, 0x040b, -1, -1, 500, 100, 0x8808c200, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x02001400)
	weapon(0x0100, MODEL_CHRCMP150, 0x0008, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0d, 0x006f, BODY_DD_GUARD, HEAD_RANDOM, 0x040c, -1, -1, 100, 100, 0x8808c000, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x02001400)
	weapon(0x0100, MODEL_CHRCMP150, 0x000d, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x07, 0x0058, BODY_DD_GUARD, HEAD_RANDOM, 0x0407, -1, -1, 100, 100, 0xc0082000, 0x02000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0007, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0a, 0x0057, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_DD_GUARD, -1, -1, 100, 100, 0xa0882000, 0x02010000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000a, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0c, 0x0060, BODY_DD_GUARD, HEAD_RANDOM, 0x0408, -1, -1, 100, 100, 0xc0082000, 0x02000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x00, 0x007d, BODY_DD_GUARD, HEAD_RANDOM, 0x0405, -1, -1, 100, 100, 0xcc080000, 0x02000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0000, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0b, 0x008e, BODY_DD_GUARD, HEAD_RANDOM, 0x0406, -1, -1, 100, 100, 0xc8080000, 0x02000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x09, 0x0081, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_DD_GUARD, -1, -1, 100, 100, 0xa8880000, 0x02010000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0009, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x01, 0x021a, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK_GUARD, -1, -1, 1000, 9, 0x8008a100, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0001, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x02, 0x021b, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK_GUARD, -1, -1, 1000, 9, 0x8008a100, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0002, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0e, 0x01f6, BODY_DDSHOCK, HEAD_DDSHOCK, 0x040d, -1, -1, 1000, 100, 0x8008a100, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x12, 0x0221, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK_GUARD, -1, -1, 1000, 100, 0x80282300, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0012, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0f, 0x021e, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK_GUARD, -1, -1, 500, 100, 0xa008a000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x10, 0x021f, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK_GUARD, -1, -1, 500, 100, 0xa0082000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0010, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x11, 0x0220, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK_GUARD, -1, -1, 500, 100, 0xa0082000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0011, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x13, 0x0222, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK_GUARD, -1, -1, 500, 100, 0xa0082000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0013, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x03, 0x021c, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK_GUARD, -1, -1, 1000, 100, 0x80002100, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0003, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x04, 0x021d, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK_GUARD, -1, -1, 1000, 100, 0x80002100, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0004, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x14, 0x020f, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK_GUARD, -1, -1, 500, 100, 0xa0002000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0014, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x15, 0x020e, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK_GUARD, -1, -1, 500, 100, 0xa0002000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0015, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x16, 0x0210, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK_GUARD, -1, -1, 500, 100, 0xa0002000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0016, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004200, 0x17, 0x01c6, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_DD_GUARD, -1, -1, 2000, 100, 0xc0002400, 0x00000100, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00010000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0017, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004000, 0x18, 0x01c7, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_DD_GUARD, -1, -1, 1000, 100, 0xc0002000, 0x00000100, TEAM_ENEMY, SQUADRON_0A, 0x35, 0, 0x00030000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0018, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004000, 0x19, 0x01c8, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_DD_GUARD, -1, -1, 1000, 100, 0xc0002400, 0x00000100, TEAM_ENEMY, SQUADRON_0A, 0x36, 0, 0x00020000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0019, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004200, 0x1a, 0x01c9, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_DD_GUARD, -1, -1, 1000, 100, 0xc0002400, 0x00000100, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00010000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004000, 0x1b, 0x01ca, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_DD_GUARD, -1, -1, 1000, 100, 0xc0002000, 0x00000100, TEAM_ENEMY, SQUADRON_0C, 0x37, 0, 0x00030000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001b, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004000, 0x1c, 0x01cb, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_DD_GUARD, -1, -1, 1000, 100, 0xc0002000, 0x00000100, TEAM_ENEMY, SQUADRON_0C, 0x38, 0, 0x00030000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004200, 0x1d, 0x01cc, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_DD_GUARD, -1, -1, 1000, 100, 0xc0002000, 0x00000100, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00010000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001d, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004000, 0x1e, 0x01ce, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_DD_GUARD, -1, -1, 1000, 100, 0xc8000000, 0x00000100, TEAM_ENEMY, SQUADRON_0D, 0x39, 0, 0x00020000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004000, 0x1f, 0x01cf, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_DD_GUARD, -1, -1, 1000, 100, 0xc8000000, 0x00000100, TEAM_ENEMY, SQUADRON_0E, 0x3a, 0, 0x00020000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001f, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004000, 0x20, 0x01d0, BODY_DD_GUARD, HEAD_RANDOM, AILIST_INIT_DD_GUARD, -1, -1, 1000, 100, 0xc8080000, 0x00000100, TEAM_ENEMY, SQUADRON_0F, 0x3b, 0, 0x00020000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0020, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)

	chr(0x00004000, 0x21, 0x01d1, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_FALCON_GUARD, -1, -1, 1000, 100, 0xc008a000, 0x00000100, TEAM_ENEMY, SQUADRON_0F, 0x3c, 0, 0x00010000)
	weapon(0x0100, MODEL_CHRFALCON2SIL, 0x0021, 0x00424000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2_SILENCER, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRFALCON2SIL, 0x0021, 0x10424000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2_SILENCER, 0x00ffffff, 0x00000000)
	link_collectibles(-1, -2)
	tag(0x61, -3)
	tag(0x62, -3)

	chr(0x00010400, CHR_CASS, 0x01c2, BODY_CASSANDRA, HEAD_CASSANDRA, AILIST_INIT_CASS, -1, -1, 1000, 100, 0x0000c400, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	chr(0x00010400, CHR_SECRETARY, 0x01c3, BODY_NEGOTIATOR, HEAD_SECRETARY, GAILIST_IDLE, -1, -1, 1000, 100, 0x0000c400, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	chr(0x00010480, CHR_PROGRAMMER, 0x007a, BODY_OFFICEWORKER, HEAD_RANDOM, AILIST_PROGRAMMER, -1, -1, 50, 100, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	tag(0x1f, 1)
	hovercar(0x004c, MODEL_DD_HOVCOP, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x20, 1)
	hovercar(0x004c, MODEL_DD_HOVCOP, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x21, 1)
	hovercar(0x004c, MODEL_DD_HOVCAR, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x22, 1)
	hovercar(0x004c, MODEL_DD_HOVCAR, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x23, 1)
	hovercar(0x004c, MODEL_DD_HOVMOTO, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x24, 1)
	hovercar(0x004c, MODEL_DD_HOVMOTO, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x25, 1)
	hovercar(0x004c, MODEL_DD_HOVTRUCK, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x26, 1)
	hovercar(0x004c, MODEL_DD_HOVTRUCK, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x27, 1)
	hovercar(0x004c, MODEL_DD_HOVCAB, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x28, 1)
	hovercar(0x004c, MODEL_DD_HOVCAB, 0x0144, 0x20000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, AILIST_INIT_HOVERCAR, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	link_scenery(1, 0, 2)
	door(0x0100, MODEL_DD_AC_UNEXP, 0x019f, 0x13500d00, 0x20304300, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00010000, 0x03e80000, 0x03e80000, 0x00010000, 0x00000000, 0x00000080, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_DD_AC_EXP, 0x01a1, 0x031204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 2)
	door(0x0100, MODEL_DD_ACBOT_UNEXP, 0x019e, 0x13500d00, 0x20304300, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00010000, 0x03e80000, 0x03e80000, 0x00010000, 0x00000000, 0x00000080, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_DD_ACBOT_EXP, 0x01a0, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0140, 0x00020101, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0141, 0x00020101, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0142, 0x00020101, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0143, 0x00020101, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)

	tag(0x31, 1)
	weapon(0x0180, MODEL_CHRECMMINE, 0xffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_ECMMINE, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x0035, L_AME(58), L_AME(59), L_AME(60), L_AME(61), L_AME(62), 0x0000, 0x0000) // "Obtain ECM Mines."

	tag(0x32, 1)
	weapon(0x0180, MODEL_CHRDATATHIEF, 0xffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DATAUPLINK, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x0036, L_AME(63), L_AME(64), L_AME(65), L_AME(66), L_AME(67), 0x0000, 0x0000) // "Obtain Data Uplink."

	tag(0x3e, 1)
	weapon(0x0180, MODEL_CHRECMMINE, 0xffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_ECMMINE, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x0035, L_AME(58), L_AME(59), L_AME(60), L_AME(61), L_AME(62), 0x0000, 0x0000) // "Obtain ECM Mines."

	tag(0x3f, 1)
	weapon(0x0180, MODEL_CHRDATATHIEF, 0xffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DATAUPLINK, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x0036, L_AME(63), L_AME(64), L_AME(65), L_AME(66), L_AME(67), 0x0000, 0x0000) // "Obtain Data Uplink."

	tag(0x00, 1)
	key(0x0100, MODEL_CHRCHAIN, CHR_CASS, 0x01244000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000020)
	rename_object(-1, 0x0050, L_AME(11), L_AME(12), L_AME(13), L_AME(14), L_AME(15), 0x0000, 0x0000) // "Obtain De Vries' necklace."

	stdobject(0x0100, MODEL_DD_STONEDESK, 0x0134, 0x000205e1, 0x00204000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_PC1, 0x0132, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff21)
	tag(0x50, 6)
	tag(0x51, 6)
	tag(0x52, 6)
	tag(0x53, 6)
	tag(0x54, 6)
	tag(0x55, 6)
	camera(0x00c0, MODEL_CCTV_PD, 0x0136, 0x00000002, 0x00000030, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x00110000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000238e, 0x00000000, 0x00000000, 0x0000001e, 0x00000000, 0x000002bc, 0x00000000)
	camera(0x00c0, MODEL_CCTV_PD, 0x0137, 0x00000002, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x00140000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00004000, 0x00000000, 0x00000000, 0x0000001e, 0x00000000, 0x000002bc, 0x00000000)
	camera(0x00c0, MODEL_CCTV_PD, 0x0138, 0x00000002, 0x00000030, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x00190000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000031c7, 0x00000000, 0x00000000, 0x0000001e, 0x00000000, 0x000002bc, 0x00000000)
	camera(0x00c0, MODEL_CCTV_PD, 0x0139, 0x00000002, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x001d0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001555, 0x00000000, 0x00000000, 0x0000001e, 0x00000000, 0x000003e8, 0x00000000)
	camera(0x00c0, MODEL_CCTV_PD, 0x013a, 0x00000002, 0x00000030, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x00670000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x00000000, 0x00000000, 0x0000001e, 0x00000000, 0x000002bc, 0x00000000)
	camera(0x00c0, MODEL_CCTV_PD, 0x013b, 0x00000002, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000190, 0x00000000, 0x00000000, 0x0fff0000, 0x00780000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00004000, 0x00000000, 0x00000000, 0x0000001e, 0x00000000, 0x000002bc, 0x00000000)
	camera2(0x0000, 0xfffd05c6, 0xfff25662, 0x000013f6, 0x005a0000, 0x00063f8f, 0x00000219)
	tag(0x09, -1)
	camera2(0x0000, 0xffff51d2, 0xfffd0422, 0x00000c58, 0x00060000, 0x0005f5c2, 0x00000219)
	tag(0x15, -1)
	camera2(0x0000, 0xffff67da, 0xfffd8eec, 0xfffe7c44, 0x0004a147, 0x0005f851, 0x00000219)
	tag(0x16, -1)
	tag(0x04, 1)
	multimonitor(0x0099, MODEL_COMHUB, 0x025c, 0x00000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(0x03, 1)
	multimonitor(0x0099, MODEL_COMHUB, 0x013c, 0x00000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(0x14, 1)
	stdobject(0x0100, MODEL_LIGHTSWITCH, 0x013d, 0x10000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x10, 1)
	multimonitor(0x0099, MODEL_PD_CONSOLE, 0x0258, 0x000001a1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08030000)
	tag(0x11, 1)
	multimonitor(0x0099, MODEL_PD_CONSOLE, 0x0259, 0x000001a1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03220000)
	tag(0x12, 1)
	multimonitor(0x0099, MODEL_PD_CONSOLE, 0x025a, 0x000001a1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x23030000)
	tag(0x13, 1)
	multimonitor(0x0099, MODEL_PD_CONSOLE, 0x025b, 0x000001a1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03210000)
	tag(0x19, 2)
	tag(0x1a, 2)
	stdobject(0x0100, MODEL_DD_BANNER, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_BANNER, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x17, 1)
	stdobject(0x0100, MODEL_DDJUMPSHIP, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1b, 1)
	stdobject(0x0024, MODEL_DDJUMPSHIP, 0xffff, 0x00020001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x18, 1)
	stdobject(0x0100, MODEL_ROPE, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1c, 1)
	stdobject(0x0051, MODEL_TAXICAB, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1e, 1)
	stdobject(0x0024, MODEL_TAXICAB, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1d, 1)
	stdobject(0x0051, MODEL_POLICECAR, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x30, 1)
	stdobject(0x0024, MODEL_POLICECAR, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x29, 1)
	stdobject(0x0019, MODEL_DD_HOVCOP, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2a, 1)
	stdobject(0x0019, MODEL_DD_HOVCAR, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2b, 1)
	stdobject(0x0019, MODEL_DD_HOVMOTO, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2c, 1)
	stdobject(0x0019, MODEL_DD_HOVCAB, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2d, 1)
	stdobject(0x0019, MODEL_DD_HOVTRUCK, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x00de, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0121, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0122, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x011f, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0120, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tag(0x41, 1)
#if VERSION >= VERSION_JAP_FINAL
	// ........................................................ v
	shield(0x0100, MODEL_CHRSHIELD, 0x000a, 0x00004001, 0x00000080, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
#else
	shield(0x0100, MODEL_CHRSHIELD, 0x000a, 0x00004001, 0x000000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
#endif
	tag(0x42, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x025f, 0x00000001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x43, 1)
	weapon(0x0100, MODEL_CHRPCGUN, 0x01d2, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_LAPTOPGUN, 0x00ffffff, 0x00000000)
	tag(0x44, 1)
	weapon(0x0100, MODEL_CHRFALCON2, 0x01d5, 0x00400008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2_SILENCER, 0x00ffffff, 0x00000000)
	tag(0x45, 1)
	weapon(0x0100, MODEL_CHRFALCON2, 0x01d4, 0x00400008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2_SILENCER, 0x00ffffff, 0x00000000)
	tag(0x46, 1)
	ammocrate(0x0019, MODEL_MULTI_AMMO_CRATE, 0x01d6, 0x004000e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_PISTOL)
	tag(0x47, 1)
	ammocrate(0x0019, MODEL_MULTI_AMMO_CRATE, 0x01d7, 0x00400001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_PISTOL)
	tag(0x48, 1)
	ammocrate(0x0019, MODEL_MULTI_AMMO_CRATE, 0x01d8, 0x00400001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_PISTOL)
	tag(0x49, 1)
	ammocrate(0x0019, MODEL_MULTI_AMMO_CRATE, 0x01d9, 0x00400001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_PISTOL)
	tag(0x4a, 1)
	ammocrate(0x0100, MODEL_CHRFALCON2, 0x01da, 0x00400001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_PISTOL)
	tag(0x4a, 1)
	ammocrate(0x0100, MODEL_CHRFALCON2, 0x01da, 0x00400001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_PISTOL)
	tag(0x4b, 1)
	ammocrate(0x0019, MODEL_MULTI_AMMO_CRATE, 0x01db, 0x00400001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_PISTOL)
	tag(0x4c, 1)
	weapon(0x0100, MODEL_CHRCMP150, 0x025d, 0x00400008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	tag(0x4d, 1)
	weapon(0x0100, MODEL_CHRCMP150, 0x025e, 0x00400008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	endprops
};

s32 intro[] = {
	intro_weapon(WEAPON_FALCON2_SILENCER, -1)
	ammo(AMMOTYPE_PISTOL, 80)
	ammo(AMMOTYPE_ECM_MINE, 2)
	outfit(OUTFIT_DEFAULT)
	spawn(0x01d3)
	endintro
};

s32 path00[] = {
	0x0144,
	0x0145,
	-1,
};

s32 path01[] = {
	0x0146,
	0x0147,
	0x0148,
	-1,
};

s32 path02[] = {
	0x0149,
	0x014a,
	0x014b,
	0x014c,
	0x014d,
	0x014e,
	-1,
};

s32 path03[] = {
	0x0152,
	0x0151,
	0x0150,
	0x014f,
	-1,
};

s32 path04[] = {
	0x0154,
	0x0157,
	0x0156,
	0x0153,
	0x0155,
	-1,
};

s32 path05[] = {
	0x0159,
	0x015a,
	0x015d,
	0x015b,
	0x015c,
	0x0158,
	-1,
};

s32 path06[] = {
	0x015e,
	0x015f,
	0x0160,
	0x0161,
	0x0162,
	0x0163,
	-1,
};

s32 path07[] = {
	0x0167,
	0x0166,
	0x0165,
	0x0168,
	0x0169,
	0x0164,
	-1,
};

s32 path08[] = {
	0x016a,
	0x016b,
	0x016c,
	0x016d,
	-1,
};

s32 path09[] = {
	0x016e,
	0x016f,
	0x0170,
	0x0171,
	0x0172,
	0x0173,
	-1,
};

s32 path10[] = {
	0x0174,
	0x0175,
	0x0176,
	0x0177,
	-1,
};

s32 path11[] = {
	0x0178,
	0x0179,
	0x017a,
	0x017b,
	0x017c,
	0x017d,
	0x017e,
	0x017f,
	-1,
};

s32 path12[] = {
	0x0180,
	0x0181,
	0x0182,
	-1,
};

s32 path13[] = {
	0x0183,
	0x0184,
	0x0185,
	-1,
};

s32 path14[] = {
	0x0186,
	0x0191,
	-1,
};

s32 path15[] = {
	0x0187,
	0x0190,
	-1,
};

s32 path16[] = {
	0x0188,
	0x018f,
	-1,
};

s32 path17[] = {
	0x0189,
	0x018e,
	-1,
};

s32 path18[] = {
	0x018c,
	0x018b,
	-1,
};

s32 path19[] = {
	0x018d,
	0x018a,
	-1,
};

s32 path20[] = {
	0x0192,
	0x019d,
	-1,
};

s32 path21[] = {
	0x0193,
	0x019c,
	-1,
};

s32 path22[] = {
	0x0194,
	0x019b,
	-1,
};

s32 path23[] = {
	0x0195,
	0x019a,
	-1,
};

s32 path24[] = {
	0x0197,
	0x0198,
	-1,
};

s32 path25[] = {
	0x0196,
	0x0199,
	-1,
};

s32 path26[] = {
	0x007d,
	0x007c,
	0x0077,
	0x0076,
	0x008d,
	0x008c,
	0x008b,
	0x0088,
	0x008b,
	0x008c,
	-1,
};

s32 path27[] = {
	0x008e,
	0x008d,
	0x008c,
	0x008b,
	0x0088,
	-1,
};

s32 path30[] = {
	0x000c,
	0x000b,
	0x000f,
	0x0010,
	0x0013,
	0x0011,
	0x0012,
	0x0011,
	0x0010,
	0x000f,
	0x000b,
	-1,
};

s32 path32[] = {
	0x0028,
	0x0029,
	0x002f,
	0x0030,
	0x002b,
	0x002a,
	0x002d,
	0x002c,
	0x002e,
	0x0031,
	0x0032,
	0x003b,
	0x003a,
	0x0039,
	-1,
};

s32 path33[] = {
	0x0032,
	0x003b,
	0x003a,
	0x0039,
	0x0074,
	0x006e,
	0x006d,
	0x0072,
	0x0073,
	0x0070,
	0x0071,
	0x006f,
	-1,
};

s32 path34[] = {
	0x01f6,
	0x01f5,
	0x01f4,
	0x01f3,
	0x01f2,
	0x01f0,
	0x01ef,
	0x01ee,
	0x01ec,
	0x01e8,
	0x01e6,
	0x01e5,
	0x01dd,
	0x01e4,
	0x01e3,
	0x01e2,
	0x01e1,
	-1,
};

s32 path35[] = {
	0x007c,
	0x0078,
	0x0077,
	0x0076,
	0x008e,
	0x008d,
	0x008c,
	0x008b,
	0x008a,
	0x0089,
	0x0088,
	0x0090,
	0x0075,
	0x006f,
	0x0071,
	0x0070,
	0x0073,
	0x0066,
	0x0058,
	0x0059,
	0x005a,
	0x0067,
	0x0068,
	0x005b,
	0x005c,
	0x005d,
	0x005e,
	0x0061,
	-1,
};

s32 path31[] = {
	0x0011,
	0x0013,
	0x0014,
	0x0015,
	0x0016,
	0x0017,
	-1,
};

s32 path28[] = {
	0x0058,
	0x0067,
	0x0068,
	0x005b,
	0x005d,
	-1,
};

s32 path29[] = {
	0x0060,
	0x005f,
	0x0056,
	0x0055,
	0x0051,
	0x0052,
	0x0053,
	-1,
};

/**
 * @unused
 */
u8 func0401_do_some_animation[] = {
	// Do some animation
	restart_timer
	chr_do_animation(0x0066, 0, 1, 0x04, 0x10, CHR_SELF, 2)

	beginloop(0x08)
		if_timer_gt(0, /*goto*/ 0x2c)
	endloop(0x08)

	label(0x2c)
	chr_do_animation(0x0066, 1, -1, 0x04, 0x10, CHR_SELF, 2)

	beginloop(0x85)
	endloop(0x85)

	// Unreachable
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * @unregistered
 */
u8 unregistered_function[] = {
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * @unused
 */
u8 func0402_guard_with_chrflag[] = {
	set_returnlist(CHR_SELF, 0x0402)
	set_self_chrflag(CHRCFLAG_00000200)
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0001)
	endlist
};

/**
 * @unused
 */
u8 func0403_shielded_guard[] = {
	set_shield(200)
	set_self_chrflag(CHRCFLAG_00000200)
	set_ailist(CHR_SELF, GAILIST_CHOOSE_TARGET)
	endlist
};

u8 func0404_init_hovercar[] = {
	dprint 'h','o','v','\n',0,
	begin_hovercar_path(0)
	set_vehicle_speed(0x0c00, 120)

	beginloop(0x04)
		reloop(0x04)

		// Unreachable
		label(0x08)
		set_vehicle_speed(0x0600, 120)
		reloop(0x04)

		label(0x09)
		set_vehicle_speed(0x0700, 120)
		reloop(0x04)

		label(0x0a)
		set_vehicle_speed(0x0800, 120)
		reloop(0x04)

		label(0x0b)
		set_vehicle_speed(0x0900, 120)
		reloop(0x04)

		label(0x0c)
		set_vehicle_speed(0x0a00, 120)
		reloop(0x04)

		label(0x0d)
		set_vehicle_speed(0x0b00, 120)
		reloop(0x04)

		label(0x0e)
		set_vehicle_speed(0x0d00, 120)
	endloop(0x04)

	endlist
};

#define do_path(path) \
	assign_path(path) \
	start_path \
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004) \
	endlist \
};



u8 func0405_start_path26[] = {
	do_path(26)

u8 func0406_start_path27[] = {
	do_path(27)

u8 func0407_start_path28[] = {
	do_path(28)

u8 func0408_start_path29[] = {
	do_path(29)

u8 func0409_start_path30[] = {
	do_path(30)

u8 func040a_start_path31[] = {
	set_chr_dodge_rating(2, 0x14)
	set_unarmeddodgerating(0)
	set_accuracy(0)
	set_reaction_speed(0)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_returnlist(CHR_SELF, 0x040a)
	assign_path(31)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func040b_start_path32[] = {
	set_chr_dodge_rating(2, 0x14)
	set_unarmeddodgerating(0)
	set_accuracy(0)
	set_reaction_speed(0)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	assign_path(32)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func040c_start_path33[] = {
	set_chr_dodge_rating(2, 0x14)
	set_unarmeddodgerating(0)
	set_accuracy(0)
	set_reaction_speed(0)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	assign_path(33)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func040d_start_path34[] = {
	set_chr_dodge_rating(2, 0x14)
	set_unarmeddodgerating(0)
	set_accuracy(10)
	set_reaction_speed(0)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	assign_path(34)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func040e_start_path35[] = {
	assign_path(35)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func0410_init_cass[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_CASS)
	endlist
};

u8 func040f_cass[] = {
	set_shotlist(GAILIST_IDLE)
	if_chr_dying(CHR_CASS, /*goto*/ 0x06)
	if_chr_unloaded(CHR_CASS, /*goto*/ 0x06)
	goto_next(0x2c)

	// Dying
	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2c)
	chr_do_animation(ANIM_TALKING_00A0, 0, 193, 0x18, 0x10, CHR_SELF, 2)

	// Wait for player to enter room
	beginloop(0x59)
		set_target_chr(CHR_BOND)
		if_chr_sees_player(/*goto*/ 0x5a)
		set_target_chr(CHR_COOP)
		if_chr_sees_player(/*goto*/ 0x5a)
		set_target_chr(CHR_BOND)
		if_stage_flag_eq(STAGEFLAG_SECETARY_SAW_JO_OR_COOP, TRUE, /*goto*/ 0xbe)
	endloop(0x59)

	label(0xbe)
	if_stage_flag_eq(STAGEFLAG_SECRETARY_SAW_COOP, TRUE, /*goto*/ 0xbf)
	set_target_chr(CHR_BOND)
	goto_next(0x5a)

	label(0xbf)
	set_target_chr(CHR_COOP)
	goto_next(0x5a)

	// Face target chr (Jo or Velvet)
	label(0x5a)
	stop_chr
	yield
	unset_stage_flag(STAGEFLAG_SECETARY_SAW_JO_OR_COOP)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x5b)

	beginloop(0x5b)
		if_chr_stopped(/*goto*/ 0x5c)
	endloop(0x5b)

	label(0x5c)
	speak(CHR_TARGET, L_AME(21), 0x0af4, CHANNEL_6, COLOR_04_ORANGE) // "Who are you and what are you doing here?"
	restart_timer
	chr_do_animation(ANIM_TALKING_0098, 0, 193, 0x18, 0x10, CHR_SELF, 2)

	beginloop(0x5d)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x5e)
	endloop(0x5d)

	// Walk backwards for 4 seconds
	label(0x5e)
	stop_chr
	chr_do_animation(ANIM_WALK_BACKWARDS, -1, -1, 0x10, 0x10, CHR_SELF, 2)
	restart_timer

	beginloop(0x5f)
		if_timer_gt(240, /*goto*/ 0x06)
	endloop(0x5f)

	label(0x06)
	stop_chr

	// Face target again
	label(0x06)
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x64)

	beginloop(0x64)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x65)
		if_timer_gt(90, /*goto*/ 0x65)
	endloop(0x64)

	label(0x65)
	restart_timer
	if_chr_sees_player(/*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x005b, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x005c, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x005d, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x005e, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x005f, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x0060, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x0061, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x0062, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x0064, /*goto*/ 0x2c)
	goto_next(0x66)

	label(0x2c)
	speak(CHR_TARGET, L_AME(23), 0x0af5, CHANNEL_6, COLOR_04_ORANGE) // "You won't shoot me, foolish child!"
	chr_do_animation(ANIM_TALKING_00A0, 0, 193, 0x18, 0x10, CHR_SELF, 2)

	beginloop(0x66)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x67)
	endloop(0x66)

	label(0x67)
	if_chr_sees_player(/*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x005b, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x005c, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x005d, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x005e, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x005f, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x0060, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x0061, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x0062, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x0064, /*goto*/ 0x2c)
	goto_next(0x68)

	label(0x2c)
	chr_do_animation(ANIM_TALKING_00A3, 0, 193, 0x18, 0x10, CHR_SELF, 2)
	speak(CHR_TARGET, L_AME(24), 0x0af6, CHANNEL_6, COLOR_04_ORANGE) // "Don't you know who I am?"

	beginloop(0x68)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x69)
	endloop(0x68)

	label(0x69)
	walk_to_pad(0x004d)

	beginloop(0x60)
		if_chr_distance_to_pad_lt(CHR_SELF, 70, 0x004d, /*goto*/ 0x06)
	endloop(0x60)

	label(0x06)
	walk_to_pad(0x004e)

	beginloop(0x61)
		if_chr_distance_to_pad_lt(CHR_SELF, 70, 0x004e, /*goto*/ 0x06)
	endloop(0x61)

	label(0x06)
	walk_to_pad(0x0041)

	beginloop(0x62)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x62)

	label(0x06)
	restart_timer
	try_face_entity(0x0008, 0x0042, /*goto*/ 0xb8)

	beginloop(0xb8)
		if_timer_gt(60, /*goto*/ 0x63)
	endloop(0xb8)

	label(0x63)
	if_chr_sees_player(/*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x005b, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x005c, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x005d, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x005e, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x005f, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x0060, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x0061, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x0062, /*goto*/ 0x2c)
	if_chr_in_room(CHR_TARGET, 0x00, 0x0064, /*goto*/ 0x2c)
	goto_next(0x06)

	label(0x2c)
	speak(CHR_TARGET, L_AME(25), 0x0af7, CHANNEL_6, COLOR_04_ORANGE) // "Let's see how you deal with security."
	label(0x06)
	chr_do_animation(ANIM_PUSH_BUTTON, 0, 193, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x6a)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x6a)

	label(0x06)
	activate_alarm

	label(0x6b)
		stop_chr
		yield
		try_face_entity(0x0200, 0x0000, /*goto*/ 0x6c)

		beginloop(0x6c)
			call_rng
			if_rand_lt(250, /*goto*/ 0x06)
			stop_chr
			try_face_entity(0x0200, 0x0000, /*goto*/ 0x2c)
			label(0x2c)
			call_rng
			if_distance_to_target_gt(500, /*goto*/ 0x06)
			if_chr_in_view(/*goto*/ 0x6d)
			label(0x06)
		endloop(0x6c)

		label(0x6d)
		restart_timer
		say_quip(CHR_TARGET, 0x00, 0xff, 0x00, 0xff, BANK_1, 0x01, 0x04) // "How dare you disturb me","You will regret this intrusion girl","If I were you I'd leave, now"
		chr_do_animation(ANIM_TALKING_00A3, 0, 193, 0x18, 0x10, CHR_SELF, 2)

		beginloop(0x6e)
			if_timer_gt(100, /*goto*/ 0x6f)
		endloop(0x6e)

		label(0x6f)
		restart_timer

		beginloop(0x70)
			if_timer_gt(300, /*goto*/ 0x71)
		endloop(0x70)

		label(0x71)
	goto_first(0x6b)

	endlist
};

u8 func0412_init_secretary[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_SECRETARY)
	endlist
};

u8 func0411_secretary[] = {
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x06)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	set_chr_hiddenflag(CHR_SECRETARY, CHRHFLAG_00100000)
	chr_move_to_pad(CHR_SECRETARY, 0x01c3, 0x00, /*goto*/ 0x2c)
	dprint 'D','E','T','E','C','T',' ','4',0,
	label(0x2c)
	stop_chr
	label(0x06)
	set_shotlist(GAILIST_IDLE)
	if_chr_dying(CHR_SECRETARY, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SECRETARY, /*goto*/ 0x06)
	goto_next(0x2c)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2c)
	chr_do_animation(0x00a1, 0, 193, 0x18, 0x10, CHR_SELF, 2)

	beginloop(0x72)
		set_target_chr(CHR_BOND)
		if_chr_sees_player(/*goto*/ 0x73)
		set_target_chr(CHR_COOP)
		if_chr_sees_player(/*goto*/ 0x74)
		set_target_chr(CHR_BOND)
	endloop(0x72)

	label(0x74)
	set_stage_flag(STAGEFLAG_SECRETARY_SAW_COOP)
	label(0x73)
	stop_chr
	restart_timer
	set_stage_flag(STAGEFLAG_SECETARY_SAW_JO_OR_COOP)

	beginloop(0x7a)
		if_timer_gt(20, /*goto*/ 0x7b)
	endloop(0x7a)

	label(0x7b)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x7c)

	beginloop(0x7c)
		if_timer_lt(80, /*goto*/ 0x2c)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x7d)
		label(0x2c)
	endloop(0x7c)

	label(0x7d)
	restart_timer
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x2c)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x2c)
	speak(CHR_TARGET, L_AME(22), 0x1aed, CHANNEL_5, COLOR_07_RED) // "Look out! She's got a gun."
	label(0x2c)
	chr_do_animation(ANIM_SURRENDER_002E, 0, 193, 0x18, 0x10, CHR_SELF, 2)

	beginloop(0x75)
		if_timer_gt(60, /*goto*/ 0x76)
	endloop(0x75)

	label(0x76)
	set_action(MA_PANIC, FALSE)
	jog_to_pad(0x0047)

	beginloop(0x77)
		if_chr_stopped(/*goto*/ 0x78)
	endloop(0x77)

	label(0x78)
		chr_do_animation(ANIM_COWER_01F5, -1, -1, 0x50, 0x14, CHR_SELF, 2)

		beginloop(0x79)
			if_distance_to_target_gt(500, /*goto*/ 0x06)
			if_chr_in_view(/*goto*/ 0x7e)
			label(0x06)
		endloop(0x79)

		label(0x7e)
		restart_timer
		chr_do_animation(ANIM_COWER_01F5, -1, -1, 0x10, 0x0a, CHR_SELF, 2)
		yield
		goto_next(0x81)

		// Unreachable
		try_face_entity(0x0200, 0x0000, /*goto*/ 0x7f)

		beginloop(0x7f)
			if_jo_ccw_direction_lt(10, /*goto*/ 0x81)
			if_timer_gt(120, /*goto*/ 0x81)
		endloop(0x7f)

		label(0x81)
		restart_timer
		say_quip(CHR_TARGET, 0x01, 0xff, 0x00, 0xff, BANK_1, 0x02, 0x07) // "Please don't kill me","Don't shoot!"
		chr_do_animation(ANIM_SURRENDER_002E, 0, -1, 0x18, 0x10, CHR_SELF, 2)

		beginloop(0x82)
			if_timer_gt(180, /*goto*/ 0x83)
		endloop(0x82)

		label(0x83)
		chr_do_animation(ANIM_COWER_0229, -1, -1, 0x10, 0x14, CHR_SELF, 2)

		beginloop(0x84)
			call_rng
			if_rand_gt(254, /*goto*/ 0x06)
		endloop(0x84)

		label(0x06)
	goto_first(0x78)

	endlist
};

u8 func0414_programmer[] = {
#define LABEL_JO_SPEAK            0x9c
#define LABEL_RUN_TO_GUARD        0xa5
#define LABEL_NEAR_LAPTOPGUN_ROOM 0xa8
#define LABEL_LOG_ON              0xaa
#define LABEL_PC_BROKEN           0xc5

	// PA only
	if_difficulty_gt(DIFF_SA, /*goto*/ 0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2c)
	set_reaction_speed(100)
	set_shotlist(AILIST_PROGRAMMER)
	set_chr_chrflag(CHR_PROGRAMMER, CHRCFLAG_00000080)
	if_chr_dying(CHR_SELF, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x2c)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2c)
	if_num_times_shot_lt(1, /*goto*/ 0x06)
	set_stage_flag(STAGEFLAG_PROGRAMMER_INJURED)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x2c)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x2c)
	if_sound_finished(CHANNEL_3, /*goto*/ 0x90)
	goto_next(0x2c)

	label(0x90)
	speak(CHR_TARGET, L_AME(53), 0x12fe, CHANNEL_3, COLOR_03_RED) // "Don't shoot, don't shoot!"
	label(0x2c)
	restart_timer

	beginloop(0xab)
		if_chr_stopped(/*goto*/ LABEL_JO_SPEAK)
	endloop(0xab)

	// Hasn't been shot
	label(0x06)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	stop_chr

	// Wait until Jo or Velvet near his office
	beginloop(0x91)
		set_target_chr(CHR_BOND)
		if_chr_same_floor_distance_to_pad_lt(CHR_TARGET, 0x0050, 1240, /*goto*/ 0x06)
		set_target_chr(CHR_COOP)
		if_chr_same_floor_distance_to_pad_lt(CHR_TARGET, 0x0050, 1240, /*goto*/ 0x06)
	endloop(0x91)

	// Phone ringing
	label(0x06)
	play_sound_from_object2(CHANNEL_4, OBJ_PCMONITOR, 0x8109, 0x0f, 0x02)

	// Wait until Jo or Velvet is close to his door
	beginloop(0x92)
		set_target_chr(CHR_BOND)
		if_chr_same_floor_distance_to_pad_lt(CHR_TARGET, 0x0014, 1240, /*goto*/ 0x06)
		set_target_chr(CHR_COOP)
		if_chr_same_floor_distance_to_pad_lt(CHR_TARGET, 0x0014, 1240, /*goto*/ 0x06)
	endloop(0x92)

	label(0x06)
	restart_timer

	beginloop(0x8e)
		if_timer_gt(40, /*goto*/ 0x2c)
	endloop(0x8e)

	label(0x2c)
	mute_channel(CHANNEL_4) // stop ringing
	restart_timer

	beginloop(0x8f)
		if_timer_gt(90, /*goto*/ 0x2c)
	endloop(0x8f)

	// The timer in the following is dialogue is used to measure the gap between
	// speaks.
	label(0x2c)
	restart_timer
	speak(CHR_TARGET, L_AME(68), 0x8104, CHANNEL_3, COLOR_03_RED) // "Yes, yes, I agree. Personality is expendable in th..."
	restart_timer
	chr_do_animation(ANIM_TALKING_00A0, 0, 193, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x08)
		pause_timer
		if_sound_finished(CHANNEL_3, /*goto*/ 0x06)
		reloop(0x08)

		label(0x06)
		resume_timer
		if_timer_gt(30, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	yield
	yield
	yield
	speak(CHR_TARGET, L_AME(69), 0x8105, CHANNEL_3, COLOR_03_RED) // "No, I can start the process from my office termina..."
	restart_timer

	beginloop(0x0e)
		pause_timer
		if_sound_finished(CHANNEL_3, /*goto*/ 0x06)
		reloop(0x0e)

		label(0x06)
		resume_timer
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x0e)

	label(0x06)
	speak(CHR_TARGET, L_AME(70), 0x8106, CHANNEL_3, COLOR_03_RED) // "I'll begin at once. Goodbye."

	beginloop(0x0f)
		if_sound_finished(CHANNEL_3, /*goto*/ 0x06)
	endloop(0x0f)

	label(0x06)
	stop_chr
	walk_to_pad(0x0062)
	restart_timer

	beginloop(0x09)
		if_timer_gt(30, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	set_stage_flag(STAGEFLAG_PROGRAMMER_WALKING)
	label(0x06)

	label(0x99)
		walk_to_pad(0x0062)

		// While walking, check for anything that might cause him to detect Jo.

		// @bug The condition to jump to log on should be a distance check rather
		// than chr stopped. If the programmer's pathing has failed then he will
		// have stopped without being near the PC. This bug is repeated several
		// times in this function but only documented here.
		beginloop(0x93)
			if_target_in_sight(/*goto*/ 0x96)
			if_near_miss(/*goto*/ 0x96)
			if_saw_injury(0x00, /*goto*/ 0x96)
			if_saw_death(0x00, /*goto*/ 0x96)
			if_hears_gunfire(/*goto*/ 0x96)
			if_stage_flag_eq(STAGEFLAG_PROGRAMMER_RAN_TO_GUARD, TRUE, /*goto*/ 0x2c)
			if_sees_suspicious_item(/*goto*/ 0x96)
			label(0x2c)
			if_chr_stopped(/*goto*/ LABEL_LOG_ON)
		endloop(0x93)

		// Detected Jo
		label(0x96)
		restart_timer
		set_alertness(255)
		restart_timer
		try_face_entity(0x0200, 0x0000, /*goto*/ 0x9a)

		beginloop(0x9a)
			if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
			if_timer_gt(60, /*goto*/ 0x06)
		endloop(0x9a)

		label(0x06)
		if_stage_flag_eq(STAGEFLAG_TALKED_TO_PROGRAMMER, TRUE, /*goto*/ 0x06)
		speak(CHR_TARGET, L_AME(36), 0x1300, CHANNEL_3, COLOR_03_RED) // "HELP - Intruder!"
		chr_do_animation(ANIM_SURRENDER_002E, 0, 193, 0x18, 0x10, CHR_SELF, 2)

		beginloop(0xa3)
			if_sound_finished(CHANNEL_3, /*goto*/ 0x06)
		endloop(0xa3)

		label(0x06)
		if_chr_in_room(CHR_PROGRAMMER, 0x00, 0x007d, /*goto*/ LABEL_NEAR_LAPTOPGUN_ROOM)
		if_chr_in_room(CHR_PROGRAMMER, 0x00, 0x007e, /*goto*/ LABEL_NEAR_LAPTOPGUN_ROOM)
		if_chr_in_room(CHR_PROGRAMMER, 0x00, 0x007f, /*goto*/ LABEL_NEAR_LAPTOPGUN_ROOM)
		if_stage_flag_eq(STAGEFLAG_PROGRAMMER_INJURED, TRUE, /*goto*/ LABEL_JO_SPEAK)

		label(0xa2)
		if_chr_sees_player(/*goto*/ 0x06)
		goto_next(0x2c)

		// Can see Jo, and not injured or near Laptop Gun room
		label(0x06)
		if_stage_flag_eq(STAGEFLAG_PROGRAMMER_RAN_TO_GUARD, TRUE, /*goto*/ 0x06)

		label(0x2c)
		speak(CHR_TARGET, L_AME(79), 0x8107, CHANNEL_3, COLOR_03_RED) // "Security... Help me!"
		goto_next(0xa1)

		label(0x06)
		speak(CHR_TARGET, L_AME(38), 0x8108, CHANNEL_3, COLOR_03_RED) // "HELP, HELP!"
		label(0xa1)
		restart_timer
		set_stage_flag(STAGEFLAG_PROGRAMMER_RAN_TO_GUARD)
		try_set_chrpreset_to_unalerted_teammate(0, /*goto*/ LABEL_RUN_TO_GUARD)
		unset_object_flag2(OBJ_LAPTOPGUNDOOR, OBJFLAG2_AICANNOTUSE)
		jog_to_pad(0x0086)

		beginloop(0x97)
			if_timer_lt(240, /*goto*/ 0x06)
			if_chr_sees_player(/*goto*/ 0x2c)
			goto_next(0x06)
			label(0x2c)
			if_distance_to_target_lt(300, /*goto*/ LABEL_JO_SPEAK)
			label(0x06)
			if_chr_stopped(/*goto*/ 0x06)
		endloop(0x97)

		label(0x06)
		set_stage_flag(STAGEFLAG_PROGRAMMER_INJURED)
		restart_timer
		unlock_door(OBJ_LAPTOPGUNDOOR, 0x02)
		chr_do_animation(ANIM_COWER_01F5, 0, -1, 0x50, 0x10, CHR_SELF, 2)

		beginloop(0x0d)
			if_timer_gt(300, /*goto*/ 0xb5)
			if_distance_to_target_gt(300, /*goto*/ 0x2c)
			if_chr_sees_player(/*goto*/ 0x06)
			goto_next(0x2c)
			label(0x06)
			if_player_looking_at_something_maybe(0x28, 0x01, 0x00, /*goto*/ LABEL_JO_SPEAK)
			label(0x2c)
		endloop(0x0d)

		label(0xb5)
		goto_first(0x99)

		label(LABEL_RUN_TO_GUARD)
		try_run_to_chr(CHR_PRESET, /*goto*/ 0xa6)

		beginloop(0xa6)
			if_detected_chr(CHR_PRESET, /*goto*/ 0xa7)
			if_timer_lt(120, /*goto*/ 0x06)
			if_chr_sees_player(/*goto*/ LABEL_JO_SPEAK)
			goto_next(0x06)
			if_distance_to_target_lt(300, /*goto*/ LABEL_JO_SPEAK)
			label(0x06)
			if_chr_stopped(/*goto*/ 0xa7)
		endloop(0xa6)

		label(0xa7)
		speak(CHR_TARGET, L_AME(38), 0x8108, CHANNEL_3, COLOR_03_RED) // "HELP, HELP!"
		increase_squadron_alertness(100)
	endloop(0x99)

	label(LABEL_JO_SPEAK)
	restart_timer
	if_stage_flag_eq(STAGEFLAG_TALKED_TO_PROGRAMMER, TRUE, /*goto*/ 0x2c)
	speak(CHR_TARGET, L_AME(72), 0x7322, CHANNEL_3, COLOR_09_BLUE) // "I've got a password problem, and you're the man to..."
	goto_next(0x06)
	label(0x2c)
	speak(CHR_TARGET, L_AME(71), 0x7323, CHANNEL_3, COLOR_09_BLUE) // "Move it!"
	label(0x06)
	set_stage_flag(STAGEFLAG_TALKED_TO_PROGRAMMER)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x9b)

	beginloop(0x9b)
		if_stage_flag_eq(STAGEFLAG_TALKED_TO_PROGRAMMER, TRUE, /*goto*/ 0x06)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x9b)

	label(0x06)
	chr_do_animation(ANIM_SURRENDER_002E, 0, 193, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x10)
		if_sound_finished(CHANNEL_3, /*goto*/ 0x06)
	endloop(0x10)

	label(0x06)
	if_stage_flag_eq(STAGEFLAG_TALKED_TO_PROGRAMMER, TRUE, /*goto*/ 0x2c)
	speak(CHR_TARGET, L_AME(35), 0x12ff, CHANNEL_5, COLOR_03_RED) // "I'll do what you want!"
	set_stage_flag(STAGEFLAG_TALKED_TO_PROGRAMMER)
	goto_next(0x06)
	label(0x2c)
	speak(CHR_TARGET, L_AME(73), 0x12fe, CHANNEL_5, COLOR_03_RED) // "Don't shoot, don't shoot!"
	label(0x06)
	chr_do_animation(ANIM_DONT_SHOOT, 0, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x9f)
		if_sound_finished(CHANNEL_5, /*goto*/ 0x9d)
	endloop(0x9f)

	label(0x9d)
	walk_to_pad(0x0062)

	beginloop(0x9e)
		if_chr_stopped(/*goto*/ LABEL_LOG_ON)
		if_stage_flag_eq(STAGEFLAG_PROGRAMMER_INJURED, TRUE, /*goto*/ 0x06)
		if_distance_to_target_lt(500, /*goto*/ 0x06)
		if_player_looking_at_something_maybe(0x28, 0x01, 0x00, /*goto*/ 0x06)
		if_chr_in_room(CHR_PROGRAMMER, 0x00, 0x007d, /*goto*/ 0x06)
		if_chr_in_room(CHR_PROGRAMMER, 0x00, 0x007e, /*goto*/ 0x06)
		if_chr_in_room(CHR_PROGRAMMER, 0x00, 0x007f, /*goto*/ 0x06)
		goto_next(0xa0)
		label(0x06)
	endloop(0x9e)

	label(0xa0)
	goto_first(0xa2)

	label(LABEL_NEAR_LAPTOPGUN_ROOM)
	stop_chr
	speak(CHR_TARGET, L_AME(39), 0x12ff, CHANNEL_3, COLOR_03_RED) // "I'll do what you want..."
	restart_timer
	label(0x06)
	walk_to_pad(0x0062)

	beginloop(0xa9)
		if_chr_stopped(/*goto*/ LABEL_LOG_ON)
	endloop(0xa9)

	label(LABEL_LOG_ON)
	restart_timer
	if_stage_flag_eq(STAGEFLAG_PC_DESTROYED, TRUE, /*goto*/ LABEL_PC_BROKEN)
	if_detected_chr(CHR_TARGET, /*goto*/ 0x2c)
	speak(CHR_TARGET, L_AME(40), 0x1301, CHANNEL_3, COLOR_03_RED) // "Logging on now..."
	goto_next(0x06)
	label(0x2c)
	speak(CHR_TARGET, L_AME(109), 0x1304, CHANNEL_3, COLOR_03_RED) // "I...I'm logging on now."
	label(0x06)
	chr_do_animation(ANIM_STANDING_TYPE_ONE_HAND, 0, 193, 0x18, 0x10, CHR_SELF, 2)
	speak(CHR_TARGET, -1, 0x8116, -1, COLOR_00_GREEN)

	beginloop(0xae)
		if_stage_flag_eq(STAGEFLAG_PC_DESTROYED, TRUE, /*goto*/ LABEL_PC_BROKEN)
		if_timer_gt(360, /*goto*/ 0x06)
	endloop(0xae)

	label(0x06)
	if_stage_flag_eq(STAGEFLAG_PC_DESTROYED, TRUE, /*goto*/ LABEL_PC_BROKEN)
	chr_do_animation(ANIM_PUSH_BUTTON, 0, 193, 0x18, 0x10, CHR_SELF, 2)
	set_stage_flag(STAGEFLAG_PROGRAMMER_LOGGED_IN)
	if_detected_chr(CHR_TARGET, /*goto*/ 0x2c)
	speak(CHR_TARGET, L_AME(41), 0x1302, CHANNEL_3, COLOR_03_RED) // "Okay, I'm in..."
	goto_next(0x06)
	label(0x2c)
	speak(CHR_TARGET, L_AME(108), 0x1305, CHANNEL_3, COLOR_03_RED) // "Right, I'm in..."
	label(0x06)
	speak(CHR_TARGET, -1, 0x8117, -1, COLOR_00_GREEN)

	beginloop(0xaf)
		if_stage_flag_eq(STAGEFLAG_PC_DESTROYED, TRUE, /*goto*/ LABEL_PC_BROKEN)
		if_chr_dying(CHR_SELF, /*goto*/ 0xb1)
		if_timer_gt(1040, /*goto*/ 0x06)
	endloop(0xaf)

	label(0x06)
	if_stage_flag_eq(STAGEFLAG_PC_DESTROYED, TRUE, /*goto*/ LABEL_PC_BROKEN)
	set_stage_flag(STAGEFLAG_PERSONALITY_DELETED)
	set_chr_maxdamage(CHR_SELF, 1)
	chr_do_animation(ANIM_TALKING_003D, 0, 193, 0x18, 0x10, CHR_SELF, 2)
	speak(CHR_TARGET, L_AME(42), 0x1303, CHANNEL_3, COLOR_03_RED) // "Goodbye, Dr. Caroll."
	if_stage_flag_eq(STAGEFLAG_DOWNLOAD_COMPLETE, TRUE, /*goto*/ 0x2c)
	set_stage_flag(STAGEFLAG_DELETED_WITHOUT_DOWNLOAD)
	label(0x2c)
	speak(CHR_TARGET, -1, 0x8118, -1, COLOR_00_GREEN)

	beginloop(0xb0)
	endloop(0xb0)

	label(0xb1)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(LABEL_PC_BROKEN)
	set_self_flag_bankx(CHRFLAG0_CANT_ALERT_GROUP, BANK_0)
	speak(CHR_TARGET, L_AME(98), 0x1289, CHANNEL_3, COLOR_03_RED) // "You vandal, you've broken it!"
	do_preset_animation(-1)

	beginloop(0xc6)
		if_sound_finished(CHANNEL_3, /*goto*/ 0x06)
	endloop(0xc6)

	label(0x06)
	set_returnlist(CHR_SELF, GAILIST_ALERTED)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

/**
 * This function appears to be pointless considering you have control during the
 * conversation anyway. Perhaps at one point during development there was a
 * cutscene for the phone conversation?
 */
u8 func1005_give_control[] = {
	beginloop(0x52)
		if_stage_flag_eq(STAGEFLAG_PROGRAMMER_WALKING, TRUE, /*goto*/ 0x06)
	endloop(0x52)

	label(0x06)
	label(0x2c)
	yield
	grant_control(CHR_BOND)
	grant_control(CHR_COOP)
	yield
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * @unused
 */
u8 func0415_set_idle[] = {
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * @unused
 */
u8 func0413_c318[] = {
	set_accuracy(10)
	try_equip_weapon(MODEL_CHRCMP150, WEAPON_CMP150, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	set_squadron(SQUADRON_09)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	set_self_flag_bankx(CHRFLAG0_00008000, BANK_0)
	set_alertness(255)
	set_self_chrflag(CHRCFLAG_00000200)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0001)
	endlist
};

u8 func100e_check_ecm_mines[] = {
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x06)
	give_object_to_chr(OBJ_ECMMINE_BOND, CHR_BOND)
	give_object_to_chr(OBJ_ECMMINE_COOP, CHR_COOP)
	label(0x06)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x00)
	give_object_to_chr(OBJ_DATAUPLINK_BOND, CHR_BOND)
	give_object_to_chr(OBJ_DATAUPLINK_COOP, CHR_COOP)

	beginloop(0x00)
		if_stage_flag_eq(STAGEFLAG_SECURITYHUB_COMPLETE, TRUE, /*goto*/ 0x06)
		if_stage_flag_eq(STAGEFLAG_SECURITYHUB_MINES_WASTED, TRUE, /*goto*/ 0x2c)
		if_weapon_thrown_on_object(WEAPON_ECMMINE, OBJ_SECURITYHUB, /*goto*/ 0x08)
		label(0x06)
		if_stage_flag_eq(STAGEFLAG_EXTCOMMSHUB_COMPLETE, TRUE, /*goto*/ 0x06)
		if_stage_flag_eq(STAGEFLAG_EXTCOMMSHUB_MINES_WASTED, TRUE, /*goto*/ 0x2c)
		if_weapon_thrown_on_object(WEAPON_ECMMINE, OBJ_EXTCOMMSHUB, /*goto*/ 0x0a)
		label(0x06)
		if_timer_gt(0, /*goto*/ 0x06)
		if_weapon_thrown(WEAPON_ECMMINE, /*goto*/ 0x0b)
		label(0x2c)
		reloop(0x00)

		label(0x06)
		if_timer_gt(240, /*goto*/ 0x53)
		reloop(0x00)

		label(0x08)
		reset_timer
		show_hudmsg(CHR_BOND, L_AME(29)) // "ECM Mine placed correctly."
		yield
		mute_channel(CHANNEL_0)
		assign_sound(0x8113, CHANNEL_0)
		control_sound_from_object(CHANNEL_0, OBJ_SECURITYHUB, TRUE)
		show_hudmsg(CHR_BOND, L_AME(76)) // "Internal security system temporarily disabled."
		set_stage_flag(STAGEFLAG_SECURITYHUB_COMPLETE)
		reloop(0x00)

		label(0x0a)
		reset_timer
		show_hudmsg(CHR_BOND, L_AME(29)) // "ECM Mine placed correctly."
		yield
		mute_channel(CHANNEL_1)
		assign_sound(0x8113, CHANNEL_1)
		control_sound_from_object(CHANNEL_1, OBJ_EXTCOMMSHUB, TRUE)
		show_hudmsg(CHR_BOND, L_AME(77)) // "External communications hub disabled."
		set_stage_flag(STAGEFLAG_EXTCOMMSHUB_COMPLETE)
		reloop(0x00)

		label(0x0b)
		restart_timer
		reloop(0x00)

		// Check ECM mines wasted
		label(0x53)
		reset_timer
		if_stage_flag_eq(STAGEFLAG_SECURITYHUB_COMPLETE, TRUE, /*goto*/ 0x88)
		if_stage_flag_eq(STAGEFLAG_EXTCOMMSHUB_COMPLETE, TRUE, /*goto*/ 0x89)
		if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0xbe)
		if_ammo_quantity_lt(CHR_BOND, AMMOTYPE_ECM_MINE, 1, /*goto*/ 0xbe)
		if_ammo_quantity_lt(CHR_BOND, AMMOTYPE_ECM_MINE, 2, /*goto*/ 0xbf)
		reloop(0x00)

		label(0xbe)
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0xc0)
		if_ammo_quantity_lt(CHR_COOP, AMMOTYPE_ECM_MINE, 2, /*goto*/ 0xc0)
		reloop(0x00)

		label(0xbf)
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0xc0)
		if_ammo_quantity_lt(CHR_COOP, AMMOTYPE_ECM_MINE, 1, /*goto*/ 0xc0)
		reloop(0x00)

		label(0xc0)
		goto_next(0x8d)

		// Security hub is complete
		label(0x88)
		if_stage_flag_eq(STAGEFLAG_EXTCOMMSHUB_COMPLETE, TRUE, /*goto*/ 0x8a)
		if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0xbe)
		if_ammo_quantity_lt(CHR_BOND, AMMOTYPE_ECM_MINE, 1, /*goto*/ 0xbe)
		reloop(0x00)

		label(0xbe)
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0xbf)
		if_ammo_quantity_lt(CHR_COOP, AMMOTYPE_ECM_MINE, 1, /*goto*/ 0xbf)
		reloop(0x00)

		label(0xbf)
		goto_next(0x8b)

		// Comms hub is complete
		label(0x89)
		if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0xbe)
		if_ammo_quantity_lt(CHR_BOND, AMMOTYPE_ECM_MINE, 1, /*goto*/ 0xbe)
		reloop(0x00)

		label(0xbe)
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0xbf)
		if_ammo_quantity_lt(CHR_COOP, AMMOTYPE_ECM_MINE, 1, /*goto*/ 0xbf)
		reloop(0x00)

		// Mines wasted with security hub remaining
		label(0xbf)
		goto_next(0x06)
		label(0x06)
		set_stage_flag(STAGEFLAG_SECURITYHUB_MINES_WASTED)
		goto_next(0x8c)

		// Mines wasted with comms hub remaining
		label(0x8b)
		set_stage_flag(STAGEFLAG_EXTCOMMSHUB_MINES_WASTED)

		label(0x8c)
		show_hudmsg(CHR_BOND, L_AME(28)) // "Badly placed ECM Mine."
		reloop(0x00)

		// Mines wasted with both hubs remaining
		label(0x8d)
		show_hudmsg(CHR_BOND, L_AME(28)) // "Badly placed ECM Mine."
		show_hudmsg(CHR_BOND, L_AME(32)) // "CANNOT complete all objectives."
		set_stage_flag(STAGEFLAG_SECURITYHUB_MINES_WASTED)
		set_stage_flag(STAGEFLAG_EXTCOMMSHUB_MINES_WASTED)
		reloop(0x00)

		// Both hubs are complete
		label(0x8a)
	endloop(0x00)

	beginloop(0x06)
	endloop(0x06)

	endlist
};

u8 func1004_check_lab_lift_located[] = {
	beginloop(0x52)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_LABLIFTDOOR1, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, OBJ_LABLIFTDOOR2, /*goto*/ 0x2c)
		if_chr_in_room(CHR_P1P2, 0x00, 0x002b, /*goto*/ 0x2c)
		reloop(0x52)

		label(0x2c)
		if_stage_flag_eq(STAGEFLAG_LAB_LIFT_LOCATED, TRUE, /*goto*/ 0x2c)
		show_hudmsg(CHR_P1P2, L_AME(78)) // "Laboratory lift located."
		set_stage_flag(STAGEFLAG_LAB_LIFT_LOCATED)
		label(0x2c)
		yield
		if_all_objectives_complete(/*goto*/ 0x2c)
	endloop(0x52)

	label(0x2c)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2c)
	if_chr_dying(CHR_BOND, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x2c)
	goto_next(0x06)

	label(0x2c)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2c)
	if_chr_dying(CHR_COOP, /*goto*/ 0x2c)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x2c)
	goto_next(0x06)

	label(0x2c)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	set_invincible(CHR_BOND)
	set_ailist(CHR_SELF, AILIST_OUTRO)
	endlist
};

u8 func1006_check_programmer_dead[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x06)

	beginloop(0x04)
		if_chr_dying(CHR_PROGRAMMER, /*goto*/ 0x2c)
		if_chr_unloaded(CHR_PROGRAMMER, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	if_stage_flag_eq(STAGEFLAG_PROGRAMMER_LOGGED_IN, TRUE, /*goto*/ 0x06)
	show_hudmsg(CHR_BOND, L_AME(57)) // "Critical mission personnel killed."
	set_stage_flag(STAGEFLAG_PROGRAMMER_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Unreachable
	label(0xac)
	yield
	goto_first(0x06)

	endlist
};

u8 func1007_uplinking[] = {
	beginloop(0x04)
		if_chr_activated_object(CHR_BOND, OBJ_PC, /*goto*/ 0xbe)
		if_chr_activated_object(CHR_COOP, OBJ_PC, /*goto*/ 0xbf)
		reloop(0x04)

		label(0xbe)
		set_target_chr(CHR_BOND)
		goto_next(0xc0)

		label(0xbf)
		set_target_chr(CHR_COOP)
		goto_next(0xc0)

		label(0xc0)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_DATAUPLINK, /*goto*/ 0x2c)
		show_hudmsg(CHR_TARGET, L_AME(49)) // "Unable to download - Data Uplink needed."
		call_rng
		if_rand_lt(60, /*goto*/ 0x0d)
		if_rand_lt(120, /*goto*/ 0x0e)
		if_rand_lt(180, /*goto*/ 0x0f)

		label(0x0c)
		speak(CHR_TARGET, -1, 0x8116, -1, COLOR_00_GREEN)
		goto_next(0x06)

		label(0x0d)
		speak(CHR_TARGET, -1, 0x8117, -1, COLOR_00_GREEN)
		goto_next(0x06)

		label(0x0e)
		speak(CHR_TARGET, -1, 0x8118, -1, COLOR_00_GREEN)
		goto_next(0x06)

		label(0x0f)
		speak(CHR_TARGET, -1, 0x8118, -1, COLOR_00_GREEN)

		label(0x06)
		restart_timer

		beginloop(0x10)
			if_timer_gt(120, /*goto*/ 0x06)
		goto_first(0x10)

		label(0x06)
		reloop(0x04)

		label(0x2c)
		if_stage_flag_eq(STAGEFLAG_PROGRAMMER_LOGGED_IN, TRUE, /*goto*/ 0xae)
		restart_timer
		show_hudmsg(CHR_TARGET, L_AME(46)) // "ACCESS DENIED - password needed."
		assign_sound(0x01c0, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_PC, FALSE)

		beginloop(0xaf)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0xaf)

		label(0x06)
		mute_channel(CHANNEL_7)
		goto_first(0x04)

		label(0xae)
		show_hudmsg(CHR_TARGET, L_AME(44)) // "File download initiated."
		assign_sound(0x01bf, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_PC, TRUE)
		restart_timer

		// @bug: Missing check for player still having uplink equipped
		beginloop(0xac)
			if_chr_distance_to_pad_gt(CHR_TARGET, 250, 0x01b6, /*goto*/ 0x2c)
			if_stage_flag_eq(STAGEFLAG_DELETED_WITHOUT_DOWNLOAD, TRUE, /*goto*/ 0x12)
			if_timer_gt(300, /*goto*/ 0xad)
		endloop(0xac)

		label(0xad)
		mute_channel(CHANNEL_7)
		assign_sound(0x01c1, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_PC, TRUE)
		show_hudmsg(CHR_TARGET, L_AME(45)) // "File download completed."
		yield
		set_stage_flag(STAGEFLAG_DOWNLOAD_COMPLETE)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x2c)
		show_hudmsg(CHR_TARGET, L_AME(74)) // "Datalink broken - connection terminated."
		mute_channel(CHANNEL_7)
		assign_sound(0x01c0, CHANNEL_6)
		play_sound_from_object(CHANNEL_6, OBJ_PC, 0x012c, 0x0190)
		restart_timer

		beginloop(0x11)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x11)

		label(0x06)
		mute_channel(CHANNEL_6)
		reloop(0x04)

		label(0x12)
		show_hudmsg(CHR_TARGET, L_AME(75)) // "Datalink error - incomplete file download."
		mute_channel(CHANNEL_7)
		assign_sound(0x01c0, CHANNEL_6)
		play_sound_from_object(CHANNEL_6, OBJ_PC, 0x012c, 0x0190)
		restart_timer

		beginloop(0x13)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x13)

		label(0x06)
		mute_channel(CHANNEL_6)
	endloop(0x04)

	endlist
};

u8 func1008_doorswitch[] = {
	if_difficulty_gt(DIFF_SA, /*goto*/ 0x04)

	// A and SA
	unlock_door(OBJ_OFFICEDOOR1, 0x01)
	unlock_door(OBJ_OFFICEDOOR2, 0x01)
	unset_object_flag2(OBJ_OFFICEDOOR1, OBJFLAG2_AICANNOTUSE)
	unset_object_flag2(OBJ_OFFICEDOOR2, OBJFLAG2_AICANNOTUSE)
	set_stage_flag(STAGEFLAG_OFFICE_DOOR_UNLOCKED)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// PA
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_DOORSWITCH, /*goto*/ 0x2c)
		label(0x06)
	endloop(0x04)

	label(0x2c)
	play_sound(0x00ba, -1)
	show_hudmsg(CHR_P1P2, L_AME(47)) // "Door unlocked."
	set_stage_flag(STAGEFLAG_OFFICE_DOOR_UNLOCKED)
	unlock_door(OBJ_OFFICEDOOR1, 0x01)
	unlock_door(OBJ_OFFICEDOOR2, 0x01)
	unset_object_flag2(OBJ_OFFICEDOOR1, OBJFLAG2_AICANNOTUSE)
	unset_object_flag2(OBJ_OFFICEDOOR2, OBJFLAG2_AICANNOTUSE)
	yield
	restart_timer

	beginloop(0x08)
		if_timer_gt(45, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	assign_sound(0x043b, CHANNEL_7)
	control_sound_from_object(CHANNEL_7, OBJ_OFFICEDOOR1, TRUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1009_check_civilians_killed[] = {
	beginloop(0x04)
		if_chr_dying(CHR_SECRETARY, /*goto*/ 0x2c)
		if_chr_dying(CHR_CASS, /*goto*/ 0x09)
		label(0x06)
	endloop(0x04)

	label(0x2c)
	show_hudmsg(CHR_BOND, L_AME(55)) // "Unacceptable civilian casualties."
	set_stage_flag(STAGEFLAG_CIVILIANS_KILLED)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x09)
	show_hudmsg(CHR_BOND, L_AME(57)) // "Critical mission personnel killed."
	set_stage_flag(STAGEFLAG_CIVILIANS_KILLED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Wait for alarm while security is disabled, then set a flag on a CMP guard.
 */
u8 func100a_alarm_guard[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_SECURITY_DISABLED, FALSE, /*goto*/ 0x06)
		if_alarm_active(/*goto*/ 0x2c)
		label(0x06)
		reloop(0x04)

		label(0x2c)
		set_chr_flag_bankx(0x09, CHRFLAG0_00002000, BANK_0)
		goto_next(0xb3)

		// Unreachable
		label(0xac)
		deactivate_alarm
		reloop(0x04)

		label(0xb3)
		label(0xb2)
	endloop(0x04)

	endlist
};

u8 func100b_lightswitch[] = {
	beginloop(0x04)
		if_chr_activated_object(CHR_ANY, OBJ_LIGHTSWITCH, /*goto*/ 0x2c)
		reloop(0x04)

		label(0x2c)
		play_sound(0x00ba, -1)
		if_stage_flag_eq(STAGEFLAG_LIGHTS_OFF, TRUE, /*goto*/ 0x06)

		// Turning lights off
		set_stage_flag(STAGEFLAG_LIGHTS_OFF)
		set_lights_state(0x0044, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x0039, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x003c, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x003d, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x003e, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x003b, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x0042, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x003f, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x003a, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x0041, 0x07, 0x00, 0x00, 0x00)
		set_lights_state(0x0040, 0x07, 0x00, 0x00, 0x00)
		reloop(0x04)

		// Turning lights on
		label(0x06)
		unset_stage_flag(STAGEFLAG_LIGHTS_OFF)
		set_lights_state(0x0044, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x0039, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x003c, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x003d, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x003e, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x003b, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x0042, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x003f, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x003a, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x0041, 0x06, 0x00, 0x00, 0x00)
		set_lights_state(0x0040, 0x06, 0x00, 0x00, 0x00)
	endloop(0x04)

	endlist
};

u8 func100c_noop2[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_PERSONALITY_DELETED, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100d_check_objects_destroyed[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0d)

	// SA and PA
	beginloop(0x04)
		// Check security hub
		if_stage_flag_eq(STAGEFLAG_SECURITYHUB_DESTROYED, TRUE, /*goto*/ 0x2c)
		if_object_in_good_condition(OBJ_SECURITYHUB, /*goto*/ 0x2c)
		set_stage_flag(STAGEFLAG_SECURITYHUB_DESTROYED)
		mute_channel(CHANNEL_0)
		show_hudmsg(CHR_BOND, L_AME(54)) // "Critical mission object destroyed."

		// PA only - check door switch
		label(0x2c)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_OFFICE_DOOR_UNLOCKED, TRUE, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_DOORSWITCH_DESTROYED, TRUE, /*goto*/ 0x2c)
		if_object_in_good_condition(OBJ_DOORSWITCH, /*goto*/ 0x2c)
		set_stage_flag(STAGEFLAG_DOORSWITCH_DESTROYED)
		show_hudmsg(CHR_BOND, L_AME(54)) // "Critical mission object destroyed."

		// PA only - check PC
		label(0x2c)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x2c)
		if_objective_complete(2, /*goto*/ 0x2c)
		if_stage_flag_eq(STAGEFLAG_PC_DESTROYED, TRUE, /*goto*/ 0x2c)
		if_objective_failed(2, /*goto*/ 0x2c)
		if_object_in_good_condition(OBJ_PC, /*goto*/ 0x2c)
		set_stage_flag(STAGEFLAG_PC_DESTROYED)
		show_hudmsg(CHR_BOND, L_AME(54)) // "Critical mission object destroyed."

		// Check comms hub
		label(0x2c)
		if_stage_flag_eq(STAGEFLAG_EXTCOMMSHUB_DESTROYED, TRUE, /*goto*/ 0x2c)
		if_object_in_good_condition(OBJ_EXTCOMMSHUB, /*goto*/ 0x2c)
		set_stage_flag(STAGEFLAG_EXTCOMMSHUB_DESTROYED)
		mute_channel(CHANNEL_1)
		show_hudmsg(CHR_BOND, L_AME(54)) // "Critical mission object destroyed."
		label(0x2c)
	endloop(0x04)

	// Agent
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1002_objectives_failed_msg[] = {
	yield
	set_chr_chrflag(CHR_CASS, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_SECRETARY, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_PROGRAMMER, CHRCFLAG_04000000)
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

#define wait_for_camera_finished \
	beginloop(0x08) \
		if_camera_animating(/*goto*/ 0x2c) \
		goto_next(0x06) \
		label(0x2c) \
		if_controller_button_pressed(/*goto*/ 0x06) \
	endloop(0x08)



u8 func041b_intro_041b[] = {
	if_controller_button_pressed(/*goto*/ 0x36)
	camera_movement(0x00c9)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	show_object(OBJ_JUMPSHIP2)
	set_object_flag3(OBJ_JUMPSHIP2, OBJFLAG3_00000010)
	object_do_animation(0x00ca, OBJ_JUMPSHIP2, 0x04, 0xffff)
	show_object(OBJ_POLICECAR)
	set_object_flag3(OBJ_POLICECAR, OBJFLAG3_00000010)
	object_do_animation(0x0122, OBJ_POLICECAR, 0x04, 0xffff)
	show_object(OBJ_HOVERCOP3)
	set_object_flag3(OBJ_HOVERCOP3, OBJFLAG3_00000010)
	object_do_animation(0x0123, OBJ_HOVERCOP3, 0x04, 0xffff)
	show_object(OBJ_HOVERCAR3)
	set_object_flag3(OBJ_HOVERCAR3, OBJFLAG3_00000010)
	object_do_animation(0x0124, OBJ_HOVERCAR3, 0x04, 0xffff)
	show_object(OBJ_HOVERMOTO3)
	set_object_flag3(OBJ_HOVERMOTO3, OBJFLAG3_00000010)
	object_do_animation(0x0125, OBJ_HOVERMOTO3, 0x04, 0xffff)
	show_object(OBJ_HOVERCAB3)
	set_object_flag3(OBJ_HOVERCAB3, OBJFLAG3_00000010)
	object_do_animation(0x0126, OBJ_HOVERCAB3, 0x04, 0xffff)
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 90)
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_FALCON2_SILENCER, WEAPON_NONE)

	wait_for_camera_finished

	label(0x06)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	hide_object(OBJ_JUMPSHIP2)
	hide_object(OBJ_POLICECAR)
	hide_object(OBJ_HOVERCOP3)
	hide_object(OBJ_HOVERCAR3)
	hide_object(OBJ_HOVERMOTO3)
	hide_object(OBJ_HOVERCAB3)
	label(0x36)
	return
	endlist
};

u8 func041a_intro_041a[] = {
	if_controller_button_pressed(/*goto*/ 0x36)
	camera_movement(0x00c7)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	show_object(OBJ_JUMPSHIP2)
	set_object_flag3(OBJ_JUMPSHIP2, OBJFLAG3_00000010)
	object_do_animation(0x00c8, OBJ_JUMPSHIP2, 0x04, 0xffff)
	show_object(OBJ_HOVERTAXI2)
	set_object_flag3(OBJ_HOVERTAXI2, OBJFLAG3_00000010)
	object_do_animation(0x011c, OBJ_HOVERTAXI2, 0x04, 0xffff)
	show_object(OBJ_HOVERCOP3)
	set_object_flag3(OBJ_HOVERCOP3, OBJFLAG3_00000010)
	object_do_animation(0x011d, OBJ_HOVERCOP3, 0x04, 0xffff)
	show_object(OBJ_HOVERCAR3)
	set_object_flag3(OBJ_HOVERCAR3, OBJFLAG3_00000010)
	object_do_animation(0x011e, OBJ_HOVERCAR3, 0x04, 0xffff)
	show_object(OBJ_HOVERMOTO3)
	set_object_flag3(OBJ_HOVERMOTO3, OBJFLAG3_00000010)
	object_do_animation(0x011f, OBJ_HOVERMOTO3, 0x04, 0xffff)
	show_object(OBJ_HOVERCAB3)
	set_object_flag3(OBJ_HOVERCAB3, OBJFLAG3_00000010)
	object_do_animation(0x0120, OBJ_HOVERCAB3, 0x04, 0xffff)
	show_object(OBJ_HOVERTRUCK3)
	set_object_flag3(OBJ_HOVERTRUCK3, OBJFLAG3_00000010)
	object_do_animation(0x0121, OBJ_HOVERTRUCK3, 0x04, 0xffff)

	wait_for_camera_finished

	label(0x06)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	hide_object(OBJ_JUMPSHIP2)
	hide_object(OBJ_HOVERTAXI2)
	hide_object(OBJ_HOVERCOP3)
	hide_object(OBJ_HOVERCAR3)
	hide_object(OBJ_HOVERMOTO3)
	hide_object(OBJ_HOVERCAB3)
	hide_object(OBJ_HOVERTRUCK3)
	label(0x36)
	return
	endlist
};

u8 func0419_intro_0419[] = {
	if_controller_button_pressed(/*goto*/ 0x36)
	camera_movement(0x00c5)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	show_object(OBJ_JUMPSHIP2)
	set_object_flag3(OBJ_JUMPSHIP2, OBJFLAG3_00000010)
	object_do_animation(0x00c6, OBJ_JUMPSHIP2, 0x04, 0xffff)
	show_object(OBJ_HOVERTAXI1)
	set_object_flag3(OBJ_HOVERTAXI1, OBJFLAG3_00000010)
	object_do_animation(0x0119, OBJ_HOVERTAXI1, 0x04, 0xffff)
	show_object(OBJ_HOVERCOP3)
	set_object_flag3(OBJ_HOVERCOP3, OBJFLAG3_00000010)
	object_do_animation(0x011a, OBJ_HOVERCOP3, 0x04, 0xffff)
	show_object(OBJ_HOVERCAR3)
	set_object_flag3(OBJ_HOVERCAR3, OBJFLAG3_00000010)
	object_do_animation(0x011b, OBJ_HOVERCAR3, 0x04, 0xffff)

	wait_for_camera_finished

	label(0x06)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	hide_object(OBJ_JUMPSHIP2)
	hide_object(OBJ_HOVERTAXI1)
	hide_object(OBJ_HOVERCOP3)
	hide_object(OBJ_HOVERCAR3)
	label(0x36)
	return
	endlist
};

u8 func041c_intro_041c[] = {
	if_controller_button_pressed(/*goto*/ 0x36)
	camera_movement(0x00cb)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	show_object(OBJ_JUMPSHIP2)
	set_object_flag3(OBJ_JUMPSHIP2, OBJFLAG3_00000010)
	object_do_animation(0x00cc, OBJ_JUMPSHIP2, 0x04, 0xffff)
	show_object(OBJ_HOVERTAXI1)
	set_object_flag3(OBJ_HOVERTAXI1, OBJFLAG3_00000010)
	object_do_animation(0x0127, OBJ_HOVERTAXI1, 0x04, 0xffff)

	// Invalid object
	show_object(0x1d)
	set_object_flag3(0x1d, OBJFLAG3_00000010)
	object_do_animation(0x0128, 0x1d, 0x04, 0xffff)

	show_object(OBJ_HOVERCOP3)
	set_object_flag3(OBJ_HOVERCOP3, OBJFLAG3_00000010)
	object_do_animation(0x0129, OBJ_HOVERCOP3, 0x04, 0xffff)
	show_object(OBJ_HOVERCAR3)
	set_object_flag3(OBJ_HOVERCAR3, OBJFLAG3_00000010)
	object_do_animation(0x012a, OBJ_HOVERCAR3, 0x04, 0xffff)
	show_object(OBJ_HOVERMOTO3)
	set_object_flag3(OBJ_HOVERMOTO3, OBJFLAG3_00000010)
	object_do_animation(0x012b, OBJ_HOVERMOTO3, 0x04, 0xffff)

	wait_for_camera_finished

	label(0x06)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	hide_object(OBJ_JUMPSHIP2)
	hide_object(OBJ_HOVERTAXI1)
	hide_object(0x1d)
	hide_object(OBJ_HOVERCOP3)
	hide_object(OBJ_HOVERCAR3)
	hide_object(OBJ_HOVERMOTO3)
	label(0x36)
	return
	endlist
};

/**
 * Part of the intro cutscene.
 */
u8 func041d_intro_041d[] = {
	if_controller_button_pressed(/*goto*/ 0x36)
	camera_movement(0x00cd)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	show_object(OBJ_JUMPSHIP2)
	set_object_flag3(OBJ_JUMPSHIP2, OBJFLAG3_00000010)
	object_do_animation(0x00ce, OBJ_JUMPSHIP2, 0x01, 0xffff)
	show_object(OBJ_HOVERTAXI1)
	set_object_flag3(OBJ_HOVERTAXI1, OBJFLAG3_00000010)
	object_do_animation(0x012c, OBJ_HOVERTAXI1, 0x04, 0xffff)
	show_object(0x1d)
	set_object_flag3(0x1d, OBJFLAG3_00000010)
	object_do_animation(0x012d, 0x1d, 0x04, 0xffff)

	wait_for_camera_finished

	label(0x06)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	hide_object(OBJ_JUMPSHIP2)
	hide_object(OBJ_HOVERTAXI1)
	hide_object(0x1d)
	label(0x36)
	return
	endlist
};

/**
 * @unregistered
 */
u8 unregistered_function2[] = {
	set_returnlist(CHR_SELF, GAILIST_END_CINEMA)
	set_ailist(CHR_SELF, AILIST_INTRO_041B)
	endlist
};

/**
 * @unregistered
 */
u8 unregistered_function3[] = {
	set_returnlist(CHR_SELF, GAILIST_END_CINEMA)
	set_ailist(CHR_SELF, AILIST_INTRO_041A)
	endlist
};

/**
 * @unregistered
 */
u8 unregistered_function4[] = {
	set_returnlist(CHR_SELF, GAILIST_END_CINEMA)
	set_ailist(CHR_SELF, AILIST_INTRO_0419)
	endlist
};

/**
 * @unregistered
 */
u8 unregistered_function5[] = {
	set_returnlist(CHR_SELF, GAILIST_END_CINEMA)
	set_ailist(CHR_SELF, AILIST_INTRO_041C)
	endlist
};

/**
 * @unregistered
 */
u8 unregistered_function6[] = {
	set_returnlist(CHR_SELF, GAILIST_END_CINEMA)
	set_ailist(CHR_SELF, AILIST_INTRO_041D)
	endlist
};

/**
 * This is the most ridiculous way of doing an intro cutscene. This is how all
 * the ailists call each other:
 *
 * func0422_intro calls 041b with return to 041e
 * 041e calls 041a with return to 041f
 * 041f calls 0419 with return to 0420
 * 0420 calls 041c with return to 0421
 * 0421 calls 041d with return to 0428
 * 0428 does stuff then sets 0424
 * 0424 does stuff then sets 0425
 * 0425 does stuff then sets 0423
 * 0423 does stuff then sets 0426
 * 0426 does stuff then sets 0429
 * 0429 does stuff then sets 0427
 * 0427 does stuff then sets 042a
 * 042a does stuff then sets 042b
 * 042b does stuff then sets 042c
 * 042c just sets 042d
 * 042d finishes intro
 */
u8 func0422_intro[] = {
#if VERSION == VERSION_PAL_FINAL
	yield
	set_stage_flag(STAGEFLAG_TRIGGER_INTRO)
	yield
#else
	set_sfx_track(MUSIC_DEFECTION_INTRO_SFX)

	// No yield in this loop!
	label(0x07)
	cmd01dd_if_something(0x10, /*goto*/ 0x2c)
	misc_command(0x0000, 0x0b, 0x00)
	goto_first(0x07)

	label(0x2c)
	yield
	set_stage_flag(STAGEFLAG_TRIGGER_INTRO)
	yield
	set_music_track(MUSIC_DEFECTION_INTRO)

	label(0x08)
	cmd01dd_if_something(0x01, /*goto*/ 0x2c)
	misc_command(0x0000, 0x0b, 0x00)
	goto_first(0x08)

	label(0x2c)
#endif

	set_returnlist(CHR_SELF, AILIST_INTRO_041E)
	set_ailist(CHR_SELF, AILIST_INTRO_041B)
	endlist
};

u8 func041e_intro_041e[] = {
	set_returnlist(CHR_SELF, AILIST_INTRO_041F)
	set_ailist(CHR_SELF, AILIST_INTRO_041A)
	endlist
};

u8 func041f_intro_041f[] = {
	set_returnlist(CHR_SELF, AILIST_INTRO_0420)
	set_ailist(CHR_SELF, AILIST_INTRO_0419)
	endlist
};

u8 func0420_intro_0420[] = {
	set_returnlist(CHR_SELF, AILIST_INTRO_0421)
	set_ailist(CHR_SELF, AILIST_INTRO_041C)
	endlist
};

u8 func0421_intro_0421[] = {
	set_returnlist(CHR_SELF, 0x0428)
	set_ailist(CHR_SELF, AILIST_INTRO_041D)
	endlist
};

u8 func0422_intro_0423[] = {
	if_controller_button_pressed(/*goto*/ 0x36)
	camera_movement(0x00ee)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	show_object(OBJ_JUMPSHIP1)
	set_object_flag3(OBJ_JUMPSHIP1, OBJFLAG3_00000010)
	object_do_animation(0x00ef, OBJ_JUMPSHIP1, 0x04, 0xffff)
	set_tinted_glass_enabled(TRUE)

	wait_for_camera_finished

	label(0x06)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	hide_object(OBJ_JUMPSHIP1)
	set_tinted_glass_enabled(FALSE)
	label(0x36)
	set_ailist(CHR_SELF, AILIST_INTRO_0426)
	endlist
};

u8 func0422_intro_0424[] = {
	if_controller_button_pressed(/*goto*/ 0x36)
	camera_movement(0x00fc)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	show_object(OBJ_JUMPSHIP1)
	set_object_flag3(OBJ_JUMPSHIP1, OBJFLAG3_00000010)
	object_do_animation(0x00fd, OBJ_JUMPSHIP1, 0x04, 0xffff)
	set_chr_chrflag(CHR_CASS, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_SECRETARY, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_SECRETARY, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_SECRETARY, CHRHFLAG_00020000)
	chr_do_animation(0x00fe, -1, -1, 0x06, 0x00, CHR_SECRETARY, 4)

	wait_for_camera_finished

	label(0x06)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	hide_object(OBJ_JUMPSHIP1)
	unset_chr_chrflag(CHR_CASS, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_SECRETARY, CHRCFLAG_UNPLAYABLE)
	label(0x36)
	set_ailist(CHR_SELF, AILIST_INTRO_0425)
	endlist
};

u8 func0422_intro_0425[] = {
	if_controller_button_pressed(/*goto*/ 0x36)
	camera_movement(0x00ff)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	show_object(OBJ_JUMPSHIP1)
	set_object_flag3(OBJ_JUMPSHIP1, OBJFLAG3_00000010)
	object_do_animation(0x0100, OBJ_JUMPSHIP1, 0x04, 0xffff)
	object_do_animation(0x0102, OBJ_BANNER1, 0x04, 0xffff)
	object_do_animation(0x0117, OBJ_BANNER2, 0x04, 0xffff)

	wait_for_camera_finished

	label(0x06)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	hide_object(OBJ_JUMPSHIP1)
	hide_object(OBJ_BANNER1)
	hide_object(OBJ_BANNER2)
	label(0x36)
	set_ailist(CHR_SELF, AILIST_INTRO_0423)
	endlist
};

u8 func0422_intro_0426[] = {
	if_controller_button_pressed(/*goto*/ 0x36)
	camera_movement(0x012e)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	show_object(OBJ_JUMPSHIP1)
	set_object_flag3(OBJ_JUMPSHIP1, OBJFLAG3_00000010)
	object_do_animation(0x012f, OBJ_JUMPSHIP1, 0x04, 0xffff)
	show_object(OBJ_BANNER1)
	set_object_flag3(OBJ_BANNER1, OBJFLAG3_00000010)
	object_do_animation(0x0131, OBJ_BANNER1, 0x04, 0xffff)
	show_object(OBJ_BANNER2)
	set_object_flag3(OBJ_BANNER1, OBJFLAG3_00000010)
	object_do_animation(0x0132, OBJ_BANNER2, 0x04, 0xffff)

	wait_for_camera_finished

	label(0x06)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	hide_object(OBJ_JUMPSHIP1)
	hide_object(OBJ_BANNER1)
	hide_object(OBJ_BANNER2)
	label(0x36)
	set_ailist(CHR_SELF, AILIST_INTRO_0429)
	endlist
};

u8 func0422_intro_0427[] = {
	if_controller_button_pressed(/*goto*/ 0x36)
	camera_movement(0x0133)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	show_object(OBJ_JUMPSHIP1)
	set_object_flag3(OBJ_JUMPSHIP1, OBJFLAG3_00000010)
	object_do_animation(0x0134, OBJ_JUMPSHIP1, 0x04, 0xffff)
	show_object(OBJ_ROPE)
	set_object_flag3(OBJ_ROPE, OBJFLAG3_00000010)
	object_do_animation(0x0135, OBJ_ROPE, 0x04, 0xffff)
	show_object(OBJ_BANNER1)
	set_object_flag3(OBJ_BANNER1, OBJFLAG3_00000010)
	object_do_animation(0x0136, OBJ_BANNER1, 0x04, 0xffff)
	show_object(OBJ_BANNER2)
	set_object_flag3(OBJ_BANNER1, OBJFLAG3_00000010)
	object_do_animation(0x0137, OBJ_BANNER2, 0x04, 0xffff)

	wait_for_camera_finished

	label(0x06)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	hide_object(OBJ_JUMPSHIP1)
	hide_object(OBJ_ROPE)
	hide_object(OBJ_BANNER1)
	hide_object(OBJ_BANNER2)
	label(0x36)
	set_ailist(CHR_SELF, AILIST_INTRO_042A)
	endlist
};

u8 func0422_intro_0428[] = {
	if_controller_button_pressed(/*goto*/ 0x36)
	camera_movement(0x0103)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	show_object(OBJ_JUMPSHIP1)
	set_object_flag3(OBJ_JUMPSHIP1, OBJFLAG3_00000010)
	object_do_animation(0x0104, OBJ_JUMPSHIP1, 0x04, 0xffff)
	set_object_flag2(OBJ_HOVERCOP1, OBJFLAG2_INVISIBLE)
	set_object_flag2(OBJ_HOVERCOP2, OBJFLAG2_INVISIBLE)
	set_object_flag2(OBJ_HOVERCAR1, OBJFLAG2_INVISIBLE)
	set_object_flag2(OBJ_HOVERCAR2, OBJFLAG2_INVISIBLE)
	set_object_flag2(OBJ_HOVERMOTO1, OBJFLAG2_INVISIBLE)
	set_object_flag2(OBJ_HOVERMOTO2, OBJFLAG2_INVISIBLE)
	set_object_flag2(OBJ_HOVERTRUCK1, OBJFLAG2_INVISIBLE)
	set_object_flag2(OBJ_HOVERTRUCK2, OBJFLAG2_INVISIBLE)
	set_object_flag2(OBJ_HOVERCAB1, OBJFLAG2_INVISIBLE)
	set_object_flag2(OBJ_HOVERCAB2, OBJFLAG2_INVISIBLE)

	wait_for_camera_finished

	label(0x06)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	hide_object(OBJ_JUMPSHIP1)
	unset_object_flag2(OBJ_HOVERCOP1, OBJFLAG2_INVISIBLE)
	unset_object_flag2(OBJ_HOVERCOP2, OBJFLAG2_INVISIBLE)
	unset_object_flag2(OBJ_HOVERCAR1, OBJFLAG2_INVISIBLE)
	unset_object_flag2(OBJ_HOVERCAR2, OBJFLAG2_INVISIBLE)
	unset_object_flag2(OBJ_HOVERMOTO1, OBJFLAG2_INVISIBLE)
	unset_object_flag2(OBJ_HOVERMOTO2, OBJFLAG2_INVISIBLE)
	unset_object_flag2(OBJ_HOVERTRUCK1, OBJFLAG2_INVISIBLE)
	unset_object_flag2(OBJ_HOVERTRUCK2, OBJFLAG2_INVISIBLE)
	unset_object_flag2(OBJ_HOVERCAB1, OBJFLAG2_INVISIBLE)
	unset_object_flag2(OBJ_HOVERCAB2, OBJFLAG2_INVISIBLE)
	label(0x36)
	set_ailist(CHR_SELF, AILIST_INTRO_0424)
	endlist
};

u8 func0422_intro_0429[] = {
	if_controller_button_pressed(/*goto*/ 0x36)
	camera_movement(0x0105)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	show_object(OBJ_JUMPSHIP1)
	set_object_flag3(OBJ_JUMPSHIP1, OBJFLAG3_00000010)
	object_do_animation(0x0106, OBJ_JUMPSHIP1, 0x04, 0xffff)
	set_tinted_glass_enabled(TRUE)

	wait_for_camera_finished

	label(0x06)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	hide_object(OBJ_JUMPSHIP1)
	set_tinted_glass_enabled(FALSE)
	label(0x36)
	set_ailist(CHR_SELF, AILIST_INTRO_0427)
	endlist
};

u8 func0422_intro_042a[] = {
	if_controller_button_pressed(/*goto*/ 0x36)
	camera_movement(0x0107)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	show_object(OBJ_JUMPSHIP1)
	set_object_flag3(OBJ_JUMPSHIP1, OBJFLAG3_00000010)
	object_do_animation(0x0108, OBJ_JUMPSHIP1, 0x04, 0xffff)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x0109, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	set_chr_hudpiece_visible(CHR_BOND, TRUE)
	show_object(OBJ_ROPE)
	set_object_flag3(OBJ_ROPE, OBJFLAG3_00000010)
	object_do_animation(0x010a, OBJ_ROPE, 0x04, 0xffff)

	wait_for_camera_finished

	label(0x06)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	hide_object(OBJ_JUMPSHIP1)
	hide_object(OBJ_ROPE)
	label(0x36)
	set_ailist(CHR_SELF, AILIST_INTRO_042B)
	endlist
};

u8 func0422_intro_042b[] = {
	if_controller_button_pressed(/*goto*/ 0x36)
	camera_movement(0x010b)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	show_object(OBJ_JUMPSHIP1)
	set_object_flag3(OBJ_JUMPSHIP1, OBJFLAG3_00000010)
	object_do_animation(0x010c, OBJ_JUMPSHIP1, 0x04, 0xffff)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x010d, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	set_chr_hudpiece_visible(CHR_BOND, TRUE)
	show_object(OBJ_ROPE)
	set_object_flag3(OBJ_ROPE, OBJFLAG3_00000010)
	object_do_animation(0x010e, OBJ_ROPE, 0x04, 0xffff)
	show_object(OBJ_BANNER1)
	set_object_flag3(OBJ_BANNER1, OBJFLAG3_00000010)
	object_do_animation(0x010f, OBJ_BANNER1, 0x04, 0xffff)
	show_object(OBJ_BANNER2)
	set_object_flag3(OBJ_BANNER1, OBJFLAG3_00000010)
	object_do_animation(0x0118, OBJ_BANNER2, 0x04, 0xffff)

	wait_for_camera_finished

	label(0x06)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	hide_object(OBJ_JUMPSHIP1)
	hide_object(OBJ_ROPE)
	hide_object(OBJ_BANNER1)
	hide_object(OBJ_BANNER2)
	label(0x36)
	set_ailist(CHR_SELF, AILIST_INTRO_042C)
	endlist
};

u8 func0422_intro_042c[] = {
	set_ailist(CHR_SELF, AILIST_INTRO_042D)
	endlist
};

u8 func0422_intro_042d[] = {
	camera_movement(0x0155)
	cmd0175(60)
	if_controller_button_pressed(/*goto*/ 0x36)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x0156, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	set_chr_hudpiece_visible(CHR_BOND, FALSE)

	wait_for_camera_finished

	label(0x06)
	label(0x36)
	show_object(OBJ_BANNER1)
	show_object(OBJ_BANNER2)
	set_object_flag3(OBJ_BANNER1, OBJFLAG3_00000010)
	object_do_animation(0x0161, OBJ_BANNER1, 0x08, 0xffff)

	// @bug: Copy/paste error - should be banner 2
	set_object_flag3(OBJ_BANNER1, OBJFLAG3_00000010)
	object_do_animation(0x0162, OBJ_BANNER2, 0x08, 0xffff)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x0156, -2, -1, 0x06, 0x00, CHR_BOND, 2)
	set_chr_hudpiece_visible(CHR_BOND, FALSE)
	mute_channel(CHANNEL_7)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_5)
	set_ailist(CHR_SECRETARY, AILIST_INIT_SECRETARY)
	enter_firstperson
	set_stage_flag(STAGEFLAG_STOP_INTRO)
	restart_timer

	beginloop(0x09)
		if_timer_gt(90, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	restart_default_music
	reset_ambience
	set_savefile_flag(SAVEFILEFLAG_CI_TOUR_DONE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0416_outro_from_menu[] = {
	set_ailist(CHR_SELF, AILIST_OUTRO)
	endlist
};

u8 func0416_outro[] = {
	camera_movement(0x00f2)
	set_music_track(MUSIC_DEFECTION_OUTRO)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0xf1, CHRCFLAG_HIDDEN)
	set_ailist(CHR_P1P2, GAILIST_IDLE)
	set_chr_chrflag(CHR_P1P2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_P1P2, CHRHFLAG_00020000)
	chr_do_animation(0x00f3, -1, -1, 0x06, 0x00, CHR_P1P2, 4)
	restart_timer
	unset_stage_flag(STAGEFLAG_LAB_ELEVATOR_CLOSED)
	set_door_open(OBJ_LABLIFTDOOR1)
	set_door_open(OBJ_LABLIFTDOOR2)
	restart_timer
	set_cutscene_weapon(CHR_P1P2, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_P1P2, WEAPON_FALCON2_SILENCER, WEAPON_NONE)
	show_nonessential_chrs(FALSE)

	beginloop(0xb6)
		if_controller_button_pressed(/*goto*/ 0xbd)
		if_timer_gt(40, /*goto*/ 0x06)
	endloop(0xb6)

	label(0x06)
	play_sound(0x0165, CHANNEL_10)

	beginloop(0xb7)
		if_controller_button_pressed(/*goto*/ 0xbd)
		if_timer_gt(110, /*goto*/ 0x06)
	endloop(0xb7)

	label(0x06)
	play_sound(0x0167, CHANNEL_10)

	beginloop(0xb8)
		if_controller_button_pressed(/*goto*/ 0xbd)
		if_timer_gt(123, /*goto*/ 0x06)
	endloop(0xb8)

	label(0x06)
	play_sound(0x01dc, CHANNEL_10)

	beginloop(0xb9)
		if_controller_button_pressed(/*goto*/ 0xbd)
		if_timer_gt(215, /*goto*/ 0x06)
	endloop(0xb9)

	label(0x06)
	play_sound(0x01d8, CHANNEL_10)

	beginloop(0xba)
		if_controller_button_pressed(/*goto*/ 0xbd)
		if_timer_gt(245, /*goto*/ 0x06)
	endloop(0xba)

	label(0x06)
	play_sound(0x01da, CHANNEL_10)

	beginloop(0xbb)
		if_controller_button_pressed(/*goto*/ 0xbd)
		if_timer_gt(250, /*goto*/ 0x06)
	endloop(0xbb)

	label(0x06)
	play_sound(0x80f6, CHANNEL_10)

	beginloop(0xbc)
		if_controller_button_pressed(/*goto*/ 0xbd)
		if_timer_gt(285, /*goto*/ 0x06)
	endloop(0xbc)

	label(0x06)
	play_sound(0x01db, CHANNEL_10)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2c)
		goto_next(0xbd)

		label(0x2c)
		if_controller_button_pressed(/*goto*/ 0xbd)
		if_stage_flag_eq(STAGEFLAG_LAB_ELEVATOR_CLOSED, TRUE, /*goto*/ 0x2c)
		if_timer_lt(336, /*goto*/ 0x2c)
		close_door(OBJ_LABLIFTDOOR1)
		close_door(OBJ_LABLIFTDOOR2)
		set_stage_flag(STAGEFLAG_LAB_ELEVATOR_CLOSED)
		label(0x2c)
	endloop(0x08)

	label(0xbd)
	mute_channel(CHANNEL_10)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1000_rebuild_groups[] = {
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func1401_setup_counterop[] = {
	noop016c
	yield
	set_chr_team(CHR_ANTI, TEAM_ENEMY)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func100f_check_necklace_collected[] = {
	beginloop(0x04)
		if_chr_has_object(CHR_BOND, OBJ_NECKLACE, /*goto*/ 0x2c)
		if_chr_has_object(CHR_COOP, OBJ_NECKLACE, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	remove_cass_necklace(CHR_CASS)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1003_start_intro[] = {
	set_ailist(CHR_SELF, AILIST_INTRO)
	endlist
};

u8 func1010_start_hub_humms[] = {
	yield
	play_sound_from_object2(CHANNEL_0, OBJ_SECURITYHUB, 0x8111, 0x0f, 0x02)
	yield
	play_sound_from_object2(CHANNEL_1, OBJ_EXTCOMMSHUB, 0x8111, 0x0f, 0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1011_check_hubs_activated[] = {
	beginloop(0x04)
		if_chr_activated_object(CHR_ANY, OBJ_SECURITYHUB, /*goto*/ 0x08)
		if_chr_activated_object(CHR_ANY, OBJ_EXTCOMMSHUB, /*goto*/ 0x0a)
		reloop(0x04)

		label(0x08)
		show_hudmsg(CHR_BOND, L_AME(80)) // "ECM Mine needed to disable security hub."
		restart_timer

		beginloop(0x09)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x09)

		label(0x0a)
		show_hudmsg(CHR_BOND, L_AME(81)) // "ECM Mine needed to disable comms hub."
		restart_timer

		beginloop(0x0b)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x0b)

		label(0x06)
	endloop(0x04)

	endlist
};

u8 func1012_trigger_x_music[] = {
	// Wait until arriving at bottom floor
	beginloop(0x04)
		if_camera_animating(/*goto*/ 0x2c)
		if_chr_y(CHR_BOND, -8000, OPERATOR_LESS_THAN, /*goto*/ 0x06)
		if_chr_y(CHR_COOP, -8000, OPERATOR_LESS_THAN, /*goto*/ 0x06)
		label(0x2c)
	endloop(0x04)

	// This stage flag check seems a bit weird, but it makes sense if Rare were
	// testing the outro in isolation of the rest of the stage. They obviously
	// didn't want the X music playing during the outro while testing. Note that
	// the flag is only set during the outro cutscene, not during gameplay.
	label(0x06)
	if_stage_flag_eq(STAGEFLAG_LAB_ELEVATOR_CLOSED, TRUE, /*goto*/ 0x2c)
	play_x_music(CHANNEL_10, 60)
	label(0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define init_guard(accuracy, health) \
	set_chr_dodge_rating(2, 0x14) \
	set_unarmeddodgerating(0) \
	set_accuracy(accuracy) \
	set_reaction_speed(0) \
	set_chr_maxdamage(CHR_SELF, health) \
	add_health_or_armor(0) \
	set_recovery_speed(0) \
	set_shield(0)



u8 func0417_init_dd_guard[] = {
	init_guard(0, 40)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func0418_init_shock_guard[] = {
	if_difficulty_gt(DIFF_A, /*goto*/ 0x2c)

	// Agent
	init_guard(10, 40)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)

	// SA and PA
	label(0x2c)
	init_guard(20, 40)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func0430_init_falcon_guard[] = {
	if_difficulty_gt(DIFF_A, /*goto*/ 0x2c)

	// Agent
	init_guard(20, 40)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)

	// SA and PA
	label(0x2c)
	init_guard(30, 60)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func1013_msg_commshubnearby[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0d)

	beginloop(0x04)
		if_chr_y(CHR_BOND, -770, OPERATOR_LESS_THAN, /*goto*/ 0x2c)
		reloop(0x04)

		label(0x2c)
		if_chr_in_room(CHR_BOND, 0x00, 0x0039, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	speak(CHR_BOND, L_AME(93), 0x8170, CHANNEL_6, COLOR_09_BLUE) // "We're getting a positive reading - the internal co..."
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1014_msg_officefloor[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0d)

	beginloop(0x04)
		if_chr_in_room(CHR_BOND, 0x00, 0x0054, /*goto*/ 0x2c)
		if_chr_in_room(CHR_BOND, 0x00, 0x0064, /*goto*/ 0x0d)
	endloop(0x04)

	label(0x2c)
	speak(CHR_BOND, L_AME(94), 0x8171, CHANNEL_6, COLOR_09_BLUE) // "You're on the same floor as Cassandra's office."
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1015_msg_securityroom[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0d)

	beginloop(0x04)
		if_chr_in_room(CHR_BOND, 0x00, 0x0025, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	speak(CHR_BOND, L_AME(95), 0x73a2, CHANNEL_6, COLOR_09_BLUE) // "The other hub has got to be in the Security Room."
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1016_msg_basementelevator[] = {
	beginloop(0x04)
		if_chr_in_room(CHR_BOND, 0x00, 0x002c, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	speak(CHR_BOND, L_AME(96), 0x8172, CHANNEL_6, COLOR_09_BLUE) // "The basement elevator must be around there somewhe..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1017_unlock_basement_door[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2c)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Agent only - unlock basement door (SA and PA requires necklace)
	label(0x2c)
	unlock_door(OBJ_SECRETDOOR, 0x20)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Rare used stage flags to trigger the intro cutscene to restart.
 */
u8 func0422_intro_speaking[] = {
	label(0xbe)
	if_stage_flag_eq(STAGEFLAG_TRIGGER_INTRO, TRUE, /*goto*/ 0xbf)
	yield
	goto_first(0xbe)

	label(0xbf)
	unset_stage_flag(STAGEFLAG_TRIGGER_INTRO)
	restart_timer

#if VERSION == VERSION_PAL_FINAL
	beginloop(0xb7)
		if_stage_flag_eq(STAGEFLAG_STOP_INTRO, TRUE, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x2c)
	endloop(0xb7)

	label(0x2c)
	set_sfx_track(MUSIC_DEFECTION_INTRO_SFX)

	// No yield in this loop!
	label(0xb8)
	cmd01dd_if_something(0x10, /*goto*/ 0x2c)
	misc_command(0x0000, 0x0b, 0x00)
	goto_first(0xb8)

	label(0x2c)
	set_music_track(MUSIC_DEFECTION_INTRO)

	label(0xb9)
	cmd01dd_if_something(0x01, /*goto*/ 0x2c)
	misc_command(0x0000, 0x0b, 0x00)
	goto_first(0xb9)

	label(0x2c)
#endif

	beginloop(0xb6)
		if_stage_flag_eq(STAGEFLAG_STOP_INTRO, TRUE, /*goto*/ 0x06)
		if_timer_gt(700, /*goto*/ 0x2c)
	endloop(0xb6)

	label(0x2c)
	speak(CHR_BOND, L_AME(100), 0x73e4, CHANNEL_6, COLOR_09_BLUE) // "Why the big hurry?"

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_STOP_INTRO, TRUE, /*goto*/ 0x06)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2c)
	endloop(0x08)

	label(0x2c)
	speak(CHR_BOND, L_AME(101), 0x73e5, CHANNEL_6, COLOR_06_WHITE) // "If Dr. Caroll is not extracted tonight, dataDyne w..."

	beginloop(0x09)
		if_stage_flag_eq(STAGEFLAG_STOP_INTRO, TRUE, /*goto*/ 0x06)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2c)
	endloop(0x09)

	label(0x2c)
	speak(CHR_BOND, L_AME(102), 0x73e6, CHANNEL_6, COLOR_09_BLUE) // "Are they all expendable?"

	beginloop(0x0a)
		if_stage_flag_eq(STAGEFLAG_STOP_INTRO, TRUE, /*goto*/ 0x06)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2c)
	endloop(0x0a)

	label(0x2c)
	speak(CHR_BOND, L_AME(103), 0x73e7, CHANNEL_6, COLOR_06_WHITE) // "Don't joke! You have to be careful, Joanna. Code k..."

	beginloop(0x0b)
		if_stage_flag_eq(STAGEFLAG_STOP_INTRO, TRUE, /*goto*/ 0x06)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2c)
	endloop(0x0b)

	label(0x2c)
	speak(CHR_BOND, L_AME(104), 0x73e8, CHANNEL_6, COLOR_09_BLUE) // "What's the target location?"

	beginloop(0x0c)
		if_stage_flag_eq(STAGEFLAG_STOP_INTRO, TRUE, /*goto*/ 0x06)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2c)
	endloop(0x0c)

	label(0x2c)
	speak(CHR_BOND, L_AME(105), 0x73e9, CHANNEL_6, COLOR_06_WHITE) // "Work your way down the building to the ground leve..."

	beginloop(0x0d)
		if_stage_flag_eq(STAGEFLAG_STOP_INTRO, TRUE, /*goto*/ 0x06)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2c)
	endloop(0x0d)

	label(0x2c)
	speak(CHR_BOND, L_AME(106), 0x73ea, CHANNEL_6, COLOR_09_BLUE) // "How will I recognize him?"

	beginloop(0x0e)
		if_stage_flag_eq(STAGEFLAG_STOP_INTRO, TRUE, /*goto*/ 0x06)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2c)
	endloop(0x0e)

	label(0x2c)
	speak(CHR_BOND, L_AME(107), 0x73eb, CHANNEL_6, COLOR_06_WHITE) // "We don't have an image record, and we can't find a..."

	beginloop(0x0f)
		if_stage_flag_eq(STAGEFLAG_STOP_INTRO, TRUE, /*goto*/ 0x06)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2c)
	endloop(0x0f)

	label(0x2c)
	label(0x06)
	mute_channel(CHANNEL_6)
	goto_first(0xbe)

	endlist
};

/**
 * Hide guards, then unhide then once you pass below -2000. This is likely the
 * first staircase between the light switch room and Cass's office floor.
 */
u8 func1019_toggle_guards[] = {
	label(0x2c)
	hide_chr(0x01)
	hide_chr(0x02)
	hide_chr(0x0e)
	hide_chr(0x12)
	hide_chr(0x0f)
	hide_chr(0x10)
	hide_chr(0x11)
	hide_chr(0x13)
	hide_chr(0x03)
	hide_chr(0x04)
	hide_chr(0x14)
	hide_chr(0x15)
	hide_chr(0x16)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_y(CHR_P1P2, -2000, OPERATOR_LESS_THAN, /*goto*/ 0x2c)
	endloop(0x04)

	label(0x2c)
	show_chr(0x01)
	yield
	show_chr(0x02)
	yield
	show_chr(0x0e)
	yield
	show_chr(0x12)
	yield
	show_chr(0x0f)
	yield
	show_chr(0x10)
	yield
	show_chr(0x11)
	yield
	show_chr(0x13)
	yield
	show_chr(0x03)
	yield
	show_chr(0x04)
	yield
	show_chr(0x14)
	yield
	show_chr(0x15)
	yield
	show_chr(0x16)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101a_noop[] = {
	yield
	yield
	yield
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func141c_start_lifts[] = {
	activate_lift(2, OBJ_LIFT1)
	activate_lift(1, OBJ_LIFT2)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101d_disable_cameras[] = {
	// Check security hub objective
	beginloop(0xc4)
		if_objective_complete(0, /*goto*/ 0x2c)
	endloop(0xc4)

	label(0x2c)
	set_object_flag(OBJ_CAMERA1, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_CAMERA2, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_CAMERA3, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_CAMERA4, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_CAMERA5, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_CAMERA6, OBJFLAG_DEACTIVATED)
	set_stage_flag(STAGEFLAG_SECURITY_DISABLED)
	restart_timer

	// @bug: If you disable the security (bottom floor), then activate the alarm
	// before the 2 minute timer expires (eg. by getting Cass to activate it),
	// then the first camera is never reactivated. The if_alarm_active check
	// should go to 0x2c instead.
	beginloop(0x08)
		if_alarm_active(/*goto*/ 0x06)
		if_timer_gt(7200, /*goto*/ 0x2c)
	endloop(0x08)

	// 2 minutes elapsed
	label(0x2c)
	if_object_in_good_condition(OBJ_CAMERA1, /*goto*/ 0x2c)
	goto_next(0x06)
	label(0x2c)
	unset_object_flag(OBJ_CAMERA1, OBJFLAG_DEACTIVATED)

	label(0x06)
	if_object_in_good_condition(OBJ_CAMERA2, /*goto*/ 0x2c)
	goto_next(0x06)
	label(0x2c)
	unset_object_flag(OBJ_CAMERA2, OBJFLAG_DEACTIVATED)

	label(0x06)
	if_object_in_good_condition(OBJ_CAMERA3, /*goto*/ 0x2c)
	goto_next(0x06)
	label(0x2c)
	unset_object_flag(OBJ_CAMERA3, OBJFLAG_DEACTIVATED)

	label(0x06)
	if_object_in_good_condition(OBJ_CAMERA4, /*goto*/ 0x2c)
	goto_next(0x06)
	label(0x2c)
	unset_object_flag(OBJ_CAMERA4, OBJFLAG_DEACTIVATED)

	label(0x06)
	if_object_in_good_condition(OBJ_CAMERA5, /*goto*/ 0x2c)
	goto_next(0x06)
	label(0x2c)
	unset_object_flag(OBJ_CAMERA5, OBJFLAG_DEACTIVATED)

	label(0x06)
	if_object_in_good_condition(OBJ_CAMERA6, /*goto*/ 0x2c)
	goto_next(0x06)
	label(0x2c)
	unset_object_flag(OBJ_CAMERA6, OBJFLAG_DEACTIVATED)

	label(0x06)
	show_hudmsg(CHR_BOND, L_AME(97)) // "Security system is now back online."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * @unregistered
 */
u8 unregistered_function7[] = {
	show_hudmsg(CHR_BOND, L_AME(99)) // "2023 AD, 2214 Hours Lucerne Tower - dataDyne HQ"
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101e_lift_door_sounds[] = {
	beginloop(0xc4)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_LIFT1DOOR1, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, OBJ_LIFT1DOOR2, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, OBJ_LIFT1DOOR3, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, OBJ_LIFT1DOOR4, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, OBJ_LIFT2DOOR1, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, OBJ_LIFT2DOOR2, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, OBJ_LIFT2DOOR3, /*goto*/ 0x2c)
		if_chr_activated_object(CHR_P1P2, OBJ_LIFT2DOOR4, /*goto*/ 0x2c)
		reloop(0xc4)

		label(0x2c)
		play_sound(0x81b0, -1)
		restart_timer

		beginloop(0x08)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x08)

		label(0x06)
	endloop(0xc4)

	endlist
};

/**
 * @unused
 */
u8 func042e_init_surrendering_guard[] = {
	label(0xc4)
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_SURRENDERING_GUARD)
	endlist
};

/**
 * @unused
 */
u8 func042f_surrendering_guard[] = {
	// Wait for player detection
	beginloop(0xc4)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x2c)
		if_enemy_distance_lt_and_los(500, /*goto*/ 0x2c)
		if_near_miss(/*goto*/ 0x2c)
		if_saw_injury(0x00, /*goto*/ 0x2c)
	endloop(0xc4)

	// Be surprised
	label(0x2c)
	say_quip(CHR_BOND, 0x12, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00) // "What the?!","Who the?!"
	chr_do_animation(ANIM_SURPRISED_0202, 0, -1, 0x00, 0x10, CHR_SELF, 2)

	// Wait 1 second
	beginloop(0x08)
		dprint 'S','4',0,
		if_timer_gt(60, /*goto*/ 0x2c)
	endloop(0x08)

	label(0x2c)
	try_set_chrpreset_to_unalerted_teammate(0, /*goto*/ 0x54)
	goto_next(0x55)

	label(0x54)
	try_run_to_chr(CHR_PRESET, /*goto*/ 0x56)

	beginloop(0x56)
		if_distance_to_target_gt(300, /*goto*/ 0x06)
		if_chr_in_view(/*goto*/ 0x28)
		label(0x06)
		if_chr_death_animation_finished(CHR_PRESET, /*goto*/ 0x55)
		if_chr_unloaded(CHR_PRESET, /*goto*/ 0x55)
		if_detected_chr(CHR_PRESET, /*goto*/ 0x57)
		if_chr_stopped(/*goto*/ 0x57)
	endloop(0x56)

	// Warn
	label(0x57)
	dprint 'W','A','R','N',' ','F','R','I','E','N','D','S','\n',0,
	say_quip(CHR_BOND, 0x10, 0xff, 0x02, 0xff, BANK_0, 0x00, 0x00) // "Intruder alert!","We've got trouble","We've got problems"
	increase_squadron_alertness(100)

	// No chr in same group, or follow through from above
	// Wait until player in range and then surrender.
	beginloop(0x55)
		if_distance_to_target_gt(300, /*goto*/ 0x06)
		if_chr_in_view(/*goto*/ 0x28)
		label(0x06)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x58)
	endloop(0x55)

	label(0x58)
	restart_timer
	retreat(SPEED_RUN, 2)

	beginloop(0x0a)
		if_distance_to_target_gt(300, /*goto*/ 0x06)
		if_chr_in_view(/*goto*/ 0x28)
		label(0x06)
		if_timer_gt(600, /*goto*/ 0x2c)
	endloop(0x0a)

	label(0x2c)
	stop_chr
	goto_first(0x55)

	// Surrender
	label(0x28)
	surrender
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101f_setup_rtracker[] = {
	yield
	set_object_flag3(OBJ_FALCONSIL1, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(OBJ_FALCONSIL2, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(OBJ_LAPTOPGUN, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1420_setup_portals[] = {
	yield
	set_portal_flag(0x008e, 0x08)
	set_portal_flag(0x008f, 0x08)
	set_portal_flag(0x0084, 0x08)
	set_portal_flag(0x0090, 0x08)
	set_portal_flag(0x0091, 0x08)
	set_portal_flag(0x0093, 0x08)
	set_portal_flag(0x0096, 0x08)
	set_portal_flag(0x0095, 0x08)
	set_portal_flag(0x0099, 0x08)
	set_portal_flag(0x00b6, 0x08)
	set_portal_flag(0x00bf, 0x08)
	set_portal_flag(0x00be, 0x08)
	set_portal_flag(0x00c0, 0x08)
	set_portal_flag(0x00c2, 0x08)
	set_portal_flag(0x00c4, 0x08)
	set_portal_flag(0x00c8, 0x08)
	set_portal_flag(0x00c7, 0x08)
	set_portal_flag(0x00c9, 0x08)
	set_portal_flag(0x00cd, 0x08)
	set_portal_flag(0x00ce, 0x08)
	set_portal_flag(0x00d2, 0x08)
	set_portal_flag(0x00e0, 0x08)
	set_portal_flag(0x00dc, 0x08)
	set_portal_flag(0x00de, 0x08)
	set_portal_flag(0x00e3, 0x08)
	set_portal_flag(0x00e5, 0x08)
	set_portal_flag(0x00e7, 0x08)
	set_portal_flag(0x00fb, 0x08)
	set_portal_flag(0x00fa, 0x08)
	set_portal_flag(0x00fc, 0x08)
	set_portal_flag(0x00ff, 0x08)
	set_portal_flag(0x0100, 0x08)
	set_portal_flag(0x0103, 0x08)
	set_portal_flag(0x0102, 0x08)
	set_portal_flag(0x0104, 0x08)
	set_portal_flag(0x0109, 0x08)
	set_portal_flag(0x010c, 0x08)
	set_portal_flag(0x0119, 0x08)
	set_portal_flag(0x0112, 0x08)
	set_portal_flag(0x0117, 0x08)
	set_portal_flag(0x0120, 0x08)
	set_portal_flag(0x011e, 0x08)
	set_portal_flag(0x011c, 0x08)
	set_portal_flag(0x0108, 0x08)
	set_portal_flag(0x006f, 0x08)
	set_portal_flag(0x007d, 0x08)
	set_portal_flag(0x0080, 0x08)
	set_portal_flag(0x0081, 0x08)
	set_portal_flag(0x0075, 0x08)
	set_portal_flag(0x0078, 0x08)
	set_portal_flag(0x0079, 0x08)
	set_portal_flag(0x0006, 0x08)
	set_portal_flag(0x0004, 0x08)
	set_portal_flag(0x0008, 0x08)
	set_portal_flag(0x000a, 0x08)
	set_portal_flag(0x0001, 0x08)
	set_portal_flag(0x0005, 0x08)
	set_portal_flag(0x0000, 0x08)
	set_portal_flag(0x0003, 0x08)
	set_portal_flag(0x0007, 0x08)
	set_portal_flag(0x0013, 0x08)
	set_portal_flag(0x0009, 0x08)
	set_portal_flag(0x00b1, 0x08)
	set_portal_flag(0x00ef, 0x08)
	set_portal_flag(0x00ee, 0x08)
	set_portal_flag(0x0121, 0x08)
	set_portal_flag(0x00e8, 0x08)
	set_portal_flag(0x00e9, 0x08)
	set_portal_flag(0x00ea, 0x08)
	set_portal_flag(0x00ec, 0x08)
	set_portal_flag(0x00eb, 0x08)
	set_portal_flag(0x00ed, 0x08)
	set_portal_flag(0x009d, 0x08)
	set_portal_flag(0x00af, 0x08)
	set_portal_flag(0x00a1, 0x08)
	set_portal_flag(0x005a, 0x08)
	set_portal_flag(0x005c, 0x08)
	set_portal_flag(0x005d, 0x08)
	set_portal_flag(0x0060, 0x08)
	set_portal_flag(0x0034, 0x08)
	set_portal_flag(0x0030, 0x08)
	set_portal_flag(0x002e, 0x08)
	set_portal_flag(0x002b, 0x08)
	set_portal_flag(0x0028, 0x08)
	set_portal_flag(0x0025, 0x08)
	set_portal_flag(0x0036, 0x08)
	set_portal_flag(0x0038, 0x08)
	set_portal_flag(0x004f, 0x08)
	set_portal_flag(0x0051, 0x08)
	set_portal_flag(0x0052, 0x08)
	set_portal_flag(0x0057, 0x08)
	set_portal_flag(0x0058, 0x08)
	set_portal_flag(0x0031, 0x08)
	set_portal_flag(0x002f, 0x08)
	set_portal_flag(0x0023, 0x08)
	set_portal_flag(0x00a6, 0x08)
	set_portal_flag(0x00a3, 0x08)
	set_portal_flag(0x00a2, 0x08)
	set_portal_flag(0x00a4, 0x08)
	set_portal_flag(0x0087, 0x08)
	set_portal_flag(0x00b9, 0x08)
	set_portal_flag(0x00b4, 0x08)
	set_portal_flag(0x00b2, 0x08)
	set_portal_flag(0x00b3, 0x08)
	set_portal_flag(0x00bd, 0x08)
	set_portal_flag(0x00f4, 0x08)
	set_portal_flag(0x00f2, 0x08)
	set_portal_flag(0x00f0, 0x08)
	set_portal_flag(0x00f8, 0x08)
	set_portal_flag(0x00f1, 0x08)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1421_setup_lighting[] = {
	yield
	misc_command(0x0000, 0x00, 0x01)
	misc_command(0x0000, 0x01, 0x00)
	misc_command(0x0000, 0x02, 0x00)
	misc_command(0x0000, 0x03, 0x00)
	misc_command(0x0000, 0x04, 0x00)
	misc_command(0x0002, 0x05, 0x01)
	misc_command(0x0002, 0x06, 0x01)
	misc_command(0x0003, 0x05, 0x01)
	misc_command(0x0003, 0x06, 0x01)
	misc_command(0x0004, 0x05, 0x01)
	misc_command(0x0004, 0x06, 0x01)
	misc_command(0x0005, 0x06, 0x01)
	misc_command(0x0006, 0x06, 0x01)
	misc_command(0x0007, 0x06, 0x01)
	misc_command(0x0008, 0x06, 0x01)
	misc_command(0x0009, 0x06, 0x01)
	misc_command(0x000a, 0x06, 0x01)
	misc_command(0x000b, 0x06, 0x01)
	misc_command(0x000c, 0x06, 0x01)
	misc_command(0x000d, 0x06, 0x01)
	misc_command(0x000e, 0x06, 0x01)
	misc_command(0x000f, 0x06, 0x01)
	misc_command(0x0010, 0x06, 0x01)
	misc_command(0x0011, 0x06, 0x01)
	misc_command(0x0012, 0x06, 0x01)
	misc_command(0x0013, 0x06, 0x01)
	misc_command(0x0014, 0x06, 0x01)
	misc_command(0x003a, 0x05, 0x01)
	misc_command(0x00a2, 0x06, 0x01)
	misc_command(0x00a4, 0x06, 0x01)
	misc_command(0x00a5, 0x06, 0x01)
	misc_command(0x00a7, 0x06, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 unregistered_function8[] = {
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

struct ailist ailists[] = {
	{ func0401_do_some_animation,        0x0401 },
	{ func0402_guard_with_chrflag,       0x0402 },
	{ func0403_shielded_guard,           0x0403 },
	{ func0404_init_hovercar,            0x0404 },
	{ func0405_start_path26,             0x0405 },
	{ func0406_start_path27,             0x0406 },
	{ func0407_start_path28,             0x0407 },
	{ func0408_start_path29,             0x0408 },
	{ func0409_start_path30,             0x0409 },
	{ func040a_start_path31,             0x040a },
	{ func040b_start_path32,             0x040b },
	{ func040c_start_path33,             0x040c },
	{ func040d_start_path34,             0x040d },
	{ func040e_start_path35,             0x040e },
	{ func040f_cass,                     0x040f },
	{ func0410_init_cass,                0x0410 },
	{ func0411_secretary,                0x0411 },
	{ func0412_init_secretary,           0x0412 },
	{ func0413_c318,                     0x0413 },
	{ func0414_programmer,               0x0414 },
	{ func0415_set_idle,                 0x0415 },
	{ func0419_intro_0419,               0x0419 },
	{ func041a_intro_041a,               0x041a },
	{ func041b_intro_041b,               0x041b },
	{ func041c_intro_041c,               0x041c },
	{ func041d_intro_041d,               0x041d },
	{ func041e_intro_041e,               0x041e },
	{ func041f_intro_041f,               0x041f },
	{ func0420_intro_0420,               0x0420 },
	{ func0421_intro_0421,               0x0421 },
	{ func0422_intro,                    0x0422 },
	{ func0422_intro_0423,               0x0423 },
	{ func0422_intro_0424,               0x0424 },
	{ func0422_intro_0425,               0x0425 },
	{ func0422_intro_0426,               0x0426 },
	{ func0422_intro_0427,               0x0427 },
	{ func0422_intro_0428,               0x0428 },
	{ func0422_intro_0429,               0x0429 },
	{ func0422_intro_042a,               0x042a },
	{ func0422_intro_042b,               0x042b },
	{ func0422_intro_042c,               0x042c },
	{ func0422_intro_042d,               0x042d },
	{ func042e_init_surrendering_guard,  0x042e },
	{ func042f_surrendering_guard,       0x042f },
	{ func0430_init_falcon_guard,        0x0430 },
	{ func0416_outro,                    0x0416 },
	{ func0417_init_dd_guard,            0x0417 },
	{ func0418_init_shock_guard,         0x0418 },
	{ func1000_rebuild_groups,           0x1000 },
	{ func1401_setup_counterop,          0x1401 },
	{ func1002_objectives_failed_msg,    0x1002 },
	{ func1003_start_intro,              0x1003 },
	{ func1004_check_lab_lift_located,   0x1004 },
	{ func1005_give_control,             0x1005 },
	{ func1006_check_programmer_dead,    0x1006 },
	{ func1007_uplinking,                0x1007 },
	{ func1008_doorswitch,               0x1008 },
	{ func1009_check_civilians_killed,   0x1009 },
	{ func100a_alarm_guard,              0x100a },
	{ func100b_lightswitch,              0x100b },
	{ func100c_noop2,                    0x100c },
	{ func100d_check_objects_destroyed,  0x100d },
	{ func100e_check_ecm_mines,          0x100e },
	{ func100f_check_necklace_collected, 0x100f },
	{ func1010_start_hub_humms,          0x1010 },
	{ func1011_check_hubs_activated,     0x1011 },
	{ func1012_trigger_x_music,          0x1012 },
	{ func1013_msg_commshubnearby,       0x1013 },
	{ func1014_msg_officefloor,          0x1014 },
	{ func1015_msg_securityroom,         0x1015 },
	{ func1016_msg_basementelevator,     0x1016 },
	{ func1017_unlock_basement_door,     0x1017 },
	{ func0422_intro_speaking,           0x1418 },
	{ func1019_toggle_guards,            0x1019 },
	{ func101a_noop,                     0x101a },
	{ func141c_start_lifts,              0x141c },
	{ func101d_disable_cameras,          0x101d },
	{ func101e_lift_door_sounds,         0x101e },
	{ func101f_setup_rtracker,           0x101f },
	{ func1420_setup_portals,            0x1420 },
	{ func1421_setup_lighting,           0x1421 },
	{ func0422_intro,                    0x0c00 },
	{ func0416_outro_from_menu,          0x0c01 },
	{ NULL, 0 },
};

struct path paths[] = {
	{ path00, 0, PATHTYPE_BACKANDFORTH },
	{ path01, 1, PATHTYPE_FLYING },
	{ path02, 2, PATHTYPE_FLYING },
	{ path03, 3, PATHTYPE_FLYING },
	{ path04, 4, PATHTYPE_FLYING },
	{ path05, 5, PATHTYPE_FLYING },
	{ path06, 6, PATHTYPE_FLYING },
	{ path07, 7, PATHTYPE_FLYING },
	{ path08, 8, PATHTYPE_FLYING },
	{ path09, 9, PATHTYPE_FLYING },
	{ path10, 10, PATHTYPE_FLYING },
	{ path11, 11, PATHTYPE_FLYING },
	{ path12, 12, PATHTYPE_FLYING },
	{ path13, 13, PATHTYPE_FLYING },
	{ path14, 14, PATHTYPE_FLYING },
	{ path15, 15, PATHTYPE_FLYING },
	{ path16, 16, PATHTYPE_FLYING },
	{ path17, 17, PATHTYPE_FLYING },
	{ path18, 18, PATHTYPE_FLYING },
	{ path19, 19, PATHTYPE_FLYING },
	{ path20, 20, PATHTYPE_FLYING },
	{ path21, 21, PATHTYPE_FLYING },
	{ path22, 22, PATHTYPE_FLYING },
	{ path23, 23, PATHTYPE_FLYING },
	{ path24, 24, PATHTYPE_FLYING },
	{ path25, 25, PATHTYPE_FLYING },
	{ path26, 26, PATHTYPE_CIRCULAR },
	{ path27, 27, PATHTYPE_BACKANDFORTH },
	{ path28, 28, PATHTYPE_BACKANDFORTH },
	{ path29, 29, PATHTYPE_BACKANDFORTH },
	{ path30, 30, PATHTYPE_CIRCULAR },
	{ path31, 31, PATHTYPE_BACKANDFORTH },
	{ path32, 32, PATHTYPE_BACKANDFORTH },
	{ path33, 33, PATHTYPE_BACKANDFORTH },
	{ path34, 34, PATHTYPE_CIRCULAR },
	{ path35, 35, PATHTYPE_BACKANDFORTH },
	{ NULL, 0, 0 },
};

