#include <ultra64.h>
#include "constants.h"
#include "types.h"

struct mpconfig g_MpConfigs[] = {
	// MPCONFIG_TEMPLE
	{
		"Temple",
		0,
		MPSCENARIO_COMBAT,
		STAGE_MP_TEMPLE,
		9, 100, 400,
		0,
		{
			MPWEAPON_DEVASTATOR,
			MPWEAPON_DEVASTATOR,
			MPWEAPON_SUPERDRAGON,
			MPWEAPON_SUPERDRAGON,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
		},
	},
	// MPCONFIG_PISTOLS
	{
		"Pistols",
		MPOPTION_ONEHITKILLS,
		MPSCENARIO_COMBAT,
		STAGE_MP_AREA52,
		60, 9, 400,
		0,
		{
			MPWEAPON_FALCON2,
			MPWEAPON_MAGSEC4,
			MPWEAPON_FALCON2_SILENCER,
			MPWEAPON_DY357MAGNUM,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
		},
	},
	// MPCONFIG_FARSIGHT
	{
		"FarSight",
		0,
		MPSCENARIO_COMBAT,
		STAGE_MP_COMPLEX,
		9, 19, 400,
		0,
		{
			MPWEAPON_MAGSEC4,
			MPWEAPON_CYCLONE,
			MPWEAPON_K7AVENGER,
			MPWEAPON_FARSIGHTXR20,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
		},
	},
	// MPCONFIG_DRUGGUN
	{
		"Drug Gun",
		0,
		MPSCENARIO_COMBAT,
		STAGE_MP_SKEDAR,
		9, 9, 400,
		0,
		{
			MPWEAPON_FALCON2,
			MPWEAPON_CMP150,
			MPWEAPON_DRAGON,
			MPWEAPON_TRANQUILIZER,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
		},
	},
	// MPCONFIG_SLAYER
	{
		"Slayer",
		0,
		MPSCENARIO_COMBAT,
		STAGE_MP_SKEDAR,
		9, 9, 400,
		0,
		{
			MPWEAPON_MAGSEC4,
			MPWEAPON_SHOTGUN,
			MPWEAPON_K7AVENGER,
			MPWEAPON_SLAYER,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
		},
	},
	// MPCONFIG_CLOAKING
	{
		"Cloaking",
		0,
		MPSCENARIO_COMBAT,
		STAGE_MP_SKEDAR,
		9, 9, 400,
		0,
		{
			MPWEAPON_MAULER,
			MPWEAPON_GRENADE,
			MPWEAPON_REAPER,
			MPWEAPON_SUPERDRAGON,
			MPWEAPON_SHIELD,
			MPWEAPON_CLOAKINGDEVICE,
		},
		{
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
		},
	},
	// MPCONFIG_SLOWMO
	{
		"SlowMo",
		MPOPTION_SLOWMOTION_ON,
		MPSCENARIO_COMBAT,
		STAGE_MP_SKEDAR,
		4, 9, 400,
		0,
		{
			MPWEAPON_MAGSEC4,
			MPWEAPON_SHOTGUN,
			MPWEAPON_SNIPERRIFLE,
			MPWEAPON_SUPERDRAGON,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
		},
	},
	// MPCONFIG_NOSHIELD
	{
		"No Shield",
		0,
		MPSCENARIO_COMBAT,
		STAGE_MP_SKEDAR,
		9, 9, 400,
		0,
		{
			MPWEAPON_FALCON2,
			MPWEAPON_MAGSEC4,
			MPWEAPON_CYCLONE,
			MPWEAPON_CMP150,
			MPWEAPON_AR34,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
		},
	},
	// MPCONFIG_BRIEFCASE
	{
		"Briefcase",
		MPOPTION_HTB_SHOWONRADAR | MPOPTION_HTB_HIGHLIGHTBRIEFCASE,
		MPSCENARIO_HOLDTHEBRIEFCASE,
		STAGE_MP_SKEDAR,
		9, 100, 400,
		0,
		{
			MPWEAPON_MAGSEC4,
			MPWEAPON_K7AVENGER,
			MPWEAPON_SHOTGUN,
			MPWEAPON_ROCKETLAUNCHER,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
		},
	},
	// MPCONFIG_SKEDARKING
	{
		"Skedar King",
		MPOPTION_KOH_MOBILEHILL | MPOPTION_KOH_HILLONRADAR | MPOPTION_TEAMSENABLED,
		MPSCENARIO_KINGOFTHEHILL,
		STAGE_MP_SKEDAR,
		9, 100, 9,
		0,
		{
			MPWEAPON_MAGSEC4,
			MPWEAPON_DY357MAGNUM,
			MPWEAPON_K7AVENGER,
			MPWEAPON_AR34,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
		},
	},
	// MPCONFIG_FLAGS
	{
		"Flags",
		MPOPTION_CTC_SHOWONRADAR | MPOPTION_TEAMSENABLED,
		MPSCENARIO_CAPTURETHECASE,
		STAGE_MP_AREA52,
		9, 100, 400,
		0,
		{
			MPWEAPON_FALCON2,
			MPWEAPON_CYCLONE,
			MPWEAPON_SHOTGUN,
			MPWEAPON_SUPERDRAGON,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
		},
	},
	// MPCONFIG_SIMULANTS
	{
		"Simulants",
		0,
		MPSCENARIO_COMBAT,
		STAGE_MP_SKEDAR,
		9, 100, 400,
		0x00f0,
		{
			MPWEAPON_FALCON2,
			MPWEAPON_CMP150,
			MPWEAPON_AR34,
			MPWEAPON_ROCKETLAUNCHER,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_JON,         MPBODY_DD_SECGUARD, MPTEAM_1, { MPSIMDIFF_MEAT,   MPSIMDIFF_MEAT,   MPSIMDIFF_MEAT,   MPSIMDIFF_MEAT   } },
			{ MPHEAD_DARLING,     MPBODY_DD_SECGUARD, MPTEAM_1, { MPSIMDIFF_MEAT,   MPSIMDIFF_MEAT,   MPSIMDIFF_MEAT,   MPSIMDIFF_MEAT   } },
			{ MPHEAD_DDSHOCK,     MPBODY_DDSHOCK,     MPTEAM_1, { MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL } },
			{ MPHEAD_DDSHOCK,     MPBODY_DDSHOCK,     MPTEAM_1, { MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
		},
	},
	// MPCONFIG_AUTOMATICS
	{
		"Automatics",
		0,
		MPSCENARIO_COMBAT,
		STAGE_MP_PIPES,
		9, 9, 400,
		0,
		{
			MPWEAPON_CYCLONE,
			MPWEAPON_CMP150,
			MPWEAPON_DRAGON,
			MPWEAPON_AR34,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
		},
	},
	// MPCONFIG_ROCKETS
	{
		"Rockets",
		0,
		MPSCENARIO_COMBAT,
		STAGE_MP_AREA52,
		9, 9, 400,
		0,
		{
			MPWEAPON_DY357MAGNUM,
			MPWEAPON_SNIPERRIFLE,
			MPWEAPON_DRAGON,
			MPWEAPON_ROCKETLAUNCHER,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF, MPSIMDIFF_OFF } },
		},
	},
	// MPCONFIG_CHALLENGE01
	{
		"",
		MPOPTION_TEAMSENABLED,
		MPSCENARIO_COMBAT,
		STAGE_MP_SKEDAR,
		4, 100, 3,
		0,
		{
			MPWEAPON_FALCON2,
			MPWEAPON_CMP150,
			MPWEAPON_SNIPERRIFLE,
			MPWEAPON_DY357MAGNUM,
			MPWEAPON_DRAGON,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DDSHOCK, MPBODY_DDSHOCK,     MPTEAM_1, { MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_MEAT } },
			{ MPHEAD_JON,     MPBODY_DD_SECGUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_MEAT, MPSIMDIFF_MEAT } },
			{ MPHEAD_DDSHOCK, MPBODY_DDSHOCK,     MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_BEAU1,   MPBODY_DD_SECGUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DDSHOCK, MPBODY_DDSHOCK,     MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DARLING, MPBODY_DD_SECGUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DDSHOCK, MPBODY_DDSHOCK,     MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_MARK2,   MPBODY_DD_SECGUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
		},
	},
	// MPCONFIG_CHALLENGE02
	{
		"",
		MPOPTION_TEAMSENABLED,
		MPSCENARIO_COMBAT,
		STAGE_MP_AREA52,
		4, 100, 5,
		0,
		{
			MPWEAPON_COMBATKNIFE,
			MPWEAPON_FALCON2,
			MPWEAPON_CYCLONE,
			MPWEAPON_DRAGON,
			MPWEAPON_ROCKETLAUNCHER,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DDSHOCK, MPBODY_DD_SHOCK_INF, MPTEAM_1, { MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_MEAT } },
			{ MPHEAD_DDSHOCK, MPBODY_DD_GUARD,     MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_MEAT } },
			{ MPHEAD_DDSHOCK, MPBODY_DD_SHOCK_INF, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_MEAT } },
			{ MPHEAD_DDSHOCK, MPBODY_DD_GUARD,     MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DDSHOCK, MPBODY_DD_SHOCK_INF, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DDSHOCK, MPBODY_DD_GUARD,     MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DDSHOCK, MPBODY_DD_SHOCK_INF, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DDSHOCK, MPBODY_DD_GUARD,     MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
		},
	},
	// MPCONFIG_CHALLENGE03
	{
		"",
		MPOPTION_TEAMSENABLED,
		MPSCENARIO_COMBAT,
		STAGE_MP_PIPES,
		4, 100, 7,
		0,
		{
			MPWEAPON_MAGSEC4,
			MPWEAPON_CMP150,
			MPWEAPON_TIMEDMINE,
			MPWEAPON_DRAGON,
			MPWEAPON_AR34,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARLING, MPBODY_CILABTECH, MPTEAM_1, { MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_MEAT } },
			{ MPHEAD_VD,      MPBODY_CIFEMTECH, MPTEAM_1, { MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_MEAT } },
			{ MPHEAD_MARK2,   MPBODY_CILABTECH, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_MEAT, MPSIMDIFF_MEAT } },
			{ MPHEAD_VD,      MPBODY_CIFEMTECH, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_MEAT } },
			{ MPHEAD_RUSS,    MPBODY_CILABTECH, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_VD,      MPBODY_CIFEMTECH, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_BRIAN,   MPBODY_CILABTECH, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_VD,      MPBODY_CIFEMTECH, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
		},
	},
	// MPCONFIG_CHALLENGE04
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_KOH_MOBILEHILL | MPOPTION_KOH_HILLONRADAR,
		MPSCENARIO_KINGOFTHEHILL,
		STAGE_MP_SKEDAR,
		9, 100, 3,
		0,
		{
			MPWEAPON_MAGSEC4,
			MPWEAPON_CMP150,
			MPWEAPON_DRAGON,
			MPWEAPON_K7AVENGER,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_MARK2,   MPBODY_CISOLDIER, MPTEAM_1, { MPSIMDIFF_EASY, MPSIMDIFF_EASY, MPSIMDIFF_EASY, MPSIMDIFF_EASY } },
			{ MPHEAD_RUSS,    MPBODY_CISOLDIER, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_MEAT, MPSIMDIFF_EASY, MPSIMDIFF_EASY } },
			{ MPHEAD_BRIAN,   MPBODY_CISOLDIER, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_MEAT } },
			{ MPHEAD_ROSS,    MPBODY_CISOLDIER, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_JAMIE,   MPBODY_CISOLDIER, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DUNCAN2, MPBODY_CISOLDIER, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_CHRIST,  MPBODY_CISOLDIER, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_CHRIST,  MPBODY_CISOLDIER, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
		},
	},
	// MPCONFIG_CHALLENGE05
	{
		"",
		MPOPTION_TEAMSENABLED,
		MPSCENARIO_COMBAT,
		STAGE_MP_COMPLEX,
		9, 100, 9,
		0,
		{
			MPWEAPON_CYCLONE,
			MPWEAPON_GRENADE,
			MPWEAPON_AR34,
			MPWEAPON_FARSIGHTXR20,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_CASSANDRA, MPBODY_CASSANDRA, MPTEAM_1, { MPSIMDIFF_EASY, MPSIMDIFF_EASY, MPSIMDIFF_EASY, MPSIMDIFF_EASY } },
			{ MPHEAD_VD,        MPBODY_FEM_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_EASY } },
			{ MPHEAD_VD,        MPBODY_FEM_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_MEAT, MPSIMDIFF_MEAT } },
			{ MPHEAD_VD,        MPBODY_FEM_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_VD,        MPBODY_FEM_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_VD,        MPBODY_FEM_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_VD,        MPBODY_FEM_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_VD,        MPBODY_FEM_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
		},
	},
	// MPCONFIG_CHALLENGE06
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_HTB_HIGHLIGHTBRIEFCASE | MPOPTION_HTB_SHOWONRADAR,
		MPSCENARIO_HOLDTHEBRIEFCASE,
		STAGE_MP_AREA52,
		9, 100, 5,
		0,
		{
			MPWEAPON_CMP150,
			MPWEAPON_DY357MAGNUM,
			MPWEAPON_SHOTGUN,
			MPWEAPON_K7AVENGER,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_RUSS,    MPBODY_OFFICEWORKER,  MPTEAM_1, { MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_EASY, MPSIMDIFF_EASY } },
			{ MPHEAD_BRIAN,   MPBODY_OFFICEWORKER2, MPTEAM_1, { MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_EASY } },
			{ MPHEAD_ROSS,    MPBODY_OFFICEWORKER,  MPTEAM_1, { MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_MEAT } },
			{ MPHEAD_JAMIE,   MPBODY_OFFICEWORKER2, MPTEAM_1, { MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_MEAT, MPSIMDIFF_MEAT } },
			{ MPHEAD_DUNCAN2, MPBODY_OFFICEWORKER,  MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_GRANT,   MPBODY_OFFICEWORKER2, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_CHRIST,  MPBODY_OFFICEWORKER,  MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_GRANT,   MPBODY_OFFICEWORKER2, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
		},
	},
	// MPCONFIG_CHALLENGE07
	{
		"",
		MPOPTION_ONEHITKILLS | MPOPTION_TEAMSENABLED | MPOPTION_KOH_HILLONRADAR | MPOPTION_KOH_MOBILEHILL,
		MPSCENARIO_KINGOFTHEHILL,
		STAGE_MP_WAREHOUSE,
		9, 100, 4,
		0,
		{
			MPWEAPON_FALCON2_SILENCER,
			MPWEAPON_MAGSEC4,
			MPWEAPON_CYCLONE,
			MPWEAPON_GRENADE,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_EASY, MPSIMDIFF_EASY, MPSIMDIFF_EASY, MPSIMDIFF_EASY } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_MEAT, MPSIMDIFF_EASY, MPSIMDIFF_EASY } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
		},
	},
	// MPCONFIG_CHALLENGE08
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_CTC_SHOWONRADAR,
		MPSCENARIO_CAPTURETHECASE,
		STAGE_MP_SKEDAR,
		9, 100, 8,
		0,
		{
			MPWEAPON_MAGSEC4,
			MPWEAPON_K7AVENGER,
			MPWEAPON_SHOTGUN,
			MPWEAPON_SUPERDRAGON,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DDSNIPER, MPBODY_DDSNIPER, MPTEAM_1, { MPSIMDIFF_EASY, MPSIMDIFF_EASY, MPSIMDIFF_EASY, MPSIMDIFF_EASY } },
			{ MPHEAD_DDSNIPER, MPBODY_DDSNIPER, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_EASY, MPSIMDIFF_EASY, MPSIMDIFF_EASY } },
			{ MPHEAD_DDSNIPER, MPBODY_DDSNIPER, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_MEAT, MPSIMDIFF_MEAT } },
			{ MPHEAD_DDSNIPER, MPBODY_DDSNIPER, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_MEAT } },
			{ MPHEAD_DDSNIPER, MPBODY_DDSNIPER, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DDSNIPER, MPBODY_DDSNIPER, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DDSNIPER, MPBODY_DDSNIPER, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DDSNIPER, MPBODY_DDSNIPER, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
		},
	},
	// MPCONFIG_CHALLENGE09
	{
		"",
		MPOPTION_ONEHITKILLS | MPOPTION_TEAMSENABLED,
		MPSCENARIO_COMBAT,
		STAGE_MP_RAVINE,
		9, 100, 9,
		0,
		{
			MPWEAPON_FALCON2,
			MPWEAPON_DY357MAGNUM,
			MPWEAPON_TIMEDMINE,
			MPWEAPON_LAPTOPGUN,
			MPWEAPON_FARSIGHTXR20,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_TRENT,   MPBODY_TRENT,      MPTEAM_1, { MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL } },
			{ MPHEAD_BRIAN,   MPBODY_NSA_LACKEY, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_MEAT,   MPSIMDIFF_EASY   } },
			{ MPHEAD_ROSS,    MPBODY_NSA_LACKEY, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_JAMIE,   MPBODY_NSA_LACKEY, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_DUNCAN2, MPBODY_NSA_LACKEY, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_GRANT,   MPBODY_NSA_LACKEY, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_CHRIST,  MPBODY_NSA_LACKEY, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_GRANT,   MPBODY_NSA_LACKEY, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
		},
	},
	// MPCONFIG_CHALLENGE10
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_HTM_HIGHLIGHTTERMINAL | MPOPTION_HTM_SHOWONRADAR,
		MPSCENARIO_HACKERCENTRAL,
		STAGE_MP_TEMPLE,
		9, 100, 2,
		0,
		{
			MPWEAPON_CMP150,
			MPWEAPON_CYCLONE,
			MPWEAPON_REMOTEMINE,
			MPWEAPON_AR34,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_ROSS,    MPBODY_G5_GUARD,      MPTEAM_1, { MPSIMDIFF_EASY, MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL } },
			{ MPHEAD_JAMIE,   MPBODY_G5_SWAT_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_EASY,   MPSIMDIFF_EASY,   MPSIMDIFF_NORMAL } },
			{ MPHEAD_DUNCAN2, MPBODY_G5_GUARD,      MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_EASY,   MPSIMDIFF_EASY   } },
			{ MPHEAD_DAVEC,   MPBODY_G5_SWAT_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_CHRIST,  MPBODY_G5_GUARD,      MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_GRANT,   MPBODY_G5_SWAT_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_PENNY,   MPBODY_G5_GUARD,      MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_DAVEC,   MPBODY_G5_SWAT_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
		},
	},
	// MPCONFIG_CHALLENGE11
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_KOH_HILLONRADAR | MPOPTION_KOH_MOBILEHILL,
		MPSCENARIO_KINGOFTHEHILL,
		STAGE_MP_COMPLEX,
		9, 100, 9,
		0,
		{
			MPWEAPON_MAGSEC4,
			MPWEAPON_TRANQUILIZER,
			MPWEAPON_SHOTGUN,
			MPWEAPON_K7AVENGER,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_MRBLONDE, MPBODY_MRBLONDE, MPTEAM_1, { MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL, MPSIMDIFF_HARD, MPSIMDIFF_HARD   } },
			{ MPHEAD_MRBLONDE, MPBODY_MRBLONDE, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_NORMAL, MPSIMDIFF_MEAT, MPSIMDIFF_NORMAL } },
			{ MPHEAD_MRBLONDE, MPBODY_MRBLONDE, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_MEAT, MPSIMDIFF_EASY   } },
			{ MPHEAD_MRBLONDE, MPBODY_MRBLONDE, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_MEAT, MPSIMDIFF_MEAT   } },
			{ MPHEAD_MRBLONDE, MPBODY_MRBLONDE, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,  MPSIMDIFF_OFF    } },
			{ MPHEAD_MRBLONDE, MPBODY_MRBLONDE, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,  MPSIMDIFF_OFF    } },
			{ MPHEAD_MRBLONDE, MPBODY_MRBLONDE, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,  MPSIMDIFF_OFF    } },
			{ MPHEAD_MRBLONDE, MPBODY_MRBLONDE, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,  MPSIMDIFF_OFF    } },
		},
	},
	// MPCONFIG_CHALLENGE12
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_SLOWMOTION_ON,
		MPSCENARIO_COMBAT,
		STAGE_MP_SKEDAR,
		9, 100, 2,
		0,
		{
			MPWEAPON_FALCON2_SCOPE,
			MPWEAPON_SNIPERRIFLE,
			MPWEAPON_SHOTGUN,
			MPWEAPON_SUPERDRAGON,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_TRENCH, MPTEAM_1, { MPSIMDIFF_HARD, MPSIMDIFF_HARD,   MPSIMDIFF_HARD,   MPSIMDIFF_HARD   } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_TRENCH, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_TRENCH, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_EASY,   MPSIMDIFF_EASY   } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_TRENCH, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_EASY   } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_TRENCH, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_TRENCH, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_TRENCH, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_TRENCH, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
		},
	},
	// MPCONFIG_CHALLENGE13
	{
		"",
		MPOPTION_ONEHITKILLS | MPOPTION_TEAMSENABLED | MPOPTION_00010000,
		MPSCENARIO_COMBAT,
		STAGE_MP_G5BUILDING,
		9, 100, 9,
		0,
		{
			MPWEAPON_FALCON2_SILENCER,
			MPWEAPON_TRANQUILIZER,
			MPWEAPON_LAPTOPGUN,
			MPWEAPON_GRENADE,
			MPWEAPON_REAPER,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_JAMIE,   MPBODY_CIAGUY, MPTEAM_1, { MPSIMDIFF_NORMAL, MPSIMDIFF_HARD, MPSIMDIFF_HARD, MPSIMDIFF_HARD } },
			{ MPHEAD_DUNCAN2, MPBODY_FBIGUY, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_EASY, MPSIMDIFF_EASY, MPSIMDIFF_EASY } },
			{ MPHEAD_KEITH,   MPBODY_CIAGUY, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,  MPSIMDIFF_EASY, MPSIMDIFF_EASY } },
			{ MPHEAD_CHRIST,  MPBODY_FBIGUY, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_EASY } },
			{ MPHEAD_GRANT,   MPBODY_CIAGUY, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_PENNY,   MPBODY_FBIGUY, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DAVEC,   MPBODY_CIAGUY, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_KEITH,   MPBODY_FBIGUY, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
		},
	},
	// MPCONFIG_CHALLENGE14
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_CTC_SHOWONRADAR,
		MPSCENARIO_CAPTURETHECASE,
		STAGE_MP_AREA52,
		9, 100, 9,
		0,
		{
			MPWEAPON_CYCLONE,
			MPWEAPON_SUPERDRAGON,
			MPWEAPON_K7AVENGER,
			MPWEAPON_FARSIGHTXR20,
			MPWEAPON_CLOAKINGDEVICE,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DUNCAN2, MPBODY_AREA51GUARD, MPTEAM_1, { MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL, MPSIMDIFF_HARD,   MPSIMDIFF_HARD   } },
			{ MPHEAD_STEVEM,  MPBODY_A51TROOPER,  MPTEAM_1, { MPSIMDIFF_EASY,   MPSIMDIFF_EASY,   MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL } },
			{ MPHEAD_CHRIST,  MPBODY_AREA51GUARD, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_EASY,   MPSIMDIFF_EASY,   MPSIMDIFF_EASY   } },
			{ MPHEAD_GRANT,   MPBODY_A51AIRMAN,   MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_EASY,   MPSIMDIFF_EASY,   MPSIMDIFF_EASY   } },
			{ MPHEAD_PENNY,   MPBODY_AREA51GUARD, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_EASY,   MPSIMDIFF_EASY   } },
			{ MPHEAD_DAVEC,   MPBODY_A51TROOPER,  MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_EASY   } },
			{ MPHEAD_KEITH,   MPBODY_AREA51GUARD, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_STEVEM,  MPBODY_A51AIRMAN,   MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
		},
	},
	// MPCONFIG_CHALLENGE15
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_HTB_HIGHLIGHTBRIEFCASE | MPOPTION_HTB_SHOWONRADAR,
		MPSCENARIO_HOLDTHEBRIEFCASE,
		STAGE_MP_GRID,
		9, 100, 9,
		0,
		{
			MPWEAPON_MAGSEC4,
			MPWEAPON_DRAGON,
			MPWEAPON_SHOTGUN,
			MPWEAPON_DEVASTATOR,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_PENNY,  MPBODY_LABTECH,    MPTEAM_1, { MPSIMDIFF_NORMAL, MPSIMDIFF_HARD,   MPSIMDIFF_HARD,   MPSIMDIFF_HARD   } },
			{ MPHEAD_VD,     MPBODY_FEMLABTECH, MPTEAM_1, { MPSIMDIFF_MEAT,   MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL } },
			{ MPHEAD_CHRIST, MPBODY_DD_LABTECH, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_MEAT,   MPSIMDIFF_EASY,   MPSIMDIFF_EASY   } },
			{ MPHEAD_GRANT,  MPBODY_LABTECH,    MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_MEAT,   MPSIMDIFF_EASY   } },
			{ MPHEAD_VD,     MPBODY_FEMLABTECH, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_MEAT   } },
			{ MPHEAD_PENNY,  MPBODY_DD_LABTECH, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_DAVEC,  MPBODY_LABTECH,    MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_VD,     MPBODY_FEMLABTECH, MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
		},
	},
	// MPCONFIG_CHALLENGE16
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_NORADAR,
		MPSCENARIO_COMBAT,
		STAGE_MP_FELICITY,
		9, 100, 9,
		0,
		{
			MPWEAPON_FALCON2,
			MPWEAPON_K7AVENGER,
			MPWEAPON_SUPERDRAGON,
			MPWEAPON_PROXIMITYMINE,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_BIOTECH, MPBODY_BIOTECH, MPTEAM_1, { MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT } },
			{ MPHEAD_BIOTECH, MPBODY_BIOTECH, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_NORMAL,  MPSIMDIFF_HARD,    MPSIMDIFF_HARD    } },
			{ MPHEAD_BIOTECH, MPBODY_BIOTECH, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_MEAT,    MPSIMDIFF_EASY    } },
			{ MPHEAD_BIOTECH, MPBODY_BIOTECH, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_EASY    } },
			{ MPHEAD_BIOTECH, MPBODY_BIOTECH, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_BIOTECH, MPBODY_BIOTECH, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_BIOTECH, MPBODY_BIOTECH, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_BIOTECH, MPBODY_BIOTECH, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
		},
	},
	// MPCONFIG_CHALLENGE17
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_KOH_HILLONRADAR | MPOPTION_KOH_MOBILEHILL,
		MPSCENARIO_KINGOFTHEHILL,
		STAGE_MP_TEMPLE,
		9, 100, 9,
		0,
		{
			MPWEAPON_DY357MAGNUM,
			MPWEAPON_AR34,
			MPWEAPON_REAPER,
			MPWEAPON_SLAYER,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_CARRINGTON, MPBODY_CARRINGTON, MPTEAM_1, { MPSIMDIFF_PERFECT, MPSIMDIFF_HARD, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT } },
			{ MPHEAD_CHRIST,     MPBODY_CISOLDIER,  MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_EASY, MPSIMDIFF_NORMAL,  MPSIMDIFF_NORMAL  } },
			{ MPHEAD_GRANT,      MPBODY_CISOLDIER,  MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_MEAT, MPSIMDIFF_EASY,    MPSIMDIFF_EASY    } },
			{ MPHEAD_PENNY,      MPBODY_CISOLDIER,  MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_MEAT, MPSIMDIFF_OFF,     MPSIMDIFF_MEAT    } },
			{ MPHEAD_DAVEC,      MPBODY_CISOLDIER,  MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,  MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_KEITH,      MPBODY_CISOLDIER,  MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,  MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_STEVEM,     MPBODY_CISOLDIER,  MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,  MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_JON,        MPBODY_CISOLDIER,  MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,  MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
		},
	},
	// MPCONFIG_CHALLENGE18
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_KOH_HILLONRADAR | MPOPTION_KOH_MOBILEHILL,
		MPSCENARIO_KINGOFTHEHILL,
		STAGE_MP_VILLA,
		9, 100, 9,
		0,
		{
			MPWEAPON_FALCON2,
			MPWEAPON_PHOENIX,
			MPWEAPON_TRANQUILIZER,
			MPWEAPON_LAPTOPGUN,
			MPWEAPON_SHIELD,
			MPWEAPON_CLOAKINGDEVICE,
		},
		{
			{ MPHEAD_ELVIS, MPBODY_THEKING, MPTEAM_1, { MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_NORMAL } },
			{ MPHEAD_ELVIS, MPBODY_ELVIS1,  MPTEAM_1, { MPSIMDIFF_MEAT,    MPSIMDIFF_HARD,    MPSIMDIFF_HARD,    MPSIMDIFF_NORMAL } },
			{ MPHEAD_ELVIS, MPBODY_ELVIS1,  MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_MEAT,    MPSIMDIFF_EASY   } },
			{ MPHEAD_ELVIS, MPBODY_ELVIS1,  MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_EASY   } },
			{ MPHEAD_ELVIS, MPBODY_ELVIS1,  MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_MEAT   } },
			{ MPHEAD_ELVIS, MPBODY_ELVIS1,  MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_MEAT   } },
			{ MPHEAD_ELVIS, MPBODY_ELVIS1,  MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF    } },
			{ MPHEAD_ELVIS, MPBODY_ELVIS1,  MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF    } },
		},
	},
	// MPCONFIG_CHALLENGE19
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_FASTMOVEMENT,
		MPSCENARIO_COMBAT,
		STAGE_MP_G5BUILDING,
		9, 100, 9,
		0,
		{
			MPWEAPON_CMP150,
			MPWEAPON_SHOTGUN,
			MPWEAPON_ROCKETLAUNCHER,
			MPWEAPON_FARSIGHTXR20,
			MPWEAPON_SHIELD,
			MPWEAPON_COMBATBOOST,
		},
		{
			{ MPHEAD_CASSANDRA, MPBODY_CASSANDRA, MPTEAM_1, { MPSIMDIFF_HARD, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT } },
			{ MPHEAD_TRENT,     MPBODY_TRENT,     MPTEAM_1, { MPSIMDIFF_EASY, MPSIMDIFF_PERFECT, MPSIMDIFF_HARD,    MPSIMDIFF_HARD    } },
			{ MPHEAD_DDSNIPER,  MPBODY_DDSNIPER,  MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,     MPSIMDIFF_NORMAL,  MPSIMDIFF_NORMAL  } },
			{ MPHEAD_DDSNIPER,  MPBODY_DDSNIPER,  MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_EASY    } },
			{ MPHEAD_DDSNIPER,  MPBODY_DDSNIPER,  MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_DDSNIPER,  MPBODY_DDSNIPER,  MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_DDSNIPER,  MPBODY_DDSNIPER,  MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_DDSNIPER,  MPBODY_DDSNIPER,  MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
		},
	},
	// MPCONFIG_CHALLENGE20
	{
		"",
		MPOPTION_ONEHITKILLS | MPOPTION_TEAMSENABLED,
		MPSCENARIO_COMBAT,
		STAGE_MP_SEWERS,
		9, 100, 9,
		0,
		{
			MPWEAPON_MAULER,
			MPWEAPON_FALCON2,
			MPWEAPON_MAGSEC4,
			MPWEAPON_DY357MAGNUM,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_GRANT,  MPBODY_PILOTAF1,   MPTEAM_1, { MPSIMDIFF_HARD,   MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT } },
			{ MPHEAD_PENNY,  MPBODY_PILOTAF1,   MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_HARD,    MPSIMDIFF_HARD,    MPSIMDIFF_PERFECT } },
			{ MPHEAD_VD,     MPBODY_STEWARDESS, MPTEAM_0, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_DAVEC,  MPBODY_STEWARD,    MPTEAM_0, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_KEITH,  MPBODY_STEWARD,    MPTEAM_0, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_VD,     MPBODY_STEWARDESS, MPTEAM_0, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_NORMAL  } },
			{ MPHEAD_STEVEM, MPBODY_STEWARD,    MPTEAM_0, { MPSIMDIFF_OFF,    MPSIMDIFF_NORMAL,  MPSIMDIFF_NORMAL,  MPSIMDIFF_NORMAL  } },
			{ MPHEAD_VD,     MPBODY_STEWARDESS, MPTEAM_0, { MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL,  MPSIMDIFF_NORMAL,  MPSIMDIFF_NORMAL  } },
		},
	},
	// MPCONFIG_CHALLENGE21
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_HTM_HIGHLIGHTTERMINAL | MPOPTION_HTM_SHOWONRADAR,
		MPSCENARIO_HACKERCENTRAL,
		STAGE_MP_GRID,
		9, 100, 9,
		0,
		{
			MPWEAPON_MAULER,
			MPWEAPON_REAPER,
			MPWEAPON_SHOTGUN,
			MPWEAPON_CALLISTONTG,
			MPWEAPON_CLOAKINGDEVICE,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARK_COMBAT, MPBODY_DARKSNOW,      MPTEAM_1, { MPSIMDIFF_HARD, MPSIMDIFF_HARD,   MPSIMDIFF_HARD,   MPSIMDIFF_HARD   } },
			{ MPHEAD_PENNY,       MPBODY_ALASKAN_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL } },
			{ MPHEAD_DAVEC,       MPBODY_ALASKAN_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_EASY,   MPSIMDIFF_NORMAL } },
			{ MPHEAD_KEITH,       MPBODY_ALASKAN_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_EASY   } },
			{ MPHEAD_STEVEM,      MPBODY_ALASKAN_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_JON,         MPBODY_ALASKAN_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_BEAU1,       MPBODY_ALASKAN_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_DARLING,     MPBODY_ALASKAN_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
		},
	},
	// MPCONFIG_CHALLENGE22
	{
		"",
		MPOPTION_ONEHITKILLS | MPOPTION_TEAMSENABLED | MPOPTION_HTB_HIGHLIGHTBRIEFCASE | MPOPTION_HTB_SHOWONRADAR,
		MPSCENARIO_HOLDTHEBRIEFCASE,
		STAGE_MP_BASE,
		9, 100, 9,
		0,
		{
			MPWEAPON_FALCON2,
			MPWEAPON_SNIPERRIFLE,
			MPWEAPON_CROSSBOW,
			MPWEAPON_K7AVENGER,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_PRESIDENT, MPBODY_PRESIDENT,     MPTEAM_1, { MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT } },
			{ MPHEAD_DAVEC,     MPBODY_PRES_SECURITY, MPTEAM_1, { MPSIMDIFF_NORMAL,  MPSIMDIFF_NORMAL,  MPSIMDIFF_HARD,    MPSIMDIFF_NORMAL  } },
			{ MPHEAD_KEITH,     MPBODY_PRES_SECURITY, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_EASY,    MPSIMDIFF_NORMAL,  MPSIMDIFF_NORMAL  } },
			{ MPHEAD_STEVEM,    MPBODY_PRES_SECURITY, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_EASY    } },
			{ MPHEAD_JON,       MPBODY_PRES_SECURITY, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_BEAU1,     MPBODY_PRES_SECURITY, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_DARLING,   MPBODY_PRES_SECURITY, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_MARK2,     MPBODY_PRES_SECURITY, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
		},
	},
	// MPCONFIG_CHALLENGE23
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_SLOWMOTION_ON,
		MPSCENARIO_COMBAT,
		STAGE_MP_COMPLEX,
		9, 100, 1,
		0,
		{
			MPWEAPON_MAGSEC4,
			MPWEAPON_GRENADE,
			MPWEAPON_LAPTOPGUN,
			MPWEAPON_RCP120,
			MPWEAPON_SHIELD,
			MPWEAPON_COMBATBOOST,
		},
		{
			{ MPHEAD_PRESIDENT, MPBODY_PRESIDENT_CLONE2, MPTEAM_1, { MPSIMDIFF_HARD, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT } },
			{ MPHEAD_KEITH,     MPBODY_STRIPES,          MPTEAM_1, { MPSIMDIFF_HARD, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT } },
			{ MPHEAD_STEVEM,    MPBODY_STRIPES,          MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,     MPSIMDIFF_HARD,    MPSIMDIFF_NORMAL  } },
			{ MPHEAD_JON,       MPBODY_STRIPES,          MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_NORMAL  } },
			{ MPHEAD_BEAU1,     MPBODY_STRIPES,          MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_DARLING,   MPBODY_STRIPES,          MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_MARK2,     MPBODY_STRIPES,          MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_RUSS,      MPBODY_STRIPES,          MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
		},
	},
	// MPCONFIG_CHALLENGE24
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_CTC_SHOWONRADAR,
		MPSCENARIO_CAPTURETHECASE,
		STAGE_MP_FORTRESS,
		60, 100, 8,
		0,
		{
			MPWEAPON_CMP150,
			MPWEAPON_TRANQUILIZER,
			MPWEAPON_DEVASTATOR,
			MPWEAPON_SUPERDRAGON,
			MPWEAPON_DY357LX,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_STEVEM,  MPBODY_AREA51GUARD, MPTEAM_1, { MPSIMDIFF_EASY, MPSIMDIFF_NORMAL, MPSIMDIFF_HARD,    MPSIMDIFF_HARD   } },
			{ MPHEAD_JON,     MPBODY_A51TROOPER,  MPTEAM_1, { MPSIMDIFF_EASY, MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL,  MPSIMDIFF_HARD   } },
			{ MPHEAD_BEAU1,   MPBODY_A51AIRMAN,   MPTEAM_1, { MPSIMDIFF_EASY, MPSIMDIFF_EASY,   MPSIMDIFF_NORMAL,  MPSIMDIFF_NORMAL } },
			{ MPHEAD_DARLING, MPBODY_AREA51GUARD, MPTEAM_1, { MPSIMDIFF_EASY, MPSIMDIFF_EASY,   MPSIMDIFF_EASY,    MPSIMDIFF_NORMAL } },
			{ MPHEAD_MARK2,   MPBODY_A51TROOPER,  MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_EASY,    MPSIMDIFF_EASY   } },
			{ MPHEAD_RUSS,    MPBODY_A51AIRMAN,   MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_PERFECT, MPSIMDIFF_EASY   } },
			{ MPHEAD_BRIAN,   MPBODY_AREA51GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,     MPSIMDIFF_OFF    } },
			{ MPHEAD_ROSS,    MPBODY_AREA51GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,    MPSIMDIFF_OFF,     MPSIMDIFF_OFF    } },
		},
	},
	// MPCONFIG_CHALLENGE25
	{
		"",
		MPOPTION_TEAMSENABLED,
		MPSCENARIO_COMBAT,
		STAGE_MP_RAVINE,
		2, 100, 9,
		0,
		{
			MPWEAPON_MAULER,
			MPWEAPON_NBOMB,
			MPWEAPON_K7AVENGER,
			MPWEAPON_FARSIGHTXR20,
			MPWEAPON_CLOAKINGDEVICE,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DDSHOCK, MPBODY_DDSHOCK,      MPTEAM_1, { MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT } },
			{ MPHEAD_DDSHOCK, MPBODY_DD_SHOCK_INF, MPTEAM_1, { MPSIMDIFF_HARD,    MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT } },
			{ MPHEAD_DDSHOCK, MPBODY_DDSHOCK,      MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_HARD,    MPSIMDIFF_HARD,    MPSIMDIFF_PERFECT } },
			{ MPHEAD_DDSHOCK, MPBODY_DD_SHOCK_INF, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_NORMAL,  MPSIMDIFF_HARD    } },
			{ MPHEAD_DDSHOCK, MPBODY_DDSHOCK,      MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_EASY    } },
			{ MPHEAD_DDSHOCK, MPBODY_DD_SHOCK_INF, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_DDSHOCK, MPBODY_DDSHOCK,      MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_DDSHOCK, MPBODY_DD_SHOCK_INF, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
		},
	},
	// MPCONFIG_CHALLENGE26
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_KOH_HILLONRADAR | MPOPTION_KOH_MOBILEHILL,
		MPSCENARIO_KINGOFTHEHILL,
		STAGE_MP_RUINS,
		9, 100, 9,
		0,
		{
			MPWEAPON_FALCON2,
			MPWEAPON_MAULER,
			MPWEAPON_CYCLONE,
			MPWEAPON_LAPTOPGUN,
			MPWEAPON_REAPER,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_JON,     MPBODY_CILABTECH, MPTEAM_1, { MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT } },
			{ MPHEAD_VD,      MPBODY_CIFEMTECH, MPTEAM_1, { MPSIMDIFF_HARD,    MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT } },
			{ MPHEAD_BEAU1,   MPBODY_CISOLDIER, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_HARD,    MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT } },
			{ MPHEAD_DARLING, MPBODY_CISOLDIER, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_EASY,    MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT } },
			{ MPHEAD_MARK2,   MPBODY_CISOLDIER, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_PERFECT } },
			{ MPHEAD_RUSS,    MPBODY_CISOLDIER, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_BRIAN,   MPBODY_CISOLDIER, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_ROSS,    MPBODY_CISOLDIER, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
		},
	},
	// MPCONFIG_CHALLENGE27
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_HTM_HIGHLIGHTTERMINAL | MPOPTION_HTM_SHOWONRADAR,
		MPSCENARIO_HACKERCENTRAL,
		STAGE_MP_SEWERS,
		9, 100, 9,
		0,
		{
			MPWEAPON_FALCON2,
			MPWEAPON_MAGSEC4,
			MPWEAPON_CMP150,
			MPWEAPON_ROCKETLAUNCHER,
			MPWEAPON_SHIELD,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_BEAU1,   MPBODY_CIAGUY, MPTEAM_1, { MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT } },
			{ MPHEAD_DARLING, MPBODY_FBIGUY, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT } },
			{ MPHEAD_MARK2,   MPBODY_CIAGUY, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_PERFECT, MPSIMDIFF_PERFECT } },
			{ MPHEAD_RUSS,    MPBODY_FBIGUY, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_PERFECT } },
			{ MPHEAD_BRIAN,   MPBODY_CIAGUY, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_ROSS,    MPBODY_FBIGUY, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_JAMIE,   MPBODY_CIAGUY, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
			{ MPHEAD_DUNCAN2, MPBODY_FBIGUY, MPTEAM_1, { MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF,     MPSIMDIFF_OFF     } },
		},
	},
	// MPCONFIG_CHALLENGE28
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_CTC_SHOWONRADAR,
		MPSCENARIO_CAPTURETHECASE,
		STAGE_MP_VILLA,
		9, 100, 8,
		0,
		{
			MPWEAPON_FALCON2,
			MPWEAPON_FALCON2_SILENCER,
			MPWEAPON_DY357MAGNUM,
			MPWEAPON_AR34,
			MPWEAPON_SHOTGUN,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_DARLING, MPBODY_PELAGIC_GUARD, MPTEAM_1, { MPSIMDIFF_DARK, MPSIMDIFF_DARK, MPSIMDIFF_DARK, MPSIMDIFF_DARK } },
			{ MPHEAD_MARK2,   MPBODY_PELAGIC_GUARD, MPTEAM_1, { MPSIMDIFF_DARK, MPSIMDIFF_DARK, MPSIMDIFF_DARK, MPSIMDIFF_DARK } },
			{ MPHEAD_RUSS,    MPBODY_PELAGIC_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_DARK, MPSIMDIFF_DARK, MPSIMDIFF_DARK } },
			{ MPHEAD_BRIAN,   MPBODY_PELAGIC_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_DARK, MPSIMDIFF_DARK } },
			{ MPHEAD_ROSS,    MPBODY_PELAGIC_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_DARK } },
			{ MPHEAD_JAMIE,   MPBODY_PELAGIC_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_DUNCAN2, MPBODY_PELAGIC_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_JAMIE,   MPBODY_PELAGIC_GUARD, MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
		},
	},
	// MPCONFIG_CHALLENGE29
	{
		"",
		MPOPTION_TEAMSENABLED,
		MPSCENARIO_COMBAT,
		STAGE_MP_G5BUILDING,
		9, 100, 9,
		0,
		{
			MPWEAPON_FALCON2,
			MPWEAPON_CYCLONE,
			MPWEAPON_DY357MAGNUM,
			MPWEAPON_CMP150,
			MPWEAPON_DRAGON,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_MARK2, MPBODY_OFFICEWORKER,  MPTEAM_1, { MPSIMDIFF_DARK, MPSIMDIFF_DARK, MPSIMDIFF_DARK, MPSIMDIFF_DARK } },
			{ MPHEAD_RUSS,  MPBODY_OFFICEWORKER2, MPTEAM_1, { MPSIMDIFF_DARK, MPSIMDIFF_DARK, MPSIMDIFF_DARK, MPSIMDIFF_DARK } },
			{ MPHEAD_VD,    MPBODY_FEM_GUARD,     MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_DARK, MPSIMDIFF_DARK, MPSIMDIFF_DARK } },
			{ MPHEAD_VD,    MPBODY_FEM_GUARD,     MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_DARK, MPSIMDIFF_DARK } },
			{ MPHEAD_VD,    MPBODY_FEM_GUARD,     MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_DARK } },
			{ MPHEAD_VD,    MPBODY_FEM_GUARD,     MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_VD,    MPBODY_FEM_GUARD,     MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
			{ MPHEAD_VD,    MPBODY_FEM_GUARD,     MPTEAM_1, { MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF,  MPSIMDIFF_OFF  } },
		},
	},
	// MPCONFIG_CHALLENGE30
	{
		"",
		MPOPTION_TEAMSENABLED | MPOPTION_KOH_HILLONRADAR | MPOPTION_KOH_MOBILEHILL,
		MPSCENARIO_KINGOFTHEHILL,
		STAGE_MP_SKEDAR,
		9, 100, 9,
		0,
		{
			MPWEAPON_FALCON2,
			MPWEAPON_FALCON2_SCOPE,
			MPWEAPON_MAGSEC4,
			MPWEAPON_MAULER,
			MPWEAPON_DY357MAGNUM,
			MPWEAPON_DISABLED,
		},
		{
			{ MPHEAD_MRBLONDE,    MPBODY_MRBLONDE,    MPTEAM_1, { MPSIMDIFF_DARK,   MPSIMDIFF_DARK,   MPSIMDIFF_DARK,   MPSIMDIFF_DARK   } },
			{ MPHEAD_CASSANDRA,   MPBODY_CASSANDRA,   MPTEAM_1, { MPSIMDIFF_DARK,   MPSIMDIFF_DARK,   MPSIMDIFF_DARK,   MPSIMDIFF_DARK   } },
			{ MPHEAD_TRENT,       MPBODY_TRENT,       MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_DARK,   MPSIMDIFF_DARK,   MPSIMDIFF_DARK   } },
			{ MPHEAD_MRBLONDE,    MPBODY_MRBLONDE,    MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_DARK,   MPSIMDIFF_DARK   } },
			{ MPHEAD_MRBLONDE,    MPBODY_MRBLONDE,    MPTEAM_1, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_DARK   } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_0, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_0, { MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF,    MPSIMDIFF_OFF    } },
			{ MPHEAD_DARK_COMBAT, MPBODY_DARK_COMBAT, MPTEAM_0, { MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL, MPSIMDIFF_NORMAL } },
		},
	},
};
