//
// Skedar Ruins
//

#include "stagesetup.h"

// Characters
#define CHR_KING1                   0x33
#define CHR_KING_SKEDAR_SPAWNER     0x34
#define CHR_KING_MINISKEDAR_SPAWNER 0x35
#define CHR_ELVIS                   0x36
#define CHR_KING2                   0x3b

// Objects
#define OBJ_PILLAR1          0x01
#define OBJ_PILLAR2          0x02
#define OBJ_PILLAR3          0x03
#define OBJ_BRIDGE           0x05
#define OBJ_TARGETAMP_BOND   0x08
#define OBJ_ALTAR            0x0b
#define OBJ_SPIKE_ML         0x13
#define OBJ_SPIKE_MR         0x14
#define OBJ_SPIKE_BL         0x15
#define OBJ_SPIKE_BR         0x16
#define OBJ_SPIKE_T          0x17
#define OBJ_SPIKE_SHAD_ML    0x19
#define OBJ_SPIKE_SHAD_MR    0x1a
#define OBJ_SPIKE_SHAD_BL    0x1b
#define OBJ_SPIKE_SHAD_BR    0x1c
#define OBJ_SPIKE_SHAD_T     0x1d
#define OBJ_SPIKE_NOSHAD_ML  0x1e
#define OBJ_SPIKE_NOSHAD_MR  0x1f
#define OBJ_SPIKE_NOSHAD_BL  0x20
#define OBJ_SPIKE_NOSHAD_BR  0x21
#define OBJ_SPIKE_NOSHAD_T   0x22
#define OBJ_TARGETAMP_COOP   0x35
#define OBJ_PHOENIX1         0x42
#define OBJ_PHOENIX2         0x43
#define OBJ_REMOTEMINE       0x44
#define OBJ_ALTAR_FALCON     0x47
#define OBJ_ALTAR_DEVASTATOR 0x48
#define OBJ_ALTAR_CALLISTO   0x49
#define OBJ_ALTAR_MAULER     0x4a
#define OBJ_ALTAR_SLAYER     0x4b
#define OBJ_PUZZLEROCK       0x4c
#define OBJ_BUDDYBRIDGE      0x50
#define OBJ_BUDDYBARRICADE   0x51

// Stage flags
#define STAGEFLAG_COOP_THREW_FIRST_BUG          0x00000001
#define STAGEFLAG_COOP_THREW_SECOND_BUG         0x00000002
#define STAGEFLAG_COOP_THREW_THIRD_BUG          0x00000004
#define STAGEFLAG_COOP_BUGS_WASTED              0x00000008
#define STAGEFLAG_BOND_BUGS_WASTED              0x00000010
#define STAGEFLAG_IN_INTRO                      0x00000020
#define STAGEFLAG_IN_OUTRO                      0x00000040
#define STAGEFLAG_AI_BUDDY_EXISTS               0x00000080
#define STAGEFLAG_PILLAR1_MARKED                0x00000100
#define STAGEFLAG_PILLAR2_MARKED                0x00000200
#define STAGEFLAG_PILLAR3_MARKED                0x00000400
#define STAGEFLAG_BUG_WASTED                    0x00000800
#define STAGEFLAG_BRIDGE_EXTENDED               0x00001000
#define STAGEFLAG_TRIGGER_SKEDAR_ARMY           0x00002000
#define STAGEFLAG_ARMY_DEFEATED                 0x00004000
#define STAGEFLAG_CROSSED_RAVINE_WITHOUT_BRIDGE 0x00008000
#define STAGEFLAG_TRIGGER_BRIDGE                0x00010000
#define STAGEFLAG_BOND_THREW_FIRST_BUG          0x00020000
#define STAGEFLAG_BOND_THREW_SECOND_BUG         0x00040000
#define STAGEFLAG_BOND_THREW_THIRD_BUG          0x00080000
#define STAGEFLAG_GRENADES_WASTED               0x00100000
#define STAGEFLAG_ACCESSED_SANCTUM              0x00200000
#define STAGEFLAG_KING_SKEDAR_CLONE_EXISTS      0x00800000
#define STAGEFLAG_SPIKE1_DESTROYED              0x01000000
#define STAGEFLAG_SPIKE2_DESTROYED              0x02000000
#define STAGEFLAG_SPIKE3_DESTROYED              0x04000000
#define STAGEFLAG_SPIKE4_DESTROYED              0x08000000
#define STAGEFLAG_SPIKE5_DESTROYED              0x10000000
#define STAGEFLAG_SPIKES_VULNERABLE             0x20000000
#define STAGEFLAG_SPIKE_DESTROYED               0x40000000
#define STAGEFLAG_KING_MINISKEDAR_CLONE_EXISTS  0x80000000

// AI Lists
#define AILIST_INIT_UNARMED_SKEDAR           0x0401
#define AILIST_UNARMED_SKEDAR                0x0402
#define AILIST_INIT_MINISKEDAR               0x0403
#define AILIST_MINISKEDAR                    0x0404
#define AILIST_PUZZLEROOM_MINISKEDAR_WAITING 0x0405
#define AILIST_MINISKEDAR_SPAWNER            0x0406
#define AILIST_INIT_CLOAKED_SKEDAR           0x0407
#define AILIST_CLOAKED_SKEDAR                0x0408
#define AILIST_REAPER_SLAYER_SKEDAR          0x0409
#define AILIST_INIT_REAPER_SLAYER_SKEDAR     0x040a
#define AILIST_MAULER_SKEDAR                 0x040b
#define AILIST_KING_WAITING                  0x040c
#define AILIST_KING_COMBAT                   0x040d
#define AILIST_KING_SKEDAR_SPAWNER           0x040e
#define AILIST_UPDATE_SPIKE_STAGEFLAGS       0x040f
#define AILIST_INIT_KING_SKEDAR_CLONE        0x0410
#define AILIST_KING_MINISKEDAR_SPAWNER       0x0411
#define AILIST_INIT_KING_MINISKEDAR_CLONE    0x0412
#define AILIST_HIDE                          0x0413
#define AILIST_OUTRO                         0x0414

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x4201)
	briefing(1, 0x4200)
	briefing(2, 0x4202)
	briefing(3, 0x4203)

	beginobjective(0, L_SHO(5), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Identify temple targets"
		complete_flags(STAGEFLAG_PILLAR1_MARKED)
		complete_flags(STAGEFLAG_PILLAR2_MARKED)
		complete_flags(STAGEFLAG_PILLAR3_MARKED)
		fail_flags(STAGEFLAG_BUG_WASTED)
	endobjective

	beginobjective(1, L_SHO(6), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Activate bridge"
		complete_flags(STAGEFLAG_BRIDGE_EXTENDED)
	endobjective

	beginobjective(2, L_SHO(7), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Gain access to Inner Sanctum"
		complete_flags(STAGEFLAG_ACCESSED_SANCTUM)
	endobjective

	beginobjective(3, L_SHO(8), (DIFFBIT_PA | DIFFBIT_PD)) // "Destroy secret Skedar army"
		complete_flags(STAGEFLAG_ARMY_DEFEATED)
	endobjective

	beginobjective(4, L_SHO(9), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Assassinate Skedar leader"
		complete_flags(STAGEFLAG_SPIKE1_DESTROYED)
		complete_flags(STAGEFLAG_SPIKE2_DESTROYED)
		complete_flags(STAGEFLAG_SPIKE3_DESTROYED)
		complete_flags(STAGEFLAG_SPIKE4_DESTROYED)
		complete_flags(STAGEFLAG_SPIKE5_DESTROYED)
		fail_flags(STAGEFLAG_GRENADES_WASTED)
	endobjective

	chr(0x00000200, 0x05, 0x00a0, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00d8, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x06, 0x00a1, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00d8, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x07, 0x00a2, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00d9, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x08, 0x00a3, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00d9, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x17, 0x00a4, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_REAPER_SLAYER_SKEDAR, -1, -1, 1000, 15, 0x40002000, 0x00000010, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSKMINIGUN, 0x0017, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REAPER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x09, 0x00a5, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00da, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x0a, 0x00a6, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00da, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x0b, 0x00a7, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00db, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x0c, 0x00a8, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00db, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x0d, 0x00a9, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00dc, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x0e, 0x00aa, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00dc, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x0f, 0x00ab, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00dd, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x10, 0x00ac, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00dd, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x1c, 0x00a4, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_REAPER_SLAYER_SKEDAR, -1, -1, 1000, 15, 0x40002000, 0x00000010, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSKMINIGUN, 0x001c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REAPER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x18, 0x00ae, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_REAPER_SLAYER_SKEDAR, -1, -1, 1000, 50, 0x40002000, 0x00000010, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSKMINIGUN, 0x0018, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REAPER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x19, 0x00af, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_REAPER_SLAYER_SKEDAR, -1, -1, 1000, 50, 0x40002000, 0x00000010, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSKMINIGUN, 0x0019, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REAPER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1a, 0x00b0, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_REAPER_SLAYER_SKEDAR, -1, -1, 1000, 50, 0x40002000, 0x00000010, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSKMINIGUN, 0x001a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REAPER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x11, 0x00b1, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00de, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x12, 0x00b2, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00de, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x13, 0x00b3, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00de, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x14, 0x00b4, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00de, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x1b, 0x00b5, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_REAPER_SLAYER_SKEDAR, -1, -1, 1000, 9, 0x40002000, 0x00000010, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSKMINIGUN, 0x001b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REAPER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1d, 0x00b6, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_REAPER_SLAYER_SKEDAR, -1, -1, 1000, 9, 0x40002000, 0x00000010, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSKMINIGUN, 0x001d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REAPER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x15, 0x00b7, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00df, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x16, 0x00b8, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_CLOAKED_SKEDAR, 0x00df, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x1e, 0x00b9, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_REAPER_SLAYER_SKEDAR, -1, -1, 1000, 9, 0x40002000, 0x00000010, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSKMINIGUN, 0x001e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REAPER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1f, 0x00ba, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_REAPER_SLAYER_SKEDAR, -1, -1, 1000, 9, 0x40002000, 0x00000010, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSKMINIGUN, 0x001f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REAPER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x23, 0x00bb, BODY_MINISKEDAR, HEAD_RANDOM, AILIST_MINISKEDAR_SPAWNER, 0x00e0, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x24, 0x00bc, BODY_MINISKEDAR, HEAD_RANDOM, AILIST_MINISKEDAR_SPAWNER, 0x00e1, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x25, 0x00bd, BODY_MINISKEDAR, HEAD_RANDOM, AILIST_MINISKEDAR_SPAWNER, 0x00e1, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x26, 0x00be, BODY_MINISKEDAR, HEAD_RANDOM, AILIST_PUZZLEROOM_MINISKEDAR_WAITING, -1, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x28, 0x00bf, BODY_MINISKEDAR, HEAD_RANDOM, AILIST_MINISKEDAR_SPAWNER, 0x00e2, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x29, 0x00c0, BODY_MINISKEDAR, HEAD_RANDOM, AILIST_MINISKEDAR_SPAWNER, 0x00e3, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x2a, 0x00c2, BODY_MINISKEDAR, HEAD_RANDOM, AILIST_MINISKEDAR_SPAWNER, 0x00e4, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x20, 0x00c3, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_REAPER_SLAYER_SKEDAR, -1, -1, 1000, 30, 0x40002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x02000500)
	weapon(0x0100, MODEL_CHRSKROCKET, 0x0020, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SLAYER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x21, 0x00c4, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_REAPER_SLAYER_SKEDAR, -1, -1, 1000, 30, 0x40002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x02000500)
	weapon(0x0100, MODEL_CHRSKROCKET, 0x0021, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SLAYER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x22, 0x00c5, BODY_SKEDAR, HEAD_RANDOM, AILIST_INIT_REAPER_SLAYER_SKEDAR, -1, -1, 1000, 30, 0x40002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x02000a00)
	weapon(0x0100, MODEL_CHRSKMINIGUN, 0x0022, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REAPER, 0x00ffffff, 0x00000000)
	chr(0x00000100, 0x2c, 0x00c6, BODY_SKEDAR, HEAD_RANDOM, AILIST_MAULER_SKEDAR, -1, -1, 1000, 9, 0x04000000, 0x40000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x002c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000100, 0x2d, 0x00c7, BODY_SKEDAR, HEAD_RANDOM, AILIST_MAULER_SKEDAR, -1, -1, 1000, 9, 0x04000000, 0x40000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x002d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000100, 0x2e, 0x00c8, BODY_SKEDAR, HEAD_RANDOM, AILIST_MAULER_SKEDAR, -1, -1, 1000, 9, 0x04000000, 0x40000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x002e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000100, 0x2f, 0x00c9, BODY_SKEDAR, HEAD_RANDOM, AILIST_MAULER_SKEDAR, -1, -1, 1000, 9, 0x04000000, 0x40000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x002f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000100, 0x30, 0x00ca, BODY_SKEDAR, HEAD_RANDOM, AILIST_MAULER_SKEDAR, -1, -1, 1000, 9, 0x04000000, 0x40000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0030, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000100, 0x31, 0x00cb, BODY_SKEDAR, HEAD_RANDOM, AILIST_MAULER_SKEDAR, -1, -1, 1000, 9, 0x04000000, 0x40000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0031, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000100, 0x32, 0x00cc, BODY_SKEDAR, HEAD_RANDOM, AILIST_MAULER_SKEDAR, -1, -1, 1000, 9, 0x04000000, 0x40000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRMAULER, 0x0032, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x33, 0x00cd, BODY_SKEDARKING, HEAD_RANDOM, AILIST_HIDE, -1, -1, 1000, 9, 0x04000000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_KINGSCEPTRE, 0x0033, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_ROCKETLAUNCHER_34, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x34, 0x00ce, BODY_SKEDAR, HEAD_RANDOM, AILIST_KING_SKEDAR_SPAWNER, -1, -1, 1000, 9, 0x00000004, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	ammocrate(0x0100, MODEL_CHRUZI, 0x0034, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_FARSIGHT)
	chr(0x00000000, 0x35, 0x00cf, BODY_MINISKEDAR, HEAD_RANDOM, AILIST_KING_MINISKEDAR_SPAWNER, -1, -1, 1000, 9, 0x00000004, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00010000, 0x36, 0x00d9, BODY_ELVISWAISTCOAT, HEAD_ELVIS, AILIST_HIDE, -1, -1, 1000, 200, 0x00002000, 0x00300000, TEAM_ALLY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00004000, 0x37, 0x000f, BODY_SKEDAR, HEAD_RANDOM, AILIST_HIDE, 0x00d8, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00004000, 0x38, 0x0010, BODY_SKEDAR, HEAD_RANDOM, AILIST_HIDE, 0x00d8, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00004000, 0x39, 0x0011, BODY_SKEDAR, HEAD_RANDOM, AILIST_HIDE, 0x00d8, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00004000, 0x3a, 0x0012, BODY_SKEDAR, HEAD_RANDOM, AILIST_HIDE, 0x00d8, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00004000, 0x3b, 0x0018, BODY_SKEDARKING, HEAD_RANDOM, GAILIST_IDLE, 0x00d8, -1, 1000, 9, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_KINGSCEPTRE, 0x003b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_NONE, 0x00ffffff, 0x00000000)
	link_scenery(1, 0, 2)
	debris(0x0100, MODEL_SKCREV_UNEXP1, 0x00e5, 0x035005e8, 0x00304300, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	debris(0x0100, MODEL_SKCREV_EXP1, 0x00e6, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x44, 1)
	remote_mine(0x0100, MODEL_CHRPROXIMITYMINE, 0x00e6, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x21000000, 0x00000001, 0x00000000)
	link_scenery(1, 0, 2)
	door(0x0100, MODEL_SKTNL_UNEXP1, 0x00e7, 0x13500d00, 0x20304300, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00010000, 0x03e80000, 0x03e80000, 0x00010000, 0x00000000, 0x00000080, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_SKTNL_EXP1, 0x00e8, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x4d, -2)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_PILLARLEFT, 0x013d, 0x035004e8, 0x00104300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_PILLARLEFT, 0x013e, 0x035004e8, 0x00104300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_PILLARLEFT, 0x013f, 0x035004e8, 0x00104300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_PILLARLEFT, 0x0140, 0x035004e8, 0x00104300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_PILLARRIGHT, 0x0141, 0x035004e8, 0x00104300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_PILLARRIGHT, 0x0142, 0x075005e8, 0x00104300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_PILLARRIGHT, 0x0143, 0x035004e8, 0x00104300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_PILLARRIGHT, 0x0144, 0x035004e8, 0x00104300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x19, 5)
	tag(0x1a, 5)
	tag(0x1b, 5)
	tag(0x1c, 5)
	tag(0x1d, 5)
	stdobject(0x0100, MODEL_SK_FL_SHAD_ML, 0x014b, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_SK_FL_SHAD_MR, 0x014c, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_SK_FL_SHAD_BL, 0x014d, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_SK_FL_SHAD_BR, 0x014e, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_SK_FL_SHAD_T, 0x014a, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1e, 5)
	tag(0x1f, 5)
	tag(0x20, 5)
	tag(0x21, 5)
	tag(0x22, 5)
	stdobject(0x0100, MODEL_SK_FL_NOSHAD_ML, 0x014b, 0x035204e8, 0x00384300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_SK_FL_NOSHAD_MR, 0x014c, 0x035204e8, 0x00384300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_SK_FL_NOSHAD_BL, 0x014d, 0x035204e8, 0x00384300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_SK_FL_NOSHAD_BR, 0x014e, 0x035204e8, 0x00384300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_SK_FL_NOSHAD_T, 0x014a, 0x035204e8, 0x00384300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x01, 3)
	tag(0x2a, 2)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_TEMPLECOLUMN4, 0x0111, 0x035005e8, 0x80126300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x02, 3)
	tag(0x2b, 2)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_TEMPLECOLUMN2, 0x010a, 0x035005e8, 0x80126300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x41, -1)
	tag(0x03, 3)
	tag(0x2c, 2)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_TEMPLECOLUMN3, 0x010b, 0x035005e8, 0x80126300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2d, 2)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_TEMPLECOLUMN2, 0x010c, 0x035005e1, 0x80126300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2e, 2)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_TEMPLECOLUMN3, 0x010d, 0x035005e1, 0x80126300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2f, 5)
	tag(0x30, 5)
	tag(0x31, 5)
	tag(0x32, 5)
	tag(0x33, 5)
	stdobject(0x0019, MODEL_CHRREMOTEMINE, 0x00d5, 0x012204e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_CHRREMOTEMINE, 0x010a, 0x012204e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_CHRREMOTEMINE, 0x010b, 0x012204e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_CHRREMOTEMINE, 0x010c, 0x012204e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0019, MODEL_CHRREMOTEMINE, 0x010d, 0x012204e8, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x27, -3)
	tag(0x28, -3)
	tag(0x29, -3)
	tag(0x3e, 1)
	stdobject(0x0100, MODEL_SK_SUNSHAD1, 0x014f, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3d, 1)
	stdobject(0x0100, MODEL_SK_SUNSHAD2, 0x0150, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x4e, 2)
	tag(0x4f, 2)
	stdobject(0x0100, MODEL_SK_SUNNOSHAD1, 0x014f, 0x035204e8, 0x00384300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_SK_SUNNOSHAD2, 0x0150, 0x035204e8, 0x00384300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	door(0x0100, MODEL_SK_DOOR1, 0x00eb, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00ec, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00ed, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00ee, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00ef, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00f0, 0x10000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x09, 2)
	tag(0x0a, 2)
	door(0x0100, MODEL_SK_DOOR1, 0x00f1, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00f2, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0d, 2)
	tag(0x0e, 2)
	door(0x0100, MODEL_SK_DOOR1, 0x00f3, 0x10000000, 0x28000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00f4, 0x10000000, 0x30000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x45, 2)
	tag(0x46, 2)
	door(0x0100, MODEL_SK_DOOR1, 0x00f5, 0x10000000, 0x30000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000080, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00f6, 0x10000000, 0x28000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000080, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0f, 2)
	tag(0x10, 2)
	door(0x0100, MODEL_SK_DOOR1, 0x00f7, 0x10000000, 0x30000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00f8, 0x10000000, 0x28000000, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x11, 2)
	tag(0x12, 2)
	door(0x0100, MODEL_SK_DOOR1, 0x00f9, 0x10000000, 0x28000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000080, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_DOOR1, 0x00fa, 0x10000000, 0x30000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00001999, 0x00014000, 0x00000666, 0x00000000, 0x00000080, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000400, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0c, 1)
	vent_fan(0x0100, MODEL_SK_UNDER_GENERATOR, 0x0126, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_SK_UNDER_TRANS, 0x0127, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	vent_fan(0x0100, MODEL_SK_UNDER_TRANS, 0x0128, 0x000204e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000444, 0x00000000, 0x00000002, 0x01000000)
	tag(0x4c, 1)
	stdobject(0x00e6, MODEL_SKPUZZLEOBJECT, 0x012c, 0x010201e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x05, 1)
	lift(0x0100, MODEL_SKEDARBRIDGE, 0x0135, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0135, 0x0134, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000471c, 0x00a6aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x08, 1)
	stdobject(0x0100, MODEL_TARGETAMP, 0x0001, 0x012405e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	rename_object(-1, 0x3f, L_SHO(20), L_SHO(21), L_SHO(22), L_SHO(23), L_SHO(24), 0x0000, 0x0000) // "Obtain Target Amplifier."
	tag(0x35, 1)
	stdobject(0x0100, MODEL_TARGETAMP, 0x0001, 0x012405e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	rename_object(-1, 0x3f, L_SHO(20), L_SHO(21), L_SHO(22), L_SHO(23), L_SHO(24), 0x0000, 0x0000) // "Obtain Target Amplifier."
	tag(0x0b, 1)
	multimonitor(0x0019, MODEL_COMHUB, 0x0137, 0x00420002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(0x13, 1)
	stdobject(0x0100, MODEL_SK_PLINTH_ML, 0x0146, 0x010405e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000bb8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x14, 1)
	stdobject(0x0100, MODEL_SK_PLINTH_MR, 0x0147, 0x010405e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000bb8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x15, 1)
	stdobject(0x0100, MODEL_SK_PLINTH_BL, 0x0149, 0x010405e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000bb8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x16, 1)
	stdobject(0x0100, MODEL_SK_PLINTH_BR, 0x0148, 0x010405e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000bb8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x17, 1)
	stdobject(0x0100, MODEL_SK_PLINTH_T, 0x0145, 0x010405e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000bb8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x012d, 0x00000101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	weapon(0x0100, MODEL_CHRMAULER, 0xffff, 0x00008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x012e, 0x00000101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	weapon(0x0100, MODEL_CHRMAULER, 0xffff, 0x00008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x012f, 0x00000101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	weapon(0x0100, MODEL_CHRMAULER, 0xffff, 0x00008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0130, 0x00000101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	weapon(0x0100, MODEL_CHRMAULER, 0xffff, 0x00008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	tag(0x23, 1)
	stdobject(0x0019, MODEL_RUBBLE1, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x24, 1)
	stdobject(0x0019, MODEL_RUBBLE2, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x25, 1)
	stdobject(0x0019, MODEL_RUBBLE3, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x26, 1)
	stdobject(0x0019, MODEL_RUBBLE4, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x37, 1)
	stdobject(0x0019, MODEL_SK_JONRUBBLE3, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x38, 1)
	stdobject(0x0019, MODEL_SK_JONRUBBLE4, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x39, 1)
	stdobject(0x0019, MODEL_SK_JONRUBBLE5, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3a, 1)
	stdobject(0x0019, MODEL_SK_JONRUBBLE6, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3b, 1)
	stdobject(0x0019, MODEL_SK_JONRUBBLE3, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3c, 1)
	stdobject(0x0019, MODEL_RUBBLE3, 0xffff, 0x000215e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_TEMPLECOLUMN2, 0x010e, 0x035005e1, 0x80106300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_TEMPLECOLUMN2, 0x010f, 0x035005e1, 0x80106300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 0)
	debris(0x0100, MODEL_SK_TEMPLECOLUMN2, 0x0110, 0x035005e1, 0x80106300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x36, 1)
	stdobject(0x0100, MODEL_SK_SHUTTLE, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x00fc, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x00fb, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x00fd, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x00fe, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x0100, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x00ff, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x0101, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x0102, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x0104, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x0103, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x0106, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x0105, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_BOT, 0x0107, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SK_CRYOPOD1_TOP, 0x0108, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000eb68, 0x0000eb68, 0x0001aaaa, 0x00002aaa, 0x00002aaa, 0x00000004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00001100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x47, 1)
	weapon(0x0100, MODEL_CHRFALCON2SCOPE, 0x00d6, 0x00100000, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2_SCOPE, 0x00ffffff, 0x00000000)
	tag(0x48, 1)
	weapon(0x0100, MODEL_CHRDEVASTATOR, 0x00d6, 0x00100000, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DEVASTATOR, 0x00ffffff, 0x00000000)
	tag(0x49, 1)
	weapon(0x0100, MODEL_CHRMAIANSMG, 0x00d6, 0x00100000, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CALLISTONTG, 0x00ffffff, 0x00000000)
	tag(0x4a, 1)
	weapon(0x0100, MODEL_CHRMAULER, 0x00d6, 0x00100000, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAULER, 0x00ffffff, 0x00000000)
	tag(0x4b, 1)
	weapon(0x0100, MODEL_CHRSKROCKET, 0x00d6, 0x00100000, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SLAYER, 0x00ffffff, 0x00000000)
	tag(0x50, 2)
	tag(0x51, 2)
	stdobject(0x0100, MODEL_BUDDYBRIDGE, 0x00ea, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_SK_TEMPLECOLUMN4, 0x0131, 0x035205e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3f, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x0151, 0x00000001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x40, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x00ba, 0x00000001, 0x000000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x42, 2)
	tag(0x43, 2)
	weapon(0x0100, MODEL_CHRMAIANPISTOL, 0x0032, 0x00100001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_PHOENIX, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRMAIANPISTOL, 0x0032, 0x00100001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_PHOENIX, 0x00ffffff, 0x00000000)
	link_collectibles(-1, -2)
	pad_effect(PADEFFECT_SPARKS, 0x0112)
	pad_effect(PADEFFECT_SPARKS, 0x0117)
	pad_effect(PADEFFECT_SPARKS, 0x0113)
	pad_effect(PADEFFECT_SPARKS, 0x0114)
	pad_effect(PADEFFECT_SPARKS, 0x0115)
	pad_effect(PADEFFECT_SPARKS, 0x0116)
	pad_effect(PADEFFECT_SPARKS, 0x0118)
	pad_effect(PADEFFECT_SPARKS, 0x0119)
	pad_effect(PADEFFECT_SPARKS, 0x011a)
	pad_effect(PADEFFECT_SPARKS, 0x011b)
	pad_effect(PADEFFECT_SPARKS, 0x011c)
	pad_effect(PADEFFECT_SPARKS, 0x011d)
	pad_effect(PADEFFECT_SPARKS, 0x011e)
	pad_effect(PADEFFECT_SPARKS, 0x011f)
	pad_effect(PADEFFECT_SPARKS, 0x0120)
	pad_effect(PADEFFECT_SPARKS, 0x0121)
	pad_effect(PADEFFECT_SPARKS, 0x0122)
	pad_effect(PADEFFECT_SPARKS, 0x0123)
	pad_effect(PADEFFECT_SPARKS, 0x0124)
	pad_effect(PADEFFECT_SPARKS, 0x0125)
	pad_effect(PADEFFECT_SMOKE_TEMPORARY, 0x0025)
	pad_effect(PADEFFECT_SMOKE_TEMPORARY, 0x008c)
	pad_effect(PADEFFECT_SMOKE_TEMPORARY, 0x0028)
	pad_effect(PADEFFECT_SMOKE_TEMPORARY, 0x0029)
	pad_effect(PADEFFECT_SMOKE_TEMPORARY, 0x002a)
	pad_effect(PADEFFECT_SMOKE_TEMPORARY, 0x0023)
	pad_effect(PADEFFECT_SMOKE_TEMPORARY, 0x0027)
	pad_effect(PADEFFECT_SMOKE_TEMPORARY, 0x0026)
	pad_effect(PADEFFECT_SMOKE_TEMPORARY, 0x0006)
	pad_effect(PADEFFECT_SMOKE_TEMPORARY, 0x00d9)
	pad_effect(PADEFFECT_SMOKE_TEMPORARY, 0x00a3)
	pad_effect(PADEFFECT_SMOKE_TEMPORARY, 0x000c)
	endprops
};

s32 intro[] = {
	outfit(OUTFIT_DEFAULT)
	intro_weapon(WEAPON_FALCON2_SCOPE, -1)
	ammo(AMMOTYPE_PISTOL, 200)
	intro_weapon(WEAPON_CALLISTONTG, -1)
	ammo(AMMOTYPE_SMG, 300)
	ammo(AMMOTYPE_BUG, 3)
	intro_weapon(WEAPON_DEVASTATOR, -1)
	ammo(AMMOTYPE_DEVASTATOR, 4)
	intro_weapon(WEAPON_IRSCANNER, -1)
	intro_weapon(WEAPON_RTRACKER, -1)
	spawn(0x0000)
	endintro
};

u8 func0401_init_unarmed_skedar[] = {
	set_accuracy(0)
	set_reaction_speed(75)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(160)
	set_recovery_speed(0)
	set_shield(0)
	set_self_chrflag(CHRCFLAG_00020000)
	set_ailist(CHR_SELF, AILIST_UNARMED_SKEDAR)
	endlist
};

u8 func0402_unarmed_skedar[] = {
	set_shotlist(AILIST_UNARMED_SKEDAR)
	set_action(MA_NORMAL, TRUE)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2d)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2d)
	goto_next(0x06)

	// Dying
	label(0x2d)
	set_shotlist(GAILIST_IDLE)
	yield
	restart_timer

	beginloop(0x11)
		if_timer_gt(30, /*goto*/ 0x2d)
	endloop(0x11)

	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
#define LABEL_HANDLE_PHOENIX_AREA 0x5a
#define LABEL_HANDLE_WALL_AREA    0x5b

	// Alive
	label(0x06)
	set_action(MA_NORMAL, TRUE)
	stop_chr
	if_self_flag_bankx_eq(CHRFLAG0_00000004, FALSE, BANK_0, /*goto*/ 0x03)
	set_action(MA_TRACKING, TRUE)
	try_run_to_target(/*goto*/ 0x03)

	beginloop(0x03)
		if_chr_in_room(CHR_SELF, 0x00, 0x003b, /*goto*/ LABEL_HANDLE_PHOENIX_AREA)
		if_chr_in_room(CHR_SELF, 0x00, 0x0041, /*goto*/ LABEL_HANDLE_WALL_AREA)
		if_self_flag_bankx_eq(CHRFLAG0_AIVSAI, FALSE, BANK_0, /*goto*/ 0x2e)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x2d)
		label(0x2e)
		set_target_chr(CHR_BOND)
		if_chr_sees_player(/*goto*/ 0x2d)
		set_target_chr(CHR_COOP)
		if_chr_sees_player(/*goto*/ 0x2d)
		if_self_flag_bankx_eq(CHRFLAG0_00000004, FALSE, BANK_0, /*goto*/ 0x2e)
		if_just_injured(CHR_SELF, /*goto*/ 0x2d)

		label(0x2e)
		call_rng
		if_rand_gt(1, /*goto*/ 0x06)
		say_quip(CHR_BOND, 0x03, 0xff, 0x05, 0xff, BANK_0, 0x00, 0x00)
		label(0x06)
	endloop(0x03)

	// Injured or detected enemy
	label(0x2d)
	label(0xd9)
	yield
	if_chr_in_room(CHR_SELF, 0x00, 0x003b, /*goto*/ LABEL_HANDLE_PHOENIX_AREA)
	if_chr_in_room(CHR_SELF, 0x00, 0x0041, /*goto*/ LABEL_HANDLE_WALL_AREA)
	if_self_flag_bankx_eq(CHRFLAG0_AIVSAI, FALSE, BANK_0, /*goto*/ 0x2e)
	if_enemy_distance_lt_and_los(2540, /*goto*/ 0x2e)
	label(0x2e)
	set_chr_cloaked(CHR_SELF, FALSE, TRUE)
	say_quip(CHR_BOND, 0x01, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	if_distance_to_target_lt(150, /*goto*/ 0x2f)
	label(0x54)
	if_num_times_shot_lt(1, /*goto*/ 0x2d)
	goto_next(0x06)

	label(0x2d)
	label(0x2d)
	restart_timer
	set_action(MA_WAITING, TRUE)
	say_quip(CHR_BOND, 0x03, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	try_walk_to_target(/*goto*/ 0x08)

	beginloop(0x08)
		if_chr_in_room(CHR_SELF, 0x00, 0x003b, /*goto*/ LABEL_HANDLE_PHOENIX_AREA)
		if_chr_in_room(CHR_SELF, 0x00, 0x0041, /*goto*/ LABEL_HANDLE_WALL_AREA)
		if_timer_gt(120, /*goto*/ 0x09)
	endloop(0x08)

	label(0x09)
	label(0x0a)
	if_chr_propsoundcount_zero(CHR_SELF, /*goto*/ 0x2d)
	goto_next(0x2d)

	label(0x06)
	say_quip(CHR_BOND, 0x01, 0x20, 0x00, 0xff, BANK_0, 0x00, 0x00)
	label(0x2d)
	restart_timer
	set_action(MA_TRACKING, TRUE)
	try_run_to_target(/*goto*/ 0x0b)

	beginloop(0x0b)
		if_chr_has_hiddenflag(CHR_TARGET, CHRHFLAG_CLOAKED, /*goto*/ 0x10)
		if_chr_in_room(CHR_SELF, 0x00, 0x003b, /*goto*/ LABEL_HANDLE_PHOENIX_AREA)
		if_chr_in_room(CHR_SELF, 0x00, 0x0041, /*goto*/ LABEL_HANDLE_WALL_AREA)
		if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x10)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x10)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x10)
		if_target_moving_away(/*goto*/ 0x2d)
		if_distance_to_target_lt(150, /*goto*/ 0x2f)
		label(0x2d)
		if_distance_to_target_lt(50, /*goto*/ 0x2f)
		if_timer_gt(30, /*goto*/ 0x06)
	endloop(0x0b)

	label(0x06)
	goto_first(0x0a)

	label(0x2f)
	restart_timer
	dprint 'F','A','C','E',' ','T','A','R','G','E','T','\n',0,
	if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
	if_jo_ccw_direction_gt(246, /*goto*/ 0x06)
	stop_chr
	set_action(MA_FACING, TRUE)
	try_face_entity(0x0200, 0x0001, /*goto*/ 0x0c)

	beginloop(0x0c)
		if_chr_has_hiddenflag(CHR_TARGET, CHRHFLAG_CLOAKED, /*goto*/ 0x10)
		if_chr_in_room(CHR_SELF, 0x00, 0x003b, /*goto*/ LABEL_HANDLE_PHOENIX_AREA)
		if_chr_in_room(CHR_SELF, 0x00, 0x0041, /*goto*/ LABEL_HANDLE_WALL_AREA)
		if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x10)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x10)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x10)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_jo_ccw_direction_gt(246, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x0c)

	label(0x06)
	set_action(MA_PUNCHING, TRUE)
	try_punch_or_kick(/*goto*/ 0x31)
	goto_first(0xd9)

	// Punching or kicking
	label(0x31)

	beginloop(0x30)
		if_chr_has_hiddenflag(CHR_TARGET, CHRHFLAG_CLOAKED, /*goto*/ 0x10)
		if_chr_in_room(CHR_SELF, 0x00, 0x003b, /*goto*/ LABEL_HANDLE_PHOENIX_AREA)
		if_chr_in_room(CHR_SELF, 0x00, 0x0041, /*goto*/ LABEL_HANDLE_WALL_AREA)
		if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x10)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x10)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x10)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x30)

	// Finished attack
	label(0x06)
	if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x10)
	if_chr_dying(CHR_TARGET, /*goto*/ 0x10)
	if_chr_unloaded(CHR_TARGET, /*goto*/ 0x10)
	goto_first(0xd9)

	// Killed target
	label(0x10)
	stop_chr
	unset_self_flag_bankx(CHRFLAG0_00000004, BANK_0)
	goto_first(0x03)

	// At ledge near Phoenix
	label(LABEL_HANDLE_PHOENIX_AREA)
	stop_chr
	set_chr_cloaked(CHR_SELF, TRUE, TRUE)
	restart_timer
	run_to_pad(0x0018)

	beginloop(0x5c)
		if_chr_stopped(/*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0020, /*goto*/ 0x2d) // at T junction near Phoenix
	endloop(0x5c)

	label(0x2d)
	set_self_flag_bankx(CHRFLAG0_00000004, BANK_0)
	goto_first(0x03)

	// At ledge prior to grenadable wall
	label(LABEL_HANDLE_WALL_AREA)
	stop_chr
	set_chr_cloaked(CHR_SELF, TRUE, TRUE)
	restart_timer
	run_to_pad(0x003c)

	beginloop(0x5c)
		if_chr_stopped(/*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0045, /*goto*/ 0x2d) // at weak wall
	endloop(0x5c)

	label(0x2d)
	set_self_flag_bankx(CHRFLAG0_00000004, BANK_0)
	goto_first(0x03)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0405_puzzleroom_miniskedar_waiting[] = {
	stop_chr

	beginloop(0x03)
		if_self_flag_bankx_eq(CHRFLAG0_AIVSAI, FALSE, BANK_0, /*goto*/ 0x2e)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x2d)

		label(0x2e)
		set_target_chr(CHR_BOND)
		if_chr_sees_player(/*goto*/ 0x2d)
		set_target_chr(CHR_COOP)
		if_chr_sees_player(/*goto*/ 0x2d)
		if_just_injured(CHR_SELF, /*goto*/ 0x2d)
	endloop(0x03)

	// Detected player
	label(0x2d)
	set_ailist(CHR_SELF, AILIST_INIT_MINISKEDAR)
	endlist
};

u8 func0403_init_miniskedar[] = {
	set_self_chrflag(CHRCFLAG_00020000)
	set_accuracy(0)
	set_reaction_speed(75)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_self_chrflag(CHRCFLAG_00080000)
	set_ailist(CHR_SELF, AILIST_MINISKEDAR)
	endlist
};

u8 func0404_miniskedar[] = {
	set_shotlist(AILIST_MINISKEDAR)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2d)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2d)
	goto_next(0x06)

	// Dying
	label(0x2d)
	yield
	restart_timer

	beginloop(0x11)
		if_timer_gt(30, /*goto*/ 0x2d)
	endloop(0x11)

	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x06)
	label(0x03)
	yield
	if_self_flag_bankx_eq(CHRFLAG0_AIVSAI, FALSE, BANK_0, /*goto*/ 0x2e)
	if_enemy_distance_lt_and_los(2540, /*goto*/ 0x2d)

	label(0x2e)
	if_chr_sees_player(/*goto*/ 0x2d)
	if_just_injured(CHR_SELF, /*goto*/ 0x2d)

	// Healthy
	call_rng
	say_quip(CHR_BOND, 0x06, 0xff, 0x05, 0xff, BANK_0, 0x00, 0x00)
	label(0x06)
	label(0x06)
	goto_next(0x54)

	// Injured or detected enemy
	label(0x2d)
	set_self_flag_bankx(CHRFLAG0_00000004, BANK_0)
	if_distance_to_target_lt(400, /*goto*/ 0x2f)

	label(0x54)
	restart_timer
	label(0x09)
	restart_timer
	if_chr_propsoundcount_zero(CHR_SELF, /*goto*/ 0x2d)
	goto_next(0x06)

	label(0x2d)
	label(0x06)
	try_run_to_target(/*goto*/ 0x0b)

	beginloop(0x0b)
		if_self_flag_bankx_eq(CHRFLAG0_AIVSAI, FALSE, BANK_0, /*goto*/ 0x2e)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x2d)
		label(0x2e)
		if_chr_sees_player(/*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
		if_distance_to_target_lt(400, /*goto*/ 0x2f)
		label(0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x0b)

	label(0x06)
	goto_first(0x09)

	label(0x2f)
	restart_timer
	dprint 'F','A','C','E',' ','T','A','R','G','E','T','\n',0,
	stop_chr
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x0c)

	beginloop(0x0c)
		if_timer_gt(30, /*goto*/ 0x06)
	endloop(0x0c)

	label(0x2d)
	if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
	if_jo_ccw_direction_gt(246, /*goto*/ 0x06)
	goto_first(0x0c)

	label(0x06)
	if_distance_to_target_lt(200, /*goto*/ 0x2e)
	miniskedar_try_pounce(0x04, 0x000e, /*goto*/ 0x30)
	goto_first(0x03)

	beginloop(0x30)
		if_chr_stopped(/*goto*/ 0x2d)
	endloop(0x30)

	label(0x2d)
	restart_timer
	if_chr_injured_target(CHR_SELF, /*goto*/ 0x2d)
	goto_next(0x06)

	label(0x2d)
	label(0x2e)
	retreat(SPEED_RUN, 1)

	beginloop(0x0d)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x0d)

	label(0x06)
	goto_first(0x03)

	endlist
};

/**
 * Spawn a clone and remove self. This function seems unnecessary.
 */
u8 func0407_init_cloaked_skedar[] = {
	set_self_chrflag(CHRCFLAG_00000002)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_00040000)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_CLOAKED)

	beginloop(0x04)
		// Wait until clone dead - which it would be immediately?
		chr_toggle_p1p2(CHR_SELF)
		label(0x4f)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x4f)
		reloop(0x04)

		// Spawn clone
		label(0x4f)
		try_spawn_clone2(CHR_SELF, AILIST_CLOAKED_SKEDAR, 0x00001010, /*goto*/ 0x2d)
		reloop(0x04)

		// Remove self
		label(0x2d)
		remove_chr(CHR_SELF)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		yield
	endloop(0x04)

	endlist
};

u8 func0408_cloaked_skedar[] = {
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	rebuild_teams
	rebuild_squadrons
	set_self_chrflag(CHRCFLAG_00040000)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_CLOAKED)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_00400000)
	restart_timer

	beginloop(0x08)
		if_objective_complete(4, /*goto*/ 0x0e)

		// King is alive
		chr_toggle_p1p2(CHR_SELF)
		if_chr_distance_to_pad_lt(CHR_P1P2, 300, PAD_PRESET, /*goto*/ 0x2d)

		// 1 in 256 chance of making skedar roar sound
		call_rng
		if_rand_gt(1, /*goto*/ 0x06)
		say_quip(CHR_BOND, 0x03, 0xff, 0x05, 0xff, BANK_0, 0x00, 0x00)
		label(0x06)
	endloop(0x08)

	// Player went close to cloaked skedar
	label(0x2d)
	unset_self_chrflag(CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, AILIST_INIT_UNARMED_SKEDAR)

	// King is dead
	label(0x0e)
	remove_chr(CHR_SELF)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Spawns up to 3 miniskedar clones, one at a time.
 */
u8 func0404_miniskedar_spawner[] = {
	set_self_chrflag(CHRCFLAG_00000002)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_00040000)
	set_morale(0)

	// Wait until player near trigger pad
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_distance_to_pad_lt(CHR_P1P2, 300, PAD_PRESET, /*goto*/ 0x4f)
		endloop(0x04)

		label(0x4f)
		if_morale_lt(3, /*goto*/ 0x06)
		goto_next(0x2e)

		label(0x06)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x4f)
		reloop(0x04)

		label(0x4f)
		try_spawn_clone2(CHR_SELF, AILIST_INIT_MINISKEDAR, 0x00000010, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		add_morale(1)
		label(0x2e)
		yield
	endloop(0x04)

	endlist
};

u8 unregistered_function3[] = {
	camera_movement(0x00c3)
	yield
	set_chr_hiddenflag(0x00, CHRHFLAG_00020000)
	chr_do_animation(0x00c4, -1, -1, 0x06, 0x00, 0x00, 4)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
	endloop(0x08)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1001_objectives_failed_msg[] = {
	yield
	give_object_to_chr(OBJ_TARGETAMP_BOND, CHR_BOND)
	give_object_to_chr(OBJ_TARGETAMP_COOP, CHR_COOP)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)

	label(0x2d)
	hide_object(OBJ_TARGETAMP_COOP)
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

u8 func1400_setup_counterop[] = {
	yield
	set_chr_team(CHR_ANTI, TEAM_ENEMY)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func1003_remove_random_skedar[] = {
	#define remove_random(chr1, chr2) \
		call_rng \
		if_rand_gt(128, /*goto*/ 0x2d) \
		remove_chr(chr1) \
		goto_next(0x06) \
		label(0x2d) \
		remove_chr(chr2) \
		label(0x06)



	remove_random(0x05, 0x06)
	remove_random(0x07, 0x08)
	remove_random(0x0b, 0x0c)
	remove_random(0x0f, 0x10)
	remove_random(0x11, 0x12)
	remove_random(0x13, 0x14)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101a_pointless[] = {
	beginloop(0x04)
		if_chr_death_animation_finished(CHR_KING1, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100c_check_army_defeated[] = {
	yield

	beginloop(0x04)
		if_chr_death_animation_finished(0x2c, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_death_animation_finished(0x2d, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_death_animation_finished(0x2e, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_death_animation_finished(0x2f, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_death_animation_finished(0x30, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_death_animation_finished(0x31, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_death_animation_finished(0x32, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	show_hudmsg(CHR_BOND, L_SHO(29)) // "Skedar secret army has been defeated."
	set_stage_flag(STAGEFLAG_ARMY_DEFEATED)

	beginloop(0x91)
		if_objective_complete(0, /*goto*/ 0x2d)
	endloop(0x91)

	label(0x2d)
	unset_object_flag2(0x45, OBJFLAG2_LOCKEDFRONT)
	unset_object_flag2(0x46, OBJFLAG2_LOCKEDBACK)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1005_5e0c[] = {
	yield

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
#if VERSION >= VERSION_PAL_FINAL
		if_object_distance_to_pad_lt(OBJ_PUZZLEROCK, 50, 0x00d4, /*goto*/ 0x41)
#else
		if_object_distance_to_pad_lt(OBJ_PUZZLEROCK, 50, 0x00d4, /*goto*/ 0x2d)
#endif
		if_chr_distance_to_pad_lt(CHR_P1P2, 50, 0x00d4, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x005f, /*goto*/ 0x2e)
		unset_stage_flag(STAGEFLAG_TRIGGER_BRIDGE)
	endloop(0x04)

	// Crossed bridge without using puzzle piece,
	// or one player crossed then another moved the piece off the pad
	label(0x2e)
	set_stage_flag(STAGEFLAG_CROSSED_RAVINE_WITHOUT_BRIDGE)
	set_stage_flag(STAGEFLAG_TRIGGER_BRIDGE)

#if VERSION >= VERSION_PAL_FINAL
	label(0x41)
	if_num_human_players_lt(2, /*goto*/ 0x2d)
	unset_object_flag3(OBJ_PUZZLEROCK, OBJFLAG3_PUSHABLE)
#endif

	// Pad pressed, or follow through from above
	label(0x2d)
	if_stage_flag_eq(STAGEFLAG_TRIGGER_BRIDGE, TRUE, /*goto*/ 0x2d)
	mute_channel(CHANNEL_5)
	assign_sound(0x0436, CHANNEL_5)
	control_sound_from_object(CHANNEL_5, OBJ_PUZZLEROCK, TRUE)

	// Wait for a condition that would cause the bridge to retract
	label(0x2d)
	restart_timer

	beginloop(0x91)
		if_stage_flag_eq(STAGEFLAG_CROSSED_RAVINE_WITHOUT_BRIDGE, TRUE, /*goto*/ 0x2d)
		if_timer_gt(60, /*goto*/ 0x2e)
		label(0x2d)
		if_timer_lt(20, /*goto*/ 0x06)
		if_stage_flag_eq(STAGEFLAG_CROSSED_RAVINE_WITHOUT_BRIDGE, TRUE, /*goto*/ 0x93)
		if_object_distance_to_pad_lt(OBJ_PUZZLEROCK, 50, 0x00d4, /*goto*/ 0x06)
		if_chr_distance_to_pad_lt(CHR_P1P2, 50, 0x00d4, /*goto*/ 0x06)
		goto_next(0x2e)

		label(0x06)
		reloop(0x91)

		label(0x93)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0057, /*goto*/ 0x06) // start side
	endloop(0x91)

	// Player crossed bridge without using switch, then crossed back
	label(0x06)
	unset_stage_flag(STAGEFLAG_CROSSED_RAVINE_WITHOUT_BRIDGE)
	unset_stage_flag(STAGEFLAG_TRIGGER_BRIDGE)
	goto_first(0x04)

	// Switch activated and bridge extended for 1 second
	label(0x2e)
	if_object_distance_to_pad_lt(OBJ_PUZZLEROCK, 50, 0x00d4, /*goto*/ 0x2d)
	if_chr_distance_to_pad_lt(CHR_P1P2, 50, 0x00d4, /*goto*/ 0x2d)

	// Switch no longer pressed
	mute_channel(CHANNEL_5)
	assign_sound(0x0437, CHANNEL_5)
	control_sound_from_object(CHANNEL_5, OBJ_PUZZLEROCK, TRUE)
	goto_first(0x04)

	// Switch still pressed
	label(0x2d)
	set_stage_flag(STAGEFLAG_TRIGGER_BRIDGE)
	goto_first(0x04)

	endlist
};

u8 func1006_bridge[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_BRIDGE, TRUE, /*goto*/ 0x2d)
		set_object_flag(OBJ_BRIDGE, OBJFLAG_DEACTIVATED)
	endloop(0x04)

	label(0x2d)
	unset_object_flag(OBJ_BRIDGE, OBJFLAG_DEACTIVATED)
	mute_channel(CHANNEL_4)
	assign_sound(0x8020, CHANNEL_4)
	play_sound_from_object(CHANNEL_4, OBJ_BRIDGE, 0x04b0, 0x0640)
	yield

	beginloop(0x08)
		if_lift_stationary(OBJ_BRIDGE, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	mute_channel(CHANNEL_4)
	assign_sound(0x8027, CHANNEL_4)
	control_sound_from_object(CHANNEL_4, OBJ_BRIDGE, TRUE)
	set_object_flag(OBJ_BRIDGE, OBJFLAG_DEACTIVATED)
	set_stage_flag(STAGEFLAG_BRIDGE_EXTENDED)

	beginloop(0x09)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_BRIDGE, FALSE, /*goto*/ 0x2d)
	endloop(0x09)

	label(0x2d)

	beginloop(0x91)
		if_sound_finished(CHANNEL_4, /*goto*/ 0x2d)
	endloop(0x91)

	label(0x2d)
	unset_object_flag(OBJ_BRIDGE, OBJFLAG_DEACTIVATED)
	mute_channel(CHANNEL_4)
	assign_sound(0x8020, CHANNEL_4)
	play_sound_from_object(CHANNEL_4, OBJ_BRIDGE, 0x04b0, 0x0640)
	yield

	beginloop(0x0b)
		if_lift_stationary(OBJ_BRIDGE, /*goto*/ 0x06)
	endloop(0x0b)

	label(0x06)
	unset_stage_flag(STAGEFLAG_BRIDGE_EXTENDED)
	set_object_flag(OBJ_BRIDGE, OBJFLAG_DEACTIVATED)
	mute_channel(CHANNEL_4)
	assign_sound(0x8027, CHANNEL_4)
	control_sound_from_object(CHANNEL_4, OBJ_BRIDGE, TRUE)
	goto_first(0x04)

	endlist
};

u8 func1007_bug_throws_bond[] = {
	beginloop(0x03)
		if_stage_flag_eq(STAGEFLAG_BOND_THREW_FIRST_BUG, FALSE, /*goto*/ 0x55)
		if_stage_flag_eq(STAGEFLAG_BOND_THREW_SECOND_BUG, FALSE, /*goto*/ 0x56)
		if_stage_flag_eq(STAGEFLAG_BOND_THREW_THIRD_BUG, FALSE, /*goto*/ 0x57)

		label(0x55)
		dprint 'C','H','E','C','K',' ','1','\n',0,
		if_ammo_quantity_lt(CHR_BOND, AMMOTYPE_BUG, 3, /*goto*/ 0x2d)
	endloop(0x03)

	// Threw first
	label(0x2d)
	dprint 'F','I','R','E',' ','1','\n',0,
	set_stage_flag(STAGEFLAG_BOND_THREW_FIRST_BUG)
	goto_next(0x0e)

	// Check for second
	label(0x56)
	dprint 'C','H','E','C','K',' ','2','\n',0,
	label(0x2d)
	if_ammo_quantity_lt(CHR_BOND, AMMOTYPE_BUG, 2, /*goto*/ 0x2d)
	goto_first(0x03)

	label(0x2d)
	set_stage_flag(STAGEFLAG_BOND_THREW_SECOND_BUG)
	goto_next(0x0e)

	// Check for third
	label(0x57)
	dprint 'C','H','E','C','K',' ','3','\n',0,
	if_ammo_quantity_lt(CHR_BOND, AMMOTYPE_BUG, 1, /*goto*/ 0x2d)
	goto_first(0x03)

	label(0x2d)
	set_stage_flag(STAGEFLAG_BOND_THREW_THIRD_BUG)
	goto_next(0x0e)

	beginloop(0x0e)
		if_weapon_thrown(WEAPON_TARGETAMPLIFIER, /*goto*/ 0x06)
	endloop(0x0e)

	label(0x06)
	restart_timer

	beginloop(0x08)
		dprint 'A','T',' ','R','E','S','T','\n',0,
		if_stage_flag_eq(STAGEFLAG_PILLAR1_MARKED, TRUE, /*goto*/ 0x2d)
		if_weapon_thrown_on_object(WEAPON_TARGETAMPLIFIER, OBJ_PILLAR1, /*goto*/ 0x09)
		label(0x2d)
		if_stage_flag_eq(STAGEFLAG_PILLAR2_MARKED, TRUE, /*goto*/ 0x2d)
		if_weapon_thrown_on_object(WEAPON_TARGETAMPLIFIER, OBJ_PILLAR2, /*goto*/ 0x0b)
		label(0x2d)
		if_stage_flag_eq(STAGEFLAG_PILLAR3_MARKED, TRUE, /*goto*/ 0x2d)
		if_weapon_thrown_on_object(WEAPON_TARGETAMPLIFIER, OBJ_PILLAR3, /*goto*/ 0x0c)
		label(0x2d)
		if_timer_gt(120, /*goto*/ 0x0d)
	endloop(0x08)

	label(0x09)
	dprint '1',' ','P','L','A','C','E','D','\n',0,
	if_stage_flag_eq(STAGEFLAG_PILLAR1_MARKED, TRUE, /*goto*/ 0x0d)
	set_stage_flag(STAGEFLAG_PILLAR1_MARKED)
	show_hudmsg(CHR_BOND, L_SHO(25)) // "Target Amplifier placed correctly."
	if_ammo_quantity_lt(CHR_BOND, AMMOTYPE_BUG, 1, /*goto*/ 0x0d)
	goto_first(0x03)

	label(0x0b)
	dprint '2',' ','P','L','A','C','E','D','\n',0,
	if_stage_flag_eq(STAGEFLAG_PILLAR2_MARKED, TRUE, /*goto*/ 0x0d)
	set_stage_flag(STAGEFLAG_PILLAR2_MARKED)
	show_hudmsg(CHR_BOND, L_SHO(25)) // "Target Amplifier placed correctly."
	if_ammo_quantity_lt(CHR_BOND, AMMOTYPE_BUG, 1, /*goto*/ 0x0d)
	goto_first(0x03)

	label(0x0c)
	dprint '3',' ','P','L','A','C','E','D','\n',0,
	if_stage_flag_eq(STAGEFLAG_PILLAR3_MARKED, TRUE, /*goto*/ 0x0d)
	set_stage_flag(STAGEFLAG_PILLAR3_MARKED)
	show_hudmsg(CHR_BOND, L_SHO(25)) // "Target Amplifier placed correctly."
	if_ammo_quantity_lt(CHR_BOND, AMMOTYPE_BUG, 1, /*goto*/ 0x0d)
	goto_first(0x03)

	label(0x0d)
	dprint 'P','L','L','A','C','E','D',' ','W','R','O','N','G','\n',0,
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2e)
	if_stage_flag_eq(STAGEFLAG_COOP_BUGS_WASTED, TRUE, /*goto*/ 0x2d)
	goto_next(0x0f)

	label(0x2d)
	if_ammo_quantity_lt(CHR_BOND, AMMOTYPE_BUG, 1, /*goto*/ 0x2e)
	goto_next(0x0f)

	label(0x2e)
	if_stage_flag_eq(STAGEFLAG_PILLAR1_MARKED, FALSE, /*goto*/ 0x06)
	if_stage_flag_eq(STAGEFLAG_PILLAR2_MARKED, FALSE, /*goto*/ 0x06)
	if_stage_flag_eq(STAGEFLAG_PILLAR3_MARKED, FALSE, /*goto*/ 0x06)
	goto_next(0x2d)

	label(0x06)
	set_stage_flag(STAGEFLAG_BOND_BUGS_WASTED)
	if_stage_flag_eq(STAGEFLAG_COOP_BUGS_WASTED, FALSE, /*goto*/ 0x0f)
	set_stage_flag(STAGEFLAG_BUG_WASTED)
	show_hudmsg(CHR_BOND, L_SHO(26)) // "Target Amplifier placed incorrectly."
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x0f)
	goto_first(0x03)

	endlist
};

u8 func101b_bug_throws_coop[] = {
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)
	goto_next(0x03)

	label(0x2d)
	set_stage_flag(STAGEFLAG_COOP_BUGS_WASTED)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x03)
		if_stage_flag_eq(STAGEFLAG_COOP_THREW_FIRST_BUG, FALSE, /*goto*/ 0x55)
		if_stage_flag_eq(STAGEFLAG_COOP_THREW_SECOND_BUG, FALSE, /*goto*/ 0x56)
		if_stage_flag_eq(STAGEFLAG_COOP_THREW_THIRD_BUG, FALSE, /*goto*/ 0x57)

		label(0x55)
		dprint 'C','O','O','P',' ','C','H','E','C','K',' ','1','\n',0,
		if_ammo_quantity_lt(CHR_COOP, AMMOTYPE_BUG, 3, /*goto*/ 0x2d)
	endloop(0x03)

	label(0x2d)
	dprint 'C','O','O','P',' ','F','I','R','E',' ','1','\n',0,
	set_stage_flag(STAGEFLAG_COOP_THREW_FIRST_BUG)
	goto_next(0x0e)

	label(0x56)
	dprint 'C','O','O','P',' ','C','H','E','C','K',' ','2','\n',0,
	label(0x2d)
	if_ammo_quantity_lt(CHR_COOP, AMMOTYPE_BUG, 2, /*goto*/ 0x2d)
	goto_first(0x03)

	label(0x2d)
	set_stage_flag(STAGEFLAG_COOP_THREW_SECOND_BUG)
	goto_next(0x0e)

	label(0x57)
	dprint 'C','O','O','P',' ','C','H','E','C','K',' ','3','\n',0,
	if_ammo_quantity_lt(CHR_COOP, AMMOTYPE_BUG, 1, /*goto*/ 0x2d)
	goto_first(0x03)

	label(0x2d)
	set_stage_flag(STAGEFLAG_COOP_THREW_THIRD_BUG)
	goto_next(0x0e)

	beginloop(0x0e)
		if_weapon_thrown(WEAPON_TARGETAMPLIFIER, /*goto*/ 0x06)
	endloop(0x0e)

	label(0x06)
	restart_timer

	beginloop(0x08)
		dprint 'C','O','O','P',' ','A','T',' ','R','E','S','T','\n',0,
		if_stage_flag_eq(STAGEFLAG_PILLAR1_MARKED, TRUE, /*goto*/ 0x2d)
		if_weapon_thrown_on_object(WEAPON_TARGETAMPLIFIER, 0x01, /*goto*/ 0x09)
		label(0x2d)
		if_stage_flag_eq(STAGEFLAG_PILLAR2_MARKED, TRUE, /*goto*/ 0x2d)
		if_weapon_thrown_on_object(WEAPON_TARGETAMPLIFIER, 0x02, /*goto*/ 0x0b)
		label(0x2d)
		if_stage_flag_eq(STAGEFLAG_PILLAR3_MARKED, TRUE, /*goto*/ 0x2d)
		if_weapon_thrown_on_object(WEAPON_TARGETAMPLIFIER, 0x03, /*goto*/ 0x0c)
		label(0x2d)
		if_timer_gt(120, /*goto*/ 0x0d)
	endloop(0x08)

	label(0x09)
	dprint 'C','O','O','P',' ','1',' ','P','L','A','C','E','D','\n',0,
	unset_object_flag3(OBJ_PILLAR1, OBJFLAG3_RTRACKED_YELLOW)
	if_stage_flag_eq(STAGEFLAG_PILLAR1_MARKED, TRUE, /*goto*/ 0x0d)
	set_stage_flag(STAGEFLAG_PILLAR1_MARKED)
	show_hudmsg(CHR_COOP, L_SHO(25)) // "Target Amplifier placed correctly."
	if_ammo_quantity_lt(CHR_COOP, AMMOTYPE_BUG, 1, /*goto*/ 0x0d)
	goto_first(0x03)

	label(0x0b)
	dprint 'C','O','O','P',' ','2',' ','P','L','A','C','E','D','\n',0,
	unset_object_flag3(OBJ_PILLAR2, OBJFLAG3_RTRACKED_YELLOW)
	if_stage_flag_eq(STAGEFLAG_PILLAR2_MARKED, TRUE, /*goto*/ 0x0d)
	set_stage_flag(STAGEFLAG_PILLAR2_MARKED)
	show_hudmsg(CHR_COOP, L_SHO(25)) // "Target Amplifier placed correctly."
	if_ammo_quantity_lt(CHR_COOP, AMMOTYPE_BUG, 1, /*goto*/ 0x0d)
	goto_first(0x03)

	label(0x0c)
	dprint 'C','O','O','P',' ','3',' ','P','L','A','C','E','D','\n',0,
	unset_object_flag3(OBJ_PILLAR3, OBJFLAG3_RTRACKED_YELLOW)
	if_stage_flag_eq(STAGEFLAG_PILLAR3_MARKED, TRUE, /*goto*/ 0x0d)
	set_stage_flag(STAGEFLAG_PILLAR3_MARKED)
	show_hudmsg(CHR_COOP, L_SHO(25)) // "Target Amplifier placed correctly."
	if_ammo_quantity_lt(CHR_COOP, AMMOTYPE_BUG, 1, /*goto*/ 0x0d)
	goto_first(0x03)

	label(0x0d)
	dprint 'C','O','O','P',' ','P','L','L','A','C','E','D',' ','W','R','O','N','G','\n',0,
	if_ammo_quantity_lt(CHR_BOND, AMMOTYPE_BUG, 1, /*goto*/ 0x2d)
	goto_next(0x0f)

	label(0x2d)
	if_ammo_quantity_lt(CHR_COOP, AMMOTYPE_BUG, 1, /*goto*/ 0x2d)
	goto_next(0x0f)

	label(0x2d)
	if_stage_flag_eq(STAGEFLAG_PILLAR1_MARKED, FALSE, /*goto*/ 0x06)
	if_stage_flag_eq(STAGEFLAG_PILLAR2_MARKED, FALSE, /*goto*/ 0x06)
	if_stage_flag_eq(STAGEFLAG_PILLAR3_MARKED, FALSE, /*goto*/ 0x06)
	goto_next(0x2d)

	label(0x06)
	set_stage_flag(STAGEFLAG_COOP_BUGS_WASTED)
	if_self_flag_bankx_eq(CHRFLAG0_00000010, FALSE, BANK_0, /*goto*/ 0x0f)
	set_stage_flag(STAGEFLAG_BUG_WASTED)
	show_hudmsg(CHR_COOP, L_SHO(26)) // "Target Amplifier placed incorrectly."
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x0f)
	goto_first(0x03)

	endlist
};

u8 func1008_lock_door[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2d)
	goto_next(0x04)

	// A
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// SA and PA
	label(0x04)
	yield
	lock_door(0x09, 0x02)
	lock_door(0x0a, 0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1009_altar[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0f)

	beginloop(0x08)
		chr_toggle_p1p2(CHR_SELF)
		if_object_flag2(OBJ_ALTAR, OBJFLAG2_00002000, /*goto*/ 0x2d)
		if_chr_distance_to_pad_lt(CHR_P1P2, 300, 0x0137, /*goto*/ 0x2e)
		label(0x2d)
		if_chr_activated_object(CHR_P1P2, OBJ_ALTAR, /*goto*/ 0x06)
	endloop(0x08)

	// Activated
	label(0x06)

	// Altar has flag
	label(0x2d)
	if_chr_weapon_equipped(CHR_P1P2, WEAPON_DEVASTATOR, /*goto*/ 0x92)
	if_chr_weapon_equipped(CHR_P1P2, WEAPON_CALLISTONTG, /*goto*/ 0x93)
	if_chr_weapon_equipped(CHR_P1P2, WEAPON_FALCON2_SCOPE, /*goto*/ 0x94)
	if_chr_weapon_equipped(CHR_P1P2, WEAPON_SLAYER, /*goto*/ 0x95)
	if_chr_weapon_equipped(CHR_P1P2, WEAPON_MAULER, /*goto*/ 0x96)

	// At pad, or invalid weapon equipped
	label(0x2e)
	set_object_flag2(OBJ_ALTAR, OBJFLAG2_00002000)
	show_hudmsg(CHR_P1P2, L_SHO(51)) // "Make your sacrifice to the God of War."
	restart_timer

	beginloop(0x91)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x91)

	label(0x06)
	goto_first(0x08)

	label(0x92)
	unset_object_flag2(OBJ_ALTAR_DEVASTATOR, OBJFLAG2_INVISIBLE)
	goto_next(0x2d)

	label(0x93)
	unset_object_flag2(OBJ_ALTAR_CALLISTO, OBJFLAG2_INVISIBLE)
	goto_next(0x2d)

	label(0x94)
	unset_object_flag2(OBJ_ALTAR_FALCON, OBJFLAG2_INVISIBLE)
	goto_next(0x2d)

	label(0x95)
	unset_object_flag2(OBJ_ALTAR_SLAYER, OBJFLAG2_INVISIBLE)
	goto_next(0x2d)

	label(0x96)
	unset_object_flag2(OBJ_ALTAR_MAULER, OBJFLAG2_INVISIBLE)
	goto_next(0x2d)

	label(0x2d)
	play_sound(0x80aa, -1)
	chr_drop_weapon(CHR_P1P2)
	label(0x04)
	yield
	label(0x2d)
	label(0x0f)
	unlock_door(0x09, 0x02)
	unlock_door(0x0a, 0x02)
	set_lights_state(0x0060, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0061, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0062, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0063, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0064, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0065, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0066, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0067, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0068, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0069, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x006a, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x006b, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x006c, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x006d, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x006e, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x006f, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0070, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0071, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0072, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0073, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0074, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0075, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0076, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0077, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0078, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x0079, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x007a, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x007b, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x007c, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x007d, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x007e, 0x03, 0x06, 0x80, 0x78)
	set_lights_state(0x007f, 0x03, 0x06, 0x80, 0x78)
	restart_timer

	beginloop(0x0e)
		if_timer_gt(120, /*goto*/ 0x2d)
	endloop(0x0e)

	label(0x2d)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2d)
	show_hudmsg(CHR_P1P2, L_SHO(27)) // "Generator has been reactivated."
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * This function would have cycled the lights every 20 seconds, but the cycling
 * part has been disabled.
 */
u8 func101c_setup_corridor_lighting[] = {
	label(0x59)
	restart_timer
	label(0x04)
	yield
	label(0x2d)
	set_lights_state(0x0060, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0061, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0062, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0063, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0064, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0065, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0066, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0067, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0068, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0069, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x006a, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x006b, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x006c, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x006d, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x006e, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x006f, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0070, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0071, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0072, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0073, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0074, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0076, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0078, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0079, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x007a, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x007b, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x007c, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x007d, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x007e, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x007f, 0x01, 0x06, 0x00, 0x00)
	yield
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// The rest of this function is unreachable
	restart_timer

	beginloop(0x08)
		if_timer_gt(1200, /*goto*/ 0x2d)
	endloop(0x08)

	label(0x2d)
	set_lights_state(0x0060, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0061, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0062, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0063, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0064, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0065, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0066, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0067, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0068, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0069, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x006a, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x006b, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x006c, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x006d, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x006e, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x006f, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0070, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0071, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0072, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0073, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0074, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0075, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0076, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0077, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0078, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0079, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x007a, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x007b, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x007c, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x007d, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x007e, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x007f, 0x03, 0x06, 0xff, 0x78)
	goto_first(0x59)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040a_init_reaper_slayer_skedar[] = {
	set_accuracy(20)
	set_reaction_speed(75)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(160)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, AILIST_REAPER_SLAYER_SKEDAR)
	endlist
};

u8 func0409_reaper_slayer_skedar[] = {
	unset_self_chrflag(CHRCFLAG_HIDDEN)
	set_shotlist(AILIST_REAPER_SLAYER_SKEDAR)
	if_chr_dying(CHR_SELF, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x2d)

	// Dying
	label(0x06)
	set_shotlist(GAILIST_IDLE)
	restart_timer

	beginloop(0x5d)
		if_timer_gt(15, /*goto*/ 0x06)
	endloop(0x5d)

	label(0x06)
	say_quip(CHR_BOND, 0x19, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x2d)
	if_just_injured(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x08)

	// Injured
	label(0x06)
	set_view_distance(100)

	// Healthy
	label(0x08)
	set_self_chrflag(CHRCFLAG_00000040)
	label(0x5e)
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x06)
	set_target_chr(CHR_BOND)
	try_chr_kneel_and_shoot_thing(0x0220, 0x0000, /*goto*/ 0x5f)
	label(0x06)
	kneel

	beginloop(0x5f)
		chr_toggle_p1p2(CHR_SELF)
		label(0x2d)
		set_target_chr(CHR_P1P2)
		if_self_flag_bankx_eq(CHRFLAG0_AIVSAI, FALSE, BANK_0, /*goto*/ 0x2e)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x60)
		label(0x2e)
		if_player_looking_at_something_maybe(0x00, 0x00, 0x01, /*goto*/ 0x06)
		if_target_in_sight(/*goto*/ 0x60)
		label(0x06)
		if_just_injured(CHR_SELF, /*goto*/ 0x58)
		label(0x2d)
		if_saw_injury(0x00, /*goto*/ 0x60)
		if_near_miss(/*goto*/ 0x61)
		label(0x2d)
		set_target_chr(CHR_P1P2)
	endloop(0x5f)

	label(0x06)
	if_player_looking_at_something_maybe(0x00, 0x00, 0x01, /*goto*/ 0x2d)
	if_target_in_sight(/*goto*/ 0x60)
	label(0x2d)
	set_target_chr(CHR_BOND)
	goto_first(0x5f)

	label(0x60)
	if_chr_sees_player(/*goto*/ 0x2d)
	goto_first(0x5e)

	label(0x58)
	label(0x2d)
	set_view_distance(100)
	if_self_flag_bankx_eq(CHRFLAG0_00000004, TRUE, BANK_0, /*goto*/ 0x2d)
	set_self_flag_bankx(CHRFLAG0_00000004, BANK_0)
	say_quip(CHR_BOND, 0x0b, 0xff, 0x02, 0xff, BANK_0, 0x00, 0x00)
	label(0x2d)
	goto_next(0x71)

	// Unreachable
	cmd0184(90, 100)

	beginloop(0x64)
		if_chr_stopped(/*goto*/ 0x63)
	endloop(0x64)

	label(0x63)
	restart_timer
	stop_chr

	beginloop(0x65)
		if_chr_weapon_equipped(CHR_SELF, WEAPON_SLAYER, /*goto*/ 0x2e)
		if_timer_gt(120, /*goto*/ 0x2d)

		label(0x2e)
		if_timer_gt(200, /*goto*/ 0x2d)
	endloop(0x65)

	label(0x2d)
	label(0x06)
	goto_first(0x5e)

	label(0x61)
	set_view_distance(100)
	restart_timer
	if_self_flag_bankx_eq(CHRFLAG0_00000004, TRUE, BANK_0, /*goto*/ 0x6a)
	set_self_flag_bankx(CHRFLAG0_00000004, BANK_0)

	label(0x6a)
	call_rng
	chr_toggle_p1p2(CHR_SELF)
	set_target_chr(CHR_P1P2)
	if_player_looking_at_something_maybe(0x00, 0x00, 0x01, /*goto*/ 0x06)
	if_target_in_sight(/*goto*/ 0x6b)
	label(0x06)
	if_timer_gt(60, /*goto*/ 0x6c)
	if_rand_lt(4, /*goto*/ 0x6c)
	goto_first(0x6a)

	label(0x6c)
	if_chr_sees_player(/*goto*/ 0x6b)
	goto_first(0x5e)

	label(0x6b)
	goto_first(0x60)

	label(0x6d)
	restart_timer

	beginloop(0x6e)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x6b)
		if_timer_gt(300, /*goto*/ 0x06)
	endloop(0x6e)

	label(0x06)
	goto_first(0x5e)

	label(0x6b)
	goto_first(0x60)

	label(0x71)
	if_self_flag_bankx_eq(CHRFLAG0_00002000, FALSE, BANK_0, /*goto*/ 0x72)
	try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x70)
	label(0x70)
	say_quip(CHR_BOND, 0x00, 0x19, 0x02, 0x01, BANK_0, 0x00, 0x00)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x06)
	goto_next(0x2d)

	label(0x72)
	cmd0184(40, 60)
	dprint 'F','I','R','E',' ','F','U','L','L','\n',0,
	label(0x06)
	goto_first(0x64)

	label(0x2d)
	goto_first(0x63)

	endlist
};

u8 func100a_army_room[] = {
	yield
	set_lights_state(0x0082, 0x01, 0x06, 0x00, 0x00)
	set_lights_state(0x0087, 0x01, 0x06, 0x00, 0x00)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0082, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	close_door(0x0d)
	close_door(0x0e)
	close_door(0x0f)
	close_door(0x10)
	if_objective_complete(0, /*goto*/ 0x2d)
	goto_next(0x06)

	label(0x2d)
	lock_door(0x0d, 0x02)
	lock_door(0x0e, 0x02)
	lock_door(0x0f, 0x02)
	lock_door(0x10, 0x02)
	label(0x06)
	restart_timer

	beginloop(0x08)
		if_timer_gt(180, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	set_lights_state(0x0082, 0x03, 0x06, 0xff, 0x78)
	set_lights_state(0x0087, 0x03, 0x06, 0xff, 0x78)
	set_stage_flag(STAGEFLAG_TRIGGER_SKEDAR_ARMY)
	play_x_music(CHANNEL_10, 60)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	goto_first(0x04)

	endlist
};

u8 func100b_check_sanctum_accessed[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x007a, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	show_hudmsg(CHR_P1P2, L_SHO(28)) // "Skedar Inner Sanctum has been reached."
	set_stage_flag(STAGEFLAG_ACCESSED_SANCTUM)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040b_mauler_skedar[] = {
	set_self_chrflag(CHRCFLAG_00080000)
	set_accuracy(20)
	set_reaction_speed(50)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(50)
	set_recovery_speed(0)
	set_shield(0)

	beginloop(0x04)
		if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	set_alertness(100)
	set_target_chr(CHR_BOND)
	try_jog_to_target(/*goto*/ 0x2d)
	label(0x2d)
	set_shotlist(GAILIST_COMBAT_WITH_TARGET)
	set_returnlist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100e_wake_skedar_army[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_SKEDAR_ARMY, TRUE, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)

	#define enable_army_skedar(chr, loopid) \
		restart_timer \
		set_chr_flag_bankx(chr, CHRFLAG0_00002000, BANK_0) \
		beginloop(loopid) \
			if_timer_gt(500, /*goto*/ 0x2d) \
		endloop(loopid) \
		label(0x2d)



	enable_army_skedar(0x2e, 0x08)
	enable_army_skedar(0x31, 0x09)
	enable_army_skedar(0x2c, 0x0b)
	enable_army_skedar(0x2f, 0x0c)
	enable_army_skedar(0x2d, 0x0d)
	enable_army_skedar(0x32, 0x0e)
	enable_army_skedar(0x30, 0x0f)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040c_king_waiting[] = {
	set_shield(500)
	set_accuracy(100)
	set_chr_chrflag(CHR_SELF, CHRCFLAG_00080000)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_00100000)
	if_difficulty_gt(DIFF_A, /*goto*/ 0x2d)
	set_self_chrflag(CHRCFLAG_00000020)
	label(0x2d)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_10000000)
	set_morale(0)

	beginloop(0x08)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0088, /*goto*/ 0x2d)
	endloop(0x08)

	label(0x2d)
	stop_music_channel(-1)
	play_music_track(MUSIC_SKEDARRUINS_KING)
	restart_timer

	beginloop(0x09)
		if_timer_gt(300, /*goto*/ 0x2d)
	endloop(0x09)

	label(0x2d)
	unset_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, AILIST_KING_COMBAT)
	endlist
};

/**
 * morale tracks how many rockets have been fired in a row.
 */
u8 func040d_king_combat[] = {
#define LABEL_MAINLOOP         0x03
#define LABEL_PLAYER_DEAD      0x11
#define LABEL_FIRE_ROCKET      0x73
#define LABEL_SPAWN_SKEDAR     0x74
#define LABEL_SPAWN_MINISKEDAR 0x75
#define LABEL_CLOAK            0x76
#define LABEL_LOW_SHIELD       0x7c

	beginloop(0x59)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_in_disarm_range(/*goto*/ 0x03)
		if_chr_shield_lt(CHR_SELF, 20, /*goto*/ LABEL_LOW_SHIELD)
	endloop(0x59)

	// Main loop
	label(LABEL_MAINLOOP)
	chr_toggle_p1p2(CHR_SELF)
	set_target_chr(CHR_P1P2)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x04)

	beginloop(0x04)
		if_chr_death_animation_finished(CHR_P1P2, /*goto*/ LABEL_PLAYER_DEAD)
		if_chr_shield_lt(CHR_SELF, 20, /*goto*/ LABEL_LOW_SHIELD)
		if_stage_flag_eq(STAGEFLAG_KING_SKEDAR_CLONE_EXISTS, TRUE, /*goto*/ 0x2d)
		if_stage_flag_eq(STAGEFLAG_KING_MINISKEDAR_CLONE_EXISTS, TRUE, /*goto*/ 0x2d)

		// No clones exist
		call_rng
		if_rand_gt(200, /*goto*/ 0x79)
		if_morale_lt(2, /*goto*/ 0x06)
		goto_next(0x2d)

		label(0x06)
		goto_next(LABEL_FIRE_ROCKET)

		label(0x79)
		if_rand_gt(237, /*goto*/ 0x07)
		if_rand_gt(218, /*goto*/ 0x06)
		goto_next(LABEL_SPAWN_MINISKEDAR)

		label(0x06)
		goto_next(LABEL_SPAWN_SKEDAR)

		label(0x07)
		goto_next(LABEL_CLOAK)

		label(0x2d)
	endloop(0x04)

	//
	// Run to side and fire a rocket
	//
	label(LABEL_FIRE_ROCKET)
	restart_timer
	if_chr_distance_to_pad_lt(CHR_SELF, 300, 0x0098, /*goto*/ 0x06)
	jog_to_pad(0x0098) // left side (when facing king)
	goto_next(0x7f)

	label(0x06)
	restart_timer
	jog_to_pad(0x0097) // right side

	beginloop(0x7f)
		if_chr_death_animation_finished(CHR_P1P2, /*goto*/ LABEL_PLAYER_DEAD)
		if_chr_shield_lt(CHR_SELF, 20, /*goto*/ LABEL_LOW_SHIELD)
		if_chr_stopped(/*goto*/ 0x2d)
	endloop(0x7f)

	label(0x2d)
	set_self_chrflag(CHRCFLAG_00000040)

	beginloop(0x7a)
		if_chr_death_animation_finished(CHR_P1P2, /*goto*/ LABEL_PLAYER_DEAD)
		if_chr_shield_lt(CHR_SELF, 20, /*goto*/ LABEL_LOW_SHIELD)
		if_in_disarm_range(/*goto*/ 0x06)
	endloop(0x7a)

	label(0x06)
	say_quip(CHR_BOND, 0x01, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x70)
	label(0x70)
	say_quip(CHR_BOND, 0x00, 0x19, 0x02, 0x01, BANK_0, 0x00, 0x00)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x7b)
	goto_next(0x2d)

	label(0x06)
	goto_first(LABEL_MAINLOOP)

	// Shoot successful
	beginloop(0x7b)
		if_chr_death_animation_finished(CHR_P1P2, /*goto*/ LABEL_PLAYER_DEAD)
		if_chr_shield_lt(CHR_SELF, 20, /*goto*/ LABEL_LOW_SHIELD)
		if_chr_stopped(/*goto*/ 0x2d)
	endloop(0x7b)

	label(0x2d)
	add_morale(1)
	goto_first(LABEL_MAINLOOP)

	//
	// Spawn skedar
	//
	label(LABEL_SPAWN_SKEDAR)
	say_quip(CHR_BOND, 0x01, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_morale(0)
	restart_timer
	chr_do_animation(0x0350, 0, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x66)
		if_chr_death_animation_finished(CHR_P1P2, /*goto*/ LABEL_PLAYER_DEAD)
		if_chr_shield_lt(CHR_SELF, 20, /*goto*/ LABEL_LOW_SHIELD)
		if_timer_gt(120, /*goto*/ 0x2d)
	endloop(0x66)

	label(0x2d)
	set_chr_flag_bankx(CHR_KING_SKEDAR_SPAWNER, CHRFLAG0_00002000, BANK_0)
	goto_first(LABEL_MAINLOOP)

	//
	// Spawn miniskedar
	//
	label(LABEL_SPAWN_MINISKEDAR)
	say_quip(CHR_BOND, 0x01, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_morale(0)
	restart_timer
	chr_do_animation(0x0350, 0, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x67)
		if_chr_death_animation_finished(CHR_P1P2, /*goto*/ LABEL_PLAYER_DEAD)
		if_chr_shield_lt(CHR_SELF, 20, /*goto*/ LABEL_LOW_SHIELD)
		if_timer_gt(120, /*goto*/ 0x2d)
	endloop(0x67)

	label(0x2d)
	set_chr_flag_bankx(CHR_KING_MINISKEDAR_SPAWNER, CHRFLAG0_00002000, BANK_0)
	goto_first(LABEL_MAINLOOP)

	//
	// Cloak and warp to player for hand combat
	//
	label(LABEL_CLOAK)
	say_quip(CHR_BOND, 0x01, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_morale(0)
	restart_timer
	chr_do_animation(0x0350, 0, -1, 0x10, 0x10, CHR_SELF, 2)
	set_chr_cloaked(CHR_SELF, TRUE, TRUE)

	beginloop(0x68)
		if_chr_death_animation_finished(CHR_P1P2, /*goto*/ LABEL_PLAYER_DEAD)
		if_timer_gt(120, /*goto*/ 0x2d)
	endloop(0x68)

	label(0x2d)
	try_set_target_pad_to_something2(0x01, /*goto*/ 0x2d)
	try_set_target_pad_to_something2(0x02, /*goto*/ 0x2d)
	try_set_target_pad_to_something2(0x04, /*goto*/ 0x2d)
	goto_next(0x88)

	label(0x2d)
	chr_move_to_pad(CHR_SELF, PAD_PRESET, 0x00, /*goto*/ 0x2d)
	goto_next(0x88)

	label(0x2d)
	set_countdown_timer(7)
	start_countdown_timer

	label(0x8a)
	restart_timer
	try_run_to_target(/*goto*/ 0x08)

	beginloop(0x08)
		if_chr_death_animation_finished(CHR_P1P2, /*goto*/ 0x0b)
		if_timer_gt(20, /*goto*/ 0x89)
		if_distance_to_target_lt(150, /*goto*/ 0x06)
	endloop(0x08)

	// Unreachable
	label(0x2d)
	goto_next(0x88)

	// Every 20 frames - check countdown timer
	label(0x89)
	if_countdown_timer_lt(1, /*goto*/ 0x2d)
	goto_first(0x8a)

	// Been chasing player while cloaked for 7 seconds
	label(0x2d)
	goto_next(0x88)

	// Distance to player < 150
	label(0x06)
	say_quip(CHR_BOND, 0x01, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_chr_cloaked(CHR_SELF, FALSE, TRUE)
	restart_timer
	dprint 'F','A','C','E',' ','T','A','R','G','E','T','\n',0,
	if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
	if_jo_ccw_direction_gt(246, /*goto*/ 0x06)
	stop_chr
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		if_chr_death_animation_finished(CHR_P1P2, /*goto*/ 0x0b)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_jo_ccw_direction_gt(246, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x2d)
	goto_next(0x87)

	label(0x06)
	dprint 'P','U','N','C','H','\n',0,
	try_punch_or_kick(/*goto*/ 0x0b)
	goto_next(0x87)

	beginloop(0x0b)
		if_chr_stopped(/*goto*/ 0x2d)
	endloop(0x0b)

	label(0x2d)
	restart_timer
	set_chr_cloaked(CHR_SELF, TRUE, TRUE)

	beginloop(0x0d)
		if_timer_gt(120, /*goto*/ 0x2d)
	endloop(0x0d)

	label(0x2d)
	label(0x88)
	stop_chr
	chr_move_to_pad(CHR_SELF, 0x0097, 0x00, /*goto*/ 0x87)
	chr_move_to_pad(CHR_SELF, 0x0096, 0x00, /*goto*/ 0x87)
	chr_move_to_pad(CHR_SELF, 0x0098, 0x00, /*goto*/ 0x87)

	label(0x87)
	set_chr_cloaked(CHR_SELF, FALSE, TRUE)
	restart_timer

	beginloop(0x85)
		if_timer_gt(120, /*goto*/ 0x2d)
	endloop(0x85)

	label(0x2d)
	goto_first(LABEL_MAINLOOP)

	// Unreachable - nothing jumps here
	label(0x77)
	say_quip(CHR_BOND, 0x01, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_morale(0)
	restart_timer
	chr_do_animation(0x0350, 0, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x69)
		if_chr_shield_lt(CHR_SELF, 20, /*goto*/ LABEL_LOW_SHIELD)
		if_timer_gt(120, /*goto*/ 0x2d)
	endloop(0x69)

	label(0x2d)
	goto_first(LABEL_MAINLOOP)

	// Shield < 20
	label(LABEL_LOW_SHIELD)
	say_quip(CHR_BOND, 0x02, 0xff, 0x00, 0xff, BANK_0, 0x00, 0x00)
	jog_to_pad(0x0096)

	beginloop(0x7d)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x7d)

	label(0x06)
	restart_timer
	set_stage_flag(STAGEFLAG_SPIKES_VULNERABLE)
	chr_do_animation(0x0351, 0, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x7e)
		if_stage_flag_eq(STAGEFLAG_SPIKE_DESTROYED, TRUE, /*goto*/ 0x06)
		if_timer_gt(500, /*goto*/ 0x06)
	endloop(0x7e)

	label(0x06)
	stop_chr
	unset_stage_flag(STAGEFLAG_SPIKE_DESTROYED)
	if_stage_flag_eq(STAGEFLAG_SPIKE4_DESTROYED, TRUE, /*goto*/ 0x83)
	if_stage_flag_eq(STAGEFLAG_SPIKE3_DESTROYED, TRUE, /*goto*/ 0x82)
	if_stage_flag_eq(STAGEFLAG_SPIKE2_DESTROYED, TRUE, /*goto*/ 0x81)
	if_stage_flag_eq(STAGEFLAG_SPIKE1_DESTROYED, TRUE, /*goto*/ 0x80)

	set_shield(500)
	goto_next(0x06)

	label(0x80)
	set_shield(400)
	goto_next(0x06)

	label(0x81)
	set_shield(300)
	goto_next(0x06)

	label(0x82)
	set_shield(200)
	goto_next(0x06)

	label(0x83)
	set_shield(100)

	label(0x06)
	unset_stage_flag(STAGEFLAG_SPIKES_VULNERABLE)
	goto_first(LABEL_MAINLOOP)

	// Player dead
	label(LABEL_PLAYER_DEAD)
	goto_first(0x59)

	endlist
};

u8 func040e_king_skedar_spawner[] = {
	set_self_chrflag(CHRCFLAG_00000002)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_00040000)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_00100000)

	beginloop(0x04)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x2d)
		if_chr_dying(CHR_CLONE, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_CLONE, /*goto*/ 0x2d)
		goto_next(0x06)

		// Clone dead
		label(0x2d)
		unset_stage_flag(STAGEFLAG_KING_SKEDAR_CLONE_EXISTS)

		label(0x06)
		if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x4f)
		reloop(0x04)

		label(0x4f)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x4f)
		if_chr_dying(CHR_CLONE, /*goto*/ 0x4f)
		if_chr_unloaded(CHR_CLONE, /*goto*/ 0x4f)
		reloop(0x04)

		label(0x4f)
		try_spawn_clone2(CHR_SELF, AILIST_INIT_KING_SKEDAR_CLONE, 0x00000010, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		unset_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
		set_stage_flag(STAGEFLAG_KING_SKEDAR_CLONE_EXISTS)
		yield
	endloop(0x04)

	endlist
};

u8 func0410_init_king_skedar_clone[] = {
	set_self_chrflag(CHRCFLAG_00040000)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_CLOAKED)
	yield
	try_equip_weapon(MODEL_CHRMAULER, WEAPON_MAULER, 0x20000000, /*goto*/ 0x06)
	label(0x06)
	yield
	yield
	yield
	yield
	unset_self_chrflag(CHRCFLAG_HIDDEN)
	set_chr_cloaked(CHR_SELF, FALSE, TRUE)
	set_ailist(CHR_SELF, AILIST_INIT_UNARMED_SKEDAR)
	endlist
};

u8 func0411_king_miniskedar_spawner[] = {
	set_self_chrflag(CHRCFLAG_00000002)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_00040000)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_00100000)

	beginloop(0x04)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x2d)
		if_chr_dying(CHR_CLONE, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_CLONE, /*goto*/ 0x2d)
		goto_next(0x06)

		// Clone dead
		label(0x2d)
		unset_stage_flag(STAGEFLAG_KING_MINISKEDAR_CLONE_EXISTS)
		label(0x06)
		if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x4f)
		reloop(0x04)

		// Clone dead and flag set
		// Redundant check
		label(0x4f)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x4f)
		if_chr_dying(CHR_CLONE, /*goto*/ 0x4f)
		if_chr_unloaded(CHR_CLONE, /*goto*/ 0x4f)
		reloop(0x04)

		// Spawn clone
		label(0x4f)
		try_spawn_clone2(CHR_SELF, AILIST_INIT_KING_MINISKEDAR_CLONE, 0x00000010, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		unset_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
		set_stage_flag(STAGEFLAG_KING_MINISKEDAR_CLONE_EXISTS)
		yield
	endloop(0x04)

	endlist
};

u8 func0412_init_king_miniskedar_clone[] = {
	set_self_chrflag(CHRCFLAG_00040000)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_CLOAKED)
	yield
	try_equip_weapon(MODEL_CHRMAULER, WEAPON_MAULER, 0x20000000, /*goto*/ 0x06)
	label(0x06)
	yield
	yield
	yield
	yield
	unset_self_chrflag(CHRCFLAG_HIDDEN)
	set_chr_cloaked(CHR_SELF, FALSE, TRUE)
	set_ailist(CHR_SELF, AILIST_INIT_MINISKEDAR)
	endlist
};

u8 func100f_spikes_vulnerability[] = {
	set_object_flag2(OBJ_SPIKE_ML, 0x00200002)
	set_object_flag2(OBJ_SPIKE_MR, 0x00200002)
	set_object_flag2(OBJ_SPIKE_BL, 0x00200002)
	set_object_flag2(OBJ_SPIKE_BR, 0x00200002)
	set_object_flag2(OBJ_SPIKE_T, 0x00200002)

	beginloop(0x91)
		if_stage_flag_eq(STAGEFLAG_IN_INTRO, FALSE, /*goto*/ 0x86)
	endloop(0x91)

	label(0x86)
	label(0x03)
	set_object_flag(OBJ_SPIKE_ML, OBJFLAG_INVINCIBLE)
	set_object_flag(OBJ_SPIKE_MR, OBJFLAG_INVINCIBLE)
	set_object_flag(OBJ_SPIKE_BL, OBJFLAG_INVINCIBLE)
	set_object_flag(OBJ_SPIKE_BR, OBJFLAG_INVINCIBLE)
	set_object_flag(OBJ_SPIKE_T, OBJFLAG_INVINCIBLE)
	set_object_flag3(OBJ_SPIKE_ML, 0x00101000)
	set_object_flag3(OBJ_SPIKE_MR, 0x00101000)
	set_object_flag3(OBJ_SPIKE_BL, 0x00101000)
	set_object_flag3(OBJ_SPIKE_BR, 0x00101000)
	set_object_flag3(OBJ_SPIKE_T, 0x00101000)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_SPIKES_VULNERABLE, TRUE, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	unset_object_flag(OBJ_SPIKE_ML, OBJFLAG_INVINCIBLE)
	unset_object_flag(OBJ_SPIKE_MR, OBJFLAG_INVINCIBLE)
	unset_object_flag(OBJ_SPIKE_BL, OBJFLAG_INVINCIBLE)
	unset_object_flag(OBJ_SPIKE_BR, OBJFLAG_INVINCIBLE)
	unset_object_flag3(OBJ_SPIKE_ML, 0x00101000)
	unset_object_flag3(OBJ_SPIKE_MR, 0x00101000)
	unset_object_flag3(OBJ_SPIKE_BL, 0x00101000)
	unset_object_flag3(OBJ_SPIKE_BR, 0x00101000)

	if_stage_flag_eq(STAGEFLAG_SPIKE1_DESTROYED, FALSE, /*goto*/ 0x08)
	if_stage_flag_eq(STAGEFLAG_SPIKE2_DESTROYED, FALSE, /*goto*/ 0x08)
	if_stage_flag_eq(STAGEFLAG_SPIKE3_DESTROYED, FALSE, /*goto*/ 0x08)
	if_stage_flag_eq(STAGEFLAG_SPIKE4_DESTROYED, FALSE, /*goto*/ 0x08)
	unset_object_flag(OBJ_SPIKE_T, OBJFLAG_INVINCIBLE)
	unset_object_flag3(OBJ_SPIKE_T, 0x00101000)

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_SPIKES_VULNERABLE, FALSE, /*goto*/ 0x2d)
	endloop(0x08)

	label(0x2d)
	goto_first(0x03)

	endlist
};

#define wait_for_spike_destroyed(spike, shadow, noshadow) \
	beginloop(0x03) \
		if_object_in_good_condition(spike, /*goto*/ 0x2d) \
		goto_next(0x06) \
 \
		label(0x2d) \
	endloop(0x03) \
 \
	label(0x06) \
	set_object_flag2(shadow, OBJFLAG2_INVISIBLE) \
	unset_object_flag2(noshadow, OBJFLAG2_INVISIBLE)



u8 func1010_spike_ml[] = {
	wait_for_spike_destroyed(OBJ_SPIKE_ML, OBJ_SPIKE_SHAD_ML, OBJ_SPIKE_NOSHAD_ML)
	set_ailist(CHR_SELF, AILIST_UPDATE_SPIKE_STAGEFLAGS)
	endlist
};

u8 func1011_spike_mr[] = {
	wait_for_spike_destroyed(OBJ_SPIKE_MR, OBJ_SPIKE_SHAD_MR, OBJ_SPIKE_NOSHAD_MR)
	set_ailist(CHR_SELF, AILIST_UPDATE_SPIKE_STAGEFLAGS)
	endlist
};

u8 func1012_spike_bl[] = {
	wait_for_spike_destroyed(OBJ_SPIKE_BL, OBJ_SPIKE_SHAD_BL, OBJ_SPIKE_NOSHAD_BL)
	set_ailist(CHR_SELF, AILIST_UPDATE_SPIKE_STAGEFLAGS)
	endlist
};

u8 func1013_spike_br[] = {
	wait_for_spike_destroyed(OBJ_SPIKE_BR, OBJ_SPIKE_SHAD_BR, OBJ_SPIKE_NOSHAD_BR)
	set_ailist(CHR_SELF, AILIST_UPDATE_SPIKE_STAGEFLAGS)
	endlist
};

u8 func1014_spike_top[] = {
	wait_for_spike_destroyed(OBJ_SPIKE_T, OBJ_SPIKE_SHAD_T, OBJ_SPIKE_NOSHAD_T)

	set_stage_flag(STAGEFLAG_SPIKE5_DESTROYED)
	yield
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2d)
	if_chr_dying(CHR_BOND, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x2d)
	goto_next(0x06)

	label(0x2d)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)
	if_chr_dying(CHR_COOP, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x2d)
	goto_next(0x06)

	label(0x2d)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	set_invincible(CHR_BOND)
	set_ailist(CHR_SELF, AILIST_OUTRO)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040f_update_spike_stageflags[] = {
	if_stage_flag_eq(STAGEFLAG_SPIKE1_DESTROYED, TRUE, /*goto*/ 0x09)
	set_stage_flag(STAGEFLAG_SPIKE1_DESTROYED)
	set_stage_flag(STAGEFLAG_SPIKE_DESTROYED)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x09)
	if_stage_flag_eq(STAGEFLAG_SPIKE2_DESTROYED, TRUE, /*goto*/ 0x0b)
	set_stage_flag(STAGEFLAG_SPIKE2_DESTROYED)
	set_stage_flag(STAGEFLAG_SPIKE_DESTROYED)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x0b)
	if_stage_flag_eq(STAGEFLAG_SPIKE3_DESTROYED, TRUE, /*goto*/ 0x0c)
	set_stage_flag(STAGEFLAG_SPIKE3_DESTROYED)
	set_stage_flag(STAGEFLAG_SPIKE_DESTROYED)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x0c)
	set_stage_flag(STAGEFLAG_SPIKE4_DESTROYED)
	set_stage_flag(STAGEFLAG_SPIKE_DESTROYED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0c00_intro[] = {
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_SKEDARRUINS_INTRO)
	set_stage_flag(STAGEFLAG_IN_INTRO)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_00080000)
	set_chr_chrflag(CHR_KING2, CHRCFLAG_HIDDEN)
	camera_movement(0x02e9)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x86)

		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x86)
		label(0x2d)
	endloop(0x08)

	label(0x86)
	if_controller_button_pressed(/*goto*/ 0x86)
	camera_movement(0x02ea)

	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x02eb, -1, -1, 0x06, 0x00, CHR_BOND, 4)

	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	chr_do_animation(0x02ec, -1, -1, 0x06, 0x00, CHR_ELVIS, 4)

	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_CALLISTONTG, WEAPON_NONE)

	beginloop(0x09)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x86)

		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x86)
		label(0x2d)
	endloop(0x09)

	label(0x86)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	if_controller_button_pressed(/*goto*/ 0x86)
	camera_movement(0x02ed)

	set_chr_chrflag(0x37, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x37, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x37, CHRHFLAG_00020000)
	chr_do_animation(0x02ee, -1, -1, 0x06, 0x00, 0x37, 4)

	set_chr_chrflag(0x38, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x38, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x38, CHRHFLAG_00020000)
	chr_do_animation(0x02ef, -1, -1, 0x06, 0x00, 0x38, 4)

	set_chr_chrflag(0x39, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x39, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x39, CHRHFLAG_00020000)
	chr_do_animation(0x02f0, -1, -1, 0x06, 0x00, 0x39, 4)

	beginloop(0x0b)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x86)

		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x86)
		label(0x2d)
	endloop(0x0b)

	label(0x86)
	unset_chr_chrflag(0x37, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x38, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x39, CHRCFLAG_UNPLAYABLE)
	if_controller_button_pressed(/*goto*/ 0x86)
	camera_movement(0x02f1)

	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x02f2, -1, -1, 0x06, 0x00, CHR_BOND, 4)

	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	chr_do_animation(0x02f3, -1, -1, 0x06, 0x00, CHR_ELVIS, 4)

	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_DEVASTATOR, WEAPON_NONE)

	beginloop(0x0c)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x86)

		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x86)
		label(0x2d)
	endloop(0x0c)

	label(0x86)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	if_controller_button_pressed(/*goto*/ 0x86)
	camera_movement(0x02f4)

	set_chr_chrflag(0x37, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x37, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x37, CHRHFLAG_00020000)
	chr_do_animation(0x02f5, -1, -1, 0x06, 0x00, 0x37, 4)

	set_chr_chrflag(0x38, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x38, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x38, CHRHFLAG_00020000)
	chr_do_animation(0x02f6, -1, -1, 0x06, 0x00, 0x38, 4)

	set_chr_chrflag(0x39, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x39, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x39, CHRHFLAG_00020000)
	chr_do_animation(0x02f7, -1, -1, 0x06, 0x00, 0x39, 4)

	set_chr_chrflag(0x3a, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x3a, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x3a, CHRHFLAG_00020000)
	chr_do_animation(0x02f8, -1, -1, 0x06, 0x00, 0x3a, 4)

	beginloop(0x0d)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x86)

		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x86)
		label(0x2d)
	endloop(0x0d)

	label(0x86)
	unset_chr_chrflag(0x37, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x38, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x39, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x3a, CHRCFLAG_UNPLAYABLE)
	if_controller_button_pressed(/*goto*/ 0x86)
	camera_movement(0x02f9)

	show_object(0x36)
	set_object_flag2(0x36, OBJFLAG2_04000000)
	set_object_flag3(0x36, OBJFLAG3_00000010)
	object_do_animation(0x02fa, 0x36, 0x01, 0xffff)
	set_object_part_visible(0x36, FALSE)

	beginloop(0x0e)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x86)

		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x86)
		label(0x2d)
	endloop(0x0e)

	label(0x86)
	hide_object(0x36)
	if_controller_button_pressed(/*goto*/ 0x86)
	camera_movement(0x02fb)

	set_chr_chrflag(0x37, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x37, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x37, CHRHFLAG_00020000)
	chr_do_animation(0x02fc, -1, -1, 0x06, 0x00, 0x37, 4)

	set_chr_chrflag(0x38, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x38, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x38, CHRHFLAG_00020000)
	chr_do_animation(0x02fd, -1, -1, 0x06, 0x00, 0x38, 4)

	set_chr_chrflag(0x39, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x39, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x39, CHRHFLAG_00020000)
	chr_do_animation(0x02fe, -1, -1, 0x06, 0x00, 0x39, 4)

	set_chr_chrflag(0x3a, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x3a, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x3a, CHRHFLAG_00020000)
	chr_do_animation(0x02ff, -1, -1, 0x06, 0x00, 0x3a, 4)

	unset_chr_chrflag(CHR_KING2, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_KING2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_KING2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_KING2, CHRHFLAG_00020000)
	chr_do_animation(0x0300, -1, -1, 0x06, 0x00, CHR_KING2, 4)

	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_FALCON2_SCOPE, WEAPON_NONE)

	beginloop(0x0f)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x86)

		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x86)
		label(0x2d)
	endloop(0x0f)

	label(0x86)
	unset_chr_chrflag(0x37, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x38, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x39, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x3a, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_KING2, CHRCFLAG_UNPLAYABLE)
	camera_movement(0x0301)
	cmd0175(60)
	if_controller_button_pressed(/*goto*/ 0x86)

	show_object(0x36)
	set_object_flag2(0x36, OBJFLAG2_04000000)
	set_object_flag3(0x36, OBJFLAG3_00000010)
	object_do_animation(0x0302, 0x36, 0x04, 0xffff)
	set_object_part_visible(0x36, FALSE)

	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x0303, -1, -1, 0x06, 0x00, CHR_BOND, 4)

	beginloop(0x10)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x86)

		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x86)
		label(0x2d)
	endloop(0x10)

	label(0x86)
	unset_stage_flag(STAGEFLAG_IN_INTRO)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_00080000)
	mute_channel(CHANNEL_7)
	label(0x06)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x0303, -2, -1, 0x06, 0x00, CHR_BOND, 2)
	hide_object(0x36)
	remove_chr(0x37)
	remove_chr(0x38)
	remove_chr(0x39)
	remove_chr(0x3a)
	remove_chr(CHR_KING2)
	unset_chr_chrflag(CHR_KING1, CHRCFLAG_HIDDEN)
	set_ailist(CHR_KING1, AILIST_KING_WAITING)
	set_object_flag2(0x2a, OBJFLAG2_04000000)
	set_object_flag2(0x2b, OBJFLAG2_04000000)
	set_object_flag2(0x2c, OBJFLAG2_04000000)
	set_object_flag2(0x2d, OBJFLAG2_04000000)
	set_object_flag2(0x2e, OBJFLAG2_04000000)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	restart_default_music
	reset_ambience
	enter_firstperson
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0414_outro_from_menu[] = {
	set_ailist(CHR_ELVIS, GAILIST_IDLE)
	hide_object(OBJ_SPIKE_ML)
	hide_object(OBJ_SPIKE_MR)
	hide_object(OBJ_SPIKE_BL)
	hide_object(OBJ_SPIKE_BR)
	set_ailist(CHR_SELF, AILIST_OUTRO)
	endlist
};

u8 func0414_outro[] = {
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2d)
	set_target_chr(CHR_BOND)
	goto_next(0x06)

	label(0x2d)
	set_target_chr(CHR_COOP)

	label(0x06)
	set_chr_chrflag(CHR_TARGET, CHRCFLAG_KILLCOUNTABLE)
	camera_movement(0x044c)
	set_music_track(MUSIC_SKEDARRUINS_OUTRO)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0xf1, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_TARGET, CHRCFLAG_HIDDEN)
	set_ailist(CHR_TARGET, GAILIST_IDLE)
	remove_chr(0x05)
	remove_chr(0x06)
	remove_chr(0x07)
	remove_chr(0x08)
	remove_chr(0x09)
	remove_chr(0x0a)
	remove_chr(0x0b)
	remove_chr(0x0c)
	remove_chr(0x0d)
	remove_chr(0x0e)
	remove_chr(0x17)
	remove_chr(0x0f)
	remove_chr(0x10)
	remove_chr(0x0d)
	remove_chr(0x1c)
	remove_chr(0x18)
	remove_chr(0x19)
	remove_chr(0x1a)
	remove_chr(0x11)
	remove_chr(0x12)
	remove_chr(0x13)
	remove_chr(0x14)
	remove_chr(0x1b)
	remove_chr(0x15)
	remove_chr(0x16)
	remove_chr(0x1d)
	remove_chr(0x1e)
	remove_chr(0x1f)
	set_ailist(CHR_KING1, GAILIST_IDLE)

	set_chr_chrflag(CHR_KING1, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_KING1, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_KING1, CHRHFLAG_00020000)
	chr_do_animation(0x044d, -1, -1, 0x06, 0x00, CHR_KING1, 4)

	object_do_animation(0x044e, OBJ_SPIKE_T, 0x04, 0xffff)
	set_stage_flag(STAGEFLAG_IN_OUTRO)
	show_nonessential_chrs(FALSE)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x86)

		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x86)
		label(0x2d)
	endloop(0x08)

	label(0x86)
	camera_movement(0x044f)

	set_chr_chrflag(CHR_KING1, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_KING1, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_KING1, CHRHFLAG_00020000)
	chr_do_animation(0x0450, -1, -1, 0x06, 0x00, CHR_KING1, 4)

	set_chr_chrflag(CHR_TARGET, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_TARGET, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_TARGET, CHRHFLAG_00020000)
	chr_do_animation(0x0451, -1, -1, 0x06, 0x00, CHR_TARGET, 4)

	object_do_animation(0x0452, OBJ_SPIKE_T, 0x04, 0xffff)

	show_object(0x37)
	set_object_flag2(0x37, OBJFLAG2_04000000)
	set_object_flag3(0x37, OBJFLAG3_00000010)
	object_do_animation(0x0453, 0x37, 0x04, 0xffff)

	show_object(0x38)
	set_object_flag2(0x38, OBJFLAG2_04000000)
	set_object_flag3(0x38, OBJFLAG3_00000010)
	object_do_animation(0x0454, 0x38, 0x04, 0xffff)

	show_object(0x39)
	set_object_flag2(0x39, OBJFLAG2_04000000)
	set_object_flag3(0x39, OBJFLAG3_00000010)
	object_do_animation(0x0455, 0x39, 0x04, 0xffff)

	show_object(0x3a)
	set_object_flag2(0x3a, OBJFLAG2_04000000)
	set_object_flag3(0x3a, OBJFLAG3_00000010)
	object_do_animation(0x0456, 0x3a, 0x04, 0xffff)

	show_object(0x3b)
	set_object_flag2(0x3b, OBJFLAG2_04000000)
	set_object_flag3(0x3b, OBJFLAG3_00000010)
	object_do_animation(0x0457, 0x3b, 0x04, 0xffff)
	show_object(0x3c)

	set_object_flag2(0x3c, OBJFLAG2_04000000)
	set_object_flag3(0x3c, OBJFLAG3_00000010)
	object_do_animation(0x0458, 0x3c, 0x04, 0xffff)

	beginloop(0x09)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x86)

		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x86)
		label(0x2d)
	endloop(0x09)

	label(0x86)
	hide_object(0x3c)
	camera_movement(0x02c7)

	set_chr_chrflag(CHR_TARGET, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_TARGET, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_TARGET, CHRHFLAG_00020000)
	chr_do_animation(0x02c8, -1, -1, 0x06, 0x00, CHR_TARGET, 4)

	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	chr_do_animation(0x02c9, -1, -1, 0x06, 0x00, CHR_ELVIS, 4)

	show_object(0x23)
	set_object_flag2(0x23, OBJFLAG2_04000000)
	set_object_flag3(0x23, OBJFLAG3_00000010)
	object_do_animation(0x02ca, 0x23, 0x04, 0xffff)

	show_object(0x24)
	set_object_flag2(0x24, OBJFLAG2_04000000)
	set_object_flag3(0x24, OBJFLAG3_00000010)
	object_do_animation(0x02cb, 0x24, 0x04, 0xffff)

	show_object(0x25)
	set_object_flag2(0x25, OBJFLAG2_04000000)
	set_object_flag3(0x25, OBJFLAG3_00000010)
	object_do_animation(0x02cc, 0x25, 0x04, 0xffff)

	show_object(0x26)
	set_object_flag2(0x26, OBJFLAG2_04000000)
	set_object_flag3(0x26, OBJFLAG3_00000010)
	object_do_animation(0x02cd, 0x26, 0x04, 0xffff)

	beginloop(0x0b)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x86)

		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x86)
		label(0x2d)
	endloop(0x0b)

	label(0x86)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_KILLCOUNTABLE)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_KILLCOUNTABLE)
	unset_stage_flag(STAGEFLAG_IN_OUTRO)
	hide_object(0x23)
	hide_object(0x24)
	hide_object(0x25)
	hide_object(0x26)
	label(0x06)
	restart_default_music
	reset_ambience
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0413_hide[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1015_msg_specialpillars[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0026, /*goto*/ 0x91)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0031, /*goto*/ 0x92)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0035, /*goto*/ 0x93)
		if_chr_in_room(CHR_P1P2, 0x00, 0x002b, /*goto*/ 0x94)
		if_chr_in_room(CHR_P1P2, 0x00, 0x000e, /*goto*/ 0x95)
	endloop(0x04)

	label(0x91)
	if_object_in_room(0x01, 0x0026, /*goto*/ 0x2d)
	if_object_in_room(0x02, 0x0026, /*goto*/ 0x2d)
	if_object_in_room(0x03, 0x0026, /*goto*/ 0x2d)
	goto_first(0x04)

	label(0x92)
	if_object_in_room(0x01, 0x0031, /*goto*/ 0x2d)
	if_object_in_room(0x02, 0x0031, /*goto*/ 0x2d)
	if_object_in_room(0x03, 0x0031, /*goto*/ 0x2d)
	goto_first(0x04)

	label(0x93)
	if_object_in_room(0x01, 0x0037, /*goto*/ 0x2d)
	if_object_in_room(0x02, 0x0037, /*goto*/ 0x2d)
	if_object_in_room(0x03, 0x0037, /*goto*/ 0x2d)
	goto_first(0x04)

	label(0x94)
	if_object_in_room(0x01, 0x002b, /*goto*/ 0x2d)
	if_object_in_room(0x02, 0x002b, /*goto*/ 0x2d)
	if_object_in_room(0x03, 0x002b, /*goto*/ 0x2d)
	goto_first(0x04)

	label(0x95)
	if_object_in_room(0x01, 0x000d, /*goto*/ 0x2d)
	if_object_in_room(0x02, 0x000d, /*goto*/ 0x2d)
	if_object_in_room(0x03, 0x000d, /*goto*/ 0x2d)
	goto_first(0x04)

	label(0x2d)
	speak(CHR_P1P2, L_SHO(30), 0x73e0, CHANNEL_6, COLOR_09_BLUE) // "This seems to be one of the special pillars."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1016_msg_powersmoreconstant[] = {
	restart_timer

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0077, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	speak(CHR_P1P2, L_SHO(31), 0x73e1, CHANNEL_6, COLOR_09_BLUE) // "The power's more constant in this area. The Inner ..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1017_msg_skedararmy[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0082, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	speak(CHR_P1P2, L_SHO(32), 0x73e2, CHANNEL_6, COLOR_09_BLUE) // "OH, NO!!! A Skedar army in suspended animation!"
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1018_msg_cutoffthehead[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0088, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	restart_timer

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x2d)
	endloop(0x08)

	label(0x2d)
	speak(CHR_P1P2, L_SHO(33), 0x73e3, CHANNEL_6, COLOR_09_BLUE) // "Okay, this is it... Cut off the head and the body ..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1019_blow_pillars[] = {
	// Wait until all pillars marked
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_PILLAR1_MARKED, TRUE, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_stage_flag_eq(STAGEFLAG_PILLAR2_MARKED, TRUE, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_stage_flag_eq(STAGEFLAG_PILLAR3_MARKED, TRUE, /*goto*/ 0x2d)
	endloop(0x04)

	// Wait 10 seconds
	label(0x2d)
	restart_timer

	beginloop(0x08)
		if_timer_gt(600, /*goto*/ 0x2d)
	endloop(0x08)

	// 1
	label(0x2d)
	unset_object_flag(0x27, OBJFLAG_00000100)
	unset_object_flag(0x28, OBJFLAG_00000100)
	unset_object_flag(0x29, OBJFLAG_00000100)
	unset_object_flag(OBJ_PILLAR1, OBJFLAG_INVINCIBLE)
	unset_object_flag(0x27, OBJFLAG_INVINCIBLE)
	destroy_object(0x27)
	yield
	yield
	yield
	yield
	yield
	restart_timer

	beginloop(0x09)
		if_timer_gt(180, /*goto*/ 0x2d)
	endloop(0x09)

	// 2
	label(0x2d)
	unset_object_flag(OBJ_PILLAR2, OBJFLAG_INVINCIBLE)
	unset_object_flag(0x28, OBJFLAG_INVINCIBLE)
	destroy_object(0x28)
	yield
	yield
	yield
	yield
	yield
	restart_timer

	beginloop(0x0b)
		if_timer_gt(180, /*goto*/ 0x2d)
	endloop(0x0b)

	// 3
	label(0x2d)
	unset_object_flag(OBJ_PILLAR3, OBJFLAG_INVINCIBLE)
	unset_object_flag(0x29, OBJFLAG_INVINCIBLE)
	destroy_object(0x29)
	yield
	yield
	yield
	yield
	yield
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1004_setup_pillars[] = {
	yield
	shuffle_ruins_pillars(OBJ_PILLAR1, OBJ_PILLAR2, OBJ_PILLAR3, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x27, 0x28, 0x29, 0x2f, 0x30, 0x31, 0x32, 0x33)
	yield
	set_object_flag3(OBJ_PILLAR1, OBJFLAG3_RTRACKED_YELLOW)
	set_object_flag3(OBJ_PILLAR2, OBJFLAG3_RTRACKED_YELLOW)
	set_object_flag3(OBJ_PILLAR3, OBJFLAG3_RTRACKED_YELLOW)
	set_object_flag(OBJ_PILLAR1, OBJFLAG_INVINCIBLE)
	set_object_flag(OBJ_PILLAR2, OBJFLAG_INVINCIBLE)
	set_object_flag(OBJ_PILLAR3, OBJFLAG_INVINCIBLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101d_remove_pillar_shadow[] = {
	beginloop(0x04)
		// One of the pillars, but with a different tag
		if_object_in_good_condition(0x41, /*goto*/ 0x2d)

		// Destroyed - remove shadow
		label(0x06)
		hide_object(0x3d)
		hide_object(0x3e)
		unset_object_flag2(0x4e, OBJFLAG2_INVISIBLE)
		unset_object_flag2(0x4f, OBJFLAG2_INVISIBLE)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x2d)
	endloop(0x04)

	// Unreachable
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0c00_intro_sounds[] = {
	label(0xda)
	if_chr_has_chrflag(CHR_BOND, CHRCFLAG_00080000, /*goto*/ 0xdb)
	yield
	goto_first(0xda)

	label(0xdb)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_00080000)

	#define wait_until_with_stageflag(time, loopid) \
		beginloop(loopid) \
			if_stage_flag_eq(STAGEFLAG_IN_INTRO, FALSE, /*goto*/ 0x86) \
			if_controller_button_pressed(/*goto*/ 0x86) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)



	// @bug: Several loops in this function don't check the stageflag.
	// It happens so frequently that I'm using this macro to handle it.
	#define wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0x86) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)



	label(0x2d)
	restart_timer

	wait_until_with_stageflag(100, 0x91)
	speak(CHR_BOND, L_SHO(34), 0x748d, CHANNEL_10, COLOR_04_ORANGE) // "This is the Skedar fanatics' most holy place. They..."

	wait_until_with_stageflag(770, 0xa4)
	play_sound(0x0433, CHANNEL_10)

	wait_until_with_stageflag(800, 0x92)
	speak(CHR_BOND, L_SHO(35), 0x748e, CHANNEL_10, COLOR_09_BLUE) // "So let me get this straight - it's holy. But there..."

	wait_until_with_stageflag(1018, 0xa5)
	play_sound(0x05a0, CHANNEL_10)

	wait_until_with_stageflag(1090, 0xa6)
	play_sound(0x05a1, CHANNEL_10)

	wait_until_with_stageflag(1148, 0xa7)
	play_sound(0x05a0, CHANNEL_10)

	wait_until_with_stageflag(1210, 0x93)
	speak(CHR_BOND, L_SHO(36), 0x748f, CHANNEL_10, COLOR_04_ORANGE) // "Yes. In all of the time that we Maians fought the ..."

	wait_until_with_stageflag(1230, 0xa8)
	play_sound(0x05a1, CHANNEL_10)

	wait_until(1270, 0xc5)
	play_sound(0x0531, CHANNEL_10)

	wait_until_with_stageflag(1274, 0xa9)
	play_sound(0x05a0, CHANNEL_10)

	wait_until_with_stageflag(1330, 0xaa)
	play_sound(0x05a1, CHANNEL_10)

	wait_until_with_stageflag(1375, 0xab)
	play_sound(0x05a0, CHANNEL_10)

	wait_until_with_stageflag(1435, 0xac)
	play_sound(0x05a1, CHANNEL_10)

	wait_until_with_stageflag(1490, 0xad)
	play_sound(0x05a0, CHANNEL_10)

	wait_until_with_stageflag(1600, 0xc7)
	play_sound(0x05c7, CHANNEL_10)

	wait_until_with_stageflag(1670, 0xc8)
	play_sound(0x05c6, CHANNEL_10)

	wait_until_with_stageflag(1710, 0xae)
	play_sound(0x05c5, CHANNEL_10)

	wait_until_with_stageflag(1840, 0xaf)
	play_sound(0x05cc, CHANNEL_10)

	wait_until_with_stageflag(2040, 0xb7)
	play_sound(0x05a0, CHANNEL_10)

	wait_until_with_stageflag(2065, 0xb0)
	play_sound(0x05a1, CHANNEL_10)

	wait_until_with_stageflag(2090, 0xb8)
	play_sound(0x05a0, CHANNEL_10)

	wait_until_with_stageflag(2115, 0xb1)
	play_sound(0x05a1, CHANNEL_10)

	wait_until(2050, 0xc6) // time is out of order
	play_sound(0x0530, CHANNEL_10)

	wait_until_with_stageflag(2140, 0xb9)
	play_sound(0x05a0, CHANNEL_10)

	wait_until_with_stageflag(2180, 0xb2)
	play_sound(0x05a1, CHANNEL_10)

	wait_until_with_stageflag(2220, 0xb3)
	play_sound(0x05a0, CHANNEL_10)

	wait_until_with_stageflag(2250, 0xb4)
	play_sound(0x05a0, CHANNEL_10)

	wait_until_with_stageflag(2290, 0xb5)
	play_sound(0x05a0, CHANNEL_10)

	wait_until_with_stageflag(2340, 0xb6)
	play_sound(0x05a0, CHANNEL_10)

	wait_until_with_stageflag(2650, 0x94)
	speak(CHR_BOND, L_SHO(37), 0x7490, CHANNEL_10, COLOR_09_BLUE) // "Then we have to be certain that no fanatics surviv..."

	wait_until_with_stageflag(3250, 0x95)
	speak(CHR_BOND, L_SHO(38), 0x7491, CHANNEL_10, COLOR_04_ORANGE) // "If you're caught on the ground when the fleet gets..."

	wait_until(3330, 0xc3)
	play_sound(0x0530, CHANNEL_10)

	wait_until(3535, 0xc4)
	play_sound(0x0531, CHANNEL_10)

	wait_until_with_stageflag(3600, 0x96)
	mute_channel(CHANNEL_7)
	speak(CHR_BOND, L_SHO(39), 0x7492, CHANNEL_10, COLOR_09_BLUE) // "That's a mistake I don't intend to make."

	wait_until(4040, 0xc0)
	play_sound(0x05a0, CHANNEL_10)

	wait_until(4158, 0xc1)
	play_sound(0x05a1, CHANNEL_10)

	wait_until(4236, 0xc2)
	play_sound(0x0529, CHANNEL_10)

	wait_until(4580, 0xbc)
	play_sound(0x01d8, CHANNEL_10)

	wait_until(4610, 0xbd)
	play_sound(0x01da, CHANNEL_10)

	wait_until(4630, 0xbe)
	play_sound(0x80f6, CHANNEL_10)

	wait_until(4678, 0xbf)
	play_sound(0x01db, CHANNEL_10)

	wait_until_with_stageflag(4675, 0x97)
	play_sound(0x0162, CHANNEL_10)

	wait_until_with_stageflag(4750, 0xbb)
	play_sound(0x0161, CHANNEL_10)

	mute_channel(CHANNEL_0)
	mute_channel(CHANNEL_1)
	mute_channel(CHANNEL_2)
	mute_channel(CHANNEL_3)
	mute_channel(CHANNEL_4)
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_7)
	label(0x86)
	mute_channel(CHANNEL_10)
	goto_first(0xda)

	endlist
};

u8 func0414_outro_sounds[] = {
	// The kill countable flag is probably just used to track which player
	// destroyed the final spike so they can be shown in the outro.
	label(0xda)
	if_chr_has_chrflag(CHR_BOND, CHRCFLAG_KILLCOUNTABLE, /*goto*/ 0xdb)
	if_chr_has_chrflag(CHR_COOP, CHRCFLAG_KILLCOUNTABLE, /*goto*/ 0xdc)
	yield
	goto_first(0xda)

	label(0xdb)
	set_target_chr(CHR_BOND)
	goto_next(0x2d)

	label(0xdc)
	set_target_chr(CHR_COOP)
	goto_next(0x2d)

	#define outro_wait_until_with_stageflag(time, loopid) \
		beginloop(loopid) \
			if_stage_flag_eq(STAGEFLAG_IN_OUTRO, FALSE, /*goto*/ 0x86) \
			if_controller_button_pressed(/*goto*/ 0x86) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)



	#define outro_wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0x86) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)



	label(0x2d)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_KILLCOUNTABLE)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_KILLCOUNTABLE)
	restart_timer


	outro_wait_until_with_stageflag(40, 0xd5)
	play_sound(0x0067, CHANNEL_10)

	outro_wait_until_with_stageflag(80, 0x9e)
	play_sound(0x0067, CHANNEL_10)

	outro_wait_until_with_stageflag(120, 0x9f)
	play_sound(0x0067, CHANNEL_10)

	outro_wait_until_with_stageflag(160, 0xa0)
	play_sound(0x05c0, CHANNEL_10)

	outro_wait_until_with_stageflag(180, 0xa1)
	play_sound(0x052d, CHANNEL_10)

	outro_wait_until_with_stageflag(230, 0x9b)
	speak(CHR_BOND, L_SHO(40), 0x74de, CHANNEL_10, COLOR_09_BLUE) // "Yesss..."

	outro_wait_until_with_stageflag(470, 0xa9)
	play_sound(0x8099, CHANNEL_10)

	outro_wait_until_with_stageflag(494, 0xa2)
	play_sound(0x8098, CHANNEL_10)
	play_sound(0x00f6, CHANNEL_10)

	outro_wait_until_with_stageflag(520, 0xa8)
	play_sound(0x809b, CHANNEL_10)

	outro_wait_until_with_stageflag(540, 0xa3)
	play_sound(0x80a2, CHANNEL_10)
	play_sound(0x00f6, CHANNEL_10)

	outro_wait_until_with_stageflag(550, 0xd6)
	play_sound(0x77c8, CHANNEL_10)

	outro_wait_until_with_stageflag(600, 0xaa)
	play_sound(0x80a3, CHANNEL_10)

	outro_wait_until_with_stageflag(616, 0xa4)
	play_sound(0x809f, CHANNEL_10)
	play_sound(0x00f6, CHANNEL_10)

	outro_wait_until_with_stageflag(700, 0xa5)
	play_sound(0x80a1, CHANNEL_10)
	play_sound(0x00f6, CHANNEL_10)

	outro_wait_until_with_stageflag(760, 0xcd)
	play_sound(0x80a3, CHANNEL_10)

	outro_wait_until(780, 0xae)
	fade_to_color(0x000000ff, 80)

	outro_wait_until_with_stageflag(790, 0xa6)
	play_sound(0x809c, CHANNEL_10)
	play_sound(0x00f6, CHANNEL_10)

	outro_wait_until_with_stageflag(820, 0xcc)
	play_sound(0x80a2, CHANNEL_10)

	outro_wait_until_with_stageflag(860, 0xa7)
	play_sound(0x80a3, CHANNEL_10)

	outro_wait_until_with_stageflag(880, 0xce)
	play_sound(0x77da, CHANNEL_10)

	outro_wait_until(920, 0xaf)
	fade_to_color(0xffffffff, 0)
	fade_to_color(0x00000000, 120)
	set_cutscene_weapon(CHR_TARGET, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_TARGET, WEAPON_NONE, WEAPON_NONE)
	set_cutscene_weapon(CHR_ELVIS, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_ELVIS, WEAPON_NONE, WEAPON_NONE)

	outro_wait_until_with_stageflag(1680, 0x91)
	mute_channel(CHANNEL_10)
	speak(CHR_BOND, L_SHO(41), 0x7493, CHANNEL_10, COLOR_04_ORANGE) // "Joanna! Joanna!"

	outro_wait_until_with_stageflag(2020, 0x9c)
	speak(CHR_BOND, L_SHO(54), 0x7755, CHANNEL_10, COLOR_04_ORANGE) // "Where are you? Are you hurt?"

	outro_wait_until_with_stageflag(2206, 0x92)
	speak(CHR_BOND, L_SHO(42), 0x7494, CHANNEL_10, COLOR_09_BLUE) // "Elvis! Elvis! Over here."

	outro_wait_until_with_stageflag(2625, 0x93)
	speak(CHR_BOND, L_SHO(43), 0x7495, CHANNEL_10, COLOR_04_ORANGE) // "No problem. Grab my arms - we'll get you out in no..."

	outro_wait_until_with_stageflag(2810, 0xd4)
	play_sound(0x0531, CHANNEL_10)

	outro_wait_until_with_stageflag(2895, 0x94)
	speak(CHR_BOND, L_SHO(44), 0x7496, CHANNEL_10, COLOR_09_BLUE) // "No, quick! Give me your gun!"

	outro_wait_until_with_stageflag(3160, 0xca)
	set_cutscene_weapon(CHR_ELVIS, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_ELVIS, WEAPON_PHOENIX, WEAPON_NONE)

	outro_wait_until_with_stageflag(3280, 0xcb)
	set_cutscene_weapon(CHR_TARGET, WEAPON_PHOENIX, WEAPON_NONE)
	set_cutscene_weapon(CHR_ELVIS, WEAPON_NONE, WEAPON_NONE)

	outro_wait_until_with_stageflag(3290, 0x95)
	speak(CHR_BOND, L_SHO(45), 0x7497, CHANNEL_10, COLOR_09_BLUE) // "Will! You! Just! Let! Go!"

	outro_wait_until_with_stageflag(3420, 0xcf)
	set_chr_shooting_in_cutscene(CHR_TARGET, TRUE)
	yield
	yield
	set_chr_shooting_in_cutscene(CHR_TARGET, FALSE)
	play_sound(0x052e, CHANNEL_10)

	outro_wait_until_with_stageflag(3445, 0xd0)
	set_chr_shooting_in_cutscene(CHR_TARGET, TRUE)
	yield
	yield
	set_chr_shooting_in_cutscene(CHR_TARGET, FALSE)

	outro_wait_until_with_stageflag(3470, 0xd1)
	set_chr_shooting_in_cutscene(CHR_TARGET, TRUE)
	yield
	yield
	set_chr_shooting_in_cutscene(CHR_TARGET, FALSE)

	outro_wait_until_with_stageflag(3495, 0xd2)
	set_chr_shooting_in_cutscene(CHR_TARGET, TRUE)
	yield
	yield
	set_chr_shooting_in_cutscene(CHR_TARGET, FALSE)

	outro_wait_until_with_stageflag(3520, 0xd3)
	set_chr_shooting_in_cutscene(CHR_TARGET, TRUE)
	yield
	yield
	set_chr_shooting_in_cutscene(CHR_TARGET, FALSE)
	play_sound_from_object2(CHANNEL_6, 0x25, 0x052d, 0x00, 0x00)

	outro_wait_until_with_stageflag(3600, 0xd7)
	play_sound(0x77c9, CHANNEL_10)

	outro_wait_until_with_stageflag(3880, 0xd8)
	play_sound(0x0427, CHANNEL_10)

	outro_wait_until_with_stageflag(3990, 0x96)
	speak(CHR_BOND, L_SHO(46), 0x7498, CHANNEL_10, COLOR_04_ORANGE) // "I managed to get the fleet to stop the bombardment..."

	outro_wait_until_with_stageflag(4425, 0x97)
	speak(CHR_BOND, L_SHO(47), 0x7499, CHANNEL_10, COLOR_09_BLUE) // "I'd have got out in time if that one hadn't grabbe..."

	outro_wait_until_with_stageflag(4650, 0x98)
	speak(CHR_BOND, L_SHO(48), 0x749a, CHANNEL_10, COLOR_04_ORANGE) // "Of course, Joanna, of course."

	outro_wait_until_with_stageflag(4825, 0x99)
	speak(CHR_BOND, L_SHO(49), 0x749b, CHANNEL_10, COLOR_09_BLUE) // "No, I would have."

	outro_wait_until_with_stageflag(4960, 0x9a)
	speak(CHR_BOND, L_SHO(50), 0x749c, CHANNEL_10, COLOR_04_ORANGE) // "I believe you."

	outro_wait_until_with_stageflag(5560, 0x9d)
	play_sound(0x0161, CHANNEL_7)

	label(0x86)
	mute_channel(CHANNEL_10)
	mute_channel(CHANNEL_7)
	mute_channel(CHANNEL_6)
	goto_first(0xda)

	endlist
};

u8 func1020_show_phoenix[] = {
	// Show Phoenix once pillars destroyed
	beginloop(0x04)
		if_object_in_good_condition(0x2a, /*goto*/ 0x2d)
		if_object_in_good_condition(0x2b, /*goto*/ 0x2d)
		if_object_in_good_condition(0x2c, /*goto*/ 0x2d)
		if_object_in_good_condition(0x2d, /*goto*/ 0x2d)
		if_object_in_good_condition(0x2e, /*goto*/ 0x2d)
		unset_object_flag(OBJ_PHOENIX1, OBJFLAG_UNCOLLECTABLE)
		unset_object_flag2(OBJ_PHOENIX1, OBJFLAG2_INVISIBLE)
		unset_object_flag(OBJ_PHOENIX2, OBJFLAG_UNCOLLECTABLE)
		unset_object_flag2(OBJ_PHOENIX2, OBJFLAG2_INVISIBLE)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x2d)
	endloop(0x04)

	endlist
};

/**
 * Handle the mine hidden inside the first ravine debris.
 */
u8 func1021_handle_mine[] = {
	yield
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2d)

	// SA and PA
	hide_object(OBJ_REMOTEMINE)

	// A
	label(0x2d)
	destroy_object(OBJ_REMOTEMINE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1022_armyroom_exitdoors[] = {
	yield
	set_object_flag2(0x45, OBJFLAG2_LOCKEDFRONT)
	set_object_flag2(0x46, OBJFLAG2_LOCKEDBACK)
	if_difficulty_gt(DIFF_SA, /*goto*/ 0x2d)

	// A and SA
	beginloop(0x91)
		if_objective_complete(0, /*goto*/ 0x06)
	endloop(0x91)

	label(0x06)
	unset_object_flag2(0x45, OBJFLAG2_LOCKEDFRONT)
	unset_object_flag2(0x46, OBJFLAG2_LOCKEDBACK)

	// All difficulties
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 unregistered_function1[] = {
	restart_timer

	beginloop(0x04)
		if_timer_gt(300, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	chr_drop_weapon(CHR_BOND)
	show_hudmsg(CHR_BOND, L_SHO(26)) // "Target Amplifier placed incorrectly."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Used to print whether the puzzle rock is pushable or not.
 */
u8 unregistered_function2[] = {
	beginloop(0x04)
		if_object_flag3(OBJ_PUZZLEROCK, OBJFLAG3_PUSHABLE, /*goto*/ 0x2d)
		dprint 'C','A','N','T',' ','P','U','S','H','\n',0,
		reloop(0x04)

		label(0x2d)
		dprint 'C','A','N',' ','P','U','S','H','\n',0,
	endloop(0x04)

	endlist
};

u8 func1024_check_grenades_wasted[] = {
	beginloop(0x04)
		if_ammo_quantity_lt(CHR_BOND, AMMOTYPE_DEVASTATOR, 1, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)
		if_ammo_quantity_lt(CHR_COOP, AMMOTYPE_DEVASTATOR, 1, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	restart_timer

	beginloop(0x91)
		if_timer_gt(240, /*goto*/ 0x2d)
	endloop(0x91)

	label(0x2d)
	if_object_in_good_condition(0x4d, /*goto*/ 0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	label(0x2d)
	restart_timer

	beginloop(0x08)
		if_timer_gt(60, /*goto*/ 0x09)
	endloop(0x08)

	beginloop(0x09)
		if_object_in_good_condition(0x4d, /*goto*/ 0x2d)

		// Blown up using other means (eg. Phoenix or all guns cheat)
		unset_stage_flag(STAGEFLAG_GRENADES_WASTED)
		show_hudmsg(CHR_BOND, L_SHO(53)) // "Alternative entrance to Shrine created."
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x2d)
		if_stage_flag_eq(STAGEFLAG_GRENADES_WASTED, TRUE, /*goto*/ 0x2d)
		show_hudmsg(CHR_BOND, L_SHO(52)) // "Grenade ammo used up - can't enter Shrine."
		set_stage_flag(STAGEFLAG_GRENADES_WASTED)
		label(0x2d)
	endloop(0x09)

	endlist
};

u8 func1023_setup_rtracker[] = {
	yield
	set_object_flag3(OBJ_PHOENIX1, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(OBJ_PHOENIX2, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1427_setup_lighting[] = {
	yield
	misc_command(0x0004, 0x05, 0x01)
	misc_command(0x0004, 0x06, 0x01)
	misc_command(0x0005, 0x05, 0x01)
	misc_command(0x0005, 0x06, 0x01)
	misc_command(0x0006, 0x05, 0x01)
	misc_command(0x0006, 0x06, 0x01)
	misc_command(0x0007, 0x05, 0x01)
	misc_command(0x0007, 0x06, 0x01)
	misc_command(0x0008, 0x05, 0x01)
	misc_command(0x0008, 0x06, 0x01)
	misc_command(0x0009, 0x05, 0x01)
	misc_command(0x0009, 0x06, 0x01)
	misc_command(0x000a, 0x05, 0x01)
	misc_command(0x000a, 0x06, 0x01)
	misc_command(0x000b, 0x05, 0x01)
	misc_command(0x000b, 0x06, 0x01)
	misc_command(0x000c, 0x05, 0x01)
	misc_command(0x000c, 0x06, 0x01)
	misc_command(0x000d, 0x05, 0x01)
	misc_command(0x000d, 0x06, 0x01)
	misc_command(0x000e, 0x05, 0x01)
	misc_command(0x000e, 0x06, 0x01)
	misc_command(0x000f, 0x05, 0x01)
	misc_command(0x000f, 0x06, 0x01)
	misc_command(0x0010, 0x05, 0x01)
	misc_command(0x0010, 0x06, 0x01)
	misc_command(0x0011, 0x05, 0x01)
	misc_command(0x0011, 0x06, 0x01)
	misc_command(0x0012, 0x05, 0x01)
	misc_command(0x0012, 0x06, 0x01)
	misc_command(0x0013, 0x05, 0x01)
	misc_command(0x0013, 0x06, 0x01)
	misc_command(0x0014, 0x05, 0x01)
	misc_command(0x0014, 0x06, 0x01)
	misc_command(0x0015, 0x05, 0x01)
	misc_command(0x0015, 0x06, 0x01)
	misc_command(0x0016, 0x05, 0x01)
	misc_command(0x0016, 0x06, 0x01)
	misc_command(0x0017, 0x05, 0x01)
	misc_command(0x0017, 0x06, 0x01)
	misc_command(0x0018, 0x05, 0x01)
	misc_command(0x0018, 0x06, 0x01)
	misc_command(0x0019, 0x05, 0x01)
	misc_command(0x0019, 0x06, 0x01)
	misc_command(0x001a, 0x05, 0x01)
	misc_command(0x001b, 0x05, 0x01)
	misc_command(0x001b, 0x06, 0x01)
	misc_command(0x001d, 0x05, 0x01)
	misc_command(0x001d, 0x06, 0x01)
	misc_command(0x001e, 0x05, 0x01)
	misc_command(0x001e, 0x06, 0x01)
	misc_command(0x001f, 0x05, 0x01)
	misc_command(0x001f, 0x06, 0x01)
	misc_command(0x0020, 0x05, 0x01)
	misc_command(0x0020, 0x06, 0x01)
	misc_command(0x0021, 0x05, 0x01)
	misc_command(0x0021, 0x06, 0x01)
	misc_command(0x0022, 0x05, 0x01)
	misc_command(0x0022, 0x06, 0x01)
	misc_command(0x0023, 0x05, 0x01)
	misc_command(0x0023, 0x06, 0x01)
	misc_command(0x0024, 0x05, 0x01)
	misc_command(0x0024, 0x06, 0x01)
	misc_command(0x0025, 0x05, 0x01)
	misc_command(0x0025, 0x06, 0x01)
	misc_command(0x0026, 0x05, 0x01)
	misc_command(0x0026, 0x06, 0x01)
	misc_command(0x0027, 0x05, 0x01)
	misc_command(0x0027, 0x06, 0x01)
	misc_command(0x0028, 0x05, 0x01)
	misc_command(0x0028, 0x06, 0x01)
	misc_command(0x0029, 0x05, 0x01)
	misc_command(0x0029, 0x06, 0x01)
	misc_command(0x002a, 0x05, 0x01)
	misc_command(0x002a, 0x06, 0x01)
	misc_command(0x002b, 0x05, 0x01)
	misc_command(0x002b, 0x06, 0x01)
	misc_command(0x002c, 0x05, 0x01)
	misc_command(0x002c, 0x06, 0x01)
	misc_command(0x002d, 0x05, 0x01)
	misc_command(0x002d, 0x06, 0x01)
	misc_command(0x002e, 0x05, 0x01)
	misc_command(0x002e, 0x06, 0x01)
	misc_command(0x002f, 0x05, 0x01)
	misc_command(0x002f, 0x06, 0x01)
	misc_command(0x0030, 0x05, 0x01)
	misc_command(0x0030, 0x06, 0x01)
	misc_command(0x0031, 0x05, 0x01)
	misc_command(0x0031, 0x06, 0x01)
	misc_command(0x003b, 0x05, 0x01)
	misc_command(0x003b, 0x06, 0x01)
	misc_command(0x003c, 0x05, 0x01)
	misc_command(0x003c, 0x06, 0x01)
	misc_command(0x003d, 0x05, 0x01)
	misc_command(0x003d, 0x06, 0x01)
	misc_command(0x003e, 0x05, 0x01)
	misc_command(0x003e, 0x06, 0x01)
	misc_command(0x003f, 0x05, 0x01)
	misc_command(0x003f, 0x06, 0x01)
	misc_command(0x0040, 0x05, 0x01)
	misc_command(0x0040, 0x06, 0x01)
	misc_command(0x0041, 0x05, 0x01)
	misc_command(0x0041, 0x06, 0x01)
	misc_command(0x0042, 0x05, 0x01)
	misc_command(0x0042, 0x06, 0x01)
	misc_command(0x0043, 0x05, 0x01)
	misc_command(0x0043, 0x06, 0x01)
	misc_command(0x0044, 0x05, 0x01)
	misc_command(0x0044, 0x06, 0x01)
	misc_command(0x0045, 0x05, 0x01)
	misc_command(0x0046, 0x05, 0x01)
	misc_command(0x0047, 0x05, 0x01)
	misc_command(0x0047, 0x06, 0x01)
	misc_command(0x0049, 0x05, 0x01)
	misc_command(0x0049, 0x06, 0x01)
	misc_command(0x004a, 0x05, 0x01)
	misc_command(0x004a, 0x06, 0x01)
	misc_command(0x004b, 0x06, 0x01)
	misc_command(0x0048, 0x06, 0x01)
	misc_command(0x004f, 0x05, 0x01)
	misc_command(0x0058, 0x05, 0x01)
	misc_command(0x0059, 0x05, 0x01)
	misc_command(0x0059, 0x06, 0x01)
	misc_command(0x0032, 0x05, 0x01)
	misc_command(0x0034, 0x05, 0x01)
	misc_command(0x0035, 0x05, 0x01)
	misc_command(0x0036, 0x05, 0x01)
	misc_command(0x0037, 0x05, 0x01)
	misc_command(0x0038, 0x05, 0x01)
	misc_command(0x0032, 0x06, 0x01)
	misc_command(0x0034, 0x06, 0x01)
	misc_command(0x0035, 0x06, 0x01)
	misc_command(0x0036, 0x06, 0x01)
	misc_command(0x0037, 0x06, 0x01)
	misc_command(0x0038, 0x06, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1025_unlock_doors_for_buddy[] = {
	yield
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)

	// Co-op mode
	// Wait for pillars objective
	beginloop(0x91)
		if_objective_complete(0, /*goto*/ 0x2d)
		reloop(0x91)

		// Unlock doors repeatedly
		label(0x2d)
		unlock_door(0x0d, 0x02)
		unlock_door(0x0e, 0x02)
		unlock_door(0x0f, 0x02)
		unlock_door(0x10, 0x02)
		unlock_door(0x45, 0x80)
		unlock_door(0x46, 0x80)
	endloop(0x91)

	// Buddy doesn't exist
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1426_setup_portals[] = {
	yield
	set_portal_flag(0x0072, 0x04)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1028_buddybridge[] = {
	yield

	// Wait for camera to finish
	beginloop(0x59)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x2e)

		label(0x2d)
	endloop(0x59)

	// Wait 5 seconds
	label(0x2e)
	restart_timer

	beginloop(0x04)
		if_timer_gt(300, /*goto*/ 0x2d)
	endloop(0x04)

	// This flag is set by global ailists
	label(0x2d)
	if_stage_flag_eq(STAGEFLAG_AI_BUDDY_EXISTS, FALSE, /*goto*/ 0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Flag not set - so this is solo mode
	// Remove the bridge and barricade over the first ravine
	label(0x2d)
	hide_object(OBJ_BUDDYBRIDGE)
	hide_object(OBJ_BUDDYBARRICADE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

struct ailist ailists[] = {
	{ func0401_init_unarmed_skedar,           0x0401 },
	{ func0402_unarmed_skedar,                0x0402 },
	{ func0403_init_miniskedar,               0x0403 },
	{ func0404_miniskedar,                    0x0404 },
	{ func0405_puzzleroom_miniskedar_waiting, 0x0405 },
	{ func0404_miniskedar_spawner,            0x0406 },
	{ func0407_init_cloaked_skedar,           0x0407 },
	{ func0408_cloaked_skedar,                0x0408 },
	{ func0409_reaper_slayer_skedar,          0x0409 },
	{ func040a_init_reaper_slayer_skedar,     0x040a },
	{ func040b_mauler_skedar,                 0x040b },
	{ func040c_king_waiting,                  0x040c },
	{ func040d_king_combat,                   0x040d },
	{ func040e_king_skedar_spawner,           0x040e },
	{ func040f_update_spike_stageflags,       0x040f },
	{ func0410_init_king_skedar_clone,        0x0410 },
	{ func0411_king_miniskedar_spawner,       0x0411 },
	{ func0412_init_king_miniskedar_clone,    0x0412 },
	{ func0413_hide,                          0x0413 },
	{ func0414_outro,                         0x0414 },
	{ func0c00_intro,                         0x0c00 },
	{ func0414_outro_from_menu,               0x0c01 },
	{ func1400_setup_counterop,               0x1400 },
	{ func1001_objectives_failed_msg,         0x1001 },
	{ func0c00_intro,                         0x1002 },
	{ func1003_remove_random_skedar,          0x1003 },
	{ func1004_setup_pillars,                 0x1004 },
	{ func1005_5e0c,                          0x1005 },
	{ func1006_bridge,                        0x1006 },
	{ func1007_bug_throws_bond,               0x1007 },
	{ func1008_lock_door,                     0x1008 },
	{ func1009_altar,                         0x1009 },
	{ func100a_army_room,                     0x100a },
	{ func100b_check_sanctum_accessed,        0x100b },
	{ func100c_check_army_defeated,           0x100c },
	{ func100e_wake_skedar_army,              0x100e },
	{ func100f_spikes_vulnerability,          0x100f },
	{ func1010_spike_ml,                      0x1010 },
	{ func1011_spike_mr,                      0x1011 },
	{ func1012_spike_bl,                      0x1012 },
	{ func1013_spike_br,                      0x1013 },
	{ func1014_spike_top,                     0x1014 },
	{ func1015_msg_specialpillars,            0x1015 },
	{ func1016_msg_powersmoreconstant,        0x1016 },
	{ func1017_msg_skedararmy,                0x1017 },
	{ func1018_msg_cutoffthehead,             0x1018 },
	{ func1019_blow_pillars,                  0x1019 },
	{ func101a_pointless,                     0x101a },
	{ func101b_bug_throws_coop,               0x101b },
	{ func101c_setup_corridor_lighting,       0x101c },
	{ func101d_remove_pillar_shadow,          0x101d },
	{ func0c00_intro_sounds,                  0x141e },
	{ func0414_outro_sounds,                  0x141f },
	{ func1020_show_phoenix,                  0x1020 },
	{ func1021_handle_mine,                   0x1021 },
	{ func1022_armyroom_exitdoors,            0x1022 },
	{ func1023_setup_rtracker,                0x1023 },
	{ func1024_check_grenades_wasted,         0x1024 },
	{ func1025_unlock_doors_for_buddy,        0x1025 },
	{ func1426_setup_portals,                 0x1426 },
	{ func1427_setup_lighting,                0x1427 },
	{ func1028_buddybridge,                   0x1028 },
	{ NULL, 0 },
};

struct path paths[] = {
	{ NULL, 0, 0 },
};

