//
// Air Force One
//

#include "stagesetup.h"

// Characters
#define CHR_ELVIS      0x00
#define CHR_PRESIDENT  0x18
#define CHR_PILOT1     0x19
#define CHR_PILOT2     0x1a
#define CHR_STEWARDESS 0x1b
#define CHR_STEWARD    0x1c
#define CHR_TAKER1     0x2a
#define CHR_TAKER2     0x2b
#define CHR_TRENT      0x32
#define CHR_BLONDE1    0x33
#define CHR_BLONDE2    0x34

// Objects
#define OBJ_EQUIPMENT              0x00
#define OBJ_DATAUPLINK_BOND        0x01
#define OBJ_COMMSHUB1              0x02
#define OBJ_AUTOPILOT_SWITCH       0x03
#define OBJ_REMOTEMINE_BOND        0x04
#define OBJ_DUMBWAITER1            0x05
#define OBJ_DUMBWAITER2            0x06
#define OBJ_DUMBWAITER1_SWITCH     0x07
#define OBJ_DUMBWAITER2_SWITCH     0x08
#define OBJ_FLOORHATCH             0x0b
#define OBJ_COCKPITDOOR            0x0e
#define OBJ_DATAUPLINK_COOP        0x16
#define OBJ_REMOTEMINE_COOP        0x17
#define OBJ_EQUIPMENT_SWITCH       0x1e
#define OBJ_HOVERBIKE_SWITCH       0x21
#define OBJ_KEYCARD                0x22
#define OBJ_ESCAPE_POD             0x24
#define OBJ_EXTERIOR_DOOR          0x25
#define OBJ_EXTERIOR_DOOR_DETACHED 0x26
#define OBJ_COMMSHUB2              0x27
#define OBJ_COMMSHUB3              0x28
#define OBJ_COMMSHUB4              0x29
#define OBJ_COMMSHUB5              0x2a
#define OBJ_FLOOR_HATCH_DETACHED   0x2e
#define OBJ_EQUIPMENT_COOP         0x3a

// Stage flags
#define STAGEFLAG_POD_DESTROYED              0x00000004
#define STAGEFLAG_ALL_OBJECTIVES_COMPLETE    0x00000008
#define STAGEFLAG_PLANE_NOSEDIVING           0x00000010
#define STAGEFLAG_BOND_MINE_WASTED           0x00000020
#define STAGEFLAG_COOP_MINE_WASTED           0x00000040
#define STAGEFLAG_AI_BUDDY_EXISTS            0x00000080
#define STAGEFLAG_PRESIDENT_STARTED_RUNNING  0x00000100
#define STAGEFLAG_PRESIDENT_AT_POD           0x00000200
#define STAGEFLAG_UFO_ATTACHMENT_DAMAGED     0x00000800
#define STAGEFLAG_KILLED_NEUTRALS            0x00001000
#define STAGEFLAG_PILOTS_DEAD                0x00002000
#define STAGEFLAG_PLANE_STABILIZED           0x00004000
#define STAGEFLAG_AUTOPILOT_DESTROYED        0x00008000
#define STAGEFLAG_PRESIDENT_DEAD             0x00010000
#define STAGEFLAG_BOTH_BLONDES_DEAD          0x00020000
#define STAGEFLAG_ONE_BLONDE_DEAD            0x00040000
#define STAGEFLAG_PRESIDENT_CALLED_SECURITY  0x00080000
#define STAGEFLAG_00100000                   0x00100000
#define STAGEFLAG_INTRO_FINISHED             0x00200000
#define STAGEFLAG_TRIGGER_MIDCUTSCENE        0x00400000
#define STAGEFLAG_MIDCUTSCENE_FINISHED       0x00800000
#define STAGEFLAG_EQUIPMENT_RAISED           0x01000000
#define STAGEFLAG_EQUIPMENT_SWITCH_DESTROYED 0x02000000
#define STAGEFLAG_BOTH_MINES_WASTED          0x04000000
#define STAGEFLAG_PRESIDENT_INJURED          0x08000000
#define STAGEFLAG_PLANE_CRASHED              0x10000000
#define STAGEFLAG_MIDCUTSCENE_STARTED        0x20000000

// AI Lists
#define AILIST_INIT_STRIPES        0x0401
#define AILIST_INIT_ELVIS          0x0402
#define AILIST_STRIPES             0x0403
#define AILIST_PRESIDENT_RUNNING   0x0404
#define AILIST_PRESIDENT_IN_ROOM   0x0405
#define AILIST_INIT_PRESIDENT      0x0406
#define AILIST_STEWARD             0x0407
#define AILIST_STEWARDESS          0x0408
#define AILIST_DEFEND_PAD          0x040a
#define AILIST_DEFEND_PRESIDENT    0x040b
#define AILIST_INIT_DEFEND_PAD     0x040c
#define AILIST_TAKER1              0x040f
#define AILIST_TAKER2              0x0410
#define AILIST_TYPING_GUY          0x0411
#define AILIST_SITTING_GUY         0x0412
#define AILIST_TAKER               0x0413
#define AILIST_COCKPIT_STRIPES     0x0414
#define AILIST_CLONER1             0x0415
#define AILIST_INIT_CLONE1         0x0416
#define AILIST_CLONE1              0x0417
#define AILIST_CLONER2             0x0418
#define AILIST_INIT_CLONE2         0x0419
#define AILIST_CLONE2              0x041a
#define AILIST_CLONER3             0x041b
#define AILIST_INIT_CLONE3         0x041c
#define AILIST_CLONE3              0x041d
#define AILIST_BLONDE              0x041e
#define AILIST_INIT_BLONDE         0x041f
#define AILIST_TRENT_ATTACKING     0x0420
#define AILIST_TRENT_WAITING       0x0421
#define AILIST_TRENT_RUNNING       0x0422
#define AILIST_OUTRO               0x0423
#define AILIST_MIDCUTSCENE         0x0424
#define AILIST_STEWARD_SHOT        0x0425
#define AILIST_BE_UNALERT          0x0429
#define AILIST_INIT_NEUTRAL        0x042a
#define AILIST_REINIT_STRIPES      0x042b
#define AILIST_REMOVE_IF_OFFSCREEN 0x042c

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x3601)
	briefing(1, 0x3600)
	briefing(2, 0x3602)
	briefing(3, 0x3603)

	beginobjective(0, L_RIT(5), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Locate and retrieve equipment"
		require_object_collected(OBJ_EQUIPMENT)
		fail_flags(STAGEFLAG_EQUIPMENT_SWITCH_DESTROYED)
	endobjective

	beginobjective(1, L_RIT(6), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Locate President"
		complete_flags(STAGEFLAG_PRESIDENT_STARTED_RUNNING)
		fail_flags(STAGEFLAG_PRESIDENT_CALLED_SECURITY)
	endobjective

	beginobjective(2, L_RIT(7), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Get President to escape capsule"
		complete_flags(STAGEFLAG_PRESIDENT_AT_POD)
		fail_flags(STAGEFLAG_PRESIDENT_DEAD)
		fail_flags(STAGEFLAG_KILLED_NEUTRALS)
		fail_flags(STAGEFLAG_POD_DESTROYED)
	endobjective

	beginobjective(3, L_RIT(8), (DIFFBIT_PA | DIFFBIT_PD)) // "Secure Air Force One flight path"
		complete_flags(STAGEFLAG_PLANE_STABILIZED)
		fail_flags(STAGEFLAG_AUTOPILOT_DESTROYED)
	endobjective

	beginobjective(4, L_RIT(9), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Detach UFO from Air Force One"
		complete_flags(STAGEFLAG_UFO_ATTACHMENT_DAMAGED)
		fail_flags(STAGEFLAG_BOTH_MINES_WASTED)
		fail_flags(STAGEFLAG_PLANE_CRASHED)
	endobjective

	chr(0x00000400, 0x32, 0x00be, BODY_TRENT, HEAD_TRENT, GAILIST_IDLE, -1, -1, 200, 8, 0x40018000, 0x00101a00, TEAM_NONCOMBAT, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDY357TRENT, 0x0032, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DY357LX, 0x00ffffff, 0x00000000)
	chr(0x00000400, 0x33, 0x00bc, BODY_MRBLONDE, HEAD_MRBLONDE, GAILIST_IDLE, -1, -1, 200, 100, 0x40018201, 0x00101a00, TEAM_NONCOMBAT, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0033, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000400, 0x34, 0x00bd, BODY_MRBLONDE, HEAD_MRBLONDE, GAILIST_IDLE, -1, -1, 200, 100, 0x40018201, 0x00101a00, TEAM_NONCOMBAT, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0034, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000400, 0x01, 0x008b, BODY_OVERALL, HEAD_RANDOM, AILIST_INIT_NEUTRAL, 0x008b, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	chr(0x000044c0, 0x1b, 0x008c, BODY_STEWARDESS, HEAD_RANDOM, AILIST_STEWARDESS, 0x00b2, -1, 2000, 5, 0x40002000, 0x00000101, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00010000)
	chr(0x000044c0, 0x1c, 0x00c1, BODY_STEWARD, HEAD_RANDOM, AILIST_STEWARD, 0x001f, -1, 2000, 5, 0x40002000, 0x00000101, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00010000)
	chr(0x00000600, 0x04, 0x008e, BODY_OVERALL, HEAD_RANDOM, AILIST_INIT_NEUTRAL, 0x008e, -1, 1000, 100, 0xc0002000, 0x20000001, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	chr(0x00000600, 0x05, 0x008f, BODY_OVERALL, HEAD_RANDOM, AILIST_INIT_NEUTRAL, 0x008f, -1, 1000, 100, 0xc0002000, 0x20000001, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	chr(0x00000600, 0x06, 0x0090, BODY_PRES_SECURITY, HEAD_RANDOM, AILIST_INIT_NEUTRAL, 0x0090, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	chr(0x00000600, 0x07, 0x0091, BODY_PRES_SECURITY, HEAD_RANDOM, 0x0426, 0x0091, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	chr(0x00000600, 0x08, 0x0092, BODY_PRES_SECURITY, HEAD_RANDOM, AILIST_INIT_NEUTRAL, 0x0092, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	chr(0x00000600, 0x09, 0x0093, BODY_PRES_SECURITY, HEAD_RANDOM, GAILIST_IDLE, 0x0093, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	chr(0x00000600, 0x0a, 0x0094, BODY_PRES_SECURITY, HEAD_RANDOM, GAILIST_IDLE, 0x0094, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	chr(0x00000600, 0x0b, 0x0095, BODY_PRES_SECURITY, HEAD_RANDOM, AILIST_INIT_NEUTRAL, 0x0002, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	chr(0x00000600, 0x0c, 0x0096, BODY_PRES_SECURITY, HEAD_RANDOM, GAILIST_IDLE, 0x0002, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	chr(0x00000600, 0x0d, 0x0097, BODY_PRES_SECURITY, HEAD_RANDOM, GAILIST_IDLE, 0x0097, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	chr(0x00000400, 0x0e, 0x0098, BODY_PRES_SECURITY, HEAD_RANDOM, AILIST_INIT_NEUTRAL, 0x0003, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	chr(0x00000400, 0x0f, 0x0099, BODY_PRES_SECURITY, HEAD_RANDOM, 0x0427, 0x0002, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	chr(0x00000600, 0x10, 0x009a, BODY_PRES_SECURITY, HEAD_RANDOM, AILIST_INIT_NEUTRAL, 0x009a, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	chr(0x00000600, 0x11, 0x009b, BODY_PRES_SECURITY, HEAD_RANDOM, AILIST_INIT_NEUTRAL, 0x0004, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	chr(0x00010400, 0x18, 0x00a0, BODY_PRESIDENT, HEAD_PRESIDENT, GAILIST_IDLE, 0x00a0, -1, 1000, 100, 0x80082000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	chr(0x00000600, 0x12, 0x009c, BODY_PRES_SECURITY, HEAD_RANDOM, 0x0428, 0x0003, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	chr(0x00000600, 0x13, 0x009d, BODY_PRES_SECURITY, HEAD_RANDOM, AILIST_INIT_NEUTRAL, 0x0002, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	chr(0x00000600, 0x14, 0x009e, BODY_PRES_SECURITY, HEAD_RANDOM, AILIST_INIT_NEUTRAL, 0x0020, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	chr(0x00000600, 0x15, 0x009f, BODY_PRES_SECURITY, HEAD_RANDOM, AILIST_INIT_NEUTRAL, 0x00bb, -1, 1000, 100, 0xc0002000, 0x20001000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	chr(0x00004400, 0x16, 0x00ca, BODY_PRES_SECURITY, HEAD_RANDOM, AILIST_TYPING_GUY, 0x00b2, -1, 1000, 100, 0x40002000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, 0x11, 0, 0x00000000)
	chr(0x00004400, 0x17, 0x00c9, BODY_PRES_SECURITY, HEAD_RANDOM, AILIST_SITTING_GUY, 0x001f, -1, 1000, 100, 0x40002000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, 0x10, 0, 0x00000000)
	chr(0x00014401, 0x19, 0x00c7, BODY_PILOTAF1, HEAD_ROSS, AILIST_TYPING_GUY, -1, -1, 1000, 100, 0x40002000, 0x00000000, TEAM_ENEMY, SQUADRON_0B, 0x12, 0, 0x00000000)
	chr(0x00014401, 0x1a, 0x00c8, BODY_PILOTAF1, HEAD_WONG, AILIST_SITTING_GUY, -1, -1, 1000, 100, 0x40002000, 0x00000000, TEAM_ENEMY, SQUADRON_0B, 0x13, 0, 0x00000000)
	chr(0x00000000, 0x1d, 0x00a5, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x80092000, 0x00101a00, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x001d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x1e, 0x00a6, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x80092000, 0x00101a00, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x001e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x1f, 0x00a7, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x80092000, 0x00101a00, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x001f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x20, 0x00a8, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x80092000, 0x00101a00, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0020, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x21, 0x00a9, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x80092000, 0x00101a00, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0021, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x22, 0x00aa, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x80092000, 0x00101a00, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0022, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x24, 0x00ac, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x80092000, 0x00101a00, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0024, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x25, 0x00ad, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x80092000, 0x00101a00, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0025, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x26, 0x0006, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x80092000, 0x00101a00, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0026, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x27, 0x0089, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x80092000, 0x00101a00, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0027, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x28, 0x000d, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x80092000, 0x00101a00, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0028, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x29, 0x00ae, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc0018201, 0x00101a00, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0029, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000100, 0x2a, 0x00af, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc0092000, 0x00101a00, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x002a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000100, 0x2b, 0x00b0, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc0092000, 0x00101a00, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x002b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x30, 0x006a, BODY_STRIPES, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 200, 100, 0x40018201, 0x00101a00, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0030, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x31, 0x0069, BODY_TRENT, HEAD_TRENT, GAILIST_IDLE, -1, -1, 200, 100, 0x40018201, 0x00101a00, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	chr(0x00000000, 0x00, 0x008a, BODY_THEKING, HEAD_ELVIS, AILIST_INIT_ELVIS, -1, -1, 200, 100, 0x40018201, 0x00101a00, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	chr(0x00000000, 0x35, 0x0088, BODY_STRIPES, HEAD_RANDOM, AILIST_CLONER1, -1, -1, 200, 100, 0x80092000, 0x00381000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	chr(0x00000000, 0x36, 0x00b5, BODY_STRIPES, HEAD_RANDOM, AILIST_CLONER2, -1, -1, 200, 100, 0x80092000, 0x00381000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	chr(0x00000000, 0x37, 0x00b6, BODY_STRIPES, HEAD_RANDOM, AILIST_CLONER3, -1, -1, 200, 100, 0x80092000, 0x00381000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	tag(0x1b, 1)
	lift(0x0100, MODEL_A51_LIFT_THINWALL, 0x010b, 0x835204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x010b, 0x010a, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x15000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x1f, 1)
	lift(0x0100, MODEL_A51_LIFT_THINWALL, 0x0110, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0110, 0x0111, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x15000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00d2, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00d3, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00d4, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00d5, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00d6, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00d7, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00d8, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00d9, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00da, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00db, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00dc, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AF1_DOORBIG2, 0x00dd, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AF1_DOORBIG2, 0x00de, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00df, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00e0, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00e1, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00e2, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AF1_DOORBIG2, 0x0100, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000004, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AF1_DOORBIG2, 0x0101, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000004, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AF1_DOORBIG2, 0x0102, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000020, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AF1_DOORBIG2, 0x0103, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000020, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	key(0x0080, MODEL_KEYCARD, 0x000e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000004)
	rename_object(-1, 0x49, L_RIT(55), L_RIT(56), L_RIT(57), L_RIT(58), L_RIT(59), 0x0000, 0x0000) // ""
	key(0x0080, MODEL_KEYCARD, 0x000f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000020)
	rename_object(-1, 0x49, L_RIT(55), L_RIT(56), L_RIT(57), L_RIT(58), L_RIT(59), 0x0000, 0x0000) // ""
	tag(0x22, 1)
	key(0x0080, MODEL_KEYCARD, 0x0001, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	rename_object(-1, 0x49, L_RIT(55), L_RIT(56), L_RIT(57), L_RIT(58), L_RIT(59), 0x0000, 0x0000) // ""
	door(0x0100, MODEL_DD_DR_NONREF, 0x00f5, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00f6, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00f7, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00f8, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00f9, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00fa, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00fb, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00fc, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00fd, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0c, 1)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00e3, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00e4, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0e, 1)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00e5, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000040, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00e6, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00e7, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00e8, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00e9, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x15, 1)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00ea, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00eb, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00ec, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00ed, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00ee, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00ef, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00fe, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x25, 1)
	door(0x0100, MODEL_AF1ESCAPEDOOR, 0x0105, 0x12000410, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x26, 1)
	door(0x0100, MODEL_AF1ESCAPEDOOR, 0x0106, 0x12000410, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x20, 1)
	door(0x0100, MODEL_DD_GRATE, 0x00f1, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x0000ffff, 0x00014000, 0x00000ccc, 0x00040000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0b, 1)
	door(0x0100, MODEL_DD_GRATE, 0x00f2, 0x00000400, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x08040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x2e, 1)
	stdobject(0x0100, MODEL_DD_GRATE, 0x0108, 0x000200e1, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	door(0x0100, MODEL_DD_GRATE, 0x0109, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x011b, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00a6, MODEL_A51_CRATE2, 0x011c, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x011e, 0x000201e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x01, 1)
	weapon(0x0180, MODEL_CHRDATATHIEF, 0x003f, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_LAPTOPGUN, 0x00ffffff, 0x00000000)
	tag(0x16, 1)
	weapon(0x0180, MODEL_CHRDATATHIEF, 0xffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_LAPTOPGUN, 0x00ffffff, 0x00000000)
	tag(0x04, 1)
	weapon(0x0180, MODEL_CHRREMOTEMINE, 0x003f, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_TIMEDMINE, 0x00ffffff, 0x00000000)
	tag(0x17, 1)
	weapon(0x0180, MODEL_CHRREMOTEMINE, 0xffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_TIMEDMINE, 0x00ffffff, 0x00000000)
	tag(0x02, 1)
	multimonitor(0x0099, MODEL_COMHUB, 0x0116, 0x0202000a, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(0x27, 1)
	multimonitor(0x0099, MODEL_COMHUB, 0x0117, 0x0202000a, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(0x28, 1)
	multimonitor(0x0099, MODEL_COMHUB, 0x0118, 0x0202000a, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(0x29, 1)
	multimonitor(0x0099, MODEL_COMHUB, 0x0119, 0x0202000a, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(0x2a, 1)
	multimonitor(0x0099, MODEL_COMHUB, 0x011a, 0x0202000a, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(0x03, 1)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x0112, 0x100000e2, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x0f, 3)
	tag(0x05, 1)
	lift(0x0100, MODEL_A51_LIFT_THINWALL, 0x010c, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x010c, 0x010d, 0xffffffff, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x1b000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_DR_NONREF, 0x00ff, 0x12000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-1, -2, 0, 0)
	tag(0x2b, 1)
#if VERSION >= VERSION_PAL_FINAL
	// ................................................................................................................................................................................................................................................................................................................................................................ v
	door(0x0100, MODEL_DD_DR_NONREF, 0x00f4, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x08040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
#else
	door(0x0100, MODEL_DD_DR_NONREF, 0x00f4, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
#endif
	door(0x0100, MODEL_DD_DR_NONREF, 0x00f3, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x06, 1)
	lift(0x0100, MODEL_A51_LIFT_THINWALL, 0x010f, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x010f, 0x010e, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x1b000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x07, 1)
	multimonitor(0x0099, MODEL_COMHUB, 0x0113, 0x00000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(0x08, 1)
	multimonitor(0x0099, MODEL_COMHUB, 0x0114, 0x00000002, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(0x12, 1)
	stdobject(0x0100, MODEL_AF1_PILOTCHAIR, 0x013a, 0x000205e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PILOTCHAIR, 0x013b, 0x000205e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x13, 1)
	stdobject(0x0100, MODEL_AF1_PILOTCHAIR, 0x013c, 0x000205e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x10, 1)
	stdobject(0x0100, MODEL_AF1_PILOTCHAIR, 0x013d, 0x000205e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x11, 1)
	stdobject(0x0100, MODEL_AF1_PILOTCHAIR, 0x013e, 0x000205e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x011f, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0120, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0121, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0122, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0123, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0124, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0125, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0126, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0127, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0128, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0129, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x012a, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x012b, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x012d, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x012e, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x012f, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0130, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0131, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0132, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0133, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0134, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0135, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0136, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0137, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0138, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x0139, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x016a, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x0160, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x0161, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x0162, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x0163, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x0164, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x0165, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x0166, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x013f, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x0140, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x0141, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x0142, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x0143, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x0144, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x0145, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x0146, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x0147, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x0148, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x0149, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x014a, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x014b, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x014c, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x014d, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x014e, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x014f, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x0150, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x0151, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x0152, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TABLE, 0x0169, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TOILET, 0x0153, 0x000205e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_TOILET, 0x0154, 0x000205e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_LAMP, 0x0156, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_LAMP, 0x0157, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_LAMP, 0x0158, 0x000005e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_LAMP, 0x0159, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_LAMP, 0x015a, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_LAMP, 0x015b, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_AF1_PASSCHAIR, 0x015e, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x19, 1)
	stdobject(0x0100, MODEL_SK_SHUTTLE, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x37, 1)
	stdobject(0x0100, MODEL_AIRFORCE1, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x1a, 1)
	stdobject(0x0100, MODEL_ELVIS_SAUCER, 0xffff, 0x00001401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x23, 1)
	stdobject(0x0019, MODEL_SAUCERINSIDE, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_HOVBIKE, 0x00c0, 0x05120101, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	door(0x0100, MODEL_DOOR2A_G5, 0x0104, 0x10000400, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x1c, 1)
	door(0x0100, MODEL_DD_GRATE, 0x00f0, 0x00000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00040000, 0x00000010, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x1e, 1)
	singlemonitor(0x0100, MODEL_GOODSTATION, 0x0168, 0x000004e1, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x21, 1)
	singlemonitor(0x0100, MODEL_GOODSTATION, 0x0167, 0x000004e1, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x00, 1)
	weapon(0x0180, MODEL_CHRBRIEFCASE, 0x00b3, 0x00000101, 0x00000000, 0x00400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUITCASE, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x4d, L_RIT(10), L_RIT(11), L_RIT(12), L_RIT(13), L_RIT(14), 0x0000, 0x0000) // "Obtain Suitcase."
	tag(0x3a, 1)
	weapon(0x0180, MODEL_CHRBRIEFCASE, 0xffff, 0x00000101, 0x00000000, 0x00400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUITCASE, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x4d, L_RIT(10), L_RIT(11), L_RIT(12), L_RIT(13), L_RIT(14), 0x0000, 0x0000) // "Obtain Suitcase."
	tag(0x24, 1)
	stdobject(0x0100, MODEL_PRESCAPSULE, 0x0171, 0x000001e1, 0x00004101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00007d00, 0x00000000, 0x00000000, 0x0fff0000)
	glass(0x0100, MODEL_WINDOW, 0x016d, 0x04000262, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x016e, 0x04000262, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x016f, 0x04000262, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x0170, 0x04000262, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x2f, 5)
	tag(0x30, 6)
	tag(0x31, 7)
	tag(0x32, 8)
	link_scenery(1, 0, 0)
	debris(0x0019, MODEL_AF1RUBBLE, 0x00ce, 0x03520401, 0x00186300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 0)
	debris(0x0019, MODEL_AF1RUBBLE, 0x00cf, 0x03520401, 0x00186300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 0)
	debris(0x0019, MODEL_AF1RUBBLE, 0x00d0, 0x03520401, 0x00186300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x0fff0000)
	link_scenery(1, 0, 0)
	debris(0x0019, MODEL_AF1RUBBLE, 0x00d1, 0x03520401, 0x00186300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x33, 4)
	tag(0x34, 4)
	tag(0x35, 4)
	tag(0x36, 4)
	weapon(0x0100, MODEL_CHRREMOTEMINE, 0x00ce, 0x01320401, 0x000a6000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REMOTEMINE, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRREMOTEMINE, 0x00cf, 0x01320401, 0x000a6000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REMOTEMINE, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRREMOTEMINE, 0x00d0, 0x01320401, 0x000a6000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REMOTEMINE, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRREMOTEMINE, 0x00d1, 0x01320401, 0x000a6000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REMOTEMINE, 0x00ffffff, 0x00000000)
	tag(0x2c, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x016c, 0x00420101, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x2d, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x016b, 0x00420101, 0x000000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x38, 2)
	tag(0x39, 2)
	weapon(0x0180, MODEL_CHRCYCLONE, 0x00cb, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CYCLONE, 0x00ffffff, 0x00000000)
	weapon(0x0180, MODEL_CHRCYCLONE, 0x00cc, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CYCLONE, 0x00ffffff, 0x00000000)
	link_collectibles(-1, -2)
	endprops
};

s32 intro[] = {
	outfit(OUTFIT_STEWARDESS)
	ammo(AMMOTYPE_CROSSBOW, 10)
	ammo(AMMOTYPE_SMG, 100)
	intro_weapon(WEAPON_UNARMED, -1)
	intro_weapon(WEAPON_COMBATBOOST, -1)
	ammo(AMMOTYPE_BOOST, 2)
	spawn(0x008a)
	endintro
};

s32 path00[] = {
	0x0034,
	0x0033,
	0x0031,
	0x0030,
	0x0031,
	0x0033,
	0x0034,
	-1,
};

s32 path01[] = {
	0x000d,
	0x000e,
	0x000b,
	0x0012,
	0x0007,
	0x0006,
	0x0010,
	0x000c,
	-1,
};

s32 path02[] = {
	0x003e,
	0x0044,
	0x0042,
	0x0040,
	0x003f,
	0x003d,
	0x003e,
	0x004d,
	-1,
};

u8 func1001_objectives_failed_msg[] = {
	yield
	set_chr_chrflag(CHR_PRESIDENT, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_STEWARDESS, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_STEWARD, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_PILOT1, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_PILOT2, CHRCFLAG_04000000)
	set_chr_chrflag(0x01, CHRCFLAG_04000000)
	set_chr_chrflag(0x02, CHRCFLAG_04000000)
	set_chr_chrflag(0x03, CHRCFLAG_04000000)
	set_chr_chrflag(0x04, CHRCFLAG_04000000)
	set_chr_chrflag(0x05, CHRCFLAG_04000000)
	set_chr_chrflag(0x06, CHRCFLAG_04000000)
	set_chr_chrflag(0x07, CHRCFLAG_04000000)
	set_chr_chrflag(0x08, CHRCFLAG_04000000)
	set_chr_chrflag(0x09, CHRCFLAG_04000000)
	set_chr_chrflag(0x0a, CHRCFLAG_04000000)
	set_chr_chrflag(0x0b, CHRCFLAG_04000000)
	set_chr_chrflag(0x0c, CHRCFLAG_04000000)
	set_chr_chrflag(0x0d, CHRCFLAG_04000000)
	set_chr_chrflag(0x0e, CHRCFLAG_04000000)
	set_chr_chrflag(0x0f, CHRCFLAG_04000000)
	set_chr_chrflag(0x10, CHRCFLAG_04000000)
	set_chr_chrflag(0x11, CHRCFLAG_04000000)
	set_chr_chrflag(0x12, CHRCFLAG_04000000)
	set_chr_chrflag(0x13, CHRCFLAG_04000000)
	set_chr_chrflag(0x14, CHRCFLAG_04000000)
	set_chr_chrflag(0x15, CHRCFLAG_04000000)
	set_chr_chrflag(0x16, CHRCFLAG_04000000)
	set_chr_chrflag(0x17, CHRCFLAG_04000000)
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

u8 func1400_setup_counterop[] = {
	yield
	yield
	yield
	set_chr_team(CHR_ANTI, TEAM_04)
	chr_draw_weapon(CHR_BOND, WEAPON_UNARMED)
	chr_draw_weapon(CHR_COOP, WEAPON_UNARMED)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func1003_rebuild_groups[] = {
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func1024_give_objects[] = {
	if_difficulty_gt(DIFF_A, /*goto*/ 0x2d)
	give_object_to_chr(OBJ_EQUIPMENT, CHR_BOND)
	give_object_to_chr(OBJ_EQUIPMENT_COOP, CHR_COOP)

	label(0x2d)
	set_object_flag2(OBJ_DATAUPLINK_BOND, OBJFLAG2_INVISIBLE)
	set_object_flag(OBJ_DATAUPLINK_BOND, OBJFLAG_UNCOLLECTABLE)
	set_object_flag2(OBJ_REMOTEMINE_BOND, OBJFLAG2_INVISIBLE)
	set_object_flag(OBJ_REMOTEMINE_BOND, OBJFLAG_UNCOLLECTABLE)
	set_object_flag2(OBJ_DATAUPLINK_COOP, OBJFLAG2_INVISIBLE)
	set_object_flag(OBJ_DATAUPLINK_COOP, OBJFLAG_UNCOLLECTABLE)
	set_object_flag2(OBJ_REMOTEMINE_COOP, OBJFLAG2_INVISIBLE)
	set_object_flag(OBJ_REMOTEMINE_COOP, OBJFLAG_UNCOLLECTABLE)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_has_object(CHR_P1P2, OBJ_EQUIPMENT, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	give_object_to_chr(OBJ_DATAUPLINK_BOND, CHR_BOND)
	give_object_to_chr(OBJ_REMOTEMINE_BOND, CHR_BOND)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)
	give_object_to_chr(OBJ_DATAUPLINK_COOP, CHR_COOP)
	give_object_to_chr(OBJ_REMOTEMINE_COOP, CHR_COOP)
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1004_reassign_ailists_during_conversation[] = {
	// Wait until player in president's room
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0055, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0056, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0057, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	dprint 'b','4',' ','s','h','i','e','l','d',' ','c','h','e','c','k','\n',0,
	set_stage_flag(STAGEFLAG_00100000)
	set_chr_target_chr(CHR_PRESIDENT, CHR_P1P2)
	set_ailist(0x01, AILIST_BE_UNALERT)
	set_ailist(CHR_STEWARDESS, AILIST_BE_UNALERT)
	set_ailist(CHR_STEWARD, AILIST_BE_UNALERT)
	set_ailist(0x04, AILIST_BE_UNALERT)
	set_ailist(0x05, AILIST_BE_UNALERT)
	set_ailist(0x06, AILIST_BE_UNALERT)
	set_ailist(0x07, AILIST_BE_UNALERT)
	set_ailist(0x08, AILIST_BE_UNALERT)
	set_ailist(0x09, AILIST_BE_UNALERT)
	set_ailist(0x0a, AILIST_BE_UNALERT)
	set_ailist(0x0b, AILIST_BE_UNALERT)
	set_ailist(0x0c, AILIST_BE_UNALERT)
	set_ailist(0x0d, AILIST_BE_UNALERT)
	set_ailist(0x0e, AILIST_BE_UNALERT)
	set_ailist(0x0f, AILIST_BE_UNALERT)
	set_ailist(0x10, AILIST_BE_UNALERT)
	set_ailist(0x11, AILIST_BE_UNALERT)
	set_ailist(0x12, AILIST_BE_UNALERT)
	set_ailist(0x13, AILIST_BE_UNALERT)
	set_ailist(0x14, AILIST_BE_UNALERT)
	set_ailist(0x15, AILIST_BE_UNALERT)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1005_check_neutrals_killed[] = {
	set_chr_chrflag(0x01, CHRCFLAG_KILLCOUNTABLE)
#if VERSION >= VERSION_JAP_FINAL
	set_chr_chrflag(CHR_STEWARDESS, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(CHR_STEWARD, CHRCFLAG_KILLCOUNTABLE)
#endif
	set_chr_chrflag(0x04, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x05, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x06, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x07, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x08, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x09, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x0a, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x0b, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x0c, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x0d, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x0e, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x0f, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x10, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x11, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x12, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x13, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x14, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x15, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x16, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x17, CHRCFLAG_KILLCOUNTABLE)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_PRESIDENT_STARTED_RUNNING, TRUE, /*goto*/ 0x06)
		if_kill_count_gt(0, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	show_hudmsg(CHR_BOND, L_RIT(20)) // "Too many neutral casualties inflicted."
	set_stage_flag(STAGEFLAG_KILLED_NEUTRALS)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0401_init_stripes[] = {
	set_chr_chrflag(CHR_SELF, CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0402_init_elvis[] = {
	set_chr_chrflag(CHR_SELF, CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1006_hijack[] = {
	yield
	hide_chr(0x1d)
	hide_chr(0x1e)
	hide_chr(0x1f)
	hide_chr(0x20)
	hide_chr(0x21)
	hide_chr(0x22)
	hide_chr(0x23)
	hide_chr(0x24)
	hide_chr(0x25)
	hide_chr(0x26)
	hide_chr(0x27)
	hide_chr(0x28)
	hide_chr(0x29)
	hide_chr(CHR_TAKER1)
	hide_chr(CHR_TAKER2)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_PRESIDENT_STARTED_RUNNING, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	play_music_continuously(MUSIC_AIRFORCEONE_X)
	set_chr_maxdamage(0x01, 10)
	set_chr_maxdamage(0x04, 10)
	set_chr_maxdamage(0x05, 10)
	set_chr_maxdamage(0x06, 10)
	set_chr_maxdamage(0x07, 10)
	set_chr_maxdamage(0x08, 10)
	set_chr_maxdamage(0x09, 10)
	set_chr_maxdamage(0x0a, 10)
	set_chr_maxdamage(0x0b, 10)
	set_chr_maxdamage(0x0c, 10)
	set_chr_maxdamage(0x0d, 10)
	set_chr_maxdamage(0x0e, 10)
	set_chr_maxdamage(0x0f, 10)
	set_chr_maxdamage(0x10, 10)
	set_chr_maxdamage(0x16, 10)
	set_chr_maxdamage(0x17, 10)
	set_chr_maxdamage(CHR_PILOT1, 10)
	set_chr_maxdamage(CHR_PILOT2, 10)
	set_ailist(0x01, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(CHR_STEWARDESS, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(CHR_STEWARD, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(0x04, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(0x05, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(0x06, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(0x07, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(0x08, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(0x09, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(0x0a, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(0x0b, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(0x0c, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(0x0d, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(0x10, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(0x12, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(0x13, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(0x15, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(0x16, AILIST_REMOVE_IF_OFFSCREEN)
	yield
	set_ailist(0x17, AILIST_REMOVE_IF_OFFSCREEN)
	set_ailist(0x0e, AILIST_INIT_DEFEND_PAD)
	set_ailist(0x0f, AILIST_INIT_DEFEND_PAD)
	set_ailist(0x11, AILIST_INIT_DEFEND_PAD)
	set_ailist(0x14, AILIST_INIT_DEFEND_PAD)
	yield

	#define enable_stripes_chr(chr, function) \
		show_chr(chr) \
		set_ailist(chr, function) \
		unset_chr_chrflag(chr, CHRCFLAG_HIDDEN) \
		set_chr_hiddenflag(chr, CHRHFLAG_00400000) \
		yield



	enable_stripes_chr(0x1d, AILIST_REINIT_STRIPES)
	enable_stripes_chr(0x1e, AILIST_REINIT_STRIPES)
	enable_stripes_chr(0x1f, AILIST_REINIT_STRIPES)
	enable_stripes_chr(0x20, AILIST_REINIT_STRIPES)
	enable_stripes_chr(0x21, AILIST_REINIT_STRIPES)
	enable_stripes_chr(0x22, AILIST_REINIT_STRIPES)
	enable_stripes_chr(0x23, AILIST_REINIT_STRIPES)
	enable_stripes_chr(0x24, AILIST_REINIT_STRIPES)
	enable_stripes_chr(0x25, AILIST_REINIT_STRIPES)
	enable_stripes_chr(0x26, AILIST_REINIT_STRIPES)
	enable_stripes_chr(0x27, AILIST_REINIT_STRIPES)
	enable_stripes_chr(0x28, AILIST_REINIT_STRIPES)
	enable_stripes_chr(0x29, AILIST_COCKPIT_STRIPES)
	enable_stripes_chr(CHR_TAKER1, AILIST_TAKER2)
	enable_stripes_chr(CHR_TAKER2, AILIST_TAKER1)

	set_chr_flag_bankx(0x01, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(CHR_STEWARDESS, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(CHR_STEWARD, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x04, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x05, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x06, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x07, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x08, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x09, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x0a, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x0b, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x0c, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x0d, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x0e, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x0f, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x10, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x11, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x12, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x13, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x14, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_flag_bankx(0x15, CHRFLAG0_AIVSAI, BANK_0)
	set_chr_team(CHR_TRENT, TEAM_04)
	set_chr_team(CHR_BLONDE1, TEAM_04)
	set_chr_team(CHR_BLONDE2, TEAM_04)
	unset_chr_hiddenflag(CHR_TRENT, CHRHFLAG_40000000)
	unset_chr_hiddenflag(CHR_BLONDE1, CHRHFLAG_40000000)
	unset_chr_hiddenflag(CHR_BLONDE2, CHRHFLAG_40000000)
	unlock_door(OBJ_COCKPITDOOR, 0x40)
	rebuild_teams
	rebuild_squadrons
	unset_chr_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISED)
	unset_chr_hiddenflag(CHR_COOP, CHRHFLAG_DISGUISED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0403_stripes[] = {
	set_returnlist(CHR_SELF, AILIST_STRIPES)
	set_self_chrflag(CHRCFLAG_00000040)

	beginloop(0x04)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x06)

		// No target nearby
		yield
		unset_self_flag_bankx(CHRFLAG1_00001000, BANK_1)
		stop_chr
		set_ailist(CHR_SELF, GAILIST_UNALERTED)

		// Got target
		label(0x06)
		if_target_is_player(/*goto*/ 0x06)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x2d)
		set_returnlist(CHR_SELF, AILIST_STRIPES)
		set_shotlist(AILIST_STRIPES)
		set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)

		label(0x06)
		unset_self_flag_bankx(CHRFLAG1_00001000, BANK_1)
		set_ailist(CHR_SELF, GAILIST_UNALERTED)
		set_returnlist(CHR_SELF, GAILIST_UNALERTED)

		label(0x2d)
		set_target_chr(-1)
		stop_chr
	endloop(0x04)

	endlist
};

u8 unregistered_function1[] = {
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define check_mine_wasted(chr1, chr2, myflag, buddyflag) \
	set_object_flag(OBJ_COMMSHUB1, OBJFLAG_00002000) \
	set_object_flag(OBJ_COMMSHUB2, OBJFLAG_00002000) \
	set_object_flag(OBJ_COMMSHUB3, OBJFLAG_00002000) \
	set_object_flag(OBJ_COMMSHUB4, OBJFLAG_00002000) \
	set_object_flag(OBJ_COMMSHUB5, OBJFLAG_00002000) \
	yield \
	yield \
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x06) \
 \
	/* Wait until equipment collected */ \
	beginloop(0x93) \
		if_objective_complete(0, /*goto*/ 0x06) \
	endloop(0x93) \
 \
	label(0x06) \
	yield \
	yield \
	yield \
	yield \
	yield \
	label(0x08) \
	set_target_chr(chr1) \
 \
	/* Wait until mine thrown */ \
	beginloop(0x09) \
		if_ammo_quantity_lt(chr2, AMMOTYPE_TIMED_MINE, 1, /*goto*/ 0x2d) \
	endloop(0x09) \
 \
	label(0x2d) \
	if_stage_flag_eq(STAGEFLAG_MIDCUTSCENE_FINISHED, FALSE, /*goto*/ 0x0a) \
	label(0x2d) \
	unset_object_flag(OBJ_COMMSHUB1, OBJFLAG_INVINCIBLE) \
	unset_object_flag(OBJ_COMMSHUB2, OBJFLAG_INVINCIBLE) \
	unset_object_flag(OBJ_COMMSHUB3, OBJFLAG_INVINCIBLE) \
	unset_object_flag(OBJ_COMMSHUB4, OBJFLAG_INVINCIBLE) \
	unset_object_flag(OBJ_COMMSHUB5, OBJFLAG_INVINCIBLE) \
	restart_timer \
 \
	/* Wait 8.3 seconds or until commshub destroyed */ \
	beginloop(0x04) \
		if_timer_gt(500, /*goto*/ 0x0a) \
		if_object_in_good_condition(OBJ_COMMSHUB1, /*goto*/ 0x2d) \
		goto_next(0x06) \
 \
		label(0x2d) \
		if_object_in_good_condition(OBJ_COMMSHUB2, /*goto*/ 0x2d) \
		goto_next(0x06) \
 \
		label(0x2d) \
		if_object_in_good_condition(OBJ_COMMSHUB3, /*goto*/ 0x2d) \
		goto_next(0x06) \
 \
		label(0x2d) \
		if_object_in_good_condition(OBJ_COMMSHUB4, /*goto*/ 0x2d) \
		goto_next(0x06) \
 \
		label(0x2d) \
		if_object_in_good_condition(OBJ_COMMSHUB5, /*goto*/ 0x2d) \
		goto_next(0x06) \
 \
		label(0x2d) \
	endloop(0x04) \
 \
	/* Commshub damaged */ \
	label(0x06) \
	show_hudmsg(CHR_BOND, 0x3615) /* "UFO attachment damaged." */ \
	set_stage_flag(STAGEFLAG_UFO_ATTACHMENT_DAMAGED) \
	unset_stage_flag(STAGEFLAG_BOTH_MINES_WASTED) \
	set_ailist(CHR_SELF, GAILIST_IDLE) \
 \
	/* Mine wasted */ \
	label(0x0a) \
	set_stage_flag(myflag) \
	if_stage_flag_eq(buddyflag, TRUE, /*goto*/ 0x2d) \
	set_ailist(CHR_SELF, GAILIST_IDLE) \
 \
	label(0x2d) \
	show_hudmsg(CHR_BOND, 0x3645) /* "Timed mine has been wasted." */ \
	set_stage_flag(STAGEFLAG_BOTH_MINES_WASTED) \
	set_ailist(CHR_SELF, GAILIST_IDLE)



u8 func1008_check_mine_wasted_bond[] = {
	check_mine_wasted(CHR_BOND, CHR_TARGET, STAGEFLAG_BOND_MINE_WASTED, STAGEFLAG_COOP_MINE_WASTED)
	endlist
};

u8 func1021_check_mine_wasted_coop[] = {
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)
	goto_next(0x06)
	label(0x2d)
	set_stage_flag(STAGEFLAG_COOP_MINE_WASTED)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	check_mine_wasted(CHR_COOP, CHR_COOP, STAGEFLAG_COOP_MINE_WASTED, STAGEFLAG_BOND_MINE_WASTED)
	endlist
};

u8 func101e_blow_mines[] = {
	// Wait for any commshub destroyed
	beginloop(0x04)
		if_object_in_good_condition(OBJ_COMMSHUB1, /*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
		if_object_in_good_condition(OBJ_COMMSHUB2, /*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
		if_object_in_good_condition(OBJ_COMMSHUB3, /*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
		if_object_in_good_condition(OBJ_COMMSHUB4, /*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
		if_object_in_good_condition(OBJ_COMMSHUB5, /*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
	endloop(0x04)

	label(0x06)

	// 1
	unset_object_flag(0x2f, OBJFLAG_INVINCIBLE)
	unset_object_flag2(0x33, OBJFLAG2_INVISIBLE)
	unset_object_flag(0x33, OBJFLAG_INVINCIBLE)
	destroy_object(0x33)
	restart_timer

	beginloop(0x60)
		if_timer_gt(60, /*goto*/ 0x2d)
	endloop(0x60)

	label(0x2d)
	unset_object_flag2(0x2f, OBJFLAG2_INVISIBLE)
	destroy_object(0x2f)

	// 2
	unset_object_flag(0x30, OBJFLAG_INVINCIBLE)
	unset_object_flag2(0x34, OBJFLAG2_INVISIBLE)
	unset_object_flag(0x34, OBJFLAG_INVINCIBLE)
	destroy_object(0x34)
	restart_timer

	beginloop(0x77)
		if_timer_gt(60, /*goto*/ 0x2d)
	endloop(0x77)

	label(0x2d)
	unset_object_flag2(0x30, OBJFLAG2_INVISIBLE)
	destroy_object(0x30)

	// 3
	unset_object_flag(0x31, OBJFLAG_INVINCIBLE)
	unset_object_flag2(0x35, OBJFLAG2_INVISIBLE)
	unset_object_flag(0x35, OBJFLAG_INVINCIBLE)
	destroy_object(0x35)
	restart_timer

	beginloop(0x78)
		if_timer_gt(60, /*goto*/ 0x2d)
	endloop(0x78)

	label(0x2d)
	unset_object_flag2(0x31, OBJFLAG2_INVISIBLE)
	destroy_object(0x31)

	// 4
	unset_object_flag(0x32, OBJFLAG_INVINCIBLE)
	unset_object_flag2(0x36, OBJFLAG2_INVISIBLE)
	unset_object_flag(0x36, OBJFLAG_INVINCIBLE)
	destroy_object(0x36)
	restart_timer

	beginloop(0x79)
		if_timer_gt(60, /*goto*/ 0x2d)
	endloop(0x79)

	label(0x2d)
	unset_object_flag2(0x32, OBJFLAG2_INVISIBLE)
	destroy_object(0x32)

	yield
	hide_object(0x2f)
	hide_object(0x30)
	hide_object(0x31)
	hide_object(0x32)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1009_check_end_level[] = {
	beginloop(0x04)
		if_all_objectives_complete(/*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_stage_flag(STAGEFLAG_ALL_OBJECTIVES_COMPLETE)
	restart_timer
	label(0x08)
	yield
	label(0x06)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2d)
	if_chr_dying(CHR_BOND, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x2d)
	goto_next(0x06)

	label(0x2d)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)
	if_chr_dying(CHR_COOP, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x2d)
	goto_next(0x06)

	// Both players dead
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Redundant check
	label(0x06)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2d)
	if_chr_dying(CHR_BOND, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x2d)
	goto_next(0x06)

	label(0x2d)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)
	if_chr_dying(CHR_COOP, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x2d)
	goto_next(0x06)

	label(0x2d)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Mission complete
	label(0x06)
	set_invincible(CHR_BOND)
	set_ailist(CHR_SELF, AILIST_OUTRO)
	endlist
};

u8 func100a_autopilot_switch[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_object_in_good_condition(OBJ_AUTOPILOT_SWITCH, /*goto*/ 0x2d)
		goto_next(0x08)

		label(0x2d)
		if_chr_activated_object(CHR_P1P2, OBJ_AUTOPILOT_SWITCH, /*goto*/ 0x2d)
		if_stage_flag_eq(STAGEFLAG_PLANE_STABILIZED, TRUE, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		label(0x06)
		if_stage_flag_eq(STAGEFLAG_PLANE_NOSEDIVING, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	// Switch pressed
	label(0x06)
	assign_sound(0x043a, CHANNEL_7)
	control_sound_from_object(CHANNEL_7, OBJ_AUTOPILOT_SWITCH, TRUE)
	set_object_image(OBJ_AUTOPILOT_SWITCH, 0x00, 0x13)
	set_stage_flag(STAGEFLAG_PLANE_STABILIZED)
	yield
	show_hudmsg(CHR_P1P2, L_RIT(24)) // "Air Force One has been stabilized."
	show_hudmsg(CHR_P1P2, L_RIT(23)) // "Autopilot has been activated."
	restart_timer

	beginloop(0x0e)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x0e)

	label(0x06)
	misc_command(0x0000, 0x0d, 0x00)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Switch destroyed
	label(0x08)
	show_hudmsg(CHR_P1P2, L_RIT(25)) // "Autopilot systems have been destroyed."
	set_stage_flag(STAGEFLAG_AUTOPILOT_DESTROYED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0406_init_president[] = {
	set_chr_maxdamage(CHR_SELF, 0)
	set_ailist(CHR_SELF, AILIST_PRESIDENT_IN_ROOM)
	endlist
};

u8 func0405_president_in_room[] = {
	set_shotlist(AILIST_PRESIDENT_IN_ROOM)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2d)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2d)
	goto_next(0x06)

	// Dying
	label(0x2d)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x06)
	stop_chr
	yield

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_00100000, TRUE, /*goto*/ 0x03)
		if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2d)
		if_chr_dying(CHR_SELF, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_SELF, /*goto*/ 0x2d)
	endloop(0x04)

	// Dying
	label(0x2d)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x03)
	set_target_chr(CHR_PRESET)
	restart_timer
	label(0x08)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		// Wait for Carrington's "on this level" message to finish
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2d)
		reloop(0x09)

		label(0x2d)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	do_preset_animation(0)
	speak(CHR_TARGET, L_RIT(35), 0x12c5, CHANNEL_6, COLOR_08_RED) // "Who are you, young lady?"
	restart_timer

	beginloop(0x60)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0055, /*goto*/ 0x2d)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0056, /*goto*/ 0x2d)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0057, /*goto*/ 0x2d)
		if_chr_sees_player(/*goto*/ 0x2d)
		goto_next(0x86)

		label(0x2d)
		if_saw_injury(0x00, /*goto*/ 0x86)
		if_hears_gunfire(/*goto*/ 0x86)
		if_timer_lt(120, /*goto*/ 0x2d)
		if_chr_in_view(/*goto*/ 0x06)
		label(0x2d)
	endloop(0x60)

	label(0x06)
	speak(CHR_TARGET, L_RIT(37), 0x72bc, CHANNEL_7, COLOR_09_BLUE) // "Mr. President, you're in danger. Trent is trying t..."
	restart_timer
	stop_chr
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x78)

	// In this loop the president will continue to turn to face the player
	// because it lacks an if_jo_ccw_direction_lt check.
	beginloop(0x78)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0055, /*goto*/ 0x2d)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0056, /*goto*/ 0x2d)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0057, /*goto*/ 0x2d)
		if_chr_sees_player(/*goto*/ 0x2d)
		goto_next(0x86)

		label(0x2d)
		if_saw_injury(0x00, /*goto*/ 0x86)
		if_hears_gunfire(/*goto*/ 0x86)
		if_timer_lt(240, /*goto*/ 0x2d)
		if_chr_in_view(/*goto*/ 0x06)
		label(0x2d)
	endloop(0x78)

	label(0x06)
	do_preset_animation(1)
	speak(CHR_TARGET, L_RIT(40), 0x12c6, CHANNEL_6, COLOR_08_RED) // "You can't make accusations like that without evide..."
	restart_timer

	beginloop(0x79)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0055, /*goto*/ 0x2d)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0056, /*goto*/ 0x2d)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0057, /*goto*/ 0x2d)
		if_chr_sees_player(/*goto*/ 0x2d)
		goto_next(0x86)

		label(0x2d)
		if_saw_injury(0x00, /*goto*/ 0x86)
		if_hears_gunfire(/*goto*/ 0x86)
		if_timer_lt(400, /*goto*/ 0x2d)
		goto_next(0x84)

		label(0x2d)
	endloop(0x79)

	label(0x84)
	if_chr_has_object(CHR_TARGET, OBJ_EQUIPMENT, /*goto*/ 0x10)
	if_chr_has_object(CHR_TARGET, OBJ_EQUIPMENT_COOP, /*goto*/ 0x10)

	// No equipment
	label(0x85)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISE_UNCOVERED)
	set_chr_hiddenflag(CHR_COOP, CHRHFLAG_DISGUISE_UNCOVERED)
	speak(CHR_TARGET, L_RIT(36), 0x12c4, CHANNEL_6, COLOR_08_RED) // "Security, SECURITY!!"
	restart_timer
	chr_do_animation(0x0231, 0, 193, 0x18, 0x10, CHR_SELF, 2)

	beginloop(0x77)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x77)

	label(0x06)
	set_ailist(0x01, GAILIST_UNALERTED)
	set_ailist(CHR_STEWARDESS, GAILIST_UNALERTED)
	set_ailist(CHR_STEWARD, GAILIST_UNALERTED)
	set_ailist(0x04, GAILIST_UNALERTED)
	set_ailist(0x05, GAILIST_UNALERTED)
	set_ailist(0x06, GAILIST_UNALERTED)
	set_ailist(0x07, GAILIST_UNALERTED)
	set_ailist(0x08, GAILIST_UNALERTED)
	set_ailist(0x09, GAILIST_UNALERTED)
	set_ailist(0x0a, GAILIST_UNALERTED)
	set_ailist(0x0b, GAILIST_UNALERTED)
	set_ailist(0x0c, GAILIST_UNALERTED)
	set_ailist(0x0d, GAILIST_UNALERTED)
	set_ailist(0x0e, GAILIST_UNALERTED)
	set_ailist(0x0f, GAILIST_UNALERTED)
	set_ailist(0x10, GAILIST_UNALERTED)
	set_ailist(0x11, GAILIST_UNALERTED)
	set_ailist(0x12, GAILIST_UNALERTED)
	set_ailist(0x13, GAILIST_UNALERTED)
	set_ailist(0x14, GAILIST_UNALERTED)
	set_ailist(0x15, GAILIST_UNALERTED)
	set_stage_flag(STAGEFLAG_PRESIDENT_CALLED_SECURITY)
	yield
	increase_squadron_alertness(100)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x0a)

	beginloop(0x0a)
	endloop(0x0a)

	label(0x06)

	// Has equipment
	label(0x10)
	stop_chr
	speak(CHR_TARGET, L_RIT(41), 0x72bd, CHANNEL_6, COLOR_09_BLUE) // "This is a recording of a meeting between Trent and..."
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x0b)

	// This loop uses an if_sound_finished check rather than a timer check,
	// which allows the speech to be skipped.
	beginloop(0x0b)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0055, /*goto*/ 0x2d)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0056, /*goto*/ 0x2d)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0057, /*goto*/ 0x2d)
		if_chr_sees_player(/*goto*/ 0x2d)
		goto_next(0x86)

		label(0x2d)
		if_saw_injury(0x00, /*goto*/ 0x86)
		if_hears_gunfire(/*goto*/ 0x86)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x06)
	goto_first(0x0b)

	label(0x06)
	do_preset_animation(2)
	speak(CHR_TARGET, L_RIT(42), 0x12c7, CHANNEL_6, COLOR_08_RED) // "Seems overwhelming... I'm in your hands. What do w..."
	restart_timer

	beginloop(0x7a)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0055, /*goto*/ 0x2d)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0056, /*goto*/ 0x2d)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0057, /*goto*/ 0x2d)
		if_chr_sees_player(/*goto*/ 0x2d)
		goto_next(0x86)

		label(0x2d)
		if_saw_injury(0x00, /*goto*/ 0x86)
		if_hears_gunfire(/*goto*/ 0x86)
		if_timer_gt(400, /*goto*/ 0x06)
	endloop(0x7a)

	label(0x33)
	label(0x06)
	set_stage_flag(STAGEFLAG_TRIGGER_MIDCUTSCENE)

	beginloop(0x0d)
		if_stage_flag_eq(STAGEFLAG_MIDCUTSCENE_FINISHED, TRUE, /*goto*/ 0x06)
	endloop(0x0d)

	label(0x06)
	set_chr_team(CHR_SELF, TEAM_ALLY)
	rebuild_teams
	rebuild_squadrons
	hide_object(OBJ_EXTERIOR_DOOR)
	hide_object(OBJ_FLOORHATCH)
	set_object_flag(OBJ_FLOOR_HATCH_DETACHED, OBJFLAG_00000100)
	unset_object_flag2(OBJ_FLOOR_HATCH_DETACHED, OBJFLAG2_INVISIBLE)
	unset_object_flag2(OBJ_EXTERIOR_DOOR_DETACHED, OBJFLAG2_INVISIBLE)
	set_object_flag(OBJ_EXTERIOR_DOOR_DETACHED, OBJFLAG_00000100)
	play_sound(0x8098, -1)
	restart_timer

	beginloop(0x7b)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x7b)

	label(0x06)
	do_preset_animation(-1)
	speak(CHR_TARGET, L_RIT(38), 0x816e, CHANNEL_6, COLOR_08_RED) // "What the hell was that!"
	restart_timer

	beginloop(0x0c)
		if_timer_gt(180, /*goto*/ 0x06)
	endloop(0x0c)

	label(0x06)
	stop_chr
	set_stage_flag(STAGEFLAG_PRESIDENT_STARTED_RUNNING)
	speak(CHR_TARGET, L_RIT(39), 0x72be, CHANNEL_6, COLOR_09_BLUE) // "We have to get you to the escape pod. Follow me."
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x0e)

	beginloop(0x0e)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x0e)

	label(0x06)
	set_chrpreset(CHR_TARGET)
	set_chr_maxdamage(CHR_SELF, 500)
	set_shotlist(AILIST_PRESIDENT_RUNNING)
	set_ailist(CHR_SELF, AILIST_PRESIDENT_RUNNING)

	label(0x86)
	goto_first(0x85)

	endlist
};

u8 func0404_president_running[] = {
	set_self_chrflag(CHRCFLAG_01000000)
	set_shotlist(AILIST_PRESIDENT_RUNNING)
	set_target_chr(CHR_PRESET)
	if_chr_dying(CHR_SELF, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x2d)

	// Dying
	label(0x06)
	set_shotlist(GAILIST_IDLE)
	restart_timer

	beginloop(0x54)
		if_timer_gt(15, /*goto*/ 0x06)
	endloop(0x54)

	label(0x06)
	assign_sound(0x1abf, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x2d)
	dprint 'b','4',' ','s','h','i','e','l','d',' ','c','h','e','c','k','\n',0,
	if_just_injured(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x55)

	// Injured
	label(0x06)
	restart_timer
	assign_sound(0x1ac2, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)
	if_stage_flag_eq(STAGEFLAG_PRESIDENT_INJURED, TRUE, /*goto*/ 0x56)
	set_stage_flag(STAGEFLAG_PRESIDENT_INJURED)
	show_hudmsg(CHR_BOND, L_RIT(72)) // "The President is under attack."

	beginloop(0x56)
		if_num_times_shot_lt(1, /*goto*/ 0x06)
		if_timer_lt(20, /*goto*/ 0x06)

		label(0x06)
		if_chr_stopped(/*goto*/ 0x55)
	endloop(0x56)

	// Not injured, or injury animation finished
	label(0x55)
	stop_chr
	restart_timer

	beginloop(0x57)
		// @bug: This FALSE should be TRUE instead. This causes the president
		// to behave weirdly when you've killed both blondes and stand in the
		// entrace to Trent's room.
		if_stage_flag_eq(STAGEFLAG_BOTH_BLONDES_DEAD, FALSE, /*goto*/ 0x2d)

		// Both blondes dead
		// This room is the entrace to Trent's room
		if_chr_in_room(CHR_TARGET, 0x00, 0x000d, /*goto*/ 0x10)

		// At least one Blonde is alive, or follow through
		// These rooms are the escape pod area
		label(0x2d)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0030, /*goto*/ 0x11)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0031, /*goto*/ 0x11)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0032, /*goto*/ 0x11)
		dprint 't','a','r','g','e','t','\n',0,
		if_chr_sees_player(/*goto*/ 0x06)
		goto_next(0x58)

		label(0x06)
		if_timer_gt(1250, /*goto*/ 0x2d)
		if_distance_to_target_gt(200, /*goto*/ 0x58)
	endloop(0x57)

	// Been in sight for almost 21 seconds - say quip
	label(0x2d)
	call_rng
	if_rand_lt(64, /*goto*/ 0x2d)
	say_quip(CHR_BOND, 0x21, 0xff, 0x02, 0xff, BANK_1, 0x00, 0x00)
	goto_first(0x55)

	label(0x2d)
	say_quip(CHR_BOND, 0x21, 0xff, 0x02, 0xff, BANK_1, 0x00, 0x00)
	goto_first(0x55)

	// Unreachable
	label(0x06)
	say_quip(CHR_BOND, 0x21, 0xff, 0x02, 0xff, BANK_1, 0x00, 0x00)
	goto_first(0x55)

	// Distance to player > 200 or line of sight broken, so start following
	label(0x58)
	restart_timer
	label(0x2d)
	try_jog_to_target(/*goto*/ 0x59)

	beginloop(0x59)
		// @bug: This FALSE should be TRUE instead. This causes the president
		// to behave weirdly when you've killed both blondes and stand in the
		// entrace to Trent's room.
		if_stage_flag_eq(STAGEFLAG_BOTH_BLONDES_DEAD, FALSE, /*goto*/ 0x2d)

		// Both blondes dead
		// This room is the entrace to Trent's room
		if_chr_in_room(CHR_TARGET, 0x00, 0x000d, /*goto*/ 0x10)

		// At least one Blonde is alive, or follow through
		// These rooms are the escape pod area
		label(0x2d)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0030, /*goto*/ 0x11)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0031, /*goto*/ 0x11)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0032, /*goto*/ 0x11)
		if_distance_to_target_lt(100, /*goto*/ 0x5b)
		if_chr_stopped(/*goto*/ 0x5b)
		if_timer_gt(360, /*goto*/ 0x2d)
	endloop(0x59)

	label(0x2d)
	say_quip(CHR_BOND, 0x21, 0xff, 0x02, 0xff, BANK_1, 0x00, 0x00)
	goto_first(0x58)

	label(0x06)
	say_quip(CHR_BOND, 0x21, 0xff, 0x02, 0xff, BANK_1, 0x00, 0x00)
	goto_first(0x58)

	// Stopped because president is close to player's sampled prop
	label(0x5b)
	goto_first(0x55)

	// Unreachable
	label(0x5c)
	try_run_to_target(/*goto*/ 0x5d)

	beginloop(0x5d)
		if_stage_flag_eq(STAGEFLAG_BOTH_BLONDES_DEAD, FALSE, /*goto*/ 0x2d)
		if_chr_in_room(CHR_TARGET, 0x00, 0x000d, /*goto*/ 0x10)
		label(0x2d)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0030, /*goto*/ 0x11)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0031, /*goto*/ 0x11)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0032, /*goto*/ 0x11)
	endloop(0x5d)

	label(0x5e)
	goto_first(0x55)

	// Player in pod room while a Blonde is alive
	// This pad is at the escape pod
	label(0x11)
	jog_to_pad(0x0083)

	beginloop(0x09)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	stop_chr
	set_stage_flag(STAGEFLAG_PRESIDENT_AT_POD)
	set_chr_team(CHR_SELF, TEAM_NONCOMBAT)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Player is in the entrace to Trent's room and both blondes are dead.
	// The intention behind this code is to make the president cower until the
	// Blondes are dead, then resume following. However, due to a logic bug
	// described earlier this code is jumped to only after the blondes are dead.
	label(0x10)
	run_to_pad(0x0019)

	// This loop will never iterate because the blondes are already dead
	beginloop(0x0a)
		if_chr_stopped(/*goto*/ 0x0b)
		if_stage_flag_eq(STAGEFLAG_BOTH_BLONDES_DEAD, TRUE, /*goto*/ 0x06)
	endloop(0x0a)

	// Unreachable under real conditions
	label(0x0b)
	chr_do_animation(ANIM_COWER_0229, -1, -1, 0x10, 0x0a, CHR_SELF, 2)

	beginloop(0x83)
		if_stage_flag_eq(STAGEFLAG_BOTH_BLONDES_DEAD, TRUE, /*goto*/ 0x06)
		if_chr_stopped(/*goto*/ 0x2d)
	endloop(0x83)

	label(0x2d)
	goto_first(0x0b)

	// Both blondes dead - resume running
	label(0x06)
	goto_first(0x55)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100b_check_president_dead[] = {
	beginloop(0x04)
		if_chr_dying(CHR_PRESIDENT, /*goto*/ 0x06)
		if_chr_death_animation_finished(CHR_PRESIDENT, /*goto*/ 0x06)
		if_chr_unloaded(CHR_PRESIDENT, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_stage_flag(STAGEFLAG_PRESIDENT_DEAD)
	show_hudmsg(CHR_BOND, L_RIT(26)) // "The President has been incapacitated."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0409_unused[] = {
	set_self_chrflag(CHRCFLAG_00000040)

	beginloop(0x04)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		if_target_is_player(/*goto*/ 0x06)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x2d)
		set_returnlist(CHR_SELF, 0x0409)
		set_shotlist(0x0409)
		set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)

		label(0x2d)
	endloop(0x04)

	label(0x06)
	unset_self_flag_bankx(CHRFLAG1_00001000, BANK_1)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	set_returnlist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

/**
 * This stripes guard is in one of the cockpit rooms.
 */
u8 func100c_cockpit_stripes[] = {
	set_shotlist(GAILIST_ALERTED)
	set_chr_team(CHR_SELF, TEAM_04)
	rebuild_teams
	rebuild_squadrons
	set_chr_dodge_rating(2, 0x00)
	set_accuracy(14)
	set_reaction_speed(50)
	set_chr_maxdamage(CHR_SELF, 60)
	add_health_or_armor(0)
	set_recovery_speed(30)
	set_shield(0)
	set_self_chrflag(CHRCFLAG_00000040)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x06)
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		if_target_is_player(/*goto*/ 0x06)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x2d)
		set_returnlist(CHR_SELF, AILIST_COCKPIT_STRIPES)
		set_shotlist(GAILIST_COMBAT_WITH_TARGET)
		set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
		label(0x2d)
	endloop(0x04)

	label(0x06)
	unset_self_flag_bankx(CHRFLAG1_00001000, BANK_1)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	set_returnlist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func0413_taker1[] = {
	set_chr_team(CHR_SELF, TEAM_04)
	rebuild_teams
	rebuild_squadrons
	set_self_chrflag(CHRCFLAG_00000020)
	set_chr_dodge_rating(2, 0x00)
	set_reaction_speed(50)
	set_chr_maxdamage(CHR_SELF, 60)
	add_health_or_armor(0)
	set_recovery_speed(30)
	set_shield(0)
	set_target_chr(CHR_PILOT1)
	set_ailist(CHR_SELF, AILIST_TAKER)
	endlist
};

u8 func0413_taker2[] = {
	set_chr_team(CHR_SELF, TEAM_04)
	rebuild_teams
	rebuild_squadrons
	set_self_chrflag(CHRCFLAG_00000020)
	set_chr_dodge_rating(2, 0x00)
	set_reaction_speed(50)
	set_chr_maxdamage(CHR_SELF, 60)
	add_health_or_armor(0)
	set_recovery_speed(30)
	set_shield(0)
	set_target_chr(CHR_PILOT2)
	set_ailist(CHR_SELF, AILIST_TAKER)
	endlist
};

u8 func0413_taker[] = {
	set_shotlist(GAILIST_ALERTED)
	unset_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_team(CHR_SELF, TEAM_04)
	rebuild_teams
	rebuild_squadrons
	set_accuracy(50)
	set_self_chrflag(CHRCFLAG_00000040)
	restart_timer

	// Wait for condition
	beginloop(0x04)
		if_door_state(0x0c, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x0a)
		if_stage_flag_eq(STAGEFLAG_PRESIDENT_STARTED_RUNNING, FALSE, /*goto*/ 0x2d)
		if_timer_gt(7200, /*goto*/ 0x0a)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x0a)
		label(0x2d)
	endloop(0x04)

	// Wait another 1.5 seconds
	label(0x0a)
	restart_timer

	beginloop(0x0c)
		if_timer_gt(90, /*goto*/ 0x06)
	endloop(0x0c)

	label(0x06)
	if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x11)
	if_chr_dying(CHR_TARGET, /*goto*/ 0x11)
	if_chr_unloaded(CHR_TARGET, /*goto*/ 0x11)
	try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x06)
	label(0x06)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x08)
	label(0x08)
	say_quip(CHR_BOND, 0x00, 0x19, 0x02, 0x00, BANK_0, 0x00, 0x00)
	say_quip(CHR_BOND, 0x01, 0x19, 0x02, 0x01, BANK_0, 0x00, 0x00)
	restart_timer

	beginloop(0x09)
		if_chr_stopped(/*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x2d)
	endloop(0x09)

	label(0x2d)
	if_target_is_player(/*goto*/ 0x11)
	if_chrpresets_target_is_different(/*goto*/ 0x2d)
	goto_next(0x11)

	label(0x2d)
	damage_chr(CHR_TARGET, 18)

	beginloop(0x0b)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x0b)

	label(0x06)
	if_chr_dying(CHR_TARGET, /*goto*/ 0x06)
	goto_first(0x0a)

	label(0x11)
	label(0x06)
	unset_self_flag_bankx(CHRFLAG1_00001000, BANK_1)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func100c_cockpit[] = {
	label(0x2d)
	label(0x2e)
	set_chr_chrflag(CHR_TAKER1, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_TAKER2, CHRCFLAG_HIDDEN)

	beginloop(0x60)
		if_all_objectives_complete(/*goto*/ 0x2d)
		if_stage_flag_eq(STAGEFLAG_UFO_ATTACHMENT_DAMAGED, TRUE, /*goto*/ 0x2e)
	endloop(0x60)

	// All objectives complete
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// UFO attachment damaged
	label(0x2e)
	yield
	if_stage_flag_eq(STAGEFLAG_ALL_OBJECTIVES_COMPLETE, TRUE, /*goto*/ 0x11)
	unset_chr_chrflag(CHR_TAKER1, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_TAKER2, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_TAKER1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_TAKER2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	label(0x06)

	// This loop will surely never iterate because
	// the UFO attachment is already damaged
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_ALL_OBJECTIVES_COMPLETE, TRUE, /*goto*/ 0x11)
		if_stage_flag_eq(STAGEFLAG_UFO_ATTACHMENT_DAMAGED, TRUE, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	if_chr_dying(CHR_TAKER1, /*goto*/ 0x2d)
	if_chr_death_animation_finished(CHR_TAKER1, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_TAKER1, /*goto*/ 0x2d)
	goto_next(0x06)

	label(0x2d)
	if_chr_dying(CHR_TAKER2, /*goto*/ 0x2d)
	if_chr_death_animation_finished(CHR_TAKER2, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_TAKER2, /*goto*/ 0x2d)
	goto_next(0x06)

	// Both takers dead
	label(0x2d)
	goto_next(0x2e)

	// At least one taker alive
	label(0x06)
	damage_chr(CHR_PILOT1, 18)
	damage_chr(CHR_PILOT2, 18)
	yield
	damage_chr(CHR_PILOT1, 18)
	damage_chr(CHR_PILOT2, 18)
	yield
	damage_chr(CHR_PILOT1, 18)
	damage_chr(CHR_PILOT2, 18)
	yield
	set_stage_flag(STAGEFLAG_PILOTS_DEAD)
	show_hudmsg(CHR_BOND, L_RIT(27)) // "Pilots have been killed."
	goto_next(0x06)

	// Both takers dead
	label(0x2e)

	// Pilots killed
	label(0x06)
	label(0x10)
	set_stage_flag(STAGEFLAG_PLANE_NOSEDIVING)
	set_object_image(OBJ_AUTOPILOT_SWITCH, 0x00, 0x0f)

	// Wait 10 seconds
	label(0x09)
	restart_timer

	beginloop(0x0f)
		if_stage_flag_eq(STAGEFLAG_ALL_OBJECTIVES_COMPLETE, TRUE, /*goto*/ 0x11)
		if_timer_gt(600, /*goto*/ 0x2d)
	endloop(0x0f)

	label(0x2d)
	misc_command(0x0000, 0x0a, 0x3c)

	// Wait 40 seconds or for autopilot
	restart_timer

	beginloop(0x0a)
		if_stage_flag_eq(STAGEFLAG_PLANE_STABILIZED, TRUE, /*goto*/ 0x11)
		if_timer_gt(2400, /*goto*/ 0x0b)
	endloop(0x0a)

	label(0x0b)
	if_stage_flag_eq(STAGEFLAG_ALL_OBJECTIVES_COMPLETE, TRUE, /*goto*/ 0x11)
	show_hudmsg(CHR_BOND, L_RIT(29)) // "Air Force One is about to crash."

	// Wait until the 50 second mark
	beginloop(0x0c)
		if_all_objectives_complete(/*goto*/ 0x11)
		if_stage_flag_eq(STAGEFLAG_PLANE_STABILIZED, TRUE, /*goto*/ 0x11)
		if_timer_gt(3000, /*goto*/ 0x0e)
	endloop(0x0c)

	// Crash
	label(0x0e)
	set_stage_flag(STAGEFLAG_PLANE_CRASHED)
	explosions_around_chr(CHR_BOND)
	restart_timer

	beginloop(0x65)
		if_timer_gt(180, /*goto*/ 0x2d)
	endloop(0x65)

	label(0x2d)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Unreachable
	label(0x7c)
	label(0x2d)
	set_object_image(0x03, 0x00, 0x13)
	set_stage_flag(STAGEFLAG_PLANE_STABILIZED)
	show_hudmsg(CHR_BOND, L_RIT(28)) // "Pilots have been saved."
	reset_ambience
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Unreachable
	label(0x08)
	goto_first(0x04)

	// Plane stabilized or all objectives complete
	label(0x11)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Assigned to a pilot and a cyclone guard.
 */
u8 func0411_typing_guy[] = {
	set_shotlist(AILIST_TYPING_GUY)
	label(0x04)
	chr_do_animation(ANIM_SITTING_TYPING, 0, -1, 0x04, 0x10, CHR_SELF, 2)

	beginloop(0x03)
		if_chr_idle(/*goto*/ 0x06)
		goto_first(0x04)

		label(0x06)
	endloop(0x03)

	endlist
};

/**
 * Assigned to a pilot and a cyclone guard.
 */
u8 func0412_sitting_guy[] = {
	set_shotlist(AILIST_SITTING_GUY)
	label(0x04)
	chr_do_animation(ANIM_SITTING_DORMANT, 0, -1, 0x04, 0x10, CHR_SELF, 2)

	beginloop(0x03)
		if_chr_idle(/*goto*/ 0x06)
		goto_first(0x04)

		label(0x06)
	endloop(0x03)

	endlist
};

u8 func0426_start_path00[] = {
	set_chr_dodge_rating(2, 0x00)
	set_accuracy(14)
	set_reaction_speed(70)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	assign_path(0)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func0427_start_path01[] = {
	set_chr_dodge_rating(2, 0x00)
	set_accuracy(14)
	set_reaction_speed(70)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	assign_path(1)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func0428_start_path02[] = {
	assign_path(2)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func1002_intro[] = {
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_AIRFORCEONE_INTRO)
	camera_movement(0x018c)
	set_chr_chrflag(0x30, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x30, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x30, CHRHFLAG_00020000)
	chr_do_animation(0x018f, -1, -1, 0x06, 0x00, 0x30, 4)
	set_chr_chrflag(0x31, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x31, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x31, CHRHFLAG_00020000)
	chr_do_animation(0x018d, -1, -1, 0x06, 0x00, 0x31, 4)
	set_chr_chrflag(CHR_PRESIDENT, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_PRESIDENT, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_PRESIDENT, CHRHFLAG_00020000)
	chr_do_animation(0x018e, -1, -1, 0x06, 0x00, CHR_PRESIDENT, 4)
	set_chr_chrflag(0x13, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x14, CHRCFLAG_HIDDEN)
	restart_timer
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 90)
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)

	#define wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0x7d) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)



	wait_until(140, 0x94)

	wait_until(180, 0x60)
	speak(CHR_BOND, L_RIT(73), 0x744c, CHANNEL_7, COLOR_05_GREEN) // "Have you thought any more about that proposal I ga..."

	wait_until(330, 0x95)

	wait_until(360, 0x96)

	wait_until(438, 0x77)
	speak(CHR_BOND, L_RIT(74), 0x744d, CHANNEL_7, COLOR_08_RED) // "My answer remains the same... I'm sorry Trent, but..."

	wait_until(486, 0x97)

	wait_until(532, 0x98)

	wait_until(850, 0x99)

	wait_until(1020, 0x78)
	speak(CHR_BOND, L_RIT(75), 0x744e, CHANNEL_7, COLOR_05_GREEN) // "But this is a golden opportunity to show that Amer..."

	wait_until(1402, 0x79)
	speak(CHR_BOND, L_RIT(76), 0x81bb, CHANNEL_7, COLOR_08_RED) // "Damn it, man! I say no and I mean no! I'm not gonn..."

	wait_until(2348, 0x7a)
	speak(CHR_BOND, L_RIT(77), 0x7450, CHANNEL_7, COLOR_05_GREEN) // "As you wish, sir."

	wait_until(2406, 0x9a)

	wait_until(2410, 0x62)
	open_door(0x15)

	wait_until(2465, 0x9b)

	wait_until(2498, 0x9c)

	wait_until(2560, 0x9d)

	wait_until(2616, 0x9e)

	wait_until(2654, 0x7b)
	speak(CHR_BOND, L_RIT(78), 0x7451, CHANNEL_7, COLOR_05_GREEN) // "My last chance? Ha! You fool. That was yours."
	close_door(0x15)
	play_sound(0x8008, CHANNEL_10)

	wait_until(2680, 0x9f)

	wait_until(2710, 0xa0)

	wait_until(2790, 0xa5)

	wait_until(3140, 0xa1)

	wait_until(3180, 0xa2)

	wait_until(3190, 0xa3)

	wait_until(3210, 0xa4)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x7d)

		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x7d)
		label(0x2d)
	endloop(0x08)

	label(0x7d)
	mute_channel(CHANNEL_10)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISED)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)
	set_chr_hiddenflag(CHR_COOP, CHRHFLAG_DISGUISED)
	label(0x2d)
	if_savefile_flag_is_set(SAVEFILEFLAG_AF1_ENTRY, /*goto*/ 0x06)
	goto_next(0x7e)
	label(0x06)
	camera_movement(0x01d0)
	cmd0175(60)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)
	chr_move_to_pad(CHR_COOP, 0x008a, 0x01, /*goto*/ 0x2d)
	label(0x2d)
	if_controller_button_pressed(/*goto*/ 0x5f)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x01d1, -1, -1, 0x06, 0x00, CHR_BOND, 4)

	beginloop(0x09)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x5f)
		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x5f)
		label(0x2d)
	endloop(0x09)

	label(0x7e)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISED)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)
	set_chr_hiddenflag(CHR_COOP, CHRHFLAG_DISGUISED)
	label(0x2d)
	dprint 'D','I','S','G','U','I','S','E','D','\n',0,
	camera_movement(0x01d2)
	cmd0175(60)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)
	chr_move_to_pad(CHR_COOP, 0x00b2, 0x01, /*goto*/ 0x2d)
	label(0x2d)
	if_controller_button_pressed(/*goto*/ 0x5f)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x01d3, -1, -1, 0x06, 0x00, CHR_BOND, 4)

	beginloop(0x0a)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x5f)
		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x5f)
		label(0x2d)
	endloop(0x0a)

	label(0x5f)
	mute_channel(CHANNEL_7)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	if_savefile_flag_is_set(SAVEFILEFLAG_AF1_ENTRY, /*goto*/ 0x06)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_TRIGGER_BUDDY_WARP)
	chr_do_animation(0x01d3, -2, -1, 0x06, 0x00, CHR_BOND, 2)
	goto_next(0x2d)
	label(0x06)
	chr_do_animation(0x01d1, -2, -1, 0x06, 0x00, CHR_BOND, 2)
	label(0x2d)
	restart_default_music
	reset_ambience
	unset_chr_chrflag(0x13, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x14, CHRCFLAG_HIDDEN)
	set_ailist(CHR_PRESIDENT, AILIST_INIT_PRESIDENT)
	set_ailist(0x09, AILIST_INIT_NEUTRAL)
	set_ailist(0x0a, AILIST_INIT_NEUTRAL)
	set_ailist(0x0c, AILIST_INIT_NEUTRAL)
	set_ailist(0x0d, AILIST_INIT_NEUTRAL)
	remove_chr(0x30)
	remove_chr(0x31)
	unset_chr_chrflag(0x30, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x31, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_PRESIDENT, CHRCFLAG_UNPLAYABLE)
	set_stage_flag(STAGEFLAG_INTRO_FINISHED)
	enter_firstperson
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * The dumbwaiter near the middle of the plane.
 */
u8 func1010_dumbwaiter1[] = {
	label(0x03)
	set_object_flag(OBJ_DUMBWAITER1, OBJFLAG_DEACTIVATED)
	set_object_image(OBJ_DUMBWAITER1_SWITCH, 0x00, 0x12)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_DUMBWAITER1_SWITCH, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	play_sound(0x043a, CHANNEL_7)
	set_object_image(OBJ_DUMBWAITER1_SWITCH, 0x00, 0x13)
	unset_object_flag(OBJ_DUMBWAITER1, OBJFLAG_DEACTIVATED)
	yield
	yield
	yield

	beginloop(0x08)
		if_lift_stationary(OBJ_DUMBWAITER1, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	set_object_flag(OBJ_DUMBWAITER1, OBJFLAG_DEACTIVATED)
	restart_timer

	beginloop(0x09)
		if_timer_gt(180, /*goto*/ 0x2d)
	endloop(0x09)

	label(0x2d)
	unset_object_flag(OBJ_DUMBWAITER1, OBJFLAG_DEACTIVATED)
	yield
	yield
	yield

	beginloop(0x0a)
		if_lift_stationary(OBJ_DUMBWAITER1, /*goto*/ 0x06)
		goto_next(0x2d)

		label(0x06)
	endloop(0x0a)

	label(0x2d)
	yield
	yield
	yield

	beginloop(0x0b)
		if_lift_stationary(OBJ_DUMBWAITER1, /*goto*/ 0x06)
	endloop(0x0b)

	label(0x06)
	open_door(0x2b)
	if_chr_activated_object(CHR_P1P2, OBJ_DUMBWAITER1_SWITCH, /*goto*/ 0x2d)
	label(0x2d)
	goto_first(0x03)

	endlist
};

u8 func1011_dumbwaiter2[] = {
	label(0x03)
	set_object_flag(OBJ_DUMBWAITER2, OBJFLAG_DEACTIVATED)
	set_object_image(OBJ_DUMBWAITER2_SWITCH, 0x00, 0x12)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_DUMBWAITER2_SWITCH, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	play_sound(0x043a, CHANNEL_7)
	set_object_image(OBJ_DUMBWAITER2_SWITCH, 0x00, 0x13)
	unset_object_flag(OBJ_DUMBWAITER2, OBJFLAG_DEACTIVATED)
	yield
	yield
	yield

	beginloop(0x08)
		if_lift_stationary(OBJ_DUMBWAITER2, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	set_object_flag(OBJ_DUMBWAITER2, OBJFLAG_DEACTIVATED)
	restart_timer

	beginloop(0x09)
		if_timer_gt(180, /*goto*/ 0x2d)
	endloop(0x09)

	label(0x2d)
	unset_object_flag(OBJ_DUMBWAITER2, OBJFLAG_DEACTIVATED)
	yield
	yield
	yield

	beginloop(0x0a)
		if_lift_stationary(OBJ_DUMBWAITER2, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	// @bug: Wrong object, but this is a no-op anyway.
	if_chr_activated_object(CHR_P1P2, OBJ_DUMBWAITER1_SWITCH, /*goto*/ 0x2d)
	label(0x2d)
	goto_first(0x03)

	endlist
};

u8 func040a_defend_pad[] = {
	set_shotlist(AILIST_DEFEND_PAD)
	set_returnlist(CHR_SELF, AILIST_DEFEND_PAD)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2d)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2d)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2d)
	goto_next(0x06)

	// Dying
	label(0x2d)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x06)
	if_just_injured(CHR_SELF, /*goto*/ 0x2d)
	goto_next(0x06)

	// Injured
	label(0x2d)

	beginloop(0x0a)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x0a)

	// Not injured
	label(0x06)
	if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
	if_chr_distance_to_pad_lt(CHR_SELF, 200, PAD_PRESET, /*goto*/ 0x06)

	label(0x03)
	jog_to_pad(PAD_PRESET)

	beginloop(0x04)
		dprint 'G','O',' ','T','O',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
		if_chr_distance_to_pad_lt(CHR_SELF, 200, PAD_PRESET, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	stop_chr

	beginloop(0x09)
		dprint 'A','T',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
		if_chr_distance_to_pad_gt(CHR_SELF, 300, PAD_PRESET, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	goto_first(0x03)

	// Detected enemy
	label(0x08)
	dprint 'D','E','T','E','C','T','E','D','\n',0,
	set_returnlist(CHR_SELF, AILIST_DEFEND_PAD)
	set_shotlist(AILIST_DEFEND_PAD)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	endlist
};

/**
 * Unused, but would have been assigned to a cyclone guard.
 */
u8 func040b_defend_president[] = {
	set_shotlist(AILIST_DEFEND_PRESIDENT)
	if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
	if_distance_to_chr_lt(200, CHR_PRESIDENT, /*goto*/ 0x06)

	label(0x03)
	try_jog_to_chr(CHR_PRESIDENT, /*goto*/ 0x04)

	beginloop(0x04)
		dprint 'G','O',' ','T','O',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
		if_detected_chr(CHR_PRESIDENT, /*goto*/ 0x60)
	endloop(0x04)

	// Near president
	label(0x60)
	if_distance_to_chr_lt(200, CHR_PRESIDENT, /*goto*/ 0x06)
	goto_first(0x04)

	label(0x06)
	stop_chr

	beginloop(0x09)
		dprint 'A','T',' ','P','A','D','\n',0,
		if_enemy_distance_lt_and_los(2540, /*goto*/ 0x08)
		if_detected_chr(CHR_PRESIDENT, /*goto*/ 0x60)
		goto_first(0x04)

		label(0x60)
		if_distance_to_chr_gt(300, CHR_PRESIDENT, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	goto_first(0x03)

	// Detected enemy
	label(0x08)
	dprint 'D','E','T','E','C','T','E','D','\n',0,
	set_returnlist(CHR_SELF, AILIST_DEFEND_PRESIDENT)
	set_shotlist(AILIST_DEFEND_PRESIDENT)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)
	endlist
};

u8 func0415_cloner1[] = {
	set_self_chrflag(CHRCFLAG_00000002)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_00040000)

	beginloop(0x03)
		if_stage_flag_eq(STAGEFLAG_PRESIDENT_STARTED_RUNNING, TRUE, /*goto*/ 0x06)
		reloop(0x03)

		label(0x06)
		if_stage_flag_eq(STAGEFLAG_PRESIDENT_AT_POD, TRUE, /*goto*/ 0x06)
	endloop(0x03)

	label(0x06)

	set_chr_team(CHR_SELF, TEAM_04)
	try_equip_weapon(MODEL_CHRAVENGER, WEAPON_K7AVENGER, 0x10000000, /*goto*/ 0x04)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_UFO_ATTACHMENT_DAMAGED, TRUE, /*goto*/ 0x0e)
		// These rooms are the attachment area
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0017, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0018, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0019, /*goto*/ 0x2d)
		if_never_been_onscreen(/*goto*/ 0x4f)
		if_chr_sees_player(/*goto*/ 0x08)
		label(0x2d)
		reloop(0x04)

		// Line of sight to player
		label(0x08)
		set_ailist(CHR_SELF, AILIST_CLONE1)

		// Chr flag is unset
		label(0x4f)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x4f)
		reloop(0x04)

		// @bug? This may have intended to be a bank 1 check because the bank 1
		// flag is unset further below, and cloner3 uses bank 1.
		label(0x4f)
		if_self_flag_bankx_eq(CHRFLAG0_SQUADALERTANYDIST, TRUE, BANK_0, /*goto*/ 0x2d)
		restart_timer

		beginloop(0x0b)
			if_stage_flag_eq(STAGEFLAG_UFO_ATTACHMENT_DAMAGED, TRUE, /*goto*/ 0x0e)
			if_timer_gt(2400, /*goto*/ 0x2d)
		endloop(0x0b)

		// Player is in UFO area, or interval has passed
		label(0x2d)
		unset_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
		try_spawn_clone2(CHR_SELF, AILIST_INIT_CLONE1, 0x00000000, /*goto*/ 0x2d)
		label(0x2d)
		yield
	endloop(0x04)

	// UFO attachment damaged
	label(0x0e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0416_init_clone1[] = {
	set_chr_dodge_rating(2, 0x00)
	set_accuracy(14)
	set_reaction_speed(50)
	set_chr_maxdamage(CHR_SELF, 60)
	add_health_or_armor(0)
	set_recovery_speed(30)
	set_shield(0)
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	try_equip_weapon(MODEL_CHRAVENGER, WEAPON_K7AVENGER, 0x10000000, /*goto*/ 0x04)
	label(0x04)
	rebuild_teams
	rebuild_squadrons
	try_inherit_properties(0x35, /*goto*/ 0x06)
	label(0x06)
	set_ailist(CHR_SELF, AILIST_CLONE1)
	endlist
};

u8 func0417_clone1[] = {
	// Pad is at the cockpit door
	run_to_pad(0x0042)
	set_returnlist(CHR_SELF, AILIST_CLONE1)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func0418_cloner2[] = {
	set_self_chrflag(CHRCFLAG_00000002)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_00040000)

	beginloop(0x03)
		if_stage_flag_eq(STAGEFLAG_PRESIDENT_STARTED_RUNNING, TRUE, /*goto*/ 0x06)
		reloop(0x03)

		label(0x06)
		if_stage_flag_eq(STAGEFLAG_PRESIDENT_AT_POD, TRUE, /*goto*/ 0x06)
	endloop(0x03)

	label(0x06)

	set_chr_team(CHR_SELF, TEAM_04)
	try_equip_weapon(MODEL_CHRAVENGER, WEAPON_K7AVENGER, 0x10000000, /*goto*/ 0x04)
	yield
	yield
	yield
	yield
	yield

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_UFO_ATTACHMENT_DAMAGED, TRUE, /*goto*/ 0x0e)
		// These rooms are the attachment area
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0017, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0018, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0019, /*goto*/ 0x2d)
		if_never_been_onscreen(/*goto*/ 0x4f)
		if_chr_sees_player(/*goto*/ 0x08)
		label(0x2d)
		reloop(0x04)

		// Line of sight to player
		label(0x08)
		set_ailist(CHR_SELF, AILIST_CLONE2)

		// Chr flag is unset
		label(0x4f)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x4f)
		reloop(0x04)

		// @bug? This may have intended to be a bank 1 check because the bank 1
		// flag is unset further below, and cloner3 uses bank 1.
		label(0x4f)
		if_self_flag_bankx_eq(CHRFLAG0_SQUADALERTANYDIST, TRUE, BANK_0, /*goto*/ 0x2d)
		restart_timer

		beginloop(0x0b)
			if_stage_flag_eq(STAGEFLAG_UFO_ATTACHMENT_DAMAGED, TRUE, /*goto*/ 0x0e)
			if_timer_gt(3600, /*goto*/ 0x2d)
		endloop(0x0b)

		// Player is in UFO area, or interval has passed
		label(0x2d)
		unset_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
		try_spawn_clone2(CHR_SELF, AILIST_INIT_CLONE2, 0x00000000, /*goto*/ 0x2d)
		label(0x2d)
		yield
	endloop(0x04)

	// UFO attachment damaged
	label(0x0e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0419_init_clone2[] = {
	set_chr_dodge_rating(2, 0x00)
	set_accuracy(14)
	set_reaction_speed(50)
	set_chr_maxdamage(CHR_SELF, 60)
	add_health_or_armor(0)
	set_recovery_speed(30)
	set_shield(0)
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	try_equip_weapon(MODEL_CHRAVENGER, WEAPON_K7AVENGER, 0x10000000, /*goto*/ 0x04)
	label(0x04)
	rebuild_teams
	rebuild_squadrons
	try_inherit_properties(0x36, /*goto*/ 0x06)
	label(0x06)
	set_ailist(CHR_SELF, AILIST_CLONE2)
	endlist
};

u8 func041a_clone2[] = {
	// Pad is at back of the plane, top floor
	run_to_pad(0x005c)
	set_returnlist(CHR_SELF, AILIST_CLONE2)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

/**
 * Unlike the other two cloners, this one does not stop once the president has
 * reached the escape pod.
 */
u8 func041b_cloner3[] = {
	set_self_chrflag(CHRCFLAG_00000002)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_00040000)

	beginloop(0x03)
		if_stage_flag_eq(STAGEFLAG_PRESIDENT_STARTED_RUNNING, TRUE, /*goto*/ 0x06)
	endloop(0x03)

	label(0x06)
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	set_chr_team(CHR_SELF, TEAM_04)
	try_equip_weapon(MODEL_CHRAVENGER, WEAPON_K7AVENGER, 0x10000000, /*goto*/ 0x04)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_UFO_ATTACHMENT_DAMAGED, TRUE, /*goto*/ 0x0e)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0017, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0018, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0019, /*goto*/ 0x2d)
		if_never_been_onscreen(/*goto*/ 0x4f)
		if_chr_sees_player(/*goto*/ 0x08)
		label(0x2d)
		reloop(0x04)

		label(0x08)
		set_ailist(CHR_SELF, AILIST_CLONE3)
		label(0x4f)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x4f)
		reloop(0x04)

		label(0x4f)
		if_self_flag_bankx_eq(CHRFLAG1_00080000, TRUE, BANK_1, /*goto*/ 0x2d)
		restart_timer

		beginloop(0x0b)
			if_stage_flag_eq(STAGEFLAG_UFO_ATTACHMENT_DAMAGED, TRUE, /*goto*/ 0x0e)
			if_timer_gt(3600, /*goto*/ 0x2d)
		endloop(0x0b)

		label(0x2d)
		unset_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
		try_spawn_clone2(CHR_SELF, AILIST_INIT_CLONE3, 0x00000000, /*goto*/ 0x2d)
		label(0x2d)
		yield
	endloop(0x04)

	label(0x0e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func041c_init_clone3[] = {
	set_chr_dodge_rating(2, 0x00)
	set_accuracy(14)
	set_reaction_speed(50)
	set_chr_maxdamage(CHR_SELF, 60)
	add_health_or_armor(0)
	set_recovery_speed(30)
	set_shield(0)
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	try_equip_weapon(MODEL_CHRAVENGER, WEAPON_K7AVENGER, 0x10000000, /*goto*/ 0x04)
	label(0x04)
	rebuild_teams
	rebuild_squadrons
	try_inherit_properties(0x37, /*goto*/ 0x06)
	label(0x06)
	set_ailist(CHR_SELF, AILIST_CLONE3)
	endlist
};

u8 func041d_clone3[] = {
	set_target_chr(CHR_BOND)
	try_run_to_target(/*goto*/ 0x04)
	label(0x04)
	yield
	set_returnlist(CHR_SELF, AILIST_CLONE3)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

u8 func041f_init_blonde[] = {
	set_chr_team(CHR_SELF, TEAM_04)
	rebuild_teams
	rebuild_squadrons
	set_chr_dodge_rating(2, 0x00)
	set_accuracy(24)
	set_reaction_speed(50)
	set_chr_maxdamage(CHR_SELF, 60)
	add_health_or_armor(100)
	set_recovery_speed(100)
	set_shield(0)
	set_ailist(CHR_SELF, AILIST_BLONDE)
	endlist
};

u8 func041e_blonde[] = {
	set_chr_team(CHR_SELF, TEAM_04)
	rebuild_teams
	rebuild_squadrons
	set_accuracy(30)
	set_shotlist(AILIST_BLONDE)
	if_chr_dying(CHR_SELF, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x2d)

	// Dying
	label(0x06)
	set_shotlist(GAILIST_IDLE)
	restart_timer

	beginloop(0x54)
		if_timer_gt(15, /*goto*/ 0x06)
	endloop(0x54)

	label(0x06)
	say_quip(CHR_BOND, 0x19, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	// This injured check is pointless
	label(0x2d)
	if_just_injured(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x08)

	label(0x06)
	label(0x08)
	set_self_chrflag(CHRCFLAG_00000040)
	label(0x68)
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x06)
	try_chr_kneel_and_shoot_thing(0x0220, 0x0000, /*goto*/ 0x75)
	label(0x06)
	kneel

	beginloop(0x75)
		label(0x2d)
		chr_toggle_p1p2(CHR_P1P2)
		set_target_chr(CHR_BOND)
		if_target_in_sight(/*goto*/ 0x6a)
		if_near_miss(/*goto*/ 0x6b)
		label(0x2d)
		reloop(0x75)

		label(0x06)
		if_target_in_sight(/*goto*/ 0x6a)
		label(0x2d)
	endloop(0x75)

	label(0x6a)
	if_self_flag_bankx_eq(CHRFLAG0_00000004, TRUE, BANK_0, /*goto*/ 0x2d)
	set_self_flag_bankx(CHRFLAG0_00000004, BANK_0)
	say_quip(CHR_BOND, 0x0b, 0xff, 0x02, 0xff, BANK_0, 0x00, 0x00)
	label(0x2d)
	goto_next(0x6c)

	// Unreachable
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x6d)
	goto_next(0x6e)

	// Reachable from below
	beginloop(0x6d)
		if_chr_stopped(/*goto*/ 0x6e)
	endloop(0x6d)

	label(0x6e)
	restart_timer
	chr_do_animation(ANIM_RELOAD_0209, 0, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x66)
		if_self_flag_bankx_eq(CHRFLAG1_00000020, FALSE, BANK_1, /*goto*/ 0x06)
		if_timer_lt(120, /*goto*/ 0x06)
		assign_sound(0x80f6, CHANNEL_7)
		play_sound_from_entity(CHANNEL_7, CHR_SELF, 0x0bb8, 0x1770, 0x01)
		unset_self_flag_bankx(CHRFLAG1_00000020, BANK_1)
		label(0x06)
		if_chr_stopped(/*goto*/ 0x2d)
	endloop(0x66)

	label(0x2d)
	label(0x06)
	goto_first(0x68)

	label(0x6b)
	restart_timer
	if_self_flag_bankx_eq(CHRFLAG0_00000004, TRUE, BANK_0, /*goto*/ 0x6f)
	set_self_flag_bankx(CHRFLAG0_00000004, BANK_0)

	label(0x6f)
	call_rng
	if_target_in_sight(/*goto*/ 0x70)
	if_timer_gt(60, /*goto*/ 0x71)
	if_rand_lt(4, /*goto*/ 0x71)
	goto_first(0x6f)

	label(0x71)
	if_chr_sees_player(/*goto*/ 0x70)
	goto_first(0x68)

	label(0x70)
	goto_first(0x6a)

	label(0x72)
	restart_timer

	beginloop(0x73)
		if_chr_sees_player(/*goto*/ 0x70)
		if_timer_gt(300, /*goto*/ 0x06)
	endloop(0x73)

	label(0x06)
	goto_first(0x68)

	label(0x70)
	goto_first(0x6a)

	label(0x6c)
	say_quip(CHR_BOND, 0x00, 0x19, 0x02, 0x01, BANK_0, 0x00, 0x00)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x06)
	label(0x06)
	goto_first(0x6d)

	label(0x2d)
	goto_first(0x6e)

	label(0x76)
	try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x74)
	label(0x74)
	say_quip(CHR_BOND, 0x00, 0x19, 0x02, 0x01, BANK_0, 0x00, 0x00)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x06)
	goto_next(0x2d)
	label(0x06)
	goto_first(0x6d)

	label(0x2d)
	goto_first(0x6e)

	endlist
};

u8 func0421_trent_waiting[] = {
	set_chr_team(CHR_SELF, TEAM_04)
	rebuild_teams
	rebuild_squadrons
	set_self_chrflag(CHRCFLAG_00000040)
	set_shield(500)
	set_chr_chrflag(CHR_TRENT, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	restart_timer
	speak(CHR_TARGET, L_RIT(45), 0x816f, CHANNEL_6, COLOR_05_GREEN) // "How the hell did you get on board?"
	chr_do_animation(ANIM_TALKING_0231, 0, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	set_ailist(CHR_SELF, AILIST_TRENT_ATTACKING)
	endlist
};

u8 func0420_trent_attacking[] = {
	label(0x03)
	stop_chr

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		try_unset_chr_flag_bank3_02000000(CHR_SELF, /*goto*/ 0x2d)
		set_target_chr(CHR_PRESIDENT)
		if_target_in_sight(/*goto*/ 0x06)
		if_stage_flag_eq(STAGEFLAG_ONE_BLONDE_DEAD, TRUE, /*goto*/ 0x2d)
	endloop(0x04)

	// One Blonde dead or player in sight
	label(0x2d)
	set_shield(500)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_10000000)
	speak(CHR_P1P2, L_RIT(70), 0x12cb, CHANNEL_6, COLOR_05_GREEN) // "Ha, Ha, Ha, Ha, Ha."
	set_ailist(CHR_SELF, AILIST_TRENT_RUNNING)

	// President in sight
	label(0x06)
	label(0x76)
	try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x74)
	label(0x74)
	say_quip(CHR_BOND, 0x00, 0x19, 0x02, 0x01, BANK_0, 0x00, 0x00)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x08)
	goto_next(0x2d)

	beginloop(0x08)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	if_chr_dying(CHR_TARGET, /*goto*/ 0x09)
	if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x09)
	if_chr_unloaded(CHR_TARGET, /*goto*/ 0x09)
	goto_first(0x03)

	label(0x2d)
	goto_first(0x03)

	label(0x09)
	restart_timer
	chr_do_animation(ANIM_TALKING_0231, 0, -1, 0x10, 0x10, CHR_SELF, 2)
	speak(CHR_P1P2, L_RIT(71), 0x12ca, CHANNEL_6, COLOR_05_GREEN) // "You'll never save him now."

	beginloop(0x0a)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	set_ailist(CHR_SELF, AILIST_TRENT_RUNNING)
	endlist
};

u8 func0422_trent_running[] = {
	run_to_pad(0x0034)

	beginloop(0x08)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	set_target_chr(CHR_BOND)
	if_chr_sees_player(/*goto*/ 0x06)
	set_target_chr(CHR_COOP)
	if_chr_sees_player(/*goto*/ 0x06)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	remove_chr(CHR_SELF)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	set_alertness(100)
	set_returnlist(CHR_SELF, GAILIST_UNALERTED)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func1012_check_blondes_dead[] = {
	beginloop(0x04)
		if_chr_dying(CHR_BLONDE1, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_BLONDE1, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_BLONDE1, /*goto*/ 0x2d)

		if_chr_dying(CHR_BLONDE2, /*goto*/ 0x06)
		if_chr_death_animation_finished(CHR_BLONDE2, /*goto*/ 0x06)
		if_chr_unloaded(CHR_BLONDE2, /*goto*/ 0x06)
		reloop(0x04)

		// Blonde 2 dead
		label(0x06)
		set_stage_flag(STAGEFLAG_ONE_BLONDE_DEAD)
		reloop(0x04)

		// Blonde 1 dead
		label(0x2d)
		set_stage_flag(STAGEFLAG_ONE_BLONDE_DEAD)
		if_chr_dying(CHR_BLONDE2, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_BLONDE2, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_BLONDE2, /*goto*/ 0x2d)
	endloop(0x04)

	// Both blondes dead
	label(0x2d)
	set_stage_flag(STAGEFLAG_BOTH_BLONDES_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1013_unhide_trent_and_blondes[] = {
	yield
	hide_chr(CHR_TRENT)
	hide_chr(CHR_BLONDE1)
	hide_chr(CHR_BLONDE2)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_stage_flag_eq(STAGEFLAG_PRESIDENT_STARTED_RUNNING, TRUE, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_y(CHR_P1P2, 190, OPERATOR_LESS_THAN, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	show_chr(CHR_TRENT)
	set_ailist(CHR_TRENT, AILIST_TRENT_WAITING)
	show_chr(CHR_BLONDE1)
	set_ailist(CHR_BLONDE1, AILIST_INIT_BLONDE)
	show_chr(CHR_BLONDE2)
	set_ailist(CHR_BLONDE2, AILIST_INIT_BLONDE)
	yield
	unset_chr_chrflag(CHR_TRENT, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BLONDE1, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BLONDE2, CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Assigned to basically everyone during president conversation.
 */
u8 func0429_be_unalert[] = {
	set_shotlist(GAILIST_ALERTED)
	set_target_chr(CHR_BOND)
	set_alertness(0)

	label(0x03)
	try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x04)

	beginloop(0x04)
		if_chr_stopped(/*goto*/ 0x06)
		if_chr_dying(CHR_PRESIDENT, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_PRESIDENT, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_PRESIDENT, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x06)
	goto_first(0x03)

	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

/**
 * Would have given the player one minute before the diguise was uncovered.
 * The set_ailist at the start has effectively disabled this function.
 */
u8 func1014_uncover_disguise[] = {
	set_ailist(CHR_SELF, GAILIST_IDLE)
	restart_timer

	beginloop(0x04)
		if_timer_gt(3600, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISE_UNCOVERED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Assigned to presidential security as well as the two mechanics.
 */
u8 func042a_init_neutral[] = {
	yield

	beginloop(0x60)
		if_camera_animating(/*goto*/ 0x77)
		goto_next(0x06)

		label(0x77)
	endloop(0x60)

	label(0x06)
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	set_chr_dodge_rating(2, 0x00)
	set_accuracy(14)
	set_reaction_speed(70)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func042b_reinit_stripes[] = {
	set_chr_dodge_rating(2, 0x00)
	set_accuracy(14)
	set_reaction_speed(50)
	set_chr_maxdamage(CHR_SELF, 60)
	add_health_or_armor(0)
	set_recovery_speed(30)
	set_shield(0)
	set_chr_team(CHR_SELF, TEAM_04)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, AILIST_STRIPES)
	endlist
};

u8 func0407_steward[] = {
	set_shotlist(AILIST_STEWARD_SHOT)

	beginloop(0x03)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_idle(/*goto*/ 0x2d)
		call_rng
		if_rand_lt(32, /*goto*/ 0x0f)
		call_rng
		if_rand_lt(32, /*goto*/ 0x8a)
		if_rand_lt(64, /*goto*/ 0x8b)
		if_rand_lt(96, /*goto*/ 0x8c)
		if_rand_lt(128, /*goto*/ 0x8d)
		if_rand_lt(160, /*goto*/ 0x8e)
		if_rand_lt(192, /*goto*/ 0x8f)
		if_rand_lt(224, /*goto*/ 0x90)

		chr_do_animation(ANIM_OPERATE_0221, -1, -1, 0x10, 0x01, CHR_SELF, 2)
		goto_next(0x2d)

		label(0x8a)
		chr_do_animation(ANIM_OPERATE_0221, -1, -1, 0x10, 0x01, CHR_SELF, 2)
		goto_next(0x2d)

		label(0x8b)
		chr_do_animation(ANIM_OPERATE_0223, -1, -1, 0x10, 0x01, CHR_SELF, 2)
		goto_next(0x2d)

		label(0x8c)
		chr_do_animation(ANIM_OPERATE_0221, -1, -1, 0x11, 0x01, CHR_SELF, 2)
		goto_next(0x2d)

		label(0x8d)
		chr_do_animation(ANIM_OPERATE_0221, -1, -1, 0x11, 0x01, CHR_SELF, 2)
		goto_next(0x2d)

		label(0x8e)
		chr_do_animation(ANIM_OPERATE_0223, -1, -1, 0x11, 0x01, CHR_SELF, 2)
		goto_next(0x2d)

		label(0x8f)
		chr_do_animation(0x023a, -1, -1, 0x11, 0x01, CHR_SELF, 2)
		goto_next(0x2d)

		label(0x90)
		chr_do_animation(0x023b, -1, -1, 0x11, 0x01, CHR_SELF, 2)
		goto_next(0x2d)

		label(0x0f)
		call_rng
		if_rand_lt(86, /*goto*/ 0x60)
		if_rand_lt(172, /*goto*/ 0x77)

		if_chr_distance_to_pad_lt(CHR_SELF, 50, 0x00c1, /*goto*/ 0x60)
		label(0x79)
		walk_to_pad(0x00c1)
		set_morale(1)
		set_padpreset(0x00c2)
		goto_next(0x87)

		label(0x60)
		if_chr_distance_to_pad_lt(CHR_SELF, 50, 0x00c3, /*goto*/ 0x77)
		walk_to_pad(0x00c3)
		set_morale(2)
		set_padpreset(0x00c4)
		goto_next(0x87)

		label(0x77)
		if_chr_distance_to_pad_lt(CHR_SELF, 50, 0x00c1, /*goto*/ 0x78)
		set_morale(3)
		set_padpreset(0x00c6)
		walk_to_pad(0x00c5)
		goto_next(0x87)

		label(0x78)
		goto_first(0x79)

		beginloop(0x87)
			chr_toggle_p1p2(CHR_SELF)
			set_target_chr(CHR_P1P2)
			if_target_in_sight(/*goto*/ 0x89)
			if_saw_injury(0x00, /*goto*/ 0x89)
			if_chr_stopped(/*goto*/ 0x06)
		endloop(0x87)

		label(0x06)
		try_face_entity(ENTITYTYPE_PAD, PAD_PRESET, /*goto*/ 0x88)

		beginloop(0x88)
			if_chr_stopped(/*goto*/ 0x06)
		endloop(0x88)

		label(0x06)
		reloop(0x03)

		chr_do_animation(ANIM_OPERATE_0204, 0, -1, 0x10, 0x10, CHR_SELF, 2)
		label(0x2d)
		if_target_in_sight(/*goto*/ 0x89)
		if_saw_injury(0x00, /*goto*/ 0x89)
	endloop(0x03)

	// Detected player
	label(0x89)
	set_alertness(100)
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	increase_squadron_alertness(100)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISE_UNCOVERED)
	do_preset_animation(-1)
	restart_timer
	speak(CHR_P1P2, L_RIT(43), 0x1abb, CHANNEL_4, COLOR_04_ORANGE) // "Hey, that's not..."

	beginloop(0x08)
		if_timer_gt(35, /*goto*/ 0x2d)
	endloop(0x08)

	label(0x2d)
	mute_channel(CHANNEL_4)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0407_steward_shot[] = {
	mute_channel(CHANNEL_4)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

u8 func0407_stewardess[] = {
	set_chr_maxdamage(CHR_SELF, 0)
	set_shotlist(AILIST_STEWARDESS)
	if_chr_dying(CHR_SELF, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x03)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Wait until alerted
	beginloop(0x03)
		if_chr_idle(/*goto*/ 0x2d)
		chr_do_animation(ANIM_OPERATE_0204, 0, -1, 0x10, 0x10, CHR_SELF, 2)
		label(0x2d)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x2d)
		if_saw_injury(0x00, /*goto*/ 0x2d)
		if_chr_dying(CHR_STEWARD, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_STEWARD, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_STEWARD, /*goto*/ 0x2d)
	endloop(0x03)

	// Alerted
	label(0x2d)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISE_UNCOVERED)
	chr_do_animation(ANIM_WALK_BACKWARDS, -1, -1, 0x10, 0x10, CHR_SELF, 2)
	restart_timer

	beginloop(0x08)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	try_set_chrpreset_to_unalerted_teammate(0, /*goto*/ 0x2d)
	goto_next(0x0a)

	label(0x2d)
	try_run_to_chr(CHR_PRESET, /*goto*/ 0x7f)

	beginloop(0x7f)
		if_detected_chr(CHR_PRESET, /*goto*/ 0x80)
		if_chr_stopped(/*goto*/ 0x80)
	endloop(0x7f)

	label(0x80)
	play_sound(0x1adc, CHANNEL_7)
	increase_squadron_alertness(100)

	label(0x0a)
	set_self_chrflag(CHRCFLAG_01000000)
	chr_do_animation(ANIM_COWER_0229, -1, 190, 0x10, 0x0a, CHR_SELF, 2)

	beginloop(0x83)
		if_chr_stopped(/*goto*/ 0x2d)
	endloop(0x83)

	label(0x2d)
	goto_first(0x0a)

	endlist
};

u8 func1015_msg_retrievetheevidence[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0e)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_INTRO_FINISHED, TRUE, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	restart_timer

	beginloop(0x08)
		if_timer_gt(180, /*goto*/ 0x2d)
	endloop(0x08)

	label(0x2d)
	speak(CHR_BOND, L_RIT(46), 0x73c8, CHANNEL_6, COLOR_09_BLUE) // "Now, let's retrieve the evidence."
	label(0x0e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1016_msg_onthislevel[] = {
	restart_timer

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_y(CHR_P1P2, 440, OPERATOR_LESS_THAN, /*goto*/ 0x06)
		goto_next(0x2d)

		label(0x06)
	endloop(0x04)

	label(0x2d)
	set_target_chr(CHR_PRESET)
	speak(CHR_TARGET, L_RIT(47), 0x8185, CHANNEL_6, COLOR_09_BLUE) // "The President's room is on this level, Joanna."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1017_msg_gettothecockpit[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_ALL_OBJECTIVES_COMPLETE, TRUE, /*goto*/ 0x0e)
		if_stage_flag_eq(STAGEFLAG_PILOTS_DEAD, TRUE, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_stage_flag_eq(STAGEFLAG_PLANE_NOSEDIVING, TRUE, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	restart_timer

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_ALL_OBJECTIVES_COMPLETE, TRUE, /*goto*/ 0x0e)
		if_timer_gt(180, /*goto*/ 0x2d)
	endloop(0x08)

	label(0x2d)
	speak(CHR_BOND, L_RIT(48), 0x8186, CHANNEL_5, COLOR_09_BLUE) // "Something's wrong... You have to get to the cockpi..."

	label(0x0e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1018_msg_maybeamine[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_ALL_OBJECTIVES_COMPLETE, TRUE, /*goto*/ 0x0e)
		chr_toggle_p1p2(CHR_SELF)
		if_objective_complete(2, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0018, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	speak(CHR_P1P2, L_RIT(49), 0x73cb, CHANNEL_6, COLOR_09_BLUE) // "Maybe a mine will detach the UFO."

	label(0x0e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0c02_outro_from_menu[] = {
	set_ailist(CHR_ELVIS, GAILIST_IDLE)
	set_ailist(CHR_SELF, AILIST_OUTRO)
	endlist
};

u8 func0423_outro[] = {
	misc_command(0x0000, 0x0d, 0x00)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2d)
	set_target_chr(CHR_BOND)
	goto_next(0x06)
	label(0x2d)
	set_target_chr(CHR_COOP)
	label(0x06)
	camera_movement(0x02d8)
	set_music_track(MUSIC_AIRFORCEONE_OUTRO)
	misc_command(0x0000, 0x0d, 0x00)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0xf1, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)
	set_ailist(CHR_TARGET, GAILIST_IDLE)
	set_chr_chrflag(CHR_TARGET, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_TARGET, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_TARGET, CHRHFLAG_00020000)
	chr_do_animation(0x02da, -1, -1, 0x06, 0x00, CHR_TARGET, 4)
	set_chr_hudpiece_visible(CHR_TARGET, TRUE)
	set_chr_chrflag(CHR_ELVIS, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_ELVIS, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_ELVIS, CHRHFLAG_00020000)
	chr_do_animation(0x02d9, -1, -1, 0x06, 0x00, CHR_ELVIS, 4)
	show_object(0x19)
	set_object_flag2(0x19, OBJFLAG2_04000000)
	set_object_flag3(0x19, OBJFLAG3_00000010)
	object_do_animation(0x02db, 0x19, 0x04, 0xffff)
	show_object(0x1a)
	set_object_flag2(0x1a, OBJFLAG2_04000000)
	set_object_flag3(0x1a, OBJFLAG3_00000010)
	object_do_animation(0x02dc, 0x1a, 0x04, 0xffff)
	show_object(0x23)
	set_object_flag2(0x23, OBJFLAG2_04000000)
	set_object_flag3(0x23, OBJFLAG3_00000010)
	object_do_animation(0x02dd, 0x23, 0x04, 0xffff)
	show_object(0x37)
	set_object_flag2(0x37, OBJFLAG2_04000000)
	set_object_flag3(0x37, OBJFLAG3_00000010)
	object_do_animation(0x02de, 0x37, 0x04, 0xffff)
	restart_timer
	set_cutscene_weapon(CHR_TARGET, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_TARGET, WEAPON_NONE, WEAPON_NONE)
	show_nonessential_chrs(FALSE)
	label(0x60)
	yield
	if_controller_button_pressed(/*goto*/ 0x5f)
	if_timer_gt(20, /*goto*/ 0x06)
	goto_first(0x60)

	label(0x06)
	speak(CHR_BOND, L_RIT(79), 0x7452, CHANNEL_7, COLOR_09_BLUE) // "Elvis! Elvis! I can't detach that tube from the fu..."

	#define outro_wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0x5f) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)



	outro_wait_until(426, 0x77)
	speak(CHR_BOND, L_RIT(80), 0x7453, CHANNEL_7, COLOR_06_WHITE) // "Piece of cake, Joanna. Watch this!"

	outro_wait_until(1045, 0x65)
	play_sound(0x0063, CHANNEL_10)

	outro_wait_until(1050, 0x78)
	speak(CHR_BOND, L_RIT(81), 0x7454, CHANNEL_7, COLOR_06_WHITE) // "Uh-oh."
	emit_sparks(0x23)

	outro_wait_until(1112, 0x79)
	speak(CHR_BOND, L_RIT(82), 0x7455, CHANNEL_7, COLOR_09_BLUE) // "Watch what? Will you stop playing around and shoot..."

	outro_wait_until(1380, 0x7a)
	speak(CHR_BOND, L_RIT(83), 0x7456, CHANNEL_7, COLOR_06_WHITE) // "Out of options... Joanna, brace yourself for impac..."

	outro_wait_until(1950, 0x7b)

	outro_wait_until(1951, 0x62)
	destroy_object(0x1a)

	outro_wait_until(1958, 0x63)
	destroy_object(0x1a)

	outro_wait_until(1970, 0x64)
	destroy_object(0x1a)
	destroy_object(0x19)

	outro_wait_until(1985, 0x8e)
	destroy_object(0x1a)

	outro_wait_until(2000, 0x8a)
	destroy_object(0x1a)

	outro_wait_until(2015, 0x8b)
	destroy_object(0x1a)

	outro_wait_until(2030, 0x8c)
	destroy_object(0x1a)

	outro_wait_until(2045, 0x8d)
	destroy_object(0x1a)

	outro_wait_until(2060, 0x8f)
	destroy_object(0x1a)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x5f)

		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x5f)
		label(0x2d)
	endloop(0x08)

	label(0x5f)
	mute_channel(CHANNEL_10)
	label(0x06)
	restart_default_music
	misc_command(0x0000, 0x0d, 0x00)
	hide_object(0x19)
	hide_object(0x1a)
	set_chr_hudpiece_visible(CHR_TARGET, FALSE)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1019_midcutscene[] = {
	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_MIDCUTSCENE, TRUE, /*goto*/ 0x2d)
	endloop(0x08)

	label(0x2d)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	if_stage_flag_eq(STAGEFLAG_MIDCUTSCENE_STARTED, TRUE, /*goto*/ 0x2d)
	set_stage_flag(STAGEFLAG_MIDCUTSCENE_STARTED)
	dprint 'm','i','d',' ','c','u','t','s','c','e','n','e','\n',0,
	set_music_track(MUSIC_AIRFORCEONE_MIDCUTSCENE)
	label(0x2d)
	camera_movement(0x02df)

	show_object(0x19)
	set_object_flag2(0x19, OBJFLAG2_04000000)
	set_object_flag3(0x19, OBJFLAG3_00000010)
	object_do_animation(0x02e0, 0x19, 0x04, 0xffff)
	set_object_part_visible(0x19, TRUE)

	show_object(0x37)
	set_object_flag2(0x37, OBJFLAG2_04000000)
	set_object_flag3(0x37, OBJFLAG3_00000010)
	object_do_animation(0x02e1, 0x37, 0x04, 0xffff)

	restart_timer

	outro_wait_until(1086, 0x61)
	play_sound(0x042c, -1)

	beginloop(0x09)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x5f)

		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x5f)
		label(0x2d)
	endloop(0x09)

	label(0x5f)
	hide_object(0x37)
	hide_object(0x19)
	label(0x06)
	set_stage_flag(STAGEFLAG_MIDCUTSCENE_FINISHED)
	restart_default_music
	reset_ambience
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_END_CINEMA)
	endlist
};

u8 func1019_midcutscene_from_menu[] = {
	set_stage_flag(STAGEFLAG_TRIGGER_MIDCUTSCENE)
	set_ailist(CHR_SELF, AILIST_MIDCUTSCENE)
	endlist
};

u8 func101a_equipment_switch[] = {
	set_object_flag(0x1b, OBJFLAG_DEACTIVATED)
	set_object_image(OBJ_EQUIPMENT_SWITCH, 0x00, 0x12)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_EQUIPMENT_SWITCH, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_has_object(CHR_P1P2, OBJ_KEYCARD, /*goto*/ 0x2d)

		restart_timer
		show_hudmsg(CHR_P1P2, L_RIT(63)) // "Access denied - lift key card required."

		beginloop(0x77)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x77)

		label(0x06)
	endloop(0x04)

	// Switch activated with keycard
	label(0x2d)
	set_object_image(OBJ_EQUIPMENT_SWITCH, 0x00, 0x13)
	set_stage_flag(STAGEFLAG_EQUIPMENT_RAISED)
	open_door(0x1c)
	show_hudmsg(CHR_P1P2, L_RIT(61)) // "Cargo bay has been raised."
	assign_sound(0x043a, CHANNEL_7)
	control_sound_from_object(CHANNEL_7, OBJ_EQUIPMENT_SWITCH, TRUE)
	unset_object_flag(0x1b, OBJFLAG_DEACTIVATED)
	yield
	yield
	yield
	yield
	yield
	yield
	restart_timer

	beginloop(0x08)
		if_lift_stationary(0x1b, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	set_object_flag(0x1b, OBJFLAG_DEACTIVATED)
	set_object_image(OBJ_EQUIPMENT_SWITCH, 0x00, 0x12)

	beginloop(0x09)
		if_door_state(0x1c, DOORSTATE_CLOSING, /*goto*/ 0x2d)
		reloop(0x09)

		label(0x2d)
		open_door(0x1c)
	endloop(0x09)

	endlist
};

u8 func101b_hoverbike_switch[] = {
	unset_savefile_flag(SAVEFILEFLAG_CRASHSITE_BIKE)
	set_object_flag(0x1f, OBJFLAG_DEACTIVATED)
	set_object_image(OBJ_HOVERBIKE_SWITCH, 0x00, 0x12)
	label(0x08)
	open_door(0x20)

	beginloop(0x09)
		chr_toggle_p1p2(CHR_SELF)
		if_door_state(0x20, DOORSTATE_CLOSING, /*goto*/ 0x2d)
		if_chr_activated_object(CHR_P1P2, OBJ_HOVERBIKE_SWITCH, /*goto*/ 0x0a)
		reloop(0x09)

		label(0x2d)
		open_door(0x20)
		reloop(0x09)

		label(0x0a)
		if_chr_has_object(CHR_P1P2, OBJ_KEYCARD, /*goto*/ 0x2d)
		restart_timer
		show_hudmsg(CHR_P1P2, L_RIT(63)) // "Access denied - lift key card required."

		beginloop(0x77)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x77)

		label(0x06)
	endloop(0x09)

	// Activated with keycard
	label(0x2d)
	set_object_image(OBJ_HOVERBIKE_SWITCH, 0x00, 0x13)
	show_hudmsg(CHR_P1P2, L_RIT(60)) // "Cargo bay has been lowered."
	set_savefile_flag(SAVEFILEFLAG_CRASHSITE_BIKE)
	assign_sound(0x043a, CHANNEL_7)
	control_sound_from_object(CHANNEL_7, OBJ_HOVERBIKE_SWITCH, TRUE)
	unset_object_flag(0x1f, OBJFLAG_DEACTIVATED)
	restart_timer

	beginloop(0x0c)
		if_timer_gt(2, /*goto*/ 0x2d)
	endloop(0x0c)

	label(0x2d)
	close_door(0x20)

	beginloop(0x0b)
		if_lift_stationary(0x1f, /*goto*/ 0x06)
	endloop(0x0b)

	label(0x06)
	set_object_flag(0x1f, OBJFLAG_DEACTIVATED)
	set_object_image(OBJ_HOVERBIKE_SWITCH, 0x00, 0x12)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101c_check_equipment_switch_destroyed[] = {
	beginloop(0x04)
		if_object_in_good_condition(OBJ_EQUIPMENT_SWITCH, /*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
	endloop(0x04)

	label(0x06)
	if_stage_flag_eq(STAGEFLAG_EQUIPMENT_RAISED, TRUE, /*goto*/ 0x2d)
	set_stage_flag(STAGEFLAG_EQUIPMENT_SWITCH_DESTROYED)
	show_hudmsg(CHR_BOND, L_RIT(62)) // "Mission critical object has been destroyed."
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040c_init_defend_pad[] = {
	unset_chr_hiddenflag(CHR_SELF, CHRHFLAG_40000000)
	set_chr_team(CHR_SELF, TEAM_ALLY)
	rebuild_teams
	rebuild_squadrons
	set_target_chr(-1)
	label(0x04)
	try_equip_weapon(MODEL_CHRCYCLONE, WEAPON_CYCLONE, 0x00000000, /*goto*/ 0x2d)
	label(0x2d)
	set_ailist(CHR_SELF, AILIST_DEFEND_PAD)
	endlist
};

u8 func040e_unused[] = {
	label(0x04)
	try_equip_weapon(MODEL_CHRCYCLONE, WEAPON_CYCLONE, 0x00000000, /*goto*/ 0x2d)
	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

/**
 * Unused.
 */
u8 func040d_init_defend_president[] = {
	label(0x04)
	try_equip_weapon(MODEL_CHRCYCLONE, WEAPON_CYCLONE, 0x00000000, /*goto*/ 0x2d)
	label(0x2d)
	set_ailist(CHR_SELF, AILIST_DEFEND_PRESIDENT)
	endlist
};

u8 func042c_remove_if_offscreen[] = {
	unset_chr_hiddenflag(CHR_SELF, CHRHFLAG_40000000)
	set_chr_team(CHR_SELF, TEAM_ALLY)
	rebuild_teams
	rebuild_squadrons
	set_chr_maxdamage(CHR_SELF, 0)

	label(0x04)
	yield
	set_target_chr(CHR_BOND)
	if_chr_sees_player(/*goto*/ 0x06)
	set_target_chr(CHR_COOP)
	if_chr_sees_player(/*goto*/ 0x06)
	label(0x08)
	chr_drop_weapon(CHR_SELF)
	remove_chr(CHR_SELF)
	yield
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	set_ailist(CHR_SELF, AILIST_INIT_DEFEND_PAD)
	endlist
};

/**
 * If president dies between mid cutscene and Jo's "we have to get you to the
 * escape pod" line, set the flag that causes things to happen.
 *
 * This was most likely added after QA, hence why the original function wasn't
 * changed instead.
 */
u8 func101d_handle_early_president_death[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_MIDCUTSCENE_FINISHED, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	hide_object(OBJ_EXTERIOR_DOOR)
	unset_object_flag2(OBJ_EXTERIOR_DOOR_DETACHED, OBJFLAG2_INVISIBLE)
	set_object_flag(OBJ_EXTERIOR_DOOR_DETACHED, OBJFLAG_00000100)

	beginloop(0x08)
		if_chr_death_animation_finished(CHR_PRESIDENT, /*goto*/ 0x2d)
		if_chr_dying(CHR_PRESIDENT, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_PRESIDENT, /*goto*/ 0x2d)
	endloop(0x08)

	label(0x2d)
	set_stage_flag(STAGEFLAG_PRESIDENT_STARTED_RUNNING)
	unlock_door(OBJ_COCKPITDOOR, 0x40)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1007_check_pod_destroyed[] = {
	beginloop(0x04)
		if_object_in_good_condition(OBJ_ESCAPE_POD, /*goto*/ 0x2d)
		show_hudmsg(CHR_BOND, L_RIT(62)) // "Mission critical object has been destroyed."
		set_stage_flag(STAGEFLAG_POD_DESTROYED)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x2d)
	endloop(0x04)

	endlist
};

u8 func101f_setup_rtracker[] = {
	yield
	set_object_flag3(0x38, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(0x39, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1420_setup_lighting[] = {
	yield
	misc_command(0x001a, 0x05, 0x01)
	misc_command(0x001b, 0x05, 0x01)
	misc_command(0x002b, 0x05, 0x01)
	misc_command(0x002d, 0x05, 0x01)
	misc_command(0x002e, 0x05, 0x01)
	misc_command(0x002f, 0x05, 0x01)
	misc_command(0x0030, 0x05, 0x01)
	misc_command(0x0031, 0x05, 0x01)
	misc_command(0x0032, 0x05, 0x01)
	misc_command(0x0033, 0x05, 0x01)
	misc_command(0x0034, 0x05, 0x01)
	misc_command(0x0035, 0x05, 0x01)
	misc_command(0x0036, 0x05, 0x01)
	misc_command(0x0037, 0x05, 0x01)
	misc_command(0x0038, 0x05, 0x01)
	misc_command(0x0039, 0x05, 0x01)
	misc_command(0x003b, 0x05, 0x01)
	misc_command(0x003c, 0x05, 0x01)
	misc_command(0x003e, 0x05, 0x01)
	misc_command(0x003f, 0x05, 0x01)
	misc_command(0x0040, 0x05, 0x01)
	misc_command(0x0041, 0x05, 0x01)
	misc_command(0x0042, 0x05, 0x01)
	misc_command(0x0043, 0x05, 0x01)
	misc_command(0x0059, 0x05, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1022_pilots_stabilizing[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_PLANE_NOSEDIVING, TRUE, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	restart_timer

	beginloop(0x93)
		if_chr_death_animation_finished(CHR_PILOT1, /*goto*/ 0x2e)
		if_chr_death_animation_finished(CHR_PILOT1, /*goto*/ 0x2e)
		if_chr_death_animation_finished(CHR_PILOT1, /*goto*/ 0x2e)
		goto_next(0x06)

		label(0x2e)
		if_chr_death_animation_finished(CHR_PILOT2, /*goto*/ 0x0e)
		if_chr_death_animation_finished(CHR_PILOT2, /*goto*/ 0x0e)
		if_chr_death_animation_finished(CHR_PILOT2, /*goto*/ 0x0e)

		// Pilots stabilizing
		label(0x06)
		if_stage_flag_eq(STAGEFLAG_PLANE_STABILIZED, TRUE, /*goto*/ 0x0e)
		if_timer_gt(1200, /*goto*/ 0x06)
	endloop(0x93)

	label(0x06)
	show_hudmsg(CHR_BOND, L_RIT(84)) // "The pilots have stabilized Air Force One."
	set_stage_flag(STAGEFLAG_PLANE_STABILIZED)

	label(0x0e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1023_check_pilots_dead[] = {
	beginloop(0x04)
		if_chr_death_animation_finished(CHR_PILOT1, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_PILOT1, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_PILOT1, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_death_animation_finished(CHR_PILOT2, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_PILOT2, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_PILOT2, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	set_stage_flag(STAGEFLAG_PILOTS_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Wait until intro finished, then wait several frames before unsetting a flag
 * on Joanna.
 *
 * When the flag is set, the co-op buddy will attempt to warp to Jo. This is
 * needed because Jo can start in two locations in this level, but the buddy
 * only starts in one location.
 *
 * The flag must be unset so the buddy stops attempting to warp.
 */
u8 func1025_disable_buddy_warp[] = {
	yield

	beginloop(0x04)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
	endloop(0x04)

	label(0x06)
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	unset_chr_hiddenflag(CHR_BOND, CHRHFLAG_TRIGGER_BUDDY_WARP)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1026_buddy_floor_hatch[] = {
	yield

	beginloop(0x93)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x04)

		label(0x2d)
	endloop(0x93)

	// This flag is set by a global function
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_AI_BUDDY_EXISTS, TRUE, /*goto*/ 0x2d)
	endloop(0x04)

	// Maybe the AI has difficulty opening the floor hatch so they removed it?
	label(0x2d)
	hide_object(OBJ_FLOORHATCH)
	set_object_flag(OBJ_FLOOR_HATCH_DETACHED, OBJFLAG_00000100)
	unset_object_flag2(OBJ_FLOOR_HATCH_DETACHED, OBJFLAG2_INVISIBLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

struct ailist ailists[] = {
	{ func1400_setup_counterop,                        0x1400 },
	{ func1001_objectives_failed_msg,                  0x1001 },
	{ func1002_intro,                                  0x1002 },
	{ func1003_rebuild_groups,                         0x1003 },
	{ func1004_reassign_ailists_during_conversation, 0x1004 },
	{ func1005_check_neutrals_killed,                  0x1005 },
	{ func1006_hijack,                                 0x1006 },
	{ func1007_check_pod_destroyed,                    0x1007 },
	{ func1008_check_mine_wasted_bond,                 0x1008 },
	{ func1009_check_end_level,                        0x1009 },
	{ func100a_autopilot_switch,                       0x100a },
	{ func100b_check_president_dead,                   0x100b },
	{ func100c_cockpit,                                0x100c },
	{ func1010_dumbwaiter1,                            0x1010 },
	{ func1011_dumbwaiter2,                            0x1011 },
	{ func1012_check_blondes_dead,                     0x1012 },
	{ func1013_unhide_trent_and_blondes,               0x1013 },
	{ func1014_uncover_disguise,                       0x1014 },
	{ func1015_msg_retrievetheevidence,                0x1015 },
	{ func1016_msg_onthislevel,                        0x1016 },
	{ func1017_msg_gettothecockpit,                    0x1017 },
	{ func1018_msg_maybeamine,                         0x1018 },
	{ func1019_midcutscene,                            0x1019 },
	{ func101a_equipment_switch,                       0x101a },
	{ func101b_hoverbike_switch,                       0x101b },
	{ func101c_check_equipment_switch_destroyed,       0x101c },
	{ func101d_handle_early_president_death,           0x101d },
	{ func101e_blow_mines,                             0x101e },
	{ func101f_setup_rtracker,                         0x101f },
	{ func1420_setup_lighting,                         0x1420 },
	{ func1021_check_mine_wasted_coop,                 0x1021 },
	{ func1022_pilots_stabilizing,                     0x1022 },
	{ func1023_check_pilots_dead,                      0x1023 },
	{ func1024_give_objects,                           0x1024 },
	{ func1025_disable_buddy_warp,                     0x1025 },
	{ func1026_buddy_floor_hatch,                      0x1026 },
	{ func1002_intro,                                  0x0c00 },
	{ func1019_midcutscene_from_menu,                  0x0c01 },
	{ func0c02_outro_from_menu,                        0x0c02 },
	{ func0401_init_stripes,                           0x0401 },
	{ func0402_init_elvis,                             0x0402 },
	{ func0403_stripes,                                0x0403 },
	{ func0404_president_running,                      0x0404 },
	{ func0405_president_in_room,                      0x0405 },
	{ func0406_init_president,                         0x0406 },
	{ func0407_steward,                                0x0407 },
	{ func0407_stewardess,                             0x0408 },
	{ func1019_midcutscene,                            0x0424 },
	{ func0409_unused,                                 0x0409 },
	{ func040a_defend_pad,                             0x040a },
	{ func040b_defend_president,                       0x040b },
	{ func040c_init_defend_pad,                        0x040c },
	{ func040d_init_defend_president,                  0x040d },
	{ func040e_unused,                                 0x040e },
	{ func0413_taker,                                  0x0413 },
	{ func100c_cockpit_stripes,                        0x0414 },
	{ func0413_taker1,                                 0x040f },
	{ func0413_taker2,                                 0x0410 },
	{ func0413_taker,                                  0x0413 },
	{ func0411_typing_guy,                             0x0411 },
	{ func0412_sitting_guy,                            0x0412 },
	{ func0426_start_path00,                           0x0426 },
	{ func0427_start_path01,                           0x0427 },
	{ func0428_start_path02,                           0x0428 },
	{ func0429_be_unalert,                             0x0429 },
	{ func042a_init_neutral,                           0x042a },
	{ func042b_reinit_stripes,                         0x042b },
	{ func042c_remove_if_offscreen,                    0x042c },
	{ func0415_cloner1,                                0x0415 },
	{ func0416_init_clone1,                            0x0416 },
	{ func0417_clone1,                                 0x0417 },
	{ func0418_cloner2,                                0x0418 },
	{ func0419_init_clone2,                            0x0419 },
	{ func041a_clone2,                                 0x041a },
	{ func041b_cloner3,                                0x041b },
	{ func041c_init_clone3,                            0x041c },
	{ func041d_clone3,                                 0x041d },
	{ func041e_blonde,                                 0x041e },
	{ func041f_init_blonde,                            0x041f },
	{ func0420_trent_attacking,                        0x0420 },
	{ func0421_trent_waiting,                          0x0421 },
	{ func0422_trent_running,                          0x0422 },
	{ func0423_outro,                                  0x0423 },
	{ func0407_steward_shot,                           0x0425 },
	{ NULL, 0 },
};

struct path paths[] = {
	{ path00, 0, PATHTYPE_BACKANDFORTH },
	{ path01, 1, PATHTYPE_BACKANDFORTH },
	{ path02, 2, PATHTYPE_BACKANDFORTH },
	{ NULL, 0, 0 },
};

