//
// Chicago
//

#include "stagesetup.h"

// Characters
#define CHR_TOPSTAIRS 0x07
#define CHR_SEALER1   0x0d
#define CHR_SEALER2   0x0e
#define CHR_SEALER3   0x0f
#define CHR_SEALER4   0x10
#define CHR_FBI1      0x17
#define CHR_FBI2      0x18
#define CHR_FBI3      0x19
#define CHR_CIA1      0x1a
#define CHR_CIA2      0x1b // bug spotter
#define CHR_CIA3      0x1c
#define CHR_CIA4      0x1d
#define CHR_HIDDENGUY 0x1e // positioned just behind Jo's starting place, never unhidden, and used for distance checks and something related to the robot
#define CHR_ROBOT     0x1f

// Objects
#define OBJ_CAR1           0x00
#define OBJ_CAR2           0x01
#define OBJ_CAR3           0x02
#define OBJ_CAR4           0x03
#define OBJ_CAR5           0x05
#define OBJ_BRIEFCASE1     0x06
#define OBJ_BRIEFCASE2     0x07
#define OBJ_FIREDOORTOP    0x08
#define OBJ_FIREDOORBOTTOM 0x09
#define OBJ_TAXI           0x0a
#define OBJ_LIMO           0x0c
#define OBJ_SWITCH         0x0e
#define OBJ_BRIEFCASE3     0x0f
#define OBJ_MINE1          0x12
#define OBJ_MINE2          0x13
#define OBJ_BRIEFCASE4     0x1b
#define OBJ_BRIEFCASE5     0x1d
#define OBJ_BRIEFCASE6     0x1e
#define OBJ_WIREFENCE      0x21
#define OBJ_FALCON2        0x22
#define OBJ_DUMPSTER       0x25

// Stage flags
#define STAGEFLAG_ALARM_GROUP1_DEAD          0x00000001
#define STAGEFLAG_ALARM_GROUP2_DEAD          0x00000002
#define STAGEFLAG_ALARM_GROUP3_DEAD          0x00000004
#define STAGEFLAG_TRACERBUG_SPOTTED          0x00000008
#define STAGEFLAG_CRASH_FINISHED             0x00000010
#define STAGEFLAG_TRIGGER_CRASH              0x00000020
#define STAGEFLAG_ROBOT_NEAR_CORNER          0x00000040
#define STAGEFLAG_TRACERBUG_SAFE             0x00000080
#define STAGEFLAG_ONE_BUG_REMAINING          0x00000100
#define STAGEFLAG_MINE_PLACED                0x00000200
#define STAGEFLAG_MINE_WASTED                0x00000400
#define STAGEFLAG_TAXI_REPROGRAMMED          0x00000800
#define STAGEFLAG_TRACERBUG_PLACED           0x00001000
#define STAGEFLAG_TRACERBUG_WASTED           0x00002000
#define STAGEFLAG_LIMO_DESTROYED             0x00004000
#define STAGEFLAG_TAXI_DESTROYED             0x00008000
#define STAGEFLAG_ROBOT_DESTROYED            0x00010000
#define STAGEFLAG_IN_ELEVATOR                0x00020000
#define STAGEFLAG_LIMO_READY_TO_LEAVE        0x00040000
#define STAGEFLAG_LIMO_READY_15SEC_AGO       0x00080000
#define STAGEFLAG_TRIGGER_TAXI_LEAVE         0x00100000
#define STAGEFLAG_TAXI_ALMOST_READY_TO_CRASH 0x00200000
#define STAGEFLAG_ALARM_SOUNDED              0x00400000
#define STAGEFLAG_ROBOT_NEAR_HOME            0x00800000
#define STAGEFLAG_ROBOT_ON_DRAIN_STREET      0x01000000
#define STAGEFLAG_TRIGGER_INTRO              0x02000000
#define STAGEFLAG_LIMO_ESCAPED               0x04000000
#define STAGEFLAG_CIVILIAN_DEAD              0x08000000
#define STAGEFLAG_ELEVATOR_SEALED            0x10000000
#define STAGEFLAG_INTRO_FINISHED             0x20000000
#define STAGEFLAG_DIVERSION_CREATED          0x40000000
#define STAGEFLAG_TAXI_READY_TO_CRASH        0x80000000

// AI Lists
#define AILIST_OUTRO           0x040b
#define AILIST_CIA             0x0412
#define AILIST_BUGSPOTTER      0x0413
#define AILIST_INIT_CIA1       0x0419
#define AILIST_ROBOT           0x041a
#define AILIST_INIT_ROBOT      0x041b
#define AILIST_HIDDENGUY       0x041c
#define AILIST_FBI             0x041d
#define AILIST_SEALER1         0x041e
#define AILIST_ALARM_RESPONDER 0x041f
#define AILIST_JOG_TO_ACCIDENT 0x0420

// Other
#define GROUP_ALARM_RESPONDER 0x09

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x3201)
	briefing(1, 0x3200)
	briefing(2, 0x3202)
	briefing(3, 0x3203)

	beginobjective(0, L_PETE(9), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Retrieve drop point equipment"
		require_object_collected(OBJ_BRIEFCASE1)
		require_object_collected(OBJ_BRIEFCASE2)
	endobjective

	beginobjective(1, L_PETE(10), (DIFFBIT_PA | DIFFBIT_PD)) // "Attach tracer to limousine"
		complete_flags(STAGEFLAG_TRACERBUG_PLACED)
		fail_flags(STAGEFLAG_TRACERBUG_WASTED)
		fail_flags(STAGEFLAG_LIMO_DESTROYED)
		fail_flags(STAGEFLAG_LIMO_ESCAPED)
		fail_flags(STAGEFLAG_TRACERBUG_SPOTTED)
	endobjective

	beginobjective(2, L_PETE(11), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Prepare escape route"
		complete_flags(STAGEFLAG_MINE_PLACED)
		fail_flags(STAGEFLAG_MINE_WASTED)
	endobjective

	beginobjective(3, L_PETE(13), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Create vehicular diversion"
		complete_flags(STAGEFLAG_DIVERSION_CREATED)
		fail_flags(STAGEFLAG_TAXI_DESTROYED)
		fail_flags(STAGEFLAG_ROBOT_DESTROYED)
	endobjective

	beginobjective(4, L_PETE(14), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Gain entry to G5 building"
		complete_flags(STAGEFLAG_IN_ELEVATOR)
		fail_flags(STAGEFLAG_CIVILIAN_DEAD)
		fail_flags(STAGEFLAG_ELEVATOR_SEALED)
	endobjective

	chr(0x00010c00, 0x1a, 0x00a9, BODY_CIAGUY, HEAD_RANDOM, AILIST_INIT_CIA1, -1, -1, 1000, 6, 0x80004000, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	chr(0x00000200, 0x00, 0x00aa, BODY_G5_GUARD, HEAD_RANDOM, 0x0414, -1, -1, 1000, 10, 0xa0004408, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0000, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x000000c0, 0x17, 0x00ab, BODY_FBIGUY, HEAD_RANDOM, 0x0411, -1, -1, 800, 30, 0x8000a000, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	chr(0x00000200, 0x01, 0x00ac, BODY_G5_GUARD, HEAD_RANDOM, 0x0415, -1, -1, 1000, 10, 0xa0004408, 0x00000000, TEAM_20, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0001, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000080, 0x18, 0x00af, BODY_FBIGUY, HEAD_RANDOM, 0x0411, -1, -1, 500, 30, 0x8000e008, 0x00000000, TEAM_20, SQUADRON_01, -1, 0, 0x01000000)
	chr(0x00000200, 0x02, 0x00ad, BODY_G5_GUARD, HEAD_RANDOM, 0x0416, -1, -1, 1000, 10, 0xa0004008, 0x00000000, TEAM_20, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0002, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x03, 0x00ae, BODY_G5_GUARD, HEAD_RANDOM, 0x040e, -1, -1, 1000, 50, 0xc0004008, 0x00000000, TEAM_20, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0003, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x04, 0x00b0, BODY_G5_GUARD, HEAD_RANDOM, 0x040e, -1, -1, 1000, 50, 0xc0004008, 0x00000000, TEAM_20, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0004, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x05, 0x00b1, BODY_G5_GUARD, HEAD_RANDOM, 0x0417, -1, -1, 1000, 50, 0xa0004008, 0x00000000, TEAM_20, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0005, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x19, 0x00b3, BODY_FBIGUY, HEAD_RANDOM, 0x0411, -1, -1, 500, 20, 0xc000a000, 0x00000000, TEAM_20, SQUADRON_04, -1, 0, 0x02000000)
	chr(0x00000200, 0x06, 0x00b4, BODY_G5_GUARD, HEAD_RANDOM, 0x040f, -1, -1, 1000, 10, 0xc0004008, 0x00000000, TEAM_20, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0006, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000300, 0x0a, 0x00b6, BODY_G5_GUARD, HEAD_RANDOM, 0x040f, -1, -1, 1000, 10, 0xd0002008, 0x00000000, TEAM_20, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x07, 0x00b5, BODY_G5_GUARD, HEAD_RANDOM, 0x040f, -1, -1, 1000, 10, 0xd0002008, 0x00001000, TEAM_20, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0007, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0b, 0x00b7, BODY_G5_GUARD, HEAD_RANDOM, 0x040f, -1, -1, 1000, 10, 0xc0004008, 0x00000000, TEAM_20, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000240, 0x08, 0x00cb, BODY_G5_GUARD, HEAD_RANDOM, 0x040f, -1, -1, 1000, 10, 0xd0002008, 0x00000000, TEAM_20, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0009, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000280, 0x09, 0x00cc, BODY_G5_GUARD, HEAD_RANDOM, 0x040f, -1, -1, 1000, 10, 0xd0002008, 0x00000000, TEAM_20, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0009, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0c, 0x00b8, BODY_G5_GUARD, HEAD_RANDOM, 0x0418, -1, -1, 500, 10, 0xc0004008, 0x00000000, TEAM_20, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00010c00, 0x1c, 0x00b9, BODY_CIAGUY, HEAD_RANDOM, AILIST_CIA, -1, -1, 1000, 6, 0x80000008, 0x00000000, TEAM_20, SQUADRON_05, -1, 0, 0x01000000)
	chr(0x00010c00, 0x1d, 0x0042, BODY_CIAGUY, HEAD_RANDOM, AILIST_CIA, -1, -1, 1000, 6, 0x80002000, 0x00000000, TEAM_20, SQUADRON_05, -1, 0, 0x02000000)
	chr(0x00000400, 0x0d, 0x00bf, BODY_G5_GUARD, HEAD_RANDOM, AILIST_SEALER1, -1, -1, 1000, 15, 0xc0004008, 0x00000000, TEAM_20, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x0e, 0x00bc, BODY_G5_GUARD, HEAD_RANDOM, 0x040e, 0x00c5, -1, 1000, 15, 0xc0084008, 0x00000000, TEAM_20, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x0f, 0x00bd, BODY_G5_GUARD, HEAD_RANDOM, 0x040e, 0x00c6, -1, 1000, 15, 0xc0084008, 0x00000000, TEAM_20, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x10, 0x00be, BODY_G5_GUARD, HEAD_RANDOM, 0x040e, 0x00c7, -1, 1000, 15, 0xc0084008, 0x00000000, TEAM_20, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0010, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00010c00, 0x1b, 0x00b2, BODY_CIAGUY, HEAD_RANDOM, AILIST_BUGSPOTTER, -1, -1, 1000, 6, 0x80000000, 0x00000000, TEAM_20, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000000, 0x11, 0x00c9, BODY_G5_GUARD, HEAD_RANDOM, GAILIST_IDLE, 0x00c9, -1, 1000, 30, 0xc1086008, 0x00000000, TEAM_20, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0011, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x12, 0x00ca, BODY_G5_GUARD, HEAD_RANDOM, GAILIST_IDLE, 0x00ca, -1, 1000, 30, 0xc1086008, 0x00000000, TEAM_20, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0012, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000400, 0x1f, 0x0020, BODY_CHICROB, 0x00, AILIST_INIT_ROBOT, -1, -1, 1000, 15, 0x00000000, 0x00000000, TEAM_20, SQUADRON_00, -1, 0, 0x00000000)
	chr(0x00000000, 0x1e, 0x0063, BODY_G5_GUARD, HEAD_RANDOM, AILIST_HIDDENGUY, 0x00c8, -1, 1000, 15, 0x40084008, 0x00000000, TEAM_20, SQUADRON_01, -1, 0, 0x00000000)
	chr(0x00000200, 0x13, 0x00cd, BODY_G5_GUARD, HEAD_RANDOM, 0x040e, -1, -1, 500, 10, 0xc0004208, 0x00000000, TEAM_20, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0013, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x14, 0x00ce, BODY_G5_GUARD, HEAD_RANDOM, 0x040e, -1, -1, 500, 10, 0xc0004208, 0x00000000, TEAM_20, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0014, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x15, 0x00cf, BODY_G5_GUARD, HEAD_RANDOM, 0x040e, -1, -1, 500, 10, 0xc0004208, 0x00000000, TEAM_20, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0015, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x16, 0x00d1, BODY_G5_GUARD, HEAD_RANDOM, 0x040e, -1, -1, 1, 10, 0xc0004008, 0x00000000, TEAM_20, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0016, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	tag(0x00, 1)
	stdobject(0x0100, MODEL_TAXICAB, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x01, 1)
	stdobject(0x0100, MODEL_TAXICAB, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x02, 1)
	stdobject(0x0100, MODEL_TAXICAB, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x03, 1)
	stdobject(0x0100, MODEL_POLICECAR, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x05, 1)
	stdobject(0x0100, MODEL_POLICECAR, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x06, 1)
	weapon(0x0180, MODEL_CHRBRIEFCASE, 0x00a6, 0x00422001, 0x00000001, 0x20400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REMOTEMINE, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x22, L_PETE(38), L_PETE(39), L_PETE(40), L_PETE(41), L_PETE(42), 0x0000, 0x0000) // "Obtain Remote Mine."
	tag(0x0f, 1)
	weapon(0x0180, MODEL_CHRBRIEFCASE, 0xffff, 0x00000001, 0x00000001, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_TRACERBUG, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x3e, L_PETE(43), L_PETE(44), L_PETE(45), L_PETE(46), L_PETE(47), 0x0000, 0x0000) // "Obtain Tracer Bug."
	tag(0x1d, 1)
	weapon(0x0180, MODEL_CHRBRIEFCASE, 0xffff, 0x00000001, 0x00000001, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_TRACERBUG, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x3e, L_PETE(43), L_PETE(44), L_PETE(45), L_PETE(46), L_PETE(47), 0x0000, 0x0000) // "Obtain Tracer Bug."
	tag(0x0e, 1)
	singlemonitor(0x0019, MODEL_G5_LASER_SWITCH, 0x00eb, 0x00000002, 0x00002301, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff13)
	tag(0x07, 1)
	weapon(0x0180, MODEL_CHRBRIEFCASE, 0x00a6, 0x00462001, 0x00000001, 0x20400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DATAUPLINK, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x36, L_PETE(49), L_PETE(50), L_PETE(51), L_PETE(52), L_PETE(53), 0x0000, 0x0000) // "Obtain Reprogrammer."
	tag(0x1b, 1)
	weapon(0x0180, MODEL_CHRBRIEFCASE, 0x001c, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2_SCOPE, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x04, L_PETE(55), L_PETE(56), L_PETE(57), L_PETE(58), L_PETE(59), 0x0000, 0x0000) // "Obtain Remote Mine."
	tag(0x1e, 1)
	weapon(0x0180, MODEL_CHRBRIEFCASE, 0x001c, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2_SCOPE, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x04, L_PETE(55), L_PETE(56), L_PETE(57), L_PETE(58), L_PETE(59), 0x0000, 0x0000) // "Obtain Remote Mine."
	tag(0x1f, 1)
	stdobject(0x0100, MODEL_CHRBRIEFCASE, 0x009c, 0x012004e1, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x0a, 1)
	hovercar(0x0100, MODEL_TAXICAB, 0x00a3, 0x20000108, 0x00000001, 0x10010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000002bc, 0x00000000, 0x00000000, 0x0fff0000, 0x0000040c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0c, 1)
	hovercar(0x00cc, MODEL_LIMO, 0x00a4, 0x20000108, 0x00000001, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000002bc, 0x00000000, 0x00000000, 0x0fff0000, 0x0000040d, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x21, 1)
	stdobject(0x0100, MODEL_WIREFENCE, 0xffff, 0x00021501, 0x00008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x08, 1)
	door(0x0100, MODEL_G5_ESCDOORUP, 0x00fb, 0x13520d00, 0x20304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00010000, 0x03e80000, 0x03e80000, 0x00010000, 0x00000000, 0x00000080, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x09, 1)
	door(0x0100, MODEL_G5_ESCDOORDOWN, 0x00fc, 0x13520d00, 0x20304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00010000, 0x03e80000, 0x03e80000, 0x00010000, 0x00000000, 0x00000080, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x10, 2)
	tag(0x11, 2)
	door(0x0100, MODEL_G5CARLIFTDOOR, 0x00ec, 0x10000000, 0x00000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00003333, 0x00014000, 0x00001333, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_G5CARLIFTDOOR, 0x00ed, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00003333, 0x00014000, 0x00001333, 0x00080000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x14, 1)
	door(0x0100, MODEL_CH_SHUTTER1, 0x00ee, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f5c2, 0x0000f333, 0x00003333, 0x00014000, 0x00001333, 0x00040004, 0x00000004, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000a00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x1a, 1)
	door(0x0100, MODEL_CH_SHUTTER1, 0x00ef, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f5c2, 0x0000f333, 0x00003333, 0x00014000, 0x00001333, 0x00040004, 0x00000000, 0x00000708, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CH_SHUTTER1, 0x00f0, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f5c2, 0x0000f333, 0x00003333, 0x00014000, 0x00001333, 0x00040004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000a00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CH_SHUTTER1, 0x00f1, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f5c2, 0x0000f333, 0x00003333, 0x00014000, 0x00001333, 0x00040004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000a00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x15, 2)
	tag(0x16, 2)
	door(0x0100, MODEL_CH_SHUTTER1, 0x00f2, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f5c2, 0x0000f333, 0x00003333, 0x00014000, 0x00001333, 0x000c0004, 0x00000004, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000a00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CH_SHUTTER1, 0x00f3, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f5c2, 0x0000f333, 0x00003333, 0x00014000, 0x00001333, 0x000c0004, 0x00000004, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000a00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x19, 1)
	door(0x0100, MODEL_CH_SHUTTER1, 0x00f4, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f5c2, 0x0000f333, 0x00003333, 0x00014000, 0x00001333, 0x000c0004, 0x00000004, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000a00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x17, 2)
	tag(0x18, 2)
	door(0x0100, MODEL_CH_SHUTTER1, 0x00f5, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f5c2, 0x0000f333, 0x00003333, 0x00014000, 0x00001333, 0x000c0004, 0x00000004, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000a00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CH_SHUTTER1, 0x00f6, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f5c2, 0x0000f333, 0x00003333, 0x00014000, 0x00001333, 0x000c0004, 0x00000004, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000a00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_CH_SHUTTER1, 0x00f7, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f5c2, 0x0000f333, 0x00003333, 0x00014000, 0x00001333, 0x000c0004, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000a00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x12, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0067, 0x012004e1, 0x00086001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x13, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0067, 0x012004e1, 0x00086001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	door(0x0100, MODEL_DOOR2A_G5, 0x00fd, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00003333, 0x00014000, 0x00001333, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x00fe, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00003333, 0x00014000, 0x00001333, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x0104, 0x00000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x00000005, 0x00000001, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_OFFICEDOOR, 0x0105, 0x20000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x00000005, 0x00000001, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x25, 1)
	stdobject(0x0100, MODEL_DUMPSTER, 0x011e, 0x004001e1, 0x00004000, 0x00000801, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	weapon(0x0100, MODEL_CHRBRIEFCASE, 0xffff, 0x40008000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CAMSPY, 0x00ffffff, 0x00000000)
	tag(0x24, -1)
	stdobject(0x0100, MODEL_BARREL, 0x010b, 0x000001e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x010c, 0x000001e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x010e, 0x000001e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x010f, 0x000001e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0110, 0x000001e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0111, 0x000001e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0112, 0x000001e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0113, 0x000001e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0114, 0x000001e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0115, 0x000001e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0116, 0x000001e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0117, 0x000001e8, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0119, 0x000000e8, 0x00080001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x011d, 0x000000e8, 0x00080001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x011c, 0x000000e8, 0x00080001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x011b, 0x000000e8, 0x00080001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0118, 0x000000e8, 0x00080001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x011a, 0x000000e8, 0x00080001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DUMPSTER, 0x0106, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DUMPSTER, 0x0107, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DUMPSTER, 0x0108, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DUMPSTER, 0x0109, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DUMPSTER, 0x010a, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	door(0x0100, MODEL_DD_GRATE, 0x00f8, 0x10000400, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000fd70, 0x00010000, 0x00003333, 0x00014000, 0x00001333, 0x08000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_GRATE, 0x00f9, 0x10000400, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000fd70, 0x00010000, 0x00003333, 0x00014000, 0x00001333, 0x08000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_GRATE, 0x00fa, 0x10000400, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000fd70, 0x00010000, 0x00003333, 0x00014000, 0x00001333, 0x08000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x22, 2)
	tag(0x23, 2)
	weapon(0x0100, MODEL_CHRFALCON2, 0x011f, 0x00420001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2_SCOPE, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRFALCON2, 0x011f, 0x00420001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2_SCOPE, 0x00ffffff, 0x00000000)
	link_collectibles(-1, -2)
	tag(0x1c, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x0121, 0x00000001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x20, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x0122, 0x00000001, 0x000000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0123, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0124, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0125, 0x14000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	pad_effect(PADEFFECT_SPLASH, 0x009b)
	pad_effect(PADEFFECT_SPLASH, 0x009c)
	pad_effect(PADEFFECT_SPLASH, 0x009d)
	pad_effect(PADEFFECT_SPLASH, 0x009e)
	endprops
};

s32 intro[] = {
	ammo(AMMOTYPE_PISTOL, 50)
	outfit(OUTFIT_TRENCH)
	spawn(0x0063)
	endintro
};

s32 path00[] = {
	0x00d3,
	0x00d4,
	0x00d9,
	0x00d6,
	0x00d7,
	0x0036,
	0x00d7,
	0x00d6,
	0x00d9,
	0x00d4,
	0x00d3,
	-1,
};

s32 path01[] = {
	0x00da,
	0x00d7,
	0x00d7,
	0x00d6,
	0x00d9,
	0x00d5,
	0x00d4,
	0x00db,
	0x00de,
	0x00d3,
	-1,
};

s32 path02[] = {
	0x00a4,
	0x00a4,
	0x00a4,
	0x00a4,
	0x00a4,
	-1,
};

s32 path03[] = {
	0x00e3,
	-1,
};

s32 path04[] = {
	0x00a3,
	0x00a3,
	0x00a3,
	0x00a3,
	0x00a3,
	-1,
};

s32 path05[] = {
	0x00e8,
	-1,
};

s32 path06[] = {
	0x00ea,
	0x00ea,
	0x00ea,
	0x00e8,
	-1,
};

s32 path07[] = {
	0x0061,
	0x0060,
	0x0065,
	0x005f,
	0x005e,
	0x005d,
	0x005e,
	0x005f,
	0x0065,
	0x0060,
	-1,
};

s32 path08[] = {
	0x0038,
	0x002e,
	0x000c,
	0x002e,
	0x0038,
	0x0037,
	-1,
};

s32 path09[] = {
	0x0033,
	0x0035,
	0x0034,
	0x002d,
	0x0028,
	0x002a,
	0x001d,
	0x002a,
	0x0028,
	0x002d,
	0x0034,
	0x0035,
	-1,
};

s32 path10[] = {
	0x0047,
	0x0046,
	0x0047,
	-1,
};

s32 path11[] = {
	0x0034,
	0x0043,
	0x0041,
	0x0051,
	0x0041,
	0x0043,
	0x0034,
	-1,
};

s32 path12[] = {
	0x0061,
	0x0060,
	0x0066,
	0x0062,
	0x0063,
	0x0064,
	0x0063,
	0x0062,
	0x0066,
	0x0060,
	-1,
};

s32 path13[] = {
	0x00da,
	0x00d7,
	0x00d7,
	0x00d6,
	0x00d9,
	0x00d5,
	0x00d4,
	0x00db,
	0x00de,
	0x00d3,
	-1,
};

#define chicago_car_do_animation(object, animation) \
	show_object(object) \
	set_object_flag2(object, OBJFLAG2_04000000) \
	set_object_flag3(object, OBJFLAG3_00000010) \
	object_do_animation(animation, object, 0x04, 0xffff)



#define chicago_wait_for_camera \
	beginloop(0x05) \
		if_camera_animating(/*goto*/ 0x03) \
		goto_next(0x04) \
		label(0x03) \
		if_controller_button_pressed(/*goto*/ 0x04) \
	goto_first(0x05) \
	label(0x04)



u8 func0401_3ae8[] = {
	set_stage_flag(STAGEFLAG_TRIGGER_INTRO)
	if_controller_button_pressed(/*goto*/ 0x00)
	camera_movement(0x00cf)
	set_music_track(MUSIC_CHICAGO_INTRO)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)

	chicago_car_do_animation(OBJ_CAR1, 0x00d6)
	chicago_car_do_animation(OBJ_CAR2, 0x00d7)
	chicago_car_do_animation(OBJ_CAR3, 0x00d8)
	chicago_car_do_animation(OBJ_CAR4, 0x00d5)

	set_chr_chrflag(CHR_CIA1, CHRCFLAG_HIDDEN)
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 90)

	chicago_wait_for_camera

	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	hide_object(OBJ_CAR1)
	hide_object(OBJ_CAR2)
	hide_object(OBJ_CAR3)
	hide_object(OBJ_CAR4)
	unset_chr_chrflag(CHR_CIA1, CHRCFLAG_HIDDEN)
	label(0x00)
	return
	endlist
};

u8 func0402_3bb4[] = {
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	if_controller_button_pressed(/*goto*/ 0x00)
	camera_movement(0x00d0)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)

	chicago_car_do_animation(OBJ_CAR1, 0x00dc)
	chicago_car_do_animation(OBJ_CAR2, 0x00dd)
	chicago_car_do_animation(OBJ_CAR4, 0x00d9)
	chicago_car_do_animation(OBJ_CAR5, 0x00db)

	set_chr_chrflag(CHR_CIA1, CHRCFLAG_HIDDEN)

	chicago_wait_for_camera

	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	hide_object(OBJ_CAR1)
	hide_object(OBJ_CAR2)
	hide_object(OBJ_CAR4)
	hide_object(OBJ_CAR5)
	unset_chr_chrflag(CHR_CIA1, CHRCFLAG_HIDDEN)
	label(0x00)
	return
	endlist
};

u8 func0403_3c74[] = {
	if_controller_button_pressed(/*goto*/ 0x00)
	camera_movement(0x00d1)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	show_object(OBJ_CAR4)
	set_object_flag2(OBJ_CAR4, OBJFLAG2_04000000)
	set_object_flag3(OBJ_CAR4, OBJFLAG3_00000010)
	object_do_animation(0x00de, OBJ_CAR4, 0x04, 0xffff)
	set_chr_chrflag(CHR_CIA1, CHRCFLAG_HIDDEN)

	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_FALCON2_SCOPE, WEAPON_NONE)

	chicago_wait_for_camera

	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	hide_object(OBJ_CAR4)
	unset_chr_chrflag(CHR_CIA1, CHRCFLAG_HIDDEN)
	label(0x00)
	return
	endlist
};

u8 func0404_3ce0[] = {
	show_object(OBJ_WIREFENCE)
	set_object_flag2(OBJ_WIREFENCE, OBJFLAG2_04000000)
	set_object_flag3(OBJ_WIREFENCE, OBJFLAG3_00000010)
	object_do_animation(0x0470, OBJ_WIREFENCE, 0x01, 0xffff)

	if_controller_button_pressed(/*goto*/ 0x00)
	camera_movement(0x00e0)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x00e1, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	set_chr_chrflag(CHR_CIA1, CHRCFLAG_HIDDEN)

	chicago_wait_for_camera

	unset_chr_chrflag(CHR_CIA1, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	label(0x00)
	return
	endlist
};

u8 func0405_3d50[] = {
	camera_movement(0x00d2)
	cmd0175(60)
	if_controller_button_pressed(/*goto*/ 0x00)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x00df, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	set_chr_chrflag(CHR_CIA1, CHRCFLAG_HIDDEN)

	restart_timer

	beginloop(0x2d)
		if_controller_button_pressed(/*goto*/ 0x2f)
		if_timer_gt(480, /*goto*/ 0x04)
	endloop(0x2d)

	label(0x04)
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)

	beginloop(0x2f)
		if_controller_button_pressed(/*goto*/ 0x04)
		if_timer_gt(910, /*goto*/ 0x04)
	endloop(0x2f)

	label(0x04)
	chicago_wait_for_camera

	label(0x00)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	mute_channel(CHANNEL_7)
	unset_chr_chrflag(CHR_CIA1, CHRCFLAG_HIDDEN)

	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x00df, -2, -1, 0x06, 0x00, CHR_BOND, 2)

	restart_default_music
	reset_ambience
	set_stage_flag(STAGEFLAG_INTRO_FINISHED)
	enter_firstperson
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 unregistered_function1[] = {
	set_returnlist(CHR_SELF, GAILIST_END_CINEMA)
	set_ailist(CHR_SELF, 0x0401)
	endlist
};

u8 unregistered_function2[] = {
	set_returnlist(CHR_SELF, GAILIST_END_CINEMA)
	set_ailist(CHR_SELF, 0x0402)
	endlist
};

u8 unregistered_function3[] = {
	set_returnlist(CHR_SELF, GAILIST_END_CINEMA)
	set_ailist(CHR_SELF, 0x0403)
	endlist
};

u8 unregistered_function4[] = {
	set_returnlist(CHR_SELF, GAILIST_END_CINEMA)
	set_ailist(CHR_SELF, 0x0404)
	endlist
};

u8 unregistered_function5[] = {
	set_ailist(CHR_SELF, 0x0405)
	endlist
};

u8 func040a_intro[] = {
	set_returnlist(CHR_SELF, 0x0406)
	set_ailist(CHR_SELF, 0x0401)
	endlist
};

u8 func0406_3e54[] = {
	set_returnlist(CHR_SELF, 0x0407)
	set_ailist(CHR_SELF, 0x0402)
	endlist
};

u8 func0407_3e60[] = {
	set_returnlist(CHR_SELF, 0x0408)
	set_ailist(CHR_SELF, 0x0403)
	endlist
};

u8 func0408_3e6c[] = {
	set_returnlist(CHR_SELF, 0x0409)
	set_ailist(CHR_SELF, 0x0404)
	endlist
};

u8 func0409_3e78[] = {
	set_ailist(CHR_SELF, 0x0405)
	endlist
};

u8 func100f_check_mine[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0a)

	// SA and PA
	yield
	beginloop(0x08)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_has_object(CHR_P1P2, OBJ_BRIEFCASE1, /*goto*/ 0x03)
		reloop(0x08)

		label(0x03)
		set_target_chr(CHR_P1P2)

		beginloop(0x11)
			dprint 'M','A','I','N','\n',0,
			if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x29)
			if_chr_dying(CHR_TARGET, /*goto*/ 0x29)
			if_chr_unloaded(CHR_TARGET, /*goto*/ 0x29)
			if_ammo_quantity_lt(CHR_TARGET, AMMOTYPE_REMOTE_MINE, 1, /*goto*/ 0x03)
		endloop(0x11)

		label(0x29)
		label(0x54)
		yield
		dprint 'D','E','A','D','\n',0,
		if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x28)
		if_chr_dying(CHR_TARGET, /*goto*/ 0x28)
		if_chr_unloaded(CHR_TARGET, /*goto*/ 0x28)
		yield
		dprint 'N','O','T','D','E','A','D','\n',0,
		if_ammo_quantity_lt(CHR_BOND, AMMOTYPE_REMOTE_MINE, 1, /*goto*/ 0x29)
		reloop(0x08)

		label(0x29)
		if_ammo_quantity_lt(CHR_COOP, AMMOTYPE_REMOTE_MINE, 1, /*goto*/ 0x29)
	endloop(0x08)

	label(0x29)
	dprint 'N','O','A','M','M','O','\n',0,
	label(0x28)
	dprint 'S','T','I','L','L','D','E','A','D','\n',0,
	goto_first(0x54)

	label(0x03)
	dprint 'F','A','I','L','\n',0,
	yield
	yield
	yield
	yield
	yield
	if_weapon_thrown(WEAPON_REMOTEMINE, /*goto*/ 0x04)
	goto_first(0x11)

	label(0x04)
	restart_timer

	beginloop(0x05)
		if_weapon_thrown_on_object(WEAPON_REMOTEMINE, OBJ_FIREDOORTOP, /*goto*/ 0x06)
		if_weapon_thrown_on_object(WEAPON_REMOTEMINE, OBJ_FIREDOORBOTTOM, /*goto*/ 0x08)
		if_timer_gt(120, /*goto*/ 0x07)
	endloop(0x05)

	label(0x08)
	unset_savefile_flag(SAVEFILEFLAG_G5_MINE)
	goto_next(0x03)
	label(0x06)
	set_savefile_flag(SAVEFILEFLAG_G5_MINE)

	label(0x03)
	set_stage_flag(STAGEFLAG_MINE_PLACED)
	show_hudmsg(CHR_P1P2, L_PETE(15)) // "Mine placed correctly."

	// Check that the player hasn't detonated the mine
	beginloop(0x2d)
		if_weapon_thrown_on_object(WEAPON_REMOTEMINE, OBJ_FIREDOORTOP, /*goto*/ 0x03)
		if_weapon_thrown_on_object(WEAPON_REMOTEMINE, OBJ_FIREDOORBOTTOM, /*goto*/ 0x03)
		goto_next(0x04)
		label(0x03)
	endloop(0x2d)

	label(0x04)
	set_stage_flag(STAGEFLAG_MINE_WASTED)
	show_hudmsg(CHR_P1P2, L_PETE(72)) // "Remote Mine has been wasted."
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x07)
	set_stage_flag(STAGEFLAG_MINE_WASTED)
	show_hudmsg(CHR_P1P2, L_PETE(16)) // "Mine placed incorrectly."

	label(0x0a)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1026_uplink[] = {
	beginloop(0x10)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_TAXI, /*goto*/ 0x03)
		reloop(0x10)

		label(0x03)
		if_stage_flag_eq(STAGEFLAG_TAXI_REPROGRAMMED, FALSE, /*goto*/ 0x04)
		show_hudmsg(CHR_P1P2, L_PETE(17)) // "Virus already downloaded into NavComp."
		reloop(0x10)

		label(0x04)
		if_chr_weapon_equipped(CHR_P1P2, WEAPON_DATAUPLINK, /*goto*/ 0x03)
		show_hudmsg(CHR_P1P2, L_PETE(18)) // "Hovcab is unresponsive - need Reprogrammer."
		reloop(0x10)

		// Uplinking
		label(0x03)
		show_hudmsg(CHR_P1P2, L_PETE(19)) // "Accessing hovercab navigation systems."
		assign_sound(0x0456, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_TAXI, TRUE)
		restart_timer

		beginloop(0x05)
			if_timer_gt(300, /*goto*/ 0x04)
			if_chr_distance_to_pad_gt(CHR_P1P2, 350, 0x00a3, /*goto*/ 0x06)
		endloop(0x05)

		label(0x04)
		show_hudmsg(CHR_P1P2, L_PETE(20)) // "Virus downloaded successfully."
		yield
		show_hudmsg(CHR_P1P2, L_PETE(21)) // "Hovercab navigation systems reprogrammed."
		mute_channel(CHANNEL_7)
		assign_sound(0x01c1, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_TAXI, TRUE)
		yield
		set_stage_flag(STAGEFLAG_TAXI_REPROGRAMMED)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		// Moved away while uplinking
		label(0x06)
		show_hudmsg(CHR_P1P2, L_PETE(22)) // "Connection to hovercab broken."
		mute_channel(CHANNEL_7)
		yield
		yield
		yield
		assign_sound(0x0457, CHANNEL_4)
		play_sound_from_object(CHANNEL_4, OBJ_TAXI, 0x012c, 0x0190)
		restart_timer

		beginloop(0x1d)
			if_timer_gt(120, /*goto*/ 0x04)
		endloop(0x1d)

		label(0x04)
		mute_channel(CHANNEL_4)
	endloop(0x10)

	endlist
};

u8 func040d_limo[] = {
	begin_hovercar_path(0x02)
	set_vehicle_speed(SPEED_WALK, 0)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x03)

	// SA and PA
	set_chr_maxdamage(CHR_SELF, 34464)
	goto_next(0x04)

	// A
	label(0x03)
	set_chr_maxdamage(CHR_SELF, 65456)

	// All difficulties
	label(0x04)

	// Wait for flag set, provided limo not destroyed
	beginloop(0x05)
		if_object_in_good_condition(OBJ_LIMO, /*goto*/ 0x03)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x03)
		if_stage_flag_eq(STAGEFLAG_LIMO_READY_TO_LEAVE, TRUE, /*goto*/ 0x04)
	endloop(0x05)

	label(0x04)

	// Wait until not in room
	beginloop(0x2d)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0002, /*goto*/ 0x03)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0010, /*goto*/ 0x03)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0012, /*goto*/ 0x03)
		goto_next(0x04)
		label(0x03)
	endloop(0x2d)

	label(0x04)
	set_object_flag2(OBJ_LIMO, OBJFLAG2_04000000)
	set_object_flag3(OBJ_LIMO, OBJFLAG3_00000010)
	object_do_animation(0x02d6, OBJ_LIMO, 0x04, 0xffff)

	assign_sound(0x01b4, CHANNEL_1)
	play_sound_from_object(CHANNEL_1, OBJ_LIMO, 0x0960, 0x0c80)
	if_stage_flag_eq(STAGEFLAG_TRACERBUG_PLACED, TRUE, /*goto*/ 0x03)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x03)
	set_stage_flag(STAGEFLAG_LIMO_ESCAPED)
	show_hudmsg(CHR_BOND, L_PETE(28)) // "DataDyne limo has escaped."
	label(0x03)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040c_taxi[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x03)

	// SA and PA
	set_chr_maxdamage(CHR_SELF, 34464)
	goto_next(0x04)

	// A
	label(0x03)
	set_chr_maxdamage(CHR_SELF, 65456)
	begin_hovercar_path(0x04)
	set_vehicle_speed(SPEED_WALK, 0)

	// All difficulties
	label(0x04)

	beginloop(0x05)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_TAXI_LEAVE, TRUE, /*goto*/ 0x04)
		label(0x03)
	endloop(0x05)

	// Check taxi healthy
	label(0x04)
	if_object_in_good_condition(OBJ_TAXI, /*goto*/ 0x03)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Take off
	label(0x03)
	assign_sound(0x8000, CHANNEL_0)
	play_sound_from_object(CHANNEL_0, OBJ_TAXI, 0x0960, 0x0c80)
	object_do_animation(0x0168, OBJ_TAXI, 0x04, 0xffff)
	set_object_flag2(OBJ_TAXI, OBJFLAG2_04000000)

	// Wait for flag
	beginloop(0x06)
		if_stage_flag_eq(STAGEFLAG_TAXI_ALMOST_READY_TO_CRASH, TRUE, /*goto*/ 0x04)
	endloop(0x06)

	// Check taxi healthy
	label(0x04)
	if_object_in_good_condition(OBJ_TAXI, /*goto*/ 0x03)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x03)
	set_stage_flag(STAGEFLAG_TAXI_READY_TO_CRASH)

	// Wait for another flag
	beginloop(0x07)
		if_stage_flag_eq(STAGEFLAG_ROBOT_NEAR_CORNER, TRUE, /*goto*/ 0x04)
	endloop(0x07)

	label(0x04)
	label(0x38)
	dprint 'G','O',' ','F','O','R',' ','C','R','A','S','H','\n',0,
	set_stage_flag(STAGEFLAG_TRIGGER_CRASH)
	yield
	mute_channel(CHANNEL_0)
	object_do_animation(0x0169, OBJ_TAXI, 0x04, 0xffff)
	label(0x0a)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define tracerbug_logic(chr, chr2) \
	set_chrpreset(chr) \
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x54) \
	goto_next(0x04) \
 \
	/* A or SA */ \
	label(0x54) \
	set_ailist(CHR_SELF, GAILIST_IDLE) \
 \
	/* PA */ \
	label(0x04) \
	yield \
 \
	beginloop(0x11) \
		dprint 'B','U','G',' ','C','1','\n',0, \
		set_target_chr(chr2) \
		if_chr_death_animation_finished(chr, /*goto*/ 0x2f) \
		if_chr_dying(chr, /*goto*/ 0x2f) \
		if_chr_unloaded(chr, /*goto*/ 0x2f) \
		if_ammo_quantity_lt(chr, AMMOTYPE_BUG, 1, /*goto*/ 0x03) \
		label(0x04) \
	endloop(0x11) \
 \
	/* Dead - not sure why it checks this a second time */ \
	beginloop(0x2f) \
		dprint 'B','U','G',' ','D','O','\n',0, \
		set_target_chr(chr2) \
		if_chr_death_animation_finished(chr, /*goto*/ 0x30) \
		if_chr_dying(chr, /*goto*/ 0x30) \
		if_chr_unloaded(chr, /*goto*/ 0x30) \
		label(0x31) \
		yield \
		yield \
		yield \
		yield \
		yield \
		goto_first(0x11) \
 \
		label(0x30) \
	endloop(0x2f) \
 \
	/* Alive but has no bug */ \
	label(0x03) \
		dprint 'B','U','G',' ','C','2','\n',0, \
		yield \
		if_weapon_thrown(WEAPON_TRACERBUG, /*goto*/ 0x04) \
	goto_first(0x03) \
 \
	/* Check limo healthy */ \
	label(0x04) \
	if_object_in_good_condition(OBJ_LIMO, /*goto*/ 0x04) \
	set_ailist(CHR_SELF, GAILIST_IDLE) \
 \
	label(0x04) \
	restart_timer \
 \
	beginloop(0x05) \
		dprint 'B','U','G',' ','C','3','\n',0, \
		if_weapon_thrown_on_object(WEAPON_TRACERBUG, OBJ_LIMO, /*goto*/ 0x06) \
		if_timer_gt(120, /*goto*/ 0x07) \
	endloop(0x05) \
 \
	label(0x06) \
	set_stage_flag(STAGEFLAG_TRACERBUG_PLACED) \
	unset_stage_flag(STAGEFLAG_TRACERBUG_WASTED) \
	show_hudmsg(chr, 0x3217) /* "Tracer Bug placed correctly." */ \
	restart_timer \
 \
	beginloop(0x08) \
		dprint 'B','U','G',' ','C','4','\n',0, \
		if_timer_gt(300, /*goto*/ 0x04) \
	goto_first(0x08) \
 \
	label(0x04) \
	set_stage_flag(STAGEFLAG_TRACERBUG_SAFE) \
	set_ailist(CHR_SELF, GAILIST_IDLE) \
 \
	/* Bug wasted */ \
	label(0x07) \
	dprint 'W','R','O','N','G','1','\n',0, \
	if_stage_flag_eq(STAGEFLAG_ONE_BUG_REMAINING, TRUE, /*goto*/ 0x03) \
	dprint 'W','R','O','N','G','2','\n',0, \
	set_stage_flag(STAGEFLAG_ONE_BUG_REMAINING) \
	set_ailist(CHR_SELF, GAILIST_IDLE) \
 \
	label(0x03) \
	dprint 'W','R','O','N','G','3','\n',0, \
	set_stage_flag(STAGEFLAG_TRACERBUG_WASTED) \
	show_hudmsg(chr, 0x3218) /* "Tracer Bug placed incorrectly." */ \
	set_ailist(CHR_SELF, GAILIST_IDLE)



u8 func1004_tracerbug_bond[] = {
	tracerbug_logic(CHR_BOND, CHR_BOND)
	endlist
};

u8 func1011_trackerbug_coop[] = {
	yield
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x03)
	goto_next(0x04)

	label(0x03)
	set_stage_flag(STAGEFLAG_ONE_BUG_REMAINING)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x04)
	tracerbug_logic(CHR_COOP, CHR_PRESET)
	endlist
};

u8 func1005_check_things_destroyed[] = {
	beginloop(0x10)
		// Check limo
		if_stage_flag_eq(STAGEFLAG_LIMO_DESTROYED, TRUE, /*goto*/ 0x03)
		if_object_in_good_condition(OBJ_LIMO, /*goto*/ 0x03)
		set_stage_flag(STAGEFLAG_LIMO_DESTROYED)
		mute_channel(CHANNEL_1)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x03)
		show_hudmsg(CHR_BOND, L_PETE(25)) // "Mission critical vehicle destroyed."

		// Check taxi
		label(0x03)
		if_stage_flag_eq(STAGEFLAG_DIVERSION_CREATED, TRUE, /*goto*/ 0x03)
		if_stage_flag_eq(STAGEFLAG_TAXI_DESTROYED, TRUE, /*goto*/ 0x03)
		if_object_in_good_condition(OBJ_TAXI, /*goto*/ 0x03)
		mute_channel(CHANNEL_0)
		set_stage_flag(STAGEFLAG_TAXI_DESTROYED)
		show_hudmsg(CHR_BOND, L_PETE(25)) // "Mission critical vehicle destroyed."

		// Check robot
		label(0x03)
		if_stage_flag_eq(STAGEFLAG_DIVERSION_CREATED, TRUE, /*goto*/ 0x03)
		if_stage_flag_eq(STAGEFLAG_ROBOT_DESTROYED, TRUE, /*goto*/ 0x03)
		if_chr_dying(CHR_ROBOT, /*goto*/ 0x04)
		goto_next(0x03)

		label(0x04)
		restart_timer

		beginloop(0x05)
			if_timer_gt(120, /*goto*/ 0x04)
		endloop(0x05)

		label(0x04)
		set_stage_flag(STAGEFLAG_ROBOT_DESTROYED)
		show_hudmsg(CHR_BOND, L_PETE(25)) // "Mission critical vehicle destroyed."
		label(0x03)
	endloop(0x10)

	endlist
};

u8 func1006_check_for_end[] = {
	beginloop(0x05)
		chr_toggle_p1p2(CHR_SELF)
		if_objective_complete(0, /*goto*/ 0x03)
		reloop(0x05)

		label(0x03)
		if_objective_complete(3, /*goto*/ 0x03)
		reloop(0x05)

		label(0x03)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x0a)
		if_objective_complete(2, /*goto*/ 0x03)
		reloop(0x05)

		label(0x03)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x0a)
		if_objective_complete(1, /*goto*/ 0x0a)
		reloop(0x05)

		label(0x0a)
		dprint 'P','A','D',' ','C','H','E','C','K','\n',0,
		if_chr_distance_to_pad_lt(CHR_P1P2, 350, 0x00a7, /*goto*/ 0x04)
	endloop(0x05)

	label(0x04)
	set_stage_flag(STAGEFLAG_IN_ELEVATOR)
	dprint 'I','N',' ','T','H','E',' ','E','L','E','V','A','T','O','R','\n',0,
	yield
	yield
	set_invincible(CHR_BOND)
	revoke_control(CHR_BOND, 4)

	// But there is no countdown timer...
	hide_countdown_timer
	stop_countdown_timer

	if_all_objectives_complete(/*goto*/ 0x05)

	// Objectives failed
	show_hudmsg(CHR_P1P2, L_PETE(26)) // "MISSION FAILED"
	label(0x03)
	restart_timer

	beginloop(0x13)
		if_timer_gt(280, /*goto*/ 0x12)
	endloop(0x13)

	label(0x12)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Objectives complete
	label(0x05)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x03)
	if_chr_dying(CHR_BOND, /*goto*/ 0x03)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x03)
	goto_next(0x04)

	label(0x03)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x03)
	if_chr_dying(CHR_COOP, /*goto*/ 0x03)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x03)
	goto_next(0x04)

	label(0x03)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x04)
	set_ailist(CHR_SELF, AILIST_OUTRO)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040d_limo_timing[] = {
	// Wait for any of the following:
	// - Taxi reprogrammed
	// - Tracer bug placed and robot on drain street
	// - 2 minutes elapsed and robot on drain street (3 mins on Agent)
	restart_timer

	beginloop(0x05)
		if_stage_flag_eq(STAGEFLAG_TAXI_REPROGRAMMED, TRUE, /*goto*/ 0x04)
		if_stage_flag_eq(STAGEFLAG_ROBOT_ON_DRAIN_STREET, TRUE, /*goto*/ 0x03)
		reloop(0x05)

		label(0x03)
		if_stage_flag_eq(STAGEFLAG_TRACERBUG_PLACED, TRUE, /*goto*/ 0x04)
		if_difficulty_gt(DIFF_SA, /*goto*/ 0x07)
		if_difficulty_gt(DIFF_A, /*goto*/ 0x06)

		// A - 3 minute timer
		if_timer_gt(10800, /*goto*/ 0x04)
		reloop(0x05)

		// SA - 2 minute timer
		label(0x06)
		if_timer_gt(7200, /*goto*/ 0x04)
		reloop(0x05)

		// PA - 2 minute timer
		label(0x07)
		if_timer_gt(7200, /*goto*/ 0x04)
	endloop(0x05)

	// Ready to leave
	label(0x04)
	set_stage_flag(STAGEFLAG_LIMO_READY_TO_LEAVE)
	dprint 'L','I','M','O',' ','R','E','A','D','Y',' ','T','O',' ','G','O','\n',0,
	restart_timer

	// Wait 15 seconds
	beginloop(0x0a)
		if_timer_gt(900, /*goto*/ 0x04)
	endloop(0x0a)

	label(0x04)
	set_stage_flag(STAGEFLAG_LIMO_READY_15SEC_AGO)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040c_taxi_timing[] = {
	// Wait for both conditions
	beginloop(0x07)
		if_stage_flag_eq(STAGEFLAG_ROBOT_ON_DRAIN_STREET, TRUE, /*goto*/ 0x03)
		reloop(0x07)

		label(0x03)
		if_stage_flag_eq(STAGEFLAG_TAXI_REPROGRAMMED, TRUE, /*goto*/ 0x03)
	endloop(0x07)

	// Wait 3.3 seconds
	label(0x03)
	restart_timer

	beginloop(0x05)
		if_timer_gt(200, /*goto*/ 0x04)
	endloop(0x05)

	label(0x04)
	set_stage_flag(STAGEFLAG_TRIGGER_TAXI_LEAVE)
	restart_timer

	// Wait 10 seconds
	beginloop(0x06)
		if_timer_gt(600, /*goto*/ 0x04)
	endloop(0x06)

	label(0x04)
	set_stage_flag(STAGEFLAG_TAXI_ALMOST_READY_TO_CRASH)
	unset_object_flag2(OBJ_TAXI, OBJFLAG2_04000000)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0412_cia[] = {
	set_returnlist(CHR_SELF, AILIST_CIA)
	set_shotlist(AILIST_CIA)
	if_chr_dying(CHR_SELF, /*goto*/ 0x04)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x04)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x04)
	goto_next(0x03)

	label(0x04)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x03)
	if_chr_idle(/*goto*/ 0x43)
	if_num_times_shot_lt(1, /*goto*/ 0x10)

	// Has been shot
	beginloop(0x0d)
		if_chr_stopped(/*goto*/ 0x04)
	endloop(0x0d)

	label(0x04)
	goto_next(0x0c)

	// Unreachable
	restart_timer

	// Chr is idle
	beginloop(0x43)
		if_saw_death(0x00, /*goto*/ 0x1d)
		if_saw_injury(0x00, /*goto*/ 0x1e)
		dprint 'D','U','R','I','N','G','T','A','L','K','\n',0,
		if_timer_gt(180, /*goto*/ 0x04)
	endloop(0x43)

	// Idle + 3 seconds
	label(0x04)
	if_self_flag_bankx_eq(CHRFLAG0_00004000, TRUE, BANK_0, /*goto*/ 0x54)
	dprint 'N','O','T',' ','A',' ','P','A','T','R','O','L','L','E','R','\n',0,
	stop_chr
	goto_next(0x10)

	// Patroller
	label(0x54)
	dprint 'P','A','T',' ','R','E','T','\n',0,
	start_path

	// Not shot, not a patroller, or patroller who has started his path
	label(0x10)
	yield
	chr_toggle_p1p2(CHR_SELF)
	set_target_chr(CHR_P1P2)
	if_self_flag_bankx_eq(CHRFLAG0_00004000, TRUE, BANK_0, /*goto*/ 0x37)
	call_rng
	if_rand_gt(128, /*goto*/ 0x37)
	label(0x2d)
	restart_timer
	label(0x08)
	stop_chr
	if_self_flag_bankx_eq(CHRFLAG1_DONE_SEARCH_ANIM, TRUE, BANK_1, /*goto*/ 0x03)
	call_rng
	if_rand_gt(128, /*goto*/ 0x03)
	call_rng
	if_rand_lt(64, /*goto*/ 0x50)
	if_rand_lt(128, /*goto*/ 0x51)
	if_rand_lt(196, /*goto*/ 0x52)
	set_self_flag_bankx(CHRFLAG1_DONE_SEARCH_ANIM, BANK_1)
	chr_do_animation(ANIM_SMOKE_CIGARETTE, 0, -1, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x36)

	label(0x50)
	chr_do_animation(ANIM_SCRATCH_HEAD, 0, -1, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x36)

	label(0x51)
	chr_do_animation(ANIM_YAWN, 0, -1, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x36)

	label(0x52)
	chr_do_animation(ANIM_GRAB_CROTCH, 0, -1, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x36)

	label(0x53)
	chr_do_animation(ANIM_TWO_GUN_HOLD, 0, 100, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x36)

	label(0x03)
	unset_self_flag_bankx(CHRFLAG1_DONE_SEARCH_ANIM, BANK_1)
	if_room_onscreen(0x003e, /*goto*/ 0x04)
	set_padpreset(0x00ba)
	goto_next(0x03)

	label(0x04)
	call_rng
	if_rand_lt(64, /*goto*/ 0x50)
	if_rand_lt(128, /*goto*/ 0x51)
	if_rand_lt(196, /*goto*/ 0x52)
	try_set_target_pad_to_something(0x08, /*goto*/ 0x03)
	label(0x50)
	try_set_target_pad_to_something(0x02, /*goto*/ 0x03)
	label(0x51)
	try_set_target_pad_to_something(0x04, /*goto*/ 0x03)
	label(0x52)
	try_set_target_pad_to_something(0x08, /*goto*/ 0x03)
	goto_next(0x36)

	label(0x03)
	go_to_target_pad(SPEED_WALK)

	beginloop(0x36)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_saw_death(0x00, /*goto*/ 0x1d)
		if_saw_injury(0x00, /*goto*/ 0x1e)
		if_target_in_sight(/*goto*/ 0x04)
		if_chr_stopped(/*goto*/ 0x35)
	endloop(0x36)

	label(0x35)
	goto_first(0x10)

	label(0x37)
	if_saw_death(0x00, /*goto*/ 0x1d)
	if_saw_injury(0x00, /*goto*/ 0x1e)
	if_target_in_sight(/*goto*/ 0x04)
	goto_first(0x10)

	label(0x04)
	restart_timer
	label(0x05)
	yield
	if_saw_death(0x00, /*goto*/ 0x1d)
	if_saw_injury(0x00, /*goto*/ 0x1e)
	if_chr_weapon_equipped(CHR_P1P2, WEAPON_UNARMED, /*goto*/ 0x03)
	goto_next(0x04)

	label(0x03)
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x03)
	if_distance_to_target_gt(450, /*goto*/ 0x03)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	set_returnlist(CHR_SELF, AILIST_CIA)
	set_ailist(CHR_SELF, GAILIST_CIVILIAN_SAY_COMMENT)

	label(0x03)
	if_timer_lt(600, /*goto*/ 0x03)
	unset_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	label(0x03)
	dprint 'L','I','M','O',' ','R','E','A','D','Y',' ','T','O',' ','G','O','\n',0,
	goto_first(0x10)

	label(0x1e)
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x04)
		if_timer_gt(40, /*goto*/ 0x04)
	endloop(0x09)

	// Saw a death
	label(0x1d)
	restart_timer
	chr_do_animation(ANIM_LOOK_AROUND_FRANTIC, 0, 193, 0x10, 0x10, CHR_SELF, 2)

	// Shot near chr, or follow through from above
	beginloop(0x1e)
		if_timer_gt(90, /*goto*/ 0x0c)
	endloop(0x1e)

	label(0x04)
	increase_squadron_alertness(100)

	beginloop(0x38)
		if_chr_in_squadron_doing_action(MA_TALKING, /*goto*/ 0x04)
		goto_next(0x03)

		// A civilian is cowering
		label(0x04)
		restart_timer

		beginloop(0x3a)
			if_timer_gt(120, /*goto*/ 0x04)
		endloop(0x3a)

		label(0x04)
		set_self_flag_bankx(CHRFLAG0_00000080, BANK_0)
		set_squadron(SQUADRON_03)
	endloop(0x38)

	label(0x03)
	rebuild_teams
	rebuild_squadrons
	set_action(MA_TALKING, FALSE)
	say_quip(CHR_BOND, 0x18, 0xff, 0x00, 0xff, 0x81, 0x00, 0x00)
	chr_do_animation(ANIM_SURRENDER_002E, 0, 193, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x0a)
		if_timer_gt(120, /*goto*/ 0x0c)
	endloop(0x0a)

	// Alerted
	label(0x0c)
	set_action(MA_NORMAL, FALSE)
	if_self_flag_bankx_eq(CHRFLAG0_00000080, FALSE, BANK_0, /*goto*/ 0x03)
	set_squadron(SQUADRON_04)
	rebuild_teams
	rebuild_squadrons
	label(0x03)
	set_chr_team(CHR_SELF, TEAM_ALLY)
	rebuild_teams
	rebuild_squadrons
	try_set_chrpreset_to_unalerted_teammate(0, /*goto*/ 0x04)
	goto_next(0x0b)

	label(0x03)
	goto_first(0x05)

	label(0x04)
	set_chr_team(CHR_SELF, TEAM_NONCOMBAT)
	rebuild_teams
	rebuild_squadrons
	try_run_to_chr(CHR_PRESET, /*goto*/ 0x06)

	beginloop(0x06)
		if_distance_to_chr_lt(2520, CHR_HIDDENGUY, /*goto*/ 0x03)
		reloop(0x06)

		label(0x03)
		if_detected_chr(CHR_PRESET, /*goto*/ 0x04)
	endloop(0x06)

	label(0x04)
	increase_squadron_alertness(100)
	say_quip(CHR_BOND, 0x19, 0xff, 0x00, 0xff, 0x81, 0x00, 0x00)
	label(0x0b)
	set_chr_team(CHR_SELF, TEAM_NONCOMBAT)
	rebuild_teams
	rebuild_squadrons
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x2d)
	if_self_flag_bankx_eq(CHRFLAG0_00004000, TRUE, BANK_0, /*goto*/ 0x2f)
	run_to_pad(0x00c8)
	goto_next(0x07)

	label(0x2d)
	run_to_pad(0x005a)
	goto_next(0x07)

	label(0x2f)
	run_to_pad(0x0026)
	label(0x07)
	yield
	if_chr_stopped(/*goto*/ 0x04)
	label(0x03)
	goto_first(0x07)

	label(0x04)

	label(0x0e)
		chr_do_animation(ANIM_COWER_0229, -1, -1, 0x10, 0x0a, CHR_SELF, 2)

		beginloop(0x0f)
			if_chr_stopped(/*goto*/ 0x03)
		endloop(0x0f)

		label(0x03)
	goto_first(0x0e)

	endlist
};

u8 func0413_bugspotter[] = {
#define LABEL_RUN_AWAY 0x0d

	set_alertness(255)
	set_shotlist(AILIST_BUGSPOTTER)
	if_chr_dying(CHR_SELF, /*goto*/ 0x04)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x04)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x04)
	goto_next(0x03)

	label(0x04)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x03)

	// Wait until player in sight (mainly)
	beginloop(0x10)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x04)
		if_stage_flag_eq(STAGEFLAG_LIMO_READY_TO_LEAVE, TRUE, /*goto*/ LABEL_RUN_AWAY)
		if_stage_flag_eq(STAGEFLAG_TRACERBUG_PLACED, TRUE, /*goto*/ LABEL_RUN_AWAY)
		if_stage_flag_eq(STAGEFLAG_TAXI_READY_TO_CRASH, TRUE, /*goto*/ LABEL_RUN_AWAY)
		if_object_in_good_condition(OBJ_LIMO, /*goto*/ 0x03)
		goto_next(LABEL_RUN_AWAY)
		label(0x03)
	endloop(0x10)

	// Player in sight - face them
	label(0x04)
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x04)

	beginloop(0x09)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x04)
		if_timer_gt(40, /*goto*/ 0x04)
	endloop(0x09)

	// Make a comment
	label(0x04)
	if_chr_weapon_equipped(CHR_P1P2, WEAPON_UNARMED, /*goto*/ 0x03)
	if_chr_weapon_equipped(CHR_P1P2, WEAPON_NONE, /*goto*/ 0x03)
	say_quip(CHR_BOND, 0x1a, 0xff, 0x0a, 0xff, 0x81, 0x00, 0x00)
	goto_next(0x04)
	label(0x03)
	say_quip(CHR_BOND, 0x17, 0xff, 0x0a, 0xff, 0x81, 0x00, 0x00)
	label(0x04)
	chr_do_animation(ANIM_TALKING_00A3, 0, -1, 0x00, 0x10, CHR_SELF, 2)

	// Looks like he spots if the tracer bug if he sees Jo within 8.3 seconds of
	// the bug landing on the limo.
	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_LIMO_READY_TO_LEAVE, TRUE, /*goto*/ LABEL_RUN_AWAY)
		if_stage_flag_eq(STAGEFLAG_TAXI_READY_TO_CRASH, TRUE, /*goto*/ LABEL_RUN_AWAY)
		if_object_in_good_condition(OBJ_LIMO, /*goto*/ 0x03)
		goto_next(LABEL_RUN_AWAY)

		label(0x03)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x03)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x03)
		goto_next(0x0a)
		label(0x03)
		if_stage_flag_eq(STAGEFLAG_TRACERBUG_SAFE, TRUE, /*goto*/ 0x0a)
		if_stage_flag_eq(STAGEFLAG_TRACERBUG_PLACED, TRUE, /*goto*/ 0x04)
		label(0x0a)
		if_timer_gt(500, /*goto*/ 0x03)
	endloop(0x08)

	label(0x03)
	if_stage_flag_eq(STAGEFLAG_TRACERBUG_PLACED, TRUE, /*goto*/ LABEL_RUN_AWAY)
	goto_first(0x10)

	// Bug was thrown recently
	label(0x04)
	chr_do_animation(ANIM_TALKING_00A3, 0, -1, 0x00, 0x10, CHR_SELF, 2)
	assign_sound(0x044a, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)
	set_stage_flag(STAGEFLAG_TRACERBUG_SPOTTED)
	show_hudmsg(CHR_BOND, L_PETE(67)) // "Tracer Bug has been spotted."

	// Wait for talking animation to finish
	beginloop(0x05)
		if_stage_flag_eq(STAGEFLAG_LIMO_READY_TO_LEAVE, TRUE, /*goto*/ LABEL_RUN_AWAY)
		if_stage_flag_eq(STAGEFLAG_TAXI_READY_TO_CRASH, TRUE, /*goto*/ LABEL_RUN_AWAY)
		if_object_in_good_condition(OBJ_LIMO, /*goto*/ 0x03)
		goto_next(LABEL_RUN_AWAY)
		label(0x03)
		if_chr_stopped(/*goto*/ 0x04)
	endloop(0x05)

	// Find another guard and run to them
	label(0x04)
	try_set_chrpreset_to_unalerted_teammate(0, /*goto*/ 0x04)
	goto_next(0x0b)

	label(0x04)
	try_run_to_chr(CHR_PRESET, /*goto*/ 0x06)

	// Wait until detected target guard
	beginloop(0x06)
		if_stage_flag_eq(STAGEFLAG_LIMO_READY_TO_LEAVE, TRUE, /*goto*/ LABEL_RUN_AWAY)
		if_stage_flag_eq(STAGEFLAG_TAXI_READY_TO_CRASH, TRUE, /*goto*/ LABEL_RUN_AWAY)
		if_object_in_good_condition(OBJ_LIMO, /*goto*/ 0x03)
		goto_next(LABEL_RUN_AWAY)
		label(0x03)
		if_detected_chr(CHR_PRESET, /*goto*/ 0x04)
	endloop(0x06)

	// Alert everyone in group
	label(0x04)
	increase_squadron_alertness(100)
	assign_sound(0x0467, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)

	// No other guard to run to
	label(0x0b)
	retreat(SPEED_RUN, 2)

	beginloop(0x07)
		if_stage_flag_eq(STAGEFLAG_LIMO_READY_TO_LEAVE, TRUE, /*goto*/ LABEL_RUN_AWAY)
		if_stage_flag_eq(STAGEFLAG_TAXI_READY_TO_CRASH, TRUE, /*goto*/ LABEL_RUN_AWAY)
		if_object_in_good_condition(OBJ_LIMO, /*goto*/ 0x03)
		goto_next(LABEL_RUN_AWAY)
		label(0x03)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_within_units_of_sight(30, /*goto*/ 0x03)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_within_units_of_sight(30, /*goto*/ 0x03)
		goto_next(0x04)
		label(0x03)
	goto_first(0x07)

	label(0x04)
	restart_timer

	beginloop(0x0e)
		if_timer_gt(10, /*goto*/ 0x03)
	endloop(0x0e)

	label(0x03)
	chr_toggle_p1p2(CHR_SELF)
	set_target_chr(CHR_P1P2)
	if_within_units_of_sight(30, /*goto*/ 0x03)
	goto_next(0x04)
	label(0x03)
	goto_first(0x07)

	label(0x04)
	unset_self_chrflag(CHRCFLAG_KILLCOUNTABLE)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	yield
	drop_gun_and_fade_out
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(LABEL_RUN_AWAY)
	jog_to_pad(0x004f)

	beginloop(0x0e)
		if_chr_stopped(/*goto*/ 0x04)
	endloop(0x0e)

	label(0x04)
	stop_chr
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define init_patroller(pathid) \
	set_chr_dodge_rating(2, 0x0a) \
	set_accuracy(4) \
	set_reaction_speed(30) \
	set_chr_maxdamage(CHR_SELF, 40) \
	add_health_or_armor(0) \
	set_recovery_speed(0) \
	set_shield(0) \
	assign_path(pathid) \
	start_path \
	set_ailist(CHR_SELF, GAILIST_UNALERTED) \
 \
	beginloop(0x04) \
	endloop(0x04)



u8 func0414_start_path07[] = {
	init_patroller(0x07)
	endlist
};

u8 func0415_start_path08[] = {
	init_patroller(0x08)
	endlist
};

u8 func0416_start_path09[] = {
	init_patroller(0x09)
	endlist
};

u8 func0417_start_path10[] = {
	init_patroller(0x0a)
	endlist
};

u8 func0418_start_path11[] = {
	init_patroller(0x0b)
	endlist
};

/**
 * This chr waits 2 seconds before starting his path.
 */
u8 func0419_init_cia1[] = {
	restart_timer

	beginloop(0x05)
		if_timer_gt(120, /*goto*/ 0x04)
	endloop(0x05)

	label(0x04)
	assign_path(12)
	start_path
	set_ailist(CHR_SELF, AILIST_CIA)

	beginloop(0x04)
	endloop(0x04)

	endlist
};

u8 func041d_fbi[] = {
	set_shotlist(AILIST_FBI)
	if_chr_dying(CHR_SELF, /*goto*/ 0x04)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x04)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x04)
	goto_next(0x03)

	label(0x04)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x03)
	if_num_times_shot_lt(1, /*goto*/ 0x19)

	// Shot - wait for animation to finish
	beginloop(0x05)
		if_chr_stopped(/*goto*/ 0x04)
	endloop(0x05)

	label(0x04)
	goto_next(0x17)

	// Unreachable
	label(0x04)
	say_quip(CHR_BOND, 0x1b, 0xff, 0x00, 0xff, 0x81, 0x00, 0x00)
	increase_squadron_alertness(100)
	goto_next(0x16)

	// Not shot
	label(0x19)
		set_action(MA_NORMAL, TRUE)
		yield
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_alertness(100, OPERATOR_LESS_THAN, /*goto*/ 0x04)
		goto_next(0x16)

		label(0x04)
		if_target_in_sight(/*goto*/ 0x18)
		if_near_miss(/*goto*/ 0x18)
		if_num_times_shot_gt(0, /*goto*/ 0x18)
		if_hears_gunfire(/*goto*/ 0x16)
		if_saw_injury(0x00, /*goto*/ 0x16)
		if_saw_death(0x00, /*goto*/ 0x16)
		if_sees_suspicious_item(/*goto*/ 0x16)
	endloop(0x19)

	label(0x16)
	if_stage_flag_eq(STAGEFLAG_ALARM_SOUNDED, FALSE, /*goto*/ 0x04)

	// Draw magnum and go after player
	label(0x17)
	try_equip_weapon(MODEL_CHRDY357, WEAPON_DY357MAGNUM, 0x10000000, /*goto*/ 0x03)
	label(0x03)
	set_ailist(CHR_SELF, GAILIST_ALERTED)

	label(0x04)
	dprint 'T','R','A','C','K',' ','P','L','A','Y','E','R','\n',0,
	try_jog_to_target(/*goto*/ 0x06)

	beginloop(0x06)
		if_distance_to_target_lt(500, /*goto*/ 0x18)
		if_target_in_sight(/*goto*/ 0x18)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x18)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
	endloop(0x06)

	label(0x18)
	if_stage_flag_eq(STAGEFLAG_ALARM_SOUNDED, FALSE, /*goto*/ 0x04)
	try_equip_weapon(MODEL_CHRDY357, WEAPON_DY357MAGNUM, 0x10000000, /*goto*/ 0x03)
	label(0x03)
	set_ailist(CHR_SELF, GAILIST_ALERTED)

	label(0x04)
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x0d)

	beginloop(0x0d)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x04)
		if_timer_gt(40, /*goto*/ 0x04)
	endloop(0x0d)

	label(0x04)
	say_quip(CHR_BOND, 0x1b, 0xff, 0x00, 0xff, 0x81, 0x00, 0x00)
	chr_do_animation(0x0266, 0, 193, 0x00, 0x10, CHR_SELF, 2)

	beginloop(0x0e)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x03)
		if_chr_propsoundcount_zero(CHR_SELF, /*goto*/ 0x04)
		label(0x03)
		if_chr_stopped(/*goto*/ 0x04)
	endloop(0x0e)

	label(0x04)
	dprint 'C','R','E','A','T','E','D',' ','W','E','A','P','\n',0,
	try_equip_weapon(MODEL_CHRDY357, WEAPON_DY357MAGNUM, 0x10000000, /*goto*/ 0x04)
	label(0x04)
	yield
	set_stage_flag(STAGEFLAG_ALARM_SOUNDED)
	activate_alarm
	dprint 'C','R','E','A','T','E','D',' ','W','E','A','P','\n',0,
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

#define check_cia_dead(chr) \
	beginloop(0x10) \
		if_chr_dying(chr, /*goto*/ 0x05) \
	endloop(0x10) \
 \
	/* Unreachable */ \
	label(0x03) \
	set_ailist(CHR_SELF, GAILIST_IDLE) \
 \
	label(0x05) \
	set_stage_flag(STAGEFLAG_CIVILIAN_DEAD) \
	show_hudmsg(CHR_BOND, 0x321d) /* "Mission failed - unacceptable civilian casualties." */ \
	set_ailist(CHR_SELF, GAILIST_IDLE)



u8 func1009_check_cia1_dead[] = {
	check_cia_dead(CHR_CIA1)
	endlist
};

/**
 * This guy is allowed to be killed once he has a certain flag.
 */
u8 func100a_check_cia2_dead[] = {
	beginloop(0x10)
		if_chr_has_flag_bankx(CHR_CIA2, CHRFLAG0_00002000, BANK_0, /*goto*/ 0x03)
		if_chr_dying(CHR_CIA2, /*goto*/ 0x05)
	endloop(0x10)

	// Stop checking this chr
	label(0x03)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x05)
	set_stage_flag(STAGEFLAG_CIVILIAN_DEAD)
	show_hudmsg(CHR_BOND, L_PETE(29)) // "Mission failed - unacceptable civilian casualties."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100b_check_cia3_dead[] = {
	check_cia_dead(CHR_CIA3)
	endlist
};

u8 func100c_check_cia4_dead[] = {
	check_cia_dead(CHR_CIA4)
	endlist
};

u8 func041b_init_robot[] = {
	set_accuracy(40)
	set_shield(100)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_10000000)
	set_ailist(CHR_SELF, AILIST_ROBOT)
	endlist
};

u8 func041a_robot[] = {
	set_self_chrflag(CHRCFLAG_00040000)
	set_chr_maxdamage(CHR_SELF, 1)
	if_chr_dying(CHR_SELF, /*goto*/ 0x0c)
	assign_path(0)
	start_path

	beginloop(0x02)
		set_target_chr(CHR_HIDDENGUY)
		if_target_moving_closer(/*goto*/ 0x03)
		unset_stage_flag(STAGEFLAG_ROBOT_NEAR_HOME)
		goto_next(0x04)

		label(0x03)
		set_stage_flag(STAGEFLAG_ROBOT_NEAR_HOME)

		label(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_CRASH, TRUE, /*goto*/ 0x01)
		if_target_in_sight(/*goto*/ 0x08)
		call_rng
		if_rand_gt(5, /*goto*/ 0x03)
		if_sound_finished(CHANNEL_5, /*goto*/ 0x04)
		goto_next(0x03)

		label(0x04)
		call_rng
		if_rand_lt(86, /*goto*/ 0x06)
		if_rand_lt(172, /*goto*/ 0x07)
		assign_sound(0x046a, CHANNEL_5)
		play_sound_from_entity(CHANNEL_5, CHR_SELF, 0x0bb8, 0x1770, 0x01)
		goto_next(0x03)

		label(0x06)
		assign_sound(0x046b, CHANNEL_5)
		play_sound_from_entity(CHANNEL_5, CHR_SELF, 0x0bb8, 0x1770, 0x01)
		goto_next(0x03)

		label(0x07)
		assign_sound(0x046c, CHANNEL_5)
		play_sound_from_entity(CHANNEL_5, CHR_SELF, 0x0bb8, 0x1770, 0x01)
		label(0x03)

		if_path_started(/*goto*/ 0x03)
		start_path
		label(0x03)
		reloop(0x02)

		label(0x08)
		restart_timer
		stop_chr
		if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x05)
		play_sound(0x1aeb, -1)
		set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
		label(0x05)
		try_unset_chr_flag_bank3_02000000(CHR_SELF, /*goto*/ 0x03)
		goto_next(0x05)

		label(0x03)
		if_self_flag_bankx_eq(CHRFLAG0_00004000, TRUE, BANK_0, /*goto*/ 0x05)
		play_sound(0x1aec, -1)
		set_self_flag_bankx(CHRFLAG0_00004000, BANK_0)

		beginloop(0x05)
			set_target_chr(CHR_HIDDENGUY)
			if_target_moving_closer(/*goto*/ 0x03)
			unset_stage_flag(STAGEFLAG_ROBOT_NEAR_HOME)
			goto_next(0x04)
			label(0x03)
			set_stage_flag(STAGEFLAG_ROBOT_NEAR_HOME)
			label(0x04)
			set_target_chr(CHR_P1P2)
			if_stage_flag_eq(STAGEFLAG_TRIGGER_CRASH, TRUE, /*goto*/ 0x01)
			if_timer_gt(120, /*goto*/ 0x04)
			if_self_flag_bankx_eq(CHRFLAG0_00002000, FALSE, BANK_0, /*goto*/ 0x2a)
			if_target_in_sight(/*goto*/ 0x03)
			label(0x2a)
		endloop(0x05)

		label(0x03)
		set_target_chr(CHR_P1P2)
		restart_timer
		try_aim_and_shoot_thing1(0x0200, 0x0000, /*goto*/ 0x09)
		reloop(0x02)

		beginloop(0x09)
			unset_stage_flag(STAGEFLAG_ROBOT_NEAR_HOME)
			set_target_chr(CHR_P1P2)
			if_stage_flag_eq(STAGEFLAG_TRIGGER_CRASH, TRUE, /*goto*/ 0x01)
			if_timer_gt(60, /*goto*/ 0x04)
			if_chr_stopped(/*goto*/ 0x04)
		endloop(0x09)

		label(0x04)
		set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
		start_path
	endloop(0x02)

	label(0x0c)
	assign_sound(0x1aec, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x01)
	label(0x04)
	label(0x38)
	set_chr_chrflag(CHR_ROBOT, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_ROBOT, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_ROBOT, CHRHFLAG_00020000)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_hiddenflag(CHR_SELF, CHRHFLAG_10000000)
	set_ailist(CHR_ROBOT, GAILIST_IDLE)
	set_shield(0)
	chr_do_animation(0x016a, 0, -1, 0x06, 0x00, CHR_SELF, 4)

	beginloop(0x2d)
		dprint 'P','A','R','T',' ','4','\n',0,
		if_chr_stopped(/*goto*/ 0x04)
	goto_first(0x2d)

	label(0x04)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func041e_sealer1[] = {
#define LABEL_ALERTED 0x18

	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(4)
	set_reaction_speed(30)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_shotlist(GAILIST_IDLE)

	beginloop(0x19)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_stage_flag_eq(STAGEFLAG_CRASH_FINISHED, TRUE, /*goto*/ 0x03)
		if_alertness(100, OPERATOR_LESS_THAN, /*goto*/ 0x04)
		goto_next(LABEL_ALERTED)

		label(0x04)
		if_target_in_sight(/*goto*/ LABEL_ALERTED)
		if_near_miss(/*goto*/ LABEL_ALERTED)
		if_num_times_shot_gt(0, /*goto*/ LABEL_ALERTED)
		if_hears_gunfire(/*goto*/ LABEL_ALERTED)
		if_saw_injury(0x00, /*goto*/ LABEL_ALERTED)
		if_saw_death(0x00, /*goto*/ LABEL_ALERTED)
		if_sees_suspicious_item(/*goto*/ LABEL_ALERTED)
	endloop(0x19)

	// Crash happened
	label(0x03)
	unset_chr_hiddenflag(CHR_SELF, CHRHFLAG_PASSIVE)
	jog_to_pad(0x00c4)
	set_ailist(CHR_SEALER2, AILIST_JOG_TO_ACCIDENT)
	set_ailist(CHR_SEALER3, AILIST_JOG_TO_ACCIDENT)
	set_ailist(CHR_SEALER4, AILIST_JOG_TO_ACCIDENT)

	beginloop(0x0d)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x03)
		if_chr_stopped(/*goto*/ 0x04)
	endloop(0x0d)

	// At crash site
	label(0x04)
	restart_timer

	beginloop(0x0c)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x03)
		if_timer_gt(120, /*goto*/ 0x04)
	endloop(0x0c)

	label(0x03)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)

	// Conversation
	label(0x04)
	assign_sound(0x814b, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)
	chr_do_animation(ANIM_TALKING_0098, -1, -1, 0x02, 0x00, CHR_SELF, 2)
	restart_timer

	beginloop(0x07)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x04)
		if_timer_gt(120, /*goto*/ 0x03)
	endloop(0x07)

	label(0x03)
	assign_sound(0x044f, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)
	chr_do_animation(ANIM_TALKING_0231, -1, -1, 0x02, 0x00, CHR_SEALER1, 2)
	chr_do_animation(ANIM_TWO_GUN_HOLD, -1, -1, 0x02, 0x00, CHR_SELF, 2)

	beginloop(0x08)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x04)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x03)
	goto_first(0x08)

	label(0x03)
	assign_sound(0x0450, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)
	chr_do_animation(ANIM_TALKING_0233, -1, -1, 0x02, 0x00, CHR_SEALER3, 2)
	chr_do_animation(ANIM_TWO_GUN_HOLD, -1, -1, 0x02, 0x00, CHR_SEALER1, 2)
	restart_timer

	beginloop(0x09)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x04)
		if_timer_gt(180, /*goto*/ 0x03)
	goto_first(0x09)

	label(0x03)
	assign_sound(0x0451, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)
	chr_do_animation(ANIM_TALKING_0232, -1, -1, 0x02, 0x00, CHR_SEALER1, 2)
	chr_do_animation(ANIM_TWO_GUN_HOLD, -1, -1, 0x02, 0x00, CHR_SEALER3, 2)
	restart_timer

	beginloop(0x0a)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x04)
		if_timer_gt(120, /*goto*/ 0x03)
	goto_first(0x0a)

	label(0x03)
	assign_sound(0x0452, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)
	chr_do_animation(ANIM_TALKING_0234, -1, -1, 0x02, 0x00, CHR_SEALER3, 2)
	chr_do_animation(ANIM_TWO_GUN_HOLD, -1, -1, 0x02, 0x00, CHR_SEALER1, 2)

	beginloop(0x0b)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x04)
		if_saw_injury(0x00, /*goto*/ 0x04)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x04)
	endloop(0x0b)

	label(0x04)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)

	// Alerted - seal elevator
	label(LABEL_ALERTED)
	label(0x04)
	close_door(0x10)
	close_door(0x11)
	lock_door(0x10, 0x02)
	lock_door(0x11, 0x02)
	set_stage_flag(STAGEFLAG_ELEVATOR_SEALED)
	assign_sound(0x0469, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)
	show_hudmsg(CHR_BOND, L_PETE(33)) // "Elevator access sealed."
	chr_do_animation(ANIM_STANDING_TYPE_ONE_HAND, 0, 193, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x06)
		if_chr_stopped(/*goto*/ 0x04)
	goto_first(0x06)

	label(0x04)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

u8 func100d_spawn_alarm_responders[] = {
	restart_timer
	beginloop(0x05)
		if_stage_flag_eq(STAGEFLAG_ALARM_SOUNDED, TRUE, /*goto*/ 0x03)
	endloop(0x05)

	label(0x03)
	restart_timer
	play_sound(L_MP13(240), -1) // "Attention all personnel"

	beginloop(0x1d)
		if_timer_gt(200, /*goto*/ 0x03)
	endloop(0x1d)

	label(0x03)
	restart_timer
	play_sound(L_MP13(241), -1) // "Locate and apprehend fugitive"

	beginloop(0x1e)
		if_timer_gt(120, /*goto*/ 0x03)
	endloop(0x1e)

	label(0x03)
	play_x_music(CHANNEL_10, 60)
	goto_next(0x04)

	// When the alarm sounds, there are 4 groups of people who respond.
	// Each group has 4 guards, and the entire group must be dead before the
	// next group is spawned. There is a 15 second delay between groups.
	// Each group spawns at a different location.

	#define spawn_group(pad) \
		try_spawn_chr_at_pad(BODY_G5_SWAT_GUARD, HEAD_RANDOM, pad, AILIST_ALARM_RESPONDER, 0x00000200, /*goto*/ 0x04) \
		label(0x04) \
		yield \
		yield \
		yield \
		yield \
		yield \
		try_spawn_chr_at_pad(BODY_G5_SWAT_GUARD, HEAD_RANDOM, pad, AILIST_ALARM_RESPONDER, 0x00000200, /*goto*/ 0x04) \
		label(0x04) \
		yield \
		yield \
		yield \
		yield \
		yield \
		try_spawn_chr_at_pad(BODY_G5_SWAT_GUARD, HEAD_RANDOM, pad, AILIST_ALARM_RESPONDER, 0x00000200, /*goto*/ 0x04) \
		label(0x04) \
		yield \
		yield \
		yield \
		yield \
		yield \
		try_spawn_chr_at_pad(BODY_G5_SWAT_GUARD, HEAD_RANDOM, pad, AILIST_ALARM_RESPONDER, 0x00000200, /*goto*/ 0x04) \
		label(0x04)



	label(0x07)
		unlock_door(0x14, 0x04)
		restart_timer
		if_stage_flag_eq(STAGEFLAG_ALARM_GROUP1_DEAD, TRUE, /*goto*/ 0x08)

		// Spawn group 1
		spawn_group(0x0067)
		goto_next(0x06)

		// Group 1 is already done
		label(0x08)
		unlock_door(0x15, 0x04)
		unlock_door(0x16, 0x04)
		if_stage_flag_eq(STAGEFLAG_ALARM_GROUP2_DEAD, TRUE, /*goto*/ 0x09)

		// Spawn group 2
		spawn_group(0x00c2)
		goto_next(0x06)

		// Groups 1 and 2 are done
		label(0x09)
		unlock_door(0x17, 0x04)
		unlock_door(0x18, 0x04)
		if_stage_flag_eq(STAGEFLAG_ALARM_GROUP3_DEAD, TRUE, /*goto*/ 0x0a)

		// Spawn group 3
		spawn_group(0x00c3)
		goto_next(0x06)

		// Groups 1, 2 and 3 are done
		// Spawn group 3
		label(0x0a)
		unlock_door(0x19, 0x04)
		spawn_group(0x00c1)
		goto_next(0x06)

		// Wait until group is dead
		beginloop(0x06)
			if_all_chrs_in_squadron_are_dead(GROUP_ALARM_RESPONDER, /*goto*/ 0x04)
		endloop(0x06)

		// Set this group as dead
		label(0x04)
		if_stage_flag_eq(STAGEFLAG_ALARM_GROUP1_DEAD, TRUE, /*goto*/ 0x04)
		set_stage_flag(STAGEFLAG_ALARM_GROUP1_DEAD)
		goto_next(0x03)

		label(0x04)
		if_stage_flag_eq(STAGEFLAG_ALARM_GROUP2_DEAD, TRUE, /*goto*/ 0x04)
		set_stage_flag(STAGEFLAG_ALARM_GROUP2_DEAD)
		goto_next(0x03)

		label(0x04)
		if_stage_flag_eq(STAGEFLAG_ALARM_GROUP3_DEAD, TRUE, /*goto*/ 0x04)
		set_stage_flag(STAGEFLAG_ALARM_GROUP3_DEAD)
		goto_next(0x03)

		label(0x04)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		// Wait 15 seconds
		label(0x03)
		restart_timer

		beginloop(0x2d)
			if_timer_gt(900, /*goto*/ 0x04)
		endloop(0x2d)

		// Loop again to trigger next group
		label(0x04)
	goto_first(0x07)

	endlist
};

u8 func041f_alarm_responder[] = {
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	set_self_flag_bankx(CHRFLAG0_80000000, BANK_0)
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(14)
	set_reaction_speed(20)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	try_equip_weapon(MODEL_CHRDY357, WEAPON_DY357MAGNUM, 0x00000000, /*goto*/ 0x04)
	label(0x04)
	set_chr_team(CHR_SELF, TEAM_20)
	set_squadron(GROUP_ALARM_RESPONDER)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	set_self_flag_bankx(CHRFLAG0_00008000, BANK_0)
	set_alertness(90)
	set_self_chrflag(CHRCFLAG_00000200)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_SEARCH_FOR_PLAYER)
	endlist
};

u8 func0420_jog_to_accident[] = {
	unset_chr_hiddenflag(CHR_SELF, CHRHFLAG_PASSIVE)
	label(0x03)
	go_to_target_pad(SPEED_JOG)

	// This is a bit weird. I'm pretty sure the set_ailist causes this
	// function to stop. But because the guard has been issued the
	// go_to_target_pad command, he'll continue to do so while running the
	// unalerted function.
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	yield
	if_chr_stopped(/*goto*/ 0x04)
	goto_first(0x0d)

	label(0x04)
	endlist
};

u8 func040a_intro_from_gameplay[] = {
	set_ailist(CHR_SELF, 0x040a)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101f_setup_robot_noise[] = {
	play_sound_from_object2(CHANNEL_2, CHR_ROBOT, 0x80b9, 0x00, 0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Not sure why it would give briefcases to the players.
 * Note this is a coop/counterop only function.
 */
u8 func1400_give_briefcases[] = {
	yield
	set_chr_team(CHR_ANTI, TEAM_20)
	set_chr_chrflag(CHR_TOPSTAIRS, CHRCFLAG_HAS_SPECIAL_DEATH_ANIMATION)
	set_chr_chrflag(CHR_TOPSTAIRS, CHRCFLAG_00000020)
	set_chr_chrflag(0x0a, CHRCFLAG_00000020)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x03)

	// PA
	give_object_to_chr(OBJ_BRIEFCASE3, CHR_BOND)

	// All difficulties
	label(0x03)
	give_object_to_chr(OBJ_BRIEFCASE4, CHR_BOND)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x03)

	if_difficulty_lt(DIFF_PA, /*goto*/ 0x04)

	// PA
	give_object_to_chr(OBJ_BRIEFCASE5, CHR_COOP)

	// All difficulties
	label(0x04)
	give_object_to_chr(OBJ_BRIEFCASE6, CHR_COOP)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)

	// Velvet doesn't exist
	label(0x03)
	hide_object(OBJ_BRIEFCASE3)
	hide_object(OBJ_BRIEFCASE5)
	hide_object(OBJ_BRIEFCASE6)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func1002_rebuild_groups[] = {
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func1010_elevator_switch[] = {
	yield
	open_door(0x10)
	open_door(0x11)
	yield

	beginloop(0x10)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_SWITCH, /*goto*/ 0x03)
		if_stage_flag_eq(STAGEFLAG_ELEVATOR_SEALED, TRUE, /*goto*/ 0x04)
		label(0x04)
	endloop(0x10)

	label(0x03)
	close_door(0x10)
	close_door(0x11)
	lock_door(0x10, 0x02)
	lock_door(0x11, 0x02)
	if_stage_flag_eq(STAGEFLAG_ELEVATOR_SEALED, TRUE, /*goto*/ 0x04)
	show_hudmsg(CHR_P1P2, L_PETE(33)) // "Elevator access sealed."
	set_stage_flag(STAGEFLAG_ELEVATOR_SEALED)
	goto_first(0x10)

	label(0x04)
	show_hudmsg(CHR_P1P2, L_PETE(48)) // "Elevator door cannot be reopened."
	goto_first(0x10)

	endlist
};

u8 func1001_objectives_failed_msg[] = {
	yield
	set_chr_chrflag(CHR_CIA1, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_CIA2, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_CIA3, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_CIA4, CHRCFLAG_04000000)
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

u8 func1014_crash[] = {
	beginloop(0x02)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_CRASH, TRUE, /*goto*/ 0x04)
	endloop(0x02)

	label(0x04)
	restart_timer

	beginloop(0x09)
		if_timer_gt(230, /*goto*/ 0x04)
	endloop(0x09)

	label(0x04)
	move_object_to_pad(OBJ_MINE1, 0x0029)
	destroy_object(OBJ_MINE1)
	set_stage_flag(STAGEFLAG_DIVERSION_CREATED)
	show_hudmsg(CHR_BOND, L_PETE(54)) // "Diversion has been created."
	destroy_object(OBJ_TAXI)
	restart_timer

	beginloop(0x0a)
		if_timer_gt(180, /*goto*/ 0x04)
	endloop(0x0a)

	label(0x04)
	move_object_to_pad(OBJ_MINE2, 0x001c)
	destroy_object(OBJ_MINE2)
	set_stage_flag(STAGEFLAG_CRASH_FINISHED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040a_intro_sfx[] = {
	// This flag is used to trigger the intro. Note that the entire function
	// loops, so Rare could have tested the intro by setting the flag again.
	label(0x2b)
	if_stage_flag_eq(STAGEFLAG_TRIGGER_INTRO, TRUE, /*goto*/ 0x2c)
	yield
	goto_first(0x2b)

	label(0x2c)
	unset_stage_flag(STAGEFLAG_TRIGGER_INTRO)
	label(0x10)
	yield
	dprint 'C','U','T','S','C','E','N','E',' ','S','T','A','R','T','E','D','\n',0,
	label(0x03)
	restart_timer
	dprint 'C','U','T','S','C','E','N','E',' ','S','T','A','R','T','E','D','\n',0,

	#define wait_until(time, loopid) \
		beginloop(loopid) \
			if_stage_flag_eq(STAGEFLAG_INTRO_FINISHED, TRUE, /*goto*/ 0x2e) \
			if_timer_gt(time, /*goto*/ 0x04) \
		endloop(loopid) \
		label(0x04)



	wait_until(30, 0x55)
	speak(CHR_BOND, L_PETE(68), 0x7408, CHANNEL_7, COLOR_05_GREEN) // "We suspect the G5 Corporation is just a front for ..."

	wait_until(1060, 0x56)
	speak(CHR_BOND, L_PETE(69), 0x7409, CHANNEL_7, COLOR_09_BLUE) // "Just who is this help you keep referring to?"

	wait_until(1260, 0x57)
	speak(CHR_BOND, L_PETE(70), 0x740a, CHANNEL_7, COLOR_05_GREEN) // "Not now, Joanna. Time for radio silence. Good luck..."

	wait_until(1488, 0x58)
	speak(CHR_BOND, L_PETE(71), 0x740b, CHANNEL_7, COLOR_09_BLUE) // "Thanks a lot."

	label(0x2d)
	yield
	label(0x03)
	if_stage_flag_eq(STAGEFLAG_INTRO_FINISHED, TRUE, /*goto*/ 0x2e)
	if_timer_gt(1468, /*goto*/ 0x04)
	goto_first(0x2d)

	label(0x04)
	play_sound(0x0161, CHANNEL_3)

	wait_until(1519, 0x2f)
	play_sound(0x0162, CHANNEL_3)

	wait_until(1566, 0x30)
	play_sound(0x046d, CHANNEL_4)

	wait_until(1649, 0x31)
	play_sound(0x046d, CHANNEL_3)

	label(0x33)
	wait_until(1758, 0x34)
	play_sound(0x0164, CHANNEL_4)

	wait_until(1784, 0x35)
	play_sound(0x0163, CHANNEL_3)

	wait_until(1814, 0x36)
	play_sound(0x0162, CHANNEL_3)

	wait_until(1855, 0x37)
	play_sound(0x0161, CHANNEL_3)

	wait_until(1897, 0x38)
	play_sound(0x0470, CHANNEL_3)

	wait_until(2017, 0x3a)
	play_sound(0x0165, CHANNEL_3)

	wait_until(2028, 0x3b)
	play_sound(0x046e, CHANNEL_4)

	wait_until(2050, 0x3c)
	play_sound(0x0472, CHANNEL_3)

	wait_until(2175, 0x3d)
	play_sound(0x0473, CHANNEL_4)

	wait_until(2239, 0x3e)
	play_sound(0x0474, CHANNEL_3)

	wait_until(2269, 0x3f)
	play_sound(0x0475, CHANNEL_4)

	wait_until(2278, 0x41)
	play_sound(0x0166, CHANNEL_3)

	wait_until(2280, 0x40)
	play_sound(0x046f, CHANNEL_4)

	wait_until(2323, 0x42)
	play_sound(0x0165, CHANNEL_3)

	wait_until(2339, 0x43)
	play_sound(0x0166, CHANNEL_3)

	wait_until(2356, 0x44)
	play_sound(0x0167, CHANNEL_3)

	wait_until(2373, 0x45)
	play_sound(0x0168, CHANNEL_3)

	wait_until(2386, 0x46)
	play_sound(0x0165, CHANNEL_3)

	wait_until(2388, 0x47)

	wait_until(2402, 0x48)
	mute_channel(CHANNEL_4)
	play_sound(0x0166, CHANNEL_3)

	wait_until(2404, 0x4a)
	play_sound(0x0080, CHANNEL_4)

	wait_until(2424, 0x49)
	play_sound(0x0167, CHANNEL_3)

	wait_until(2434, 0x4c)
	play_sound(0x0476, CHANNEL_3)

	wait_until(2584, 0x4b)
	play_sound(0x0161, CHANNEL_5)

	wait_until(2622, 0x4d)
	mute_channel(CHANNEL_5)

	play_sound(0x0162, CHANNEL_4)
	wait_until(2660, 0x4e)
	mute_channel(CHANNEL_5)

	play_sound(0x0163, CHANNEL_6)

	label(0x2e)
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_7)
	goto_first(0x2b)

	endlist
};

u8 func040b_outro[] = {
	camera_movement(0x0178)
	set_music_track(MUSIC_CHICAGO_OUTRO)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0xf1, CHRCFLAG_HIDDEN)
	set_ailist(CHR_P1P2, GAILIST_IDLE)
	set_door_open(0x10)
	set_door_open(0x11)
	hide_object(OBJ_TAXI)
	hide_object(OBJ_LIMO)
	hide_chr(CHR_SEALER1)
	hide_chr(CHR_SEALER2)
	hide_chr(CHR_SEALER3)
	hide_chr(CHR_SEALER4)

	set_chr_chrflag(CHR_P1P2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_P1P2, CHRHFLAG_00020000)
	chr_do_animation(0x0179, -1, -1, 0x06, 0x00, CHR_P1P2, 4)

	restart_timer
	set_cutscene_weapon(CHR_P1P2, -1, -1)
	yield
	set_cutscene_weapon(CHR_P1P2, -1, 0x02)
	show_nonessential_chrs(FALSE)

	#define func0c01_wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0x2e) \
			if_timer_gt(time, /*goto*/ 0x04) \
		endloop(loopid) \
		label(0x04)



	func0c01_wait_until(30, 0x2d)
	play_sound(0x0161, CHANNEL_7)

	func0c01_wait_until(70, 0x2f)
	play_sound(0x0162, CHANNEL_7)

	func0c01_wait_until(120, 0x30)
	play_sound(0x0163, CHANNEL_7)

	func0c01_wait_until(174, 0x31)
	play_sound(0x0164, CHANNEL_7)

	func0c01_wait_until(208, 0x32)
	play_sound(0x046d, CHANNEL_6)

	func0c01_wait_until(210, 0x33)
	play_sound(0x0161, CHANNEL_7)

	func0c01_wait_until(238, 0x34)
	play_sound(0x0162, CHANNEL_7)

	func0c01_wait_until(280, 0x35)
	play_sound(0x0171, CHANNEL_7)

	func0c01_wait_until(350, 0x36)
	play_sound(0x0173, CHANNEL_7)

	func0c01_wait_until(458, 0x37)
	play_sound(0x0172, CHANNEL_7)

	func0c01_wait_until(506, 0x38)
	play_sound(0x0171, CHANNEL_7)

	func0c01_wait_until(540, 0x39)
	close_door(0x10)
	close_door(0x11)

	func0c01_wait_until(545, 0x3a)
	play_sound(0x0171, CHANNEL_7)

	func0c01_wait_until(588, 0x3b)
	play_sound(0x0172, CHANNEL_7)

	beginloop(0x05)
		if_camera_animating(/*goto*/ 0x03)
		goto_next(0x2e)
		label(0x03)
		if_controller_button_pressed(/*goto*/ 0x2e)
		label(0x03)
	endloop(0x05)

	label(0x2e)
	mute_channel(CHANNEL_7)
	mute_channel(CHANNEL_10)
	label(0x04)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1012_update_robot_prop_flags[] = {
	// pad 0x00d4 = corner
	// pad 0x00d9 = next to limo

	beginloop(0x02)
		// Update ROBOT_NEAR_CORNER flag
		if_stage_flag_eq(STAGEFLAG_ROBOT_NEAR_HOME, FALSE, /*goto*/ 0x03)
		if_chr_distance_to_pad_lt(CHR_ROBOT, 200, 0x00d4, /*goto*/ 0x04)
		label(0x03)
		unset_stage_flag(STAGEFLAG_ROBOT_NEAR_CORNER)
		goto_next(0x03)

		label(0x04)
		set_stage_flag(STAGEFLAG_ROBOT_NEAR_CORNER)

		// Update ROBOT_ON_DRAIN_STREET flag
		label(0x03)
		if_chr_distance_to_pad_gt(CHR_ROBOT, 1800, 0x00d9, /*goto*/ 0x04)
		unset_stage_flag(STAGEFLAG_ROBOT_ON_DRAIN_STREET)
		goto_next(0x03)

		label(0x04)
		set_stage_flag(STAGEFLAG_ROBOT_ON_DRAIN_STREET)
		label(0x03)
	endloop(0x02)

	endlist
};

u8 func1416_setup_rain[] = {
	yield
	yield
	yield
	enable_rain(2)

	label(0x05)
		// Wait 1 second
		restart_timer

		beginloop(0x06)
			if_timer_gt(60, /*goto*/ 0x03)
		endloop(0x06)

		// 12 in 256 chance of changing rain effect
		label(0x03)
		call_rng
		if_rand_lt(12, /*goto*/ 0x03)
		goto_first(0x05)

		label(0x03)
		call_rng
		if_rand_gt(192, /*goto*/ 0x0a)
		if_rand_gt(128, /*goto*/ 0x09)
		if_rand_gt(64, /*goto*/ 0x08)
		enable_rain(2)
		goto_first(0x05)

		label(0x08)
		enable_rain(1)
		goto_first(0x05)

		label(0x09)
		enable_rain(2)
		goto_first(0x05)

		label(0x0a)
		enable_rain(3)
	goto_first(0x05)

	endlist
};

u8 func041c_hiddenguy[] = {
	set_chr_chrflag(CHR_HIDDENGUY, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_HIDDENGUY, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * This function makes two guards unhide and persue Jo after she picks up the
 * drain briefcase.
 */
u8 func1017_drain_guards[] = {
	set_chr_chrflag(0x11, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x12, CHRCFLAG_HIDDEN)

	// Wait until drain briefcase collected
	beginloop(0x05)
		if_objective_complete(0, /*goto*/ 0x03)
	endloop(0x05)

	label(0x03)
	unset_chr_chrflag(0x11, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x12, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x11, CHRHFLAG_00400000)
	set_chr_hiddenflag(0x12, CHRHFLAG_00400000)
	set_ailist(0x11, GAILIST_ALERTED)
	set_ailist(0x12, GAILIST_ALERTED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1018_keep_door_open[] = {
	beginloop(0x10)
		if_door_state(0x1a, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x03)
		reloop(0x10)

		label(0x03)
		open_door(0x1a)
	endloop(0x10)

	endlist
};

u8 func1019_setup_topstairs_death_animation[] = {
	set_chr_special_death_animation(CHR_TOPSTAIRS, SPECIALDIE_OVERRAILING)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040e_6064[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(4)
	set_reaction_speed(30)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func040f_6088[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x03)
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(20)
	set_reaction_speed(30)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	label(0x03)
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(4)
	set_reaction_speed(30)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func0410_60d0[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(14)
	set_reaction_speed(20)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func0411_60f4[] = {
	set_self_chrflag(CHRCFLAG_00020000)
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(14)
	set_reaction_speed(20)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(40)
	set_shield(0)
	set_ailist(CHR_SELF, AILIST_FBI)
	endlist
};

u8 func101a_msg_onlyplace[] = {
	beginloop(0x10)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0014, /*goto*/ 0x03)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0026, /*goto*/ 0x03)
	endloop(0x10)

	label(0x03)
	speak(CHR_P1P2, L_PETE(60), 0x8179, CHANNEL_6, COLOR_09_BLUE) // "The only place we could secure the equipment was a..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101b_msg_blockedupdoors[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0a)
	restart_timer

	// Wait for drain briefcase collected
	beginloop(0x10)
		if_objective_complete(0, /*goto*/ 0x05)
	endloop(0x10)

	beginloop(0x05)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x003a, /*goto*/ 0x03)
	endloop(0x05)

	label(0x03)
	speak(CHR_P1P2, L_PETE(61), 0x73b1, CHANNEL_6, COLOR_09_BLUE) // "Either of those blocked-up doors will do as an esc..."
	label(0x0a)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101c_msg_reprogramthattaxi[] = {
	// Wait for drain briefcase collected
	beginloop(0x10)
		if_objective_complete(0, /*goto*/ 0x05)
	endloop(0x10)

	beginloop(0x05)
		if_object_in_good_condition(OBJ_TAXI, /*goto*/ 0x03)
		reloop(0x05)

		label(0x03)
		if_stage_flag_eq(STAGEFLAG_TAXI_REPROGRAMMED, TRUE, /*goto*/ 0x0a)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x004a, /*goto*/ 0x03)
	endloop(0x05)

	label(0x03)
	speak(CHR_P1P2, L_PETE(62), 0x817a, CHANNEL_6, COLOR_09_BLUE) // "Reprogram that taxi - it's a Mark 2 and should be ..."
	label(0x0a)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101d_msg_pointofingress[] = {
	beginloop(0x10)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0059, /*goto*/ 0x03)
	endloop(0x10)

	label(0x03)
	speak(CHR_P1P2, L_PETE(63), 0x817b, CHANNEL_6, COLOR_09_BLUE) // "That car park lift is your only point of ingress."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101e_check_sealer_guards_dead[] = {
	beginloop(0x10)
		if_stage_flag_eq(STAGEFLAG_ELEVATOR_SEALED, TRUE, /*goto*/ 0x06)
		if_chr_dying(CHR_SEALER1, /*goto*/ 0x03)
		if_chr_death_animation_finished(CHR_SEALER1, /*goto*/ 0x03)
	endloop(0x10)

	label(0x03)
	if_chr_dying(CHR_SEALER2, /*goto*/ 0x03)
	if_chr_death_animation_finished(CHR_SEALER2, /*goto*/ 0x03)
	goto_first(0x10)

	label(0x03)
	if_chr_dying(CHR_SEALER3, /*goto*/ 0x03)
	if_chr_death_animation_finished(CHR_SEALER3, /*goto*/ 0x03)
	goto_first(0x10)

	label(0x03)
	if_chr_dying(CHR_SEALER4, /*goto*/ 0x03)
	if_chr_death_animation_finished(CHR_SEALER4, /*goto*/ 0x03)
	goto_first(0x10)

	label(0x03)
	if_stage_flag_eq(STAGEFLAG_DIVERSION_CREATED, TRUE, /*goto*/ 0x03)
	show_hudmsg(CHR_BOND, L_PETE(66)) // "An alternative diversion has been created!"
	unset_stage_flag(STAGEFLAG_TAXI_DESTROYED)
	unset_stage_flag(STAGEFLAG_ROBOT_DESTROYED)
	set_stage_flag(STAGEFLAG_DIVERSION_CREATED)
	label(0x03)
	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1020_elevator_doors[] = {
	beginloop(0x10)
		if_stage_flag_eq(STAGEFLAG_ELEVATOR_SEALED, TRUE, /*goto*/ 0x03)
		if_door_state(0x10, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x04)
		reloop(0x10)

		label(0x04)
		open_door(0x10)
		open_door(0x11)
	endloop(0x10)

	label(0x03)
	close_door(0x10)
	close_door(0x11)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Guard at top stairs: Turn off special death animation if he's moved away from
 * his pad or if Jo has climbed the staircase.
 */
u8 func1021_check_topstairs_guy[] = {
	beginloop(0x10)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_y(CHR_P1P2, 500, OPERATOR_LESS_THAN, /*goto*/ 0x03)
		goto_next(0x04)
		label(0x03)
		if_chr_distance_to_pad_gt(CHR_TOPSTAIRS, 250, 0x00b5, /*goto*/ 0x04)
	endloop(0x10)

	label(0x04)
	set_chr_special_death_animation(CHR_TOPSTAIRS, SPECIALDIE_NONE)
	unset_chr_chrflag(CHR_TOPSTAIRS, CHRCFLAG_HAS_SPECIAL_DEATH_ANIMATION)
	unset_chr_flag_bankx(CHR_TOPSTAIRS, CHRFLAG1_00001000, BANK_1)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040d_limo_flags[] = {
	// Wait until limo ready
	beginloop(0x10)
		if_stage_flag_eq(STAGEFLAG_LIMO_READY_TO_LEAVE, TRUE, /*goto*/ 0x2f)
	endloop(0x10)

	// Wait until player not in certain rooms
	beginloop(0x2f)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0002, /*goto*/ 0x03)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0010, /*goto*/ 0x03)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0012, /*goto*/ 0x03)
		goto_next(0x04)
		label(0x03)
	endloop(0x2f)

	// Wait almost 10 seconds - provided limo not destroyed
	label(0x04)
	restart_timer

	beginloop(0x2d)
		if_object_in_good_condition(OBJ_LIMO, /*goto*/ 0x03)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x03)
		if_timer_gt(596, /*goto*/ 0x03)
	endloop(0x2d)

	label(0x03)
	hide_object(OBJ_LIMO)
	set_object_flag(OBJ_LIMO, OBJFLAG_INVINCIBLE)
	set_object_flag2(OBJ_LIMO, OBJFLAG2_INVISIBLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1423_setup_lighting[] = {
	yield
	misc_command(0x0000, 0x00, 0x00)
	misc_command(0x0000, 0x01, 0x00)
	misc_command(0x0000, 0x02, 0x00)
	misc_command(0x0000, 0x03, 0x00)
	misc_command(0x0000, 0x04, 0x00)
	misc_command(0x0002, 0x05, 0x01)
	misc_command(0x0003, 0x05, 0x01)
	misc_command(0x000f, 0x05, 0x01)
	misc_command(0x0010, 0x05, 0x01)
	misc_command(0x0011, 0x05, 0x01)
	misc_command(0x0012, 0x05, 0x01)
	misc_command(0x0013, 0x05, 0x01)
	misc_command(0x0014, 0x05, 0x01)
	misc_command(0x0015, 0x05, 0x01)
	misc_command(0x0017, 0x05, 0x01)
	misc_command(0x0018, 0x05, 0x01)
	misc_command(0x0019, 0x05, 0x01)
	misc_command(0x001a, 0x05, 0x01)
	misc_command(0x001c, 0x05, 0x01)
	misc_command(0x001d, 0x05, 0x01)
	misc_command(0x001f, 0x05, 0x01)
	misc_command(0x0021, 0x05, 0x01)
	misc_command(0x0022, 0x05, 0x01)
	misc_command(0x0025, 0x05, 0x01)
	misc_command(0x0026, 0x05, 0x01)
	misc_command(0x0027, 0x05, 0x01)
	misc_command(0x0028, 0x05, 0x01)
	misc_command(0x002c, 0x05, 0x01)
	misc_command(0x002d, 0x05, 0x01)
	misc_command(0x002e, 0x05, 0x01)
	misc_command(0x0031, 0x05, 0x01)
	misc_command(0x0032, 0x05, 0x01)
	misc_command(0x0037, 0x05, 0x01)
	misc_command(0x0038, 0x05, 0x01)
	misc_command(0x0039, 0x05, 0x01)
	misc_command(0x003a, 0x05, 0x01)
	misc_command(0x003d, 0x05, 0x01)
	misc_command(0x003e, 0x05, 0x01)
	misc_command(0x003f, 0x05, 0x01)
	misc_command(0x0043, 0x05, 0x01)
	misc_command(0x0044, 0x05, 0x01)
	misc_command(0x0045, 0x05, 0x01)
	misc_command(0x004a, 0x05, 0x01)
	misc_command(0x004b, 0x05, 0x01)
	misc_command(0x004c, 0x05, 0x01)
	misc_command(0x004e, 0x05, 0x01)
	misc_command(0x0050, 0x05, 0x01)
	misc_command(0x0051, 0x05, 0x01)
	misc_command(0x0052, 0x05, 0x01)
	misc_command(0x0059, 0x05, 0x01)
	misc_command(0x005a, 0x05, 0x01)
	misc_command(0x005b, 0x05, 0x01)
	misc_command(0x005c, 0x05, 0x01)
	misc_command(0x005d, 0x05, 0x01)
	misc_command(0x005f, 0x05, 0x01)
	misc_command(0x0060, 0x05, 0x01)
	misc_command(0x0061, 0x05, 0x01)
	misc_command(0x0062, 0x05, 0x01)
	misc_command(0x0064, 0x05, 0x01)
	misc_command(0x0066, 0x05, 0x01)
	misc_command(0x0067, 0x05, 0x01)
	misc_command(0x0068, 0x05, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0412_cia_invincibility[] = {
	beginloop(0x10)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_TAXI_LEAVE, TRUE, /*goto*/ 0x03)
	endloop(0x10)

	label(0x03)
	set_chr_chrflag(CHR_CIA1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_CIA2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_CIA3, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_CIA4, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)

	beginloop(0x2d)
		if_stage_flag_eq(STAGEFLAG_DIVERSION_CREATED, TRUE, /*goto*/ 0x03)
	endloop(0x2d)

	label(0x03)
	restart_timer

	beginloop(0x2f)
		if_timer_gt(300, /*goto*/ 0x03)
	endloop(0x2f)

	label(0x03)
	unset_chr_chrflag(CHR_CIA1, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_CIA2, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_CIA3, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(CHR_CIA4, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1025_rtracker[] = {
	yield
	set_object_flag3(OBJ_FALCON2, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1027_untrack_dumpster[] = {
	yield

	beginloop(0x10)
		if_object_in_good_condition(OBJ_DUMPSTER, /*goto*/ 0x04)
		goto_next(0x03)
		label(0x04)
	endloop(0x10)

	label(0x03)
	unset_object_flag3(OBJ_DUMPSTER, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

struct ailist ailists[] = {
	{ func0401_3ae8,                            0x0401 },
	{ func0402_3bb4,                            0x0402 },
	{ func0403_3c74,                            0x0403 },
	{ func0404_3ce0,                            0x0404 },
	{ func0405_3d50,                            0x0405 },
	{ func0406_3e54,                            0x0406 },
	{ func0407_3e60,                            0x0407 },
	{ func0408_3e6c,                            0x0408 },
	{ func0409_3e78,                            0x0409 },
	{ func040a_intro,                           0x040a },
	{ func040b_outro,                           0x040b },
	{ func040c_taxi,                            0x040c },
	{ func040d_limo,                            0x040d },
	{ func040e_6064,                            0x040e },
	{ func040f_6088,                            0x040f },
	{ func0410_60d0,                            0x0410 },
	{ func0411_60f4,                            0x0411 },
	{ func0412_cia,                             0x0412 },
	{ func0413_bugspotter,                      0x0413 },
	{ func0414_start_path07,                    0x0414 },
	{ func0415_start_path08,                    0x0415 },
	{ func0416_start_path09,                    0x0416 },
	{ func0417_start_path10,                    0x0417 },
	{ func0418_start_path11,                    0x0418 },
	{ func0419_init_cia1,                       0x0419 },
	{ func041d_fbi,                             0x041d },
	{ func041c_hiddenguy,                       0x041c },
	{ func041e_sealer1,                         0x041e },
	{ func041f_alarm_responder,                 0x041f },
	{ func0420_jog_to_accident,                 0x0420 },
	{ func041a_robot,                           0x041a },
	{ func041b_init_robot,                      0x041b },
	{ func040a_intro,                           0x0c00 },
	{ func040b_outro,                           0x0c01 },
	{ func1400_give_briefcases,                 0x1400 },
	{ func1001_objectives_failed_msg,           0x1001 },
	{ func1002_rebuild_groups,                  0x1002 },
	{ func040a_intro_from_gameplay,             0x1003 },
	{ func1004_tracerbug_bond,                  0x1004 },
	{ func1005_check_things_destroyed,          0x1005 },
	{ func1006_check_for_end,                   0x1006 },
	{ func040d_limo_timing,                     0x1007 },
	{ func040c_taxi_timing,                     0x1008 },
	{ func1009_check_cia1_dead,                 0x1009 },
	{ func100a_check_cia2_dead,                 0x100a },
	{ func100b_check_cia3_dead,                 0x100b },
	{ func100c_check_cia4_dead,                 0x100c },
	{ func100d_spawn_alarm_responders,          0x100d },
	{ func100f_check_mine,                      0x100f },
	{ func1010_elevator_switch,                 0x1010 },
	{ func1011_trackerbug_coop,                 0x1011 },
	{ func1012_update_robot_prop_flags,     0x1012 },
	{ func1014_crash,                           0x1014 },
	{ func040a_intro_sfx,                       0x1415 },
	{ func1416_setup_rain,                      0x1416 },
	{ func1017_drain_guards,                    0x1017 },
	{ func1018_keep_door_open,                  0x1018 },
	{ func1019_setup_topstairs_death_animation, 0x1019 },
	{ func101a_msg_onlyplace,                   0x101a },
	{ func101b_msg_blockedupdoors,              0x101b },
	{ func101c_msg_reprogramthattaxi,           0x101c },
	{ func101d_msg_pointofingress,              0x101d },
	{ func101e_check_sealer_guards_dead,        0x101e },
	{ func101f_setup_robot_noise,               0x101f },
	{ func1020_elevator_doors,                  0x1020 },
	{ func1021_check_topstairs_guy,             0x1021 },
	{ func040d_limo_flags,                      0x1022 },
	{ func1423_setup_lighting,                  0x1423 },
	{ func0412_cia_invincibility,               0x1024 },
	{ func1025_rtracker,                        0x1025 },
	{ func1026_uplink,                          0x1026 },
	{ func1027_untrack_dumpster,                0x1027 },
	{ NULL, 0 },
};

struct path paths[] = {
	{ path00, 0, PATHTYPE_BACKANDFORTH },
	{ path01, 1, PATHTYPE_BACKANDFORTH },
	{ path02, 2, PATHTYPE_BACKANDFORTH },
	{ path03, 3, PATHTYPE_BACKANDFORTH },
	{ path04, 4, PATHTYPE_BACKANDFORTH },
	{ path05, 5, PATHTYPE_BACKANDFORTH },
	{ path06, 6, PATHTYPE_BACKANDFORTH },
	{ path07, 7, PATHTYPE_BACKANDFORTH },
	{ path08, 8, PATHTYPE_BACKANDFORTH },
	{ path09, 9, PATHTYPE_BACKANDFORTH },
	{ path10, 10, PATHTYPE_BACKANDFORTH },
	{ path11, 11, PATHTYPE_BACKANDFORTH },
	{ path12, 12, PATHTYPE_BACKANDFORTH },
	{ path13, 13, PATHTYPE_BACKANDFORTH },
	{ NULL, 0, 0 },
};

