//
// Infiltration
//

#include "stagesetup.h"

// Characters
#define CHR_MECHANIC             0x30
#define CHR_JONATHAN             0x31
#define CHR_OUTRO_GUARD          0x33
#define CHR_ROCKETLAUNCHER_GUARD 0x34

// Objects
#define OBJ_INTERCEPTOR1     0x02
#define OBJ_INTERCEPTOR2     0x03
#define OBJ_INTERCEPTOR3     0x04
#define OBJ_MAINGATE_SWITCH  0x05
#define OBJ_ANTENNA          0x07
#define OBJ_BUG1_BOND        0x08
#define OBJ_ANTENNA_SWITCH   0x09
#define OBJ_KEYCARD          0x0a
#define OBJ_LIFT1_SWITCH     0x0b
#define OBJ_LIFT2_SWITCH     0x0c
#define OBJ_RADAR_TERMINAL   0x10
#define OBJ_MAINGATE1        0x13
#define OBJ_MAINGATE2        0x14
#define OBJ_MINE1            0x17
#define OBJ_MINE2            0x18
#define OBJ_MINE3            0x19
#define OBJ_MINE4            0x1b
#define OBJ_MINE5            0x1c
#define OBJ_MINE6            0x1d
#define OBJ_BUG2_BOND        0x2e
#define OBJ_AUTOGUN_AT_START 0x35
#define OBJ_BUG1_COOP        0x36
#define OBJ_BUG2_COOP        0x37
#define OBJ_ROCKETLAUNCHER   0x53
#define OBJ_EXPLOSIVE_BRICK  0x54
#define OBJ_HOVERBIKE        0x55

// Stage flags
#define STAGEFLAG_INTERCEPTOR1_DESTROYED  0x00000100
#define STAGEFLAG_INTERCEPTOR2_DESTROYED  0x00000200
#define STAGEFLAG_INTERCEPTOR3_DESTROYED  0x00000400
#define STAGEFLAG_COMMSBUG_PLACED         0x00000800
#define STAGEFLAG_COMMSBUG_MISPLACED      0x00001000
#define STAGEFLAG_ANTENNA_DESTROYED       0x00002000
#define STAGEFLAG_ANTENNA_LOWERED         0x00004000
#define STAGEFLAG_LIFT1_CALLED            0x00008000
#define STAGEFLAG_LIFT2_CALLED            0x00010000
#define STAGEFLAG_HANGAR_ACCESSED         0x00020000
#define STAGEFLAG_MET_JON                 0x00040000
#define STAGEFLAG_RADAR_SHUT_DOWN         0x00080000
#define STAGEFLAG_EXPLOSIVES_PLACED       0x00200000
#define STAGEFLAG_TRIGGER_INTERCEPTOR     0x00400000
#define STAGEFLAG_ENTERED_FINAL_HANGAR    0x00800000
#define STAGEFLAG_INTRO_FINISHED          0x01000000
#define STAGEFLAG_LIFT_SWITCHES_DESTROYED 0x04000000
#define STAGEFLAG_ONE_BUG_WASTED          0x08000000
#define STAGEFLAG_ANY_LASER_DESTROYED     0x10000000

// AI Lists
#define AILIST_OUTRO                      0x040e
#define AILIST_SPAWNED_GUARD              0x040f
#define AILIST_INTRO                      0x0410
#define AILIST_ALERT_WHEN_STOPPED         0x0415
#define AILIST_MECHANIC                   0x0416
#define AILIST_TRAITOR                    0x0417
#define AILIST_INIT_ALERTED_SPAWNED_GUARD 0x041a
#define AILIST_ALERTED_SPAWNED_GUARD      0x041b
#define AILIST_TEMPLATE_GUARD             0x041c
#define AILIST_TROOPER_UNALERTED          0x041d
#define AILIST_DRAGON_UNALERTED           0x041e
#define AILIST_TROOPER_ALERTED            0x041f
#define AILIST_DRAGON_ALERTED             0x0420
#define AILIST_ACTIVATE_AUTOGUN           0x0421
#define AILIST_ACTIVATE_LASERS            0x0424

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x2c01)
	briefing(1, 0x2c00)
	briefing(2, 0x2c02)
	briefing(3, 0x2c03)

	beginobjective(0, L_LUE(9), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Shut down air intercept radar"
		complete_flags(STAGEFLAG_RADAR_SHUT_DOWN)
	endobjective

	beginobjective(1, L_LUE(10), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Plant comms device on antenna"
		complete_flags(STAGEFLAG_COMMSBUG_PLACED)
		fail_flags(STAGEFLAG_COMMSBUG_MISPLACED)
		fail_flags(STAGEFLAG_ANTENNA_DESTROYED)
	endobjective

	beginobjective(2, L_LUE(11), (DIFFBIT_PA | DIFFBIT_PD)) // "Disable all robot interceptors"
		complete_flags(STAGEFLAG_INTERCEPTOR1_DESTROYED)
		complete_flags(STAGEFLAG_INTERCEPTOR2_DESTROYED)
		complete_flags(STAGEFLAG_INTERCEPTOR3_DESTROYED)
	endobjective

	beginobjective(3, L_LUE(12), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Gain access to hangar lift"
		complete_flags(STAGEFLAG_HANGAR_ACCESSED)
		fail_flags(STAGEFLAG_LIFT_SWITCHES_DESTROYED)
	endobjective

	beginobjective(4, L_LUE(13), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Make contact with CI spy"
		complete_flags(STAGEFLAG_MET_JON)
	endobjective

	tag(0x3c, 5)
	tag(0x3d, 6)
	tag(0x31, 2)
	tag(0x0f, 2)
	lift(0x0100, MODEL_A51_LIFT_HANGAR, 0x031e, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x031e, 0x031f, 0xffffffff, 0x00000001, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x14000000, 0x00000000, 0x00000000, 0x00000000)
#if VERSION >= VERSION_PAL_FINAL
	// ....................................................... v
	door(0x0100, MODEL_DOOR_ROLLERTRAIN, 0x0321, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000c000, 0x000031c7, 0x000031c7, 0x000002fc, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001900, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
#else
	door(0x0100, MODEL_DOOR_ROLLERTRAIN, 0x0321, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000c000, 0x000031c7, 0x000031c7, 0x000002fc, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001900, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
#endif
	link_objects(-1, -2, 0, 0)
#if VERSION >= VERSION_PAL_FINAL
	door(0x0100, MODEL_DOOR_ROLLERTRAIN, 0x0322, 0x10000000, 0x20000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000c000, 0x000031c7, 0x000031c7, 0x000002fc, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001900, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
#else
	door(0x0100, MODEL_DOOR_ROLLERTRAIN, 0x0322, 0x10000000, 0x00000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000c000, 0x000031c7, 0x000031c7, 0x000002fc, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001900, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
#endif
	link_objects(-1, -4, 0, 1)
	tag(0x39, -2)
	tag(0x3e, 5)
	tag(0x3f, 6)
	tag(0x32, 2)
	tag(0x0e, 2)
	lift(0x0100, MODEL_A51_LIFT_HANGAR, 0x0324, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0324, 0x0325, 0xffffffff, 0x00000001, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x14000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR_ROLLERTRAIN, 0x0327, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000c000, 0x000031c7, 0x000031c7, 0x000002fc, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001900, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-1, -2, 0, 0)
	door(0x0100, MODEL_DOOR_ROLLERTRAIN, 0x0328, 0x10000000, 0x00000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000c000, 0x000031c7, 0x000031c7, 0x000002fc, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001900, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-1, -4, 0, 1)
	tag(0x38, -2)
	door(0x0100, MODEL_DOOR_ROLLERTRAIN, 0x0320, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000c000, 0x000031c7, 0x000031c7, 0x000002fc, 0x00040004, 0x00000004, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR_ROLLERTRAIN, 0x0326, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000c000, 0x000031c7, 0x000031c7, 0x000002fc, 0x00040004, 0x00000004, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x40, 6)
	tag(0x41, 6)
	tag(0x42, 8)
	tag(0x43, 8)
	tag(0x33, 1)
	lift(0x0100, MODEL_A51_LIFT_CONTROL, 0x0329, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0329, 0x032a, 0xffffffff, 0x00000001, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x16000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x032e, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00008e38, 0x00008e38, 0x00000444, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x032f, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00008e38, 0x00008e38, 0x00000444, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-2, -3, 0, 0)
	link_objects(-2, -4, 0, 0)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x0330, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00008e38, 0x00008e38, 0x00000444, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x0331, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00008e38, 0x00008e38, 0x00000444, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-2, -7, 0, 1)
	link_objects(-2, -8, 0, 1)
	chr(0x00004200, 0x00, 0x0354, BODY_A51TROOPER, HEAD_RANDOM, AILIST_TROOPER_UNALERTED, -1, -1, 10000, 100, 0x8000ae00, 0x00000100, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x0000, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRGRENADE, 0x0000, 0x20004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_GRENADE, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x01, 0x0355, BODY_A51TROOPER, HEAD_RANDOM, AILIST_TROOPER_UNALERTED, -1, -1, 10000, 100, 0x8000ae00, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x0001, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x02, 0x0029, BODY_A51TROOPER, HEAD_RANDOM, 0x0402, -1, -1, 1000, 0, 0x8000ae08, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x02001400)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x0002, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRGRENADE, 0x0002, 0x20004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_GRENADE, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x03, 0x0012, BODY_A51TROOPER, HEAD_RANDOM, 0x0401, -1, -1, 1000, 0, 0x8000ae08, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x02000500)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x0003, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRGRENADE, 0x0003, 0x20004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_GRENADE, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x04, 0x0010, BODY_A51TROOPER, HEAD_RANDOM, AILIST_TEMPLATE_GUARD, -1, -1, 1000, 100, 0x8000ae08, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x02000500)
	chr(0x00000300, 0x05, 0x0356, BODY_A51TROOPER, HEAD_RANDOM, 0x040d, -1, -1, 1000, 30, 0x10002800, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x0005, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	chr(0x00000300, 0x06, 0x0357, BODY_A51TROOPER, HEAD_RANDOM, 0x040d, -1, -1, 1000, 30, 0x10002800, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x0006, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x07, 0x0055, BODY_A51TROOPER, HEAD_RANDOM, 0x0403, 0x0370, -1, 1000, 100, 0x80028804, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x0007, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRGRENADE, 0x0007, 0x20004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_GRENADE, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x08, 0x004f, BODY_A51TROOPER, HEAD_RANDOM, 0x0403, 0x0371, -1, 1000, 100, 0x80028804, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x0008, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRGRENADE, 0x0008, 0x20004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_GRENADE, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x09, 0x003e, BODY_A51TROOPER, HEAD_RANDOM, 0x0404, -1, -1, 1000, 100, 0xc0080e01, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x0009, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0c, 0x036d, BODY_A51TROOPER, HEAD_RANDOM, AILIST_TROOPER_UNALERTED, -1, -1, 2000, 100, 0xa0004800, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x000c, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0d, 0x0085, BODY_A51TROOPER, HEAD_RANDOM, AILIST_TROOPER_UNALERTED, -1, -1, 2000, 100, 0xa0004800, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x000d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0e, 0x0089, BODY_A51TROOPER, HEAD_RANDOM, 0x0405, -1, -1, 1000, 100, 0x80082800, 0x00000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x000e, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0f, 0x0092, BODY_A51TROOPER, HEAD_RANDOM, 0x0406, -1, -1, 1000, 100, 0x80002800, 0x00002000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x000f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x10, 0x036e, BODY_A51TROOPER, HEAD_RANDOM, AILIST_TROOPER_UNALERTED, -1, -1, 1000, 100, 0xac008800, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x0010, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x11, 0x036f, BODY_A51TROOPER, HEAD_RANDOM, AILIST_TROOPER_UNALERTED, -1, -1, 1000, 100, 0x8c008800, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x0011, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x12, 0x035a, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_UNALERTED, -1, -1, 1000, 20, 0xc0004800, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0012, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x13, 0x035b, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_UNALERTED, -1, -1, 1000, 20, 0xc0004800, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0013, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00010800, 0x30, 0x0358, BODY_OVERALL, HEAD_RANDOM, AILIST_MECHANIC, -1, -1, 1000, 5, 0x80002400, 0x20000000, TEAM_NONCOMBAT, SQUADRON_07, -1, 0, 0x00000000)
	tag(0x0a, 1)
	key(0x0080, MODEL_KEYCARD, 0x0030, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	rename_object(-1, 0x4b, L_LUE(31), L_LUE(32), L_LUE(33), L_LUE(34), L_LUE(35), 0x0000, 0x0000) // "Obtain lift key card."
	chr(0x00000200, 0x14, 0x035d, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_UNALERTED, -1, -1, 1000, 100, 0xcc080800, 0x00004000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0014, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x15, 0x0362, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_UNALERTED, -1, -1, 1000, 100, 0xcc080800, 0x00004000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0015, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x16, 0x035c, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_UNALERTED, -1, -1, 1000, 100, 0xcc080800, 0x00006000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0016, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x17, 0x035e, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_UNALERTED, -1, -1, 1000, 100, 0xcc080800, 0x00004000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0017, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x18, 0x035f, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_UNALERTED, -1, -1, 1000, 100, 0xc0000800, 0x00000040, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0018, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x19, 0x0361, BODY_A51AIRMAN, HEAD_RANDOM, 0x0407, -1, -1, 1000, 20, 0xc0000800, 0x00000000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0019, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1a, 0x0360, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_UNALERTED, -1, -1, 1000, 20, 0xc0000800, 0x00000000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x001a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1c, 0x0363, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_UNALERTED, -1, -1, 1000, 100, 0xc0004800, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x001c, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1d, 0x0364, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_UNALERTED, -1, -1, 1000, 100, 0xc0004a00, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x001d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1e, 0x0365, BODY_A51AIRMAN, HEAD_RANDOM, 0x0408, -1, -1, 1000, 100, 0xe0004800, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x001e, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1f, 0x037b, BODY_A51TROOPER, HEAD_RANDOM, GAILIST_IDLE, 0x007d, -1, 1000, 100, 0x81002000, 0x00000000, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x001f, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x22, 0x037e, BODY_A51TROOPER, HEAD_RANDOM, GAILIST_IDLE, 0x007d, -1, 1000, 100, 0x81002000, 0x00000000, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x0022, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x20, 0x003a, BODY_A51TROOPER, HEAD_RANDOM, GAILIST_IDLE, 0x0077, -1, 1000, 100, 0x89000000, 0x00000000, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x0020, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x21, 0x0033, BODY_A51TROOPER, HEAD_RANDOM, GAILIST_IDLE, 0x0077, -1, 1000, 100, 0x89000000, 0x00000000, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x0021, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x23, 0x01ba, BODY_A51AIRMAN, HEAD_RANDOM, GAILIST_IDLE, 0x007d, -1, 1000, 100, 0x00002800, 0x00002000, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0023, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x24, 0x01b2, BODY_A51AIRMAN, HEAD_RANDOM, GAILIST_IDLE, 0x007d, -1, 1000, 100, 0x00002800, 0x00002000, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0024, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x25, 0x01ce, BODY_A51AIRMAN, HEAD_RANDOM, 0x0419, 0x007d, -1, 1000, 100, 0x80002000, 0x00000000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0025, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00010400, 0x31, 0x0196, BODY_A51AIRMAN, HEAD_JONATHAN, 0x0425, -1, -1, 1000, 100, 0xc0004e00, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDY357, 0x0031, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DY357MAGNUM, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x32, 0x0197, BODY_A51TROOPER, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 1000, 100, 0xc0004e00, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0032, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x33, 0x0199, BODY_A51AIRMAN, HEAD_KEN, 0x0425, -1, -1, 1000, 100, 0xc0004e00, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0033, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x29, 0x0158, BODY_LABTECH, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 1000, 100, 0xc0004e00, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	chr(0x00000000, 0x2a, 0x0157, BODY_BIOTECH, HEAD_BIOTECH, GAILIST_IDLE, -1, -1, 1000, 100, 0xc0004e00, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSONICSCREWER, 0x002a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_52, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x2b, 0x0156, BODY_BIOTECH, HEAD_BIOTECH, GAILIST_IDLE, -1, -1, 1000, 100, 0xc0004e00, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSONICSCREWER, 0x002b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_52, 0x00ffffff, 0x00000000)
	tag(0x2f, 1)
	hover_prop(0x0100, MODEL_HOVERBED, 0x0155, 0x05120101, 0x00304300, 0x00100003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	chr(0x00000000, 0x34, 0x040f, BODY_A51TROOPER, HEAD_RANDOM, GAILIST_IDLE, 0x007d, -1, 1000, 100, 0x81002000, 0x00000000, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDYROCKET, 0x0034, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_ROCKETLAUNCHER, 0x00ffffff, 0x00000000)
	tag(0x53, -1)
	chr(0x00000000, 0x35, 0x009f, BODY_AREA51GUARD, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 1000, 100, 0x04003000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x0035, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRLEEGUN1, 0x0035, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_MAGSEC4, 0x00ffffff, 0x00000000)
	link_collectibles(-1, -2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x027f, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x027e, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x027d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x027c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x027a, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x027b, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0278, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0279, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0277, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0276, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0274, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0275, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0273, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0272, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0270, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0271, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x026f, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x026e, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0266, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0267, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02a6, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00001999, 0x00000004, 0x00000040, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x11, 2)
	tag(0x12, 2)
#if VERSION >= VERSION_PAL_FINAL
	// .......................................................... v
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x02af, 0x10000010, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT,  0x02b0, 0x10000010, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
#else
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x02af, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT,  0x02b0, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
#endif
	tag(0x13, 2)
	tag(0x14, 2)
	door(0x0100, MODEL_A51GATE_L, 0x02b5, 0x10000010, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00000ccc, 0x00014000, 0x00000111, 0x00000000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51GATE_R, 0x02b6, 0x10000010, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00000ccc, 0x00014000, 0x00000111, 0x00000000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00001800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
#if VERSION >= VERSION_PAL_FINAL
	// ....................................................... v
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02b3, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000010, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02b4, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000010, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
#else
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02b3, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000010, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02b4, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000010, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
#endif
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x028c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x028d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x0291, 0x10000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000004, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02a9, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x00, 1)
	autogun(0x0100, MODEL_A51_TURRET, 0x0380, 0x00000101, 0x00000300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000bb8, 0x00000000, 0x00000000, 0x0fff0000, 0x00280000, 0x00000000, 0x00020000, 0xfffe0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000002d8, 0x001e0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	autogun(0x0100, MODEL_A51_TURRET, 0x0382, 0x00000101, 0x00000300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000bb8, 0x00000000, 0x00000000, 0x0fff0000, 0x002e0000, 0x00000000, 0x00020000, 0xfffe0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000002d8, 0x001e0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x01, 1)
	autogun(0x0100, MODEL_A51_TURRET, 0x0383, 0x00000101, 0x00000300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000bb8, 0x00000000, 0x00000000, 0x0fff0000, 0x00260000, 0x00000000, 0x00020000, 0xfffe0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000016c, 0x001e0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x35, 1)
	autogun(0x0100, MODEL_A51_TURRET, 0x0381, 0x00000101, 0x00000300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001f4, 0x00000000, 0x00000000, 0x0fff0000, 0x00150000, 0x00000000, 0x00020000, 0xfffe0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000002d8, 0x001e0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	autogun(0x00c0, MODEL_A51_ROOFGUN, 0x0401, 0x00000004, 0x000020e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x03660000, 0x00000000, 0x00004000, 0xffffc000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000da, 0x00140000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	autogun(0x00c0, MODEL_A51_ROOFGUN, 0x0402, 0x00000004, 0x000020e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x03680000, 0x00000000, 0x00004000, 0xffffc000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000da, 0x00140000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	autogun(0x00c0, MODEL_A51_ROOFGUN, 0x0403, 0x00000004, 0x000020e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x03670000, 0x00000000, 0x00004000, 0xffffc000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000da, 0x00140000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	autogun(0x00c0, MODEL_A51_ROOFGUN, 0x0404, 0x00000004, 0x000020e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x03690000, 0x00000000, 0x000031c7, 0xffffce39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000da, 0x00140000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	autogun(0x00c0, MODEL_A51_ROOFGUN, 0x0401, 0x00000004, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x03660000, 0x00000000, 0x00004000, 0xffffc000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000e38, 0x003c0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	autogun(0x00c0, MODEL_A51_ROOFGUN, 0x0402, 0x00000004, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x03680000, 0x00000000, 0x00004000, 0xffffc000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000e38, 0x003c0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	autogun(0x00c0, MODEL_A51_ROOFGUN, 0x0403, 0x00000004, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x03670000, 0x00000000, 0x00004000, 0xffffc000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000e38, 0x003c0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	autogun(0x00c0, MODEL_A51_ROOFGUN, 0x0404, 0x00000004, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x03690000, 0x00000000, 0x000031c7, 0xffffce39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000e38, 0x003c0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x55, 1)
	hoverbike(0x0100, MODEL_HOVBIKE, 0x037a, 0x05120101, 0x00304300, 0x02000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x01010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x02, 1)
	armed_vehicle(0x0a00, MODEL_A51INTERCEPTOR, 0x0359, 0x20000108, 0x00080000, 0x00008200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, 0x0000040c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x03, 1)
	armed_vehicle(0x0a00, MODEL_A51INTERCEPTOR, 0x036c, 0x20000108, 0x00080000, 0x00008200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, 0x0000040c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x04, 1)
	armed_vehicle(0x0a00, MODEL_A51INTERCEPTOR, 0x034e, 0x20000108, 0x00080000, 0x00008200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, 0x0000040a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x05, 1)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x0409, 0x10000002, 0x00000800, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x08, 1)
	weapon(0x0180, MODEL_CHRBUG, 0xffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_COMMSRIDER, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x3d, L_LUE(21), L_LUE(22), L_LUE(23), L_LUE(24), L_LUE(25), 0x0000, 0x0000) // "Obtain comms rider."
	tag(0x36, 1)
	weapon(0x0180, MODEL_CHRBUG, 0xffff, 0x00100001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_COMMSRIDER, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x3d, L_LUE(21), L_LUE(22), L_LUE(23), L_LUE(24), L_LUE(25), 0x0000, 0x0000) // "Obtain comms rider."
	tag(0x2e, 1)
	stdobject(0x0100, MODEL_CHRBUG, 0x035b, 0x012404e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	rename_object(-1, 0x3b, L_LUE(48), L_LUE(49), L_LUE(50), L_LUE(51), L_LUE(52), 0x0000, 0x0000) // "Obtain explosive."
	tag(0x37, 1)
	stdobject(0x0100, MODEL_CHRBUG, 0x035b, 0x013004e1, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	rename_object(-1, 0x3b, L_LUE(48), L_LUE(49), L_LUE(50), L_LUE(51), L_LUE(52), 0x0000, 0x0000) // "Obtain explosive."
	tag(0x09, 1)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x0406, 0x10000002, 0x00002001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff13)
	tag(0x0b, 1)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x0407, 0x10000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x0c, 1)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x0408, 0x10000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x10, 1)
	multimonitor(0x0099, MODEL_PD_CONSOLE, 0x04f7, 0x000201a1, 0x00000800, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030000)
	tag(0x54, 1)
	stdobject(0x000c, MODEL_EXPLOSIVEBRICK, 0x036b, 0x01520408, 0x00084000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x17, 1)
	remote_mine(0x0100, MODEL_CHRPROXIMITYMINE, 0x040c, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x21000000, 0x00000001, 0x00000000)
	tag(0x18, 1)
	remote_mine(0x0100, MODEL_CHRPROXIMITYMINE, 0x040d, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x21000000, 0x00000001, 0x00000000)
	tag(0x19, 1)
	remote_mine(0x0100, MODEL_CHRPROXIMITYMINE, 0x040e, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x21000000, 0x00000001, 0x00000000)
	tag(0x1b, 1)
	remote_mine(0x0100, MODEL_CHRPROXIMITYMINE, 0x0410, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x21000000, 0x00000001, 0x00000000)
	tag(0x1c, 1)
	remote_mine(0x0100, MODEL_CHRPROXIMITYMINE, 0x0411, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x21000000, 0x00000001, 0x00000000)
	tag(0x1d, 1)
	remote_mine(0x0100, MODEL_CHRPROXIMITYMINE, 0x0412, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x21000000, 0x00000001, 0x00000000)
	stdobject(0x0100, MODEL_BARREL, 0x0413, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0414, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0415, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0416, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0417, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x0418, 0x00000501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0311, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0312, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x0313, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0314, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0307, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0306, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x0305, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0304, 0x00020501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02f9, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x02fa, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02fb, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x02fc, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x02fd, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02fe, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x02ff, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x0300, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0301, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0302, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x0303, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0309, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x030a, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x030b, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x030c, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x030d, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x030e, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x030f, 0x000201e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0310, 0x000201e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02f8, 0x000201e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x07, 1)
	lift(0x0100, MODEL_A51DISH, 0x033b, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x033b, 0x033a, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0446, 0x14020b62, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0096012c, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0445, 0x14020b62, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0096012c, 0x0000ffff, 0x00000000)
	tag(0x1e, 7)
	tag(0x1f, 7)
	tag(0x20, 7)
	tag(0x21, 7)
	tag(0x22, 7)
	tag(0x23, 7)
	tag(0x24, 7)
	door(0x0100, MODEL_LASDOOR, 0x044a, 0x06000400, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x044b, 0x06000400, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x044c, 0x06000400, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x044d, 0x06000400, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x044e, 0x06000400, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x044f, 0x06000400, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0450, 0x06000400, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x25, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0050, 0x012204e1, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x26, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0050, 0x012204e1, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x27, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0050, 0x012204e1, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x28, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0050, 0x012204e1, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x29, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0050, 0x012204e1, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2a, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0050, 0x012204e1, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2b, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0050, 0x012204e1, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2c, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0050, 0x012204e1, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2d, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x0050, 0x012204e1, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x51, 1)
	stdobject(0x0100, MODEL_CHRREMOTEMINE, 0x04e8, 0x012204e1, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04e2, 0x000005e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04e3, 0x000005e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04e4, 0x000005e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04e5, 0x000005e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04e6, 0x000005e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04e7, 0x000005e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04e8, 0x000005e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04e9, 0x000005e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04ea, 0x000005e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_G5_MAINFRAME, 0x04eb, 0x000005e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x040b, 0x10000002, 0x00000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	stdobject(0x0100, MODEL_A51TABLE, 0x04d5, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x44, 2)
	tag(0x45, 2)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x04f8, 0x000004e8, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x04f9, 0x000004e8, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x46, 2)
	tag(0x47, 2)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x04fa, 0x000004e8, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x04fb, 0x000004e8, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x48, 2)
	tag(0x49, 2)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x04fc, 0x000004e8, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x04fd, 0x000004e8, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x4a, 2)
	tag(0x4b, 2)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x04fe, 0x000004e8, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x04ff, 0x000004e8, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x4c, 2)
	tag(0x4d, 2)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0500, 0x000004e8, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0501, 0x000004e8, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x4e, 2)
	tag(0x4f, 2)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0502, 0x000004e8, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0503, 0x000004e8, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x50, 2)
	tag(0x52, 2)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0504, 0x000004e8, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x0505, 0x000004e8, 0x00002010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3a, 1)
#if VERSION >= VERSION_JAP_FINAL
	// ........................................................ v
	shield(0x0100, MODEL_CHRSHIELD, 0x0565, 0x00000001, 0x00000080, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
#else
	shield(0x0100, MODEL_CHRSHIELD, 0x0565, 0x00000001, 0x000000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
#endif
	tag(0x3b, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x0096, 0x00000001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	endprops
};

s32 intro[] = {
	spawn(0x000f)
	intro_weapon(WEAPON_FALCON2, -1)
	ammo(AMMOTYPE_PISTOL, 100)
	outfit(OUTFIT_DEFAULT)
	endintro
};

s32 path34[] = {
	0x0560,
	0x0563,
	0x0562,
	0x0561,
	-1,
};

s32 path00[] = {
	0x001a,
	0x001d,
	0x001e,
	0x0022,
	0x0024,
	0x0025,
	0x0026,
	0x0025,
	0x0024,
	0x0022,
	0x001e,
	0x001d,
	0x001a,
	0x0019,
	0x0013,
	-1,
};

s32 path01[] = {
	0x0026,
	0x0025,
	0x0024,
	0x0022,
	0x001e,
	0x001d,
	0x001a,
	0x0019,
	0x0013,
	0x0019,
	0x001a,
	0x001d,
	0x001e,
	0x0022,
	0x0024,
	0x0025,
	-1,
};

s32 path02[] = {
	0x0055,
	0x0054,
	0x004f,
	0x004e,
	-1,
};

s32 path03[] = {
	0x003f,
	0x0077,
	0x0078,
	0x0079,
	0x007a,
	0x007b,
	0x007c,
	0x007d,
	0x007e,
	0x007f,
	0x007e,
	0x007d,
	0x007c,
	0x007b,
	0x007a,
	0x0079,
	0x0078,
	0x0077,
	-1,
};

s32 path04[] = {
	0x008d,
	0x008e,
	0x0093,
	0x008e,
	0x0092,
	0x0091,
	0x0090,
	0x008c,
	-1,
};

s32 path05[] = {
	0x0092,
	0x008e,
	0x0093,
	0x008e,
	0x008d,
	0x008c,
	0x0090,
	0x0091,
	-1,
};

s32 unregistered_path1[] = {
	0x01dc,
	0x01b9,
	0x01b8,
	0x01b7,
	0x01b6,
	0x01b5,
	0x01b3,
	0x01b5,
	0x01b6,
	0x01b7,
	0x01b8,
	0x01b9,
	-1,
};

s32 unregistered_path2[] = {
	0x01d6,
	0x01d6,
	0x01d4,
	0x01d3,
	0x01d2,
	0x01d1,
	0x01d2,
	0x01d3,
	0x01d4,
	0x01d6,
	-1,
};

s32 path08[] = {
	0x0506,
	0x0507,
	-1,
};

s32 path09[] = {
	0x0508,
	0x0509,
	0x050a,
	-1,
};

s32 path10[] = {
	0x050b,
	0x050c,
	0x050d,
	0x050e,
	0x050f,
	0x0510,
	-1,
};

s32 path11[] = {
	0x0511,
	0x0512,
	0x0513,
	0x0514,
	-1,
};

s32 path12[] = {
	0x0515,
	0x0516,
	0x0517,
	0x0518,
	0x0519,
	-1,
};

s32 path13[] = {
	0x051a,
	0x051b,
	0x051c,
	0x051d,
	0x051e,
	0x051f,
	-1,
};

s32 path14[] = {
	0x0520,
	0x0521,
	0x0522,
	0x0523,
	0x0524,
	0x0525,
	-1,
};

s32 path15[] = {
	0x0526,
	0x0527,
	0x0528,
	0x0529,
	0x052a,
	0x052b,
	-1,
};

s32 path16[] = {
	0x052c,
	0x052d,
	0x052e,
	0x052f,
	-1,
};

s32 path17[] = {
	0x0530,
	0x0531,
	0x0532,
	0x0533,
	0x0534,
	0x0535,
	-1,
};

s32 path18[] = {
	0x0536,
	0x0537,
	0x0538,
	0x0539,
	-1,
};

s32 path19[] = {
	0x053a,
	0x053b,
	0x053c,
	0x053d,
	0x053e,
	0x053f,
	0x0540,
	0x0541,
	-1,
};

s32 path20[] = {
	0x0542,
	0x0543,
	0x0544,
	-1,
};

s32 path21[] = {
	0x0545,
	0x0546,
	0x0547,
	-1,
};

s32 path22[] = {
	0x0548,
	0x0553,
	-1,
};

s32 path23[] = {
	0x0549,
	0x0552,
	-1,
};

s32 path24[] = {
	0x054a,
	0x0551,
	-1,
};

s32 path25[] = {
	0x054b,
	0x0550,
	-1,
};

s32 path26[] = {
	0x054e,
	0x054d,
	-1,
};

s32 path27[] = {
	0x054f,
	0x054c,
	-1,
};

s32 path28[] = {
	0x0554,
	0x055f,
	-1,
};

s32 path29[] = {
	0x0555,
	0x055e,
	-1,
};

s32 path30[] = {
	0x0556,
	0x055d,
	-1,
};

s32 path31[] = {
	0x0557,
	0x055c,
	-1,
};

s32 path32[] = {
	0x0559,
	0x055a,
	-1,
};

s32 path33[] = {
	0x0558,
	0x055b,
	-1,
};

struct path paths[] = {
	{ path00, 0, PATHTYPE_BACKANDFORTH },
	{ path01, 1, PATHTYPE_BACKANDFORTH },
	{ path02, 2, PATHTYPE_CIRCULAR },
	{ path03, 3, PATHTYPE_BACKANDFORTH },
	{ path04, 4, PATHTYPE_BACKANDFORTH },
	{ path05, 5, PATHTYPE_BACKANDFORTH },
	{ path08, 8, PATHTYPE_BACKANDFORTH },
	{ path09, 9, PATHTYPE_FLYING },
	{ path10, 10, PATHTYPE_FLYING },
	{ path11, 11, PATHTYPE_FLYING },
	{ path12, 12, PATHTYPE_FLYING },
	{ path13, 13, PATHTYPE_FLYING },
	{ path14, 14, PATHTYPE_FLYING },
	{ path15, 15, PATHTYPE_FLYING },
	{ path16, 16, PATHTYPE_FLYING },
	{ path17, 17, PATHTYPE_FLYING },
	{ path18, 18, PATHTYPE_FLYING },
	{ path19, 19, PATHTYPE_FLYING },
	{ path20, 20, PATHTYPE_FLYING },
	{ path21, 21, PATHTYPE_FLYING },
	{ path22, 22, PATHTYPE_FLYING },
	{ path23, 23, PATHTYPE_FLYING },
	{ path24, 24, PATHTYPE_FLYING },
	{ path25, 25, PATHTYPE_FLYING },
	{ path26, 26, PATHTYPE_FLYING },
	{ path27, 27, PATHTYPE_FLYING },
	{ path28, 28, PATHTYPE_FLYING },
	{ path29, 29, PATHTYPE_FLYING },
	{ path30, 30, PATHTYPE_FLYING },
	{ path31, 31, PATHTYPE_FLYING },
	{ path32, 32, PATHTYPE_FLYING },
	{ path33, 33, PATHTYPE_FLYING },
	{ path34, 34, PATHTYPE_FLYING },
	{ NULL, 0, 0 },
};

u8 func0426_8420[] = {
	try_inherit_properties(0x04, /*goto*/ 0x2e)
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

#define init_path(pathid) \
	set_chr_dodge_rating(2, 0x0a) \
	set_accuracy(6) \
	set_reaction_speed(50) \
	set_chr_maxdamage(CHR_SELF, 40) \
	add_health_or_armor(0) \
	set_recovery_speed(0) \
	set_shield(0) \
	assign_path(pathid) \
	start_path \
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)



u8 func0401_start_path00[] = {
	init_path(0)
	endlist
};

u8 func0402_start_path01[] = {
	init_path(1)
	endlist
};

u8 func0403_start_path02[] = {
	init_path(2)
	endlist
};

u8 func0404_start_path03[] = {
	init_path(3)
	endlist
};

u8 func0405_start_path04[] = {
	init_path(4)
	endlist
};

u8 func0406_start_path05[] = {
	init_path(5)
	endlist
};

u8 func0407_start_path06[] = {
	assign_path(6)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func0408_start_path07[] = {
	assign_path(7)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)
	endlist
};

u8 func0409_set_rotor_speed[] = {
	set_rotor_speed(620, 7200)
	beginloop(0x04)
	endloop(0x04)

	endlist
};

u8 func040b_stop_vehicle[] = {
	set_vehicle_speed(0, 1)

	beginloop(0x04)
	endloop(0x04)

	endlist
};

u8 func0c00_init_intro[] = {
	set_returnlist(CHR_SELF, GAILIST_END_CINEMA)
	set_ailist(CHR_SELF, AILIST_INTRO)
	endlist
};

u8 func140e_check_interceptors_destroyed[] = {
	set_object_flag(OBJ_AUTOGUN_AT_START, OBJFLAG_DEACTIVATED)

	beginloop(0x04)
		if_object_in_good_condition(OBJ_INTERCEPTOR1, /*goto*/ 0x2e)
		if_stage_flag_eq(STAGEFLAG_INTERCEPTOR1_DESTROYED, TRUE, /*goto*/ 0x2e)
		set_stage_flag(STAGEFLAG_INTERCEPTOR1_DESTROYED)
		show_hudmsg(CHR_BOND, L_LUE(19)) // "Robot interceptor disabled."

		label(0x2e)
		if_object_in_good_condition(OBJ_INTERCEPTOR2, /*goto*/ 0x2e)
		if_stage_flag_eq(STAGEFLAG_INTERCEPTOR2_DESTROYED, TRUE, /*goto*/ 0x2e)
		set_stage_flag(STAGEFLAG_INTERCEPTOR2_DESTROYED)
		show_hudmsg(CHR_BOND, L_LUE(19)) // "Robot interceptor disabled."

		label(0x2e)
		if_object_in_good_condition(OBJ_INTERCEPTOR3, /*goto*/ 0x2e)
		if_stage_flag_eq(STAGEFLAG_INTERCEPTOR3_DESTROYED, TRUE, /*goto*/ 0x2e)
		set_stage_flag(STAGEFLAG_INTERCEPTOR3_DESTROYED)
		show_hudmsg(CHR_BOND, L_LUE(19)) // "Robot interceptor disabled."

		label(0x2e)
		if_stage_flag_eq(STAGEFLAG_INTERCEPTOR1_DESTROYED, FALSE, /*goto*/ 0x2e)
		if_stage_flag_eq(STAGEFLAG_INTERCEPTOR2_DESTROYED, FALSE, /*goto*/ 0x2e)
		if_stage_flag_eq(STAGEFLAG_INTERCEPTOR3_DESTROYED, FALSE, /*goto*/ 0x2e)
		show_hudmsg(CHR_BOND, L_LUE(20)) // "All robot interceptors disabled."

		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x2e)
	endloop(0x04)

	endlist
};

u8 func100c_maingate_switch[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_door_state(OBJ_MAINGATE1, DOORSTATE_CLOSING, /*goto*/ 0x2e)
		goto_next(0x06)

		label(0x2e)
		set_object_image(OBJ_MAINGATE_SWITCH, 0x00, 0x12)
		label(0x06)
		if_chr_activated_object(CHR_P1P2, OBJ_MAINGATE_SWITCH, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		assign_sound(0x043f, CHANNEL_7)
		play_sound_from_entity(CHANNEL_7, OBJ_MAINGATE_SWITCH, 0x012c, 0x0190, 0x00)
		set_object_image(OBJ_MAINGATE_SWITCH, 0x00, 0x13)
		if_door_state(OBJ_MAINGATE1, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x2e)
		show_hudmsg(CHR_P1P2, L_LUE(43)) // "Main gate has been opened."
		open_door(OBJ_MAINGATE1)
		open_door(OBJ_MAINGATE2)
		restart_timer

		beginloop(0x09)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x09)

		label(0x06)
		reloop(0x04)

		label(0x2e)
		assign_sound(0x043f, CHANNEL_7)
		play_sound_from_entity(CHANNEL_7, OBJ_MAINGATE_SWITCH, 0x012c, 0x0190, 0x00)
		set_object_image(OBJ_MAINGATE_SWITCH, 0x00, 0x12)
		show_hudmsg(CHR_P1P2, L_LUE(44)) // "Main gate has been closed."
		close_door(OBJ_MAINGATE1)
		close_door(OBJ_MAINGATE2)
		restart_timer

		beginloop(0x0a)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x0a)

		label(0x06)
	endloop(0x04)

	endlist
};

u8 func1400_give_bugs[] = {
	yield
	set_chr_team(CHR_ANTI, TEAM_ENEMY)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2e)
	give_object_to_chr(OBJ_BUG1_BOND, CHR_BOND)
	label(0x2e)
	give_object_to_chr(OBJ_BUG2_BOND, CHR_BOND)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2e)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2e)
	give_object_to_chr(OBJ_BUG1_COOP, CHR_COOP)
	label(0x2e)
	give_object_to_chr(OBJ_BUG2_COOP, CHR_COOP)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

#define check_bug_wasted(chr) \
	yield \
	beginloop(0x00) \
		if_ammo_quantity_lt(chr, AMMOTYPE_BUG, 1, /*goto*/ 0x2e) \
	endloop(0x00) \
 \
	beginloop(0x2e) \
		if_weapon_thrown(WEAPON_COMMSRIDER, /*goto*/ 0x06) \
	endloop(0x2e) \
 \
	label(0x06) \
	restart_timer \
 \
	beginloop(0x09) \
		if_weapon_thrown_on_object(WEAPON_COMMSRIDER, OBJ_ANTENNA, /*goto*/ 0x0a) \
		if_timer_gt(120, /*goto*/ 0x0b) \
	endloop(0x09) \
 \
	label(0x0a) \
	set_stage_flag(STAGEFLAG_COMMSBUG_PLACED) \
	show_hudmsg(chr, 0x2c1a) /* "Communications bug placed correctly." */ \
	set_ailist(CHR_SELF, GAILIST_IDLE) \
 \
	label(0x0b) \
	if_stage_flag_eq(STAGEFLAG_ONE_BUG_WASTED, TRUE, /*goto*/ 0x2e) \
	set_stage_flag(STAGEFLAG_ONE_BUG_WASTED) \
	set_ailist(CHR_SELF, GAILIST_IDLE) \
 \
	label(0x2e) \
	set_stage_flag(STAGEFLAG_COMMSBUG_MISPLACED) \
	show_hudmsg(chr, 0x2c1b) /* "Communications bug placed incorrectly." */ \
	set_ailist(CHR_SELF, GAILIST_IDLE)



/**
 * @unused
 */
u8 func0422_check_bug_wasted_target[] = {
	check_bug_wasted(CHR_TARGET)
	endlist
};

u8 func1003_check_bug_wasted_bond[] = {
	set_target_chr(CHR_BOND)
	check_bug_wasted(CHR_BOND)
	endlist
};

u8 func1023_check_bug_wasted_coop[] = {
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2e)
	set_target_chr(CHR_COOP)
	goto_next(0x06)

	label(0x2e)
	set_stage_flag(STAGEFLAG_ONE_BUG_WASTED)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	check_bug_wasted(CHR_COOP)
	endlist
};

u8 func1004_check_antenna_destroyed[] = {
	beginloop(0x04)
		if_object_in_good_condition(OBJ_ANTENNA, /*goto*/ 0x2e)
		show_hudmsg(CHR_BOND, L_LUE(28)) // "Antenna has been destroyed."
		set_stage_flag(STAGEFLAG_ANTENNA_DESTROYED)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x2e)
	endloop(0x04)

	endlist
};

u8 func1405_antenna_switch[] = {
	set_object_flag(OBJ_ANTENNA, OBJFLAG_DEACTIVATED)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_ANTENNA_SWITCH, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		if_stage_flag_eq(STAGEFLAG_ANTENNA_LOWERED, TRUE, /*goto*/ 0x06)
		play_sound_from_object2(CHANNEL_9, OBJ_ANTENNA_SWITCH, 0x801e, 0x00, 0x00)
		play_sound_from_object2(CHANNEL_1, OBJ_ANTENNA, 0x00cd, 0x00, 0x02)
		set_object_image(OBJ_ANTENNA_SWITCH, 0x00, 0x12)
		unset_object_flag(OBJ_ANTENNA, OBJFLAG_DEACTIVATED)
		show_hudmsg(CHR_P1P2, L_LUE(30)) // "Antenna lowered."
		set_stage_flag(STAGEFLAG_ANTENNA_LOWERED)
		restart_timer

		beginloop(0x09)
			if_timer_gt(20, /*goto*/ 0x2e)
			reloop(0x09)

			label(0x2e)
			if_lift_stationary(OBJ_ANTENNA, /*goto*/ 0x2e)
		endloop(0x09)

		label(0x2e)
		mute_channel(CHANNEL_1)
		play_sound_from_object2(CHANNEL_9, OBJ_ANTENNA_SWITCH, 0x801f, 0x00, 0x00)
		set_object_flag(OBJ_ANTENNA, OBJFLAG_DEACTIVATED)
		reloop(0x04)

		label(0x06)
		play_sound_from_object2(CHANNEL_9, OBJ_ANTENNA_SWITCH, 0x801e, 0x00, 0x00)
		play_sound_from_object2(CHANNEL_1, OBJ_ANTENNA, 0x00cd, 0x00, 0x02)
		set_object_image(OBJ_ANTENNA_SWITCH, 0x00, 0x13)
		unset_object_flag(OBJ_ANTENNA, OBJFLAG_DEACTIVATED)
		unset_stage_flag(STAGEFLAG_ANTENNA_LOWERED)
		show_hudmsg(CHR_P1P2, L_LUE(29)) // "Antenna raised."
		restart_timer

		beginloop(0x0a)
			if_timer_gt(20, /*goto*/ 0x2e)
			reloop(0x0a)

			label(0x2e)
			if_lift_stationary(OBJ_ANTENNA, /*goto*/ 0x2e)
		endloop(0x0a)

		label(0x2e)
		mute_channel(CHANNEL_1)
		play_sound_from_object2(CHANNEL_9, OBJ_ANTENNA_SWITCH, 0x801f, 0x00, 0x00)
		set_object_flag(OBJ_ANTENNA, OBJFLAG_DEACTIVATED)
	endloop(0x04)

	endlist
};

u8 func1006_lift_switches[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_LIFT1_SWITCH, /*goto*/ 0x09)
		if_chr_activated_object(CHR_P1P2, OBJ_LIFT2_SWITCH, /*goto*/ 0x0a)
		reloop(0x04)

		label(0x09)
		assign_sound(0x043f, CHANNEL_7)
		play_sound_from_entity(CHANNEL_7, OBJ_LIFT1_SWITCH, 0x012c, 0x0190, 0x00)
		if_chr_has_object(CHR_P1P2, OBJ_KEYCARD, /*goto*/ 0x2e)
		show_hudmsg(CHR_P1P2, L_LUE(36)) // "Lift access denied - key card needed."
		goto_next(0x0b)

		label(0x2e)
		set_object_image(OBJ_LIFT1_SWITCH, 0x00, 0x13)
		if_stage_flag_eq(STAGEFLAG_LIFT1_CALLED, TRUE, /*goto*/ 0x06)
		set_stage_flag(STAGEFLAG_LIFT1_CALLED)
		open_door(0x0e)
		open_door(0x38)
		unlock_door(0x0e, 0x02)
		unlock_door(0x38, 0x02)
		show_hudmsg(CHR_P1P2, L_LUE(37)) // "Key card accepted - lift operational."
		goto_next(0x0b)

		label(0x06)
		show_hudmsg(CHR_P1P2, L_LUE(38)) // "Lift is fully operational."
		goto_next(0x0b)

		label(0x0a)
		assign_sound(0x043f, CHANNEL_7)
		play_sound_from_entity(CHANNEL_7, OBJ_LIFT2_SWITCH, 0x012c, 0x0190, 0x00)
#if VERSION >= VERSION_PAL_FINAL
		if_chr_has_object(CHR_P1P2, OBJ_KEYCARD, /*goto*/ 0x2e)
#else
		if_chr_has_object(CHR_BOND, OBJ_KEYCARD, /*goto*/ 0x2e)
#endif
		show_hudmsg(CHR_P1P2, L_LUE(36)) // "Lift access denied - key card needed."
		goto_next(0x0b)

		label(0x2e)
		set_object_image(OBJ_LIFT2_SWITCH, 0x00, 0x13)
		if_stage_flag_eq(STAGEFLAG_LIFT2_CALLED, TRUE, /*goto*/ 0x06)
		set_stage_flag(STAGEFLAG_LIFT2_CALLED)
		open_door(0x0f)
		open_door(0x39)
		yield
		yield
		unlock_door(0x0f, 0x02)
		unlock_door(0x39, 0x02)
		show_hudmsg(CHR_P1P2, L_LUE(37)) // "Key card accepted - lift operational."
		goto_next(0x0b)

		label(0x06)
		show_hudmsg(CHR_P1P2, L_LUE(38)) // "Lift is fully operational."
		goto_next(0x0b)

		label(0x0b)
		restart_timer

		beginloop(0x0c)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x0c)

		label(0x06)
	endloop(0x04)

	endlist
};

u8 func1007_check_hangar_accessed[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0042, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0043, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_stage_flag(STAGEFLAG_HANGAR_ACCESSED)
	show_hudmsg(CHR_P1P2, L_LUE(39)) // "Hangar has been accessed."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1008_check_end_level[] = {
	beginloop(0x04)
		if_door_state(0x11, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x09)
		if_door_state(0x12, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x09)
	endloop(0x04)

	beginloop(0x09)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0060, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	show_hudmsg(CHR_P1P2, L_LUE(40)) // "Met up with CI agent."
	set_stage_flag(STAGEFLAG_MET_JON)
	yield
	yield
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2e)
	if_chr_dying(CHR_BOND, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x2e)
	goto_next(0x06)

	label(0x2e)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2e)
	if_chr_dying(CHR_COOP, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x2e)
	goto_next(0x06)

	label(0x2e)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	set_invincible(CHR_BOND)
	set_ailist(CHR_SELF, AILIST_OUTRO)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1009_check_radar_shut_down[] = {
	beginloop(0x04)
		if_object_in_good_condition(OBJ_RADAR_TERMINAL, /*goto*/ 0x06)
		goto_next(0x2e)
		label(0x06)
	endloop(0x04)

	label(0x2e)
	show_hudmsg(CHR_BOND, L_LUE(41)) // "Air intercept radar shut down."
	mute_channel(CHANNEL_0)
	set_stage_flag(STAGEFLAG_RADAR_SHUT_DOWN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100b_final_hangar[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_objective_complete(0, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x2e)
		if_objective_complete(1, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x2e)
		if_objective_complete(2, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		if_objective_complete(3, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		if_chr_distance_to_pad_lt(CHR_P1P2, 200, 0x01d2, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	set_stage_flag(STAGEFLAG_ENTERED_FINAL_HANGAR)
	play_x_music(CHANNEL_10, 60)
	restart_timer
	unlock_door(0x11, 0x08)
	unlock_door(0x12, 0x08)
	try_spawn_chr_at_pad(BODY_A51AIRMAN, HEAD_RANDOM, 0x01c6, 0x0411, 0x00000210, /*goto*/ 0x09)

	beginloop(0x09)
		if_timer_gt(30, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	try_spawn_chr_at_pad(BODY_A51AIRMAN, HEAD_RANDOM, 0x01c6, 0x0412, 0x00000210, /*goto*/ 0x0a)

	beginloop(0x0a)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	try_spawn_chr_at_pad(BODY_A51AIRMAN, HEAD_RANDOM, 0x01c6, 0x0413, 0x00000210, /*goto*/ 0x0b)

	beginloop(0x0b)
		if_timer_gt(90, /*goto*/ 0x06)
	endloop(0x0b)

	label(0x06)
	try_spawn_chr_at_pad(BODY_A51AIRMAN, HEAD_RANDOM, 0x01c6, 0x0414, 0x00000210, /*goto*/ 0x0c)

	// @bug: This timer check will pass immediately.
	// It was probably intended to be 120.
	beginloop(0x0c)
		if_timer_gt(1, /*goto*/ 0x06)
	endloop(0x0c)

	label(0x06)

	// This guard will shoot the spawned guards above, but this guard is NOT Jon
	beginloop(0x60)
		try_spawn_chr_at_pad(BODY_A51AIRMAN, HEAD_RANDOM, 0x01c6, AILIST_TRAITOR, 0x00000210, /*goto*/ 0x0d)
	endloop(0x60)

	label(0x0d)
	yield
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0411_init_hangar_guard1[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(8)
	set_reaction_speed(30)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(10)
	set_recovery_speed(35)
	set_shield(0)
	set_squadron(SQUADRON_0B)
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	set_self_chrflag(CHRCFLAG_00000040)
	set_chr_id(0x2c)
	set_self_flag_bankx(CHRFLAG0_10000000, BANK_0)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	try_equip_weapon(MODEL_CHRDRAGON, WEAPON_DRAGON, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	jog_to_pad(0x0420)
	yield
	set_ailist(CHR_SELF, AILIST_ALERT_WHEN_STOPPED)
	endlist
};

u8 func0412_init_hangar_guard2[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(8)
	set_reaction_speed(30)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(10)
	set_recovery_speed(35)
	set_shield(0)
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	set_squadron(SQUADRON_0B)
	set_self_chrflag(CHRCFLAG_00000040)
	set_chr_id(0x2d)
	set_self_flag_bankx(CHRFLAG0_10000000, BANK_0)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	try_equip_weapon(MODEL_CHRDRAGON, WEAPON_DRAGON, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	jog_to_pad(0x041f)
	yield
	set_ailist(CHR_SELF, AILIST_ALERT_WHEN_STOPPED)
	endlist
};

u8 func0413_init_hangar_guard3[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(8)
	set_reaction_speed(30)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(10)
	set_recovery_speed(35)
	set_shield(0)
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	set_squadron(SQUADRON_0B)
	set_self_chrflag(CHRCFLAG_00000040)
	set_chr_id(0x2e)
	set_self_flag_bankx(CHRFLAG0_10000000, BANK_0)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	try_equip_weapon(MODEL_CHRDRAGON, WEAPON_DRAGON, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	jog_to_pad(0x041e)
	yield
	set_ailist(CHR_SELF, AILIST_ALERT_WHEN_STOPPED)
	endlist
};

u8 func0414_init_hangar_guard4[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(8)
	set_reaction_speed(30)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(10)
	set_recovery_speed(35)
	set_shield(0)
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	set_squadron(SQUADRON_0B)
	set_self_chrflag(CHRCFLAG_00000040)
	set_chr_id(0x2f)
	set_self_flag_bankx(CHRFLAG0_10000000, BANK_0)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	try_equip_weapon(MODEL_CHRDRAGON, WEAPON_DRAGON, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	jog_to_pad(0x041d)
	yield
	set_target_chr(CHR_BOND)
	set_ailist(CHR_SELF, AILIST_ALERT_WHEN_STOPPED)
	endlist
};

u8 func0415_alert_when_stopped[] = {
	// @bug: This loop should have a check for seeing Jo or a distance check to
	// Jo. Without it, the guards will run past Jo at the end if she's already
	// at the door.
	beginloop(0x04)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

/**
 * This is NOT assigned to Jon.
 */
u8 func0417_traitor[] = {
	set_self_chrflag(CHRCFLAG_00000040)
	set_self_flag_bankx(CHRFLAG1_WARNED, BANK_1)
	set_accuracy(100)
	set_reaction_speed(100)
	restart_timer
	try_equip_weapon(MODEL_CHRDY357, WEAPON_DY357MAGNUM, 0x00000000, /*goto*/ 0x03)

	beginloop(0x03)
		if_timer_gt(300, /*goto*/ 0x09)
	endloop(0x03)

	label(0x09)
		open_door(0x11)
		if_chr_dying(0x2f, /*goto*/ 0x0d)
		if_chr_unloaded(0x2f, /*goto*/ 0x0d)
		set_target_chr(0x2f)
		goto_next(0x2e)

		label(0x0d)
		if_chr_dying(0x2e, /*goto*/ 0x0e)
		if_chr_unloaded(0x2e, /*goto*/ 0x0e)
		set_target_chr(0x2e)
		goto_next(0x2e)

		label(0x0e)
		if_chr_dying(0x2d, /*goto*/ 0x0f)
		if_chr_unloaded(0x2d, /*goto*/ 0x0f)
		set_target_chr(0x2d)
		goto_next(0x2e)

		label(0x0f)
		if_chr_dying(0x2c, /*goto*/ 0x10)
		if_chr_unloaded(0x2c, /*goto*/ 0x10)
		set_target_chr(0x2c)

		label(0x2e)
		call_rng
		if_rand_gt(128, /*goto*/ 0x2e)
		try_chr_kneel_and_shoot_thing(0x0220, 0x0000, /*goto*/ 0x0a)

		label(0x2e)
		try_aim_and_shoot_thing1(0x0220, 0x0000, /*goto*/ 0x0a)
		dprint 'S','H','O','O','T','F','A','I','L','E','D','\n',0,
		yield
		label(0x0a)
		try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x0b)
		goto_next(0x0c)

		beginloop(0x0b)
			chr_toggle_p1p2(CHR_SELF)
			if_chr_y(CHR_P1P2, -1373, OPERATOR_LESS_THAN, /*goto*/ 0x10)
			chr_toggle_p1p2(CHR_SELF)
			if_chr_y(CHR_P1P2, -1373, OPERATOR_LESS_THAN, /*goto*/ 0x10)
			if_chr_stopped(/*goto*/ 0x0c)
		endloop(0x0b)

		label(0x0c)
		if_chr_death_animation_finished(0x2f, /*goto*/ 0x2e)
		chr_shoot_chr(CHR_SELF, 0x2f, WEAPON_DY357MAGNUM)
		goto_next(0x06)

		label(0x2e)
		if_chr_death_animation_finished(0x2e, /*goto*/ 0x2e)
		chr_shoot_chr(CHR_SELF, 0x2e, WEAPON_DY357MAGNUM)
		goto_next(0x06)

		label(0x2e)
		if_chr_death_animation_finished(0x2d, /*goto*/ 0x2e)
		chr_shoot_chr(CHR_SELF, 0x2d, WEAPON_DY357MAGNUM)
		goto_next(0x06)

		label(0x2e)
		if_chr_death_animation_finished(0x2c, /*goto*/ 0x06)
		chr_shoot_chr(CHR_SELF, 0x2c, WEAPON_DY357MAGNUM)
		label(0x06)
	goto_first(0x09)

	label(0x10)
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_00100000)
	run_to_pad(0x0197)

	beginloop(0x60)
		if_chr_stopped(/*goto*/ 0x2e)
	endloop(0x60)

	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0416_mechanic[] = {
	set_shotlist(AILIST_MECHANIC)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2e)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2e)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2e)
	goto_next(0x06)

	label(0x2e)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	if_just_injured(CHR_SELF, /*goto*/ 0x2e)
	if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x0f)
	goto_next(0x04)

	label(0x2e)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	rebuild_teams
	rebuild_squadrons

	beginloop(0x6a)
		if_chr_stopped(/*goto*/ 0x2e)
	endloop(0x6a)

	// Not alert - at interceptor
	label(0x04)
		call_rng
		chr_do_animation(ANIM_STANDING_TYPE_ONE_HAND, 0, 193, 0x10, 0x10, CHR_SELF, 2)

		beginloop(0x09)
			chr_toggle_p1p2(CHR_SELF)
			set_target_chr(CHR_P1P2)
			if_stage_flag_eq(STAGEFLAG_TRIGGER_INTERCEPTOR, TRUE, /*goto*/ 0x2f)
			if_just_injured(CHR_SELF, /*goto*/ 0x2e)
			if_target_in_sight(/*goto*/ 0x2e)
			if_chr_stopped(/*goto*/ 0x06)
		endloop(0x09)

		label(0x06)
	goto_first(0x04)

	label(0x2f)
	jog_to_pad(0x0385)

	beginloop(0x0c)
		if_chr_stopped(/*goto*/ 0x0e)
	endloop(0x0c)

	// In bunker
	label(0x0e)
		chr_do_animation(ANIM_STANDING_TYPE_ONE_HAND, 0, 193, 0x10, 0x10, CHR_SELF, 2)

		beginloop(0x0d)
			chr_toggle_p1p2(CHR_SELF)
			set_target_chr(CHR_P1P2)
			if_heard_target_recently(/*goto*/ 0x2e)
			if_target_in_sight(/*goto*/ 0x2e)
			if_chr_stopped(/*goto*/ 0x06)
		endloop(0x0d)

		label(0x06)
	goto_first(0x0e)

	label(0x2e)
	set_alertness(100)
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x0a)

	beginloop(0x0a)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_timer_gt(30, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x0f)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	rebuild_teams
	rebuild_squadrons
	play_sound(0x80f7, CHANNEL_7)
	label(0x06)
	set_returnlist(CHR_SELF, GAILIST_ALERTED)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

u8 func1001_objectives_failed_msg[] = {
	yield
	set_object_flag2(OBJ_MINE1, OBJFLAG2_INVISIBLE)
	set_object_flag2(OBJ_MINE2, OBJFLAG2_INVISIBLE)
	set_object_flag2(OBJ_MINE3, OBJFLAG2_INVISIBLE)
	set_object_flag2(0x1a, OBJFLAG2_INVISIBLE) // invalid object
	set_object_flag2(OBJ_MINE4, OBJFLAG2_INVISIBLE)
	set_object_flag2(OBJ_MINE5, OBJFLAG2_INVISIBLE)
	set_object_flag2(OBJ_MINE6, OBJFLAG2_INVISIBLE)
	set_chr_chrflag(CHR_MECHANIC, CHRCFLAG_04000000)
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

u8 func040a_top_interceptor[] = {
	set_chr_maxdamage(CHR_SELF, 5000)
	set_object_flag(OBJ_INTERCEPTOR3, OBJFLAG_INTERCEPTOR_DISABLED)
	restart_timer

	beginloop(0x03)
		if_object_in_good_condition(OBJ_INTERCEPTOR3, /*goto*/ 0x2e)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x2e)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_INTERCEPTOR, TRUE, /*goto*/ 0x06)
	endloop(0x03)

	label(0x06)
	unset_object_flag(OBJ_INTERCEPTOR3, OBJFLAG_INTERCEPTOR_DISABLED)
	chopper_arm_weapons
	begin_hovercar_path(0x22)
	set_chr_maxdamage(CHR_SELF, 5000)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x59)
	endloop(0x04)

	label(0x58)
	yield
	label(0x09)
	begin_hovercar_path(0x22)

	beginloop(0x0a)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		label(0x06)
		if_chr_sees_player(/*goto*/ 0x59)
		reloop(0x0a)

		// Unreachable
		label(0x5a)
		dprint 'C','H','A','N','G','E',' ','T','O',' ','L','O','W','\n',0,
		goto_first(0x09)

		label(0x59)
		try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x5b)
		reloop(0x0a)

		label(0x5b)
		yield
		if_chr_sees_player(/*goto*/ 0x5c)
		restart_timer

		beginloop(0x5d)
			if_timer_gt(480, /*goto*/ 0x5e)
			if_chr_sees_player(/*goto*/ 0x5c)
		endloop(0x5d)

		label(0x5e)
		stop_chr
	endloop(0x0a)

	label(0x5c)
	goto_first(0x5b)

	endlist
};

u8 func040c_init_bottom_interceptors[] = {
	set_chr_maxdamage(CHR_SELF, 5000)
	set_object_flag(OBJ_INTERCEPTOR1, OBJFLAG_INTERCEPTOR_DISABLED)
	set_object_flag(OBJ_INTERCEPTOR2, OBJFLAG_INTERCEPTOR_DISABLED)

	beginloop(0x04)
	endloop(0x04)

	endlist
};

u8 func040d_90c8[] = {
	set_self_chrflag(CHRCFLAG_00000020)
	set_accuracy(30)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func040e_outro[] = {
	open_door(0x11)
	hide_object(OBJ_HOVERBIKE)
	camera_movement(0x017d)
	set_music_track(MUSIC_INFILTRATION_OUTRO)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0xf1, CHRCFLAG_HIDDEN)
	set_ailist(CHR_P1P2, GAILIST_IDLE)
	set_chr_chrflag(CHR_JONATHAN, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_OUTRO_GUARD, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)

	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_P1P2, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_P1P2, CHRHFLAG_00020000)
	chr_do_animation(0x017f, -1, -1, 0x06, 0x00, CHR_P1P2, 4)
	set_chr_hudpiece_visible(CHR_P1P2, TRUE)

	set_chr_chrflag(CHR_JONATHAN, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_JONATHAN, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_JONATHAN, CHRHFLAG_00020000)
	chr_do_animation(0x017e, -1, -1, 0x06, 0x00, CHR_JONATHAN, 4)

	set_chr_chrflag(CHR_OUTRO_GUARD, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_OUTRO_GUARD, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_OUTRO_GUARD, CHRHFLAG_00020000)
	chr_do_animation(0x0180, -1, -1, 0x06, 0x00, CHR_OUTRO_GUARD, 4)

	restart_timer
	show_nonessential_chrs(FALSE)
	set_cutscene_weapon(CHR_P1P2, -1, -1)
	yield
	set_cutscene_weapon(CHR_P1P2, -1, WEAPON_FALCON2)

	#define wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0x54) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)



	wait_until(1, 0x60)
	speak(CHR_P1P2, L_LUE(67), 0x7421, CHANNEL_5, COLOR_07_RED) // "Agent Dark! Over here!"

	wait_until(46, 0x61)
	play_sound(0x0171, CHANNEL_7)

	wait_until(74, 0x62)
	play_sound(0x0172, CHANNEL_6)

	wait_until(100, 0x64)
	play_sound(0x0173, CHANNEL_7)

	wait_until(150, 0x65)
	speak(CHR_P1P2, L_LUE(68), 0x7422, CHANNEL_5, COLOR_09_BLUE) // "There you are! I was beginning to wonder if..."

	wait_until(188, 0x66)
	play_sound(0x0174, CHANNEL_6)

	wait_until(278, 0x67)
	play_sound(0x0175, CHANNEL_7)

	wait_until(290, 0x68)
	set_chr_shooting_in_cutscene(CHR_JONATHAN, TRUE)
	yield
	yield
	set_chr_shooting_in_cutscene(CHR_JONATHAN, FALSE)

	wait_until(296, 0x79)
	play_sound(0x8076, CHANNEL_10)

	wait_until(310, 0x7a)
	play_sound(0x0090, CHANNEL_10)

	wait_until(392, 0x69)
	play_sound(0x808e, CHANNEL_10)

	wait_until(406, 0x6c)
	speak(CHR_P1P2, L_LUE(69), 0x7423, CHANNEL_5, COLOR_07_RED) // "If what?"

	wait_until(410, 0x6a)
	play_sound(0x0176, CHANNEL_6)

	wait_until(424, 0x6b)
	play_sound(0x0177, CHANNEL_6)

	wait_until(426, 0x6c)
	play_sound(0x0177, CHANNEL_7)

	wait_until(464, 0x6d)
	play_sound(0x007d, CHANNEL_10)

	wait_until(472, 0x6e)
	speak(CHR_P1P2, L_LUE(70), 0x7424, CHANNEL_5, COLOR_09_BLUE) // "If you'd been discovered yet. And frankly, if this..."

	wait_until(900, 0x70)
	speak(CHR_P1P2, L_LUE(71), 0x7425, CHANNEL_5, COLOR_07_RED) // "I was tidying up one of your loose ends."

	wait_until(936, 0x6f)
	play_sound(0x0178, CHANNEL_7)

	wait_until(1080, 0x71)
	speak(CHR_P1P2, L_LUE(72), 0x7426, CHANNEL_5, COLOR_09_BLUE) // "My loose ends?"

	wait_until(1180, 0x72)
	speak(CHR_P1P2, L_LUE(73), 0x7427, CHANNEL_5, COLOR_07_RED) // "I'm sorry, I didn't realize you wanted him to shoo..."

	wait_until(1228, 0x73)
	play_sound(0x0171, CHANNEL_7)

	wait_until(1286, 0x74)
	play_sound(0x0172, CHANNEL_7)

	wait_until(1434, 0x75)
	play_sound(0x0173, CHANNEL_7)

	wait_until(1462, 0x77)
	play_sound(0x0174, CHANNEL_6)

	wait_until(1585, 0x76)
	speak(CHR_P1P2, L_LUE(74), 0x7428, CHANNEL_5, COLOR_09_BLUE) // "Okay, okay, forget about it. I'm going to let the ..."

	wait_until(1588, 0x78)
	play_sound(0x0175, CHANNEL_7)

	beginloop(0x09)
		if_camera_animating(/*goto*/ 0x2e)
		goto_next(0x54)

		label(0x2e)
		if_controller_button_pressed(/*goto*/ 0x54)
		label(0x2e)
	endloop(0x09)

	label(0x54)
	label(0x06)
	remove_chr(CHR_OUTRO_GUARD)
	set_chr_hudpiece_visible(CHR_P1P2, FALSE)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0410_intro[] = {
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	if_controller_button_pressed(/*goto*/ 0x54)
	set_music_track(MUSIC_INFILTRATION_INTRO)
	camera_movement(0x0181)
	set_chr_chrflag(0x0c, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x0d, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x32, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x32, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x32, CHRHFLAG_00020000)
	chr_do_animation(0x0182, -1, -1, 0x06, 0x00, 0x32, 4)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	restart_timer
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 90)
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_FALCON2, WEAPON_NONE)

	wait_until(26, 0x60)
	speak(CHR_BOND, L_LUE(58), 0x7418, CHANNEL_7, COLOR_06_WHITE) // "Okay, Joanna, take a look at this. Our operative i..."

	wait_until(500, 0x61)
	speak(CHR_BOND, L_LUE(59), 0x7419, CHANNEL_7, COLOR_06_WHITE) // "This is your entry point... A deserted helipad on ..."

	wait_until(800, 0x62)
	speak(CHR_BOND, L_LUE(60), 0x741a, CHANNEL_7, COLOR_06_WHITE) // "The lift down to the hangars and the rendezvous po..."

	wait_until(1200, 0x63)

	wait_until(1236, 0x64)
	speak(CHR_BOND, L_LUE(61), 0x741b, CHANNEL_7, COLOR_06_WHITE) // "Here is the communications antenna. Attach a comms..."

	beginloop(0x09)
		if_camera_animating(/*goto*/ 0x2e)
		goto_next(0x06)

		label(0x2e)
		if_controller_button_pressed(/*goto*/ 0x06)
		label(0x2e)
	endloop(0x09)

	label(0x06)
	label(0x55)
	unset_chr_chrflag(0x32, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	label(0x54)
	if_controller_button_pressed(/*goto*/ 0x54)
	camera_movement(0x0183)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)

	set_chr_chrflag(0x29, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x29, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x29, CHRHFLAG_00020000)
	chr_do_animation(0x0184, -1, -1, 0x06, 0x00, 0x29, 4)

	set_chr_chrflag(0x2a, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x2a, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x2a, CHRHFLAG_00020000)
	chr_do_animation(0x0185, -1, -1, 0x06, 0x00, 0x2a, 4)

	set_chr_chrflag(0x2b, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x2b, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x2b, CHRHFLAG_00020000)
	chr_do_animation(0x0186, -1, -1, 0x06, 0x00, 0x2b, 4)

	set_object_flag2(0x2f, OBJFLAG2_04000000)
	set_object_flag3(0x2f, OBJFLAG3_00000010)
	object_do_animation(0x0187, 0x2f, 0x04, 0xffff)
	restart_timer

	wait_until(186, 0x65)
	speak(CHR_BOND, L_LUE(62), 0x81b9, CHANNEL_7, COLOR_09_BLUE) // "Oh, my God!"

	wait_until(380, 0x66)
	speak(CHR_BOND, L_LUE(63), 0x741d, CHANNEL_7, COLOR_06_WHITE) // "Here is our friend. He appears to be physically un..."

	beginloop(0x0a)
		if_camera_animating(/*goto*/ 0x2e)
		goto_next(0x06)

		label(0x2e)
		if_controller_button_pressed(/*goto*/ 0x06)
		label(0x2e)
	endloop(0x0a)

	label(0x06)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x29, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x2a, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x2b, CHRCFLAG_UNPLAYABLE)
	unset_object_flag2(0x2f, OBJFLAG2_04000000)
	label(0x54)
	if_controller_button_pressed(/*goto*/ 0x54)
	camera_movement(0x0188)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)

	set_chr_chrflag(0x2a, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x2a, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x2a, CHRHFLAG_00020000)
	chr_do_animation(0x0189, -1, -1, 0x06, 0x00, 0x2a, 4)

	set_chr_chrflag(0x2b, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x2b, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x2b, CHRHFLAG_00020000)
	chr_do_animation(0x018a, -1, -1, 0x06, 0x00, 0x2b, 4)

	set_object_flag2(0x2f, OBJFLAG2_04000000)
	set_object_flag3(0x2f, OBJFLAG3_00000010)
	object_do_animation(0x018b, 0x2f, 0x04, 0xffff)
	restart_timer

	wait_until(416, 0x67)
	speak(CHR_BOND, L_LUE(64), 0x741e, CHANNEL_7, COLOR_09_BLUE) // "But who was...?"

	wait_until(485, 0x68)
	speak(CHR_BOND, L_LUE(65), 0x741f, CHANNEL_7, COLOR_06_WHITE) // "Any questions? No. Good. Away you go to the hangar..."

	beginloop(0x0b)
		if_camera_animating(/*goto*/ 0x2e)
		goto_next(0x06)

		label(0x2e)
		if_controller_button_pressed(/*goto*/ 0x06)
		label(0x2e)
	endloop(0x0b)

	label(0x06)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x2a, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x2b, CHRCFLAG_UNPLAYABLE)
	unset_object_flag2(0x2f, OBJFLAG2_04000000)
	label(0x54)
	camera_movement(0x00f0)
	cmd0175(60)
	if_controller_button_pressed(/*goto*/ 0x54)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x00f1, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	set_chr_chrflag(0x03, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(0x03, CHRHFLAG_00020000)
	unset_chr_chrflag(0x03, CHRCFLAG_HIDDEN)
	restart_timer

	wait_until(1, 0x69)
	speak(CHR_BOND, L_LUE(66), 0x7420, CHANNEL_10, COLOR_09_BLUE) // "Agent Dark Mission Log, 1028 hours. Against my bet..."

	wait_until(340, 0x6a)
	play_sound(0x80d5, CHANNEL_10)

	wait_until(364, 0x6b)
	play_sound(0x04b0, CHANNEL_10)

	wait_until(458, 0x6c)
	play_sound(0x046e, CHANNEL_10)

	play_sound(0x80d5, CHANNEL_10)
	wait_until(496, 0x6d)
	play_sound(0x80cc, CHANNEL_10)

	play_sound(0x80cd, CHANNEL_10)
	wait_until(638, 0x6e)

	wait_until(688, 0x6f)
	play_sound(0x046f, CHANNEL_10)
	play_sound(0x80ce, CHANNEL_10)
	play_sound(0x80cf, CHANNEL_10)

	wait_until(750, 0x70)
	play_sound(0x016a, CHANNEL_10)

	wait_until(815, 0x71)
	play_sound(0x016b, CHANNEL_10)

	wait_until(844, 0x72)
	play_sound(0x016c, CHANNEL_10)

	wait_until(908, 0x73)
	play_sound(0x0169, CHANNEL_10)

	wait_until(916, 0x74)

	beginloop(0x0c)
		if_camera_animating(/*goto*/ 0x2e)
		goto_next(0x54)

		label(0x2e)
		if_controller_button_pressed(/*goto*/ 0x54)
		label(0x2e)
	endloop(0x0c)

	label(0x54)
	mute_channel(CHANNEL_10)
	mute_channel(CHANNEL_7)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x0c, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x0d, CHRCFLAG_HIDDEN)
	remove_chr(0x32)
	remove_chr(0x29)
	remove_chr(0x2a)
	remove_chr(0x2b)
	hide_object(0x2f)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x00f1, -2, -1, 0x06, 0x00, CHR_BOND, 2)
	unset_chr_chrflag(0x03, CHRCFLAG_UNPLAYABLE)
	set_ailist(0x02, 0x0426)
	set_ailist(0x03, 0x0426)
	unset_object_flag2(OBJ_INTERCEPTOR1, OBJFLAG2_INVISIBLE)
	unset_object_flag2(OBJ_INTERCEPTOR2, OBJFLAG2_INVISIBLE)
	unset_object_flag2(OBJ_INTERCEPTOR3, OBJFLAG2_INVISIBLE)
	restart_default_music
	reset_ambience
	enter_firstperson
	set_stage_flag(STAGEFLAG_INTRO_FINISHED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * This pad is right next to where you start. Most likely the guard was changed
 * to use a path instead, but this function remained.
 *
 * @unused
 */
u8 func0418_walk_to_pad[] = {
	walk_to_pad(0x0019)
	beginloop(0x09)
	endloop(0x09)

	endlist
};

u8 func1010_bunker_lighting[] = {
	yield
	set_chr_team(CHR_ANTI, TEAM_ENEMY)
	restart_timer

	beginloop(0x09)
		if_stage_flag_eq(STAGEFLAG_EXPLOSIVES_PLACED, TRUE, /*goto*/ 0x06)
		if_stage_flag_eq(STAGEFLAG_ANY_LASER_DESTROYED, TRUE, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	mute_channel(CHANNEL_0)
	yield
	assign_sound(0x04ac, CHANNEL_0)
	play_sound_from_object(CHANNEL_0, 0x10, 0x0320, 0x044c)
	set_lights_state(0x0009, 0x03, 0xff, 0x32, 0x78)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0e)
	restart_timer

	beginloop(0x0a)
		if_timer_gt(30, /*goto*/ 0x2e)
	endloop(0x0a)

	label(0x2e)

	beginloop(0x0b)
		if_timer_gt(40, /*goto*/ 0x2e)
	endloop(0x0b)

	label(0x2e)
	label(0x0e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1012_bunker_laser1[] = {
	if_difficulty_gt(DIFF_A, /*goto*/ 0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// SA and PA only
	label(0x2e)
	restart_timer

	beginloop(0x09)
		if_stage_flag_eq(STAGEFLAG_EXPLOSIVES_PLACED, TRUE, /*goto*/ 0x0a)
		if_stage_flag_eq(STAGEFLAG_ANY_LASER_DESTROYED, TRUE, /*goto*/ 0x0a)
	endloop(0x09)

	label(0x0a)
		restart_timer
		close_door(0x1e)

		beginloop(0x0b)
			if_stage_flag_eq(STAGEFLAG_RADAR_SHUT_DOWN, TRUE, /*goto*/ 0x10)
			if_timer_gt(180, /*goto*/ 0x06)
		endloop(0x0b)

		label(0x06)
		restart_timer
		open_door(0x1e)

		beginloop(0x0c)
			if_stage_flag_eq(STAGEFLAG_RADAR_SHUT_DOWN, TRUE, /*goto*/ 0x10)
			if_timer_gt(180, /*goto*/ 0x06)
		endloop(0x0c)

		label(0x06)
	goto_first(0x0a)

	label(0x10)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1013_bunker_lasers234[] = {
	if_difficulty_gt(DIFF_A, /*goto*/ 0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2e)
	restart_timer

	beginloop(0x09)
		if_stage_flag_eq(STAGEFLAG_EXPLOSIVES_PLACED, TRUE, /*goto*/ 0x0a)
		if_stage_flag_eq(STAGEFLAG_ANY_LASER_DESTROYED, TRUE, /*goto*/ 0x0a)
	endloop(0x09)

	label(0x0a)
		restart_timer
		close_door(0x1f)
		close_door(0x20)
		close_door(0x21)

		beginloop(0x0b)
			if_stage_flag_eq(STAGEFLAG_RADAR_SHUT_DOWN, TRUE, /*goto*/ 0x10)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x0b)

		label(0x06)
		restart_timer
		open_door(0x1f)
		open_door(0x20)
		open_door(0x21)

		beginloop(0x0c)
			if_stage_flag_eq(STAGEFLAG_RADAR_SHUT_DOWN, TRUE, /*goto*/ 0x10)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x0c)

		label(0x06)
	goto_first(0x0a)

	label(0x10)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1013_bunker_lasers56[] = {
	if_difficulty_gt(DIFF_A, /*goto*/ 0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2e)
	restart_timer

	beginloop(0x09)
		if_stage_flag_eq(STAGEFLAG_EXPLOSIVES_PLACED, TRUE, /*goto*/ 0x0a)
		if_stage_flag_eq(STAGEFLAG_ANY_LASER_DESTROYED, TRUE, /*goto*/ 0x0a)
	endloop(0x09)

	label(0x0a)
		restart_timer
		close_door(0x22)

		beginloop(0x0b)
			if_stage_flag_eq(STAGEFLAG_RADAR_SHUT_DOWN, TRUE, /*goto*/ 0x10)
			if_timer_gt(60, /*goto*/ 0x06)
		endloop(0x0b)

		label(0x06)
		restart_timer
		open_door(0x22)
		close_door(0x23)

		beginloop(0x0c)
			if_stage_flag_eq(STAGEFLAG_RADAR_SHUT_DOWN, TRUE, /*goto*/ 0x10)
			if_timer_gt(60, /*goto*/ 0x06)
		endloop(0x0c)

		label(0x06)
		label(0x06)
		restart_timer
		open_door(0x23)
		close_door(0x24)

		beginloop(0x0d)
			if_stage_flag_eq(STAGEFLAG_RADAR_SHUT_DOWN, TRUE, /*goto*/ 0x10)
			if_timer_gt(60, /*goto*/ 0x06)
		endloop(0x0d)

		label(0x06)
		label(0x06)
		restart_timer
		open_door(0x24)

		beginloop(0x0e)
			if_stage_flag_eq(STAGEFLAG_RADAR_SHUT_DOWN, TRUE, /*goto*/ 0x10)
			if_timer_gt(60, /*goto*/ 0x06)
		endloop(0x0e)

		label(0x06)
	goto_first(0x0a)

	label(0x10)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1013_bunker_lasers[] = {
	if_difficulty_gt(DIFF_A, /*goto*/ 0x03)

	// Agent - hide lasers
	hide_object(0x1e)
	hide_object(0x1f)
	hide_object(0x20)
	hide_object(0x21)
	hide_object(0x22)
	hide_object(0x23)
	hide_object(0x24)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// SA and PA
	label(0x03)
		set_object_flag(0x1e, OBJFLAG_40000000)
		set_object_flag(0x1f, OBJFLAG_40000000)
		set_object_flag(0x20, OBJFLAG_40000000)
		set_object_flag(0x21, OBJFLAG_40000000)
		set_object_flag(0x22, OBJFLAG_40000000)
		set_object_flag(0x23, OBJFLAG_40000000)
		set_object_flag(0x24, OBJFLAG_40000000)
		open_door(0x1e)
		open_door(0x1f)
		open_door(0x20)
		open_door(0x21)
		open_door(0x22)
		open_door(0x23)
		open_door(0x24)
		set_object_flag(0x1e, OBJFLAG_40000000)
		set_object_flag(0x1f, OBJFLAG_40000000)
		set_object_flag(0x20, OBJFLAG_40000000)
		set_object_flag(0x21, OBJFLAG_40000000)
		set_object_flag(0x22, OBJFLAG_40000000)
		set_object_flag(0x23, OBJFLAG_40000000)
		set_object_flag(0x24, OBJFLAG_40000000)

		beginloop(0x04)
			if_stage_flag_eq(STAGEFLAG_EXPLOSIVES_PLACED, TRUE, /*goto*/ 0x09)
			if_stage_flag_eq(STAGEFLAG_ANY_LASER_DESTROYED, TRUE, /*goto*/ 0x09)
			if_door_state(0x1e, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x06)
		endloop(0x04)

		label(0x06)
	goto_first(0x03)

	beginloop(0x09)
		if_stage_flag_eq(STAGEFLAG_RADAR_SHUT_DOWN, TRUE, /*goto*/ 0x2e)
	endloop(0x09)

	label(0x2e)
	open_door(0x1e)
	open_door(0x1f)
	open_door(0x20)
	open_door(0x21)
	open_door(0x22)
	open_door(0x23)
	open_door(0x24)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1011_bunker_explosives[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_RADAR_TERMINAL, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		if_chr_weapon_equipped(CHR_P1P2, WEAPON_EXPLOSIVES, /*goto*/ 0x2e)
		show_hudmsg(CHR_P1P2, L_LUE(45)) // "Access denied."
	goto_first(0x04)

	label(0x2e)
	unset_object_flag2(OBJ_EXPLOSIVE_BRICK, OBJFLAG2_INVISIBLE)
	show_hudmsg(CHR_P1P2, L_LUE(46)) // "Explosive has been placed."
	remove_weapon_from_inventory(WEAPON_EXPLOSIVES)
	set_stage_flag(STAGEFLAG_EXPLOSIVES_PLACED)
	restart_timer

	beginloop(0x0a)
		if_timer_gt(180, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	yield
	set_countdown_timer(20)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2e)
	if_stage_flag_eq(STAGEFLAG_ANY_LASER_DESTROYED, TRUE, /*goto*/ 0x06)
	show_hudmsg(CHR_P1P2, L_LUE(47)) // "Intruder detected - security system online."
	goto_next(0x06)

	// Agent
	label(0x2e)
	show_hudmsg(CHR_P1P2, L_LUE(75)) // "Foreign object detected - security alerted."
	label(0x06)
	play_x_music(CHANNEL_10, 20)
	yield
	show_countdown_timer
	start_countdown_timer

	beginloop(0x09)
		if_countdown_timer_lt(1, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	hide_countdown_timer
	unset_object_flag(OBJ_RADAR_TERMINAL, OBJFLAG_INVINCIBLE)
	yield
	move_object_to_pad(0x25, 0x036b)
	hide_object(OBJ_EXPLOSIVE_BRICK)
	unset_object_flag(0x25, OBJFLAG_INVINCIBLE)
	destroy_object(0x25)
	destroy_object(OBJ_RADAR_TERMINAL)
	mute_channel(CHANNEL_0)
	assign_sound(0x0479, CHANNEL_0)
	control_sound_from_object(CHANNEL_0, OBJ_RADAR_TERMINAL, TRUE)
	restart_timer

	beginloop(0x0b)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x0b)

	label(0x06)
	move_object_to_pad(0x26, 0x0375)
	unset_object_flag(0x26, OBJFLAG_INVINCIBLE)
	destroy_object(0x26)
	move_object_to_pad(0x27, 0x0376)
	unset_object_flag(0x27, OBJFLAG_INVINCIBLE)
	destroy_object(0x27)
	move_object_to_pad(0x28, 0x0372)
	unset_object_flag(0x28, OBJFLAG_INVINCIBLE)
	destroy_object(0x28)
	yield
	restart_timer

	beginloop(0x0c)
		if_timer_gt(90, /*goto*/ 0x06)
	endloop(0x0c)

	label(0x06)
	unset_object_flag(0x51, OBJFLAG_INVINCIBLE)
	destroy_object(0x51)
	restart_timer

	beginloop(0x7b)
		if_timer_gt(90, /*goto*/ 0x06)
	endloop(0x7b)

	label(0x06)
	unset_object_flag(0x2d, OBJFLAG_INVINCIBLE)
	move_object_to_pad(0x2d, 0x0379)
	destroy_object(0x2d)
	restart_timer

	beginloop(0x11)
		if_timer_gt(90, /*goto*/ 0x06)
	endloop(0x11)

	label(0x06)
	label(0x06)
	unset_object_flag(0x29, OBJFLAG_INVINCIBLE)
	move_object_to_pad(0x29, 0x0373)
	destroy_object(0x29)
	restart_timer

	beginloop(0x0d)
		if_timer_gt(90, /*goto*/ 0x06)
	endloop(0x0d)

	label(0x06)
	unset_object_flag(0x2a, OBJFLAG_INVINCIBLE)
	move_object_to_pad(0x2a, 0x0374)
	destroy_object(0x2a)
	restart_timer

	beginloop(0x0e)
		if_timer_gt(90, /*goto*/ 0x06)
	endloop(0x0e)

	label(0x06)
	unset_object_flag(0x2b, OBJFLAG_INVINCIBLE)
	move_object_to_pad(0x2b, 0x0377)
	destroy_object(0x2b)
	restart_timer

	beginloop(0x0f)
		if_timer_gt(90, /*goto*/ 0x06)
	endloop(0x0f)

	label(0x06)
	unset_object_flag(0x2c, OBJFLAG_INVINCIBLE)
	move_object_to_pad(0x2c, 0x0378)
	destroy_object(0x2c)
	restart_timer

	beginloop(0x10)
		if_timer_gt(90, /*goto*/ 0x06)
	endloop(0x10)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1016_trigger_interceptor[] = {
	restart_timer

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_COMMSBUG_PLACED, TRUE, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x09)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x0a)

		// PA - 60 seconds
		if_timer_gt(3600, /*goto*/ 0x06)
		goto_first(0x04)

		// Agent - 120 seconds
		label(0x09)
		if_timer_gt(7200, /*goto*/ 0x06)
		reloop(0x04)

		// SA - 90 seconds
		label(0x0a)
		if_timer_gt(5400, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_stage_flag(STAGEFLAG_TRIGGER_INTERCEPTOR)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1017_radar_terminal_noise[] = {
	yield
	assign_sound(0x8146, CHANNEL_0)
	play_sound_from_object(CHANNEL_0, OBJ_RADAR_TERMINAL, 0x0320, 0x044c)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1018_unhide_guards[] = {
	set_chr_chrflag(0x35, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x1f, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x20, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x21, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x22, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x23, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x24, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x35, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x1f, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x20, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x21, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x22, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x23, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x24, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)

	// Agent: wait until guards 0x10 and 0x11 are dead
	// (two guards near antenna blue door)
	// SA and PA: Wait until bug thrown on antenna
	beginloop(0x04)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x06)
		if_objective_complete(1, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x06)
		if_chr_death_animation_finished(0x10, /*goto*/ 0x06)
		if_chr_dying(0x10, /*goto*/ 0x06)
		if_chr_unloaded(0x10, /*goto*/ 0x06)
		goto_first(0x04)

		label(0x06)
		if_chr_death_animation_finished(0x11, /*goto*/ 0x2e)
		if_chr_dying(0x11, /*goto*/ 0x2e)
		if_chr_unloaded(0x11, /*goto*/ 0x2e)
	endloop(0x04)

	// Enable 4 more guards - the ones inside the blue door
	label(0x2e)
	unset_chr_chrflag(0x1f, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x20, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x21, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x22, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x1f, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x20, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x21, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x22, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x1f, AILIST_TROOPER_ALERTED)
	set_ailist(0x20, AILIST_TROOPER_ALERTED)
	set_ailist(0x21, AILIST_TROOPER_ALERTED)
	set_ailist(0x22, AILIST_TROOPER_ALERTED)

	// Wait until player in room 0x0044 (first hangar ramp)
	beginloop(0x09)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0044, /*goto*/ 0x2e)
	endloop(0x09)

	// Enable 2 more guards
	label(0x2e)
	unset_chr_chrflag(0x23, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x24, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x23, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x24, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x23, AILIST_DRAGON_ALERTED)
	set_ailist(0x24, AILIST_DRAGON_ALERTED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0419_clone_spawner[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(8)
	set_reaction_speed(30)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(10)
	set_recovery_speed(35)
	set_shield(0)
	set_self_chrflag(CHRCFLAG_00000002)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_00040000)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_ENTERED_FINAL_HANGAR, TRUE, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		dprint 'O','B','J','E','C','T','I','V','E',' ','D','O','N','E','\n',0,
		if_never_been_onscreen(/*goto*/ 0x4f)
		if_chr_sees_player(/*goto*/ 0x09)
		reloop(0x04)

		label(0x09)
		set_ailist(CHR_SELF, AILIST_ALERTED_SPAWNED_GUARD)

		label(0x4f)
		unset_self_chrflag(CHRCFLAG_HIDDEN)
		unset_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x4f)
		reloop(0x04)

		label(0x4f)
		try_spawn_clone2(CHR_SELF, AILIST_INIT_ALERTED_SPAWNED_GUARD, 0x00000000, /*goto*/ 0x2e)
		set_ailist(CHR_SELF, AILIST_ALERTED_SPAWNED_GUARD)

		label(0x2e)
		yield
	endloop(0x04)

	endlist
};

u8 func041a_init_alerted_spawned_guard[] = {
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	label(0x04)
	rebuild_teams
	rebuild_squadrons
	try_inherit_properties(0x25, /*goto*/ 0x06)
	label(0x06)
	set_ailist(CHR_SELF, AILIST_ALERTED_SPAWNED_GUARD)
	endlist
};

u8 func041b_alerted_spawned_guard[] = {
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

u8 func1019_spawn_guards_at_antenna[] = {
	// Agent: wait until guards 0x10 and 0x11 are dead
	// (two guards near antenna blue door)
	// SA and PA: Wait until bug thrown on antenna
	beginloop(0x04)
		dprint 'C','H','E','C','K',' ','F','O','R',' ','O','B','J','E','C','T','I','V','E','\n',0,
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x06)
		if_objective_complete(1, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x06)
		if_chr_death_animation_finished(0x10, /*goto*/ 0x06)
		if_chr_dying(0x10, /*goto*/ 0x06)
		if_chr_unloaded(0x10, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		if_chr_death_animation_finished(0x11, /*goto*/ 0x2e)
		if_chr_dying(0x11, /*goto*/ 0x2e)
		if_chr_unloaded(0x11, /*goto*/ 0x2e)
	endloop(0x04)

	// Spawn 3 guards
	label(0x2e)
	label(0x06)
	set_morale(3)

	beginloop(0x56)
		dprint 'T','R','Y',' ','C','R','E','A','T','E','\n',0,
		if_morale_lt(1, /*goto*/ 0x06)
		try_spawn_chr_at_pad(BODY_A51TROOPER, HEAD_RANDOM, 0x00a0, AILIST_SPAWNED_GUARD, 0x00000200, /*goto*/ 0x57)
		reloop(0x56)

		label(0x57)
		yield
		dprint 'C','R','E','A','T','E','\n',0,
		subtract_morale(1)
		restart_timer

		beginloop(0x09)
			if_timer_gt(10, /*goto*/ 0x2e)
		endloop(0x09)

		label(0x2e)
	endloop(0x56)

	label(0x06)
	yield
	yield
	yield
	yield
	yield
	unset_chr_chrflag(0x35, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x35, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x35, GAILIST_SEARCH_FOR_PLAYER)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040f_spawned_guard[] = {
	try_equip_weapon(MODEL_CHRLEEGUN1, WEAPON_MAGSEC4, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	set_self_flag_bankx(CHRFLAG0_04000000, BANK_0)
	set_squadron(SQUADRON_0E)
	set_self_chrflag(CHRCFLAG_00080000)
	try_inherit_properties(0x35, /*goto*/ 0x06)
	label(0x06)
	restart_timer

	beginloop(0x0a)
		if_timer_gt(300, /*goto*/ 0x2e)
	endloop(0x0a)

	label(0x2e)
	run_to_pad(0x0095) // outside blue door

	beginloop(0x09)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_SEARCH_FOR_PLAYER)
	endlist
};

#define init_guard(accuracy, reaction, armor, recovery, function) \
	set_accuracy(accuracy) \
	set_reaction_speed(reaction) \
	set_chr_maxdamage(CHR_SELF, 40) \
	add_health_or_armor(armor) \
	set_recovery_speed(recovery) \
	set_shield(0) \
	set_ailist(CHR_SELF, function)



u8 func041d_trooper_unalerted[] = {
	set_chr_dodge_rating(2, 0x0a)
	init_guard(6, 50, 0, 0, GAILIST_UNALERTED)
	endlist
};

u8 func041f_trooper_alerted[] = {
	set_chr_dodge_rating(2, 0x0a)
	init_guard(6, 50, 0, 0, GAILIST_ALERTED)
	endlist
};

u8 func041e_dragon_unalerted[] = {
	init_guard(8, 30, 10, 35, GAILIST_UNALERTED)
	endlist
};

u8 func0420_dragon_alerted[] = {
	init_guard(8, 30, 10, 35, GAILIST_ALERTED)
	endlist
};

u8 func141f_start_lifts[] = {
	activate_lift(2, 0x31)
	activate_lift(3, 0x32)
	activate_lift(4, 0x33)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101a_check_mechanic_dead[] = {
	yield
	unset_savefile_flag(SAVEFILEFLAG_RESCUE_MECHANIC_DEAD)

	beginloop(0x04)
		if_chr_dying(CHR_MECHANIC, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	set_savefile_flag(SAVEFILEFLAG_RESCUE_MECHANIC_DEAD)
	dprint 'D','E','L','E','T','E',' ','M','E','C','H','\n',0,
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * @bug: This message cannot be played because the player has no way to get to
 * room 0x0001, which is above the bunker roof.
 */
u8 func101b_msg_airinterceptradar[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0001, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	speak(CHR_P1P2, L_LUE(53), 0x817d, CHANNEL_6, COLOR_09_BLUE) // "The air intercept radar is controlled from that bu..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101c_msg_cantthrow[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0e)
	restart_timer

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0013, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	speak(CHR_P1P2, L_LUE(54), 0x73b9, CHANNEL_6, COLOR_09_BLUE) // "There's the antenna, but... I can't throw a bug th..."
	label(0x0e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * This message is also unplayable.
 */
u8 func101d_msg_hangarlift[] = {
	// Wait for radar shut down and player in room 0x0001 (which is impossible)
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_objective_complete(0, /*goto*/ 0x2e)
		reloop(0x04)

		label(0x2e)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0001, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	speak(CHR_P1P2, L_LUE(55), 0x817e, CHANNEL_6, COLOR_09_BLUE) // "The hangar lift is on the other side of that huge ..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101e_msg_triggerfinger[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0051, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	speak(CHR_P1P2, L_LUE(56), 0x817f, CHANNEL_6, COLOR_09_BLUE) // "Careful with that trigger finger, Agent Dark - you..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0421_activate_autogun[] = {
	set_shotlist(GAILIST_ALERTED)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x2e)
		if_heard_target_recently(/*goto*/ 0x2e)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x2e)
	endloop(0x04)

	label(0x2e)
	run_to_pad(0x0384)

	beginloop(0x09)
		if_object_in_good_condition(OBJ_AUTOGUN_AT_START, /*goto*/ 0x06)
		goto_next(0x0e)

		label(0x06)
		if_chr_stopped(/*goto*/ 0x2e)
	endloop(0x09)

	label(0x2e)
	chr_do_animation(ANIM_STANDING_TYPE_ONE_HAND, 0, 120, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x0a)
		if_chr_stopped(/*goto*/ 0x2e)
	endloop(0x0a)

	label(0x2e)
	if_object_in_good_condition(OBJ_AUTOGUN_AT_START, /*goto*/ 0x2e)
	goto_next(0x06)

	label(0x2e)
	unset_object_flag(OBJ_AUTOGUN_AT_START, OBJFLAG_DEACTIVATED)
	label(0x06)
	set_ailist(CHR_SELF, GAILIST_ALERTED)

	label(0x0e)
	say_quip(CHR_BOND, 0x12, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	restart_timer
	chr_do_animation(ANIM_SURPRISED_0202, 0, -1, 0x00, 0x10, CHR_SELF, 2)

	beginloop(0x7c)
		if_timer_gt(60, /*goto*/ 0x7d)
	endloop(0x7c)

	label(0x7d)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

/**
 * Randomly select one of two guards near the start to be the one who will
 * attempt to activate the autogun.
 */
u8 func1020_choose_autogun_guard[] = {
	yield
	call_rng
	if_rand_gt(128, /*goto*/ 0x2e)
	set_ailist(0x00, AILIST_ACTIVATE_AUTOGUN)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2e)
	set_ailist(0x01, AILIST_ACTIVATE_AUTOGUN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1021_damage_rl_guard[] = {
	yield
	damage_chr(CHR_ROCKETLAUNCHER_GUARD, 18)
	yield
	damage_chr(CHR_ROCKETLAUNCHER_GUARD, 18)
	yield
	damage_chr(CHR_ROCKETLAUNCHER_GUARD, 18)
	yield
	damage_chr(CHR_ROCKETLAUNCHER_GUARD, 18)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1022_check_lift_switches_destroyed[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_LIFT1_CALLED, TRUE, /*goto*/ 0x06)
		if_stage_flag_eq(STAGEFLAG_LIFT2_CALLED, TRUE, /*goto*/ 0x06)
		if_object_in_good_condition(OBJ_LIFT1_SWITCH, /*goto*/ 0x2e)
		if_object_in_good_condition(OBJ_LIFT2_SWITCH, /*goto*/ 0x2e)
		show_hudmsg(CHR_BOND, L_LUE(57)) // "Lift access terminals destroyed."
		set_stage_flag(STAGEFLAG_LIFT_SWITCHES_DESTROYED)
		goto_next(0x06)

		label(0x2e)
	endloop(0x04)

	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1024_lift_door_sounds[] = {
	beginloop(0x7e)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, 0x3c, /*goto*/ 0x0a)
		if_chr_activated_object(CHR_P1P2, 0x3e, /*goto*/ 0x0b)
		if_chr_activated_object(CHR_P1P2, 0x3d, /*goto*/ 0x41)
		if_chr_activated_object(CHR_P1P2, 0x3f, /*goto*/ 0x41)
		if_chr_activated_object(CHR_P1P2, 0x40, /*goto*/ 0x2e)
		if_chr_activated_object(CHR_P1P2, 0x41, /*goto*/ 0x2e)
		if_chr_activated_object(CHR_P1P2, 0x42, /*goto*/ 0x2e)
		if_chr_activated_object(CHR_P1P2, 0x43, /*goto*/ 0x2e)
		goto_first(0x7e)

		label(0x0a)
		if_door_locked(0x3c, 0x02, /*goto*/ 0x2f)
		goto_next(0x41)

		label(0x0b)
		if_door_locked(0x3e, 0x02, /*goto*/ 0x2f)
		goto_next(0x41)

		label(0x41)
		play_sound(0x01dc, -1)
		goto_next(0x06)

		label(0x2e)
		play_sound(0x81b0, -1)
		goto_next(0x06)

		label(0x2f)
		play_sound(0x05dd, -1)
		label(0x06)
		restart_timer

		beginloop(0x09)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x09)

		label(0x06)
	endloop(0x7e)

	endlist
};

u8 func1025_spawn_bunker_guards[] = {
	// This logic is pointless and all leads to label 0x04 anyway
	if_difficulty_gt(DIFF_SA, /*goto*/ 0x2e)
	goto_next(0x04)
	label(0x2e)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x0e)

	beginloop(0x04)
		yield
		yield
		yield
		yield
		if_stage_flag_eq(STAGEFLAG_EXPLOSIVES_PLACED, TRUE, /*goto*/ 0x2e)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x06)
		if_stage_flag_eq(STAGEFLAG_ANY_LASER_DESTROYED, TRUE, /*goto*/ 0x2e)
		label(0x06)
	endloop(0x04)

	label(0x2e)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2e)
	if_stage_flag_eq(STAGEFLAG_ANY_LASER_DESTROYED, FALSE, /*goto*/ 0x0e)
	label(0x2e)
	restart_timer

	beginloop(0x60)
		try_spawn_chr_at_pad(BODY_A51AIRMAN, HEAD_RANDOM, 0x0057, 0x0423, 0x00000300, /*goto*/ 0x0a)
	endloop(0x60)

	beginloop(0x0a)
		if_timer_gt(30, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)

	beginloop(0x61)
		try_spawn_chr_at_pad(BODY_A51AIRMAN, HEAD_RANDOM, 0x0050, 0x0423, 0x00000300, /*goto*/ 0x0b)
	endloop(0x61)

	beginloop(0x0b)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x0b)

	label(0x06)
	label(0x0e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0423_a5e8[] = {
	try_inherit_properties(0x25, /*goto*/ 0x06)
	label(0x06)
	set_alertness(100)
	set_self_flag_bankx(CHRFLAG0_CAN_HEAR_ALARMS, BANK_0)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	set_self_flag_bankx(CHRFLAG0_AIVSAI, BANK_0)
	set_self_flag_bankx(CHRFLAG0_CAN_HEARSPAWN, BANK_0)
	try_equip_weapon(MODEL_CHRDRAGON, WEAPON_DRAGON, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, AILIST_TROOPER_ALERTED)
	endlist
};

#define watch_for_laser_broken(crate1, crate2, laser) \
	if_difficulty_gt(DIFF_A, /*goto*/ 0x7e) \
	set_ailist(CHR_SELF, GAILIST_IDLE) \
 \
	/* SA and PA */ \
	beginloop(0x7e) \
		if_object_in_good_condition(crate1, /*goto*/ 0x2e) \
		goto_next(0x06) \
 \
		label(0x2e) \
		if_object_in_good_condition(crate2, /*goto*/ 0x2e) \
		goto_next(0x06) \
 \
		label(0x2e) \
	endloop(0x7e) \
 \
	label(0x06) \
	hide_object(laser) \
	set_ailist(CHR_SELF, AILIST_ACTIVATE_LASERS)



u8 func1026_check_laser1_broken[] = {
	watch_for_laser_broken(0x44, 0x45, 0x1e)
	endlist
};

u8 func1027_check_laser2_broken[] = {
	watch_for_laser_broken(0x46, 0x47, 0x1f)
	endlist
};

u8 func1028_check_laser3_broken[] = {
	watch_for_laser_broken(0x48, 0x49, 0x20)
	endlist
};

u8 func1029_check_laser4_broken[] = {
	watch_for_laser_broken(0x4a, 0x4b, 0x21)
	endlist
};

u8 func102a_check_laser5_broken[] = {
	watch_for_laser_broken(0x4c, 0x4d, 0x22)
	endlist
};

u8 func102b_check_laser6_broken[] = {
	watch_for_laser_broken(0x4e, 0x4f, 0x23)
	endlist
};

u8 func102c_check_laser7_broken[] = {
	watch_for_laser_broken(0x50, 0x52, 0x24)
	endlist
};

u8 func0424_activate_lasers[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2e)

	// PA
	label(0x7e)
	if_stage_flag_eq(STAGEFLAG_ANY_LASER_DESTROYED, TRUE, /*goto*/ 0x2e)
	set_stage_flag(STAGEFLAG_ANY_LASER_DESTROYED)
	if_stage_flag_eq(STAGEFLAG_EXPLOSIVES_PLACED, TRUE, /*goto*/ 0x2e)
	show_hudmsg(CHR_BOND, L_LUE(47)) // "Intruder detected - security system online."

	// A and SA
	label(0x2e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0425_a7d4[] = {
	label(0x04)
	yield
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * This hidden guard is used as a template for cloning others.
 */
u8 func041c_template_guard[] = {
	label(0x04)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102d_check_antenna_switch_destroyed[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0e)

	beginloop(0x04)
		if_object_in_good_condition(OBJ_ANTENNA_SWITCH, /*goto*/ 0x06)
		goto_next(0x2e)

		label(0x06)
	endloop(0x04)

	label(0x2e)
	if_stage_flag_eq(STAGEFLAG_ANTENNA_LOWERED, TRUE, /*goto*/ 0x2e)
	show_hudmsg(CHR_BOND, L_LUE(42)) // "Critical mission object destroyed."
	set_stage_flag(STAGEFLAG_ANTENNA_DESTROYED)
	label(0x2e)
	label(0x0e)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102e_setup_rtracker[] = {
	yield
	set_object_flag3(OBJ_ROCKETLAUNCHER, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func142f_setup_lighting[] = {
	yield
	misc_command(0x0000, 0x00, 0x00)
	misc_command(0x0000, 0x01, 0x00)
	misc_command(0x0000, 0x02, 0x00)
	misc_command(0x0000, 0x03, 0x00)
	misc_command(0x0000, 0x04, 0x00)
	misc_command(0x0001, 0x06, 0x01)
	misc_command(0x0002, 0x05, 0x01)
	misc_command(0x0002, 0x06, 0x01)
	misc_command(0x0003, 0x05, 0x01)
	misc_command(0x0004, 0x05, 0x01)
	misc_command(0x0005, 0x05, 0x01)
	misc_command(0x0005, 0x06, 0x01)
	misc_command(0x0006, 0x05, 0x01)
	misc_command(0x0006, 0x06, 0x01)
	misc_command(0x0007, 0x05, 0x01)
	misc_command(0x0007, 0x06, 0x01)
	misc_command(0x0008, 0x05, 0x01)
	misc_command(0x0008, 0x06, 0x01)
	misc_command(0x000a, 0x05, 0x01)
	misc_command(0x000b, 0x05, 0x01)
	misc_command(0x000e, 0x05, 0x01)
	misc_command(0x0010, 0x05, 0x01)
	misc_command(0x0011, 0x05, 0x01)
	misc_command(0x0012, 0x05, 0x01)
	misc_command(0x0013, 0x05, 0x01)
	misc_command(0x0013, 0x06, 0x01)
	misc_command(0x0014, 0x05, 0x01)
	misc_command(0x0014, 0x06, 0x01)
	misc_command(0x0015, 0x05, 0x01)
	misc_command(0x0015, 0x06, 0x01)
	misc_command(0x0016, 0x05, 0x01)
	misc_command(0x0018, 0x05, 0x01)
	misc_command(0x0019, 0x05, 0x01)
	misc_command(0x001a, 0x05, 0x01)
	misc_command(0x001b, 0x05, 0x01)
	misc_command(0x001c, 0x05, 0x01)
	misc_command(0x001d, 0x05, 0x01)
	misc_command(0x001e, 0x05, 0x01)
	misc_command(0x001e, 0x06, 0x01)
	misc_command(0x001f, 0x05, 0x01)
	misc_command(0x001f, 0x06, 0x01)
	misc_command(0x0020, 0x05, 0x01)
	misc_command(0x0020, 0x06, 0x01)
	misc_command(0x0017, 0x05, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

struct ailist ailists[] = {
	{ func0401_start_path00,                   0x0401 },
	{ func0402_start_path01,                   0x0402 },
	{ func0403_start_path02,                   0x0403 },
	{ func0404_start_path03,                   0x0404 },
	{ func0405_start_path04,                   0x0405 },
	{ func0406_start_path05,                   0x0406 },
	{ func0407_start_path06,                   0x0407 },
	{ func0408_start_path07,                   0x0408 },
	{ func0409_set_rotor_speed,                0x0409 },
	{ func040a_top_interceptor,                0x040a },
	{ func040b_stop_vehicle,                   0x040b },
	{ func040c_init_bottom_interceptors,       0x040c },
	{ func040d_90c8,                           0x040d },
	{ func0411_init_hangar_guard1,             0x0411 },
	{ func0412_init_hangar_guard2,             0x0412 },
	{ func0413_init_hangar_guard3,             0x0413 },
	{ func0414_init_hangar_guard4,             0x0414 },
	{ func0415_alert_when_stopped,             0x0415 },
	{ func0416_mechanic,                       0x0416 },
	{ func0417_traitor,                        0x0417 },
	{ func0418_walk_to_pad,                    0x0418 },
	{ func040f_spawned_guard,                  0x040f },
	{ func040e_outro,                          0x040e },
	{ func0410_intro,                          0x0410 },
	{ func0419_clone_spawner,                  0x0419 },
	{ func041a_init_alerted_spawned_guard,     0x041a },
	{ func041c_template_guard,                 0x041c },
	{ func041b_alerted_spawned_guard,          0x041b },
	{ func041d_trooper_unalerted,              0x041d },
	{ func041e_dragon_unalerted,               0x041e },
	{ func041f_trooper_alerted,                0x041f },
	{ func0420_dragon_alerted,                 0x0420 },
	{ func0421_activate_autogun,               0x0421 },
	{ func0422_check_bug_wasted_target,        0x0422 },
	{ func0423_a5e8,                           0x0423 },
	{ func0424_activate_lasers,                0x0424 },
	{ func0425_a7d4,                           0x0425 },
	{ func0426_8420,                           0x0426 },
	{ func0c00_init_intro,                     0x0c00 },
	{ func040e_outro,                          0x0c01 },
	{ func1400_give_bugs,                      0x1400 },
	{ func1001_objectives_failed_msg,          0x1001 },
	{ func0c00_init_intro,                     0x1002 },
	{ func1003_check_bug_wasted_bond,          0x1003 },
	{ func1004_check_antenna_destroyed,        0x1004 },
	{ func1405_antenna_switch,                 0x1405 },
	{ func1006_lift_switches,                  0x1006 },
	{ func1007_check_hangar_accessed,          0x1007 },
	{ func1008_check_end_level,                0x1008 },
	{ func1009_check_radar_shut_down,          0x1009 },
	{ func100b_final_hangar,                   0x100b },
	{ func100c_maingate_switch,                0x100c },
	{ func140e_check_interceptors_destroyed,   0x140e },
	{ func1010_bunker_lighting,                0x1010 },
	{ func1011_bunker_explosives,              0x1011 },
	{ func1012_bunker_laser1,                  0x1012 },
	{ func1013_bunker_lasers,                  0x1013 },
	{ func1013_bunker_lasers234,               0x1014 },
	{ func1013_bunker_lasers56,                0x1015 },
	{ func1016_trigger_interceptor,            0x1016 },
	{ func1017_radar_terminal_noise,           0x1017 },
	{ func1018_unhide_guards,                  0x1018 },
	{ func1019_spawn_guards_at_antenna,        0x1019 },
	{ func101a_check_mechanic_dead,            0x101a },
	{ func101b_msg_airinterceptradar,          0x101b },
	{ func101c_msg_cantthrow,                  0x101c },
	{ func101d_msg_hangarlift,                 0x101d },
	{ func101e_msg_triggerfinger,              0x101e },
	{ func141f_start_lifts,                    0x141f },
	{ func1020_choose_autogun_guard,           0x1020 },
	{ func1021_damage_rl_guard,                0x1021 },
	{ func1022_check_lift_switches_destroyed,  0x1022 },
	{ func1023_check_bug_wasted_coop,          0x1023 },
	{ func1024_lift_door_sounds,               0x1024 },
	{ func1025_spawn_bunker_guards,            0x1025 },
	{ func1026_check_laser1_broken,            0x1026 },
	{ func1027_check_laser2_broken,            0x1027 },
	{ func1028_check_laser3_broken,            0x1028 },
	{ func1029_check_laser4_broken,            0x1029 },
	{ func102a_check_laser5_broken,            0x102a },
	{ func102b_check_laser6_broken,            0x102b },
	{ func102c_check_laser7_broken,            0x102c },
	{ func102d_check_antenna_switch_destroyed, 0x102d },
	{ func102e_setup_rtracker,                 0x102e },
	{ func142f_setup_lighting,                 0x142f },
	{ NULL, 0 },
};

