//
// Rescue
//

#include "stagesetup.h"

// Characters
#define CHR_ALIEN              0x38
#define CHR_DOORMAN            0x39
#define CHR_LABTECH_RECORDS    0x3a
#define CHR_LABTECH_LIGHTS     0x3b
#define CHR_LABTECH_DOORS1     0x3c
#define CHR_LABTECH_SHOWERS    0x3d
#define CHR_LABTECH_HARRYSMATE 0x3e
#define CHR_LABTECH_KEYCARDGUY 0x3f
#define CHR_BIOTECH1           0x40
#define CHR_BIOTECH2           0x41
#define CHR_LABTECH_DOORS2     0x42
#define CHR_MECHANIC           0x43
#define CHR_JONATHAN           0x48
#define CHR_INTRO_DEAD_GUARD   0x49

// Objects
#define OBJ_LABCOAT1         0x00
#define OBJ_DOOR_TERMINAL    0x02
#define OBJ_DATAUPLINK_BOND  0x05
#define OBJ_KEYCARD          0x06
#define OBJ_CRATE            0x17
#define OBJ_WALL             0x18
#define OBJ_AUTOGUN          0x19
#define OBJ_CHAMBER1         0x1a
#define OBJ_CHAMBER2         0x1b
#define OBJ_CHAMBER3         0x1c
#define OBJ_CHAMBER4         0x1d
#define OBJ_CHAMBER5         0x1e
#define OBJ_CHAMBER6         0x1f
#define OBJ_CHAMBER7         0x20
#define OBJ_CHAMBER8         0x21
#define OBJ_CHAMBER1_SWITCH  0x22
#define OBJ_CHAMBER2_SWITCH  0x23
#define OBJ_CHAMBER3_SWITCH  0x24
#define OBJ_CHAMBER4_SWITCH  0x25
#define OBJ_CHAMBER5_SWITCH  0x26
#define OBJ_CHAMBER6_SWITCH  0x27
#define OBJ_CHAMBER7_SWITCH  0x28
#define OBJ_CHAMBER8_SWITCH  0x29
#define OBJ_DATAUPLINK_COOP  0x3a
#define OBJ_LABCOAT2         0x3e
#define OBJ_LABCOAT3         0x3f
#define OBJ_LABCOAT4         0x40
#define OBJ_LABCOAT5         0x41
#define OBJ_FALCON2SILENCED1 0x4c
#define OBJ_FALCON2SILENCED2 0x4d
#define OBJ_PHOENIX          0x4e

// Stage flags
#define STAGEFLAG_CHAMBER4_RAISED             0x00000001
#define STAGEFLAG_CHAMBER5_RAISED             0x00000002
#define STAGEFLAG_CHAMBER6_RAISED             0x00000004
#define STAGEFLAG_CHAMBER7_RAISED             0x00000008
#define STAGEFLAG_CHAMBER8_RAISED             0x00000010
#define STAGEFLAG_LOOKING_AT_CHAMBER          0x00000020
#define STAGEFLAG_ONE_KEYCARD_GUARD_REMAINING 0x00000040
#define STAGEFLAG_UPLINK_TERMINAL_DESTROYED   0x00000080
#define STAGEFLAG_USED_DISGUISE               0x00000100
#define STAGEFLAG_RECORDS_DESTROYED           0x00000200
#define STAGEFLAG_DOOR_VIRUS_DOWNLOADED       0x00000400
#define STAGEFLAG_LIGHT_VIRUS_DONE            0x00000800
#define STAGEFLAG_AUTOGUN_VIRUS_DONE          0x00001000
#define STAGEFLAG_ENTERED_LAB                 0x00002000
#define STAGEFLAG_DISGUISE_UNCOVERED          0x00010000
#define STAGEFLAG_LABTECH_DEAD                0x00020000
#define STAGEFLAG_DOORMAN_REJECTED            0x00040000
#define STAGEFLAG_DOORMAN_DEAD                0x00080000
#define STAGEFLAG_KEYCARDGUY_ANGRY            0x00100000
#define STAGEFLAG_ENTERED_ELVIS_AREA          0x00200000
#define STAGEFLAG_RESCUED_ELVIS               0x00400000
#define STAGEFLAG_ELVIS_DEAD                  0x00800000
#define STAGEFLAG_XRAY_DONE                   0x01000000
#define STAGEFLAG_CHAMBER_SWITCH_DESTROYED    0x02000000
#define STAGEFLAG_CRATE_DESTROYED             0x08000000
#define STAGEFLAG_AUTOGUN_ACTIVATED           0x10000000
#define STAGEFLAG_CHAMBER1_RAISED             0x20000000
#define STAGEFLAG_CHAMBER2_RAISED             0x40000000
#define STAGEFLAG_CHAMBER3_RAISED             0x80000000

// AI Lists
#define AILIST_LABTECH_SA_PA          0x0410
#define AILIST_LABTECH_AGENT          0x0411
#define AILIST_INIT_LABTECH           0x0412
#define AILIST_MECHANIC               0x0413
#define AILIST_INIT_MECHANIC          0x0414
#define AILIST_WAREHOUSE_SPAWNER      0x0415
#define AILIST_BECOME_UNAWARE         0x0416
#define AILIST_WAREHOUSE_CLONE        0x0417
#define AILIST_DOORMAN                0x0418
#define AILIST_INIT_DOORMAN           0x0419
#define AILIST_LABTECH_HARRYSMATE     0x041a
#define AILIST_LABTECH_KEYCARDGUY     0x041b
#define AILIST_LABTECH_LIGHTS         0x041f
#define AILIST_LABTECH_DOORS          0x0420
#define AILIST_INIT_LABTECH_DOORS     0x0421
#define AILIST_LABTECH_RECORDS        0x0422
#define AILIST_INIT_LABTECH_RECORDS   0x0423
#define AILIST_ALIEN                  0x0424
#define AILIST_HIDDENGUY              0x0425
#define AILIST_CHECK_LOOKING_AT_ALIEN 0x0426
#define AILIST_SHOCK_CLONE            0x0427
#define AILIST_OUTRO                  0x0428
#define AILIST_DRAGON_GUARD           0x042c
#define AILIST_SUPERDRAGON_GUARD      0x042d
#define AILIST_BIOTECH_GUARD          0x042e
#define AILIST_BIOTECH_GUARD_ALERTED  0x042f
#define AILIST_BIOTECH2               0x0430
#define AILIST_BIOTECH1               0x0431
#define AILIST_INIT_BIOTECH1          0x0432
#define AILIST_INIT_BIOTECH2          0x0433

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x2a01)
	briefing(1, 0x2a00)
	briefing(2, 0x2a02)
	briefing(3, 0x2a03)

	beginobjective(0, L_LIP(10), (DIFFBIT_PA | DIFFBIT_PD)) // "Destroy computer records"
		complete_flags(STAGEFLAG_RECORDS_DESTROYED)
		fail_flags(STAGEFLAG_UPLINK_TERMINAL_DESTROYED)
	endobjective

	beginobjective(1, L_LIP(11), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Locate conspiracy evidence"
		complete_flags(STAGEFLAG_XRAY_DONE)
		fail_flags(STAGEFLAG_CHAMBER_SWITCH_DESTROYED)
	endobjective

	beginobjective(2, L_LIP(9), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Obtain and use lab technician disguise"
		complete_flags(STAGEFLAG_USED_DISGUISE)
		fail_flags(STAGEFLAG_DISGUISE_UNCOVERED)
	endobjective

	beginobjective(3, L_LIP(12), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Gain access to autopsy lab"
		complete_flags(STAGEFLAG_ENTERED_LAB)
		require_object_collected(OBJ_KEYCARD)
		fail_flags(STAGEFLAG_DOORMAN_REJECTED)
		fail_flags(STAGEFLAG_DOORMAN_DEAD)
	endobjective

	beginobjective(4, L_LIP(13), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Rescue the crash Survivor"
		complete_flags(STAGEFLAG_RESCUED_ELVIS)
		fail_flags(STAGEFLAG_ELVIS_DEAD)
		fail_flags(STAGEFLAG_CRATE_DESTROYED)
	endobjective

	chr(0x00000200, 0x00, 0x039f, BODY_A51AIRMAN, HEAD_RANDOM, 0x0401, -1, -1, 1000, 20, 0x8c008800, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0000, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x01, 0x03a2, BODY_A51AIRMAN, HEAD_RANDOM, 0x0402, -1, -1, 1000, 20, 0x8c008800, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0001, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x02, 0x03a3, BODY_A51AIRMAN, HEAD_RANDOM, 0x0403, -1, -1, 1000, 20, 0x8c008800, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0002, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x03, 0x03a4, BODY_A51AIRMAN, HEAD_RANDOM, 0x0404, -1, -1, 1000, 20, 0xac008800, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0003, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x04, 0x03a5, BODY_A51AIRMAN, HEAD_RANDOM, 0x0405, -1, -1, 1000, 20, 0xac008800, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0004, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x05, 0x0386, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_GUARD, -1, -1, 2000, 20, 0xac008800, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0005, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x06, 0x0387, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_GUARD, -1, -1, 2000, 20, 0xac008800, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0006, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x07, 0x03a7, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_GUARD, -1, -1, 1000, 20, 0xa000c800, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0007, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x08, 0x03a6, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_GUARD, -1, -1, 1000, 20, 0x80008a00, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0008, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x09, 0x03a8, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_GUARD, -1, -1, 1000, 20, 0xa000c800, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0009, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0a, 0x03cb, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_GUARD, -1, -1, 1000, 20, 0xa000c800, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x000a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0b, 0x03a9, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_DRAGON_GUARD, -1, -1, 1000, 100, 0xc008c800, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x000b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0c, 0x03aa, BODY_A51AIRMAN, HEAD_RANDOM, 0x0406, -1, -1, 1000, 100, 0xc008c800, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x000c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0d, 0x01bb, BODY_A51AIRMAN, HEAD_RANDOM, 0x0406, -1, -1, 1000, 100, 0xc008c800, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x000d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0e, 0x01bc, BODY_A51AIRMAN, HEAD_RANDOM, 0x0406, -1, -1, 1000, 100, 0xc008c800, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x000e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0f, 0x03ab, BODY_AREA51GUARD, HEAD_RANDOM, 0x0407, -1, -1, 1000, 100, 0xc008c000, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x000f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x10, 0x03ac, BODY_AREA51GUARD, HEAD_RANDOM, 0x0408, -1, -1, 1000, 100, 0xc008c000, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0010, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x11, 0x03ae, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0x8000c000, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0011, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00010000, 0x3a, 0x03af, BODY_LABTECH, HEAD_RANDOM, AILIST_INIT_LABTECH_RECORDS, -1, -1, 1000, 100, 0x0000c000, 0x00000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	chr(0x00000200, 0x27, 0x03bf, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SUPERDRAGON_GUARD, -1, -1, 100, 100, 0xc008c000, 0x00000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0027, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x28, 0x03c0, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SUPERDRAGON_GUARD, -1, -1, 100, 100, 0xc008c000, 0x00000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0028, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x12, 0x03b1, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0x8000c000, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0012, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00014000, 0x3b, 0x03d8, BODY_LABTECH, HEAD_RANDOM, AILIST_LABTECH_LIGHTS, -1, -1, 1000, 6, 0x0000c000, 0x00000000, TEAM_ENEMY, SQUADRON_06, 0x3b, 0, 0x00010000)
	chr(0x00000200, 0x13, 0x03b2, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0x8008c000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0013, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00010000, 0x3c, 0x03c9, BODY_LABTECH, HEAD_RANDOM, AILIST_INIT_LABTECH_DOORS, 0x03c8, -1, 1000, 100, 0x8008c000, 0x00000000, TEAM_20, SQUADRON_07, -1, 0, 0x00000000)
	chr(0x00010000, 0x42, 0x03b3, BODY_LABTECH, HEAD_RANDOM, AILIST_INIT_LABTECH_DOORS, 0x03c9, -1, 1000, 100, 0x8008c004, 0x00000000, TEAM_20, SQUADRON_07, -1, 0, 0x00000000)
	chr(0x00000200, 0x14, 0x00f7, BODY_AREA51GUARD, HEAD_RANDOM, 0x0409, -1, -1, 1000, 100, 0x8000c000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0014, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x15, 0x00f0, BODY_AREA51GUARD, HEAD_RANDOM, 0x040a, -1, -1, 1000, 100, 0x8000c000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0015, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00010000, 0x3d, 0x03b4, BODY_LABTECH, HEAD_RANDOM, AILIST_INIT_LABTECH, -1, -1, 1000, 100, 0x00000000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	chr(0x00000200, 0x18, 0x00c7, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0xc000a000, 0x00000000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0018, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1e, 0x0130, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SUPERDRAGON_GUARD, 0x0132, -1, 1000, 100, 0x800a8204, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x001e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x19, 0x0131, BODY_BIOTECH, HEAD_BIOTECH, AILIST_BIOTECH_GUARD, 0x0136, -1, 1000, 100, 0x800a8204, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRUGGUN, 0x0019, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_TRANQUILIZER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1a, 0x013b, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SUPERDRAGON_GUARD, 0x013c, -1, 1000, 100, 0x800a8204, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x001a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1d, 0x0137, BODY_BIOTECH, HEAD_BIOTECH, AILIST_BIOTECH_GUARD, 0x013a, -1, 1000, 100, 0x800a8204, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRUGGUN, 0x001d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_TRANQUILIZER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1b, 0x0123, BODY_AREA51GUARD, HEAD_RANDOM, 0x040b, -1, -1, 1000, 100, 0x8000a000, 0x00000000, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x001b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1c, 0x0124, BODY_AREA51GUARD, HEAD_RANDOM, 0x040c, -1, -1, 1000, 100, 0x8000a000, 0x00000000, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x001c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x3e, 0x03c1, BODY_LABTECH, HEAD_RANDOM, AILIST_LABTECH_HARRYSMATE, -1, -1, 1000, 100, 0x00084000, 0x00000000, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	chr(0x00000000, 0x3f, 0x03c2, BODY_LABTECH, HEAD_RANDOM, AILIST_LABTECH_KEYCARDGUY, -1, -1, 1000, 15, 0x00084000, 0x00000000, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	chr(0x00000400, 0x39, 0x0121, BODY_AREA51GUARD, HEAD_BEAU1, AILIST_INIT_DOORMAN, -1, -1, 1000, 100, 0x8008c000, 0x00000000, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0039, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x33, 0x03cc, BODY_BIOTECH, HEAD_BIOTECH, GAILIST_IDLE, -1, -1, 1000, 100, 0x80002000, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRUGGUN, 0x0033, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_TRANQUILIZER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x34, 0x03cd, BODY_BIOTECH, HEAD_BIOTECH, GAILIST_IDLE, -1, -1, 1000, 100, 0x80002000, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRUGGUN, 0x0034, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_TRANQUILIZER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x37, 0x03d0, BODY_AREA51GUARD, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 1000, 100, 0x8c080000, 0x00004000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0037, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2c, 0x03d1, BODY_AREA51GUARD, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 1000, 100, 0x8c080000, 0x00004000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x002c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2d, 0x03d2, BODY_AREA51GUARD, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 1000, 100, 0x8c080000, 0x00004000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x002d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2e, 0x03d3, BODY_AREA51GUARD, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 1000, 100, 0x8c080000, 0x00004000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x002e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2f, 0x03d4, BODY_BIOTECH, HEAD_BIOTECH, GAILIST_IDLE, -1, -1, 1000, 100, 0xc008a000, 0x00000000, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRUGGUN, 0x002f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_TRANQUILIZER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x30, 0x03d5, BODY_AREA51GUARD, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 1000, 100, 0xc008a000, 0x00000000, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0030, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x31, 0x03d6, BODY_AREA51GUARD, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 1000, 100, 0xc008a000, 0x00000000, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0031, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x32, 0x03d7, BODY_AREA51GUARD, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 1000, 100, 0xc008a000, 0x00000000, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0032, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1f, 0x03b5, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0x84008000, 0x00004000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x001f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x20, 0x03b6, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0x84008000, 0x00004000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0020, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x21, 0x03b7, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0x84008000, 0x00004000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0021, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x22, 0x03b8, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0x84008000, 0x00004000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0022, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x23, 0x03b9, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0xc008c000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0023, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x24, 0x03ba, BODY_BIOTECH, HEAD_BIOTECH, AILIST_BIOTECH_GUARD, -1, -1, 1000, 100, 0xc008c000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRUGGUN, 0x0024, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_TRANQUILIZER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x25, 0x03bb, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0xc008c000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0025, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x26, 0x03bc, BODY_AREA51GUARD, HEAD_RANDOM, AILIST_SUPERDRAGON_GUARD, -1, -1, 1000, 100, 0xc008c000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSUPERDRAGON, 0x0026, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUPERDRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000400, 0x40, 0x03be, BODY_BIOTECH, HEAD_BIOTECH, AILIST_INIT_BIOTECH1, -1, -1, 1000, 100, 0x0000c000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSONICSCREWER, 0x0040, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_52, 0x00ffffff, 0x00000000)
	chr(0x00000400, 0x41, 0x03dc, BODY_BIOTECH, HEAD_BIOTECH, AILIST_INIT_BIOTECH2, -1, -1, 1000, 100, 0x0000c000, 0x00000000, TEAM_NONCOMBAT, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRSONICSCREWER, 0x0041, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_52, 0x00ffffff, 0x00000000)
	chr(0x00010000, 0x43, 0x01de, BODY_OVERALL, HEAD_RANDOM, AILIST_INIT_MECHANIC, -1, -1, 1000, 5, 0x0000c000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	tag(0x2f, 1)
	hover_prop(0x0100, MODEL_HOVERBED, 0x03bd, 0x05120101, 0x00304300, 0x00100003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	chr(0x00000000, 0x44, 0x0196, BODY_A51AIRMAN, HEAD_RANDOM, AILIST_HIDDENGUY, -1, -1, 1000, 100, 0x8008c600, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0044, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x47, 0x0119, BODY_AREA51GUARD, HEAD_RANDOM, 0x0429, -1, -1, 1000, 100, 0x80002000, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0047, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000400, 0x48, 0x020a, BODY_A51AIRMAN, HEAD_JONATHAN, GAILIST_IDLE, -1, -1, 1000, 100, 0x40004600, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDY357, 0x0048, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DY357MAGNUM, 0x00ffffff, 0x00000000)
	chr(0x00000400, 0x49, 0x0197, BODY_A51AIRMAN, HEAD_RANDOM, GAILIST_IDLE, -1, -1, 1000, 100, 0x40004600, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	chr(0x00004400, 0x38, 0x0134, BODY_ELVIS1, HEAD_ELVIS, AILIST_ALIEN, -1, -1, 2000, 100, 0xc0002400, 0x00000100, TEAM_NONCOMBAT, SQUADRON_09, 0x1a, 0, 0x00010000)
	door_scale(0x00008000)
	tag(0x35, 1)
	lift(0x0100, MODEL_A51_LIFT_STORE, 0x0334, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0334, 0x0335, 0xffffffff, 0x00000001, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x20000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51LIFTDOOR, 0x02e2, 0x04000400, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00000888, 0x00000888, 0x00000147, 0x00000000, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51LIFTDOOR, 0x02e1, 0x04000400, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00000888, 0x00000888, 0x00000147, 0x00000000, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-2, -3, 0, 0)
	link_objects(-2, -4, 0, 1)
	tag(0x39, 1)
	lift(0x0100, MODEL_A51_LIFT_THINWALL, 0x0336, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0336, 0x0337, 0xffffffff, 0x00000001, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x20000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51LIFTDOOR, 0x02e4, 0x04000400, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00000888, 0x00000888, 0x00000147, 0x00080000, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51LIFTDOOR, 0x02e3, 0x04000400, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00000888, 0x00000888, 0x00000147, 0x00080000, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-2, -3, 0, 0)
	link_objects(-2, -4, 0, 1)
	door_scale(0x00010000)
	tag(0x00, 1)
	weapon(0x0180, MODEL_LABCOAT, 0x042b, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DISGUISE40, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x40, L_LIP(15), L_LIP(16), L_LIP(17), L_LIP(18), L_LIP(19), 0x0000, 0x0000) // "Obtain lab clothes."
	tag(0x3e, 1)
	weapon(0x0180, MODEL_LABCOAT, 0x042c, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DISGUISE40, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x40, L_LIP(15), L_LIP(16), L_LIP(17), L_LIP(18), L_LIP(19), 0x0000, 0x0000) // "Obtain lab clothes."
	tag(0x3f, 1)
	weapon(0x0180, MODEL_LABCOAT, 0x042d, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DISGUISE40, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x40, L_LIP(15), L_LIP(16), L_LIP(17), L_LIP(18), L_LIP(19), 0x0000, 0x0000) // "Obtain lab clothes."
	tag(0x40, 1)
	weapon(0x0180, MODEL_LABCOAT, 0x042e, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DISGUISE40, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x40, L_LIP(15), L_LIP(16), L_LIP(17), L_LIP(18), L_LIP(19), 0x0000, 0x0000) // "Obtain lab clothes."
	tag(0x41, 1)
	weapon(0x0180, MODEL_LABCOAT, 0x042f, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DISGUISE40, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x40, L_LIP(15), L_LIP(16), L_LIP(17), L_LIP(18), L_LIP(19), 0x0000, 0x0000) // "Obtain lab clothes."
	tag(0x03, 1)
	singlemonitor(0x0033, MODEL_SINISTERSTATION, 0x0428, 0x000005e1, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x02, 1)
	singlemonitor(0x0033, MODEL_SINISTERSTATION, 0x0427, 0x000005e1, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x01, 1)
	singlemonitor(0x0033, MODEL_SINISTERSTATION, 0x0429, 0x000005e1, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x04, 1)
	singlemonitor(0x0033, MODEL_SINISTERSTATION, 0x0426, 0x000005e1, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x05, 1)
	weapon(0x0180, MODEL_CHRDATATHIEF, 0x00da, 0x00100001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DATAUPLINK, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x36, L_LIP(24), L_LIP(25), L_LIP(26), L_LIP(27), L_LIP(28), 0x0000, 0x0000) // "Obtain Data Uplink."
	tag(0x3a, 1)
	weapon(0x0180, MODEL_CHRDATATHIEF, 0x00da, 0x00100001, 0x00080000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DATAUPLINK, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x36, L_LIP(24), L_LIP(25), L_LIP(26), L_LIP(27), L_LIP(28), 0x0000, 0x0000) // "Obtain Data Uplink."
	tag(0x3c, 2)
	tag(0x3d, 2)
	singlemonitor(0x0033, MODEL_SINISTERSTATION, 0x03c6, 0x000005e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0033, MODEL_SINISTERSTATION, 0x03c7, 0x000005e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x027f, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x027e, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x027d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x027c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x027a, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x027b, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0278, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0279, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0277, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0276, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0274, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000002, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0275, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000002, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0273, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000002, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0272, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000002, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0270, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0271, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x026f, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x026e, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x026c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x026d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x026b, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x026a, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0268, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0269, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x44, 2)
	tag(0x45, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0266, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0267, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x2b, 4)
	tag(0x2c, 4)
	tag(0x2d, 4)
	tag(0x2e, 4)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02aa, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000080, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02ab, 0x10000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000080, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02ac, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000080, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02ad, 0x10000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000080, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x07, 2)
	tag(0x08, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0280, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000040, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0281, 0x10000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000040, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x09, 2)
	tag(0x0a, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02b7, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02b8, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0b, 2)
	tag(0x0c, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02b9, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02ba, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x0d, 2)
	tag(0x0e, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02bb, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02bc, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0283, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0282, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0284, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x0285, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x028b, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x028a, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_GL, 0x0286, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00020004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x01f407d0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0287, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_GL, 0x0289, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00020004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x01f407d0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x0288, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02a4, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02a5, 0x10000400, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00001999, 0x00000004, 0x00000020, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02a6, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_SECRET, 0x028e, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0000d555, 0x0000d555, 0x00001999, 0x00000004, 0x00000001, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x0292, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT, 0x0293, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x0294, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT, 0x0295, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51GATE_L, 0x02b5, 0x10000010, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00008000, 0x00000000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000f00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51GATE_R, 0x02b6, 0x10000010, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00004000, 0x00000000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x0299, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT, 0x0298, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x4a, 2)
	tag(0x4b, 2)
	door(0x0100, MODEL_A51_HORIZ_DOOR_GL, 0x02a8, 0x10000000, 0x28000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00020004, 0x00000040, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x01f407d0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02a7, 0x10000000, 0x30000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000040, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x029a, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT, 0x029b, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x029c, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT, 0x029d, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x13, 1)
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x029e, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT, 0x029f, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x30, 3)
	tag(0x31, 3)
	tag(0x11, 1)
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x02a1, 0x12000010, 0x00000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT, 0x02a0, 0x12000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x028c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x028d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02ae, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000010, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x028f, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x12, 1)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x0290, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000080, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x0291, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02a2, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000a666, 0x0000a666, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000004, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02a3, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000a666, 0x0000a666, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000004, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x00e6, MODEL_LAB_CONTAINER, 0x031c, 0x000001e1, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02e5, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x02e6, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x02e7, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02e8, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x02e9, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x02ea, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02eb, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x02ec, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x02ed, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02ee, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x02ef, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x02f0, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02f1, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x02f2, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x02f3, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02f4, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x02f5, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x02f6, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x02f7, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	link_paths(0x00000002, 0x011101bb, 0x00000000)
	link_scenery(1, 0, 2)
	door(0x0100, MODEL_A51_UNEXP1, 0x0422, 0x13500d00, 0x20304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00010000, 0x03e80000, 0x03e80000, 0x00010000, 0x00000000, 0x00000080, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_A51_EXP1, 0x0421, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x18, -2)
	tag(0x46, 6)
	tag(0x47, 6)
	tag(0x48, 8)
	tag(0x49, 8)
	tag(0x38, 1)
	lift(0x0100, MODEL_A51_LIFT_CONTROL, 0x032a, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x032a, 0x032b, 0xffffffff, 0x00000001, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x16000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x0330, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00008e38, 0x00008e38, 0x00000444, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x0331, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00008e38, 0x00008e38, 0x00000444, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-2, -3, 0, 0)
	link_objects(-2, -4, 0, 0)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x0332, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00008e38, 0x00008e38, 0x00000444, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x0333, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00008e38, 0x00008e38, 0x00000444, 0x00000000, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-2, -7, 0, 1)
	link_objects(-2, -8, 0, 1)
	tag(0x14, 2)
	tag(0x15, 2)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02b3, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00080000, 0x00000010, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02b4, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000010, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x33, 2)
	tag(0x34, 2)
	door(0x0100, MODEL_A51_VERT_DOOR_RIGHT, 0x02af, 0x10000010, 0x30000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000010, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_LEFT, 0x02b0, 0x10000010, 0x28000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000cccc, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000010, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR_ROLLERTRAIN, 0x0321, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000c000, 0x000031c7, 0x000031c7, 0x000002fc, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR_ROLLERTRAIN, 0x0327, 0x10000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000c000, 0x000031c7, 0x000031c7, 0x000002fc, 0x00040004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02b2, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00100004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02b1, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x17, 1)
	hover_prop(0x00eb, MODEL_HOVERCRATE1, 0x01c7, 0x35100101, 0x80102301, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x02010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x06, 1)
	key(0x0080, MODEL_KEYCARD, 0x003f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000020)
	rename_object(-1, 0x47, L_LIP(32), L_LIP(33), L_LIP(34), L_LIP(35), L_LIP(36), 0x0000, 0x0000) // "Obtain medlab 2 key card."

	// @bug: This keycard is given to guard 0x26 rather than being left
	// unassigned. This breaks the keycard hot potato which is supposed to
	// happen in the last room, because the keycard is not given to anyone until
	// there's one guard left, and you can just kill guard 0x26 for it.
	tag(0x10, 1)
	key(0x0080, MODEL_KEYCARD, 0x0026, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000080)
	rename_object(-1, 0x48, L_LIP(59), L_LIP(60), L_LIP(61), L_LIP(62), L_LIP(63), 0x0000, 0x0000) // "Obtain op room key card."

	stdobject(0x0100, MODEL_A51BOARD, 0x03c4, 0x05120101, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02bd, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02be, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02bf, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02c0, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02c1, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02c2, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_BOT, 0x02c3, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02c4, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00085555, 0x00085555, 0x00001999, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	glass(0x0100, MODEL_MEDLABWIN1, 0x0436, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_MEDLABWIN2, 0x0437, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_MEDLABWIN2, 0x0438, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_MEDLABWIN1, 0x0439, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_MEDLABWIN2, 0x043a, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_MEDLABWIN2, 0x043b, 0x04020b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0446, 0x14020b62, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0096012c, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0445, 0x14020b62, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0096012c, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x043d, 0x00420262, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x043e, 0x00420262, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x043f, 0x00420262, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0440, 0x00420262, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0441, 0x00420262, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x0442, 0x00420262, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x04b007d0, 0x0000ffff, 0x00000000)
	tag(0x19, 1)
	autogun(0x00c0, MODEL_A51_ROOFGUN, 0x0405, 0x00000004, 0x00002000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x01080000, 0x00000000, 0x00004000, 0xffffc000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000da, 0x00140000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x1a, 2)
	tag(0x22, 2)
	lift(0x0100, MODEL_CHAMBER, 0x033c, 0x075204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x033c, 0x033d, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x045c, 0x10000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x1c, 2)
	tag(0x24, 2)
	lift(0x0100, MODEL_CHAMBER, 0x0340, 0x075204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0340, 0x0341, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x0459, 0x10000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x1e, 2)
	tag(0x26, 2)
	lift(0x0100, MODEL_CHAMBER, 0x0344, 0x075204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0344, 0x0345, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x045a, 0x10000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x20, 2)
	tag(0x28, 2)
	lift(0x0100, MODEL_CHAMBER, 0x0348, 0x075204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0348, 0x0349, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x045b, 0x10000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x1b, 2)
	tag(0x23, 2)
	lift(0x0100, MODEL_CHAMBER, 0x033f, 0x075204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x033f, 0x033e, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x045e, 0x10000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x1d, 2)
	tag(0x25, 2)
	lift(0x0100, MODEL_CHAMBER, 0x0343, 0x075204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0343, 0x0342, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x045f, 0x10000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x1f, 2)
	tag(0x27, 2)
	lift(0x0100, MODEL_CHAMBER, 0x0347, 0x075204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0347, 0x0346, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x0460, 0x10000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x21, 2)
	tag(0x29, 2)
	lift(0x0100, MODEL_CHAMBER, 0x034b, 0x075204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x034b, 0x034a, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	singlemonitor(0x0100, MODEL_MODEMBOX, 0x045d, 0x10000002, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff12)
	tag(0x32, 1)
	stdobject(0x0100, MODEL_A51_CRATE1, 0xffff, 0x00021501, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0461, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0462, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0463, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0464, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0465, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0466, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0467, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0468, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0469, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x046a, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x046b, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x046c, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x046d, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x046e, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x046f, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0470, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0471, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0472, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0473, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51TABLE, 0x0474, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0476, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0477, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0479, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x047a, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x047b, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x047c, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x047d, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x047e, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x047f, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0480, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0481, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0482, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0483, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0484, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0485, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3b, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0486, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0487, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0488, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x0489, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0491, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0492, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0493, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0494, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0495, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0496, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0497, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0498, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x0499, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x049a, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x049b, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x049c, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x049d, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x049e, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x049f, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x04a0, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x04a1, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x04a2, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51WASTEBIN, 0x04a3, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04a4, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04a5, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04a6, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04a7, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04a8, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04a9, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04aa, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04ab, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51DIVIDE, 0x04ac, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE3, 0x031a, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE1, 0x031b, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x04b7, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x04b8, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x04b9, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x04ba, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x04bb, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x04bc, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x04bd, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_BARREL, 0x04be, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02c7, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02c8, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02c9, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02ca, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02cb, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02cc, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02cd, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02ce, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02cf, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_HORIZ_DOOR_TOP, 0x02d0, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x0001aaaa, 0x0001aaaa, 0x00000ccc, 0x00000004, 0x00000000, 0x00000078, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02d1, 0x34000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02d2, 0x34000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02d3, 0x34000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02d4, 0x34000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02d5, 0x34000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02d6, 0x34000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02d7, 0x34000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02d8, 0x34000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02d9, 0x34000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02da, 0x34000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x02db, 0x34000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x012c0000, 0x012c0000, 0x00030000, 0x00000005, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b00, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0100, MODEL_A51TABLE, 0x04d4, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51GRATE, 0x0443, 0x000215e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x4c, 2)
	tag(0x4d, 2)
	weapon(0x0100, MODEL_CHRFALCON2SIL, 0x03db, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2_SILENCER, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRFALCON2SIL, 0x03db, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FALCON2_SILENCER, 0x00ffffff, 0x00000000)
	link_collectibles(-1, -2)
	tag(0x4e, 1)
	weapon(0x0100, MODEL_CHRMAIANPISTOL, 0x0389, 0x00420001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_PHOENIX, 0x00ffffff, 0x00000000)
	tag(0x42, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x0004, 0x00004001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x43, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x0474, 0x00000001, 0x000000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	endprops
};

s32 intro[] = {
	spawn(0x03a1)
	intro_weapon(WEAPON_FALCON2_SILENCER, -1)
	ammo(AMMOTYPE_PISTOL, 100)
	intro_weapon(WEAPON_XRAYSCANNER, -1)
	outfit(OUTFIT_DEFAULT)
	endintro
};

s32 path00[] = {
	0x0194,
	0x0193,
	0x0196,
	0x0195,
	-1,
};

s32 path01[] = {
	0x019a,
	0x019c,
	0x018b,
	0x018a,
	0x018f,
	0x01a0,
	0x0190,
	0x019e,
	0x0199,
	-1,
};

s32 path02[] = {
	0x0190,
	0x019e,
	0x0199,
	0x019a,
	0x019c,
	0x018b,
	0x018a,
	0x018f,
	0x01a0,
	-1,
};

s32 path03[] = {
	0x018d,
	0x0189,
	0x0191,
	0x018f,
	0x018e,
	-1,
};

s32 path04[] = {
	0x0185,
	0x0186,
	0x0187,
	0x0182,
	0x0188,
	-1,
};

s32 path05[] = {
	0x01bd,
	0x01bc,
	0x01bb,
	0x01bc,
	0x01bd,
	-1,
};

s32 path06[] = {
	0x0111,
	0x010f,
	0x011a,
	0x0118,
	0x011a,
	0x010f,
	0x0111,
	-1,
};

s32 path07[] = {
	0x0112,
	0x0113,
	0x0100,
	0x0102,
	0x0104,
	0x0102,
	0x0100,
	0x0113,
	-1,
};

s32 path08[] = {
	0x00f7,
	0x00fa,
	0x00fb,
	0x00fc,
	0x00fb,
	0x00fa,
	0x00f7,
	0x00f8,
	0x00f9,
	0x00fa,
	-1,
};

s32 path09[] = {
	0x00f0,
	0x00f2,
	0x00f3,
	0x00f4,
	0x00f3,
	0x00f2,
	0x00f0,
	0x00ef,
	0x00f3,
	0x00f2,
	-1,
};

s32 path10[] = {
	0x0123,
	0x0124,
	-1,
};

s32 path11[] = {
	0x0124,
	0x0123,
	-1,
};

s32 path12[] = {
	0x0118,
	0x0119,
	0x011a,
	0x010d,
	0x010e,
	0x010f,
	0x0110,
	0x0111,
	0x0112,
	0x0113,
	0x0114,
	0x0100,
	0x0114,
	0x0113,
	0x0112,
	0x0111,
	0x0110,
	0x010f,
	0x010e,
	0x010d,
	0x011a,
	0x0119,
	-1,
};

s32 path13[] = {
	0x00ed,
	0x0100,
	0x00ed,
	-1,
};

s32 path14[] = {
	0x0100,
	0x0118,
	0x0100,
	0x00ed,
	-1,
};

u8 func1400_give_datauplinks[] = {
	yield
	set_chr_team(CHR_ANTI, TEAM_22)
	give_object_to_chr(OBJ_DATAUPLINK_BOND, CHR_BOND)
	give_object_to_chr(OBJ_DATAUPLINK_COOP, CHR_COOP)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func1007_check_disguise_collected[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_has_object(CHR_P1P2, OBJ_LABCOAT1, /*goto*/ 0x06)
		if_chr_has_object(CHR_P1P2, OBJ_LABCOAT2, /*goto*/ 0x06)
		if_chr_has_object(CHR_P1P2, OBJ_LABCOAT3, /*goto*/ 0x06)
		if_chr_has_object(CHR_P1P2, OBJ_LABCOAT4, /*goto*/ 0x06)
		if_chr_has_object(CHR_P1P2, OBJ_LABCOAT5, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	dprint 'D','I','S','G','U','I','S','E','D',' ','U','P','\n',0,

	beginloop(0x08)
		if_chr_has_hiddenflag(CHR_P1P2, CHRHFLAG_DISGUISED, /*goto*/ 0x2d)
	endloop(0x08)

	label(0x2d)
	set_stage_flag(STAGEFLAG_USED_DISGUISE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1026_check_records_destroyed[] = {
	beginloop(0x04)
		if_object_in_good_condition(0x04, /*goto*/ 0x06)
		show_hudmsg(CHR_BOND, L_LIP(14)) // "Research records destroyed."
		set_stage_flag(STAGEFLAG_RECORDS_DESTROYED)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x06)
	endloop(0x04)

	endlist
};

u8 func1003_uplink_doors[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, 0x02, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_stage_flag_eq(STAGEFLAG_DOOR_VIRUS_DOWNLOADED, FALSE, /*goto*/ 0x06)
		play_sound(0x8116, -1)
		show_hudmsg(CHR_P1P2, L_LIP(48)) // "Virus has already been downloaded."
		reloop(0x04)

		label(0x06)
		if_chr_weapon_equipped(CHR_P1P2, WEAPON_DATAUPLINK, /*goto*/ 0x2d)
		play_sound(0x8116, -1)
		show_hudmsg(CHR_P1P2, L_LIP(20)) // "Access to door control systems denied."
		reloop(0x04)

		label(0x2d)
		show_hudmsg(CHR_P1P2, L_LIP(30)) // "Data Uplink connected."
		restart_timer

		beginloop(0x08)
			if_timer_gt(60, /*goto*/ 0x06)
			if_chr_distance_to_pad_gt(CHR_P1P2, 300, 0x0427, /*goto*/ 0x09)
			if_chr_weapon_equipped(CHR_P1P2, WEAPON_DATAUPLINK, /*goto*/ 0x2d)
			goto_next(0x09)

			label(0x2d)
		endloop(0x08)

		label(0x06)
		show_hudmsg(CHR_P1P2, L_LIP(49)) // "Initiating virus download."
		restart_timer
		assign_sound(0x01bf, CHANNEL_5)
		control_sound_from_object(CHANNEL_5, 0x02, TRUE)

		beginloop(0x11)
			if_timer_gt(400, /*goto*/ 0x06)
			if_chr_distance_to_pad_gt(CHR_P1P2, 300, 0x0427, /*goto*/ 0x09)
			if_chr_weapon_equipped(CHR_P1P2, WEAPON_DATAUPLINK, /*goto*/ 0x2d)
			goto_next(0x09)

			label(0x2d)
		endloop(0x11)

		label(0x06)
		mute_channel(CHANNEL_5)
		if_object_in_good_condition(0x02, /*goto*/ 0x2d)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x2d)
		assign_sound(0x01c1, CHANNEL_5)
		control_sound_from_object(CHANNEL_5, 0x02, TRUE)
		show_hudmsg(CHR_P1P2, L_LIP(23)) // "Virus downloaded to console."
		yield
		set_stage_flag(STAGEFLAG_DOOR_VIRUS_DOWNLOADED)
		reloop(0x04)

		label(0x09)
		show_hudmsg(CHR_P1P2, L_LIP(31)) // "Data Uplink connection broken."
		mute_channel(CHANNEL_5)
		assign_sound(0x01c0, CHANNEL_6)
		control_sound_from_object(CHANNEL_6, 0x02, TRUE)
		restart_timer

		beginloop(0x13)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x13)

		label(0x06)
		mute_channel(CHANNEL_6)
	endloop(0x04)

	endlist
};

u8 func1004_uplink_lights[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, 0x01, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_stage_flag_eq(STAGEFLAG_LIGHT_VIRUS_DONE, FALSE, /*goto*/ 0x06)
		play_sound(0x8116, -1)
		show_hudmsg(CHR_P1P2, L_LIP(48)) // "Virus has already been downloaded."
		reloop(0x04)

		label(0x06)
		if_chr_weapon_equipped(CHR_P1P2, WEAPON_DATAUPLINK, /*goto*/ 0x2d)
		play_sound(0x8116, -1)
		show_hudmsg(CHR_P1P2, L_LIP(21)) // "Access to light control systems denied."
		reloop(0x04)

		label(0x2d)
		show_hudmsg(CHR_P1P2, L_LIP(30)) // "Data Uplink connected."
		restart_timer

		beginloop(0x08)
			if_timer_gt(60, /*goto*/ 0x06)
			if_chr_distance_to_pad_gt(CHR_P1P2, 300, 0x0429, /*goto*/ 0x09)
			if_chr_weapon_equipped(CHR_P1P2, WEAPON_DATAUPLINK, /*goto*/ 0x2d)
			goto_next(0x09)

			label(0x2d)
		endloop(0x08)

		label(0x06)
		show_hudmsg(CHR_P1P2, L_LIP(49)) // "Initiating virus download."
		restart_timer
		assign_sound(0x01bf, CHANNEL_5)
		control_sound_from_object(CHANNEL_5, 0x01, TRUE)

		beginloop(0x11)
			if_timer_gt(400, /*goto*/ 0x06)
			if_chr_distance_to_pad_gt(CHR_P1P2, 300, 0x0429, /*goto*/ 0x09)
			if_chr_weapon_equipped(CHR_P1P2, WEAPON_DATAUPLINK, /*goto*/ 0x2d)
			goto_next(0x09)

			label(0x2d)
		endloop(0x11)

		label(0x06)
		mute_channel(CHANNEL_5)
		if_object_in_good_condition(0x01, /*goto*/ 0x2d)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x2d)
		assign_sound(0x01c1, CHANNEL_5)
		control_sound_from_object(CHANNEL_5, 0x01, TRUE)
		show_hudmsg(CHR_P1P2, L_LIP(23)) // "Virus downloaded to console."
		yield
		show_hudmsg(CHR_P1P2, L_LIP(88)) // "Lighting systems overloaded."
		misc_command(0x00c4, 0x0c, 0x6e)
		misc_command(0x00c3, 0x0c, 0x6e)
		misc_command(0x00c8, 0x0c, 0x6e)
		misc_command(0x00c9, 0x0c, 0x6e)
		misc_command(0x00ca, 0x0c, 0x6e)
		misc_command(0x00c7, 0x0c, 0x6e)
		misc_command(0x00c2, 0x0c, 0x6e)
		misc_command(0x00c1, 0x0c, 0x6e)
		misc_command(0x00c0, 0x0c, 0x6e)
		misc_command(0x00bf, 0x0c, 0x6e)
		misc_command(0x00c6, 0x0c, 0x6e)
		misc_command(0x00c5, 0x0c, 0x6e)
		misc_command(0x00a6, 0x0c, 0x6e)
		set_stage_flag(STAGEFLAG_LIGHT_VIRUS_DONE)
		reloop(0x04)

		label(0x09)
		show_hudmsg(CHR_P1P2, L_LIP(31)) // "Data Uplink connection broken."
		mute_channel(CHANNEL_5)
		assign_sound(0x01c0, CHANNEL_6)
		control_sound_from_object(CHANNEL_6, 0x01, TRUE)
		restart_timer

		beginloop(0x13)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x13)

		label(0x06)
		mute_channel(CHANNEL_6)
	endloop(0x04)

	endlist
};

u8 func1005_uplink_autoguns[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, 0x03, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_stage_flag_eq(STAGEFLAG_LIGHT_VIRUS_DONE, FALSE, /*goto*/ 0x06)
		play_sound(0x8116, -1)
		show_hudmsg(CHR_P1P2, L_LIP(48)) // "Virus has already been downloaded."
		reloop(0x04)

		label(0x06)
		if_chr_weapon_equipped(CHR_P1P2, WEAPON_DATAUPLINK, /*goto*/ 0x2d)
		play_sound(0x8116, -1)
		show_hudmsg(CHR_P1P2, L_LIP(22)) // "Access to security control systems denied."
		reloop(0x04)

		label(0x2d)
		show_hudmsg(CHR_P1P2, L_LIP(30)) // "Data Uplink connected."
		restart_timer

		beginloop(0x08)
			if_timer_gt(60, /*goto*/ 0x06)
			if_chr_distance_to_pad_gt(CHR_P1P2, 300, 0x0428, /*goto*/ 0x09)
			if_chr_weapon_equipped(CHR_P1P2, WEAPON_DATAUPLINK, /*goto*/ 0x2d)
			goto_next(0x09)

			label(0x2d)
		endloop(0x08)

		label(0x06)
		show_hudmsg(CHR_P1P2, L_LIP(49)) // "Initiating virus download."
		restart_timer
		assign_sound(0x01bf, CHANNEL_5)
		control_sound_from_object(CHANNEL_5, 0x03, TRUE)

		beginloop(0x11)
			if_timer_gt(400, /*goto*/ 0x06)
			if_chr_distance_to_pad_gt(CHR_P1P2, 300, 0x0428, /*goto*/ 0x09)
			if_chr_weapon_equipped(CHR_P1P2, WEAPON_DATAUPLINK, /*goto*/ 0x2d)
			goto_next(0x09)

			label(0x2d)
		endloop(0x11)

		label(0x06)
		mute_channel(CHANNEL_5)
		if_object_in_good_condition(0x03, /*goto*/ 0x2d)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x2d)
		assign_sound(0x01c1, CHANNEL_5)
		control_sound_from_object(CHANNEL_5, 0x00, TRUE)
		show_hudmsg(CHR_P1P2, L_LIP(23)) // "Virus downloaded to console."
		yield
		show_hudmsg(CHR_P1P2, L_LIP(105)) // "Automatic Defenses Disabled."
		set_stage_flag(STAGEFLAG_AUTOGUN_VIRUS_DONE)
		reloop(0x04)

		label(0x09)
		show_hudmsg(CHR_P1P2, L_LIP(31)) // "Data Uplink connection broken."
		mute_channel(CHANNEL_5)
		assign_sound(0x01c0, CHANNEL_6)
		control_sound_from_object(CHANNEL_6, 0x03, TRUE)
		restart_timer

		beginloop(0x13)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x13)

		label(0x06)
		mute_channel(CHANNEL_6)
		reloop(0x04)

		show_hudmsg(CHR_P1P2, L_LIP(23)) // "Virus downloaded to console."
		set_stage_flag(STAGEFLAG_AUTOGUN_VIRUS_DONE)
	endloop(0x04)

	endlist
};

u8 func1006_check_lab_accessed[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x008f, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	show_hudmsg(CHR_P1P2, L_LIP(29)) // "Laboratory accessed successfully."
	set_stage_flag(STAGEFLAG_ENTERED_LAB)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define init_path(accuracy, health, recovery, pathid) \
	set_chr_dodge_rating(2, 0x0a) \
	set_accuracy(accuracy) \
	set_reaction_speed(35) \
	set_chr_maxdamage(CHR_SELF, health) \
	add_health_or_armor(0) \
	set_recovery_speed(recovery) \
	set_shield(0) \
	assign_path(pathid) \
	start_path \
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)



u8 func0401_start_path00[] = {
	init_path(8, 50, 35, 0x00)
	endlist
};

u8 func0402_start_path01[] = {
	init_path(8, 50, 35, 0x01)
	endlist
};

u8 func0403_start_path02[] = {
	init_path(8, 50, 35, 0x02)
	endlist
};

u8 func0404_start_path03[] = {
	init_path(8, 50, 35, 0x03)
	endlist
};

u8 func0405_start_path04[] = {
	init_path(8, 50, 35, 0x04)
	endlist
};

u8 func0406_start_path05[] = {
	init_path(8, 50, 35, 0x05)
	endlist
};

u8 func0407_start_path06[] = {
	init_path(10, 80, 0, 0x06)
	endlist
};

u8 func0408_start_path07[] = {
	init_path(10, 80, 0, 0x07)
	endlist
};

u8 func0409_start_path08[] = {
	init_path(10, 80, 0, 0x08)
	endlist
};

u8 func040a_start_path09[] = {
	init_path(10, 80, 0, 0x09)
	endlist
};

u8 func040b_start_path10[] = {
	init_path(10, 80, 0, 0x0a)
	endlist
};

u8 func040c_start_path11[] = {
	init_path(10, 80, 0, 0x0b)
	endlist
};

u8 func040d_start_path12[] = {
	init_path(10, 80, 0, 0x0c)
	endlist
};

u8 func040e_start_path13[] = {
	init_path(10, 80, 0, 0x0d)
	endlist
};

u8 func040f_start_path14[] = {
	init_path(10, 80, 0, 0x0e)
	endlist
};

u8 func1001_objectives_failed_msg[] = {
	yield
	set_chr_chrflag(CHR_LABTECH_RECORDS, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_LABTECH_LIGHTS, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_LABTECH_DOORS1, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_LABTECH_SHOWERS, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_LABTECH_HARRYSMATE, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_LABTECH_KEYCARDGUY, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_BIOTECH1, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_BIOTECH2, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_LABTECH_DOORS2, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_MECHANIC, CHRCFLAG_04000000)
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

u8 func0411_labtech_showers_agent[] = {
	beginloop(0x04)
		if_object_in_good_condition(OBJ_WALL, /*goto*/ 0x2d)
		goto_next(0x64)

		label(0x2d)
	endloop(0x04)

	beginloop(0x64)
		damage_chr(CHR_SELF, 18)
		if_chr_dying(CHR_SELF, /*goto*/ 0x2d)
	endloop(0x64)

	label(0x2d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0412_init_labtech_showers[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2d)
	goto_next(0x06)

	// Agent
	label(0x2d)
	run_to_pad(0x03ab)

	beginloop(0x08)
		if_chr_stopped(/*goto*/ 0x2e)
	endloop(0x08)

	label(0x2e)
	set_ailist(CHR_SELF, AILIST_LABTECH_AGENT)

	// SA and PA
	label(0x06)
	set_ailist(CHR_SELF, AILIST_LABTECH_SA_PA)
	endlist
};

u8 func0410_labtech_showers_sa_pa[] = {
	set_shotlist(AILIST_LABTECH_SA_PA)
	if_chr_dying(CHR_SELF, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x2d)

	label(0x06)
	set_shotlist(GAILIST_IDLE)
	set_stage_flag(STAGEFLAG_LABTECH_DEAD)
	restart_timer

	beginloop(0x54)
		if_timer_gt(15, /*goto*/ 0x06)
	endloop(0x54)

	label(0x06)
	say_quip(CHR_BOND, 0x19, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2d)
	if_just_injured(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x2d)

	// Injured
	label(0x06)
	restart_timer

	beginloop(0x55)
		if_self_flag_bankx_eq(CHRFLAG0_SAID_INJURY_QUIP, TRUE, BANK_0, /*goto*/ 0x06)
		if_num_times_shot_lt(1, /*goto*/ 0x06)
		if_timer_lt(20, /*goto*/ 0x06)
		say_quip(CHR_BOND, 0x0d, 0x28, 0x03, 0x00, BANK_0, 0x00, 0x00)
		say_quip(CHR_BOND, 0x0e, 0x28, 0x03, 0x01, BANK_0, 0x00, 0x00)
		set_self_flag_bankx(CHRFLAG0_SAID_INJURY_QUIP, BANK_0)
		label(0x06)
		if_chr_stopped(/*goto*/ 0x58)
	endloop(0x55)

	// Not injured, or recovered
	label(0x2d)
	stop_chr

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x2d)
		if_distance_to_target_lt(500, /*goto*/ 0x03)
	endloop(0x04)

	// Detected Jo
	label(0x2d)
	label(0x03)
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x56)
	restart_timer
	label(0x08)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	dprint 'T','A','L','K',' ','1','\n',0,
	speak(CHR_TARGET, L_LIP(37), 0x1b2d, CHANNEL_4, COLOR_08_RED) // "Who are you?"
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x64)

	// Wait until seeing Jo with a gun, or Jo has clothes
	beginloop(0x64)
		if_timer_lt(120, /*goto*/ 0x2d)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x2d)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x2d)
		if_chr_in_view(/*goto*/ 0x53)
		label(0x2d)
		if_chr_has_object(CHR_TARGET, OBJ_LABCOAT1, /*goto*/ 0x0d)
		if_chr_has_object(CHR_TARGET, OBJ_LABCOAT2, /*goto*/ 0x0d)
		if_chr_has_object(CHR_TARGET, OBJ_LABCOAT3, /*goto*/ 0x0d)
		if_chr_has_object(CHR_TARGET, OBJ_LABCOAT4, /*goto*/ 0x0d)
		if_chr_has_object(CHR_TARGET, OBJ_LABCOAT5, /*goto*/ 0x0d)
	endloop(0x64)

	// Jo has clothes
	label(0x0d)
	speak(CHR_TARGET, L_LIP(38), 0x1b2e, CHANNEL_4, COLOR_08_RED) // "Hey - you've got my clothes."
	restart_timer

	beginloop(0x0e)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x2d)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x2d)
		goto_next(0x53)

		label(0x2d)
		if_timer_gt(180, /*goto*/ 0x06)
	endloop(0x0e)

	label(0x06)
	speak(CHR_TARGET, L_LIP(43), 0x1b32, CHANNEL_4, COLOR_08_RED) // "Give me back my clothes - or else!"
	restart_timer

	beginloop(0x0f)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x2d)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x2d)
		goto_next(0x53)

		label(0x2d)
		if_timer_gt(200, /*goto*/ 0x56)
	endloop(0x0f)

	label(0x56)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00aa, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00a9, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00b4, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00b5, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00b6, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00be, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00b7, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00b8, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00b3, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x009b, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00ae, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00af, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00b0, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00b1, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00b2, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00bc, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00ab, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00bb, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00ba, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00b9, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00ac, /*goto*/ 0x2d)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00ad, /*goto*/ 0x2d)
		goto_next(0x58)

		// Jo is in one of many rooms
		label(0x2d)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x2d)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x2d)
		goto_next(0x53)

		// Jo is in one of many rooms with nothing equipped - attack her
		label(0x2d)
		if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x2d)
		speak(CHR_TARGET, L_LIP(44), 0x1b33, CHANNEL_4, COLOR_08_RED) // "Right - you've asked for it!"
		set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
		goto_next(0x06)

		label(0x2d)
		call_rng
		if_rand_gt(25, /*goto*/ 0x06)
		speak(CHR_TARGET, L_LIP(45), 0x1b34, CHANNEL_4, COLOR_08_RED) // "Give me my clothes."
		label(0x06)
		try_run_to_target(/*goto*/ 0x6f)
		restart_timer

		beginloop(0x6f)
			if_distance_to_target_lt(400, /*goto*/ 0x2d)
			if_timer_gt(600, /*goto*/ 0x06)
			if_chr_stopped(/*goto*/ 0x06)
		endloop(0x6f)

		label(0x2d)
		set_returnlist(CHR_SELF, AILIST_LABTECH_SA_PA)
		set_ailist(CHR_SELF, GAILIST_HAND_COMBAT)

		// Chasing Jo for over 10 seconds - do room check again
		label(0x06)
	goto_first(0x56)

	// Jo in an unknown room
	label(0x58)
	goto_next(0x06)

	// Tech saw weapon
	label(0x53)
	chr_do_animation(ANIM_SURPRISED_0202, 0, -1, 0x10, 0x10, CHR_SELF, 2)
	dprint 'T','A','L','K',' ','1','\n',0,
	speak(CHR_TARGET, L_LIP(41), 0x8156, CHANNEL_4, COLOR_08_RED) // "Oh, my God - a gun!"
	restart_timer

	beginloop(0x0a)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x0a)

	// Jo in an unknown room, or follow through from seeing weapon
	label(0x06)
	restart_timer
	speak(CHR_TARGET, L_LIP(39), 0x1b2f, CHANNEL_4, COLOR_08_RED) // "Help - help!"
	try_set_chrpreset_to_unalerted_teammate(0, /*goto*/ 0x06)

	// No chr in same group - run to pad instead
	run_to_pad(0x0121)

	beginloop(0x10)
		if_chr_stopped(/*goto*/ 0x61)
	endloop(0x10)

	label(0x06)
	try_run_to_chr(CHR_PRESET, /*goto*/ 0x0b)

	beginloop(0x0b)
		if_detected_chr(CHR_PRESET, /*goto*/ 0x61)
	endloop(0x0b)

	label(0x61)
	speak(CHR_TARGET, L_LIP(42), 0x1b31, CHANNEL_4, COLOR_08_RED) // "There's an intruder in the complex."
	set_stage_flag(STAGEFLAG_DISGUISE_UNCOVERED)
	increase_squadron_alertness(100)
	stop_chr

	beginloop(0x0c)
	endloop(0x0c)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1009_disguise_timer[] = {
	beginloop(0x04)
		// Pointless check
		if_stage_flag_eq(STAGEFLAG_LABTECH_DEAD, TRUE, /*goto*/ 0x2d)
		label(0x2d)
		if_chr_has_object(CHR_BOND, OBJ_LABCOAT1, /*goto*/ 0x2d)
		if_chr_has_object(CHR_BOND, OBJ_LABCOAT2, /*goto*/ 0x2d)
		if_chr_has_object(CHR_BOND, OBJ_LABCOAT3, /*goto*/ 0x2d)
		if_chr_has_object(CHR_BOND, OBJ_LABCOAT4, /*goto*/ 0x2d)
		if_chr_has_object(CHR_BOND, OBJ_LABCOAT5, /*goto*/ 0x2d)
		if_chr_has_object(CHR_COOP, OBJ_LABCOAT1, /*goto*/ 0x2d)
		if_chr_has_object(CHR_COOP, OBJ_LABCOAT2, /*goto*/ 0x2d)
		if_chr_has_object(CHR_COOP, OBJ_LABCOAT3, /*goto*/ 0x2d)
		if_chr_has_object(CHR_COOP, OBJ_LABCOAT4, /*goto*/ 0x2d)
		if_chr_has_object(CHR_COOP, OBJ_LABCOAT5, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	restart_timer

	beginloop(0x09)
		if_timer_gt(180, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	speak(CHR_BOND, L_LIP(46), 0x72ab, CHANNEL_4, COLOR_09_BLUE) // "I don't have much time!!!"
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x5d)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x5f)
	set_countdown_timer(90)
	goto_next(0x2d)

	label(0x5d)
	set_countdown_timer(180)
	goto_next(0x2d)

	label(0x5f)
	set_countdown_timer(135)
	label(0x2d)
	show_countdown_timer
	start_countdown_timer

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_ENTERED_LAB, TRUE, /*goto*/ 0x2d)
		if_countdown_timer_lt(1, /*goto*/ 0x06)
		if_door_locked(0x4a, 0x40, /*goto*/ 0x2e)
		goto_next(0x0d)

		label(0x2e)
	endloop(0x08)

	// Door unlocked
	label(0x0d)

	// Entered lab
	label(0x2d)
	stop_countdown_timer
	hide_countdown_timer
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Timer expired
	label(0x06)
	stop_countdown_timer
	hide_countdown_timer
	restart_timer
	label(0x66)
	activate_alarm
	yield
	label(0x2d)
	show_hudmsg(CHR_BOND, L_LIP(47)) // "The enemy has discovered the disguise."
	set_stage_flag(STAGEFLAG_DISGUISE_UNCOVERED)
	hide_countdown_timer
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100a_random_doors[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_DOOR_VIRUS_DOWNLOADED, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_object_flag(0x07, OBJFLAG_CANNOT_ACTIVATE)
	set_object_flag(0x09, OBJFLAG_CANNOT_ACTIVATE)
	set_object_flag(0x0b, OBJFLAG_CANNOT_ACTIVATE)
	set_object_flag(0x0d, OBJFLAG_CANNOT_ACTIVATE)
	set_object_flag(0x08, OBJFLAG_CANNOT_ACTIVATE)
	set_object_flag(0x0a, OBJFLAG_CANNOT_ACTIVATE)
	set_object_flag(0x0c, OBJFLAG_CANNOT_ACTIVATE)
	set_object_flag(0x0e, OBJFLAG_CANNOT_ACTIVATE)

	beginloop(0x03)
		// 55 in 256 chance of doing anything on a given frame
		call_rng
		if_rand_gt(200, /*goto*/ 0x06)
		reloop(0x03)

		label(0x06)
		call_rng
		if_rand_lt(64, /*goto*/ 0x0a)
		if_rand_lt(128, /*goto*/ 0x0c)
		if_rand_lt(196, /*goto*/ 0x0e)

		// 25% chance //1
		label(0x08)
		if_door_state(0x07, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x09)
		open_door(0x07)
		open_door(0x08)
		reloop(0x03)

		label(0x09)
		close_door(0x07)
		close_door(0x08)
		reloop(0x03)

		// 25% chance //2
		label(0x0a)
		if_door_state(0x09, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x0b)
		open_door(0x09)
		open_door(0x0a)
		reloop(0x03)

		label(0x0b)
		close_door(0x09)
		close_door(0x0a)
		reloop(0x03)

		// 25% chance //3
		label(0x0c)
		if_door_state(0x0b, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x0d)
		open_door(0x0b)
		open_door(0x0c)
		reloop(0x03)

		label(0x0d)
		close_door(0x0b)
		close_door(0x0c)
		reloop(0x03)

		// 25% chance //4
		label(0x0e)
		if_door_state(0x0d, (DOORSTATE_OPEN | DOORSTATE_OPENING), /*goto*/ 0x0f)
		open_door(0x0d)
		open_door(0x0e)
		reloop(0x03)

		label(0x0f)
		close_door(0x0d)
		close_door(0x0e)
	endloop(0x03)

	endlist
};

u8 func0419_init_doorman[] = {
	set_accuracy(10)
	set_reaction_speed(35)
	set_chr_maxdamage(CHR_SELF, 1)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, AILIST_DOORMAN)
	endlist
};

u8 func0418_doorman[] = {
	set_shotlist(GAILIST_ALERTED)
	if_chr_dying(CHR_SELF, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x2d)

	label(0x06)
	set_shotlist(GAILIST_IDLE)
	restart_timer

	beginloop(0x54)
		if_timer_gt(15, /*goto*/ 0x06)
	endloop(0x54)

	label(0x06)
	say_quip(CHR_BOND, 0x19, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x2d)
	if_just_injured(CHR_SELF, /*goto*/ 0x06)
	if_has_gun(CHR_SELF, /*goto*/ 0x2d)

	// Gun shot out of hand
	label(0x06)
	increase_squadron_alertness(100)
	set_target_chr(CHR_BOND)
	set_ailist(CHR_SELF, GAILIST_ALERTED)

	// Waiting for Jo to arrive
	label(0x2d)
	stop_chr

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x03)
		if_distance_to_target_lt(500, /*goto*/ 0x03)
	endloop(0x04)

	label(0x03)
	restart_timer
	label(0x08)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	speak(CHR_TARGET, L_LIP(50), 0x8157, CHANNEL_4, COLOR_08_RED) // "So, you got here at last."

	beginloop(0x0a)
		if_timer_gt(240, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	if_stage_flag_eq(STAGEFLAG_DISGUISE_UNCOVERED, TRUE, /*goto*/ 0x2d)
	if_stage_flag_eq(STAGEFLAG_USED_DISGUISE, TRUE, /*goto*/ 0x06)

	// Disguise not used, or uncovered
	label(0x2d)
	dprint 'T','A','L','K',' ','1','\n',0,
	speak(CHR_TARGET, L_LIP(51), 0x8158, CHANNEL_4, COLOR_08_RED) // "Hey, you're not... SECURITY ALERT!"
	restart_timer
	stop_chr

	beginloop(0x0b)
		if_timer_lt(120, /*goto*/ 0x2d)
	endloop(0x0b)

	label(0x2d)
	set_stage_flag(STAGEFLAG_DOORMAN_REJECTED)
	show_hudmsg(CHR_TARGET, L_LIP(57)) // "Cannot gain access to autopsy lab."
	goto_next(0x64)

	// Disguised
	label(0x06)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x59)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x59)

	// Jo has gun equipped
	label(0x2d)
	speak(CHR_TARGET, L_LIP(52), 0x8159, CHANNEL_4, COLOR_08_RED) // "No guns allowed in here - put your weapon away."
	restart_timer

	beginloop(0x0c)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x59)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x59)
		if_timer_gt(300, /*goto*/ 0x06)
	endloop(0x0c)

	label(0x06)
	speak(CHR_TARGET, L_LIP(53), 0x815a, CHANNEL_4, COLOR_08_RED) // "I won't tell you again - lose the weapon."
	restart_timer

	beginloop(0x0d)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x59)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x59)
		if_timer_gt(600, /*goto*/ 0x06)
	endloop(0x0d)

	label(0x1b)
	label(0x06)
	speak(CHR_TARGET, L_LIP(54), 0x815b, CHANNEL_4, COLOR_08_RED) // "Right - I'm calling security."
	restart_timer
	label(0x10)
	set_stage_flag(STAGEFLAG_DOORMAN_REJECTED)
	show_hudmsg(CHR_TARGET, L_LIP(57)) // "Cannot gain access to autopsy lab."
	goto_next(0x64)

	// Jo disguised and unarmed
	label(0x59)
	speak(CHR_TARGET, L_LIP(55), 0x815c, CHANNEL_4, COLOR_08_RED) // "Everyone's been waiting for you..."
	restart_timer

	beginloop(0x0e)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x0e)

	label(0x06)
	if_alarm_active(/*goto*/ 0x2d)
	goto_next(0x06)

	label(0x2d)
	goto_first(0x1b)

	// Unlocking
	label(0x06)
	unset_object_flag2(0x4a, OBJFLAG2_AICANNOTUSE)
	unset_object_flag2(0x4b, OBJFLAG2_AICANNOTUSE)
	unlock_door(0x4a, 0x40)
	unlock_door(0x4b, 0x40)
	open_door(0x4a)
	open_door(0x4b)

	beginloop(0x0f)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x06)
		if_saw_injury(0x00, /*goto*/ 0x06)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x2d)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
		if_door_state(0x4a, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x2d)
		reloop(0x0f)

		label(0x2d)
		open_door(0x4a)
		open_door(0x4b)
	endloop(0x0f)

	label(0x06)
	increase_squadron_alertness(100)
	set_target_chr(CHR_BOND)
	set_ailist(CHR_SELF, GAILIST_ALERTED)

	label(0x64)
	yield
	goto_first(0x64)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100b_check_doorman_dead[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_dying(CHR_DOORMAN, /*goto*/ 0x2d)
		if_chr_death_animation_finished(CHR_DOORMAN, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_DOORMAN, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		if_chr_has_object(CHR_BOND, 0x06, /*goto*/ 0x0d)
		if_chr_has_object(CHR_COOP, 0x06, /*goto*/ 0x0d)
		if_door_locked(0x4a, 0x40, /*goto*/ 0x2d)
		goto_next(0x0d)

		label(0x2d)
		if_chr_in_room(CHR_BOND, 0x00, 0x0083, /*goto*/ 0x06)
		if_chr_in_room(CHR_BOND, 0x00, 0x0084, /*goto*/ 0x06)
		if_chr_in_room(CHR_BOND, 0x00, 0x0085, /*goto*/ 0x06)
		if_chr_in_room(CHR_BOND, 0x00, 0x0086, /*goto*/ 0x06)
		if_chr_in_room(CHR_BOND, 0x00, 0x0087, /*goto*/ 0x06)
		if_chr_in_room(CHR_BOND, 0x00, 0x0088, /*goto*/ 0x06)
		if_chr_in_room(CHR_BOND, 0x00, 0x0089, /*goto*/ 0x06)
		if_chr_in_room(CHR_BOND, 0x00, 0x008a, /*goto*/ 0x06)
		show_hudmsg(CHR_P1P2, L_LIP(56)) // "Critical mission personnel killed."
		restart_timer

		beginloop(0x08)
			if_timer_gt(120, /*goto*/ 0x2d)
		endloop(0x08)

		label(0x2d)
		show_hudmsg(CHR_P1P2, L_LIP(57)) // "Cannot gain access to autopsy lab."
		restart_timer
		set_stage_flag(STAGEFLAG_DOORMAN_DEAD)

		beginloop(0x09)
			if_timer_gt(120, /*goto*/ 0x2d)
		endloop(0x09)

		label(0x2d)
		label(0x0d)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x06)
	endloop(0x04)

	endlist
};

/**
 * The lab guy who stands in the room behind the doorman.
 */
u8 func041a_labtech_harrysmate[] = {
	set_shotlist(AILIST_LABTECH_HARRYSMATE)
	if_chr_dying(CHR_SELF, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x2d)

	label(0x06)
	set_shotlist(GAILIST_IDLE)
	restart_timer

	beginloop(0x54)
		if_timer_gt(15, /*goto*/ 0x06)
	endloop(0x54)

	label(0x06)
	say_quip(CHR_BOND, 0x19, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2d)
	if_just_injured(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x2d)

	label(0x06)
	restart_timer

	beginloop(0x55)
		if_self_flag_bankx_eq(CHRFLAG0_SAID_INJURY_QUIP, TRUE, BANK_0, /*goto*/ 0x06)
		if_num_times_shot_lt(1, /*goto*/ 0x06)
		if_timer_lt(20, /*goto*/ 0x06)
		say_quip(CHR_BOND, 0x0d, 0x28, 0x03, 0x00, BANK_0, 0x00, 0x00)
		say_quip(CHR_BOND, 0x0e, 0x28, 0x03, 0x01, BANK_0, 0x00, 0x00)
		set_self_flag_bankx(CHRFLAG0_SAID_INJURY_QUIP, BANK_0)
		label(0x06)
		if_chr_stopped(/*goto*/ 0x58)
	endloop(0x55)

	label(0x58)
	goto_next(0x5a)

	label(0x2d)
	stop_chr

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0083, /*goto*/ 0x08)
	endloop(0x04)

	beginloop(0x08)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x2d)
		if_target_in_sight(/*goto*/ 0x2d)
		if_distance_to_target_lt(500, /*goto*/ 0x2d)
	endloop(0x08)

	label(0x2d)
	restart_timer
	label(0x08)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	speak(CHR_TARGET, L_LIP(58), 0x1abb, CHANNEL_4, COLOR_08_RED) // "Hey, that's not Harry. It's an intruder."
	increase_squadron_alertness(120)
	restart_timer
	chr_do_animation(0x002e, 0, -1, 0x18, 0x10, CHR_SELF, 2)

	beginloop(0x0a)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	run_to_pad(0x011e)

	beginloop(0x0b)
		if_chr_stopped(/*goto*/ 0x5a)
	endloop(0x0b)

	label(0x5a)
	chr_do_animation(ANIM_DRAW_PISTOL_0288, 0, -1, 0x00, 0x10, CHR_SELF, 2)

	beginloop(0x0c)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x0c)

	label(0x06)
	dprint 'C','R','E','A','T','E','D',' ','W','E','A','P','\n',0,
	try_equip_weapon(MODEL_CHRDRUGGUN, WEAPON_TRANQUILIZER, 0x10000000, /*goto*/ 0x06)
	label(0x06)
	set_target_chr(CHR_BOND)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

u8 func041b_labtech_keycardguy[] = {
	set_shotlist(AILIST_LABTECH_KEYCARDGUY)
	if_chr_dying(CHR_SELF, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x2d)

	// Dying
	label(0x06)
	set_shotlist(GAILIST_IDLE)
	restart_timer

	beginloop(0x54)
		if_timer_gt(15, /*goto*/ 0x06)
	endloop(0x54)

	label(0x06)
	say_quip(CHR_BOND, 0x19, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Alive
	label(0x2d)
	if_just_injured(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x08)

	// Injured
	label(0x06)
	restart_timer

	beginloop(0x55)
		if_self_flag_bankx_eq(CHRFLAG0_SAID_INJURY_QUIP, TRUE, BANK_0, /*goto*/ 0x06)
		if_num_times_shot_lt(1, /*goto*/ 0x06)
		if_timer_lt(20, /*goto*/ 0x06)
		say_quip(CHR_BOND, 0x0d, 0x28, 0x03, 0x00, BANK_0, 0x00, 0x00)
		say_quip(CHR_BOND, 0x0e, 0x28, 0x03, 0x01, BANK_0, 0x00, 0x00)
		set_self_flag_bankx(CHRFLAG0_SAID_INJURY_QUIP, BANK_0)
		label(0x06)
		if_chr_stopped(/*goto*/ 0x58)
	endloop(0x55)

	label(0x58)
	goto_next(0x5a)

	// Not injured, or recovered
	// Waiting to detect Jo
	beginloop(0x08)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x2d)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x2d)
	endloop(0x08)

	// Detected
	label(0x2d)
	jog_to_pad(0x011b)

	beginloop(0x08)
		if_chr_distance_to_pad_lt(CHR_SELF, 100, 0x011b, /*goto*/ 0x2d)
	endloop(0x08)

	label(0x2d)
	restart_timer
	chr_do_animation(ANIM_SURRENDER_002E, 0, 190, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x09)
		if_timer_gt(60, /*goto*/ 0x06)
		reloop(0x09)

		label(0x06)
		set_stage_flag(STAGEFLAG_KEYCARDGUY_ANGRY)
		if_chr_stopped(/*goto*/ 0x5a)
	endloop(0x09)

	label(0x5a)
	chr_do_animation(ANIM_DRAW_PISTOL_0288, 0, -1, 0x00, 0x10, CHR_SELF, 2)

	beginloop(0x0a)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	dprint 'C','R','E','A','T','E','D',' ','W','E','A','P','\n',0,
	try_equip_weapon(MODEL_CHRDRUGGUN, WEAPON_TRANQUILIZER, 0x10000000, /*goto*/ 0x06)
	label(0x06)
	set_target_chr(CHR_BOND)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

u8 func100c_keycardguy_lights[] = {
	set_lights_state(0x0088, 0x01, 0x00, 0x00, 0x00)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_KEYCARDGUY_ANGRY, TRUE, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	set_lights_state(0x0088, 0x01, 0x64, 0x00, 0x00)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100d_check_entered_lab[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0083, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0084, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0085, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0086, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0087, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0088, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0089, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x008a, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_stage_flag(STAGEFLAG_ENTERED_LAB)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100e_elvis_timer[] = {
	beginloop(0x04)
		if_door_state(0x13, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	set_stage_flag(STAGEFLAG_ENTERED_ELVIS_AREA)
	play_x_music(CHANNEL_10, 60)
	set_countdown_timer(60)
	show_countdown_timer
	start_countdown_timer

	beginloop(0x08)
		if_stage_flag_eq(STAGEFLAG_RESCUED_ELVIS, TRUE, /*goto*/ 0x2d)
		if_countdown_timer_lt(1, /*goto*/ 0x06)
	endloop(0x08)

	label(0x06)
	stop_countdown_timer
	hide_countdown_timer
	set_stage_flag(STAGEFLAG_ELVIS_DEAD)
	show_hudmsg(CHR_BOND, L_LIP(64)) // "Elvis has been killed."
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2d)
	stop_countdown_timer
	hide_countdown_timer
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100f_check_end_level[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_distance_to_pad_lt(CHR_P1P2, 300, 0x02a1, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		set_stage_flag(STAGEFLAG_RESCUED_ELVIS)
		yield
		yield
		if_all_objectives_complete(/*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	set_invincible(CHR_BOND)
	revoke_control(CHR_BOND, 4)
	hide_countdown_timer
	stop_countdown_timer
	restart_timer

	beginloop(0x5c)
		if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2d)
		if_chr_dying(CHR_BOND, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_BOND, /*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2d)
		if_chr_dying(CHR_COOP, /*goto*/ 0x2d)
		if_chr_unloaded(CHR_COOP, /*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
		end_level
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x06)
		set_ailist(CHR_SELF, AILIST_OUTRO)
		if_timer_gt(280, /*goto*/ 0x5b)
	endloop(0x5c)

	label(0x5b)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1010_give_keycard[] = {
	set_chr_chrflag(0x23, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x24, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x25, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x26, CHRCFLAG_KILLCOUNTABLE)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_ONE_KEYCARD_GUARD_REMAINING, TRUE, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	label(0x2d)
	if_chr_dying(0x23, /*goto*/ 0x06)
	if_chr_death_animation_finished(0x23, /*goto*/ 0x06)
	if_chr_unloaded(0x23, /*goto*/ 0x06)
	give_object_to_chr(0x10, 0x23)
	dprint 'G','I','V','E',' ','T','O','4',0,
	goto_next(0x2d)

	label(0x06)
	if_chr_dying(0x24, /*goto*/ 0x06)
	if_chr_death_animation_finished(0x24, /*goto*/ 0x06)
	if_chr_unloaded(0x24, /*goto*/ 0x06)
	give_object_to_chr(0x10, 0x24)
	dprint 'G','I','V','E',' ','T','O','5',0,
	goto_next(0x2d)

	label(0x06)
	if_chr_dying(0x25, /*goto*/ 0x06)
	if_chr_death_animation_finished(0x25, /*goto*/ 0x06)
	if_chr_unloaded(0x25, /*goto*/ 0x06)
	give_object_to_chr(0x10, 0x25)
	dprint 'G','I','V','E',' ','T','O','6',0,
	goto_next(0x2d)

	label(0x06)
	if_chr_death_animation_finished(0x26, /*goto*/ 0x2d)
	if_chr_dying(0x26, /*goto*/ 0x2d)
	if_chr_unloaded(0x26, /*goto*/ 0x2d)
	dprint 'G','I','V','E',' ','T','O','7',0,

	label(0x2d)
	unset_object_flag2(0x10, OBJFLAG2_INVISIBLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0414_init_mechanic[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_MECHANIC)
	endlist
};

u8 func0413_mechanic[] = {
	set_shotlist(AILIST_MECHANIC)
	if_chr_dying(CHR_SELF, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x2d)

	label(0x06)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	restart_timer

	beginloop(0x54)
		if_timer_gt(15, /*goto*/ 0x06)
	endloop(0x54)

	label(0x06)
	say_quip(CHR_BOND, 0x19, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2d)
	if_just_injured(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x2d)

	// Injured
	label(0x06)
	restart_timer

	beginloop(0x55)
		if_self_flag_bankx_eq(CHRFLAG0_SAID_INJURY_QUIP, TRUE, BANK_0, /*goto*/ 0x06)
		if_num_times_shot_lt(1, /*goto*/ 0x06)
		if_timer_lt(20, /*goto*/ 0x06)
		say_quip(CHR_BOND, 0x0d, 0x28, 0x03, 0x00, BANK_0, 0x00, 0x00)
		say_quip(CHR_BOND, 0x0e, 0x28, 0x03, 0x01, BANK_0, 0x00, 0x00)
		set_self_flag_bankx(CHRFLAG0_SAID_INJURY_QUIP, BANK_0)
		label(0x06)
		if_chr_stopped(/*goto*/ 0x58)
	endloop(0x55)

	// Main logic
	label(0x2d)
	stop_chr

	// Wait for player to attempt to open door
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x0a)
		if_chr_activated_object(CHR_P1P2, 0x14, /*goto*/ 0x2d)
		if_chr_activated_object(CHR_P1P2, 0x15, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	restart_timer

	beginloop(0x0d)
		if_timer_gt(180, /*goto*/ 0x06)
	endloop(0x0d)

	label(0x06)
	unlock_door(0x14, 0x10)
	unlock_door(0x15, 0x10)
	open_door(0x14)
	open_door(0x15)

	beginloop(0x0a)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	restart_timer

	label(0x08)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	dprint 'T','A','L','K',' ','1','\n',0,
	speak(CHR_BOND, L_LIP(65), 0x80fb, CHANNEL_4, COLOR_08_RED) // "Get the hell out of here!"
	restart_timer
	chr_do_animation(ANIM_SURRENDER_002E, 0, -1, 0x18, 0x10, CHR_SELF, 2)

	beginloop(0x64)
		if_timer_gt(120, /*goto*/ 0x2d)
	endloop(0x64)

	label(0x58)
	label(0x2d)
	run_to_pad(0x01ba)

	beginloop(0x0e)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x0e)

	label(0x06)
	label(0x0f)
		chr_do_animation(ANIM_COWER_0229, -1, -1, 0x10, 0x0a, CHR_SELF, 2)

		beginloop(0x8a)
			if_chr_stopped(/*goto*/ 0x2d)
		endloop(0x8a)

		label(0x2d)
	goto_first(0x0f)

	endlist
};

u8 func1011_unhide_warehouse_spawner[] = {
	// Wait until player near second elevator
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00f8, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00f7, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00f6, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00f4, /*goto*/ 0x06)
	endloop(0x04)

	// Unhide a guy at the top of the ramp near the start
	label(0x06)
	unset_chr_chrflag(0x44, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x44, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x44, AILIST_WAREHOUSE_SPAWNER)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0415_warehouse_spawner[] = {
	set_self_chrflag(CHRCFLAG_00000002)
	restart_timer

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x08)
		if_chr_in_room(CHR_TARGET, 0x00, 0x00f8, /*goto*/ 0x08)
		if_chr_in_room(CHR_TARGET, 0x00, 0x00f7, /*goto*/ 0x08)
		if_chr_in_room(CHR_TARGET, 0x00, 0x00f6, /*goto*/ 0x08)
		if_chr_in_room(CHR_TARGET, 0x00, 0x00f4, /*goto*/ 0x08)
		reloop(0x04)

		label(0x08)
		dprint 'H','E','A','R','S','P','A','W','N','\n',0,

		label(0x2d)
		if_never_been_onscreen(/*goto*/ 0x4e)
		dprint 'N','E','V','E','R',' ','V','I','S','F','A','I','L','\n',0,
		if_chr_sees_player(/*goto*/ 0x08)
		reloop(0x04)

		label(0x08)
		set_target_chr(CHR_BOND)
		set_ailist(CHR_SELF, GAILIST_ALERTED)

		label(0x4e)
		dprint 'C','H','E','C','K',' ','D','U','P','E','\n',0,
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x4e)
		reloop(0x04)

		label(0x4e)
		dprint 'C','R','E','A','T','E',' ','S','P','A','W','N','\n',0,
		try_spawn_clone2(CHR_SELF, AILIST_WAREHOUSE_CLONE, 0x00000000, /*goto*/ 0x2d)
		dprint 'C','R','E','A','T','E',' ','F','A','I','L','\n',0,
		reloop(0x04)

		label(0x2d)
		restart_timer
		yield
	endloop(0x04)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0417_warehouse_clone[] = {
	set_target_chr(CHR_BOND)
	set_alertness(100)
	try_run_to_target(/*goto*/ 0x2d)
	label(0x2d)
	set_returnlist(CHR_SELF, GAILIST_UNALERTED)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func1013_check_chamber_switch_destroyed[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0d)

	beginloop(0x04)
		if_object_in_good_condition(OBJ_CHAMBER1_SWITCH, /*goto*/ 0x06)
		if_stage_flag_eq(STAGEFLAG_CHAMBER1_RAISED, TRUE, /*goto*/ 0x2d)
		show_hudmsg(CHR_BOND, L_LIP(68)) // "Mission critical equipment destroyed."
		set_stage_flag(STAGEFLAG_CHAMBER_SWITCH_DESTROYED)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x2d)
		reloop(0x04)

		label(0x06)
	endloop(0x04)

	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1014_check_crate_destroyed[] = {
	// The unsetting of the wall's IMMUNE_TO_EXPLOSIVES flag suggests that the
	// wall was originally intended to only be blown up via the crate. This must
	// have been changed at some point, but the unsetting of the flag remains.
	beginloop(0x04)
		if_object_in_good_condition(OBJ_CRATE, /*goto*/ 0x06)
		unset_object_flag(OBJ_WALL, OBJFLAG_INVINCIBLE)
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		yield
		if_object_in_good_condition(OBJ_WALL, /*goto*/ 0x2d)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x2d)
		show_hudmsg(CHR_BOND, L_LIP(68)) // "Mission critical equipment destroyed."
		set_stage_flag(STAGEFLAG_CRATE_DESTROYED)

		beginloop(0x08)
			if_object_in_good_condition(OBJ_WALL, /*goto*/ 0x2d)
			goto_next(0x2e)

			label(0x2d)
		endloop(0x08)

		label(0x2e)
		unset_stage_flag(STAGEFLAG_CRATE_DESTROYED)
		show_hudmsg(CHR_BOND, L_LIP(89)) // "Alternative entrance to medlabs created."
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x06)
	endloop(0x04)

	endlist
};

/**
 * @unused
 */
u8 func041c_unused_041c[] = {
	set_chr_chrflag(CHR_SELF, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_SELF, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * @unused
 */
u8 func041d_unused_041d[] = {
	set_chr_chrflag(CHR_SELF, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_SELF, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * @unused
 */
u8 func041e_unused_041e[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(10)
	set_reaction_speed(35)
	set_chr_maxdamage(CHR_SELF, 80)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_chr_chrflag(CHR_SELF, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(CHR_SELF, CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1016_check_undisguised[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_stage_flag_eq(STAGEFLAG_DISGUISE_UNCOVERED, TRUE, /*goto*/ 0x06)
		if_chr_dying(CHR_LABTECH_HARRYSMATE, /*goto*/ 0x06)
		if_chr_dying(CHR_LABTECH_KEYCARDGUY, /*goto*/ 0x06)
		if_chr_dying(CHR_DOORMAN, /*goto*/ 0x06)
		if_chr_has_object(CHR_P1P2, OBJ_KEYCARD, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	unset_chr_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISED)
	unset_chr_hiddenflag(CHR_COOP, CHRHFLAG_DISGUISED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func041f_labtech_lights[] = {
	set_shotlist(AILIST_LABTECH_LIGHTS)
	if_chr_dying(CHR_SELF, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x2d)

	label(0x06)
	restart_timer

	beginloop(0x54)
		if_timer_gt(15, /*goto*/ 0x06)
	endloop(0x54)

	label(0x06)
	say_quip(CHR_BOND, 0x19, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2d)
	if_just_injured(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x5e)

	label(0x06)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	restart_timer

	beginloop(0x55)
		if_self_flag_bankx_eq(CHRFLAG0_SAID_INJURY_QUIP, TRUE, BANK_0, /*goto*/ 0x06)
		if_num_times_shot_lt(1, /*goto*/ 0x06)
		if_timer_lt(20, /*goto*/ 0x06)
		say_quip(CHR_BOND, 0x0d, 0x28, 0x03, 0x00, BANK_0, 0x00, 0x00)
		say_quip(CHR_BOND, 0x0e, 0x28, 0x03, 0x01, BANK_0, 0x00, 0x00)
		set_self_flag_bankx(CHRFLAG0_SAID_INJURY_QUIP, BANK_0)
		label(0x06)
		if_chr_stopped(/*goto*/ 0x5e)
	endloop(0x55)

	label(0x5e)
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x53)
	call_rng
	if_rand_lt(86, /*goto*/ 0x69)
	if_rand_lt(172, /*goto*/ 0x6a)
	chr_do_animation(ANIM_SITTING_DORMANT, -1, -1, 0x14, 0x01, CHR_SELF, 2)
	goto_next(0x04)

	label(0x69)
	chr_do_animation(ANIM_SITTING_DORMANT, -1, -1, 0x14, 0x01, CHR_SELF, 2)
	goto_next(0x04)

	label(0x6a)
	chr_do_animation(ANIM_SITTING_DORMANT, -1, -1, 0x14, 0x01, CHR_SELF, 2)
	goto_next(0x04)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x53)
		if_target_in_sight(/*goto*/ 0x03)
		if_chr_idle(/*goto*/ 0x06)
		goto_first(0x5e)

		label(0x06)
	endloop(0x04)

	// Jo in sight
	label(0x03)
	object_do_animation(0x025a, 0xff, 0x02, 0xffff)
	dprint 'T','A','L','K',' ','0','\n',0,
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x53)
	restart_timer
	label(0x08)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	dprint 'T','A','L','K',' ','1','\n',0,
	if_chr_has_hiddenflag(CHR_TARGET, CHRHFLAG_DISGUISE_UNCOVERED, /*goto*/ 0x06)
	if_chr_has_hiddenflag(CHR_TARGET, CHRHFLAG_DISGUISED, /*goto*/ 0x2d)
	label(0x06)
	object_do_animation(0x025a, 0xff, 0x02, 0xffff)
	speak(CHR_TARGET, L_LIP(37), 0x8103, CHANNEL_4, COLOR_08_RED) // "Who are you?"

#if VERSION >= VERSION_JAP_FINAL
	label(0x68)
	if_sound_finished(CHANNEL_4, /*goto*/ 0x06)
	yield
	goto_first(0x68)

	label(0x06)
#endif

	goto_next(0x06)

	label(0x2d)
	speak(CHR_TARGET, L_LIP(83), 0x127f, CHANNEL_4, COLOR_08_RED) // "Should you be in here?"
	restart_timer
	do_preset_animation(-1)

	beginloop(0x64)
		if_sound_finished(CHANNEL_4, /*goto*/ 0x06)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x2d)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x2d)
		label(0x2d)
	endloop(0x64)

	label(0x06)
	stop_chr
	if_chr_has_hiddenflag(CHR_TARGET, CHRHFLAG_DISGUISE_UNCOVERED, /*goto*/ 0x06)
	if_chr_has_hiddenflag(CHR_TARGET, CHRHFLAG_DISGUISED, /*goto*/ 0x0c)
	label(0x06)
	speak(CHR_TARGET, L_LIP(82), 0x1286, CHANNEL_4, COLOR_08_RED) // "Leave this area now."
	restart_timer
	do_preset_animation(-1)

	beginloop(0x66)
		if_sound_finished(CHANNEL_4, /*goto*/ 0x53)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x2d)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x2d)
		label(0x2d)
	endloop(0x66)

	label(0x53)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)

	label(0x0a)
		set_target_chr(CHR_BOND)
		restart_timer
		try_run_to_target(/*goto*/ 0x0b)

		beginloop(0x0b)
			if_timer_gt(60, /*goto*/ 0x06)
			if_distance_to_target_lt(400, /*goto*/ 0x2d)
		endloop(0x0b)

		label(0x06)
	goto_first(0x0a)

	label(0x2d)
	set_self_flag_bankx(CHRFLAG0_00000004, BANK_0)
	set_returnlist(CHR_SELF, AILIST_LABTECH_LIGHTS)
	set_ailist(CHR_SELF, GAILIST_HAND_COMBAT)

	label(0x0c)
	walk_to_pad(0x020d)

	beginloop(0x0d)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x2d)
		if_saw_injury(0x00, /*goto*/ 0x0f)
		label(0x2d)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x2d)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x2d)
		goto_next(0x0f)

		label(0x2d)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x0d)

	label(0x06)
	set_self_chrflag(CHRCFLAG_00000080)
	restart_timer
	try_face_entity(0x0008, 0x0428, /*goto*/ 0x6e)

	beginloop(0x6e)
		if_timer_gt(120, /*goto*/ 0x6f)
		if_chr_stopped(/*goto*/ 0x6f)
	endloop(0x6e)

	label(0x6f)
	call_rng
	if_rand_lt(86, /*goto*/ 0x64)
	if_rand_lt(172, /*goto*/ 0x66)
	chr_do_animation(ANIM_OPERATE_0221, -1, -1, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x0e)

	label(0x64)
	chr_do_animation(ANIM_OPERATE_0221, -1, -1, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x0e)

	label(0x66)
	chr_do_animation(ANIM_OPERATE_0223, -1, -1, 0x10, 0x0a, CHR_SELF, 2)

	beginloop(0x0e)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x2d)
		if_saw_injury(0x00, /*goto*/ 0x0f)
		label(0x2d)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x2d)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x2d)
		goto_next(0x0f)

		label(0x2d)
		if_chr_idle(/*goto*/ 0x2e)
		goto_first(0x6f)

		label(0x2e)
	endloop(0x0e)

	label(0x0f)
	speak(CHR_TARGET, L_LIP(84), 0x8124, CHANNEL_4, COLOR_08_RED) // "Holy..."
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	chr_do_animation(ANIM_SURPRISED_0202, -1, -1, 0x14, 0x0a, CHR_SELF, 2)
	restart_timer

	beginloop(0x10)
		if_timer_gt(60, /*goto*/ 0x2d)
	endloop(0x10)

	label(0x2d)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	goto_first(0x53)

	endlist
};

u8 func0421_init_labtech_doors[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_LABTECH_DOORS)
	endlist
};

u8 func0420_labtech_doors[] = {
	set_self_chrflag(CHRCFLAG_00000080)
	set_shotlist(AILIST_LABTECH_DOORS)
	if_chr_dying(CHR_SELF, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x2d)

	label(0x06)
	say_quip(CHR_BOND, 0x19, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2d)
	if_just_injured(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x5e)

	label(0x06)
	restart_timer

	beginloop(0x55)
		if_self_flag_bankx_eq(CHRFLAG0_SAID_INJURY_QUIP, TRUE, BANK_0, /*goto*/ 0x06)
		if_num_times_shot_lt(1, /*goto*/ 0x06)
		if_timer_lt(20, /*goto*/ 0x06)
		say_quip(CHR_BOND, 0x0d, 0x28, 0x03, 0x00, BANK_0, 0x00, 0x00)
		say_quip(CHR_BOND, 0x0e, 0x28, 0x03, 0x01, BANK_0, 0x00, 0x00)
		set_self_flag_bankx(CHRFLAG0_SAID_INJURY_QUIP, BANK_0)
		label(0x06)
		if_chr_stopped(/*goto*/ 0x5e)
	endloop(0x55)

	label(0x5e)
	chr_do_animation(ANIM_OPERATE_0221, -1, -1, 0x10, 0x01, CHR_SELF, 2)
	goto_next(0x6f)

	label(0x64)
	chr_do_animation(ANIM_OPERATE_0221, -1, -1, 0x10, 0x01, CHR_SELF, 2)
	goto_next(0x6f)

	label(0x66)
	chr_do_animation(ANIM_OPERATE_0223, -1, -1, 0x10, 0x01, CHR_SELF, 2)
	label(0x6f)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		set_target_chr(CHR_BOND)
		if_chr_has_hiddenflag(CHR_TARGET, CHRHFLAG_DISGUISE_UNCOVERED, /*goto*/ 0x06)
		if_chr_has_hiddenflag(CHR_TARGET, CHRHFLAG_DISGUISED, /*goto*/ 0x2d)
		label(0x06)
		goto_next(0x2e)

		label(0x2d)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x2e)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x2e)
		if_self_flag_bankx_eq(CHRFLAG0_08000000, TRUE, BANK_0, /*goto*/ 0x06)
		label(0x2e)
		if_chr_sees_player(/*goto*/ 0x03)
		label(0x06)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x03)
		if_saw_injury(0x00, /*goto*/ 0x03)
		if_saw_death(0x00, /*goto*/ 0x03)
		if_chr_idle(/*goto*/ 0x2d)
		goto_first(0x5e)

		label(0x2d)
	endloop(0x04)

	label(0x03)
	restart_timer
	label(0x08)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		if_saw_injury(0x00, /*goto*/ 0x89)
		if_saw_death(0x00, /*goto*/ 0x89)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	dprint 'T','A','L','K',' ','1','\n',0,
	if_chr_has_hiddenflag(CHR_TARGET, CHRHFLAG_DISGUISE_UNCOVERED, /*goto*/ 0x06)
	if_chr_has_hiddenflag(CHR_TARGET, CHRHFLAG_DISGUISED, /*goto*/ 0x2d)
	label(0x06)
	dprint 'T','A','L','K',' ','2','\n',0,
	goto_next(0x06)

	label(0x2d)
	dprint 'T','A','L','K',' ','3','\n',0,
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x2d)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x2d)
	dprint 'T','A','L','K',' ','4','\n',0,
	goto_next(0x06)

	label(0x2d)
	do_preset_animation(3)
	say_quip(CHR_BOND, 0x1d, 0xff, 0x02, 0xff, BANK_0, 0x00, 0x00)
	set_self_flag_bankx(CHRFLAG0_08000000, BANK_0)

	beginloop(0x7b)
		if_saw_injury(0x00, /*goto*/ 0x89)
		if_saw_death(0x00, /*goto*/ 0x89)
		dprint 'T','A','L','K',' ','5','\n',0,
		if_chr_propsoundcount_zero(CHR_SELF, /*goto*/ 0x2d)
	endloop(0x7b)

	label(0x2d)
	stop_chr
	goto_first(0x5e)

	label(0x89)
	label(0x06)
	increase_squadron_alertness(100)

	beginloop(0x83)
		if_sound_finished(CHANNEL_4, /*goto*/ 0x2d)
	endloop(0x83)

	label(0x2d)
	if_self_flag_bankx_eq(CHRFLAG0_00000004, TRUE, BANK_0, /*goto*/ 0x2e)
	speak(CHR_BOND, L_LIP(85), 0x1aa6, CHANNEL_4, COLOR_08_RED) // "It's a spy!"
	goto_next(0x2d)

	label(0x2e)
	speak(CHR_BOND, L_LIP(87), 0x1aa5, CHANNEL_4, COLOR_08_RED) // "Imposter!"
	label(0x2d)
	label(0x06)
	go_to_target_pad(SPEED_JOG)

	beginloop(0x0a)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	restart_timer
	if_self_flag_bankx_eq(CHRFLAG0_00000004, TRUE, BANK_0, /*goto*/ 0x2d)
	try_face_entity(0x0008, 0x03c6, /*goto*/ 0x70)
	label(0x2d)
	try_face_entity(0x0008, 0x03c7, /*goto*/ 0x70)

	beginloop(0x70)
		if_timer_gt(30, /*goto*/ 0x2d)
	endloop(0x70)

	label(0x2d)
	chr_do_animation(ANIM_OPERATE_0221, -1, 120, 0x10, 0x01, CHR_SELF, 2)
	restart_timer

	beginloop(0x71)
		if_timer_gt(120, /*goto*/ 0x2d)
		if_timer_lt(60, /*goto*/ 0x2d)
		if_stage_flag_eq(STAGEFLAG_AUTOGUN_ACTIVATED, TRUE, /*goto*/ 0x06)
		if_stage_flag_eq(STAGEFLAG_AUTOGUN_VIRUS_DONE, TRUE, /*goto*/ 0x2d)
		set_stage_flag(STAGEFLAG_AUTOGUN_ACTIVATED)
		if_self_flag_bankx_eq(CHRFLAG0_00000004, TRUE, BANK_0, /*goto*/ 0x75)
		assign_sound(0x043a, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, 0x3c, TRUE)
		goto_next(0x2d)

		label(0x75)
		assign_sound(0x043a, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, 0x3d, TRUE)
		label(0x2d)
	endloop(0x71)

	label(0x06)
	restart_timer
	try_face_entity(0x0008, 0x0107, /*goto*/ 0x73)

	beginloop(0x73)
		if_timer_gt(30, /*goto*/ 0x06)
	endloop(0x73)

	label(0x06)
	dprint 'F','L','A','G',' ','S','E','T','\n',0,
	label(0x10)
	chr_do_animation(ANIM_COWER_0229, -1, -1, 0x10, 0x0a, CHR_SELF, 2)

	beginloop(0x77)
		if_chr_stopped(/*goto*/ 0x2d)
	endloop(0x77)

	label(0x2d)
	goto_first(0x10)

	endlist
};

u8 func1017_activate_autogun[] = {
	set_object_flag(OBJ_AUTOGUN, OBJFLAG_DEACTIVATED)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_AUTOGUN_ACTIVATED, TRUE, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	if_object_in_good_condition(OBJ_AUTOGUN, /*goto*/ 0x2d)
	goto_next(0x06)

	label(0x2d)
	unset_object_flag(OBJ_AUTOGUN, OBJFLAG_DEACTIVATED)
	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0423_init_labtech_records[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_LABTECH_RECORDS)
	endlist
};

u8 func0422_labtech_records[] = {
	set_shotlist(AILIST_LABTECH_RECORDS)
	if_chr_dying(CHR_SELF, /*goto*/ 0x06)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x06)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x2d)
	label(0x06)
	set_shotlist(GAILIST_IDLE)
	restart_timer
	label(0x54)
	yield
	if_timer_gt(15, /*goto*/ 0x06)
	goto_first(0x54)

	label(0x06)
	say_quip(CHR_BOND, 0x19, 0xff, 0x03, 0xff, BANK_0, 0x00, 0x00)
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x2d)
	if_just_injured(CHR_SELF, /*goto*/ 0x06)
	goto_next(0x5e)
	label(0x06)
	restart_timer
	label(0x55)
	yield
	if_self_flag_bankx_eq(CHRFLAG0_SAID_INJURY_QUIP, TRUE, BANK_0, /*goto*/ 0x06)
	if_num_times_shot_lt(1, /*goto*/ 0x06)
	if_timer_lt(20, /*goto*/ 0x06)
	say_quip(CHR_BOND, 0x0d, 0x28, 0x03, 0x00, BANK_0, 0x00, 0x00)
	say_quip(CHR_BOND, 0x0e, 0x28, 0x03, 0x01, BANK_0, 0x00, 0x00)
	set_self_flag_bankx(CHRFLAG0_SAID_INJURY_QUIP, BANK_0)
	label(0x06)
	if_chr_stopped(/*goto*/ 0x5e)
	goto_first(0x55)

	label(0x5e)
	call_rng
	if_rand_lt(32, /*goto*/ 0x64)
	if_rand_lt(64, /*goto*/ 0x66)
	if_rand_lt(96, /*goto*/ 0x68)
	if_rand_lt(128, /*goto*/ 0x69)
	if_rand_lt(160, /*goto*/ 0x6a)
	if_rand_lt(192, /*goto*/ 0x6b)
	if_rand_lt(224, /*goto*/ 0x6c)
	chr_do_animation(0x0221, -1, -1, 0x10, 0x01, CHR_SELF, 2)
	goto_next(0x04)
	label(0x64)
	chr_do_animation(0x0221, -1, -1, 0x10, 0x01, CHR_SELF, 2)
	goto_next(0x04)
	label(0x66)
	chr_do_animation(0x0223, -1, -1, 0x10, 0x01, CHR_SELF, 2)
	goto_next(0x04)
	label(0x68)
	chr_do_animation(0x0221, -1, -1, 0x11, 0x01, CHR_SELF, 2)
	goto_next(0x04)
	label(0x69)
	chr_do_animation(0x0221, -1, -1, 0x11, 0x01, CHR_SELF, 2)
	goto_next(0x04)
	label(0x6a)
	chr_do_animation(0x0223, -1, -1, 0x11, 0x01, CHR_SELF, 2)
	goto_next(0x04)
	label(0x6b)
	chr_do_animation(0x023a, -1, -1, 0x11, 0x01, CHR_SELF, 2)
	goto_next(0x04)
	label(0x6c)
	chr_do_animation(0x023b, -1, -1, 0x11, 0x01, CHR_SELF, 2)
	label(0x04)
	yield
	if_chr_idle(/*goto*/ 0x2d)
	goto_first(0x5e)

	label(0x2d)
	chr_toggle_p1p2(CHR_SELF)
	set_target_chr(CHR_P1P2)
	if_target_in_sight(/*goto*/ 0x03)
	if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x03)
	if_distance_to_target_lt(500, /*goto*/ 0x03)
	goto_first(0x04)

	label(0x03)
	if_chr_has_hiddenflag(CHR_TARGET, CHRHFLAG_DISGUISE_UNCOVERED, /*goto*/ 0x06)
	if_chr_has_hiddenflag(CHR_TARGET, CHRHFLAG_DISGUISED, /*goto*/ 0x2d)
	goto_next(0x06)
	label(0x2d)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x2d)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x2d)
	goto_next(0x06)
	label(0x2d)
	goto_first(0x04)

	label(0x2d)
	restart_timer
	label(0x08)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)
	label(0x09)
	yield
	if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
	if_timer_gt(60, /*goto*/ 0x06)
	goto_first(0x09)

	label(0x06)
	label(0x06)
	if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x2d)
	increase_squadron_alertness(100)
	speak(CHR_TARGET, L_LIP(87), 0x1aa5, CHANNEL_4, COLOR_08_RED) // "Imposter!"
	chr_do_animation(0x0202, -1, -1, 0x14, 0x0a, CHR_SELF, 2)
	restart_timer
	label(0x79)
	yield
	if_timer_gt(90, /*goto*/ 0x2d)
	goto_first(0x79)

	label(0x2d)
	dprint 'T','A','L','K',' ','1','\n',0,
	speak(CHR_TARGET, L_LIP(86), 0x04ce, CHANNEL_4, COLOR_08_RED) // "Warn the others..."
	label(0x2d)
	label(0x06)
	run_to_pad(0x0108)
	label(0x0a)
	yield
	if_chr_stopped(/*goto*/ 0x06)
	goto_first(0x0a)

	label(0x06)
	dprint 'F','L','A','G',' ','S','E','T','\n',0,
	label(0x10)
	chr_do_animation(0x0229, -1, -1, 0x10, 0x0a, CHR_SELF, 2)
	label(0x0e)
	yield
	if_chr_stopped(/*goto*/ 0x2d)
	goto_first(0x0e)

	label(0x2d)
	goto_first(0x10)

	endlist
};

/**
 * Chambers are actually lifts. They must be disabled so they don't continuously
 * go up and down.
 */
u8 func1018_disable_chambers[] = {
	set_object_flag(OBJ_CHAMBER1, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_CHAMBER2, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_CHAMBER3, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_CHAMBER4, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_CHAMBER5, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_CHAMBER6, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_CHAMBER7, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_CHAMBER8, OBJFLAG_DEACTIVATED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

// This macro is here is reduce the amount of duplicate code. However, each
// chamber's code is not entirely consistant, hence why it's not used by all
// chambers.
#define chamber_logic(switch, chamber, stageflag) \
	/* Wait for player to activate chamber switch */ \
	beginloop(0x04) \
		chr_toggle_p1p2(CHR_SELF) \
		if_chr_activated_object(CHR_P1P2, switch, /*goto*/ 0x06) \
		reloop(0x04) \
 \
		label(0x06) \
		if_stage_flag_eq(stageflag, TRUE, /*goto*/ 0x2d) \
		mute_channel(CHANNEL_0) \
 \
		/* Raising chamber */ \
		assign_sound(0x042b, CHANNEL_0) \
		control_sound_from_object(CHANNEL_0, chamber, TRUE) \
		assign_sound(0x043a, CHANNEL_7) \
		control_sound_from_object(CHANNEL_7, switch, TRUE) \
		show_hudmsg(CHR_P1P2, 0x2a42) /* "Containment unit raised up." */ \
		set_object_image(switch, 0x00, 0x13) \
		unset_object_flag(chamber, OBJFLAG_DEACTIVATED) \
		set_stage_flag(stageflag) \
		restart_timer \
 \
		beginloop(0x08) \
			if_timer_gt(200, /*goto*/ 0x06) \
		endloop(0x08) \
 \
		label(0x06) \
		mute_channel(CHANNEL_0) \
		assign_sound(0x042c, CHANNEL_0) \
		control_sound_from_object(CHANNEL_0, chamber, TRUE) \
		set_object_flag(chamber, OBJFLAG_DEACTIVATED) \
		reloop(0x04) \
 \
		/* Lowering chamber */ \
		label(0x2d) \
		mute_channel(CHANNEL_0) \
		assign_sound(0x042b, CHANNEL_0) \
		control_sound_from_object(CHANNEL_0, chamber, TRUE) \
		assign_sound(0x043a, CHANNEL_7) \
		control_sound_from_object(CHANNEL_7, switch, TRUE) \
		show_hudmsg(CHR_P1P2, 0x2a43) /* "Containment unit lowered down." */ \
		set_object_image(switch, 0x00, 0x12) \
		unset_object_flag(chamber, OBJFLAG_DEACTIVATED) \
		unset_stage_flag(stageflag) \
		restart_timer \
 \
		beginloop(0x09) \
			if_timer_gt(200, /*goto*/ 0x06) \
		endloop(0x09) \
 \
		label(0x06) \
		mute_channel(CHANNEL_0) \
		assign_sound(0x042c, CHANNEL_0) \
		control_sound_from_object(CHANNEL_0, chamber, TRUE) \
		set_object_flag(chamber, OBJFLAG_DEACTIVATED) \
	endloop(0x04)



/**
 * This chamber has the alien in it.
 */
u8 func1019_chamber1[] = {
	// Wait for player to activate chamber switch
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_CHAMBER1_SWITCH, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		if_stage_flag_eq(STAGEFLAG_CHAMBER1_RAISED, TRUE, /*goto*/ 0x2d)
		mute_channel(CHANNEL_0)

		// Raising chamber
		assign_sound(0x042b, CHANNEL_0)
		control_sound_from_object(CHANNEL_0, OBJ_CHAMBER1, TRUE)
		assign_sound(0x043a, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_CHAMBER1_SWITCH, TRUE)
		set_object_image(OBJ_CHAMBER1_SWITCH, 0x00, 0x13)
		show_hudmsg(CHR_P1P2, L_LIP(66)) // "Containment unit raised up."
		unset_object_flag(OBJ_CHAMBER1, OBJFLAG_DEACTIVATED)
		set_stage_flag(STAGEFLAG_CHAMBER1_RAISED)
		restart_timer

		beginloop(0x08)
			if_timer_gt(200, /*goto*/ 0x06)
		endloop(0x08)

		label(0x06)
		mute_channel(CHANNEL_0)
		assign_sound(0x042c, CHANNEL_0)
		control_sound_from_object(CHANNEL_0, OBJ_CHAMBER1, TRUE)
		set_chr_hiddenflag(CHR_ALIEN, CHRHFLAG_00100000)

		beginloop(0x64)
			chr_move_to_pad(CHR_ALIEN, 0x03ca, 0x01, /*goto*/ 0x06)
		endloop(0x64)

		label(0x06)
		yield
		unset_chr_chrflag(CHR_ALIEN, CHRCFLAG_HIDDEN)
		set_ailist(CHR_ALIEN, AILIST_CHECK_LOOKING_AT_ALIEN)
		label(0x06)
		set_object_flag(OBJ_CHAMBER1, OBJFLAG_DEACTIVATED)
		reloop(0x04)

		// Lowering chamber
		label(0x2d)
		mute_channel(CHANNEL_0)
		assign_sound(0x042b, CHANNEL_0)
		control_sound_from_object(CHANNEL_0, OBJ_CHAMBER1, TRUE)
		set_chr_chrflag(CHR_ALIEN, CHRCFLAG_HIDDEN)
		assign_sound(0x043a, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_CHAMBER1_SWITCH, TRUE)
		set_object_image(OBJ_CHAMBER1_SWITCH, 0x00, 0x12)
		show_hudmsg(CHR_P1P2, L_LIP(67)) // "Containment unit lowered down."
		unset_object_flag(OBJ_CHAMBER1, OBJFLAG_DEACTIVATED)
		unset_stage_flag(STAGEFLAG_CHAMBER1_RAISED)
		restart_timer

		beginloop(0x09)
			if_timer_gt(200, /*goto*/ 0x06)
		endloop(0x09)

		label(0x06)
		mute_channel(CHANNEL_0)
		assign_sound(0x042c, CHANNEL_0)
		control_sound_from_object(CHANNEL_0, OBJ_CHAMBER1, TRUE)
		set_object_flag(OBJ_CHAMBER1, OBJFLAG_DEACTIVATED)
	endloop(0x04)
	endlist
};

u8 func101a_chamber2[] = {
	// Wait for player to activate chamber switch
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_CHAMBER2_SWITCH, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		mute_channel(CHANNEL_0)
		if_stage_flag_eq(STAGEFLAG_CHAMBER2_RAISED, TRUE, /*goto*/ 0x2d)

		// Raising chamber
		assign_sound(0x042b, CHANNEL_0)
		control_sound_from_object(CHANNEL_0, OBJ_CHAMBER2, TRUE)
		assign_sound(0x043a, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_CHAMBER2_SWITCH, TRUE)
		set_object_image(OBJ_CHAMBER2_SWITCH, 0x00, 0x13)
		show_hudmsg(CHR_P1P2, L_LIP(66)) // "Containment unit raised up."
		unset_object_flag(OBJ_CHAMBER2, OBJFLAG_DEACTIVATED)
		set_stage_flag(STAGEFLAG_CHAMBER2_RAISED)
		restart_timer

		beginloop(0x08)
			if_timer_gt(200, /*goto*/ 0x06)
		endloop(0x08)

		label(0x06)
		mute_channel(CHANNEL_0)
		assign_sound(0x042c, CHANNEL_0)
		control_sound_from_object(CHANNEL_0, OBJ_CHAMBER2, TRUE)

		set_object_flag(OBJ_CHAMBER2, OBJFLAG_DEACTIVATED)
		reloop(0x04)

		// Lowering chamber
		label(0x2d)
		mute_channel(CHANNEL_0)
		assign_sound(0x042b, CHANNEL_0)
		control_sound_from_object(CHANNEL_0, OBJ_CHAMBER2, TRUE)
		assign_sound(0x043a, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_CHAMBER2_SWITCH, TRUE)
		set_object_image(OBJ_CHAMBER2_SWITCH, 0x00, 0x12)
		show_hudmsg(CHR_P1P2, L_LIP(67)) // "Containment unit lowered down."
		unset_object_flag(OBJ_CHAMBER2, OBJFLAG_DEACTIVATED)
		unset_stage_flag(STAGEFLAG_CHAMBER2_RAISED)
		restart_timer

		beginloop(0x09)
			if_timer_gt(200, /*goto*/ 0x06)
		endloop(0x09)

		label(0x06)
		mute_channel(CHANNEL_0)
		assign_sound(0x042c, CHANNEL_0)
		control_sound_from_object(CHANNEL_0, OBJ_CHAMBER2, TRUE)
		set_object_flag(OBJ_CHAMBER2, OBJFLAG_DEACTIVATED)
	endloop(0x04)
	endlist
};

u8 func101b_chamber3[] = {
	chamber_logic(OBJ_CHAMBER3_SWITCH, OBJ_CHAMBER3, STAGEFLAG_CHAMBER3_RAISED)
	endlist
};

u8 func101c_chamber4[] = {
	chamber_logic(OBJ_CHAMBER4_SWITCH, OBJ_CHAMBER4, STAGEFLAG_CHAMBER4_RAISED)
	endlist
};

u8 func101d_chamber5[] = {
	chamber_logic(OBJ_CHAMBER5_SWITCH, OBJ_CHAMBER5, STAGEFLAG_CHAMBER5_RAISED)
	endlist
};

u8 func101e_chamber6[] = {
	chamber_logic(OBJ_CHAMBER6_SWITCH, OBJ_CHAMBER6, STAGEFLAG_CHAMBER6_RAISED)
	endlist
};

u8 func101f_chamber7[] = {
	chamber_logic(OBJ_CHAMBER7_SWITCH, OBJ_CHAMBER7, STAGEFLAG_CHAMBER7_RAISED)
	endlist
};

u8 func1020_chamber8[] = {
	// Wait for player to activate chamber switch
	beginloop(0x04)
		// Likely @bug: Chamber 8 is the only chamber that doesn't call
		// chr_toggle_p1p2 here.
		// Co-op player might not be able to activate chamber 8.
		if_chr_activated_object(CHR_P1P2, OBJ_CHAMBER8_SWITCH, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		if_stage_flag_eq(STAGEFLAG_CHAMBER8_RAISED, TRUE, /*goto*/ 0x2d)
		mute_channel(CHANNEL_0)

		// Raising chamber
		assign_sound(0x042b, CHANNEL_0)
		control_sound_from_object(CHANNEL_0, OBJ_CHAMBER8, TRUE)
		assign_sound(0x043a, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_CHAMBER8_SWITCH, TRUE)
		show_hudmsg(CHR_P1P2, L_LIP(66)) // "Containment unit raised up."
		set_object_image(OBJ_CHAMBER8_SWITCH, 0x00, 0x13)
		unset_object_flag(OBJ_CHAMBER8, OBJFLAG_DEACTIVATED)
		set_stage_flag(STAGEFLAG_CHAMBER8_RAISED)
		restart_timer

		beginloop(0x08)
			if_timer_gt(200, /*goto*/ 0x06)
		endloop(0x08)

		label(0x06)
		mute_channel(CHANNEL_0)
		assign_sound(0x042c, CHANNEL_0)
		control_sound_from_object(CHANNEL_0, OBJ_CHAMBER8, TRUE)

		set_object_flag(OBJ_CHAMBER8, OBJFLAG_DEACTIVATED)
		reloop(0x04)

		// Lowering chamber
		label(0x2d)
		mute_channel(CHANNEL_0)
		assign_sound(0x042b, CHANNEL_0)
		control_sound_from_object(CHANNEL_0, OBJ_CHAMBER8, TRUE)

		assign_sound(0x043a, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_CHAMBER8_SWITCH, TRUE)
		show_hudmsg(CHR_P1P2, L_LIP(67)) // "Containment unit lowered down."
		set_object_image(OBJ_CHAMBER8_SWITCH, 0x00, 0x12)
		unset_object_flag(OBJ_CHAMBER8, OBJFLAG_DEACTIVATED)
		unset_stage_flag(STAGEFLAG_CHAMBER8_RAISED)
		restart_timer

		beginloop(0x09)
			if_timer_gt(200, /*goto*/ 0x06)
		endloop(0x09)

		label(0x06)
		mute_channel(CHANNEL_0)
		assign_sound(0x042c, CHANNEL_0)
		control_sound_from_object(CHANNEL_0, OBJ_CHAMBER8, TRUE)
		set_object_flag(OBJ_CHAMBER8, OBJFLAG_DEACTIVATED)
	endloop(0x04)
	endlist
};

u8 func0424_alien[] = {
	set_chr_chrflag(CHR_SELF, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_SELF, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, AILIST_CHECK_LOOKING_AT_ALIEN)
	endlist
};

/**
 * Guy that's hidden near the start. He starts sending out clones once you reach
 * the second elevator.
 */
u8 func0425_hiddenguy[] = {
	set_chr_chrflag(CHR_SELF, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_SELF, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0426_check_looking_at_alien[] = {
	beginloop(0x04)
		set_target_chr(CHR_BOND)
		if_self_has_chrflag(CHRCFLAG_HIDDEN, /*goto*/ 0x61)
		if_distance_to_target_lt(300, /*goto*/ 0x64)
		goto_next(0x66)

		// Jo is in range
		label(0x64)
		if_player_looking_at_something_maybe(0x0a, 0x01, 0x00, /*goto*/ 0x2d)

		// Jo is too far away or not looking at alien
		label(0x66)
		set_target_chr(CHR_COOP)
		if_distance_to_target_lt(300, /*goto*/ 0x68)
		goto_next(0x69)

		// Velvet is in range
		label(0x68)
		if_player_looking_at_something_maybe(0x0a, 0x01, 0x00, /*goto*/ 0x2d)

		// Both players are too far away
		label(0x69)

		// Alien is lowered/hidden
		label(0x61)
		unset_stage_flag(STAGEFLAG_LOOKING_AT_CHAMBER)
		reloop(0x04)

		label(0x2d)
		set_stage_flag(STAGEFLAG_LOOKING_AT_CHAMBER)
	endloop(0x04)

	endlist
};

u8 func1021_xray_scanning[] = {
	beginloop(0x04)
		// @bug? In co-op, the player wearing the xray may be the player who is
		// not looking at the alien.
		chr_toggle_p1p2(CHR_SELF)
		if_chr_has_weapon_equipped(CHR_P1P2, WEAPON_XRAYSCANNER, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		if_stage_flag_eq(STAGEFLAG_LOOKING_AT_CHAMBER, TRUE, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		show_hudmsg(CHR_P1P2, L_LIP(74)) // "Scanner target acquired."
		restart_timer

		beginloop(0x08)
			if_timer_gt(240, /*goto*/ 0x06)
			if_stage_flag_eq(STAGEFLAG_LOOKING_AT_CHAMBER, FALSE, /*goto*/ 0x2d)
		endloop(0x08)

		label(0x06)
		show_hudmsg(CHR_P1P2, L_LIP(75)) // "Target ID confirmed - XT origin."
		set_stage_flag(STAGEFLAG_XRAY_DONE)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x2d)
		show_hudmsg(CHR_P1P2, L_LIP(76)) // "Scanner lock lost."
	endloop(0x04)

	endlist
};

/**
 * Waits until the player has been in the xray area for over 10 seconds, then
 * spawns a dataDyne shock trooper.
 *
 * Rare may have decided that it was too challenging to have a guard attack you
 * while xraying, hence removed the guard but left this function.
 */
u8 unregistered_function1[] = {
	restart_timer

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_timer_gt(600, /*goto*/ 0x08)
		pause_timer
		if_chr_in_room(CHR_P1P2, 0x00, 0x010d, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0102, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0103, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0104, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0105, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0106, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0107, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0108, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0109, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x010c, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00fa, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00fb, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00fc, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00fd, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00fe, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00ff, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0100, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0101, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		resume_timer
		reloop(0x04)

		// 10 seconds passed
		label(0x08)
		if_chr_death_animation_finished(0x46, /*goto*/ 0x2d)
		reloop(0x04)

		label(0x2d)
		try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_DDSHOCK, 0x0101, 0x0427, 0x00000200, /*goto*/ 0x06)
		goto_next(0x2d)

		label(0x06)
		restart_timer
		reloop(0x04)

		label(0x2d)
	endloop(0x04)

	endlist
};

/**
 * Assigned by the above, which is an unregistered function.
 *
 * Makes the shock trooper run to one of two xray rooms, depending on which one
 * you're in.
 *
 * @unused
 */
u8 func0427_shock_clone[] = {
	stop_chr
	set_chr_id(0x46)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	try_equip_weapon(MODEL_CHRSUPERDRAGON, WEAPON_SUPERDRAGON, 0x10000000, /*goto*/ 0x04)

	label(0x04)
	yield
	chr_toggle_p1p2(CHR_SELF)
	if_chr_in_room(CHR_P1P2, 0x00, 0x010d, /*goto*/ 0x06)
	if_chr_in_room(CHR_P1P2, 0x00, 0x0102, /*goto*/ 0x06)
	if_chr_in_room(CHR_P1P2, 0x00, 0x0103, /*goto*/ 0x06)
	if_chr_in_room(CHR_P1P2, 0x00, 0x0104, /*goto*/ 0x06)
	if_chr_in_room(CHR_P1P2, 0x00, 0x0105, /*goto*/ 0x06)
	if_chr_in_room(CHR_P1P2, 0x00, 0x0106, /*goto*/ 0x06)
	if_chr_in_room(CHR_P1P2, 0x00, 0x0107, /*goto*/ 0x06)
	if_chr_in_room(CHR_P1P2, 0x00, 0x0108, /*goto*/ 0x06)
	if_chr_in_room(CHR_P1P2, 0x00, 0x0109, /*goto*/ 0x06)
	run_to_pad(0x0184)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)

	label(0x06)
	run_to_pad(0x013b)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func1023_setup_door_locks[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x06)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x09)

	// PA
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Agent - lock big door at bottom of ramp near showers
	label(0x06)
	lock_door(0x44, 0x80)
	lock_door(0x45, 0x80)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// SA - unlock the small shower doors
	label(0x09)
	unlock_door(0x2b, 0x80)
	unlock_door(0x2c, 0x80)
	unlock_door(0x2d, 0x80)
	unlock_door(0x2e, 0x80)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0c01_outro[] = {
	set_invincible(CHR_BOND)
	camera_movement(0x0198)
	set_music_track(MUSIC_RESCUE_OUTRO)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0xf1, CHRCFLAG_HIDDEN)
	set_ailist(CHR_P1P2, GAILIST_IDLE)
	set_ailist(CHR_BIOTECH1, GAILIST_IDLE)
	set_ailist(CHR_BIOTECH2, GAILIST_IDLE)
	set_invincible(CHR_BOND)

	set_chr_chrflag(CHR_P1P2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_P1P2, CHRHFLAG_00020000)
	chr_do_animation(0x0199, -1, -1, 0x06, 0x00, CHR_P1P2, 4)

	set_chr_chrflag(CHR_BIOTECH1, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_BIOTECH1, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_BIOTECH1, CHRHFLAG_00020000)
	chr_do_animation(0x019a, -1, -1, 0x06, 0x00, CHR_BIOTECH1, 4)

	set_chr_chrflag(CHR_BIOTECH2, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_BIOTECH2, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_BIOTECH2, CHRHFLAG_00020000)
	chr_do_animation(0x019b, -1, -1, 0x06, 0x00, CHR_BIOTECH2, 4)

	set_object_flag2(0x2f, OBJFLAG2_04000000)
	set_object_flag3(0x2f, OBJFLAG3_00000010)
	object_do_animation(0x01a1, 0x2f, 0x04, 0xffff)
	show_nonessential_chrs(FALSE)
	restart_timer
	set_cutscene_weapon(CHR_P1P2, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_P1P2, WEAPON_FALCON2_SCOPE, WEAPON_NONE)

	#define wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0x8b) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)



	wait_until(315, 0x73)
	open_door(0x30)
	open_door(0x31)

	wait_until(344, 0x64)
	play_sound(0x0161, CHANNEL_10)

	wait_until(380, 0x66)
	speak(CHR_P1P2, L_LIP(100), 0x7433, CHANNEL_7, COLOR_09_BLUE) // "Put your hands up and step away from the alien."

	wait_until(390, 0x68)
	play_sound(0x0162, CHANNEL_10)

	wait_until(460, 0x69)
	play_sound(0x0163, CHANNEL_10)

	wait_until(500, 0x74)

	wait_until(514, 0x6a)
	play_sound(0x0164, CHANNEL_10)

	wait_until(580, 0x6c)
	speak(CHR_P1P2, L_LIP(102), 0x7435, CHANNEL_7, COLOR_09_BLUE) // "Don't make me tell you again, Doctor. And turn tha..."

	wait_until(588, 0x6b)
	play_sound(0x0161, CHANNEL_10)

	wait_until(606, 0x6d)
	play_sound(0x0163, CHANNEL_10)

	wait_until(612, 0x6e)
	play_sound(0x0164, CHANNEL_10)

	wait_until(618, 0x6f)
	play_sound(0x0162, CHANNEL_10)

	wait_until(656, 0x70)
	play_sound(0x0163, CHANNEL_10)

	wait_until(720, 0x71)
	play_sound(0x0164, CHANNEL_10)

	wait_until(786, 0x72)
	play_sound(0x0163, CHANNEL_10)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x8b)

		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x8b)
		label(0x2d)
	endloop(0x08)

	label(0x8b)
	mute_channel(CHANNEL_10)
	restart_default_music
	reset_ambience
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1002_intro[] = {
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_RESCUE_INTRO)
	camera_movement(0x01c6)
	cmd0175(60)

	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x01c8, -1, -1, 0x06, 0x00, CHR_BOND, 4)

	set_chr_chrflag(CHR_JONATHAN, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_JONATHAN, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_JONATHAN, CHRHFLAG_00020000)
	chr_do_animation(0x01c7, -1, -1, 0x06, 0x00, CHR_JONATHAN, 4)

	set_chr_chrflag(CHR_INTRO_DEAD_GUARD, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_INTRO_DEAD_GUARD, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_INTRO_DEAD_GUARD, CHRHFLAG_00020000)
	chr_do_animation(0x01c9, -1, -1, 0x06, 0x00, CHR_INTRO_DEAD_GUARD, 4)

	set_object_flag2(OBJ_CRATE, OBJFLAG2_04000000)
	set_object_flag3(OBJ_CRATE, OBJFLAG3_00000010)
	object_do_animation(0x01ca, OBJ_CRATE, 0x04, 0xffff)

	restart_timer
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 90)
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_FALCON2_SILENCER, WEAPON_NONE)

	wait_until(62, 0x67)
	play_sound(0x0161, CHANNEL_10)

	wait_until(90, 0x64)
	speak(CHR_BOND, L_LIP(90), 0x7429, CHANNEL_5, COLOR_03_RED) // "The problem you have is that there is no way to sn..."

	wait_until(108, 0x66)
	play_sound(0x0162, CHANNEL_10)

	wait_until(686, 0x68)
	play_sound(0x0163, CHANNEL_10)

	wait_until(738, 0x69)
	play_sound(0x0164, CHANNEL_10)

	wait_until(782, 0x6a)
	play_sound(0x0161, CHANNEL_10)

	wait_until(810, 0x6b)
	speak(CHR_BOND, L_LIP(91), 0x742a, CHANNEL_5, COLOR_09_BLUE) // "Doesn't sound like a problem to me. Where are thes..."

	wait_until(1104, 0x6c)
	speak(CHR_BOND, L_LIP(92), 0x742b, CHANNEL_5, COLOR_03_RED) // "In that crate."

	wait_until(1186, 0x6d)
	play_sound(0x0162, CHANNEL_10)

	wait_until(1222, 0x6e)
	play_sound(0x0163, CHANNEL_10)

	wait_until(1246, 0x6f)
	play_sound(0x0163, CHANNEL_10)

	wait_until(1316, 0x70)
	play_sound(0x01dc, CHANNEL_10)

	wait_until(1346, 0x71)
	assign_sound(0x8169, CHANNEL_1)
	control_sound_from_object(CHANNEL_1, OBJ_CRATE, TRUE)

	wait_until(1390, 0x72)
	speak(CHR_BOND, L_LIP(93), 0x742c, CHANNEL_5, COLOR_09_BLUE) // "Cute. Very cute."

	wait_until(1440, 0x73)
	play_sound(0x0161, CHANNEL_10)

	wait_until(1492, 0x74)
	play_sound(0x0162, CHANNEL_10)

	wait_until(1584, 0x75)
	play_sound(0x0163, CHANNEL_10)

	wait_until(1597, 0x76)
	speak(CHR_BOND, L_LIP(94), 0x742d, CHANNEL_5, COLOR_03_RED) // "By the way, the stores are crawling with guards. I..."

	wait_until(1628, 0x77)
	play_sound(0x0161, CHANNEL_10)

	wait_until(1658, 0x78)
	play_sound(0x0162, CHANNEL_10)

	wait_until(1724, 0x79)
	play_sound(0x0163, CHANNEL_10)

	wait_until(1792, 0x7a)
	play_sound(0x0164, CHANNEL_10)

	wait_until(1866, 0x7b)
	play_sound(0x0163, CHANNEL_10)

	wait_until(1906, 0x7c)
	play_sound(0x0161, CHANNEL_10)

	wait_until(2024, 0x7d)
	play_sound(0x0162, CHANNEL_10)

	wait_until(2017, 0x7e)
	speak(CHR_BOND, L_LIP(95), 0x742e, CHANNEL_5, COLOR_09_BLUE) // "Certainly. Any other pearls of wisdom?"

	wait_until(2275, 0x7f)
	speak(CHR_BOND, L_LIP(96), 0x742f, CHANNEL_5, COLOR_03_RED) // "That crate..."

	wait_until(2338, 0x80)
	speak(CHR_BOND, L_LIP(97), 0x7430, CHANNEL_5, COLOR_09_BLUE) // "Yes?"

	wait_until(2409, 0x81)
	speak(CHR_BOND, L_LIP(98), 0x7431, CHANNEL_5, COLOR_03_RED) // "It really doesn't like being shot."

	wait_until(2440, 0x65)
	open_door(0x33)
	open_door(0x34)

	wait_until(2648, 0x82)
	play_sound(0x0172, CHANNEL_10)

	wait_until(2680, 0x83)
	speak(CHR_BOND, L_LIP(99), 0x7432, CHANNEL_5, COLOR_09_BLUE) // "Great. Now, if I can just fight the urge to report..."

	wait_until(2690, 0x84)
	play_sound(0x0173, CHANNEL_10)

	wait_until(2986, 0x85)
	play_sound(0x0161, CHANNEL_10)

	wait_until(3048, 0x86)
	play_sound(0x0162, CHANNEL_10)

	wait_until(3104, 0x87)
	play_sound(0x0163, CHANNEL_10)

	wait_until(3152, 0x88)
	play_sound(0x0164, CHANNEL_10)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2d)
		goto_next(0x8b)

		label(0x2d)
		if_controller_button_pressed(/*goto*/ 0x8b)
		label(0x2d)
	endloop(0x08)

	label(0x8b)
	mute_channel(CHANNEL_10)
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_1)
	assign_sound(0x8169, CHANNEL_1)
	control_sound_from_object(CHANNEL_1, OBJ_CRATE, TRUE)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x01c8, -2, -1, 0x06, 0x00, CHR_BOND, 2)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_JONATHAN, CHRCFLAG_UNPLAYABLE)
	remove_chr(CHR_JONATHAN)
	unset_chr_chrflag(CHR_INTRO_DEAD_GUARD, CHRCFLAG_UNPLAYABLE)
	set_chr_chrflag(CHR_INTRO_DEAD_GUARD, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_hiddenflag(CHR_INTRO_DEAD_GUARD, CHRHFLAG_00020000)
	chr_do_animation(0x01c9, -2, -1, 0x06, 0x00, CHR_INTRO_DEAD_GUARD, 2)
	mute_channel(CHANNEL_10)
	unset_object_flag2(OBJ_CRATE, OBJFLAG2_04000000)
	set_object_flag3(OBJ_CRATE, OBJFLAG3_00000010)
	object_do_animation(0x01ca, OBJ_CRATE, 0x01, 0xfffe)
	close_door(0x33)
	close_door(0x34)
	restart_default_music
	reset_ambience
	enter_firstperson
	yield
	set_chr_chrflag(CHR_INTRO_DEAD_GUARD, CHRCFLAG_00010000)
	chr_do_animation(0x01c9, 2, 3, 0x06, 0x00, CHR_INTRO_DEAD_GUARD, 2)
	set_ailist(CHR_INTRO_DEAD_GUARD, GAILIST_IDLE)
	yield
	kill(CHR_INTRO_DEAD_GUARD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1024_noop[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_LIGHT_VIRUS_DONE, TRUE, /*goto*/ 0x03)
	endloop(0x04)

	label(0x03)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * Disable chrs, wait until player has keycard, then activate them.
 * Most likely guards in the final corridor.
 */
u8 func1025_toggle_guards[] = {
	set_chr_chrflag(0x33, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x34, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x33, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x34, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x37, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x2c, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x2d, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x2e, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x37, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x2c, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x2d, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x2e, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x2f, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x30, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x31, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x32, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x2f, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x30, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x31, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x32, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)

	beginloop(0x08)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_has_object(CHR_P1P2, OBJ_KEYCARD, /*goto*/ 0x2d)
	endloop(0x08)

	label(0x2d)
	unset_chr_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISED)
	unset_chr_chrflag(0x33, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x34, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x33, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x34, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x33, AILIST_BIOTECH_GUARD_ALERTED)
	set_ailist(0x34, AILIST_BIOTECH_GUARD_ALERTED)
	unset_chr_chrflag(0x37, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x2c, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x2d, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x2e, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x37, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x2c, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x2d, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x2e, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x37, AILIST_SUPERDRAGON_GUARD)
	set_ailist(0x2c, AILIST_SUPERDRAGON_GUARD)
	set_ailist(0x2d, AILIST_SUPERDRAGON_GUARD)
	set_ailist(0x2e, AILIST_SUPERDRAGON_GUARD)
	unset_chr_chrflag(0x2f, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x30, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x31, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x32, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x2f, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x30, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x31, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	unset_chr_chrflag(0x32, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(0x2f, AILIST_BIOTECH_GUARD)
	set_ailist(0x30, AILIST_SUPERDRAGON_GUARD)
	set_ailist(0x31, AILIST_SUPERDRAGON_GUARD)
	set_ailist(0x32, AILIST_SUPERDRAGON_GUARD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0429_spawn_while_xraying[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(8)
	set_reaction_speed(35)
	set_chr_maxdamage(CHR_SELF, 50)
	add_health_or_armor(0)
	set_recovery_speed(35)
	set_shield(0)
	set_self_chrflag(CHRCFLAG_00000002)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_00040000)
	restart_timer

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_has_hiddenflag(CHR_P1P2, CHRHFLAG_DISGUISED, /*goto*/ 0x0d)
		if_timer_gt(1800, /*goto*/ 0x2d)
		reloop(0x04)

		// 30 seconds passed and not disguised
		label(0x2d)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_has_hiddenflag(CHR_P1P2, CHRHFLAG_DISGUISED, /*goto*/ 0x0d)

		// Xray area
		if_chr_in_room(CHR_P1P2, 0x00, 0x010d, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0102, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0103, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0104, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0105, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0106, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0107, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0108, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0109, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x010c, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00fa, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00fb, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00fc, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00fd, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00fe, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x00ff, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0100, /*goto*/ 0x06)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0101, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		dprint 'O','B','J','E','C','T','I','V','E',' ','D','O','N','E','\n',0,
		label(0x4e)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x4e)
		reloop(0x04)

		label(0x4e)
		try_spawn_clone2(CHR_SELF, 0x042a, 0x00000000, /*goto*/ 0x2d)
		label(0x2d)
		restart_timer
		yield
	endloop(0x04)

	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func042a_init_xray_clone[] = {
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	label(0x04)
	rebuild_teams
	rebuild_squadrons
	try_inherit_properties(0x47, /*goto*/ 0x06)
	label(0x06)
	set_ailist(CHR_SELF, 0x042b)
	endlist
};

u8 func042b_xray_clone[] = {
	set_target_chr(CHR_BOND)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

u8 func042c_dragon_guard[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(8)
	set_reaction_speed(35)
	set_chr_maxdamage(CHR_SELF, 50)
	add_health_or_armor(0)
	set_recovery_speed(35)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func042d_superdragon_guard[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(10)
	set_reaction_speed(35)
	set_chr_maxdamage(CHR_SELF, 80)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func042e_biotech_guard[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(18)
	set_reaction_speed(35)
	set_chr_maxdamage(CHR_SELF, 80)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func042e_biotech_guard_alerted[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(18)
	set_reaction_speed(35)
	set_chr_maxdamage(CHR_SELF, 80)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_target_chr(CHR_BOND)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

u8 func142d_start_lifts[] = {
	activate_lift(1, 0x35)
	activate_lift(4, 0x38)
	activate_lift(5, 0x39)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1027_check_disguise_worn[] = {
	beginloop(0x04)
		if_chr_has_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISED, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	show_hudmsg(CHR_BOND, L_LIP(77)) // "Disguise has been worn."
	set_returnlist(0x00, 0x0401)
	set_returnlist(0x01, 0x0402)
	set_returnlist(0x02, 0x0403)
	set_returnlist(0x03, 0x0404)
	set_returnlist(0x04, 0x0405)
	set_returnlist(0x05, AILIST_DRAGON_GUARD)
	set_returnlist(0x06, AILIST_DRAGON_GUARD)
	set_returnlist(0x07, AILIST_DRAGON_GUARD)
	set_returnlist(0x08, AILIST_DRAGON_GUARD)
	set_returnlist(0x09, AILIST_DRAGON_GUARD)
	set_returnlist(0x0a, AILIST_DRAGON_GUARD)
	set_returnlist(0x0b, AILIST_DRAGON_GUARD)
	set_returnlist(0x0c, 0x0406)
	set_returnlist(0x0d, 0x0406)
	set_returnlist(0x0e, 0x0406)
	set_returnlist(0x0f, 0x0407)
	set_returnlist(0x10, 0x0408)
	set_returnlist(0x11, AILIST_DRAGON_GUARD)
	set_returnlist(0x27, AILIST_DRAGON_GUARD)
	set_returnlist(0x28, AILIST_DRAGON_GUARD)
	set_returnlist(0x12, AILIST_DRAGON_GUARD)
	set_returnlist(0x13, AILIST_DRAGON_GUARD)
	set_returnlist(0x14, 0x0409)
	set_returnlist(0x15, 0x040a)
	set_returnlist(0x16, AILIST_DRAGON_GUARD)
	set_returnlist(0x17, AILIST_DRAGON_GUARD)
	set_returnlist(0x18, AILIST_DRAGON_GUARD)
	set_returnlist(0x1e, AILIST_DRAGON_GUARD)
	set_returnlist(0x19, AILIST_DRAGON_GUARD)
	set_returnlist(0x1a, AILIST_DRAGON_GUARD)
	set_returnlist(0x1d, AILIST_DRAGON_GUARD)
	set_returnlist(0x1b, 0x040b)
	set_returnlist(0x1c, 0x040c)
	set_returnlist(0x1f, AILIST_DRAGON_GUARD)
	set_returnlist(0x20, AILIST_DRAGON_GUARD)
	set_returnlist(0x21, AILIST_DRAGON_GUARD)
	set_returnlist(0x22, AILIST_DRAGON_GUARD)
	set_ailist(0x00, AILIST_BECOME_UNAWARE)
	set_ailist(0x01, AILIST_BECOME_UNAWARE)
	set_ailist(0x02, AILIST_BECOME_UNAWARE)
	set_ailist(0x03, AILIST_BECOME_UNAWARE)
	set_ailist(0x04, AILIST_BECOME_UNAWARE)
	set_ailist(0x05, AILIST_BECOME_UNAWARE)
	set_ailist(0x06, AILIST_BECOME_UNAWARE)
	set_ailist(0x07, AILIST_BECOME_UNAWARE)
	set_ailist(0x08, AILIST_BECOME_UNAWARE)
	set_ailist(0x09, AILIST_BECOME_UNAWARE)
	set_ailist(0x0a, AILIST_BECOME_UNAWARE)
	set_ailist(0x0b, AILIST_BECOME_UNAWARE)
	set_ailist(0x0c, AILIST_BECOME_UNAWARE)
	set_ailist(0x0d, AILIST_BECOME_UNAWARE)
	set_ailist(0x0e, AILIST_BECOME_UNAWARE)
	set_ailist(0x0f, AILIST_BECOME_UNAWARE)
	set_ailist(0x10, AILIST_BECOME_UNAWARE)
	set_ailist(0x11, AILIST_BECOME_UNAWARE)
	set_ailist(0x27, AILIST_BECOME_UNAWARE)
	set_ailist(0x28, AILIST_BECOME_UNAWARE)
	set_ailist(0x12, AILIST_BECOME_UNAWARE)
	set_ailist(0x13, AILIST_BECOME_UNAWARE)
	set_ailist(0x14, AILIST_BECOME_UNAWARE)
	set_ailist(0x15, AILIST_BECOME_UNAWARE)
	set_ailist(0x16, AILIST_BECOME_UNAWARE)
	set_ailist(0x17, AILIST_BECOME_UNAWARE)
	set_ailist(0x18, AILIST_BECOME_UNAWARE)
	set_ailist(0x1e, AILIST_BECOME_UNAWARE)
	set_ailist(0x19, AILIST_BECOME_UNAWARE)
	set_ailist(0x1a, AILIST_BECOME_UNAWARE)
	set_ailist(0x1d, AILIST_BECOME_UNAWARE)
	set_ailist(0x1b, AILIST_BECOME_UNAWARE)
	set_ailist(0x1c, AILIST_BECOME_UNAWARE)
	set_ailist(0x1f, AILIST_BECOME_UNAWARE)
	set_ailist(0x20, AILIST_BECOME_UNAWARE)
	set_ailist(0x21, AILIST_BECOME_UNAWARE)
	set_ailist(0x22, AILIST_BECOME_UNAWARE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1028_toggle_mechanic[] = {
	if_savefile_flag_is_set(SAVEFILEFLAG_RESCUE_MECHANIC_DEAD, /*goto*/ 0x06)
	dprint 'K','E','E','P',' ','M','E','C','H','\n',0,
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	dprint 'D','E','L','E','T','E',' ','M','E','C','H','\n',0,
	hide_chr(CHR_MECHANIC)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1029_msg_showers[] = {
	beginloop(0x04)
		if_chr_in_room(CHR_BOND, 0x00, 0x00a9, /*goto*/ 0x2d)
		if_chr_in_room(CHR_BOND, 0x00, 0x00aa, /*goto*/ 0x2d)
		if_chr_in_room(CHR_BOND, 0x00, 0x00a9, /*goto*/ 0x2d)
		if_chr_in_room(CHR_BOND, 0x00, 0x00bc, /*goto*/ 0x2d)
		if_chr_in_room(CHR_BOND, 0x00, 0x009b, /*goto*/ 0x2d)
		if_chr_in_room(CHR_BOND, 0x00, 0x00b5, /*goto*/ 0x2d)
		if_chr_in_room(CHR_BOND, 0x00, 0x00ad, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	speak(CHR_BOND, L_LIP(78), 0x73bc, CHANNEL_6, COLOR_09_BLUE) // "The showers... Now, if I can convince someone to p..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102a_msg_temperaturedropping[] = {
	restart_timer

	beginloop(0x04)
		if_chr_in_room(CHR_BOND, 0x00, 0x010a, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	speak(CHR_BOND, L_LIP(79), 0x8180, CHANNEL_6, COLOR_09_BLUE) // "The temperature's dropping... You must be close to..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102b_msg_airrecycled[] = {
	beginloop(0x04)
		if_chr_in_room(CHR_BOND, 0x00, 0x007f, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	speak(CHR_BOND, L_LIP(80), 0x73be, CHANNEL_6, COLOR_09_BLUE) // "The air's heavily recycled around here - must be n..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102c_msg_hurry[] = {
	beginloop(0x04)
		if_chr_in_room(CHR_BOND, 0x00, 0x0093, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	speak(CHR_BOND, L_LIP(81), 0x8181, CHANNEL_6, COLOR_09_BLUE) // "There he is, Jo! Hurry or you'll be too late!"
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * This function is run on many guards when Jo puts on the disguise.
 */
u8 func0416_become_unaware[] = {
	set_chr_hiddenflag(CHR_SELF, CHRHFLAG_00002000)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x0f)
	if_chr_dying(CHR_SELF, /*goto*/ 0x0f)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x0f)
	if_chr_sees_player(/*goto*/ 0x2d)
	set_alertness(0)
	return

	label(0x2d)
	set_target_chr(CHR_BOND)
	set_ailist(CHR_SELF, GAILIST_ALERTED)

	// Dying/dead
	label(0x0f)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 unregistered_function2[] = {
	set_object_flag(OBJ_WALL, OBJFLAG_INVINCIBLE)

	beginloop(0x04)
		if_object_in_good_condition(OBJ_CRATE, /*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
	endloop(0x04)

	// Crate destroyed
	label(0x06)
	unset_object_flag(OBJ_WALL, OBJFLAG_INVINCIBLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102f_shuffle_disguise[] = {
	yield
	yield
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x0c)
	call_rng
	if_rand_lt(51, /*goto*/ 0x08)
	if_rand_lt(102, /*goto*/ 0x09)
	if_rand_lt(153, /*goto*/ 0x0a)
	if_rand_lt(204, /*goto*/ 0x0b)

	// Rand >= 204 (52 out of 256 chance)
	hide_object(OBJ_LABCOAT1)
	hide_object(OBJ_LABCOAT2)
	hide_object(OBJ_LABCOAT3)
	hide_object(OBJ_LABCOAT4)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Rand < 51 (51 out of 256 chance)
	label(0x08)
	hide_object(OBJ_LABCOAT2)
	hide_object(OBJ_LABCOAT3)
	hide_object(OBJ_LABCOAT4)
	hide_object(OBJ_LABCOAT5)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Rand >= 51 and < 102 (51 out of 256 chance)
	label(0x09)
	hide_object(OBJ_LABCOAT1)
	hide_object(OBJ_LABCOAT3)
	hide_object(OBJ_LABCOAT4)
	hide_object(OBJ_LABCOAT5)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Rand >= 102 and < 153 (51 out of 256 chance)
	label(0x0a)
	hide_object(OBJ_LABCOAT1)
	hide_object(OBJ_LABCOAT2)
	hide_object(OBJ_LABCOAT4)
	hide_object(OBJ_LABCOAT5)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Rand >= 153 and < 204 (51 out of 256 chance)
	label(0x0b)
	hide_object(OBJ_LABCOAT1)
	hide_object(OBJ_LABCOAT2)
	hide_object(OBJ_LABCOAT3)
	hide_object(OBJ_LABCOAT5)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// A and SA
	label(0x0c)
	give_object_to_chr(OBJ_LABCOAT1, CHR_LABTECH_SHOWERS)
	hide_object(OBJ_LABCOAT2)
	hide_object(OBJ_LABCOAT3)
	hide_object(OBJ_LABCOAT4)
	hide_object(OBJ_LABCOAT5)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Unreachable
	label(0x0d)
	hide_object(OBJ_LABCOAT1)
	hide_object(OBJ_LABCOAT2)
	hide_object(OBJ_LABCOAT4)
	hide_object(OBJ_LABCOAT5)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1030_lift_door_sounds[] = {
	beginloop(0x5e)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, 0x46, /*goto*/ 0x2d)
		if_chr_activated_object(CHR_P1P2, 0x47, /*goto*/ 0x2d)
		if_chr_activated_object(CHR_P1P2, 0x48, /*goto*/ 0x2d)
		if_chr_activated_object(CHR_P1P2, 0x49, /*goto*/ 0x2d)
		reloop(0x5e)

		label(0x2d)
		play_sound(0x81b0, -1)
		restart_timer

		beginloop(0x08)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x08)

		label(0x06)
	endloop(0x5e)

	endlist
};

u8 func1031_toggle_doorman[] = {
	yield
	set_chr_chrflag(CHR_DOORMAN, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_DOORMAN, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)

	beginloop(0x5e)
		label(0x2d)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x2d)
		if_objective_complete(0, /*goto*/ 0x2d)
		goto_first(0x5e)

		label(0x2d)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x2d)
		if_objective_complete(1, /*goto*/ 0x2d)
	endloop(0x5e)

	label(0x2d)
	unset_chr_chrflag(CHR_DOORMAN, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_DOORMAN, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1032_count_last_room_guards[] = {
	beginloop(0x04)
		set_morale(0)
		if_chr_dying(0x23, /*goto*/ 0x2d)
		if_chr_death_animation_finished(0x23, /*goto*/ 0x2d)
		if_chr_unloaded(0x23, /*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
		add_morale(1)
		label(0x06)
		if_chr_dying(0x24, /*goto*/ 0x2d)
		if_chr_death_animation_finished(0x24, /*goto*/ 0x2d)
		if_chr_unloaded(0x24, /*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
		add_morale(1)
		label(0x06)
		if_chr_dying(0x25, /*goto*/ 0x2d)
		if_chr_death_animation_finished(0x25, /*goto*/ 0x2d)
		if_chr_unloaded(0x25, /*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
		add_morale(1)
		label(0x06)
		if_chr_dying(0x26, /*goto*/ 0x2d)
		if_chr_death_animation_finished(0x26, /*goto*/ 0x2d)
		if_chr_unloaded(0x26, /*goto*/ 0x2d)
		goto_next(0x06)

		label(0x2d)
		add_morale(1)
		label(0x06)
		if_morale_lt(3, /*goto*/ 0x2d)
		set_stage_flag(STAGEFLAG_ONE_KEYCARD_GUARD_REMAINING)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x2d)
	endloop(0x04)

	endlist
};

/**
 * Not really sure what the point of this is.
 */
u8 func1033_update_buddy_placed_flag[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_has_hiddenflag(CHR_P1P2, CHRHFLAG_BUDDY_PLACED, /*goto*/ 0x2d)
	endloop(0x04)

	label(0x2d)
	restart_timer

	beginloop(0x64)
		if_timer_gt(600, /*goto*/ 0x2d)
	endloop(0x64)

	label(0x2d)
	unset_chr_hiddenflag(CHR_P1P2, CHRHFLAG_BUDDY_PLACED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1034_setup_rtracker[] = {
	yield
	set_object_flag3(OBJ_FALCON2SILENCED1, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(OBJ_FALCON2SILENCED2, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(OBJ_PHOENIX, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1435_setup_lighting[] = {
	yield
	misc_command(0x007c, 0x05, 0x01)
	misc_command(0x007d, 0x05, 0x01)
	misc_command(0x007e, 0x05, 0x01)
	misc_command(0x007f, 0x05, 0x01)
	misc_command(0x0080, 0x05, 0x01)
	misc_command(0x0081, 0x05, 0x01)
	misc_command(0x0082, 0x05, 0x01)
	misc_command(0x0083, 0x05, 0x01)
	misc_command(0x0084, 0x05, 0x01)
	misc_command(0x0085, 0x05, 0x01)
	misc_command(0x0086, 0x05, 0x01)
	misc_command(0x0087, 0x05, 0x01)
	misc_command(0x0088, 0x05, 0x01)
	misc_command(0x0089, 0x05, 0x01)
	misc_command(0x008a, 0x05, 0x01)
	misc_command(0x008b, 0x05, 0x01)
	misc_command(0x008c, 0x05, 0x01)
	misc_command(0x008d, 0x05, 0x01)
	misc_command(0x008e, 0x05, 0x01)
	misc_command(0x008f, 0x05, 0x01)
	misc_command(0x0090, 0x05, 0x01)
	misc_command(0x0091, 0x05, 0x01)
	misc_command(0x0092, 0x05, 0x01)
	misc_command(0x0093, 0x05, 0x01)
	misc_command(0x0094, 0x05, 0x01)
	misc_command(0x0095, 0x05, 0x01)
	misc_command(0x0096, 0x05, 0x01)
	misc_command(0x0097, 0x05, 0x01)
	misc_command(0x0098, 0x05, 0x01)
	misc_command(0x0099, 0x05, 0x01)
	misc_command(0x009a, 0x05, 0x01)
	misc_command(0x009b, 0x05, 0x01)
	misc_command(0x00a5, 0x05, 0x01)
	misc_command(0x00a6, 0x05, 0x01)
	misc_command(0x00a7, 0x05, 0x01)
	misc_command(0x00a8, 0x05, 0x01)
	misc_command(0x00a9, 0x05, 0x01)
	misc_command(0x00aa, 0x05, 0x01)
	misc_command(0x00ab, 0x05, 0x01)
	misc_command(0x00ac, 0x05, 0x01)
	misc_command(0x00ad, 0x05, 0x01)
	misc_command(0x00ae, 0x05, 0x01)
	misc_command(0x00af, 0x05, 0x01)
	misc_command(0x00b0, 0x05, 0x01)
	misc_command(0x00b1, 0x05, 0x01)
	misc_command(0x00b3, 0x05, 0x01)
	misc_command(0x00b4, 0x05, 0x01)
	misc_command(0x00b5, 0x05, 0x01)
	misc_command(0x00b6, 0x05, 0x01)
	misc_command(0x00b7, 0x05, 0x01)
	misc_command(0x00b8, 0x05, 0x01)
	misc_command(0x00b9, 0x05, 0x01)
	misc_command(0x00ba, 0x05, 0x01)
	misc_command(0x00bb, 0x05, 0x01)
	misc_command(0x00bc, 0x05, 0x01)
	misc_command(0x00be, 0x05, 0x01)
	misc_command(0x00bf, 0x05, 0x01)
	misc_command(0x00c0, 0x05, 0x01)
	misc_command(0x00c1, 0x05, 0x01)
	misc_command(0x00c2, 0x05, 0x01)
	misc_command(0x00c3, 0x05, 0x01)
	misc_command(0x00c4, 0x05, 0x01)
	misc_command(0x00c5, 0x05, 0x01)
	misc_command(0x00c6, 0x05, 0x01)
	misc_command(0x00c7, 0x05, 0x01)
	misc_command(0x00c8, 0x05, 0x01)
	misc_command(0x00c9, 0x05, 0x01)
	misc_command(0x00ca, 0x05, 0x01)
	misc_command(0x00cb, 0x05, 0x01)
	misc_command(0x00f2, 0x05, 0x01)
	misc_command(0x00fa, 0x05, 0x01)
	misc_command(0x00fb, 0x05, 0x01)
	misc_command(0x00fc, 0x05, 0x01)
	misc_command(0x00fd, 0x05, 0x01)
	misc_command(0x00fe, 0x05, 0x01)
	misc_command(0x00ff, 0x05, 0x01)
	misc_command(0x0100, 0x05, 0x01)
	misc_command(0x0101, 0x05, 0x01)
	misc_command(0x0102, 0x05, 0x01)
	misc_command(0x0103, 0x05, 0x01)
	misc_command(0x0104, 0x05, 0x01)
	misc_command(0x0105, 0x05, 0x01)
	misc_command(0x0106, 0x05, 0x01)
	misc_command(0x0107, 0x05, 0x01)
	misc_command(0x0108, 0x05, 0x01)
	misc_command(0x0109, 0x05, 0x01)
	misc_command(0x010a, 0x05, 0x01)
	misc_command(0x010b, 0x05, 0x01)
	misc_command(0x010c, 0x05, 0x01)
	misc_command(0x010d, 0x05, 0x01)
	misc_command(0x010e, 0x05, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0432_init_biotech1[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_ailist(CHR_SELF, AILIST_BIOTECH1)
	endlist
};

u8 func0433_init_biotech2[] = {
	set_self_chrflag(CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_self_chrflag(CHRCFLAG_UNEXPLODABLE)
	set_ailist(CHR_SELF, AILIST_BIOTECH2)
	endlist
};

u8 func0430_biotech2[] = {
	label(0x0b)
		call_rng
		if_rand_gt(85, /*goto*/ 0x62)
		if_rand_gt(170, /*goto*/ 0x63)

		chr_do_animation(ANIM_OPERATE_0221, 0, -1, 0x10, 0x00, CHR_SELF, 2)
		goto_next(0x04)

		label(0x62)
		chr_do_animation(ANIM_OPERATE_0222, 0, -1, 0x10, 0x00, CHR_SELF, 2)
		goto_next(0x04)

		label(0x63)
		chr_do_animation(ANIM_OPERATE_0223, 0, -1, 0x10, 0x00, CHR_SELF, 2)
		goto_next(0x04)

		beginloop(0x04)
			if_chr_stopped(/*goto*/ 0x2d)
		endloop(0x04)

		label(0x2d)
	goto_first(0x0b)

	endlist
};

u8 func0431_biotech1[] = {
	label(0x0b)
		call_rng
		if_rand_gt(85, /*goto*/ 0x62)
		if_rand_gt(170, /*goto*/ 0x63)

		chr_do_animation(ANIM_OPERATE_0204, 0, -1, 0x10, 0x00, CHR_SELF, 2)
		goto_next(0x04)

		label(0x62)
		chr_do_animation(ANIM_OPERATE_0205, 0, -1, 0x10, 0x00, CHR_SELF, 2)
		goto_next(0x04)

		label(0x63)
		chr_do_animation(ANIM_OPERATE_0206, 0, -1, 0x10, 0x00, CHR_SELF, 2)
		goto_next(0x04)

		beginloop(0x04)
			if_chr_stopped(/*goto*/ 0x2d)
		endloop(0x04)

		label(0x2d)
	goto_first(0x0b)

	endlist
};

u8 func1036_check_door_terminal_destroyed[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2e)

	beginloop(0x0b)
		if_object_in_good_condition(OBJ_DOOR_TERMINAL, /*goto*/ 0x2d)
		if_stage_flag_eq(STAGEFLAG_DOOR_VIRUS_DOWNLOADED, TRUE, /*goto*/ 0x2e)
		show_hudmsg(CHR_BOND, L_LIP(68)) // "Mission critical equipment destroyed."
		set_stage_flag(STAGEFLAG_UPLINK_TERMINAL_DESTROYED)
		label(0x2e)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		label(0x2d)
	endloop(0x0b)

	endlist
};

struct ailist ailists[] = {
	{ func1400_give_datauplinks,               0x1400 },
	{ func1001_objectives_failed_msg,          0x1001 },
	{ func1002_intro,                          0x1002 },
	{ func1003_uplink_doors,                   0x1003 },
	{ func1004_uplink_lights,                  0x1004 },
	{ func1005_uplink_autoguns,                0x1005 },
	{ func1006_check_lab_accessed,             0x1006 },
	{ func1007_check_disguise_collected,       0x1007 },
	{ func1009_disguise_timer,                 0x1009 },
	{ func100a_random_doors,                   0x100a },
	{ func100b_check_doorman_dead,             0x100b },
	{ func100c_keycardguy_lights,              0x100c },
	{ func100d_check_entered_lab,              0x100d },
	{ func100e_elvis_timer,                    0x100e },
	{ func100f_check_end_level,                0x100f },
	{ func1010_give_keycard,                   0x1010 },
	{ func1011_unhide_warehouse_spawner,       0x1011 },
	{ func1013_check_chamber_switch_destroyed, 0x1013 },
	{ func1014_check_crate_destroyed,          0x1014 },
	{ func1016_check_undisguised,              0x1016 },
	{ func1017_activate_autogun,               0x1017 },
	{ func1018_disable_chambers,               0x1018 },
	{ func1019_chamber1,                       0x1019 },
	{ func101a_chamber2,                       0x101a },
	{ func101b_chamber3,                       0x101b },
	{ func101c_chamber4,                       0x101c },
	{ func101d_chamber5,                       0x101d },
	{ func101e_chamber6,                       0x101e },
	{ func101f_chamber7,                       0x101f },
	{ func1020_chamber8,                       0x1020 },
	{ func1021_xray_scanning,                  0x1021 },
	{ func1023_setup_door_locks,               0x1023 },
	{ func1024_noop,                           0x1024 },
	{ func1025_toggle_guards,                  0x1025 },
	{ func1026_check_records_destroyed,        0x1026 },
	{ func1027_check_disguise_worn,            0x1027 },
	{ func1028_toggle_mechanic,                0x1028 },
	{ func1029_msg_showers,                    0x1029 },
	{ func102a_msg_temperaturedropping,        0x102a },
	{ func102b_msg_airrecycled,                0x102b },
	{ func102c_msg_hurry,                      0x102c },
	{ func142d_start_lifts,                    0x142d },
	{ func102f_shuffle_disguise,               0x102f },
	{ func1030_lift_door_sounds,               0x1030 },
	{ func1031_toggle_doorman,                 0x1031 },
	{ func1032_count_last_room_guards,         0x1032 },
	{ func1033_update_buddy_placed_flag,       0x1033 },
	{ func1034_setup_rtracker,                 0x1034 },
	{ func1435_setup_lighting,                 0x1435 },
	{ func1036_check_door_terminal_destroyed,  0x1036 },
	{ func1002_intro,                          0x0c00 },
	{ func0c01_outro,                          0x0c01 },
	{ func0401_start_path00,                   0x0401 },
	{ func0402_start_path01,                   0x0402 },
	{ func0403_start_path02,                   0x0403 },
	{ func0404_start_path03,                   0x0404 },
	{ func0405_start_path04,                   0x0405 },
	{ func0406_start_path05,                   0x0406 },
	{ func0407_start_path06,                   0x0407 },
	{ func0408_start_path07,                   0x0408 },
	{ func0409_start_path08,                   0x0409 },
	{ func040a_start_path09,                   0x040a },
	{ func040b_start_path10,                   0x040b },
	{ func040c_start_path11,                   0x040c },
	{ func040d_start_path12,                   0x040d },
	{ func040e_start_path13,                   0x040e },
	{ func040f_start_path14,                   0x040f },
	{ func0410_labtech_showers_sa_pa,          0x0410 },
	{ func0411_labtech_showers_agent,          0x0411 },
	{ func0412_init_labtech_showers,           0x0412 },
	{ func0413_mechanic,                       0x0413 },
	{ func0414_init_mechanic,                  0x0414 },
	{ func0415_warehouse_spawner,              0x0415 },
	{ func0416_become_unaware,                 0x0416 },
	{ func0429_spawn_while_xraying,            0x0429 },
	{ func042a_init_xray_clone,                0x042a },
	{ func042b_xray_clone,                     0x042b },
	{ func0417_warehouse_clone,                0x0417 },
	{ func0418_doorman,                        0x0418 },
	{ func0419_init_doorman,                   0x0419 },
	{ func041a_labtech_harrysmate,             0x041a },
	{ func041b_labtech_keycardguy,             0x041b },
	{ func041c_unused_041c,                    0x041c },
	{ func041d_unused_041d,                    0x041d },
	{ func041e_unused_041e,                    0x041e },
	{ func041f_labtech_lights,                 0x041f },
	{ func0420_labtech_doors,                  0x0420 },
	{ func0421_init_labtech_doors,             0x0421 },
	{ func0422_labtech_records,                0x0422 },
	{ func0423_init_labtech_records,           0x0423 },
	{ func0424_alien,                          0x0424 },
	{ func0425_hiddenguy,                      0x0425 },
	{ func0426_check_looking_at_alien,         0x0426 },
	{ func0427_shock_clone,                    0x0427 },
	{ func0c01_outro,                          0x0428 },
	{ func042c_dragon_guard,                   0x042c },
	{ func042d_superdragon_guard,              0x042d },
	{ func042e_biotech_guard,                  0x042e },
	{ func042e_biotech_guard_alerted,          0x042f },
	{ func0432_init_biotech1,                  0x0432 },
	{ func0433_init_biotech2,                  0x0433 },
	{ func0430_biotech2,                       0x0430 },
	{ func0431_biotech1,                       0x0431 },
	{ NULL, 0 },
};

struct path paths[] = {
	{ path00, 0, PATHTYPE_BACKANDFORTH },
	{ path01, 1, PATHTYPE_BACKANDFORTH },
	{ path02, 2, PATHTYPE_BACKANDFORTH },
	{ path03, 3, PATHTYPE_BACKANDFORTH },
	{ path04, 4, PATHTYPE_BACKANDFORTH },
	{ path05, 5, PATHTYPE_BACKANDFORTH },
	{ path06, 6, PATHTYPE_BACKANDFORTH },
	{ path07, 7, PATHTYPE_BACKANDFORTH },
	{ path08, 8, PATHTYPE_BACKANDFORTH },
	{ path09, 9, PATHTYPE_BACKANDFORTH },
	{ path10, 10, PATHTYPE_BACKANDFORTH },
	{ path11, 11, PATHTYPE_BACKANDFORTH },
	{ path12, 12, PATHTYPE_BACKANDFORTH },
	{ path13, 13, PATHTYPE_BACKANDFORTH },
	{ path14, 14, PATHTYPE_BACKANDFORTH },
	{ NULL, 0, 0 },
};

