//
// Investigation
//

#include "stagesetup.h"

// Characters
#define CHR_DRCAROLL    0x39
#define CHR_INTRO_GUARD 0x3a
#define CHR_K7_GUARD    0x3b

// Objects
#define OBJ_CACHETERMINAL            0x01
#define OBJ_BOT_ACTIVATION_TERMINAL  0x02
#define OBJ_BOT_PROGRAMMING_TERMINAL 0x03
#define OBJ_K7AVENGER                0x04
#define OBJ_NIGHTVISION              0x05
#define OBJ_SHIELD                   0x06
#define OBJ_GOODTERM1                0x07
#define OBJ_GOODTERM2                0x08
#define OBJ_GOODTERM3                0x09
#define OBJ_UPLINKPC                 0x0a
#define OBJ_ALARMTERM1               0x0f
#define OBJ_ALARMTERM2               0x14
#define OBJ_ALARMTERM3               0x19
#define OBJ_UPLINKDOOR               0x22
#define OBJ_DATAUPLINK_BOND          0x25
#define OBJ_YELLOWBOT                0x37 // opens the secret door
#define OBJ_PURPLEBOT                0x38 // lasers
#define OBJ_HATCHPC                  0x3a
#define OBJ_DATAUPLINK_COOP          0x48
#define OBJ_CACHEDOOR1               0x55
#define OBJ_CACHEDOOR2               0x56
#define OBJ_CMP150_1                 0x57
#define OBJ_CMP150_2                 0x58
#define OBJ_PROXYMINES               0x59

// Stage flags
#define STAGEFLAG_DRCAROLL_LOCATED                   0x00000001
#define STAGEFLAG_UPLINK_SEARCHING                   0x00000002
#define STAGEFLAG_00000004                           0x00000004
#define STAGEFLAG_00000008                           0x00000008
#define STAGEFLAG_TRIGGER_OUTRO_AUDIO                0x00000010
#define STAGEFLAG_HAS_K7AVENGER                      0x00000020
#define STAGEFLAG_HAS_NIGHTVISION                    0x00000040
#define STAGEFLAG_HAS_SHIELD                         0x00000080
#define STAGEFLAG_ITEMS_UNCOLLECTABLE                0x00000100
#define STAGEFLAG_BOT_ACTIVE                         0x00000200
#define STAGEFLAG_BOT_REPROGRAMMED                   0x00000400
#define STAGEFLAG_ALL_ITEMS_COLLECTED                0x00000800
#define STAGEFLAG_UNACCEPTABLE_CASUALTIES            0x00001000
#define STAGEFLAG_CAMSPY_DESTROYED                   0x00002000
#define STAGEFLAG_SHUT_DOWN_EXPERIMENT1              0x00004000
#define STAGEFLAG_SHUT_DOWN_EXPERIMENT2              0x00008000
#define STAGEFLAG_SHUT_DOWN_EXPERIMENT3              0x00010000
#define STAGEFLAG_UPLINK_FINISHED                    0x00020000
#define STAGEFLAG_BOT_ACTIVE_MAINTENANCE             0x00040000
#define STAGEFLAG_BOT_ACTIVATION_TERMINAL_DESTROYED  0x00080000
#define STAGEFLAG_BOT_PROGRAMMING_TERMINAL_DESTROYED 0x00100000
#define STAGEFLAG_ONE_SCIENTIST_DONE                 0x00200000
#define STAGEFLAG_TWO_SCIENTISTS_DONE                0x00400000
#define STAGEFLAG_THREE_SCIENTISTS_DONE              0x00800000
#define STAGEFLAG_ALARM1_ACTIVE                      0x01000000
#define STAGEFLAG_ALARM2_ACTIVE                      0x02000000
#define STAGEFLAG_ALARM3_ACTIVE                      0x04000000
#define STAGEFLAG_ALARM_RESPONDERS_SPAWNED           0x08000000
#define STAGEFLAG_UPLINKPC_DESTROYED                 0x10000000
#define STAGEFLAG_BOT_ACTIVE_CLEANING                0x20000000
#define STAGEFLAG_BOT_ACTIVE_NOPROGRAM               0x40000000
#define STAGEFLAG_GOODTERM_DESTROYED                 0x80000000

// AI Lists
#define AILIST_K7_GUARD             0x0402
#define AILIST_K7_SCIENTIST         0x0403
#define AILIST_SCIENTIST            0x0404
#define AILIST_INIT_SCIENTIST       0x0405
#define AILIST_NASTY_SCIENTIST      0x0406
#define AILIST_INIT_NASTY_SCIENTIST 0x0407
#define AILIST_ALARM_RESPONDER      0x0408
#define AILIST_UPLINK_RESPONDER     0x0409
#define AILIST_INIT_BASIC_GUARD     0x040a
#define AILIST_INIT_SHOCK_GUARD     0x040b
#define AILIST_PATH00               0x040c
#define AILIST_PATH01               0x040d // unused
#define AILIST_PATH02               0x040e
#define AILIST_PATH03               0x040f
#define AILIST_PATH04               0x0410 // unused
#define AILIST_PURPLEBOT_AT_LASERS  0x0413
#define AILIST_RADIOACTIVITY        0x0415
#define AILIST_OUTRO                0x0417

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x1e01)
	briefing(1, 0x1e00)
	briefing(2, 0x1e02)
	briefing(3, 0x1e03)

	beginobjective(0, L_EAR(13), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Holograph radioactive isotope"
		require_object_holographed(0x39, 0, 0)
		fail_flags(STAGEFLAG_CAMSPY_DESTROYED)
	endobjective

	beginobjective(1, L_EAR(11), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Start security maintenance cycle"
		complete_flags(STAGEFLAG_BOT_ACTIVE_MAINTENANCE)
		fail_flags(STAGEFLAG_BOT_ACTIVATION_TERMINAL_DESTROYED)
		fail_flags(STAGEFLAG_BOT_PROGRAMMING_TERMINAL_DESTROYED)
	endobjective

	beginobjective(2, L_EAR(10), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Shut down experiments"
		complete_flags(STAGEFLAG_SHUT_DOWN_EXPERIMENT1)
		complete_flags(STAGEFLAG_SHUT_DOWN_EXPERIMENT2)
		complete_flags(STAGEFLAG_SHUT_DOWN_EXPERIMENT3)
		fail_flags(STAGEFLAG_GOODTERM_DESTROYED)
		fail_flags(STAGEFLAG_UNACCEPTABLE_CASUALTIES)
		fail_flags(STAGEFLAG_00000008)
	endobjective

	beginobjective(3, L_EAR(12), (DIFFBIT_PA | DIFFBIT_PD)) // "Obtain experimental technologies"
		complete_flags(STAGEFLAG_ALL_ITEMS_COLLECTED)
		require_object_collected(OBJ_K7AVENGER)
		require_object_collected(OBJ_NIGHTVISION)
		require_object_collected(OBJ_SHIELD)
	endobjective

	beginobjective(4, L_EAR(9), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Locate Dr. Caroll"
		complete_flags(STAGEFLAG_DRCAROLL_LOCATED)
		fail_flags(STAGEFLAG_UPLINKPC_DESTROYED)
	endobjective

	tag(0x60, 1)
	lift(0x0100, MODEL_LIFT_PLATFORM, 0x025b, 0x835204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x025b, 0x025c, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000b6, 0x0010aaaa, 0x15000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_ACCESSDOORUP, 0x019b, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00100004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_ACCESSDOORDN, 0x019c, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_ACCESSDOORUP, 0x019d, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00100004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_ACCESSDOORDN, 0x019e, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_ACCESSDOORUP, 0x019f, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00100004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_ACCESSDOORDN, 0x01a0, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LABDOOR, 0x015a, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LABDOOR, 0x015b, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LABDOOR, 0x015c, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x27, 1)
	door(0x0100, MODEL_DD_LAB_DOOR_SEC, 0x015d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000004, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x24, 2)
	tag(0x40, 2)
	door(0x0100, MODEL_DOOR4A_G5, 0x0169, 0x00000400, 0x00000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000708, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00001200, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR4B_G5, 0x0168, 0x00000400, 0x00000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x00000000, 0x00000000, 0x00000708, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_DOOR_WIND, 0x015e, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00020004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00c80384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x5b, 1)
	door(0x0100, MODEL_DD_LABDOOR, 0x015f, 0x10000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LABDOOR, 0x016d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x5d, 1)
	door(0x0100, MODEL_DD_LABDOOR, 0x016e, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LABDOOR, 0x016f, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x5c, 1)
	door(0x0100, MODEL_DD_LABDOOR, 0x0170, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x5e, 2)
	tag(0x5f, 2)
	door(0x0100, MODEL_DD_LAB_SECTOR2BOT, 0x0175, 0x10000010, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_DOORTOP, 0x0176, 0x10000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR2BOT, 0x0178, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_DOORTOP, 0x0177, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffd, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR2BOT, 0x0179, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_DOORTOP, 0x017a, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR2BOT, 0x017c, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_DOORTOP, 0x017b, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffd, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR2BOT, 0x0171, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR2TOP, 0x0172, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR2BOT, 0x0162, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_CAUTIONTOP, 0x0163, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR2BOT, 0x0164, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_CAUTIONTOP, 0x0165, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x47, 1)
	door(0x0100, MODEL_DD_LAB_SECTOR2BOT, 0x0166, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_CAUTIONTOP, 0x0167, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR2BOT, 0x0173, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR2TOP, 0x0174, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR2BOT, 0x017f, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_DOORTOP, 0x0180, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR2BOT, 0x0181, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR3TOP, 0x0182, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x45, 1)
	door(0x0100, MODEL_DD_LAB_SECTOR2BOT, 0x0183, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_DOORTOP, 0x0184, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x44, 1)
	door(0x0100, MODEL_DD_LAB_SECTOR3, 0x017d, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x40000004, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR3, 0x017e, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x40000004, 0x00000000, 0x00000258, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LABDOOR, 0x0185, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LABDOOR, 0x0186, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x22, 1)
	door(0x0100, MODEL_DD_LAB_SECTOR3WIND, 0x0187, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00020004, 0x00000002, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00c80384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR3WIND, 0x0188, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00020004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00c80384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR2BOT, 0x0189, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_RESTRICTED, 0x018a, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x5a, 1)
	door(0x0100, MODEL_DD_LAB_SECTOR2BOT, 0x018b, 0x10000010, 0x00000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000040, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_RESTRICTED, 0x018c, 0x10000010, 0x00000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000040, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x26, -1)
	door(0x0100, MODEL_DD_LAB_SECTOR2BOT, 0x018d, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_RESTRICTED, 0x018e, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR2BOT, 0x018f, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000500, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DD_LAB_SECTOR4TOP, 0x0190, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x23, 1)
	door(0x0100, MODEL_DR_CAROLL_DOOR, 0x0199, 0x00000010, 0x00000000, 0x00000020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000e666, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000040, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DR_CAROLL_DOOR_MAIN, 0x0198, 0x10000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00100004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000100, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DR_CAROLL_DOOR_LEFT, 0x0196, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DR_CAROLL_DOOR_RIGHT, 0x0197, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DR_CAROLL_DOOR_BMAIN, 0x0195, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DR_CAROLL_DOOR_BLEFT, 0x0193, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DR_CAROLL_DOOR_BRIGHT, 0x0194, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f851, 0x0000f333, 0x00035555, 0x00035555, 0x00000666, 0x00000004, 0x00000000, 0x0000012c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffb, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x28, 5)
	tag(0x29, 5)
	tag(0x2a, 5)
	tag(0x2b, 5)
	tag(0x2c, 5)
	door(0x0100, MODEL_LASDOOR, 0x01f0, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000002, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x01f1, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000002, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x01f2, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000002, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x01f3, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000002, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x01f4, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000002, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffc, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x2d, 5)
	tag(0x2e, 5)
	tag(0x2f, 5)
	tag(0x30, 5)
	tag(0x31, 5)
	door(0x0100, MODEL_LASDOOR, 0x01f5, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x01f6, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x01f7, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x01f8, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x01f9, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffc, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x32, 5)
	tag(0x33, 5)
	tag(0x34, 5)
	tag(0x35, 5)
	tag(0x36, 5)
	door(0x0100, MODEL_LASDOOR, 0x01fa, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x01fb, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x01fc, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x01fd, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x01fe, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffc, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x3f, 1)
	door(0x0100, MODEL_DD_GRATE, 0x016a, 0x00000400, 0xa0000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x00010000, 0x00007fff, 0x00014000, 0x00000666, 0x08000000, 0x00000008, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x01, 1)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0213, 0x50000062, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x02, 1)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0214, 0x50000062, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x03, 1)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0215, 0x50000062, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0216, 0x50000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0217, 0x50000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0218, 0x50000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0219, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x021a, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x021b, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x3a, 1)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x021c, 0x00000062, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff04)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x021d, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x021e, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x021f, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0220, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0221, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0222, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0223, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0224, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0225, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0226, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0227, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0228, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0229, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x022a, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x022b, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x022c, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x022d, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x022e, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x022f, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0230, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0231, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0232, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0233, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0234, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0235, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_TVSCREEN, 0x0236, 0x00000062, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x0245, 0x000004e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff23)
	chr(0x00000200, 0x2f, 0x0146, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 200, 100, 0x90082400, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x30, 0x0147, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 200, 100, 0x90082000, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0030, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x31, 0x0148, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 200, 100, 0x90082000, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0031, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x32, 0x0149, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 200, 100, 0x90082000, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0032, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x33, 0x014a, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 200, 100, 0x90086000, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0033, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x00, 0x001f, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_PATH00, -1, -1, 1000, 100, 0x80004700, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0000, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004200, 0x01, 0x0135, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, 0x0019, -1, 1000, 100, 0x8000c408, 0x00000100, TEAM_ENEMY, SQUADRON_01, 0x3c, 0, 0x00030000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0001, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004200, 0x02, 0x0136, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, 0x001a, -1, 1000, 100, 0x8000c408, 0x00000100, TEAM_ENEMY, SQUADRON_01, 0x3d, 0, 0x00030000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0002, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004200, 0x3c, 0x0134, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 1000, 100, 0x80002200, 0x00000100, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00010000)
	weapon(0x0100, MODEL_CHRCMP150, 0x003c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004200, 0x03, 0x0137, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 1000, 100, 0x80004100, 0x00000100, TEAM_ENEMY, SQUADRON_02, 0x3e, 0, 0x00020000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0003, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x04, 0x0111, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 1000, 100, 0x80004100, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0004, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x05, 0x0112, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 1000, 100, 0x80004100, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0005, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x06, 0x0113, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 1000, 100, 0x80004100, 0x00000000, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0006, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0a, 0x0031, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_PATH02, -1, -1, 200, 100, 0x80000100, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0b, 0x0038, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_PATH02, -1, -1, 200, 100, 0x80000100, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0c, 0x0062, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_PATH03, -1, -1, 1000, 100, 0x80002000, 0x00000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0d, 0x006e, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_PATH03, -1, -1, 1000, 100, 0x80002000, 0x00000000, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0e, 0x0114, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 1, 100, 0x80082000, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x0f, 0x0115, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, 0x0060, -1, 100, 100, 0x81002000, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x000f, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004200, 0x10, 0x0116, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, 0x0060, -1, 100, 100, 0x81002000, 0x00000100, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00010000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0010, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004200, 0x11, 0x0117, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, 0x0065, -1, 100, 100, 0x81002000, 0x00000100, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00010000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0011, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x12, 0x0118, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, 0x0065, -1, 100, 100, 0x81002000, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0012, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00004200, 0x13, 0x0119, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, 0x0069, -1, 100, 100, 0x81002000, 0x00000100, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00010000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0013, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x14, 0x011a, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, 0x0069, -1, 100, 100, 0x81002000, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0014, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x15, 0x011b, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 200, 100, 0x80000000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0015, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x16, 0x011c, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 200, 100, 0x80000000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0016, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x17, 0x011d, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 200, 100, 0x80000000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0017, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x18, 0x011e, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 200, 100, 0x80000000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0018, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x19, 0x011f, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 200, 100, 0x84000100, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0019, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1a, 0x0120, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 200, 100, 0x80000000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1b, 0x0121, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 200, 100, 0x80000000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x001b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1c, 0x0122, BODY_DD_SHOCK_INF, HEAD_DDSHOCK, AILIST_INIT_BASIC_GUARD, -1, -1, 200, 100, 0x80000000, 0x00000000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x001c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1d, 0x0123, BODY_DD_SHOCK_INF, HEAD_DDSHOCK, AILIST_INIT_BASIC_GUARD, -1, -1, 200, 100, 0x80000000, 0x00000000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x001d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00004200, 0x1e, 0x0124, BODY_DD_SHOCK_INF, HEAD_DDSHOCK, AILIST_INIT_BASIC_GUARD, -1, -1, 1000, 20, 0x80084100, 0x00000100, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00010000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x001e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1f, 0x0125, BODY_DD_SHOCK_INF, HEAD_DDSHOCK, AILIST_INIT_BASIC_GUARD, -1, -1, 200, 20, 0x80004100, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x001f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x20, 0x0126, BODY_DD_SHOCK_INF, HEAD_DDSHOCK, AILIST_INIT_BASIC_GUARD, -1, -1, 200, 20, 0x80004100, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0020, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x21, 0x0127, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK_GUARD, -1, -1, 200, 20, 0x80084100, 0x00000000, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0021, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x22, 0x0128, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK_GUARD, -1, -1, 200, 20, 0x80002000, 0x00000000, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0022, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x23, 0x0129, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK_GUARD, -1, -1, 200, 20, 0x80002000, 0x00000000, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0023, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x24, 0x012a, BODY_DDSHOCK, HEAD_DDSHOCK, AILIST_INIT_SHOCK_GUARD, -1, -1, 200, 20, 0x80002000, 0x00000000, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0024, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000400, 0x3b, 0x013b, BODY_DD_SHOCK_INF, HEAD_DDSHOCK, AILIST_K7_GUARD, -1, -1, 1, 20, 0x0000c200, 0x00000000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x003b, 0x00424000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	tag(0x04, -1)
	chr(0x00010400, 0x38, 0x013c, BODY_DD_LABTECH, HEAD_RANDOM, AILIST_K7_SCIENTIST, 0x0076, -1, 1, 20, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	chr(0x00000200, 0x29, 0x0155, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 1000, 100, 0xc0082000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x0029, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2a, 0x0156, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, 0x0060, -1, 1000, 100, 0xc0082000, 0x00000000, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002a, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2b, 0x014b, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 1000, 100, 0xc0082000, 0x00000000, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2c, 0x014c, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, 0x0060, -1, 1000, 100, 0xc0082000, 0x00000000, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002c, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2d, 0x0151, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, -1, -1, 1000, 100, 0xc0082000, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x2e, 0x0152, BODY_DD_SHOCK_INF, HEAD_RANDOM, AILIST_INIT_BASIC_GUARD, 0x0060, -1, 1000, 100, 0xc0082000, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x002e, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	chr(0x00010400, 0x35, 0x0138, BODY_DD_LABTECH, HEAD_JAMIE, AILIST_INIT_SCIENTIST, 0x0076, -1, 1000, 10, 0x00002000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	chr(0x00010400, 0x36, 0x0139, BODY_DD_LABTECH, HEAD_JON, AILIST_INIT_SCIENTIST, -1, -1, 1000, 10, 0x00004000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x01000000)
	chr(0x00010400, 0x37, 0x013a, BODY_DD_LABTECH, HEAD_DUNCAN2, AILIST_INIT_SCIENTIST, -1, -1, 1000, 10, 0x00000000, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x02000000)
	chr(0x00000400, 0x3a, 0x0106, BODY_DDSHOCK, HEAD_DARLING, GAILIST_IDLE, -1, -1, 1000, 100, 0x0000c200, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	chr(0x00010400, 0x39, 0x010c, BODY_DRCAROLL, 0x00, GAILIST_IDLE, -1, -1, 1000, 100, 0x0000c200, 0x00000000, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	tag(0x0b, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x0246, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x0c, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x0247, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x0d, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x0248, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x0e, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x0249, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x10, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x024a, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x11, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x024b, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x12, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x024c, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x13, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x024d, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x08, 3)
	tag(0x14, 2)
	tag(0x15, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x024e, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x16, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x024f, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x17, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x0250, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x18, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x0251, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x09, 3)
	tag(0x19, 2)
	tag(0x1a, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x0252, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x1b, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x0253, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x1c, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x0254, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x1d, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x0255, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x07, 3)
	tag(0x0f, 2)
	tag(0x1e, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x0256, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x1f, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x0257, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x20, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x0258, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x21, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x0259, 0x000004e1, 0x00000001, 0x00210000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	stdobject(0x0100, MODEL_LAB_TABLE, 0x023c, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x0a, 1)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x025a, 0x010004e1, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	tag(0x37, 1)
	hovercar(0x00c0, MODEL_HOOVERBOT, 0x0001, 0xe0000008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, 0x00000411, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x38, 1)
	hovercar(0x00c0, MODEL_TESTERBOT, 0x003b, 0xc0020008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, 0x00000412, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01b3, 0x04000b62, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01b4, 0x04000b62, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01b8, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01b9, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01ba, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01bb, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01bc, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x01b5, 0x04020b62, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00c80384, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x01b6, 0x04020b62, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00c80384, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_WINDOW, 0x01b7, 0x04020b62, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00c80384, 0x0000ffff, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01bd, 0x04000b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01be, 0x04000b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01bf, 0x04000b62, 0x00100000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x3e, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x020c, 0x000205e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x020b, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x020a, 0x000004e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	stdobject(0x0100, MODEL_LAB_CHAIR, 0x020d, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_LAB_TABLE, 0x020e, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x020f, 0x000004e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	stdobject(0x0100, MODEL_LAB_CHAIR, 0x0211, 0x000005e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_LAB_TABLE, 0x0210, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	singlemonitor(0x0100, MODEL_SINISTERPC, 0x0212, 0x000004e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff03)
	glass(0x0100, MODEL_WINDOW, 0x01d4, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01d3, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01d2, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01d1, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01d0, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01cf, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01ce, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01cd, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c7, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c6, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c5, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c4, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c3, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c2, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c1, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c0, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01cb, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01ca, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c9, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01c8, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01cc, 0x04020b62, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01dd, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01e4, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01e3, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01e2, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01e1, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01e0, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01df, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01de, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01e5, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01e6, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01e7, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01e8, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01e9, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01ea, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01eb, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01ec, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01d5, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01d6, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01d7, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01d8, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01d9, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01da, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01db, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01dc, 0x04000b62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01ed, 0x04020b62, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01ee, 0x04020b62, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01ef, 0x04020b62, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	tag(0x3d, 1)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x01a9, 0x000205e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x01aa, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x3c, 1)
	stdobject(0x0100, MODEL_DD_REDARM, 0x01ab, 0x000205e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x01ac, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x01ad, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x01ae, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDSOFA, 0x01af, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x01b0, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x01b1, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_REDARM, 0x01b2, 0x000005e1, 0x00004100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x01a1, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0166, MODEL_DD_PLANTRUBBER, 0x01a2, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x01a3, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0180, MODEL_DD_PLANTSPIKE, 0x01a4, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0180, MODEL_DD_PLANTRUBBER, 0x01a5, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0200, MODEL_DD_PLANTSPIKE, 0x01a6, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0180, MODEL_DD_PLANTRUBBER, 0x01a7, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0133, MODEL_DD_PLANTSPIKE, 0x01a8, 0x04000501, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x025d, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x025e, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x025f, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x0260, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x0261, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0262, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0263, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0264, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0265, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x0266, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x0267, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x0268, 0x000201e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0033, MODEL_QUADPOD, 0x013d, 0x000005e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)

	/**
	 * @bug: This should be using MODEL_CHRNIGHTSIGHT.
	 *
	 * When picking up night vision the game checks if the perfect darkness
	 * cheat is enabled and skips adding the night vision to your inventory as
	 * it would already be there. But because this uses IR specs instead, the
	 * check doesn't match and a duplicate night vision is added to the
	 * inventory.
	 */
	tag(0x05, 1)
	stdobject(0x0100, MODEL_MISC_IRSPECS, 0x013d, 0x014605e1, 0x00004001, 0x00400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	rename_object(-1, 0x2d, L_EAR(45), L_EAR(46), L_EAR(47), L_EAR(48), L_EAR(49), 0x0000, 0x0000) // "Obtain Night Vision."

	tag(0x06, 1)
	stdobject(0x0100, MODEL_CHRSHIELD, 0x0243, 0x01460501, 0x00004001, 0x00400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	rename_object(-1, 0x4f, L_EAR(50), L_EAR(51), L_EAR(52), L_EAR(53), L_EAR(54), 0x0000, 0x0000) // "Obtain shield tech item."
	tag(0x25, 1)
	weapon(0x0180, MODEL_CHRDATATHIEF, 0xffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DATAUPLINK, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x36, L_EAR(55), L_EAR(56), L_EAR(57), L_EAR(58), L_EAR(59), 0x0000, 0x0000) // "Obtain Data Uplink."
	tag(0x48, 1)
	weapon(0x0180, MODEL_CHRDATATHIEF, 0xffff, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DATAUPLINK, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x36, L_EAR(55), L_EAR(56), L_EAR(57), L_EAR(58), L_EAR(59), 0x0000, 0x0000) // "Obtain Data Uplink."
	tag(0x41, 1)
	autogun(0x0099, MODEL_ROOFGUN, 0x026b, 0x00000004, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x026e0000, 0x00000000, 0x00004000, 0xffffc000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000da, 0x000a0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x42, 1)
	autogun(0x0099, MODEL_ROOFGUN, 0x026c, 0x00000004, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x026f0000, 0x00000000, 0x00004000, 0xffffc000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000da, 0x000a0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x43, 1)
	autogun(0x0099, MODEL_ROOFGUN, 0x026d, 0x00000004, 0x00000030, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x02700000, 0x00000000, 0x00004000, 0xffffc000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000005b0, 0x000a0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	autogun(0x0099, MODEL_ROOFGUN, 0x026b, 0x00000004, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x026e0000, 0x00000000, 0x00004000, 0xffffc000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000e38, 0x00140000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	autogun(0x0099, MODEL_ROOFGUN, 0x026c, 0x00000004, 0x00000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x026f0000, 0x00000000, 0x00004000, 0xffffc000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000e38, 0x00140000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x0133, MODEL_A51_CRATE2, 0x0269, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0133, MODEL_A51_CRATE2, 0x026a, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x39, 1)
	stdobject(0x0400, MODEL_ISOTOPE, 0x0158, 0x04000408, 0x0000c101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0400, MODEL_ISOTOPEEXPERIMENT, 0x0157, 0x04000101, 0x00004101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x49, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x027e, 0x00000001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x4a, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x027f, 0x00000001, 0x000000c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x4b, 1)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0x0271, 0x000000e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_RIFLE)
	tag(0x4c, 1)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0x0272, 0x000000e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_RIFLE)
	tag(0x4d, 1)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0x0273, 0x000000e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_RIFLE)
	tag(0x4e, 1)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0x0274, 0x000000e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_RIFLE)
	tag(0x4f, 1)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0x0275, 0x000000e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_RIFLE)
	tag(0x50, 1)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0x0276, 0x000000e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_RIFLE)
	tag(0x51, 1)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0x0277, 0x000000e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_RIFLE)
	tag(0x52, 1)
	ammocrate(0x0080, MODEL_MULTI_AMMO_CRATE, 0x0278, 0x000000e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, AMMOTYPE_RIFLE)
	tag(0x53, 1)
	weapon(0x0100, MODEL_CHRCMP150, 0x0279, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	tag(0x54, 1)
	weapon(0x0100, MODEL_CHRCMP150, 0x027a, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	tag(0x55, 2)
	tag(0x56, 2)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x016b, 0x000201e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_A51_CRATE2, 0x016c, 0x000201e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x57, 2)
	tag(0x58, 2)
	weapon(0x0100, MODEL_CHRCMP150, 0x027b, 0x00100008, 0x00080001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRCMP150, 0x027c, 0x00100008, 0x00080001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_CMP150, 0x00ffffff, 0x00000000)
	link_collectibles(-1, -2)
	tag(0x59, 1)
	weapon(0x0080, MODEL_MULTI_AMMO_CRATE, 0x027d, 0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_PROXIMITYMINE, 0x00ffffff, 0x00000000)
	endprops
};

s32 intro[] = {
	intro_weapon(WEAPON_FALCON2, -1)
	ammo(AMMOTYPE_PISTOL, 100)
	ammo(AMMOTYPE_RIFLE, 50)
	intro_weapon(WEAPON_CAMSPY, -1)
	outfit(OUTFIT_DEFAULT)
	spawn(0x001b)
	endintro
};

s32 path00[] = {
	0x001f,
	0x001e,
	0x001d,
	0x001c,
	0x000c,
	0x000f,
	0x0010,
	0x000e,
	0x0004,
	0x0003,
	0x0001,
	0x0012,
	0x0011,
	0x0013,
	0x0014,
	0x0015,
	-1,
};

s32 path01[] = {
	0x004f,
	0x004e,
	0x004d,
	0x004c,
	0x004b,
	0x004a,
	0x0049,
	0x002a,
	0x002b,
	0x002c,
	0x002d,
	0x002e,
	0x0029,
	0x002a,
	0x0049,
	0x004a,
	0x004b,
	0x004c,
	0x004d,
	0x004e,
	-1,
};

s32 path02[] = {
	0x0031,
	0x0034,
	0x0033,
	0x0032,
	0x0035,
	0x0036,
	0x0038,
	0x0039,
	0x003a,
	-1,
};

s32 path03[] = {
	0x0062,
	0x0061,
	0x0063,
	0x0065,
	0x0066,
	0x0067,
	0x0069,
	0x006a,
	0x006d,
	0x006e,
	-1,
};

s32 path04[] = {
	0x0107,
	0x0108,
	0x0109,
	-1,
};

s32 path05[] = {
	0x0001,
	0x0002,
	0x000c,
	0x001d,
	0x001e,
	0x001f,
	0x0028,
	0x0029,
	0x002d,
	0x002a,
	0x002e,
	0x002e,
	0x002e,
	-1,
};

s32 path06[] = {
	0x002e,
	0x0029,
	0x0028,
	0x001f,
	0x001e,
	0x001d,
	0x000c,
	0x0002,
	0x0002,
	0x0002,
	-1,
};

s32 path07[] = {
	0x003b,
	0x0039,
	0x003b,
	0x0039,
	-1,
};

s32 path08[] = {
	0x003b,
	0x003c,
	0x003b,
	-1,
};

s32 path09[] = {
	0x0038,
	0x0035,
	0x0033,
	0x0034,
	0x0031,
	0x0030,
	0x002b,
	0x002a,
	0x0049,
	0x004a,
	0x004b,
	0x004c,
	0x004d,
	0x0050,
	0x004e,
	0x0042,
	0x0043,
	0x005e,
	0x0061,
	0x0065,
	0x0069,
	0x006d,
	0x006b,
	0x006c,
	0x00bd,
	0x00be,
	-1,
};

s32 path10[] = {
	0x00be,
	0x012e,
	0x012f,
	0x0130,
	0x00c7,
	0x00cd,
	0x00c8,
	0x00c4,
	0x0130,
	0x012f,
	0x012e,
	0x00be,
	0x00bd,
	0x011c,
	0x00be,
	-1,
};

s32 path11[] = {
	0x003b,
	0x003b,
	0x003b,
	-1,
};

s32 path12[] = {
	0x007f,
	0x007f,
	0x007f,
	-1,
};

s32 path13[] = {
	0x0080,
	0x0080,
	0x0080,
	-1,
};

#define init_path(pathid) \
	set_chr_dodge_rating(2, 0x0a) \
	set_accuracy(1) \
	set_reaction_speed(20) \
	set_chr_maxdamage(CHR_SELF, 40) \
	add_health_or_armor(0) \
	set_recovery_speed(0) \
	set_shield(0) \
	assign_path(pathid) \
	start_path \
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0004)



u8 func040c_start_path00[] = {
	init_path(0)
	endlist
};

u8 func040d_start_path01[] = {
	init_path(1)
	endlist
};

u8 func040e_start_path02[] = {
	init_path(2)
	endlist
};

u8 func040f_start_path03[] = {
	init_path(3)
	endlist
};

u8 func0410_start_path04[] = {
	init_path(4)
	endlist
};

/**
 * @unused
 *
 * The function doesn't do any checks for detecting Jo, so the guard would
 * ignore you if it were assigned.
 */
u8 func0414_walk_3_pads[] = {
	label(0x03)
		walk_to_pad(0x0002)

		beginloop(0x06)
			if_chr_stopped(/*goto*/ 0x2f)
		endloop(0x06)

		label(0x2f)
		walk_to_pad(0x0003)

		beginloop(0x04)
			if_chr_stopped(/*goto*/ 0x08)
		endloop(0x04)

		label(0x08)
		walk_to_pad(0x0001)

		beginloop(0x09)
			if_chr_stopped(/*goto*/ 0x0a)
		endloop(0x09)

		label(0x0a)
	goto_first(0x03)

	endlist
};

/**
 * Unused.
 */
u8 func0401_init_chr_with_flag[] = {
	set_self_chrflag(CHRCFLAG_00000200)
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0001)
	endlist
};

u8 func0405_init_scientist[] = {
	set_chr_maxdamage(CHR_SELF, 20)
	set_ailist(CHR_SELF, AILIST_SCIENTIST)
	endlist
};

u8 func0404_scientist[] = {
	set_shotlist(AILIST_SCIENTIST)
	if_chr_dying(CHR_SELF, /*goto*/ 0x2f)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2f)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	dprint 'N','I','S','D','E','A','D','\n',0,
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	dprint 'N','I','S','2','\n',0,
	if_just_injured(CHR_SELF, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	beginloop(0x10)
		if_chr_stopped(/*goto*/ 0x2f)
	endloop(0x10)

	label(0x2f)
	set_ailist(CHR_SELF, AILIST_INIT_NASTY_SCIENTIST)

	label(0x06)
	stop_chr

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x2f)
		if_distance_to_target_lt(500, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	if_stage_flag_eq(STAGEFLAG_ONE_SCIENTIST_DONE, TRUE, /*goto*/ 0x06)
	set_stage_flag(STAGEFLAG_ONE_SCIENTIST_DONE)
	goto_next(0x03)

	label(0x06)
	if_stage_flag_eq(STAGEFLAG_TWO_SCIENTISTS_DONE, TRUE, /*goto*/ 0x06)
	set_stage_flag(STAGEFLAG_TWO_SCIENTISTS_DONE)
	goto_next(0x03)

	label(0x06)
	set_stage_flag(STAGEFLAG_THREE_SCIENTISTS_DONE)
	if_stage_flag_eq(STAGEFLAG_THREE_SCIENTISTS_DONE, FALSE, /*goto*/ 0x03)
	set_ailist(CHR_SELF, AILIST_INIT_NASTY_SCIENTIST)

	label(0x03)
	if_chr_in_room(CHR_P1P2, 0x00, 0x0031, /*goto*/ 0x6a)
	if_chr_in_room(CHR_P1P2, 0x00, 0x0032, /*goto*/ 0x6a)
	if_chr_in_room(CHR_P1P2, 0x00, 0x0042, /*goto*/ 0x6d)
	if_chr_in_room(CHR_P1P2, 0x00, 0x0043, /*goto*/ 0x6d)
	goto_next(0x06)

	label(0x6a)
		chr_do_animation(ANIM_COWER_0229, -1, -1, 0x10, 0x0a, CHR_SELF, 2)

		beginloop(0x6b)
			if_chr_dying(0x2b, /*goto*/ 0x2f)
			if_chr_death_animation_finished(0x2b, /*goto*/ 0x2f)
			if_chr_unloaded(0x2b, /*goto*/ 0x2f)
			if_chr_stopped(/*goto*/ 0x6c)
			reloop(0x6b)

			label(0x2f)
			if_chr_dying(0x2c, /*goto*/ 0x06)
			if_chr_death_animation_finished(0x2c, /*goto*/ 0x06)
			if_chr_unloaded(0x2c, /*goto*/ 0x06)
			if_chr_stopped(/*goto*/ 0x6c)
		endloop(0x6b)

		label(0x6c)
	goto_first(0x6a)

	label(0x6d)
		chr_do_animation(ANIM_COWER_0229, -1, -1, 0x10, 0x0a, CHR_SELF, 2)

		beginloop(0x6e)
			if_chr_dying(0x2d, /*goto*/ 0x2f)
			if_chr_death_animation_finished(0x2d, /*goto*/ 0x2f)
			if_chr_unloaded(0x2d, /*goto*/ 0x2f)
			if_chr_stopped(/*goto*/ 0x6f)
			reloop(0x6e)

			label(0x2f)
			if_chr_dying(0x2e, /*goto*/ 0x06)
			if_chr_death_animation_finished(0x2e, /*goto*/ 0x06)
			if_chr_unloaded(0x2e, /*goto*/ 0x06)
			if_chr_stopped(/*goto*/ 0x6f)
		endloop(0x6e)

		label(0x6f)
	goto_first(0x6d)

	label(0x06)
	restart_timer
	label(0x08)
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2f)
	endloop(0x09)

	label(0x2f)
	if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
	if_timer_gt(60, /*goto*/ 0x06)
	goto_first(0x09)

	label(0x06)
	dprint 'T','A','L','K',' ','1','\n',0,
	say_quip(CHR_TARGET, 0x0a, 0xff, 0x00, 0xff, 0x81, 0x03, 0x08)
	restart_timer
	stop_chr

	beginloop(0x56)
		if_timer_lt(120, /*goto*/ 0x2f)
		if_chr_in_view(/*goto*/ 0x06)
		label(0x2f)
	endloop(0x56)

	label(0x06)
	dprint 'T','A','L','K',' ','1','\n',0,
	say_quip(CHR_TARGET, 0x0b, 0xff, 0x00, 0xff, 0x81, 0x04, 0x09)
	restart_timer

	beginloop(0x57)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x57)

	label(0x06)
	label(0x0a)
	say_quip(CHR_TARGET, 0x0c, 0xff, 0x00, 0xff, 0x81, 0x05, 0x08)
	restart_timer
	chr_do_animation(ANIM_SURRENDER_002E, 0, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x0b)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_timer_gt(90, /*goto*/ 0x06)
	endloop(0x0b)

	label(0x06)
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x06)
	if_self_flag_bankx_eq(CHRFLAG0_00004000, TRUE, BANK_0, /*goto*/ 0x2f)
	set_pad_preset_to_investigation_terminal(OBJ_GOODTERM3)
	goto_next(0x12)

	label(0x06)
	set_pad_preset_to_investigation_terminal(OBJ_GOODTERM1)
	goto_next(0x12)

	label(0x2f)
	set_pad_preset_to_investigation_terminal(OBJ_GOODTERM2)
	label(0x12)
	go_to_target_pad(SPEED_JOG)

	beginloop(0x0c)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x0c)

	label(0x06)
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x06)
	if_self_flag_bankx_eq(CHRFLAG0_00004000, TRUE, BANK_0, /*goto*/ 0x2f)
	if_object_in_good_condition(OBJ_GOODTERM3, /*goto*/ 0x19)
	say_quip(CHR_TARGET, 0x10, 0xff, 0x00, 0xff, 0x81, 0x09, 0x08)
	show_hudmsg_top_middle(CHR_TARGET, L_EAR(44), COLOR_00_GREEN) // "It appears someone has broken my PC."
	goto_next(0x0e)

	label(0x19)
	if_stage_flag_eq(STAGEFLAG_SHUT_DOWN_EXPERIMENT3, FALSE, /*goto*/ 0x15)
	say_quip(CHR_TARGET, 0x0f, 0xff, 0x00, 0xff, 0x81, 0x08, 0x08)
	goto_next(0x0e)

	label(0x15)
	set_stage_flag(STAGEFLAG_SHUT_DOWN_EXPERIMENT3)
	say_quip(CHR_TARGET, 0x0d, 0xff, 0x00, 0xff, 0x81, 0x06, 0x08)
	assign_sound(0x01c3, CHANNEL_5)
	control_sound_from_object(CHANNEL_5, OBJ_GOODTERM3, TRUE)
	goto_next(0x0f)

	label(0x06)
	if_object_in_good_condition(OBJ_GOODTERM1, /*goto*/ 0x19)
	say_quip(CHR_TARGET, 0x10, 0xff, 0x00, 0xff, 0x81, 0x09, 0x08)
	goto_next(0x0e)

	label(0x19)
	if_stage_flag_eq(STAGEFLAG_SHUT_DOWN_EXPERIMENT1, FALSE, /*goto*/ 0x16)
	say_quip(CHR_TARGET, 0x0f, 0xff, 0x00, 0xff, 0x81, 0x08, 0x08)
	goto_next(0x0e)

	label(0x16)
	set_stage_flag(STAGEFLAG_SHUT_DOWN_EXPERIMENT1)
	say_quip(CHR_TARGET, 0x0d, 0xff, 0x00, 0xff, 0x81, 0x06, 0x08)
	assign_sound(0x01c3, CHANNEL_5)
	control_sound_from_object(CHANNEL_5, OBJ_GOODTERM1, TRUE)
	goto_next(0x0f)

	label(0x2f)
	if_object_in_good_condition(OBJ_GOODTERM1, /*goto*/ 0x19)
	say_quip(CHR_TARGET, 0x10, 0xff, 0x00, 0xff, 0x81, 0x09, 0x08)
	goto_next(0x0e)

	label(0x19)
	if_stage_flag_eq(STAGEFLAG_SHUT_DOWN_EXPERIMENT2, FALSE, /*goto*/ 0x17)
	say_quip(CHR_TARGET, 0x0f, 0xff, 0x00, 0xff, 0x81, 0x08, 0x08)
	goto_next(0x0e)

	label(0x17)
	set_stage_flag(STAGEFLAG_SHUT_DOWN_EXPERIMENT2)
	say_quip(CHR_TARGET, 0x0d, 0xff, 0x00, 0xff, 0x81, 0x06, 0x08)
	assign_sound(0x01c3, CHANNEL_5)
	control_sound_from_object(CHANNEL_5, OBJ_GOODTERM2, TRUE)
	goto_next(0x0f)

	label(0x0f)
	show_hudmsg(CHR_TARGET, L_EAR(28)) // "Powering down active systems."
	speak(CHR_TARGET, 0xffff, 0x8118, CHANNEL_9, COLOR_00_GREEN) // unknown text
	chr_do_animation(ANIM_STANDING_TYPE_ONE_HAND, 0, 193, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x0d)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x0d)

	label(0x06)
	show_hudmsg(CHR_TARGET, L_EAR(29)) // "Experiment has been shut down."
	stop_chr

	beginloop(0x0e)
	endloop(0x0e)

	endlist
};

u8 func0407_init_nasty_scientist[] = {
	set_ailist(CHR_SELF, AILIST_NASTY_SCIENTIST)
	endlist
};

u8 func0406_nasty_scientist[] = {
	set_shotlist(AILIST_NASTY_SCIENTIST)
	dprint 'N','A','S','T','Y','1','\n',0,
	if_chr_dying(CHR_SELF, /*goto*/ 0x2f)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x2f)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	dprint 'N','A','S','T','Y',' ','D','E','A','D','\n',0,
	set_shotlist(GAILIST_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	dprint 'N','A','S','T','Y','2','\n',0,
	if_just_injured(CHR_SELF, /*goto*/ 0x2f)
	if_num_times_shot_lt(1, /*goto*/ 0x06)
	label(0x2f)
	play_sound(0x128c, CHANNEL_7)

	beginloop(0x10)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x10)

	label(0x06)
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x06)
	if_self_flag_bankx_eq(CHRFLAG0_00004000, TRUE, BANK_0, /*goto*/ 0x2f)
	set_pad_preset_to_investigation_terminal(OBJ_ALARMTERM3)
	goto_next(0x12)

	label(0x06)
	set_pad_preset_to_investigation_terminal(OBJ_ALARMTERM1)
	goto_next(0x12)

	label(0x2f)
	set_pad_preset_to_investigation_terminal(OBJ_ALARMTERM2)
	label(0x12)
	if_num_times_shot_lt(1, /*goto*/ 0x13)
	go_to_target_pad(SPEED_JOG)
	goto_next(0x55)

	label(0x13)
	label(0x08)
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		if_sound_finished(CHANNEL_6, /*goto*/ 0x2f)
		reloop(0x09)

		label(0x2f)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x06)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	say_quip(CHR_TARGET, 0x0a, 0xff, 0x00, 0xff, 0x81, 0x03, 0x08)
	restart_timer

	beginloop(0x56)
		if_timer_gt(120, /*goto*/ 0x06)
	endloop(0x56)

	label(0x06)
	dprint 'T','A','L','K',' ','1','\n',0,
	say_quip(CHR_TARGET, 0x0b, 0xff, 0x00, 0xff, 0x81, 0x04, 0x09)
	restart_timer

	beginloop(0x57)
		if_timer_gt(120, /*goto*/ 0x0a)
	endloop(0x57)

	label(0x0a)
	restart_timer
	stop_chr
	say_quip(CHR_TARGET, 0x0c, 0xff, 0x00, 0xff, 0x81, 0x05, 0x08)

	beginloop(0x0b)
		if_timer_gt(90, /*goto*/ 0x55)
	endloop(0x0b)

	label(0x55)
	go_to_target_pad(SPEED_JOG)

	beginloop(0x0c)
		if_chr_stopped(/*goto*/ 0x06)
	endloop(0x0c)

	label(0x06)
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x06)
	if_self_flag_bankx_eq(CHRFLAG0_00004000, TRUE, BANK_0, /*goto*/ 0x2f)
	if_object_in_good_condition(OBJ_ALARMTERM3, /*goto*/ 0x30)
	goto_next(0x11)

	label(0x30)
	set_stage_flag(STAGEFLAG_ALARM3_ACTIVE)
	assign_sound(0x8118, CHANNEL_6)
	control_sound_from_object(CHANNEL_6, OBJ_GOODTERM3, TRUE)
	goto_next(0x0f)

	label(0x06)
	if_object_in_good_condition(OBJ_ALARMTERM1, /*goto*/ 0x30)
	goto_next(0x11)

	label(0x30)
	set_stage_flag(STAGEFLAG_ALARM1_ACTIVE)
	assign_sound(0x8118, CHANNEL_6)
	control_sound_from_object(CHANNEL_6, OBJ_GOODTERM1, TRUE)
	goto_next(0x0f)

	label(0x2f)
	if_object_in_good_condition(OBJ_ALARMTERM2, /*goto*/ 0x30)
	goto_next(0x11)

	label(0x30)
	set_stage_flag(STAGEFLAG_ALARM2_ACTIVE)
	assign_sound(0x8118, CHANNEL_6)
	control_sound_from_object(CHANNEL_6, OBJ_GOODTERM2, TRUE)
	goto_next(0x0f)

	label(0x11)
	say_quip(CHR_TARGET, 0x10, 0xff, 0x00, 0xff, 0x81, 0x09, 0x08)
	goto_next(0x78)

	label(0x0f)
	speak(CHR_TARGET, 0xffff, 0x8118, CHANNEL_9, COLOR_00_GREEN) // unknown text
	say_quip(CHR_TARGET, 0x0e, 0xff, 0x00, 0xff, 0x81, 0x07, 0x08)
	chr_do_animation(ANIM_STANDING_TYPE_ONE_HAND, 0, 193, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x0d)
		if_chr_stopped(/*goto*/ 0x30)
	endloop(0x0d)

	label(0x30)
	activate_alarm
	label(0x78)
	label(0x06)
	stop_chr

	beginloop(0x0e)
	endloop(0x0e)

	endlist
};

u8 func1009_weaponscache[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_activated_object(CHR_TARGET, OBJ_CACHETERMINAL, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	if_chr_has_hiddenflag(CHR_BOND, CHRHFLAG_PSYCHOSISED, /*goto*/ 0x2f)
	show_hudmsg(CHR_TARGET, L_EAR(98)) // "Secret weapons compartment opened."
	play_sound(0x00f7, -1)
	assign_sound(0x043b, CHANNEL_5)
	control_sound_from_object(CHANNEL_5, OBJ_CMP150_1, TRUE)
	hide_object(OBJ_CACHEDOOR1)
	hide_object(OBJ_CACHEDOOR2)
	unset_object_flag(OBJ_CMP150_1, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(OBJ_CMP150_1, OBJFLAG2_INVISIBLE)
	unset_object_flag(OBJ_CMP150_2, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(OBJ_CMP150_2, OBJFLAG2_INVISIBLE)
	set_object_flag2(OBJ_CMP150_1, OBJFLAG2_00001000)
	set_object_flag2(OBJ_CMP150_2, OBJFLAG2_00001000)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x2f)
	show_hudmsg(CHR_TARGET, L_EAR(99)) // "Enemy detected - weapon cache locked."
	play_sound(0x00f7, -1)
	unset_stage_flag(STAGEFLAG_BOT_ACTIVE)
	unset_stage_flag(STAGEFLAG_BOT_REPROGRAMMED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * The second terminal you're supposed to activate.
 *
 * If turning the bot on without reprogramming it first, the bot will run
 * without a program where it moves in a small circle at slow speed.
 *
 * If turning the bot on after reprogramming it will start the maintenance
 * cycle (lasers).
 */
u8 func1002_bot_activation_terminal[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2f)
	goto_next(0x04)

	label(0x2f)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_activated_object(CHR_TARGET, OBJ_BOT_ACTIVATION_TERMINAL, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x2f)
		if_objective_failed(1, /*goto*/ 0x0b)
		if_stage_flag_eq(STAGEFLAG_BOT_ACTIVE_MAINTENANCE, TRUE, /*goto*/ 0x08)
		if_stage_flag_eq(STAGEFLAG_BOT_ACTIVE, TRUE, /*goto*/ 0x0a)
		if_stage_flag_eq(STAGEFLAG_BOT_REPROGRAMMED, TRUE, /*goto*/ 0x2f)

		// Activating prior to reprogramming
		play_sound(0x01ca, -1)
		assign_sound(0x01c5, CHANNEL_3)
		play_sound_from_object(CHANNEL_3, OBJ_PURPLEBOT, 0x0258, 0x0320)
		show_hudmsg(CHR_TARGET, L_EAR(15)) // "Maintenance robots activated."
		set_stage_flag(STAGEFLAG_BOT_ACTIVE)
		set_stage_flag(STAGEFLAG_BOT_ACTIVE_NOPROGRAM)
		reloop(0x04)

		// Activating after reprogramming
		label(0x2f)
		show_hudmsg(CHR_TARGET, L_EAR(15)) // "Maintenance robots activated."
		set_stage_flag(STAGEFLAG_BOT_ACTIVE)
		yield
		play_sound(0x00f7, -1)
		show_hudmsg(CHR_TARGET, L_EAR(18)) // "Maintenance cycle activated."
		set_stage_flag(STAGEFLAG_BOT_ACTIVE_MAINTENANCE)
		reloop(0x04)

		// Attempting to deactivate while bot reprogrammed and running
		label(0x08)
		play_sound(0x00f7, -1)
		show_hudmsg(CHR_TARGET, L_EAR(20)) // "Operation not allowed - robots busy."
		restart_timer

		beginloop(0x09)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x09)

		label(0x06)
		reloop(0x04)

		// Deactivating
		label(0x0a)
		show_hudmsg(CHR_TARGET, L_EAR(21)) // "Maintenance robots deactivated."
		unset_stage_flag(STAGEFLAG_BOT_ACTIVE)
		unset_stage_flag(STAGEFLAG_BOT_ACTIVE_CLEANING)
		unset_stage_flag(STAGEFLAG_BOT_ACTIVE_NOPROGRAM)
		play_sound(0x01c9, -1)
		mute_channel(CHANNEL_3)
		reloop(0x04)

		label(0x0b)
		play_sound(0x00f7, -1)
		show_hudmsg(CHR_TARGET, L_EAR(23)) // "Maintenance robot system offline."
	endloop(0x04)

	endlist
};

/**
 * The first terminal you're supposed to activate.
 *
 * If activated while the bot is offline, the bot is reprogrammed with the
 * maintenance cycle (ie. lasers) but still needs to be started.
 *
 * If activated while the bot is running with no program, the bot is
 * reprogrammed with the cleaning cycle (up and down the room at medium speed).
 */
u8 func1003_bot_programming_terminal[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2f)
	goto_next(0x04)

	label(0x2f)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_activated_object(CHR_TARGET, OBJ_BOT_PROGRAMMING_TERMINAL, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x2f)
		if_objective_failed(1, /*goto*/ 0x0b)
		if_stage_flag_eq(STAGEFLAG_BOT_ACTIVE_MAINTENANCE, TRUE, /*goto*/ 0x09)
		if_stage_flag_eq(STAGEFLAG_BOT_ACTIVE_CLEANING, TRUE, /*goto*/ 0x09)

		// Reprogramming
		play_sound(0x00f7, -1)
		show_hudmsg(CHR_TARGET, L_EAR(16)) // "Maintenance robots reprogrammed."
		set_stage_flag(STAGEFLAG_BOT_REPROGRAMMED)
		if_stage_flag_eq(STAGEFLAG_BOT_ACTIVE, TRUE, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x2f)
		yield
		play_sound(0x00f7, -1)
		show_hudmsg(CHR_TARGET, L_EAR(19)) // "Routine cleaning cycle activated."
		set_stage_flag(STAGEFLAG_BOT_ACTIVE_CLEANING)
		restart_timer

		beginloop(0x08)
			if_timer_gt(300, /*goto*/ 0x06)
		endloop(0x08)

		label(0x06)
		reloop(0x04)

		// Attempting to reprogram while bot already reprogrammed and running
		label(0x09)
		play_sound(0x00f7, -1)
		show_hudmsg(CHR_TARGET, L_EAR(20)) // "Operation not allowed - robots busy."
		restart_timer

		beginloop(0x0a)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x0a)

		label(0x06)
		reloop(0x04)

		label(0x0b)
		show_hudmsg(CHR_TARGET, L_EAR(23)) // "Maintenance robot system offline."
	endloop(0x04)

	endlist
};

u8 func1004_check_items_collected[] = {
	yield
	set_object_flag3(OBJ_K7AVENGER, OBJFLAG3_00400000)
	set_object_flag3(OBJ_NIGHTVISION, OBJFLAG3_00400000)
	set_object_flag3(OBJ_SHIELD, OBJFLAG3_00400000)

	beginloop(0x04)
		if_chr_has_object(CHR_BOND, OBJ_K7AVENGER, /*goto*/ 0x2f)
		if_chr_has_object(CHR_COOP, OBJ_K7AVENGER, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x2f)
		if_chr_has_object(CHR_BOND, OBJ_NIGHTVISION, /*goto*/ 0x2f)
		if_chr_has_object(CHR_COOP, OBJ_NIGHTVISION, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x2f)
		if_chr_has_object(CHR_BOND, OBJ_SHIELD, /*goto*/ 0x2f)
		if_chr_has_object(CHR_COOP, OBJ_SHIELD, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	yield
	set_stage_flag(STAGEFLAG_ALL_ITEMS_COLLECTED)
	unset_stage_flag(STAGEFLAG_ITEMS_UNCOLLECTABLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1018_item_pickup_messages[] = {
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x0d)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_stage_flag_eq(STAGEFLAG_HAS_K7AVENGER, TRUE, /*goto*/ 0x2f)
		if_chr_has_object(CHR_P1P2, OBJ_K7AVENGER, /*goto*/ 0x06)
		goto_next(0x2f)

		label(0x06)
		show_hudmsg(CHR_P1P2, L_EAR(86)) // "Experimental item 1 acquired."
		set_stage_flag(STAGEFLAG_HAS_K7AVENGER)
		label(0x2f)
		if_stage_flag_eq(STAGEFLAG_HAS_NIGHTVISION, TRUE, /*goto*/ 0x2f)
		if_chr_has_object(CHR_P1P2, OBJ_NIGHTVISION, /*goto*/ 0x06)
		goto_next(0x2f)

		label(0x06)
		show_hudmsg(CHR_P1P2, L_EAR(87)) // "Experimental item 2 acquired."
		set_stage_flag(STAGEFLAG_HAS_NIGHTVISION)
		label(0x2f)
		if_stage_flag_eq(STAGEFLAG_HAS_SHIELD, TRUE, /*goto*/ 0x2f)
		if_chr_has_object(CHR_P1P2, OBJ_SHIELD, /*goto*/ 0x06)
		goto_next(0x2f)

		label(0x06)
		show_hudmsg(CHR_P1P2, L_EAR(88)) // "Experimental item 3 acquired."
		set_stage_flag(STAGEFLAG_HAS_SHIELD)
		label(0x2f)
	endloop(0x04)

	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1005_check_unacceptable_casualties[] = {
	beginloop(0x04)
		if_chr_dying(0x35, /*goto*/ 0x08)
		if_chr_death_animation_finished(0x35, /*goto*/ 0x08)
		if_chr_dying(0x36, /*goto*/ 0x09)
		if_chr_death_animation_finished(0x36, /*goto*/ 0x09)
		if_chr_dying(0x37, /*goto*/ 0x0a)
		if_chr_death_animation_finished(0x37, /*goto*/ 0x0a)
		if_chr_dying(0x38, /*goto*/ 0x0a)
		if_chr_death_animation_finished(0x38, /*goto*/ 0x0a)
		reloop(0x04)

		label(0x08)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x2f)
		goto_next(0x0f)

		if_chr_dying(0x36, /*goto*/ 0x0b)
		if_chr_death_animation_finished(0x36, /*goto*/ 0x0b)
		if_chr_dying(0x37, /*goto*/ 0x0c)
		if_chr_death_animation_finished(0x37, /*goto*/ 0x0c)
		label(0x0b)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x2f)
		goto_next(0x0f)

		label(0x2f)
		if_chr_dying(0x37, /*goto*/ 0x0f)
		if_chr_death_animation_finished(0x37, /*goto*/ 0x0f)
		reloop(0x04)

		label(0x0c)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x2f)
		goto_next(0x0f)
		label(0x2f)
		reloop(0x04)

		label(0x09)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x2f)
		goto_next(0x0f)
		label(0x2f)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x2f)
		if_chr_dying(0x37, /*goto*/ 0x0f)
		if_chr_death_animation_finished(0x37, /*goto*/ 0x0f)
		label(0x2f)
	endloop(0x04)

	label(0x0a)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x2f)
	goto_next(0x0f)

	label(0x2f)
	label(0x0f)
	set_stage_flag(STAGEFLAG_UNACCEPTABLE_CASUALTIES)
	show_hudmsg(CHR_BOND, L_EAR(26)) // "Unacceptable scientist casualties."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1006_terminal_activation[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_activated_object(CHR_TARGET, OBJ_GOODTERM1, /*goto*/ 0x08)
		if_chr_activated_object(CHR_TARGET, OBJ_ALARMTERM1, /*goto*/ 0x09)
		if_chr_activated_object(CHR_TARGET, OBJ_GOODTERM2, /*goto*/ 0x0d)
		if_chr_activated_object(CHR_TARGET, OBJ_ALARMTERM2, /*goto*/ 0x0b)
		if_chr_activated_object(CHR_TARGET, OBJ_GOODTERM3, /*goto*/ 0x0f)
		if_chr_activated_object(CHR_TARGET, OBJ_ALARMTERM3, /*goto*/ 0x0c)
		if_chr_activated_object(CHR_TARGET, 0x0b, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x0c, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x0d, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x0e, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x10, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x11, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x12, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x13, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x15, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x16, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x17, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x18, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x1a, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x1b, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x1c, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x1d, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x1e, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x1f, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x20, /*goto*/ 0x2f)
		if_chr_activated_object(CHR_TARGET, 0x21, /*goto*/ 0x2f)
		endloop(0x04)

		// Inactive terminal
		label(0x2f)
		speak(CHR_TARGET, 0xffff, 0x8118, CHANNEL_9, COLOR_00_GREEN) // unknown text
		show_hudmsg(CHR_TARGET, L_EAR(27)) // "Terminal is not active."
		restart_timer

		beginloop(0x56)
			if_timer_gt(120, /*goto*/ 0x2f)
		endloop(0x56)

		label(0x2f)
		reloop(0x04)

		// Good terminal 0x07
		label(0x08)
		speak(CHR_TARGET, 0xffff, 0x8118, CHANNEL_9, COLOR_00_GREEN) // unknown text
		if_stage_flag_eq(STAGEFLAG_SHUT_DOWN_EXPERIMENT1, FALSE, /*goto*/ 0x2f)
		restart_timer

		beginloop(0x56)
			if_timer_gt(60, /*goto*/ 0x06)
		endloop(0x56)

		label(0x06)
		show_hudmsg(CHR_TARGET, L_EAR(42)) // "Experiment already powered down."
		reloop(0x04)

		label(0x2f)
		show_hudmsg(CHR_TARGET, L_EAR(28)) // "Powering down active systems."
		assign_sound(0x01c3, CHANNEL_5)
		control_sound_from_object(CHANNEL_5, OBJ_GOODTERM1, TRUE)
		restart_timer

		beginloop(0x0a)
			if_timer_gt(180, /*goto*/ 0x06)
		endloop(0x0a)

		label(0x06)
		show_hudmsg(CHR_TARGET, L_EAR(29)) // "Experiment has been shut down."
		set_stage_flag(STAGEFLAG_SHUT_DOWN_EXPERIMENT1)
		reloop(0x04)

		// Good terminal 0x08
		label(0x0d)
		speak(CHR_TARGET, 0xffff, 0x8118, CHANNEL_9, COLOR_00_GREEN) // unknown text
		if_stage_flag_eq(STAGEFLAG_SHUT_DOWN_EXPERIMENT2, FALSE, /*goto*/ 0x2f)
		restart_timer

		beginloop(0x57)
			if_timer_gt(60, /*goto*/ 0x06)
		endloop(0x57)

		label(0x06)
		show_hudmsg(CHR_TARGET, L_EAR(42)) // "Experiment already powered down."
		goto_first(0x04)

		label(0x2f)
		show_hudmsg(CHR_TARGET, L_EAR(28)) // "Powering down active systems."
		assign_sound(0x01c3, CHANNEL_5)
		control_sound_from_object(CHANNEL_5, OBJ_GOODTERM2, TRUE)
		restart_timer

		beginloop(0x0e)
			if_timer_gt(180, /*goto*/ 0x06)
		endloop(0x0e)

		label(0x06)
		show_hudmsg(CHR_TARGET, L_EAR(29)) // "Experiment has been shut down."
		set_stage_flag(STAGEFLAG_SHUT_DOWN_EXPERIMENT2)
		reloop(0x04)

		// Good terminal 0x09
		label(0x0f)
		speak(CHR_TARGET, 0xffff, 0x8118, CHANNEL_9, COLOR_00_GREEN) // unknown text
		if_stage_flag_eq(STAGEFLAG_SHUT_DOWN_EXPERIMENT3, FALSE, /*goto*/ 0x2f)
		restart_timer

		beginloop(0x58)
			if_timer_gt(60, /*goto*/ 0x06)
		endloop(0x58)

		label(0x06)
		show_hudmsg(CHR_TARGET, L_EAR(42)) // "Experiment already powered down."
		reloop(0x04)

		label(0x2f)
		show_hudmsg(CHR_TARGET, L_EAR(28)) // "Powering down active systems."
		assign_sound(0x01c3, CHANNEL_5)
		control_sound_from_object(CHANNEL_5, OBJ_GOODTERM3, TRUE)
		restart_timer

		beginloop(0x10)
			if_timer_gt(180, /*goto*/ 0x06)
		endloop(0x10)

		label(0x06)
		show_hudmsg(CHR_TARGET, L_EAR(29)) // "Experiment has been shut down."
		set_stage_flag(STAGEFLAG_SHUT_DOWN_EXPERIMENT3)
		reloop(0x04)

		// Alarm terminal 0x0f
		label(0x09)
		if_alarm_active(/*goto*/ 0x06)
		speak(CHR_TARGET, 0xffff, 0x8118, CHANNEL_9, COLOR_00_GREEN) // unknown text
		show_hudmsg(CHR_TARGET, L_EAR(30)) // "Alarm activated."
		set_stage_flag(STAGEFLAG_ALARM1_ACTIVE)
		activate_alarm
		reloop(0x04)

		label(0x06)
		show_hudmsg(CHR_TARGET, L_EAR(31)) // "Alarm deactivated."
		unset_stage_flag(STAGEFLAG_ALARM1_ACTIVE)
		deactivate_alarm
		reloop(0x04)

		// Alarm terminal 0x14
		label(0x0b)
		if_alarm_active(/*goto*/ 0x06)
		speak(CHR_TARGET, 0xffff, 0x8118, CHANNEL_9, COLOR_00_GREEN) // unknown text
		show_hudmsg(CHR_TARGET, L_EAR(30)) // "Alarm activated."
		set_stage_flag(STAGEFLAG_ALARM2_ACTIVE)
		activate_alarm
		reloop(0x04)

		label(0x06)
		show_hudmsg(CHR_TARGET, L_EAR(31)) // "Alarm deactivated."
		unset_stage_flag(STAGEFLAG_ALARM2_ACTIVE)
		deactivate_alarm
		reloop(0x04)

		// Alarm terminal 0x19
		label(0x0c)
		if_alarm_active(/*goto*/ 0x06)
		speak(CHR_TARGET, 0xffff, 0x8118, CHANNEL_9, COLOR_00_GREEN) // unknown text
		show_hudmsg(CHR_TARGET, L_EAR(30)) // "Alarm activated."
		set_stage_flag(STAGEFLAG_ALARM3_ACTIVE)
		activate_alarm
		reloop(0x04)

		label(0x06)
		show_hudmsg(CHR_TARGET, L_EAR(31)) // "Alarm deactivated."
		unset_stage_flag(STAGEFLAG_ALARM3_ACTIVE)
		deactivate_alarm
		reloop(0x04)

		label(0x2f)
	endloop(0x04)

	endlist
};

u8 func1007_uplink[] = {
	beginloop(0x04)
		if_object_in_good_condition(OBJ_UPLINKPC, /*goto*/ 0x30)
		goto_next(0x0d)

		label(0x30)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_activated_object(CHR_TARGET, OBJ_UPLINKPC, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x2f)
		if_stage_flag_eq(STAGEFLAG_UPLINK_FINISHED, FALSE, /*goto*/ 0x06)

		// Activating a second time
		speak(CHR_TARGET, 0xffff, 0x8116, CHANNEL_9, COLOR_00_GREEN) // unknown text
		show_hudmsg(CHR_TARGET, L_EAR(41)) // "Security door already unlocked."
		reloop(0x04)

		label(0x06)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_DATAUPLINK, /*goto*/ 0x2f)

		// Activated computer without uplink
		speak(CHR_TARGET, 0xffff, 0x8116, CHANNEL_9, COLOR_00_GREEN) // unknown text
		show_hudmsg(CHR_TARGET, L_EAR(36)) // "ACCESS DENIED - security code required."
		reloop(0x04)

		// Uplinking
		label(0x2f)
		show_hudmsg(CHR_TARGET, L_EAR(60)) // "Connection established."
		restart_timer

		// First second of uplinking
		beginloop(0x08)
			if_object_in_good_condition(OBJ_UPLINKPC, /*goto*/ 0x30)
			goto_next(0x0d)

			label(0x30)
			if_timer_gt(60, /*goto*/ 0x06)
			if_chr_distance_to_pad_gt(CHR_TARGET, 200, 0x025a, /*goto*/ 0x09)
			if_difficulty_lt(DIFF_SA, /*goto*/ 0x2f)
			if_stage_flag_eq(STAGEFLAG_SHUT_DOWN_EXPERIMENT1, FALSE, /*goto*/ 0x0b)
			if_stage_flag_eq(STAGEFLAG_SHUT_DOWN_EXPERIMENT2, FALSE, /*goto*/ 0x0b)
			if_stage_flag_eq(STAGEFLAG_SHUT_DOWN_EXPERIMENT3, FALSE, /*goto*/ 0x0b)
			label(0x2f)
			if_chr_weapon_equipped(CHR_TARGET, WEAPON_DATAUPLINK, /*goto*/ 0x2f)
			goto_next(0x09)
			label(0x2f)
		endloop(0x08)

		label(0x06)
		show_hudmsg(CHR_TARGET, L_EAR(37)) // "Searching for password."
		restart_timer
		set_stage_flag(STAGEFLAG_UPLINK_SEARCHING)
		assign_sound(0x01bf, CHANNEL_5)
		control_sound_from_object(CHANNEL_5, OBJ_UPLINKPC, TRUE)

		beginloop(0x14)
			if_object_in_good_condition(OBJ_UPLINKPC, /*goto*/ 0x30)
			goto_next(0x0d)

			label(0x30)
			if_timer_gt(400, /*goto*/ 0x06)
			if_chr_distance_to_pad_gt(CHR_TARGET, 200, 0x025a, /*goto*/ 0x09)
			if_chr_weapon_equipped(CHR_TARGET, WEAPON_DATAUPLINK, /*goto*/ 0x2f)
			goto_next(0x09)
			label(0x2f)
		endloop(0x14)

		label(0x06)
		mute_channel(CHANNEL_5)
		assign_sound(0x01c1, CHANNEL_6)
		control_sound_from_object(CHANNEL_6, OBJ_UPLINKPC, TRUE)
		show_hudmsg(CHR_TARGET, L_EAR(39)) // "Password located - bypassing lock."
		yield
		show_hudmsg(CHR_TARGET, L_EAR(17)) // "Security doors unlocked."
		set_stage_flag(STAGEFLAG_UPLINK_FINISHED)
		unlock_door(OBJ_UPLINKDOOR, 0x02)

		beginloop(0x15)
			if_timer_gt(90, /*goto*/ 0x06)
		endloop(0x15)

		label(0x06)
		assign_sound(0x043b, CHANNEL_6)
		control_sound_from_object(CHANNEL_6, 0x22, TRUE)
		reloop(0x04)

		// Moved away from PC or switched weapon
		label(0x09)
		show_hudmsg(CHR_TARGET, L_EAR(40)) // "Contact broken - reestablish link."
		mute_channel(CHANNEL_5)
		mute_channel(CHANNEL_6)
		assign_sound(0x01c0, CHANNEL_6)
		control_sound_from_object(CHANNEL_6, OBJ_UPLINKPC, TRUE)
		restart_timer

		beginloop(0x16)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x16)

		label(0x06)
		mute_channel(CHANNEL_6)
		reloop(0x04)

		label(0x0b)
		restart_timer

		beginloop(0x0c)
			if_timer_gt(60, /*goto*/ 0x06)
		endloop(0x0c)

		label(0x06)
		show_hudmsg(CHR_TARGET, L_EAR(85)) // "Connection broken - experiments still active."
		mute_channel(CHANNEL_5)
		mute_channel(CHANNEL_6)
		assign_sound(0x01c0, CHANNEL_6)
		control_sound_from_object(CHANNEL_6, OBJ_UPLINKPC, TRUE)
		restart_timer

		beginloop(0x17)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x17)

		label(0x06)
		mute_channel(CHANNEL_6)
	endloop(0x04)

	label(0x0d)
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_6)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1008_check_bot_terminals_destroyed[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_BOT_ACTIVE_MAINTENANCE, TRUE, /*goto*/ 0x08)
		if_stage_flag_eq(STAGEFLAG_BOT_ACTIVATION_TERMINAL_DESTROYED, TRUE, /*goto*/ 0x2f)
		if_object_in_good_condition(OBJ_BOT_ACTIVATION_TERMINAL, /*goto*/ 0x2f)
		set_stage_flag(STAGEFLAG_BOT_ACTIVATION_TERMINAL_DESTROYED)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x2f)
		show_hudmsg(CHR_BOND, L_EAR(22)) // "Critical mission object destroyed."
		label(0x2f)
		if_stage_flag_eq(STAGEFLAG_BOT_PROGRAMMING_TERMINAL_DESTROYED, TRUE, /*goto*/ 0x2f)
		if_object_in_good_condition(OBJ_BOT_PROGRAMMING_TERMINAL, /*goto*/ 0x2f)
		set_stage_flag(STAGEFLAG_BOT_PROGRAMMING_TERMINAL_DESTROYED)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x2f)
		show_hudmsg(CHR_BOND, L_EAR(22)) // "Critical mission object destroyed."
		label(0x2f)
	endloop(0x04)

	label(0x08)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1001_objectives_failed_msg[] = {
	yield
	// These are scientist chrs
	set_chr_chrflag(0x35, CHRCFLAG_04000000)
	set_chr_chrflag(0x36, CHRCFLAG_04000000)
	set_chr_chrflag(0x37, CHRCFLAG_04000000)
	set_chr_chrflag(0x38, CHRCFLAG_04000000)
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

u8 func100a_spawn_alarm_responders[] = {
	beginloop(0x04)
		if_alarm_active(/*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		if_stage_flag_eq(STAGEFLAG_ALARM_RESPONDERS_SPAWNED, TRUE, /*goto*/ 0x0c)
		set_stage_flag(STAGEFLAG_ALARM_RESPONDERS_SPAWNED)
		restart_timer

		beginloop(0x56)
			try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x005d, AILIST_ALARM_RESPONDER, 0x00000200, /*goto*/ 0x08)
		endloop(0x56)

		beginloop(0x08)
			if_timer_gt(30, /*goto*/ 0x06)
		endloop(0x08)

		label(0x06)
		beginloop(0x57)
			try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x005d, AILIST_ALARM_RESPONDER, 0x00000200, /*goto*/ 0x09)
		endloop(0x57)

		beginloop(0x09)
			if_timer_gt(30, /*goto*/ 0x06)
		endloop(0x09)

		label(0x06)
		beginloop(0x58)
			try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x005d, AILIST_ALARM_RESPONDER, 0x00000200, /*goto*/ 0x0a)
		endloop(0x58)

		beginloop(0x0a)
			if_timer_gt(30, /*goto*/ 0x06)
		endloop(0x0a)

		label(0x06)
		beginloop(0x59)
			try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x005d, AILIST_ALARM_RESPONDER, 0x00000200, /*goto*/ 0x0b)
		endloop(0x59)

		beginloop(0x0b)
			if_timer_gt(30, /*goto*/ 0x0c)
		endloop(0x0b)

		set_stage_flag(STAGEFLAG_ALARM_RESPONDERS_SPAWNED)
		label(0x0c)
	endloop(0x04)

	endlist
};

u8 func0408_alarm_responder[] = {
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2f)
	set_accuracy(20)
	goto_next(0x06)

	label(0x2f)
	set_accuracy(10)

	label(0x06)
	try_inherit_properties(0x19, /*goto*/ 0x06)
	label(0x06)
	try_equip_weapon(MODEL_CHRCMP150, WEAPON_CMP150, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	set_squadron(SQUADRON_09)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	set_self_flag_bankx(CHRFLAG0_00008000, BANK_0)
	set_alertness(90)
	set_self_chrflag(CHRCFLAG_00000200)

	// Run to scientist based on which alarm was triggered
	if_stage_flag_eq(STAGEFLAG_ALARM1_ACTIVE, TRUE, /*goto*/ 0x08)
	if_stage_flag_eq(STAGEFLAG_ALARM2_ACTIVE, TRUE, /*goto*/ 0x09)
	try_run_to_chr(0x37, /*goto*/ 0x06)
	goto_next(0x06)

	label(0x08)
	try_run_to_chr(0x35, /*goto*/ 0x06)
	goto_next(0x06)

	label(0x09)
	try_run_to_chr(0x36, /*goto*/ 0x06)
	goto_next(0x06)

	label(0x06)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_UNALERTED_0001)
	endlist
};

u8 func100b_check_uplink_pc_destroyed[] = {
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_UPLINK_FINISHED, TRUE, /*goto*/ 0x08)
		if_object_in_good_condition(OBJ_UPLINKPC, /*goto*/ 0x2f)
		set_stage_flag(STAGEFLAG_UPLINKPC_DESTROYED)
		show_hudmsg(CHR_BOND, L_EAR(22)) // "Critical mission object destroyed."
		goto_next(0x08)
		label(0x2f)
	endloop(0x04)

	label(0x08)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0411_yellowbot[] = {
	dprint 'h','o','v','\n',0,
	label(0x03)
		begin_hovercar_path(0x05)
		set_vehicle_speed(512, 120)

		beginloop(0x04)
			if_hoverbot_next_step(OPERATOR_GREATER_THAN, 10, /*goto*/ 0x06)
		endloop(0x04)

		label(0x06)
		begin_hovercar_path(0x06)
		set_vehicle_speed(512, 120)

		beginloop(0x08)
			if_hoverbot_next_step(OPERATOR_GREATER_THAN, 8, /*goto*/ 0x06)
		endloop(0x08)

		label(0x06)
	goto_first(0x03)

	endlist
};

u8 func0412_purplebot_programs[] = {
	dprint 'h','o','v','\n',0,
	if_difficulty_gt(DIFF_A, /*goto*/ 0x04)

	// Agent
	dprint 'm','o','v','\n',0,
	move_object_to_pad(OBJ_PURPLEBOT, 0x00be)
	goto_next(0x14)

	// SA or PA
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_BOT_ACTIVE_NOPROGRAM, TRUE, /*goto*/ 0x0a)
		if_stage_flag_eq(STAGEFLAG_BOT_ACTIVE_MAINTENANCE, TRUE, /*goto*/ 0x0c)
		if_stage_flag_eq(STAGEFLAG_BOT_ACTIVE_CLEANING, TRUE, /*goto*/ 0x08)
	endloop(0x04)

	// Cleaning cycle (up and down the terminal room at medium speed)
	label(0x08)
		begin_hovercar_path(0x07)
		set_vehicle_speed(512, 120)

		beginloop(0x09)
			if_stage_flag_eq(STAGEFLAG_BOT_ACTIVE_NOPROGRAM, FALSE, /*goto*/ 0x0e)
			if_hoverbot_next_step(OPERATOR_GREATER_THAN, 1, /*goto*/ 0x06)
		endloop(0x09)

		label(0x06)
	goto_first(0x08)

	// No program (small circles at low speed)
	label(0x0a)
		begin_hovercar_path(0x08)
		set_vehicle_speed(128, 120)

		beginloop(0x0b)
			if_stage_flag_eq(STAGEFLAG_BOT_ACTIVE_NOPROGRAM, FALSE, /*goto*/ 0x0e)
			if_stage_flag_eq(STAGEFLAG_BOT_ACTIVE_CLEANING, TRUE, /*goto*/ 0x10)
			if_hoverbot_next_step(OPERATOR_GREATER_THAN, 1, /*goto*/ 0x06)
		endloop(0x0b)

		label(0x06)
	goto_first(0x0a)

	// Maintenance cycle - on route to lasers (high speed)
	label(0x0c)
	begin_hovercar_path(0x09)
	set_vehicle_speed(768, 120)

	beginloop(0x0d)
		if_hoverbot_next_step(OPERATOR_GREATER_THAN, 24, /*goto*/ 0x06)
	endloop(0x0d)

	label(0x14)
	label(0x06)
	set_ailist(CHR_SELF, AILIST_PURPLEBOT_AT_LASERS)

	// Returning to offline
	label(0x0e)
	begin_hovercar_path(0x0b)
	set_vehicle_speed(512, 120)
	unset_stage_flag(STAGEFLAG_BOT_ACTIVE_CLEANING)
	unset_stage_flag(STAGEFLAG_BOT_REPROGRAMMED)
	unset_stage_flag(STAGEFLAG_BOT_ACTIVE)

	beginloop(0x0f)
		if_stage_flag_eq(STAGEFLAG_BOT_ACTIVE_NOPROGRAM, TRUE, /*goto*/ 0x11)
		if_stage_flag_eq(STAGEFLAG_BOT_ACTIVE_MAINTENANCE, TRUE, /*goto*/ 0x12)
		if_stage_flag_eq(STAGEFLAG_BOT_ACTIVE_CLEANING, TRUE, /*goto*/ 0x10)
		if_hoverbot_next_step(OPERATOR_GREATER_THAN, 1, /*goto*/ 0x06)
	endloop(0x0f)

	label(0x06)
	set_vehicle_speed(0, 1)
	goto_first(0x04)

	label(0x11)
	goto_first(0x0a)

	label(0x12)
	goto_first(0x0a)

	label(0x10)
	goto_first(0x08)

	endlist
};

u8 func0413_purplebot_at_lasers[] = {
	label(0x03)
	begin_hovercar_path(0x0a)
	set_vehicle_speed(512, 120)

	beginloop(0x13)
	endloop(0x13)

	endlist
};

u8 func100c_shuffle_terminals[] = {
	shuffle_investigation_terminals(OBJ_GOODTERM1, OBJ_ALARMTERM1, 0x1e, 0x1f, 0x20, 0x21)
	shuffle_investigation_terminals(OBJ_GOODTERM2, OBJ_ALARMTERM2, 0x1a, 0x1b, 0x1c, 0x1d)
	shuffle_investigation_terminals(OBJ_GOODTERM3, OBJ_ALARMTERM3, 0x15, 0x16, 0x17, 0x18)
	yield
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100e_experiment_terminals_destroyed[] = {
	beginloop(0x04)
		if_object_in_good_condition(OBJ_GOODTERM1, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_GOODTERM_DESTROYED, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_SHUT_DOWN_EXPERIMENT1, TRUE, /*goto*/ 0x2f)
		set_stage_flag(STAGEFLAG_GOODTERM_DESTROYED)
		show_hudmsg(CHR_BOND, L_EAR(22)) // "Critical mission object destroyed."

		label(0x2f)
		if_object_in_good_condition(OBJ_GOODTERM2, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_GOODTERM_DESTROYED, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_SHUT_DOWN_EXPERIMENT2, TRUE, /*goto*/ 0x2f)
		set_stage_flag(STAGEFLAG_GOODTERM_DESTROYED)
		show_hudmsg(CHR_BOND, L_EAR(22)) // "Critical mission object destroyed."

		label(0x2f)
		if_object_in_good_condition(0x09, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_GOODTERM_DESTROYED, TRUE, /*goto*/ 0x2f)
		if_stage_flag_eq(STAGEFLAG_SHUT_DOWN_EXPERIMENT3, TRUE, /*goto*/ 0x2f)
		set_stage_flag(STAGEFLAG_GOODTERM_DESTROYED)
		show_hudmsg(CHR_BOND, L_EAR(22)) // "Critical mission object destroyed."

		label(0x2f)
	endloop(0x04)

	endlist
};

u8 func0416_intro[] = {
	set_music_track(MUSIC_INVESTIGATION_INTRO)
	camera_movement(0x00f5)
	cmd0175(60)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)

	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_00010000)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x00f6, -1, -1, 0x06, 0x00, CHR_BOND, 4)

	set_chr_chrflag(CHR_INTRO_GUARD, CHRCFLAG_UNPLAYABLE)
	set_chr_chrflag(CHR_INTRO_GUARD, CHRCFLAG_00010000)
	unset_chr_chrflag(CHR_INTRO_GUARD, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_INTRO_GUARD, CHRHFLAG_00020000)
	chr_do_animation(0x00f7, -1, -1, 0x06, 0x00, CHR_INTRO_GUARD, 4)

	restart_timer
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 90)
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_FALCON2, WEAPON_NONE)

	#define wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0x77) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)



	wait_until(0, 0x56)
	play_sound(0x01d5, CHANNEL_7)

	wait_until(250, 0x57)
	play_sound(0x00ec, CHANNEL_10)

	wait_until(270, 0x58)
	play_sound(0x0171, CHANNEL_10)

	wait_until(290, 0x59)
	play_sound(0x0172, CHANNEL_10)

	wait_until(320, 0x5a)
	play_sound(0x0174, CHANNEL_10)

	wait_until(380, 0x5b)
	open_door(0x24)
	play_sound(0x0165, CHANNEL_7)

	wait_until(580, 0x5c)
	play_sound(0x01d2, CHANNEL_7)

	wait_until(950, 0x5d)
	play_sound(0x0172, CHANNEL_7)

	wait_until(990, 0x5e)
	play_sound(0x0171, CHANNEL_7)

	wait_until(1060, 0x5f)
	play_sound(0x0172, CHANNEL_7)

	wait_until(1090, 0x60)
	play_sound(0x0173, CHANNEL_7)

	wait_until(1140, 0x61)
	play_sound(0x01d3, CHANNEL_7)

	wait_until(1190, 0x62)
	play_sound(0x0031, CHANNEL_7)

	wait_until(1196, 0x68)
	play_sound(0x008f, CHANNEL_6)

	wait_until(1310, 0x63)
	play_sound(0x0085, CHANNEL_7)

	wait_until(1370, 0x64)
	play_sound(0x007b, CHANNEL_7)

	wait_until(1410, 0x65)
	play_sound(0x0175, CHANNEL_7)

	wait_until(1430, 0x66)
	play_sound(0x0176, CHANNEL_7)

	wait_until(1600, 0x67)
	play_sound(0x0171, CHANNEL_7)

	beginloop(0x08)
		if_camera_animating(/*goto*/ 0x2f)
		goto_next(0x77)
		label(0x2f)
		if_controller_button_pressed(/*goto*/ 0x77)
		label(0x2f)
	endloop(0x08)

	label(0x77)
	set_door_open(0x24)
	set_door_open(0x40)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_00010000)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x00f6, -2, -1, 0x06, 0x00, CHR_BOND, 2)

	unset_chr_chrflag(CHR_INTRO_GUARD, CHRCFLAG_UNPLAYABLE)
	set_chr_chrflag(CHR_INTRO_GUARD, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_hiddenflag(CHR_INTRO_GUARD, CHRHFLAG_00020000)
	chr_do_animation(0x00f7, -2, -1, 0x06, 0x00, CHR_INTRO_GUARD, 2)

	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	restart_default_music
	reset_ambience
	enter_firstperson
	yield
	chr_do_animation(0x020b, -1, -1, 0x06, 0x00, CHR_INTRO_GUARD, 2)
	yield
	kill(CHR_INTRO_GUARD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0417_outro[] = {
	set_music_track(MUSIC_INVESTIGATION_OUTRO)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0xf1, CHRCFLAG_HIDDEN)
	set_stage_flag(STAGEFLAG_TRIGGER_OUTRO_AUDIO)

	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_P1P2, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_P1P2, CHRHFLAG_00020000)

	set_ailist(CHR_DRCAROLL, GAILIST_IDLE)
	set_ailist(CHR_K7_GUARD, GAILIST_IDLE)
	restart_timer
	dprint 's','h','o','t',' ','1',0,
	camera_movement(0x00f9)
	chr_do_animation(0x00fa, -1, -1, 0x06, 0x00, CHR_P1P2, 2)
	set_cutscene_weapon(CHR_P1P2, -1, -1)
	yield
	set_cutscene_weapon(CHR_P1P2, -1, WEAPON_FALCON2)
	show_nonessential_chrs(FALSE)

	#define wait_for_camera(loopid) \
		beginloop(loopid) \
			if_camera_animating(/*goto*/ 0x2f) \
			goto_next(0x06) \
			label(0x2f) \
			if_controller_button_pressed(/*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)



	wait_for_camera(0x08)

	dprint 's','h','o','t',' ','2',0,
	if_controller_button_pressed(/*goto*/ 0x06)
	camera_movement(0x0140)
	chr_do_animation(0x0141, -1, -1, 0x06, 0x00, CHR_P1P2, 2)

	wait_for_camera(0x09)

	dprint 's','h','o','t',' ','3',0,
	if_controller_button_pressed(/*goto*/ 0x06)
	camera_movement(0x0143)
	chr_do_animation(0x0144, -1, -1, 0x06, 0x00, CHR_P1P2, 2)

	wait_for_camera(0x0a)

	dprint 's','h','o','t',' ','4',0,
	if_controller_button_pressed(/*goto*/ 0x06)
	camera_movement(0x0146)
	chr_do_animation(0x0147, -1, -1, 0x06, 0x00, CHR_P1P2, 2)
	restart_timer

	beginloop(0x0b)
		if_camera_animating(/*goto*/ 0x2f)
		goto_next(0x06)
		label(0x2f)
		if_controller_button_pressed(/*goto*/ 0x06)
		if_timer_gt(282, /*goto*/ 0x2f)
	endloop(0x0b)

	label(0x2f)
	open_door(0x23)

	beginloop(0x5f)
		if_camera_animating(/*goto*/ 0x2f)
		goto_next(0x06)
		label(0x2f)
		if_controller_button_pressed(/*goto*/ 0x06)
	endloop(0x5f)

	label(0x2f)
	label(0x06)
	dprint 's','h','o','t',' ','5',0,
	if_controller_button_pressed(/*goto*/ 0x06)
	unset_chr_chrflag(CHR_DRCAROLL, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_DRCAROLL, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_DRCAROLL, CHRHFLAG_00020000)
	camera_movement(0x0149)
	chr_do_animation(0x014a, -1, -1, 0x06, 0x00, CHR_P1P2, 2)
	chr_do_animation(0x014b, -1, -1, 0x06, 0x00, CHR_DRCAROLL, 2)

	wait_for_camera(0x0c)

	dprint 's','h','o','t',' ','6',0,
	if_controller_button_pressed(/*goto*/ 0x06)
	camera_movement(0x014c)
	chr_do_animation(0x014d, -1, -1, 0x06, 0x00, CHR_P1P2, 2)
	chr_do_animation(0x014e, -1, -1, 0x06, 0x00, CHR_DRCAROLL, 2)

	wait_for_camera(0x0d)

	dprint 's','h','o','t',' ','7',0,
	if_controller_button_pressed(/*goto*/ 0x06)
	camera_movement(0x014f)
	chr_do_animation(0x0150, -1, -1, 0x06, 0x00, CHR_P1P2, 2)
	chr_do_animation(0x0151, -1, -1, 0x06, 0x00, CHR_DRCAROLL, 2)

	wait_for_camera(0x0e)

	dprint 's','h','o','t',' ','8',0,
	camera_movement(0x0152)
	chr_do_animation(0x0153, -1, -1, 0x06, 0x00, CHR_P1P2, 2)
	chr_do_animation(0x0154, -1, -1, 0x06, 0x00, CHR_DRCAROLL, 2)

	wait_for_camera(0x0f)

	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1010_intro_from_menu[] = {
	set_returnlist(CHR_SELF, GAILIST_END_CINEMA)
	set_ailist(CHR_SELF, 0x0416)
	endlist
};

u8 func0417_outro_from_menu[] = {
	set_returnlist(CHR_SELF, GAILIST_END_CINEMA)
	set_ailist(CHR_SELF, AILIST_OUTRO)
	endlist
};

u8 unregistered_function1[] = {
	set_returnlist(CHR_SELF, 0x0419)
	set_ailist(CHR_SELF, 0x0416)
	endlist
};

u8 unregistered_function2[] = {
	set_returnlist(CHR_SELF, 0x041a)
	set_ailist(CHR_SELF, AILIST_OUTRO)
	endlist
};

u8 func1415_outro_audio[] = {
	label(0x79)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_OUTRO_AUDIO, TRUE, /*goto*/ 0x7a)
		yield
	goto_first(0x79)

	label(0x7a)
	unset_stage_flag(STAGEFLAG_TRIGGER_OUTRO_AUDIO)
	label(0x2f)
	restart_timer
	hide_object(0x37)
	hide_object(0x38)
	mute_channel(CHANNEL_0)
	mute_channel(CHANNEL_1)
	mute_channel(CHANNEL_2)
	mute_channel(CHANNEL_3)
	mute_channel(CHANNEL_4)
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_7)

	#define outro_wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0x77) \
			if_timer_gt(time, /*goto*/ 0x06) \
		endloop(loopid) \
		label(0x06)



	outro_wait_until(78, 0x56)
	play_sound(0x0161, CHANNEL_6)

	outro_wait_until(116, 0x57)
	play_sound(0x0165, CHANNEL_7)

	outro_wait_until(131, 0x58)
	play_sound(0x0166, CHANNEL_5)

	outro_wait_until(162, 0x59)
	play_sound(0x0167, CHANNEL_6)

	outro_wait_until(197, 0x5a)
	play_sound(0x0168, CHANNEL_7)

	outro_wait_until(236, 0x5b)
	play_sound(0x0167, CHANNEL_5)

	outro_wait_until(266, 0x5c)
	play_sound(0x0168, CHANNEL_6)

	outro_wait_until(281, 0x5d)
	play_sound(0x0165, CHANNEL_7)

	outro_wait_until(335, 0x5e)
	play_sound(0x0162, CHANNEL_5)

	outro_wait_until(384, 0x5f)
	play_sound(0x0163, CHANNEL_6)

	outro_wait_until(415, 0x60)
	play_sound(0x0164, CHANNEL_7)

	outro_wait_until(434, 0x61)
	play_sound(0x0163, CHANNEL_5)

	outro_wait_until(474, 0x62)
	play_sound(0x0164, CHANNEL_6)

	outro_wait_until(511, 0x63)
	play_sound(0x0163, CHANNEL_7)

	outro_wait_until(356, 0x65)
	play_sound(0x0164, CHANNEL_5)

	outro_wait_until(581, 0x66)
	play_sound(0x0161, CHANNEL_6)

	outro_wait_until(620, 0x68)
	speak(CHR_P1P2, L_EAR(100), 0x73ec, CHANNEL_7, COLOR_09_BLUE) // "Dr. Caroll?"

	outro_wait_until(676, 0x67)
	play_sound(0x0162, CHANNEL_6)

	outro_wait_until(747, 0x69)
	play_sound(0x0163, CHANNEL_5)

	outro_wait_until(750, 0x6a)
	speak(CHR_P1P2, L_EAR(101), 0x73ed, CHANNEL_7, COLOR_09_BLUE) // "Dr. Caroll, are you here?"

	outro_wait_until(864, 0x6b)
	speak(CHR_P1P2, L_EAR(102), 0x73ee, CHANNEL_7, COLOR_04_ORANGE) // "Well, is it safe to come out?"

	outro_wait_until(1027, 0x6c)
	speak(CHR_P1P2, L_EAR(103), 0x73ef, CHANNEL_7, COLOR_09_BLUE) // "Yes, all clear."

	outro_wait_until(1200, 0x6f)
	mute_channel(CHANNEL_6)

	play_sound(0x042c, CHANNEL_4)
	outro_wait_until(1219, 0x70)

	outro_wait_until(1254, 0x71)
	speak(CHR_P1P2, L_EAR(104), 0x73f0, CHANNEL_7, COLOR_09_BLUE) // "Wh..what... you're..."

	outro_wait_until(1460, 0x73)
	speak(CHR_P1P2, L_EAR(105), 0x73f1, CHANNEL_7, COLOR_04_ORANGE) // "Very professionally done, my dear, but there's no ..."

	outro_wait_until(1556, 0x74)
	mute_channel(CHANNEL_5)
	play_sound(0x042c, CHANNEL_6)

	outro_wait_until(1900, 0x75)
	speak(CHR_P1P2, L_EAR(106), 0x73f2, CHANNEL_7, COLOR_04_ORANGE) // "Come on. I have vital information, and you must pr..."

	outro_wait_until(2200, 0x76)
	play_sound(0x0161, CHANNEL_6)

	label(0x77)
	goto_first(0x79)

	endlist
};

u8 func100f_check_for_end_level[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0063, /*goto*/ 0x2f)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0065, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x2f)
		if_door_state(0x26, (DOORSTATE_OPEN | DOORSTATE_CLOSING | DOORSTATE_OPENING), /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		set_stage_flag(STAGEFLAG_DRCAROLL_LOCATED)
		dprint 's','h','o','t',' ','6',0,
		yield
		if_all_objectives_complete(/*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x2f)
	if_chr_dying(CHR_BOND, /*goto*/ 0x2f)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x2f)
	if_chr_dying(CHR_COOP, /*goto*/ 0x2f)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x2f)
	goto_next(0x06)

	label(0x2f)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	set_invincible(CHR_BOND)
	set_ailist(CHR_SELF, AILIST_OUTRO)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1400_setup_counterop[] = {
	yield
	set_chr_team(CHR_ANTI, TEAM_ENEMY)
	give_object_to_chr(OBJ_DATAUPLINK_BOND, CHR_BOND)
	give_object_to_chr(OBJ_DATAUPLINK_COOP, CHR_COOP)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func1011_spawn_guards_during_uplink[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x0d)
	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_UPLINK_SEARCHING, TRUE, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	restart_timer
	try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x0131, AILIST_UPLINK_RESPONDER, 0x00000210, /*goto*/ 0x09)

	beginloop(0x09)
		if_timer_gt(30, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	try_spawn_chr_at_pad(BODY_DDSHOCK, HEAD_RANDOM, 0x0132, AILIST_UPLINK_RESPONDER, 0x00000210, /*goto*/ 0x0a)

	beginloop(0x0a)
		if_timer_gt(60, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0409_uplink_responder[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2f)
	set_accuracy(20)
	goto_next(0x06)

	label(0x2f)
	set_accuracy(10)

	label(0x06)
	try_equip_weapon(MODEL_CHRCMP150, WEAPON_CMP150, 0x00000000, /*goto*/ 0x06)
	label(0x06)
	set_chr_team(CHR_SELF, TEAM_ENEMY)
	set_squadron(SQUADRON_09)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	set_self_flag_bankx(CHRFLAG0_00008000, BANK_0)
	set_alertness(110)
	set_self_chrflag(CHRCFLAG_00000200)
	label(0x06)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func1012_start_laser_sound[] = {
	label(0x04)
	yield
	assign_sound(0x8119, CHANNEL_0)
	play_sound_from_object(CHANNEL_0, 0x28, 0x012c, 0x0190)
	label(0x2f)
	assign_sound(0x811a, CHANNEL_1)
	play_sound_from_object(CHANNEL_1, 0x2d, 0x012c, 0x0190)
	label(0x2f)
	assign_sound(0x8119, CHANNEL_2)
	play_sound_from_object(CHANNEL_2, 0x32, 0x012c, 0x0190)
	assign_sound(0x01c5, CHANNEL_3)
	play_sound_from_object(CHANNEL_3, 0x38, 0x0258, 0x0320)
	assign_sound(0x01c5, CHANNEL_4)
	play_sound_from_object(CHANNEL_4, 0x37, 0x0258, 0x0320)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1013_hatch_pc[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_activated_object(CHR_TARGET, OBJ_HATCHPC, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		if_door_locked(0x3f, 0x08, /*goto*/ 0x56)
		goto_next(0x2f)

		label(0x56)
		play_sound(0x00f7, -1)
		show_hudmsg(CHR_TARGET, L_EAR(61)) // "Maintenance hatch is now open."
		unlock_door(0x3f, 0x08)
		reloop(0x04)

		label(0x2f)
		show_hudmsg(CHR_TARGET, L_EAR(62)) // "Maintenance hatch is already open."
		restart_timer

		beginloop(0x57)
			if_timer_gt(120, /*goto*/ 0x2f)
		endloop(0x57)

		label(0x2f)
	endloop(0x04)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0415_radioactivity[] = {
	restart_timer

	beginloop(0x04)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0014, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0015, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0016, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0017, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0018, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0019, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x001a, /*goto*/ 0x06)
		reloop(0x04)

		label(0x06)
		show_hudmsg(CHR_TARGET, L_EAR(63)) // "WARNING - radioactive matter detected."
		restart_timer
		label(0x08)
		yield
		add_motion_blur(CHR_TARGET, 10, TRUE)
		if_timer_lt(300, /*goto*/ 0x2f)
		restart_timer
		damage_chr2(CHR_TARGET, 1024)
		label(0x2f)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0014, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0015, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0016, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0017, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0018, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0019, /*goto*/ 0x06)
		if_chr_in_room(CHR_TARGET, 0x00, 0x001a, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	goto_first(0x08)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1014_jo_radioactivity[] = {
	set_target_chr(CHR_BOND)
	set_ailist(CHR_SELF, AILIST_RADIOACTIVITY)
	endlist
};

u8 func101d_coop_radioactivty[] = {
	yield
	set_target_chr(CHR_COOP)
	if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x2f)
	set_ailist(CHR_SELF, AILIST_RADIOACTIVITY)
	label(0x2f)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1021_counterop_radioactivity[] = {
	yield
	set_target_chr(CHR_ANTI)
	if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x2f)
	set_ailist(CHR_SELF, AILIST_RADIOACTIVITY)
	label(0x2f)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0402_k7_guard[] = {
	set_accuracy(20)
	set_reaction_speed(100)
	set_shotlist(GAILIST_ALERTED)

	beginloop(0x0f)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		set_chrpreset(CHR_P1P2)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0036, /*goto*/ 0x03)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0037, /*goto*/ 0x03)
		if_chr_in_room(CHR_TARGET, 0x00, 0x003a, /*goto*/ 0x03)
	endloop(0x0f)

	label(0x03)
		restart_timer
		call_rng
		if_rand_gt(128, /*goto*/ 0x06)
		label(0x2f)
		say_quip(CHR_PRESET, 0x09, 0xff, 0x02, 0xff, BANK_1, 0x00, 0x00)
		label(0x06)

		beginloop(0x04)
			chr_toggle_p1p2(CHR_SELF)
			set_target_chr(CHR_P1P2)
			if_target_in_sight(/*goto*/ 0x0c)
			if_near_miss(/*goto*/ 0x0c)
			if_num_times_shot_gt(0, /*goto*/ 0x0c)
			if_saw_injury(0x00, /*goto*/ 0x0c)
			if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x0c)
			if_timer_gt(120, /*goto*/ 0x06)
		endloop(0x04)

		label(0x06)
		try_aim_and_shoot_thing1(0x0028, 0x0159, /*goto*/ 0x2f)
		label(0x2f)
		try_aim_and_shoot_thing2(0x0008, 0x0159, /*goto*/ 0x2f)
		label(0x2f)
		say_quip(CHR_BOND, 0x00, 0x32, 0x02, 0xff, BANK_0, 0x00, 0x00)

		beginloop(0x08)
			chr_toggle_p1p2(CHR_SELF)
			set_target_chr(CHR_P1P2)
			if_target_in_sight(/*goto*/ 0x0c)
			if_near_miss(/*goto*/ 0x0c)
			if_num_times_shot_gt(0, /*goto*/ 0x0c)
			if_saw_injury(0x00, /*goto*/ 0x0c)
			if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x0c)
			if_chr_stopped(/*goto*/ 0x2f)
		goto_first(0x08)

		label(0x2f)
		call_rng
		if_rand_gt(200, /*goto*/ 0x2f)
	goto_first(0x03)

	label(0x2f)
	stop_chr
	restart_timer
	call_rng
	if_rand_gt(128, /*goto*/ 0x06)
	assign_sound(0x1299, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)

	beginloop(0x0c)
		if_timer_gt(120, /*goto*/ 0x2f)
	endloop(0x0c)

	label(0x2f)
	say_quip(CHR_PRESET, 0x08, 0xff, 0x02, 0xff, BANK_1, 0x00, 0x00)
	label(0x06)
	if_chr_distance_to_pad_lt(CHR_SELF, 100, 0x013b, /*goto*/ 0x2f)
	walk_to_pad(0x013b)
	label(0x2f)
	restart_timer

	beginloop(0x09)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x0c)
		if_near_miss(/*goto*/ 0x0c)
		if_num_times_shot_gt(0, /*goto*/ 0x0c)
		if_saw_injury(0x00, /*goto*/ 0x0c)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x0c)
		if_timer_gt(180, /*goto*/ 0x06)
	endloop(0x09)

	label(0x06)
	restart_timer

	beginloop(0x0a)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x0c)
		if_near_miss(/*goto*/ 0x0c)
		if_num_times_shot_gt(0, /*goto*/ 0x0c)
		if_saw_injury(0x00, /*goto*/ 0x0c)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x0c)
		if_timer_gt(300, /*goto*/ 0x06)
	endloop(0x0a)

	label(0x06)
	goto_first(0x03)

	label(0x0c)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func0403_k7_scientist[] = {
	beginloop(0x14)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0035, /*goto*/ 0x03)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0036, /*goto*/ 0x03)
		if_chr_in_room(CHR_TARGET, 0x00, 0x0037, /*goto*/ 0x03)
		if_chr_in_room(CHR_TARGET, 0x00, 0x003a, /*goto*/ 0x03)
	endloop(0x14)

	label(0x03)
		stop_chr
		restart_timer

		beginloop(0x08)
			chr_toggle_p1p2(CHR_SELF)
			set_target_chr(CHR_P1P2)
			if_target_in_sight(/*goto*/ 0x0c)
			if_near_miss(/*goto*/ 0x0c)
			if_num_times_shot_gt(0, /*goto*/ 0x0c)
			if_saw_injury(0x00, /*goto*/ 0x0c)
			if_saw_death(0x00, /*goto*/ 0x0c)
			if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x0c)
			call_rng
			if_rand_lt(1, /*goto*/ 0x06)
		endloop(0x08)

		label(0x06)
		call_rng
		if_rand_lt(64, /*goto*/ 0x09)
		if_rand_lt(128, /*goto*/ 0x0a)
		if_rand_lt(196, /*goto*/ 0x0b)
		chr_do_animation(ANIM_GRAB_CROTCH, 0, -1, 0x10, 0x10, CHR_SELF, 2)
		goto_next(0x0f)
		label(0x09)
		chr_do_animation(ANIM_YAWN, 0, -1, 0x10, 0x10, CHR_SELF, 2)
		goto_next(0x0f)
		label(0x0a)
		chr_do_animation(ANIM_ROLL_HEAD, 0, -1, 0x10, 0x10, CHR_SELF, 2)
		goto_next(0x0f)
		label(0x0b)
		chr_do_animation(ANIM_GRAB_BUTT, 0, -1, 0x10, 0x10, CHR_SELF, 2)
		goto_next(0x0f)

		beginloop(0x0f)
			chr_toggle_p1p2(CHR_SELF)
			set_target_chr(CHR_P1P2)
			if_target_in_sight(/*goto*/ 0x0c)
			if_near_miss(/*goto*/ 0x0c)
			if_num_times_shot_gt(0, /*goto*/ 0x0c)
			if_saw_injury(0x00, /*goto*/ 0x0c)
			if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x0c)
			if_chr_stopped(/*goto*/ 0x2f)
		endloop(0x0f)

		label(0x2f)
	goto_first(0x03)

	label(0x0c)
	assign_sound(0x128f, CHANNEL_6)
	play_sound_from_entity(CHANNEL_6, CHR_SELF, 0x0bb8, 0x1770, 0x01)
	increase_squadron_alertness(100)
	jog_to_pad(0x0133)

	beginloop(0x0d)
		if_chr_stopped(/*goto*/ 0x10)
	endloop(0x0d)

	label(0x10)
		chr_do_animation(ANIM_COWER_0229, -1, -1, 0x10, 0x0a, CHR_SELF, 2)

		beginloop(0x0e)
			if_chr_stopped(/*goto*/ 0x2f)
		endloop(0x0e)

		label(0x2f)
	goto_first(0x10)

	endlist
};

u8 func1016_setup_drcaroll[] = {
	set_chr_chrflag(CHR_DRCAROLL, CHRCFLAG_HIDDEN)
	set_ailist(CHR_DRCAROLL, GAILIST_INVINCIBLE_AND_IDLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040a_init_basic_guard[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(1)
	set_reaction_speed(20)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func040b_init_shock_guard[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(11)
	set_reaction_speed(20)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(10)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func1019_msg_securitysector[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0052, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	speak(CHR_P1P2, L_EAR(94), 0x8173, CHANNEL_6, COLOR_09_BLUE) // "That's the highest security sector - Dr. Caroll ha..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101a_msg_lotofpower[] = {
	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0031, /*goto*/ 0x2f)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0042, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	speak(CHR_P1P2, L_EAR(95), 0x73a5, CHANNEL_6, COLOR_09_BLUE) // "Something around here's using a lot of power."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101b_msg_reprogram[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x08)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0026, /*goto*/ 0x2f)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0024, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	speak(CHR_P1P2, L_EAR(96), 0x8174, CHANNEL_6, COLOR_09_BLUE) // "Reprogram that cleaning bot - it'll give you a way..."
	label(0x08)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101c_msg_radioactive[] = {
	beginloop(0x04)
		if_objective_complete(0, /*goto*/ 0x06)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0014, /*goto*/ 0x2f)
	endloop(0x04)

	label(0x2f)
	speak(CHR_P1P2, L_EAR(97), 0x8175, CHANNEL_6, COLOR_09_BLUE) // "Get out, Jo! The levels are too high. Use the CamS..."
	label(0x06)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101e_unlock_drcaroll_door[] = {
	beginloop(0x04)
		if_objective_complete(0, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x2f)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x06)
		if_objective_complete(1, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x2f)
		if_objective_complete(2, /*goto*/ 0x2f)
		reloop(0x04)

		label(0x2f)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x06)
		if_objective_complete(3, /*goto*/ 0x06)
	endloop(0x04)

	label(0x06)
	unlock_door(0x26, 0x40)
	unlock_door(0x5a, 0x40)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101f_check_bot_destroyed[] = {
	beginloop(0x04)
		if_object_in_good_condition(OBJ_PURPLEBOT, /*goto*/ 0x2f)
		goto_next(0x08)
		label(0x2f)
	endloop(0x04)

	// 0x32 is a laser
	beginloop(0x08)
		if_door_state(0x32, DOORSTATE_CLOSED, /*goto*/ 0x2f)
	endloop(0x08)

	label(0x2f)
	if_chr_in_room(CHR_BOND, 0x00, 0x004d, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x004e, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x004f, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0050, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0051, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0052, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0053, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0054, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0055, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0056, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0057, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0058, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0059, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x005a, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x005b, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x005c, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x005d, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x005e, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x005f, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0061, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0062, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0063, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x006c, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x006b, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0069, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0068, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x006d, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x006e, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0064, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0065, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0066, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0060, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x0067, /*goto*/ 0x06)
	if_chr_in_room(CHR_BOND, 0x00, 0x006a, /*goto*/ 0x06)

	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x0b)
	if_chr_in_room(CHR_COOP, 0x00, 0x004d, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x004e, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x004f, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0050, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0051, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0052, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0053, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0054, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0055, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0056, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0057, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0058, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0059, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x005a, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x005b, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x005c, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x005d, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x005e, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x005f, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0061, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0062, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0063, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x006c, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x006b, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0069, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0068, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x006d, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x006e, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0064, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0065, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0066, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0060, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x0067, /*goto*/ 0x06)
	if_chr_in_room(CHR_COOP, 0x00, 0x006a, /*goto*/ 0x06)

	label(0x0b)
	show_hudmsg(CHR_BOND, L_EAR(22)) // "Critical mission object destroyed."
	set_stage_flag(STAGEFLAG_00000008)
	set_stage_flag(STAGEFLAG_00000004)
	if_stage_flag_eq(STAGEFLAG_HAS_K7AVENGER, TRUE, /*goto*/ 0x2f)
	set_stage_flag(STAGEFLAG_ITEMS_UNCOLLECTABLE)
	label(0x2f)
	if_stage_flag_eq(STAGEFLAG_HAS_NIGHTVISION, TRUE, /*goto*/ 0x2f)
	set_stage_flag(STAGEFLAG_ITEMS_UNCOLLECTABLE)
	label(0x2f)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x06)
	if_objective_complete(0, /*goto*/ 0x2f)
	goto_first(0x0b)

	label(0x2f)
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x2f)
	if_objective_complete(2, /*goto*/ 0x2f)
	goto_first(0x0b)

	label(0x2f)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x0d)
	if_chr_has_object(CHR_BOND, OBJ_K7AVENGER, /*goto*/ 0x2f)
	if_chr_has_object(CHR_COOP, OBJ_K7AVENGER, /*goto*/ 0x2f)
	goto_first(0x0b)

	label(0x2f)
	if_chr_has_object(CHR_BOND, OBJ_NIGHTVISION, /*goto*/ 0x2f)
	if_chr_has_object(CHR_COOP, OBJ_NIGHTVISION, /*goto*/ 0x2f)
	label(0x0d)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1020_lock_agent_doors[] = {
	label(0x04)
	yield
	if_difficulty_gt(DIFF_A, /*goto*/ 0x2f)
	lock_door(0x5b, 0x08)
	lock_door(0x5c, 0x08)
	lock_door(0x5d, 0x08)
	lock_door(0x5e, 0x08)
	lock_door(0x5f, 0x08)
	label(0x2f)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1022_setup_rtracker[] = {
	yield
	set_object_flag3(OBJ_CMP150_1, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(OBJ_CMP150_2, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(OBJ_PROXYMINES, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1423_setup_lighting[] = {
	yield
	misc_command(0x0000, 0x00, 0x00)
	misc_command(0x0000, 0x01, 0x00)
	misc_command(0x0000, 0x02, 0x00)
	misc_command(0x0000, 0x03, 0x00)
	misc_command(0x0000, 0x04, 0x00)
	misc_command(0x0001, 0x05, 0x01)
	misc_command(0x0006, 0x05, 0x01)
	misc_command(0x0007, 0x05, 0x01)
	misc_command(0x0014, 0x05, 0x01)
	misc_command(0x0015, 0x05, 0x01)
	misc_command(0x0016, 0x05, 0x01)
	misc_command(0x0017, 0x05, 0x01)
	misc_command(0x0018, 0x05, 0x01)
	misc_command(0x0019, 0x05, 0x01)
	misc_command(0x001a, 0x05, 0x01)
	misc_command(0x0023, 0x05, 0x01)
	misc_command(0x0024, 0x05, 0x01)
	misc_command(0x0025, 0x05, 0x01)
	misc_command(0x0026, 0x05, 0x01)
	misc_command(0x0027, 0x05, 0x01)
	misc_command(0x0028, 0x05, 0x01)
	misc_command(0x0029, 0x05, 0x01)
	misc_command(0x0031, 0x05, 0x01)
	misc_command(0x0032, 0x05, 0x01)
	misc_command(0x0034, 0x05, 0x01)
	misc_command(0x0035, 0x05, 0x01)
	misc_command(0x0036, 0x05, 0x01)
	misc_command(0x003e, 0x05, 0x01)
	misc_command(0x003f, 0x05, 0x01)
	misc_command(0x0042, 0x05, 0x01)
	misc_command(0x0043, 0x05, 0x01)
	misc_command(0x0044, 0x05, 0x01)
	misc_command(0x0045, 0x05, 0x01)
	misc_command(0x0046, 0x05, 0x01)
	misc_command(0x005e, 0x05, 0x01)
	misc_command(0x005f, 0x05, 0x01)
	misc_command(0x0060, 0x05, 0x01)
	misc_command(0x0064, 0x05, 0x01)
	misc_command(0x0065, 0x05, 0x01)
	misc_command(0x0066, 0x05, 0x01)
	misc_command(0x0067, 0x05, 0x01)
	misc_command(0x0069, 0x05, 0x01)
	misc_command(0x006a, 0x05, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1424_start_lift[] = {
	activate_lift(1, 0x60)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

struct ailist ailists[] = {
	{ func0401_init_chr_with_flag,             0x0401 },
	{ func0402_k7_guard,                       0x0402 },
	{ func0403_k7_scientist,                   0x0403 },
	{ func0404_scientist,                      0x0404 },
	{ func0405_init_scientist,                 0x0405 },
	{ func0406_nasty_scientist,                0x0406 },
	{ func0407_init_nasty_scientist,           0x0407 },
	{ func0408_alarm_responder,                0x0408 },
	{ func0409_uplink_responder,               0x0409 },
	{ func040a_init_basic_guard,               0x040a },
	{ func040b_init_shock_guard,               0x040b },
	{ func040c_start_path00,                   0x040c },
	{ func040d_start_path01,                   0x040d },
	{ func040e_start_path02,                   0x040e },
	{ func040f_start_path03,                   0x040f },
	{ func0410_start_path04,                   0x0410 },
	{ func0411_yellowbot,                      0x0411 },
	{ func0412_purplebot_programs,             0x0412 },
	{ func0413_purplebot_at_lasers,            0x0413 },
	{ func0415_radioactivity,                  0x0415 },
	{ func1400_setup_counterop,                0x1400 },
	{ func1001_objectives_failed_msg,          0x1001 },
	{ func1002_bot_activation_terminal,        0x1002 },
	{ func1003_bot_programming_terminal,       0x1003 },
	{ func1004_check_items_collected,          0x1004 },
	{ func1005_check_unacceptable_casualties,  0x1005 },
	{ func1006_terminal_activation,            0x1006 },
	{ func1007_uplink,                         0x1007 },
	{ func1008_check_bot_terminals_destroyed,  0x1008 },
	{ func1009_weaponscache,                   0x1009 },
	{ func100a_spawn_alarm_responders,         0x100a },
	{ func100b_check_uplink_pc_destroyed,      0x100b },
	{ func100c_shuffle_terminals,              0x100c },
	{ func100e_experiment_terminals_destroyed, 0x100e },
	{ func100f_check_for_end_level,            0x100f },
	{ func1010_intro_from_menu,                0x1010 },
	{ func1011_spawn_guards_during_uplink,     0x1011 },
	{ func1012_start_laser_sound,              0x1012 },
	{ func1013_hatch_pc,                       0x1013 },
	{ func1014_jo_radioactivity,               0x1014 },
	{ func1415_outro_audio,                    0x1415 },
	{ func1016_setup_drcaroll,                 0x1016 },
	{ func1018_item_pickup_messages,           0x1018 },
	{ func1019_msg_securitysector,             0x1019 },
	{ func101a_msg_lotofpower,                 0x101a },
	{ func101b_msg_reprogram,                  0x101b },
	{ func101c_msg_radioactive,                0x101c },
	{ func101d_coop_radioactivty,              0x101d },
	{ func101e_unlock_drcaroll_door,           0x101e },
	{ func101f_check_bot_destroyed,            0x101f },
	{ func1020_lock_agent_doors,               0x1020 },
	{ func1021_counterop_radioactivity,        0x1021 },
	{ func1022_setup_rtracker,                 0x1022 },
	{ func1423_setup_lighting,                 0x1423 },
	{ func1424_start_lift,                     0x1424 },
	{ func0414_walk_3_pads,                    0x0414 },
	{ func0416_intro,                          0x0416 },
	{ func0417_outro,                          0x0417 },
	{ func1010_intro_from_menu,                0x0c00 },
	{ func0417_outro_from_menu,                0x0c01 },
	{ NULL, 0 },
};

struct path paths[] = {
	{ path00, 0, PATHTYPE_BACKANDFORTH },
	{ path01, 1, PATHTYPE_BACKANDFORTH },
	{ path02, 2, PATHTYPE_BACKANDFORTH },
	{ path03, 3, PATHTYPE_BACKANDFORTH },
	{ path04, 4, PATHTYPE_BACKANDFORTH },
	{ path05, 5, PATHTYPE_BACKANDFORTH },
	{ path06, 6, PATHTYPE_BACKANDFORTH },
	{ path07, 7, PATHTYPE_BACKANDFORTH },
	{ path08, 8, PATHTYPE_BACKANDFORTH },
	{ path09, 9, PATHTYPE_BACKANDFORTH },
	{ path10, 10, PATHTYPE_CIRCULAR },
	{ path11, 11, PATHTYPE_BACKANDFORTH },
	{ path12, 12, PATHTYPE_BACKANDFORTH },
	{ path13, 13, PATHTYPE_BACKANDFORTH },
	{ NULL, 0, 0 },
};

