//
// Air Base
//

#include "stagesetup.h"

// Characters
#define CHR_STEWARDESS 0x38
#define CHR_SECRETARY  0x39
#define CHR_OFFICE1    0x3c
#define CHR_OFFICE2    0x3d
#define CHR_TRENT      0x47
#define CHR_OUTRO_NSA  0x49

// Objects
#define OBJ_BRIEFCASE1        0x00
#define OBJ_CONSOLE           0x01
#define OBJ_UNIFORM           0x02
#define OBJ_FLIGHTPLANS       0x03
#define OBJ_BAGGAGE_CARRIER   0x04
#define OBJ_LASER_PANEL       0x05
#define OBJ_BRIEFCASE2        0x06
#define OBJ_ALARM             0x19
#define OBJ_SAFE_SWITCH       0x1a
#define OBJ_SAFE_SWITCH_COVER 0x1f
#define OBJ_VERTICAL_LIFT     0x21 // the one leading to the plane - not briefcase office
#define OBJ_REMOTEMINE        0x2b
#define OBJ_SAFEDOOR          0x2d
#define OBJ_PLANE             0x2e
#define OBJ_DIAGONAL_LIFT     0x36

// Stage flags
#define STAGEFLAG_SECURITY_SHUT_DOWN                  0x00000100
#define STAGEFLAG_STEWARDESS_ENTERED_BASE             0x00000200
#define STAGEFLAG_CIVILIANS_KILLED                    0x00000400
#define STAGEFLAG_DISGUISE_UNCOVERED                  0x00000800
#define STAGEFLAG_DISGUISED                           0x00001000
#define STAGEFLAG_RECEPTIONIST_CALLED_SECURITY        0x00002000
#define STAGEFLAG_SUITCASE_DEPOSITED                  0x00004000
#define STAGEFLAG_WEAPONS_DETECTED                    0x00008000
#define STAGEFLAG_SUITCASE_SCANNED                    0x00010000
#define STAGEFLAG_BOARDED_PLANE                       0x00020000
#define STAGEFLAG_LASERS_OVERLOADED                   0x00040000
#define STAGEFLAG_TOO_MANY_NEUTRALS_KILLED            0x00080000
#define STAGEFLAG_TRIGGER_MSG_NOWSYOURCHANCE          0x00100000
#define STAGEFLAG_OFFICE1_DEAD                        0x00200000
#define STAGEFLAG_OFFICE2_DEAD                        0x00400000
#define STAGEFLAG_DISGUISED2                          0x00800000
#define STAGEFLAG_SECRETARY_DEAD                      0x01000000
#define STAGEFLAG_CONSOLE_DESTROYED                   0x02000000
#define STAGEFLAG_ENTERED_BASE                        0x04000000
#define STAGEFLAG_TROLLEY_SHUT_DOWN_WITHOUT_BRIEFCASE 0x08000000
#define STAGEFLAG_CONSOLE_ACTIVATED                   0x10000000

// AI Lists
#define AILIST_INIT_STRIPES               0x0402
#define AILIST_BECOME_UNALERTED           0x0406
#define AILIST_STEWARDESS                 0x0407
#define AILIST_SECRETARY                  0x0408
#define AILIST_OFFICE1                    0x0409
#define AILIST_OFFICE2                    0x040a
#define AILIST_INIT_SECRETARY             0x040c
#define AILIST_INIT_OFFICE1               0x040d
#define AILIST_INIT_OFFICE2               0x040e
#define AILIST_NSA                        0x040f
#define AILIST_TAKEOVER_LACKEY            0x0411
#define AILIST_INIT_TAKEOVER_LACKEY       0x0412
#define AILIST_ALASKAN_CONSOLE_GUARD      0x0413
#define AILIST_OFFICEWORKER               0x0414
#define AILIST_ALASKAN_MOUNTAINLIFT_GUARD 0x0415
#define AILIST_REMOVE_OR_UNALERT          0x0417
#define AILIST_REMOVE_OR_COWER            0x0418
#define AILIST_DRAW_MAGNUM                0x041a
#define AILIST_INIT_ALASKAN_GUARD         0x0426
#define AILIST_INIT_POSTTAKEOVER_GUARD    0x0427
#define AILIST_POSTTAKEOVER_GUARD         0x0428
#define AILIST_FOYER_SPAWNER              0x042a
#define AILIST_INIT_FOYER_CLONE           0x042b
#define AILIST_FOYER_CLONE                0x042c

s32 intro[];
u32 props[];
struct path paths[];
struct ailist ailists[];

struct stagesetup setup = {
	NULL,
	NULL,
	NULL,
	intro,
	props,
	paths,
	ailists,
	NULL,
};

u32 props[] = {
	briefing(0, 0x0e01)
	briefing(1, 0x0e00)
	briefing(2, 0x0e02)
	briefing(3, 0x0e03)

	beginobjective(0, L_CAVE(5), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Obtain disguise and enter base"
		complete_flags(STAGEFLAG_DISGUISED2)
		complete_flags(STAGEFLAG_ENTERED_BASE)
		fail_flags(STAGEFLAG_CIVILIANS_KILLED)
		fail_flags(STAGEFLAG_DISGUISE_UNCOVERED)
		fail_flags(STAGEFLAG_STEWARDESS_ENTERED_BASE)
		fail_flags(STAGEFLAG_RECEPTIONIST_CALLED_SECURITY)
		fail_flags(STAGEFLAG_TOO_MANY_NEUTRALS_KILLED)
		fail_flags(STAGEFLAG_SECRETARY_DEAD)
	endobjective

	beginobjective(1, L_CAVE(6), (DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Check in equipment"
		complete_flags(STAGEFLAG_SUITCASE_DEPOSITED)
		fail_flags(STAGEFLAG_WEAPONS_DETECTED)
		fail_flags(STAGEFLAG_TROLLEY_SHUT_DOWN_WITHOUT_BRIEFCASE)
	endobjective

	beginobjective(2, L_CAVE(7), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Subvert security monitoring system"
		complete_flags(STAGEFLAG_SECURITY_SHUT_DOWN)
		fail_flags(STAGEFLAG_SUITCASE_SCANNED)
		fail_flags(STAGEFLAG_CONSOLE_DESTROYED)
	endobjective

	beginobjective(3, L_CAVE(8), (DIFFBIT_PA | DIFFBIT_PD)) // "Obtain flight plans from safe"
		require_object_collected(OBJ_FLIGHTPLANS)
	endobjective

	beginobjective(4, L_CAVE(9), (DIFFBIT_A | DIFFBIT_SA | DIFFBIT_PA | DIFFBIT_PD)) // "Board Air Force One"
		complete_flags(STAGEFLAG_BOARDED_PLANE)
	endobjective

	chr(0x00000e80, 0x00, 0x00c8, BODY_ALASKAN_GUARD, HEAD_RANDOM, GAILIST_IDLE, 0x0135, -1, 20, 20, 0x80882408, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 3, 0x00000700)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0000, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000e00, 0x01, 0x00d0, BODY_ALASKAN_GUARD, HEAD_RANDOM, GAILIST_IDLE, 0x0135, -1, 20, 20, 0x80882008, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000700)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0001, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00010c01, 0x38, 0x00d1, BODY_STEWARDESS_COAT, HEAD_ANKA, GAILIST_IDLE, -1, -1, 200, 10, 0x00880408, 0x00000000, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x02000700)
	chr(0x00000e00, 0x02, 0x00d3, BODY_ALASKAN_GUARD, HEAD_RANDOM, AILIST_ALASKAN_MOUNTAINLIFT_GUARD, 0x0135, -1, 200, 20, 0x80802400, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x02000700)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0002, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000e00, 0x03, 0x0012, BODY_ALASKAN_GUARD, HEAD_RANDOM, 0x041b, 0x0135, -1, 200, 15, 0x80882008, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x02000500)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0003, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000ec0, 0x04, 0x00ca, BODY_ALASKAN_GUARD, HEAD_RANDOM, AILIST_INIT_ALASKAN_GUARD, 0x0135, -1, 200, 100, 0x80802609, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0004, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000ec0, 0x05, 0x00cb, BODY_ALASKAN_GUARD, HEAD_RANDOM, AILIST_INIT_ALASKAN_GUARD, 0x0135, -1, 200, 100, 0x80842408, 0x00000000, TEAM_ENEMY, SQUADRON_03, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0005, 0x10004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x07, 0x00c7, BODY_ALASKAN_GUARD, HEAD_RANDOM, AILIST_INIT_ALASKAN_GUARD, -1, -1, 200, 14, 0x80882000, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0007, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x06, 0x00e8, BODY_ALASKAN_GUARD, HEAD_RANDOM, AILIST_INIT_ALASKAN_GUARD, -1, -1, 200, 14, 0x80882000, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0006, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00010400, 0x39, 0x00c9, BODY_SECRETARY, HEAD_SECRETARY, AILIST_INIT_SECRETARY, -1, -1, 200, 14, 0x80882000, 0x00000000, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	chr(0x00014400, 0x3c, 0x00c6, BODY_OFFICEWORKER, HEAD_RANDOM, AILIST_INIT_OFFICE1, -1, -1, 200, 8, 0x80082000, 0x00000100, TEAM_ENEMY, SQUADRON_05, 0x24, 0, 0x00010000)
	chr(0x00014400, 0x3d, 0x00c5, BODY_OFFICEWORKER, HEAD_RANDOM, AILIST_INIT_OFFICE2, -1, -1, 200, 8, 0x80082000, 0x00000100, TEAM_ENEMY, SQUADRON_05, 0x25, 0, 0x00010000)
	chr(0x00000600, 0x08, 0x00c3, BODY_ALASKAN_GUARD, HEAD_RANDOM, AILIST_INIT_ALASKAN_GUARD, -1, -1, 200, 100, 0xa0882000, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0008, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x09, 0x0031, BODY_ALASKAN_GUARD, HEAD_RANDOM, 0x041c, -1, -1, 200, 100, 0x80082000, 0x00000000, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x0009, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x10, 0x003a, BODY_NSA_LACKEY, HEAD_RANDOM, AILIST_NSA, 0x003a, -1, 200, 100, 0x80082080, 0x00000881, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	chr(0x00000600, 0x0a, 0x003d, BODY_ALASKAN_GUARD, HEAD_RANDOM, 0x041d, -1, -1, 200, 100, 0xa0882000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x000a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x0b, 0x005b, BODY_ALASKAN_GUARD, HEAD_RANDOM, 0x041e, -1, -1, 200, 100, 0x80082000, 0x00000000, TEAM_ENEMY, SQUADRON_07, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x000b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x11, 0x0072, BODY_NSA_LACKEY, HEAD_RANDOM, AILIST_NSA, 0x0072, -1, 200, 100, 0x80082000, 0x00000881, TEAM_ENEMY, SQUADRON_05, -1, 0, 0x01000000)
	chr(0x00004600, 0x0c, 0x00c2, BODY_ALASKAN_GUARD, HEAD_RANDOM, AILIST_ALASKAN_CONSOLE_GUARD, 0x0156, -1, 200, 100, 0xc0082000, 0x20000100, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00050000)
	chr(0x00000200, 0x12, 0x00c1, BODY_NSA_LACKEY, HEAD_RANDOM, AILIST_INIT_TAKEOVER_LACKEY, -1, -1, 200, 100, 0x80080000, 0x00000800, TEAM_ENEMY, SQUADRON_06, -1, 0, 0x02000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0012, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	tag(0x30, 2)
	tag(0x31, 2)
	weapon(0x0100, MODEL_CHRDY357, 0x0012, 0x20004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DY357MAGNUM, 0x00ffffff, 0x00000000)
	weapon(0x0100, MODEL_CHRDY357, 0x0012, 0x20004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DY357MAGNUM, 0x00ffffff, 0x00000000)
	link_collectibles(-1, -2)
	chr(0x00000600, 0x0d, 0x00c0, BODY_ALASKAN_GUARD, HEAD_RANDOM, 0x041f, -1, -1, 200, 100, 0xa0882000, 0x00000000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x000d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x0e, 0x00bf, BODY_ALASKAN_GUARD, HEAD_RANDOM, AILIST_INIT_ALASKAN_GUARD, -1, -1, 200, 100, 0x80082000, 0x00000000, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x000e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000400, 0x3a, 0x00be, BODY_OFFICEWORKER, HEAD_RANDOM, AILIST_OFFICEWORKER, -1, -1, 200, 4, 0x80082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	chr(0x00000600, 0x0f, 0x00bc, BODY_ALASKAN_GUARD, HEAD_RANDOM, AILIST_INIT_ALASKAN_GUARD, -1, -1, 200, 100, 0x80082000, 0x00000000, TEAM_ENEMY, SQUADRON_0A, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRDRAGON, 0x000f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x13, 0x00ba, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc4082000, 0x04000a00, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0013, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x14, 0x0123, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x84082000, 0x04000a00, TEAM_ENEMY, SQUADRON_09, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0014, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000700, 0x16, 0x0124, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc4080000, 0x04000a00, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0016, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000700, 0x18, 0x0125, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xcc080000, 0x04000a00, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0018, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1a, 0x0126, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc0088000, 0x04000a00, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x001a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1c, 0x0127, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xe008a000, 0x04000a00, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x001c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1b, 0x0090, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc008a000, 0x04000a00, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x001b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x19, 0x008e, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc0088000, 0x04000a00, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0019, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1d, 0x0096, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc008a000, 0x04000a00, TEAM_ENEMY, SQUADRON_02, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x001d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x1e, 0x0128, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc008a000, 0x04000a00, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x001e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000200, 0x20, 0x0129, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xe008a000, 0x04000a00, TEAM_ENEMY, SQUADRON_0C, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0020, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x21, 0x00b4, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc0082000, 0x04000a00, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0021, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x22, 0x012a, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc0082000, 0x04000a00, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0022, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x23, 0x00b2, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc0082000, 0x04000a00, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0023, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x24, 0x012b, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc0082000, 0x04000a00, TEAM_ENEMY, SQUADRON_0D, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0024, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x25, 0x0026, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc4082000, 0x04000a00, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0025, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x26, 0x012c, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc4082000, 0x04000a00, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0026, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x27, 0x002c, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc4082000, 0x04000a00, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0027, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x28, 0x012d, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xa4082000, 0x04000a00, TEAM_ENEMY, SQUADRON_0E, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0028, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x2a, 0x00d9, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc4082000, 0x04000a00, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x002a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x2b, 0x012e, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc4082000, 0x04000a00, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x002b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x2c, 0x00da, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc4082000, 0x04000a00, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x002c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x2d, 0x012f, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc4082000, 0x04000a00, TEAM_ENEMY, SQUADRON_0F, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x002d, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x2e, 0x00d8, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x8008a000, 0x04000a00, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x002e, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x2f, 0x0130, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x8008a000, 0x04000a00, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x002f, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x30, 0x00b1, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x8008a000, 0x04000a00, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0030, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x31, 0x0131, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x8008a000, 0x04000a00, TEAM_ENEMY, SQUADRON_01, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0031, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x32, 0x00dc, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xa4082000, 0x04000a00, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0032, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x33, 0x0132, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc4082000, 0x04000a00, TEAM_ENEMY, SQUADRON_0B, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0033, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x34, 0x00b0, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc0002000, 0x04000a00, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0034, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x35, 0x0133, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc0002000, 0x04000a00, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0035, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00004600, 0x36, 0x00db, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc0002000, 0x00000b00, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00010000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0036, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000600, 0x37, 0x0134, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0xc0002000, 0x04000a00, TEAM_ENEMY, SQUADRON_08, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0037, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00010400, 0x44, 0x0132, BODY_CIAGUY, HEAD_RANDOM, 0x0419, 0x0132, -1, 1000, 6, 0x80000004, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x00000000)
	chr(0x00010400, 0x45, 0x00b1, BODY_STEWARDESS, HEAD_RANDOM, 0x0419, 0x00b1, -1, 1000, 9, 0x80000000, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x02000000)
	chr(0x00010400, 0x46, 0x00e6, BODY_STEWARD, HEAD_RANDOM, 0x0419, 0x00e6, -1, 1000, 10, 0x80000000, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 0, 0x01000000)
	chr(0x00000000, 0x42, 0x0136, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x80082000, 0x00000a00, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0042, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x43, 0x0137, BODY_STRIPES, HEAD_RANDOM, AILIST_INIT_STRIPES, -1, -1, 200, 100, 0x80082000, 0x00000a00, TEAM_ENEMY, SQUADRON_04, -1, 0, 0x00000000)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0043, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x47, 0x0138, BODY_TRENT, HEAD_TRENT, GAILIST_IDLE, 0x0135, -1, 20, 20, 0x80882408, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 3, 0x00000700)
	chr(0x00000001, 0x48, 0x0139, BODY_STEWARDESS_COAT, HEAD_ANKA, GAILIST_IDLE, 0x0135, -1, 20, 20, 0x80882408, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 3, 0x00000700)
	chr(0x00000000, 0x49, 0x013a, BODY_NSA_LACKEY, HEAD_RANDOM, GAILIST_INVINCIBLE_AND_IDLE, 0x0135, -1, 20, 20, 0x80882408, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 3, 0x00000700)
	weapon(0x0100, MODEL_CHRAVENGER, 0x0049, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x4a, 0x013b, BODY_NSA_LACKEY, HEAD_RANDOM, GAILIST_IDLE, 0x0135, -1, 20, 20, 0x80882408, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 3, 0x00000700)
	weapon(0x0100, MODEL_CHRAVENGER, 0x004a, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_K7AVENGER, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x4b, 0x013c, BODY_ALASKAN_GUARD, HEAD_RANDOM, GAILIST_IDLE, 0x0135, -1, 20, 20, 0x80882408, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 3, 0x00000700)
	weapon(0x0100, MODEL_CHRDRAGON, 0x004b, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	chr(0x00000000, 0x4c, 0x013d, BODY_ALASKAN_GUARD, HEAD_RANDOM, GAILIST_IDLE, 0x0135, -1, 20, 20, 0x80882408, 0x00000000, TEAM_ENEMY, SQUADRON_00, -1, 3, 0x00000700)
	weapon(0x0100, MODEL_CHRDRAGON, 0x004c, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DRAGON, 0x00ffffff, 0x00000000)
	tag(0x00, 1)
	weapon(0x0180, MODEL_CHRBRIEFCASE, 0x0113, 0x00420001, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_SUITCASE, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x4d, L_CAVE(10), L_CAVE(11), L_CAVE(12), L_CAVE(13), L_CAVE(14), 0x0000, 0x0000) // "Obtain suitcase."
	tag(0x01, 1)
	multimonitor(0x0099, MODEL_PD_CONSOLE, 0x0156, 0x000001a1, 0x00000001, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030000)
	tag(0x02, 1)
	weapon(0x0080, MODEL_STEWARDESS_TROLLEY, 0x00b6, 0x00000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_DISGUISE41, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x41, L_CAVE(15), L_CAVE(16), L_CAVE(17), L_CAVE(18), L_CAVE(19), 0x0000, 0x0000) // "Obtain air stewardess uniform."
	tag(0x06, 1)
	stdobject(0x0100, MODEL_CHRBRIEFCASE, 0x00c4, 0x014204e1, 0x00086000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x42, 6)
	tag(0x43, 6)
	tag(0x48, 6)
	tag(0x49, 6)
	tag(0x20, 1)
	lift(0x0100, MODEL_A51_LIFT_THINWALL, 0x013f, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x013f, 0x013e, 0xffffffff, 0x00000001, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x15000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x019a, 0x10000400, 0x00000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00040000, 0x00000000, 0x000000b4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x019b, 0x10000400, 0x00000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00040000, 0x00000000, 0x000000b4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x0198, 0x10000400, 0x00000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00040000, 0x00000000, 0x000000b4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x0199, 0x10000400, 0x00000800, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00040000, 0x00000000, 0x000000b4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-4, -5, 0, 0)
	link_objects(-4, -6, 0, 0)
	link_objects(-4, -7, 0, 1)
	link_objects(-4, -8, 0, 1)
	tag(0x04, 1)
	lift(0x0100, MODEL_BAGGAGECARRIER, 0x0144, 0x015204e8, 0x00304300, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0144, 0x0145, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x3b, 6)
	tag(0x37, 3)
	tag(0x36, 1)
	lift(0x0100, MODEL_AIRBASE_LIFT_ANGLE, 0x0146, 0x235204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0146, 0x0147, 0xffffffff, 0x00000001, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000aaa, 0x00320000, 0x15000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x0184, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00040000, 0x00000000, 0x000000b4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x0185, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00040000, 0x00000000, 0x000000b4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x019d, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00040000, 0x00000000, 0x000000b4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x019e, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00040000, 0x00000000, 0x000000b4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-4, -5, 0, 0)
	link_objects(-4, -6, 0, 0)
	link_objects(-4, -7, 0, 1)
	link_objects(-4, -8, 0, 1)
	tag(0x3c, 10)
	tag(0x3d, 10)
	tag(0x3e, 10)
	tag(0x3f, 10)
	tag(0x40, 10)
	tag(0x41, 10)
	tag(0x38, 10)
	tag(0x39, 10)
	tag(0x21, 1)
	lift(0x0100, MODEL_AIRBASE_LIFT_ENCLOSED, 0x0140, 0x035204e8, 0x00304300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0140, 0x0141, 0x01420143, 0x00000001, 0x00000003, 0x00000005, 0x00000007, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x16000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x0196, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x0197, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x0194, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x0195, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x0192, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x0193, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x0190, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x0191, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	link_objects(-8, -9, 0, 0)
	link_objects(-8, -10, 0, 0)
	link_objects(-8, -11, 0, 1)
	link_objects(-8, -12, 0, 1)
	link_objects(-8, -13, 0, 2)
	link_objects(-8, -14, 0, 2)
	link_objects(-8, -15, 0, 3)
	link_objects(-8, -16, 0, 3)
	tag(0x05, 1)
	multimonitor(0x0099, MODEL_COMHUB, 0x0153, 0x00000102, 0x00000000, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	tag(0x07, 17)
	tag(0x08, 17)
	tag(0x09, 17)
	tag(0x0a, 17)
	tag(0x0b, 17)
	tag(0x0c, 17)
	tag(0x0d, 17)
	tag(0x0e, 17)
	tag(0x0f, 17)
	tag(0x10, 17)
	tag(0x11, 17)
	tag(0x12, 17)
	tag(0x13, 17)
	tag(0x14, 17)
	tag(0x15, 17)
	tag(0x16, 17)
	tag(0x17, 17)
	door(0x0100, MODEL_LASDOOR, 0x0168, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0169, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x016a, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x016b, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x016c, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x016d, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x016e, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x016f, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0170, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0177, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0171, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0172, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0173, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0176, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0174, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0175, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x017a, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x017b, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x017c, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0178, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_LASDOOR, 0x0179, 0x06000400, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00011999, 0x00011999, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0c00000b, 0x00000000, 0x00004650, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x0157, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x0158, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x0159, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x015a, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x015b, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x015c, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x015d, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x015e, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x015f, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x0160, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x0161, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x0162, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x0163, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x0164, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x0165, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x0166, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x00e6, MODEL_A51_CRATE2, 0x0167, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x0180, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_A51_VERT_DOOR_ST, 0x017f, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00000000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x003b, 0x03520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	escalator(0x0100, MODEL_ESCA_STEP, 0x002d, 0x13520401, 0x00224300, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x18, 1)
	door(0x0100, MODEL_AF1_INNERDOOR, 0x0183, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00040000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_DOOR2A_G5, 0x0186, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x35, 1)
	door(0x0100, MODEL_AF1_INNERDOOR, 0x0187, 0x10000400, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00040000, 0x00000080, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x27, 1)
	door(0x0100, MODEL_AF1_INNERDOOR, 0x018a, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x29, 1)
	stdobject(0x0100, MODEL_AF1_INNERDOOR, 0x01a0, 0x800201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x28, 1)
	door(0x0100, MODEL_AF1_INNERDOOR, 0x018e, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x2a, 1)
	stdobject(0x0100, MODEL_AF1_INNERDOOR, 0x01a4, 0x000201e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	door(0x0100, MODEL_AF1_INNERDOOR, 0x018b, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x2d, 1)
	door(0x0100, MODEL_AIRBASE_SAFEDOOR, 0x018c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x005a0000, 0x03e80000, 0x00640000, 0x00640000, 0x00010000, 0x00000005, 0x00000080, 0x000005dc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AF1_INNERDOOR, 0x018d, 0x10000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00040000, 0x00000000, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_AF1_INNERDOOR, 0x018f, 0x10000400, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000f333, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00040000, 0x00000002, 0x00000384, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000800, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x19, 1)
	multimonitor(0x0099, MODEL_COMHUB, 0x0154, 0x00000102, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030300)
	hovercar(0x0080, MODEL_TESTERBOT, 0x01ba, 0xe0000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, 0x0000042e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	hovercar(0x0080, MODEL_HOOVERBOT, 0x01ba, 0xe0000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, 0x0000042f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	hovercar(0x0080, MODEL_HOOVERBOT, 0x01c3, 0xe0000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, 0x00000431, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	hovercar(0x004c, MODEL_TESTERBOT, 0x01c3, 0xe0000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000064, 0x00000000, 0x00000000, 0x0fff0000, 0x00000432, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x03, 1)
	weapon(0x0040, MODEL_SAFEITEM, 0x00d6, 0x00000008, 0x00000000, 0x00400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_FLIGHTPLANS, 0x00ffffff, 0x00000000)
	rename_object(-1, 0x42, L_CAVE(20), L_CAVE(21), L_CAVE(22), L_CAVE(23), L_CAVE(24), 0x0000, 0x0000) // "Obtain flight plans from safe."
	tag(0x1f, 1)
	lift(0x0100, MODEL_DD_LIFTDOOR, 0x0151, 0x035204e8, 0x00304300, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0151, 0x0150, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000071c, 0x0010aaaa, 0x01000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x1a, 1)
	stdobject(0x0100, MODEL_LIGHTSWITCH2, 0x0155, 0x00420008, 0x00000800, 0x00010000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01ce, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01cf, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01d0, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01d1, 0x000005e1, 0x00004000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01d2, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01d4, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01d5, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01d6, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01d7, 0x000005e1, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x24, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01d9, 0x000205e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x25, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01dc, 0x000205e1, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01da, 0x000205e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01db, 0x000205e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x26, 1)
	stdobject(0x0100, MODEL_DD_CHAIR, 0x01dd, 0x000205e1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01d3, 0x000005e1, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_PLANTRUBBER, 0x01de, 0x04000001, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_PLANTSPIDER, 0x01df, 0x04000001, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_PLANTSPIKE, 0x01e0, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_PLANTRUBBER, 0x01e1, 0x04000001, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_PLANTSPIDER, 0x01e2, 0x04000001, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_PLANTSPIKE, 0x01e3, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_PLANTRUBBER, 0x01e4, 0x04000001, 0x0000c100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_PLANTSPIKE, 0x01e7, 0x04000501, 0x0000c100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01e8, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01e9, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	stdobject(0x0100, MODEL_DD_DESK, 0x01ea, 0x000005e1, 0x00004100, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x23, 1)
	door(0x0100, MODEL_DOOR2A_G5, 0x019c, 0x04000400, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000e666, 0x0000e666, 0x00005555, 0x00005555, 0x000007ae, 0x00000000, 0x00000002, 0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x22, 1)
	stdobject(0x0100, MODEL_CABLE_CAR, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x2f, 1)
	stdobject(0x0100, MODEL_BINOCULARS, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x01ec, 0x10000b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00640190, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x01ed, 0x10000b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00640190, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x01ee, 0x10000b62, 0x00104000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00640190, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x01ef, 0x14000b62, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00640190, 0x0000ffff, 0x00000000)
	tag(0x46, 2)
	tag(0x47, 2)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x01f0, 0x14000b62, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00640190, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x01f1, 0x14000b62, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00640190, 0x0000ffff, 0x00000000)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x01f2, 0x14000b62, 0x00004000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00640190, 0x0000ffff, 0x00000000)
	tag(0x2b, 1)
	weapon(0x0100, MODEL_CHRREMOTEMINE, 0x0111, 0x003004e8, 0x000a2001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_REMOTEMINE, 0x00ffffff, 0x00000000)
	tag(0x2e, 1)
	stdobject(0x0100, MODEL_AIRFORCE1, 0xffff, 0x00021401, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000)
	tag(0x45, 1)
	tinted_glass(0x0100, MODEL_DD_WINDOW, 0x01eb, 0x14000b62, 0x00000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00c80320, 0x0000ffff, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01f3, 0x04000b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01f4, 0x04000b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01f5, 0x04000b62, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01f6, 0x04000262, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01f7, 0x04000262, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01f8, 0x04000262, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	glass(0x0100, MODEL_WINDOW, 0x01f9, 0x04000262, 0x00304000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00000000)
	door(0x0100, MODEL_SHUTTLEDOOR, 0x01a2, 0x10000000, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x0000f333, 0x0002c71c, 0x0002c71c, 0x00000888, 0x00140000, 0x00000000, 0x0000003c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000300, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	door(0x0100, MODEL_SHUTTLEDOOR, 0x01a3, 0x10000000, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x0000c000, 0x0000f333, 0x0002c71c, 0x0002c71c, 0x00000888, 0x000c0000, 0x00000000, 0x0fffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000)
	tag(0x33, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x0011, 0x00004001, 0x000000e0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x34, 1)
	shield(0x0100, MODEL_CHRSHIELD, 0x00d6, 0x00100001, 0x000800c0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, 0x00010000, 0x00000000, 0x00000000)
	tag(0x44, 1)
	weapon(0x0080, MODEL_MULTI_AMMO_CRATE, 0x00b5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000003e8, 0x00000000, 0x00000000, 0x0fff0000, WEAPON_PROXIMITYMINE, 0x00ffffff, 0x00000000)
	endprops
};

s32 intro[] = {
	spawn(0x011e)
	intro_weapon(WEAPON_CROSSBOW, -1)
	intro_weapon(WEAPON_HORIZONSCANNER, -1)
	ammo(AMMOTYPE_CROSSBOW, 12)
	ammo(AMMOTYPE_PROXY_MINE, 3)
	ammo(AMMOTYPE_RIFLE, 30)
	intro_weapon(WEAPON_CAMSPY, -1)
	outfit(OUTFIT_SNOW)
	endintro
};

s32 path06[] = {
	0x000e,
	0x000d,
	0x000d,
	0x000e,
	0x0012,
	-1,
};

s32 path07[] = {
	0x002d,
	0x0031,
	0x002e,
	0x002f,
	0x0030,
	0x0031,
	-1,
};

s32 path08[] = {
	0x004d,
	0x004f,
	0x004d,
	0x004c,
	0x003d,
	0x003e,
	0x003c,
	0x003e,
	0x003d,
	0x004c,
	-1,
};

s32 path09[] = {
	0x005b,
	0x0053,
	0x0051,
	0x0052,
	0x0054,
	0x0053,
	-1,
};

s32 path10[] = {
	0x0041,
	0x0042,
	0x0043,
	0x0044,
	0x0045,
	0x0044,
	0x0043,
	0x0042,
	-1,
};

s32 path11[] = {
	0x008e,
	0x008d,
	0x008c,
	0x008d,
	-1,
};

s32 path12[] = {
	0x0095,
	0x0090,
	0x008f,
	0x008e,
	0x008f,
	0x0090,
	-1,
};

s32 path13[] = {
	0x0099,
	0x0098,
	0x0097,
	0x0096,
	0x0095,
	0x0096,
	0x0097,
	0x0098,
	-1,
};

s32 path14[] = {
	0x0030,
	0x002c,
	0x0039,
	0x002c,
	-1,
};

s32 path15[] = {
	0x0019,
	0x0012,
	-1,
};

s32 path00[] = {
	0x01ba,
	0x01bb,
	0x01bc,
	0x01bd,
	0x01bd,
	-1,
};

s32 path01[] = {
	0x01ba,
	0x01be,
	0x01bf,
	0x01c0,
	0x01ba,
	-1,
};

s32 path02[] = {
	0x01ba,
	0x01c1,
	0x01c2,
	0x01be,
	0x01ba,
	-1,
};

s32 path03[] = {
	0x01c3,
	0x01c4,
	0x01c5,
	0x01c6,
	0x01c3,
	-1,
};

s32 path04[] = {
	0x01c3,
	0x01c7,
	0x01c8,
	0x01c9,
	0x01c3,
	-1,
};

s32 path05[] = {
	0x01c3,
	0x01ca,
	0x01cb,
	0x01cc,
	0x01c3,
	-1,
};

s32 unregistered_path1[] = {
	0x003b,
	0x003e,
	0x003d,
	0x004c,
	0x004d,
	0x004f,
	0x0050,
	0x004e,
	0x004d,
	0x004c,
	0x003d,
	0x003e,
	0x003b,
	0x003b,
	-1,
};

struct path paths[] = {
	{ path06, 6, PATHTYPE_BACKANDFORTH },
	{ path07, 7, PATHTYPE_BACKANDFORTH },
	{ path08, 8, PATHTYPE_BACKANDFORTH },
	{ path09, 9, PATHTYPE_BACKANDFORTH },
	{ path10, 10, PATHTYPE_BACKANDFORTH },
	{ path11, 11, PATHTYPE_BACKANDFORTH },
	{ path12, 12, PATHTYPE_BACKANDFORTH },
	{ path13, 13, PATHTYPE_BACKANDFORTH },
	{ path14, 14, PATHTYPE_BACKANDFORTH },
	{ path15, 15, PATHTYPE_BACKANDFORTH },
	{ path00, 0, PATHTYPE_BACKANDFORTH },
	{ path01, 1, PATHTYPE_BACKANDFORTH },
	{ path02, 2, PATHTYPE_BACKANDFORTH },
	{ path03, 3, PATHTYPE_BACKANDFORTH },
	{ path04, 4, PATHTYPE_BACKANDFORTH },
	{ path05, 5, PATHTYPE_BACKANDFORTH },
	{ NULL, 0, 0 },
};

u8 func1002_objectives_failed_msg[] = {
	yield
	give_object_to_chr(OBJ_UNIFORM, CHR_STEWARDESS)
	set_chr_chrflag(0x00, CHRCFLAG_04000000)
	set_chr_chrflag(0x01, CHRCFLAG_04000000)
	set_chr_chrflag(0x02, CHRCFLAG_04000000)
	set_chr_chrflag(0x03, CHRCFLAG_04000000)
	set_chr_chrflag(0x04, CHRCFLAG_04000000)
	set_chr_chrflag(0x05, CHRCFLAG_04000000)
	set_chr_chrflag(0x06, CHRCFLAG_04000000)
	set_chr_chrflag(0x07, CHRCFLAG_04000000)
	set_chr_chrflag(0x08, CHRCFLAG_04000000)
	set_chr_chrflag(0x09, CHRCFLAG_04000000)
	set_chr_chrflag(0x0a, CHRCFLAG_04000000)
	set_chr_chrflag(0x0b, CHRCFLAG_04000000)
	set_chr_chrflag(0x0c, CHRCFLAG_04000000)
	set_chr_chrflag(0x0d, CHRCFLAG_04000000)
	set_chr_chrflag(0x0e, CHRCFLAG_04000000)
	set_chr_chrflag(0x0f, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_STEWARDESS, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_SECRETARY, CHRCFLAG_04000000)
	set_chr_chrflag(0x3a, CHRCFLAG_04000000)
	set_chr_chrflag(0x3b, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_OFFICE1, CHRCFLAG_04000000)
	set_chr_chrflag(CHR_OFFICE2, CHRCFLAG_04000000)
	set_chr_chrflag(0x44, CHRCFLAG_04000000)
	set_chr_chrflag(0x45, CHRCFLAG_04000000)
	set_chr_chrflag(0x46, CHRCFLAG_04000000)
	set_ailist(CHR_SELF, GAILIST_SHOW_OBJ_FAILED_MSG)
	endlist
};

u8 func1000_rebuild_groups[] = {
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 func1401_setup_counterop[] = {
	yield
	set_chr_team(CHR_ANTI, TEAM_04)
	set_ailist(CHR_SELF, GAILIST_REBUILD_GROUPS)
	endlist
};

u8 unregistered_function1[] = {
	set_returnlist(CHR_SELF, GAILIST_END_CINEMA)
	set_ailist(CHR_SELF, 0x0401)
	endlist
};

/**
 * @unused
 */
u8 func0401_unused_cutscene[] = {
	chr_draw_weapon_in_cutscene(CHR_BOND, WEAPON_FALCON2)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_AIRBASE_OUTRO_LONG)
	camera_movement(0x016b)
	cmd0175(60)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x0170, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	set_chr_hudpiece_visible(CHR_BOND, TRUE)
	set_chr_chrflag(0x00, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x00, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x00, CHRHFLAG_00020000)
	chr_do_animation(0x016c, -1, -1, 0x06, 0x00, 0x00, 4)
	set_chr_chrflag(0x01, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x01, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x01, CHRHFLAG_00020000)
	chr_do_animation(0x016d, -1, -1, 0x06, 0x00, 0x01, 4)
	set_chr_chrflag(0x02, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x02, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x02, CHRHFLAG_00020000)
	chr_do_animation(0x016e, -1, -1, 0x06, 0x00, 0x02, 4)
	set_chr_chrflag(CHR_STEWARDESS, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_STEWARDESS, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_STEWARDESS, CHRHFLAG_00020000)
	chr_do_animation(0x016f, -1, -1, 0x06, 0x00, CHR_STEWARDESS, 4)
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 90)
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)

	beginloop(0x04)
		if_camera_animating(/*goto*/ 0x31)
		goto_next(0x48)

		label(0x31)
		if_controller_button_pressed(/*goto*/ 0x48)
		label(0x31)
	endloop(0x04)

	label(0x48)
	label(0x02)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_ailist(0x00, 0x0405)
	set_ailist(0x01, 0x0405)
	remove_chr(0x02)
	set_ailist(CHR_STEWARDESS, 0x040b)
	restart_default_music
	reset_ambience
	set_ailist(CHR_SELF, GAILIST_END_CINEMA)
	endlist
};

u8 func0425_outro[] = {
	fade_to_color(0x000000ff, 0)
	fade_to_color(0x00000000, 110)
	camera_movement(0x031a)
	set_music_track(MUSIC_AIRBASE_OUTRO)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0xf1, CHRCFLAG_HIDDEN)
	set_ailist(CHR_P1P2, GAILIST_IDLE)
	unset_chr_chrflag(CHR_P1P2, CHRCFLAG_HIDDEN)

	set_chr_chrflag(CHR_OUTRO_NSA, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_OUTRO_NSA, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_OUTRO_NSA, CHRHFLAG_00020000)
	chr_do_animation(0x031b, -1, -1, 0x06, 0x00, CHR_OUTRO_NSA, 4)

	show_object(OBJ_PLANE)
	set_object_flag2(OBJ_PLANE, OBJFLAG2_04000000)
	set_object_flag3(OBJ_PLANE, OBJFLAG3_00000010)
	object_do_animation(0x031c, OBJ_PLANE, 0x04, 0xffff)

	set_cutscene_weapon(CHR_P1P2, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_P1P2, WEAPON_NONE, WEAPON_NONE)
	show_nonessential_chrs(FALSE)
	restart_timer

	#define wait_until(time, loopid) \
		beginloop(loopid) \
			if_controller_button_pressed(/*goto*/ 0x48) \
			if_timer_gt(time, /*goto*/ 0x02) \
		endloop(loopid) \
		label(0x02)



	wait_until(38, 0x92)
	play_sound(0x80c4, CHANNEL_10)

	wait_until(84, 0x93)
	play_sound(0x80c5, CHANNEL_10)

	wait_until(130, 0x94)
	play_sound(0x80c6, CHANNEL_10)

	wait_until(176, 0x95)
	play_sound(0x80c7, CHANNEL_10)

	wait_until(220, 0x96)
	play_sound(0x80c4, CHANNEL_10)

	wait_until(274, 0x97)
	play_sound(0x80c5, CHANNEL_10)

	wait_until(320, 0x98)
	play_sound(0x80c6, CHANNEL_10)

	wait_until(365, 0x99)
	play_sound(0x80c7, CHANNEL_10)

	beginloop(0x04)
		if_camera_animating(/*goto*/ 0x31)
		goto_next(0x48)

		label(0x31)
		if_controller_button_pressed(/*goto*/ 0x48)
		label(0x31)
	endloop(0x04)

	label(0x48)
	mute_channel(CHANNEL_10)
	label(0x02)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
#if VERSION < VERSION_PAL_FINAL
	hide_object(OBJ_PLANE)
#endif
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0402_init_stripes[] = {
	set_chr_chrflag(CHR_SELF, CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1004_guard_activation[] = {
	set_object_flag(0x29, OBJFLAG_INVINCIBLE)
	set_object_flag2(0x29, OBJFLAG2_INVISIBLE)
	unset_object_flag(0x29, OBJFLAG_00000100)
	set_object_flag(0x2a, OBJFLAG_INVINCIBLE)
	set_object_flag2(0x2a, OBJFLAG2_INVISIBLE)
	unset_object_flag(0x2a, OBJFLAG_00000100)
	set_object_flag2(OBJ_REMOTEMINE, OBJFLAG2_00020000)
	set_object_flag(OBJ_REMOTEMINE, OBJFLAG_INVINCIBLE)
	set_object_flag2(OBJ_REMOTEMINE, OBJFLAG2_INVISIBLE)
	yield
	yield
	hide_chr(0x13)
	hide_chr(0x15)
	hide_chr(0x17)
	hide_chr(0x19)
	hide_chr(0x1b)
	hide_chr(0x1d)
	hide_chr(0x1f)
	hide_chr(0x21)
	hide_chr(0x23)
	hide_chr(0x25)
	hide_chr(0x27)
	hide_chr(0x2a)
	hide_chr(0x2c)
	hide_chr(0x2e)
	hide_chr(0x30)
	hide_chr(0x32)
	hide_chr(0x34)
	hide_chr(0x36)
	hide_chr(0x42)
	hide_chr(0x43)
	hide_chr(0x14)
	hide_chr(0x16)
	hide_chr(0x18)
	hide_chr(0x1a)
	hide_chr(0x1c)
	hide_chr(0x1e)
	hide_chr(0x20)
	hide_chr(0x22)
	hide_chr(0x24)
	hide_chr(0x26)
	hide_chr(0x28)
	hide_chr(0x2b)
	hide_chr(0x2d)
	hide_chr(0x2f)
	hide_chr(0x31)
	hide_chr(0x33)
	hide_chr(0x35)
	hide_chr(0x37)

	beginloop(0x00)
		if_stage_flag_eq(STAGEFLAG_SECURITY_SHUT_DOWN, TRUE, /*goto*/ 0x02)
	endloop(0x00)

	label(0x02)
	hide_object(0x27)
	hide_object(0x28)
	unset_object_flag(0x29, OBJFLAG_INVINCIBLE)
	unset_object_flag2(0x29, OBJFLAG2_INVISIBLE)
	set_object_flag(0x29, OBJFLAG_00000100)
	unset_object_flag(0x2a, OBJFLAG_INVINCIBLE)
	unset_object_flag2(0x2a, OBJFLAG2_INVISIBLE)
	set_object_flag(0x2a, OBJFLAG_00000100)

	#define remove_alaskan_guard(chr) \
		set_chr_flag_bankx(chr, CHRFLAG1_WARNED, BANK_1) \
		set_ailist(chr, AILIST_REMOVE_OR_UNALERT) \
		set_chr_flag_bankx(chr, CHRFLAG0_AIVSAI, BANK_0) \
		yield



	remove_alaskan_guard(0x00)
	remove_alaskan_guard(0x01)
	remove_alaskan_guard(0x02)
	remove_alaskan_guard(0x03)
	remove_alaskan_guard(0x04)
	remove_alaskan_guard(0x05)
	remove_alaskan_guard(0x06)
	remove_alaskan_guard(0x07)
	remove_alaskan_guard(0x08)
	remove_alaskan_guard(0x09)
	remove_alaskan_guard(0x0a)
	remove_alaskan_guard(0x0b)
	remove_alaskan_guard(0x0d)
	remove_alaskan_guard(0x0e)
	remove_alaskan_guard(0x0f)

	set_ailist(CHR_SECRETARY, AILIST_REMOVE_OR_COWER)
	set_ailist(CHR_STEWARDESS, AILIST_REMOVE_OR_COWER)
	set_ailist(CHR_OFFICE1, AILIST_REMOVE_OR_COWER)
	set_ailist(CHR_OFFICE2, AILIST_REMOVE_OR_COWER)
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	yield
	set_ailist(0x10, AILIST_INIT_POSTTAKEOVER_GUARD)
	set_ailist(0x11, AILIST_INIT_POSTTAKEOVER_GUARD)

	#define enable_takeover_guard2(chr, function) \
		show_chr(chr) \
		set_ailist(chr, function) \
		unset_chr_hiddenflag(chr, CHRHFLAG_40000000) \
		unset_chr_chrflag(chr, CHRCFLAG_HIDDEN) \
		yield



	enable_takeover_guard2(0x15, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x17, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x21, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x23, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x25, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x27, 0x0423)
	enable_takeover_guard2(0x2a, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x2c, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x2e, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x30, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x32, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x34, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x36, AILIST_INIT_POSTTAKEOVER_GUARD)

	show_chr(0x42)
	set_ailist(0x42, AILIST_FOYER_SPAWNER)
	yield

	show_chr(0x43)
	set_ailist(0x43, AILIST_FOYER_SPAWNER)
	yield

	enable_takeover_guard2(0x22, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x24, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x26, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x28, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x2b, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x2d, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x2f, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x31, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x33, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x35, AILIST_INIT_POSTTAKEOVER_GUARD)
	enable_takeover_guard2(0x37, AILIST_INIT_POSTTAKEOVER_GUARD)

	set_ailist(0x10, AILIST_DRAW_MAGNUM)
	set_ailist(0x11, AILIST_DRAW_MAGNUM)
	unset_object_flag(0x2b, OBJFLAG_INVINCIBLE)
	unset_object_flag2(0x2b, OBJFLAG2_INVISIBLE)

	beginloop(0x6d)
		if_chr_y(CHR_P1P2, -2000, OPERATOR_LESS_THAN, /*goto*/ 0x02)
	endloop(0x6d)

	#define enable_bottom_guard(chr) \
		show_chr(chr) \
		set_ailist(chr, AILIST_INIT_POSTTAKEOVER_GUARD) \
		unset_chr_hiddenflag(chr, CHRHFLAG_40000000) \
		unset_chr_chrflag(chr, CHRCFLAG_HIDDEN) \
		yield



	label(0x02)
	enable_bottom_guard(0x13)
	enable_bottom_guard(0x14)
	enable_bottom_guard(0x16)
	enable_bottom_guard(0x18)
	enable_bottom_guard(0x1a)
	enable_bottom_guard(0x1c)
	enable_bottom_guard(0x1f)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0405_start_path15[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(12)
	set_reaction_speed(70)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	restart_timer

	beginloop(0x05)
		if_timer_gt(120, /*goto*/ 0x02)
	endloop(0x05)

	label(0x02)
	assign_path(15)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

/**
 * Assigned to the stewardess from another unused function.
 */
u8 func040b_unused[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, 0x040b)
	endlist
};

u8 func0407_stewardess[] = {
	set_shotlist(AILIST_STEWARDESS)
	if_chr_dying(CHR_SELF, /*goto*/ 0x02)
	if_chr_dying(CHR_SELF, /*goto*/ 0x02)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x02)
	goto_next(0x31)

	label(0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x31)
	if_just_injured(CHR_SELF, /*goto*/ 0x02)
	goto_next(0x4c)

	// Injured
	label(0x02)
	restart_timer

	beginloop(0x4d)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_MSG_NOWSYOURCHANCE, TRUE, /*goto*/ 0x75)
		if_distance_to_target_gt(200, /*goto*/ 0x75)
		set_stage_flag(STAGEFLAG_TRIGGER_MSG_NOWSYOURCHANCE)
		label(0x75)
		if_self_flag_bankx_eq(CHRFLAG0_SAID_INJURY_QUIP, TRUE, BANK_0, /*goto*/ 0x02)
		if_num_times_shot_lt(1, /*goto*/ 0x02)
		if_timer_lt(20, /*goto*/ 0x02)
		say_quip(CHR_BOND, 0x0d, 0x28, 0x03, 0x00, BANK_0, 0x00, 0x00)
		say_quip(CHR_BOND, 0x0e, 0x28, 0x03, 0x01, BANK_0, 0x00, 0x00)
		set_self_flag_bankx(CHRFLAG0_SAID_INJURY_QUIP, BANK_0)
		label(0x02)
		if_chr_stopped(/*goto*/ 0x4c)
	endloop(0x4d)

	// Not injured, or recovered
	label(0x4c)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x02)
	goto_next(0x16)

	label(0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	restart_timer

	beginloop(0x11)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_MSG_NOWSYOURCHANCE, TRUE, /*goto*/ 0x75)
		if_distance_to_target_gt(200, /*goto*/ 0x75)
		set_stage_flag(STAGEFLAG_TRIGGER_MSG_NOWSYOURCHANCE)
		label(0x75)
		if_self_flag_bankx_eq(CHRFLAG0_CAN_EXAMINE_BODY, FALSE, BANK_0, /*goto*/ 0x31)
		if_saw_death(0x00, /*goto*/ 0x0f)
		label(0x31)
		if_distance_to_target_gt(500, /*goto*/ 0x31)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x04)
		label(0x31)
		if_player_looking_at_something_maybe(0x00, 0x00, 0x01, /*goto*/ 0x02)
		if_target_in_sight(/*goto*/ 0x04)
		label(0x02)
		if_timer_gt(120, /*goto*/ 0x16)
	endloop(0x11)

	// Loaded
	label(0x16)
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x31)
	walk_to_pad(0x0012) // outside front door
	goto_next(0x00)

	label(0x31)
	walk_to_pad(0x0026) // top of escalators

	// Walking
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_MSG_NOWSYOURCHANCE, TRUE, /*goto*/ 0x75)
		if_distance_to_target_gt(200, /*goto*/ 0x75)
		set_stage_flag(STAGEFLAG_TRIGGER_MSG_NOWSYOURCHANCE)
		label(0x75)
		if_self_flag_bankx_eq(CHRFLAG0_CAN_EXAMINE_BODY, FALSE, BANK_0, /*goto*/ 0x31)
		if_saw_death(0x00, /*goto*/ 0x0f)
		label(0x31)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x04)
		if_player_looking_at_something_maybe(0x00, 0x00, 0x01, /*goto*/ 0x02)
		if_target_in_sight(/*goto*/ 0x04)
		label(0x02)
		if_chr_stopped(/*goto*/ 0x0b)
	endloop(0x00)

	// Saw player
	label(0x04)
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x05)

	beginloop(0x05)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x02)
		if_timer_gt(60, /*goto*/ 0x02)
	endloop(0x05)

	label(0x02)
	speak(CHR_TARGET, L_CAVE(25), 0x1adc, CHANNEL_4, COLOR_07_RED) // "Look out - it's an intruder..."
	increase_squadron_alertness(100)
	chr_do_animation(ANIM_SURRENDER_002E, 0, 193, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x06)
		if_chr_stopped(/*goto*/ 0x02)
	endloop(0x06)

	label(0x02)
	jog_to_pad(0x001d) // alcove in foyer

	beginloop(0x07)
		if_chr_stopped(/*goto*/ 0x0b)
	endloop(0x07)

	label(0x0b)
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x31)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	chr_do_animation(ANIM_SNEEZE, 0, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x69)
		if_chr_stopped(/*goto*/ 0x02)
	endloop(0x69)

	label(0x02)
	goto_first(0x16)

	label(0x31)
	set_stage_flag(STAGEFLAG_STEWARDESS_ENTERED_BASE)

	label(0x62)
		set_stage_flag(STAGEFLAG_DISGUISE_UNCOVERED)
		chr_do_animation(ANIM_COWER_0229, -1, 190, 0x10, 0x0a, CHR_SELF, 2)

		beginloop(0x63)
			if_chr_stopped(/*goto*/ 0x31)
		endloop(0x63)

		label(0x31)
	goto_first(0x62)

	label(0x0f)
	try_jog_to_chr(CHR_SEEDIE, /*goto*/ 0x49)
	dprint 'W','A','L','K','F','A','I','L','\n',0,

	beginloop(0x49)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_MSG_NOWSYOURCHANCE, TRUE, /*goto*/ 0x75)
		if_distance_to_target_gt(200, /*goto*/ 0x75)
		set_stage_flag(STAGEFLAG_TRIGGER_MSG_NOWSYOURCHANCE)
		label(0x75)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x4e)
		dprint 'W','A','L','K','I','N','G','\n',0,
		if_player_looking_at_something_maybe(0x00, 0x00, 0x01, /*goto*/ 0x31)
		if_target_in_sight(/*goto*/ 0x02)
		label(0x31)
		if_distance_to_chr_lt(200, 0xfb, /*goto*/ 0x4a)
		if_chr_stopped(/*goto*/ 0x4a)
	endloop(0x49)

	label(0x4a)
	unset_self_flag_bankx(CHRFLAG0_CAN_EXAMINE_BODY, BANK_0)
	speak(CHR_TARGET, L_CAVE(27), 0x1add, CHANNEL_4, COLOR_07_RED) // "Is he OK?"
	stop_chr
	restart_timer

	beginloop(0x4b)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_MSG_NOWSYOURCHANCE, TRUE, /*goto*/ 0x75)
		if_distance_to_target_gt(200, /*goto*/ 0x75)
		set_stage_flag(STAGEFLAG_TRIGGER_MSG_NOWSYOURCHANCE)
		label(0x75)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x4e)
		if_timer_gt(240, /*goto*/ 0x02)
	endloop(0x4b)

	label(0x02)
	speak(CHR_TARGET, L_CAVE(28), 0x1ade, CHANNEL_4, COLOR_07_RED) // "I'll go and get some help."
	restart_timer
	stop_chr

	beginloop(0x10)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_MSG_NOWSYOURCHANCE, TRUE, /*goto*/ 0x75)
		if_distance_to_target_gt(200, /*goto*/ 0x75)
		set_stage_flag(STAGEFLAG_TRIGGER_MSG_NOWSYOURCHANCE)
		label(0x75)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x4e)
		if_timer_gt(120, /*goto*/ 0x02)
	endloop(0x10)

	label(0x02)
	unset_self_flag_bankx(CHRFLAG0_CAN_EXAMINE_BODY, BANK_0)
	jog_to_pad(0x0026)
	goto_first(0x00)

	label(0x4e)
	goto_first(0x04)

	endlist
};

u8 func0406_become_unalerted[] = {
	set_self_chrflag(CHRCFLAG_00000040)
	label(0x00)
	yield
	if_enemy_distance_lt_and_los(2540, /*goto*/ 0x02)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)

	label(0x02)
	if_target_is_player(/*goto*/ 0x02)
	if_chr_dying(CHR_TARGET, /*goto*/ 0x02)
	if_chr_death_animation_finished(CHR_TARGET, /*goto*/ 0x02)
	if_chr_unloaded(CHR_TARGET, /*goto*/ 0x02)
	set_shotlist(AILIST_BECOME_UNALERTED)
	set_returnlist(CHR_SELF, AILIST_BECOME_UNALERTED)
	set_ailist(CHR_SELF, GAILIST_COMBAT_WITH_TARGET)

	label(0x02)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	set_returnlist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func1005_check_civilians_killed[] = {
	beginloop(0x00)
		if_stage_flag_eq(STAGEFLAG_SECURITY_SHUT_DOWN, TRUE, /*goto*/ 0x02)
		if_chr_dying(CHR_STEWARDESS, /*goto*/ 0x31)
		if_chr_dying(CHR_SECRETARY, /*goto*/ 0x31)
		if_chr_dying(CHR_OFFICE1, /*goto*/ 0x31)
		if_chr_dying(CHR_OFFICE2, /*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	show_hudmsg(CHR_BOND, L_CAVE(26)) // "Innocent civilians have been killed."
	set_stage_flag(STAGEFLAG_CIVILIANS_KILLED)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define init_path(reaction, health, armor, recovery, pathid) \
	set_accuracy(12) \
	set_reaction_speed(reaction) \
	set_chr_maxdamage(CHR_SELF, health) \
	add_health_or_armor(armor) \
	set_recovery_speed(recovery) \
	set_shield(0) \
	assign_path(pathid) \
	start_path \
	set_ailist(CHR_SELF, GAILIST_UNALERTED)



u8 func041b_start_path06[] = {
	init_path(70, 40, 0, 0, 0x06)
	endlist
};

u8 func041c_start_path07[] = {
	init_path(70, 40, 0, 0, 0x07)
	endlist
};

u8 func041d_start_path08[] = {
	init_path(70, 40, 0, 0, 0x08)
	endlist
};

u8 func041e_start_path09[] = {
	init_path(70, 40, 0, 0, 0x09)
	endlist
};

u8 func041f_start_path10[] = {
	init_path(70, 40, 0, 0, 0x0a)
	endlist
};

u8 func0420_start_path11[] = {
	init_path(45, 60, 40, 30, 0x0b)
	endlist
};

u8 func0421_start_path12[] = {
	init_path(45, 60, 40, 30, 0x0c)
	endlist
};

/**
 * Assigned to a stripes guard near the plane.
 */
u8 func0422_start_path13[] = {
	set_chr_team(CHR_SELF, TEAM_04)
	set_accuracy(12)
	set_reaction_speed(45)
	set_chr_maxdamage(CHR_SELF, 60)
	add_health_or_armor(40)
	set_recovery_speed(30)
	set_shield(0)
	rebuild_teams
	rebuild_squadrons
	assign_path(13)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func0423_start_path14[] = {
	set_chr_team(CHR_SELF, TEAM_04)
	set_accuracy(12)
	set_reaction_speed(45)
	set_chr_maxdamage(CHR_SELF, 60)
	add_health_or_armor(40)
	set_recovery_speed(30)
	set_shield(0)
	rebuild_teams
	rebuild_squadrons
	assign_path(14)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func0424_start_path15_unused[] = {
	set_accuracy(12)
	set_reaction_speed(45)
	set_chr_maxdamage(CHR_SELF, 60)
	add_health_or_armor(40)
	set_recovery_speed(30)
	set_shield(0)
	assign_path(15)
	start_path
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func040c_init_secretary[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_SECRETARY)
	endlist
};

/**
 * The secretary uses morale to track things.
 *
 * 0 = Not done anything
 * 1 = Not used
 * 2 = Said "good afternoon"
 * 3 = Said "you'll have to check that weapon"
 * 4 = Said "weapons are not allowed"
 */
u8 func0408_secretary[] = {
	set_shotlist(AILIST_SECRETARY)
	set_morale(0)
	if_chr_dying(CHR_SELF, /*goto*/ 0x02)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x02)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x02)
	goto_next(0x00)

	label(0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)
#define LABEL_MAIN_LOOP 0x00
#define LABEL_BECOME_ALERT1 0x66
#define LABEL_BECOME_ALERT2 0x68

	//
	// MAIN LOOP
	//
	beginloop(LABEL_MAIN_LOOP)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		set_view_distance(100)
		if_saw_injury(0x00, /*goto*/ LABEL_BECOME_ALERT1)
		if_saw_death(0x00, /*goto*/ LABEL_BECOME_ALERT1)
		set_view_distance(14)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ LABEL_BECOME_ALERT1)
		if_target_in_sight(/*goto*/ 0x02)
		if_alarm_active2(/*goto*/ 0x67)
	endloop(LABEL_MAIN_LOOP)

	// Joanna within 14 units (?) of distance
	label(0x02)
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x05)

	beginloop(0x05)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x02)
		if_timer_gt(60, /*goto*/ 0x02)
	endloop(0x05)

	label(0x02)
	if_stage_flag_eq(STAGEFLAG_DISGUISED, TRUE, /*goto*/ 0x07)

	//
	// BECOMING ALERT
	//
	label(LABEL_BECOME_ALERT1)
	mute_channel(CHANNEL_4)
	yield
	label(0x02)
	speak(CHR_TARGET, L_CAVE(32), 0x8162, CHANNEL_4, COLOR_06_WHITE) // "Oh, my God!"

	label(0x67)
	increase_squadron_alertness(100)
	restart_timer
	chr_do_animation(ANIM_SURRENDER_002E, 0, 193, 0x18, 0x10, CHR_SELF, 2)

	beginloop(0x06)
		if_chr_stopped(/*goto*/ 0x4f)
	endloop(0x06)

	label(0x4f)
	set_stage_flag(STAGEFLAG_DISGUISE_UNCOVERED)
	chr_do_animation(ANIM_COWER_0229, -1, -1, 0x10, 0x0a, CHR_SELF, 2)

	beginloop(0x0f)
		if_chr_stopped(/*goto*/ 0x31)
	endloop(0x0f)

	label(0x31)
	if_stage_flag_eq(STAGEFLAG_RECEPTIONIST_CALLED_SECURITY, TRUE, /*goto*/ 0x31)
	goto_next(0x77)

	label(0x31)
	goto_first(0x4f)

	// Unreachable
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Seen Jo while disguised
	label(0x07)
	if_morale_lt(2, /*goto*/ 0x32)
	goto_next(0x02)

	//
	// FIRST TALK
	//
	label(0x32)
	speak(CHR_TARGET, L_CAVE(29), 0x8161, CHANNEL_4, COLOR_06_WHITE) // "Good afternoon."
	chr_do_animation(ANIM_TALKING_0231, 0, 193, 0x18, 0x10, CHR_SELF, 2)
	restart_timer
	set_morale(2)

	beginloop(0x08)
		if_saw_injury(0x00, /*goto*/ LABEL_BECOME_ALERT2)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ LABEL_BECOME_ALERT2)
		if_timer_gt(60, /*goto*/ 0x02)
		if_chr_sees_player(/*goto*/ 0x31)
		goto_first(LABEL_MAIN_LOOP)

		label(0x31)
	endloop(0x08)

	//
	// SECOND TALK/WEAPON CHECK
	//
	label(0x02)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x0c)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x0c)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_HORIZONSCANNER, /*goto*/ 0x0c)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_SUITCASE, /*goto*/ 0x0c)
	if_morale_lt(3, /*goto*/ 0x32)
	goto_next(0x02)

	//
	// WEAPON TALK 1
	//
	label(0x32)
	speak(CHR_TARGET, L_CAVE(31), 0x1273, CHANNEL_4, COLOR_06_WHITE) // "You'll have to check that weapon in here."
	restart_timer
	chr_do_animation(ANIM_TALKING_0232, 0, 193, 0x18, 0x10, CHR_SELF, 2)
	set_morale(3)

	beginloop(0x09)
		if_saw_injury(0x00, /*goto*/ LABEL_BECOME_ALERT2)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ LABEL_BECOME_ALERT2)
		if_timer_gt(400, /*goto*/ 0x02)
		if_chr_sees_player(/*goto*/ 0x31)
		goto_first(LABEL_MAIN_LOOP)

		label(0x31)
	endloop(0x09)

	// 6.66 seconds since weapon talk
	label(0x02)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x31)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x31)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_HORIZONSCANNER, /*goto*/ 0x31)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_SUITCASE, /*goto*/ 0x31)
	if_morale_lt(4, /*goto*/ 0x32)
	goto_next(0x02)

	label(0x32)
	speak(CHR_TARGET, L_CAVE(33), 0x1274, CHANNEL_4, COLOR_06_WHITE) // "Weapons are not allowed in the base."
	restart_timer
	chr_do_animation(ANIM_TALKING_0233, 0, 193, 0x18, 0x10, CHR_SELF, 2)
	set_morale(4)

	beginloop(0x0a)
		if_saw_injury(0x00, /*goto*/ LABEL_BECOME_ALERT2)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ LABEL_BECOME_ALERT2)
		if_timer_gt(400, /*goto*/ 0x0c)
		if_chr_sees_player(/*goto*/ 0x31)
		goto_first(LABEL_MAIN_LOOP)

		label(0x31)
	endloop(0x0a)

	// Wait 1.5 seconds, check weapon equipped and call security if so
	label(0x0c)
	restart_timer

	beginloop(0x0d)
		if_timer_gt(90, /*goto*/ 0x31)
	endloop(0x0d)

	label(0x31)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_NONE, /*goto*/ 0x31)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x31)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_HORIZONSCANNER, /*goto*/ 0x31)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_SUITCASE, /*goto*/ 0x31)

	// Calling security
	label(0x77)
	speak(CHR_TARGET, L_CAVE(34), 0x1276, CHANNEL_4, COLOR_06_WHITE) // "Right, I'm calling security."
	set_stage_flag(STAGEFLAG_RECEPTIONIST_CALLED_SECURITY)
	activate_alarm
	restart_timer
	chr_do_animation(ANIM_SURRENDER_002E, 0, 193, 0x18, 0x10, CHR_SELF, 2)

	beginloop(0x0b)
		if_timer_gt(180, /*goto*/ 0x02)
	endloop(0x0b)

	label(0x02)
	goto_first(0x4f)

	// Unreachable
	set_ailist(CHR_SELF, GAILIST_IDLE)

	//
	// TALK 2
	//
	label(0x31)
	speak(CHR_TARGET, L_CAVE(30), 0x1272, CHANNEL_4, COLOR_06_WHITE) // "OK, you know the way from here."
	chr_do_animation(0x0232, 0, 193, 0x18, 0x10, CHR_SELF, 2)
	unlock_door(0x18, 0x02)

	beginloop(0x0e)
		if_saw_injury(0x00, /*goto*/ LABEL_BECOME_ALERT2)
		if_saw_death(0x00, /*goto*/ LABEL_BECOME_ALERT2)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ LABEL_BECOME_ALERT2)
	endloop(0x0e)

	label(0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(LABEL_BECOME_ALERT2)
	goto_first(LABEL_BECOME_ALERT1)

	endlist
};

u8 unregistered_function2[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_has_hiddenflag(CHR_P1P2, CHRHFLAG_DISGUISED, /*goto*/ 0x02)
	endloop(0x00)

	label(0x02)
	if_stage_flag_eq(STAGEFLAG_DISGUISE_UNCOVERED, TRUE, /*goto*/ 0x02)
	if_stage_flag_eq(STAGEFLAG_RECEPTIONIST_CALLED_SECURITY, TRUE, /*goto*/ 0x02)
	set_stage_flag(STAGEFLAG_DISGUISED)

	label(0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1007_console_activation[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_object_in_good_condition(OBJ_CONSOLE, /*goto*/ 0x31)
		goto_next(0x0c)

		label(0x31)
		if_chr_activated_object(CHR_P1P2, OBJ_CONSOLE, /*goto*/ 0x02)
	endloop(0x00)

	label(0x02)
	set_stage_flag(STAGEFLAG_CONSOLE_ACTIVATED)
	set_object_image(OBJ_CONSOLE, 0x00, 0x0f)
	set_object_image(OBJ_CONSOLE, 0x01, 0x0f)
	set_chr_flag_bankx(0x12, CHRFLAG0_00002000, BANK_0)
	show_hudmsg(CHR_P1P2, L_CAVE(35)) // "System shutdown initiated..."
	mute_channel(CHANNEL_1)
	assign_sound(0x01b9, CHANNEL_1)
	control_sound_from_object(CHANNEL_1, OBJ_CONSOLE, TRUE)
	restart_timer

	beginloop(0x04)
		if_object_in_good_condition(OBJ_CONSOLE, /*goto*/ 0x31)
		goto_next(0x0c)

		label(0x31)
		if_timer_gt(120, /*goto*/ 0x02)
	endloop(0x04)

	label(0x02)
	set_object_image(OBJ_CONSOLE, 0x00, 0x14)
	mute_channel(CHANNEL_1)
	assign_sound(0x0479, CHANNEL_1)
	control_sound_from_object(CHANNEL_1, OBJ_CONSOLE, TRUE)
	show_hudmsg(CHR_P1P2, L_CAVE(36)) // "Security systems have been shut down."
	set_stage_flag(STAGEFLAG_SECURITY_SHUT_DOWN)
	unset_chr_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISED)
	restart_timer

	beginloop(0x05)
		if_timer_gt(120, /*goto*/ 0x31)
	endloop(0x05)

	label(0x31)
	set_object_image(OBJ_CONSOLE, 0x01, 0x14)
	play_x_music(0x58, 88) // @bug? Invalid channel

	beginloop(0x06)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_y(CHR_P1P2, -2000, OPERATOR_LESS_THAN, /*goto*/ 0x02)
	endloop(0x06)

	label(0x02)
	stop_music_channel(CHANNEL_1)

	label(0x0c)
	mute_channel(CHANNEL_1)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define weapon_detection_logic(chr) \
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x08) \
 \
	label(0x00) \
	yield \
	mute_channel(CHANNEL_6) \
	set_lights_state(0x0039, 0x03, 0x78, 0xff, 0x3c) \
	set_lights_state(0x003a, 0x03, 0x78, 0xff, 0x3c) \
	set_lights_state(0x003b, 0x03, 0x78, 0xff, 0x3c) \
	set_lights_state(0x0041, 0x03, 0x78, 0xff, 0x3c) \
	set_lights_state(0x0042, 0x03, 0x78, 0xff, 0x3c) \
	set_lights_state(0x0043, 0x03, 0x78, 0xff, 0x3c) \
 \
	beginloop(0x65) \
		if_stage_flag_eq(STAGEFLAG_SUITCASE_DEPOSITED, TRUE, /*goto*/ 0x08) \
		if_chr_in_room(chr, 0x00, 0x0039, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x003a, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x003b, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x0041, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x0042, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x0043, /*goto*/ 0x31) \
	endloop(0x65) \
 \
	/* In hallway with weapons */ \
	label(0x31) \
	set_lights_state(0x0039, 0x04, 0x00, 0xff, 0x3c) \
	set_lights_state(0x003a, 0x04, 0x00, 0xff, 0x3c) \
	set_lights_state(0x003b, 0x04, 0x00, 0xff, 0x3c) \
	set_lights_state(0x0041, 0x04, 0x00, 0xff, 0x3c) \
	set_lights_state(0x0042, 0x04, 0x00, 0xff, 0x3c) \
	set_lights_state(0x0043, 0x04, 0x00, 0xff, 0x3c) \
	play_sound(0x04ac, CHANNEL_6) \
	restart_timer \
 \
	beginloop(0x04) \
		if_timer_gt(60, /*goto*/ 0x02) \
		if_chr_in_room(chr, 0x00, 0x0039, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x003a, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x003b, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x0041, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x0042, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x0043, /*goto*/ 0x31) \
		goto_first(0x00) \
 \
		label(0x31) \
	endloop(0x04) \
 \
	/* In hallway with weapons for over 60 frames */ \
	label(0x02) \
	restart_timer \
	set_lights_state(0x0039, 0x04, 0x00, 0xff, 0x32) \
	set_lights_state(0x003a, 0x04, 0x00, 0xff, 0x32) \
	set_lights_state(0x003b, 0x04, 0x00, 0xff, 0x32) \
	set_lights_state(0x0041, 0x04, 0x00, 0xff, 0x32) \
	set_lights_state(0x0042, 0x04, 0x00, 0xff, 0x32) \
	set_lights_state(0x0043, 0x04, 0x00, 0xff, 0x32) \
 \
	beginloop(0x05) \
		if_timer_gt(40, /*goto*/ 0x02) \
		if_chr_in_room(chr, 0x00, 0x0039, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x003a, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x003b, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x0041, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x0042, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x0043, /*goto*/ 0x31) \
		goto_first(0x00) \
 \
		label(0x31) \
	endloop(0x05) \
 \
	/* In hallway with weapons for over 100 frames */ \
	label(0x02) \
	restart_timer \
	set_lights_state(0x0039, 0x04, 0x00, 0xff, 0x28) \
	set_lights_state(0x003a, 0x04, 0x00, 0xff, 0x28) \
	set_lights_state(0x003b, 0x04, 0x00, 0xff, 0x28) \
	set_lights_state(0x0041, 0x04, 0x00, 0xff, 0x28) \
	set_lights_state(0x0042, 0x04, 0x00, 0xff, 0x28) \
	set_lights_state(0x0043, 0x04, 0x00, 0xff, 0x28) \
 \
	beginloop(0x06) \
		if_timer_gt(1, /*goto*/ 0x02) \
		if_chr_in_room(chr, 0x00, 0x0039, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x003a, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x003b, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x0041, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x0042, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x0043, /*goto*/ 0x31) \
		goto_first(0x00) \
 \
		label(0x31) \
	endloop(0x06) \
 \
	/* In hallway with weapons for over 101 frames */ \
	label(0x02) \
	restart_timer \
	set_lights_state(0x0039, 0x04, 0x00, 0xff, 0x1e) \
	set_lights_state(0x003a, 0x04, 0x00, 0xff, 0x1e) \
	set_lights_state(0x003b, 0x04, 0x00, 0xff, 0x1e) \
	set_lights_state(0x0041, 0x04, 0x00, 0xff, 0x1e) \
	set_lights_state(0x0042, 0x04, 0x00, 0xff, 0x1e) \
	set_lights_state(0x0043, 0x04, 0x00, 0xff, 0x1e) \
 \
	beginloop(0x07) \
		yield \
		yield \
		yield \
		yield \
		yield \
		yield \
		yield \
		yield \
		yield \
		if_timer_gt(30, /*goto*/ 0x02) \
		if_chr_in_room(chr, 0x00, 0x0039, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x003a, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x003b, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x0041, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x0042, /*goto*/ 0x31) \
		if_chr_in_room(chr, 0x00, 0x0043, /*goto*/ 0x31) \
		goto_first(0x00) \
 \
		label(0x31) \
	endloop(0x07) \
 \
	label(0x02) \
	show_hudmsg(chr, 0x0e25) /* "Weapons have been detected." */ \
	set_stage_flag(STAGEFLAG_WEAPONS_DETECTED) \
	label(0x31) \
	mute_channel(CHANNEL_6) \
	yield \
	activate_alarm \
	set_ailist(CHR_SELF, GAILIST_IDLE) \
 \
	/* Agent, or suitcase deposited */ \
	label(0x08) \
	set_ailist(CHR_SELF, GAILIST_IDLE)



u8 func1020_weapon_scanning_bond[] = {
	yield
	weapon_detection_logic(CHR_BOND)
	endlist
};

u8 func1021_weapon_scanning_coop[] = {
	yield
	set_target_chr(CHR_COOP)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x31)
	goto_next(0x02)

	label(0x31)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x02)
	weapon_detection_logic(CHR_COOP)
	endlist
};

u8 func1009_carousel_activation[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_BAGGAGE_CARRIER, /*goto*/ 0x02)
		if_stage_flag_eq(STAGEFLAG_SECURITY_SHUT_DOWN, TRUE, /*goto*/ 0x31)
		reloop(0x00)

		// Shut down without depositing
		label(0x31)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x09)
		show_hudmsg(CHR_BOND, L_CAVE(66)) // "Hover trolley has been shut down."
		set_stage_flag(STAGEFLAG_TROLLEY_SHUT_DOWN_WITHOUT_BRIEFCASE)
		yield
		show_hudmsg(CHR_BOND, L_CAVE(67)) // "Equipment cannot be checked in."
		label(0x09)
		set_ailist(CHR_SELF, GAILIST_IDLE)

		// Carrier activated
		label(0x02)
		if_chr_weapon_equipped(CHR_P1P2, WEAPON_SUITCASE, /*goto*/ 0x02)
	endloop(0x00)

	label(0x02)
	show_hudmsg(CHR_P1P2, L_CAVE(38)) // "Suitcase has been deposited."
	chr_draw_weapon_in_cutscene(CHR_P1P2, WEAPON_UNARMED)
	set_stage_flag(STAGEFLAG_SUITCASE_DEPOSITED)
	play_sound(0x80aa, CHANNEL_7)
	unset_object_flag2(OBJ_BRIEFCASE2, OBJFLAG2_INVISIBLE)
	move_object_to_pad(OBJ_BRIEFCASE2, 0x00de)
	yield
	restart_timer

	beginloop(0x05)
		if_timer_gt(120, /*goto*/ 0x02)
	endloop(0x05)

	label(0x02)
	clear_inventory(CHR_BOND)
	unset_object_flag(OBJ_BAGGAGE_CARRIER, OBJFLAG_DEACTIVATED)
	open_door(0x23)
	restart_timer

	beginloop(0x04)
		if_timer_gt(400, /*goto*/ 0x02)
	endloop(0x04)

	label(0x02)
	set_object_flag(OBJ_BAGGAGE_CARRIER, OBJFLAG_DEACTIVATED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100b_suitcase_scanning[] = {
	beginloop(0x00)
		if_stage_flag_eq(STAGEFLAG_SUITCASE_DEPOSITED, TRUE, /*goto*/ 0x02)
	endloop(0x00)

	label(0x02)
	restart_timer
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x07)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0xb7)

	// PA
	set_countdown_timer(30)
	show_countdown_timer
	start_countdown_timer

	beginloop(0x06)
		if_stage_flag_eq(STAGEFLAG_CONSOLE_ACTIVATED, TRUE, /*goto*/ 0x07)
		if_stage_flag_eq(STAGEFLAG_SECURITY_SHUT_DOWN, TRUE, /*goto*/ 0x07)
		if_countdown_timer_lt(1, /*goto*/ 0x02)
	endloop(0x06)

	// SA
	label(0xb7)
	set_countdown_timer(45)
	show_countdown_timer
	start_countdown_timer

	beginloop(0x05)
		if_stage_flag_eq(STAGEFLAG_CONSOLE_ACTIVATED, TRUE, /*goto*/ 0x07)
		if_stage_flag_eq(STAGEFLAG_SECURITY_SHUT_DOWN, TRUE, /*goto*/ 0x07)
		if_countdown_timer_lt(1, /*goto*/ 0x02)
	endloop(0x05)

	// Scanned
	label(0x02)
	show_hudmsg(CHR_BOND, L_CAVE(39)) // "Suitcase has been scanned."
	set_stage_flag(STAGEFLAG_SUITCASE_SCANNED)

	// Agent
	label(0x07)
	stop_countdown_timer
	hide_countdown_timer
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040d_init_office1[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_OFFICE1)
	endlist
};

u8 func0409_office1[] = {
#define LABEL_RUN_TO_FOYER 0x4f

	set_self_chrflag(CHRCFLAG_00040000)
	set_morale(0)
	set_shotlist(AILIST_OFFICE1)
	if_chr_dying(CHR_SELF, /*goto*/ 0x02)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x02)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x02)
	goto_next(0x42)

	label(0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x42)
	chr_do_animation(ANIM_SITTING_DORMANT, 0, -1, 0x14, 0x10, CHR_SELF, 2)

	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x02)
		if_saw_injury(0x00, /*goto*/ LABEL_RUN_TO_FOYER)
		if_stage_flag_eq(STAGEFLAG_OFFICE2_DEAD, TRUE, /*goto*/ LABEL_RUN_TO_FOYER)
		if_object_in_good_condition(0x45, /*goto*/ 0x33)
		goto_next(LABEL_RUN_TO_FOYER)

		label(0x33)
		if_chr_idle(/*goto*/ 0x31)
		goto_first(0x42)

		label(0x31)
	endloop(0x00)

	// Jo in sight
	label(0x02)
	if_stage_flag_eq(STAGEFLAG_DISGUISED, FALSE, /*goto*/ 0x07)

	// Disguised
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x31)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_HORIZONSCANNER, /*goto*/ 0x31)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_SUITCASE, /*goto*/ 0x31)
	goto_next(0x07)

	// Disguised and unarmed-ish
	label(0x31)
	chr_do_animation(ANIM_SITTING_0265, 0, -1, 0x14, 0x10, CHR_SELF, 2)
	speak(CHR_TARGET, L_CAVE(41), 0x1ae6, CHANNEL_4, COLOR_08_RED) // "Are you new around here?"

	beginloop(0x09)
		if_saw_injury(0x00, /*goto*/ LABEL_RUN_TO_FOYER)
		if_stage_flag_eq(STAGEFLAG_OFFICE2_DEAD, TRUE, /*goto*/ LABEL_RUN_TO_FOYER)
		if_chr_has_object(CHR_TARGET, OBJ_BRIEFCASE1, /*goto*/ 0x02)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x31)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_HORIZONSCANNER, /*goto*/ 0x31)
		if_chr_weapon_equipped(CHR_TARGET, WEAPON_SUITCASE, /*goto*/ 0x31)
		goto_next(0x07)

		label(0x31)
		if_chr_idle(/*goto*/ 0x31)
		goto_next(0x7b)

		label(0x31)
		reloop(0x09)

		label(0x7b)
		chr_do_animation(ANIM_SITTING_DORMANT, 0, -1, 0x14, 0x00, CHR_SELF, 2)
	endloop(0x09)

	// Picked up briefcase
	label(0x02)
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x0b)

	beginloop(0x0b)
		if_sound_finished(CHANNEL_4, /*goto*/ 0x31)
		reloop(0x0b)

		label(0x31)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x02)
		if_timer_gt(60, /*goto*/ 0x02)
	endloop(0x0b)

	label(0x02)
	speak(CHR_TARGET, L_CAVE(42), 0x1ae7, CHANNEL_4, COLOR_08_RED) // "Hey - give me back my case."
	restart_timer
	increase_squadron_alertness(100)

	beginloop(0x0a)
		if_timer_gt(120, /*goto*/ 0x02)
	endloop(0x0a)

	label(0x02)
	goto_next(LABEL_RUN_TO_FOYER)

	// Not disguised, or disguised with weapon equipped
	label(0x07)
	object_do_animation(0x025a, 0xff, 0x02, 0xffff)
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x05)

	beginloop(0x05)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x02)
		if_timer_gt(60, /*goto*/ 0x02)
	endloop(0x05)

	label(0x72)
	label(0x02)
	speak(CHR_TARGET, L_CAVE(40), 0x1ae5, CHANNEL_4, COLOR_08_RED) // "Hey, you - this is a restricted area."
	increase_squadron_alertness(100)
	restart_timer
	chr_do_animation(ANIM_WALK_BACKWARDS, -1, -1, 0x10, 0x10, CHR_SELF, 2)

	beginloop(0x06)
		if_timer_gt(180, /*goto*/ LABEL_RUN_TO_FOYER)
	endloop(0x06)

	// Run to foyer
	label(LABEL_RUN_TO_FOYER)
	jog_to_pad(0x001b)

	beginloop(0x08)
		if_chr_stopped(/*goto*/ 0x02)
	endloop(0x08)

	label(0x02)
	speak(CHR_TARGET, L_CAVE(44), 0x1ae8, CHANNEL_4, COLOR_08_RED) // "Upstairs...there's an intruder."
	increase_squadron_alertness(100)
	set_stage_flag(STAGEFLAG_DISGUISE_UNCOVERED)
	activate_alarm
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func040e_init_office2[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_OFFICE2)
	endlist
};

u8 func040a_office2[] = {
	set_self_chrflag(CHRCFLAG_00040000)
	set_morale(0)
	set_shotlist(AILIST_OFFICE2)
	if_chr_dying(CHR_SELF, /*goto*/ 0x02)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x02)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x02)
	goto_next(0x42)

	label(0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x42)
	chr_do_animation(ANIM_SITTING_DORMANT, 0, -1, 0x14, 0x10, CHR_SELF, 2)

	beginloop(0x00)
		if_alertness(99, OPERATOR_GREATER_THAN, /*goto*/ 0x02)
		if_saw_injury(0x00, /*goto*/ 0x72)
		if_stage_flag_eq(STAGEFLAG_OFFICE1_DEAD, TRUE, /*goto*/ 0x72)
		if_chr_idle(/*goto*/ 0x31)
		goto_first(0x42)

		label(0x31)
	endloop(0x00)

	// Alert
	label(0x02)

	beginloop(0x09)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_sees_player(/*goto*/ 0x02)
		if_saw_injury(0x00, /*goto*/ 0x02)
		if_stage_flag_eq(STAGEFLAG_OFFICE1_DEAD, TRUE, /*goto*/ 0x72)
	endloop(0x09)

	label(0x72)
	label(0x02)
	object_do_animation(0x025a, 0xff, 0x02, 0xffff)
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x05)

	// Wait for other guy to finish talking
	beginloop(0x05)
		if_sound_finished(CHANNEL_4, /*goto*/ 0x31)
		reloop(0x05)

		label(0x31)
		yield
		yield
		yield
		yield
		yield
		if_sound_finished(CHANNEL_4, /*goto*/ 0x31)
		reloop(0x05)

		label(0x31)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x02)
		if_timer_gt(60, /*goto*/ 0x02)
	endloop(0x05)

	label(0x02)
	if_chr_dying(CHR_OFFICE1, /*goto*/ 0x02)
	if_chr_death_animation_finished(CHR_OFFICE1, /*goto*/ 0x02)
	if_chr_unloaded(CHR_OFFICE1, /*goto*/ 0x02)
	speak(CHR_TARGET, L_CAVE(43), 0x1ae9, CHANNEL_4, COLOR_09_BLUE) // "You get security - I'll deal with her..."
	increase_squadron_alertness(100)
	restart_timer

	beginloop(0x06)
		if_chr_stopped(/*goto*/ 0x02)
		if_timer_gt(120, /*goto*/ 0x02)
	endloop(0x06)

	// Attack player
	label(0x02)
	set_self_flag_bankx(CHRFLAG1_00000001, BANK_1)
	set_ailist(CHR_SELF, GAILIST_ALERTED)

	// Unreachable
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100c_check_end_level[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_objective_complete(0, /*goto*/ 0x31)
		goto_first(0x00)

		label(0x31)
		if_difficulty_lt(DIFF_SA, /*goto*/ 0x31)
		if_objective_complete(1, /*goto*/ 0x31)
		goto_first(0x00)

		label(0x31)
		if_objective_complete(2, /*goto*/ 0x31)
		goto_first(0x00)

		label(0x31)
		if_difficulty_lt(DIFF_PA, /*goto*/ 0x31)
		if_objective_complete(3, /*goto*/ 0x31)
		goto_first(0x00)

		label(0x31)
		if_chr_distance_to_pad_lt(CHR_P1P2, 200, 0x00e9, /*goto*/ 0x04)
		if_chr_distance_to_pad_lt(CHR_P1P2, 200, 0x00d5, /*goto*/ 0x05)
	endloop(0x00)

	// Pad 0x00e9
	label(0x04)
	set_stage_flag(STAGEFLAG_BOARDED_PLANE)
	unset_savefile_flag(SAVEFILEFLAG_AF1_ENTRY)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x31)
	if_chr_dying(CHR_BOND, /*goto*/ 0x31)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x31)
	goto_next(0x02)

	label(0x31)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x31)
	if_chr_dying(CHR_COOP, /*goto*/ 0x31)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x31)
	goto_next(0x02)

	// Both players dead
	label(0x31)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Mission complete
	label(0x02)
	set_invincible(CHR_BOND)
	set_ailist(CHR_SELF, 0x0425)

	// Pad 0x00d5
	label(0x05)
	set_stage_flag(STAGEFLAG_BOARDED_PLANE)
	set_savefile_flag(SAVEFILEFLAG_AF1_ENTRY)
	if_chr_death_animation_finished(CHR_BOND, /*goto*/ 0x31)
	if_chr_dying(CHR_BOND, /*goto*/ 0x31)
	if_chr_unloaded(CHR_BOND, /*goto*/ 0x31)
	goto_next(0x02)

	label(0x31)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x31)
	if_chr_dying(CHR_COOP, /*goto*/ 0x31)
	if_chr_unloaded(CHR_COOP, /*goto*/ 0x31)
	goto_next(0x02)

	// Both players dead
	label(0x31)
	end_level
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Mission complete
	label(0x02)
	set_invincible(CHR_BOND)
	set_ailist(CHR_SELF, 0x0425)
	endlist
};

u8 func100d_laser_panel[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_LASER_PANEL, /*goto*/ 0x04)
		if_object_in_good_condition(OBJ_LASER_PANEL, /*goto*/ 0x02)
		goto_next(0x05)

		label(0x02)
		reloop(0x00)

		label(0x04)
		assign_sound(0x043a, CHANNEL_7)
		control_sound_from_object(CHANNEL_7, OBJ_LASER_PANEL, TRUE)
		show_hudmsg(CHR_P1P2, L_CAVE(45)) // "Laser grid access denied."
	endloop(0x00)

	label(0x05)
	set_stage_flag(STAGEFLAG_LASERS_OVERLOADED)
	show_hudmsg(CHR_P1P2, L_CAVE(46)) // "Laser grid system has been overloaded."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func100e_check_alaskans_killed[] = {
	set_chr_chrflag(0x00, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x01, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x02, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x03, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x04, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x05, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x06, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x07, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x08, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x09, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x0a, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x0b, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x0c, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x0d, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x0e, CHRCFLAG_KILLCOUNTABLE)
	set_chr_chrflag(0x0f, CHRCFLAG_KILLCOUNTABLE)

	beginloop(0x00)
		if_stage_flag_eq(STAGEFLAG_SECURITY_SHUT_DOWN, TRUE, /*goto*/ 0x02)
		if_kill_count_gt(2, /*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	show_hudmsg(CHR_BOND, L_CAVE(47)) // "Too many neutral casualties inflicted."
	set_stage_flag(STAGEFLAG_TOO_MANY_NEUTRALS_KILLED)
	label(0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * @unused
 */
u8 func0410_unused[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(22)
	set_reaction_speed(80)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_self_chrflag(CHRCFLAG_00000040)
	set_chr_chrflag(CHR_SELF, CHRCFLAG_00040000)
	set_ailist(CHR_SELF, AILIST_NSA)
	endlist
};

u8 func040f_nsa[] = {
	set_shotlist(AILIST_NSA)
	if_chr_dying(CHR_SELF, /*goto*/ 0x02)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x02)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x02)
	goto_next(0x44)

	label(0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x44)
	if_chr_distance_to_pad_lt(CHR_SELF, 70, PAD_PRESET, /*goto*/ 0x02)

	// Return to pad
	walk_to_pad(PAD_PRESET)

	beginloop(0x06)
		dprint 'G','O',' ','F','O','R',' ','P','A','D','\n',0,
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_distance_to_target_lt(250, /*goto*/ 0x64)
		if_self_flag_bankx_eq(CHRFLAG0_00000080, TRUE, BANK_0, /*goto*/ 0x33)
		if_chr_in_room(CHR_TARGET, 0x00, 0x006b, /*goto*/ 0x31)
		if_chr_in_room(CHR_TARGET, 0x00, 0x006c, /*goto*/ 0x31)
		if_chr_in_room(CHR_TARGET, 0x00, 0x006d, /*goto*/ 0x31)
		goto_first(0x00)

		label(0x33)
		if_chr_in_room(CHR_TARGET, 0x00, 0x003c, /*goto*/ 0x31)
		if_chr_in_room(CHR_TARGET, 0x00, 0x003d, /*goto*/ 0x31)
		if_chr_in_room(CHR_TARGET, 0x00, 0x003e, /*goto*/ 0x31)
		if_chr_y(CHR_TARGET, -257, OPERATOR_LESS_THAN, /*goto*/ 0x6d) // gone down an escalator
		goto_next(0x76)

		label(0x6d)
		if_chr_in_room(CHR_TARGET, 0x00, 0x003f, /*goto*/ 0x31)
		label(0x76)
		goto_first(0x00)

		label(0x31)
		if_chr_sees_player(/*goto*/ 0x04)
		if_chr_distance_to_pad_lt(CHR_SELF, 70, PAD_PRESET, /*goto*/ 0x02)
	endloop(0x06)

	// At pad
	label(0x02)
	stop_chr

	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		dprint 'W','A','I','T',' ','F','O','R',' ','C','H','R','\n',0,
		set_target_chr(CHR_P1P2)
		if_stage_flag_eq(STAGEFLAG_SECURITY_SHUT_DOWN, TRUE, /*goto*/ 0x0b)
		if_chr_sees_player(/*goto*/ 0x31)
	endloop(0x00)

	// Seen player
	label(0x31)
	dprint 'C','H','R','\n',0,
	if_chr_y(CHR_TARGET, -330, OPERATOR_LESS_THAN, /*goto*/ 0x02)
	goto_first(0x00)

	// Seen player down escalator
	label(0x02)
	if_self_flag_bankx_eq(CHRFLAG0_00000080, TRUE, BANK_0, /*goto*/ 0x33)
	if_chr_in_room(CHR_TARGET, 0x00, 0x006b, /*goto*/ 0x04)
	if_chr_in_room(CHR_TARGET, 0x00, 0x006c, /*goto*/ 0x04)
	if_chr_in_room(CHR_TARGET, 0x00, 0x006d, /*goto*/ 0x04)
	goto_first(0x00)

	label(0x33)
	if_chr_in_room(CHR_TARGET, 0x00, 0x003c, /*goto*/ 0x04)
	if_chr_in_room(CHR_TARGET, 0x00, 0x003d, /*goto*/ 0x04)
	if_chr_in_room(CHR_TARGET, 0x00, 0x003e, /*goto*/ 0x04)
	if_chr_y(CHR_TARGET, -257, OPERATOR_LESS_THAN, /*goto*/ 0x6d)
	goto_next(0x76)

	// Seen player down escalator but not in security hall
	label(0x6d)
	if_chr_in_room(CHR_TARGET, 0x00, 0x003f, /*goto*/ 0x04) // escalator room
	label(0x76)
	goto_first(0x00)

	// Seen player in security hall or escalator room
	label(0x04)
	restart_timer
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x09)

	beginloop(0x09)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x02)
		if_jo_ccw_direction_gt(245, /*goto*/ 0x02)
		if_timer_gt(60, /*goto*/ 0x02)
	endloop(0x09)

	label(0x02)
	chr_do_animation(ANIM_TALKING_0098, 0, 90, 0x00, 0x10, CHR_SELF, 2)
	say_quip(CHR_BOND, 0x1c, 0xff, 0x02, 0xff, 0x81, 0x00, 0x00)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)

	beginloop(0x0a)
		if_chr_stopped(/*goto*/ 0x02)
	endloop(0x0a)

	label(0x02)
	set_returnlist(CHR_SELF, GAILIST_ALERTED)
	set_ailist(CHR_SELF, GAILIST_ALERTED)

	// Unreachable
	restart_timer
	set_target_chr(CHR_P1P2)
	try_walk_to_target(/*goto*/ 0x05)

	// Also unreachable
	label(0x31)
	dprint 'R','U','N',' ','S','T','A','R','T','\n',0,
	restart_timer
	set_target_chr(CHR_BOND)
	try_run_to_target(/*goto*/ 0x05)

	beginloop(0x05)
		set_returnlist(CHR_SELF, GAILIST_ALERTED)
		set_ailist(CHR_SELF, GAILIST_ALERTED)
		dprint 'G','O',' ','F','O','R',' ','C','H','R','\n',0,
		if_chr_stopped(/*goto*/ 0x32)
		if_timer_gt(30, /*goto*/ 0x32)
		if_chr_y(CHR_TARGET, -330, OPERATOR_LESS_THAN, /*goto*/ 0x02)
		goto_next(0x07)

		label(0x02)
		if_self_flag_bankx_eq(CHRFLAG0_00000080, TRUE, BANK_0, /*goto*/ 0x33)
		if_chr_in_room(CHR_TARGET, 0x00, 0x006b, /*goto*/ 0x31)
		if_chr_in_room(CHR_TARGET, 0x00, 0x006c, /*goto*/ 0x31)
		if_chr_in_room(CHR_TARGET, 0x00, 0x006d, /*goto*/ 0x31)
		goto_next(0x07)

		label(0x33)
		if_chr_in_room(CHR_TARGET, 0x00, 0x003c, /*goto*/ 0x31)
		if_chr_in_room(CHR_TARGET, 0x00, 0x003d, /*goto*/ 0x31)
		if_chr_in_room(CHR_TARGET, 0x00, 0x003e, /*goto*/ 0x31)
		if_chr_in_room(CHR_TARGET, 0x00, 0x003f, /*goto*/ 0x31)
		goto_next(0x07)

		label(0x31)
		if_distance_to_target_lt(250, /*goto*/ 0x02)
	endloop(0x05)

	label(0x32)
	goto_first(0x04)

	label(0x64)
	label(0x02)
	set_self_flag_bankx(CHRFLAG1_00000001, BANK_1)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	set_returnlist(CHR_SELF, AILIST_NSA)
	set_ailist(CHR_SELF, GAILIST_HAND_COMBAT)

	label(0x07)
	chr_do_animation(ANIM_TALKING_0098, 0, 90, 0x00, 0x10, CHR_SELF, 2)
	say_quip(CHR_BOND, 0x1d, 0xff, 0x02, 0xff, 0x81, 0x00, 0x00)
	label(0x08)
	yield
	if_chr_stopped(/*goto*/ 0x02)
	goto_first(0x08)

	label(0x02)
	goto_first(0x44)

	label(0x0b)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func0412_init_takeover_lackey[] = {
	set_shotlist(GAILIST_ALERTED)
	set_self_chrflag(CHRCFLAG_00000040)
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(60)
	set_reaction_speed(80)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, AILIST_TAKEOVER_LACKEY)
	endlist
};

u8 func0411_takeover_lackey[] = {
	set_shotlist(GAILIST_ALERTED)
	if_chr_dying(CHR_SELF, /*goto*/ 0x02)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x02)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x02)
	goto_next(0x00)

	label(0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_chr_dying(0x0c, /*goto*/ 0x7b)
		if_chr_death_animation_finished(0x0c, /*goto*/ 0x7b)
		if_chr_unloaded(0x0c, /*goto*/ 0x7b)
		if_target_in_sight(/*goto*/ 0x31)
		goto_next(0x02)

		label(0x31)
		try_face_entity(0x0200, 0x0000, /*goto*/ 0x02)
		label(0x02)
		if_self_flag_bankx_eq(CHRFLAG0_00002000, FALSE, BANK_0, /*goto*/ 0x31)
		if_target_in_sight(/*goto*/ 0x02)
		label(0x31)
	endloop(0x00)

	// Alaskan guard is dead
	label(0x7b)
	label(0x02)
	set_chr_team(CHR_SELF, TEAM_04)
	if_chr_dying(0x0c, /*goto*/ 0x02)
	if_chr_death_animation_finished(0x0c, /*goto*/ 0x02)
	if_chr_unloaded(0x0c, /*goto*/ 0x02)
	set_target_chr(0x0c)
	try_chr_kneel_and_shoot_thing(0x0220, 0x0000, /*goto*/ 0x31)
	label(0x31)
	try_aim_and_shoot_thing2(0x0200, 0x0000, /*goto*/ 0x04)

	beginloop(0x04)
		if_chr_stopped(/*goto*/ 0x02)
	endloop(0x04)

	label(0x02)
	speak(CHR_TARGET, L_CAVE(65), 0x05bf, CHANNEL_6, COLOR_08_RED) // "We're taking over!!"

	beginloop(0x09)
		if_chr_stopped(/*goto*/ 0x02)
	endloop(0x09)

	label(0x02)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISE_UNCOVERED)
	set_chr_hiddenflag(CHR_COOP, CHRHFLAG_DISGUISE_UNCOVERED)
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

u8 func0413_alaskan_console_guard[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 unregistered_function3[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, AILIST_OFFICEWORKER)
	endlist
};

u8 func0414_officeworker[] = {
	set_morale(0)
	if_chr_dying(CHR_SELF, /*goto*/ 0x02)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x02)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x02)
	goto_next(0x00)

	label(0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x44)
	chr_do_animation(ANIM_SITTING_DORMANT, -1, 60, 0x14, 0x00, CHR_SELF, 2)

	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_stage_flag_eq(STAGEFLAG_SECURITY_SHUT_DOWN, TRUE, /*goto*/ 0x07)
		if_chr_idle(/*goto*/ 0x02)
		goto_next(0x08)

		label(0x02)
		if_target_in_sight(/*goto*/ 0x02)
		label(0x33)
	endloop(0x00)

	label(0x02)
	chr_do_animation(ANIM_SITTING_0265, 0, 120, 0x14, 0x10, CHR_SELF, 2)
	say_quip(CHR_BOND, 0x20, 0xff, 0x0a, 0xff, BANK_1, 0x00, 0x00)
	restart_timer

	beginloop(0x09)
		if_stage_flag_eq(STAGEFLAG_SECURITY_SHUT_DOWN, TRUE, /*goto*/ 0x07)
		if_chr_idle(/*goto*/ 0x02)
		goto_next(0x08)

		label(0x02)
		if_timer_gt(180, /*goto*/ 0x02)
	endloop(0x09)

	label(0x02)
	goto_first(0x00)

	label(0x08)
	goto_first(0x44)

	// After takeover
	label(0x07)
	if_difficulty_lt(DIFF_PA, /*goto*/ 0x6d)
	set_chr_hiddenflag(0x3a, CHRHFLAG_00100000)
	chr_move_to_pad(0x3a, 0x00d7, 0x00, /*goto*/ 0x31)

	label(0x31)
	chr_do_animation(ANIM_SITTING_DORMANT, -1, 60, 0x14, 0x00, CHR_SELF, 2)

	label(0x77)
	chr_do_animation(ANIM_COWER_0229, -1, 60, 0x14, 0x0a, CHR_SELF, 2)

	beginloop(0x04)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_target_in_sight(/*goto*/ 0x02)
		if_chr_idle(/*goto*/ 0x31)
		goto_first(0x77)

		label(0x31)
	endloop(0x04)

	label(0x02)
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x78)

	beginloop(0x78)
		if_jo_ccw_direction_lt(10, /*goto*/ 0x02)
		if_timer_gt(40, /*goto*/ 0x02)
	endloop(0x78)

	label(0x02)
	do_preset_animation(7)
	speak(CHR_TARGET, L_CAVE(54), 0x1b38, CHANNEL_4, COLOR_08_RED) // "Stop them - they're breaking into the safe..."

	beginloop(0x05)
		if_sound_finished(CHANNEL_4, /*goto*/ 0x79)
	endloop(0x05)

	label(0x79)
	chr_do_animation(0x0229, -1, 60, 0x14, 0x0a, CHR_SELF, 2)

	beginloop(0x06)
		if_chr_idle(/*goto*/ 0x02)
		goto_first(0x79)

		label(0x02)
	endloop(0x06)

	label(0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	beginloop(0x6d)
		damage_chr(CHR_SELF, 18)
		if_chr_dying(CHR_SELF, /*goto*/ 0x31)
	endloop(0x6d)

	label(0x31)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0415_alaskan_mountainlift_guard[] = {
	set_chr_maxdamage(CHR_SELF, 1)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func1010_setup_baggage_carrier[] = {
	set_object_flag(OBJ_BAGGAGE_CARRIER, OBJFLAG_DEACTIVATED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

#define laser_overloaded_logic(laser1, laser2, time) \
	beginloop(0x00) \
		if_stage_flag_eq(STAGEFLAG_LASERS_OVERLOADED, TRUE, /*goto*/ 0x04) \
	endloop(0x00) \
 \
	label(0x04) \
	restart_timer \
	open_door(laser1) \
	open_door(laser2) \
 \
	beginloop(0x05) \
		if_timer_gt(time, /*goto*/ 0x02) \
	endloop(0x05) \
 \
	label(0x02) \
	close_door(laser1) \
	close_door(laser2) \
 \
	beginloop(0x05) \
		if_timer_gt(time, /*goto*/ 0x02) \
	endloop(0x05) \
 \
	label(0x02) \
	goto_first(0x04) \
 \
	set_ailist(CHR_SELF, GAILIST_IDLE)



u8 func1011_lasers1[] = {
	laser_overloaded_logic(0x07, 0x0c, 120)
	endlist
};

u8 func1012_lasers2[] = {
	laser_overloaded_logic(0x0e, 0x10, 180)
	endlist
};

u8 func1013_lasers3[] = {
	laser_overloaded_logic(0x0b, 0x12, 90)
	endlist
};

u8 func1014_lasers4[] = {
	beginloop(0x00)
		if_stage_flag_eq(STAGEFLAG_LASERS_OVERLOADED, TRUE, /*goto*/ 0x04)
	endloop(0x00)

	label(0x04)
	restart_timer
	open_door(0x11)

	beginloop(0x05)
		if_timer_gt(180, /*goto*/ 0x02)
	endloop(0x05)

	label(0x02)
	close_door(0x11)

	beginloop(0x05)
		if_timer_gt(180, /*goto*/ 0x02)
	endloop(0x05)

	label(0x02)
	goto_first(0x04)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * This is the first laser, which gets disabled permanently.
 */
u8 func1017_laser5[] = {
	beginloop(0x00)
		if_stage_flag_eq(STAGEFLAG_LASERS_OVERLOADED, TRUE, /*goto*/ 0x04)
	endloop(0x00)

	label(0x04)
	restart_timer
	hide_object(0x13)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Unreachable
	open_door(0x13)

	beginloop(0x05)
		if_door_state(0x13, (DOORSTATE_CLOSED | DOORSTATE_CLOSING), /*goto*/ 0x31)
	endloop(0x05)

	label(0x31)
	goto_first(0x04)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0403_unused[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(12)
	set_reaction_speed(45)
	set_chr_maxdamage(CHR_SELF, 60)
	add_health_or_armor(40)
	set_recovery_speed(30)
	set_shield(0)
	set_chr_chrflag(CHR_SELF, CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1015_unhide_laser_guards[] = {
	// These are all invalid chrs. They must have been removed.
	// They would have appeared when the lasers were overloaded.
	hide_chr(0x3e)
	hide_chr(0x3f)
	hide_chr(0x40)
	hide_chr(0x41)
	set_chr_chrflag(0x3e, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x3f, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x40, CHRCFLAG_HIDDEN)
	set_chr_chrflag(0x41, CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	// Unreachable
	beginloop(0x00)
		if_stage_flag_eq(STAGEFLAG_LASERS_OVERLOADED, TRUE, /*goto*/ 0x02)
	endloop(0x00)

	label(0x02)
	unset_chr_chrflag(0x3e, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x3f, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x40, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(0x41, CHRCFLAG_HIDDEN)
	show_chr(0x3e)
	set_ailist(0x3e, 0x0404)
	show_chr(0x3f)
	set_ailist(0x3f, GAILIST_ALERTED)
	show_chr(0x40)
	set_ailist(0x40, GAILIST_ALERTED)
	show_chr(0x41)
	set_ailist(0x41, GAILIST_ALERTED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * After overloading the lasers, some guards would have been unhidden who will
 * chase you down. This function would have been assigned to one of them.
 *
 * @unused
 */
u8 func0404_laser_guard[] = {
	set_shotlist(GAILIST_UNALERTED)
	run_to_pad(0x0002)
	label(0x04)
	yield
	label(0x02)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1016_console_noises[] = {
	yield
	assign_sound(0x8141, CHANNEL_0)
	play_sound_from_object(CHANNEL_0, 0x04, 0x0258, 0x0320)
	yield
	assign_sound(0x8143, CHANNEL_2)
	play_sound_from_object(CHANNEL_2, 0x05, 0x01f4, 0x03e8)
	yield
	play_sound_from_pad(0x0114, 0x81a7)
	yield
	play_sound_from_pad(0x0115, 0x81a7)
	yield
	play_sound_from_pad(0x01ac, 0x811b)

	label(0x42)
	restart_timer

	beginloop(0x00)
		if_object_in_good_condition(OBJ_CONSOLE, /*goto*/ 0x31)
		goto_next(0x09)

		label(0x31)
		if_timer_gt(180, /*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	yield
	if_object_in_good_condition(0x01, /*goto*/ 0x31)
	goto_next(0x09)

	label(0x31)
	if_stage_flag_eq(STAGEFLAG_SECURITY_SHUT_DOWN, TRUE, /*goto*/ 0x09)
	call_rng
	if_rand_lt(100, /*goto*/ 0x76)
	if_rand_lt(150, /*goto*/ 0x77)
	if_rand_lt(200, /*goto*/ 0x78)
	goto_first(0x42)

	// Rand 1
	label(0x76)
	if_object_in_good_condition(OBJ_CONSOLE, /*goto*/ 0x31)
	goto_next(0x09)

	label(0x31)
	mute_channel(CHANNEL_1)
	yield
	yield
	yield
	yield
	yield
	assign_sound(0x8112, CHANNEL_1)
	play_sound_from_object(CHANNEL_1, OBJ_CONSOLE, 0x0258, 0x0320)
	goto_first(0x42)

	// Rand 2
	label(0x77)
	if_object_in_good_condition(OBJ_CONSOLE, /*goto*/ 0x31)
	goto_next(0x09)

	label(0x31)
	mute_channel(CHANNEL_1)
	yield
	yield
	yield
	yield
	yield
	assign_sound(0x813f, CHANNEL_1)
	play_sound_from_object(CHANNEL_1, OBJ_CONSOLE, 0x0258, 0x0320)
	goto_first(0x42)

	// Rand 3
	label(0x78)
	if_object_in_good_condition(OBJ_CONSOLE, /*goto*/ 0x31)
	goto_next(0x09)

	label(0x31)
	mute_channel(CHANNEL_1)
	yield
	yield
	yield
	yield
	yield
	assign_sound(0x8140, CHANNEL_1)
	play_sound_from_object(CHANNEL_1, OBJ_CONSOLE, 0x0258, 0x0320)
	goto_first(0x42)

	label(0x09)
	mute_channel(CHANNEL_1)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func0426_init_alaskan_guard[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(12)
	set_reaction_speed(70)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

/**
 * Assigned to stripes guards and NSA lackeys during takeover.
 */
u8 func0427_init_posttakeover_guard[] = {
	set_self_chrflag(CHRCFLAG_00040000)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_chr_team(CHR_SELF, TEAM_04)
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(12)
	set_reaction_speed(45)
	set_chr_maxdamage(CHR_SELF, 60)
	add_health_or_armor(40)
	set_recovery_speed(30)
	set_shield(0)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, AILIST_POSTTAKEOVER_GUARD)
	endlist
};

/**
 * Wait until not in sight by any human player,
 * then assign AILIST_BECOME_UNALERTED.
 */
u8 func0428_posttakeover_guard[] = {
	beginloop(0x00)
		set_target_chr(CHR_BOND)
		if_within_units_of_sight(30, /*goto*/ 0x31)
		if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x02)
		set_target_chr(CHR_COOP)
		if_within_units_of_sight(30, /*goto*/ 0x31)

		label(0x02)
		if_chr_death_animation_finished(CHR_ANTI, /*goto*/ 0x02)
		set_target_chr(CHR_ANTI)
		if_within_units_of_sight(30, /*goto*/ 0x31)

		label(0x02)
		unset_self_chrflag(CHRCFLAG_HIDDEN)
		unset_self_chrflag(CHRCFLAG_00040000)
		set_ailist(CHR_SELF, AILIST_BECOME_UNALERTED)

		label(0x31)
		restart_timer

		beginloop(0x6d)
			if_timer_gt(300, /*goto*/ 0x02)
		endloop(0x6d)

		label(0x02)
	endloop(0x00)

	endlist
};

/**
 * @unused
 */
u8 func0429_unused[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(22)
	set_reaction_speed(80)
	set_chr_maxdamage(CHR_SELF, 40)
	add_health_or_armor(0)
	set_recovery_speed(0)
	set_shield(0)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

/**
 * Assigned to two stripes guards in the foyer during takeover.
 */
u8 func042a_foyer_spawner[] = {
	set_chr_dodge_rating(2, 0x0a)
	set_accuracy(12)
	set_reaction_speed(45)
	set_chr_maxdamage(CHR_SELF, 60)
	add_health_or_armor(40)
	set_recovery_speed(30)
	set_shield(0)
	set_self_chrflag(CHRCFLAG_00000002)
	set_self_chrflag(CHRCFLAG_HIDDEN)
	set_self_chrflag(CHRCFLAG_00040000)

	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		set_target_chr(CHR_P1P2)
		if_stage_flag_eq(STAGEFLAG_SECURITY_SHUT_DOWN, TRUE, /*goto*/ 0x02)
		if_chr_y(CHR_TARGET, -4800, OPERATOR_LESS_THAN, /*goto*/ 0x09)
		reloop(0x00)

		// Security shut down
		label(0x02)
		set_chr_team(CHR_SELF, TEAM_04)
		rebuild_teams
		rebuild_squadrons
		dprint 'O','B','J','E','C','T','I','V','E',' ','D','O','N','E','\n',0,
		if_never_been_onscreen(/*goto*/ 0x6a)
		if_chr_sees_player(/*goto*/ 0x04)
		reloop(0x00)

		label(0x04)
		set_ailist(CHR_SELF, AILIST_FOYER_CLONE)

		label(0x6a)
		unset_self_chrflag(CHRCFLAG_HIDDEN)
		if_chr_death_animation_finished(CHR_CLONE, /*goto*/ 0x6a)
		reloop(0x00)

		label(0x6a)
		try_spawn_clone2(CHR_SELF, AILIST_INIT_FOYER_CLONE, 0x00000000, /*goto*/ 0x31)
		label(0x31)
		yield
	endloop(0x00)

	// Player has gone to bottom without disabling security
	label(0x09)
	set_ailist(CHR_SELF, GAILIST_SEARCH_FOR_PLAYER)
	endlist
};

u8 func042b_init_foyer_clone[] = {
	set_self_flag_bankx(CHRFLAG1_00080000, BANK_1)
	label(0x00)
	rebuild_teams
	rebuild_squadrons
	try_inherit_properties(0x42, /*goto*/ 0x02)
	label(0x02)
	set_ailist(CHR_SELF, AILIST_FOYER_CLONE)
	endlist
};

u8 func042c_foyer_clone[] = {
	set_ailist(CHR_SELF, GAILIST_ALERTED)
	endlist
};

#define hoverbot_do_paths(path1, path2, path3) \
	/* Path 1 */ \
	label(0x44) \
	begin_hovercar_path(path1) \
	label(0x31) \
	set_vehicle_speed(512, 120) \
 \
	beginloop(0x04) \
		if_hoverbot_next_step(OPERATOR_GREATER_THAN, 3, /*goto*/ 0x02) \
	endloop(0x04) \
 \
	/* Path 2 */ \
	label(0x02) \
	begin_hovercar_path(path2) \
	label(0x31) \
	set_vehicle_speed(512, 120) \
 \
	beginloop(0x05) \
		if_hoverbot_next_step(OPERATOR_GREATER_THAN, 3, /*goto*/ 0x02) \
	endloop(0x05) \
 \
	/* Path 3 */ \
	label(0x02) \
	begin_hovercar_path(path3) \
	label(0x31) \
	set_vehicle_speed(512, 120) \
 \
	beginloop(0x06) \
		if_hoverbot_next_step(OPERATOR_GREATER_THAN, 3, /*goto*/ 0x02) \
	endloop(0x06) \
 \
	label(0x02) \
	goto_first(0x44) \
 \
	set_ailist(CHR_SELF, GAILIST_IDLE)



u8 func042d_hoverbot1[] = {
	hoverbot_do_paths(0, 1, 2)
	endlist
};

u8 func042e_hoverbot2[] = {
	hoverbot_do_paths(1, 2, 0)
	endlist
};

u8 func042f_hoverbot3[] = {
	hoverbot_do_paths(2, 0, 1)
	endlist
};

u8 func0430_hoverbot4[] = {
	hoverbot_do_paths(3, 4, 5)
	endlist
};

u8 func0431_hoverbot5[] = {
	hoverbot_do_paths(4, 5, 3)
	endlist
};

u8 func0432_hoverbot6[] = {
	hoverbot_do_paths(5, 3, 4)
	endlist
};

/**
 * This looks to be copied from Chicago? But is assigned to an chr called
 * steward.
 */
u8 func0419_ba8c[] = {
	set_alertness(255)
	set_returnlist(CHR_SELF, 0x0419)
	set_shotlist(0x0419)
	if_chr_dying(CHR_SELF, /*goto*/ 0x02)
	if_chr_death_animation_finished(CHR_SELF, /*goto*/ 0x02)
	if_chr_unloaded(CHR_SELF, /*goto*/ 0x02)
	goto_next(0x31)

	label(0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x31)
	if_chr_idle(/*goto*/ 0x6b)
	if_num_times_shot_lt(1, /*goto*/ 0x00)

	beginloop(0x0c)
		if_chr_stopped(/*goto*/ 0x02)
	endloop(0x0c)

	label(0x02)
	goto_next(0x0b)

	// Unreachable
	restart_timer

	beginloop(0x6b)
		if_saw_death(0x00, /*goto*/ 0x4f)
		if_saw_injury(0x00, /*goto*/ 0x0f)
		dprint 'D','U','R','I','N','G','T','A','L','K','\n',0,
		if_timer_gt(180, /*goto*/ 0x02)
	endloop(0x6b)

	label(0x02)
	if_self_flag_bankx_eq(CHRFLAG0_00004000, TRUE, BANK_0, /*goto*/ 0x33)
	dprint 'N','O','T',' ','A',' ','P','A','T','R','O','L','L','E','R','\n',0,
	stop_chr
	goto_next(0x00)

	label(0x33)
	dprint 'P','A','T',' ','R','E','T','\n',0,
	start_path
	label(0x00)
	yield
	if_self_flag_bankx_eq(CHRFLAG0_00004000, TRUE, BANK_0, /*goto*/ 0x6c)
	call_rng
	if_rand_gt(128, /*goto*/ 0x6c)
	label(0x6d)
	restart_timer
	label(0x07)
	stop_chr
	if_self_flag_bankx_eq(CHRFLAG1_DONE_SEARCH_ANIM, TRUE, BANK_1, /*goto*/ 0x31)
	call_rng
	if_rand_gt(128, /*goto*/ 0x31)
	call_rng
	if_rand_lt(64, /*goto*/ 0x6e)
	if_rand_lt(128, /*goto*/ 0x6f)
	if_rand_lt(196, /*goto*/ 0x70)
	set_self_flag_bankx(CHRFLAG1_DONE_SEARCH_ANIM, BANK_1)
	chr_do_animation(ANIM_SMOKE_CIGARETTE, 0, -1, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x72)

	label(0x6e)
	chr_do_animation(ANIM_SCRATCH_HEAD, 0, -1, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x72)

	label(0x6f)
	chr_do_animation(ANIM_YAWN, 0, -1, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x72)

	label(0x70)
	chr_do_animation(ANIM_GRAB_CROTCH, 0, -1, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x72)

	label(0x71)
	chr_do_animation(ANIM_TWO_GUN_HOLD, 0, 100, 0x10, 0x0a, CHR_SELF, 2)
	goto_next(0x72)

	label(0x31)
	unset_self_flag_bankx(CHRFLAG1_DONE_SEARCH_ANIM, BANK_1)
	if_chr_distance_to_pad_lt(CHR_SELF, 100, PAD_PRESET, /*goto*/ 0x02)
	goto_next(0x31)

	label(0x02)
	call_rng
	if_rand_lt(64, /*goto*/ 0x6e)
	if_rand_lt(128, /*goto*/ 0x6f)
	if_rand_lt(196, /*goto*/ 0x70)
	try_set_target_pad_to_something(0x08, /*goto*/ 0x31)
	label(0x6e)
	try_set_target_pad_to_something(0x02, /*goto*/ 0x31)
	label(0x6f)
	try_set_target_pad_to_something(0x04, /*goto*/ 0x31)
	label(0x70)
	try_set_target_pad_to_something(0x08, /*goto*/ 0x31)
	goto_next(0x72)
	label(0x31)
	go_to_target_pad(SPEED_WALK)
	restart_timer
	label(0x72)
	yield
	chr_toggle_p1p2(CHR_SELF)
	set_target_chr(CHR_P1P2)
	if_saw_death(0x00, /*goto*/ 0x4f)
	if_saw_injury(0x00, /*goto*/ 0x0f)
	if_target_in_sight(/*goto*/ 0x02)
	if_chr_stopped(/*goto*/ 0x73)
	if_chr_idle(/*goto*/ 0x31)
	if_timer_gt(180, /*goto*/ 0x73)
	label(0x31)
	goto_first(0x72)

	label(0x73)
	goto_first(0x00)

	label(0x6c)
	if_saw_death(0x00, /*goto*/ 0x4f)
	if_saw_injury(0x00, /*goto*/ 0x0f)
	if_target_in_sight(/*goto*/ 0x02)
	goto_first(0x00)

	label(0x02)
	restart_timer
	label(0x04)
	yield
	if_saw_death(0x00, /*goto*/ 0x4f)
	if_saw_injury(0x00, /*goto*/ 0x0f)
	if_chr_weapon_equipped(CHR_TARGET, WEAPON_UNARMED, /*goto*/ 0x31)
	goto_next(0x02)
	label(0x31)
	if_self_flag_bankx_eq(CHRFLAG0_00002000, TRUE, BANK_0, /*goto*/ 0x31)
	if_distance_to_target_gt(450, /*goto*/ 0x31)
	set_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	set_returnlist(CHR_SELF, 0x0419)
	set_ailist(CHR_SELF, GAILIST_CIVILIAN_SAY_COMMENT)
	label(0x31)
	if_timer_lt(600, /*goto*/ 0x31)
	unset_self_flag_bankx(CHRFLAG0_00002000, BANK_0)
	label(0x31)
	dprint 'L','I','M','O',' ','R','E','A','D','Y',' ','T','O',' ','G','O','\n',0,
	goto_first(0x00)

	label(0x0f)
	restart_timer
	try_face_entity(0x0200, 0x0000, /*goto*/ 0x08)
	label(0x08)
	yield
	if_jo_ccw_direction_lt(10, /*goto*/ 0x02)
	if_timer_gt(40, /*goto*/ 0x02)
	goto_first(0x08)

	label(0x4f)
	restart_timer
	chr_do_animation(0x025f, 0, 193, 0x10, 0x10, CHR_SELF, 2)
	label(0x0f)
	yield
	if_timer_gt(90, /*goto*/ 0x0b)
	goto_first(0x0f)

	label(0x02)
	say_quip(CHR_BOND, 0x24, 0xff, 0x00, 0xff, 0x81, 0x00, 0x00)
	chr_do_animation(0x002e, 0, 193, 0x10, 0x10, CHR_SELF, 2)
	label(0x09)
	yield
	if_timer_gt(120, /*goto*/ 0x0b)
	goto_first(0x09)

	label(0x0b)
	try_set_chrpreset_to_unalerted_teammate(0, /*goto*/ 0x02)
	goto_next(0x0e)
	label(0x31)
	goto_first(0x04)

	label(0x02)
	try_run_to_chr(CHR_PRESET, /*goto*/ 0x05)
	label(0x05)
	yield
	if_detected_chr(CHR_PRESET, /*goto*/ 0x02)
	goto_first(0x05)

	label(0x02)
	increase_squadron_alertness(100)
	say_quip(CHR_BOND, 0x25, 0xff, 0x00, 0xff, 0x81, 0x00, 0x00)
	label(0x0e)
	chr_do_animation(0x0229, -1, -1, 0x10, 0x14, CHR_SELF, 2)
	label(0x0a)
	yield
	if_chr_stopped(/*goto*/ 0x31)
	goto_first(0x0a)

	label(0x31)
	goto_first(0x0e)

	endlist
};

u8 func041a_draw_magnum[] = {
	set_chr_team(CHR_SELF, TEAM_04)
	try_equip_weapon(MODEL_CHRDY357, WEAPON_DY357MAGNUM, 0x10000000, /*goto*/ 0x00)
	label(0x00)
	unset_self_flag_bankx(CHRFLAG1_00000001, BANK_1)
	set_self_flag_bankx(CHRFLAG0_AIVSAI, BANK_0)
	set_self_flag_bankx(CHRFLAG1_WARNED, BANK_1)
	rebuild_teams
	rebuild_squadrons
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func141b_setup_lifts[] = {
	activate_lift(1, 0x20)
	activate_lift(2, 0x21)
	activate_lift(9, 0x36)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1018_safe_switch[] = {
	set_object_flag2(OBJ_FLIGHTPLANS, OBJFLAG2_INVISIBLE)
	set_object_flag(OBJ_SAFE_SWITCH_COVER, OBJFLAG_DEACTIVATED)

	// Wait for player to activate switch
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_SAFE_SWITCH, /*goto*/ 0x31)
	endloop(0x00)

	// Raise switch cover
	label(0x31)
	unset_object_flag(OBJ_SAFE_SWITCH_COVER, OBJFLAG_DEACTIVATED)

	beginloop(0x05)
		if_lift_stationary(OBJ_SAFE_SWITCH_COVER, /*goto*/ 0x31)
	endloop(0x05)

	label(0x31)
	set_object_flag(OBJ_SAFE_SWITCH_COVER, OBJFLAG_DEACTIVATED)

	// Wait for player to press button again
	beginloop(0x06)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, OBJ_SAFE_SWITCH, /*goto*/ 0x31)
	endloop(0x06)

	// Open safe
	label(0x31)
	play_sound(0x00ba, -1)
	yield
	yield
	yield
	yield
	yield
	open_door(OBJ_SAFEDOOR)
	yield
	set_object_flag(OBJ_SAFEDOOR, OBJFLAG_40000000)

	unset_object_flag2(OBJ_FLIGHTPLANS, OBJFLAG2_INVISIBLE)
	unset_object_flag(OBJ_FLIGHTPLANS, OBJFLAG_UNCOLLECTABLE)
	set_object_flag(OBJ_FLIGHTPLANS, OBJFLAG_COLLECTABLE)
	set_object_flag2(OBJ_FLIGHTPLANS, OBJFLAG2_00001000)

	// 0x32 = a shield
	set_object_flag2(0x34, OBJFLAG2_00001000)
	unset_object_flag(0x34, OBJFLAG_UNCOLLECTABLE)

	// 0x32 = invalid object
	unset_object_flag2(0x32, OBJFLAG2_INVISIBLE)
	unset_object_flag(0x32, OBJFLAG_UNCOLLECTABLE)

	label(0x31)

	beginloop(0x08)
		if_door_state(OBJ_SAFEDOOR, DOORSTATE_CLOSING, /*goto*/ 0x31)
		reloop(0x08)

		label(0x31)
		open_door(OBJ_SAFEDOOR)
	endloop(0x08)

	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1018_safe_switch_cover[] = {
	set_object_flag(OBJ_SAFE_SWITCH_COVER, OBJFLAG_DEACTIVATED)

	beginloop(0x00)
		if_chr_activated_object(CHR_ANY, OBJ_SAFE_SWITCH_COVER, /*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	unset_object_flag(OBJ_SAFE_SWITCH_COVER, OBJFLAG_DEACTIVATED)
	yield
	yield

	beginloop(0x04)
		if_lift_stationary(OBJ_SAFE_SWITCH_COVER, /*goto*/ 0x31)
	endloop(0x04)

	label(0x31)
	set_object_flag(OBJ_SAFE_SWITCH_COVER, OBJFLAG_CANNOT_ACTIVATE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101a_check_disguise_used[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_has_hiddenflag(CHR_P1P2, CHRHFLAG_DISGUISED, /*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	show_hudmsg(CHR_P1P2, L_CAVE(49)) // "Disguise worn."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1003_intro[] = {
	label(0x31)
	set_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	set_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	set_music_track(MUSIC_AIRBASE_INTRO)
	camera_movement(0x01e5)
	cmd0175(60)
	set_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x01e6, -1, -1, 0x06, 0x00, CHR_BOND, 4)
	set_chr_hudpiece_visible(CHR_BOND, TRUE)
	set_chr_chrflag(CHR_TRENT, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(CHR_TRENT, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(CHR_TRENT, CHRHFLAG_00020000)
	chr_do_animation(0x01e7, -1, -1, 0x06, 0x00, CHR_TRENT, 4)
	set_chr_chrflag(0x48, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x48, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x48, CHRHFLAG_00020000)
	chr_do_animation(0x01e8, -1, -1, 0x06, 0x00, 0x48, 4)
	set_chr_chrflag(0x49, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x49, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x49, CHRHFLAG_00020000)
	chr_do_animation(0x01e9, -1, -1, 0x06, 0x00, 0x49, 4)
	set_chr_chrflag(0x4a, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x4a, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x4a, CHRHFLAG_00020000)
	chr_do_animation(0x01ea, -1, -1, 0x06, 0x00, 0x4a, 4)
	set_chr_chrflag(0x4b, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x4b, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x4b, CHRHFLAG_00020000)
	chr_do_animation(0x01eb, -1, -1, 0x06, 0x00, 0x4b, 4)
	set_chr_chrflag(0x4c, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x4c, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x4c, CHRHFLAG_00020000)
	chr_do_animation(0x01ec, -1, -1, 0x06, 0x00, 0x4c, 4)
	show_object(0x22)
	set_object_flag2(0x22, OBJFLAG2_04000000)
	set_object_flag3(0x22, OBJFLAG3_00000010)
	object_do_animation(0x01ed, 0x22, 0x04, 0xffff)
	show_object(0x2f)
	set_object_flag2(0x2f, OBJFLAG2_04000000)
	set_object_flag3(0x2f, OBJFLAG3_00000010)
	object_do_animation(0x01ee, 0x2f, 0x04, 0xffff)
	restart_timer
	fade_to_color(0x000000ff, 0x0000)
	fade_to_color(0x00000000, 0x006e)
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)
	yield
	set_cutscene_weapon(CHR_BOND, WEAPON_NONE, WEAPON_NONE)

	wait_until(30, 0x6d)
	speak(CHR_BOND, L_CAVE(55), 0x7447, CHANNEL_7, COLOR_09_BLUE) // "Agent Dark in prop. I can see the main entranc..."

	wait_until(312, 0x89)
	play_sound(0x0594, CHANNEL_10)

	wait_until(346, 0x8a)
	play_sound(0x0595, CHANNEL_10)

	wait_until(580, 0x76)
	speak(CHR_BOND, L_CAVE(56), 0x7448, CHANNEL_10, COLOR_06_WHITE) // "Excellent, Joanna. That cable car is your way in....."

	wait_until(968, 0x8b)
	play_sound(0x0596, CHANNEL_10)

	wait_until(1315, 0x77)
	speak(CHR_BOND, L_CAVE(57), 0x77db, CHANNEL_10, COLOR_09_BLUE) // "That they're probably innocent of any involvement ..."

	wait_until(1411, 0x8e)
	play_sound(0x04af, CHANNEL_0)

	wait_until(1735, 0x85)
	mute_channel(CHANNEL_0)
	play_sound(0x04ea, CHANNEL_10)

	wait_until(1800, 0x86)
	play_sound(0x04eb, CHANNEL_10)

	wait_until(1890, 0x87)
	play_sound(0x04ec, CHANNEL_10)

	wait_until(1900, 0x78)
	speak(CHR_BOND, L_CAVE(58), 0x7449, CHANNEL_5, COLOR_06_WHITE) // "I don't know how far the conspiracy has spread thr..."

	wait_until(1970, 0x8c)
	play_sound(0x0171, CHANNEL_10)

	wait_until(1980, 0x88)

	wait_until(2013, 0x8d)
	play_sound(0x0172, CHANNEL_10)

	wait_until(2048, 0x8f)
	play_sound(0x0596, CHANNEL_10)

	wait_until(2076, 0x92)
	play_sound(0x0161, CHANNEL_10)

	wait_until(2088, 0x93)
	play_sound(0x0162, CHANNEL_10)

	wait_until(2116, 0x94)
	play_sound(0x0163, CHANNEL_10)

	wait_until(2140, 0x95)
	play_sound(0x0164, CHANNEL_10)

	wait_until(2154, 0x96)
	play_sound(0x0165, CHANNEL_10)

	wait_until(2184, 0x97)
	play_sound(0x0166, CHANNEL_10)

	wait_until(2202, 0x98)
	play_sound(0x0167, CHANNEL_10)

	wait_until(2246, 0x99)
	play_sound(0x0168, CHANNEL_10)

	wait_until(2296, 0x9a)
	play_sound(0x0161, CHANNEL_10)

	wait_until(2332, 0x9b)
	play_sound(0x0162, CHANNEL_10)

	wait_until(2376, 0x9c)
	play_sound(0x0165, CHANNEL_10)

	wait_until(2418, 0x9d)
	play_sound(0x0163, CHANNEL_10)

	wait_until(2446, 0x9e)
	play_sound(0x0164, CHANNEL_10)

	wait_until(2486, 0x9f)
	play_sound(0x0168, CHANNEL_10)

	wait_until(2526, 0xa0)
	play_sound(0x0166, CHANNEL_10)

	wait_until(2558, 0xa1)
	play_sound(0x0167, CHANNEL_10)

	wait_until(2674, 0xa2)
	play_sound(0x0168, CHANNEL_10)

	wait_until(2700, 0x79)
	speak(CHR_BOND, L_CAVE(59), 0x744a, CHANNEL_7, COLOR_09_BLUE) // "Yes, and protect him from his abductors. Do you ha..."

	wait_until(2704, 0xa3)
	play_sound(0x0161, CHANNEL_10)

	wait_until(2720, 0xa4)
	play_sound(0x0163, CHANNEL_10)

	wait_until(2770, 0xa5)
	play_sound(0x0164, CHANNEL_10)

	wait_until(2796, 0xa6)
	play_sound(0x0167, CHANNEL_10)

	wait_until(2812, 0xa7)
	play_sound(0x0168, CHANNEL_10)

	wait_until(2830, 0xa8)
	play_sound(0x0162, CHANNEL_10)

	wait_until(2846, 0xa9)
	play_sound(0x0164, CHANNEL_10)

	wait_until(2856, 0xaa)
	play_sound(0x0165, CHANNEL_10)

	wait_until(2890, 0xab)
	play_sound(0x0166, CHANNEL_10)

	wait_until(2946, 0xac)
	play_sound(0x0163, CHANNEL_10)

	wait_until(2976, 0xad)
	play_sound(0x0164, CHANNEL_10)

	wait_until(3008, 0xae)
	play_sound(0x0167, CHANNEL_10)

	wait_until(3116, 0xaf)
	play_sound(0x0164, CHANNEL_10)

	wait_until(3154, 0xb0)
	play_sound(0x0165, CHANNEL_10)

	wait_until(3188, 0xb1)
	play_sound(0x0163, CHANNEL_10)

	wait_until(3230, 0xb2)
	play_sound(0x0164, CHANNEL_10)

	wait_until(3250, 0x7a)
	speak(CHR_BOND, L_CAVE(60), 0x744b, CHANNEL_5, COLOR_06_WHITE) // "Only vague suspicions, and I won't distract you wi..."

	wait_until(3387, 0xb3)
	play_sound(0x0166, CHANNEL_10)

	wait_until(3427, 0xb4)
	play_sound(0x0167, CHANNEL_10)

	wait_until(3448, 0xb5)
	play_sound(0x0168, CHANNEL_10)

	wait_until(3656, 0xb6)
	play_sound(0x0163, CHANNEL_10)

	wait_until(3723, 0x90)

	wait_until(3796, 0x91)
	play_sound(0x04fc, CHANNEL_10)

	beginloop(0x04)
		if_camera_animating(/*goto*/ 0x31)
		goto_next(0x48)

		label(0x31)
		if_controller_button_pressed(/*goto*/ 0x48)
		label(0x31)
	endloop(0x04)

	label(0x48)
	mute_channel(CHANNEL_7)
	mute_channel(CHANNEL_6)
	mute_channel(CHANNEL_5)
	mute_channel(CHANNEL_4)
	mute_channel(CHANNEL_0)
	mute_channel(CHANNEL_10)
	hide_object(0x22)
	hide_object(0x2f)
	label(0x02)
	unset_chr_chrflag(CHR_COOP, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_ANTI, CHRCFLAG_HIDDEN)
	unset_chr_chrflag(CHR_TRENT, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x48, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x49, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x4a, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x4b, CHRCFLAG_UNPLAYABLE)
	unset_chr_chrflag(0x4c, CHRCFLAG_UNPLAYABLE)
	remove_chr(CHR_TRENT)
	remove_chr(0x48)
	remove_chr(0x4a)
	remove_chr(0x4b)
	remove_chr(0x4c)
	set_chr_chrflag(0x49, CHRCFLAG_INVINCIBLE_TO_GUNFIRE)
	set_chr_chrflag(0x49, CHRCFLAG_HIDDEN)
	set_chr_hiddenflag(0x49, CHRHFLAG_00020000)
	chr_do_animation(0x01e9, -2, -1, 0x06, 0x00, 0x49, 2)
	unset_chr_chrflag(CHR_BOND, CHRCFLAG_UNPLAYABLE)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_00020000)
	chr_do_animation(0x01e6, -2, -1, 0x06, 0x00, CHR_BOND, 2)
	set_chr_hudpiece_visible(CHR_BOND, FALSE)
	unset_object_flag2(0x22, OBJFLAG2_04000000)
	set_object_flag3(0x22, OBJFLAG3_00000010)
	object_do_animation(0x01ed, 0x22, 0x01, 0xfffe)
	set_ailist(0x00, 0x0405)
	set_ailist(0x01, 0x0405)
	set_ailist(CHR_STEWARDESS, AILIST_STEWARDESS)
	restart_default_music
	reset_ambience
	enter_firstperson
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101c_msg_nowsyourchance[] = {
	beginloop(0x00)
		if_stage_flag_eq(STAGEFLAG_TRIGGER_MSG_NOWSYOURCHANCE, TRUE, /*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	speak(CHR_BOND, L_CAVE(50), 0x8182, CHANNEL_6, COLOR_09_BLUE) // "Now's your chance! Grab the stewardess's bag and g..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101d_msg_usethatcase[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x09)

	restart_timer

	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_has_object(CHR_P1P2, OBJ_BRIEFCASE1, /*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	restart_timer

	beginloop(0x04)
		if_timer_gt(600, /*goto*/ 0x31)
		reloop(0x04)

		label(0x31)
		if_sound_finished(CHANNEL_4, /*goto*/ 0x31)
	endloop(0x04)

	label(0x31)
	speak(CHR_P1P2, L_CAVE(51), 0x8183, CHANNEL_4, COLOR_09_BLUE) // "Use that case to conceal your equipment."

	label(0x09)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101e_msg_casewillgetstopped[] = {
	beginloop(0x00)
		if_objective_complete(1, /*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	restart_timer

	beginloop(0x04)
		if_timer_gt(120, /*goto*/ 0x31)
	endloop(0x04)

	label(0x31)
	speak(CHR_BOND, L_CAVE(52), 0x8184, CHANNEL_6, COLOR_09_BLUE) // "The case will get stopped unless you do something."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func101f_msg_smallerthanithought[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0025, /*goto*/ 0x31)
		if_chr_in_room(CHR_P1P2, 0x00, 0x001c, /*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	speak(CHR_P1P2, L_CAVE(53), 0x73c7, CHANNEL_6, COLOR_09_BLUE) // "So that's Air Force One? ... Huh, smaller than I t..."
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1022_check_office1_dead[] = {
	beginloop(0x00)
		if_chr_dying(CHR_OFFICE1, /*goto*/ 0x31)
		if_chr_death_animation_finished(CHR_OFFICE1, /*goto*/ 0x31)
		if_chr_unloaded(CHR_OFFICE1, /*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	set_stage_flag(STAGEFLAG_OFFICE1_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1023_check_office2_dead[] = {
	beginloop(0x00)
		if_chr_dying(CHR_OFFICE2, /*goto*/ 0x31)
		if_chr_death_animation_finished(CHR_OFFICE2, /*goto*/ 0x31)
		if_chr_unloaded(CHR_OFFICE2, /*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	set_stage_flag(STAGEFLAG_OFFICE2_DEAD)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1024_double_dy357[] = {
	set_object_flag(0x30, OBJFLAG_UNCOLLECTABLE)
	set_object_flag2(0x30, OBJFLAG2_INVISIBLE)
	set_object_flag(0x31, OBJFLAG_UNCOLLECTABLE)
	set_object_flag2(0x31, OBJFLAG2_INVISIBLE)

	beginloop(0x00)
		if_chr_unloaded(0x10, /*goto*/ 0x31)
		reloop(0x00)

		label(0x31)
		if_chr_unloaded(0x11, /*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	unset_object_flag(0x30, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(0x30, OBJFLAG2_INVISIBLE)
	unset_object_flag(0x31, OBJFLAG_UNCOLLECTABLE)
	unset_object_flag2(0x31, OBJFLAG2_INVISIBLE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

/**
 * @unused
 */
u8 func0416_watch_flag[] = {
	beginloop(0x00)
		if_chr_has_hiddenflag(CHR_SELF, CHRHFLAG_40000000, /*goto*/ 0x31)
		dprint 'F','L','A','G',' ','N','O','T',' ','S','E','T','\n',0,
		reloop(0x00)

		label(0x31)
		dprint 'F','L','A','G',' ','S','E','T','\n',0,
	endloop(0x00)

	endlist
};

u8 func101a_check_disguise_used2[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_has_object(CHR_P1P2, OBJ_UNIFORM, /*goto*/ 0x02)
	endloop(0x00)

	label(0x02)
	dprint 'D','I','S','G','U','I','S','E','D',' ','U','P','\n',0,

	beginloop(0x04)
		if_chr_has_hiddenflag(CHR_P1P2, CHRHFLAG_DISGUISED, /*goto*/ 0x31)
	endloop(0x04)

	label(0x31)
	if_stage_flag_eq(STAGEFLAG_DISGUISE_UNCOVERED, TRUE, /*goto*/ 0x02)
	if_stage_flag_eq(STAGEFLAG_RECEPTIONIST_CALLED_SECURITY, TRUE, /*goto*/ 0x02)
	set_stage_flag(STAGEFLAG_DISGUISED)
	set_stage_flag(STAGEFLAG_DISGUISED2)
	label(0x02)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x00)
	endlist
};

u8 func1026_check_alarm_destroyed[] = {
	beginloop(0x00)
		if_object_in_good_condition(OBJ_ALARM, /*goto*/ 0x31)
		activate_alarm
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x31)
	endloop(0x00)

	endlist
};

u8 func0417_remove_or_unalert[] = {
	set_self_chrflag(CHRCFLAG_00040000)

	label(0x00)
	yield
	set_target_chr(CHR_BOND)
	if_within_units_of_sight(30, /*goto*/ 0x02)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x31)
	set_target_chr(CHR_COOP)
	if_within_units_of_sight(30, /*goto*/ 0x02)
	label(0x31)
	if_chr_death_animation_finished(CHR_ANTI, /*goto*/ 0x04)
	set_target_chr(CHR_ANTI)
	if_within_units_of_sight(30, /*goto*/ 0x02)
	label(0x04)
	yield
	chr_drop_weapon(CHR_SELF)
	remove_chr(CHR_SELF)
	label(0x31)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x02)
	set_ailist(CHR_SELF, GAILIST_UNALERTED)
	endlist
};

u8 func0418_remove_or_cower[] = {
	set_self_chrflag(CHRCFLAG_00040000)
	label(0x00)
	yield
	set_target_chr(CHR_BOND)
	if_within_units_of_sight(30, /*goto*/ 0x02)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x31)
	set_target_chr(CHR_COOP)
	if_within_units_of_sight(30, /*goto*/ 0x02)
	label(0x31)
	if_chr_death_animation_finished(CHR_ANTI, /*goto*/ 0x04)
	set_target_chr(CHR_ANTI)
	if_within_units_of_sight(30, /*goto*/ 0x02)
	label(0x04)
	yield
	remove_chr(CHR_SELF)
	label(0x31)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	label(0x02)
	label(0x62)
	chr_do_animation(ANIM_COWER_0229, -1, -1, 0x14, 0x0a, CHR_SELF, 2)

	beginloop(0x63)
		if_chr_stopped(/*goto*/ 0x31)
	endloop(0x63)

	label(0x31)
	goto_first(0x62)

	endlist
};

u8 func102a_setup_snow[] = {
	enable_snow(TRUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1027_remotemine[] = {
	beginloop(0x00)
		if_object_in_good_condition(OBJ_REMOTEMINE, /*goto*/ 0x31)
		goto_next(0x02)

		label(0x31)
		reloop(0x00)

		label(0x02)
		destroy_object(OBJ_REMOTEMINE)
		yield
		destroy_object(0x46)
		yield
		destroy_object(0x47)
		set_ailist(CHR_SELF, GAILIST_IDLE)
		label(0x31)
	endloop(0x00)

	endlist
};

u8 func141b_setup_lifts_and_doors[] = {
	if_difficulty_lt(DIFF_SA, /*goto*/ 0x31)

	// SA and PA
	unlock_door(0x35, 0x80)
	goto_next(0x02)

	// Agent
	label(0x31)
	hide_object(0x09)
	label(0x02)
	set_object_flag(OBJ_DIAGONAL_LIFT, OBJFLAG_DEACTIVATED)
	set_object_flag(OBJ_VERTICAL_LIFT, OBJFLAG_DEACTIVATED)

	beginloop(0x04)
		if_stage_flag_eq(STAGEFLAG_SECURITY_SHUT_DOWN, TRUE, /*goto*/ 0x02)
	endloop(0x04)

	label(0x02)
	unset_object_flag(OBJ_DIAGONAL_LIFT, OBJFLAG_DEACTIVATED)
	unset_object_flag(OBJ_VERTICAL_LIFT, OBJFLAG_DEACTIVATED)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1029_lift_doors[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_activated_object(CHR_P1P2, 0x37, /*goto*/ 0x31)
		if_chr_activated_object(CHR_P1P2, 0x38, /*goto*/ 0x31)
		if_chr_activated_object(CHR_P1P2, 0x39, /*goto*/ 0x31)
		if_chr_activated_object(CHR_P1P2, 0x42, /*goto*/ 0x05)
		if_chr_activated_object(CHR_P1P2, 0x43, /*goto*/ 0x05)
		if_chr_activated_object(CHR_P1P2, 0x48, /*goto*/ 0x05)
		if_chr_activated_object(CHR_P1P2, 0x49, /*goto*/ 0x05)
		if_chr_activated_object(CHR_P1P2, 0x3b, /*goto*/ 0x05)
		if_chr_activated_object(CHR_P1P2, 0x3c, /*goto*/ 0x05)
		if_chr_activated_object(CHR_P1P2, 0x3d, /*goto*/ 0x05)
		if_chr_activated_object(CHR_P1P2, 0x3e, /*goto*/ 0x05)
		if_chr_activated_object(CHR_P1P2, 0x3f, /*goto*/ 0x05)
		if_chr_activated_object(CHR_P1P2, 0x40, /*goto*/ 0x05)
		if_chr_activated_object(CHR_P1P2, 0x41, /*goto*/ 0x05)
		reloop(0x00)

		label(0x31)
		if_stage_flag_eq(STAGEFLAG_SECURITY_SHUT_DOWN, TRUE, /*goto*/ 0x05)
		show_hudmsg(CHR_P1P2, L_CAVE(61)) // "Lift inoperative - security system is active."
		restart_timer

		beginloop(0x04)
			if_stage_flag_eq(STAGEFLAG_SECURITY_SHUT_DOWN, TRUE, /*goto*/ 0x05)
			if_timer_gt(120, /*goto*/ 0x31)
		endloop(0x04)

		label(0x31)
		reloop(0x00)

		label(0x05)
		play_sound(0x81b0, -1)
		restart_timer

		beginloop(0x06)
			if_timer_gt(120, /*goto*/ 0x02)
		endloop(0x06)

		label(0x02)
	endloop(0x00)

	endlist
};

u8 func102b_check_secretary_dead[] = {
	beginloop(0x00)
		if_stage_flag_eq(STAGEFLAG_SECURITY_SHUT_DOWN, TRUE, /*goto*/ 0x09)
		if_chr_death_animation_finished(CHR_SECRETARY, /*goto*/ 0x31)
		if_chr_dying(CHR_SECRETARY, /*goto*/ 0x31)
		if_chr_unloaded(CHR_SECRETARY, /*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	if_door_locked(0x18, 0x02, /*goto*/ 0x31)
	set_ailist(CHR_SELF, GAILIST_IDLE)

	label(0x31)
	show_hudmsg(CHR_BOND, L_CAVE(62)) // "Critical mission personnel disabled."
	set_stage_flag(STAGEFLAG_SECRETARY_DEAD)
	label(0x09)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102c_lock_door_on_alarm[] = {
	beginloop(0x00)
		if_alarm_active(/*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	lock_door(0x18, 0x04)
	close_door(0x18)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102d_check_console_destroyed[] = {
	beginloop(0x00)
		if_object_in_good_condition(OBJ_CONSOLE, /*goto*/ 0x31)
		goto_next(0x02)

		label(0x31)
	endloop(0x00)

	label(0x02)
	mute_channel(CHANNEL_1)
	if_stage_flag_eq(STAGEFLAG_SECURITY_SHUT_DOWN, TRUE, /*goto*/ 0x31)
	set_stage_flag(STAGEFLAG_CONSOLE_DESTROYED)
	show_hudmsg(CHR_BOND, L_CAVE(63)) // "Critical mission object destroyed."
	label(0x31)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102e_check_base_entered[] = {
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x002e, /*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	show_hudmsg(CHR_BOND, L_CAVE(64)) // "Entrance to base secured."
	set_stage_flag(STAGEFLAG_ENTERED_BASE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func102f_undisguise_on_alarm[] = {
	beginloop(0x00)
		if_alarm_active(/*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	set_chr_hiddenflag(CHR_BOND, CHRHFLAG_DISGUISE_UNCOVERED)
	if_chr_death_animation_finished(CHR_COOP, /*goto*/ 0x31)
	set_chr_hiddenflag(CHR_COOP, CHRHFLAG_DISGUISE_UNCOVERED)
	label(0x31)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1030_setup_rtracker[] = {
	yield
	set_object_flag3(0x30, OBJFLAG3_RTRACKED_BLUE)
	set_object_flag3(0x31, OBJFLAG3_RTRACKED_BLUE)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1031_setup_lighting[] = {
	yield
	misc_command(0x0000, 0x00, 0x00)
	misc_command(0x0000, 0x01, 0x00)
	misc_command(0x0000, 0x02, 0x00)
	misc_command(0x0000, 0x03, 0x00)
	misc_command(0x0000, 0x04, 0x00)
	misc_command(0x007b, 0x05, 0x01)
	misc_command(0x007b, 0x06, 0x01)
	misc_command(0x007c, 0x05, 0x01)
	misc_command(0x007c, 0x06, 0x01)
	misc_command(0x007d, 0x05, 0x01)
	misc_command(0x007d, 0x06, 0x01)
	misc_command(0x007f, 0x05, 0x01)
	misc_command(0x007f, 0x06, 0x01)
	misc_command(0x0080, 0x06, 0x01)
	misc_command(0x0081, 0x05, 0x01)
	misc_command(0x0081, 0x06, 0x01)
	misc_command(0x0082, 0x05, 0x01)
	misc_command(0x0082, 0x06, 0x01)
	misc_command(0x0083, 0x05, 0x01)
	misc_command(0x0083, 0x06, 0x01)
	misc_command(0x0084, 0x06, 0x01)
	misc_command(0x0085, 0x06, 0x01)
	misc_command(0x0086, 0x05, 0x01)
	misc_command(0x0086, 0x06, 0x01)
	misc_command(0x0087, 0x05, 0x01)
	misc_command(0x0087, 0x06, 0x01)
	misc_command(0x0088, 0x05, 0x01)
	misc_command(0x0088, 0x06, 0x01)
	misc_command(0x0089, 0x05, 0x01)
	misc_command(0x008f, 0x05, 0x01)
	misc_command(0x0090, 0x06, 0x01)
	misc_command(0x0091, 0x06, 0x01)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1032_unhide_guards_near_plane[] = {
	// Wait until player is in a room near the plane. If you ride the vertical
	// elevator all the way to the bottom, then come out and turn left, you'll
	// walk through these rooms before reaching the stairs.
	beginloop(0x00)
		chr_toggle_p1p2(CHR_SELF)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0016, /*goto*/ 0x31)
		if_chr_in_room(CHR_P1P2, 0x00, 0x0017, /*goto*/ 0x31)
	endloop(0x00)

	label(0x31)
	show_chr(0x1b)
	set_ailist(0x1b, 0x0422)
	unset_chr_hiddenflag(0x1b, CHRHFLAG_40000000)
	unset_chr_chrflag(0x1b, CHRCFLAG_HIDDEN)
	yield
	show_chr(0x19)
	set_ailist(0x19, AILIST_INIT_POSTTAKEOVER_GUARD)
	unset_chr_hiddenflag(0x19, CHRHFLAG_40000000)
	unset_chr_chrflag(0x19, CHRCFLAG_HIDDEN)
	yield
	show_chr(0x1d)
	set_ailist(0x1d, AILIST_INIT_POSTTAKEOVER_GUARD)
	unset_chr_hiddenflag(0x1d, CHRHFLAG_40000000)
	unset_chr_chrflag(0x1d, CHRCFLAG_HIDDEN)
	yield
	show_chr(0x1e)
	set_ailist(0x1e, AILIST_INIT_POSTTAKEOVER_GUARD)
	unset_chr_hiddenflag(0x1e, CHRHFLAG_40000000)
	unset_chr_chrflag(0x1e, CHRCFLAG_HIDDEN)
	yield
	show_chr(0x20)
	set_ailist(0x20, AILIST_INIT_POSTTAKEOVER_GUARD)
	unset_chr_hiddenflag(0x20, CHRHFLAG_40000000)
	unset_chr_chrflag(0x20, CHRCFLAG_HIDDEN)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

u8 func1420_setup_portals[] = {
	yield
	configure_room_portals(0x0080)
	set_ailist(CHR_SELF, GAILIST_IDLE)
	endlist
};

struct ailist ailists[] = {
	{ func1000_rebuild_groups,             0x1000 },
	{ func1401_setup_counterop,            0x1401 },
	{ func1002_objectives_failed_msg,      0x1002 },
	{ func1003_intro,                      0x1003 },
	{ func1004_guard_activation,           0x1004 },
	{ func1005_check_civilians_killed,     0x1005 },
	{ func1007_console_activation,         0x1007 },
	{ func1009_carousel_activation,        0x1009 },
	{ func100b_suitcase_scanning,          0x100b },
	{ func100c_check_end_level,            0x100c },
	{ func100d_laser_panel,                0x100d },
	{ func100e_check_alaskans_killed,      0x100e },
	{ func1010_setup_baggage_carrier,      0x1010 },
	{ func1011_lasers1,                    0x1011 },
	{ func1012_lasers2,                    0x1012 },
	{ func1013_lasers3,                    0x1013 },
	{ func1014_lasers4,                    0x1014 },
	{ func1015_unhide_laser_guards,        0x1015 },
	{ func1016_console_noises,             0x1016 },
	{ func1017_laser5,                     0x1017 },
	{ func1018_safe_switch,                0x1018 },
	{ func1018_safe_switch_cover,          0x1019 },
	{ func101a_check_disguise_used,        0x101a },
	{ func141b_setup_lifts,                0x141b },
	{ func101c_msg_nowsyourchance,         0x101c },
	{ func101d_msg_usethatcase,            0x101d },
	{ func101e_msg_casewillgetstopped,     0x101e },
	{ func101f_msg_smallerthanithought,    0x101f },
	{ func1020_weapon_scanning_bond,       0x1020 },
	{ func1021_weapon_scanning_coop,       0x1021 },
	{ func1022_check_office1_dead,         0x1022 },
	{ func1023_check_office2_dead,         0x1023 },
	{ func1024_double_dy357,               0x1024 },
	{ func101a_check_disguise_used2,       0x1025 },
	{ func1026_check_alarm_destroyed,      0x1026 },
	{ func1027_remotemine,                 0x1027 },
	{ func141b_setup_lifts_and_doors,      0x1028 },
	{ func1029_lift_doors,                 0x1029 },
	{ func102a_setup_snow,                 0x102a },
	{ func102b_check_secretary_dead,       0x102b },
	{ func102c_lock_door_on_alarm,         0x102c },
	{ func102d_check_console_destroyed,    0x102d },
	{ func102e_check_base_entered,         0x102e },
	{ func102f_undisguise_on_alarm,        0x102f },
	{ func1030_setup_rtracker,             0x1030 },
	{ func1031_setup_lighting,             0x1031 },
	{ func1032_unhide_guards_near_plane,   0x1032 },
	{ func1420_setup_portals,              0x1420 },
	{ func0404_laser_guard,                0x0404 },
	{ func0403_unused,                     0x0403 },
	{ func0402_init_stripes,               0x0402 },
	{ func0401_unused_cutscene,            0x0401 },
	{ func0405_start_path15,               0x0405 },
	{ func0406_become_unalerted,           0x0406 },
	{ func041b_start_path06,               0x041b },
	{ func041c_start_path07,               0x041c },
	{ func041d_start_path08,               0x041d },
	{ func041e_start_path09,               0x041e },
	{ func041f_start_path10,               0x041f },
	{ func0420_start_path11,               0x0420 },
	{ func0421_start_path12,               0x0421 },
	{ func0422_start_path13,               0x0422 },
	{ func0423_start_path14,               0x0423 },
	{ func0424_start_path15_unused,        0x0424 },
	{ func0407_stewardess,                 0x0407 },
	{ func0408_secretary,                  0x0408 },
	{ func0409_office1,                    0x0409 },
	{ func040a_office2,                    0x040a },
	{ func040b_unused,                     0x040b },
	{ func040c_init_secretary,             0x040c },
	{ func040d_init_office1,               0x040d },
	{ func040e_init_office2,               0x040e },
	{ func040f_nsa,                        0x040f },
	{ func0410_unused,                     0x0410 },
	{ func0411_takeover_lackey,            0x0411 },
	{ func0412_init_takeover_lackey,       0x0412 },
	{ func0413_alaskan_console_guard,      0x0413 },
	{ func0414_officeworker,               0x0414 },
	{ func0415_alaskan_mountainlift_guard, 0x0415 },
	{ func0416_watch_flag,                 0x0416 },
	{ func0417_remove_or_unalert,          0x0417 },
	{ func0418_remove_or_cower,            0x0418 },
	{ func0419_ba8c,                       0x0419 },
	{ func041a_draw_magnum,                0x041a },
	{ func0425_outro,                      0x0425 },
	{ func0426_init_alaskan_guard,         0x0426 },
	{ func0427_init_posttakeover_guard,    0x0427 },
	{ func0428_posttakeover_guard,         0x0428 },
	{ func0429_unused,                     0x0429 },
	{ func042a_foyer_spawner,              0x042a },
	{ func042b_init_foyer_clone,           0x042b },
	{ func042c_foyer_clone,                0x042c },
	{ func042d_hoverbot1,                  0x042d },
	{ func042e_hoverbot2,                  0x042e },
	{ func042f_hoverbot3,                  0x042f },
	{ func0430_hoverbot4,                  0x0430 },
	{ func0431_hoverbot5,                  0x0431 },
	{ func0432_hoverbot6,                  0x0432 },
	{ func1003_intro,                      0x0c00 },
	{ func0425_outro,                      0x0c01 },
	{ NULL, 0 },
};

