#!/usr/bin/ruby -w

require "yaml"

def yaml2code(fout, data, ev_type)
  fout.puts "// Do not edit by hand, this file was automatically generated by #{$0}\n\n"  
  fout.puts "#include \"symbols/environment.hpp\""
  fout.puts "#include \"symbols/namespace.hpp\""
  fout.puts "#include \"symbols/symbol.hpp\""
  fout.puts ""
  fout.puts "void init_environment_#{ev_type}(EnvironmentPtr env)"
  fout.puts "{"
  # pass1 
  data.each do |namespace|
    fout.puts "  {"
    fout.puts "    NamespacePtr ns = env->add_namespace(\"#{namespace['name']}\");"
    
    namespace['aliases'].each do |sym|
      fout.puts "    env->add_namespace_alias(\"#{sym}\", ns);"
    end if namespace.has_key?('aliases')
    
    namespace[ev_type].each do |sym|
      fout.puts "    {"
      fout.puts "      SymbolPtr sym = ns->add_symbol(\"#{sym['name']}\");"
      sym['aliases'].each do |al|
        fout.puts "      ns->add_alias(\"#{al}\", sym);";
      end if sym.has_key?('aliases')
      fout.puts "    }"
    end if namespace.has_key?(ev_type)
    fout.puts "  }"
  end

  # pass2
  data.each do |namespace|
    fout.puts "  {"
    fout.puts "    NamespacePtr ns = env->lookup_namespace(\"#{namespace['name']}\");"
    namespace[ev_type].each do |sym|
      if sym.has_key?('provides')
        fout.puts "    {"
        fout.puts "      SymbolPtr sym = ns->lookup(\"#{sym['name']}\");"
        fout.puts "      assert(sym);"       
        sym['provides'].each do |provides|
          ns, sym = provides.split(".")
          fout.puts "      sym->add_provides(env->lookup_symbol(\"#{ns}\", \"#{sym}\"));"
        end
        fout.puts "    }"
      end
    end if namespace.has_key?(ev_type)
    fout.puts "  }"
  end
  fout.puts "}"
  fout.puts "\n/* EOF */"
end

data = []
Dir.glob("*.yaml") do |filename|
  begin
    data.concat(YAML::load(File.new(filename)))
    # puts "#{filename}: ok"
  rescue ArgumentError => e
    $stderror.puts "#{filename}: error: #{e}"
  end
end

File.open("init_abs.cpp", "w") do |fout|
  yaml2code(fout, data, 'abs')
end

File.open("init_key.cpp", "w") do |fout|
  yaml2code(fout, data, 'key')
end

File.open("init_rel.cpp", "w") do |fout|
  yaml2code(fout, data, 'rel')
end

# EOF #
