#include "xenon_smc.h"
#include "xenon_gpio.h"
#include "xenos_init.h"

#include <vsprintf.h>
#include <time.h>
#include <string.h>
#define assert(x)

#define require(x, label) if (!(x)) { printf("%s:%d [%s]\n", __FILE__, __LINE__, #x); goto label; }

#define FB_BASE 0x1e000000 

static void xenos_write32(int reg, uint32_t val)
{
	*(volatile uint32_t*)(0x80000200ec800000 + reg) = val;
}

static uint32_t xenos_read32(int reg)
{
	return *(volatile uint32_t*)(0x80000200ec800000 + reg);
}

static void xenos_ana_write(int addr, uint32_t reg)
{
	xenos_write32(0x7950, addr);
	xenos_read32(0x7950);
	xenos_write32(0x7954, reg);
	while (xenos_read32(0x7950) == addr) printf(".");
}

uint32_t ana_640x480p [] = {
0x0000004f, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000,  // 00
0x00060001, 0x00000000, 0x00000000, 0xffffffff, 0xac0000d0, 0x00000009, 0x1c0ffc00, 0x00000000,  // 08
0x24900000, 0x00087400, 0xf8461778, 0x48280320, 0x002c1061, 0x4601120d, 0x00000000, 0x02064f2e,  // 10
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 18
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xc0000000, 0x00000000,  // 20
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 28
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x81612c88, 0x00000000, 0x10b3c8c3,  // 30
0x00000000, 0x00080c0b, 0x00000000, 0x07e7d5dc, 0x00000000, 0x07bfb3d4, 0x00000000, 0x0014180e,  // 38
0x00000000, 0x0000fe00, 0x0000fffd, 0xfd000000, 0x81612c88, 0x00000000, 0x10b3c8c3, 0x00000000,  // 40
0x00080c0b, 0x00000000, 0x07e7d5dc, 0x00000000, 0x07bfb3d4, 0x00000000, 0x0014180e, 0x00000000,  // 48
0x0000fe00, 0x0000fffd, 0xfd000000, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x40000000,  // 50
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 58
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 60
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xdeadbeef, 0x00000000, 0x00000000,  // 68
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0f897040, 0x00b85b53, 0xffffffff,  // 70
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 78
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 80
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 88
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 90
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 98
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b8
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c8
0x000562de, 0x001162de, 0x002cfe1f, 0x00205218, 0x00115a17, 0x00000060, 0x00000060, 0x00000000,  // d0
0x0000000f, 0x0001ee60, 0x00000002, 0x00000003, 0x000042aa, 0xffffffff, 0xffffffff, 0xffffffff,  // d8
0x000086d7, 0x00000000, 0x00000000, 0x8436f666, 0x0000001b, 0xffffffff, 0xffffffff, 0xffffffff,  // e0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // e8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // f0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000001, 0x00000000,  // f8
};

uint32_t ana_1024x768 [] = {
0x0000004f, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000,  // 00
0x00060001, 0x00000000, 0x00000000, 0xffffffff, 0x8c0000d0, 0x00000009, 0x1c0ffc00, 0x00000000,  // 08
0x24900000, 0x00087400, 0xf8c89778, 0x94400540, 0x004b9089, 0x46018326, 0x00000000, 0x020ffe5d,  // 10
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 18
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xc0000000, 0x00000000,  // 20
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 28
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xc9500000, 0x00000000, 0x1e300000,  // 30
0x00000000, 0x002c0000, 0x00000000, 0x07580000, 0x00000000, 0x06d00000, 0x00000000, 0x00580000,  // 38
0x00000000, 0x00000000, 0x0000fb00, 0x00000000, 0xc9500000, 0x00000000, 0x1e300000, 0x00000000,  // 40
0x002c0000, 0x00000000, 0x07580000, 0x00000000, 0x06d00000, 0x00000000, 0x00580000, 0x00000000,  // 48
0x00000000, 0x0000fb00, 0x00000000, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x40000000,  // 50
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 58
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 60
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xdeadbeef, 0x00000000, 0x00000000,  // 68
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1a9894ee, 0x001db0a9, 0xffffffff,  // 70
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 78
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 80
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 88
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 90
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 98
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b8
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c8
0x000551d4, 0x000551d4, 0x002cfe1f, 0x00205218, 0x00115a17, 0x00000060, 0x000000f0, 0x00000000,  // d0
0x00000007, 0x0001ee60, 0x00000002, 0x00000004, 0x000042aa, 0xffffffff, 0xffffffff, 0xffffffff,  // d8
0x00000000, 0x00000000, 0x00000000, 0x8436f666, 0x0000001b, 0xffffffff, 0xffffffff, 0xffffffff,  // e0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // e8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // f0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000001, 0x00000000,  // f8
};

uint32_t ana_640_480_composite[] = {
0x0000005f, 0x00000003, 0x00000000, 0x00000007, 0x00000000, 0xffffffff, 0xe880a916, 0x07001482,  // 00
0x00060001, 0x00000029, 0x00000000, 0xffffffff, 0xd8000002, 0x00000001, 0x1c0ffc40, 0x06cf00d8,  // 08
0x24900000, 0x1789e000, 0x90674700, 0x74a8030c, 0x00299039, 0x2651b20d, 0x88773443, 0x0300ebff,  // 10
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 18
0x02540f38, 0x0e600002, 0x02540409, 0x00000002, 0x02540000, 0x03310002, 0x83713c67, 0x081268b2,  // 20
0x106408f9, 0x0ed370c8, 0x00381c0e, 0x00341809, 0x0783b7d7, 0x0753a9d6, 0x00841dfd, 0x07bfc7db,  // 28
0x079fdbf4, 0x07e80005, 0xfdfdfdfe, 0xff010c0a, 0x09060402, 0x80c09c47, 0x069234b1, 0x13b4d123,  // 30
0x1103ccd3, 0x00040606, 0x0024180e, 0x07f3e9eb, 0x078bb3d2, 0x07d7c7d7, 0x073f9bce, 0x000c120d,  // 38
0x003c2010, 0x000000fe, 0xfefd00fe, 0xfdfcfcfd, 0x80c09c45, 0x067228ad, 0x1344b11d, 0x1083b4cf,  // 40
0x00040606, 0x0024180e, 0x07f3e9eb, 0x078bb5d3, 0x07d7c9d8, 0x07479dcf, 0x000c120d, 0x003c200f,  // 48
0x000000ff, 0xfefd00fe, 0xfdfcfcfd, 0x40001f18, 0x0e030d0c, 0x79566e05, 0x56793e3e, 0x4000056e,  // 50
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 58
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 60
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xdeadbeef, 0x00000000, 0x00000000,  // 68
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x78870305, 0x00314733, 0xffffffff,  // 70
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 78
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 80
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 88
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 90
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 98
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b8
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c8
0x00055a9d, 0x001f4a9f, 0x002cfe1f, 0x00205218, 0x00115a17, 0x00000000, 0x00000060, 0x00000000,  // d0
0x0000000f, 0x0001ee60, 0x00000002, 0x00000004, 0x000042aa, 0xffffffff, 0xffffffff, 0xffffffff,  // d8
0x00000000, 0x00000000, 0x00000000, 0x8436f666, 0x0000001b, 0xffffffff, 0xffffffff, 0xffffffff,  // e0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // e8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // f0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000001, 0x00000000,  // f8
};

uint32_t ana_yuv_480p[] = {
0x0000005f, 0x00000003, 0x00000000, 0x00000007, 0x00000000, 0xffffffff, 0xe880a916, 0x07001482,  // 00
0x00060001, 0x00000029, 0x00000000, 0xffffffff, 0xd8000002, 0x00000001, 0x1c0ffc40, 0x06cf00d8,  // 08
0x24900000, 0x1789e000, 0x90674700, 0x74a8030c, 0x00299039, 0x2651b20d, 0x88773443, 0x0300ebff,  // 10
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 18
0x02540f38, 0x0e600002, 0x02540409, 0x00000002, 0x02540000, 0x03310002, 0x83713c67, 0x081268b2,  // 20
0x106408f9, 0x0ed370c8, 0x00381c0e, 0x00341809, 0x0783b7d7, 0x0753a9d6, 0x00841dfd, 0x07bfc7db,  // 28
0x079fdbf4, 0x07e80005, 0xfdfdfdfe, 0xff010c0a, 0x09060402, 0x80c09c47, 0x069234b1, 0x13b4d123,  // 30
0x1103ccd3, 0x00040606, 0x0024180e, 0x07f3e9eb, 0x078bb3d2, 0x07d7c7d7, 0x073f9bce, 0x000c120d,  // 38
0x003c2010, 0x000000fe, 0xfefd00fe, 0xfdfcfcfd, 0x80c09c45, 0x067228ad, 0x1344b11d, 0x1083b4cf,  // 40
0x00040606, 0x0024180e, 0x07f3e9eb, 0x078bb5d3, 0x07d7c9d8, 0x07479dcf, 0x000c120d, 0x003c200f,  // 48
0x000000ff, 0xfefd00fe, 0xfdfcfcfd, 0x40001f18, 0x0e030d0c, 0x79566e05, 0x56793e3e, 0x4000056e,  // 50
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 58
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 60
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xdeadbeef, 0x00000000, 0x00000000,  // 68
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x78870305, 0x00314733, 0xffffffff,  // 70
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 78
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 80
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 88
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 90
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 98
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b8
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c8
0x00055a9d, 0x001f4a9f, 0x002cfe1f, 0x00205218, 0x00115a17, 0x00000060, 0x00000060, 0x00000000,  // d0
0x0000000f, 0x0001ee60, 0x00000002, 0x00000004, 0x000042aa, 0xffffffff, 0xffffffff, 0xffffffff,  // d8
0x00000000, 0x00000000, 0x00000000, 0x8436f666, 0x0000001b, 0xffffffff, 0xffffffff, 0xffffffff,  // e0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // e8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // f0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000001, 0x00000000,  // f8
};

uint32_t ana_pal[] = {
0x0000005f, 0x00000003, 0x00000000, 0x00000007, 0x00000000, 0xffffffff, 0x4bc44112, 0x08c001c6,  // 00
0x00000008, 0x00000029, 0x00000000, 0xffffffff, 0xd800002a, 0x00000001, 0x1c0ffc40, 0x06cf00d8,  // 08
0x24900000, 0x1539e000, 0x90574700, 0x7f280310, 0x0029e03a, 0x2c5d2271, 0x66573423, 0x050093d4,  // 10
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 18
0x02540f38, 0x0e600002, 0x02540409, 0x00000002, 0x02540000, 0x03310002, 0x8281085e, 0x07b264b5,  // 20
0x11a4550b, 0x0fb39cd0, 0x00301c10, 0x00442410, 0x07a3c1d9, 0x0753a1cf, 0x0047fbec, 0x0783add1,  // 28
0x07c3f1ff, 0x0014140e, 0xfcfcfbfb, 0xfbfc0906, 0x0401fffd, 0x80c09c47, 0x069234b1, 0x13b4d123,  // 30
0x1103ccd3, 0x00040606, 0x0024180e, 0x07f3e9eb, 0x078bb3d2, 0x07d7c7d7, 0x073f9bce, 0x000c120d,  // 38
0x003c2010, 0x000000fe, 0xfefd00fe, 0xfdfcfcfd, 0x80c09c45, 0x067228ad, 0x1344b11d, 0x1083b4cf,  // 40
0x00040606, 0x0024180e, 0x07f3e9eb, 0x078bb5d3, 0x07d7c9d8, 0x07479dcf, 0x000c120d, 0x003c200f,  // 48
0x000000ff, 0xfefd00fe, 0xfdfcfcfd, 0x40001f18, 0x0e030d0c, 0x79566e05, 0x56793e3e, 0x4000056e,  // 50
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 58
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 60
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xdeadbeef, 0x00000000, 0x00000000,  // 68
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x711bb61b, 0x00ecd9c7, 0xffffffff,  // 70
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 78
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 80
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 88
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 90
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 98
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b8
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c8
0x00056a14, 0x001a3154, 0x002cfe1f, 0x00205218, 0x00115a17, 0x00000060, 0x00000060, 0x00000000,  // d0
0x0000000f, 0x0001ee60, 0x00000002, 0x00000004, 0x000042aa, 0xffffffff, 0xffffffff, 0xffffffff,  // d8
0x946b0000, 0x00000000, 0x00000000, 0x8436f666, 0x0000001b, 0xffffffff, 0xffffffff, 0xffffffff,  // e0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // e8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // f0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000001, 0x00000000,  // f8
};

uint32_t ana_1280x768[] = {
0x0000004f, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000,  // 00
0x00180005, 0x00000000, 0x00000000, 0xffffffff, 0x8c0000d0, 0x00000009, 0x1c0ffc00, 0x00000000,  // 08
0x24900000, 0x00087400, 0xf8e81770, 0xa0500680, 0x00601081, 0x3601831e, 0x00000000, 0x020ffe5d,  // 10
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 18
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xc0000000, 0x00000000,  // 20
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 28
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xc9500000, 0x00000000, 0x1e300000,  // 30
0x00000000, 0x002c0000, 0x00000000, 0x07580000, 0x00000000, 0x06d00000, 0x00000000, 0x00580000,  // 38
0x00000000, 0x00000000, 0x0000fb00, 0x00000000, 0xc9500000, 0x00000000, 0x1e300000, 0x00000000,  // 40
0x002c0000, 0x00000000, 0x07580000, 0x00000000, 0x06d00000, 0x00000000, 0x00580000, 0x00000000,  // 48
0x00000000, 0x0000fb00, 0x00000000, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x40000000,  // 50
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 58
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 60
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xdeadbeef, 0x00000000, 0x00000000,  // 68
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5594e543, 0x00ddb0a9, 0xffffffff,  // 70
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 78
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 80
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 88
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 90
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 98
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b8
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c8
0x000582d8, 0x000582d8, 0x002cfe1f, 0x00205218, 0x00115a17, 0x00000060, 0x00000060, 0x00000000,  // d0
0x0000000f, 0x0001ee60, 0x00000002, 0x00000004, 0x000042aa, 0xffffffff, 0xffffffff, 0xffffffff,  // d8
0x00000000, 0x00000000, 0x00000000, 0x8436f666, 0x0000001b, 0xffffffff, 0xffffffff, 0xffffffff,  // e0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // e8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // f0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000001, 0x00000000,  // f8
};

uint32_t ana_1360x768[] = {
0x0000004f, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000,  // 00
0x00180005, 0x00000000, 0x00000000, 0xffffffff, 0x840000d0, 0x00000009, 0x1c0ffc00, 0x00000000,  // 08
0x00000000, 0x00087400, 0xf8c71750, 0xb8550700, 0x00691071, 0x3001831b, 0x00000000, 0x010fff26,  // 10
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 18
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xc0000000, 0x00000000,  // 20
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 28
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x90f00000, 0x00000000, 0x00000000,  // 30
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 38
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x90f00000, 0x00000000, 0x00000000, 0x00000000,  // 40
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 48
0x00000000, 0x00000000, 0x00000000, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x40000000,  // 50
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 58
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 60
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xdeadbeef, 0x00000000, 0x00000000,  // 68
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x519d02fb, 0x00885b53, 0xffffffff,  // 70
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 78
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 80
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 88
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 90
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 98
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b8
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c8
0x00095a9c, 0x00045a9c, 0x002cfe1f, 0x00205218, 0x00115a17, 0x00000060, 0x00000060, 0x00000000,  // d0
0x0000000f, 0x0001ee60, 0x00000002, 0x00000004, 0x000042aa, 0xffffffff, 0xffffffff, 0xffffffff,  // d8
0x00000000, 0x00000000, 0x00000000, 0x8436f666, 0x0000001b, 0xffffffff, 0xffffffff, 0xffffffff,  // e0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // e8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // f0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000001, 0x00000000,  // f8
};

uint32_t ana_1280x720[] = {
0x0000004f, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000,  // 00
0x00180005, 0x00000000, 0x00000000, 0xffffffff, 0x8e0000d0, 0x00000009, 0x1ffffc00, 0x066c0000,  // 08
0x24900000, 0x0009d800, 0xf8a29750, 0x82500672, 0x0064b029, 0x320282ee, 0x00000000, 0x020ffe5d,  // 10
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 18
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xc0000000, 0x00000000,  // 20
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 28
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x85700000, 0x00000000, 0x11a00000,  // 30
0x00000000, 0x00180000, 0x00000000, 0x079c0000, 0x00000000, 0x07500000, 0x00000000, 0x00340000,  // 38
0x00000000, 0x00000000, 0x0000fd00, 0x00000000, 0x85700000, 0x00000000, 0x11a00000, 0x00000000,  // 40
0x00180000, 0x00000000, 0x079c0000, 0x00000000, 0x07500000, 0x00000000, 0x00340000, 0x00000000,  // 48
0x00000000, 0x0000fd00, 0x00000000, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x40000000,  // 50
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 58
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 60
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xdeadbeef, 0x00000000, 0x00000000,  // 68
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6485e4e9, 0x00adb0a9, 0x00000001,  // 70
0x351f2e53, 0x4400f126, 0xdeadbeef, 0x00000000, 0x00000000, 0xffffffff, 0xffffffff, 0x4455002a,  // 78
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 80
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 88
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 90
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 98
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b8
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x020c804e, 0x08e84014, 0x00000014,  // c8
0x00069b18, 0x00069b18, 0x002cfe1f, 0x09832017, 0x0990e00e, 0x00000060, 0x00000060, 0x00000008,  // d0
0x00000007, 0x00000020, 0x00000002, 0x00000002, 0x000042aa, 0xffffffff, 0xffffffff, 0x00000001,  // d8
0x00000000, 0x00000000, 0x00000000, 0x8436f666, 0x0000001b, 0xffffffff, 0xffffffff, 0xffffffff,  // e0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // e8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // f0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x00000000, 0x00010001, 0x00000000,  // f8
};

uint32_t ana_1440x900[] = {
0x0000004f, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000,  // 00
0x00180005, 0x00000000, 0x00000000, 0xffffffff, 0x860000d0, 0x00000009, 0x1ffffc00, 0x066c0000,  // 08
0x00000000, 0x0009d800, 0xf8c99770, 0xc05a0770, 0x006d9099, 0x3e0183a6, 0x00000000, 0x010fff26,  // 10
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 18
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xc0000000, 0x00000000,  // 20
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 28
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x93c00000, 0x00000000, 0x00000000,  // 30
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 38
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x93c00000, 0x00000000, 0x00000000, 0x00000000,  // 40
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 48
0x00000000, 0x00000000, 0x00000000, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x40000000,  // 50
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 58
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 60
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xdeadbeef, 0x00000000, 0x00000000,  // 68
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x37b632da, 0x007305fe, 0x00000001,  // 70
0x351f2e53, 0x4400f126, 0xdeadbeef, 0x00000000, 0x00000000, 0xffffffff, 0xffffffff, 0xa44100cd,  // 78
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 80
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 88
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 90
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 98
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b8
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x020c804e, 0x08e84014, 0x00000014,  // c8
0x0005531b, 0x0002531b, 0x002cfe1f, 0x09832017, 0x0990e00e, 0x00000060, 0x00000060, 0x00000008,  // d0
0x00000007, 0x00000020, 0x00000002, 0x00000005, 0x000042aa, 0xffffffff, 0xffffffff, 0x00000001,  // d8
0x00000000, 0x0000a987, 0x00000000, 0x8436f666, 0x0000001b, 0xffffffff, 0xffffffff, 0xffffffff,  // e0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // e8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // f0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x00000000, 0x00010001, 0x00000000,  // f8
};

uint32_t ana_1280x1024[] = {
0x0000004f, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000,  // 00
0x00060001, 0x00000000, 0x00000000, 0xffffffff, 0x860000d0, 0x00000009, 0x1ffffc00, 0x066c0000,  // 08
0x00000000, 0x0009d800, 0xf8671750, 0xb4500698, 0x00629071, 0x5200842a, 0x00000000, 0x010fff26,  // 10
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 18
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xc0000000, 0x00000000,  // 20
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 28
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x93c00000, 0x00000000, 0x00000000,  // 30
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 38
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x93c00000, 0x00000000, 0x00000000, 0x00000000,  // 40
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 48
0x00000000, 0x00000000, 0x00000000, 0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x40000000,  // 50
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 58
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 60
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xdeadbeef, 0x00000000, 0x00000000,  // 68
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x38a911a2, 0x00f305fe, 0x00000001,  // 70
0x351f2e53, 0x4400f126, 0xdeadbeef, 0x00000000, 0x00000000, 0xffffffff, 0xffffffff, 0xf1d30073,  // 78
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 80
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 88
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 90
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 98
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b8
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x020c804e, 0x08e84014, 0x00000014,  // c8
0x00075a17, 0x00035a17, 0x002cfe1f, 0x09832017, 0x0990e00e, 0x00000060, 0x00000060, 0x00000008,  // d0
0x00000007, 0x00000020, 0x00000002, 0x00000002, 0x000042aa, 0xffffffff, 0xffffffff, 0x00000001,  // d8
0x00000000, 0x00000000, 0x00000000, 0x8436f666, 0x0000001b, 0xffffffff, 0xffffffff, 0xffffffff,  // e0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // e8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // f0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x00000000, 0x00010001, 0x00000000,  // f8
};

uint32_t ana_hdmi_720p[] = {
0x000000c1, 0x0000000b, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000000,  // 00
0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x860000d0, 0x00000009, 0x1ffffc00, 0x066c0000,  // 08
0x00000000, 0x00087400, 0xf8529700, 0x82500672, 0x0064b029, 0x320282ee, 0x00000000, 0x00000000,  // 10
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 18
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 20
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 28
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 30
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 38
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 40
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 48
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // 50
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 58
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 60
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xdeadbeef, 0x00000000, 0x00000000,  // 68
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00001001, 0x00011a78, 0x00000001,  // 70
0x351f2e53, 0x4400f126, 0xdeadbeef, 0x00000000, 0x00000000, 0xffffffff, 0xffffffff, 0x906600de,  // 78
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 80
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 88
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 90
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // 98
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // a8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // b8
0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // c0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x020c804e, 0x08e84014, 0x00000014,  // c8
0x000d9b18, 0x00069b18, 0x002cfe1f, 0x09832017, 0x0990e00e, 0x00000000, 0x00000000, 0x0000000f,  // d0
0x0000000f, 0x00000020, 0x00000002, 0x00000005, 0x000042aa, 0xffffffff, 0xffffffff, 0x00000000,  // d8
0x00000000, 0x00000000, 0x00000000, 0x8436f666, 0x0000001b, 0xffffffff, 0xffffffff, 0xffffffff,  // e0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // e8
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,  // f0
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x00000000, 0x00010001, 0x00000000,  // f8
};

struct mode_s
{
	uint32_t *ana;
	int total_width, total_height, hsync_offset, real_active_width, active_height, vsync_offset, is_progressive, width, height, composite_sync, rgb, hdmi;
} xenos_modes[] = {
	{
		.ana = ana_640x480p,
		.total_width = 800,
		.total_height = 525,
		.hsync_offset = 0x56,
		.real_active_width = 640,
		.active_height = 480,
		.vsync_offset = 0x23,
		.is_progressive = 1,
		.width = 640,
		.height = 480,
		.rgb = 1,
	}, 
	{
		.ana = ana_1024x768,
		.total_width = 1344,
		.hsync_offset = 235,
		.real_active_width = 1024,
		.total_height = 806,
		.vsync_offset = 35,
		.active_height = 768,
		.width = 1024,
		.height = 768,
		.is_progressive = 1,
		.rgb = 1,
	},
	{
		.ana = ana_640_480_composite,
		.total_width = 780,
		.hsync_offset = 80,
		.real_active_width = 640,
		.total_height = 525,
		.vsync_offset = 38,
		.active_height = 480/2,
		.is_progressive = 0,
		.width = 640,
		.height = 480/2,
		.composite_sync = 1,
	},
	{
		.ana = ana_yuv_480p,
		.total_width = 780,
		.hsync_offset = 82,
		.real_active_width = 640,
		.total_height = 525,
		.vsync_offset = 38,
		.active_height = 480,
		.width = 640,
		.height = 480,
		.is_progressive = 1,
		.composite_sync = 1,
	},
	{
		.ana = ana_pal,
		.total_width = 784,
		.hsync_offset = 91,
		.real_active_width = 640,
		.total_height = 625,
		.vsync_offset = 44,
		.active_height = 576/2,
		.is_progressive = 0,
		.width = 640,
		.height = 576/2,
		.is_progressive = 0,
		.composite_sync = 1,
	},
	{	
        .ana = ana_1280x768,
		.total_width = 1664,
		.hsync_offset = 259,
		.real_active_width = 1280,
		.total_height = 798,
		.vsync_offset = 27,
		.active_height = 768,
		.width = 1280,
		.height = 768,
		.is_progressive = 1,
		.rgb = 1,
	}, 
	{
		.ana = ana_1360x768,
		.total_width = 1792,
		.hsync_offset = 301,
		.real_active_width = 1360,
		.total_height = 795,
		.vsync_offset = 24,
		.active_height = 768,
		.width = 1376,
		.height = 768,
		.is_progressive = 1,
		.rgb = 1,
	},
	{	
        .ana = ana_1280x720,
		.total_width = 1650,
		.hsync_offset = 199,
		.real_active_width = 1280,
		.total_height = 750,
		.vsync_offset = 25,
		.active_height = 720,
		.width = 1280,
		.height = 720,
		.is_progressive = 1,
		.rgb = 1,
	}, 
	{	
        .ana = ana_1440x900,
		.total_width = 1904,
		.hsync_offset = 317,
		.real_active_width = 1440,
		.total_height = 934,
		.vsync_offset = 31,
		.active_height = 900,
		.width = 1440,
		.height = 896, //FIXME: EDRAM isn't big enough to render 1440*900
		.is_progressive = 1,
		.rgb = 1,
	}, 
	{	
        .ana = ana_1280x1024,
		.total_width = 1688,
		.hsync_offset = 293,
		.real_active_width = 1280,
		.total_height = 1066,
		.vsync_offset = 41,
		.active_height = 1024,
		.width = 1280,
		.height = 1024,
		.is_progressive = 1,
		.rgb = 1,
	}, 
	{	
        .ana = ana_hdmi_720p,
		.total_width = 1650,
		.hsync_offset = 259,
		.real_active_width = 1280,
		.total_height = 750,
		.vsync_offset = 25,
		.active_height = 720,
		.width = 1280,
		.height = 720,
		.is_progressive = 1,
		.rgb = 1,
        .hdmi = 1,
	}
	};

void xenos_init_ana_new(uint32_t *mode_ana, int hdmi)
{
	uint32_t tmp;
	int i;
	
	require(!xenon_smc_ana_read(0xfe, &tmp), ana_error);
	
	require(!xenon_smc_ana_read(0xD9, &tmp), ana_error);
	tmp &= ~(1<<18);
	require(!xenon_smc_ana_write(0xD9, tmp), ana_error);

    int addr_0[] = {0xD5, 0xD0, 0xD1, 0xD6, 0xD8, 0xD, 0xC};
	
	xenon_smc_ana_write(0, 0);

    for (i = 1; i < 7; ++i)
	{
		require(!xenon_smc_ana_write(addr_0[i], mode_ana[addr_0[i]]), ana_error);
		if (addr_0[i] == 0xd6){
			udelay(1000);

            if (hdmi){
                xenon_smc_ana_write(0x000,0x00000181);
                udelay(5000);
                xenon_smc_ana_write(0x000,0x00000081);
            }
        }
	}
	
	require(!xenon_smc_ana_write(0, 0x60), ana_error);
	
	uint32_t old;
	xenos_write32(0x7938, (old = xenos_read32(0x7938)) & ~1);
	xenos_write32(0x7910, 1);
	xenos_write32(0x7900, 1);
	
	int fixed_addr[] = {2, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76};
    int fixed_val[] = {0, 0x2540F38, 0xE600002, 0x2540409,2, 0x2540000, 0x3310002,0,0,0,0,0,0,0,0,0,0};
	
	for (i = 0; i < 0x11; ++i)
		xenos_ana_write(fixed_addr[i], fixed_val[i]);
    	
	// levels stuff

	for (i = 0x26; i <= 0x34; ++i)
		xenos_ana_write(i, mode_ana[i]);

	for (i = 0x35; i <= 0x43; ++i)
		xenos_ana_write(i, mode_ana[i]);

	for (i = 0x44; i <= 0x52; ++i)
		xenos_ana_write(i, mode_ana[i]);
	
	for (i = 0x53; i <= 0x54; ++i)
		xenos_ana_write(i, mode_ana[i]);
	
	for (i = 0x55; i <= 0x57; ++i)
		xenos_ana_write(i, mode_ana[i]);
		
	// digital video stuff
    int addr_1[] = {3, 6, 7, 8, 0xc, 0xd, 0xe, 0xf, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17};

    for (i = 0; i < 0x11; ++i){
		xenos_ana_write(addr_1[i], mode_ana[addr_1[i]]);
    }

	xenos_write32(0x7938, old);

	xenon_smc_ana_write(0, mode_ana[0]);

    return;
	
ana_error:
	printf("error reading/writing ana\n");
}



void xenos_init_phase0(void)
{
	xenos_write32(0xe0, 0x10000000);                    
	xenos_write32(0xec, 0xffffffff);                    

	xenos_write32(0x1724, 0);                           
	int i;
	for (i = 0; i < 8; ++i)
	{
		int addr[] = {0x8000, 0x8c60, 0x8008, 0x8004, 0x800c, 0x8010, 0x8014, 0x880c, 0x8800, 0x8434, 0x8820, 0x8804, 0x8824, 0x8828, 0x882c, 0x8420, 0x841c, 0x841c, 0x8418, 0x8414, 0x8c78, 0x8c7c, 0x8c80};
		int j;
		for (j = 0; j < 23; ++j)
			xenos_write32(addr[j] + i * 0x1000, 0);
	}
}

void xenos_init_phase1(void)
{

	uint32_t v;
	xenos_write32(EDRAM_CLK_CNTL, 0x20000000); 
	v = 0x200c0011;
	xenos_write32(EDRAM_CLK_CNTL, v);         
	udelay(1000);
	v &=~ 0x20000000;
	xenos_write32(EDRAM_CLK_CNTL, v);          
	udelay(1000);
	
	assert(xenos_read32(EDRAM_CLK_CNTL) == 0xc0011);             

	xenos_write32(0x0218, 0);          
	xenos_write32(0x3c04, 0xe);        
	xenos_write32(0x00f4, 4);          
	
	xenos_write32(0x0204, 0x400300); // 4400380 for jasper  
	xenos_write32(0x0208, 0x180002); 
	
	xenos_write32(0x01a8, 0);       
	xenos_write32(0x0e6c, 0x0c0f0000); 
	xenos_write32(0x3400, 0x40401); 
	udelay(1000);
	xenos_write32(0x3400, 0x40400);
	xenos_write32(0x3300, 0x3a22);
	xenos_write32(0x340c, 0x1003f1f);
	xenos_write32(0x00f4, 0x1e);     
	
	
	xenos_write32(0x2800, 0);                       
	xenos_write32(0x2804, 0x20000000);
	xenos_write32(0x2808, 0x20000000);               
	xenos_write32(0x280c, 0);
	xenos_write32(0x2810, 0x20000000);               
	xenos_write32(0x2814, 0);

	udelay(1000);	
	xenos_write32(0x6548, 0);
	
		// resetgui
		// initcp
		
	xenos_write32(0x04f0, (xenos_read32(0x04f0) &~ 0xf0000) | 0x40100);            
}

static void xenos_ana_stop_display(void)
{
	uint32_t tmp;
	xenon_smc_ana_read(0, &tmp);
	tmp &= ~0x1e;
	xenon_smc_ana_write(0, tmp);
}

void xenos_ana_preinit(void)
{
	xenos_ana_stop_display();
	uint32_t v;
	xenos_write32(0x6028, v = (xenos_read32(0x6028) | 0x01000000)); 
	while (!(xenos_read32(0x281c) & 2));
	xenon_smc_ana_write(0, 0);
	xenon_smc_ana_write(0xd7, 0xff);
	xenos_write32(0x6028, v & ~0x301);              
	xenos_write32(0x7900, 0);                       
	xenon_smc_ana_read(0xd9, &v);
	xenon_smc_ana_write(0xd9, v | 0x40000);
	xenon_smc_i2c_write(0x108,0x36);                //enable hdmi audio maybe ?
	
}

void xenos_set_mode_f1(struct mode_s *mode)
{
	xenos_write32(D1CRTC_UPDATE_LOCK, 1);                       
	xenos_write32(DCP_LB_DATA_GAP_BETWEEN_CHUNK, 3);                      
	xenos_write32(D1CRTC_DOUBLE_BUFFER_CONTROL, 0);                       
	xenos_write32(D1CRTC_V_TOTAL, 0);                      

	int interlace_factor = mode->is_progressive ? 1 : 2;
	
	xenos_write32(D1CRTC_H_TOTAL, mode->total_width - 1);   
	xenos_write32(D1CRTC_H_SYNC_B, mode->total_height - 1);  
	xenos_write32(D1CRTC_H_BLANK_START_END, (mode->hsync_offset << 16) | (mode->real_active_width + mode->hsync_offset));
	xenos_write32(D1CRTC_H_SYNC_B_CNTL, (mode->vsync_offset << 16) | (mode->active_height * interlace_factor + mode->vsync_offset));
	xenos_write32(D1CRTC_H_SYNC_A, 0x100000);                 
	xenos_write32(0x6018, 0x60000);                  
	xenos_write32(D1CRTC_V_SYNC_B, mode->is_progressive ? 0 : 1); 
	xenos_write32(D1CRTC_H_SYNC_A_CNTL, 0);                      
	xenos_write32(0x601c, 0);                      

	xenos_write32(D1CRTC_MVP_INBAND_CNTL_CAP, 0);                     
	xenos_write32(D1CRTC_MVP_INBAND_CNTL_INSERT, 0);                      
	xenos_write32(D1CRTC_MVP_FIFO_STATUS, 0);                      
	xenos_write32(D1CRTC_MVP_SLAVE_STATUS, 0);                     

	xenos_write32(D1CRTC_UPDATE_LOCK, 0);                      
}



void xenos_set_mode_f2(struct mode_s *mode)
{
	int interlace_factor = mode->is_progressive ? 1 : 2;
	
	xenos_write32(D1GRPH_UPDATE, 1);                         
	xenos_write32(D1GRPH_PITCH, mode->width); /* pitch */   
	xenos_write32(D1GRPH_CONTROL, 2);                         
	xenos_write32(D1GRPH_LUT_SEL, 0); /* lut override */      
	xenos_write32(D1GRPH_SURFACE_OFFSET_X, 0);                         
	xenos_write32(D1GRPH_SURFACE_OFFSET_Y, 0);                         
	xenos_write32(D1GRPH_X_START, 0);                         
	xenos_write32(D1GRPH_Y_START, 0);                         
	xenos_write32(D1GRPH_X_END, mode->width);               
	xenos_write32(D1GRPH_Y_END, mode->active_height * interlace_factor); 
	xenos_write32(D1GRPH_PRIMARY_SURFACE_ADDRESS, FB_BASE);                   
	xenos_write32(D1GRPH_PITCH, mode->width);               
	xenos_write32(D1GRPH_ENABLE, 1);                         
	xenos_write32(D1GRPH_UPDATE, 0);                         

			/* scaler update */
	xenos_write32(AVIVO_D1SCL_UPDATE, 1);                         
	xenos_write32(AVIVO_D1SCL_SCALER_ENABLE , 0);                         
	xenos_write32(0x2840, FB_BASE);                   
	xenos_write32(0x2844, mode->width);
	xenos_write32(0x2848, 0x80000);
	
	xenos_write32(AVIVO_D1MODE_VIEWPORT_START , 0); /* viewport */        
	xenos_write32(AVIVO_D1MODE_VIEWPORT_SIZE, (mode->width << 16) | (mode->active_height * interlace_factor));
	xenos_write32(0x65e8, (mode->width >> 2) - 1);
	xenos_write32(AVIVO_D1MODE_DATA_FORMAT, mode->is_progressive ? 0 : 1);    
	xenos_write32(0x6550, 0xff);
	xenos_write32(0x6524, 0x300);
	xenos_write32(0x65d0, 0x100);
	xenos_write32(D1GRPH_FLIP_CONTROL, 1);                        
	
	xenos_write32(AVIVO_D1SCL_SCALER_TAP_CONTROL, 0x905);                    
	xenos_write32(AVIVO_D1MODE_VIEWPORT_SIZE, (mode->width << 16) | (mode->height * interlace_factor));
	xenos_write32(0x65e8, (mode->width / 4) - 1);
	xenos_write32(AVIVO_D1MODE_VIEWPORT_START, 0);                       
	xenos_write32(D1GRPH_X_START, 0);                       
	xenos_write32(D1GRPH_Y_START, 0);                       
	xenos_write32(D1GRPH_X_END, mode->width);             
	xenos_write32(D1GRPH_Y_END, mode->height * interlace_factor); 
	xenos_write32(D1CRTC_MVP_FIFO_STATUS, 0);                               
	xenos_write32(D1CRTC_MVP_SLAVE_STATUS, 0);                               
	xenos_write32(D1CRTC_MVP_INBAND_CNTL_CAP, 0);                               
	xenos_write32(D1CRTC_MVP_INBAND_CNTL_INSERT, 0);                               
	xenos_write32(0x65a0, 0);
	xenos_write32(0x65b4, 0x01000000);
	xenos_write32(0x65c4, 0x01000000);
	xenos_write32(0x65b0, 0);
	xenos_write32(0x65c0, 0x01000000);
	xenos_write32(0x65b8, 0x00060000);
	xenos_write32(0x65c8, 0x00040000);
	xenos_write32(0x65dc, 0);
	xenos_write32(AVIVO_D1SCL_UPDATE, 0);                       
	
	xenos_write32(DC_LUTA_CONTROL, 0);                               
	xenos_write32(DC_LUT_RW_INDEX, 0);                               
	xenos_write32(DC_LUT_RW_MODE, 0);                               
	xenos_write32(DC_LUT_WRITE_EN_MASK, 7);                               
	xenos_write32(DC_LUT_AUTOFILL, 1);                               
	while (!(xenos_read32(DC_LUT_AUTOFILL) & 2));                    
}

void xenos_set_mode(struct mode_s *mode)
{
	xenos_write32(0x7938, xenos_read32(0x7938) | 1);       
	xenos_write32(0x06ac, 1);                  
	
	printf(" . ana disable\n");
	xenos_ana_preinit();
	xenos_write32(0x04a0, 0x100);              
	printf(" . ana enable\n");
	xenos_init_ana_new(mode->ana,mode->hdmi);
	xenos_write32(0x7900, 1);                  

	printf(" . f1\n");
	xenos_set_mode_f1(mode);
	printf(" . f2\n");
	xenos_set_mode_f2(mode);

	xenos_write32(0x6028, 0x10001);            
	
	if (!mode->composite_sync)
	{
		xenos_write32(D1CRTC_MVP_CONTROL1, 0x04010040);    
		xenos_write32(D1CRTC_MVP_CONTROL2, 0);             
		xenos_write32(D1CRTC_MVP_FIFO_CONTROL, 0x04010040);    
	} else
	{
		xenos_write32(D1CRTC_MVP_CONTROL1, 0x20000200);
		xenos_write32(D1CRTC_MVP_CONTROL2, 0x20010200);
		xenos_write32(D1CRTC_MVP_FIFO_CONTROL, 0x20010200);
	}
	xenos_write32(0x793c, 0);
	xenos_write32(0x7938, 0x700);

	
	xenos_write32(AVIVO_D1CRTC_V_BLANK_START_END, 0x04010040);        
	xenos_write32(D1CRTC_MVP_INBAND_CNTL_INSERT_TIMER, 0x00010002);        
	xenos_write32(D1CRTC_MVP_BLACK_KEYER, 0xec02414a);        

	xenos_write32(D1CRTC_TRIGA_CNTL, 0x000000ec);        
	xenos_write32(D1CRTC_TRIGA_MANUAL_TRIG, 0x014a00ec);       
	xenos_write32(D1CRTC_TRIGB_CNTL, 0x00d4014a);        
	xenos_write32(D1GRPH_PRIMARY_SURFACE_ADDRESS, FB_BASE);          


	if (!mode->rgb)
	{
		xenos_write32(D1GRPH_COLOR_MATRIX_TRANSFORMATION_CNTL, 0x00000001);    
		xenos_write32(D1COLOR_MATRIX_COEF_1_1, 0x00702000);    
		xenos_write32(D1COLOR_MATRIX_COEF_1_2, 0x87a26000);    
		xenos_write32(D1COLOR_MATRIX_COEF_1_3, 0x87ede000);    
		xenos_write32(D1COLOR_MATRIX_COEF_1_4, 0x02008000);    
		xenos_write32(D1COLOR_MATRIX_COEF_2_1, 0x00418000);    
		xenos_write32(D1COLOR_MATRIX_COEF_2_2, 0x0080a000);    
		xenos_write32(D1COLOR_MATRIX_COEF_2_3, 0x00192000);    
		xenos_write32(D1COLOR_MATRIX_COEF_2_4, 0x00408000);    
		xenos_write32(D1COLOR_MATRIX_COEF_3_1, 0x87da4000);    
		xenos_write32(D1COLOR_MATRIX_COEF_3_2, 0x87b5e000);    
		xenos_write32(D1COLOR_MATRIX_COEF_3_3, 0x00702000);    
		xenos_write32(D1COLOR_MATRIX_COEF_3_4, 0x02008000);    
		xenos_write32(0x63b4, 0x00000000);
	} else
	{
		xenos_write32(D1GRPH_COLOR_MATRIX_TRANSFORMATION_CNTL, 0x00000001);
		xenos_write32(D1COLOR_MATRIX_COEF_1_1, 0x00db4000);
		xenos_write32(D1COLOR_MATRIX_COEF_1_2, 0x00000000);
		xenos_write32(D1COLOR_MATRIX_COEF_1_3, 0x00000000);
		xenos_write32(D1COLOR_MATRIX_COEF_1_4, 0x00408000);
		xenos_write32(D1COLOR_MATRIX_COEF_2_1, 0x00000000);
		xenos_write32(D1COLOR_MATRIX_COEF_2_2, 0x00db4000);
		xenos_write32(D1COLOR_MATRIX_COEF_2_3, 0x00000000);
		xenos_write32(D1COLOR_MATRIX_COEF_2_4, 0x00408000);
		xenos_write32(D1COLOR_MATRIX_COEF_3_1, 0x00000000);
		xenos_write32(D1COLOR_MATRIX_COEF_3_2, 0x00000000);
		xenos_write32(D1COLOR_MATRIX_COEF_3_3, 0x00db4000);
		xenos_write32(D1COLOR_MATRIX_COEF_3_4, 0x00408000);
		xenos_write32(0x63b4, 0x00000000);
	}
	
	if (mode->hdmi) xenon_smc_ana_write(0,0x2c1);                      
}

void xenos_autoset_mode(void)
{
	int mode = VIDEO_MODE_PAL60;
	int avpack = xenon_smc_read_avpack();

	printf("AVPACK detected: %02x\n", avpack);
	switch (avpack&0xF)
	{
	case 0x3: // normal (composite)
		mode = VIDEO_MODE_PAL60;
		break;
	case 0xF: // HDTV
        	mode = (avpack&0x40)?VIDEO_MODE_PAL60:VIDEO_MODE_HDMI_720p; //FIXME: 720p YUV
		break;
	case 0xb: // VGA
		mode = (avpack&0x40)?VIDEO_MODE_VGA_1024x768:VIDEO_MODE_HDMI_720p; // fix for optical audio+HDMI
		break;
	case 0xC: // no AV pack, revert to composite.
		mode = VIDEO_MODE_PAL60;
		break;
	default:
		printf("unsupported AVPACK!\n");
		{
			int table[] = {0xf, 0x1, 0x3, 0x7};
			xenon_smc_set_led(1, 0xff);
			mdelay(1000);
			xenon_smc_set_led(1, table[(avpack>>6) & 3]);
			mdelay(1000);
			xenon_smc_set_led(1, table[(avpack>>4) & 3]);
			mdelay(1000);
			xenon_smc_set_led(1, table[(avpack>>2) & 3]);
			mdelay(1000);
			xenon_smc_set_led(1, table[(avpack>>0) & 3]);
			mdelay(1000);
			xenon_smc_set_led(1, 0xff);
			mdelay(1000);
			xenon_smc_set_led(0, 0);
		}
		break;
	}
	xenos_set_mode(&xenos_modes[mode]);
}

void xenos_lowlevel_init(void)
{
	xenos_init_phase0();
	xenos_init_phase1();
	
	xenon_gpio_set(0, 0x2300);
	xenon_gpio_set_oe(0, 0x2300);

	xenos_autoset_mode();

	xenon_smc_ana_write(0xdf, 0);
	xenos_write32(AVIVO_D1MODE_DESKTOP_HEIGHT, 0x00000300);
}
