#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <xenos/xe.h>
#include <xenos/xenos.h>
#include <xenos/edram.h>
#include <console/console.h>
#include "engine.h"
#include "xee.h"

uint64_t ld(volatile void *addr)
{
	uint64_t l;
	asm volatile ("ld %0, 0(%1)" : "=r" (l) : "r" (addr));
	return l;
}

		/* simple 3d */
static unsigned char shader_3d_ps[] = {
	0x10, 0x2a, 0x11, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x00, 0x00, 0x00, 0x48,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x8c, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x7f,
	0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x1c,
	0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x44,
	0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x03, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x69, 0x67, 0x68, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x00, 0xab, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x04,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0x00, 0xab, 0xab,
	0x00, 0x04, 0x00, 0x0c, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x73, 0x5f, 0x33, 0x5f, 0x30, 0x00, 0x32,
	0x2e, 0x30, 0x2e, 0x37, 0x36, 0x38, 0x30, 0x2e, 0x30, 0x00, 0xab, 0xab,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x10, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x42,
	0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x70, 0x30,
	0x00, 0x00, 0xf1, 0x50, 0x00, 0x01, 0x10, 0x02, 0x00, 0x00, 0x12, 0x00,
	0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x03, 0x00, 0x00, 0x22, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x10, 0x21, 0x1f, 0x1f, 0xf6, 0x88,
	0x00, 0x00, 0x40, 0x00, 0xc8, 0x01, 0x00, 0x00, 0x00, 0xbe, 0xbe, 0x00,
	0xb0, 0x00, 0x00, 0x00, 0x14, 0x87, 0x80, 0x00, 0x00, 0x6c, 0xc0, 0x1b,
	0xe1, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00
};

static unsigned char shader_3d_vs[] = {
	0x10, 0x2a, 0x11, 0x01, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0xb4,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x83,
	0xff, 0xfe, 0x03, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x1c,
	0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x44,
	0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x02, 0x00, 0x04,
	0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x00,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x69, 0x65, 0x77, 0x00, 0xab, 0xab,
	0x00, 0x03, 0x00, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x57, 0x6f, 0x72,
	0x6c, 0x64, 0x00, 0xab, 0x00, 0x03, 0x00, 0x03, 0x00, 0x04, 0x00, 0x03,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0x73, 0x5f, 0x33,
	0x5f, 0x30, 0x00, 0x32, 0x2e, 0x30, 0x2e, 0x37, 0x36, 0x38, 0x30, 0x2e,
	0x30, 0x00, 0xab, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4,
	0x00, 0x11, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0x42, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03,
	0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x02, 0x90, 0x00, 0x10, 0x00, 0x03,
	0x00, 0x00, 0x30, 0x04, 0x00, 0x20, 0x50, 0x05, 0x00, 0x00, 0x70, 0x30,
	0x00, 0x03, 0xf1, 0x50, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x0c,
	0x00, 0x00, 0x10, 0x0d, 0x00, 0x00, 0x10, 0x0a, 0x70, 0x15, 0x30, 0x03,
	0x00, 0x00, 0x12, 0x00, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x06,
	0x00, 0x00, 0x12, 0x00, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x0a,
	0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xf8, 0x20, 0x00,
	0x00, 0x00, 0x06, 0x88, 0x00, 0x00, 0x00, 0x00, 0x05, 0xf8, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x47, 0x00, 0x00, 0x00, 0x00, 0x05, 0xf8, 0x10, 0x00,
	0x00, 0x00, 0x06, 0x88, 0x00, 0x00, 0x00, 0x00, 0xc8, 0x01, 0x80, 0x3e,
	0x00, 0xa7, 0xa7, 0x00, 0xaf, 0x02, 0x00, 0x00, 0xc8, 0x02, 0x80, 0x3e,
	0x00, 0xa7, 0xa7, 0x00, 0xaf, 0x02, 0x01, 0x00, 0xc8, 0x04, 0x80, 0x3e,
	0x00, 0xa7, 0xa7, 0x00, 0xaf, 0x02, 0x02, 0x00, 0xc8, 0x08, 0x80, 0x3e,
	0x00, 0xa7, 0xa7, 0x00, 0xaf, 0x02, 0x03, 0x00, 0xc8, 0x0f, 0x80, 0x01,
	0x00, 0x00, 0x00, 0x00, 0xe2, 0x01, 0x01, 0x00, 0xc8, 0x01, 0x80, 0x00,
	0x00, 0xc3, 0xbe, 0x00, 0xb0, 0x00, 0x04, 0x00, 0xc8, 0x02, 0x80, 0x00,
	0x00, 0xc3, 0xbe, 0x00, 0xb0, 0x00, 0x05, 0x00, 0xc8, 0x04, 0x80, 0x00,
	0x00, 0xc3, 0xbe, 0x00, 0xb0, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

int main(void)
{
	xenos_init(VIDEO_MODE_AUTO);
	console_init();
	printf("Hello, world!\n");
	struct XenosDevice _xe, *xe;

	xe = &_xe;
		/* initialize the GPU */
	Xe_Init(xe);

		/* create a render target (the framebuffer) */
	struct XenosSurface *fb = Xe_GetFramebufferSurface(xe);
	Xe_SetRenderTarget(xe, fb);

		/* let's define a vertex buffer format */
	static const struct XenosVBFFormat vbf =
	{
		5, {
		  {XE_USAGE_POSITION, 0, XE_TYPE_FLOAT3},
		  {XE_USAGE_NORMAL,   0, XE_TYPE_FLOAT3},
		  {XE_USAGE_TANGENT,  0, XE_TYPE_FLOAT3},
		  {XE_USAGE_COLOR,    0, XE_TYPE_UBYTE4},
		  {XE_USAGE_TEXCOORD, 0, XE_TYPE_FLOAT2},
		}
	};

		/* a cube */
	float cube[] = {
		//       POSITION           |            NORMAL           |        TANGENT              |   COL   |    U        V    |
		-0.5000 , -0.5000 , -0.5000 , +0.0000 , +0.0000 , -1.0000 , +1.0000 , +0.0000 , +0.0000 , +0.0000 , +1.0000 , +1.0000, 
		-0.5000 , +0.5000 , -0.5000 , +0.0000 , +0.0000 , -1.0000 , +1.0000 , +0.0000 , +0.0000 , +0.0000 , +1.0000 , +0.0000, 
		+0.5000 , +0.5000 , -0.5000 , +0.0000 , +0.0000 , -1.0000 , +1.0000 , +0.0000 , +0.0000 , +0.0000 , +2.0000 , +0.0000, 
		+0.5000 , -0.5000 , -0.5000 , +0.0000 , +0.0000 , -1.0000 , +1.0000 , +0.0000 , +0.0000 , +0.0000 , +2.0000 , +1.0000, 
		-0.5000 , -0.5000 , +0.5000 , -1.0000 , +0.0000 , +0.0000 , +0.0000 , +0.0000 , -1.0000 , +0.0000 , +0.0000 , +1.0000, 
		-0.5000 , +0.5000 , +0.5000 , -1.0000 , +0.0000 , +0.0000 , +0.0000 , +0.0000 , -1.0000 , +0.0000 , +0.0000 , +0.0000, 
		-0.5000 , +0.5000 , -0.5000 , -1.0000 , +0.0000 , +0.0000 , +0.0000 , +0.0000 , -1.0000 , +0.0000 , +1.0000 , +0.0000, 
		-0.5000 , -0.5000 , -0.5000 , -1.0000 , +0.0000 , +0.0000 , +0.0000 , +0.0000 , -1.0000 , +0.0000 , +1.0000 , +1.0000, 
		+0.5000 , -0.5000 , +0.5000 , +0.0000 , +0.0000 , +1.0000 , -1.0000 , +0.0000 , +0.0000 , +0.0000 , +3.0000 , +1.0000, 
		+0.5000 , +0.5000 , +0.5000 , +0.0000 , +0.0000 , +1.0000 , -1.0000 , +0.0000 , +0.0000 , +0.0000 , +3.0000 , +0.0000, 
		-0.5000 , +0.5000 , +0.5000 , +0.0000 , +0.0000 , +1.0000 , -1.0000 , +0.0000 , +0.0000 , +0.0000 , +4.0000 , +0.0000, 
		-0.5000 , -0.5000 , +0.5000 , +0.0000 , +0.0000 , +1.0000 , -1.0000 , +0.0000 , +0.0000 , +0.0000 , +4.0000 , +1.0000, 
		+0.5000 , -0.5000 , -0.5000 , +1.0000 , +0.0000 , +0.0000 , +0.0000 , +0.0000 , +1.0000 , +0.0000 , +2.0000 , +1.0000, 
		+0.5000 , +0.5000 , -0.5000 , +1.0000 , +0.0000 , +0.0000 , +0.0000 , +0.0000 , +1.0000 , +0.0000 , +2.0000 , +0.0000, 
		+0.5000 , +0.5000 , +0.5000 , +1.0000 , +0.0000 , +0.0000 , +0.0000 , +0.0000 , +1.0000 , +0.0000 , +3.0000 , +0.0000, 
		+0.5000 , -0.5000 , +0.5000 , +1.0000 , +0.0000 , +0.0000 , +0.0000 , +0.0000 , +1.0000 , +0.0000 , +3.0000 , +1.0000, 
		-0.5000 , +0.5000 , -0.5000 , +0.0000 , +1.0000 , +0.0000 , +1.0000 , +0.0000 , +0.0000 , +0.0000 , +0.0000 , +1.0000, 
		-0.5000 , +0.5000 , +0.5000 , +0.0000 , +1.0000 , +0.0000 , +1.0000 , +0.0000 , +0.0000 , +0.0000 , +0.0000 , +0.0000, 
		+0.5000 , +0.5000 , +0.5000 , +0.0000 , +1.0000 , +0.0000 , +1.0000 , +0.0000 , +0.0000 , +0.0000 , +1.0000 , +0.0000, 
		+0.5000 , +0.5000 , -0.5000 , +0.0000 , +1.0000 , +0.0000 , +1.0000 , +0.0000 , +0.0000 , +0.0000 , +1.0000 , +1.0000, 
		+0.5000 , -0.5000 , -0.5000 , +0.0000 , -1.0000 , +0.0000 , -1.0000 , +0.0000 , +0.0000 , +0.0000 , +0.0000 , +1.0000, 
		+0.5000 , -0.5000 , +0.5000 , +0.0000 , -1.0000 , +0.0000 , -1.0000 , +0.0000 , +0.0000 , +0.0000 , +0.0000 , +0.0000, 
		-0.5000 , -0.5000 , +0.5000 , +0.0000 , -1.0000 , +0.0000 , -1.0000 , +0.0000 , +0.0000 , +0.0000 , +1.0000 , +0.0000, 
		-0.5000 , -0.5000 , -0.5000 , +0.0000 , -1.0000 , +0.0000 , -1.0000 , +0.0000 , +0.0000 , +0.0000 , +1.0000 , +1.0000, 
	};
	unsigned short cube_indices[] = { 0, 1, 2, 0, 2, 3, 4, 5, 6, 4, 6, 7, 8, 9, 10, 8, 10, 11, 12, 13, 14, 12, 14, 15, 16, 17, 18, 16, 18, 19, 20, 21, 22, 20, 22, 23};

	struct XenosShader *sh_3d_ps = Xe_LoadShaderFromMemory(xe, shader_3d_ps);
	Xe_InstantiateShader(xe, sh_3d_ps, 0);

	struct XenosShader *sh_3d_vs = Xe_LoadShaderFromMemory(xe, shader_3d_vs);
	Xe_InstantiateShader(xe, sh_3d_vs, 0);
	Xe_ShaderApplyVFetchPatches(xe, sh_3d_vs, 0, &vbf);

	M_BuildPersp(&g_proj, 45.0 / 180.0 * M_PI, 640.0/480.0, 1, 200.0);

	printf("create vb...\n");
		/* create and fill vertex buffer */
	struct XenosVertexBuffer *vb = Xe_CreateVertexBuffer(xe, sizeof(cube));
	void *v = Xe_VB_Lock(xe, vb, 0, sizeof(cube), XE_LOCK_WRITE);
	memcpy(v, cube, sizeof(cube));
	Xe_VB_Unlock(xe, vb);

	printf("create ib...\n");
		/* create and fill index buffer */
	struct XenosIndexBuffer *ib = Xe_CreateIndexBuffer(xe, sizeof(cube_indices), XE_FMT_INDEX16);
	unsigned short *i = Xe_IB_Lock(xe, ib, 0, sizeof(cube_indices), XE_LOCK_WRITE);
	memcpy(i, cube_indices, sizeof(cube_indices));
	Xe_IB_Unlock(xe, ib);

		/* init EDRAM, this needs to be done right before beginning the first frame */
	edram_init(xe);

		/* stats */
	int f = 0;
	int framecount = 0;
	printf("render..\n");
	
	console_close();

	while (1)
	{
		f++;
		framecount++;
		
			/* begin a new frame, i.e. reset all renderstates to the default */
		Xe_InvalidateState(xe);
		
			/* load some model-view matrix */
		glLoadIdentity();
		glPushMatrix();
		glTranslate(0, 0, -3);
		glRotate(f / 100.0, .5, .1, 1);
		M_LoadMV(xe, 0); // load model view matrix to VS constant 0
		M_LoadMW(xe, 4); // load (fake) model world matrix to VS constant 4

			/* set the light direction for the pixel shader */
		float lightDirection[] = {0, 0, -1, 0};
		Xe_SetPixelShaderConstantF(xe, 0, lightDirection, 1);

		int max_vertices = sizeof(cube)/(sizeof(*cube)*12);
		int nr_primitives = sizeof(cube_indices)/sizeof(*cube_indices) / 3;

			/* draw cube */
		Xe_SetShader(xe, SHADER_TYPE_PIXEL, sh_3d_ps, 0);
		Xe_SetShader(xe, SHADER_TYPE_VERTEX, sh_3d_vs, 0);
		Xe_SetStreamSource(xe, 0, vb, 0, 12); /* using this vertex buffer */
		Xe_SetIndices(xe, ib); /* ... this index buffer... */
		Xe_SetTexture(xe, 0, fb); /* ... and this texture */
		Xe_DrawIndexedPrimitive(xe, XE_PRIMTYPE_TRIANGLELIST, 0, 0, max_vertices, 0, nr_primitives);

			/* clear to white */
		Xe_SetClearColor(xe, ~0);

			/* resolve (and clear) */
		Xe_Resolve(xe);

			/* wait for render finish */
	 	Xe_Sync(xe);

	 	glPopMatrix();
	 	
	 		/* some stats */
	}
	
	return 0;
}
