const fs = require('fs');

function readFile() {
    return new Promise((resolve, reject) => {
        fs.readFile('./archive.json', 'utf8', (err, data) => {
            if (err) {
                reject(err);
                return;
            }

            resolve(JSON.parse(data));
        });
    });
}

function checkTypes(object) {
    if (!Array.isArray(object))
        return 'archive is not a array';

    for (let i in object) {
        let archiveItem = object[i];

        if (Object.keys(archiveItem).length !== 5)
            return 'every archive item must have exactly 5 items';

        if (!archiveItem.subreddit
            || !archiveItem.download_homepage
            || !archiveItem.download_link
            || !archiveItem.date_archived
            || !archiveItem.author) {
            return 'archive item is missing properties'
        }

        if(!archiveItem.date_archived.match(/\d\d\d\d-\d\d-\d\d/)) {
            return 'date is not properly formatted';
        }

        if(archiveItem.subreddit !== archiveItem.subreddit.toLowerCase()) {
            return 'subreddit name must be all lowercase';
        }
    }
}

async function validate() {
    let object = await readFile();

    let typeErrors = checkTypes(object);

    if (typeErrors) {
        return typeErrors;
    }
}

validate()
    .then(error => {
        if (error) {
            console.error(error);
            process.exit(1);
        }
    })
    .catch(err => {
        console.error(err);
        process.exit(1);
    });