package tv.porst.swfretools.parser.tags;

/**
 * Contains the numeric values of tag codes as they can be found in SWF files.
 */
public final class TagCodes {

	/**
	 * Tag identifier for the End tag.
	 */
	public static final int End = 0;

	/**
	 * Tag identifier for the ShowFrame tag.
	 */
	public static final int ShowFrame = 1;

	/**
	 * Tag identifier for the DefineShape tag.
	 */
	public static final int DefineShape = 2;

	/**
	 * Tag identifier for the PlaceObject tag.
	 */
	public static final int PlaceObject = 4;

	/**
	 * Tag identifier for the RemoveObject tag.
	 */
	public static final int RemoveObject = 5;

	/**
	 * Tag identifier for the DefineBits tag.
	 */
	public static final int DefineBits = 6;

	/**
	 * Tag identifier for the DefineButton tag.
	 */
	public static final int DefineButton = 7;

	/**
	 * Tag identifier for the JPEGTables tag.
	 */
	public static final int JPEGTables = 8;

	/**
	 * Tag identifier for the SetBackgroundColor tag.
	 */
	public static final int SetBackgroundColor = 9;

	/**
	 * Tag identifier for the DefineFont tag.
	 */
	public static final int DefineFont = 10;

	/**
	 * Tag identifier for the DefineText tag.
	 */
	public static final int DefineText = 11;

	/**
	 * Tag identifier for the DoAction tag.
	 */
	public static final int DoAction = 12;

	/**
	 * Tag identifier for the DefineFontInfo tag.
	 */
	public static final int DefineFontInfo = 13;

	/**
	 * Tag identifier for the DefineSound tag.
	 */
	public static final int DefineSound = 14;

	/**
	 * Tag identifier for the StartSound tag.
	 */
	public static final int StartSound = 15;

	/**
	 * Tag identifier for the DefineButtonSound tag.
	 */
	public static final int DefineButtonSound = 17;

	/**
	 * Tag identifier for the SoundStreamHead tag.
	 */
	public static final int SoundStreamHead = 18;

	/**
	 * Tag identifier for the SoundStreamBlock tag.
	 */
	public static final int SoundStreamBlock = 19;

	/**
	 * Tag identifier for the DefineBitsLossless tag.
	 */
	public static final int DefineBitsLossless = 20;

	/**
	 * Tag identifier for the DefineBitsJPEG2 tag.
	 */
	public static final int DefineBitsJPEG2 = 21;

	/**
	 * Tag identifier for the DefineShape2 tag.
	 */
	public static final int DefineShape2 = 22;

	/**
	 * Tag identifier for the DefineButtonCxform tag.
	 */
	public static final int DefineButtonCxform = 23;

	/**
	 * Tag identifier for the Protect tag.
	 */
	public static final int Protect = 24;

	/**
	 * Tag identifier for the PlaceObject2 tag.
	 */
	public static final int PlaceObject2 = 26;

	/**
	 * Tag identifier for the RemoveObject2 tag.
	 */
	public static final int RemoveObject2 = 28;

	/**
	 * Tag identifier for the DefineShape3 tag.
	 */
	public static final int DefineShape3 = 32;

	/**
	 * Tag identifier for the DefineText2 tag.
	 */
	public static final int DefineText2 = 33;

	/**
	 * Tag identifier for the DefineButton2 tag.
	 */
	public static final int DefineButton2 = 34;

	/**
	 * Tag identifier for the DefineBitsJPEG3 tag.
	 */
	public static final int DefineBitsJPEG3 = 35;

	/**
	 * Tag identifier for the DefineBitsLossless2 tag.
	 */
	public static final int DefineBitsLossless2 = 36;

	/**
	 * Tag identifier for the DefineEditText tag.
	 */
	public static final int DefineEditText = 37;

	/**
	 * Tag identifier for the DefineSprite tag.
	 */
	public static final int DefineSprite = 39;

	/**
	 * Tag identifier for the FrameLabel tag.
	 */
	public static final int FrameLabel = 43;

	/**
	 * Tag identifier for the SoundStreamHead2 tag.
	 */
	public static final int SoundStreamHead2 = 45;

	/**
	 * Tag identifier for the DefineMorphShape tag.
	 */
	public static final int DefineMorphShape = 46;

	/**
	 * Tag identifier for the DefineFont2 tag.
	 */
	public static final int DefineFont2 = 48;

	/**
	 * Tag identifier for the ExportAssets tag.
	 */
	public static final int ExportAssets = 56;

	/**
	 * Tag identifier for the ImportAssets tag.
	 */
	public static final int ImportAssets = 57;

	/**
	 * Tag identifier for the EnableDebugger tag.
	 */
	public static final int EnableDebugger = 58;

	/**
	 * Tag identifier for the DoInitAction tag.
	 */
	public static final int DoInitAction = 59;

	/**
	 * Tag identifier for the DefineVideoStream tag.
	 */
	public static final int DefineVideoStream = 60;

	/**
	 * Tag identifier for the VideoFrame tag.
	 */
	public static final int VideoFrame = 61;

	/**
	 * Tag identifier for the DefineFontInfo2 tag.
	 */
	public static final int DefineFontInfo2 = 62;

	/**
	 * Tag identifier for the EnableDebugger2 tag.
	 */
	public static final int EnableDebugger2 = 64;

	/**
	 * Tag identifier for the ScriptLimits tag.
	 */
	public static final int ScriptLimits = 65;

	/**
	 * Tag identifier for the SetTabIndex tag.
	 */
	public static final int SetTabIndex = 66;

	/**
	 * Tag identifier for the FileAttributes tag.
	 */
	public static final int FileAttributes = 69;

	/**
	 * Tag identifier for the PlaceObject3 tag.
	 */
	public static final int PlaceObject3 = 70;

	/**
	 * Tag identifier for the ImportAssets2 tag.
	 */
	public static final int ImportAssets2 = 71;

	/**
	 * Tag identifier for the RawABC tag.
	 */
	public static final int RawABC = 72;

	/**
	 * Tag identifier for the DefineFontAlignZones tag.
	 */
	public static final int DefineFontAlignZones = 73;

	/**
	 * Tag identifier for the CSMTextSettings tag.
	 */
	public static final int CSMTextSettings = 74;

	/**
	 * Tag identifier for the DefineFont3 tag.
	 */
	public static final int DefineFont3 = 75;

	/**
	 * Tag identifier for the SymbolClass tag.
	 */
	public static final int SymbolClass = 76;

	/**
	 * Tag identifier for the Metadata tag.
	 */
	public static final int Metadata = 77;

	/**
	 * Tag identifier for the DefineScalingGrid tag.
	 */
	public static final int DefineScalingGrid = 78;

	/**
	 * Tag identifier for the DoABC tag.
	 */
	public static final int DoABC = 82;

	/**
	 * Tag identifier for the DefineShape4 tag.
	 */
	public static final int DefineShape4 = 83;

	/**
	 * Tag identifier for the DefineMorphShape2 tag.
	 */
	public static final int DefineMorphShape2 = 84;

	/**
	 * Tag identifier for the DefineSceneAndFrameLabelData tag.
	 */
	public static final int DefineSceneAndFrameLabelData = 86;

	/**
	 * Tag identifier for the DefineBinaryData tag.
	 */
	public static final int DefineBinaryData = 87;

	/**
	 * Tag identifier for the DefineFontName tag.
	 */
	public static final int DefineFontName = 88;

	/**
	 * Tag identifier for the StartSound2 tag.
	 */
	public static final int StartSound2 = 89;

	/**
	 * Tag identifier for the DefineBitsJPEG4 tag.
	 */
	public static final int DefineBitsJPEG4 = 90;

	/**
	 * Tag identifier for the DefineFont4 tag.
	 */
	public static final int DefineFont4 = 91;
}