RABCDAsm Changelog
==================

RABCDAsm v1.18 (2016.01.16)
---------------------------

 * Fix disassembly of `pushbyte` instructions (the AVM specification 
   incorrectly lists the argument as unsigned).
 * Bump `#version` directive of new disassemblies to 4:
   - Versions below 4 treat `pushbyte` as unsigned, and throw an exception if 
     the argument is outside the range `0` ... `255`.
   - Versions 4 and above treat `pushbyte` as signed, and throw an exception 
     if the argument is outside the range `-128` ... `127`.
 * Fix buffer reuse bugs when using macros
 * Dump floating-point numbers in hex notation if necessary to ensure precision
 * Cease emitting a number in a comment after opening `script` tags
 * Detect a known DMD bug in `build_rabcdasm`
 * Ignore invalid file size in header

RABCDAsm v1.17 (2014.09.10)
---------------------------

 * Do not attempt to disassemble unreachable code
 * Improve handling of disassembly errors:
   methods will be partially disassembled as far as possible.
 * Fix LZMA errors with uncompressable data.

RABCDAsm v1.16 (2014.04.21)
---------------------------

 * Fix handling of TypeName-kind Multinames with null parameters
 * Fix v1.15 regression in handling very long paths on Windows
   (DMD 2.066 is required when building from source for this to work)

RABCDAsm v1.15 (2014.01.11)
---------------------------

 * Fix building on systems with a noexec `/tmp/`
 * Improve compatibility with 3rd-party players
   * Don't emit forward references in TypeName-kind Multinames
 * Improve performance and memory usage

RABCDAsm v1.14 (2013.08.21)
---------------------------

 * Improved refid generation
 * Worked around liblzma dictionary size limitation, which prevented 
   decompression of some LZMA-compressed files
 * Added an option to `swflzmacompress` to update the SWF version number
 * Added `finddef` instruction
 * Added unimplemented `{get|set|delete}propertylate` instructions
 * Documentation updates

RABCDAsm v1.13 (2012.09.29)
---------------------------

 * Fixed handling of truncated SWF tags

RABCDAsm v1.12 (2012.09.08)
---------------------------

 * Relaxed filename sanitization for names like "controller"
 * Added range validation for byte literals
 * Fixed LZMA support misdetection caused by stale rdmd cache
 * Added coerce_b, coerce_i and coerce_d opcodes
 * Fixed handling of recursively-nested function literals
 * Fixed handling of homonym non-private namespaces
   * #privatens directives are now ignored, and no longer generated
 * Improved refid generation
 * Bumped #version to 3 (v1.12 disassemblies are not backwards-compatible)
 * Documentation updates

RABCDAsm v1.11 (2012.03.15)
---------------------------

 * Fixed v1.10 hierarchy flattening regression
 * Improved refid generation for protected namespaces
 * Improved handling of overflown signed integers
 * Fixed metadata handling (caused by error in ABC format specification)
 * Added #version directive (v1.11 disassemblies are not backwards-compatible)
 * Removed path length limitation on Windows
 * Improved filename sanitization
 * Updated asasm.hrc
 * Documentation updates

RABCDAsm v1.10 (2012.02.29)
---------------------------

 * Fixed escaping of paths with empty segments

RABCDAsm v1.9 (2012.02.07)
--------------------------

 * Added support for LZMA-compressed SWF files
 * Added swflzmacompress
 * Fixed undiscovered private namespaces in class interfaces
 * Fixed handling of overflown integers
 * Documentation updates

RABCDAsm v1.8 (2011.07.06)
--------------------------

 * Fixed handling of orphan methods with multiple references
 * Treat out-of-bounds namespace/multiname indices as null
 * Documentation updates

RABCDAsm v1.7 (2011.06.14)
--------------------------

 * Fixed handling of invalid UTF-8 in strings
 * Fixed handling of null namespaces and multinames
 * Fixed handling of exception info in corrupted method bodies
 * Fixed handling of orphan private namespaces
 * Fixed handling of out-of-bounds class/method indices
 * Disassembler now creates one file per class and script-level method
 * Disassembler now outputs blank lines after `si32` etc. instructions as well
 * `abcexport` now delimits the index with a dash in output filenames
 * Improved shortening of `double` literals
 * Documentation updates

RABCDAsm v1.6 (2011.05.13)
--------------------------

 * Overhaul of the structure of disassembler-generated files
   * Private namespace names and `refid`s for nested classes are now generated 
     from their referenced contexts
     * This also fixes problems caused by private namespaces being referenced 
       in multiple distinct contexts
   * One `#include`d file per script instead of per class
     * Nested classes, script initializers and other script traits are now in 
       the same file as their main class
   * Inline methods are now in separate files, placed according to their usage 
     context
   * Private namespaces are sorted by their autogenerated names in the 
     `.privatens.asasm` file
   * No syntax changes, output is backwards-compatible
 * Improved escaping of file names
 * Output correct opcode error locations
 * Disassembler will now refuse to overwrite files
 * `rabcdasm` will now always generate output in the same directory as the 
   input file
 * Failure to decode a method body is now not a fatal error
 * Aggressively try to shorten double literals to their shortest representation
 * Added the `swfbinexport` and `swfbinreplace` utilities, to aid in 
   manipulating contents of `DefineBinaryData` tags
 * The package can now be built using a simple, dedicated build tool
 * Documentation updates

RABCDAsm v1.5 (2011.04.14)
--------------------------

 * Fixed v1.4 constant pool regression
 * Added support for memory-access and sign-extend opcodes
 * Speed optimizations
 * Documentation updates

RABCDAsm v1.4 (2011.03.07)
--------------------------

 * Source code ported to D2
 * Add support for forward-references for TypeName-kind Multinames
 * Correctly order classes by dependencies (extends/implements) and reference 
   count
 * Finish Metadata support
 * Documentation updates

RABCDAsm v1.3 (2010.11.11)
--------------------------

 * Fixed double precision problem
   * This also fixes problems with illegal default values for function 
     parameters (default values for integer parameters are stored as doubles, 
     which might become out-of-range due to inadequate double precision)
 * Added Changelog
 * Documentation markdown fixes

RABCDAsm v1.2 (2010.11.06)
--------------------------

 * Fixed ref generation for orphan objects which were only referenced by other 
   orphans
 * Better error handling in `abcexport`; warn when no DoABC tags found
 * Documentation updates

RABCDAsm v1.1 (2010.06.30)
--------------------------

 * Private namespaces are now referenced by auto-generated names
 * Use `:` to delimit namespace and name in QNames for consistency
 * Fixed relative include paths
 * Add optional byte offsets to labels, which allows lossless representation 
   of jumps inside instructions and outside the function bounds
 * Documentation updates

RABCDAsm v1.0 (2010.05.05)
--------------------------

 * Initial release.
