---
layout: post
title: 秦晖：捐赠者权利问题——不同背景下的诉求
categories: Archive
tags: 新冠肺炎
image_feature: ""
date: 2020-02-16
description: "财富被滥用可以再创造，政府不行也可以另选，但社会道德、公益心和凝聚力的损害更难恢复，而即使好政府面对缺乏凝聚力的社会也是难于治理的。因此，对捐款的使用进行有效监督，比对税款使用的监督应当更严格。"
---

原文来自「秦川雁塔」：~~[秦晖：捐赠者权利问题——不同背景下的诉求](https://github.com/Terminus2049/Terminus2049.github.io/issues/535)~~

---

【按：这是笔者给斯坦福大学慈善和民间社会中心联合主任和社会伦理中心主任罗布·莱奇教授的著作《公平的捐赠：为什么慈善事业正在辜负民主以及如何做得更好》（普林斯顿大学出版社，2018年）一书写的学术书评中的一节。全文其他部分发表于《斯坦福社会创新评论》。近期关于武汉肺炎救助的公益问题引发热议，特发此段以供讨论】

莱奇提到的一大问题，就是捐赠者对其基金使用的意愿应该得到何种程度的尊重？这种尊重应该延续多久？无疑，除了捐赠者无特殊意愿的情况（如直接捐赠给国库或教会，由其任意使用），如果捐赠者有意愿，那是应该尽量尊重的。否则那就不叫捐赠，而应该叫赋税了。但如果捐赠者意愿过于刚性，不但公益的性质确实会受影响，日久还会带来“信托失败”的风险。

这个问题其实自有慈善信托之日起就存在。假如一个慈善者直接与受助者打交道，比如有人在家门口直接给人布施，那不是一种社会行为，这种慈善也做不大。假如他对一个基金会进行捐赠，委托其实现自己的救助意愿，那就构成了一种信托关系，这是慈善能成为社会事业的基础。

　
一般认为西方慈善有两个源头：在希腊罗马的古典philanthropy形态中，捐助者主权通常相当具体，信托者的主动空间极小。而中世纪主要由教会为主体的charity传统中,行善的主动权完全操于教会之手，捐赠者只是通过教会向上帝赎罪，对其捐赠的用途通常是没法过问的。这两种缺陷都影响了公益信托的发展。

近代首先在英国普通法传统中兴起的“近似原则（cy-pres，源于古法语“尽可能接近”）”被认为解决了此问题。其原则是：当委托人的最初目标变得不可能、不可行或无意义时，近似原则允许慈善信托用于“尽可能接近”委托人初衷之目的，以防止信托失败。

这一原则在美国尤其促进了民间慈善公益事业成长到世界领先水平。如莱奇所言，那时美国尚未实行捐赠者税收优惠的激励政策，旺盛的慈善意愿主要就是由捐赠者的个人“理想”推动的。而对他们意愿的尊重又因“近似原则”变得十分灵活，尤其在捐赠者离世、不可能改动意愿的情况下，根据公益的目的灵活定义其意愿就更为重要。典型的如：南北战争前著名废奴主义者弗朗西斯·杰克逊遗赠基金用于“在美国废除黑奴制”。杰克逊去世四年后奴隶制已废除，杰克逊家属认为原委托目的消失，要求解除信托。但法院判决：按照接近于杰克逊的初衷，基金可以用于“促进自由民的教育，支持和帮助废奴后的前奴隶”。

显然，正如基于纳税人权利的“无代表不纳税”奠定了近代公共财政不同于传统“皇粮国税”的基础一样，基于捐赠人权利的“近似原则”也是近代慈善不同于中世纪“赎罪”式宗教慈善（charity）的基本区别。但是在民煮确立之后，随着“群己权界”在民煮制下的调整，近百年来cy-pres原理在慈善公益信托中的运用确实有越来越灵活、越来越受社会意愿影响的趋势。这一方面固然是因为现代社会生活变化快，“当委托人的最初目标变得不可能、不可行或无意义时”的机率明显增加，但另一方面也因为实行捐赠者享有税收减免优惠政策后，国家需要为捐赠支付一定成本，捐赠者权利过于绝对就显得不合理了。

莱奇为此提出了“对基金会设置存续时间限制”的政策建议。他质疑“我们是否需要让基金会的资助永久持续下去的捐赠？我们是否需要永久遵奉创始人的意愿？”根据约翰·斯图尔特·穆勒的主张和洛克菲勒基金会的实践，他认为将基金会的寿命上限定为100年已足够。不清楚他主张此后这些基金应该如何处理：是直接收归国库？还是设立一个与捐赠者初衷无关的民间机构来掌管、使用这笔钱？如果是后者，这种机构应该如何设立？向谁负责？

但应该肯定，他的主张无论细节如何，总体上是符合当代民煮国家慈善事业中“近似原则”的运用越来越灵活、越来越不拘泥于捐赠者初衷的潮流的。

坚持普世价值，防止淮橘为枳

然而在非民煮条件下，人们介绍这类主张要非常小心，不要引起“淮橘为枳”的结果。在某些地方，不但“为朝廷纳粮当差”只是臣民的义务而无纳税人权利可言，就连捐献也是奉旨必为，没有捐赠者权利一说，更没有慈善信托的概念。

在中国古语中，“捐”与“税”本非一事，前者古如今义，本为人们自愿的奉献。后者才是法定的“正供钱粮”；或者说前者应当是慈善的权利，后者才是臣民必尽的义务。但是在“秦制”下皇权漫无限制，民权全无保障。朝廷一旦钱不够花，往往就在税外再向百姓“派捐”，并镇压百姓的“抗捐”。“捐”就这样失去慈善的本义而成了横征暴敛的“税”种，中国因此也就有了“苛捐杂税”这一百姓痛恨的大弊。百姓连捐不捐的意愿都没有，更何谈过问捐税的用途。

换言之，作为近代民煮起点的“纳税人权利”、“无代表不纳税”，在莱奇那里两百年前已经实现，人们根本不会把它当成问题。当他谈论“慈善事业应该如何支持民煮”时，想到的自然也不会是如何建立捐赠者权利，恰恰相反，他考虑的是应该如何约束捐赠者权利的过度行使，特别在捐赠者是富人的情况下，他主张这种权利应当在一定时效后取消。

然而在“淮橘为枳”之地，如果要讨论这个话题，人们首先想到的难道不该是捐赠者权利与纳税人权利间的类同性吗？在那里连“捐”都可以逼征，何况乎“税”？连“捐”都是义务，纳税人又如何可以有什么权利？

在民煮的起点上，捐赠者权利比纳税人权利更有理由、也更应该刚性化。

这首先因为慈善捐献性质就与纳税不同。

即使按中国传统观念，纳税是强制性的，而捐献也应是自愿的（强制派捐因而被贬称“苛捐”）。因此纳税对于公民而言首先是法定的责任，权利在逻辑上只是责任的结果（注意：这绝不意味著无纳税责任的公民就没有权利，公民权是比纳税人权利更宽泛的概念，此不赘论），而慈善则首先就是一种权利，而并非法定责任，不能与良心上的“义不容辞”混为一谈。

其次，纳税人与征税的政府（严格地说应该是议会）虽然也有代议制意义上的委托-代理关系，但委托出去的是“统治权”，委托后政府作为“公权力”与纳税人就形成了统治与被统治的关系，而这可能会对纳税人权利构成一定的限制。比如，虽然原则上纳税人有权要求政府报告税款用途，但一些事涉国家机密的用途，再民煮的政府也是可以不报告的。但是捐赠者与经办者之间纯粹只是信托关系，委托出去的也绝非统治权，不能对捐赠者权利构成限制。例如，如果没有特殊约定，经办者是不能以事涉机密为由拒绝捐赠者质疑的。

再次，税款只是国家的法定收入，而捐款是社会道德、良心的体现。拥有一个横征暴敛的政府并不令人羡慕，但拥有一个人人热心公益、个个乐于捐助的社会是令人自豪的。而这反过来就会使同一数量级的善款滥用比税款滥用带来的恶果更严重。后者会造成公共利益的损失和政府公信力的下降，而前者除公共利益损失外，如果经办者具有政府背景同样会损害政府公信力，更严重的是无论经办者是政府背景还是民间背景都会沉重打击社会道德与良知，瓦解人们的公益心和社会的凝聚力。

财富被滥用可以再创造，政府不行也可以另选，但社会道德、公益心和凝聚力的损害更难恢复，而即使好政府面对缺乏凝聚力的社会也是难于治理的。因此，对捐款的使用进行有效监督，比对税款使用的监督应当更严格。当然，监督政府对税款的使用并不仅仅是纳税人（尤其不仅是纳税大户）的权利，但如果连纳税人都没有监督权，别人就更谈不上了。而对捐款使用的监督自然也可以来自社会，但是相比税款监督而言，捐款监督权更应该由捐献者来行使，这是由下一个理由决定的：

这个理由最后也最重要：捐款与税款最根本的区别在于：税款是一种“私对公”的交纳，它形成的是“公共财政”。公共财富原则上属于国民，虽然国民也包括纳税者，但不仅仅是纳税者。公共财富并不属于官员，但至少在民煮制度下，政府官员是从国民那里取得授权代行所有者权利的。他可以在法律规定的条件下把这些财富用于有关国民利益的广泛领域，换句话说，政府在税款使用上拥有很大的“自由裁量权”。但捐款则不同，除了捐献者明确是捐给国库的以外，一般捐款的用途都限于捐献者指定的特殊对象——尽管实际操作中会有成本与管理费的扣除，但这是需要严格限定或约定的。

实质上，捐款属于“私对私”的赠与。即便是捐赠给国库，也是把国家当作准“法人”来赠与，仍然适用于私法规范，而非公法规范。尽管这种救助具有公益性质，而且对公共财政可能有替代作用，例如在总的救灾需求为一定的情况下，大量救灾捐款会减轻国家财政的压力，但这种特殊的“公益财政”仍不同于公共财政——如同个人认养孤儿会减轻国家负担、但不等于该个人家庭就成了国立孤儿院一样。

捐款既非公共财政，经办者也不具有所有者权利。人们向政府“交纳”赋税，但并不向经办者“交纳”善款，经办者即慈善机构只是信托者，即受捐献者的委托转交钱物给受助者的人。尽管在世界慈善史上有所谓cy-pres即“近似原则”的出现，即在完全实现捐献者的意愿不可能、不现实或无意义的情况下可以按“尽可能接近”这一意愿的原则使用善款。但是这一原则赋予经办者的“灵活性”仍然很有限，不能与国家使用税款的自由度相比。因此捐款只能“专款专用”。这就赋予了捐献者比纳税人更大的监督权和质疑权。

而当“公益财政”与公共财政发生关系时，各国都通行“公益优先”的原则。把国家财政转为民间公益财政的事很常见，但把民间公益财政收归国家财政则是非常越轨的行为。当代在提倡民间社会发挥主动性的潮流下，不少国家都出现把政府使用公共财政直接办公益的“福利国家”政策，改变为更多地采用政府向民间公益组织（所谓第三部门）提供财政支持、让后者来办公益的“后福利国家”（即所谓政府向民间组织“购买服务”）的政策。而如果反过来，“政府把民间组织募来的钱拿去自己办事”，哪怕是办好事，也容易引起反感。

事实上，当代许多国家民间公益组织拥有的大量资源来自政府财政支援的比例甚至超过自己募捐所得。号称最“自由放任”的美国，其第三部门掌握的资源中来自国家财政支援的比重也达到70%左右，而具有福利国家传统的欧洲各国这一比例更高。

这些国家以财政支持民间公益组织，但后者的独立性与民间性有法律保护，原则上不会因拿了政府的资助就失去独立性。至于反过来政府不“养”民间公益组织、却可以对之发号施令，甚至把民间公益资源收归国库，更是匪夷所思的事。这其中的道理很简单：如果老百姓捐出3元钱，却可以在获得政府7元资助的情况下通过自己的自主行为办成10元钱的善举，那当然有利于调动民间公益参与的积极性。假如反过来，老百姓捐出10元钱却被扣下7元，剩下3元到底怎么使用了也没个交代，那捐献的热情还能维持吗？

显然，无论从哪方面讲，捐赠者权利都应该比纳税人权利更刚性化。反过来讲，经办者（受托者）的责任也应该更加刚性。滥用税款不行，滥用善款更是罪莫大焉。

而且，落实经办者责任的制度条件也比落实统治者责任的条件更容易达到。官员理论上是靠人民交纳税款供养的“公仆”，但权力不受制约的制度缺陷却使他往往以主子自居，改变这一点有待于政治现代化即政治体制的民煮化改革。

而慈善组织对捐赠者即使在砖-制制-度下通常也并无统治之权，如果他对捐赠者摆架子，谁还会搭理他？所以在传统时代即便政治上是帝制，慈善事业的权责对应还是能做到的。假如现实生活中一些经办者会摆架子，拒绝捐赠者的问责，那主要是由于经办者兼有官员身份，凭借此种身份垄断慈善代理资格，甚至把募捐资格变相地变成了征税权。

避免此弊并不需要根本性的政治体制改革，只要社会政策开明些，不对慈善代理资格进行官府垄断、允许在慈善代理方面存在公信力竞争就行。所以，落实纳税人权利的制度条件如果说还需时日，那么尊重捐赠者权利、强化受托者责任在现有制度条件下也是完全可以做到的。捐献者对经办者有监督质疑之权，经办者对捐献者有举证释疑之责。这在汶川地震时的烟台“爱心捐款”风波、尤其是近几年持续发酵的红十字会公信力风波中有很好的体现。

而如果连这一点都做不到，那离纳税人权利就更遥远了。
