---
layout: post
title: 谎言与泡沫的代价
categories: Archive
date: 2020-01-28
tags: 切尔诺贝利
image_feature: "https://i.loli.net/2020/01/28/5m4wSosyV9Rj6cK.jpg"
description: “谎言有何后果？并非是我们会把谎言误认为真相，真正危险的是：我们听多了谎言便不再能分辨出真相。那时我们能做什么？除了放弃对真理的信仰，满足于谎言堆砌的故事，我们还剩下什么？”
---

来源｜[智本社（ID：zhibenshe0-1）](http://206.189.252.32:8083/%E8%B0%8E%E8%A8%80%E4%B8%8E%E6%B3%A1%E6%B2%AB%E7%9A%84%E4%BB%A3%E4%BB%B7.html)

作者｜清和  智本社社长

头图｜HBO热剧《切尔诺贝利》截图

---

![](https://i.loli.net/2020/01/28/5m4wSosyV9Rj6cK.jpg)

> “你闻到金属味儿了吗？”
>
> 1986年4月26日，凌晨1点23分。
>
> 苏联乌克兰，普里皮亚季[1]。
>
> 一阵巨响打破了深夜的宁静，一束绚烂的火光划破长空。所有人都被惊醒了，鸡鸣狗吠声不断。
>
> 接到电话的消防员瓦西里，立即穿好衣服奔赴火场。他的妻子望着远处的火光，不安地说：“这颜色看起来不对劲啊。”
>
> 瓦里西是第一批抵达现场的消防员，他们以为这是一次普通的救援，所有人都没有佩戴防毒面具。
>
> 现场警报声此起彼伏，一位技术员惊慌失措地跑进控制室大喊：“汽轮机大厅着火，堆芯爆炸了！”
>
> 副总工程师用奇怪地眼神看着他，然后故作镇定地说：“你脑子乱了，RBMK反应堆的堆芯不可能爆炸。”
>
> 有人提出质疑：“你尝到金属味儿了吗？”
>
> 副总工程师走出控制室，看到走廊上被震碎的玻璃和散落一地的石墨，但他拒绝承认这是一场灾难。
>
> 此时，一名消防员、瓦里西的同事，他的手开始剧烈疼痛，很快起泡腐烂。他这只手刚刚捡起过一块石墨碎片。
>
> 三公里外的普里皮亚季，被爆炸声惊醒的人们，走出家门欣赏这夜空上美丽的火光。小孩们在漫天飘落的颗粒中嬉戏打闹，情侣们走到一座桥上——最佳观赏点依偎。尘埃颗粒掉落在孩子稚嫩的脸颊上，情侣的发肩上，飘进了他们的口腔中。
>
> 他们全然不知，这美丽的火光，这雪花般的尘埃，是死亡的通知书。
>
> ——HBO热剧《切尔诺贝利》（2019年）剧情简介

这里正在爆发一场人类历史上最严重的核泄漏——切尔诺贝利事故。

当天晚上1点23分04秒，切尔诺贝利核电站第四号РБМК-1000型反应堆，电能供给反应堆的安全系统测试开始。因设计缺陷和技术员操作失误，反应堆出现异常。

1点23分40秒，技术员按下“紧急停堆”按钮。

7秒后，反应堆堆芯发生了连续爆炸。巨大的冲击力将反应堆上方1200吨重的穹顶瞬间击溃，燃烧的反应堆散发出剧烈的火光暴露在夜空之中，火花不断地向外喷溅，携带着大量核辐射粒子的尘埃，在空中随着热浪飘向广袤的城市乡村。

这些绚烂的火光，正是核泄漏导致的契伦科夫辐射。

可当时，与所有消防员一样，瓦西里认为这是一场普通的火灾。他让妻子别担心，自己很快就会回来。

“当时，我们新婚燕尔。即便是去商店，我们也会手牵着手一同前往。”消防员瓦西里遗孀回忆说。

“关上窗户，回床上去睡觉。反应堆着火了。我很快就回来。”

不过，瓦西里夫人并未等到丈夫回来。七点，她被告知丈夫在医院。

“他的肺和肝的碎片都从嘴里跑出来，他被自己的内脏呛到。我用绷带包着手，伸进他的嘴里，拿出那些东西。”

瓦西里及其夫人，只是千千万万个受害者之一。

在瓦西里最后的日子里，一天躺在病床上的他指着桌上一个大大的橙子，微笑地对妻子说：“我的礼物，拿去吧。”

护士在帷幕外对她比手势说不能吃。她拿起那颗橙子，瓦西里闭上眼——护士一直替他注射，让他入睡。

护士惊恐地冲她大叫：“你要知道，那不是你的丈夫了，不是你心爱的人了，而是有强烈辐射、严重辐射中毒的人。你如果没有自杀倾向，就理智一点。”

瓦西里夫人发狂似的说：“但是我爱他！我爱他！”

“他睡觉时，我轻声说：‘我爱你！’走在医院中庭：‘我爱你。’端着托盘：‘我爱你。’我记得在家的时候，他晚上都要牵我的手才睡得着。他习惯一整夜握着我的手睡觉，所以在医院里我也牵着他的手不放。”

——瓦西里遗孀口述，乌克兰记者斯维特拉娜·阿列克谢耶维奇的《切尔诺贝利的悲鸣》（2015年诺贝尔文学奖）

瓦西里夫人失去了理智，但她没有错，她深爱自己的丈夫。护士也没有错，恪尽职守。那么，到底是谁的错？意外，命中注定，还是必然？

切尔诺贝利城，这座五星级的小镇，在这场灾难中毁于一旦，沦为被废弃的“鬼城”。

这次灾难所释放出的辐射线剂量，是二战时期爆炸于广岛的原子弹的400倍以上。核辐射导致事故之后20年内9.3万人死亡，27万人致癌，250多万人身患各种疾病，其中包括47.3万名儿童。这些人身心煎熬，随时可能死亡。

当时的苏联最高领导人戈尔巴乔夫曾经语出惊人地说：“切尔诺贝利核事故可能成为5年之后苏联解体的真正原因，其重要程度甚至要超过我所开启的改革事业。”

切尔诺贝利事故，犹如一把尖刀，在苏联体国家及人民身上划下一道深深的伤口，刺破了那个历史性的谎言与泡沫，敲响了苏联第一声丧钟。

### 一、谎言政治：可怕的不是灾难，而是谎言

> “谎言有何后果？并非是我们会把谎言误认为真相，真正危险的是：我们听多了谎言便不再能分辨出真相。那时我们能做什么？除了放弃对真理的信仰，满足于谎言堆砌的故事，我们还剩下什么？”
>
> ——《切尔诺贝利》

![](https://i.loli.net/2020/01/28/dsNm3GICXHpMTA8.jpg)

<figcaption>HBO热剧《切尔诺贝利》剧情截图</figcaption>

2019年，HBO上映了《切尔诺贝利》，重新将人们的记忆带到那个历史性的悲剧时刻。

在编剧麦辛看来，《切尔诺贝利》不是一部影视剧，而是一个关乎人性、真理和谎言的真实故事，贵在追求真相。

“我们尽可能还原事件真相，选择最真实的部分呈现，我们没有为了让故事跌宕起伏而改变事实。对我们而言，这是一部关于真相的故事。”麦辛说道。

麦辛认为，人为失误是导致发生爆炸的主要原因——“只有人类才能让切尔诺贝利发生爆炸，也只有人类有能力解决该问题。那些成千上万寻求真相的人们是值得被铭记的。”

剧中，演员杰瑞德·哈里斯饰演**首席核电厂物理学家瓦列里·列加索夫。这是一个历史上的真实人物**。

事故发生后，列加索夫作为切尔诺贝利核事故调查委员会主任，冲到了最前面参与救援，并负责调查事故的真相。但灾难发生两年后，即1988年4月27日，他在自己公寓内上吊自杀了。

**当人们以为真相就此与核粒子一样埋入尘土时，一卷录音带牵出了爆炸的真实原因——反应堆设计存在缺陷**。

据他留下的录音带宣称，他向国际原子能机构的报告遭到了苏联有关部门的政治审查压力。他们甚至禁止，他提及发电厂操作员在事故前对反应堆的了解，以及当时已经知道的反应堆缺陷，并对其职业生涯造成了严重伤害。

爆炸发生的当天，普里皮亚季四五万人生活如常，他们并不知道三公里外的核电站泄漏，多数人觉得那是一场普通火灾。

早晨，官方没有通知事故，对前来问询的居民，官员也是草草应付，仅提醒居民关闭门窗，尽量留守家中。

当天恰逢周末休息日，大部分市民在家长安静地度过了一整天。镇上的购物商店照常营业，一些居民在街上散步、购物。在当地医生的坚持下，政府给居民发了放碘片，但并不及时。

爆炸发生几天后，苏联方面选择尽量隐瞒事故，乌克兰如期举行五月的一场大型庆祝活动。当时很多小孩在庆典广场参加，他们及家长却不知道自己正在暴露在核辐射之下。

此后乌克兰第一书记雪比斯基自杀，受核辐射污染人数至今都未公布。

苏联官方开始并没有重视此事。整个官僚体系麻木、失责而迟钝，事故瞒报错失最佳救援时间。

事故爆发后，即26日清晨，苏联能源部部长马约列茨通过电话向苏联部长会议主席雷日科夫汇报：

“核电站的核反应堆发生了爆炸，核电站的夜间密码警报显示‘1、2、3、4’，这四个数字标示了核泄漏、核辐射、火灾和爆炸……目前切尔诺贝利镇的事态仍不甚明朗，需要立即采取紧急措施。”

但是，苏联高层并未重视此事，将事故界定为“反应堆发生火灾，但并没有爆炸”。

根据戈尔巴乔夫回忆：“切尔诺贝利核电站爆炸的当天上午，苏共政治局就开会讨论局势，随后组织了一个政府委员会来处理事故后果。”

26日深夜，苏联部长会议主席雷日科夫又得到电话汇报：

“核电站4号机组的涡轮机组在进行非正式试验时，接连发生了两次爆炸，反应堆机房被炸毁，数百人受到核辐射，两人当场死亡，辐射情况非常复杂，暂时无法作出最后的结论……政府委员会已经按照各自的专业和分工分成若干小组开始工作，但必须派军队参与事故处理工作，急需大型直升机，另外还需防化部队，越快越好。”

但是，雷日科夫并未将事故的严重性告知戈尔巴乔夫。

戈尔巴乔夫在他的回忆录里描述了苏联科学院院长等官员，对此事故的轻视态度：“没什么大不了的。之前也有工业反应堆发生过同样的情况，他们都解决了。为避免核辐射，就需要多喝水、吃东西和睡好觉。”

委员会下辖的苏联科学院院士们赶赴了事故现场，掌握了第一手资料。列加索夫院士乘坐装甲车亲自抵临4号反应堆近距离观察，发现内部的石墨仍在燃烧，爆炸口的白色烟柱正在大量释放放射性物质。他意识到放射性物质扩散的危害性，坚持立即撤离普里皮亚季市的所有居民。

第二天上午11点，也就是爆炸发生后34小时，苏联当局开始启动首批撤离，超过1000辆大巴抵达小镇。直到下午两点，当局才宣布所有人彻底离开该镇。经过三个多小时，大约4万居民转移到了列斯格纳等镇。

为了避免恐慌，当局选择隐瞒事故真相，告诉居民没有发生严重事故，只要大家勤洗手即可。居民们以为只是暂时撤离，有些人在家门口留有“不要动我物品”的字条。然而，他们没有想到，这一去，此生不再复还。

事故发生48小时，当地政府才开始疏散半径范围10公里内的居民。很多人因为撤离太晚，受辐射患上了甲状腺癌，婴儿畸形率也因此大幅度提高。

爆炸发生后第二天，瑞典一位核电厂技术员惊讶地发现，周围空气出现了奇高的核辐射。丹麦、挪威、芬兰等国也检测到核辐射异常情况。此时，切尔诺贝利的核颗粒随着风飘到了欧洲其它国家，其中60%沉降到白俄罗斯，给当地带来极大的灾害。

28日，美国间谍卫星监测到切尔诺贝利发生爆炸。欧洲媒体大肆报道此事，瑞典核电站拿出调查报告质询苏联。苏联当局意识到已遮掩不住，便在28日晚9点，通过苏联电视台插播了一则短讯，报道此事。但此时距离事故发生，已经过去了67个小时。

**讽刺是，戈尔巴乔夫也是通过瑞典科学家的报告才得知此事的严重性**。

**苏联承认后，世界为之震惊！**

瑞典采取紧急措施，劝告市民停止食用新鲜蔬菜，尽量少外出，不饮用雨水。

奥地利政府将户外公园的沙粒全部铲除，以防止大气颗粒沉降到沙坑中污染玩耍的儿童。

此后一个星期，波兰、德国、奥地利、罗马尼亚、法国、比利时、荷兰、英国、希腊、土耳其、以色列、美国、加拿大，都陆续检测到程度不等的核辐射。切尔诺贝利遂即成为一件突发的世界性问题。

中国也为此惊出了一身冷汗。科学家每天紧张监测，几天后发现污染未进入中国。当时中国正在准备建设广东大亚湾核电站。受此事故影响，超过100万香港市民在反对建设该核电站的请愿书上签字。最后，高层出面协调才平复风波。

**令外星人感到震惊的是，最淡定的居然是苏联。**

![](https://i.loli.net/2020/01/28/7VeyrhYZlaLF16p.jpg)

<figcaption>HBO热剧《切尔诺贝利》剧情截图</figcaption>

事故爆发后整整一周，苏联政府没有对外透露过多的消息，甚至拒绝向苏联体国家提供完整的信息，导致白俄罗斯等国错估灾难后果。

苏联官媒还对外宣称：“破坏远远没有西方媒体说描述的那样严重”，“警惕西方势力破坏团结”。

一周后，叶利钦（后来的俄罗斯总统）对发布消息：“电厂附近的水库受到了污染，电厂周围辐射量就过高，不适于当地居民返回。”

此时，切尔诺贝利、普里皮亚季等居民才意识到，他们回不了家了。但为了避免恐慌，苏联当局依然拒绝将事故真相完全告知全体居民。

5月9日，核爆炸发生13天后，莫斯科照常举行卫国战争胜利的盛大庆祝活动。为了冲淡切尔诺贝利事故的负面影响，苏联当局故意粉饰太平，人为制造火爆的节日气氛。

然而，这场事故撕掉了苏联盛世强国的假面具，击碎了苏联人追求大国的金色迷梦。苏联体人民（尤其是乌克兰）发现，他们一直被政治的谎言和视生命如草芥的权力集团所蒙蔽。切尔诺贝利事故的伤痛以及恐惧，让他们不再信任“老大哥”，信念开始崩溃。

从此，这样的历史时刻，被界定为“切尔诺贝利时刻”。

事后，乌克兰第一副总理Konstantinl·I·Massik曾这样愤愤不平地总结事故发生之初苏联政府的对策：“大体上中央政府所采取的政策包括：首先是不措一切代价平息公众舆论；其次，为政府、各部及各部门进行开脱；第三，把损失的补偿减少到最低限度；最后是掩盖放射性对公共健康威胁的严重性。”

在爆炸后数月里，为了阻止核辐射继续释放，苏联动员了几十万人，在被炸毁的4号反应堆机房上方，修建了一座170米长、66米高的钢筋混凝土和钢板结构的“石棺”，以封闭住残留的近200吨放射性熔质，其中包括对人类而言极具危险性的30吨放射性尘埃。

石棺封顶后，为了表示庆功，他们在石棺上方插上了苏联国旗。

此后，乌克兰人需要实时监测石棺的危险指数，担心这个“恶魔”随时蹦出来。这座石棺的设计使用寿命是30年，三年前正好到期。

负责善后工作的“清理人”近些年在石棺上又加盖了一个巨大的拱形建筑——“穹顶”，以替代老化的石棺继续镇住这个特殊时代残留的怪胎。

阿列克谢耶维奇在《切尔诺贝利的悲鸣》中写到：战争时，每四个俄罗斯人中有一个人死亡；今天，每五个白俄罗斯人中就有一个住在受核辐射污染的地区，总数210万人，其中70万是儿童。切尔诺贝利事故辐射是白俄罗斯人口减少的最主要原因。受害最深的戈梅利和莫基列夫地区，死亡率比出生率高出了20%。

乌克兰境内有30万人死于放射病或因核辐射而诱发的其他疾病。欧洲已发现约20个受污染的“热点”地区，这些地区平均每平方公里的铯-137含量约为1居里，这种辐射级别在乌克兰境内有12处。

这次事故造成欧洲四分之三的土地被放射性物质铯污染。全欧洲遭受铯污染地区中：俄罗斯30%、白俄罗斯23%、乌克兰18.5%、芬兰4.8%、瑞典4.6%、挪威3%、奥地利2.4%、德国1.8%。

乌克兰、白俄罗斯都是老牌苏联体成员国。这次事故中苏联“老大哥”的表现，加剧了苏联内部分崩离析。切尔诺贝利事故后，戈尔巴乔夫与雷日科夫逐渐紧张，苏联高层政治逐渐四分五裂。

这一毁灭性的行为，加剧了欧洲世界对苏联的孤立和封锁。

戈尔巴乔夫在回忆录里这样描写1986年的苏联：“在我国社会和政府受到切尔诺贝利事故的巨大冲击之后，国家的财政状况使得情况变得更加复杂起来。石油价格下降到每桶10 - 12美元，这对我们的打击同样沉重。正当我们努力完成1986年 - 1990年的发展计划时，现金收入下降了三分之二。”

1991年12月25日，苏联国旗从克里姆林宫上空缓缓降下，一个不可思议的国家模式走到了尽头。

《大西洋月刊》评价麦辛的影视剧《切尔诺贝利》：该剧一半是历史剧，一半是对贬低真相严峻代价的研究。

一个庞大的谎言政治倒台，但苦难的切尔诺贝利人依然被政治谎言玩弄。苏联倒台后，当局承诺给予受害者医疗保障。

然后，1999年，这一承诺沦为废纸。

切尔诺贝利人努力抗辩，而一位官员却如此理直气壮地说：“您请看看，他们拿伟大卫国战争退伍老兵所享有的完备法律和法规的情况说事。现在这些老兵大多已经过世了，而当你们差不多都过世的时候，你们也将拥有一整套完备的法律。但现在，我们什么也帮助不了你们。”

### 二、泡沫经济：增长的不是财富，而是泡沫

> “大家先不忙努力走向苏联计划经济之路，那是一条通向奴役之路！”
>
> ——哈耶克

曾经，不少国家努力加入苏联体，他们甚至宁愿牺牲个人自由来换取国家保障。

但是，奥地利经济学家哈耶克引用本杰明·富兰克林的话——“那些愿意放弃基本自由来换得少许保障的人，既不配得到自由，也不配得到保障”，提出警告：“放弃个人自由，最终你无法获得自由，也无法获得保障”。

切尔诺贝利人不仅失去了自由，失去了保障，最终还失去了生命。

上个世纪三十年代，哈耶克与其老师米塞斯一起，跟奥斯卡·兰格、阿巴·勒纳就苏联计划经济问题展开了一场大论战，史称“兰格论战”。

苏联垮台，代表着苏联计划经济的失败。但令现代人没想到的是，当时经济学界公认，兰格在这场论战中胜出。

在整个三十年代，西方国家陷入大萧条不能自拔，凯恩斯主义、国家主义、纳粹主义以及俄国计划经济势力快速崛起，很多学者逐渐抛弃了自由主义思想。甚至罗素、维特根斯坦、熊彼特、爱因斯坦等世界级巨擘都相信“中央计划经济可能是未来人类社会发展的一个必然趋势”。

哈耶克在1940年代初也不无感叹道：“社会主义已经取代自由主义成为绝大多数进步人士所坚持的信条”。

哈耶克的老师米塞斯一身傲骨、疾恶如仇，一生都在与集权、谎言作斗争。

二战期间，德国纳粹势力破坏米塞斯，米塞斯逃离奥地利，几经波折才流亡美国。在美国，他备受排挤，米塞斯甚至找不到一份能够养活家庭的全职工作，一度住进了贫民窟。二战后，英国人的大救星丘吉尔在连任竞选时使用了哈耶克的自由主义主张，结果大受批判，疯狂掉粉。

这就是三四十年代欧美世界的逆自由主义潮流。

苏联在第一个、第二个五年计划中取得了巨大的经济成就，与大萧条泥潭中的欧美世界形成鲜明对比。二战后，苏联作为抗击德国法西斯的主力，风头一时无二。苏联计划经济，误导和迷惑了不少经济学家。

到了五六十年，美国和苏联经济都持续快速发展。但到了1960年代末，苏联持续扩张的计划经济陷入财政危机。不过，1970年代的世界石油危机爆发，国际油价大涨，苏联依靠规模巨大的石油出口得以续命，赚取了大量外汇，摆脱了财政危机。

1970年代，美国经历了20世纪最早糟糕的十年国运：布雷顿森林体系崩溃，美元失去绝对统治地位，历经三次贬值，德日崛起构成挑战；石油危机后，经济陷入长期滞胀，联邦政府和经济学家束手无策；军事上陷入越战泥潭，国内反战浪潮高企。

此时，苏联正好处于勃列日涅夫时代。苏联趁机对北约势力全面出击，以欧洲为战略重点，向第三世界发起猛烈攻势，对美国形成了压制态势。

苏联以举国体制搞生产，以运动式的方式大规模造城，让一个国家的经济规模和外在实力快速膨胀。

**乌克兰境内核电站，正是在1970年代苏联强势时代开始建造的**。上世纪70年代，苏联在切尔诺贝利市郊18公里处建造了乌克兰境内的第一座核电站。**切尔诺贝利核电站，被认为是苏联扩张，以及抵御北约势力的重要堡垒**。

除了核电站，苏联仅用16年的时间就将切尔诺贝利建设成为一个“五星级”模范城镇——苏联体内能买到香奈儿五号香水的寥寥数地之一。这座几万人的小镇，公寓、医院、学校、游乐场、公园等基础设施齐全，在核电站爆炸前刚刚建好一座摩天轮。

然而，**这座耗资巨大的核电站，以及这座仅用16年就建造而成的美妙新城，却在44秒被核爆炸毁于一旦，彻底沦为阴森恐怖的废墟和“鬼城”**。

这无疑是苏联经济模式的典型写照和悲哀归宿——一个看似无比强大、无所不能的巨人，突然轰然倒下。

哈耶克与兰格论战时向世界大声疾呼：“大家先不忙努力走向苏联计划经济之路，那是一条通向奴役之路！”

**苏联经济本质上是一种经济武装政治的模式**。苏联假以国家之名，利用计划的手段，运动式地快速堆积经济规模，以服务于快速膨胀的政治需要。

经济供养政治的模式最终会走向财政崩溃的死胡同，因为政治本身并不产生经济效益，即不存在增量，而是存量博弈。

当财政难以为继时，必须对外扩张依靠掠夺来实现财政正收益。苏联的军工产业占到了经济的70%，农业、轻工业、商业等其他产业仅仅占了30%。庞大的军工产业很难产生收益，唯一的盈利方式就是对外扩张。

从古至今，斯巴达、纳粹德国、日本法西斯，最终都走上了侵略道路。

二战爆发后，苏联与德国联合瓜分波兰，侵占波兰以及东部部分国家，将爱沙尼亚、拉脱维亚、立陶宛强行并入苏联，此后还爆发对芬兰的战争。对外扩张，强行剥夺苏联体成员国，以吸血的方式供养庞大的苏联政治机器。

1965 - 1979年苏联军费开支增长了3倍以上，平均每年递增8%。从1972年开始苏联军费开支世界第一，超过美国军费的20%以上。

苏联继续对外扩张、四面出击，直接出兵十万占领阿富汗，入侵捷克斯洛伐克，开启代理人战争模式——支持印度入侵巴基斯坦，支持越南进攻柬埔寨，支持古巴干涉安哥拉内战，介入索马里和埃塞尔比亚的战争。

国民经济武装军事，全力支持与苏联政治扩张；政治扩张以及掠夺，又反哺经济衰退以及财政亏空。

但是，这种模式，反人类、反人性，也违背经济规律，终究不可持续。这只看似庞大的八爪鱼，实则内在空虚，最终因内部分崩离析而崩溃于泰山之巅。

或许，最开始，人们的愿望是好的，试图采用计划手段、国家体制实现平等和富裕。

但实际上这违背欧洲人都明白的常识：“总是使得一个国家变成人间地狱的人事，恰恰是人们试图将其变成天堂”（诗人赫尔德林）。

哈耶克对此发出振聋发聩之语：“用通向天堂的美好愿望来铺设一个国家通向地狱之路”。哈耶克甚至引用希莱尔·贝洛克《奴隶国家》的观点——“一种新的奴役形式在我们面前兴起”。

试图用计划的方式替代私有产权实现财富自由平等，显然是不现实的。在论战中，哈耶克提醒人们不要忘记了“私有制是自由的最重要的保障，这不单对有产者，对无产者也是一样的”。他提出：“没有私有产权的法律保障，就没有个人自由，也没有经济自由”。

在没有私有产权的苏联经济体中，谁为经济负责？谁为企业负责？谁为切尔诺贝利的安全负责？以国家之名负责，国家又是何物？

**在苏联经济模式中，所有人都相信国家、企业强大无比、牢不可破。就像所有人都认为，切尔诺贝利不会爆炸，因为它背后是一个强悍的苏联体。**

切尔诺贝利的建造以及所有计划经济，不是来源于市场，也不是来源于当地需求，而是服务于苏联。当时乌克兰是苏联体的船舶等军工制造基地，供养着几艘航母及编队，需要大规模的电力供应。因此，切尔诺贝利服务于苏联体军事。

所有人都将信任交给苏联体这个国家机器，但是公众没有人想到的是，这个国家机器里面居然充满着谎言政治和泡沫经济。

这里面，所有人都服从于权力而不是客户或公众，没有一个人会担心国家破产、企业破产，没有人会对公众的信任和寄托负责；经济不断供养政治、军事，国家财政走向枯竭、赤字，政府依靠印刷货币来供养财政，以此透支民众信任。

事故爆发后，掌权者试图隐瞒以维护国家机器的信任和权威。在救援现场，消防员仅身着普通的防火布制服、头盔和手套，居然没有防毒面具。最悲剧的是，他们不知道这是一场核泄漏事故。作为核电站的消防员，他们对核泄漏救援知之甚少，几乎没有接受过核泄漏救援训练。

苏联先后在各加盟国动员了超过60万人参与善后，这些人中大量没有接受过防核训练的普通军人被派出前往充满危险的核污染地域作业。

苏联体的切尔诺贝利核电站，从上到下，没有人真正对生产、盈利及安全负责。

在国家主义的巨大泡沫之中，所有人都麻木了，失去了竞争，失去了警惕，甚至失去了思考。

当核泄漏爆发后，这个国家主义的泡沫被刺破了，当权者相互推诿、遮遮掩掩，大多数人目瞪口呆、手足无措。

无奈之下，只能找“替死鬼”及“逆行英雄”，来混淆视听、蒙混过关，实则又添悲剧。

在这场经典的论战中，除了产权理论，哈耶克和米塞斯从多角度论证苏联经济模式存在的致命缺陷。

奥地利学派认为，信息分散在市场的每一个体之中，没有任何一个人、企业、国家可以搜集完整的信息，然后合理配置资源。哈耶克根据信息分散理论，提出苏联政府不可能获得完整的市场信息，然后给出足以使市场需求恰好等于供给的产品“出清”价格。

市场是一个价格发现程序。什么价格成交，只有市场双方才知道，苏联政府不可能知道。如此，苏联的计划经济则无法达到资源的高效配置。

哈耶克后来将其与兰格的论证写成了一本书叫《通往奴役之路》。这本“自由主义宣言”在德国法西斯败退之时出版，立即风靡全球、一时洛阳纸贵。

米塞斯则从经济计算的角度指出苏联经济的致命弱点。

他认为，**苏联经济根本问题在于，缺少用货币进行的核算**。这一致命缺陷的结果是苏联经济体内，经济建设中的简单问题都将变得无比棘手，即无法对生产方式中不同方法的赢利进行计算。

简而言之，供给和需求被计划，缺乏真实的市场交易，市场无法计算价格，企业无法计算成本与盈利，整个国家实际上是本糊涂账。

所以，米塞斯的结论是，简单化的、理想化计划经济不会带来秩序和效率，只会带来停滞和混乱。在回忆录中他写道：“我本想做一名改革者，但我却变成了一位崩溃的历史记录员。”

米塞斯在1973年去世并未记录到苏联计划经济的崩溃，但他的预言成真。1974年，75岁高龄的哈耶克取得了诺贝尔经济学奖。此时，凯恩斯主义因滞胀危机而倒台，苏联进入全面攻击模式。

到了八十年代，苏联经济快速衰退，经济供给政治模式走到尽头，财政危机爆发，政府依靠印刷货币透支国本，接着通货膨胀爆发，经济陷入混乱，政治出现分裂。

事实上，苏联计划经济下的国家投资边际收益率持续走低，民收入增长率50年代平均增长10.3%，60年代平均增长6.8%，70年代平均增长4.9%，80年代经济增长率继续下跌，到90年代则出现负增长。

1980年代开始，里根改革成功，美国稳住了美元霸主地位，开始联合中东产油国压低油价，对苏联进行经济封锁，导致苏联石油收入锐减，经济受到严重冲击。

而苏联的经济供养政治模式只能依靠对外扩张来“吸血”，而此时苏联内部开始瓦解，以无力对外扩张获得增援。再加上，切尔诺贝利事故的打击，苏联在1980年代末进入瓦解通道。

随着赤字不断加剧，苏联抛售了240吨黄金，货币改革失败，国内物价大幅度上涨，生活物资短缺，饥寒交迫的民众和部分政客蠢蠢欲动，最终在内部击溃了这个的历史性泡沫。

1991年，苏联解体。这一年，哈耶克获得美国总统自由勋章，以表扬他“终身的高瞻远瞩”。次年，哈耶克去世。

哈耶克以93岁的生命，熬死了纳粹德国，等到了凯恩斯主义下台，在生命最后时刻还亲眼看到了苏联解体，一生亲自见证自己所有的预言成真。

### 后记

消防员瓦西里被转移到莫斯科一家医院治疗，他受到了1600伦琴的核辐射，远远超过了400伦琴的致死量，护士把他称为“一个核反应堆”。

在护士看来，瓦西里夫人每天坐在“一个核反应堆”面前简直是送死。但是，瓦西里夫人一刻也不想与丈夫分开。

有一天晚上，瓦西里说：“我好想看我们的孩子，不知道他好不好。”

“我们要替他取什么名字？”

“你自己决定。”

“为什么我自己决定？我们有两个人。”

“这样的话，如果是男孩，就叫瓦西里；如果是女孩，就叫娜塔莎。”

此时，瓦西里夫人已有六个月身孕，但她不能确定宝宝在她肚子里是否还安全。

第二天，克比诺克和帕维克下葬，他们身前与瓦西里一家是好朋友。就在爆炸前一天，他们与瓦西里一家在消防局门口拍了一张合照。那天大家都很开心，那是美好生活的最后一天。

瓦西里夫人参加完葬礼后匆匆从墓园回来，马上打电话到护理站问：“他怎么样？”

“他十五分钟前死了。”

……

参考文献：

[1] 《切尔诺贝利》：最真实的恐怖，菁菁，新周刊；

[2] 重返切尔诺贝利，凤凰网特别策划；

[3] 《切尔诺贝利》，麦辛，HBO；

[4] 通往奴役之路，哈耶克，中国社会科学出版社；

[5] 自由宪章，哈耶克，中国社会科学出版社；

[6] 社会主义，米塞斯，中国社会科学出版社；

[7] 切尔诺贝利的悲鸣，阿列克谢耶维奇，花城出版社。

本内容为作者独立观点，不代表虎嗅立场。未经允许不得转载，授权事宜请联系hezuo@huxiu.com
