---
layout: post
title: 贺建奎手稿独家披露：中国首例基因编辑双胞胎遭受了什么？
categories: Archive
date: 2019-12-04
tags: 基因编辑
image_feature: "https://i.loli.net/2019/12/08/SpQfYyBRwgWn8hX.jpg"
description: 近日，贺建奎的一份未经发表的手稿流出，更多关于基因编辑婴儿事件的细节浮出水面。《麻省理工科技评论》独家披露了这份手稿的信息，中文内容为 DeepTech 与丁香园合作呈现。
---

原文来自公号「丁香园」：~~[贺建奎手稿独家披露：中国首例基因编辑双胞胎遭受了什么？](https://mp.weixin.qq.com/s/Z_2FgVsF3MP2ej2P33z0tw)~~

作者：Antonio Regalado

---

近日，贺建奎的一份未经发表的手稿流出，更多关于基因编辑婴儿事件的细节浮出水面。

基因编辑婴儿的父母对此是否充分知情？有多少人参与了这次试验？这项研究是否通过伦理审查？研究人员是否充分考虑了试验可能对编辑婴儿造成的负面影响？……

《麻省理工科技评论》独家披露了这份手稿的信息，中文内容为 DeepTech 与丁香园合作呈现。

今年早些时候，一位消息人士给《麻省理工科技评论》发来了一份贺建奎未发表的手稿，这份手稿披露了去年诞生的首例基因编辑婴儿的情况。现在，我们将首次公开这份手稿的部分内容。

在作出这一决定前，《麻省理工科技评论》咨询了十余位专家的意见。他们意见不一，但共同点是，所有人都反对在学术期刊上发表这篇手稿，但都想亲眼看看它。

**这篇手稿长达 4699 个单词，名为《基因编辑 HIV 抗性双胞胎》，作者正是原南方科技大学副教授贺建奎，他创造了这对基因被编辑过的双胞胎女孩。我们收到的第二份手稿也讨论了人类和动物胚胎的实验室研究。**

手稿中的数据显示，贺建奎曾经在 2018 年 11 月下旬编辑了这两篇论文的草稿，看起来与他最初提交出版的内容相同。当然，也可能存在一份合并了两篇论文内容的手稿。这两份手稿曾经过权威期刊 _Nature_ 和 _JAMA_ 审议，不过没有发表。

在第一篇论文中，充满了对于 「可以控制 HIV 流行」的医学新突破的描述。该研究称 「新疗法」可以「成功」（成功一词在论文中被多次使用）让双胞胎对 HIV 产生抗性。

**令人惊讶的是，这篇论文关于双胞胎确实能对 HIV 产生抵抗力的论证却很少。**此外，这篇文章基本上忽略了论文中的其他数据，而这些数据恰恰证明基因编辑出现了问题。

《麻省理工科技评论》分别与一位法律专家、一位体外授精专业医生、一位胚胎学家和一位基因编辑专家分享了这些手稿，并询问了他们的意见。

**他们的反馈是负面的：**

*   **贺建奎和他的研究团队提出的关键声明并没有得到数据的支持；**
*   **基因编辑婴儿父母可能是在受到压力的情况下同意参加实验；**
*   **基因编辑行为带来的所谓医学上的获益是可疑的；**
*   **研究人员在还没有完全弄清楚基因编辑可能造成的影响之前，就已经开始进行胚胎编辑。**

由于这些文件涉及到有史以来最重要的公共利益问题之一，即利用技术改变人类遗传的能力，我们在此提供手稿的内容节选、相关专家的评论与疑问。

本文中手稿节选摘录顺序与手稿中呈现顺序一致。

![](https://i.loli.net/2019/12/08/SpQfYyBRwgWn8hX.jpg)
<center>四位评论者照片</center>
## 1. 为什么这篇论文的作者中没有医生？

手稿一开始就列出了包含 10 位作者的名单，大部分人来自南方科技大学贺建奎的实验室。里面也包括了帮助招募受试者的艾滋病感染者互助平台「白桦林全国联盟」的负责人白桦，以及正在接受莱斯大学审查的美国生物物理学家 Michael Deem。

![](https://i.loli.net/2019/12/08/lF4jIJNexZfEMSH.jpg)
<center>截图来自贺建奎手稿（下同）</center>
对于一个如此重大的研究来说，这份名单上的作者显然只是一小部分人，还有一些人的名字被遗漏了——特别是治疗病人的生殖科医生和接生婴儿的产科医生。隐瞒这些信息可能是为了保护病人的隐私，然而，这也让人怀疑，这些医生是否意识到他们正在帮助创造世界首个基因编辑婴儿。

因此，这份手稿的可信度受到了部分专业人士的质疑。

**斯坦福大学法学教授 Hank Greely：**_没有独立的证据能够证明这份报告的真实性，虽然我相信这些婴儿可能是经过 DNA 编辑后出生的，但几乎找不到相应的证据。鉴于这些情况，我不认为贺建奎会是个诚实的人。_

## 2. 研究人员的数据并不支持他们的观点

在手稿的摘要部分阐述了该项目培养人类 HIV 抗性的目标及主要结果。该报告称，研究小组成功地复制了一种名为 CCR5 的基因突变。天生携带这种变异基因的少数人群对 HIV 具有免疫能力。

![](https://i.loli.net/2019/12/08/JTEx4vRL1gwfZtC.jpg)

但是论文中的数据却远远不够支持摘要中的内容。具体而言，这个研究团队实际上并没有复制已知的突变，而是创造了新的突变，而新突变不一定能对 HIV 产生抵抗力。根据报告上的说法，他们也从来没有检查过这点。

**加州大学伯克利分校创新基因组学研究所基因组编辑科学家 Fyodor Urnov：**_他们声称自己复制了流行的 CCR5 基因突变，但这是对实际数据的公然歪曲，这种行为无疑是「蓄意的谎言」。这项研究表明，研究小组并没有复制 CCR5 基因突变，因此，「对人类胚胎进行基因编辑能帮助数百万人的说法」是十分离谱的妄想。_

**尤金集团科学主任 Rita Vassena:** _研究这份文件时，我本希望看到对人类胚胎基因编辑的反思，以及经过仔细钻研得出的基因编辑方法。然而，它实际上更像是一个寻找目的的实验，它试图找到一个理由，来为不惜一切代价在人类胚胎中使用 CRISPR/Cas9 技术的行为辩护。**它不是严谨、仔细思考、循序渐进的人类基因组编辑方法。从目前的科学共识来说，以怀孕为前提的人类胚胎 CRISPR/Cas9 编辑，既不合理也不必要，因此不应该继续进行。**_

## 3. 对胚胎进行基因编辑来「控制 HIV 流行」的想法是荒谬，特别是在受影响最严重的国家

作者在摘要的结尾和正文的开头，试图证明其研究的合理性。他们认为，对婴儿进行基因编辑可以拯救数百万人免受艾滋病毒感染。我们的评论者称这种说法是「荒谬的」和「可笑的」，并指出就算 CRISPR 能够创造出抵抗 HIV 的人，在 HIV 猖獗的地方比如非洲南部，这种方法也不太可能实用。

![](https://i.loli.net/2019/12/08/xQncbFSGj4lM3zg.jpg)

**Rita Vassena:** _这项工作几乎没有为人类胚胎的基因编辑和胚胎移植提供任何理由。作者所谓的，对胚胎进行编辑并孕育也许有一天能够「控制 HIV 流行」的想法是荒谬的。公共卫生倡议、教育和广泛使用的抗病毒药物已被证明可以控制艾滋病的流行。_

**Hank Greely:** _认为这种方法可以「控制 HIV 流行」的想法看起来很荒唐。如果世界上的每个婴儿都被赋予这种变异（几乎不可能），那么在 20 至 30 年内，它将开始大幅影响 HIV 感染，但是到那时，我们应该有更好的方法来遏制艾滋病的流行——而且现有的一些方法已经大大减缓了艾滋病毒的传播，即使这些方法还不够成熟。_

## 4. 基因编辑婴儿的父母可能因为其他原因参与项目

根据论文中的叙述，这项技术通过清洗精子来实现去除病毒，是行之有效的。但是，在婴儿的 DNA 上使用 CRISPR 并不是为了防止他们从父亲那里感染艾滋病毒。

相反，编辑的目的是让孩子在以后的生活中对 HIV 免疫。因此，这个实验并没有给父母或孩子提供明确的、直接的医疗益处。那么，为什么这对夫妇会同意呢？其中一个原因可能是为了获得辅助生殖的帮助。

![](https://i.loli.net/2019/12/08/1QhcbW74pNHa5nu.jpg)

**Rita Vassena:**

_我感到担忧的是，这对夫妇中的丈夫提供的这种基因是呈艾滋病毒感染阳性反应的。人们可以想象，这对夫妇同意接受这种对其自身和子女的健康没有任何改善，反而具有潜在风险的手术，是承受了不必要的情绪压力。_

_但值得记住的是，艾滋病毒感染不会像遗传病一样世代相传。通过预防措施，如用合适的药物控制病人的病毒载量，并在体外受精过程中小心处理配子，可以非常有效地避免传染。_

_目前的辅助生殖技术可以确保艾滋病毒抗体阳性的男性和女性安全生育，避免横向 (在伴侣之间) 和纵向 (在父母和胚胎 / 胎儿之间) 传播，因此这种情况下胚胎编辑是没有必要的。_

_事实上，参与实验的这对夫妇确实进行了这样的辅助生殖手术，包括长时间清洗精液以去除其中的艾滋病毒。这种精子清洗技术已经在世界范围内的体外受精实验室和数以千计的病人中使用将近 20 年了。根据经验，这对父母和他们未来的孩子都是安全的，而不需要对胚胎进行侵入性操作。_

**Shady Grove Fertility 中心的生殖内分泌学家 Jeanne O’Brien：**_在中国社会，感染艾滋是一种很大的耻辱。尽管对家庭和社会负有生育义务，但艾滋病患者没有机会解决生育的问题。进行临床研究的社会背景是有问题的，它针对的是一个脆弱的患者群体。这项研究是否为一个社会问题提供了基因治疗？这对夫妇是否受到过度强制？_

## 5. 这种基因编辑与天生携带 HIV 抗性的基因突变不同

研究人员描述了 CRISPR 实际上对双胞胎所做的改变。他们从试管受精胚胎中取出一些细胞来观察它们的 DNA，发现敲除 CCR5 的基因编辑确实已经占据了主导地位。

尽管科学家「期望」通过编辑使基因失活从而获得 HIV 抗性，但他们没法确定这一目标是否达成。因为编辑虽然和天生携带的 CCR5 基因突变相似，但并不完全相同。

此外，只有一个胚胎编辑了 CCR5 基因的两个拷贝（分别来自父母）; 另一个只编辑了一个拷贝，充其量只有部分 HIV 抗性。

![](https://i.loli.net/2019/12/08/Q4ULjuzg2GSA8DM.jpg)

**Hank Greely:** 

_**所谓的「成功」证据并不确凿。**相反，胚胎或胎儿产生的新变异，其影响尚未明确。同时，对艾滋病毒的「部分抵抗」究竟意味着什么？有多大比例？这是否足以证明科学家可以将携带 CCR5 突变的胚胎移植到子宫里，来进行分娩呢？_

## 6. 可能还有其他意料之外的 CRISPR 编辑

CRISPR 并不是一个完美的工具。当我们试图编辑一个基因时，基因组的其他地方可能产生意想不到的变化。贺的团队说他们只发现了一个「脱靶」的情况存在。

然而，这项研究并不完整，手稿也掩盖了一个关键点：研究人员从早期胚胎中提取的任何细胞，并没有对双胞胎的身体做出实际贡献。那些可以繁殖并成长为双胞胎的胚胎细胞可能也会「脱靶」，但在母体怀孕之前并没有办法明确这一点。

![](https://i.loli.net/2019/12/08/ni6xBcAabrMewFJ.jpg)

**Fyodor Urnov:** _这种歪曲实际数据的行为简直是赤裸裸的谎言。从技术上来讲，如果不对每个细胞进行检查，我们就不能确定一个经过编辑的胚胎是否存在脱靶情况。这是整个胚胎编辑领域的关键问题，然而作者们把它掩盖了。_

## 7. 治疗这对夫妇的医生可能并不了解真实情况

包括《华尔街日报》在内的各种新闻媒体都指控贺建奎团队通过调换血液样本欺骗医生，而且并非所有医生都知道自己参与了基因编辑婴儿。如果这是真的，那么这就是一个问题，因为医生的职责就是做对病人最有利的事情。

![](https://i.loli.net/2019/12/08/WMpfQt2N6XaZxT7.jpg)

**Jeanne O’Brien:**

_无论 CRISPR 是否用于基因组编辑，所描述的试管受精程序都遵循同样的步骤和时间线。进行辅助生殖操作的中国医生可能并不知道孩子父亲的 HIV 阳性情况或者胚胎经过基因编辑。在授精的时候，贺建奎只需要一个愿意操作的胚胎学家来注射 CRISPR。贺建奎的评论似乎表明，实施体外受精的医生并没有参与随后移植哪些胚胎的决定。_

_这对参与辅助生殖操作的医生来说是一个警钟：科学和技术将继续进步，绝望的不孕夫妇可能会忽视未知或相信技术已被证明是安全的。**一旦医生知道这是在移植胚胎前进行生殖细胞编辑，实质上就是在确认这项改造对于父母和未来孩子的安全性——问题是，操作的医生是否能对此充分知情？**_

## 8. 手稿歪曲了孩子出生的时间

到目前为止，一些媒体报道和熟悉这项研究的人已经确定这对双胞胎出生在 10 月，而并非 11 月。为什么贺建奎团队记录了一个错误的日期？这可能是为了保护病人和双胞胎的隐私。在中国这么大的国家，每个月可能会有一万多对双胞胎出生。伪造日期可能是为了使他们的重新鉴定更加困难。

![](https://i.loli.net/2019/12/08/AYfTrUkiZDK1wjI.jpg)

## 9. 目前还不清楚该试验是否经过合格的伦理审查

这篇手稿关于伦理学的讨论极其简短，根据手稿内容，这项研究已经在中国临床试验注册中心（[http://www.chictr.org.cn](http://www.chictr.org.cn) ）登记。然而，这一试验是在基因编辑的双胞胎真正出生后才完成登记的。

![](https://pic3.zhimg.com/80/v2-9aa356256a98ef89c6e5ac63d211119e_hd.jpg)

**Hank Greely：**

_试验是什么时候注册登记的？答案是在 2018 年 11 月 8 日，在基因编辑婴儿出生后、他们对外宣布基因编辑婴儿出生前不久，这可能是为了增加文章被接受发表的可能性。这不是一个正常的临床试验登记行为。也许这个试验经过了伦理审查许可——尽管那家医院否认了这一点。谁说的是真的？我们可能永远无法得知。_

_在文章中「我们被告知」了关于全面伦理审查的说法并不是非常有力的证据，这篇文章也没有讨论中国禁止为 HIV 阳性父母提供辅助生殖服务的问题。据报道，贺建奎曾让其他男性冒充接受辅助生殖服务的男性，以便通过必需的 HIV 检测。尽管这篇手稿并没有这么说，但这很可能是真的。如果消息属实，这就意味着贺建奎欺骗了中国的监管程序。_

## 10. 在真正改造人类前，研究人员并没有测试这项 HIV 免疫技术是否有效

在手稿中，研究小组概述了他们的计划：从双胞胎身上采集血液，检测被编辑的细胞是否具有 HIV 抗性。然而，这是他们在真正制造基因编辑婴儿之前就该弄清楚的事情。在移植胚胎前，他们可以先将胚胎冷冻，同时在实验室细胞中进行相同的编辑，并且测试 HIV 对这些细胞的影响。

![](https://pic2.zhimg.com/80/v2-69e2f2be5fdc1d2cfe67f3c84cfcc321_hd.jpg)

**Fyodor Urnov：**

**_这份声明证明，研究小组把他们的利益置于捐赠胚胎的夫妇和他们未来的孩子的利益之上。手稿中没有任何证据支持经过编辑的 CCR5 基因能够保护细胞避免 HIV 感染。_**

_然而，在移植胚胎之前就弄清楚这一点是极为必要的。研究人员可以使用一种已知的化验方法来实现这一点：现在实验室中对免疫细胞进行相同的基因编辑，然后引入 HIV 病毒感染细胞，理论上来说，应该只有携带 CCR5 突变的细胞才能存活下来。_

_然而，他们选择直接用经过基因编辑但并不明确其功能影响的胚胎制造婴儿，这些研究人员是不是操之过急了？难道他们根本不在乎吗？无论他们如何解释，这种违反基本道德准则和研究准则的行为几乎等同于犯罪。_

## 11. 美国的诺奖获得者可能帮他证明了其实验的正确性

手稿中还有一个令人意外的结论，它为这项研究的继续提供了一个全新的理由——贺将该项目与非洲 HIV 流行的核心因素联系了起来。文章指出，许多未感染 HIV 的孩子（其母亲感染 HIV）患上了「HEU 综合征」，这使他们更容易受到各种儿童疾病的影响。文章认为，基因组编辑可能是对抗「HEU 综合征」的一种「新策略」。

![](https://pic3.zhimg.com/80/v2-b3b4adbc66517272451f6dc48108ee3a_hd.jpg)

虽然目前还没有任何证据支持这个观点，但有一些线索可寻。在 2018 年 11 月 22 日贺建奎发给马萨诸塞州大学医学院生物学家 Craig Mello（Mello 当时也是贺建奎其中一家公司的顾问）的一封电子邮件中，他感谢 Mello 在这个问题上的建议，并附上了上图中同一段论文内容。

这是否意味着 2006 年诺贝尔医学奖得主 Mello 为论文贡献了一个关键的想法？Mello 很早就被告知了双胞胎计划，但是，他的一位发言人说，他从来没有就如何写这篇文章给过贺建奎建议。然而，根据贺的电子邮件，任何这样的互动都不会被承认。「我不会告诉人们你知道这里发生了什么，」他写信给 Mello。

## 12. 该项目还有其他支持者，但缺少关键信息

手稿最后有一份致谢名单，根据贺的说法，这份名单上的人在浏览了手稿后给了他直接的反馈或建议。根据手稿中对参与文章「修订」人员的致谢名单，他提到了加利福尼亚大学的研究人员 Mark.Dewitt。Dewitt 没有回复邮件，但根据他早些时候的解释，他说他警告过贺的这个项目。斯坦福大学的伦理学家 William Hurlbut 说，他给贺提供了伦理学建议，但不知道这位中国科学家创造了孩子。

他还要感谢 W.R. "Twink" Allen，一位英国的马繁殖专家，以及 Allen 曾经的学生 Jin Zhang，或称 John Zhang，他现在是纽约新希望生育中心的负责人。该中心是美国最大的生育中心之一。据报道，去年年底，Zhang 计划与贺一起开办一家提供基因编辑婴儿的医疗旅游公司。

![](https://pic3.zhimg.com/80/v2-e44a88091b38766fd3408bfae336d15e_hd.jpg)

在这些名字中，只有 Allen 的名字是首次出现。Allen 没有回复记者的电子邮件。那位不愿透露个人信息的 Zhang 告诉我们，他对手稿并不熟悉。「我从来没有见过手稿」，他在 10 月份告诉《麻省理工科技评论》。

我们现有的双胞胎手稿版本缺少两个通常出现在科学论文中的、至关重要的部分。首先，是谁资助了这个项目，或者作者在此项目中是否存在经济利益。另一部分是，缺少每个作者的详细的科学贡献，这意味着文章没有明确描述非中国籍作者、莱斯大学的 Micheal Deem 的角色。

Deem 的角色性质 (尤其是任何与病人有关的实际参与) 决定了他或其所在大学可能面临的处罚。Deem 的律师没有回答问题，也拒绝提供过去的陈述记录，目的是为了弱化他在研究中所起的作用。Rice 说，他们的调查正在进行中。

## 13. 研究人员忽略了基因编辑不统一的证据

在所谓的「补充」材料中，论文附上了贺建奎此前公开展示过的图表。这是一份研究团队在试图分析 CCR5 基因编辑情况时，测量基因编辑双胞胎的胚胎和出生组织（脐带和胎盘）中 DNA 序列的色谱图。

一些其他的专业人士发现，这些数据表明这些胚胎是「嵌合体」，这意味着，胚胎中的不同细胞接受基因编辑的方式不同。宾夕法尼亚大学基因编辑专家 Kiran Musunuru 指出，在色谱图中可以发现多次基因编辑的存在，即在特定的 DNA 位点能看到几个不同读数在重叠的信号中被记录下来。

![](https://pic2.zhimg.com/80/v2-fed8be85e0654cc2adf4ed4c6e7f5fc9_hd.jpg)

这些数据意味着，这对基因编辑双胞胎的身体可能混合了是经过不同方式编辑细胞产生的嵌合体，也可能根本不是。**Musunuru 指出，这意味着只有部分细胞有可能具抗 HIV 的功能，这也意味着有些细胞中的「脱靶」编辑没有被检测到，这可能会导致潜在的健康问题。**

贺建奎已经从此前的实验动物胚胎发现嵌合体可能存在的问题。既然胚胎确实存在这方面的缺陷，贺建奎为什么还要继续后续的研究，这是基因编辑婴儿试验中的一个谜团。

在他的手稿中，并没有解开这个谜题。手稿仅有「已经对所有 DNA 样本进行深度测序，以检查 CCR5 基因编辑嵌合体问题」，并没有对表格中发现的问题进行任何解释，也没有承认这些表格数据可能提示了嵌合体的问题。

**Fyodor Urnov：**

_他们本该通过持续反复的努力，把嵌合体的可能性降低到接近于零，但他们彻底失败了，然而研究团队依然选择了把后续试验继续推进下去。_

**本文翻译部分由丁香园合作完成** 译者：陈以寒、唐雨昕、傅平凡、杨媛、刘昱、史晨瑾

本文首发于微信公众号：DeepTech 深科技（ID：deeptechchina）作者：Antonio Regalado，授权丁香园发布