---

layout: post

title: 婴儿「封针」调查：一家三甲医院的脑瘫治愈神话｜大象公会

categories: Archive

date: 2019-10-21

tags: 封针

image_feature: "https://i.loli.net/2019/10/23/5GC7PUaZtwSfiV4.jpg"

description: 封针，全称为「位点加穴位药物注射疗法」，10分钟，70次注射，疼痛和「神药」一起扎入孩子身体。

---

原文来自微信公众号「偶尔治愈」（to-cure-sometimes）授权「大象公会」：~~[婴儿「封针」调查：一家三甲医院的脑瘫治愈神话](https://mp.weixin.qq.com/s/Z-t2t1YIcYu8_siwNnxkbw)~~

作者：刘楚

---

![daxianggonghui](https://i.loli.net/2019/10/23/pHAVG19M7QBw3Wa.gif)

10分钟，70次注射，疼痛和「神药」一起扎入孩子身体。

文｜刘楚

刘雅宁每天要在这条康复前街穿梭两次，骑着踏板电动车载着 6 岁的儿子，从街头的一家语言康复机构到街尾的一家小儿口腔按摩教室，目睹年轻父母脸上无处可藏的焦虑，仿若 5 年前的自己。

网上流传着一句话：读懂了康复前街，就读懂了郑州的「人间世」。位于郑州市二七区的康复前街，是当地最拥堵的老街之一，盘踞着 3 家三甲医院和若干大大小小的儿童康复训练机构。

雅宁在这条街上，听过许多患儿的故事，最常被提及的两个字是「封针」。

**封针，全称为「位点加穴位药物注射疗法」，主要流行于河南省及广东佛山等地。**

这种在网络上被打上「残忍」标签的疗法，连同它的发明人，郑州大学第三附院医院（河南省妇幼保健院，下简称三附院）儿童康复科名誉主任万国兰一起，成为走过康复前街的患儿、尤其是脑瘫或是疑似脑瘫的患儿们求医经历中绕不开的高墙。

![郑州大学三附属医院](https://i.loli.net/2019/10/23/5GC7PUaZtwSfiV4.jpg)

*郑州大学第三附院医院（河南省妇幼保健院）、解放军总医院第三医学中心（原武警总医院）、郑州大学第五附属医院均聚集在郑州市二七区康复前街上*

## 绝望的家长与挣扎的孩子9 月，在儿童康复科病房见到艾云的时候，她正抱着刚满一周岁的儿子天天站在病房走廊里。

这是天天的第三个封针疗程，天天的入院原因是肌张力高。

肌张力指的是「肌肉的张力」，过高或高低都不好，孩子肌张力高会感觉绷着，低了又感觉很无力。

大多数脑瘫儿的肌力是降低的，痉挛型脑瘫肌张力增高、不随意运动型脑瘫肌张力变化。因此，肌张力高被认为是脑瘫的一种表征。

孩子诊出肌张力高，艾云同丈夫连忙辞去了工作，经老乡介绍，来到了省城，在三附院住下，开始了漫长的封针之路。

![病房走廊](https://i.loli.net/2019/10/23/elqO6p8PkwGFI71.jpg)

*郑大三附院儿童康复科的病房走廊*

「偶尔治愈」以患者家属的身份，在艾云的帮助下，亲眼目睹了一次封针的场景。此前，从未有过封针的片段被流出。

多名家属提及，封针是不允许拍照录像的，至于为什么，医生没解释过。

> 那个场面，如果被拍下来播出去，肯定就炸了。
>
> 也就是小孩疼痛不敏感时才能这么扎，这要是大人，扎两下肯定就受不了了。

家长们这么认为。

![孩子哭](https://i.loli.net/2019/10/23/9pMFD6oVJ8AHdeu.jpg)

*约10分钟注射针头扎入几十上百次，治疗室充斥着孩子的哭声*

早上 10 点不到，穿着拖鞋的女人们陆续抱着孩子来到治疗室门口等候，此起彼伏的哭声就再也没有停止过。

治疗室的小床上，清一色被剃光了头发的患儿被一名医生和 四五名家属团团围住，几乎不留缝隙。

家属负责控制患儿，医生则拿着装满药水的注射器穿过大人手的缝隙，在挣扎的婴儿身上的特定部位扎入拔出，扎入拔出。平均 3-5 秒扎一次，每扎4、5 针换一支注射器。

从头部开始，然后是后颈、四肢、腰部，一次封针患者需要被扎入几十至近百针不等，持续时间 10 分钟左右。

封针过程中，除了控制和安抚婴儿，家属还需手里拿着棉花球，随着医生针头的移动，迅速黏在孩子被扎针的部位。

因此，结束后被抱出治疗室的婴儿大多顶着一脑袋的棉花球，血斑隐隐约约，脸上挂着泪，有些已经哭得没了声。

![正在封针](https://i.loli.net/2019/10/23/ANGnW4SQ9cBfkJ1.jpg)

*正在封针，家长们负责控制住挣扎的孩子以及用棉花球止血*那天上午，艾云的丈夫几乎就没有出过封针室，帮助着各个病友家庭。

在病房里充斥着一种感觉：所有人都能感受到孩子的痛苦，但却不得不这么做。

艾云和其他家属间流传着一个故事：曾有一个会说话的患儿，用稚嫩的声音对医生说：

「叔叔，我求求你了，求求你，不要用针扎我」。医生不忍心，最后让家长出院了。

![回病房](https://i.loli.net/2019/10/23/rBds8l95fnoNUp4.jpg)

*封针结束后的孩子被抱回病房，脑袋上顶着止血的棉花球*

治疗室门口等待中的一个稍大的孩子也在做无力的抗争。

引起大人们注意是因为这个孩子关闭了妈妈点亮的手机屏幕，妈妈再打开他又关闭……只是一个劲儿的扯着妈妈的衣服然后摇头，嘴里含糊着「不要不要」，那神情几乎就要哭出来了。

「他怎么手机都不要了？是因为要封针吗？」有人问。

「嗯，一到门口就要走，知道是来封针的，不肯封针。」妈妈无奈地说。

再绝望的哭声，再心痛的父母，都没能阻止封针的进行，因为到这里来的人们相信：忍一时之痛，孩子病能好总是值得的。

## 脑瘫治愈神话

![医护人员](https://i.loli.net/2019/10/23/EpFMPaKOkWbg9AY.jpg)

*三附院宣传材料显示，在被封针治愈过的患儿中，不乏来自俄罗斯、中国台湾等地的患儿*

封针到底有什么魔力？

三附院的宣传文章称：

三附院儿童康复科的创始人、名誉主任万国兰创立的「位点加穴位药物注射疗法」，让脑瘫从不治之症变成了可治之症，挽救了数以万计的患儿，填补了国内空白。
甚至有因重症脑炎造成的几十个植物人，也被（封针）成功唤醒，重获新生。

![三院官方](https://i.loli.net/2019/10/23/sQEKd7NGJ8VnZ4H.png)

*三附院官方微信文章称封针「让脑瘫从不治之症变成了可治之症」*

资料显示，万国兰，1950 年生，河南汝南人，1974 年从北京医科大学毕业，1992 年首创了用「位点加穴位药物注射疗法」来治疗脑瘫，俗称「封针」。

![万国兰](https://i.loli.net/2019/10/23/gUxbwT4mWOYicEI.jpg)

*万国兰（资料图片）*

2018 年，万国兰获得河南省「最美医生」提名奖，她在媒体采访视频里称，1991 年开始利用针灸、按摩治疗脑瘫，但是效果不好，从 1992 年开始尝试「封针」。

「其实周围的人都说太冒险，老同志说西方国家 100 多年就定性为不治之症了，弄成还行，弄不成别人会笑话，（为此）我查了很多资料……」

结合 2011 年一篇媒体专版报道，万国兰的灵感来自一本外文医学专著，她想到：「如果通过针灸给予脑瘫患儿的大脑一定的强刺激，就有可能激活这些『睡眠』和受损的神经细胞，恢复大脑功能！」

工作之余，她买来了鸡、鸽子进行动物实验，之后又在自己身上的人体试验，并经常把自己扎得「血流不止」。

![媒体报道](https://i.loli.net/2019/10/23/Xdf1T4zyWgwZDFu.jpg)

*媒体报道中对于万国兰发明封针过程的描写*

1992 年 10 月，万国兰开始把这种新方法投入临床使用，并将其命名为「位点加穴位药物注射疗法」。

封针的疗效如何？

在万国兰发表的一篇回顾性研究论文中，显示三附院儿童康复科从 1997 年至 2002 年诊治的 381 例脑瘫患儿，通过维生素 b 1、b 12 加生理盐水稀释，同时进行穴位和位点注射，总有效率高达 97.1%，其中「正常化」 190 例。

![论文截图](https://i.loli.net/2019/10/23/tVqnBKTSiv19O3N.png)

*论文截图*

对于正常化的描述是：运动、姿势、日常生活活动能力、社会适应能力，与正常同龄儿无明显差异。

换言之，近一半的脑瘫儿通过封针治疗恢复正常。

对此，拥有 27 年经验的儿童脑瘫治疗专家、上海壹博医生集团发起人、中国医师协会功能神经外科专委会委员孙成彦教授表示，「目前通过临床治疗脑瘫患儿能够接近常人，可以说有很好的改善，但绝不可能说正常。」

一直到今天，现代医学专家仍然认为脑细胞的死亡是不可逆的，因此脑瘫仍然无法治愈。

孙成彦补充，「成为正常人，也就是临床治愈的概念。但是脑瘫是不能提治愈的，这样会误导病患和家属。脑瘫临床治疗结果，只能陈述改善或好转，（这）才是准确的表达方式。」

论文中，三附院儿童康复科为何能得到如此高的有效率？孙成彦分析称：「要么就不是脑瘫，要么是评价标准不够严格」。

在「偶尔治愈」接触的七八组家长中，唯一确诊为脑瘫的患儿依依，不仅没有治愈，还曾遭到拒收。

5 年前，李梅千里迢迢从广东抱着女儿依依第一次去三附院儿童康复科的门诊时，因病情严重直接被拒绝接收，她哭着跪着求医生，最后重新挂号换了个医生才住进了病房。

依依在三附院的一个半月里，每次封针，李梅都请其他家属帮忙「止血」，因为她始终没办法面对孩子的挣扎和哭声。

「我最对不起女儿的就是送她去封针，眼泪都流干了，其实一点儿用都没有」。

最终，在封针治疗一个半月后，依依因癫痫发作终止治疗。当李梅提出，依依的癫痫是否是由于封针引起时，却被主治医生告知：「你孩子病情这么严重，癫痫是迟早的事情。」

## 凡凡的偶然与必然

同样后悔的还有 27 岁的新手爸爸关晓航。半个月内，穿梭于三附院的两个科室，他经历了最无助的时刻。

5 个月前， 6 个月大的凡凡仍不会翻身。在浙江儿童医院儿保科发育行为科就诊后，医院称，凡凡的智力和运动评估落后于正常孩子 3 个月左右，需要进行功能训练等小儿康复治疗。

因检测出乳酸高，医生还让凡凡做了串联质谱分析，后来，关晓航才知道，那是一种新生儿遗传性代谢疾病的筛查方法。

如果想在杭州的几家儿童医院进行康复训练，都需要提前 1 个月到半年时间预约。

医生建议也可家庭康复，定时复查，孩子的爷爷却等不及了，到处打听哪里能做小儿康复，有亲戚提到了郑大三附院。

亲戚家小孩因肌张力高被要求封针治疗，并在治疗后「发育良好，只是语言能力稍弱」。

那是关晓航第一次听到封针。

与许多河南农村家长一样，商丘宁陵县的这家人对省城这间三甲医院的权威深信不疑。

而且，关晓航在网上轻松地挂到了三附院儿童康复科的主任医师朱登纳教授的专家号，当天，一家人就坐上了去郑州的火车。
去到三附院，专家门诊、办理住院、第一次封针在同一天都完成了。

「入院第一天，还没有做什么检查，就直接封针了。」关晓航现在回想起来都觉得不可思议。

他不是没有犹豫。

网上搜索时，这位父亲看到过很多关于「封针」的负面信息。

![网络批评](https://i.loli.net/2019/10/23/mr9lv3ePph6YfcV.jpg)

*微博上一些母婴博主曾多次公开批评封针疗法*

住院当天，这位父亲仍在犹豫，他问住院主治医师张广宇，能不能不做封针，只做康复训练，医生说可以。

然而，在那个病房里，放眼望去，每个家长都在给孩子做封针，难道他们不是为了孩子好吗？

天平倾斜过去，关晓航妥协，凡凡接受了包括封针在内的康复治疗，一做就是四个疗程，每个疗程 10 针（次），约 21 天。

关晓航回忆，一开始只扎头，后面开始扎头、后颈、腿、胳膊、腰部，「一次差不多扎 70 针左右。」

> 9 月 2 日，凡凡开始第四个疗程的治疗。
>
> 9 月 13 日，做完第九次封针后，主治医生突然通知他们办理出院，一家人在院外住下，开始往返医院。
>
> 9 月 14 日，低频脉冲治疗、电子生物反馈疗法。
>
> 9 月 15 日，脑电治疗、电子生物反馈疗法、低频脉冲治疗。
>
> 9 月 15 日夜，凡凡紧急住进了三附院的神经内科病床——「间接发热 5 天，全身乏力 7 小时，口角歪斜 1 小时」，后被诊断为脑梗塞。

![凡凡突发脑梗](https://i.loli.net/2019/10/23/HfSYrQDuWLwK4jP.jpg)

*凡凡突发脑梗的诊断证明（受访者供图）*

脑梗塞又称缺血性卒中、中风、脑梗死，是指因大脑血液循环发生障碍，导致大脑缺血缺氧发生坏死的疾病。常见于中老年患者，小儿脑梗的发生概率极小。

儿童康复科大科主任兼凡凡所在的脑八科主任、现三附院副院长朱登纳在近日的一次医患沟通中对此解释，「脑梗有很多病因，比如外伤、感染、血管、先天代谢疾病等，但目前为止什么病因还没有找出，甚至说以上都排除的情况下得了脑梗，也是有可能的。」

目前，在排除了感染和血管因素后，因检出乳酸升高，医生高度怀疑凡凡的脑梗是由于先天代谢疾病导致，但这需要等基因检测结果出来后才能确认。

一切仿佛回到了 5 个月前，浙江儿童医院医生在凡凡查出乳酸高，开始做串联质谱分析筛查先天代谢疾病的时刻。

关晓航悔不当初，「当初就不应该听我爸的去郑州，治疗了半年，钱花了不说，孩子封针受罪。」

事实上，凡凡第一次在三附院的住院诊断是脑损伤综合征，以及疑似先天代谢疾病。一个疗程结束后的出院小结上，主治医生就以串联质谱分析报告结果无异常为由排除了先天代谢疾病。

近日，「偶尔治愈」致电凡凡在儿童康复科的主治医生张广宇，他解释称凡凡刚入院时未见到乳酸高的检测结果，「且治疗后孩子情况一直在好转」。

对于为何在第四个疗程让凡凡提前出院，张广宇以正在忙为由挂断了电话。

![出院记录](https://i.loli.net/2019/10/23/mz8sCvxUnRSDXgl.jpg)

*凡凡第一次封针疗程结束后，疑似先天代谢疾病被排除（受访者供图）*

于是，像大多数被诊断为「脑损伤综合征」的患儿一样，凡凡在三附院接受封针治疗，直到突发脑梗。

在朱登纳的沟通解释中，儿童康复科患儿发生脑梗这样严重的病情，「这么多年是第一次见」。

凡凡被描述成一个偶然事件。

从依依到凡凡，从癫痫到脑梗，是否与封针有关，我们并不清楚。唯一确定的事实就是：

在三附院这间全国规模最大的脑瘫康复中心，几乎所有的患儿都「不同程度」地接受着封针疗法——一项至今缺乏循证医学证据的小儿创伤疗法。

## 口口相传的「治愈」

![baby](https://i.loli.net/2019/10/23/TQI2O5sGypMEJVt.jpg)

*图片来源：站酷海洛*

李梅记得，在依依好不容易住进了三附院儿童康复科病房后，却发现病房里的孩子大多不是脑瘫，「一些看起来很精神的孩子也被送进来」。

艾云同一个病房里，三个孩子都是因为肌张力高住进来的。除此之外，脑损伤综合征、缺血缺氧性脑病也是常见的病因。

关晓航带着凡凡在康复科里治疗了 5 个月，遇到的真正的脑瘫患儿也只有少数。

今年6月的媒体报道中，朱登纳表示，目前脑瘫患儿仅占科室住院患者的 30 % ，其余的患儿包括：智力障碍、全面性发育迟缓，甚至「脑炎、脑外伤、脑出血等疾病恢复期和后遗症期、骨关节病、脊髓损伤、遗传代谢性疾病等数十种疾病都在我们收治范围之内」。

曾经，在三附院儿童康复科门诊，雅宁半岁左右的儿子壮壮也被诊断为肌张力高，轻微脑损伤，医生建议立即住院封针治疗。

「一边是省妇幼医生的亲口诊断，一边是网上的负面评价」，雅宁决定再挂个号，换个医生看看。

这一次，医生却诊断出与上次不同的结果：孩子肌张力并不高，但仍有脑损伤综合征。不过，治疗建议却是一样的——住院封针。

然而，对于壮壮和凡凡都曾被诊出的「脑损伤综合征」，著名儿科专家、北京协和医院儿科主任医师鲍秀兰向「偶尔治愈」表示，「并不存在（这种疾病分类）」。

多年来，鲍秀兰的儿童门诊接诊过不少在外地被诊断为肌张力异常、有脑瘫风险、需要康复治疗的孩子，到了北京一诊断发现肌张力都正常，并不需要过多干预。

鲍秀兰解释说：婴儿在母胎里是蜷着腿的，出生时肌张力本身就高，之后会随着时间有规律地下降，「有些人（医生）不懂怎么判断肌张力，如果怀疑是脑瘫，一定要有明确的脑损伤，没有脑损伤的就不是脑瘫。」

中国脑性瘫痪康复指南 2015 年版中指出，脑瘫诊断的必备条件应当具备以下四项：中枢性运动障碍持续存在、运动和姿势发育异常、反射发育异常、肌张力及肌张力异常。

儿科主治医师郑启城更是多次在微博反对「封针」，他告诉「偶尔治愈」，这几年里，接诊过不少来自河南的家长，曾在当地被诊断为有脑瘫风险，进行封针治疗。

治疗期间，家长不忍孩子受苦，中断封针来到北京看门诊，结果发现智力、运动评估指标都正常，不需要康复治疗。

还有一些在河南当地被诊断出肌张力高的孩子家长，通过网上问诊咨询到郑启城，最终没有选择去医院康复，「现在孩子长大了，也都证明了当初肌张力高是没有问题的」。郑启城说，超过100个类似河南案例是肯定有的。

如同前文提到的凡凡那位在三附院治疗的亲戚家的孩子，究竟是因为治疗而恢复了健康，还是当初的肌张力高本就「没有问题」，几乎是个无法厘清的问题。

然而，在没有循证医学证据，是否真正的「治愈」至今搞不清楚的情况下，三附院儿童康复科从万国兰创立时的十几张床位发展到 2019 年的 11 个住院病区、2 个康复训练区、1 个中医康复区、600 张床位……

![蓓蕾楼](https://i.loli.net/2019/10/23/aUPwBi7GvSzMuef.jpg)

*三附院儿童康复科最早的蓓蕾楼，如今已发展至11个住院病区*

媒体报道中，27 年间儿童康复科诊疗患儿愈 12 万人次，挂牌河南省小儿脑瘫康复治疗中心、河南省脑瘫儿童康复医院、河南省 0~6 岁残疾儿童筛查评估中心、河南省儿童脑瘫康复质量控制中心……

原三附院儿童康复科主任医师李湘云，回到家乡登封市，作为封针联合创始人成立了郑州市第十六人民医院儿童康复学科；而在三附院的一墙之隔的五附院，儿童康复科的主治医师赵鹏举也同样来自三附院，这间以自闭症治疗著称的医院，偶尔时不时地传出一些关于「封针」的故事。

5 年前，拿着两份均包含「脑损伤综合征」的不同诊断，结局却都是封针治疗的医嘱，雅宁丢掉了住院单，抱着儿子离开了三附院。

直到 4 年后，通过基因检测，壮壮才终于找到了病因，确诊为天使综合征，也称安格曼综合征，是一类母系单基因缺陷的罕见病。

## 脑瘫诊疗乱象中的盛宴

「面对这样的儿科医疗环境我能干点啥？」郑启城在微博写道。

后来他还以「肌张力增高是个坑」为关键词，发了一系列案例，呼吁家长不要焦虑。

「偶尔治愈」回访了其中几名家属，发现他们都提到「煎熬」和「焦虑」。

一位孩子 3 月龄被儿保科诊断出肌张力高的河南家长说：「最煎熬的是知道孩子肌张力高，却什么也不做。每天都在焦虑之中，担心万一真的有问题就错过了最佳治疗时间。」

「北京就没有这种情况，河南的家长好像特别容易被有脑瘫风险吓唬到」，郑启城说，小儿康复的过度诊疗在河南已经形成了一种奇怪的氛围。

![郑启城微博](https://i.loli.net/2019/10/23/WFBVb6zONYUuqyR.jpg)

*儿科医生郑启城微博上公布的案例*

而对于真正的脑瘫患儿来说，三附院更像是走投无路时的一根救命稻草。

5 年前，依依被老家、广州好几家医院告知「治不好，抱回去好好养着」时，李梅懂那种「什么也不能做」的痛苦。

> 当听说三附院能治脑瘫时，就想为我女儿花钱，不然觉得对不起她。

最后，李梅离开郑州时，留下的，除了封针时依依的惨烈、癫痫发作的痛苦，还有近 10 万元开销。

多名家长提供的账单显示，每个康复疗程的医药费几乎相当，2 万元左右，异地患儿家庭通过转诊医保报销后约 1 万元的自费，郑州本地家庭报销比例较高。

脑部肿瘤专家杨学军曾经说过，「难治的疾病，一定会成为伪科学的盛宴」。这句话放在脑瘫治疗中同样适用。

2018 年有媒体报道，脑瘫医疗乱象，让人「瘫上加瘫」。

河南驻马店市一位脑瘫患儿的家长曾反映：「现在治疗儿童脑瘫的办法真多，又是神经修复、手术治疗，又是药物、康复训练等，还有医院搞干细胞移植，弄得我们东奔西跑给孩子治病，钱没少花，病也没治好。」

对此，国内知名脑瘫专家、郑州大学博士生导师兼河南政府参事高晓群教授就曾公开呼吁，建议有关部门加强对脑瘫医疗机构的整治与监管，同时建议小儿脑瘫家庭一定要科学甄别，切莫病急乱投医。

高晓群总结称，目前在医疗市场上针对脑瘫患者的治疗乱象有两大类：一类是神经营养药物；二是近年出现的大肆宣扬和过分夸大的神经干细胞移植治疗。

接受过封针治疗的家长对神经营养类药物并不陌生，鼠神经生长因子和神经节苷脂、复方脑肽等药物，在医疗账单中占据一定比例。

这一类被称为「辅助用药」的神经营养类药物，因缺乏循证医学证据，在业内广受诟病。

这些药品价格昂贵，一百多元一支，通过医生回扣等营销手段，长期以来占据着国内药品销量排行榜的前列，不仅浪费了医保基金，也给患者家庭带来了很大的负担。

![20种西药的销售额](https://i.loli.net/2019/10/23/weGlFEYzR1W75dB.jpg)

*国家版「重点监控合理用药药品目录」20种西药的销售额。图片来源：丁香园insight*

今年 7 月，国家卫生健康委员会正式公布了第一批「重点监控合理用药目录」，要求医疗机构严格控制目录中的药品处方量。

封针患儿账单里的多个神经营养类药物纷纷上榜。

究竟从何时开始，封针的药水从万国兰时期的维生素混合生理盐水，变成了鼠神经生长因子和神经节苷脂、复方脑肽等神经营养类药物已无从考究。

不过，就在「国家第一批重点监控合理用药目录」发布的几个月前，三附院儿童康复科主任医师牛国辉、朱登纳等人刚刚联合发表过一篇为鼠神经生长因子「站台」的论文，想通过对照试验来论证这种神经营养类药物确实能改善痉挛型脑瘫患儿的运动功能。

![](https://i.loli.net/2019/10/23/cCMQhEXWUpfGqj6.jpg)

*论文截图*

文章称，研究者于 2013 年 9 月到 2015 年 9 月间从三附院、商丘市第一人民医院、新乡市中心医院门诊和住院的痉挛型脑瘫患者，招募了符合招募标准的患者 900 例，进行随机分组。

最终得出的结论，穴位注射鼠神经生长因子配合功能训练、推拿等综合康复治疗，比肌肉注射、对照组疗效好，且不良反应少，安全性高。

前神经内科医生、现制药企业资深从业者柯楠看过论文后直言，“临床试验的试验设计、终点定义、样本量计算等部分，文章描述都含糊不清，不符合国内外临床试验管理的指南、法规要求。而且由于临床试验严格的操作标准、质量要求，这样的试验速度、参与研究科室的工作量有点难以想象。”

换言之，论文整体的可信度在业内人士看来比较低。

没有人知道三附院迄今为止一共给脑瘫患儿开过多少张「神经营养类药」的处方单，对于那些特殊儿童家庭来说，这类药物只是他们走过的坑里夹带的泥点。

从今年 5 月起，在三附院儿童康复科的 4 个多月，关晓航一家就花了近 10 万元，如今积蓄早已花光，凡凡的治疗却仍不得不继续。

在凡凡突发脑瘫住进了神经内科病房之后，关晓航多次联系原先的主治医生张广宇询问病因，但等来的只有原先封针病友群里已被张医生踢出群聊的提醒。

（文中柯楠为化名；除关晓航外，文中的患儿和家属均为化名。文中插图未注明出处的均为刘楚摄）  

参考文献：

[1] 牛国辉,朱登纳,袁向东,宋舜意,王军,王鑫,赵云霞,王明梅.注射鼠神经生长因子对痉挛型脑瘫运动功能的改善作用[J] 中国实用神经疾病杂志,2019,22(6):591-598.

[2]万国兰，朱登纳，孙莉，李湘云.位点加穴位药物注射治疗脑性瘫痪患儿疗效分析[J].中国临床康复,2004,8(21)4280-4281.

[3]《「封针」治疗小儿脑瘫 数万名患儿父母展笑颜》    大河报

http://newpaper.dahe.cn/dhb/html/2011-01/10/content_449401.htm

[4]郑州大学第三附属医院儿童康复科介绍

http://www.zdsfy.net/Class/144.html

[5]《郑大三附院儿童康复科：孩子们的康复乐园》大河报

http://newpaper.dahe.cn/dhjkb/html/2018-06/26/content_257421.htm

[6] 唐久来等. 中国脑性瘫痪康复指南 (2015): 第一部分[D]. 2015.

[7] 《郑大三附院（省妇幼）品牌专业解读——小儿脑瘫康复治疗中心之三折翼天使在这里重新“起航”》大河报

http://newpaper.dahe.cn/dhb/html/2014-11/19/content_1180091.htm

[8] 《退休名医万国兰：妙手神医巧治脑瘫，且行善事不求回报》河南健康网

[9] 《走进最美医生 —记郑州大学第三附属医院（省妇幼保健院）儿童康复科创始人万国兰教授》

[10] 《创造无数康复奇迹 点燃家庭幸福希望—郑大三附院（省妇幼）儿童康复中心仁心妙手助患儿重新起航》郑州晚报

[11] 「神药」还是「安慰剂」？细数神经节苷脂的前世今生》丁香园

http://neuro.dxy.cn/article/549470

[12] 《脑瘫患儿康复的乐园—记郑大三附院（省妇幼）河南省小儿脑瘫康复治疗中心》大河报

![](https://i.loli.net/2019/10/23/xcREnwGouSl4P9Q.gif)
