---

layout: post

title: 历史上的一页：第一批非洲留学生为什么离开中国？

categories: Archive

date: 2019-08-28

tags: 非洲留学生

image_feature: "https://i.loli.net/2019/08/30/69OKQivIj73yaTs.jpg"

description: 1960年，中国政府从非洲国家招募了100多名学生，但大多数非洲留学生在北京生活了一年多以后不但要求回，甚至发起罢课和绝食，和中国官方发生冲突，最后如愿回到非洲。

---

原文来自公众号「孙立平社会观察」，作者 程映虹

---

作者：程映虹（美国特拉华州立大学教授）

来源: 《凤凰周刊》

1960年，随着越来越多的非洲国家取得独立，中国政府第一次向非洲学生提供奖学金，从一些非洲国家招募了100多名学生来到北京，从旅费到生活费用全部包了下来。但大多数非洲留学生在北京生活了一年多以后不但要求回，甚至发起罢课和绝食，和中国官方发生冲突，最后如愿回到非洲。

这些非洲留学生为什么在中国“留”不下来，甚至不惜和待他们“不薄”的中国政府闹翻也要回去？整整50年过去了，大陆方面至今还没有公布任何材料。本文根据当时“领头闹事”的加纳学生伊曼纽尔·约翰·海维（Emmanual John Hevi）出版的《一个非洲学生在中国》（An African Student in China）和对他的电话采访而成，也参考了其他一些材料。作为一名非洲学生的骨干分子，海维对当时中国社会和政治的描述，对今天的人认识那个时代仍有一定意义。

## 海维：一个非洲意识强烈的加纳人

海维出身于英属黄金海岸（1957年独立后称加纳）一个种植可可的农夫家庭。在殖民地的教育系统中，除了英文，他还学习了法文和德文。他没有上过大学，但以高中毕业文凭在中学教过科学，尤其是医学课程。1960年11月他前往中国北京医学院学医（先在北京语言学院学几个月的中文），按学制他要在中国大陆学习七年。但是，从一踏上红色中国开始，海维对当时日益极左的社会就产生了消极印象，直到形成整体看法后，他在中国待了一年就离开了。

加纳是非洲第一个独立国家，其领袖恩克鲁玛当时在非洲独立运动中地位崇高，言行在非洲有一定的示范作用。恩克鲁玛在建国后，很快就和社会主义国家尤其是中国建立了密切关系，开始模仿中国的制度和发展模式。海维的非洲本土政治意识非常强烈，他前往中国的目的除了学医，也是为自己新独立的国家在发展道路方面寻求借鉴，看看中国的真实情况究竟如何。所以，他和中国近代史上很多去海外寻求“救国之道”的知识分子其实非常类似。

和他的非洲同学相比，海维要年长一些（来华时28岁），有一定的社会和工作经验，思想相对成熟。他还担任了非洲学生在北京自发组织的学联的秘书长。在中国的经历使他对中国道路和模式完全失望，于是立志要让加纳和非洲知道绝对不能走中国的路，所以一回去就写出了这本书。此后他没有从医，而是在一些学校教书，后来主要从事写作。

恩克鲁玛政权一党制的问题在海维出国前就已经很明显了：出国留学生必须是执政党党员，由组织推荐。海维当时不是党员，但他通过“关系”解决了这个问题。他回加纳时，恩克鲁玛政权已经变得更加专制，甚至有极权主义倾向，通过法律禁止和惩治政治异见。海维对恩克鲁玛体制的批判使他成了异议分子，出于安全他前往尼日利亚，恩克鲁玛被推翻后回国，现已80高龄，居住在加纳东部的老家霍霍伊（Hohoe）。

## 无处不在的政治教育

应该说，中国给海维的第一印象就不佳。人们表情的呆板和顺从，尤其是服装的千篇一律，让他非常诧异。虽然同时代的西方人已经称中国人为“蓝蚂蚁”，但基于“非洲意识”，海维对这种缺乏个性强求一致的社会现象特别反感：非洲人的特点就是强烈的情绪表达和式样繁多、色彩鲜艳的服装打扮，甚至男人也穿红戴绿，难道恩克鲁玛要非洲人也变得像中国人一样吗？

海维在书中列出了使得非洲学生离开中国的一些原因，首先是课程中不受欢迎的政治灌输。以中文课为例，单词和句子充满了政治内容，例如“人民公社像初升的太阳，照亮了中国人民前进的道路”和“党的恩情说不完”等等。海维说，学了6个月的中文，他还不知道“水”这个词。经过一再要求，中方才发给他们政治色彩稍淡一些的新教科书。此外学生更要花很多时间学习政治和历史，而它们的教学和讨论又基本上是遵循官方教条。海维感到非洲学生来中国好像不是为了学习一门技术，而是接受洗脑。

专业课程方面，海维说不但整体质量不高，而且掺杂了意识形态说教。例如化学教科书上，第一章关于物质的定义用的是列宁语录，海维说这完全不符合他习得的知识。

尤其让海维觉得离奇的是生物学老师在解释新陈代谢时说：因为蛋白、脂肪和碳水化合物在人的新陈代谢过程中是相互转化的，所以尽管中国人缺乏脂肪和蛋白（这是指当时官方所说的“自然灾害”所造成的肉蛋奶等等的短缺），但不会造成营养不良——因为碳水化合物会代替脂肪和蛋白。海维说，生物学老师曾经在美国留学，她完全知道自己说得不对，所以当她说这些话的时候眼睛不看学生，声音听上去也完全没有说服力。

海维来华前在中学教过一些基本课程，所以他有时在这些知识问题上和中国师生争执。他在书中详细介绍了在做有机化合物的溶解点实验时就如何使用温度计和中国指导老师和实验同伴发生分歧。事后，他在外国留学生中找来4本英文教科书来说明自己方法的正确。几天后，当他们回到实验室的时候，那个犯错误的老师不见了，新来的老师纠正了实验方法，但对发生在海维和其他人之间的争论却一字不提，这让海维感觉特别受挫。

## 在大饥荒的中国享受特权

非洲学生在中国除了学费全免，住宿也免费，每月津贴从80元人民币涨到100元。这差不多是当时中国等级制社会中县团级干部的工资，足以养活三口之家。当时中国生活必需品都要凭票供应，但外国留学生不受这个限制，他们每天早上都有牛奶、鸡蛋，只要有现金就可以去商店购买任何商品。

享受这样的特权，海维仍然感到不满：中国人的生活标准实在太低。海维知道自己的中国同学每月只有十多元人民币的生活费，助教工资40元。相比之下80元人民币已经很高了，但即使是对来自经济落后的非洲的外国学生，80元人民币仍然不能满足他们所习惯的生活标准。经过一再交涉，中方把他们的津贴涨了20元。

由于中方对外国留学生和中国学生之间的交往严格限制，海维对自己和中国学生之间物质待遇上的天差地别是过了一阵才慢慢知道的。例如，他过了半年才知道中国学生是八个人挤在一间宿舍里，而外国学生是两个人一间。当他知道自己在中国享受这样的特权之后，他常常就感到普通中国人对他们的敌意。例如外出乘车时，中国人都要排队上车，而外国人却随到随上。这样的特权让他如芒刺背，好像周围都是敌意的目光。

海维可能是多心了。换了任何一个国家，老百姓都会有这样正常的反应，但中国人民被教育得不一样。他们不但对政府给“外国友人”的种种特殊待遇习以为常，而且会把政治需要解释为是“好客”的中国文化，甚至为此而骄傲：哪怕自己饿肚子，也不能亏着外国朋友。

1960到1962年正是大饥荒的年代。海维生活在中国条件最好的北京市，接触的范围又是国家全力保障的阶层，所以他并没有意识到大量中国人饿死。但他却充分了解中国物资匮乏的严重程度。例如，他知道北京人的蔬菜供应基本上限于大白菜，主食经常由山芋和杂粮窝头代替大米和面粉。中国学生的早餐是清汤寡水的稀粥，午餐是大白菜和玉米窝头，晚餐也是白菜和窝头。他甚至看到就在校园里也有人在挖野菜。

一些中国学生在和外国留学生熟悉以后，有时会说他们已经成年不知肉味了。还有一些中国学生会找留学生帮忙，用自己或家人省下来的钱托他们买一些配给商品。有中国朋友曾经就恳求海维帮自己买厚绒衣御寒，但被海维以自己身为留学生学联秘书长不能违反留学生纪律而拒绝。但是，海维说确实有非洲留学生偷偷帮忙，但借此收取一点“手续费”的不法行为。

尽管物资紧缺，但海维知道，和宣传中人人平等的天堂相反，中国也有特权阶层，例如他的中国同学私下就向他抱怨说他们学院某领导（一个副部级的高干）每个月肉的特供就有十斤以上。这个数字虽然不一定准确，但无人能否认特供存在。

### “阿里事件”的风波

海维的中国叙事内容非常丰富。他虽然没有受过系统的人文和社科教育，连正规的大学本科都没有上过，而且来自被很多中国人看不起的非洲，但他对上个世纪60年代初中国社会和制度的一些根本问题的观察和评论——从教育制度的缺陷到公社化失败的原因——即使今天读来仍然很精辟。

他认为在中国当时的制度下真相的稀缺比物质的匮乏更成问题，其严重性简直到了使“中国”自外于“世界”的地步。他说“在世界其他地方，说真话是最起码的，但在中国却是犯禁的”。此外就是对人在各方面的强求一致或者对人性的完全忽视——“即使是双胞胎，你也不能指望他们长大后完全一致”。他还说，在中国的很多政策和措施上，最让他感到不解的，就是“个人”的缺位。

有了这样的感受和观察，读者不难理解为什么海维回到非洲以后要大声疾呼，反对恩克鲁玛的中国化政策。

1962年3月底一天，北京发生了一起“涉外”事件：一个来自东非桑给巴尔名叫阿里的学生在北京和平饭店和工作人员发生冲突并被殴打。根据海维的介绍，阿里在那里会一个朋友，去小卖部买烟，和工作人员发生言语冲突并发展为肢体冲突，几名饭店工作人员介入并痛殴阿里。有一对为北京国际广播电台工作的桑给巴尔人当时也在宾馆，他们听到打斗声出来查看，也遭到殴打，女的还有孕在身。阿里被打倒在地失去知觉。

事件的真相究竟如何，还有待中方的材料才能了解，这里只能介绍它对非洲学生离开中国的作用。事件发生后，北京的非洲学生联合会发起了抗议，要求中方惩办打人者并对非洲学生赔礼道歉，一些非洲使馆也介入。双方对事件的处理分歧很大，矛盾迅速激化，直至多数非洲学生提出不愿在华继续学习，要求回非洲，为此罢课甚至绝食。为了不损害第一个援非教育项目，也担心国际影响，中方采取了各种措施，包括对非洲学生的分化瓦解策略并取得了一定效果，但依然无法挽留多数非洲学生。

海维是这次非洲“学运”的领导人之一。根据他的统计，事件发生一年后，118名非洲学生中有96人回到了非洲。其他一些材料有不同的数字，但总体而言说，大多数非洲学生离开了中国是不错的。

## 种族歧视与冲突？

为什么一起打斗事件——即使按照非洲学生的说法是中方饭店工作人员应负完全责任，警方的处理也偏袒中方人员——会导致绝大多数非洲学生“毅然”放弃得来不易的在华学业呢？如果说海维对中国已经形成了一个整体看法，所以他的离开不难理解的话，那么对于很多非洲学生来说，种族歧视是他们提出的一个重要原因。

海维觉得，他们一方面享受“县团级”的优厚物质待遇，另一方面却受到种族歧视？很多中国人可能会对此大惑不解。然而从非洲学生的角度却不难把很多在中国遭遇的问题从种族角度来解读。例如，很多服务设施对非洲学生和其他国家的留学生的态度明显不同，有时干脆拒绝给非洲学生提供服务。

1962年阿尔巴尼亚由于在中苏论战中支持中国，其驻苏留学生被逐，由中国接收。这批阿尔巴尼亚学生来华后，中方给他们的生活费是150元人民币，远高于非洲和其他国家的留学生。中国方面关照这些阿尔巴尼亚学生不要和非洲学生提起，但后来非洲学生还是知道了，于是对中国官方产生了很深的成见，因为在他们看来无论中方有什么理由（海维说是对他们反苏斗争的奖励），阿尔巴尼亚学生总是白人。海维承认，在这批阿尔巴尼亚人来之前，非洲学生虽然已经抱怨有种族歧视，但并不太严重，没有上升到政治的高度。我想，这很可能是由于这批阿尔巴尼亚人人数上超过非洲学生（据海维说有近200人，而原来非洲学生是最大的群体），他们的到来使得在北京的外

国留学生群体中黑白肤色的差异一下变得明显和敏感了。

更大程度上，很多非洲学生在中国感觉到的是一种用优厚待遇换来的社会隔离。和中国人交朋友非常难，和中国女性交友谈恋爱更是罕见，对方要面临巨大的压力（海维举了中国女性和非洲学生谈恋爱而受惩罚的事例），在难得举办的舞会上要邀请中国女学生跳舞也很不易。曲终舞罢团干部常常要去问被邀的中国女学生跳舞时谈了些什么。中国人对其他外国人是从哪个国家来的都区分得很清楚，但唯独对非洲来的统称为“黑人”（严格来说，本文中“非洲人”的统称也是有问题的）。在和平饭店发生的打斗中，另外两个非洲人也被打，根据海维的说法，打人者当时笼统地说“黑人不好”。肤色成为非洲人的身份标志，并和道德品质挂钩。在这样的社会中，非洲学生很难长期生活下去，完成数年的学业。

社会上对非洲人的“种族歧视”气氛在官方文件中也有反映。笔者见到的一份外交部解密的“关于向群众进行正确对待黑非洲外宾的教育的通知”（1961年5月）中说，加纳共和国首任大使克西在北京看房子途中受到围观，群众不但大呼“黑人来啦！”而且“出言不逊，制止无效，如说：‘他的脸像树皮’，‘脑袋像猪头’等。”文件说，这种出于好奇心的言行很容易被对方解读为种族歧视，造成“很不良的政治后果”。很不幸的是，一年后发生的正是如此。

## 是“小题大做”吗？

海维于1962年四五月间离开中国，这本书出版于1963年，出版社是英美合营的Frederick A. Praeger。如此快的出版速度，很显然既和海维的充分准备有关，更离不开西方世界对当时中国的态度，一些出版社正需要在处于封闭状态的中国生活了一年半的人提供的第一手材料和观察。海维的加纳异议者身份也很有“卖点”——西方正为恩克鲁玛的社会主义路线在非洲的影响担忧。所以，海维的书自然迎合了西方冷战时期的政治需要。

但西方是有不同声音的。海维的书出版后，一些学术界和新闻界人士认为他对中国的偏见太强，尤其是他对非洲人在中国遭受“种族歧视”的说法是“小题大做”（petty annoyances），即放大了日常生活中一些不愉快的细节的社会意义。但今天，当我们对60年代初中国的真实情况有了越来越多的了解时，海维的描写看来并没有任何夸大之处——他甚至还不知道中国正在发生大面积饿死人的情况。

那么，“种族歧视”是“小题大做”吗？去年台湾一个青年学者写了一篇英文文章，发表在China：An International Journal杂志上，题目就是“是小题大做吗？伊曼纽尔·约翰·海维的《一个非洲学生在中国》：五十年后的回顾”。作者利用在上海档案馆中60年代初外国学生在中国的一些有限的内部通报，对非洲学生在中国遭受的种族歧视做了一定的“核实”。但所有这些材料还是没有涉及发生在和平宾馆的冲突，更重要的是也没有中国方面对非洲学生那场“学运”的反应。

最后值得一提的是，非洲学生在北京的那场“运动”是当时社会主义阵营内的普遍现象。在冷战和非洲独立运动的背景下，中国和苏联阵营都资助了很多非洲学生。但出于相似的政治、文化和种族原因，非洲学生在这些国家都“水土不服”。1961和1962年，非洲学生在一些东欧国家“闹事”，1963年他们在莫斯科发起罢课和示威，一度“占据”了红场。海维的中国经历，也应该放在这个大背景下来思考。

![](https://i.loli.net/2019/08/30/tTlgQjMSw3PIeOb.png)

《孙立平课堂》最近10讲

[第121讲 浮华与殷实：不同的模式定型为不同的社会](https://mp.weixin.qq.com/s?__biz=MzIyNjgzNTc0NQ==&mid=2247487129&idx=1&sn=d2e0d80cd19e4f1eb3822cda3e0a7c28&chksm=e86b22d7df1cabc15e36163c874c5aaf7053160b945795ed83b4ddfd8bb936195d74f39d9896&token=852742586&lang=zh_CN&scene=21#wechat_redirect)

[第118讲 张扣扣复仇案：悲剧是如何一步步形成的？](https://mp.weixin.qq.com/s?__biz=MzIyNjgzNTc0NQ==&mid=2247487055&idx=2&sn=64a252fdfd06728e14f0705fcdc80a26&chksm=e86b2201df1cab17b046c585cd13817820c8239a97348e8a8b5bd1ac256fc53447aeb141c34a&token=339508922&lang=zh_CN&scene=21#wechat_redirect)

[第117讲 自由主义要面对新情况新问题](https://mp.weixin.qq.com/s?__biz=MzIyNjgzNTc0NQ==&mid=2247487121&idx=1&sn=e88bdf56c8c142b1316d2039ec2eaa8d&chksm=e86b22dfdf1cabc98cee77c0cd00bb09759b55836f1f1ad8c0ded28ca93272adcc7d23726463&token=339508922&lang=zh_CN&scene=21#wechat_redirect)

[第116讲 中产阶层的现状与未来发展的潜力](https://mp.weixin.qq.com/s?__biz=MzIyNjgzNTc0NQ==&mid=2247487031&idx=1&sn=780c8a8e77c05e655f3adb9c873375d8&chksm=e86b2279df1cab6fafc614066ec29066551161077975d04b11b70fb909c4013fce86463774d8&token=339508922&lang=zh_CN&scene=21#wechat_redirect)

[第115讲 多想想那些将来可能很棘手的问题](https://mp.weixin.qq.com/s?__biz=MzIyNjgzNTc0NQ==&mid=2247487081&idx=1&sn=e8838df9c9e6a42481625d7e0c2d2785&chksm=e86b2227df1cab311f1556a95c6819530e9e5e3bda9ff3a3e7a9d80e1b47cf985633a6118f77&token=339508922&lang=zh_CN&scene=21#wechat_redirect)

[第114讲：垃圾分类与运动式治理](https://mp.weixin.qq.com/s?__biz=MzIyNjgzNTc0NQ==&mid=2247486987&idx=1&sn=25953045ee00729622fa1b436c7e5060&chksm=e86b2245df1cab535ca7e69b74b79e8b5c3feff441132c4e3851d9cf3f8af17ab60282b877e7&token=339508922&lang=zh_CN&scene=21#wechat_redirect)

[第112讲 发展机遇期与遏制窗口期：对修昔底德陷阱的进一步探究之二](https://mp.weixin.qq.com/s?__biz=MzIyNjgzNTc0NQ==&mid=2247487102&idx=1&sn=f5200f16fa704301610187ddb0fb3779&chksm=e86b2230df1cab26c3f926655ea48fce1c590844eb8f9390652331d1d0bc371900cbc5005010&token=339508922&lang=zh_CN&scene=21#wechat_redirect)

[第110讲 假如冷战再一次降临，和上一次会有什么样的差别？](https://mp.weixin.qq.com/s?__biz=MzIyNjgzNTc0NQ==&mid=2247487005&idx=1&sn=f0754d023545bd1a62f20abc98cf2e38&chksm=e86b2253df1cab450ffd1d8c86fc64da9e9dc4d6e048dc7093a57e3f17b3164f8d44d261c60b&token=339508922&lang=zh_CN&scene=21#wechat_redirect)

[第109讲：实力差距与临界点：对修昔底德陷阱的进一步探究之一](https://mp.weixin.qq.com/s?__biz=MzIyNjgzNTc0NQ==&mid=2247487020&idx=2&sn=98635f35cd1a199ccddb6f28f983e7e7&chksm=e86b2262df1cab743408dca539506afb7c2dfd4b08e8c94aa35411c20500c6626b83311acc65&token=339508922&lang=zh_CN&scene=21#wechat_redirect)

[第108讲：中美关系：需要慎重对待的三个框架](https://mp.weixin.qq.com/s?__biz=MzIyNjgzNTc0NQ==&mid=2247486971&idx=1&sn=0515f81b9c6fca32cc722f8a1b636051&chksm=e86b21b5df1ca8a3772f8f465f2d453e35329f3f620416129714ca58a9f1cf9560671edb2c22&token=339508922&lang=zh_CN&scene=21#wechat_redirect)

![](https://i.loli.net/2019/08/30/NxEg342BRdzLYI1.png)

长按并扫描二维码进入《孙立平课堂》
