---

layout: post

title : 书号收缩下的大陆出版业：从自我审查到紧跟“党政方针”

categories: Archive

tags: 出版自由

date: 2019-05-08

description: 令人担忧的传闻终究变成了现实。据多位编辑证实，2019年初，中共中央宣传部向各出版社下发了一份内部文件，明确提到将缩减书号总量、压缩图书品种。

---

原文来自：~~[书号收缩下的大陆出版业：从自我审查到紧跟“党政方针”](https://app.simplenote.com/publish/ZxblWG?)~~

---

特约撰稿人 王摇、阿唐 发自上海、北京 20190503

令人担忧的传闻终究变成了现实。据多位编辑证实，2019年初，中共中央宣传部向各出版社下发了一份内部文件，明确提到将缩减书号总量、压缩图书品种。

此前，在长达一年的时间里，“书号收缩”的阴云一直笼罩着中国大陆出版界。2018年3月5日，认证身份为“三鼎甲图书公司总经理”的“出版人邢海鸟”在微博上称：“2018年是出版严控之年，出版总局减少10万个书号，约占全年书号的三分之一……”尽管这条微博在四天后被本人删除，但类似消息总不时传出，令业界人心惶惶。

书号制度，是中国出版业的重要管治手段。一本合法出版的书，必须有**中国标准书号和图书在版编目（CIP，Cataloguing In Publication）数据**。前者是国际标准书号（简称ISBN）系统的组成部分，后者则包括了作者、出版社、书号、书名等基本信息。没有上述两个“身份”的图书，被视为“非法出版物”，相关人员亦会被追究刑事责任。

但书号并不易得。它由中央宣传部掌管、分配，只供特定身份的出版社申请，且建有一套审查流程。获得书号后，出版社才能向中国版本图书馆（中央宣传部出版物数据中心）申请CIP数据。如今，这套本已繁琐、严格的制度，又再次收紧了入口，它带来的影响，不仅仅是图书出版种类的减少，还包括在题材和内容上的被动审查和自我审查，更甚者，是“整个文化对某一块知识的系统性遗忘”。

## **有国营“血统”的出版社才有资格申请书号**

中国有超过500家出版社，分为三大类：国有出版社，民营与国有共同组建、由后者控股的合资企业，以及独立运作的民营出版公司。其中，**只有前两者——有国营“血统”的出版社有资格直接申领书号**。

每个出版社每年能拿到的书号额度，依据其上一年的书号用量而定，若出现不够用的情况，一般要等到年底，再向新闻出版总署提交增补申请。

而没有书号申领资格的民营出版公司，必须与有资格的出版社合作，才能获得书号。比如，充当出版社的“选题策划机构”，从选题、版权、翻译，到封面设计、印刷、包装产生的费用，完全由民营出版公司承担。其后，民营出版公司再将图书以较低的折扣（一般在3.5折到4折）卖给出版社，由后者负责后期发行。另一种合作形式是“买书号”：出版社提供书号、进行终审，收取“书号管理费”（一个书号的价格在一万左右，人民币，下同）和“审稿费”（一般在两至三千元左右，依书稿字数浮动），余下的事宜（包括发行）交给民营出版公司做。

**在过去近十年，一些民营出版公司逐渐与国有出版社建立了稳固的合作关系。双方彼此熟悉，工作进度快，审查尺度适中**。比如，著名的人文社科图书出版公司后浪，历年图书常常交由北京联合出版社出版；文学类出版发行公司新经典文化，和南海出版社长期合作；而主营政治哲学、社科思想类图书的三辉，此前主要和中信出版社、商务印书馆、中央编译出版社等“选题调性比较相符”的社合作。

这些活跃的民营公司，也帮助国有出版社塑起品牌。据《2017 年中国图书零售市场报告》，10家国有出版集团合计码洋（指一本书的定价或一批书的总定价，此处指出版社在扣除各种成本前的实际销售总额）占有率为 28.56%，其中，北京联合出版社以2.63%的码洋占有率位列第一——而其出版的大部分书籍是交予后浪这样的机构策划完成的。此外，虽然民营公司市场占有率仅8.8%，但三大 畅销榜（虚构类、非虚构类、少儿类）TOP10上，超过半数的图书都来自民营机构。

当然，无论是国有出版社还是民营公司，对书号调控这件事都并不陌生。在浙江某出版社任外语文学编辑的姚陶告诉端传媒，2017年萨德事件发酵（因韩国接受美国协助，在国内部署萨德反导弹系统，中国官方媒体遂发起反韩声浪，获得从商界到民间的极大响应），原新闻出版广电总局叫停了所有韩国文学的图书选题，待出书籍亦无法获批书号，直到去年底才有所松动。

从事多年出版的编辑刘成荀也介绍道，遇上一个重要的纪念日，相关图书会集中在一段时间内出版。这时，中国版本图书馆通常就会卡住部分涉及该主题的CIP的发放。再比如，近一年，从国外引进版权的少儿绘本的CIP停止发放了。2018年下旬，书名里含有“晚清”二字的图书，也遭遇了一轮CIP的调控。

几乎所有接受端传媒采访的图书编辑都表示，**虽然书号额度从未完全放开过，但2018年之前，书号总是够用的，增补也比较灵活**。

到了2018年，情况就变了。

## **经济效益高、政治不敏感的书被排在了前面**

首先是书号价格的上涨。

三辉的图书编辑严肖了解到，现在最贵的书号已涨到了2.5万一个，而在2018年以前，价格还在一万左右。

甚至，出钱也买不到书号了。曾在上海某高校出版社工作的余辛对端传媒表示，其就职的出版社属于“意识形态上比较令人放心的”一类，往年书号都呈增长状态，有不少富余。但2018年开始，“书号就与上一年齐平了，社里因此开始严控给予民营公司的书号额度。”

一些规模较小的出版社甚至在年中就用完了一年的书号额度，更别提“满足”民营公司的需求了。严肖2018年中旬联系九州出版社商量买书号的事，对方编辑表示：“所剩书号已经不多了。”

书号变贵、变少，导致出版机构无法完成整年度的出版计划，继而影响收益和持续生产。据严肖估算，他们2018年出版的书目较往年缩水近一半——还是在出版社人员扩招的情况下。

最后，**增长的书号成本也会被分摊到码洋上，构成读者口中“越来越贵的书价”的一部分**。据《2018中国图书零售市场报告》，2018年图书市场上的单册新书定价涨幅超一成，平均定价已涨至68.5元——当然，其中也不乏因加强污染治理而关停造纸厂、导致纸价大幅上升等原因。

情况并未在2019年好转。年初，供职于某大学出版社、负责教材和教辅出版的大舒更接到明确通知——出版社的书号将缩减10%。以前，他们出一套幼儿园课程用书，可以用二、三十个书号，“教师用书、学生用书、幼儿挂画，有时候甚至是一个小零件，都可以用掉一个书号。”现在，他们不得不合并一些已经上马的图书项目。

书号增补的通道也被堵塞了。

依据《图书出版管理规定》，出版社须在每年第四季度将次年计划出版的选题报至所在地的省级出版行政主管部门审核，并报至新闻出版总署备案。没纳入年度选题的，每个月再按增补选题申报。也就是说，出版社每个月都有一次上报新选题的机会。民营出版公司通过出版社申报图书选题，通常走的也是增补通道。

据刘成荀获得的消息，截至4月，云南的地方出版社还不能申报每月的增补选题。这意味着，他们至少失去了今年1/3的申报新选题的机会。青少儿图书编辑吴涯也在2018年底接到的通知——来年不一定每个季度都有补报选题的机会。

从“零增长”到“总量减少”，业内的人开始感觉到——“这一次，‘书号缩减’这根政策指挥棒挥动的力度是空前的。”刘成荀说，“这样的政策调控手段会引发孔飞力笔下‘叫魂’一般的大规模恐慌和魔幻景象。说到底，图书出版是一个靠产品说话的行业，但书号的调控直接干预了产品生产的环境，直击图书出版的命脉，还会造成一系列很难为我们预料到的连锁反应。”

业内人士将“书号缩减”与出版行业的机构改革联系在一起。

2018年3月颁布的《深化党和国家机构改革方案》称：“为加强对出版活动的管理，发展和繁荣中国特色社会主义出版事业，新闻出版工作由原国家新闻出版广电总局划为中央宣传部管理，中央宣传部对外加挂国家新闻出版署（国家版权局）的牌子。”同年4月16日，国家新闻出版署揭牌，正式接管新闻出版管理职责。**此番机构调整，也释放出当局进一步把控出版业意识形态的信号**。

对于2019年年初下发的、缩减书号总量的文件，“新官上任”的中宣部这样解释其目的：“从增加品种数的粗放式增长，向着重选题质量的精细化增长转型”。

严肖并不认同这样可以提高书的质量：

**“缩减书号的直接后果是，编辑需要在一系列待报的图书选题中考虑优先级——经济效益高的、政治上不那么敏感的，也就自然被放在了前头。”**

除了对编辑个体的影响，刘成荀指出，书号压缩也会令图书公司调整产品体系和经营策略。无论是比较前沿、小众、需要慢慢培育和发展大众读者的领域，还是不如外版书质量高、内容成熟的原创作品领域，都可能成为书号压缩的“受害者”。

据《出版商务周报》报导，2018年中国各出版单位共申报图书选题277983种，比2017年同期减少29258种，同比下降9.52%。其中，除“马列主义、毛泽东思想、邓小平理论”这一类别外，其他类别（哲学、社会科学、自然科学、综合性图书）的选题数量均有下降，**哲学和社科类减幅最大，分别为17%和10%**。

## **删除那句话的编辑解释道：“我们为什么要留下这个隐患呢？”**

和书号一同收紧的，还有审查尺度。

虽然出版业向来要与审查制度打交道，但受访的编辑普遍表示，近两年来，整个出版流程上的审查尺度都存在明显的收紧——尤其是在主管部门从国家新闻出版广电总局转到中宣部以后。

**“前几年可能不费太大劲就能出的书，现在就很难出了。这里面没有标准成文的尺度，多是依靠出版社自身的判断。只是大家都知道，有某种东西在那里。”**

曾在某民营出版机构任世界史图书编辑的金城说, “如果将来出问题，对他们而言，会有很严重的政治后果需要承担。”

2016年5月，广西师范大学出版社（旗下图书品牌有“理想国”、“新民说”等，曾出版一系列高质量人文社科类书籍）原董事长何林夏以涉嫌受贿罪遭到逮捕。作家章诒和曾接受《苹果日报》采访，认为何被捕与“他手下出版的那些敏感政治书籍有关系”，是当局“用经济手段处理敏感政治问题的又一案例”。2018年，中央编译出版社由于曾出版《我的凉山兄弟》（人类学者刘绍华写作，展现因毒品和艾滋病泛滥成灾而长期被“污名化”的凉山彝族诺苏人真实生存状态）等书，遭到处分并要求整改。

世界史图书编辑金城表示，从边疆史、民族史、中国近现代史，到中东、阿拉伯的历史都是一般的出版机构近年来主动规避的，涉及宗教史的书更是除个别出版社外，没有社敢接。**与此同时，相对没那么敏感的世界史就成为了出版界竞相追逐的主题**。

前几年，著有“中国三部曲”何伟（Peter Hessler）带起了一阵“国内非虚构图书”风潮，但现在，这样的书籍也没那么好做了。在上海一家主做外国文学的出版社任发行一职的林探透露道，**他们会避开聚焦中国、并涉及到比较深刻敏感的社会和政经话题的书**。

在另一家社科类出版社，连 “探讨代孕这一新兴劳动在全球化潮流下的兴起和发展”这样的选题也被驳回了。理由是“目前在我们国家，代孕还是不合法的。这本书会让人觉得，我们有给国内想寻求代孕的人提供实践指南的意思。”

题材的收紧在无法再版的图书上看得更加清晰。《弑君者：把查理一世送上断头台的人》（_The Tyrannicide Brief: The Story of the Man Who Sent Charles I to the Scaffold_）再版就在申报选题时遇到了困难，“没有出版社愿意收了，他们可能觉得题目太可怕了吧。”上述社科类出版社的一名编辑揣测说。以往，遇到类似的问题时，他们尝试解决的办法就是“换个书名再试试吧”。

被拒收，对民营出版机构是最大的一重打击。它意味着，前期的付出——包括买版权和翻译，全都白费了。在购买版权时判断为有空间做的选题，待翻译完成后就发现根本不可能出来了——这样的状况开始变得越来越频繁。

而一些被判断为主题敏感的选题，还需上报重大选题备案，等待起码一年以上的审批过程。这一依据是1997年起实行的[《图书、期刊、音像制品、电子出版物重大选题备案办法》](https://archive.li/o/IDTju/people.com.cn/electric/flfg/d2/971010.html)。

严肖表示，近两年开始，“台湾作者的书，不管写什么内容，都需要上报重大选题。”而在漫长的审批中，**“他们不会告诉你需要补交什么材料，或是没有通过。就是这样拖着你。”**出版周期被严重拖慢，也导致“一般机构的原则，恐怕都是尽量不碰要报重大选题的书了。”

还有一些书稿会被卡在三审和质检环节。一位不愿公布其就职出版社的编辑透露，该社一本研究强奸问题的女性主义书籍迟迟未过终审，因为“出版社现在觉得‘强奸’敏感，不正能量。”另一部书稿因立足伊斯兰国家的背景，也没了动静。

去年，一家出版社重新翻译并打算再版托尼·朱特（Tony Judt）的《重估价值：反思被遗忘的20世纪》（_Reappraisals: Reflections on the Forgotten Twentieth Century_）——该书的旧版曾于2013年付印。新版的书稿在经过质检环节后被打回，原因是多处“涉及‘共产主义’的评价不符现行政策、法规”。

最终能够出版面世的图书，不少也难逃内容被“技术处理”的命运。**“在青少年图书，敏感词数量也直线上升”**，青少儿图书编辑吴涯举了一个例子：一本用魔术手段教孩子数学知识的书，里面有个小魔术名为‘我知道你前世姓什么’。终审时，其中的“前世”二字被要求替换，因为“前世”是封建迷信。

令严肖印象深刻的是，在近期发往出版社终审的书稿中，有一句“现在社会，人们不可能投向法西斯主义”的表述被删除了——这是之前都没有遇到过的情况。严肖感到不解，试图就“这句话为什么敏感”向出版社方面的编辑讨要一个说法。那边的回复只是一句：“我们为什么要留下这个隐患呢？”

**选题、编审、质检就像设置好的一层层滤网，将可能的敏感图书和内容给基本过滤干净了**。

“这样久而久之，就会导致整个文化对某一块知识的系统性遗忘吧。”金城感慨道。

不仅如此，已进入市场的书籍，也并不“安全”。特别是近两年，回过头再做追究的状况时有发生。林探透露，去年有本书因涉及到国内拆迁的内容，据说被人举报，在出书后遭到有关部门干涉，被迫下架。**早年出版的、一本以民国时期为背景的小说，因为腰封上写有一句“那是一个最自由的年代”，去年质检时被重新翻出，全部下架**。

被通知不得继续加印或售卖——潜台词就是“要求下架”——的图书，出版社一般会实行“不主动宣传”的策略，让其低调卖完。有的更是直接当作废书，化浆销毁。

“现在，像奥威尔（George Orwell）这种许多出版社都在发行的书，在宣传的时候也会考虑不要说得太激进。其他书的宣传上，也会避免以国外的情况‘影射’中国。”林探说。

2018年年底，曾有豆瓣用户整理过一份[“大陆地区下架不再版中文书目”](https://archive.li/o/IDTju/https://www.douban.com/doulist/46432949/)名单，包括百本，涉及古拉格、中国近现代史、自由主义、苏联及东欧共产主义思想统治、审查、维稳、生育控制……

而今，书号亦成为中宣部处罚出版社的一项有力手段。据刘成荀了解，今年就有31家出版社因上年度质检不合格，被要求提交整改方案，且暂停书号发放。海天出版社因去年的一本出版物出现了政治导向问题，直到现在，连1月申请的书号都没有批复下来。

## **新时代如何挖掘主题出版选题“富矿”？**

**唯一置身书号调控影响之外的，是“主题出版”领域**。去年，仅有主题出版的选题，得到了增补书号的“特殊待遇”。

据《2018中国图书零售市场报告》，非虚构类畅销书排行榜的第一位是2018年的新书《梁家河》（纪实文学，讲述习近平在梁家河村插队时的工作生活），第二名是前一年出版的《习近平的七年知青岁月》。中国新闻网的报导称，2019年年初结束的北京图书订货会上，“主题出版成为主线”。

所谓“主题出版”，不仅包括 “围绕党和国家工作大局，就一些重大会议、重大活动、重大事件、重大节庆日而进行的选题策划和出版活动”，还包括“弘扬中华优秀传统文化”的图书选题。中宣部下发的2019年主题出版工作要求，**明确了五方面的选题重点：加强习近平新时代中国特色社会主义思想的研究阐释；为庆祝新中国成立70周年营造浓厚氛围；围绕宣传阐释中央精神和重大决策部署，推动经济社会改革发展；深化社会主义核心价值观宣传；充分展示真实立体全面的中国，不断提升中华文化影响力**。

2018年底，中宣部印发了于2019年1月1日起实行的《图书出版单位社会效益评价考核试行办法》，将“社会效益评价考核”设为考核重点，占比在绩效考核的50%以上。**《办法》提到，对出版物出现严重政治导向、社会影响恶劣的，社会效益评价考核试行一票否决，年度考核定为不合格**。连续2年考核不合格的出版单位，需进行整改，并调整负责人；连续3年考核不合格的，要受到处罚直至退出。

在中部某省的教育出版社工作的简杨杨介绍，出版社可以通过出版教辅类图书获得经济效益，而社会效益，则需要依靠自行挖掘的“主题出版”图书。毕竟，风险较小、出书速度较快、导向正确、又容易拿奖的“主题出版”，本就是最符合社会效益考核指标的选择。

事实上，组织主题出版工作，对每家出版社都有所要求。具体的选题，则视出版社的级别、所在地及擅长的出版方向而定。简杨杨直言：“涉及到领导人的书，就算是正面的宣传，也是非常谨慎的。”这类选题通常都是冠有“人民”头衔的出版社的特权，如果由文艺出版社、科技出版社来申报，很大可能无法通过，“他们会觉得，你一个行业出版社，来凑什么热闹？”

2018年7月，中国新闻出版广电网刊发了[《新时代如何挖掘主题出版选题“富矿”》](https://archive.li/o/IDTju/www.xinhuanet.com/zgjx/2018-07/19/c_137334519.htm)。文中提到，出版社“只有对党和国家路线、方针、政策精准解读、正确把握，才能策划出紧跟时代主题的选题”。

在陕西、浙江、福建这样中国现任最高领导人曾经生活过的省份，出版社寻找“主题出版”的选题似乎并不困难。简杨杨供职的教育出版社就没有交上这样的好运。出版社位于中国中部某省，现任领导人没有在该省留下过什么踪迹。好在该省历史上曾是红色革命根据地，于是这家教育出版社的编辑们“就是挖掘一些本地的红色人物、英模人物来做。”

**文化、教育类的出版社，则倾向于推出一些由国外学者或作者写作、正面宣扬中国历史文化的书，或是讲述在官方历史叙事下普通人故事的书**。比如上海文艺出版社于去年出版的《明月度关山》，上海译文出版社即将推出的《趣简中国话》和《趣简中国史》。大舒目前正在编辑一套关于古代数学的书籍，也勉强可以算得上是“弘扬传统文化”的主题出版物。

至于那些因为种种原因而迟迟无法出版的书，严肖觉得，“它们就像曾经的校园传说，公司里时不时有人提起它，但同事们入职又离职，谁都见不到它们出版。有时我又觉得它们像《荒凉山庄》（_Bleak House_）里那场被永远卡住无法宣判的遗产纠纷案，不知道在真正尘埃落定的时候，这些书会不会耗尽自身失去意义。”

（ 应采访对象要求，本文出现的名字均为化名。 ）
