---

layout: post

title : 带血的庞氏，p2p消亡简史

categories: Archive

tags: p2p

date: 2019-05-08

image_feature: ‘https://i.loli.net/2019/05/08/5cd2fb0477520.jpeg’

description: 2019年4月28日，母公司金诚集团实控人韦杰等33名高管因涉嫌非法集资，被警方带走，这家号称资产规模超700亿的公司轰然倒塌。

---

原文来自：~~[带血的庞氏，p2p消亡简史](https://mp.weixin.qq.com/s/PrAFg-uhNRhOaxHCPn97PQ)~~

---

【这是半佛仙人的第69篇原创】

## 0

随着团贷网倒下，红岭创投宣布清盘，2019年的P2P行业又不安稳了。

2019年4月28日，母公司金诚集团实控人韦杰等33名高管因涉嫌非法集资，被警方带走，这家号称资产规模超700亿的公司轰然倒塌。

如果是我知乎时期的老读者以及购买我过live的人应该非常清楚，近3年来，对于国内的P2P市场，我始终秉持的态度就是普通人对于谨慎碰，最好是不要碰，这个行业是存在系统性风险的。

当然这么公开讲P2P是有代价的，每一家被我公开怼过的P2P都给我发过律师函乃至起诉书。

但这十几张律师函是我的光荣。

因为他们中没有一家活到跟我的官司开庭，其中离我最近的是团贷网，差了4个月，白白让我花了很多律师费，可惜了。

这段时间监管开始推进P2P的备案，高标准，严要求，务必保障投资者权益，这轮备案结束后，这个市场将只有真正有实力的巨头存在，大多数中小机构会被清退离场，这个行业确实是需要高门槛。

可以说P2P的游戏已经到了终局，谁会获胜仍未可知，但可知的是，活下来的机构，数量不会多。

而自2007年到2019年这12年间，围绕P2P产生的爱恨情仇，利益纠葛，无数家庭的幸福与破碎，无数投资者的高潮与坠落，无数机构的高光与死亡，还有很多事情可以讲。

这篇文章，将是对于整个P2P行业乱象的梳理与记录，以及为什么P2P模式在中国不能完全成立的逻辑论证。

是对P2P系统性风险的阐述，也是对那个狂热年代的祭奠。

## 1

P2P最早的起源有多个版本说法，有的说是尤努斯的格莱珉银行版本，有的说是英国的Zopa版本，还有的说是美国的Lending Club版本，这其实不重要，因为他们本质上都是指向同一件事。

P2P，Peer to Peer。

不完全是人对人，P2P的真实含义是，点对点。

真正的P2P平台，本身只是一个中介机构，作为一个桥梁，连接借款人/机构与出借人（投资人），撮合双方的交易，从中收取一定的管理费用，承担部分审核风险的工作。

P2P本身只是辅助，真正的投资决策是投资人做出的，其中的收益与风险，全部由投资人承担。

用一个最简单的例子理解就是，房产中介。

房东和购房者互相不知道信息，且不信任对方，中介出面协助双方交易，所有资金都放在银行的三方账户，中介监督双方完成交易。

一个标准，且合规的P2P，应该是下图这样的构造。

独立的三方资金管理，清晰的借贷双方，点对点的权责厘清。

![01.jpeg](https://i.loli.net/2019/05/08/5cd2fb0477520.jpeg)

这个模式本身从理论上是没问题的，由于模式完全都是点对点，平台不触碰资金，所以理论上不存在挤兑这个概念。

每一笔资金都有定向的去处，所以每一个债权都有对应的标的，即使所有人一起兑付，由于债权和资金的一一对应，也不会出现问题。

害怕挤兑的根源是资金出口不明晰，合规的P2P不存在这个问题。

这种点对点的，高效的金融交易，曾经是每一个金融从业者的梦想，甚至其去中心化的思路要比区块链早很多很多。

可惜梦想只是梦想，残酷的现实没有给梦想留下余地。

## 2

理想中的P2P模型，在撞到现实时，会遇到2个悖论，这直接导致标准P2P是活不下去的。

第一个悖论是，投资人只接受收益，不愿承受风险，而P2P本身并不是刚性兑付的业务。

按照标准的P2P模型，交易是点对点的，应该是投资人自己决定投不投借款人，投了之后，钱一旦要不回来，风险应当自己承担，平台作为撮合方，可以协助追讨，但本身不对投资风险进行兜底。

其实就是那句说烂了的话，投资有风险，入市需谨慎。

这句话在任何一个成熟的市场都是真理，但在我国不是。

因为投资者本质上都不是合格投资者。

在国内大多数投资者眼中，投资从来就是一件只有赚没有赔的事情。

一旦出现了赔钱，他们不会去想着会是自己看走眼，而是觉得机构黑了他们的钱，会去搞死那个机构。

这件事情从炒房上就能看到，房子降价了会去打砸售楼处，但是房子升值了从来没人去给房产公司送钱。

说穿了就是严重缺乏市场教育。

这不怪投资者，国外的成熟投资者，都是经历过多次大磨难的市场教育，最终形成市场共识。

这个过程可能历经百年，而我们欠缺的，恰恰是时间。

这个时候，P2P作为中介平台，就很尴尬，投资人不接受亏损，亏损就来砸公司，而投资本身是必然有赚有亏的事情，这是自然规律。

虽然刚性兑付是违背自然规律的，但敢于违背刚性兑付的机构，会被投资者淘汰。

这是一个不合理的需求，是一个畸形的循环。

并且刚性兑付本身也是国家明令禁止的，投资有风险是国家宣传了几十年的标语。

一头是刚兑不合规，一头是不刚兑就会死，这是P2P的第一个悖论。

## 3

P2P的第二个悖论是，高投资收益与风险的逆向筛选矛盾。

银行活期/定期存款，0风险，年化1到5个点之间，与时间有关。。

银行定期理财，基本无风险，年化3到5个点收益，与期限有关，往往有投资门槛，1到10W不等起始资金要求。

以余额宝为代表货币基金，风险无限趋近于0，年化收益是3到4个点，有点是随用随取和0资金门槛。

以上为超低风险投资的真实收益率，有兴趣的可以看看国外的投资收益率，和这个差不多。

信托，存在一定风险，年化6到10个点，期限较长，投资门槛较高，50W起，不允许刚性兑付。

企业债，存在一定风险，年化3到10个点，每天有专门市场交易，容易出黑天鹅，最近各类上市公司频频暴雷。

以上为存在明确风险的真实收益率，童叟无欺，且往往有真实资产做抵押风控，出事也是小概率事件。

一个典型的庞氏，持续了20年，金额500亿美金的麦道夫骗局，让华尔街大佬疯狂的投资产品，年化收益是多少？

也不过10到12。

以上为明确的庞氏骗局的收益率，从一开始就注定完蛋的骗局。

而P2P呢？

年化8到30个点，高于10个点的比比皆是，期限较短，1元起投，往往对外宣称无历史逾期，实质性刚性兑付。

P2P凭什么做到这个收益率？

他们在优质资产上抢不过银行信托，资金成本更是银行的好几倍，他们凭什么给出这么高的收益？

是神仙操盘吗？

神仙操盘的结局往往是仙人跳。

一般P2P给到投资者的收益在8个点以上，高的十几个点甚至几十个点的也有，再加上获客成本，运营成本，工资支出，资金通道成本，保证金等等一系列成本，P2P平台的资金成本基本都在15%以上，更高的也有。

那么问题来了，P2P平台以15个点以上的成本搞来的资金，需要以多少的价格放出去才能有的赚？

考虑到部分坏账的情况，这个数字应该是20%以上的年化。

如果对企业融资这个领域有所了解的人，应该知道，这个融资成本，正常企业是承受不起的，连毛利都不够，肯接受这种费率的企业，到底是什么样的货色？

或许一些个人借款可以接受这个费率甚至更高点，但问题是，他们为什么要借这个钱？他们为什么不能从银行借更便宜的钱？

这两个问题的答案都是同一个，那就是银行和大机构不愿意与这些企业或个人发生业务，认为他们风险高。

高风险群体的收益，必然不高，P2P公司很清楚这笔账。

但是不给投资人高收益不行，不给高收益，投资人就去别的给高收益的机构了，这将直接导致机构资金流入不足，同样会完蛋。

一头是要给投资人高收益，一头是投资标的高风险，这是P2P的第二个悖论。

## 4

如果你认真读到这里，你就会得出一个和我一样的结论，正规的P2P业务模式在当前的环境下，是活不下来的。

资金成本比正规机构高，投资标的比正规机构质量差，投资人要求必须刚性兑付，政策监管要求又不允许刚性兑付。

此路不通。

但不疯魔，不成活。

为了活下去，很多P2P机构纷纷开始了种种疯魔操作。

让所有人的不合理的要求都被满足的操作，本身一定也是不合理的，甚至不合法的。

面临生存威胁时，每一个P2P机构都红了眼。

既然没有办法保证每一笔点对点的投资都0风险，那干脆把所有资金都聚在一起，用新流入的资金覆盖历史坏账。

既然没有办法保证每一个投资标的都是优质资产，但是又需要一些资产来吸引投资人入金，那干脆就人为创造优质资产。

大量P2P公司，就此走上资金池和虚假标的不归路。

他们的命运，在老板做出决定的那个时间就已经决定了，接下来的问题只是什么时候出问题而已。

## 5

所谓资金池，就是把资金汇集到一起，形成一个像蓄水池一样的储存资金的空间，通常用在集资投资，房地产，或是保险领域。

简而言之，就是先把钱收进来，存在一个池子里不动，池子的另一端是投资标的，在这里面可以形成投资期限错配，用新投入的资金还老人的本金利息等一系列操作。

如下图所示。

![02.jpeg](https://i.loli.net/2019/05/08/5cd2fb0478a3f.jpeg)

资金池的好处是，作为平台方，拥有对资金的绝对掌控和分配权，这样可以玩出一系列超越经济规律的操作，最基础的就是用新投资人的钱还旧投资人的钱，不需要考虑标的物的风险。

更常见的操作是，挪用资金，把投资人的钱挪去做一些乱七八糟的投资，或者干脆私吞挥霍掉。

E租宝的老板当年可是买空了中国所有奢侈品门店的奢侈品，随手送给红颜知己的就是1.2亿的新加坡别墅。

全都是投资人的血汗钱。

当对大额的资金有了无限的掌控权，人性是经不起考验的。

这种资金池在我国是明令禁止的，首先是违背了P2P点对点的精神，其次是只要资金池一开，P2P平台连投资标的都不需要找了，直接玩儿资金击鼓传花就好，靠借新还旧过日子就行了。

这种东西还有另一个名字，叫庞氏骗局。

或者，非法集资。

这是国家重点打击对象。

## 6

资金池是用来管控资金的工具，而假标，则用来立资金流入的名目。

我当时在E租宝最如日中天的时候发文说他们是骗局，然后被搞的很惨。

为什么我敢说他们是骗局？

因为按照他们公开的说法，E租宝的钱是投到了生产设备融资租赁领域，而这个领域的市场是非常透明成熟和稳定的，一般平均费率在8%，而E租宝给到投资人的收益是平均14.6%，并且还给销售团队返佣，累计成本20多个点，这是非常滑稽的一件事，要么他们做生意是来送温暖的，要么就不是来做生意的。

如果不是做生意，那么他们是来干什么的呢？

还有就是E租宝公开的很多借款标的，用公开数据一查（天眼查，启信宝，企查查之类的工具），就能发现2个特征，一个是这些公司实际是由高管交叉持股的，另一个是这些公司的注册资本在近6个月出现异常变动，从小额变为大额，为的就是能吸收更多资金。

甚至仔细看他们的标书，都能发现大量重复的标书。

正可谓傻子太多，骗子都不够用了。

甚至很多实业公司有资金困难，看到P2P这么来钱，都纷纷成立P2P给自己搞自融，有实业担保的旗号，反而卖的更好。

如果现在你还在买P2P，建议你也认真查一查你买的这家公司，投出去的标，到底是什么货色。

如果是号称某某集团旗下的公司，你也认真想想，到底是集团实力给P2P担保，还是集团就靠着P2P自融续命？

这个很重要。

## 7

很不幸的是，我国很多投资人不仅贪婪，而且天真，天真到没有独立思考能力的地步。

他们在拿高收益的时候，从来没有想过一个问题，凭什么。

凭什么，这么多实业家辛苦一辈子，也没有这么高的利润，这么多的上市公司一年的净利润还不到P2P的零头。

这些P2P公司，凭什么给到这么高的收益。

P2P的谎言过于具有迷惑性，投资人又被贪婪蒙蔽了双眼，相信了P2P的一些宣传。

所谓国企入股，很多地方都有一堆僵尸国企，P2P主动上门送上钱和一小部分股份，就成了所谓国企股东。

所谓的上市公司，整个市场上有无数快要完蛋的上市公司，不需要很多钱就可以收购，对于非法集资的P2P而言，这并不困难，例如团贷。

所谓银行监管，银行只保证这个钱是到了标的公司，但是没法保证这个标的公司是不是P2P某个高管的某个亲戚私人控股的，这个超出了银行的业务范围。

所谓保险承保，只是保险保证这个资金在流转过程中安全的问题保险公司负责，不是说保险公司为坏账兜底，保险公司是SB吗，为P2P兜底，好处给P2P拿了。

所谓实业集团担保，其实是实业集团活不下去了，没有正规机构给他们放款了，需要从民间吸钱来续命。

所谓的银行级数据库，只是恰巧机房和当地银行租在了同一个楼。

或许不能说P2P说了慌，只能说是他们没有把真话说全。

有时候真话不说全，就够了。

在这种误导的大环境下，再加上所谓互联网金融的光环，很多人都把一生的积蓄投了进去，他们根本没有意识到自己的诉求是违反经济规律的。

在那个年代，什么阿猫阿狗都去做P2P了，反正投资人傻，只要树立一个概念就会投钱，甚至很多投资人不是傻，是太聪明，是吃准了这家公司要借新还旧，自己投入越早，后面的人会给自己接盘。

但是市场是公平的，大量虚假标的和概念堆出来的击鼓传花游戏，不可持久。

2015年，2017年，2018年，历经了3次P2P跑路潮，每次都会产生大量哭天喊地的投资人。

雷潮来了，一地鸡毛。

## 8

玩假标的公司，死了。

不玩假标的公司，迟早也会死，因为实在是没有优质标的。

原本P2P行业，在2017年初就该全员覆灭了，因为那时候坏账频发，且由于早期P2P都是大额投资标的，一个标的出风险，造成的结果就是一个平台爆炸。

红岭创投的清盘，与早年大额标的的坏账有密不可分的关系，这是他们自己公开承认的。

红岭创投算是大额标的的代表公司。

但更要命的是，大额标的，玩不转了，那个时候要求P2P限制标的规模，企业标的不能超过100W，个人标的不能超过20W，限期整改。

鑫合汇和草根就是那个年代囤积了过多的大额标的，导致历史包袱过重，合规无望，终局已注定，这是给我寄律师函也解决不了的问题。

所有P2P公司都在纠结。

如果假标玩不下去了，资金池没那么容易了，还得保证资产是符合国家要求的小额资产，并且还要保证刚性兑付，应该怎么玩儿？

答案只有一个，高利贷。

绝大多数现在还没倒下的P2P，都是靠搞高利贷在维持。

## 9

上文提到过P2P本身存在的问题，那么能够支撑一个有问题的需求走下去的业务，会是什么状态？

只能是，更疯狂的业务。

每一家P2P公司，都是有历史坏账的，而高利贷的利润，夸张到可以填上这些坏账。

2017年，一个神奇的物种兴起。

互联网小额高利贷。

那个时候还不是714高炮，而是1000到3000元，1到3个月，月费率6%到15%的普通小额高利贷，又叫现金贷。

大量资产慌，且资产不合规，且资产有问题的P2P公司，开始转做现金贷，P2P筹集来的钱，都拿去放现金贷了。

那个时候，现金贷市场还是一片蓝海，获客成本不高，坏账不高，收益不低，并且由于额度小，恰恰好满足了监管的小标的人对人的要求。

大量P2P公司，在现金贷的第一波红利中，赚的盆满钵满，当时做的好的公司，一个月的净收益，是放贷总额的10%。

一头是P2P吸纳来的高额现金，一头是月10%收益的现金贷资产，印钞机开起来了。

很多现在还屹立不倒的P2P公司，都是趁着那个红利期放现金贷，把自己P2P大额标的中的坏账窟窿给填上的。

后来由于参与高利贷的公司越来越来多，底层人民的多头负债越来越严重，这形成了另一个击鼓传花的游戏。

游戏规则是，谁放款的费率高，期限短，砍头息多，谁才能赚到钱。

借款人本身只是待宰的猪。

而P2P公司的屠刀早已挥下，砍头息，暴力催收，生命威胁，各种乱象频发，大家都急着榨干他们的最后一滴血，趁热吃。

可以说，是底层人民的高利贷血汗利息，养活了很多表面高大上的P2P机构，以及那些享受着P2P高收益的所谓【高净值人群】。

很多所谓金融独角兽，吃的是血。

投资人拿到的收益，是带血的钱。

## 10

但是血馒头，也吃不长了。

315曝光了714高炮，大量公司收缩了高利贷业务，大量相关机构被打掉，警方直接把套路贷定义为违法。

但高利贷不死，只要有利润，就一定有人冒着风险去做。

尽管开动印钞机需要鲜血。

但只要不是自己的血，谁在意呢？

放贷者不在意，投资人更不在意，真正在意的人，又不掌握话语权。

315之后的第二个月，高利贷市场就在回暖，贷款超市的流量就在涨价，大量三方数据公司的调用量就在回升。

大家换了更多的壳公司，继续放高利贷。

但我说了，血馒头，吃不长了。

警方打击高利贷套路贷的决心是非常强硬的。

这次，警方的重点打击对象，不再是那些壳公司和贷款超市，这治标不治本。

他们打击的，是不合规的催收公司，催收，才是高利贷的命脉。

一个很简单的道理是，敢来借高利贷的，没有几个是善茬，大多数都是走投无路的人或者陷入赌博等不良嗜好的人，他们的一大特点就是，还款率低，潜逃率高。

公司想吸他们的血，他们也想黑公司的钱。

所以催收公司的手段自然就比较血腥，电话轰炸和语言威胁只是基础，很多催收公司甚至将借款人的照片P到黄图上进行散播威胁，还有的直接伪造律师函，甚至还有伪造公安通缉证明的。

为了钱，他们敢于践踏一切。

这轮打击中，业内最大几家的催收公司（包括为银行做催收的巨头）都被警方调查过，抓了很多人，整个催收行业都在瑟瑟发抖。

如果催收力量不再充足，将直接摧毁高利贷的根基，再高的利息，收不回来，又有什么意义呢？

而如果没有高利贷的暴利顶着，很多P2P公司拿什么来给投资人收益？

游戏再一次玩不下去了，吸不到底层的血，P2P就开始吸投资人的血了。

这个历史重演过很多次，这次也不例外。

## 11

自然规律的一大特点是，不管短期你怎么践踏他，从长期来看，你最终都要为自己做出的一切作出偿还，甚至加倍偿还。

违背自然规律产生的一系列畸形P2P，已经进入到了需要还债的周期。

这一次的雷潮，不止是几家公司，而会是行业大部分公司。

太多公司在玩儿资金池，没有真正搞点对点，而资金池怕的就是投资者信心崩溃。

或者说挤兑。

挤兑的威力，不需要我多嘴。

一家倒下，会导致剩下的人去恐慌性挤兑还活着的公司，从而导致暂时安全的公司也迅速陷入危险，然后会波及更大的公司，乃至整个行业。

就像传染病。

当前的所有P2P，都在面临资金池问题，资产坏账问题，高利贷无法持续问题，以及合规备案的实缴门槛压力。

这次的雷潮，和之前不一样，之前是1到2个问题爆发，这次是个问题一起爆发。

问题同时爆发，会引发投资者信心崩塌，进而踩踏。

这就是我说的风险。

在这个过程中，多数没有知名度和实力的中小型P2P会出现问题，因为他们抗风险的能力极差，甚至我知道很多中小公司都认清了自己没法通过备案的事实，准备清盘或者跑路。

不要再相信这些公司吹嘘的实力雄厚了，最近黑市洗钱业务特别热闹，有多少是他们呢？

而现在广告打得凶的几家巨头中，有几家是心虚的吆喝呢？

团贷倒下的前一天，还在不停铺广告，无数大V给他们站台；

去年好几家头部P2P倒下前，还在公布自己的融资信息；

甚至所谓的P2P权威评测网站，旗下的P2P都跑路了，老板被抓进去了；

这个整个行业里，如果严格按照合规来算，没几家是彻底干净的，这都不算是秘密，是行业内的共识。

而对于投资者而言，可能不需要了解到这么深，只需要知道的是，这个行业不安全，这个行业的根基正在被动摇，新一轮踩踏和挤兑可能会发生。

所以我不建议在这个节点投资在P2P上了，因为一场大洪水即将到来，在洪水中活下来的，才是真正的凤凰，才是值得投资的存在。

古人云：君子不立危墙之下。

而等待，是一种优秀的品质。

在这个年代里，储备现金，留存实力，过冬，才是正确的选择。

蛰伏，等待下一个春天的到来。

起风了，希望我们都能活下去。
