---

layout: post

title: 豆瓣 | 在新疆的一些记录

categories: Archive

date: 2019-02-25

tags: 新疆

image_feature: "https://i.loli.net/2019/02/25/5c73fa6839ff2.jpg"

description: 终于去过一趟新疆了，算是了却了这几年的一个心愿。

---

原文来自「豆瓣」：~~[在新疆的一些记录](https://archive.li/ALvJq)~~

◎作者 \| xzr

---

终于去过一趟新疆了，算是了却了这几年的一个心愿。在出发之前，我很自然地没有把自己纯粹摆放在游客心态上。一来我总是对特殊、相异的生活世界和土地中怀有想象与好奇，这种想象不是指在脑海中对那个地方有了多少浓墨重彩的描摹，而是当自己作为一个异乡人进入的时候，给自己定位了要捕捉文化的状态。其次也是因为这一两年网上看了不少关于新疆的消息，从小受到的关于新疆的话语熏陶似乎也富有张力和“刺激感”，于是就有了很想获取一手讯息的冲动。这两种情结果然在旅途中都开始派上用场，但这一次我对这种初衷多了很多疑惑和不确定的感受。

比如说，我开始厌恶自己在获得各种信息后被点亮的感觉。有一个对见识很在意的朋友对我的行程表示“羡慕”，我觉得这不太对劲。将获取信息作为个人见识/知识的增进并不是独立自洽的。在陌生的情境里收集、阐释未知的信息是一个散发着智识诱惑的过程，吸引人将碎片与更大的图景镶嵌拼贴在一起。但同时，信息的交互性意味着我的“在场”意义，作为游客和外乡人，不意味着可以对信息的具体内容置身事外。我甚至觉得，在新疆探寻事实本身是背负着愧疚的。

## 安检与安全

第一次见识是在乌鲁木齐机场附近的小宾馆。门口有一道安检门，边上有一套防暴服装装备。而踏入的那一刻你就知道这是走走过场，并且在之后还要习惯很多类似的场景。宾馆入住需要照相，对应身份证的头像。一起住的朋友问这是侵犯肖像权吗？前台的大叔说，别说肖像权，人权都没有。我诧异了下，又试图问几句，但几个宾馆的员工似乎都没再回应过我，而是继续就相关话题互相闲聊，什么“社区加班费减少”啊之类的，指的应为以社区为单位，动员社区成员参与的安防工作。我从他们身上读不出情绪。

第一次亲历安检是在乌鲁木齐国际大巴扎的入口。入口分为两道，游客专用道和需要身份证验证的通道。排队的时候还分不清状况，正准备学样掏身份证，马上就有人催促着我往前走，便顺手往机器上扔了双肩包（似乎这个过程也可以省略）。于是凭着一张汉族人的脸，开始了可以无心无肺的标准游客之旅。

而相较大巴扎这种当地人经常光顾的场所，喀什老城和喀纳斯禾木景区对于游客来说，几乎就完全不存在安检包这个动作了。在北疆的两次住宿都是在村里的木屋式旅馆，几乎每家的廊道上都摆放着安检机器和一套防暴设备。和店主闲聊，他们说花了一万块安置了这个机器，摆着特别占空间，并且似乎很快就变成堆砌杂物的地方。

![](https://i.loli.net/2019/02/25/5c73fa63aad84.jpg)

<figcaption>喀纳斯 旅馆走廊上闲置的安检设备</figcaption>

更直观的感受来自喀什。我在喀什老城的青年旅社里住了三晚，我们住的区域是旅游商业氛围相对更低的片区，解放北路西面，艾提尕尔清真寺附近。说相对较低，因为这里的不少建筑很明显就能看出是重建和修缮后的成果。对门是当地小学，拐进周围的巷子即是当地人日常生活的状态。赶上国庆期间，每家每户门口基本都挂上了五星红旗。红旗高密度地飘在名族风情的墙体上方，略减去了一些味道。我每次举起手机，便有意识地避开旗帜。

![](https://i.loli.net/2019/02/25/5c73fa6839ff2.jpg)

![](https://i.loli.net/2019/02/25/5c73fa6abe8fd.jpg)

出入老城的路口都有针对少数民族人士的身份证安检设备，并且有出入时间的限制规定。有一晚半夜三点，我们和几个青旅的朋友一起归来，给这个已沉静入睡的街巷增添了各种声响，过大门的时候，有几个人和值班的警察打招呼、说一声晚安，突然觉得有点酸涩。还有一次，我看到一个戴着兜帽的维族男生从游客通道飞速跑过，成功避开了刷证式安检。

青旅门口的这条路上大约每隔十米就有一个穿着防暴设备的警察，据说密布在城市里的辅警和安保力量吸纳了大量的就业人口。日中的某个时间段，我看到一列穿着橙色马甲的当地人拖着个棒球杆式的长棍在路上走。后来问了当地人才知道，他们是社区里经营店铺的店主，组成了社区自治小队，每天定时巡逻。

老城的这些样貌，对于游客来说，大概也会有一种异样和失落。在给照片取景的时候，不得不要小心翼翼地避开“感觉”破坏了传统建筑风貌的人与物，尽管这个风貌本身也是多了许多人造雕琢成分的，要知道这里可是连路边的电箱都有土黄色的墙饰包裹。但此时的旗帜、标语等是异常耀眼。也在青旅里听人聊起喀什老城，有些人也会悻悻地谈论商业化、景区化，传统文化的被破坏。但我更好奇的是，如果不把游客的身份、青旅与墙外隔离的状态一同纳入讨论（维族人不得接待），这样的讨论会有多么空中楼阁。或者说，相较谈论商业化对维族传统风情的入侵，是不是有更加冷厉的改造值得反思。在喀什的三天，我和汉族人的相遇，常常会听到“这里特别安全” 、“这里比内地还安全”。我不知道这是不知道说什么的客套话，还是一种近乎反讽的说法，我倾向是前者。不论怎样，这套话术非常有用，仿佛立马就合理化了我们看到的种种情形，可以正当地享受差别对待了。

最令我吃惊的一次对话发生在路边。我坐在路边长凳上系鞋带，边上坐着一个汉族警察。他和我攀谈起来，问我来干嘛。我很自然地脱口而出是来旅游。接下来的对话出人意料。他说，我不懂这里有什么好旅游的，你知不知道这里的势态？我解释说，这里的建筑很有特色。他来一句，“你真的觉得这些建筑好看吗？这些都是维族的房子，民族风情的，是要反对的。”之后他低声又说了些要被删除的言论，这些对我来说都太没有心理准备了，那个人的声音低低的，带着北方口音我也没有全部听清，于是想当然地顺着他问了几句。

没想到这个汉族警察突然开始盘问我。“你不会是奸细吧？”“你真的是学生？”我甚至在他的要求下掏出了身份证。他笑着说，94年的还在上大学啊。我有点慌，感觉这个确实有破绽了。最后随意敷衍了几句溜走了。回到住宿的地方，大约有一两个小时都被惶恐包围着，夹杂着愧疚。那是我到喀什的第一天，已经满脑子只想着要离开这个地方了。除了知道自己做错了、给自己找了麻烦之外，他那句“你真的觉得这些房子好看吗”一直盘旋在我脑海里。这让我开始思考自己的初衷，这里的治理气氛已经摆在台面上了，我虽然不清楚这对当地人到底产生了什么样的影响，但是每天进出门被查身份的滋味大概可以想象一些。加上之前的捕风捉影和那个警察和我低声说的那些，我在这里看什么呢？哪里是真实的文化风情？我更难以接受，用这种手段作为对游客安全的保障，然后汉族游客们便可以光明正大地享受精心修缮过的民族特色，一想到白天在巷子里嬉笑拍照的自己突然就感到十分不适。

![](https://i.loli.net/2019/02/25/5c73fa7480858.jpg)

![](https://i.loli.net/2019/02/25/5c73faca91a96.jpg)

喀什老城街头的建筑，是否精致过头了？

## 木卡姆与维族舞厅

街头盘问后，我暗自下决心要做傻游客。而真的让我放松、短暂抛开一切的便是音乐了。在老城里感受的传统音乐和在维族酒吧的氛围让我对这里的生活有了新的理解。

在喀什老城里很容易接触维族传统音乐木卡姆。百年茶馆里经常有机动的演奏，乐器店里主人能来几段展示，街头偶尔也会有即兴的表演。走在路上时不时就被那悠扬婉转的旋律吸引了。

百年茶馆也确实是我在喀什最喜欢的地方了。天气好的时候可以坐在阳台上，点上一壶茶，静静地做着游客的安逸午后白日梦。我们第一次去的时候，选择了室内的“榻榻米”，边上的维族老人热情地给我递来手鼓，示意我们可以尝试一下。而他自己则拨动起了手边的乐器（热瓦甫）。清脆优美的古韵将整个昏暗的茶室都被调动起来。

没过多久，一个身着装饰服饰的老人走来，要去了被游客们蹂躏的手鼓，一段合奏就此开始。我离他们俩坐得非常近，可以细细观察他们的神貌，专注于音乐的样子非常动人。

![](https://i.loli.net/2019/02/25/5c73facd6776b.jpg)

![](https://i.loli.net/2019/02/25/5c73fad22498f.jpg)

<figcaption>路边演奏</figcaption>

这次在喀什呆的三天基本没有提前安排行程，而维族酒吧之旅对我来说应该是非常意外的惊喜了。我估计这也是喀什旅游攻略里绝对找不到的去处。

和我一起去的同伴邀请了她大学时的维族同学，这位喀什姑娘尽心尽力地做好地主之谊。因为知道我的朋友喜欢跳舞，所以特地打听了喀什市内一家有舞厅的酒吧。

卡巴娜酒吧是非常地道的喀什酒吧，除我们之外，95%的客人都不是汉族，更别提穿着冲锋衣的游客了。也因此，这里应该是最有喀什生活味道、可能也是维族最靓青年男女聚集的地方。目之所及，女生打扮精致，穿着凸显身材，极具魅力。反正恍惚间，仿佛掉进了迪丽热巴古力娜扎的圈子…

从装潢来看，卡巴娜酒吧和内地的酒吧没有什么两样，但这里特色的细节真的不少。维族朋友介绍，维族女生不得饮酒，因此这里菜单上的热门产品是红牛和水烟套餐。妹子本来推荐我们喝红牛，被我强烈婉拒，担心这是要两天不睡觉了。而更颠覆我们对酒吧固有形象的大概就是这里舞蹈的方式了。总共有三类舞蹈：维族舞蹈、双人舞和我们所认识的蹦迪。

维族舞蹈有非常明显的男女分野，男生动作幅度大，摆臂有力舒展，手呈拳头状。女生的姿势则柔美抚媚，指尖细节丰富。令人印象深刻的是，舞池里的所有人大多为同性别组队，男生和男生，女生和女生或者几个人围成一圈，合着优美舒缓的旋律匀速围绕舞池漫步。双人舞则基本是女生专场，刚还撑起大半舞池的男生舞伴们相继散去，偶有情侣或者夫妻档。

作为一个肢体僵硬的社恐，这应该是我第二次“蹦迪”，而朋友沐则是一个舞蹈狂热分子。她很快就把我也拉进了人群里。尽管突兀和尴尬笼罩，我还是试图学着身边人的动作尽量地做出舞的样子，因为不论如何都已经是异类分子了吧。沐快速地融入了节奏之中，我则试图感受这里的氛围。可能是总爱盯着女孩子的缘故，我发现维族女生真的是十分羞涩甚至可以说是保守，虽然衣着和内地酒吧里凹凸有致的女生类似，但是动作轻柔、女性化，哪怕到了电子乐的主场，也只是极小幅度地摆动几下。后来，我听带我们来的维族朋友调侃，她坐在二楼，说你们俩一看就是内地来的，总是跳“男生动作”。我笑笑，某种程度上，相比优美矜持的维族女孩姿态，男生动作确实更适合笨拙社恐来模仿。

那晚的高潮应该是沐被邀请进了舞池中央的一个圆圈，和她一起跳舞的维族男孩成为了她之后几天都心心念念的男孩子。而我也认识了据说是全场唯三的另一个非维族女孩，我不确定她是否是汉族。她和她的朋友非常热情地让我加入她们，结束的时候还对着我的耳边说了句“开心”。

在喀什三晚，我们去了两次维族酒吧。第二次维族姑娘回去上班了，沐在青旅邀请了好多个人，浩浩荡荡地用冲锋衣闯入了舞厅。第二天酒吧里的人不多，又或者我们实在太过惹眼，热情的维族大叔甚至过来敬酒和在舞池里主动互动。这也成为了我本次在喀什最难忘的经历之一。其实和老城一样，这里也是进门刷卡、四处红旗飘飘，在炫目、迷离的灯光之下，甚至呈现出一种类似共产朋克的效果。但真的直到来到这里，我觉得我突然没有游客包袱了。在这里可以看到喀什最时髦的年轻人怎么实践现代娱乐，不论是红牛代酒还是舞池里的性别隔离，亦或者一群尬舞的汉族人闯入，里面有许多微妙、值得回味的化学成分碰撞。而我也真的相信重要的是音乐，这是生命本身的魅力。

所以我再次想到那些被我视为压力的标志物，又想到老城街头三五成群聊天、驻足的维族老头，巴扎外凌乱拥挤的人群，真实生活的一种，与那些装饰物无关、与游客无关。

## 青年公务员

最后想写写这里的人。之前的叙述基本都是围绕我看到的、所联想到的展开。必须承认我有时候总会沉浸在自己的敏感情绪里，所以尽可能地想还原下这次遇到的两位维族朋友。

A是我上文提到的带我们转喀什的姑娘。毕业后她在喀什下面的一个县城做经济管理类公务员。因为大学朋友的到来，她特地请假，开车四个小时过来接待我们。B是在我们临走之前和我们一起吃饭的维族男孩，他也在这边的农村做公务员。他是临时听说我们要来的，因为值班难以调度的关系，抽出了一个下午的时间和两位上海人叙旧。A和B都是沐的大学同学，上海杨浦某高校工科专业，我们都是去年毕业的。

说起来这是我第一次接触同龄人里的公务员，竟然是在新疆。当他们用着带有一些口音的普通话蹦出各种官方叙事色彩浓重的词汇和句子，突然也会有种莫名的错乱感。

他们的工作非常忙，几乎是节假日无休。A和我说，她是单位里唯一一个少数民族，领导十分器重她，经常托她来喀什开会、做报告。我们问她是用维语吗？她说，当然是普通话。这个在内地呆了四年的维族姑娘普通话说得非常娴熟，虽然有口音，但基本可以熟练操纵各类流行俚语，有时候我觉得她口头表达的效果和到位程度应该比我强。同样娴熟的是她的从政才能。每周一早晨，A要主持公司里的升旗仪式，用普通话和维语进行报告。她给我展示她如何管理广场上不听话的群众，惟妙惟肖地还原当时的场景。用的方法貌似是我在中小学老师身上见过的：你那么爱讲那么就由你上台来讲吧。

我是后来才知道，A的家庭背景非常优越。和她的爸爸一样，A也有着同样宏远的目标。我们问她有没有考虑读研，她给的答案是中央党校管理类研究生。当时在凯斯尔美食宫里疯狂吃喝的屌丝如我又是一惊，但再一想就没有任何意外。也许从她选择回到喀什工作的那一天起就注定了要有这样的仕途。

A是一个非常精干的人，一如她向我们描述的工作履历。也因此我似乎并不敢多问什么，问她关于工作或者观念上的具体内容。我总有种感觉，起码她在和我们说这些的时候，已经滴水不漏地在一个固定的体系中连接答案了。

她给我留下最深的印象应该是关于情感的讨论。第一天见面时候，她说她有预感可能快要结婚了。而她和男朋友在两个月前刚刚分手。她说一年里有过五个维族男生要和她结婚，有时候她去接电话半天，然后回来和我们说，有个要追求她的80后干部又在找她了。她给我们看干部在微信上给她的写的情诗，把我笑个半死，是非常不含蓄的普通话版本。在凯斯尔的时候，她突然说厌烦总是在情感里理性计算的自己，有了恐婚症，有时候宁愿一个人呆着。我看着她神情严肃地盯着微信（他们都是汉语聊天），就是一个非常普通的同龄女孩呀。也许我的朋友沐，明年真的要去参加婚礼了。

B是完全另外一种人。一个非常内向腼腆的小伙子，吃饭没多久就开始和我们细致地介绍他的日常工作。他是驻村公务员，做维稳工作。我不知道他怎么看待这份工作，但和A一样，我总觉得他选择回到喀什，似乎就必然要走上这样的道路。

他参与的那顿饭，是经常让我感受到沉默和愧疚最多的一次。他说在朋友圈里看到了很多同学出国、读研，而他自己现在只能呆在村里。我想他在意的可能不是工作内容，而是就是在村里的这个状态和身份。

我们安慰他，如果你不选择这个工作，就不会结婚甚至还快有孩子了。B在半年前和单位里的喀什姑娘结婚了，现在妻子已经有了身孕。他给我们看结婚照，妻子非常美丽。他说，刚结婚的时候，想带妻子去上海旅游，已经买好了两千多的机票，因为某些原因所以临时取消了。现在有了孩子，也没有时间再出去。我们帮他计算，也许过两年可以带着孩子一起来上海。

他和A一直说，是的，估计过几年工作会没那么忙（就像我们期盼未来一样）。

B现在从事的工作就是我们之前在网上经常看到的关于新疆的基层治理。他晚上的时候要给村民上汉语课，他说，很多人不会说汉语也因此更难找工作，找不到工作就容易学坏。我问他怎么对待那些不服教导的村民呢？他说，就是靠思想工作，靠谈话和说教。他们身上的压力也很重，如果管理的片区有人在外做了坏事，单位里所有同事都要受处分。

我觉得自己不自觉地开始为他感到失落，在没遇到他之前我就对这份工作有比较负面的印象。而真的接触他之后，我知道眼前的这个人老实、质朴，工作勤勤恳恳，就像对待所有工作一样。我思索这份工作的意义，是不是可以由我来感到惋惜的呢？

B的家庭背景和热完全不一样，他出身农村，初中成绩数一数二，高中去了乌鲁木齐，大学是魔都的985。而每段路程几乎都是几十小时的火车，从喀什到乌鲁木齐二十多个小时，从乌鲁木齐到上海四十多个小时。他现在终于不用经历这么辛苦的旅途了。听说他买了一辆二手车，三万块，夫妻俩一起出资，再加上支付宝里的蚂蚁借贷。

我们那顿在新疆著名饭店海尔巴格的午餐花费接近400，是两位维族同学一起请客的，我想到这对明来说，应该是平时绝不会有的开支吧。

离别的那段饭后，A开车直接返回工作地。B和我们在喀什老城那条旅游街上走一走。他说他自己很少过来，才知道这里发展得这么好，还和我们提到他最近在单位报刊上看到发展喀什旅游业相关的内容。过闸门的时候，他走少数民族通道被拦下，理由竟然是身份证非本地喀什人。一问才知道，他的身份证还保留着上海集体户口的身份证，地址还是XX区某校。我问他这样会不会很不方便？他说，他希望可以一直这样留着。

和两位同学告别后，我们的喀什旅程也快要结束了。花了很多时间在聊天、吃饭上，以至于其实也没怎么真的认真游历过这座城市。老城走过一半，麻扎去了一个，夜市去过两回儿，大巴扎采购了了一点寄回家的干果，没有在老城里买地毯和陶器是我到现在都非常遗憾的事情（可能是被乌鲁木齐大巴扎上一条98万的地毯吓晕了）。

从第一天在喀什路边受到的冲击，到之后两日与维族朋友的相处。信息量很大，但我不确定自己是不是真的准备捕捉和感受了；或者说，我能在多大程度上确定地记录下这些内容。我说我对老城里飘扬的装饰物和严格的管理感到不适，但在街头晒太阳的男人、巷子里嬉戏的孩子、聊天的女人还是过着自己的生活。在夜市里和我们讲解苜蓿馄饨的小哥，后来竟然在酒吧舞池里也见到了。老城里卖金饰的那条路上，家家商铺门口都装了铁栏杆，我对他们真实处境又了解多少呢？

希望有机会再去南疆吧。
