---

layout: post

title: Matters 通讯：中国互联网二十年

categories: Archive

date: 2019-01-29

tags: 中国互联网

image_feature: "https://i.loli.net/2019/01/30/5c5187736652b.jpg"

description: 通过互联网表达的公共舆论在中国公共空间中占有独特和显著的地位。

---

原文来自[Matters](https://matters.news/tag/AMA?&post=06214bb7-d837-446d-bdd9-54ab83b094aa)和订阅号「胡泳」：~~[Matters 通讯：中国互联网二十年](http://wechatscope.jmsc.hku.hk:8000/html?fn=gh_a65e2d46beff_2019-01-29_2650144470_jWdyFA6q0B.y.tar.gz)~~

---

![](https://i.loli.net/2019/01/30/5c5187736652b.jpg)  

![](https://i.loli.net/2019/01/30/5c518773afd90.jpg)

1996年，当胡泳拿到尼葛洛庞帝（Nicholas Negroponte）的书_Being Digital_时，他想到的是严复的《天演论》。彼时，他刚为《三联生活周刊》写了万字长文《Internet离我们有多远》，在详细介绍了互联网的发展脉络与社会影响后，他提出一个疑问：对于当时家用电脑只有70万台的中国来说，能够一转身就跨入信息时代、并与发达国家站在同一起跑线上吗？

![](https://i.loli.net/2019/01/30/5c5187794b2ee.jpg)

<figcaption>《三联生活周刊》1996年第2期专题报道<br>《Internet离我们还有多远》</figcaption>

选出_Being Digital_是为了帮某间正在大规模引进海外版权书的出版社参考什么样的书值得翻译。

“拿到尼葛洛庞帝的书，我想起了严复的《天演论》：《天演论》在当时的英国不是一本特别优秀的书，赫胥黎（Thomas Henry Huxley）在英国的思想家当中也并不算举足轻重之辈，但严复把《天演论》介绍到中国时，中国恰好处在救亡图存的关键时刻，‘物竞天择，适者生存’的理念一下子就拨动了中国人的心弦，所以这本书反而成了仁人志士必读的‘圣经’”。

胡泳翻译出版了尼葛洛庞帝的《数字化生存》，他对尼氏此书做了一些“技术”处理，着意把它译成《数字化生存》——这本书在台湾被译为《数位革命》。他解释说，或许中国从来都比较需要关于生存的讨论，因为我们从来都有大国情结和忧患意识，总是被奋发图强的念头所激动着。某些特殊字眼比如“生存”、“较量”和“球籍”总能挑动中国人敏感的神经。

《数字化生存》最终卖出60万册，如果算上盗版，应该是在百万以上。是年底，胡泳在《三联生活周刊》开设 “数字化生存”专栏，这是继王小波之后，《三联生活周刊》开设的第二个专栏。这个专栏探讨数字化网络涉及的许多根本性和前瞻性问题，该专栏构成了胡泳1997年出版的《网络为王》大部分内容，这是第一本向中国人全面介绍互联网的专著。“数字化生存”、“网络为王”成为当代中国流行语，胡泳也因此成为推动中国互联网早期发展的最有影响的启蒙者之一。

![](https://i.loli.net/2019/01/30/5c51877b5139b.jpg)

<figcaption>数字化生存</figcaption>

除了著述，胡泳亲身参与和推动了一系列活动普及数字化和互联网。1997年，他参与策划和写作的“网络文化丛书”，丛书的出版是中国本土学者阐释网络文化的首次尝试，诞生了当时中国最有权威的网络文化研究群体。1998年，他参与发起中国第一个民间网络思想库“数字论坛”，该论坛旨在促进信息技术对社会发挥全面影响，加快中国向知识经济转变的进程。

2008年，胡泳出版了对中国网络公共领域进行的的深度讨论的《众声喧哗》一书。这本书的开创性在于基于公私之辨基础上，提出当时很多人关心的话题：互联网是不是中国的公共领域？它能不能够改变中国的各种方面，包括政治方面的面貌呢？

胡泳指出：“通过互联网表达的公共舆论在中国公共空间中占有独特和显著的地位。原因在于：首先，中国现实缺乏一套能充分容纳民意表达、并将民意反映到公共政策和公共事务的决策和裁判之中去的机制；同时，中国缺乏新闻自由的传统，人们更习惯的是‘舆论监督’一词，它实际上是对现实政府权力的延伸和补充。”

现在胡泳在北京大学新闻与传播学院担任教授，他的个人微信公众号“胡泳”的介绍语是“数字化时代的生活设计”。如果说从90年代开始，他所生产的大量著述是在普及互联网和数字化，那么，现在他所做的很多工作则更倾向于反思数字化和互联网。

![](https://i.loli.net/2019/01/30/5c51877d288ac.jpg)

<figcaption>数字化之后</figcaption>

在回顾中国互联网二十年的纪念文章中（《[中国互联网二十年：自由的向往，信任的呼唤](https://mp.weixin.qq.com/s?__biz=MjM5MzA1MTQ4MQ==&mid=2650144313&idx=1&sn=0d4ec17003c7ffbe4225c5b777eb49e1&chksm=be9db80f89ea3119888ae700a9a5d67c97ea2fa4b4e995af7dfb2d8e45855f3180622c1c02c8&token=1134241575&lang=zh_CN&scene=21#wechat_redirect)》），他提出今日数字生活的核心困境之所在——**关心数字商业的人数不胜数，然而关心数字社会基本问题的人少而又少**。“我们需要解决的数字社会基本问题复杂而棘手，比如个人隐私与社会公开性的冲突，商业与社区的冲突，安全与自由的冲突，政府监控与个人自治的冲突，繁荣创意与保护知识产权的冲突，日益包罗万象的网络平台与亟待伸张的用户权利的冲突等等。从这个意义上说，数字化革命远未到结束时分。” 

“无所不在的数字化并没有带来世界大同。”尼葛洛庞帝在为《数字化生存》中文版出版 20 周年的纪念文章《数字化之后》（Been Digital）中写道。从 Being Digital 到 Been Digital ，尼葛洛庞帝说，曾经对全球互联网的乐观情绪是他“有生以来最大的误判”。这也是胡泳在《数字化生存》出版 20多年后最大的感受，他在接受采访时说：“数字化革命如果是在技术这个层面上，你可以说尼葛洛庞帝当年预言的很多东西，今天都变成现实了。但实际上，数字化之后的问题可能比数字化之中的问题还要大。”

2018年12月18日，东八区下午2点，Matters 邀請胡泳老师在线与大家讨论，这是一次绝好的机会，了解二十多年后他对中国互联网的反思。

**在线问答**

**Cheng Xi-nan：**胡老师您好。第一个问题，有一种说法是，互联网是现实社会的延申，我们可以从各国不同的互联网环境中窥见其现实社会的一部分，请问这种说法是刻板印象还是已经得到明确支持的观点？

**胡泳：**互联网现在不只是现实社会的延伸，不存在互联网与现实社会的对立。它们现在是一体的。

**Cheng Xi-nan：**所以，从改变互联网环境入手，也是能够改变现实社会对吗？

**胡泳：**是的，必须打破数字二元论的迷思，所谓数字二元论的意思是，认为现实社会和数字社会是两分的。

**Cheng Xi-nan：**第二个问题。关于硬件同软件于教育上的投资（或许会有涉及到STEM教育的问题），您认为教育主管方和涉及到教育的社会各界，该如何缩小数字鸿沟？其他国家有无实例可参考？提出此问，是因为联想到中小学时本地与北京、江浙两地区间在教育上的差异，如数学实验室，利用专用程序辅助学习几何代数问题，江浙地区新世纪初开始全面推行，而本地顶尖高中几年前才刚引入。还有关于个人计算机及互联网的操作，特别是江浙，当上述两地的同龄人已开始运用各类软件甚至尝试编程时，我们许多人只会打游戏，仅会操作少数软件，有关编程的内容直到高中才接触。当看到关于人工智能的教科书率先在上海出版时，我感到深深的寒意，觉得差距如果不靠外界的帮扶，那么同龄人间的差距就不再只是经济了。

**胡泳：**你说的不平等现象不仅中国大量存在，在全球都是普遍存在的。为了了解哪些措施可能有效消除这样的数字鸿沟，有必要将问题予以分类，至少可以分成三类。

第一类，我们可以称为“缺失的链接”，是那些身处偏远农村或贫困地区的学生，对他们来说，上网是有限且昂贵的。对于这些群体，国家需要为网络访问提供经济的和技术的解决方案。

第二类可以称为“荒地”，ICT的特性自身衍生出了这类问题。女性，老年人，以及一些少数民族，发现网络过于机械、孤立和复杂。为了吸引这些群体更多使用网络，软件需要重新设计，应用需要多样化，电脑游戏需要更具想象力。社会要引导那些避开ICT的群体逐步接近ICT。

第三类是“异社会”，学生来自社会边缘，比如留守儿童。这些学生需要指导才能利用ICT提供的资源和机会。这些学生的数字鸿沟不是简单的设备差异，不只是投资于硬件、软件和网络就能解决的。相反，必须致力于解决其背后的社会不平等问题。来自学校内部和家庭内部的差异，会影响学生的学业期望和自主学习的能力。而学生的自学能力，是让一些学生比其他学生更能够从来自ICT这样的开放式资源获得更多利益的关键因素。国家旨在缩小学校教育的数字鸿沟的努力，必须关注所有这些因素。

**曉雅：**胡老师您好，谢谢受邀参与讨论。二十年过去，我们再看《数字化生存》，其价值何在？

**胡泳：**我说道，“been digital”（数字化之后）的问题，可能比“being digital”（数字化之中）的还要严重得多。我把数字化之中产生的种种冲突统称为“旧制度与数字大革命”的冲突，其原因在于，互联网终于由工具的层面、实践的层面抵达了社会安排或曰制度形式的层面。在这种冲突背景下，重读《数字化生存》，最重要的是回到原点，思考一个核心的问题：什么是互联网？这是一个听上去简单、但回答起来很复杂；似乎被回答过、但从未获得真正回答的问题。回答该问题的路径有两条：第一，把互联网予以概念化 ；第二，想象互联网。

**佳凝：**谢谢胡泳老师的分享！您在文章中，强调填平数字鸿沟的重要性。请问您如何看待上周引发热议的通过直播让贫苦地区学生与优质高中的学生同步上课的教育实验？（报道原文：《这块屏幕可能改变命运》 ） 

**胡泳：**数字鸿沟的问题在于，如果你不能够迈过这条鸿沟，你无法成为数字社会合格的一员，因而也就无法享受数字社会带来的种种利益。也因此，任何致力于缩小或者填平这一鸿沟的努力，都是值得鼓励的。

![](https://i.loli.net/2019/01/30/5c5187808cba5.jpg)

 <figcaption>不平等现象是普遍存在的  Belle Chen/绘</figcaption>

**纪小城：**胡老师好～对于您提到的公共讨论问题，据我观察，人们似乎在匿名状态下更容易发表非理性的言论。如果从促进理性交流的目的出发，您认为平台应该鼓励一定程度上的“实名制”（包括笔名等）吗？以及您觉得怎样的鼓励方式是可以接受的呢？

**胡泳：**我本人当然是反对平台实名制的，人们有匿名的正当理由。目前是强制实名制，其能否增加讨论的理性尚可怀疑，但显然已经在其他方面影响了言论表达。不过互联网的整体发展趋势是实名化，原因无他，因为随着我们的生活日益网络化，我们需要可以被鉴别的数字身份。上个世纪90年代早期赛博空间刚刚兴起的时候，人们赞颂着这是一个可以让你重新构筑自我身份的地方——你可以变成一个全新的人。然而到现在，当你的受众在不停地关注着你时，你无法变换身份了。

**映昕：**老师好，我是来自台湾的读者。您在文章中提到数字公民这个概念，当现在互联网被老大哥监控得越来越绵密、言论越来越紧缩，您认为数字公民还有什么突围的空间吗？

![](https://i.loli.net/2019/01/30/5c518782508be.jpg)

<figcaption>监控越来越绵密</figcaption>

**胡泳：**有。当监控社会日益发达的时候，数字公民应该致力于反监控。

**潔平：**来追问一下How的问题，您觉得反监控的着力点在哪里？

**胡泳：**例如，更多使用加密术，乃至区块链。

**iccccce-cream：**比如暗网？

**胡泳：**是的。

**冰码牛：**抱歉胡老师，请问区块链如何能应用在反监控这一方面上呢？毕竟我们知道区块链平台上发生的变动需要记录在每一个节点上（或者说，超过一半）才会被视作有效的。换句话说发生在区块链上的每次变动都是可以被所有节点察觉的，并且可以无限期地追溯记录。不知道胡老师能否举个例子说明一下区块链技术在反监控方面的应用呢？谢谢您。

**冰码牛：**\@iccccce-cream 我认为「暗网」之意更多指的是未被搜索引擎索引的网站。这类网站对大多数互联网用户来说都是从来注意不到的。

只是很多时候暗网也被设计成大多数互联网用户无法直接访问的网络（比如必须要通过洋葱路由才能访问），所以才被人们认为是具有匿名性的网络。但是追究起来，这恐怕不是暗网的属性，而是因为大家使用了洋葱路由或类似的技术连入互联网，才有了匿名这一属性。

**屾：**胡泳老师您好，我是正在准备考研的学生。在整理关于区块链和公共领域这一专题时，第一次了解到了matters，很幸运今天能有机会在这里向您提问相关问题。正如您文章中提到的互联网正“被老大哥看着”，而如今的互联网不仅是一个公开的平台，还成为了个人隐私数据的储存平台，例如，作为通讯工具的微信，我们与他人的私密交流却有可能受到监视，及更早之前的各种被下架的网盘，我们的个人数据在未得到允许的情况下被翻看，这是否是对个人隐私的一种侵犯，尽管在使用前我们可能“同意”过各种条款，但本身这些条款是否就存在不平等的因素？权力对个人隐私的监视又该由谁来界定标准和监管？这种老大哥的监视是否会阻碍网络公共领域的建立？

**胡泳：**互联网发展的早期，主要的意识形态是自由至上主义。其要旨是通过技术项目达至技术乌托邦。通过用技术系统来表达设计者的梦想，互联网被视为解放和民主的催化剂。在这种对互联网的历史性解释中，互联网生来就是要打破政府的桎梏，典型的表达是摇滚歌词作者约翰·巴娄的《赛博空间独立宣言》：“工业世界的政府们，你们这些令人生厌的铁血巨人们，我来自网络世界——一个崭新的心灵家园。作为未来的代言人，我代表未来，要求过去的你们别管我们。在我们这里，你们并不受欢迎。在我们聚集的地方，你们没有主权。”

今天我们都知道，赛博空间根本无法独立，激进的自由至上主义敌不过网络威权主义和大企业的操控。网络威权主义的主要特点包括：维持适度的市场竞争；通过国家所有的网络设施将信息控制视为头号要务；推动国家支持的互联网产业；通过宣传、监控、审查极大地限制个人自由。与此同时，大企业正如你所说，成为数据寡头和信息垄断者。显然，网络公共领域的建立，在互联网发展20年后，正在面临空前的挑战。

![](https://i.loli.net/2019/01/30/5c5187845e5cd.jpg)

<figcaption>约翰·巴娄 -《赛博空间独立宣言》</figcaption>

**李湘：**胡泳老师好，有人说互联网上半场是流量和用户增量的竞争，围绕c端不断挖掘新的消费商业模式，在下半场是存量市场的竞争，是开发已有用户新的商业价值，您怎么看待这个上／下半场的互联网发展说法？又怎么看待产业互联网这个概念？

**胡泳：**互联网下半场的概念，显然是新的互联网巨头为了颠覆既有格局、证明自己存在的价值而发明出来的说法。产业互联网，则是互联网渐渐基础设施化，渗透其他产业的一个必然结果。我个人认为，现在迫切需要关注的，不是互联网的上下半场问题，而是互联网的下一个大场问题，即人工智能的登台。

**李湘：**\@胡泳 我在百度云智学院待过一段时间，很多从事it的技术工作者以及从事人工智能解决方案研发的青年人，要怎么样跟这群觉得技术中立的人交流，普及技术背后的伦理与社会问题？您怎么看待程序员在未来世界或在互联网民主建设方面的作用？

**胡泳：**我在AI加速器给从事人工智能创业的企业家上课，我说道，几千年来简单抽象的东西，对很多人来说，在很大程度上无关紧要的哲学思考，现在是我们这个时代的核心问题。程序员要思考这些问题，人工智能的开发者要思考这些问题。一个学员后来写道，“胡老师讨论人工智能的伦理和哲学意义，说实话，大家边听边在处理公司繁杂的公务，他在那强调法律、人文、社会学、伦理、哲学等思考的重要性，而我们，一群创业中的人，忙着研究变现的人，听得进去的占少数，毕竟我们觉得替代人类的通用人工智能还太远。可是，编辑基因造人新闻的出现让我想起了那堂课，科技发展太快，社会伦理、法律、哲学等等，的确突然变得有意义了。”

**加一：**老师好～我有好几个小小的想法。数字化生存的我们如何认识“个体”生存的价值呢？我们当然是人（一个行为主体一个有思想的动物～），但同时我们在别人眼中只是一个随时调配的数据。这里就会产生一种身份认同危机，大家好像在接受互联网的时候顺其自然接受了“显性数据”的身份。我觉得这是一个必须认真思考的问题，互联网产生的很多问题都来源于此。但我并不知道自己思考的对不对，我只是感觉到大家在接受一个新事物的时候（而且这个新事物具有革命性意义的同时）有没有怀疑过自我身份的合法性。

**胡泳：**你说的很对，我们现在日益异化为“行走的、活的”数据。

**潔平：**胡泳老师好，以前读过您写的关于知乎与公共理性的论文，想问问您如何看待今天的知乎，您觉得是哪些因素改变了它？

**胡泳：**当时我们讨论知乎，是因为相对于高度过滤和小圈子化的微信，知乎门槛的下放和过滤的消减，有助于构建社区成员共同的认知和经验——缺乏这种认知和经验，良好的公共领域就难以建立，也无助于推动公民社会的发展。此外，知乎平台的信息易得性能让人更方便快捷地找到知识内容，获取准确链接，对于公共领域知识的丰盈起到了积极作用。个人觉得，知乎在第二点上仍然是有建树的，但第一点可能更需努力。

**佳禾：**请教老师，您认为互联网应该完全地去中心吗？您觉得时下热门的去中心化技术和应用，对您关切的几个主题有什么明确、即可实现的价值呢？

**胡泳：**去中心是不是内在就具有美好性，大概也是可商榷的。与此同时，有去中心的努力，就有再中心化的冲动。Blockchain也是可能演化成“great” blockchain的。

**帮帮：**\@胡泳 “great”block chain是什么意思呢？

**胡泳：**就是互联网作为一种去中心技术，会催生great firewall；区块链作为新的去中心技术，也难防不成为great blockchain。

**ilvashih：**胡泳老师好，常阅读您的文章，谢谢您长期分享观点。想请教老师，今天一家跨国数字企业，要如何去面对和思考中国的互联网空间？这背后想了解的是，您怎么看Google的Dragonfly计划？

**佳凝：**最新消息是，因为内部抗议，谷歌的中国版搜索引擎计划已经被叫停。 

![](https://i.loli.net/2019/01/30/5c5187863eb31.jpg)

<figcaption>Google的Dragonfly计划</figcaption>

**胡泳：**是的，已经看到了这个消息。个人觉得，跨国数字企业的全球运作，需要认识四个方面的变化：第一，新的联网国家在这个新世界里占主导地位，这纯粹是人口统计学意义上的；第二，一种互联网全球文化正在形成，对于表达自由、隐私、信任和安全，用户其实越来越共享类似的价值观和态度；第三，用户什么都想要，他们并不做鱼和熊掌的区分，也就是说，他们并不认为表达自由、隐私、信任和安全是彼此排斥的，需要从中进行艰难的抉择；第四，新联网的国家更求新，比如社交平台应用更广，而老的网络国家则更多使用传统的网络应用，态度更保守。

**Beryl：**想请教胡老师，上面提到说“曾经对全球互联网的乐观情形是误判”，那您认为这个情况会继续糟下去吗？或者说目前什么方向的发展有可能会改变这样糟糕的情况？

**胡泳：**我认为“dumbing down”会是接下来比较长期的一个发展趋势。所以，虚拟现实的发明者杰伦·拉尼尔已经号召大家删除社交媒体帐号，伯纳斯-李看到他的创造物发展为从假新闻到大规模监视汇聚的大杂烩，网络理想大幅度贬值。 他们都提出了解决计划。也许最根本的解决之道是重新设计互联网。

**光盐：**好奇如果是胡老师重新设计互联网，大概会是什么样子？

**胡泳：**其实就是，当权钱阶层力图将互联网予以再中心化的时候，通过改变互联网的结构，实现两点：第一，给予个人，而不是政府或者大企业，以数据的控制权。第二，让不论什么实体，如果想从个人那里获得信息，都要为个人付钱。

**光盐：**我想请教胡老师，在现代个性化推荐的趋势下，人们从接受到信息的那一刻起感知的互联网世界仿佛就是各不相同的，这样的不相同也就造成更多的撕裂。想请问您对个性化推荐的看法，也想请问在这样的情境下，彼此不同的人们是否还有在网络上寻求共识的突破口？

**胡泳：**目前算法推送的信息是狭窄的、标签化的，可以说个性化推荐是反个性的。

**加一：**老师第二个想法是～我觉得“个性化”是一个迷思，就是大多数人是没有“个性”的（我认为），但互联网去中心化表面上好像个体拥有高度的抉择权，被人（或者算法）建构自我个性来认识自己的存在，尤其是看到主打个性化这类平台就会想太奇怪了。明明是将人限制在内容平台上，却拿人稀缺“个性”作幌子。

**屾：**一个小小的不成熟的想法：个性是一个相对的概念，环境的不同与大小是个性程度的划分前提，在某一内容平台上，相对于大量信息的小众信息对个人而言是否就是一种个性？在众多内容平台的互联网中，同质化的内容平台便不存在个性，但若是放眼各个领域，相对于技术或其他领域而言内容是否又可以成为一种个性？

另一点，技术的美好形容词或许是试图用来掩盖技术背后价值的一种手段。个人赞同技术不是中立的说法，其积极与消极取决于背后设计与操作的主体所赋予其的价值观念。（但是否也可能存在技术自主的发展而超出人的控制范围？

**加一：**\@屾 我定义的个性可能不太一样（按我自己的标准）是真正具备独立思考不人云亦云对事件具有自己的见解这类。只有具备独立思考的能力（前提）才有可能发展出“自我个性”。（我这个定义有点点抽象是因为是按照我自己对个性的理解才讨论的，所以在交流中可能会存在误解。

但第二点突然让我想到“技术决定论”的定义。技术由人所创造但一经诞生，自身的发展逻辑便由不得人。人反过来会受到技术的限制和制约。无论是现在流行的算法还是未来的物联网。所有以“好”的出发点，都需要以怀疑的眼光去看待。

**胡泳：**\@加一 同意目前流行的大多是“伪个性”，或者是被包装的“同一性”。

**FreeKnight：**胡泳老师你好，感谢您的分享！我想问的是您对大陆的GFW的看法，它的存在是否合理？是不是加大了数字鸿沟？我们是不是应该向身边的朋友普及科学上网，或者搬运信息至墙内？您认为GFW什么时候会倒塌呢？

**listanly：**的这个问题，实际你自己已经给出答案了

![](https://i.loli.net/2019/01/30/5c5187877cefa.jpg)

**更多阅读推荐**

1.[胡泳 \| 中国互联网二十年：自由的向往，信任的呼唤](http://mp.weixin.qq.com/s?__biz=MjM5MzA1MTQ4MQ==&mid=2650144313&idx=1&sn=0d4ec17003c7ffbe4225c5b777eb49e1&chksm=be9db80f89ea3119888ae700a9a5d67c97ea2fa4b4e995af7dfb2d8e45855f3180622c1c02c8&scene=21#wechat_redirect)  

2.[胡泳 \| 我们处在巨变的前夜](https://mp.weixin.qq.com/s?__biz=MjM5MzA1MTQ4MQ==&mid=2650144386&idx=1&sn=fb0d1016f084874609b65e18c70bf893&chksm=be9db8b489ea31a24c4b475669af93062f04e0d5a11b94cf7fb040c93692d24c4e8541ea63bf&token=1111738889&lang=zh_CN&scene=21#wechat_redirect)

**赞赏**

**中国互联网二十年**

![](https://i.loli.net/2019/01/30/5c51878947549.jpg)

长按识别上方二维码赞赏支持，  

谢谢支持！

beingdigital

本人公号所刊载原创内容之知识产权为本人所有，未经许可，禁止进行转载、摘编、复制及建立镜像等任何使用。欢迎读者沟通交流，请微博@胡泳 或长按下图二维码关注、留言。

“数字化时代的生活设计”

![](https://i.loli.net/2019/01/30/5c51878aec0b3.jpg)

扫码关注东方历史评论

![](https://i.loli.net/2019/01/30/5c51880cacfcc.jpg)
