---

layout: post

title: 拍出四万亿鼓励生育，可行吗？

categories: Archive

date: 2019-01-22

tags: 人口保卫战

image_feature: "https://i.loli.net/2019/01/27/5c4db2e66ee47.jpg"

description: 城市是为人而存在的，而不是人被城市所取舍。

---

原文来自「虎嗅APP」：~~[https://mp.weixin.qq.com/s/0DnMjwHQDmQ5M6izfj2R5w](拍出四万亿鼓励生育，可行吗？)~~

---

![](https://i.loli.net/2019/01/27/5c4db2e66ee47.jpg)

虎嗅资讯组出品

采访 \| 刘然，周超臣

作者 \| 刘然

编辑 \| 周超臣

题图 \| 视觉中国

**全面放开并鼓励生育已经到了刻不容缓的地步。**

携程创始人、人口学家梁建章不止一次地公开表达过这个观点。

就在昨天（1月21日），**国家统计局公布了2018全年出生人口——1523万人，比2017年（1723万）减少200万，更是比之前卫计委对2018年的最低预测（2082.4万）少了559.4万。**

![](https://i.loli.net/2019/01/27/5c4db2e7083cc.jpg)

<figcaption>卫计委对各年出生人数的预测</figcaption>

而这只是出生人口大幅萎缩的开始。人口，真的已经成为中国未来面临的最严重的问题吗？

虎嗅日前在北京专访了梁建章和他的合作者黄文政。对此，他们给出了肯定的答案。

谈到这些数据，他们坦言：“虽然我们一直在警示中国面临低生育率危机，但现在看来情况比我们预料的还严重。我们之前的预计是2017年人口会达到峰值，但实际是从2016年就开始出现下降，而2017年的出生人口比我们的预计还少70多万。”

人口和生育问题，在他们看来，已经成为中国改革开放下一个40年里亟待解决的头等大事。而且，放开生育并不能解决根本性的问题，“鼓励生育已经刻不容缓”。

取消征收社会抚养费、取消生育审批制度、扩大义务教育范畴、缩减中小学教育年限、修改收养法、设立育子节、取消对非婚生育的歧视政策......都是梁建章和黄文政提出过的一些具体建议。在这次的采访中，梁建章还表示，**要想鼓励生育，最重要的还是要有“真金白银”，**就是采用减税和现金补贴的方式——**最起码要用GDP的2%~5%，也就是近四万亿人民币来鼓励生育。**

数字虽有点耸人听闻，但梁建章十分笃定地对虎嗅说：“这个钱必须要出，而且从长远来看，这是最值得出的一笔钱。”

在他们看来，中国经济面临着比较严重的产能过剩，对生产能力和基础设施存在许多低效、无效甚至负效的投资，但对经济环节中最核心的人力资本的投资严重不足。

 “钱要用在刀刃上，通过减轻家庭负担来扶助生育和养育，将是未来回报最高的投资。”梁建章如此说。

![](https://i.loli.net/2019/01/27/5c4db2e94803d.jpg)

<figcaption>梁建章日前接受虎嗅专访时所拍，拍摄：虎嗅，周超臣</figcaption>

梁建章认为，**有关养育的减税是一个好的开端，但目前的力度还远远不够。**现在中国城市养育成本非常高昂，每月补贴额度至少要到上千元才能对家庭起到现实的帮助，并对提升家庭再生育意愿起到积极作用。梁建章和黄文政还表示，要切实提升生育意愿，政策上目前能做的一件事半功倍的事情，可能是给所有0~6岁的孩子提供免费托儿所和幼儿服务。

对于如何建立起生育友好型社会，**黄文政建议从全面核查并更新教科书中有关人口与生育的内容开始，**并逐步树立以人为本，正面看待人口对社会的基础性意义，尊崇生命，善待生育的理念。黄文政表示自己曾组织团队审阅过目前的中小学教材，发现几乎所有科目中的有关内容都还在片面夸大人口的负面效应，宣扬限制生育的观点。

而关于教育制度改革，梁建章还提出过一个引发了争议的观点，就是“缩短学制”。谈到这点，他笑道：“缩短学制恐怕是针对提升生育意愿最有效的措施，一是可以缓解高考压力；二是有助于缓解越来越普遍的晚婚晚育现象。但这个改革力度就要非常大了。”

目前，在全面放开生育政策的窗口期，关于放开生育甚至鼓励生育的呼吁已经成了主流的声音，那么，随着人口增速的减缓，在全面放开生育之后，会不会出现一些惩罚少生甚至不生的强迫性措施呢？

对此，**黄文政和梁建章也表示，生育权是个人和家庭的基本权利，生或者不生、生多少和何时生都应该是公民个人的选择。政策上可以通过减负的方式来鼓励生育，但不能以惩罚少生或者不生的方式来进行某种程度上的“强制”生育。**

梁建章、黄文政与虎嗅谈及的另一个重要的话题，是城市化这一世界性趋势。

数据显示，2008年，有超过50%的人生活在城市中，而到2050年，这个比例预计是70%。但世界范围内的大都市化将成为生育率的另一个“杀手”，因为生活在城市中的年轻人，面对着高昂的生活成本和巨大的职业压力，他们的生育意愿只会更低。

城市化尤其是大城市化，是经济技术发展的自然结果。人口的聚集能够提升生产和生活的效率，而技术的改变使得这种高效的聚集成为可能，这种规模的城市和城市群也已经成为世界经济和技术发展的巨大引擎。但在100年前，人们一定很难想象地球上会出现上千万人口规模的城市。

但是，黄文政还表示，城市化的基本思路并不是主动扩大城市规模，而是顺应人们的选择，让他们根据自己的意愿选择自己工作和居住的地方，政府在此基础上来规划和建设公共资源。在人口和其他要素能充分自然流动的状态下，社会的资源配置和经济活动更容易达到均衡和优化。

梁建章和黄文政曾经比较过世界不同国家的人口和其一线城市的状态，他们发现，如果没有人为的限制，人口能够自由流动的话，中国的一线城市如北京、上海有可能会达到四五千万人口的规模。

在黄文政和梁建章看来，**人口在北京和上海等一线城市的聚集是中国十多亿人口规模优势的体现，但目前北京和上海的人口都可能远小于其经济均衡状态下的规模，**这有可能让中国许多创新性发展的机遇消弭于无形。

总之，解决人口问题已经迫在眉睫了。

**以下是虎嗅对梁建章和黄文政的专访内容：**

### “政策需要名正言顺地放开”

![](https://i.loli.net/2019/01/27/5c4db2ea891ce.jpg)

![](https://i.loli.net/2019/01/27/5c4db2ecd4fd0.jpg)

<figcaption>左为梁建章，右为黄文政，拍摄：虎嗅，周超臣</figcaption>

**虎嗅：**现在已经到了全面放开生育的窗口期，正值两会就要召开了，二位认为这个议题会不会拿到桌面上讨论？有多大的可能性会被通过？

**梁建章：**根据以往的惯例，重大的人口政策调整都是在党的全会（全体会议）中宣布。**如果在两会之前没有宣布，预计两会期间可能会有一些全面放开生育的提案和建议出现，但政策正式宣布可能还是会在比如四中全会上。**

实际上，计划生育机构已经在中央和省级被撤销，大部分地区对所谓计划外生育已经不再追究，但全面两孩政策在名义上依然存在，一些基层组织还是抱残守缺，所以在中央正式宣布全面放开生育之前，人们还是无法名正言顺地按意愿自主生育。

**黄文政：**由于计划生育是我国长期的基本国策，整个计划生育体系非常庞大，除了官方之前的计划生育部门外，半官方的“计划生育协会”在计划生育的实施中一直起着重要的作用，而这个机构还在正常运作着，同样，曾在章程上以人口控制职责并在长期高估我国人口的官方人口预测上发挥重要作用的“中国人口学会”依然非常活跃。**要消除之前计划生育系统的影响并非一日之功。**

**虎嗅：**两位一直在不停地呼吁全面放开生育，你们会有特殊的途径可以传达到决策层吗？

**梁建章：**我们曾经起草和协助起草过一些内参，但整个政策的调整应该是很多因素共同作用的结果。令人欣慰的是，目前舆论的形势比我们最初关注这个问题时要好得多。现在，**呼吁全面放开并鼓励生育的声音已经逐渐成为主流了，持不同观点的也只是一小部分人**，现在最重要的就是紧迫性。

### “未来的人口是从逐步萎缩进入到快速萎缩”

![](https://i.loli.net/2019/01/27/5c4db2ee21d51.jpg)

**虎嗅：**前两天有报道说，最能生的山东省如今的生育意愿也很低，而之前，山东省生育的二孩数量是非常多的，这是为什么？

**梁建章：**我们一直在警示中国陷入低生育危机，但现在看来我们之前还是太乐观了。在全面两孩实施之初，我们曾预计是2017年人口达到高峰，但实际上，2016年就出现了下降，2017年的出生人口比我们当时预计的还少70多万，比卫计委的预测少了300万，我们当时的预测是2018年开始萎缩，2018年以后开始急剧下降，但是去年则已经开始急速萎缩。

**黄文政：**山东的传统观念还比较重，相对其他省份还比较愿意生，但是之前的计划生育政策执行地非常严厉。所以在二孩放开以后，反弹得比较厉害，也因此，在反弹之后，下跌幅度也会比较大。但不管怎样，山东的生育意愿也是远远不足以阻止出生人口大幅下滑的。

**虎嗅：**今后会继续下滑吗？

**黄文政：这两年出生人口的小幅反弹在很大程度上来自于全面二孩所释放的堆积生育。随着堆积反弹的高峰过去以及育龄女性数量大幅减少，出生人口会继续下滑，但下滑幅度会有所减缓。** 我们预计2018年会比2017年少（如开头所述，最新数据显示，2018年比2017年减少了200万），2019年减少幅度会在100万左右。

**虎嗅：**假设今年全面放开生育，会不会改善下滑的趋势？

**梁建章：**全面放开之后会略微缓解一些，但无法改变出生人口大幅下滑的趋势。**在十年内，中国出生人口恐怕会跌到1000万以下。**

**黄文政：**导致中国出生人口在未来十年急剧下滑有三大因素——

**一是堆积生育逐渐释放完毕。**按中国现在的生育意愿，生一孩的家庭中大概只有一半会生二孩，所以正常情况下二孩的人数应该只有一孩的一半。但2017年的出生人口中，二孩有800多万，比一孩要多出22%。由此可以判断，**2017年的800多万一孩中恐怕有四百万以上都是因为堆积生育导致的。 等到堆积生育释放完毕，生育率会减少约1/4。**

![](https://i.loli.net/2019/01/27/5c4db2efdd739.jpg)

**二是育龄高峰期（22~30岁）的女性在十年里萎缩了约40%。**这背后是出生人口从1990年的2700万降到1999年的1400万左右的背景——即使大力鼓励生育能成功提升生育率，每个女性平均生育数量的提升也无法弥补潜在母亲数量的大幅减少。

**三是城市化和教育水平的提升。**生育年龄的不断推迟，还有城市甚至乡村已经普遍把生育一个孩子当成默认选择，这有可能进一步降低生育意愿和实际生育率。根据2017年全国生育状况调查，中国农业户口女性的生育意愿只有1.91，而非农业户口女性的生育意愿只有1.46。相比之下，日本和韩国的生育意愿都高达2，虽然它们的实际生育率分别只有1.46和1.22。**也就是说，中国农村的生育意愿都比以低生育率著称的日本和韩国还要低。**

![](https://i.loli.net/2019/01/27/5c4db2f1a75c1.jpg)

<figcaption>韩国鼓励生育的经验</figcaption>

**虎嗅：**当全面放开生育之后，未来还会不会出现人口快速增长的情况？

**黄文政：**没有任何可能。我们现在能讨论的只是，大力鼓励生育能在多大程度上缓解未来人口的急剧衰减。

“中国人口在1980年之前增长过快才需要控制生育”这个观点广为流传，但很多人并不知道，**从1950到1980年，中国人口虽然从5.4亿增长到了9.8亿，但这个增长幅度却是同期主要发展中国家中最慢的。**在1950年全球人口最多的30个国家里面，除了阿根廷，其他所有发展中国家同期人口增长都快于中国。而中国这期间的增长很大程度上还是得益于人均寿命从40岁增长到66岁。

**梁建章：**还有，虽然这段时间中大部分发达国家人口增长比中国慢，但这是因为它们之前就已经经历过，由于卫生条件和医疗条件的改善而延长人均寿命所带来的人口增长。而中国这种增长发生在1950~1980年，**相比同期的其他发展中国家和历史上的发达国家，中国的增长几乎是最小的。从国际角度来看，中国从未经历过人口的快速增长。**

### “鼓励生育，不是惩罚不想生的人”

![](https://i.loli.net/2019/01/27/5c4db2f2e8e15.jpg)

**虎嗅：**很多人现在不愿意生育，或是不敢生，也有越来越多的女性认为自己更独立更自由，在生育这件事上有自己的主张和态度。所以，除了政策方面，还可以通过什么方式来提高中国人生孩子的意愿？

**梁建章：**这是综合性的。从国家层面来说，需要很多配套措施来降低育儿成本。

在很多发达国家，学龄前机构和托儿所就是一个降低妇女育儿机会成本的重要手段，这方面在日本、韩国也全部是由政府买单，如果妈妈生育完选择继续工作，她的孩子只要是想进去（托儿所）就能进。但中国目前离这个目标很远，进度相当于0。还有中国的高考，中国父母在小孩教育方面投入太多了，在中国，高考变成了一个如此耗费精力的事情。

很多国家都走过这条路。如果这些成本都降下来了，中国人的生育意愿会大大提高。我们曾提到过，**中国是全世界最不想生孩子的国家，因为最主要的几个育儿成本都是世界上最高的，但我们现在依然还是限制生育最严厉的国家。**

当然现在国家有在税负上帮人们减轻负担（新实施的个税专项扣除），但是这针对的是有3岁以后小孩的家庭，而实际上，**负担最大的是拥有0~3岁宝宝的家庭。**

中国最近几年初次生育孩子的母亲年龄上升非常快，大概每年上升0.2~0.3岁，即，大家越来越晚育，这就导致母亲年纪越大，但生的越少，而且更加细养。 女性有自己的职业发展是好事，但也会推高养育的机会成本，反过来进一步降低生育意愿。

**虎嗅：**废除户籍制度能否有助于提升生育意愿？

**梁建章：**现行户籍制度限制了民众的迁徙，让人们无法随自己的工作和生活意愿自由流动，阻碍了同一劳动市场的形成，不利于人力资源优化配置，人为造成了城乡和地区隔离，让许多外来工作者无法真正融入所居住的城市，这自然也会影响到生育意愿。

从这个角度来说，废除户籍制度，实现真正的城市化显然有助于提升外来人口安居乐业，从而提升生育意愿。但光废除户籍制度远远不够，即使大学生和农民工们能在城市落户，但如果他们自己买不起房子、孩子入不了托儿所、上学校还得排队......那他们还是不愿甚至不敢养儿育女、修生养息的。

**虎嗅：**目前全面放开甚至是鼓励生育已经成为了主流声音。但在全面放开之后，会不会出现一些惩罚少生甚至不生人群的强制性措施呢？

**梁建章：鼓励生育本来是一个对大家都有益的事情，但如果演变成强制生育，那会适得其反，不仅无法有效提升生育率，反而会引起年轻一代的强烈反感。**

我们的基本立场是：**生育应该是个人的选择，民众有生也有不生的权利，政府没有权利强制要求民众生育。**确实，从社会整体角度来说，生育归根结底是在，是家庭用自己的辛勤劳动来养育孩子的方式来贡献社会。因此，**对愿意多生的人，政策上可以采取各种措施来降低养育家庭的负担，但绝不能以惩罚少生或者不生的方式来完成某种意义上的强制多生。**

归根结底，生育应该是个人和家庭的基本权利。

### “最重要的还是真金白银”

![](https://i.loli.net/2019/01/27/5c4db2f4325e8.jpg)

**虎嗅：**二位之前提到过，应该将生育率提升到2.2的更替水平，这个数字是怎么来的？

**黄文政：**通俗来说，生育率是指每个家庭平均生育孩子的数量。由于出生时，男孩一般比女孩多，而且并不是每个女孩都能存活到生育期结束，在发达国家，每个家庭需要生育至少2.1个孩子才能维持孩子数量与父母辈一样多，保持人口最终不衰减。

中国要维持人口不衰减的更替水平是2.2，比发达国家要求的2.1还高一些，这是因为中国的出生男女性别比更高一些，需要出生更多的孩子来弥补女孩的不足。但随着生育政策全面放开以及重男轻女思想淡化，中国出生男女性别比会趋于正常，女孩夭折率也进一步下降，中国所需的更替水平也会逐渐降至2.1。

**虎嗅：**你们提出过建立全面审核中小学教科书中有关人口与生育的内容？这有什么背景吗？

**黄文政：**要建立生育友好型社会，积极的养育观念非常重要。我曾经仔细核查过目前中小学教材，发现几乎所有科目有关内容都是一边倒地片面夸大人口的负面效应，宣扬限制生育的观点。 **我希望教育部门能核查并更新从小学到中学教科书有关人口与生育的内容，并逐步树立以人为本，正面看待人口对社会的基础性意义，尊崇生命，善待生育的理念。**

**虎嗅：**对于二位一直提及的鼓励生育要拿GDP的2%~5%进行补贴，具体措施除了您说过的取消征收社会抚养费、取消生育审批制度、扩大义务教育范畴、取消对非婚生育的歧视等，最近您还有没有最新的建议？

**梁建章：**有关养育的减税是一个好的开端，但目前的力度远远不够，力度远远不够。比较重要的是钱要用到刀刃上。**鼓励生育成功的国家很多施行的是累计制度补贴，即到三胎四胎的补贴力度会更大，而中国现在连三孩还没放开。**

现在中国城市养育成本非常高，每月补贴额度至少要到上千元恐怕才能对家庭起到现实的帮助，也才能对提升家庭再生育意愿起到积极作用。要真正提升生育意愿，政府目前能做的一件事半功倍的事情，可能就是给所有0~6岁的孩子提供免费托儿所和幼儿服务。

另外，**对提升生育意愿最有效的措施还是将中小学的学制从12年缩短到10年，这样一是可以缓解高考压力，二是有助于缓解越来越普遍的晚婚晚育现象。但这个改革力度需要非常大。**

### “教育改革需要很大力度”

![](https://i.loli.net/2019/01/27/5c4db3182101f.jpg)

**虎嗅：**所以您建议学生16岁就参加高考？

**梁建章：**中国对教育非常重视，将来我们可能会像日本韩国那样，70%~80%的人都能上大学。所以，我并不是说学生到了16岁就要结束学业出来工作，只是他们可以早点上大学，然后早点毕业。当然还有相当一部分人会选择念研究生，所以最终的毕业生中很大一部分人其实还是20多岁，只不过这些人不用等到24~26岁再工作。

其实高考的内容在过去几十年没有太大变化，但学生在这方面投入的精力却是一代比一代多，这属于是精力和时间上的巨大浪费。

**虎嗅：**教育这方面，一线城市像北京、上海对教育资源的需求最旺盛，家长也会为此花很多的钱，您认为这样的大城市应该率先作出示范作用吗？

**黄文政：**有个看起来非常矛盾的现象。在北京、上海等中国大城市里，包括外地户籍在内的孩子，占人口的比例在全世界都算是最低的。虽然孩子如此之少，但这些城市的上学却极其困难。为何如此？其实，只要去北京统计局网站上查一下就知道，过去几十年来，北京的中小学数量一直在直线减少。比如，从1995年到2015年，北京的小学生数量已经萎缩了28.7%，但小学数量却减少了62.3%（从2867所降到了1081所）。

**可以说，大城市教育资源的短缺是人为的。****这很大程度上是因为对教育容量的规划是基于人口控制思维，而且往往侧重于服务户籍人口。**整体来说，中国对基建和产能的各种投资规模非常大，但对人的投资却是是远远不够的。这种现象在一线城市尤为突出。

**虎嗅：**政策上可不可以用“农村包围城市”的手段？相对来说，农村人对生育的传统观念更重。

**梁建章：我们不要对农村的生育意愿抱有太大幻想。** 文政前面提到，中国农村的生育意愿虽然高于城市，但却还不如日本和韩国（以低生育意愿著称）。其次，农村现在的人口也在不断萎缩，大家都去城里了。这反过来又影响了农村孩子上学，原来在村里上小学比较方便的学生，现在就送到县城甚至城市里去上学，比城市更不方便。

我们目前的城市化水平远远低于我们的经济水平，只有不到60%，而同等发展水平的国家城市化率基本达到70%以上。因为土地、户籍制度的限制，中国实际城市化水平应该比数字显示的还要低。**要真正缩小城乡贫富差距，尤其是解决农村的贫困问题，真正的、充分的城市化是唯一出路。**

![](https://i.loli.net/2019/01/27/5c4db31937b3d.jpg)

<figcaption>黄文政接受虎嗅采访，拍摄：虎嗅，周超臣</figcaption>

**虎嗅：** 那么新农村建设、就地扶贫等政策能否解决农村的贫困问题呢？

**黄文政：这些政策的动机是好的，但却治标不治本。** 最重要的是，社会越富裕，人们花在食品上的开支占收入的比例会越来越低。这体现在，农业GDP占全部GDP的10%都不到，以后可能农业GDP占整体GDP的5%都不到。也就是说，农业这块蛋糕会相对越来越小，**你让40%不到的人口去分享一个10%不到的蛋糕，他们怎么会变富起来？**

**梁建章：**只有让这些人不仅在城市工作，更在城市生活和消费，**在思维习惯和生活方式上完全融入城市，他们才能完全进入现代经济循环，维持经济的可持续发展。**

### “人口颓势将拖累经济发展”

![](https://i.loli.net/2019/01/27/5c4db31976a3c.jpg)

**虎嗅：**长期低生育率带来的另一个问题就是老龄化。老龄化对中国经济带来的影响最大的时候会在什么时候？

**梁建章：**老龄化会加重中国养老的压力，当然未来养老福利肯定会提高，政府可以通过延长退休年龄的手段，关键还是对城市活力的影响。我们现在正是有一定的规模优势的时候，还可以跟美国比肩，**但谈规模的话还是要看创新和消费，这就要看年轻人的数量了。**

你可以算笔账，世界上人口变化最剧烈的一次，是刚说的从1990年到1999年降了一半，这体现在经济上的话，就要看90后这批人什么时候到30岁。目前，80后这个庞大的群体正处于30岁到40岁之间，所以我们现在的经济能力还不错，但是10年之后，年轻力壮的人突然少了一半，你说这对社会活力和各方面的能力产生什么样的影响？

**虎嗅：**人口减少会不会带来人均GDP的增加呢？

**梁建章：**综合来看，**人口雪崩带来的不仅是整体国力的衰微，也会导致社会相对贫穷。**更重要的是，任何一个群体，只要生育率一直低于更替水平，最终必定消亡，所以把生育率提升到更替水平以上，是维持民族繁衍的基本前提。**但****中国现在已经明显陷入超低生育率陷阱，出生人口乃至总人口的雪崩现在看来已经难以避免，最终要把生育率提升到更替水平，更是难比登天。**

**黄文政：**这完全是一个误区。经济发展的本质是需求与供给的匹配。人口越少，需求和供给的多样性和规模效应都会下降，匹配的效率也会降低。所以，**与很多人预料的恰恰相反，人口萎缩最终不仅降低GDP总量，也会导致人均GDP相对下降。**

这点也为各种实证分析所印证。比如，江苏如东、湖南常德那些当年计划生育更成功的地区的人均GDP增长都要明显低于邻近可比地区。生育率低迷，人口在全国占比不断下降的东北地区的人均GDP，在1980年比全国高39%，现在却比全国低14%。尽管影响东北发展的因素非常多，但长期低生育率下的人口颓势是一个最基础性的因素。

**虎嗅：**怎么评价现在的大城市化，比如北京和上海？

**梁建章：北京比上海还差一个等级。最起码上海建成区的交通和轨道的建设很到位，让人很舒服，而北京的轨道交通建设力度还不够。** 但上海也有问题，比如昆山就比青浦好很多，虽然青浦离上海更近，但规划的很差，还留了很多农田。这个问题全世界都有。

一般来说，**全世界城市的本地人、持本地户籍的人都不希望城市太过发展，他们希望维持房价，维持一个低密度人口的状态，不让贫困人口进来**，但长期来说，这对一个国家的经济发展是不好的。其实北京和上海是特例。现在一些二三线城市也已经意识到这个问题，它们现在越做越好，还能发挥中心城市的辐射作用，这是相当不错的。

中国有14亿人的人口规模优势，这就体现在一线城市上，可以说14亿人中最优秀的一部分都在一线城市奋斗，一线城市扩张的张力就在于该地的经济效率有提高。但是现在，**对大城市的人口进行控制，其实就是把中国14亿人口的规模优势里面最重要的着力点给打碎了。**

**虎嗅：**那我们是不是应该增加更多的超级大城市？

**梁建章：理想状态下，上海、北京可以容纳4000万、5000万人口，广东深圳那块现在没有限制，可能有五六千万。** 这三个区域加起来就是1.5亿~2亿人口。另外还剩下12亿人口，如果把6亿人口放到前十大城市，剩下6亿到前20大城市，那每个城市还需要2000万人口，二线城市无论如何也需要大幅扩张，不会影响一线城市。

**我们的核心观点就是让人自由活动、自由迁徙，如果这个社会公平的话，我住在哪里是我个人的选择，我做我最好的选择对这个国家来说其实是最好的**，我愿意做这个事情、付出这种劳动但国家有限制，这对国家经济是个损失。

我们不是说一定要去人为扩大城市规模，而是认为应该在公平的基础上，让民众根据自己的意愿来选择工作和居住的地方。**实际上，在信息不被刻意扭曲的前提下，民众做对自己最有利的选择，对社会整体来说也是接近最优的。**如果个人在不妨碍他人的基础上非常希望做某件事情，但因为政策限制不能去做，那这自然就是民众福祉乃至整体经济机会的损失。大城市人口控制政策就会带来这种损失。

因此，我们认为，政府应该做的不是按决策者心目中的目标去人为限制或者扩大城市规模，而是顺应民众的意愿，让他们自己选择对自己最合适的工作和居住地，在此基础上合理地预测和人口的流动，并据此规划和建设城市公共基础设施。

**城市是为人而存在的，而不是人被城市所取舍。**

> #扫描或在手机上长按下方二维码，马上来读梁建章与黄文政合写的专栏 《人口保卫战：大国崛起的机会与陷阱》。在这个专栏中，两位澄清了人们对人口问题的诸多普遍误解，揭示了人口危机的真相、其中的风险、未来社会的机会与挑战。作为严肃的人口学著作，这个专栏出乎意料地好读。
