---

layout: post

title: 杰华 | 都市里的农家女：性别、流动与社会变迁

categories: Archive

date: 2019-01-17

tags: 打工妹

image_feature: "https://i.loli.net/2019/01/24/5c49a0f370a86.jpg"

description: 打工妹的形象是另一种“他者化”的标志，围绕着它使占主导地位的国家认同理念得以构成和延续。

---

原文来自「社会学学社」：~~[杰华 \| 都市里的农家女：性别、流动与社会变迁](http://wechatscope.jmsc.hku.hk:8000/html?fn=gh_52fce386e69f_2019-01-17_2247489897_6tjYzdukV0.y.tar.gz)~~

---

![](https://i.loli.net/2019/01/24/5c49a0ef74c48.jpg)

塔玛拉·杰华（Tamara Jacka，1965.2.17-），阿德莱德大学博士，澳大利亚国立大学亚太研究学院高级研究员，政治与社会变迁系教授，主要研究领域有性别、亚洲社会研究、社会与文化人类学、发展人类学。其著作《都市里的农家女：性别、流动与社会变迁》作为年度最佳东亚人类学专著获得2007年美国人类学学会颁发的许烺光奖（the American Anthropological Association's Francis Hsuprize for best book in East Asian anthropology in 2007）。\[图源：ANU\]

![](https://i.loli.net/2019/01/24/5c49a0efb44ad.jpg)

本章考察打工妹主体位置的系谱，作为理解中国打工妹经验的一种开始方式。构成这一章的两个基本命题是：首先，在占支配地位的国家框架和流行话语中，流动者被视为本质上不同于城市居民的外来者，他们在这种国家框架和流行话语中构造和表现他们的认同、理解他们的经验，反过来这些构造、表现和理解他们的认同和经验的方式又作用于国家框架和主流话语本身。因此为了理解打工妹的生活，我们需要理解在主流话语中对流动者主体的构造。第二个初步命题是，一个社会中作为边缘的、非常规的、低等的或外来的“他者”的特殊群体该如何定义和表述，对于构成和维护关于社会的认同以及关于什么是“正常的”或“好的”公民的常规或主流观念，是相当重要的。在中国的例子当中，学者们最近开始考察农民、女性和少数民族的“他者化”（othering）如何交叉作用和贡献于现代性和国家认同的精英或主流话语（Cohen 1993；Schein 1997；Feuerwerker 1998；Rofel 1999）。在本章中，我论证了打工妹的形象是另一种“他者化”的标志，围绕着它使占主导地位的国家认同理念得以构成和延续。用朱迪斯·巴特勒的话说，她代表着一种威胁国家的现代性计划并决定其面貌的“被抛弃者”。同时她也是人们同情、娱乐和感兴趣的对象，还是为了保证现代性计划的成功必须让她加入其中并使其正常运转的主体。

那么关于这个被抛弃者/客体/主体的系谱应该从何开始呢？在以前的研究中，对于当代中国城市中农村人所遭受的高度歧视和剥削问题已经给出了大量的解释。其中一些人将它归结于毛泽东的思想和制度、特别是户口登记制度的持续影响使自由市场有益的运行方式受到了侵袭（HRIC 2002b）。另一些人根据毛泽东制度与具有后毛泽东时代经济和社会特征的市场机制之间的特殊关联来解释这种现象（Solinger 1999），还有一些人将资本主义和后毛泽东体制中“与世界接轨”和从全球资本主义秩序获益的本质看成是这一问题的根源（严海蓉2001；2003a；2003b）。

从一开始我就将声明，我自己最接近于那些将流动者的地位看成是毛泽东制度与造成中国现有社会政治与经济秩序的市场机制之间特殊关联的结果，而不是当代中国市场力量的不完全“解放”的观点。因此我认为对于流动者来说关于主体位置可得的最具说服力和最主流的理解以及附着在那些位置上的社会评价，都来自于他们在后毛泽东秩序中被吸纳和起作用的特殊方式。将一个人确定为农民工所依据的分类和评价的各种原则，同时也是构成对于农民工主体位置理解的基础。然而这些分类和评价的各种原则并不是随着1970年代晚期市场改革的释放而“无中生有地”产生出来的，也不能解释为起源于1950年代毛泽东体制下户口登记制度的颁布。另一方面，这些分类和评价的原则也不是永恒的或“自然的”。相反，我们看到的是，许多早期出现的思想和概念以及在新的情境下、服务于新功能的有关这些概念的新形式、新叙述和新表现蜂拥而至。特别是，在本章的第一部分我将指出，对于农民工主体位置来说关键的概念的出现，是与中国知识分子当中“内部东方主义”（internal orientalism）的形式联系在一起的，这些知识分子试图寻求一条出路以应对19世纪末和20世纪初西方的现代性和殖民主义计划。

在进入打工妹主体认同的各个概念中，最基本的概念与城乡分割、外地人/本地人身份，以及关于性别的话语相关，与这些话语和现代性观念彼此缠绕的方式以及贡献于现代性观念的方式相关。无论从其他人如媒体对打工妹的陈述，还是从打工妹自己的叙述中都可以明显看出这一点。因此本章试图拆解打工妹主体的构成与现时代这些话语的系谱之间存在的关联。更加明确地说，本章第一部分简要地概述了19世纪末和20世纪初“农民问题”和“农村妇女问题”的出现，以及毛泽东时代对这些问题的回答。第二部分考察了后毛泽东时代“农民问题”的再形成和对这一问题的回答。第三部分考察了后毛泽东时代农民工主体位置的构成以何种方式发起并重写了这些“问题”和“回答”，也描述了有关外地人和本地人身份的观点。这一部分首先讨论了嵌入在农民工术语中的内涵，然后集中讨论了从农村到城市的流动以及流动者在80年代中期到本世纪初的中国媒体中被建构的方式。

## 现代性和1949年前后的农民问题

在《乡村与城市》这本书中，雷蒙·威廉斯（Raymond Williams）讨论了城乡分割的存在，以及17世纪以前大量英语作家的作品中所描绘的都市优越性的假设，并将这种城乡分割的起源一直追溯到古希腊文化（Williams 1973）。然而弗雷德里克·默特（Frederick Mote）宣称，在中国的皇权文化中不存在这样的城乡分割（Mote 1977，引自Cohen 1993, 156）。虽然有足够的论据与这种观点抗衡，但是显然在传统的中国政治和文化话语中，城乡区分并不像学者官员阶层（士）与普通百姓（民）之间的区分那么重要。这一区分的古典陈述是在公元前4世纪由孟子给出的：即劳心者治人，劳力者治于人（Feuerwerker 1998, 11）。据说处在统治地位的士大夫阶层的权力和权威就在于他们在道德和知识上比普通人优越，因此修身齐家治国平天下就成为他们的职责（同上，11；Bakken 2000, 42）。如果这些职责不能得到适当的支持，那么百姓就会起来造反，他们的统治权就会丧失。

就像许多作家曾经指出的那样，19世纪到20世纪初与西方国家的接触以及中国皇权制的衰落，导致了中国知识分子的认同危机以及后来他们为实践自己作为知识和道德领袖的传统角色而寻找新道路的斗争。发生在这个斗争进程的最重大的逻辑性转换的基础，是一种全新的时代观念和一种新的国家目的论（Dikötter 1995, 9）。以前占主导地位的关于过去是黄金时代、王朝的命运是循环更替的、是贏得和失去上天训令的反映等等观念，现在被各种各样的现代话语所取代，其中无论个体还是社会都被看成是在线性道路上进化和“进步”的，并通过不同阶段走向成熟和现代化。引导和拉动中国的其他人沿着这条路径走下去，把它重建成强大的国家，已经成为知识分子迫切的新任务。

伴随着这个新目的论，出现了两种重要的与“民”相关的新话语。在第一种新话语中，“民”变成了“人种”、“种族”和“人口”，成为民族志和科学研究及定义的对象，为了国家利益必须加以改善的资源。正如弗兰克·迪克特（Frank Dikötter）指出的那样，到了19世纪晚期“政治权力不再被视为公共美德或个人道德的结果：人口的实力成为衡量国家的扩张和毁灭的惟一标准”（Dikötter 1995, 107-108）。

对“种族”和“人口”的定义、测量和评估被视为在本质上相当于对同家的描述和评估。因此它成为知识分子试图回答“中国出了什么问题”时的一个核心支架，因为殖民权力掌控的失败对受过教育的精英来说，过去是并且至今依然是一个关键的问题（Fitzgerald 1996, 108）。到了1920年代，几乎所有的知识分子都普遍接受了这样一种说法，即中国的问题就出在“国民性”上存在严重的缺陷。如前所示，先前的儒家精英已经将社会秩序与和谐的维护和人的修身养性之间联系起来，但是现在对于国民性和人口素质的改造已经成为一个更加紧迫的任务，它有一个明确的目标，就是国家的现代化。

当中国的民族主义者如梁启超、鲁迅等人写下关于国民性的弱点时，他们针对的是在这个主题上的西方殖民论述，许多情况下以西方为参照。有关中国人最有影响的西方批评之一，是一本由美国传教士明恩溥（Arthur Smith）写的1894年出版的书，书名是《中国人的特性》。在这本书中，明恩溥详细列举了中国人性格缺点的一个长长的清单，包括“漠视时间和精确性”、“缺乏勇气”、“智力混乱”和“缺乏公益心”等等（Smith 1894）。

明恩溥相信，这些缺点只有通过皈依基督教才能得到改良。对许多中国知识分子来说，这个答案则在于促进大众教育和推行文化普及。五四运动的一个主要思潮，就是提高大众文化和提倡用白话文书写的新文学。对其他人来说，关注国民性弱点引向了对培养文明和礼仪的强调。1924年，孙中山在他的有关三民主义的最后演讲中，对他的听众的行为方式表达了强烈的不满，力促在公众礼仪方面需要大改善。十年以后，蒋介石发动新生活运动，其核心是颁布治理公共行为和卫生的96条规则，包括“讲卫生”、“不随地吐痰”和“扣好衣服纽扣”等（Fitzgerald 1996,104-105；Bianco 1971, 127-128）。

但对其他人来说，关注中国人的人性特征导致对以底层阶级的人种改良为目标的优生学计划的支持。从19世纪开始，无数学者将人种的恶化归咎于穷人的过度繁殖。一些人提倡一种选择性的、以阶级为基础的限制生育计划。另一些人则提醒要警惕传播避孕知识的危险，担心这种知识会被受过教育的阶级不成比例地采纳，从而使种族覆没在出生下层社会的劣等人的游牧部落手里（Dikmter 1995，120）。

随着人口素质和国民性问题在知识分子争论中成为突出的关注点，第二种话语在20世纪初期出现了。在这种话语中，士/民之间的划分被重构为一种在城市人口或特指都市知识分子与农民之间的区分（Feuerwerker 1998，9）。19世纪晚期，由于外国“通商口岸”的建立以及他们在贸易和管理领域的介入，城乡社会之间的分化开始增大。管理、通讯、资本和机械工业日益集中在一些沿海城市，特别是在上海。其结果是，这些城市的生活质量和文化的独特性相对于内地农村不断增长，城市居民也越来越倾向于将自己与他们的农村亲戚区分开来（Stockman 2000，48—49）。在这个时期，一些植根于传统中文、而后被日本明治时期的现代化推行者重构用于翻译西方作品的词汇被采纳了。这些词汇包括新语“农民”，跟在英语中一样，它有以前常用的“农夫”或“农场主”一词中所没有的落后含义；还包括现在用于描绘“小农阶级”的一些词汇，比如“封建”和“迷信”等（Cohen 1993，155）。

在五四运动时期，农民成为文学作品和社会政治话语中的一个核心主题。根据孔迈隆（Myron Cohen）的研究，这一时期只有少数知识分子以积极的眼光看待农民：

> 将农民视为文化上独特而异类的“他者”，视为被动的、无助的、无知的群体，他们紧抓丑陋而根本无用的习俗不放，在教育和文化改革方面令人绝望地匮乏，而他们生存环境的改善完全依赖于理性的、见多识广的外来者的领导和努力——所有这些关于农民的观点在中国现代知识分子和政治精英的见解中已经成为确定无疑的东西。对于统治中国或试图对中国行使权力的精英来说，这个有关农民的形象证实了他们自认天生优越、在国家政治生活中处在特权位置的道德主张，也表明了他们深信如果中国想要避免混乱并达到国家的强盛，民粹主义或流行的民主政治是彻底无法接受的。（Cohen 1993，155）

我自己的判断是，知识分子对于农民的情感比这里提到的要复杂得多。即使在大多数改良派那里，例如鲁迅，也严厉地批评了农村生活的落后，特别是毫不动摇地指出摧毁它的必要性，但同时又表达了对它抱有相当程度的怀旧之情。在共产党的一位奠基者李大钊1919年发表的文章《青年与农村》中，也明显表现出这样一种张力。李大钊在文中指出：“中国农村的黑暗，算是达于极点”，农民迫切需要从他们所遭受的苦难、痛苦、无知和疾病中解放出来。但他同时也敦促年轻人到农村去看看，说“都市的生活，黑暗一方面多，乡村的生活，光明一方面多；都市上的生活，几乎是鬼的生活，乡村中的活动，全是人的活动；都市的空气污浊，乡村的空气清洁”（李大钊 1984\[1919\]，651）。从1910年代中期到1930年代，无数知识分子附和李大钊对青年的号召，劝告他们“到人民中去”和“走向内地”（Feuerwerker 1998，29—30；Fitzgerald 1996，136）。这种探寻是为了那些“真正的”中国人，他们没有因为与城市的外来文化接触或者腐化变质生活的影响而被玷污。

这幅知识分子有关乡村形象的张力和差异图，远比孔迈隆所描述的“证实了他们自认天生优越、在国家政治生活中处在特权位置的道德主张”更复杂，不过这种描述并没有完全失效。在五四时期的知识分子和政治领袖当中，无论对乡村抱着轻视还是喜好的态度，其共同点都在于约翰尼斯•费边（Johannes Fabian）所说的“对同时代性的否认”（Fabian1983）。换句话说，通过否认农村和城市之间在现实中是同等的，在两种情况下，乡村和农民都被有效地“他者化”（othered）了。无论他们象征着乡村这个必须摧毁的古老社会的落后代表，还是被怀旧的人们视为栖息在一个不为现代化所触及的田园世界，这些农民都被分离为“过去”的一部分。结果这就为现代性的现在和未来扫清了道路，身处其中、控制并影响着这个现代性的不是“农民”，而是那些受过教育的城市精英。

可是如同许多学者已经指出的那样，不仅仅是阶级或城乡的划分，而且还有性别的划分“成为使现代性得以想象和渴望的核心形态之一”（Rofel 1999，19）。在19世纪和20世纪初的中国，如同在其他殖民地、半殖民地社会一样，对于西方人进而包括中国知识分子来说，妇女的可怜待遇成为这个国家地位低下的一个主要标志（Fitzgerald 1996，133—134）。因此从五四时期开始，“妇女问题”就和“农民问题”一样高高悬挂在社会和政治改良者的议程当中，而农村妇女作为“他者”也成为当时文学作品的一个流行主题（Feuerwerker 1998，245）。

当新成立的中国共产党的领袖开始在1920年代阐述他们的政治理论时，“农民问题”以及让农民阶级从被压迫的政治、宗族、宗教和父权制权威（针对农村妇女而言）体系中解放出来，成为他们特别关注的问题。像其他的西方现代主义者一样，卡尔·马克思和弗里德利希·恩格斯也严厉地批评了农民阶级，将他们的特征概括为“代表了文明社会中的野蛮人”，是保守的、落后的阶级（Marx 1895，引自Swacher 1983，125）。他们拥护在英国和欧洲其他地区对农民土地的剥夺、近代资本主义工业的兴起以及大规模的城市化运动，称其为“划时代的”事件，“拯救了相当一部分人口使之脱离农村的愚昧生活”（马克思 1867；马克思和恩格斯 1848，引自Swacker 1983，121—125）。与之形成鲜明对比的是，毛泽东以他对于农民革命品质的赞赏而著称。然而这种声誉掩盖了毛泽东和他的追随者们对农民怀有的相当矛盾的情感。

丹尼尔·凯尔利赫（Daniel Kelliher）注意到，共产主义者在“农民问题”上阐述的理论集中在两个方面：首先是面对正统马克思主义对这个阶级所具有的“农村的愚昧”的贬低，如何使共产党对农民阶级日益增长的依赖合法化；其次是以史为鉴，通过学习确定为什么中国过去有那么多农民起义却未能改变社会结构的原因（Kelliher l994，389）。在1920和1930年代，共产主义思想家就这些问题提出了广泛的争论性答案，这些争论性答案逐渐结合成一个关于农民的“两重性”理论。根据这个理论，一方面，在传统经济中遭受长期剥削与压迫的农民已经慢慢输入了反叛的天性；另一方面，作为“半封建”社会的小农这一事实又促使他们具备两种落后形式：首先导致政治上的保守主义趋向和易受封建迷信的影响，其次还会引向小资产阶级的愿望，仅仅满足于获得土地并得以均分而止步不前。根据这个观点，农民是自然而然倾向于造反的，然而他们自己始终试图重建一种政治，其中一位君王长者将控制着地主和农民家长的秩序。因此在过去，“尽管每一次农民革命斗争都取得了一些社会进步，但是依然没有从根本上改变封建的经济关系和政治体系”（毛泽东，引自Kelliher 1994，392）。

共产党官员从农民的两重性理论得出的教训是，农民可以有效地雇用来服务于革命，但是他们不能自身来领导革命。他们需要无产阶级和它的政党——共产党的领导。布尔什维克已经阐述了“工农联盟”的思想，但是这一思想在中国共产主义者那里得到了更加详细充分的阐述，他们急于批判斯大林和托洛茨基关于共产党在城市工人中缺乏基础的谴责，主张共产党是工人阶级本身最先进的成分，指出无论在何处党指挥农民，都必须保持工农联盟和无产阶级革命资格审查的完整无缺（Kelliher 1994，393）。

![](https://i.loli.net/2019/01/24/5c49a0f06accf.jpg)

佚名画作《南泥湾》，1941年3月，八路军三五九旅在南泥湾开展了著名的大生产运动。\[图源：xlysauc.com\]

在上个世纪20年代到40年代的背景下，农民的两重性理论是解释“农民问题”的一个激进和创新的路径，它给中国共产党的领导人提供了以农村为基础的革命走向成功所必需的实用见解和马克思主义的合法性（Kelliher 1994，394）。但是凯尔利赫指出，1949年以后，这个农民的两重性和工农联盟理论获得了新的含义和新的意识形态功能。尽管解放以前毛泽东最为强调的是农民本性中积极的、革命的一面，但解放以后，当农民的反叛性不再是这样一种有用的资产时，对于农民意识的落后一面的关注在共产党的理论化过程中就变得更为突出。而且到了50年代中期，农民开始抱怨工农联盟的真正含义是农民阶级的利益附属于城市工人阶级和共产党的利益（同上，395）。

解放后的前30年间，共产党公开宣称自己致力于妇女解放和消除“三大差别”，那就是存在于城乡之间、脑力劳动和体力劳动之间、以及工人和农民之间的不平等。在官方媒体和文献中，农民包括农村妇女通常被描绘成领导革命的英雄，或者被描写成从前遭受过封建压迫、但是已经从封建落后思想中走出来并在共产党鼓舞下向前进的人民群众。简言之，他们被描述成不是“文明社会里的野蛮人”或者现代性的落后部分，而是“前进中的”或者“先进的”阶级，在迈向共产主义的国家动力中处在核心地位（Kipnis 1995，119—120）。

实际上在毛泽东时代，农民尤其是贫苦农民在社会和政治地位方面得到了很多，同时他们也得益于国家想要在这个群体中改善基本的健康和教育状况、提升妇女的地位以及提倡自由婚姻所作出的令人印象深刻的努力。许多农村居民现在回顾毛泽东时代，都把那段时期看成是具有平等、尊严和道德的“黄金时代”。那时候每个人的基本需要都得到了满足，几乎没有什么腐败或犯罪，所有人都统一在一个伟大的事业里，团结在一个具有超凡魅力的克里斯玛似的强大领袖旗下（Gao 1999，Dorfman 1996，269）。我想说的是，考虑到毛泽东在解放前的农村条件下和农村内部不平等、腐败、暴力不断增加的条件下所取得的成就，以及标志着毛泽东死后几十年特征的城乡之间日益增长的社会和经济分割，他们有相当正当的理由持这种看法。

然而说到性别平等，这方面取得的成就断然比国家修辞可能提到的要少得多。中国政府虽然在其他种种方面进行了创新，但是在妇女解放问题上大体采用的是过于简单化的、正统的马克思主义路径。根据这种路径，妇女一旦参加社会生产，她们就可以摆脱压迫。更有甚者，即使这种路径也只在它适合经济需要时才付诸实践，而当失业压力大时就不予采纳。结果现在的大部分分析家指出，在毛泽东时期妇女解放尤其在农村只是一个“未完成的”或者“被延迟了的”革命，存在着根本性的问题，包括劳动的性别分工和不平等报酬、双重负担，以及婚姻实践和家庭关系中遗留的自由和平等的缺乏等等（Johnson 1983；Andors 1983；Wolf，Margery 1985）。

除此之外，50年代期间共产党还制定了两种不同形式的分类和规则，使城乡分割客观化并进一步得到巩固。其中第一种分类指定了阶级身份，在这种分类过程中公民被划分为永久城市居民或某一个特定村庄的永久农村居民两大类，前者又根据他们的职业或解放前的家庭出身进一步分类，后者则根据土地所有权进行归类。第二种分类形式是户口登记制度。在导论中已经讨论了，这个制度与毛泽东政治经济管理的其他两个方面相结合，使得从农村到城市地区的流动几乎成为不可能，国家借此可以吸收农村的资源用于支持工业发展和城市的生活津贴，其结果导致农村生活水平保持在很低，并且使城乡之间的不平等得以长存。

在文化大革命十年间（1966—1976），共产党关于农民的两个极端的看法，像两重性理论中所阐述的那样，表现得尤为明显。一方面，共产党将城里人下放到农村去，既为了矫正城乡居民之间的分野，又为了让城里人向农民学习他们的革命精神。此外，在这个过程中，农村的“铁姑娘”队模仿大寨模范生产队的年轻姑娘们，成为妇女解放和革命进步的最有力的标志之一（严海蓉2002，10—11）。另一方面，共产党中的极左分子比以往更加怀疑农民的小资产阶级倾向，农村家庭通过养猪、养鸡或在自留地上种植蔬菜来补充他们的收入，这些行为被指责为“资本主义的尾巴”。

凯尔利赫注意到，到了70年代末，农民的两重性理论已经固化为一种本质主义的陈词滥调。主流的形象“将农民呈现为热情的、自豪的、体力强壮的、易于引导的、敢于挑战压迫者的、革命的、自然的和不屈服于强暴的人；同时农民的形象也被描绘成狡猾的、固执的、保守的、偷鸡摸狗的、落后的、自私的、迷信的和贪婪的人”（Kelliher 1994，397）。

## 后毛泽东时代中国农民的“低素质”

凯尔利赫指出，邓小平领导下的共产党的改革者们在80年代试图收集新的信息，打开理解农民的新视野，但是在这一点上他们遭到了两重性理论的持续影响的阻碍，尤其是受到了关于农民是落后的、目光短浅的阶级这一假设的阻碍。特别是当共产党的官员观察到非集体化伴随着解放前村庄习俗的复苏后，他们将这一现象归结于原始的、落后的“农民意识”，而不是归结于例如经济因素或者共产党未能解决农村的不安全感和不确定感问题（Kelliher 1994，401—402）。

与共产党的观察者固守在关于农民的落后本质这一古老而僵化的概念框架里不同，凯尔利赫认为“1980年代的艺术家和学者对农民的描述出现了在客观性、人道主义和智力兴奋之间前所未有的张力”（Kelliher 1994，401）。的的确确这一时期有关农村经济和社会的大量仔细的研究得以发表了，并且在文化圈中也出现了比毛泽东更加复杂的有关农村人和农村生活的描述。但是即使这种情况下关于农民的本质主义观点、特别是关于农民落后的说法依然在学术的、艺术的和官方的作品中有影响力。这不仅表现在古老的共产党理论中关于农民的“小资产阶级”倾向的说法已经蜕变为关于农民落后的不可更改的陈词滥调，而且表现在文化大革命中将城里人遣送到乡下学习农民本质中的革命性这一政策已经成为独一无二的一大败笔。大多数城里人在农村学到的，更多的是农民与自己相比在本质上是多么不同和“落后”。这一课与中国作为一个民族在世界舞台上同样是“落后”的感觉相结合，促使人们重新追问：中国出了什么问题？也导致官员、知识分子、艺术家和记者一方面从资本主义吸取灵感，另一方面又从20世纪早期中国占主导地位的知识话语中吸取灵感，对这一问题的答案进行建构。

然而随着十年“文革”的结束，农民丧失了他们在毛泽东时代获得的道德和政治身份，贯穿整个80年代关于国民性弱点和人口素质，尤其是农民和农村妇女素质落后的忧虑，不仅在官方声明中，而且在学术和艺术作品以及流行媒体中再一次成为显著的特征。例如在1986年国务院的一份关于农村贫困状况的报告中，将中国落后的责任归于农村人口的缺陷上。这份报告还被用做一部争议性的电视系列片《河殇》的背景参考材料，《河殇》所要传达的核心信息之一，就是中国的落后源于它落后的农民。贯穿这部电视系列片的始终，农民总是明确地与停滞的传统联系在一起，被指责为缺乏勇气的、被动的和迷信的（Anagnost 1997，121；Kipnis1995，122；Hao Jiaozhen 1990）。

![](https://i.loli.net/2019/01/24/5c49a0f0e059d.jpg)

<figcaption>纪录片《河殇》剧照</figcaption>

在文学作品尤其是“寻根”文学以及“第五代”导演例如张艺谋、陈凯歌等人执导的70年代末、80年代初的电影中，农村和农民也是他们的核心兴趣点。在这些作品中，如同五四运动时期一样，农民时而被描绘成野蛮的和可恶的，时而又被描绘成人们渴望的中国传统和精神的精华，或者常常被同时描绘成二者。并且就像在五四文学中那样，农村妇女的形象常常在那种受过教育的城市男性精英与“人民”之间关系的虚构描述中被比喻为“他者”。贯穿整个80和90年代，政府在以“素质”为焦点的一系列话语中不断地瞄准了农村人尤其是农村妇女和那些贫困地区的人。所谓“素质”是一个新词，翻译成英文大致相当于人的质量。例如，改善农村人口的素质，特别是消除“迷信的”仪式活动，提供技术培训，鼓励竞争和商品化，“让农村人从小生产和平均主义的传统观念的束缚中解放出来”，既是共产党提高“精神文明”运动的核心目标，又是妇联改善妇女在发展中的角色并为发展作贡献的核心目标（Jacka 1997，95；“跨世纪农村妇女工作的六大任务” 1999；Judd 2002，19—32）。

“素质”已经成为有关现代性和国力的发展和成就的各种话语中的核心要素。它可以并且已经用来指称人的一系列属性，包括教育、文化、道德、行为方式、心理学、生理学和遗传学的特征。理解它的重要性的关键不在于用一些精确的定义来束缚它，而在于首先承认这个词的可塑性的效用和权力是非常重要的。其次，“素质”配置的另一个重要特征是它集中关注人类的属性以及如何改善它们，而将注意力从源自政府创造或认可的结构、制度和实践的缺陷和不平等中转移开。

“素质”一词描述了与毛泽东的阶级范畴相当不同的社会经济分化和国家治理形式。从表面上看，“低素质”作为描述下等身份的范畴看起来不像毛泽东时代的落后阶级标签那么僵化，因为关于任何人以及人人都可以和应该提高他们自身素质的说法已经在后毛泽东时代的话语中广为提倡。事实上，有人可能会提出在后毛泽东时代为现代性而奋斗的过程中，比“素质”本身更重要的是它的可塑性，一个人和一个民族的素质并非固定不变，它们可以落在别人后面，也可以被提升。这就满足并回答了平民当中新的、非常强大的渴望和忧虑——获得更高水平的自我素质、与他人竞争谁有最好的素质、因为某人素质不错而感觉良好，以及带着同情或轻蔑的态度鄙视那些素质较差的人，所有这些可能性都已被证明是非常诱人的。

这些新的渴望和忧虑的产生，对于市场经济和国家治理来说至少像对物质财富和消费的渴望一样至关重要。这样，在宏观的层面上，通过特别是计划生育、优生学、打击犯罪和无序以及劳动力的训练和培训等手段提高人口素质，已经被政府和一般平民视为对民族发展极其重要的东西，是中国与其他国家的竞争中争取自尊与权力的一个首要目标。而在微观的层面上，通过例如更好的饮食与锻炼，通过为孩子们提供素质教育、自学英语和计算机，以及通过到城市或国外旅行开阔眼界等手段，在提高他们素质的基础上实现个体的“自我发展”，不仅被政府提升为民族发展所必需的，而且已经被内化为普通人包括我在后面章节中要讨论的打工妹中间强有力的向往。因此对中国作为一个民族的素质的渴望与忧虑，与家庭和个体的素质竞争相融合，形成了一种基于自我规制和自我发展压力的强有力的政府治理形式，这些由政府自上而下强加的压力，已经在普通人当中得到内化。

在后毛泽东时代，无论是农村人还是城里人都被淹没在倡导提高全民素质的可能性以及试图推动他们实现这种可能性的国家运动、流行媒体以及商业广告当中。然而对于那些关注素质问题的人来说，具有悲剧色彩的是，那些被指定为具有最低素质的群体，尤其是那些从农村来的人，已经发现实际上这是一种比毛泽东时代的“落后阶级”标签更难改变的身份。“素质”已经被用来映射一种在贫穷“落后”的内地农村与城市和沿海省份之间社会和经济分化的地理学，这些分化非但没有通过市场取向的改革而得到缓解，而且在80和90年代的中国变得更加赤裸裸。因此从80年代中期开始，在收入、教育、健康、福利保障方面的不平等，无论在中国的农村地区内部还是在城乡之间都进一步加大。到1995年，城乡之间的收入不平等比在后毛泽东时代初期的1978年更加突出（Knight，andSong1999，319）。这个不平等程度比当时中国任何其他形式的不平等更加明显（Khan and Riskin1998，246），同时也比除津巴布韦和南非之外的世界上任何国家的城乡不平等更加显著（Knight and Song1999，337）。这种城乡之间收入的高度不平等，是进一步造成1995年中国成为亚洲地区最不平等国家之一的原因，当时中国的基尼系数估计是0.452，比印度、巴基斯坦和印度尼西亚那些国家还要高，与菲律宾差不多（Khan and Riskin1998，246）。

## 后毛泽东话语中的“民工潮”

无论普通市民的谈吐中还是政界要员的言论里，无论是通俗影视的节目中还是权威专家的著作里，都可以听到和看到对进城农村人口的大致描述，即进城农民大抵是愚蠢的、肮脏的、缺乏教养的和没有羞耻观念的。流入城市的乡下人如果不是现行的就是潜在的盗贼、抢劫犯、卖淫嫖娼者、“超生游击队”员（指那些没有遵守计划生育政策的人）和传染病的携带者与传播者。（俞德鹏 1994，38）

已知的有关农民落后的一般偏见，符号化在“农民”这个词当中，在毛泽东时代有关农民的两重性理论和户口登记制度中得到了具体体现和本质化，并在后毛泽东时代关于素质的渴望和忧虑中再次得到了强调，因此当大批农村人在80年代中期开始进入城市时，他们自然也会被城里人以轻视和不信任的眼光来看待，这一点似乎并没有出乎意料之外。如同社会学家俞德鹂在上面的引文中所提到的，这一态度在普通人的交谈中、在流行媒体和在官方话语中都是明显公开的。

![](https://i.loli.net/2019/01/24/5c49a0f1b99f0.jpg)

<figcaption>北京街边的广告牌：“加强流动人口管理，促进首都经济建设”\[图源：《都市里的农家女》一书第44页\]</figcaption>

事实上，在后毛泽东时代的城里人中间，那些“民工潮”或“流动人口”中的农民比在乡下的农民引起了人们更多的忧虑和反感（但同时也包含更多的吸引力，我将简短地论述这一点）。这部分是因为突然之间他们大量出现在城市的大街小巷，比他们在农村时更加显眼和无法回避。同时也因为他们的流动性和域限性，由于他们将自己的根据地设在农村，并不是真正的城里人，使得他们的存在威胁到了农村人与城里人之间的区分，而这种城乡两分的秩序既维护了城里人物质上的特殊待遇，也维护了城里人素质更高所依据的观念。

对于流动性和域限性的关注清晰地反映在那些用于指称流动者的常用词汇中，包括“民工潮”、“盲流”以及“流动人口”等。值得注意的是，所有这些词汇都运用了水的比喻，包含了水流的特征。在第一个词中，流动者被比喻为一种潮汐或巨流，而后面两个词也包含若“流”的特征，意味若流动、漂浮或漂流。一些学者注意到，中国文化传统上包含了对外来者的一种特殊的使之陷入绝境的态度，以及对地理上流动的入的一种高度忧虑。或许这是因为一种基于亲缘关系定居的农业社会已经很大程度上主导了这种文化（Yang 1994，193）。因此，空间上受束缚的社区的根深蒂固，已经成为主流理想中的一个重要因素，构成了值得想望的、符合道德的生活（Zhang，Li 2001，33），而“流”的特征具有非常强大的、负面的内涵。

其他用于指称流动者的词汇，通过强调他们在目的地作为“外来者”的身份，也反映了一种符号化的威胁意识。像“外地人”、“外来工”、“外来妹”这些常见的词最明显地指示了一个外来者的身份，因为它们指出了这个人来自不同地方这一事实。“打工妹”和“打工仔”的说法不像“外地人”、“外来妹”这些词那样明确指出作为流动者的身份。然而“打工”一词指的是与持久职业形成对比的临时工作，不具备与毛泽东时代的“劳动”相符合的身份，也表明了打工者是处在城市社会秩序之外的人。尽管随着劳动力市场的引入和私人企业的成长发生了种种变化，但在90年代和本世纪初，关于职业最常见的理解还是使一个人附属于某个特定单位的一份终身工作。单位就是个体在社会中的支撑点，它所提供的不仅是就业，而且还有住房、福利和一系列的公共物品，同时还负责监控和管辖个人的行为。打工仔和打工妹完全脱离了单位体系，他们从事的是短期的工作，常常没有任何合同或其他法律文件，

并且由于一般不给他们提供任何福利或其他利益（尽管工厂经常给他们提供集体宿舍），他们也不像其他工人那样对工作单位充满感激之情。

最后，打工仔和打工妹中的“仔”（年轻男孩）和“妹”（年轻女孩）这些用词也表明了流动者是社会秩序的外部人，或至少不是社会秩序中完全的成员，因为这些用词表明所指称的个体是年轻的和未婚的。尤其对女性来说，婚姻标志着进入社会秩序的入口。因此打工妹无论处在城市中的什么位置，都被看成是暂时的，她们“真正的”成人身份始于她们回到农村、“定居下来”并成为妻子和母亲之后（Pun 1999，2）。

现在我想考察这些用来指称流动者的词汇中所包含的假设、思想和态度，在平面媒体有关流动者的描述中以什么方式被释放出来。这种描述已经成为都市文化中最显眼的一个方面，既反映了关于城乡流动的主流话语，也对这种话语的形成作出了贡献。在这一部分我将考察在全国性媒体和北京媒体中发表的一些文章，包括由学者和官员作出的分析文章和调査报告;也将考察一些说教性的文章，包括对英雄模范人物的描写以及有关失足堕落人员的警戒故事;还将考察人们感兴趣的故事和调查性的新闻报道。我讨论的这些文章来自与“商业”小报和其他出版物相区别的“官方”报纸和杂志。但是必须指出的是，媒体在资金和管理方面的变化已经使“官方”和“商业”或“非官方”媒体之间的区分复杂化了，因为商业关注的“党线”和“底线”在两类媒体中都清晰可见，反映各种不同利益、愿望和关注点的不同话语也可以跨越官方与商业的界限而清晰地看到。

本章提到的期刊杂志所共有的一个特点，事实上也是中国的大多数官方和商业媒体所共有的特点，是一种压倒一切的都市视角和假设，其主要读者群是受过教育的城市人口。农村居民尽管在人数上占优势，但他们的关注点和视角在中国新闻界几乎得不到传播，被排斥在许多专业杂志之外。然而在下一章中，我将考察明确面向农村妇女的《农家女》和《打工妹》杂志。我的部分目的是确定统治主流城市媒体的话语在多大程度上也在更加专门的女性杂志中得到了反映，这些杂志据称是专为农村读者或打工读者撰稿的。

在80和90年代的中国发表的有关城乡流动的大部分分析文章，都对流动人口带有一种矛盾的态度。一篇由北京市公安局（相当于警察局）的官员写的这类文章在讨论这个城市的流动人口时宣称：

> 改革开放以来，随着社会主义市场经济的逐步建立，人口、资金和产品的流动已经日益扩大，在全国的大型和中等规模城市中，流动人口作为一个动态的、复杂的人群，已经以前所未有的程度和速度膨胀开来。（王举、史崇欣和宋春生1993，35）

这篇文章概括了北京市流动人口在规模和人口统计学特征方面的一些数字，然后讨论了流动人口对这个城市的经济和社会的影响。首先指出了“积极的”方面，包括农村建筑工人对城市建设的贡献，以及农村劳动力有助于许多行业中的“补缺”这一事实，即弥补了诸如建筑、纺织、化学、卫生、煤矿等行业由于工作“脏、累、重”的名声而遭遇的劳动力短缺。同时也提到了农村人在城里卖农产品和其他物品，修理鞋子和家具，以及提供保洁和其他服务等等，使得首都的日常生活更加方便。文章还进一步指出，流动人口作为零售商和消费者的双重角色对于首都商业的繁荣作出了巨大贡献（王举、史崇欣和宋春生1993，36-37）文章接着写道：

> 然而任何事情都有它的两面性，数百万流动人口的进入在发展经济和建设首都中发挥了重要作用，与此同时也产生了首都经济秩序、城市管理和社会秩序方面的一系列问题。（同上，37）

文章接下去讨论了这些问题，给出统计数字证明不断增加的农村流动人口导致了北京犯罪率的上升，在不断增长的无照经营和偷税漏税者中农民工占据了大多数，流动人口的增加还给城市公共交通、水电煤的供应以及公共卫生和计划生育等造成了不可持续的压力。文章接着对民工潮的增长给出了一个简短的预测，最后在结论中列举了一系列实质性的政策建议。所有这些建议都是以改善对流动人口的管理为目标，包括在这一地区“补充、修改和完善法制体系的作用”，建立“统一的、权威的流动人口管理机构”，继续提倡雇主和其他城市居民在监督和规制农民工在城市的就业和居住中的作用，以及执行准化的“谁用谁支付”的费用制度以克服公安局和其他部门在农民工许可证管理中所需资源的严重不足等措施（王举、史崇欣和宋春生1993，37—39）。

在80年代中期和90年代中期之间，流动人口的形象是危及城市的洪水，这是当时媒体中有关农民工的最主流描述。但是在那以后，关于流动和民工的描述不断多样化，越来越多的描述集中在将农民工作为个体的人来看待，而不仅仅将流动简单地视为一个成问题的现象。它们包括，首先，越来越多的文章对流动持肯定的态度，甚至将民工描绘成发展的英雄；其次，还包括一些报告将注意力集中在农民工的艰难生活，要求以更加富于同情心的态度对待他们。一些文章就当地城市的规章制度向农民工提出忠告，还有其他将农民工尤其是打工妹变成人们的娱乐和偷窥对象的叙述。像危险的“民工潮”形象一样，关于农民工的这些表述中的每一种都在重要的方面与农民的“落后”、低素质和域限性的概念化模式相关，与伴随着市场导向的“改革”、“发展”和“现代性”而产生的一系列渴望和忧虑相关，只不过它们相关的方式各不相同。

这篇文章的叙述结构和内容的一些方面反映了80、90年代发表的关于流动人口分析的标准特点。首先，这种分析是以对同属于文本作者和读者的“我们的”城市与“其余者”之间的清楚划分为前提的，是从一个管理者的角度、特别是从一种对城市稳定性的忧虑和对本地生活标准的维护的立场出发的。因此文章中最为关切的是建立对流动人口现象的衡量标尺，决定如何控制和管理它才是最好的，而对流动者本身的福利或需求则没有考虑。而且就像大多数这类文章一样，分析中虽然提到由于流动人口在城市的存在而获得的益处，但关于流动人口的负面影响和如何管理他们的讨论，无论根据其全部的篇幅结构还是在叙述核心和结尾的主导位置上，都占据着首要的地位。

其次，市场与流动之间的关联在这个叙述中被建立起来，并且因流动人口而产生的结果与那些通常归因于市场的结果非常相似。但是这个叙述模糊了市场改革、流动和社会经济变迁之间的因果关系。总的结果是流动者成为市场的一个比喻，关于流动人口的担忧造成了对于中央计划体制的崩溃和市场力量的冲击的总体忧虑，而这种总体忧虑反过来又强化了对流动人口的担忧（参见Solinger 1999，100）。

因此这类叙述使已经符号化在“流动人口”和“盲流”这些词汇中的流动与无序之间的关系得到了再生。它们表达了对前市场改革体系的一种怀旧之情，在那个体系中，每个人在空间上是固定的。通过制造社会崩溃不断逼近的印象，这些叙述还促使人们产生一种对强大的中央控制、政府作用的合法化、尤其是法律强制机构的渴望。此外，通过强调所谓农民工在城市犯罪中占主导地位的说法，这些叙述还建构了一种反社会、低素质的危险的农村“他者”形象，与城市文明和秩序可以被建设和维护的观点形成鲜明的对照。

在80年代中期和90年代中期之间，流动人口的形象是危及城市的洪水，这是当时媒体中有关农民工的最主流描述。但是在那以后，关于流动和民工的描述不断多样化，越来越多的描述集中在将农民工作为个体的人来看待，而不仅仅将流动简单地视为一个成问题的现象。它们包括，首先，越来越多的文章对流动持肯定的态度，甚至将民工描绘成发展的英雄；其次，还包括一些报告将注意力集中在农民工的艰难生活，要求以更加富于同情心的态度对待他们。一些文章就当地城市的规章制度向农民工提出忠告，还有其他将农民工尤其是打工妹变成人们的娱乐和偷窥对象的叙述。像危险的“民工潮”形象一样，关于农民工的这些表述中的每一种都在重要的方面与农民的“落后”、低素质和域限性的概念化模式相关，与伴随着市场导向的“改革”、“发展”和“现代性”而产生的一系列渴望和忧虑相关，只不过它们相关的方式各不相同。

从90年代中期开始，小部分但人数越来越多的学者致力于争取对农民工状况的富于同情心的理解，并试图依靠调查批判城市对民工的偏见。然而对城市农民工生活的集中关注，似乎更经常地为这些学者的认识所推动，他们自身越来越认识到对农民工的强制性限制和规章制度并不能阻止他们对社会和政治稳定的威胁。相反，将他们融入城市的社会生活，并且在民工总体中首先引入自我规制的灌输形式，这样一些努力需要被引导。因此在90年代晚期，一些报纸开辟了特别为农民工和关于农民工的专栏。这些专栏中发表的大多数文章提供了瞄准农民工自身以及有关他们的法律权利和责任的信息。例如，在1999年1月至4月间《北京青年报》的“北京民工”周刊上发表的大部分文章对新进入首都的人的打工许可证要求、民工再就业中的权利与责任，以及向警察报告犯罪行为的程序提出了建议。另一些文章警告民工不要卷入酗酒、赌博或犯罪，或者敦促他们保护自己免于欺骗和偷窃。

尽管整个90年代学术界和官方文章的重点依然集中在流动对城市的法规和秩序的令人不安的冲击上，但是也有越来越多的文章因为觉察到流动对农村发展的好处而以正面的词汇对它加以描述。这些关于流动的不同立场的存在，反映了这样一个事实，就是官方的媒体也不能代表一个单一的、同质的“党线”，不如说，不同的文章反映了国家不同官僚机构分支的不同利益。公安局和农民工最为青睐的那些大城市所在的地方政府最强调流动人口引起的城市安全的威胁。相反，农业部和民工大量外出的流出地所在省政府则更经常地将城乡流动作为农村发展的一个途径大加支持。

除此之外，90年代和2000年以后，越来越多支持城乡流动的文章在媒体中的出现，反映了官方在农村发展思路上的一个全面转换。80年代一个主流的观点是，农业“剩余劳动力”应该远离大城镇，在本地的副业、小城镇和乡镇企业中消化。当时的口号是“离土不离乡，进厂不进城”。到了90年代，这一观点越来越让位于一种新的论调，即认为工业化和城市化是农村现代化因而也是整个民族现代化的本质，而仅仅通过发展小城镇和乡镇企业是不能实现的。在1995年一次关于流动人口管理的大会上，中央领导的观点还分为两大派，一派认为“就地吸收农村剩余劳动力是必要的”，另一派坚持认为“应该采纳坚定有效的措施确保农村剩余劳动力理性而有序的流动”（Solinger 1999，54）。然而在2002年举行的第16届党代会上，江泽民总书记指出“必须消除城市化的所有制度和政策障碍，引导农村劳动力理性而有序的流动”（Lague 2003，25）。意识到中国加入WTO将会导致成千上万的农民丧失谋生的机会，一个“离土又离乡，进厂又进城”的新口号诞生了。

![](https://i.loli.net/2019/01/24/5c49a0f246cfa.jpg)

<figcaption>上世纪八九十年代，苏南的一处乡镇企业工作场景。\[图源：搜狐\]</figcaption>

在90年代末和本世纪初，让一些农民工能够获得城市永久居留权的努力甚至都已经做了。但是目前为止这样的努力大部分限于人口在10万以下的小城镇以及农民工当中的技术工人和商人。这一时期占主导地位的官方假设仍然是，大城市的农民工中的大多数呆在城市几个月或几年以后，还是会回到他们的村庄或者附近的小城镇。

就像民工犯罪状况的报告一样，关于流动对农村发展的好处的文章强化了将农民视为落后分子的观念，但是这些文章又将在城市的流动和工作描绘成克服农民落后本性的手段。例如，一位为社会学杂志《社会》写稿的作者回应共产党关于农民的“两重性”理论时指出：

> 研究表明，人口素质的高低与人口的迁流状况关系密切。长期以来，自给自足、狭隘排外的自然经济造就了“生死不相往来”的极为封闭的“农村孤立国”，孕育了重本抑末、重土慎迁的小农意识，使得社会生产和意识观念长期停留在极为狭隘的领域中循环往复，农村人口素质很难提高。90年代以来，随着城乡壁垒的解体，户籍制度的松动，农民纷纷离乡外出打工，城乡人口迁流空前活跃……民工离乡进城打工意味着他们赖以生存的生产方式和生活方式发生根本性的变化，社会经济环境的变动有力地促进了民工素质的提高。（黄晨熹 1995，26）

为了详细说明这一点，作者指出农民工在城市的经历提高了他们的文化教育水平，也改善了他们的专业技能。通过给家里汇款，这些农民工还为提供其他农村人教育所需的资金作出了贡献。城市的带薪劳动还转变了农民工的思想观念。在城市工作以后，这些劳动者较少倾向于生许多孩子，更可能在较大范围内寻找结婚伴侣，因此减少了近亲结婚的可能性，从而减少了近亲繁殖和人口素质恶化的风险。此外作者还强调，他们在城市的经历会加深农民工对市场的理解，培养他们对新思想的开放性、敢于冒风险的意愿、对合作与竞争的重要性的理解，以及对信息值和时间值的准确评估。最后，在城市期间，农民工吸收了现代文明，逐渐让他们自己适应了都市的生活节奏和城市社会关系的契约性质，增加了有关现代性的第一手知识（黄晨熹 1995，26—27）。

另一些文章赞美了家政服务所具有的特殊价值，一方面它是打工妹通过服务于都市家庭对经济作贡献的一种方式，同时作为交换，在这个服务过程中，她们自身也被文明化和现代化。这不能简单地视为打工妹获得谋生新技巧的过程，还应视为她们自己的身体和思想得以改变的过程。一个例子是《半月谈》上发表的一篇文章中报道了从安徽省无为县来的年轻女性从农民到家政服务员再到企业家的转变故事。­­作者写道：

> 进城不久，这些灵慧、勤劳的姑娘经过锻炼，很快成为城乡文化结合的一代新人。她们走出乡村田野时，带着一身土气和力气，当她们归来时，不仅带回了资金、信息、技术、市场，还带回了新思想、新观念和家乡人所不具备的开拓市场经济的本领。（王树成和李仁虎 1996，24）

这篇文章和前面引用的《社会》杂志上的那篇文章里所暗示的，就是对毛泽东主义未能引领农村走出传统的、主要以谋生为基础的农业经济，以及未能改变“落后的”、“狭隘的”农民意识的批评。据说只有90年代以来，通过让他们走出乡村并进入现代城市的市场经济，农民的素质才得到了改善。在这些论述中，就像在其他许多说明中一样，有关城乡差异的一个清单在不同词汇之间被列举出来，如下表所示：

![Selection_033](https://i.loli.net/2019/01/24/5c49a3338f99e.png)

农民工是这两套概念之间的连接点。如俞德鹏的引文中提到的，农民工由于他们与农民之间挥之不去的联系而成为轻视的对象，他们被看成是愚蠢的、肮脏的、缺乏教养的和没有羞耻观念的。此外，由于农民工在字面上或在隐喻的意义上都不能确定为农村人或城里人的范畴，也由于俞德鹏所指的“乘车效应”一因为那些已经在车上（在城市）的人怨恨由其他人（农民工）试图上车所引起的拥挤现象而产生的效应，农民工被人们以猜疑和忧虑的眼光来看待（俞德鹏 1994，37）。

然而作为个体的农民工有时候会由于他们在摆脱落后的农民性方面所取得的成就而受到人们的赞许，成为引领农村现代化并鼓舞其他农民效仿的模范。例如在上面提到的那篇《半月谈》的文章中，说到了3个来自安徽无为县的模范女性。第一个女性在北京当保姆期间业余研究中医，几年后她回到无为县，创建了一个非常成功的工厂，为国内外市场生产药品。第二个女性在北京干了几年家政服务和其他工作后，她的才能被家乡的官员看重，招聘成为当地的妇联代表。第三个女性还没上究初中就离开了家乡，在北京的一位知识分子家庭找到了一份保姆的工作。后来在北京的高中水平考试中她获得了一等的好成绩，她写的一个故事也在报刊上发表了。按照这篇文章作者的说法，这些打工妹率先大胆地走出封闭的乡村田野，在陌生的都市生活中受到文明的洗礼并增长才干，从而唤醒了田埂上成千上万的兄弟姐妹，引导他们进入城市的大课堂，接受市场经济的磨炼和培训；她们为家乡带来的重大效益在于，给家乡人的传统思想观念带来强烈的冲击，并为家乡锻炼出一批敢于搏击市场风云的生力军；她们的行动同样也给家乡一个重要的启示：外部世界天宽地阔，走出狭窄的田野就能改变一切，改变贫穷落后面貌要依靠自己去创业、去奋斗。（王树成和李仁虎 1996，24）

在赞美这几位女性所取得的成就的过程中，这篇文章掩去了这样一个事实，即对成千上万的打工妹来说，家政服务是作为一份深深的羞辱性工作来体验的，从职业的发展或训练方面来看没有任何前途。此外，由于忽视了家政服务人员令人同情的低工资这一事实，这篇文章盲目崇拜这些女性在自我发展、改善自身和家乡同伴的素质，以及引领其他农村人走向“城市大课堂”中所取得的想象中的收获。在这个过程中文章抹去了对农民工的阶级剥削问题（严海蓉 2002，7）。

另一个例子是，1997年官方杂志《中国青年》上刊登了一篇有关农民工的报道，他们被共青团授予“杰出外来务工青年”的称号。其中包括一位曾经在鞋厂苦干6年、忍受着老板的虐待和严重的工伤的青年人，从那以后他回到家乡创建了自己的鞋厂。受表彰的还有一位年轻女性，作为街道清洁工，她忍受了11年的歧视和性伤害，最终她对城市社区的服务才得到了共青团的认可。最后受表彰的是一位当过保姆、在城市餐馆工作了3年、受尽羞辱和剥削的女孩子，她回到贫穷的村庄后，利用从亲戚那儿借来的钱，自己为当地的孩子盖了一所学校（刘新平 1997）。

除了赞美农村经济的工业化和商业化以及农村劳动力的无产阶级化以外，有关模范农民工的这一类报告对国家来说有两个重要的功能。其一，通过称赞那些离开农业到城市劳动市场寻找工作、并学会新技术而冒险从商（偏向于回家乡从商）的人所取得的成功，这些报告给促进市场经济的国家政策赋予了合法性。间接地说，也给后毛泽东时代国家优先考虑经济增长而忽略对社会不平等的关注，或者说以社会平等为代价的政策取向赋予了合法性。因为尽管这些农民工遭受的剥削和困苦在这些文章中也得到了反映，但是它不是作为一个问题出现的，而是作为一种对每个个体的自我发展和素质改善来说必需的“严酷考验”。

其二，这些文章推动了被视为民族发展所必需的那些价值观念和态度的内化，这些价值观念和态度包括适应性、忍耐力、自我牺牲精神以及敢于冒风险、有韧劲和自我完善的意愿。上面所引的《中国青年》和《半月谈》上文章的核心，就是农民工的素质提高了。所要传达的信息是，自我发展和一个人素质的改进是加入现代市场经济的有益结果和奖赏。同时，人人承认自己素质太低并需要自我完善，是实现民族发展的本质性的先决条件。如严海蓉所说，后毛泽东体制在“与世界接轨”方面的努力是一个社会工程，其至关重要的条件在于形成这样一种主体共识，让人们逐渐认识到自己是发展不完善的、素质不够的，从而在每个人内心产生一种对自我发展和高素质的渴望（严海蓉 2002，4—5）。

那些赞赏劳动力外流的好处并称赞农民工个体所获得的成功的文章，提示我们发展与自我发展的道路依赖于农村人打破狭隘的传统小农经济的限制（在后面的大部分例子中是回到农村并转变这种小农经济）。然而农民有一个方面被视为必须保留的优点，那就是“吃苦”或者耐劳的能力。事实上正是这种能力使他们能够在城市忍受数年极为辛苦的低薪工作、忍受虐待和剥削而没有就业福利或保障，这使他们成为了英雄。这里我们看到农民工被建构成后毛泽东时代发展的主体，而不是“被抛弃的”他者。这一次是城里人、尤其是城市工人从垂死的国有部门中被解雇出来，与毛泽东时代的中央计划经济的关联以及对终身就业和福利的“铁饭碗”的“依赖”已经成为他们被抛弃的原因（严海蓉 2002，8—9）。

将民工描写成英雄的文章发挥了重要的论证作用，但是这类文章在90年代和2000年之后的媒体中还是相对较少。将民工描写成受害人的说法更加常见。特别是关于打工妹受害人的故事尤其在小报和其他形式的商业媒体中铺天盖地，在官方的报刊杂志中也到处可见。例如有关深圳和其他经济特区外资企业的农民工、尤其是打工妹所遭受的剥削，已经有越来越多实质性的新闻调查素材。这些文章常常提供有关打工妹状况的栩栩如生的悲惨细节，包括打工妹为可怕的低工资必须忍受的超长工作时间，她们在雇主那里遭受的虐待，生活和工作的非人条件，以及她们遭遇的高比率的工伤和医疗问题。

如陈佩华（Anita Chan）所言，这些文章经常是由城市的自由主义者对社会正义的关注而推动的，并被记者用来试图对政府施加道德压力，以改善工人的权益（Chan，Anita 2001，4—5）。然而，这些文章的推理性结果和作用也许超出了对农民工本身的关注。意味深长的是，大部分这类文章揭示的都是外资企业里的剥削现象，而关于国内私营和集体企业的剥削实践，则相对来说很少讨论。我认为这不仅仅是因为外资企业的剥削程度和范围比国内企业更大，还因为批评国内企业的管理实践所包含的相对风险以及批评外资企业所能获得的政治得分。举个例子说，在2001年下半年，一个著名的故事在北京媒体和中国其他媒体中流传，说的是一群打工妹56人提出法律诉讼，状告她们在深圳的假发工厂的南韩老板，声称她们遭受了粗暴的搜身检查。尽管她们毋庸置疑受到了污辱，但是没有工人受到过损伤。虽然这样，这个故事还是在媒体中被详细地报道，还常常伴随着这些打工妹经受精神创伤而潸然泪下的巨幅照片。我认为，媒体对这个案例的兴趣并非真正来自于对个体受害者的困境的关注，而不如说在于利用这个打工妹群体来比喻遭受外来资本威胁的民族。

这类文章与那些有关农民工犯罪的报道不同，在那些报道中，农民工的形象不是作为市场的代言人起作用，而是被比喻为市场的令人不安的后果。然而就其他方面来看，这些有关农民工描述的不同流派是很相似的。它们都强化了对市场的怀疑。也许更重要的是，它们都给政府在维护社会秩序中承担的角色赋予了合法性。前者将注意力引向“我们的”城市在哪些方面正受到来自农民工犯罪的“内部”威胁，于是给政府面对这样的威胁突出法律实施的需要赋予了合法性。后者强调来自民族“外部”的对“我们的”公民的威胁，利用民族主义的情绪，突出设置法律在保护公民权利和尊严中的作用。最后，这篇文章还是表明民族主义和性别的话语可以多么紧密地交织在一起的一个例证。在这一方面，在中国就像在别的国家一样，对女性的外来的威胁或羞辱成为民族主义忧愤情绪的一个特别强大的焦点，因为依据性别话语，女人的形象比男人更容易成为一个珍贵物品（民族）的比喻，她属于国家和公民，并且必须得到国家和公民的保护。

在90年代和2000年之后中国媒体中萌芽的另一类关于女性受害者的故事，是那些针对女性保姆的性暴力的报道，以及那些曾经被欺骗、被迫当妓女或者被拐卖成婚的打工妹的记录。在这些故事中，我们再次看到了关于市场、治理和社会秩序的话语与性别话语之间的重要交叠。例如，孙万宁（音）曾经讨论了1988年的一些报纸——包括商业报纸和那些妇联赞助下出版的报纸——上发表的一个来自安徽的20岁打工妹洪招弟的故事。她的未来老板试图强迫她卖淫，当她拒绝合作时，这个男人一而再对她拳打脚踢，脱去她的衣服拍她的裸照。后来她被送进医院，但警察对她的求助不予理睬。出于绝望，洪招弟从二楼的窗户跳下企图自杀，结果造成了一等脊椎伤残（Sim 2004）。

![](https://i.loli.net/2019/01/24/5c49a0f2d1e13.jpg)

<figcaption>西安警方在深夜展开突击，清扫城中村中的“黄赌毒”。\[图源：西部网\]</figcaption>

孙万宁指出，报纸就这个故事传达了两种说教性的信息。首先，安徽妇联主办的一个官方杂志《安徽妇运》用这个故事作为一个警戒，忠告农村姑娘不要到城市打工，并警告那些想要出去打工的人对可能碰到的欺骗和犯罪活动保持警觉（Sim 2004）。

其次，无论在商业报纸还是宫方报纸上，洪招弟都被赞扬为一个“烈女”，因为她宁愿死也不愿失去贞操。“烈女”是一个儒家概念，用来描述一个具备女性英雄品质的女人。如同孙万宁所指出的，在妇联的报纸上将洪招弟称赞为“烈女”，表明了现政府对传统父权制有关性别和性关系话语的支持，也是本应以增进妇女利益为己任的妇联在这个问题上因循成见的一个例证。在商业报纸和官方报纸上报道的无数其他故事讲到了打工妹曾被“人贩子”欺骗而被拐卖当妓女或被迫成婚的经历。这里打工妹再次成为市场的腐蚀性结果的一个比喻，而市场本身被那种将商品化推向极端的人贩子形象所代表。此外，这些故事还强化了将农村视为野蛮之地的观点（因为拐卖妇女被视为一种农村特有的现象，即使实际的诱拐行为经常发生在城市）。由于受害者几乎总是被描述成天真无知的人，这一事实进一步强化了城乡之间的区分。其暗含的信息是，拐卖妇女总是与市场力量联系在一起，它只发生在无知的农村打工妹身上，而成熟老练的城市妇女是不会让她们自己落入这种陷阱的（Evans 1997，172）。

最后，就像那些论述流动人口犯罪行为的文章一样，这些故事也肯定了政府对社会的控制的重要性与合法性。这种肯定是通过两种方式进行的，一是通过论证拐卖妇女正在令人惊慌地大规模发生，呼吁对社会稳定的关注并证明强大政府干预的需要;二是通过引用令人印象深刻的有关已经落网的拐卖者人数的统计数字，表明政府正在解决这一问题（参见Anagnost 1997，135）。

与有关洪招弟的报道相类似的是，这些有关打工妹受害的故事记录中，没有对父权制结构和话语的批判，正是这种结构与话语构成了这种对妇女基本权利的可怕侵害的基础。也正是这些话语使得年轻的农村女性而不是男性成为对一个都市媒体大众来说如此吸引人的消费对象。周蕾（Rey Chow）曾经指出：

> 在某种意义上，对下层人的表述与色情写作共享着一个主要的特点，就是它同样依赖于对“他者”的某种客观化和镜式反映……如果色情作品的兴奋点可以描述为类似于“越下流越好”的话，那么对下层人的表述的兴奋点或许可以描述为类似于“被社会剥夺得越彻底越好”。两种兴奋类型都依赖于对象所缺之物——就是她的强烈需求（或者我们应该说她的堕落），以及她邀请读者主动填充这一需求的过程。（Chow 1994，243）

因此打工妹遭受的性别压迫，加上由于城乡分割而导致的压迫，进一步加大了她们与城市大众之间的距离。这既增强了城里人的优越感，又让打工妹受害者作为同情、娱乐和窥视的对象更增添了吸引力，进而使她们成为不断追逐利润的中国媒体最喜欢的素材。

## 结论

在本章中我已经展示了有关农民工主体的当代理解的系谱，是与关于“现代性”、“发展”和民族的观点的历史紧密联系在一起的。因此可以看到，一方面是农村和农民工主体位置的历程，另一方面是关于“现代性”、“发展”和民族的概念，都在最早出现于19世纪晚期的现代主义精英目的论当中得到了肯定。从那时候开始，知识分子和政治领袖们已经把“发展”或“变革”整个民族，使之走出“落后”、“传统”的过去，走向更好的、“现代化”的未来视为己任。在这些精英、线性目的论者当中，“农民”以及后来的“民工潮”首先被建构为民族进步的一个“问题”，关于这一“问题”以及所支持的“解决方案”的准确框架，在不同话语和不同时期之间都有重大的变化，并伴随着相应的重要结果。例如，与毛泽东时代关于如何支配农民的反叛性为社会主义革命所用这一问题相比，后毛泽东时代关于如何运用城乡流动来改善农民“素质”，以便更好地服务于市场经济，同时又使农民工对城市秩序造成的威胁达到最小化的问题，已经引出非常不同的态度与政策。

尽管如此，不管“农民”或“民工潮”已经被准确地定位在“发展”线路上的何时何地，不管他们是被视为“先进的”和“有远见的”阶级还是“落后的”、发展不充分的阶级，这种视“农民”为走向现代性的线性系谱中的一个“问题”或者麻烦的框架，已经导致重要的连续反应。首先，“农民”范畴的建构包含了以居住地（农村的还是城市的）和职业（农业的还是非农业的）为基础的区分程序。并且从一开始，那些区分程序也是建构不平等的程序。此后，尽管毛泽东时期努力在“农民问题”上持更加积极的态度，但是从20世纪到21世纪，所谓“农村人”和“城里人”的本质差别已经被精心制造出来，并且关于这种本质差别的理念与物质不平等的形式之间的契合也变得越来越紧密。这一过程的起因并不是毛泽东时代的社会主义或后毛泽东时代的资本主义所特有的，而是在两个时代以不同的方式被开发并进一步得以助长。80年代以来的城乡流动，加上乡村和城镇郊区工业化的巨大增长，已经在某些方面模糊了城乡之间的区分。然而在其他方面，随着城乡之间不平等的增加以及城里人更加积极地致力于将自己与“农民”相区别，这种区分甚至变得更加尖锐。

![](https://i.loli.net/2019/01/24/5c49a0f370a86.jpg)

2008年，一名英国青年激活新买的iPhone手机,主屏幕上显示出这样一张中国女孩的照片，该照片火遍全球，照片中的女孩被称作“Iphone Girl”。有网友后来表示，女孩是富士康观澜科技园C区三栋手机检测生产线上的员工，照片传播后她已被开除。\[图源：网易\]

其次，在将“农民”和“民工潮”等等视为“麻烦”的建构框架中，人本身——贴上“农民”、“外来者”“、打工妹”等等的男人和女人——已经被当成沉默的和被动的东西。这里我的意思不仅仅是“农民”的难题以及所支持的解决方案已经基本上被民族精英而绝少由农村人自己建构出来，而且还包括，如今想要听到来自农村居民或农民工的观点和感想已经极其困难。在毛泽东时代，贫穷的农民学会了在公共讨论会上“诉苦”，就是说，他们学会了发出自己的声音，与别人分享对解放前遭受的阶级剥削的理解。这是一种特殊类型的主体构成方式，我在本书第七章中将会讨论，它通过叙述在农民中间形成一个新的、强大的和持久的能动性意识，或者至少形成一个对能动性的权利意识。然而这种在毛泽东时代培育的能动性，是小心翼翼地形成并受到政府的高度限制的。毛泽东死后，这种能动性同样受到了政府的限制，同盼更少得到有意的栽培。今天，农民和农民工在不同场合被建构成关注、吸引或鄙视、有时甚至是赞美的对象。然而，大体上他们是被建构成沉默的对象而不是说话的主体。

再次，将“农民”视为“麻烦”使得对于以农村发展为目标的项目的失败或不充分所作的解释，与针对其他社会群体的项目以及政府倡导的结构或实践的解释分离开来成为可能，也使得无论是1949年以前还是以后的精英将这些失败的原因归于想象中的农民本身所固有的素质缺陷（参见Escobar 1991，667）。

最后，根据他们的“农民性”对不同人群进行的划分和评价，与其他形式的分类—最常见的是那些基于性别和内部人/外来者身份的分类相结合，已经导致“他者化”形式的极度增生。这些都对各种各样的话语、进而包括各种利益取向的形成作出了贡献。在本章中，我已经展示了在后毛泽东时代农村居民和农民工的“他者化”是如何被置于人们围绕市场改革所产生的渴望和忧虑之中的。在一些媒体文章中，市场改革与“落后的”、“低素质的”、“有犯罪倾向的”农民工危险的进城“风潮”的上升联系在一起，强化了公众对于市场的破坏性结果的忧虑，同时也赋予政府尤其是法律实施机构以强化控制的合法性。

然而在另一些文章中，农民工的形象被用于唤起人们对市场经济的支持，而不是对市场经济危险的关注。这里她被描述成不是威胁国家与（都市）社会的罪犯，也不是与城里人相比“落后的”下等人，而是城里人需要效仿的发展与自我发展的“英雄”。她无论对国内的还是全球的资本家来说都是劳动力的典范—廉价、“富于弹性”、肯吃苦并且没有怨言。

还有一些文章中，农民工被描述成既不是罪犯也不是英雄，而是一个无助的、令人同情的人，是剥削、暴力和性滥用的牺牲品。像其他表述一样，这个形象又回到了20世纪初出现的关于农民尤其是农村妇女的表述当中，可以视为得自西方殖民主义者立场的“东方主义”实践和中国现代主义精英立场的“内部东方主义”。一些有关农民工尤其是打工妹受害者的这类描述，反映并强化了对市场经济的忧虑。然而它们常常又是被媒体用于从大部分受过教育的城市大众那里榨取利润的一种方式，这些城市大众渴望从对处在比自己劣势和无权地位的一个群体的盲目崇拜或同情中获得快乐，并在这个过程中证明自己的优越身份。

简言之，“下等的”、“低素质”、“农民”、“民工潮”和“打工妹”这些表述的起源与发展是与20世纪和本世纪初中国人为民族认同和现代性所作的努力紧密联系在一起的。今天这些形象在和都市与民族认同、秩序、发展和现代性相关的主流话语中发挥了重要的作用。

\*本文为杰华《都市中的农家女：性别、流动与社会变迁》第一章“在‘农村的愚昧’与‘城市的现代性’之间”，吴小英译，江苏人民出版社，2006年 版。

\*\*封面图为2018年6月，广东东莞一玩具厂女工正加班加点赶制俄罗斯世界杯吉祥物。\[图源：视觉中国\]

〇编辑/排版：肠粉

〇审核：翰墨/岂尘

![](https://i.loli.net/2019/01/24/5c49a0f3ad08c.jpg)

![](https://i.loli.net/2019/01/24/5c49a0f4e3c49.jpg)
