---

layout: post

title: 梁文道谈“基因编辑”的伦理：谁来界定“完美婴儿”？

categories: Archive

date: 2018-11-30

tags: 基因编辑

image_feature: "https://i.loli.net/2018/12/04/5c066f0e988a5.jpg"

description: 梁文道谈“基因编辑”的伦理。

---

原文来自「看理想」：[梁文道谈“基因编辑”的伦理：谁来界定“完美婴儿”？](https://mp.weixin.qq.com/s/KLWsNkSDciwPG4yXWSUEMQ)

原文被删一次。

---

![dc275eed3020032d0a12c494e6d6a1e9648e57a6](https://i.loli.net/2018/12/04/5c06721c5e52d.gif)

第二届人类基因组编辑国际峰会的第二天，贺建奎站在了峰会的演讲台上，谈及“基因编辑婴儿”，他依然“无比自豪”。

![](https://i.loli.net/2018/12/04/5c066f0e988a5.jpg)

会议的主持人洛弗尔·巴奇（英国弗朗西斯·克里克研究所，干细胞生物学和发育遗传学系专家），与贺建奎进行了对谈，会后回答记者提问时他说：

“他（贺建奎）显然认为自己在做一件正确的事情，而且他认为自己做事的方法也是对的。但我个人感觉他误入歧途了，听取错误的建议，他本应做一个负责任的科学家该做的事情，负责任的做法是循序渐进而不是急于求成。”

他也遗憾地表示，**这次研究不是业界的突破，而是一小步倒退。**

微博用户@MollyEsWerdeLicht在完成这场峰会的采访稿件后，在微博上写下一段话，其中有几句非常值得回味：“在场的科学家，每一个都著作等身，但是今天他们都变成了粉刷匠，在尽力修补这个人捅破的天。”

“我今天为人类哭一哭吧。不是因为以后改造人会把我们全都超越，而是我们本来拥有文明，却不去竞逐文明。”

![0247ecd603c32d29588c0007a81c623d70726435](https://i.loli.net/2018/12/04/5c06727239b0d.jpeg)

<figcaption>微博@MollyEsWerdeLicht 截图</figcaption>

在这场近乎全世界声讨的“基因编辑婴儿”事件背后，最大的争议点就在于其涉及的伦理道德规范及问题。

往下追问，这其中其实还涉及到人类对于“完美”的执念和追求。利用越来越发的科技手段竞逐所谓“完美”，是彻底的个体解放，还是社会的无限混乱？维系人类社会的道德基础是否会面临坍塌？

今天的《八分》，道长介绍了迈克尔·桑德尔的**《反对完美》** 这本书。除了探讨基因编辑技术手段背后的伦理问题，还希望我们意识到，“接受不完美”以及“追求变完美”，这两者之间永远需要平衡。

也许还是要回归那句常言，技术本身无谓好坏、无辩对错，关键在于我们人类如何利用它。

![](https://i.loli.net/2018/12/04/5c066f0eea03b.jpg)

<audio id="audio" controls="" preload="none">
<source id="mp3" src="http://cdn.vistopia.com.cn/1543555931430.mp3" id="media" width="1" height="1"></audio>


**讲述 \| 梁文道**

**来源 \| 八分**

即使平常再不关注科技新闻，这几天你大概也已经知道什么叫做“基因编辑”了，这全靠深圳南方科技大学的副教授贺建奎先生公布了他惊天动地的一次“实验”。

当这项“实验”被公布后，中国乃至全世界几乎是一片声讨，认为他的所作所为无论在道德上和伦理上，都存在巨大问题。但是到底我们所说的“伦理”指的是什么意思？我暂且试着粗糙地分成两个部分来阐释。

## 1. 专业伦理上，问题重重

首先，是所谓的“专业伦理”，专业伦理指的就是，这个世界上有各种各样不同的专业，在业内会形成一套标准的合乎伦常的行事规范，这里所指的伦常是针对这个专业的特性，或者说，是在这个专业之内被尤为看重的一套伦理程序规则。

举个例子，假如我们将基因改变当成一种医学手段，通过基因改变这种方式，让一对患有艾滋病的父母或仅父亲一方患病的下一代，可以天生不会得艾滋病，这类做法可视作一种医疗手段。

**但是，从医疗专业的伦理来判断，这个做法也是存在问题的。**

![](https://i.loli.net/2018/12/04/5c066f1d1b70f.jpg)

原因很简单，通常在医学中，为了避免过度治疗，避免医疗产生的副作用以及种种不可预知的后果，**大部分情况都会采用最简单、最直接、最高效的治疗手段和方法，而不是大费周章地采取一些被认为在技术上尚未成熟，且风险相当高的手段去治疗。**

以刚才所举的例子来说，让一位患有艾滋的父亲照常结婚生育，同时出生的孩子不会受艾滋病影响，要做到这一点其实并非没有其他医学手段，最简单的办法就是所谓的“精子清洗”（Sperm Washing），清洗程序完成后再植入进子宫，这就是一种较为安全可靠的做法。

当然这种情况下诞生的试管婴儿，在中国同样存在许多争论而不被允许，但至少它是一种比现在贺建奎所使用的基因编辑手段更为安全简便的方法。同时，还有许多其他现行安全有效的医疗手段可采取，他并没有绝对必要进行基因编辑这件事，也就是说，在医疗伦理上，他的做法很成问题。

我们再来看一看关于生物工程或基因工程，基因科学方面的专业伦理，基本上与很多学术界的伦理程序近乎相同。

例如，**要在人体上进行某类实验，就需要明确被实验的对象是否已经给非常清晰地了解这个实验的目的、实验的过程以及实验可能带来的潜在风险。**

![](https://i.loli.net/2018/12/04/5c066f1fc865a.jpg)

<figcaption>电影《千钧一发》剧照</figcaption>

贺教授则表示，接受这次基因编辑实验的志愿者都受过高等教育，他已经和他们解释得非常清楚了，但是，这几天的媒体报道却提供了另一番说法——

有一位志愿者在接受这个实验的时候才发现，他其实根本不懂什么叫做“基因编辑”，而且他也一直不太清楚到底在自己身上进行的是什么样的事情和实验，也不明确在自己、或者将来出生的孩子身上，究竟会出现什么后果。实验的个中情况可能并不如贺教授表述得那样清白简单。

除此之外，贺教授曾对一些同行私下透露过，他的研究是得到了一些相关的审查委员会批准的，可是现在我们却发现好像没有经过这样的程序。如果这些审查委员会确实不知情，那么贺教授就存在造假嫌疑，假如其他相关机构知情，那就是他们和贺教授一起做了一件隐瞒整个科学界、以及国家相关专业委员会及部门的事情了。

从专业伦理上来看，这件事情可谓问题重重。

![](https://i.loli.net/2018/12/04/5c066f246345c.jpg)

## 2. “完美”的界限在哪里？

全世界的学者几乎90%都持反对立场，他们指出了一个全球科学界的共识，基因编辑在伦理上还存在很多有争议的灰色地带，一旦涉及伦理问题的时候，他们认为做这件事就不对了，更不要事件背后的技术本身就不足够成熟。

这就牵涉到关于一般人的伦理问题了，为什么呢？

由于伦理上存在争议，所以做任何基因改变的相关实验，都需要经过一个关乎伦理道德的审查委员会仔细检查审视，正是因为这些科学家认为**背后还有很多隐含的尚未解决的伦理问题**，这些“尚未解决的伦理问题”也就是我们所说的一般伦理问题，也就是说，要等待整个社会对于这方面所牵涉的方方面面，有了一定共识之后，才能去考虑下一步该怎么继续进行。

这里我想给大家介绍一本书，这本书的作者是如雷贯耳的**迈克尔·桑德尔（Michael J. Sandel）**。

![](https://i.loli.net/2018/12/04/5c066f3504906.jpg)

<figcaption>Michael J. Sandel</figcaption>

他的《公正》是一部畅销全球的哲学入门书，或者至少是政治哲学和伦理学的入门书，这也是他在美国哈佛大学的一门公开课。但他其实还有一本小书，是在这本《公正》之前写成的，就叫做 **《反对完美》**。

![](https://i.loli.net/2018/12/04/5c066f44ecc34.jpg)

<figcaption>迈克尔·桑德尔 著《反对完美》</figcaption>

《反对完美》这本书的原版大约在十年前左右出版，虽然到目前为止，在此领域之上的讨论已经有了很大进步，但是许多重要议题，比如关于基因改造的议题，我们仍然可以在这本书里得到不少见地。

这本书在我看来最好的地方就是，**它虽然有一套自己的观点，但是桑德尔仍然愿意像一般哲学家一样，充分列举正反方的种种论证，我认为这也是我们思考任何重大争议应该持有的一种态度。**

书中一开始就先声夺人地举了一个听起来颇为古怪的例子——

> 在上世纪90年代末，有一对同性伴侣决定要生一个孩子，由于这两人恰好都失聪（也就是一般所述的“聋子”），她们居然期望也怀上一个失聪的孩子。为什么？那是因为她们认为，“聋”不是一种病，相反的，它是一种生活方式。
>
> 身为聋人，她们认为自己非常完整，所以她们很想和自己未来的孩子也分享聋人社群美妙的一面。于是，她们通过各种渠道最终找到家族五代人都出现聋子的精子捐赠者，结果如愿以偿。

这件事情当然引起非常大的争议，许多人指责这对伴侣的“不道德”。

乍听之下，的确可以认为她们所做的是一个错得离谱的决定。可是假如你仔细思考一下这个问题， **其实也指出了一个我们平常很容易忽略的、很模糊的一件事情，那就是所谓的疾病和健康的界限。**

![](https://i.loli.net/2018/12/04/5c066f48cb4f5.jpg)

到底什么是需要医治或者需要矫正的问题，什么才叫做正常的健康状态呢？

如果关于“失聪”是否是健康正常的争议太难讨论，那我们换一个简单的例子：日本女孩常常会有牙齿的问题，比如显著的虎牙或突出的门牙，那么这到底是不是一个健康或者正常的状态？有的国家就会认为，这是需要矫正的畸形；但是在另一些国家，比如日本甚至有人会故意去将牙整成不整齐，或突出的虎牙，为的就是让自己看起来更加的可爱。

有时候我们真的很难轻易说明，什么能称作正常的健康，什么叫做疾病。

## 3. 公平的问题，永远无法一概而论

在这个前提下，我们再追问一个问题：如果基因疗法可以治愈某些疾病和身体状况的问题，那么我们是否能透过基因改造让一个运动员拥有更好的体能和运动表现？

如果这样问，可能我们马上会认为，前者与后者是不一样的，前者是治疗问题、治疗疾病，而后者却是要增强一个人的能力。用基因疗法强化一个人的表现，这恐怕是不对的。

可是，它们之间的界限真的有如此大的分别吗？像之前所论，如果我们连何谓健康状态和何谓疾病之间的界限都不一定能清晰区分，那所谓的治疗与改善之间的界限，是否又真的那么绝对呢？

我们可以再接着追问，如果通过基因改造让一个运动员表现更好，这是不对的，那么到底指的是哪里不对？  

可能有人会说，**是因为不公平**。但是，在运动竞技上，本来就存在诸多不公平，比如很多运动员的能力表现突出，完全是由于天赋。天赋在一定程度上，就已经决定了个人在运动场上的表现。

但是如果照此思考，**为什么基因改造，就会使得情况变得不一样，会让我们觉得更加不公平呢？**

![](https://i.loli.net/2018/12/04/5c066f528341b.jpg)

<figcaption>电影《千钧一发》剧照</figcaption>

我们试着换一个方向来思考，假如有一对父母想透过基因编辑、基因改造的方法，或者其他基因工程手段，使得他们的下一代在各方面的表现都比其他孩子更加优异，这样的想法到底有没有问题？

现在可以试着从以下两点，来进行一下反方向的思考：

第一点，其实自古以来人类就已经不断在想办法，至少是很多父母不断在想办法，在还没有生下孩子之前，就试图决定孩子的性别。

而自从我们能够用超声波提前判断胎儿的性别之后，印度这样一个传统的“男尊女卑”国家就已经产生了很严重的后果，很多孕妇会因为怀上的是女孩而选择堕胎，结果就导致现在印度人口的男女比例严重失衡。

第二点，我们一般所说的公平问题，假如一对父母已经拥有足够的金钱和资源，然后他们希望通过基因工程打造“完美”下一代，在各方面都有更优秀的条件，可能我们会认为这是不公平的。

但是试想，假如这对父母不通过基因工程，而是经过后天的精心培养而达到这样的效果，那不就是我们今天常常见到的情况吗？

![](https://i.loli.net/2018/12/04/5c066f5cdfd7d.jpg)

一对更具金钱实力和享受更好资源的父母，他们的下一代，在许多表现上可能的确会比一般家庭的孩子要好，这是因为这些孩子从小就得到了最好的照顾，营养健康、生活环境优渥，就学环境也比其他人强，这就是我们一般人所说的“赢在起跑线上”。

那么，这两者的区别是什么？假如我们认为在基因工程上，获得一个完美的孩子是不公平、不正义的，那么有钱父母在他们的孩子身上所投入的种种金钱和资源是否也是不公平、不正义的呢？

这些都是问题，不能简单地一概而论。

## 4. 父母变成了自己孩子的“暴君”

最后，我们还可以从父母和子女的关系角度来思考，父母与子女，究竟应该是一种什么样的关系？

假如父母通过基因工程，为自己定制了一个仅符合他们心目中理想形象的孩子，这样的情况会不会改变父母和子女之间的亲子关系？甚至，会不会影响到这个孩子的自主性？

非常伟大的德国思想家哈伯玛斯（哈贝马斯）就曾说过，**每一个人都该是自己人生的作者，要为自己的人生负责。**

![](https://i.loli.net/2018/12/04/5c066f6ff0432.jpg)

<figcaption>于尔根·哈伯玛斯</figcaption>

但假使父母已经提前参与了孩子的“设计”，那么这个孩子就已经不再是自己人生的唯一作者了。

当他/她不再是自己人生唯一作者，那么他/她的将来是否父母也无可避免地要负上责任，而这样的关系就不再可能是平等互惠的。这也就是哈伯玛斯反对遗传基础的优生学的理由。

让我们再回到这对接受“基因编辑”的父母身上来谈，全天下的父母都希望自己的孩子拥有一个更美好的未来，这是无可厚非的。

但桑德尔在书中就引述了一位心理学家梅所提出的说法：**父母对孩子的爱有两面，一面是接受的爱，另一面是转化的爱。**

**接受的爱，就是指要接受孩子生下来的情况，接受他的性格，接受孩子的本质；而转化的爱，则是追求孩子的福利，希望他/她会过得更好。**

![](https://i.loli.net/2018/12/04/5c066f7ee0e6c.jpg)

这两种爱，他认为应该是**需要平衡的**。也就是，一对父母要把自己的孩子完整整地接受下来，即便他/她可能身体上有问题，也许有阅读障碍，也许性格如此，也许天赋所限，父母应该要接受孩子的本质，这是没有办法的。

但是另一方面由于又希望让孩子拥有一个更好的未来，于是父母便希望有一种转化的力量，能把这种爱用一种转化的方式表达出来，让孩子有办法谋求自己更美好的人生，这其实也是很正常的，不过这两者之间是需要平衡。

然而，**野心过度的现代父母常常有一个很大的问题，就是让转化的爱压倒了接受的爱，让转化的爱和接受的爱之间失去了平衡，结果最后，父母变成了自己孩子的暴君。**

![](https://i.loli.net/2018/12/04/5c066f880cfb7.jpg)

这最终可能会导致这样一种情况的出现，也就是当将来基因工程真正被许可的情况发生了，也许大部分有能力、资源的父母都会希望为自己打造一个“完美的孩子”。

这又是不是一种父母过度自我，自大又傲慢的表现呢？当然，他们自己是不会这么认为的，**因为我们今天这个社会就是这样一个社会**，是一个父母对子女的要求越来越多，父母越来越渴望子女顺着自己心目中理想的道路前进，而且执着地认定“这都是为了他们好”的社会。

这也已经成为一个全球现象，也就是说不论基因工程走到什么地步，我们的社会恐怕都已经为设计“完美婴儿”这一步，做好了社会心理上的准备了。

这也就是桑德尔《反对完美》中的一个核心观点，在这个观点之下，**问题其实已经不在于基因改变，而在于基因改变技术是在一个什么样的背景下被实现，或者在一个什么样的背景下被我们重视。 **

![](https://i.loli.net/2018/12/04/5c066f883f93a.jpg)

![](https://i.loli.net/2018/12/04/5c066f8ee8ad7.jpg)

电影《千钧一发》剧照

**本期八分问答**  

**（问答答案均在每期音频末尾）**

**本期提问【提问者 \| Li 】**：请问道长，在现在大家都往专长发展的情况下，如何才能保证在一个大家都懂的情况下进行有效的交流？尤其是在涉及到技术层面，大众并不了解自己的决定会产生什么样的后果，在此情况下，授权他人解决会比自己解决更好还是公众有义务作出负责任的决定？

▼  

**欢迎分享今日八分·图签**

![](https://i.loli.net/2018/12/04/5c066f96beb7f.jpg)

**如果你也有想问的问题，欢迎至后台回复【提问道长】** 

**回顾往期<八分>：可在后台回复【八分】，或点击公众号底部菜单栏**

**另外！八分已在【看理想App】上同步更新，** 看理想小程序将停止更新。

**长按扫描下方二维码**

**即刻下载【看理想App】**

**▼**

![](https://i.loli.net/2018/12/04/5c066f9dc2b54.jpg)  

**转载**：请微信后台回复“转载”

**商业合作或投稿**：xingyj@vistopia.com.cn
