---

layout: post

title: 假如帝国的黄昏降临

date: 2018-10-09 12:00

image_feature: "https://i.loli.net/2018/10/13/5bc1fff5e9b37.jpg"

categories: Archive

tags: 经济

description: 很多人认为过去发生在不同年代，不同国家的经济危机都是由不同的原因造成的，而我只看到了同样一些事情一次次的重复上演。

---

文章来自虎嗅「Murph丶璇」：~~[假如帝国的黄昏降临](https://archive.fo/DN5sJ#selection-2401.5-2401.12)~~

---

几天前刚刚读完了 Ray Dalio 在今年9月10号才发布的新书 *Big Debt Crisis*（《债务危机》），作为全球最大的宏观策略对冲基金 —— 桥水的创始人，Ray 凭借他对宏观经济以及债务危机深入本质的了解与研究，带领桥水看遍了世界经济舞台上不断上演的泡沫与崩溃，疯狂与绝望。 

Ray 在书中说，“很多人认为过去发生在不同年代，不同国家的经济危机都是由不同的原因造成的，而我只看到了同样一些事情一次次的重复上演。”

这“同样的一件事情”被 Ray 总结成了一套债务危机爆发的“模式”，并通过这本新书介绍给了我们。书中还罗列了过去一百年间曾发生过的48次经济危机（GDP增速低至负3%或以下），包括对其中的三次（1921年德国爆发的“超级通胀”；1929年美国的“大萧条”以及作者亲身经历的2008“次贷危机”）的详细介绍。

由于中国自有现代化的经济数据以来就没有遇到过书中所定义的危机，因此这本书几乎没有提到中国这个词。但是作为读者的 Murph，自然会不断拿我国经济的发展历程来对照这个模式，试图搞清楚我国会不会也遭遇危机呢？ 

于是就有了这篇文章，这是一个关于中国经济的故事，让我们从头说起。

![01.jpg](https://i.loli.net/2018/10/13/5bc1fff5e9b37.jpg)

## 第一阶段——繁荣 

对于一个国家来说，资本是发展经济必不可少的因素。一个国家的经济如果想要发展，就必须投资教育，投资基础设施，投资工厂，投资机器。我国改革开放前三十年的成就其实不过是把地里的农民变成了工厂里的工人，从农业国变成了工业国。但是可不要小看这一点，工厂里的机器是要花钱买的，产品生产出来之后是需要公路和港口来运输的，工厂运转是要电的，这些东西都需要大量的投资。 

那么投资从哪里来呢？来自储蓄。对于一个人来说，我们投资的钱来源于储蓄，而储蓄又来源于我们的收入减去消费。对于国家来说也一样，只是稍微复杂了一点，因为一个国家用于投资的钱即可以是自己国民的储蓄，也可以是外国人的储蓄。也就是说一个国家还可以通过借外债来投资，发展经济。但问题是借外债的风险非常大，后面我们会用大家耳熟能详的巴西与阿根廷作为例子来说明为什么。 

《断层线》的作者，前任印度央行行长 Raghuram Rajan 通过对发展中国家几十年经济发展的研究发现，一个国家的投资越多，经济发展就越快，然而，如果投资中资金来源是外债的比例越大，其增长速度相对于那些少有外债的国家就会越慢。

换句话说，用自己国民的储蓄来投资并发展经济，才是最好的方式，这样即有足够的钱来投资，又避免了借外债。而这正是我国过去三十年发展经济的方式。 

![02.jpg](https://i.loli.net/2018/10/13/5bc1fff57a4ea.jpg)

如图为各国国民储蓄率（国民储蓄 = 政府储蓄 + 居民储蓄 + 企业储蓄）的比较，中国高居榜首。经济发展最快的几个国家，韩国，印度，德国的储蓄率都很高。可以说，如果没有高水平的储蓄率，中国是不可能实现如此快速的经济增长的。

![03.jpg](https://i.loli.net/2018/10/13/5bc1fff53baea.jpg)

中国高储蓄率的原因有很多，除了民族特点之外，就是众所周知的福利水平较低了。如上图，由于福利水平较低，所以我国的居民储蓄与政府储蓄均远远高于美国。说到福利，看到第一张图的朋友们不知道会不会想到巴西这个国家呢？ 

我在之前的文章中写到巴西经济被国内不可持续的高福利政策所拖垮。例如在巴西，平均的退休年龄是55岁。退休之后可以获得的平均退休金是退休前工资的70%。而 OECD (美国，德国等发达国家联盟) 国家的平均退休年龄是65岁，退休之后可以获得的退休金仅为之前工资的50%。 

这样的高福利政策导致了两个问题，第一就是政府没有钱。在那篇文中我也写到作为一个国土面积跟美国差不多大的国家，巴西国内竟然没有可堪重任的铁路网。就连农民都知道“要致富，先修路”的道理，但是巴西政府没有钱修路。第二就是高福利导致居民的低储蓄率（养老金太过丰厚，就没必要储蓄了）。居民和政府的低储蓄相加，导致巴西的总储蓄率只有15%，如上图，处于倒数第二的位置。 

由于国内居民的储蓄率太低，迫使巴西不得不借大量的外债（以美元计价的债务）来投资并发展经济。不过有关巴西的故事，我们后面再说。 

过去几十年间，中国通过把大量的收入用于储蓄，进而转化成投资，让中国经济几乎是以肉眼可见的速度完成了现代化。但问题是，如果我们把大量的收入用于储蓄，消费能力不就变得很低了吗？没错，事实正是这样。中国的居民消费占GDP的比一直处在40%以下，不仅远远低于美国的70%，也低于世界上几乎所有主要国家。 

既然消费能力差，而生产能力又很强（经济发展在本质上是生产力的提高），我们便没有能力消费掉自己生产的产品。于是只有依靠外贸，把产品卖给外国人。 

![04.jpg](https://i.loli.net/2018/10/13/5bc1fff5ef13a.jpg)

如图为中国出口总额占GDP的比，可以看到从改革开放之后它一直在快速的上升，2001年加入WTO之后更是几乎变成了一条直线。 

由于我们消费的少，生产的多，所以经常账户一直是顺差，即出口的多，进口的少。在正常情况下，这会导致人民币不断升值，因为在外贸市场上，为了购买中国生产的产品，即便出口多以美元结算，但出口商终究是要把拿到手的美元换成人民币来发工资的。因此在外汇市场上，对人民币的需求会超过美元，从而导致人民币兑美元升值。 

在这种时候，政府会面临两个选择，既可以选择放任人民币升值，进而不断侵蚀中国产品的国际竞争力（人民币升值会让出口产品变贵，而外国进口的产品变的更便宜），也可以选择印钞去市场上买美元，增加对美元的需求来抑制这个趋势。 

（ \* 印钞去买美元这件事本身并不会导致货币泛滥，因为还可以用存款准备金率来调节。有兴趣的朋友可以去了解一下“货币乘数”这个概念。因此印钞去买美元避免人民币升值明显是一个更好的选项。） 

中国政府选择了后者，印人民币去买美元，维持汇率稳定，以保持出口竞争力。而买到的这些美元，就变成了我们的外汇储备。 

![06.jpg](https://i.loli.net/2018/10/13/5bc1fff6a76e6.jpg)

如图为中国的外汇储备余额，从2001年中国加入WTO之后一飞冲天。 

故事进展到这时候，我们发现中国政府几乎做对了所有的事，才促成了这一场持续了三十多年的经济奇迹。作为一个中国人，我不仅感觉到自豪，甚至会觉得有些神奇。 

当然，我们的故事还要继续。 

## 第二阶段——泡沫 

当一个国家的经济经历繁荣时，它往往会吸引全世界的投资者。如下图为中国的外商直接投资，从2001年开始，每年都超过500亿美元，2005年中国宣布将允许人民币升值之后，更是每年都超过1000亿美元。 

![07.jpg](https://i.loli.net/2018/10/13/5bc1fff6abfea.jpg)

原因很简单，如烈火烹油的经济状态往往会推升资产价格，因为房子和股票都变得更有价值了，而货币又在升值，此时投资中国可以获得双重收益 —— 资产本身的收益叠加人民币升值的收益。 

Ray 在书中写到，在这个时段，由于可以吸引到来自全世界的资金，往往会导致这个国家产生资产泡沫。这一点大家都再熟悉不过了，我就不赘述了，直接列一下结果：根据全国人大财经委副主任委员黄奇帆的说法，目前中国一线城市的房价收入比（即一个居民不吃不喝多少年可以买一套房）已经达到了四十倍；二线城市也达到了二十倍；而纽约只有六倍，伦敦只有十倍。可以说已经是一个超级大泡沫。 

在资产价格膨胀的过程中，社会中会逐渐出现一些靠贷款买房发家致富的人。他们的故事很快被传播开来，从而吸引更多的人靠债务投入进来，然后再吸引更多的人。没有进来的人都会有一种错失良机的感觉，因此泡沫越吹越大，债务也越积越多。

 如图为中国居民负债与GDP的比，在过去十年中伴随房产泡沫快速上涨。

![08.jpg](https://i.loli.net/2018/10/13/5bc1fff7209b2.jpg)

说到这里，债务这个词终于出现了。让我们先来聊一聊它。在前文中我们写到，一国发展经济最好的方式就是储蓄，然后将储蓄转化为投资，发展生产力。而从储蓄转化为投资的过程往往就会产生债务，例如我们把钱存在银行，然后政府把它借走去修路了，或者企业把它借走去建厂了。 

所以债务本身不存在好与坏，有分别的是债务的用途。用Ray的说法就是，债务的用途需要产生足够的经济效益来偿还这笔债务。我们可以设想一个高中毕业的学生，他即可以贷款去上大学，也可以贷款去买跑车，这两者的区别是显而易见的。

 当然，也并不是负债去投资（上大学算一种投资）就一定是好的。因为投资本身并不一定可以获得足够的回报。例如买房就属于投资，而大部分在次贷危机之前投机买房（买房不是为了住，而是为了等升值）所产生的债务就是有问题的。因为除非房价可以持续上涨，不然这笔投资便无法产生足够的经济效益来偿还这笔债务，最后很可能会大面积违约，导致经济危机。

 那么有没有一个方法可以判断一个国家在一段时间内所产生的债务是有效的还是有害的呢？Ray 的方法是观察债务与GDP的比这个数字。原因是GDP是国家总收入，而债务我们前面提到了，可以通过投资来提高生产力，进而提高总收入。因此，如果债务与收入的比在一段时间内快速上升的话，就说明这段时间内产生了大量的债务却没有带来收入的相应增长。而我们都知道，借了超过自己收入能力的债务是会导致违约的，对一个国家来说，则会导致经济危机。 

根据今年国际货币基金组织的一份工作论文中的研究，在过去的43次一国债务与GDP的比在五年内增幅超过30%的案例中，除了五例特殊情况外，其余的38次全部在随后的五年内爆发了经济危机。 

![09.jpg](https://i.loli.net/2018/10/13/5bc1fff75329f.jpg)

如图，中国是绿色的，在左上角，因为还没有爆发危机。作者之所以说那五例是特殊情况因为其中的三例是刚刚从上一次经济危机中走出，另外两例则是在五年之后爆发的经济危机。而且作者还强调，所有在债务与GDP的比在初始状态就是100%以上的国家（中国就是这种情况）都在五年内爆发了经济危机（即五个例外都是初始状态在100%以下）。

![10.jpeg](https://i.loli.net/2018/10/13/5bc201118fdb9.jpeg)

<figcaption>美国私人债务占GDP的比</figcaption>

如图为美国私人债务占GDP的比。我们可以看到在2008年爆发次贷危机前的十年中美国的这一比率有大幅的上涨。 

![11.jpeg](https://i.loli.net/2018/10/13/5bc201122bd6f.jpeg)

<figcaption>中国私人债务占GDP的比</figcaption>

如图为中国私人债务占GDP的比。我们可以看到在中国经济发展最繁荣的阶段，即2001至2008这几年，虽然债务本身也在飞速的增长，但由于经济（收入）的增速也很快，所以债务与GDP的比几乎没有什么变化。按照Ray的标准，我们可以说那些年所增加的债务都是好债务，它们被投资在了可以产生经济效益的地方。 

而2008年以后的十年就不同了。对比美国我们发现，在同一时间，美国的这一数据从170%下降到了150%，而中国则从120%上涨到了210%，无论从上涨的速度，还是到达的高度上来看，都几乎是前无古人的。除了一个国家，就是1990年的日本。 

![12.jpeg](https://i.loli.net/2018/10/13/5bc20112b7904.jpeg)

<figcaption>日本私人债务占GDP的比</figcaption>

如图，日本在1990年爆发经济危机之前的十年中也有债务与GDP的比飞涨的现象，因为它也经历了严重的房地产泡沫。我们都知道，危机之后，日本房价下跌了近三十年（下跌幅度超过65%），日本经济陷入了失去的三十年。 

![14.gif](https://i.loli.net/2018/10/13/5bc2011431725.gif)

<figcaption>日本房价</figcaption>

这看上去很可怕，确实，与目前中国经济现状最类似的一个国家大概就是当时的日本了。不过日本经济遭遇失去的三十年是因为它在1990年之后犯了一系列错误，而有日本的前车之鉴，我相信中国是不可能犯这些错误的（例如美国在2008年就没有犯这些错误），但这并不意味着中国就不会爆发危机。有关这个问题，我们到文章的最后再来讨论。 

我们发现，日本在80 ~ 90年，美国在98 ~ 08年，以及中国在08 ~ 18年间，都发生了债务与GDP的比飞涨的现象，其中最重要的一个原因就是它们都经历了房地产泡沫。 

例如根据南开大学国家经济研究院院长夏斌今年3月在清华大学的演讲中所运用的数据：“2016年底，中国涉及房产的贷款有26.7万亿，占全部银行贷款25%。到现在（今年3月），真正和房价、地价相关的贷款已经达到了70%。“ 也就是说，大量新产生的债务并没有变成未来可以产生经济效益的投资，而是变成了房贷，或者地贷。

这就导致了，按照Ray的说法，收入的增速远远赶不上债务的增速，而现在之所以能够产生这么多债务是因为在资产泡沫下抵押品的价格很高，而一旦发生危机，当资产价格下降时，当收入减少时，就会产生大量的违约，从而引爆更严重的经济危机。当时美国的银行们为什么愿意给买不起房的人贷款呢？因为他们认为即便还不起房贷，只要把被抵押的房子卖掉就可以了。而他们没有考虑到如果房价也跌了怎么办？当时的美国人一样坚信着“一线城市房价永远涨”的神话。

## 第三阶段——反转 

这一阶段的标题叫做反转，但它的意思并不是资产泡沫要破了，而是经济在这一阶段开始由烈火烹油般的繁荣变的不那么繁荣了。原因有两个。 

第一，前面说到，当一个国家在依靠出口拉动经济，产生大量贸易顺差时，它的汇率会自动上升（汇率这个东西本来就是用来调节贸易平衡的）。这时政府有一个选项，就是印钞去外汇市场买美元，“操纵汇率”，强行稳定住人民币的汇率。 

![15.jpeg](https://i.loli.net/2018/10/13/5bc20112b91c9.jpeg)

<figcaption>人民币兑美元汇率</figcaption>

如图为人民币兑美元的汇率，我们发现人民币从1995年到2005年这十年间都被政府强行稳定在8.3这个位置上。但是就像我在贸易战那几篇文章中写到的那样，国际贸易体系毕竟不是只有我们一个玩家，如果我们总想赢，那么别人就不玩了。所以我们不得不在2005年开始允许人民币升值。而人民币升值就会导致出口产品变贵，竞争力下降，而进口产品变的便宜，国内厂商竞争压力陡升。 

第二，除了汇率这个外部因素外，还有一个内部因素。因为在经济繁荣时期GDP会高速增长，而GDP就是国民总收入的意思。虽然中国居民收入在GDP中占比没有美国的近80%那么高，但是也有60%，因此中国居民的收入是会随着GDP一起上涨的。而收入的上涨也会逐渐侵蚀国内的出口竞争力（因为企业要不断提高工资才可以雇佣到人），让我们生产的东西变得更贵。如图， 

![17.jpeg](https://i.loli.net/2018/10/13/5bc2011390c6d.jpeg)

以上这两个原因会让中国经济的竞争力下滑。从而导致在国内的投资变得没有以前那么容易产生收益。这也是在这个阶段债务与GDP的比会加速扩大的原因之一，因为同样的一笔投资，不太可能获得十年前的那种收益了。所以中国目前天量债务的现状也不能全怪房地产。 

因此，在反转阶段，由于经济竞争力持续下滑，投资收益率不断下降，最终会导致资本外流，因为此时投资别的国家可以获得更高的风险收益比（承担更小的风险或者获得更高的收益）。 

而资本外流最直观的表现就是外汇储备的下降，如图：

![18.jpeg](https://i.loli.net/2018/10/13/5bc201135596e.jpeg)

<figcaption>中国外汇储备余额</figcaption>

从2014年到2016年年中，我国外汇储备大幅下降一万亿，最终因为资本管制的加强而得以被抑制。 

除了竞争力下降外，在Ray的模型里，还有一个原因会导致资本外流。前面提到，繁荣时期往往会催生资产泡沫，而资产泡沫会带来“财富效应” —— 房产升值，股票升值会让人们觉得自己更有钱了，因此会刺激消费。这里有朋友可能要提出质疑，觉得房贷把大家的钱都套住了，所以应该导致“消费降级”。其实中国目前并不是“消费降级”，而是“两极分化”。没房的人可能被房子压的喘不过气，但是有房的人可真觉得自己一夜暴富了。根据美国白宫在2010年的报告，美国收入前10%的人占了总收入的60%以上，因此，理所当然的，这部分人的消费也占了50%以上。换句话说，最能决定一个国家消费是否快速增长的，就是这部分有钱人，他们都是有产者，有房子，有股票。

![19.jpeg](https://i.loli.net/2018/10/13/5bc2011358658.jpeg)

如图为中国私人消费占GDP的比，从2010年开始快速上升。由于消费就是收入减储蓄，因此储蓄率也在下滑。 

（ \* 心理学上有一个原理告诉我们，人们都会严重高估跟自己处境相同的人的数量。例如喜欢足球的人会严重高估同样喜欢足球的人在总人口中的比例，etc。因此，根据自己所处的境遇而否定财富效应的存在是很正常的，但并不正确。） 

Ray 通过研究过往案例的经济数据认为，在泡沫阶段，财富效应会导致消费上升，它不仅会令国内消费扩大，例如上面那张图，也会导致进口上升 —— 购买外国的产品和服务也会相应增加，进而让经常账户恶化（产生逆差）。这一点最直观的表现就是国人出国旅游和留学的人次与花费在快速增加。 

![20.jpeg](https://i.loli.net/2018/10/13/5bc2020e5b159.jpeg)

当然，就算没有财富效应存在，随着中国经济的发展，人均收入的大幅提高，这两个数据也会增加的，只是可能没有这么快。 

前面我们写到过，一国出口比进口多的情况下（经常账户顺差），会让外汇市场上对本国货币的需求量变大（即便商品以美元结算，厂商终究还是要换成人民币来发工资的），进而推升本国货币升值。而如果产生了经常账户逆差，则会让本国货币有贬值的压力，进而引发资本外逃。 

由于财富效应影响的是进出口的平衡，那么最直观的表现就是经常账户的恶化了。 

![21.jpeg](https://i.loli.net/2018/10/13/5bc2020eea7ec.jpeg)

如图为中国的经常账户，可以看出从2008年之后顺差确实大幅下降了。不过跟那些爆发过危机的国家相比，中国的经常账户目前可以说是没什么问题的。 

![22.jpeg](https://i.loli.net/2018/10/13/5bc2020ee8fb4.jpeg)

如上图为泰国在年引爆1997年亚洲金融危机时的经常账户，几乎连续十年为负，而且多年超过了负5%。根据Ray的统计，在27个最终由债务危机演变为货币危机（货币大幅贬值，通胀或膨胀大幅上升）的国家中，在爆发危机的那一年，平均经常账户余额为负（逆差）6%。而中国现在是正（顺差）1.75%，可以说距离警戒线十分遥远。所以说目前来看，贸易问题对中国资本外逃的贡献微乎其微。不过我还是把它写了下来因为很明显，情况正在发生变化 —— 贸易战来了。 

由于美国每年进口大量中国商品（去年为5000亿美元），而中国只进口很少的美国商品（去年为1300亿美元），因此贸易战一方面肯定会严重损害中国出口企业的价格竞争力（被加了关税），另一方面则会因为出口下降而令中国的经常账户恶化。这两点都会加剧资本外逃的趋势，进而让人民币贬值。事实上市场也确实是这样反应的，在过去短短几个月里，人民币兑美元贬值了8.5%。 

贸易战的问题是中国在面对债务危机的压力时最大的挑战和变数。它也是目前中国的处境不同于所有之前爆发过危机的国家的主要原因，因为中国不仅需要考虑其所运用的政策会对自己产生什么影响，还要考虑它们会对全世界产生什么影响。我们现在已经是世界第二大经济体和第一大贸易国，如果中国爆发危机，它肯定也会迅速的波及全世界，创造又一个“百年一遇”。那我们会爆发危机吗？ 

## 第四阶段——崩溃？ 

让我们不要忘了Ray 的那句话，“很多人认为过去发生在不同年代，不同国家的经济危机都是由不同的原因造成的，而我只看到了同样一些事情一次次的重复上演。” 

那么，对于我国这样一个一步步按照债务危机的模板 —— 依次经历过繁荣，泡沫，竞争力下滑，债务飞涨和资本外逃的国家来说，最后大概率是会发生危机的。这一阶段我们就来分析为什么，不过对于投资人来说，我们不仅关注会不会发生危机，更关注危机爆发后会发生些什么事。 

让我们再次介绍一下我在《世界经济2017》中介绍过的Ray眼中的经济盛衰循环，不过这会解释的更详细一点。 

![23.jpeg](https://i.loli.net/2018/10/13/5bc2020ee61b0.jpeg)

如图，左边代表债务，右边代表生产力。首先我们需要知道，在长期来看，一国的人均收入水平就是由它的生产力决定的。例如中国比印度富有是因为我们有能力大规模的生产汽车，生产手机，修建高铁，而印度由于国内极度不自由的经济环境（明码标价的腐败，无处不在的经营许可证以及僵化的劳动力市场等），到现在也只能生产一种七十年前就有的“大使牌汽车”。当然，一个国家想要发展经济不是储蓄就可以了，还要有良好的经济制度，高效的政府以及自由的商业环境。不过这些就不在这里展开讨论了。 

如果没有债务的话，经济的发展（收入的增长）就应该是非常平稳的，像右边那样，收入随着生产力的提高而稳定增长。但是很明显，在真实的世界中一个国家的经济发展往往是左边那种情况，有繁荣，有衰退，形成循环。为什么呢？因为债务可以在短期内提高人们的收入。 

前面讨论过，当经济处于繁荣期时往往会推升资产泡沫，资产泡沫导致财富效应，让经济更显得烈火烹油般火热。此时，人们会错误的估计自己的未来收入，会认为经济将永远繁荣下去，“房价永远涨”这样的幻想也开始出现在人们的脑袋里。另外，我在《世界经济2017》中还写到贫富差距的扩大（资产泡沫扩大贫富差距）会导致穷人为了不大幅落后于富人快速提高的生活质量，而不得不依托于债务，靠借钱来强行提高自己的生活水平。 

以上这三种现象叠加起来就会导致人们在短期内依靠债务大幅增加自己的消费/投资水平。是不是这样呢？举一个极端点的例子，当我认为房价永远涨的时候，我会贷款去买十套房子。而在经济活动中，一个人的消费/投资，就是另一个人的收入。我买了十套房，卖房子的人瞬间获得了大量的收入。因此，当我们依靠债务大幅增加自己消费/投资水平的时候，我们的收入也会大幅增加，在生产力并没有大幅提高的情况下。 

于是就有了下图： 

![24.jpeg](https://i.loli.net/2018/10/13/5bc2020f0921d.jpeg)

如图，灰色线代表在没有债务的情况下，经济发展（收入增长）的轨迹，黑色线则代表在有债务的情况下，经济发展（收入增长）的轨迹。所以产生了我们耳熟能详的“经济周期”。 

更有趣的是，现在我们知道了，由于一个人的消费/投资就是另一个人的收入，因此在繁荣和泡沫期 —— 黑色线超过灰色线的部分，收入的快速增长本身就是不可持续的（因为债务不能无限增长）。但是往往在这个时候，前面提到过，债务与收入（GDP）的比还要更加大幅度的增长呢。 

![25.jpeg](https://i.loli.net/2018/10/13/5bc2020ee78b9.jpeg)

<figcaption>美国私人债务占GDP的比</figcaption>

例如美国在次贷危机前发生的情况，这一比率曾大幅增长。可想而知在这个过程中，整个经济已经是多么危险。迟早有一天，人们借债的能力会达到极限，债权人会意识到来借钱的人的收入能力其实根本不足以负担这笔债务；而债务人也会因为自己背负太多的债务而感到害怕。 

当这一天到来的时候，债务人会停止借贷的行为，有可能是被动的（因为债权人害怕了）， 也有可能是主动的（因为自己害怕了），整个过程便开始翻转。债务减少导致消费/投资减少，而一个人的消费/投资就是另一个人的收入，又会导致收入减少。收入的减少会让债务人更加不敢，或者更加没有资格借钱。更糟糕的是，由于收入下降，资产价格往往也会在同一时间崩盘，因为收入大幅上涨的愿景破灭后人们又如何能负担的起如此昂贵的资产呢？当资产价格与收入同时下跌时，大量的违约就产生了。而违约导致抵押的资产被拍卖，更加剧了资产价格下跌的速度，从而形成恶性循环，一场经济危机就这样爆发了。 

可想而知，上面所描述的情形是非常可怕的，因此当它发生的时候，各国政府都会想尽办法救市，或者说在危机真正爆发之前就采取印钞等手段想要阻止危机的爆发。 

说到救市，大家一定会联想到“四万亿”，其实它不是过去十年内中国政府唯一的一次救市。接下来，我们就要去搞清楚中国过去这些年到底发生了什么，不过必须先去看看美国在2001年发生了什么。 

在2001年，美国遭遇了互联网泡沫的崩溃（纳斯达克指数狂跌78%）以及9-11，一场危机近在眼前。为了应对危机，时任美联储主席的艾伦·格林斯潘开始下调利率（印钞）。 

![26.jpg](https://i.loli.net/2018/10/13/5bc2021028415.jpg)

<figcaption>美国利率</figcaption>

如图，从2000年的6.5%一路下调至2003年的1%。这一举措成功的降低了整个社会借债的成本，因此人们得以继续依靠债务消费/投资。 

让我们再来看一下这张图， 

![27.jpeg](https://i.loli.net/2018/10/13/5bc2020f88459.jpeg)

<figcaption>美国私人债务占GDP的比</figcaption>

结果就是，虽然美国在2001年还是遭遇了经济衰退（灰色部分 —— 连续两个季度GDP负增长），但是债务并没有下降，而是继续高歌猛进。 

![28.jpeg](https://i.loli.net/2018/10/13/5bc2020f888f6.jpeg)

<figcaption>美国房价</figcaption>

如图为美国房价走势图，我们可以发现从1996到2001年之间，美国的房价就已经同债务一起在快速的上升了。可以想象，如果在2001年美联储没有印钞（降低利率）去救市的话，美国在当时会遭遇一场更持久的衰退，但是大概也可以避免后来在2008年遭遇次贷危机这样的灾难了（因为泡沫变得更大，债务变得更多）。 

这样想问题虽然没错，但是问题在于，通过对过去所有爆发过危机的国家的研究，Ray发现没有一个政府会不救市。没有人会同意在自己的任上爆发危机而袖手旁观。 

因此，之前我们提到的模型就变成了这样： 

![29.jpeg](https://i.loli.net/2018/10/13/5bc2020f8a42a.jpeg)

如图，在一个大的债务周期内，会有很多小型债务周期，每当一个小型债务周期开始反转时，政府就会出手救市（通过印钞降低利率），并开启下一个小型债务周期。在这个过程中，就像美国在2001年的经历那样，每一个小型债务周期都会让债务总量变得比上一个周期更多。 

但是很可惜，债务最终不可能涨到天上去。 

![30.jpg](https://i.loli.net/2018/10/13/5bc202f72bff3.jpg)

<figcaption>美国利率</figcaption>

如图依然为美国利率，在次贷危机时，美联储更快速的降低了利率，甚至把利率降到了零。 

![31.jpeg](https://i.loli.net/2018/10/13/5bc202f5072c2.jpeg)

<figcaption>美国私人债务占GDP的比</figcaption>

可是如图，美国的债务与GDP的比依然在快速的下滑。换句话说，没能阻止之前我们解释过的那个恶性循环。 

![32.jpeg](https://i.loli.net/2018/10/13/5bc202f59cfc2.jpeg)

<figcaption>美国房价</figcaption>

因此，如图，美国房价也在大幅下滑。 

而且美联储当时不仅仅是降低利率这么简单，更是直接印钞去买房地产抵押贷款证券，换句话说，通过直接压低房贷利率的手段鼓励老百姓买房。这就是我们熟悉的“量化宽松”政策。 

![33.jpeg](https://i.loli.net/2018/10/13/5bc202f63b477.jpeg)

<figcaption>美国三十年房贷利率</figcaption>

如图为美国三十年房贷利率，我们的关注点是红色方框里的那一段时间。在那段时间里，美联储通过量化宽松政策，将房贷利率从6%压低到了3%。而我之所以要把这么多数据都截下来就是为了让大家看看它在历史上可是从未低于过5%。 

![34.jpeg](https://i.loli.net/2018/10/13/5bc202f63fa3c.jpeg)

如图为美联储的资产负债表，在法理上，美联储印的每一张钞票都是它的负债，因此我们可以看看为了拯救次贷危机美联储印了多少钞票！但是很明显，这样疯狂的印钞依然没能阻止危机的蔓延。 

而美国还算好的，日本就更惨了。 

![35.jpeg](https://i.loli.net/2018/10/13/5bc202f63e40d.jpeg)

如图为日本的利率，从1990年危机爆发后就几乎一直是0%。 

![36.jpeg](https://i.loli.net/2018/10/13/5bc202f63cdcf.jpeg)

日本的私人债务与GDP的比却一路下滑。 

![37.gif](https://i.loli.net/2018/10/13/5bc204387804b.gif)

所以房价就变成了这样，连跌近三十年。至于为什么美国经济最终恢复了增长而日本变成了这样是经济学界热议的话题，我们后面会提到一些，但它不是本文的主题。在这里我们只需要看清一个事实，就是债务是不能涨到天上去的，当债务到达极限时，债务人会清楚的知道自己已经无法负担更多债务了（或者为承担大量债务而感到担惊受怕），而债权人也会清晰的意识到其实债务人并没有能力偿还贷款。此时无论政府如何救市，如何印钞，如何出政策都无法阻止危机的爆发了。 

当然，即便如此，如果美国在次贷危机中没有做那些救市的行为，很可能世界就要再次经历“大萧条”了。因此，Ray将美国在次贷危机中的经历称为“优雅的去杠杆”（beautiful deleveraging）。 

现在我们就能看懂从2008年至今中国都经历了些什么了。让我们再看一下这张图： 

![38.jpeg](https://i.loli.net/2018/10/13/5bc204366a83d.jpeg)

一次大的由债务繁荣到债务危机的循环，中间会包含很多小循环，直到债务到达极限，经济开始不可避免的去杠杆，削减消费/投资，而又因为一个人的消费/投资就是另一个人的收入，因此收入大跌，迫使人们削减更多的消费/投资，形成恶性循环，引爆严重的经济危机，而任何政府的救市手段都很难产生良好的效果。 

中国在过去十年中，发生过两次小的循环。如图为中国利率变化：

![39.jpeg](https://i.loli.net/2018/10/13/5bc2043667c20.jpeg)

第一次是2008年遭遇次贷危机，没问题，政府“四万亿”救市，股市大涨，房地产大涨。 

第二次是2015年，虽然没有什么外部危机，但是由于债务风险越来越大，经济竞争力越来越弱，所以经济增速下滑明显。政府再次出手救市，如上图，连续降息降准（印钞）。 

![40.jpeg](https://i.loli.net/2018/10/13/5bc204366bd53.jpeg)

如图为中国房价的涨幅，其实我们看到2015年年初时房价已经开始下跌了（小循环开始向下），但是政府的救市又让它在2016年大涨。我认为中国2015年的那次救市非常像美国的2001年。“房价永远涨”的神话也是从那时开始，因为这不，政府确实救市了呀？如果政府不愿让房地产下跌，那么它怎么可能下跌呢？ 

事实上我们从美国和日本的例子已经看出，没有一个政府是不救市的。之前之所以可以成功，只是因为债务还没有到极限。如果债务加到极限的话，就救不了了。除非政府可以宣布，“以前的房贷不用还了，让我们贷款买新的房子吧？” 

（ \* 如果真这么干，恐怕是有史以来最generous的一次财富重分配，老百姓是高兴死了，但恐怕从此以后都不会有人在中国投资了。当然，是没有国家会这样干的。） 

那么我们怎么判断中国目前是否已经到了债务的极限呢？很可惜，很难判断。我们只能跟过往的历史做比较。 

前面我们提到过，中国的私人债务占GDP的比目前是全世界最高 —— 超过210%，超过了2007年美国的170%，仅次于1990年日本的220%。而后两者分别导致了大萧条以来最严重的两次经济危机。 

私人债务又包括企业债务和居民债务。 

![41.jpeg](https://i.loli.net/2018/10/13/5bc204378bd61.jpeg)

中国的企业债务高居世界第一。 

![42.jpeg](https://i.loli.net/2018/10/13/5bc204378a98a.jpeg)

不过居民债务不算特别高。但是问题在于，中国居民的收入占GDP的比也很低。所以如果我们算居民债务与可支配收入之间的比，根据海通证券首席经济学家姜超的计算，已经达到了90%，如下图， 

![43.jpeg](https://i.loli.net/2018/10/13/5bc2043834169.jpeg)

而美国的这一数据在2007年曾达到过120%，日本在1990年曾达到过100%。所以说如果居民债务还没有到极限的话，应该也快了。而且还要考虑到我国社会福利不如美日两国，所以居民在举债的时候顾虑会更多一点。 

当然，除了私人部门之外，还有政府部门，如下图， 

![44.jpeg](https://i.loli.net/2018/10/13/5bc20437c4da0.jpeg)

可以看出，中国的政府债务（中央+地方）还是很低的。需要注意的是，我们知道地方政府有很多融资平台，这些债务都被算在企业债务里了，而没有算在地方政府这里，所以地方政府债务有所低估，企业债务有所高估。 

不过政府债务并不是我们关注的对象，因为不管发生什么，危机时政府是一定会救市的，政府一定会增加债务。但是我们已经知道了，危机爆发的原因是私人债务达到了极限，所以不管政府怎么做，都很难让债务已经达到极限的私人部门重新开始积累债务。 

其中最明显的例子就是日本了。如上图我们发现日本政府部门的债务已是冠绝全球，就是在1990年之后不断救市（修桥，造路，给银行直接注资等等什么都尝试过了）的过程中所积累的。然而日本的房价，私人债务占GDP的比依然下跌了近三十年。 

![45.jpeg](https://i.loli.net/2018/10/13/5bc204378910f.jpeg)

如图，1990年后日本政府债务一飞冲天。 

因此综上所述，可以说目前中国的债务很可能已经非常接近于极限了。那么如果中国爆发危机，又会发生什么呢？ 

如果你看过《大空头影评 —— 次贷危机十周年》那篇文的话，可真是帮了我的大忙。 在那篇文中我写到，2004年年中，由于美国入侵伊拉克令国际油价暴涨，再加上长期的低利率政策导致的货币过剩，时任美联储主席的格林斯潘开始加息以应对通货膨胀，如图，从1%一路上调至5%。美国的房地产价格也开始在2006年回落。 

![46.jpeg](https://i.loli.net/2018/10/13/5bc204377f8e3.jpeg)

美国联邦基金利率 

![47.jpeg](https://i.loli.net/2018/10/13/5bc2050681822.jpeg)

美国通胀率，从2002年的1.1%一路涨到2005年的4.6%，导致美联储在同一时间内不断加息抑制通胀。

可见美国的房地产泡沫其实是被自己刺破的。是美国的高利率政策让当时的高房价变成了越来越难以负担的资产。可以想象，如果当时没有发生格林斯潘突然大幅提高利率的事件，美国的房地产泡沫也许还可以多坚持几年。虽然它终究是要破的。 

所以说中国虽然也有债务和房地产泡沫，却不一定会马上破，因为暂时还没有明显的导火索。不过有一个人认为导火索很快就要有了。 

![48.jpeg](https://i.loli.net/2018/10/13/5bc20507239a6.jpeg)

如图为美国的利率，在实行了长时间的零利率政策后，美国经济终于开始复苏，美联储也于2016年开始加息。2017和2018年两年更是每年加1%。 

![49.jpeg](https://i.loli.net/2018/10/13/5bc2050724f50.jpeg)

如图，美国十年期国债的收益率也刚刚再次超过3%。之前我们讨论资本外逃时曾经讨论过它是由于中国经济竞争力下降，进而导致资本向海外寻求能够带来更高风险收益比的资产。而美国国债在金融市场上被认为是零风险资产，当它的收益率越来越高时，就会不断吸引全世界的资本。 

过去发生过的那些由债务危机引发货币危机的案例，有很多都是由美联储不断加息作为导火索的。例如1994年爆发在拉美的“龙舌兰危机“，2000年的阿根廷危机等。 

有趣的是美国银行首席投资策略师Michael Hartnett在最近做了一张图告诉我们过去每一次美联储的加息周期都导致了世界上的某个地方爆发了经济危机。 

![50.jpeg](https://i.loli.net/2018/10/13/5bc205088906a.jpeg)

由于中国最近这些年也面临资本外逃的压力（外汇储备下降了一万亿），因此（我最喜欢的）海通证券首席宏观分析师姜超提出了“保汇率还是保房价”的论断。意思是在美联储不断加息之际，如果我们选择跟随加息抑制资本外逃，就会刺破房地产泡沫，因为已经债务累累的房地产市场无法承受太高的利率，就像美国2006年那样。 

姜超认为我们会选择跟随加息，因为汇率比房价要更重要一些，因此还写了例如《2016年或是中国房地产历史大顶》这样的文章。 

虽然我非常喜欢姜超（因为他很关心民生问题），也经常转发他的文章，不过在这个问题上我的看法完全不同。我的观点是“不会保汇率，但最终房价也是要大跌的，不论政府如何救市。” 

后面这一点大家想必现在已经很清楚了，如果债务已达极限的话，危机来了不论政府如何救市房价还是会跌。而为什么姜超会觉得我们应该保汇率呢？可能是害怕中国经历1997年泰国那样由货币大幅贬值而引发的通货膨胀式危机吧？不会的。 

Ray在书中说，当一国的债务达到极限，来到崩溃阶段的时候，会有两种后果。第一种就像日本和美国那样，房价大跌，经济衰退，但是汇率不会出问题；第二种则像泰国那样，房价大跌，经济衰退，并且汇率会崩盘（兑美元大幅贬值50%以上），进而导致进口价格上涨，引发严重的通货膨胀，国民财富大幅缩水。 

有趣的是，在过去的所有案例中，由于债务已经到达极限，所以不管发生什么，房价都是救不了的。只有一种情况下房价会涨，就是爆发“超级通胀危机”。在超级通胀危机之下，货币贬值到一文不值，那时候所有不是纸币的资产都会疯狂涨价。中国是不可能发生这种事的。 

那么以上两种后果到底因为什么而不同呢？Ray给出了很多条标准，而中国是一条都不符合的。我们先来说说最重要的一条 —— 外债。Ray认为，当一国发生经济危机时，由于政府无法靠印钱来还外债（可以印泰铢但是没法印美元），因此大量外债会让投资者感到非常恐慌，他们会去拼命的兑换美元，从而令本国货币贬值。本国货币贬值后，外债就变得更加还不起了，于是投资者更加恐慌，货币更快的贬值。因此，当债务危机爆发时，有大量外债的国家往往会遭遇货币大幅贬值的危机，而货币大幅贬值又会令进口价格陡升，引发严重的通货膨胀。因此，Ray把这类国家遭遇的债务危机称为“通胀式债务危机”（Inflationary）。 

在文章的最开始我们提到，当国内储蓄严重不足时，一国就只能通过借外债来满足投资的需求。例如巴西作为一个储蓄率只有15%的国家，外债当然也是很高的了。相比于中国的13%，巴西外债占GDP的比在2017年为32%（十几年来一直在30%以上）。让我们来看看过去这些年巴西都发生了些什么。

 如图为巴西Real兑美元的走势图。 

![51.jpeg](https://i.loli.net/2018/10/13/5bc20507c4782.jpeg)

2014年，由于政治危机加上办世界杯，奥运会的劳民伤财，巴西遭遇了经济衰退，Real兑美元一路下跌近50%。而今年一月份开始，由于选举的不确定性（民粹主义者可能上台），Real再次大幅下跌25%。

如图为巴西的通胀率。 

![52.jpeg](https://i.loli.net/2018/10/13/5bc20508543bb.jpeg)

在2014年曾陡升超过10%，今年也再次开始攀升。而且我们看看巴西这些年所经历的通胀就可以想象这个国家的经济被管理的多么糟糕。 

下图为阿根廷的外债规模。 

![53.jpeg](https://i.loli.net/2018/10/13/5bc2050852b2f.jpeg)

如图，可以发现阿根廷过去这几十年来外债规模一直不低，在2016年也高达35%。因此，当次贷危机到来时，阿根廷马上遭遇了恐慌。 

![54.jpeg](https://i.loli.net/2018/10/13/5bc2050855d3e.jpeg)

如图为美元兑阿根廷比索的汇率，可以发现，从次贷危机开始，阿根廷比索就一直在贬值（图示为美元在升值），累计已经超过了90%！ 

![55.jpeg](https://i.loli.net/2018/10/13/5bc20507bebdc.jpeg)

如图为阿根廷的通货膨胀率，一直没有低于过10%，近几年更是达到了40%。来自阿根廷的好友对我说这个国家目前已经乱到了没人敢携带好东西出门的地步。如果开一辆好车出门，那么非常有可能会被当街抢走。 

![56.jpeg](https://i.loli.net/2018/10/13/5bc2050851199.jpeg)

上图为Ray整理的所有发生过货币危机进而导致通货膨胀案例的一些数据，我圈出了三个最重要的，分别是外债占GDP的比 —— 平均值为46%，中国为13%；经常账户（贸易是顺差还是逆差）—— 平均值为负6%，中国为正1.75%；外汇储备占GDP的比 —— 平均值为10%，中国高达23%。 

更不用说中国目前还正在实行资本管制（一定程度上限制了资本外逃的速度，至少短时间内不会形成规模，引起恐慌）呢。所以说中国是不会发生货币危机的。

为什么中国不会遭遇货币危机（货币大幅贬值50%以上）呢？因为外债很少，外汇储备也很充足，因此当人民币贬值的时候是不会引起恐慌的。而中国是一个出口大国，人民币贬值会刺激国内经济发展，让中国经济的竞争力变得更强，中国资产的价格也会更便宜，这些条件都会吸引新的投资。因此当人民币贬值到一定程度的时候，即便是政府不管，也会有市场的力量来阻止它继续下跌。何况政府不可能不管。这就是在Ray的那些案例里，虽然每个国家在危机中都会经历货币贬值，但没有导致崩溃的原因。 

所以在理想状态下，政府是不可能保汇率的，让它跌一跌对中国有很大好处。Ray在书中也写到，在所有债务危机的案例中，最终政府都会选择印钞，（由政府）借钱大搞投资以及让货币贬值。那些行动越快的国家，恢复的也越快。 

因为如果在债务危机中政府还去提高利率的话，只会导致资产价格更快的下跌，债务收缩的更快，收入下降的更快，形成更加恶性的循环。因此不管政府最初是怎么想的，包括那些想保汇率的国家，最终都会放弃，因为提高利率紧缩经济对人民来说实在是太痛苦了。 

让我们来看一个犯下严重错误的国家，日本。 

![57.jpeg](https://i.loli.net/2018/10/13/5bc205ba3f522.jpeg)

如图，红色线是日本的股票指数，蓝色线为日本的利率。我们可以发现，在1990年一月日本“平成泡沫”破裂之后，日本人用了整整六年的时间（1990 ~ 1996）才把利率降到零。而美国爆发次贷危机时完成这一动作只用了不到一年，如下图： 

![58.jpeg](https://i.loli.net/2018/10/13/5bc205bc124a9.jpeg)

那么日本人是怎么想的呢？其实他们在保汇率呀。 

![59.jpeg](https://i.loli.net/2018/10/13/5bc205bc10c44.jpeg)

如图为日元的汇率，由于日元实在太便宜了所以我们只能倒着看 —— 以美元兑日元的方式。我们发现，从1985年日本签署《广场协议》，日元开始从1：250升值到1：150左右。1990年平成泡沫破裂，而日本人迟迟不愿意快速的降低利率，导致国内发生了disinflation —— 通胀率下滑的现象（如下图）。所以就在国内爆发严重危机的时候，日元竟然是升值的！如上图，从1990年的1： 150升值到了1：100以下。 

![60.jpeg](https://i.loli.net/2018/10/13/5bc205bc13a0e.jpeg)

如上图为日本的通胀率，从1990年的4%下滑到了1996年的负值。在经济中，这种类型的通胀率下滑（不是那种从百分之十几往下滑而是从低点开始）比通胀率上升要可怕的多，因为通胀下滑意味着商品的售价下降，进而意味着企业收入减少，而企业收入减少则意味着企业要削减支出 —— 裁员，进而导致居民的收入减少，更买不起商品了，商品的售价更加下滑，进而变成恶性循环，让经济陷入严重的衰退。日本毫无疑问正是在那些年经历了这一惨痛的教训。 

奇怪，难道日本没有人懂经济学吗？为什么会制定出这样的政策？在一本可能是日本最著名的经济学著作，辜朝明的《大衰退》中，作者写到，“日本当时是世界上最大的出口国之一，我们没有那么容易去让货币贬值（印钞救市），这样会激起贸易伙伴的强烈不满。” 

考虑到当时的日本刚刚因为顶受不住来自美国贸易战的压力在1985年同美国签署了《广场协议》（内容是让日元以及德国马克等货币兑美元升值），这样的顾虑可能也不无道理。 

于是我们又可以说回中国了。今天的中国是全球第一大贸易国，对世界的影响远远比当年的日本要大。不信？如下图： 

![61.jpeg](https://i.loli.net/2018/10/13/5bc205bc4b273.jpeg)

如图为美国S&P 500股票指数，2015年8月11日，中国政府宣布“汇改”，准备让人民币贬值。结果美国 S&P 500指数在几天之内就大跌超过10%，把美国人吓坏了。原因我们已经多次提到，人民币贬值会刺激中国经济，但会让美国货变的更贵，影响美国就业。 

因此，我们现在似乎面临着与当时的日本非常相似的处境，在债务快到极限时又遭遇了贸易战。所以这场贸易战真的给已经非常脆弱的全球经济蒙上了一层浓厚的阴影。未来会发生什么便真的很难预测了。不过好消息是，我会一直和大家在一起的。

本文来自 Murph丶璇微博<https://weibo.com/ttarticle/p/show?id=2309404288058957667162>

\*文章为作者独立观点，不代表虎嗅网立场
