---

layout: post

title: 从“不许生”到“催着生”，近八百万计生人员如何转型

categories: Archive

date: 2018-09-12

tags: 计划生育

image_feature: "https://i.loli.net/2018/09/12/5b991c9be8518.jpg"

description: 政策掉头的同时，全国近八百万计生人员也开始艰难转型，从不许生育、变成求人生育。

---

原文来自「刻真」：~~[从“不许生”到“催着生”，近八百万计生人员如何转型](http://wechatscope.jmsc.hku.hk:8000/html?fn=gh_ab80e46fbcc5_2018-09-12_2247484482_alm6358kuH.y.tar.gz)~~

作者丨刻真

---

本文原文系已发表报道。经作者补写和重新编辑，于8月24日发表于端传媒。

原文链接：<https://theinitium.com/article/20180824-mainland-birth-control-staff/>

![01.jpg](https://i.loli.net/2018/09/12/5b991c9be8518.jpg)

<figcaption>2016年1月1日，中国开始实行全面二孩政策。政策掉头的同时，全国近八百万计生人员也开始艰难转型，从不许生育、变成求人生育。摄：Greg Baker/AFP/Getty Images</figcaption>

中国西北某县王牌计划生育（下称“计生”）干部张宝强的人生，在2016年1月1日突然调转了方向。那一天起，中国开始实行全面二孩政策。

“2016年以前每天都过得很充实，天天出去抓超生。现在主动服务人家生二胎，以前这（些人）都是被管理的对象。”张宝强时常想起往昔辉煌：在他的领导下，县里曾凭“结扎最多，超生最少”，连续五年排名全乡第一，出去开会倍儿有面子。如今，在最新的“催生”服务排行榜上，张宝强的团队一落千丈，心里空落落的。

进入2018年以来，中国各省纷纷出台各类鼓励生育二孩的政策。《人民日报》海外版发表评论称“生娃是家事也是国事”，呼吁落实全面二孩政策。在生育率连创新低的背景下，放开生育的呼声此起彼伏。

政策掉头的同时，全国近八百万计生人员也开始艰难转型：从“追着人做结扎”变成“追着人做孕检”，从强势不许生、变成“低三下四”求人家生。曾经刷满农村墙面的“打出来！堕出来！流出来！就是不能生下来！”变成了“放开二孩政策好，生对儿女好养老”。这些变化令计生人员无所适从：不是说计划生育是基本国策，必须长期坚持、丝毫不能动摇吗？不是说资源紧缺、人口是经济社会发展的沉重压力吗？三十年来，他们为祖国发展想方设法限制生育，如今又是怎么个说法？他们今后该怎么办？

![02.jpg](https://i.loli.net/2018/09/12/5b991c9b62bbb.jpg)

<figcaption>在全面二孩政策首次实施的2016年，全国出生人口1786万人。到2017年，全年出生人口下降到1723万人。出生率、自然增长率均开始下滑。摄：STR/AFP/Getty Images</figcaption>

## 贴钱请人做孕检，依然完不成指标

张宝强现在的考核指标是：每年催生200个二胎，完成100个免费孕前优生体检。

2015年底，张宝强所在的县镇计划生育办公室在名称前加了“卫生”二字，和妇幼保健部门正式合并。张宝强的主要工作变成宣传二胎、优生孕检和产后母子保健。

为了鼓励生育，县里申请经费买了一台四维彩超仪和唐氏筛查仪。张宝强拿着一份花名册，上面记录着他辖内符合条件的育龄妇女信息和联系方式，重点宣传对象是新婚和第一胎产后两个月的妇女。张宝强恨不得天天打电话求着人家，承诺优生、唐筛、B超检查全免费。爽约常有发生，说好了又不来，免不了又要打上几个电话。

过去，张宝强出门追结扎从不花钱，去哪儿单位都报销。 现在却情愿自掏腰包。有的妇女在省城打工，嫌远不愿回来做体检。为了完成指标，张宝强自费为夫妇俩提供往返车费和误工费，动员一对夫妇，张宝强要自己贴上500元，如果动员上十户，他一个月就白干了。

张宝强他们还开通了微信公众号，成立了微信群，经常在群里宣传：“好消息！计划怀孕夫妇，县保健所提供免费体检。请相互转达。”群聊和私聊都服务到家，有信必回。

入户宣传一直是张宝强的强项。 过去是四五个人坐车去，先把计生对象一家人震慑住。现在则是自己一人登门拜访，带着印有二孩政策的宣传小书包，挨家挨户发送。

或许是担心人们不太适应突然鼓励生育，宣传小册子还特地对人口和资源的关系做出了解释：“据有关部门测算，我国的能源、粮食等供给都在可承受范围之内，实施全面二孩政策不会影响国家既定资源环境战略目标的实现。”此外还预测了全面二孩政策对国家经济发展的正面影响：“直接拉动对妇幼健康等领域消费”、“有利于稳定经济增长”、“盘活存量、优化配置”。

但无论张宝强怎样努力，每年100个孕检指标还是难以完成。政策放开了，可每年自愿生二胎的，只有不到60个。剩下的40个指标，给谁检查？

相比过去指标明确规定“计生政策符合率95%以上”，全面二孩的评价标准显得更加微妙。张宝强揣测，“什么叫全面？全面的意思就是百分之百的生二孩，符合条件的都应该生。”但他也明白，“百分之百生二孩，必然百分之百做不到。”

据国家统计局数据，在全面二孩政策首次实施的2016年，全国出生人口1786万人。到2017年，全年出生人口下降到1723万人。出生率、自然增长率均开始下滑。据经济学家梁建章和统计学家黄文政预测，到2050年前后，中国出生人口可能萎缩到每年约800万人，只占世界全年出生人口的5%。

![03.jpg](https://i.loli.net/2018/09/12/5b991c9bafa62.jpg)

<figcaption>张宝强认为，低生育意愿，主要和高昂的教育、住房成本有关。所谓“房价是最好的避孕药”。图为2015年重庆一个二孩购房优惠巨幅广告。摄：Imagine China</figcaption>

张宝强认为，低生育意愿，主要和高昂的教育、住房成本有关。所谓“房价是最好的避孕药”，张宝强所在的地方还比较落后，但城里的房价已经涨到四五千一平米，和他的月收入不相上下。与此同时，在孩子教育方面，谁也不愿意落后，随便上几个兴趣班，每个月也要几千块。

二孩政策实施后，县里按照新标准重新排名，张宝强团队从此告别荣誉。从未落后过的张宝强，心理难受得很。

## 结扎，讲究“一个都不留”

上世纪九十年代，张宝强从医学院专科毕业，在医生和计生干部间选择了后者，到乡镇计生办公室当了一名宣传员。

计生干部的招聘门槛很高，没有大学生，就从医院借调技术人员。张宝强觉得能参加这个工作很有成就感：“中国人口太多了，计划生育是基本国策，我要为建设国家出一份力。”

一起毕业的同学中，有三分之一干了计生，有的在乡镇搞计生宣传，有的在计生医务室做结扎、上环（指在子宫内放置节育器）和引产手术。计生工作在当时是一份美差，待遇好、地位高，可见国家对计划生育的重视。单位领导说了：“每年都要建计生服务站，要创星级乡镇站”。

张宝强所在的乡镇计生办公室，辐射周围一万多人。过去，他的主要任务是宣传“少生快富”，重点盯防蠢蠢欲动的“纯女户”（即家庭所生均为女孩），带妇女去计生站做结扎。

按规定，夫妻双方都是农业户口，可以生两个。一方为非农业户口，只能生一个。当时的口号是“一环二扎”，意即：生完一个必须戴环，生完两个必须结扎。农村户生一胎和二胎间隔必须满4年，否则“超间二胎”也算超生，影响计生考核指标。“超间二胎”罚款起价500元，距离4年标准每短一个月加100元。

张宝强治下的结扎，讲究“一个都不留”——对生完两胎的农村妇女实行强制结扎。他一直将乡里的计生政策符合率保持在95%以上。

对于已经生了两个女孩，就盼着一个男孩的高危户，他们好说歹说，连哄带吓，逼着做结扎。这工作量可不小，每年全乡有二十多“纯女户”，动员一户至少要二十多次，一刻不能放松，“一不留神他们就怀孕了”。

在华南某县，计生服务站的何秀虹几乎是计生政策的同龄人，从上世纪八十年代初一直干到现在，专做计生宣传、结扎和引产工作。

和张宝强一样，何秀虹的计生服务对象主要是女性。因为男的结扎后，往往心理压力很大，回到乡村，会被嘲笑，性功能随之出现障碍，于是就转为给女性做输卵管结扎。

湖北计生干部段玲，在计生的荣誉上也不逊色。上世纪九十年代，她从卫生学校毕业后，进入计生服务站工作。九十年代末是计生管控高峰期，段玲连续几年每年流产两三百例。2002年左右，发生了一些重大恶性事故，连续出现大月份产妇引产死亡、上访增多。引产手术随后在计生医务室被叫停，只能送去三甲医院做。

段玲负责的地区，做引产的很多。因为当地被群山包围，有的村落本身就在高山上，超生孕妇不易被发现。二者，即便发现了，周围也有着绝佳的躲藏条件。这样一来，找到后往往要施行引产手术。 不论怀孕几个月，不论怎么央求，“计划生育是基本国策，是一道红线，是一票否决”，孩子绝对不能留。在深山老林发现目标，靠的是告密者。把孩子解决掉，告密者会收到一笔奖励金。

孕妇被送去手术室，抢人的两队人马已在门卫对峙。家属知道孩子引下来很可能是活的，一旦听到孩子的哭声，马上冲进去把孩子抢走。另一队人马——计生部门安排的公安和警察也等在门外，再次从家属手中把孩子抢回去，“弄死”。

![04.jpg](https://i.loli.net/2018/09/12/5b991c9b1ede5.jpg)

<figcaption>计生干部的齐心努力下，中国的人口增速得到了有效控制，每年新生儿数量从1990年的2800万，下降到1999年的1500万。摄：Paolo Koch /Gamma-Rapho via Getty Images</figcaption>

“跨省追捕”也是张宝强的家常便饭。因为有专项经费抓超生人员，张宝强一旦收到消息，便组织村干部等一行十余人，迅速出发。若在临近省份，就包车前往；若远，就搭火车，赶到超生家庭打工的地方，根据线人提供的线索，连夜“抓捕”。超生户如果配合，就带去附近的医务室，该流产流产、该结扎结扎。但后者通常都极不配合，那么就不客气了，一行人把目标强制带回老家，动手术。

在张宝强、段玲这样的计生干部的齐心努力下，中国的人口增速得到了有效控制，每年新生儿数量从1990年的2800万，下降到1999年的1500万。

## 不敢一个人下乡工作

张宝强心里也犯过嘀咕：“干这个和心里有点违背，结扎不人道，学医的是知道的。但是每年都有结扎任务、指标。”

按照规定，农村户口家庭生完第二个小孩后，就要结扎。有几个妇女，结扎刚做完，小孩夭折了。

张宝强所在的乡镇非常落后，村里还流行着一种看法：谁家没生出儿子就是报应，是因为没有积德行善。不生儿子的妇女会被人辱骂，“断后”是极大的不孝和耻辱。有时压力太大，受责骂的妇女会跑来找张宝强哭诉：“你不给我们结扎，我们就不受这些气。”

结扎并发症的高发也令学医出身的张宝强感到揪心。村里老有妇女说做了结扎后肚子疼，影响干活。那时张宝强还没有经验，也没做腹腔检查。他曾经怀疑大量妇女腹痛可能是结扎手术造成的，直到有一天，他听一个同学说，计生做的这种输卵管结扎手术，发生盆腔粘连情况的特别多，但“你在做这个工作，也不能说”。

虽然已经离开了计生工作，但段玲始终不敢直面过去：“良心一直受着很大的煎熬”。

她曾经遇到过已经足月的产妇，快要生的时候，不幸被计生人员逮住了，强制送来做引产手术。她引产下来的孩子很有可能是活的，但是领导说，“你不能让这个孩子生下来是活的。否则会影响我们的计划生育率，会影响整个乡镇的工作考核！”

领导会千方百计给医生施压，老医生们被迫想到很多办法，比如在小婴儿头伸出来之前赶紧在头上打一针，或者生下来要哭的时候把嘴捂住，丢进水里……段玲一开始根本干不来这些事情，老医生见她犯怵，就把这些活都揽了过去。

曾经，段玲他们下乡做任何计生服务都要收钱。九十年代，给育龄妇女做检查，一次收费2块。此外，人流、引产等项目，都要村民自己出钱。回想起那段岁月，段玲有点不好意思，“试条检查，一次可以收10块钱，基本上我们想怎么收就怎么收。”

收钱的时候，老百姓骂骂咧咧。给的时候，就直接把钱扔在地上，还在一旁继续骂。

![05.jpg](https://i.loli.net/2018/09/12/5b991c9b0c73c.jpg)

<figcaption>计生工作曾是一份美差，待遇好、地位高，可见国家对计划生育的重视。摄：Imagine China</figcaption>

面对迟迟不缴纳社会抚养费的，领导也有办法。有一次，领导带着段玲一行人下乡，直接去超生户家里拿东西，还拿了不少粮食。还有一次，他们拿着锄头去一个生活困难的超生户家庭，爬上房子，把房顶给扒了。

计生干部和群众之间关系恶劣，是长期积下的怨。何秀虹和同事们一下乡，村民打老远看见就跑，边跑边骂：“做绝种的工作！”有一次下乡正赶上人家办酒席。看见他们来了，酒席的主人宾客全跑了，边跑边发出警报：“阉鸡队来了！”

坊间甚至流传着一种说法：“千万不要去计生办做人流，他们会偷偷给你放一种药，你就再也生不出来了。”

无论是段玲还是何秀虹，都不敢一个人下乡。做其他工作的，下乡还能有口粥喝，计生人员下乡，连口水都没有。虽然有车，但他们下乡还是经常要走路。因为常有村民把他们的车拦下，不让通行。他们的车掉进坑里，也没有人来帮忙，还向他们扔石头。在其他地区，还出现过计生干部被村民拿刀追砍、泼粪等事件。

张宝强换位思考，能理解为什么自己不招人待见：“人家想生个男娃娃你非得让结扎；人家刚怀上你逼着引产。”

他们也听说过1991年山东聊城发起的“百日无孩”运动。为降低人口出生率，聊城冠县和莘县要求自5月1日至8月10日间，一个孩子都不许生，当地官员强令计生人员、公安、武警抓人，确保所有怀孕妇女从5月1日起强制堕胎。诸如“上吊给绳，喝药给瓶”、“宁肯断子绝孙，也要让党放心”、“宁肯流出来，不许生出来”的标语遍布大街小巷。

虽然不堪回首，但一想到计生是国策，就都觉得自己不受人待见、吃点苦不算什么，关键是为国家的建设出了一份力，要知道，“中国的一切问题都是因为人多”。

“计划生育同龄人”何秀虹不会忘记，1980年盛行的“人口控制论”宣称：若不实行计划生育，中国人口到2075年将超过40亿。

无论当时和现在，都有学者不认同这种推测。《大国空巢》作者易富贤指出，即使不实行计划生育，中国的生育率也会随着社会经济的发展而下降。例如从未干预生育的印度，生育率从1980年的4.8自发下降到2017年的2.18。不过，这样的判断至今都“不合时宜”，被国内专家众口驳斥。

“计生工作做不好，所有的升迁、福利、住房都没有指望了。”虽然有时受到良心的谴责，但段玲很快又想开了：“计生是第一考核指标，一票否决一切。看到再可怜的情况，在计生面前，也不能通融。”

段玲所在的湖北省曾经实行着极度严苛的计生政策。“一票否决”指的是，无论是谁，凡是违反计生条例的，用人单位一律直接开除。多年后，实行“一票否决”的湖北省在最短时间调转了船头，咸宁市率先出台了惠及二胎的政策：产假延长至6个月、允许孕期和幼儿小于3岁的女职工申请弹性工作时间和地点，在入学、医疗、住房、职称评定、薪酬分配等方面对生育二胎的家庭“给予倾斜”。

政策转变，总是比人的转变轻易。

## 被“卸磨杀驴”的计生干部

张宝强现在特别想回到医院去，却又苦于长期不接触临床，早把医学技术遗忘了。参加同学聚会，他发现当时选择当医生的同学，几乎都评上了高级职称。再看干计生的，最高评到中级，月收入差距有1000元。

部门合并后，张宝强除了宣传二胎，还要制定扶贫计划、指导养殖、验收田产等，跟他的专业技术一点都不沾边。

相比之下，纯粹干宣传出身的计生干部，转型起来可能更容易。反正光凭一张嘴，让说什么说什么。过去宣传“只生一个好，政府来养老”，现在宣传“二胎家庭才幸福”。

张宝强估摸着，“用不了多长时间，计生工作就不存在了。”他从名称的改革上看到了端倪：从最早的“国家计划生育委员会”，到“卫生和计划生育委员会”，再到今天的“卫生健康委员会”，“计划生育”四个字不见了。在职能上，与计生相关的司局也被撤销了。

看到2016年湖北公安县三十多个计生干部上访的新闻，段玲越发庆幸自己转行转得早。她一直关注计生方面的新闻动态和人口形势，判断放开二胎是必然趋势。与搞宣传的张宝强不同，段玲自认没有荒废医学技术。2014年，她努力调到了社区医院，从此告别计生生涯。

湖北公安县的计生干部自2006年乡镇机构改革后，被取消了事业编制。但当时社会抚养费（即“超生罚款”，征收对象为超生的城乡居民和农民）还可以按30%返还乡镇，用于计生工作，他们的待遇没有受到太大影响。

中央党校国际战略研究所的数据显示，中国的社会抚养费年征收规模在200到300亿之间。有的小孩已经上了大学，父母还在被追缴社会抚养费。在一些地区，没有按时交社会抚养费的，还会被列入征信黑名单。

![06.jpg](https://i.loli.net/2018/09/12/5b991c9acdd00.jpg)

<figcaption>数据显示，中国的社会抚养费年征收规模在200到300亿之间，巨大的经费，使用情况一直成谜。摄：China Photos/Getty Images</figcaption>

如此巨大的经费，使用情况一直成谜。其中可以明确的一个去向是，返还给基层政府和计生部门，或列为计生人员奖励。2015年后，社会抚养费返还机制取消，计生干部从中“一分钱也拿不到了”。

上访的计生干部称自己“成了弃子和路人”，被“卸磨杀驴”。他们坐在县卫计局门前，拉起横幅“落实中央政策，保我应有待遇”、“稳定计生队伍，还我应有身份”。计生站和卫生局合并后，往往是原卫生部门的人当一把手，原计生部门的人则感到“处于劣势，没有话语权，不受重视”。

据《第四次全国人口和计划生育系统人事统计公报》，截至2005年底，全国计生系统共有在编人员50万名。另据原国家计生委2009年公布的文件，除在编人员之外，全国还有约120万名村级管理员和600万名村民小组长做计生工作。这么多人，如何安置？

实地走访计生干部不难得知，从计生到催生，虽然国家政策变得快，但计生干部的观念早已根深蒂固。“人口对经济社会发展的沉重压力没有改变”、“人口与资源环境的紧张关系没有改变”、“计划生育基本国策必须长期坚持丝毫不能动摇”等口径早已深入很多人的骨髓。比如何秀虹，她并不知道专家们讨论的什么人口形势，政策的转变令她“搞不懂了”。

易富贤也质疑这种转型安排。他指出，发展人口并非靠单一部门能够解决。再者，根据国际经验，在日本、德国、韩国等设有专门负责人口政策部门的国家，生育率也不高。易富贤建议将计生人员转岗分流，可考虑为失独家庭、老无所养者提供服务。

陕西省已经做了一些尝试，从2014年11月起，陕西商洛共69名乡镇计生干部，通过专业培训，转型成为促进婴幼儿早期发展的“养育师”。这是一项婴幼儿早期发展干预试验，名为“养育未来”，由中国国家卫计委和农村教育行动计划（REAP）共同推动，项目的牵头人之一，是一直关注中国农村发展的斯坦福大学发展经济学教授罗斯高（Scott Rozelle）。

“养育师”每周要上门完成为农村婴幼儿定制的游戏和活动。罗斯高希望借此项目让贫困农村的婴幼儿也能获得科学且充分的早教，缩短农村和城市孩子在阅读、理解能力方面的巨大差距。

“想要维持同样的经济发展水平，下一代的中国人必须更聪明。”前卫计委培训交流中心主任蔡建华对媒体表示。

兰州大学哲学社会学院副教授张庆宁的团队则在探索，计生干部如何发挥“有人的地方，就有计划生育”这一优势，转做艾滋病预防和性教育工作。

如今，段玲早已转型，何秀虹马上退休，但还有大量的张宝强们，人到中年，正逢事业的成熟期。突然调头的他们，在曾经笃信的道路上顿感迷茫。但张宝强愿意一如既往地支持国家政策：“过去搞计划生育为国家出力。现在国家老龄化了，我们搞二胎催生，为国家继续出力。”

（应受访者要求，张宝强、何秀虹、段玲为化名）

![07.jpg](https://i.loli.net/2018/09/12/5b991c9ba7955.jpg)

<figcaption>刻真，赵晗的原创文章公号<br />
<br />
喜欢探讨信仰、教育、跨文化、公民社会
<br />
<br />
电邮：tozihona@gmail.com
<br />
<br />
这是“刻真”第84篇文章
<br />
<br />
</figcaption>

![08.jpg](https://i.loli.net/2018/09/12/5b991c9a87f0a.jpg)

<figcaption>打赏随意：<br />
Made in Faith
</figcaption>
