---
layout: post
title: 风雨碧桂园
date: 2018-08-13
categories: Archive
tags: 碧桂园
image_feature: "https://i.loli.net/2018/08/14/5b72f009aee9e.jpg"
description: 碧桂园最近不大顺。其高运转、高负债拿地、高份额成就共享、高成本营销推广等模式，被舆论重新检视。一向紧跟政经形势的碧桂园，将如何度过这道坎？
---

文章来自「凤凰周刊 凤凰WEEKLY」

记者\|曹蓓 编辑\|王毕强

---

碧桂园上市那年，杨国强在北大演讲时，曾经透露过他“22条商规秘籍”，其中一条是：

**可以利用记者但不要相信记者，可以给记者一些钱或礼品，不能和记者靠太近**。

11年后，碧桂园正被这样的媒体观困扰。

2018年6月24日，上海碧桂园项目售楼处6层屋面混凝土浇筑过程中出现模架坍塌，确认1人死亡、9人受伤。1个月后，安徽六安碧桂园建筑工地一处围墙和活动板房坍塌。根据上海安监部门发布的事故报告，盲目赶工催进度，压缩工期是事故的间接原因。

在碧桂园的高速发展过程中，总被曝出各种问题，质疑声也从未停止，但如此密集的负面新闻，终于让舆论集中爆发。

于是，碧桂园举行了一场走进碧桂园全国媒体见面会，真的送给了记者厚厚的信封和包装精美的礼品，也没有相信记者，并对记者设防。

高管鞠躬道歉，杨国强也罕见现身并坦露心迹“感觉自己是天底下最笨的人，做了很多的事情，钱不是自己的”，但舆论的风向并没有像碧桂园预期的那样发展，外界并不买账，认为毫无诚意。钱和礼品被曝光，不少媒体退回，留下一片冷嘲热讽。

2013年进军千亿级房企，2016年上半年冲上全国销售排行榜第三位，2017年跃居第一，并在2018年上半年以4125亿元的销售额拉大优势，超出第二名一千多亿元。

有人称碧桂园为“黑马传奇”，单纯以其发展的速度来看，这一评价在地产界并不夸张，尤其是当“奇迹”的制造者是一位出身贫苦且至今仍有明显标签的人物。

![01.jpg](https://i.loli.net/2018/08/14/5b72f00993142.jpg)

## 杨国强，一个贫民的跨越

永远都穿大一号的西装，是外界提起杨国强，这位碧桂园的创始人首先跳出来的印象。

不止在一个场合，他毫不避讳地讲述自己的早年经历，“一无所有的农民出身”、“18岁前从没穿过新衣服、没穿过鞋和袜子”，“从泥水匠开始一直干到包工头”。

已经公开的消息称，至今他仍然保持着农民的生活习惯，不喜欢穿西装，开会喜欢脱鞋和袜子，盘腿而坐。

**与那时相比，现在的杨国强，跨越了不止一个阶层，到达了金字塔的上层**。

2007年碧桂园上市，杨国强和碧桂园的发展历程被多家媒体还原。

1954年出生，广东顺德北滘镇人；

1978年在大哥杨国华的帮助下，杨国强进入北滘公社房管所；

1989年，成为北滘建筑工程公司的法定代表人兼经理，在中国房地产的第一个黄金时代赚下第一桶金；

1993年，北滘建筑工程公司改制，杨国强和同乡以3395万元收购了公司，完成私有化运作；

随后低价买下在顺德碧江及桂山交界处大片土地兴建4000套别墅，碧桂园从这里开始。

开局不利，楼市调整期的4000套碧桂园别墅只卖出3户。后借助1990年代地产营销界“北邓南王”中的王志纲，制造学区房的概念，成立碧桂园学校，并成为北京名校景山学校的广东分校，打出“邓小平孙子都入读景山”的招牌，碧桂园就此扬帆出发，这样的手法，也成为中国营销学经典案例。

很多时候，杨国强喜欢静静坐在售楼处的角落，观察新楼盘的销售情况。

不喜欢抛头露面，不喜欢被宣传、被关注，而是躲在一个不起眼的地方，低调、再低调，是杨国强的一贯作风。

内地媒体曾经报道过这样的细节，2002年，杨国强第一次进入“胡润百富榜”，“这让他很紧张。”2003年，“胡润百富榜”发布前夕，胡润团队将调研来的信息发给碧桂园确认，结果收到一份传真，落款是广东佛山市顺德区公安局，还加盖了公章。

传真写道：“兹证明杨国强与杨贰珠、杨志成、杨永潮、杨文杰非兄弟关系、非父子关系。”杨国强的律师找上门来，认为杨国强的财富没有胡润团队调研的那么多。

“那年的‘胡润百富榜’上没有杨国强的名字。胡润解释称，主要原因是碧桂园其他股东的身份难辨。比如，杨贰珠是代杨国强持股，但碧桂园方面一定要将二人‘划清界限’。”报道引用了胡润的解释。

对“出头鸟”的万般抵触，可以解释2007年碧桂园上市招股书中，杨国强公布“将股权转让给女儿杨惠妍，是意欲训练其为家族持有的碧桂园权益的继承人”。

碧桂园上市时，中外媒体甚至找不到一张这位代替杨国强成为当年内地首富的风云人物的照片。杨国强用同样的方式保护女儿，据传，他曾郑重地告诫下属，如果有人把他女儿的个人信息和照片公布出去，“后果自负”。

但不管碧桂园大股东的名字换成谁，碧桂园背后的掌舵人都是杨国强。“大到楼盘的设计，小到墙壁上的口号，他都要过问。”有陆媒称。

与对外的低调而谦卑不同，事业布局上，杨国强完全是另一个风格。

“**标准化方面学麦当劳，薄利多销方面学习沃尔玛**。”这是杨国强对碧桂园的定位，就是用做快消的方式去做房地产。

有人总结他口中的碧桂园商业模式：专注三四线城市，低成本拿地，快速开发，低价开盘，拿地的同时，设计基本完成，三个月内必须开工，四五个月可回收资金。

像工厂流水线一样建楼，这就是所谓的“高运转”，为此，不惜采取各种在专业的人看来非常冒险的方法，高负债拿地、高份额成就共享、高成本营销推广……

一切指令，都要求迅速铺开和高质量实施。

从碧桂园的发展模式和道路，可以隐约看到不同领域的不同人物的影子。曾经有业内人士分析，杨国强没有高学历，但酷爱读书，最终形成了一套复杂的思想体系，“**知识结构驳杂，充满实用性。**”

那些拿来主义中，有毛泽东的农村包围城市、调动农民积极性，沃尔玛创始人山姆·沃尔顿的薄利多销，有雷军的规模论，有马明哲的人才论……

在业内看来是高风险的“野路子”，但结果是，正是凭借这样的模式，碧桂园得以冲上“头部”。

也正是这种模式，让碧桂园这列高速快车一路在诸多非议中前行。

## 高周转、高杠杆、共享机制 不愿公开的秘密

2018年3月1日晚间，《我在碧桂园的1000天》一书作者，原碧桂园首席财务官吴建斌发布声明称，“**本书为文学创作作品，而非全部纪实，其中有我的情节虚构、个人思考和情景设想，请勿以本书作为碧桂园过往的发展事实反映。**”

有关此书，被外界传得沸沸扬扬。一张标价以每本10万元收购该书的淘宝图片流传在各个社交媒体。还有消息称，杨国强亲自找到出版社，赶在该书上架前全部买断，甚至追到作者的新公司，要求作者收回几本已经送给朋友的样书。

据分析，**如此大动干戈的原因，是因为这本书详细披露了碧桂园的独特商业模式，还有杨国强、其女儿杨惠妍及杨氏家族不为人知的经营细节等，涉及了太多的“商业秘密”**。

一家民营背景的房企让人咋舌的崛起速度，令外界不得不探究其背后的原因，碧桂园模式和方法，陆续在公众面前浮现。

例如项目实施“4568”法：4个月卖楼，5个月回款，6个月现金流为正，8个月再投资。开盘销售实施“789”法：新入市项目，开盘一周内去化不低于70%；买地后，首期开工须销售80%的存货；新入市项目，开盘当月去化率要达到90%。

一份网传的碧桂园项目负责人高周转的奖惩制度写到：

> 如（土地）摘牌即开工，奖20万元，每推迟1天，奖金递减1万元，20天开工，奖金减为0元，第21天开工则罚款1万元，逐天递增，40天开工，罚款20万元，如果第41天开工，撤职。

对碧桂园的设计人员，碧桂园要求所有三四五线城市的项目，设计院接到设计要求后，当天内出设计图（通宵）。

再例如，碧桂园大量收购三四线城市的低价土地，且为了拿地不惜高负债。

![02.jpg](https://i.loli.net/2018/08/14/5b72f009aee9e.jpg)

数据显示，2017年，碧桂园的总负债为9331亿元，比2016年增长了近一倍，公司负债率也达到88.89%。其首席财务官在媒体见面中也对此做出回应，称9331亿元是财务资产负债表总负债的余额，有息负债仅有2148亿元。

但按照《我在碧桂园的1000天》吴建斌的说法，2014年4月1日进入碧桂园后，以稳健著称的他一个重要任务就是降低企业的负债率，但并没有得到杨国强的认同。

公众把碧桂园多地频出的施工问题和房屋质量问题归咎于“高周转”，而高杠杆的压力又加剧这种高周转的要求，也被拉到舆论中心。

**但事实上，高周转、高杠杆并不是碧桂园的独创**。

十年前，**万科提出“5986”高周转模式**：拿地5个月动工、9个月销售、第一个月售出八成、产品必须六成是住宅。

按照一般房地产开发的节奏，在获取项目后，会先进行产品定位和策划，再委托设计单位做方案和施工图，期间将会展开多次讨论与评审，如此一来，从拿地到开工，短则8个月，长则一年。

但房地产是高资金依赖行业，高杠杆是常态。而销售回款作为房地产开发资金的主要来源，是影响房地产企业发展的核心因素之一。

兰德咨询总裁宋延庆曾在接受媒体采访时称，**开发成本越来越高，使得“快”成为房企的制胜法宝**。

“假设项目获取费用是10亿元，按照11%行业平均负债利率计算，每天的资金成本就是30万元，150天就是4500万元。在讨论优化、研发创新或追求完美的过程中，相当于5000万元的利润就悄然无息地蒸发了。”

业内曾分析，拿地、开发、销售等环节组合成一个高关联度的资金链条。开发商负债经营，现金流是关键，只有高周转、提高现金使用效率，才能降低成本、避免现金流风险，并且迅速做大规模。有媒体评价，当年的万科，正是利用高周转成为行业龙头，是行业内少有的“现金流大户”。

当然，在尝到甜头的同时，万科也咽下苦果，在全国范围内遭遇了密集的“质量门”事件，比如，装修中使用纸板材料等等。

高周转带来的问题显而易见：**对周转速度的极致追求，容易使正常工期被压缩，质量、安全、环保等基本要求很难兼顾，导致涉及证照不全、安全隐患、环评未达标、超时施工、噪声扰民等问题出现**。

但万科的成效，让多家房企跟进，恒大、万达等知名房企纷纷推出自己的高周转策略，以至于2013年，由于众多房企采用的高周转，成为房地产行业的年度关键词。

《我在碧桂园的1000天》中，吴建斌另一个质疑的问题，就是被外界广泛讨论“成就共享机制”，后又升级为“同心共享”，员工们拼死加班，想尽一切办法获得超额利润分红。这在2014年的万科，也能寻到踪影，当年万科宣布推行事业合伙人制度，原则上要求项目所在一线公司管理层和该项目管理人员必须跟投。

**但在吴建斌看来，碧桂园实施的这一机制的问题明显，共富贵易，共患难难**。

王阳（化名）就是希望“分享富贵，远离患难”的碧桂园的普通一员。就像他们都听到的故事一样“六个区域总，年终奖突破一个亿”，这张“大饼”支撑他们前进。

他两年前加入碧桂园的某区域团队，被派到下面四线城市的项目做行政。工资对于当地来讲，确实高出一些，但用王阳的话讲“性价比极低。”

两年间，他数度想辞职，但还是咬牙坚持下来。“毕竟是上市公司，在履历上会有竞争力，而且能拿到分红的话，确实是笔不小的收入。”

每周只休息一天，而且不能保障，由于项目离家远，他只能攒两周的假，回一次家。几乎每天，他都是晚上九点下班，家人和朋友完全理解不了他在忙什么。“项目一直在招人，上班太忙，只能下班通知应聘的人来面试。”即便是两周一次的回家日，也经常被项目总的深夜电话和周末来电打断，这让王阳对家庭充满愧疚。

最近，碧桂园负面新闻不断，身边的人都在问他，“碧桂园不会黄了吧”。虽然知道是玩笑话，也着实让他紧张了一点，自己有十几万元投资在项目上，等待分红，“最起码回报在30%。”他说。

2014年下半年，升级后的“同心共享机制”发布。据报道，所有新买入的土地均组成了合资公司，碧桂园占比大约85%，集团高管占比5%（所有项目都要投），区域人员占比约10%（投区域所在项目），其中区域总裁对辖下的每个项目的出资不低于项目总出资额的20%或80万元，项目总经理对自身管理的项目，出资不低于项目总出资额的30%或50万元。

王阳赶上了这个“红利”，认为确实是好机会。

跟所有投资人一样，在投资标的出现风险的时候，第一时间想的是，回报不重要，本金能回来就行。

## “把握经济局，必须关注政治局”

赵拓（化名）是碧桂园某项目的行政人员，前些天他接到通知，要他用一切办法招揽博士，“只要是博士就行，不限专业。只要在碧桂园就行，不限区域。”

于是他立刻搜罗了所有可能有博士资源的朋友，一一打电话，“跟你有什么关系？”几乎所有的人都问他。“这个涉及到年终的考核。”他回答，很难跟别人解释，因为他也有同样的疑问。

中部城市一个博士考察团的组织者，在洽谈会上接到了一个电话，“说是碧桂园的，不知道为什么找我。”接到电话的他，觉得莫名其妙，因为此次博士团的专业方向，基本上都是理工科，或者法律、金融，与房地产几乎没有交集。

对于碧桂园来讲，发生在两人身上的事源于同一个理由，“未来领袖计划”。

这是**2013年启动的一项被誉为超常规的人力资源建设项目。据悉，作为集团核心人才培养项目，加入计划的博士被许以高薪和高职业前景，碧桂园高管亲自担任导师，通过系统的复合式人才培养模式，他们中的一些人在短短几年内就会进入碧桂园的高层管理队伍**。

碧桂园集团副总裁兼人力资源管理中心总经理彭志斌透露，“未来领袖”计划实施5年来，共有5.6万名博士投递简历参与选拔，吸纳全球顶尖高校博士人才1122人。

有媒体称，这是因为2013年杨国强向中国平安董事长马明哲请教管理万亿资产的秘方，得到答案是“用优秀的人”。随后杨对彭志斌说：“我给你30个亿，你去给我找300个人来。”

但是仅凭别人的一句话就大规模启动的计划，并不是非常充足的理由。

十八大以来，人才问题和人才工作被高层提到重要位置，提出人才资源是第一资源，强调人才强国战略。随后，各地开始大规模地重视和开展人才工作。

2012年底召开了十八大，次年碧桂园的“未来领袖计划”就出台了。

**不得不承认，在国家大战略和大方向上，碧桂园跟得非常紧密**。

比如，扶贫。

创办免费学校、产业扶贫、64岁的时候选择“重新做一个‘农民’”、“投身到农业事业中去”、发布碧桂园现代农业品牌……

有媒体报道，2018年初，在碧桂园集团第一次工作会议上，杨国强向在场的员工提出一个问题：“中国农业发展整体还是比较落后，十九大提出乡村振兴战略，我们能为这个做什么？”

随后确立“地产+扶贫”双主业模式，把扶贫工作上升到主业的高度。5月8日，碧桂园农业控股有限公司注册成立，半个月后，碧桂园启动了全国13县精准扶贫乡村振兴行动。

**仔细观察便会发现，碧桂园的布局和发展，很多都踏在国家政策的风口**。

在房地产进入深度调整后，长效机制被不断强化，十九大提出“大力发展住房租赁市场，鼓励长租公寓等租赁业务发展”一个月后，碧桂园正式对外发布长租公寓品牌“BIG+碧家国际社区”,计划在3年内建设100万套长租公寓。

“加强国家创新体系建设，强化战略科技力量”在十九大报告中出现后，碧桂园发布科技小镇模式，大力推动产城融合。

正如碧桂园集团党委书记、总裁莫斌在住房和城乡建设部机关报《中国建设报》头版发表的文章中称，“顺势而为”。那时候，是十九大刚刚结束不久。

2007年，杨国强在北大演讲他本人的“22条商规”时，把“把握经济局，必须关注政治局”放在了第一条。

**这一条，他和他的碧桂园一直在坚定地执行**。

原文刊登于《凤凰周刊》，完整版请购买杂志阅读。

![03.jpg](https://i.loli.net/2018/08/14/5b72f009a09d1.jpg)
