---

layout: post

title: "“舆论审判”的意义和局限，兼谈米兔"

date: 2018-07-29

categories: Archive

image_feature: "https://i.loli.net/2018/08/01/5b61ca18d5b31.jpg"

tags: MeToo

description: 通过不断被曝出的案例，我们已经能够看到：中国的法律体系在保护性侵/性骚扰受害者方面存在相当大的不足。如果不是通过舆论的“法庭”，那些被指性侵/性骚扰的人将会毫发无损，而那些受害者则遭受着巨大的痛苦，社会正义将很难彰显。

---

原文来自「方可成 新闻实验室」：~~[“舆论审判”的意义和局限，兼谈米兔](https://mp.weixin.qq.com/s/t1kdmIyUVLe2VWqTa3j8Kw)~~

---

![01.jpg](https://i.loli.net/2018/08/01/5b61ca18d5b31.jpg)

本文是2018年7月28日发送的“新闻实验室会员通讯”第204期部分内容选摘。阅读更多关于传媒话题的专业资讯，欢迎点此加入[新闻实验室会员计划](https://mp.weixin.qq.com/s?__biz=MjM5NDEwNjQ0MQ==&mid=2654280568&idx=3&sn=cd0c35cfcb8b3d359b0d8bc5be3461c8&chksm=bd4d665e8a3aef48b1ac3a59766119a1ccb80a75292b859474ebed9375fefb46b67e9312031a&scene=21#wechat_redirect)。

作者：方可成

## 什么是“舆论审判”

在关于#metoo运动的诸多讨论中，有不少人表达了对“舆论审判”的疑虑和担忧。

“舆论审判”并不是一个有着严谨定义的概念。在这里，我尽量给一个明晰的界定。

按照我的理解，人们常说的“舆论审判”有两种。一种是试图通过媒体舆论，去影响案件的判决结果，也就是所谓“舆论影响司法”。对于这个问题，我的看法很简单：媒体在报道案件时确实应该尽量慎重，例如使用“犯罪嫌疑人”等准确的称谓，不在法院宣判前给人定义罪名，不使用煽情的语言，注意保护嫌疑人的权利等；但是，如果舆论真能影响司法，那主要还是司法不够独立的问题。

![02.jpg](https://i.loli.net/2018/08/01/5b61ca2b5bb49.jpg)

第二种“舆论审判”，也是人们所说的metoo运动中的“舆论审判”，它指的是舆论在法院没有给出明确判决的情况下，给予一些人舆论上的“定罪”。这些人虽然不是法律意义上的违法犯罪分子，但民意却普遍认为他们做错了事情，会对他们进行言语上的攻击。

在社交媒体普及之前，“舆论审判”主要是通过报纸杂志广播电视等大众媒体完成的。如果有人希望指控其他人，将其置于“舆论的法庭”供人评判，那么ta只能投书媒体，期待媒体关注到ta揭露的事件。如果媒体选择跟进某一爆料，那么一般会按照新闻专业主义的操作，进行调查和核实。如果媒体调查发现被举报的人确实存在不当行为，便可以发表报道，读过报道的人会形成自己的判断，完成民意上的”审判“。

社交媒体普及之后，普通人提交“诉状”的过程变得容易了很多，不再需要通过大众媒体，只需要在微博微信等社交媒体上发布自己的陈述即可。如果一则陈述被很多人看到并且相信，形成了较为一致的判断，那么“舆论的法庭”便能够快速完成一次“审判”。如果没有很多人看到，或者看到了但是不信任，或者很快就被删帖了，那也就无法完成“舆论审判”。

![03.jpg](https://i.loli.net/2018/08/01/5b61ca21b6ef7.jpg)

## “舆论审判”作为重要的替代机制

以上对“舆论审判”的描述是完全中立的。我希望特别强调的一点是：“舆论审判”并不必然是坏事，当然也并不必然是好事。我们不必看到“舆论审判”就躲得远远的，重要的是去理解它的意义和局限。

在法治社会，我们当然要依赖正式的法律体系来解决纠纷、获得社会正义。但是，正式的法律体系并不是万能的，且不说在某些司法并不独立的国家，即便在法治体系健全的西方发达国家，法律体系也不能解决一切社会正义问题。例如，美国法律系统的一个为人诟病的问题就是，富人和穷人是不对等的。富人可以通过支付昂贵的费用请到最好的律师，从而大大增加胜诉的概率。还有很多数据显示：法院在判决时对弱势群体、少数族群存在歧视现象。

因此，在承认法律体系的主导地位的同时，我们也要承认：**要达到更广泛的社会正义，必须依靠其他替代性的（alternative）机制。所谓的“舆论审判”，就是其中一种重要的替代性机制**。

![04.jpg](https://i.loli.net/2018/08/01/5b61ca1fa98e7.jpg)

章文：“我在法律上是不怕的！”

通过不断被曝出的案例，我们已经能够看到：中国的法律体系在保护性侵/性骚扰受害者方面存在相当大的不足。如果不是通过舆论的“法庭”，那些被指性侵/性骚扰的人将会毫发无损，而那些受害者则遭受着巨大的痛苦，社会正义将很难彰显。

被多名女性指控性侵/性骚扰的章文，在接受澎湃新闻采访时就直接表示：“我在法律上是不怕的。”（https://www.thepaper.cn/newsDetail_forward_2292839）

由于很多非常具体的原因（法律缺失、受害人意识不足、受害人心理创伤、警察无此方面培训、权势者威逼利诱等等），很多这样的事件确实无法在法律体系中得到公正的处理。如果没有“舆论审判”的存在，章文们可以不怕任何事，继续神气活现地出现在各种场合，继续他的勾当。

## “舆论审判”的局限性和风险

当然，在充分肯定“舆论审判”重要意义的基础上，我们也需要清楚地认识到“舆论审判”的局限性和风险。

这就需要我们拿出放大镜，仔细分析“舆论审判”的机制，并与法律审判进行对比。

**法律体系的特点是制度化**。诉讼的审判有其形式要件和规定动作：举证、辩论、裁判，每一步都有明确的规则可循。什么可以成为证据、什么样的证据可以被采信、定罪依据的是哪个法条、量刑的理由是什么，这些全都有规则、讲逻辑。

而“舆论审判”则没有这些明确的规则可循。事实上存在疑问的说法也可能被采纳，辩论中诉诸情绪而不是逻辑也可能起到明显效果，事件的复杂性容易被简单的判断遮蔽。

这些当然都是问题。但我们不必夸大这种问题，它远没有到致命的程度，原因有三。

**其一，民众并非群氓**。这一点，我在针对《乌合之众》一书的批评中就已经做了详细的论述。尽管舆论审判必定比法律审判要更加不严谨、更加情绪化，但它也绝不是一群乌合之众像无头苍蝇一样乱飞。大众的判断力也许比不上大法官，但也绝不是白痴，犯错的机率并不会特别大。

顺带说一嘴，一个有趣的现象是：大多数推崇《乌合之众》的人，都认为群众智商堪忧，同时又认为自己清醒明智。其实，你没有那么明智，群众也没有那么糊涂。你和群众的水平差不太多。

**其二，“舆论审判”是没有“牙齿“的**。刑事诉讼的背后是国家公权力，被定罪的人要被判刑，但舆论审判绝无这样的强制力，它背后没有公权力，它能做的判决只是降低一个人的社会声誉——**这也是metoo运动和“文革大字报”最大的不同**，前者是自下而上的草根运动，后者是自上而下的发动群众。而且大家也很清楚，舆论对一件事情的关注时间有限，就算在某一时间点有着非常激烈的攻击，也往往会很快淡去。

其实，只要看一下现任的美国总统就会明白：性侵/性骚扰事件中的”舆论审判“是多么的没有牙齿。

![05.jpg](https://i.loli.net/2018/08/01/5b61ca2b991ac.jpg)

**其三，“舆论审判”是有救济机制的**。这样的救济机制就是：被“审判”的人可以发表自辩，如果成功的话，可以获得民意的理解和支持，重新恢复社会声誉。而如果有人诬告，则可能会承担法律上的代价。

所以，**作为一种替代性的正义机制，“舆论审判”虽不完美，但也绝不是洪水猛兽**。

## 你如何选择？

在一个理想的世界里，我们当然是既要肯定舆论的作用，又要排除舆论审判的风险。但很可惜，不存在这样的理想世界，一个“既要……又要……”的世界往往不存在于现实中，我们的资源、精力都是有限的，我们不得不作出选择——在巨大的权力差距面前，你是选择鼓励那些勇敢的女性（也包括一小部分男性），给她们鼓劲、加油，还是选择强调“舆论审判”的风险，给这场运动增加一些束缚、泼一盆冷水？

我会毫不犹豫地选择前者。越多人鼓励，她们就越安全，也有越多人有勇气说出“me too”。那些受害者讲述的痛苦经历、性侵/性骚扰现象的深度和广度，让人无法奢谈优雅的姿势、完美的解法。

**没有社会运动是完美的**。历史上每一次推动进步的社会运动都是如此，但如果因为它是不完美的，就满心怀疑甚至拒绝它，那就好像在一个快要闷死人的房间里，对着去开窗的人说：三思啊，开窗让苍蝇飞进来了怎么办？

其实，**那些大声呼喊苍蝇危险的人，往往是自己吸着氧气瓶**（也就是享受着父权社会赋予的特权，或者是因为拥有其他方面的地位而幸免于性骚扰），**没有意识到房间里空气的稀薄程度，没有切身体会到那些无法呼吸的人的痛苦**。

但我们真的不能对他人的痛苦视而不见，不能对这房间里的权力结构视而不见。为什么过去数十年，进步的知识分子在中国积极倡导法治？因为大家知道，在巨大的权力不对等面前，法治是弱者可以依赖的武器，是约束权力的方法。

同样的道理，在巨大的性别权力不对等面前，舆论是弱者可以依赖的武器，是约束权力的方法。为什么一些长于批评公权力的人，对于这种性别权力就视而不见了呢？政治权力的压迫和父权社会的压迫，实际上是同构的。

最后做个总结：法律体系不是万能的，“舆论审判”是重要的替代性正义机制；“舆论审判”不是完美的，有局限和风险，但也不是洪水猛兽，它的负面作用是有限的、可控的；面对不平等的权力结构，我们应该鼓励不完美的社会运动继续下去。

（本文是2018年7月28日发送的“新闻实验室会员通讯”第204期部分内容选摘。阅读更多关于传媒话题的专业资讯，欢迎点此加入新闻实验室会员计划。）

我们不能对他人的痛苦视而不见，不能对这房间里的权力结构视而不见。
