---

layout: post

title: 木田无花：如何做出无悔的人生选择

categories: Archive

date: 2018-07-13

tags: 木田无花

image_feature: "https://i.loli.net/2018/07/14/5b49577a0320a.jpeg"

description: 这八个问题，助你在面临重大选择时不慌张、不犹豫、不躲避，在自己的人生道路上越走越宽，越走越坚定。

---

原文来自微信「木田无花」：~~[如何做出无悔的人生选择](https://mp.weixin.qq.com/s/Xq3CUsUCdEGCGcv6iY0iAg)~~

---

![01.jpeg](https://i.loli.net/2018/07/14/5b49577a0320a.jpeg)

又是一年毕业季。毕业典礼上，我们或许会群嘲发言者对「绩点」的自我炫耀，却忘了自己在平日的生活中，并未彻底反抗发言者所代表的「主流价值」；我们或许会在溢满感伤情调的骊歌中潸然落泪，却在泪水中小心翼翼地掩盖起，选择背后的局促不安。

尚未毕业的学弟学妹们，或许同样如此：保研还是出国，到政府还是企业，做公益媒体还是工友社区工作，间隔年去做支教项目还是创业扶贫……在千变万化，矛盾日益尖锐的社会中，每一个人生选择的背后，都似乎有着无数可能性等待着我们开启，又有无数种矛盾甚至是与我们价值观的激烈冲突；然而万千弱水，我们只能取一瓢饮。

在这种情形下，我们如何才能做出无悔的人生选择呢？如果有这样的师兄师姐，真的做出了令自己不后悔的人生选择，并且越走越坚定，我们难道不想了解，这样的选择是如何做出来的么？

这样的师姐的确存在；她就是中大校方断然不可能邀请到毕业典礼台上的校友代表——沈·dream·rain（MY）。

MY的人生选择，我们可能或多或少有所了解。她从中山大学数学专业研究生毕业后，扎根进工厂，成为一名普通工人，被rihong厂的工友们集体选为工人代表，为争取劳动者的权利与尊严踏实调研，努力发声，纵使被工厂管理者匿名诬陷，频频打压，甚至违法开除，她也从未放弃抗争。

【MY抗争详情，请见微博「梦雨有话说」，以及事件合集：http://sdxf04.ga/archives/12075】

MY是值得我们敬佩的人；MY更是我们身边的人。她在大学校园里的时候，和我们一样，通过阅读新闻或社会调研，了解到了劳动者艰难的处境，也以学生身份参与过维护劳工权益的行动；也和我们一样，面临着种种可能相当困难的人生选择：继续深造读博士，可以取得更多学术突破；凭借数学专业知识进企业，可以谋得很高的收入；即使是继续做劳工相关的工作，也可以选择去NGO或者做法律援助，工资低些，但相对稳定，也不至于没有「后路」。至于直接进厂做一位工人，当然不是不可以，但似乎总有些令人担心：一天十几个小时的重复性劳动，之前不都白学了么？身边朋友会对我有什么看法？家里人不同意，甚至直接精神崩溃，该怎么办？

如此种种选择与矛盾，需要我们逐步拆解与分析，进行价值排序。下面，我就将以MY当年面对的这几种选择为基础，总结出一套人生选择的方法论；我前一段时间自己做选择时，也运用了这一方法论。希望能以此更好地帮助到各位朋友，在面临重大选择时不慌张、不犹疑、不躲避，在自己的人生道路上越走越宽，越走越坚定。

![02.jpeg](https://i.loli.net/2018/07/14/5b49577a1bff9.jpeg)

首先，我们需要准备一支笔，一个本子，本子内页最好不要有装饰与横线。建议手写，因为手写相对不容易涂改，这样写每个字之前都需要审慎思考；最终写下自己的决定时，也有一种庄重感。

我们还可以准备相对完整的一块时间。这是为了留出一个自我审视的契机，尽可能逼迫自己问更多的问题，追问每一个「理由」背后的原因，每一条「后路」蕴含的价值取向。但如果因为正在参与社会行动，没有办法拿出一块完整时间的话，利用行动间歇的碎片时间书写，将自己的反思与整个行动结合起来，或许反而能起到更好的效果。

刚刚开始打开本子，拿起笔，我们可能还没办法做到很有逻辑；但是，我们会对「职业选择」本身有些想法，对自己和身边人最近的状态有所观察，对近来的社会环境与变化有一定认识。不如先把这些心路历程写出来，例如：

「所以……现在到了你诚心直面自己，做出选择的时候了。青年在选择职业时的考虑，你读过，不止一次。这学期开学初，你一遍遍地和身边朋友们做铺垫，说自己可能不继续读博士了，说自己很可能在广州做工人相关的工作。再然后，环卫工人的事情一件件出来，你受到了很大教育；这种教育也马上通过调研报告的实践再次得到了强化。在很大程度上，对当前局势的认识、对幻想的抛弃、对路线的调整与坚定，都是与这一学年的职业选择并行且相互影响的。」

这一步的核心，是要将社会现实环境与自己的人生选择结合起来，为后续正式的分析定下基调。当我们意识到，我们是在这样一个充满不公与压迫、撕裂与斗争的社会中，做出自己的人生选择时，我们自然会发现，自己的选择会在多大程度上改变这一压迫性的结构，或者强化它；没有改变与强化之外的「中间道路」可走。从另一个角度来说，人生选择，尤其是其中本职工作的选择，会最直接地形塑我们的社会身份与社会关系，进而形塑我们的价值与立场，所以明确社会现实环境，也有助于我们认清这一形塑作用，坚守人生选择的底线。

![03.jpeg](https://i.loli.net/2018/07/14/5b49577a35260.jpeg)

接下来，我们可以逐步问自己以下问题：

1. 现在你都有哪些选择？

  （如：升学，进企业，做NGO或法律援助，进厂）

2. 现在你要做的最紧迫的决定是什么？

  （如：何时给何单位回复，如何向家人交代等）
3. 你在做上面这些决定的时候，最纠结的点在哪里？

4. 这其中，有哪些是本来不必考虑的，需要避开？

5. 如果你真的做出了其中一种选择，可能发生哪几种情况？

6. 不同选择的本质区别究竟是什么？

7. 现在纠结的点解开了么，为什么？

8. 现在呢，你要做出哪个选择？

其中，1、2两问在开头明确选择本身，7、8两问在结尾呈现最后的思考与决定。中间四问中，3、5两问为事实分析，需要全面具体的自我暴露；4、6两问为价值排序，需要与社会现实充分结合，步步追问，审慎思考。

以第3问为例，在写自己「最纠结的点」时，暂且不用自我审查，哪怕是觉得很无厘头、甚至很自私的纠结，只要强烈而真实地存在，也先写下来再说。只有在这里充分暴露，才能在下一个问题中真正认清这些纠结背后的原因，发现其中的哪些根本不必考虑。例如，关于是否出国深造的纠结，可以这样暴露：

「我有一种『为了出国而出国』的想法；尽管我自己很清楚这种想法站不住脚，也经常劝我的朋友不要这样做，但不得不承认，直至今日我依然没有完全摆脱这样的想法。这种想法背后有什么呢？一个是，我从小生活的环境过于优裕，初中同学有一半多都到美国念本科了，所以我潜意识里总是怕自己倘若没有在美国念过书，反而在见识和视野上会比同龄人亏欠很多；另一个是，我会觉得好像出国深造是个特别理所当然的事情，不读的话可能以后很多方面都会比较被动。」

有了这样的暴露，后面的追问就很容易了：所谓「见识」与「视野」，真的依赖于你去过多少国家，是否在美国念过书吗？你所谓的「同龄人」，究竟是社会上大多数的劳动者，还是出身大城市上中产阶层家庭的那几十个人？「被动」与否取决于你以后要做什么，为哪一阶级的人而做；既然你要做的事情并不是搞学术，那么怕自己「被动」，不还是先想着自己，给自己「留后路」么？如果有给自己「留后路」的想法，问自己这种想法背后的真实原因，把这一原因写下来；我们很可能会发现，这一原因如此浅薄，连自己都说服不了。

这些追问的基础，就是价值排序。从来就没有事事能「兼顾」的人生选择，价值排序是我们能在矛盾中进行取舍的前提；有了正确的价值排序，才能在整个暴露、分析与选择的过程中，进行有条理的自我反思，而非循环论证、自我安慰式的「反思」。

![04.jpeg](https://i.loli.net/2018/07/14/5b49577a3461f.jpeg)

首先，我们要明确，价值排序的具体表现形式可能因人而异，但在具体的社会现实中，不同的价值排序是有正误优劣之分的。2018年前五个月，有据可查的中国大陆工人集体抗议、罢工等行动已达759起，比去年同期增长了95%；从八青到修宪，从高校反性骚扰到尘肺工友抗争，社会矛盾已再也无法用删帖来掩盖；属于中产阶层「岁月静好」的空间越收越紧。在这一社会现实之下，一些人依然以「稳定」作为自己价值排序的最高位，希望能找一份「远离政治」的「稳定」工作，终此一生；然而，这样的「稳定」是不可能长久的，这一价值排序也因此自相矛盾，有很大偏颇之处。只要我们本着唯物主义方法来认识社会现实，我们就不难得出上述结论。

然后，我们要带着这一明确的认识，进行核心价值的排序。例如：个人在行动中获得认可，与劳动者集体的权益得到维护，究竟哪个更重要？对于家人的道德义务，和对比自己家人更受压迫者的道德义务，究竟哪个更重大？对改变社会而言，更有价值的选择是拥有更高的社会地位，并以此做慈善，还是与工人农民相结合，改变社会的所有制结构？

还记得在整个方法论的第一步，我们通过心路历程的书写，将社会现实环境与自己的人生选择结合起来；我们和梦雨一样，看到物业公司「克扣工人工资福利、拖欠社保和公积金、给工人签空白合同、逃避本应承担的经济补偿」，看到政府部门面对如此不公「置身事外、不管不顾」，看到身边的同学们「为工人奔走、呐喊，也被团结抗争的工人所感动和教育」。

这样的结合，会帮助我们逐渐明晰价值排序：「惨淡的现实淋漓的鲜血」，让我们感觉到「法律的无力和苍白」；「审视自己」，发现自己不应「理所应当享受」投胎带来的「既得利益」，将使我们在人生选择的过程中，真正突破个人中心的束缚，同最受压迫也最有力量的阶级并肩战斗；同样是为工友们服务，我们要在尽量发挥自己特长，多做贡献的同时，选择最彻底的，最能直接介入真问题的工作。

是价值排序，让这一人生选择的方法论不同于其它的思维模式；是对正确价值排序的认知与坚守，让MY在充满矛盾的现实中，坚定地选择了进厂斗争之路，与劳动者一道寻回失去的权利与尊严。

我们今天和MY站在一起，是为了捍卫这样一种人生选择与价值排序的路径；更是为了持续鞭策我们自己，关注rihong厂的真问题，关心整个社会劳动者的真问题，并以此为基础，在自我反思的同时，与志同道合者坦诚交流，在集体中凝聚力量，做出无悔的人生选择。

![05.jpeg](https://i.loli.net/2018/07/14/5b49577a405d0.jpeg)

![06.jpeg](https://i.loli.net/2018/07/14/5b49577a1dda5.jpeg)

防失联，请关注木田君的另一个家：木田君的镐头（mutianpickaxe）

![07.jpeg](https://i.loli.net/2018/07/14/5b49577a0b258.jpeg)
