---

layout: post

title: 留守儿童有更艰难的成长发展之路

categories: Archive

date: 2018-06-17 23:00

image_feature: "https://i.loli.net/2018/06/19/5b2904319443c.jpg"

tags: 留守儿童

description: 这是针对高校中留守儿童成长的大学生发展问题的一次访谈，他们相比于其他同学有更艰难的发展之路……

---

> 原文来自微信公众号「晒爱思PsyEyes」：~~[留守儿童有更艰难的成长发展之路](https://mp.weixin.qq.com/s/a-RwZrzwkOsMcFjheHo-XQ)~~，该公众号已被永久封禁，详见 [靴子还是落下，晒爱思PsyEyes被“永久封禁”](https://mp.weixin.qq.com/s/4Fl8f2Nh1xg0c_kawtmhjg)。二次原文来自 [桌旁·坐和放宽](https://www.zhuopon.com/focus/view/4953/)。

> 作者：晒爱思PsyEyes/唐映紅

---

![01.jpg](https://i.loli.net/2018/06/19/5b2904319443c.jpg)

### 被隔代抚养的孩子最大比例就是中国特色的留守儿童，那么为什么会有这么多的留守儿童呢？

这不是一个心理学问题，而是一个社会学或政治学的问题。因为众所周知的原因，这里就不展开。

![02.jpeg](https://i.loli.net/2018/06/19/5b2904309c1be.jpeg)

### 对于留守儿童来说，他们成年之后相比于由父母亲自抚养的孩子，可能在安全感、社会性发展和习惯养成方面都存在一系列的问题，那么他们该如何克服呢？

是的。被隔代抚养的孩子相比于父母亲自抚养的孩子他们在安全感、社会性发展以及习惯养成方面存在着系统的差异。当孩子未成年时，主导孩子成长发展的责任和主要驱动力应该是扶养人；而一旦孩子成年，那么成长发展就应当是他们自己的事情。因此，对于一个希望克服自身一系列弱点的曾经留守儿童来说，实际上他要面对就是一个如何致力于自身成长，不断完善的问题。在我看来，无需特别地强调“留守儿童”概念，因为他们的成长与其他任何年轻人的成长并无二致。

举个例子，我们笼统地看待隔代抚养与父母亲自抚养之间的差异时，可以从“抽象”的现象中分析和发现一些问题。但对具体的每一个年轻人，无论他是被隔代抚养还是由父母亲自抚养，当他面临成长的困难时，就要设法去克服他，这个过程并没有什么不同。再比如说，安全感问题，虽然被隔代抚养比父母亲自抚养更容易出现的安全感不足的问题，但对具体的某一个年轻人来说，却未必。与一个生活方式紊乱、神经质的母亲朝夕相处对孩子安全感的损害恐怕比祖辈抚养更严重。被隔代抚养容易出现安全感不足的问题；而与情绪化、神经质以及生活方式紊乱的母亲能共同生活则不仅仅是不足，而是安全感被破坏掉的问题，远比前者要严重得多。

![03.jpeg](https://i.loli.net/2018/06/19/5b2904314b4a2.jpeg)

### 那么该如何致力于自身的成长呢？

首先是是否选择心智成熟的成长历程；其次才是要怎样做的问题。如果仅仅是“想”改变，但不愿付出艰辛努力，那么也是于事无补。我们每个人成长到 20 岁，无论童年、青春期是如何度过的，都必然发展出了一套适应我们成长经历的人格，它会指导我们的认知、思考、感受和行动而不致于感到局促和困顿。换言之，我们会尽可能发展出保护我们自己的人格来，当然其中也就包括了合理化不合理的经历和处境、否认错误、过度保护自尊以及压抑欲望，等等，种种因素在里面。

因此，如果我们顺其自然地成长，那么我们的人格发展会尽可能地使我们避免痛苦，趋利避害。这样的做法或许并不是什么“错误”，但如果我们的成长经历已经使人格发展存在缺陷和不足，那么趋利避害就可能埋下隐患。例如，安全感不足就可能使我们的人格发展出特异性的不安全型依恋的特质来。如果你因为安全感不足而总是过于敏感身边亲密朋友对你的态度，总是希望从他人对你的蛛丝马迹中来寻找让自己安心的线索，那么你就可能发展成痴迷型的依恋，你既强烈地渴求建立亲密关系，又十分焦虑和担忧亲密关系会破裂，这种焦灼的情绪会损害你从亲密关系中感受到幸福，同时也会令对方难以承受。或者，你因为安全感不足而使你发展出令可与他人保持足够的距离，也不愿走近一步去承受风险；甚至你干脆就习惯了独来独往，不再需要亲密关系，前者是恐惧型的依恋，后者是疏离型的依恋。这三种不安全型的依恋都有一个共同的特征：难以使我们体验到真正的幸福，阻止我们去享受家庭的温馨以及与孩子的天伦之乐。

也就是说，如果你不希望未来的人生消极，而希望能更积极一些，那么就需要选择心智成熟的历程，这意味着在短期内你会面对更多的不安、局促，甚至痛苦。例如，当你已经发展成痴迷型的依恋，那么如果你不去改变，你可能会在一次又一次的恋爱中不断地犯同样的错误，但令你欣慰的是，每一次错误你都能顺利找到对方的“错误”因而不会令你自己难堪。而你一旦选择了改变，那么就要去直面并承认自己的问题，而不是推诿到别人身上（哪怕推诿是如此的容易）；更重要的是，要“强迫”自己忽略哪些琐屑的“不安”，而专注于更重要的方面。这就可能需要你把与朋友的交往当作是一门“功课”来修习，记下要点，按大纲来反复练习。

所谓“习惯”，就是我们习以为常的认知模式、情绪感受模式和行为模式，它不需要我们意识的介入，自然而然就“跳”出来反应。养成的习惯就是我们人格的一个组成部分。要矫正或克服不好的习惯，就需要重新养成新的习惯来替换掉旧的习惯。这个过程之所以艰难，就在于你必须在你每一次要自然而然地“反应”时，你的意识必须要介入，提醒自己“应当怎么做”。所幸，你这样重复的次数足够多，就会养成新的习惯。这个过程就好比在大陆开惯了左舵车，乍一到香港开右舵车的情形类似，一开始你要克服“自然而然”的反应，要提醒自己正确的做法；一段时间之后，你就不会再有困惑了。

![04.jpeg](https://i.loli.net/2018/06/19/5b2904314b593.jpeg)

### 如果这样做了，是不是对每一个致力于成长的年轻人都有所帮助，使他们达成目标呢？

有所帮助那是肯定的，但是否达成目标就因人而宜了。我们每个人的生性中都有些与生俱来的特质，它反映在我们的人格模式中，而且与那些后天养成的“习惯”交织在一起。如果我们努力要改变的是那些后天养成的“习惯”，那么达成目标没有问题；如果我们要改变的是与生俱来的特质，那就可能会真正地“碰壁”。这就好比，你如果因为家庭养育模式的保守和自身安全感的不足，使你在追女生时缺乏信心，那么这是可以改善的部分；但你如果与生俱来就对女生不感兴趣，那就不可能改变也无须去改变。

![05.jpeg](https://i.loli.net/2018/06/19/5b29043193482.jpeg)

### 可是，如何甄别这二者呢？哪些是我们必须要接受的与生俱来的特质；哪些是后天养成阻挠我们成长的因素？

嗯哼。成长和改变必须在“悦纳自我”的基础上。没有人能在某一时刻彻底把这二者区分清楚，我对自身也做不到。但是，典型的“习惯”和典型的“天性”是可以甄别的。无论你是同性恋还是异性恋，这是“天性”的因素；但你能不能大方得体地去追求你喜欢的他人，这就是一个“习惯”的因素。大多数时候我们其实很容易把典型的“习惯”和典型的“天性”区分开来，如果说有什么困顿的因素，那就是我们可能会把一些“习惯”错误地归因为“天性”，从而保护我们的自尊或减少对自我的威胁。
