---
layout: post
title:  海航危机加剧，负债千亿，隐患重重
date:   2018-02-08
categories: Archive
tags: 海航
description: 八年之后再度面对这一熟悉的 “场景”，我决定不再等待，直接在网络上发布调查报道与记者手记。
---
来源：华夏早报 [南方周末毙稿：海航危机加剧，负债千亿，隐患重重](http://www.huaxiazaobao.net/2018/zhongbangxinwen_0208/1758.html?from=groupmessage&isappinstalled=0)

文 / 黄河

---

### 不再等待

2 月 7 日晚上，被编辑告知此前悉心操作的海航调查报道专题，在已经上版的情况下被无故撤稿，刹那间仿佛又回到了八年前平安调查报道深夜被撤时的激愤与无奈之中。

八年前的那次撤稿，我经历了长达半年的申诉与等待，并在最终发表无望的情况下多次寻找其他发表途径，最终不了了之。

八年之后再度面对这一熟悉的 “场景”，我决定不再等待，直接在网络上发布调查报道与记者手记（为了这组报道，我还专门写了一篇手记，说明自己在报道中的分析逻辑与观念立场）。

### 记者的天职

在此正式声明撤回向《南方周末》报社提交的《海航又闹 “钱荒”》与《海航“危机史”》两篇稿件，不参与报社未发稿业绩记录与评级。同时放弃两篇报道的原创版权，供网络及媒体自由流通转载。但出于“文责自负” 的原因，请转载时不得修改原文内容，并保留作者署名。

作为文章作者与网络发表的直接责任人，我个人对报道原文中的事实陈述与价值判断承担全部责任。

还是八年前自己在平安报道申诉中的那句话：“重大且涉及公众利益的事实真相，既已诞生便须公诸于众——这既是记者的天职，也是公民的本份。”

## 目录

* 海航 “钱紧”
* 致命转折点
* “点土成金”
* 三次危机
* 狂飚突进
* “红舞鞋” 与新周期
* 调查手记

![09-01-hai-hang.jpg](https://i.loli.net/2018/04/26/5ae1bf5fdd012.jpg)

借助 “造岛模式” 所形成的庞大土地储备，以及 20 余家投资参股的金融机构，海航集团打造出一个超级 “土地资产证券化” 平台，并以花样翻新的杠杆融资模式，为自己的激进并购带来源源不断的资金支撑。

在监管政策转向和环保风暴等多重冲击下，巨额负债令海航集团面临着又一场 “生存之战”。曾经“四通八达” 的融资渠道，此刻却变成一条条债务“绞索”。

以 “负债式收购” 模式迅速扩张资产负债表的海航们，实质上是以信贷膨胀所推动的资产价格增值，掩盖了企业扩张过程中的种种问题。在让资本市场买单的同时，创造出一个个“不败神话”。

### 海航 “钱紧”

2018 年 2 月 1 日，股市频现 “闪崩”，A 股上证指数和深证成指分别下跌了 0.98% 和 2.65%，两市逾 230 只股票跌停，近 40% 的个股跌幅达到 5%。

其中，海航集团旗下两只未停牌的上市公司海航创新（600555.SH）与海越股价（600387.SH），在前期宣布业绩预增和股东增持等多重利好消息之下，依然分别下跌 9.88% 和 6.69%。相比 2015 年牛市顶峰时的股价，已下跌超过 60%。

此前，海航旗下 A 股上市的七家子公司陆续宣布停牌，加之上市公司质押股权被短暂冻结、债券价格持续下跌以及高息融资等消息，令市场神经高度紧绷。

海航钱紧，源于其过去数年中狂飙突进的全球并购。

在全球范围内，海航集团以超过 400 亿美元的大手笔展开一系列跨国并购，成为包括德意志银行和希尔顿全球在内的多家跨国企业最大股东。在国内，2015 年百亿级别的 “年度十大并购案” 中，就有三桩是由海航系主导。集团旗下目前累计控制着 9 家 A 股上市公司、7 家港股上市公司及 1 家 A+H 上市公司。

海航集团内部隐含的高负债率风险，最终被一笔高息融资所 “引爆”。据媒体披露，2017 年 11 月 3 日，海航集团发行了一笔期限为 363 天期的美元债, 发行利率达 8.875%, 利息水平较三年前高出近三个百分点。

这被视为海航集团 “资金短缺的最新迹象”。紧接着，26 天后，国际评级公司标准普尔宣布，将海航的信用评级从 B + 降至 B 级，并表示担心这家公司 “即将有大量债务到期且借贷成本上升”。

就在评级下调前两天，海航集团公布了其核心财务数据，其中一个数据格外醒目——2017 年 1-11 月末预计借款余额 6375 亿元。与之相比，集团注册所在地海南省 2017 年 GDP 只有 4462.54 亿元。

集团旗下的天海投资、渤海金控等多家子公司随即陷入长达数周的股价下滑。就在集团公布财务数据后第二天，海航集团旗下子公司供销大集（000564.SZ）宣布停牌，成为 “海航系” 第一家宣布停牌的上市子公司。

此后近两个月时间里，从股价指数走势中可以看出，身为实际控制人的海航集团使尽混身解数为旗下上市子公司股价 “护盘”，但到了 2018 年 1 月下旬，终于“无力回天” 的海航集团不得不连续申请旗下子公司停牌，以避免股价连续大跌引发的质押股权 “爆仓” 风险。

据《等深线》记者统计发现，海航集团通过直接和间接质押旗下公司（非上市公司）股权融资金额超过 1000 亿元，而已停牌的 7 家上市公司股权质押比重普遍高于未停牌的上市公司，其中质押比重最高的前三家停牌上市公司：渤海金控、凯撒旅游和海航基础的质押比重分别为 60.43%、58.28%、57.32%。

媒体报道显示，近期举行的债权人会议上，海航集团表示一季度或许会出现 150 亿元人民币的资金缺口，并已加快资产处置步伐，准备在上半年出售约 1000 亿元人民币资产。海航对债权人表示，若资产处置实施顺利，集团的流动性问题将在二季度得到缓解。

### 致命转折点

海航高负债模式由来已久，为何突然一夜间陷入债务危机？

在 2017 年 11 月底接受媒体采访时，海航集团首席执行官谭向东就表示，海航已经开始调整自己的并购策略，正陆续出售资产并清理旗下企业股权。

“当年大手笔买买买的时候，我们都没有料到流动性会一下子变得这么紧张。”海航人士向媒体的这一表态，真实地传达出了集团内部对此轮突然 “刹车转向” 的措手不及。

就在 2017 年 5 月中旬，海航集团还发行了 5 亿美元商业抵押贷款债券，为其 22 亿美元收购纽约曼哈顿大楼筹集资金，这也是海航集团的最后一笔境外并购融资。此前五个月内，海航已经在并购交易中投入近 1000 亿元人民币。

转折点发生在 2017 年 6 月 22 日，银监会要求各大银行对海航、万达、安邦等多家 “海外并购明星企业” 境外投资借款进行风险排查。

不到一个月后，万达便以 637.5 亿元代价将旗下 13 个文旅项目与 77 个酒店分别转让给了融创和富力两家地产集团，令金融市场震惊的同时，也引发了市场各方对其他几家被排查企业的关注与担忧。

几天之后，海航旗下喜乐航本拟以 4.15 亿美元收购美国公司 GEE34.9％股权的计划，宣布以流产告终。据彭博数据显示，此前海航及其子公司已经质押了至少 240 亿美元的 15 家上市公司股票，包括希尔顿全球控股和德意志银行的股份。

而此时海航集团在外界质疑下公布的股权结构细节，也令其投资者和债权人们陷入疑惑：一家在美国纽约注册不到一年的基金会，以及注册地位于海南省的慈航公益基金会，合计持有海航集团 52.25% 的股权。

奇特的股权结构和错综复杂的并购资金流向，令投资者不得不自问：一旦负债数千亿规模的海航集团无力偿还债务时，身为 “控股股东” 的两家基金会靠什么来为集团负债做担保？

正是这一这疑虑下，海航集团此前多宗境外收购被相关政府及企业董事会所拒绝，而随着境外收购所带来的巨额负债及股权资产质押信息陆续公布，“偿债风险” 已经成为前期投资者和债权人们所必须关注的问题。

2017 年 9 月，在香港金管局向银行查询海航与万达企业信贷情况的背景下，海航前期在香港收购的多宗土地传出被银行拒绝续贷的消息，不得不以企业拆借和设立高回报投资基金方式，以维系资金链并吸引外部投资者入股。

海航系旗下上市公司的股权质押项目，也被列入了券商机构们的 “黑名单”；海外投行高盛则以“担忧海航所有权结构” 为由，暂停了海航集团旗下企业的上市承销运作。

此前数年中为海航并购提供了源源不断资金支持的金融市场，在监管政策与市场情绪的双重转向之下，曾经 “四通八达” 的融资渠道，此刻却变成一条条债务“绞索”，令海航集团紧绷的资金流“雪上加霜”。

其实，与此同时还有一件更重要的事发生，只不过很少有人注意到。

2017 年 11 月 10 日，财新网报道显示，海航集团旗下多家子公司共同投资开发的三亚新机场填海项目因 “涉嫌违法用海”，已被国家海洋局暂停审查其用海预审申请。

2018 年 1 月，国家海洋局向海南省反馈围填海专项督察情况时，对海花岛、如意岛及日月岛等多个未批先建，审核不严的 “人工岛” 项目提出批评并要求整改。

三亚新机场附属人工岛 “莲花岛” 项目，同样因其 “未批先建” 和“化整为零”式的违规审批，而面临着社会各方质疑与空前严厉的环保监督问责。

至此，在海南乃至全国沿海各省延续数年 “一本万利” 的“造岛运动”，作为一种商业模式已经陷入了风雨飘摇的未知命运。

意味深长的是，恰恰是在三亚新机场填海项目面临调查与问责之际，海航集团高息融资与国际信用评级下调的消息接踵而至。对于此前数年早已 “债台高筑” 的海航集团而言，似乎直到此刻才被国际评级机构发现“有大量债务到期且借贷成本上升”。

深悉资本游戏奥秘的国际投资者们，担忧失去了 “土地平台” 这一关键腾挪空间的海航后续资金链安危，或许才是真正的缘由所在。

### “点土成金”

这场看似 “突如其来” 的危机，根源早已埋藏在海航集团此前多年的商业模式与发展理念之中。

早在 2013 年 6 月，海航集团时任财务总监赵权接受《21 世纪经济报道》记者采访时，便揭示了海航在多年高负债率下的 “生存理念”。

当时海航集团负债总规模 2500 亿元，集团总资产近 3600 亿元，负债率 78%。而此前大新华航空及金海重工两家企业上市失败，令集团负债率飚升的同时，也引来了市场各方关注与担忧。

报道引述海航掌门人陈峰的观点，认为市场常规的降低负债率方式中，“扩大资产是最愚蠢的方法”，而 “减少融资” 则是“第二愚蠢的办法”。陈峰眼中“最聪明的办法”，是“通过资本通道来解决这个问题”。

赵权明确表示，当时已经拥有八家上市公司的海航集团，“希望旗下更多板块能够登陆资本市场，首先就是地产部份”。

“我们有很优秀的地产项目，很多拿着的都是最好的地，最低的价格，但是没有通道上去 (资本市场)……” 赵权的这番话，无意中点出过去十余年中，包括海航在内的一批 “圈地 + 金控” 型企业狂飚突进所依赖的“点金术”。

正是凭借这一高超的 “点金术”，海航集团在其后短短四年内再度实现负债规模翻番，总资产过万亿元的 “超级 X 计划”。

就在近期海航集团宣布加快资产处置之际，媒体曝出其正谋求出售包括海口大英山 CBD 在内的部份土地资源以回笼资金。尽管海航内部人士向媒体称并非出售土地，而是 “与实力企业合作开发”，但这一消息本身却让海航旗下最大的 “资产包”——巨额土地储备浮出水面。

据公开资料显示，大英山 CBD 位于海口市中心区，总用地面积为 8440 亩，核心用地面积约 3000 亩，区域内共有 16 个房地产开发项目，包括海航中心、海航首府、海航豪庭等，是海口城市中心 “唯一周边配套成熟的大规模地块集中区”。

早在 1999 年海口大英山机场搬迁后，机场跑道两侧的 3000 亩土地便由海航集团控股企业海口美兰机场有限责任公司获得开发权。2012 年 9 月海南省政府批复，明确由海航集团牵头，在海口大英山片区设立和启动海南国际旅游岛中央商务区项目建设——这便是 2013 年 6 月海航集团财务总监口中的 “优秀地产项目”。

南方周末记者早在 2011 年的报道中，已经揭示了海航集团早期依托这一土地资源融资发债，完成自身增资 40 亿元及向海航股份定向增发 28 亿元，在摆脱了大新华航空上市失败引发的财务危机同时，实现集团对上市公司 “实质性控制” 的一系列资本运作（参见南方周末 2011 年 12 月 8 日《海圈钱，海花钱，海航戏法》）。

而在此后五年间，相关土地价格的急剧上涨，再度成为海航展开一系列大手笔收购的 “资本之源”。这一土地储备的市场价值，可以从海航旗下上市公司海航基础（600515.SH）2016 年重组前后的资产规模变化中看出端倪。

2016 年海航基础完成资产重组，注入了地产、机场及商业等资产。在重组前三年内，公司总资产仅为 28-37 亿元，而在重组完成后公司总资产规模大幅提升至 970 亿元，净资产规模从重组前的 8-12 亿元大幅提升至 437 亿元。

正是在实现了这一巨额土地储备 “资产证券化” 的“通道转换”之后，海航集团才得以为其一系列 “超级并购” 建立起规模空前的融资平台。

也正是在这一实打实的 “优质抵押物” 面前，包括国开行在内的 “超级金主” 们，才会慷慨地向海航集团敞开“钱包”；这些大型商业银行们的巨额授信，无形中又为海航在全球资本和金融市场中提升了“信用等级”，使其一举成为国际并购市场内的“顶级玩家”。

南方周末记者在查询海航旗下多家上市公司财报及信用评估报告等资料后发现，依托这一 “土地融资平台”，海航集团展开了一系列的资本运作：

将土地注入上市公司形成巨额净资产，并将资产规模剧增的上市公司股权向银行质押贷款；同时，土地上的相关房地产开发项目，又可以开发贷款的方式再向银行获得融资；此后还可以再将融资所得资金注入旗下其他上市企业，迅速扩大公司资本规模与实际出资额，再以此展开新一轮并购，并质押股权获得新的融资……

而这一系列融资，借助于海航集团数年间所参股和控制的 20 多家金融机构，形成了外界无法参透的 “黑箱式定价体系”，其资产估值与真实市场价值之间的差距无人能够 “看懂”。

据《新财富》调查统计，截至 2016 年底，“海航系”已成为仅次于 “明天系” 的国内第二大民营金控集团，其持股的 21 家金融机构几乎囊括了从信托期货到银行保险的所有金融领域。借助着这一 “无所不包” 的金融布局，海航集团打通了从传统信贷到互联网金融在内的数十种融资模式，其融资工具之复杂、融资领域之广泛，堪称当代“杠杆融资百科全书”。

作为这一 “超级融资平台” 的价值基础，海航的土地储备规模还不仅于此。据媒体调查统计，截止

2017 年底海航地产拥有房地产项目逾百个，其中持有型项目近 60 个，可运营面积约 220 万平方米；在建项目 40 余个，总建筑面积近 450 万平方米，其中大部份位于海南省内。

海通证券 2017 年 10 月的研究报告显示，海航基础旗下另一大土地储备来源：海口南海明珠生态岛用海总面积 459.32 公顷，其中陆域面积 265.42 公顷，相当于近 4000 亩。

报告预计海航人工岛开发总投资大约 1000 亿元，其巨额融资需求与庞大投资收益无疑又一个令全球金融与投资机构们垂涎的 “大蛋糕”。

然而短短一个月后 “风云突变”，空前严厉的环保风暴刮向海南人工造岛运动。借助着迅速膨胀的潜在土地储备“预支未来”、累积了空前债务规模的海航集团，将要为自己多年“土地资产证券化” 模式下的激进扩张，迎来新一轮“生存挑战”。

### 三次危机

对于海航集团而言，此次债务危机，并非其第一次因激进扩张而遭遇 “生存危机”，甚至可以说，整个“海航模式” 就是在不断的 “并购扩张” 与“资金链危机”循环中走到今天的。

在 1989 年创立之初，启动资本 “只够买个飞机零件” 的海南航空，是凭借着 1993 年和 1999 年在 STAQ 系统和 A 股市场两次上市，才募集到购买飞机经营航线的资金。

2000 年之后，面对三大国有航空公司重组地方航空企业大潮，海南航空仍不得不以一系列远超自身资本实力的跨区域并购，跻身 “国内第四大航空公司”，才保住独立发展的资质。

但因为收购地方航空公司而欠下超过 20 亿元 “巨债”，海南航空随即陷入“资不抵债” 的困境，直到 2003 年意外爆发的 SARS 疫情: 海南航空随即宣布由于“疫情影响等原因”，公司巨亏近 15 亿元——亏损比例超过其他三大航空公司五倍以上。

摆脱了财务危机的海航迅速开始了新一轮并购扩张，在收购商业零售上市公司西安民生的同时，还试图涉足证券、信托与商业银行的股权收购。

然而 2004 年 “德隆事件” 爆发，令监管层开始严查国内企业的 “类金融控股” 模式，海航也因此被迫止步，并迅速将目光投向了以香港证券市场为代表的境外资本市场。

此后三年间，海航管理层通过一系列资本运作，试图将旗下资产置入拟在港交所上市的 “大新华航空”，并以一系列复杂的资产置换与股权结构安排，实现了由原管理层所控制的“海航集团” 实际控制大新华航空，并间接控股上市公司海南航空的多层股权控制架构（参见南方周末 2011 年 12 月 8 日《谁的海航》）。

因为上市模式及所有人结构的争议，加上 2008 年国际金融危机爆发，大新华航空上市最终功亏一篑，反而将海航集团推入了空前的债务危机之中。

此时，上市公司海南航空继续发挥特长，在大幅溢价收购海航集团旗下资产后，于 2008 年再度报出 14.24 亿元巨亏。

海南航空于 2007 年底将其 6 亿元投资建设的北京科航大厦以 “工程成本价” 转给海航集团，又于 2008 年 12 月以 17.28 亿元高价向集团回购大厦股权，仅此一笔交易带来的 “非经营亏损” 便高达 11 亿元之巨——类似的故事在海航集团此后近十年的并购扩张中不断上演。

就在海南航空报出巨亏的 2008 年，海航集团雄心勃勃地推出了打造 “物流航运业务” 板块的发展规划：计划五年内打造规模达 200 艘的远洋运输船队，并展开全球集装箱运输业务。

而支撑这一计划所需的巨额资金，则来自其 2009 年收购控股并拟推动上市的造船企业金海重工。

为此，海航集团一手投入数十亿资金收购金海重工股权，另一手给出高达百亿的造船订单，令多年巨亏的金海重工在首轮私募融资时便获得高达 118 亿元的估值。

然而，海航管理层这次 “赌错了” 航运市场复苏周期：随着 “4 万亿” 投资刺激下短暂反弹的航运市场再度下滑，造船和航运业务的双重亏损，堵死了金海重工上市融资通道，再度令海航陷入 “四面楚歌” 的狼狈处境。

此时旗下已经拥有多家上市公司的海航集团，再度展开高达百亿规模的 “资本腾挪”：旗下天津海运（现名天海投资）和渤海租赁（现名渤海金控）先后宣布总金额超过 200 亿元的定向增发和重大资产重组。（参见南方周末 2013 年 9 月 20 日报道《跨国扣船事件背后的资本暗战 海航金“船” 脱壳》）

这两家 “异军突起” 的上市公司，随即成为了海航新一轮并购扩张的“主力军”。

### 狂飚突进

2011 年 5 月海航资本（原海航实业）将旗下渤海租赁资产注入上市公司 ST 汇通，原来资产仅数亿元的水电设施企业摇身一变成为了净资产六十多亿的 “融资租赁第一股”。

在借壳上市前两年，渤海租赁以项目和房产抵押等方式融资近 150 亿元，将母公司海航实业的资产负债收购殆尽，一举化解了此前大新华航空上市失败留下的巨额负债。

上市两个月后，公司出资收购海航香港全部股权，将集团前期飞机收购中的负债也一并承担下来。两年后，渤海租赁再度出手，以 81 亿元出资接收了海航集团境外并购的集装箱租赁企业 seaco SRL。

两次收购出资总额高达 105 亿元，在母公司海航集团 “转手倒卖” 获利近 15 亿元的同时，也令渤海租赁总负债剧增至 362 亿元。（参见南方周末 2013 年 10 月 18 日报道《上市公司 “双重关联交易” 的秘密 海航关键“棋子”》）

负债累累的渤海租赁随即展开一系列跨境并购，收购多家集装箱和飞机租赁企业后，至 2016 年已形成管理飞机近 900 架（全球第三）、集装箱合计 403 万 CEU（全球第二），总资产高达 2166 亿元的 “庞然巨物”。

2016 年 1 月，渤海租赁改名为渤海金控，变身为海航集团 “金控平台”。在一系列重组并购下，该公司已拥有天津渤海、皖江租赁、横琴租赁等多家地方金融租赁平台，并参股渤海人寿、联讯证券、天津银行等金融机构，以及聚宝互联、点融网等互联网金融平台，成为一家融资触角无所不达的 “类金融控股平台”。

此时公司净资产仅为 311 亿元，2016 年净利润 23 亿元，净资产收益率仅为 1%，甚至不足以偿负其高达 1800 亿元负债的利息。

而据媒体调查显示，渤海金控旗下 Avolon 对美国飞机租赁企业高达 103.8 亿美元的收购资金中，“不超过 85 亿美元” 来自境外银行摩根士丹利与瑞银。

令人不解的是，过去一年中，多家券商及研究机构对渤海金控这一 “高负债、低收益” 并购扩张经营风险视而不见，仅凭被收购企业并表带来的利润增长，便一路看好公司“后续业绩增长”，并给出远高于公司市值的“增持建议”。

同样诡异的 “资产规模膨胀” 与“主营业务转型”也出现在集团旗下另一家上市公司天海投资身上：原名天津海运的这家上市公司，曾被外界视为金海重工上市失败后，海航重组旗下海运物流业务的核心平台，并于 2013 年定向增发 120 亿元，拟收购大新华物流旗下船舶资产。

在经历了两年入不敷出的惨淡经营之后，2015 年天津海运 “华丽变身”：宣布更名为天海投资，并将业务由单一集装箱船舶运输转向 “多业务船舶运输及物流上下游产业”。

当年总营收 7.2 亿元，净利润 2.5 亿元的天海投资，随即向同年营业收入 430 亿美元的国际 IT 产品分销巨头英迈发起了 “蛇吞象” 式的并购。为了筹措高达 60 亿美元的并购资金，天海投资变更前期募集的 120 亿元定增融资，最终于 2016 年底实现对英迈国际的收购，同时剥离部份海运业务资产，一举转型为“高科技跨国企业”。

值得关注的是，招商证券 2017 年 3 月的研究报告内指出，天海投资此次收购得到了国内资本市场著名 “玩家” 刘益谦旗下国华人寿的“深度参与”，并明确指出通过参与定增和委托银行贷款方式，国华人寿在收购中“合计投入 133 亿人民币”。

借助国内险资实现 “空手套白狼” 式跨境并购的天海投资，总资产迅速由 2015 年的 127 亿元膨胀至 2017 年的 2314.4 亿元（预估）。

然而蹊跷的是，据长城证券 2017 年 11 月研报数据，公司总负债竟然也从 2015 年的 4.7 亿元，飚升至 2017 年的 2314 亿元（预估）。这意味着公司净资产几近为零，天海投资变成了一家全部由负债构成的 “壳公司”。

面对这一堪称荒谬的资产负债表变化，长城证券的分析师似乎并不在意，而是着力推荐他们所理解的 “航空业场景 + 云计算平台” 的“高科技前景”。

此时，天海科技在一系列令人眼花缭乱的宏伟蓝图中，无意间透露出更加庞大的收购重组计划：在 “海航云” 全球落地的规划中，预计估值超过 28 亿美元的瑞士航空服务商 Swissport，斥资 65 亿美元获得控股权的希尔顿酒店集团，以及花费 14.5 亿美元收购股权的瑞士机场零售商 Dufry，都将成为海航 “云战略” 的一部份。

如果不出意外的话，这些高达百亿美元规模的海外资产，未来还将通过重重复杂的跨境股权结构安排，由天海投资的市场化股东们一一 “消化”。

而为了实现这一 “海航云“战略整合落地而需付出的后续成本，以及” 海航云”模式在未来全球 “云计算” 市场中的竞争力，则远在证券分析师们的视野之外。

### “红舞鞋” 与新周期

回顾海航集团过去十余年中的多轮并购扩张，除了早期为了生存而被迫收购地方航空公司之外，2004 年之后的海航似乎被套上了一双安徒生童话中的 “红舞鞋”，在越滚越大的负债与不断爆发的危机中不停奔跑。

2004 年到 2008 年期间，海航的多元化战略几近失控，旗下囊括了航空、商业、物流等八大业务板块，子公司总数超过 700 家。在通过大新华航空上市整合业务的努力失败后，海航随即陷入了经营危机。

就在这一生死关头，“四万亿 “刺激政策及各地方政府与银行联手“放水”，为此后数年的中国经济体系内增加了数十万亿规模的货币供给。海航立刻抓住了这一机会，以不断并购中迅速扩大企业规模的同时，再度以上市公司报亏“撇账” 的方式，一举摆脱了前期坏账。

但在这一轮扩张中，海航寄予厚望并投入巨资打造的物流业务板块，再度随着市场周期下滑与上市冲刺失败，而陷入新的巨亏之中；而集团在 “豪赌” 物流业务过程中，与外部投资者所设下的 “对赌式” 融资协议，成为令其被迫展开新一轮并购的资本压力。

2012 年前后海航经历了一轮大规模收缩重组，撤销多个区域总部、关停 200 多家企业并将其八大业务版块收缩至五个。

但就在此时，金融监管体系 “政策松绑” 所催生的金融混业形态，再一次将中国金融市场推入规模空前的广义信贷膨胀与 “资产泡沫化” 进程，存在多年的 “土地证券化” 融资模式也在 “大资管” 市场催化下，变成了几近失控的“货币创造机”。

短短数年内剧增近百万亿规模的银行资管与理财资金，与估值膨胀至 270 万亿元规模的房地产市场相互激荡，催生了规模空前的资本泡沫与影子银行体系。

在这一背景下本已进入收缩调整周期的海航再次抓住机会，借助新机场扩建与 “造岛模式” 带来的新增土地资源，继续以 “土地银行” 模式展开一系列境内外“超级并购”。

然而，在连续两轮信贷膨胀推动下的产能过剩，已经无力再支撑这场 “泡沫游戏”。

经济学家、原央行货币委员会委员樊纲指出，2008 年国内统计钢铁产能过剩时，是 4 亿吨需求，6 亿吨产能，“三分之一过剩”；而到了 2011 年 “四万亿” 刺激计划推出后，变成了“6 亿吨需求，12 亿吨产能”。

迅速膨胀的地方债务推动下的资产泡沫，在带来社会成本急剧增长，社会整体生产率大幅下滑的同时，令整个社会经济体系不断 “脱实入虚”，陷入依靠杠杆融资维系的“资金空转” 困境。

樊纲坦言，如果没有房地产限购和金融 “去杠杆” 的政策，“房价飙升、炒房团满天飞”的房地产狂欢可能持续两三年甚至更久，之后就是资本市场崩盘与真正的金融危机，“中国经济别说恢复增长，是否出局都不知道”。

十九大之后推出的一系列金融监管政策，正是为了通过未来数年 “资产负债表收缩” 的危机应对与调整，为中国经济未来 20 年乃至更长远的健康发展赢得历史机遇。

在新的政治经济周期下，草莽式的混业金融业态正面临着统一监管的新约束，负债式收购的 “转杠杆” 滚动模式已无法持续；信贷资金回表对银行带来巨大不良资产压力，逼迫银行们不断收缩信贷规模；以房地产为代表的资本市场，在统一监管的短期限制和租贷并举长效机制下，也将在整体上进入资产价格平稳下行阶段。

面对这一轮全新的宏观经济背景，过去十余年中以持续不断的 “负债式收购” 扩张到今天的海航们，是到脱下那双 “红舞鞋” 的时候了。

### 海航调查报道手记

2 月 5 日上午，我在给编辑顾策的海航调查报道发稿邮件里写道：

“这次对海航整体资本运作模式的梳理，实际上就是我在 2013 年写 “海航金蝉脱壳” 时想做而没来得及做的事。

但在经过三年市场变化，尤其是去年开始的金融监管政策转向后，这个解释框架就更有说服力了。它实际上不仅针对海航，而是包括万达、复星等企业在内共同的游戏玩法。

第二篇配稿中把这个玩法得以成立的宏观经济背景也做了介绍，从这个宏观背景来理解，海航们的选择有它的合理性——其实就象过去十多年你只要敢借钱买房就会发达一样。”

我在邮件中也提到，因为篇幅所限，还有更多的局部分析没法展开：比如国开行的角色，地方政府的角色，外资投行们的玩法等等。这些 “局部分析” 只能等以后有机会再借别的报道慢慢解释了。

实际上在两周前编辑询问我意见，我断然放下操作中的另一篇报道转而投入 “海航调查” 时，心目中已经有了一个清晰的打算：这次我要写的不是“海航事件”，而是“海航模式”。

对 “海航模式” 的关注，可以追溯到 2011 年底 “解密海航” 专题的报道操作。在那一组报道采写过程中，我基本上对海航从股权变化到资本运作的 “实体运营” 路径有了整体上的认识，但是对这一系列资本运作背后的商业模式及经济逻辑，其实还缺乏深入理解。

更重要的是，我对于这一微观层面的企业运营逻辑，与宏观层面的货币金融政策与经济趋势变化之间的互动与反馈，更加缺乏认识。

直到 2013 年下半年，连续两篇海航扣船事件背后资本运作的追踪报道操作，让我从上市公司这一 “信息窗口”，得以更加深入了解海航系“资本黑箱” 的一些关键运作模式与操作手法，同时也意识到彼时的海航正处于前期高速扩张失败后的 “危机收缩” 阶段。

此后两年间，对央行货币政策转向，以及国资、土地等体制改革的报道操作，意外地为我打通了理解从 “土地（资本）增值” 到“货币超发”（实质上是广义信贷膨胀）之间关联变化的一个全新观察视角。

在这一视角下，原本看似没有直接关联的 “宏观经济”（货币金融）与作为企业资本基础的 “要素市场”（土地、能源、利率等）之间，通过资本市场估值体系的膨胀与扭曲，竟然形成了一个空前庞大的 “自反馈系统”。

对于这一 “微观 - 宏观” 系统反馈的观察与理解，直到 2016 年年中写《中国式影子银行的跨界套利游戏》以及其后《从 “外储货币” 到“土地银行”：货币 “超发” 之谜》时，才终于形成某种“阶段性的总结”。

也就是在那时，我开始坚信中国的房地产调控政策，必然成为金融监管当局正在建构的 “宏观审慎政策” 体系的一部份，而对房地产市场短期调控和长效机制的形成，势必对已经过度膨胀的资本市场估值和杠杆融资体系，带来远超市场预期的收缩效应。

这一宏观经济体系 “去杠杆” 的效应，体现在金融资本市场的 “中观层面” 就是监管政策体系重塑以及市场内部 “杠杆通道” 崩溃的过程；与此同时，通过前期 “圈地” 获得大量土地估值溢价的企业们，也会通过包括境外收购等种种方式，把大量 “账面财富” 转换成更具资本权益保障性的“真实资产”。

这种宏观审慎 “政策转向” 与微观资本 “杠杆崩溃” 之间的矛盾与冲突，常常被秉持 “自由市场” 理念的研究者们，视为 “公共权力” 对“私有产权”的粗暴侵犯，也因此引来市场各方的批评与质疑。

但我要说的是，在过去二十多年的报道观察中，我发现今天社会公众所以为的 “国有” 或“公共”土地与要素资源，直到今天为止并没有实现张五常等制度经济学者们所强调的“产权的清晰界定”。

一块土地的所有权，并不等于它的开发权、抵押权、收益转让权乃至 “临建权”——而这些不同层面的“产权剥离”，正是许多“制度套利” 型企业在跟地方政府合作过程中的“暴利之源”。

这方面我还没有看到真正从经济理论角度进行系统分析与解释的文章。但我可以肯定的是，被以为或自以为拥有城市土地等关键要素资源的地方政府们，在为了 “招商引资” 而廉价出让土地资源的时候，并没有意识到这些土地的“增值收益权”，应该属于包括城市居民在内的所有公众，而不是某些许下诱人承诺的企业控制人。

在这方面，中国的产权制度与经济管理体系内依然有着诸多需要补全的 “体制短板”。

从这个角度而言，可以说过去三十年中，正是制度经济学所谓 “公地悲剧” 带来的巨大 “租值耗散”，成为了相当一批“市场要素掠夺型” 企业（圈地、抢金融牌照、争夺上市指标等等）造就其 “不败神话” 的真正源头。

这也正是我在两年前的 “宝万之争” 报道操作中，与部份师友出现争议，乃至激愤地写下长篇报道手记的原因所在。

在过去二十年中，此类 “企业神话” 我已经看得太多了。而在中国国情所决定的产权结构与政经体制约束下，简单地以 “自由市场理念” 来衡量政府行为，并将所有试图约束 “公共租值耗散” 的政策视为“干涉市场”，其后果只能是用本该由社会公众分享的福利增长，为某些人或企业惊人的财富聚集“买单”！

在今天依然存在着大量监管空白与制度缺失的市场规则体系下，这些企业或个人的做法或许是 “合法” 的，但我并不认为它是合理的。

需要澄清的是，我这里所描述的只是自己的观察所见，而并非定义 “好人” 与“坏人”的价值判断。正如我在 2013 年海航报道手记中所说，“财技精妙”甚至利用规则缺陷而获利并不是什么坏事，身为记者应当关注的是企业获利过程中是否符合“市场游戏规则”，以及相关制度规则可能的缺陷。

2016 年年中我所做的两组报道：九鼎调查与 “宝万之争”，从某种意义而言恰好是极度压缩与夸张之后“海航模式” 的“上半场”与“下半场”。

海航此前十余年的并购扩张，本质上就是通过将低价获得的要素资源通过资本市场估值转化为激进收购的扩张资本。如果把这十多年的并购压缩到两年时间里，从资本运作角度而言就是 “九鼎模式 “。

而宝能对万科 “蛇吞象” 式的并购，其要义在于将已经 “虚增估值” 的要素资源（土地、万能险）转化为借贷资本，从而实现对更大规模 “安全资产” 的控制，并借此实现新的资本腾挪。而海航、万达们看似复杂的跨境收购布局，说到底也不过就是这样的“资产置换”。

出于这一理解，我对此前万达巨资出让旗下资产的消息，第一时间的判断就是 “转杠杆”。但当时我没有想明白的是，象融创这样的企业，为什么会敢在这个时期 “接飞刀”，并且对其后续运作充满了好奇。

而随着乐视这把 “飞刀” 的落下，我猜或许孙宏斌先生也就是再一次 “赌错周期” 了吧——所谓 “宏观套利型” 投资，赌的其实也就是这点事儿。

对于此前十五年间，两轮经济过热及其带来的信贷膨胀与产能过剩等种种现象，我之前一直认为是高层 “决策失误”。但年初樊纲老师在做中国经济分析时，提出的“代际差异” 又给我带来了一个全新的理解角度：整整两代人在 “收入高增长” 和“维系低消费”之间所形成的巨额 “居民净储蓄”，及其所带来的种种货币金融市场扭典现象，不是靠某个“宏观决策” 就可以简单化解掉的。

在这方面还有许多需要学习和理解的内容，但樊纲老师的那句提醒：“不要把所有问题都推到体制头上”，以后当深以为诫！

在 “海航危机史” 的初稿里，我写了两段关于日本经济转型的 “前车之鉴”，编辑调整时删掉了这两段话。开始我觉得有些可惜，后来想想也没错：如果没有足够篇幅来把相关背景解释清楚，没头没脑的扯两句“日本教训” 反而让读者更摸不着头脑。

这里大概写写我自己的思路，以做日后参考。

对于日本经济 “失去的二十年” 有很多解释，但野村证券研究所首席经济学家辜朝明在《大衰退》一书中提出的“资产负债表衰退”，给我留下了深刻的印象。

在 1980 年代末期，同样经历了三十余年高速增长，以及狂欢式海外并购的日本经济学界，曾经有过 “日本不一样” 的各种乐观论调：日本经济过热不叫过热、日本的资产泡沫也“不一样”…… 最后事实证明，泡沫就是泡沫，没有什么不一样。

而在金融泡沫崩溃之后，日本金融与实业界长达十余年的 “资产负债表衰退” 与修复，恰好令其错过了全球经济体系 “第四次工业革命” 的关键发展时机。

在写全球液晶产业迁移的京东方报道，以及对集成电路产业爆发的资料搜集与阅读过程中，我意外地发现曾经在汽车和电子产品领域领先全球的日本，恰好是在 “失去的二十年” 中，陆续失去了其全球领先的产业角色。先被韩国和台湾，然后被中国内地所超越。

而我们在做中国经济报道时，从 2012 年开始，就每年追问和寻找中国经济的 “新动能”。直到最近两年明显感觉到以数字革命为代表的 “新动能”，从经济规模和产业拉动体量上，都开始接上了因产能过剩而失速的宏观经济增长 “这一棒”。

在我看来，这一宏观产业动能的顺利转换，也是让中央政府最终下定决心出手收拾 “金融风险” 的决策关键所在——过去数次宏观调控的决策，都是因传统经济体系失速，以及外部风险爆发而被迫中断。

所谓宏观经济 “去杠杆”，实际上就是整个社会经济体系的 “资产负债表收缩”，在这一收缩过程中如果没有新的增长动能支撑，内部投资的萎缩加上外部情绪的转换，很容易就会让有计划的 “收缩”，变成一场失去控制的 “溃散”。

从这个意义而言，我相信海航们不会是下一个雷曼，但新的挑战与风险会来自何方，依然需要谨慎观察与继续守望……
