---
layout: post
title: 独家|新冠病毒基因测序溯源：警报是何时拉响的 （财新网报道）
categories: Archive
date: 2020-02-27
tags: 新冠肺炎
image_feature: ""
description: 种种证据显示，在去年12月底之前，有不少于9名不明肺炎病例的样本被从武汉各医院采集，基因测序显示病原体是一种类SARS冠状病毒，这些检测结果陆续回馈医院并上报给了卫健委和疾控系统。直至1月9日，央视报道，“武汉病毒性肺炎病原检测结果初步评估专家组”正式宣布病原体为“新型冠状病毒”。
---

原文来自财新网：~~[新冠病毒基因测序溯源：警报是何时拉响的](http://china.caixin.com/2020-02-26/101520972.html)~~

【财新网】（记者 高昱 彭岩锋 杨睿 冯禹丁 马丹萌）

---

追根溯源，截至2月24日已致2660多人死亡、77000多人确诊感染的新冠病毒，这种与SARS相近的新型冠状病毒何时被发现？财新记者通过多方采访，并梳理相关论文、数据库资料印证，使信息拼图逐渐完整地浮现出来。

种种证据显示，在去年12月底之前，有不少于9名不明肺炎病例的样本被从武汉各医院采集，基因测序显示病原体是一种类SARS冠状病毒，这些检测结果陆续回馈医院并上报给了卫健委和疾控系统。直至1月9日，央视报道，“武汉病毒性肺炎病原检测结果初步评估专家组”正式宣布病原体为“新型冠状病毒”。

## 首例12月27日即出结果

2019年12月15日，一名65岁的华南海鲜市场男性送货员开始发烧。12月18日，他来到武汉市中心医院本院（南京路院区）急诊科看病，医生怀疑可能是社区获得性肺炎，将其收治入该院急诊科病房。社区获得性肺炎是一类由细菌、病毒、衣原体和支原体等多种微生物所引起的肺炎的泛称，主要临床症状有咳嗽、伴或不伴咳痰和胸疼。

12月22日，这位病人病情加重，进入ICU，医生们使用了各种抗生素治疗无效。武汉市中心医院呼吸内科主任医师赵苏教授告诉财新记者，12月24日，呼吸内科一名副主任医师对这位病人进行了气管镜采样，然后将病人的肺泡灌洗液样本送到第三方检测机构广州微远基因科技有限公司进行NGS检测，希望利用其基于宏基因组学的二代高通量基因测序技术（mNGS），找出病原体。肺泡灌洗是一种清除肺泡内炎性分泌物等、改善呼吸功能的治疗方法，对下呼吸道和肺部疾病来说，肺泡灌洗液中的病原体含量高于咽拭子。

微远基因全称广州微远基因科技有限公司，成立于2018年6月。其招聘广告称专注于肿瘤学和感染病原学精准医疗，拥有基于二代高通量测序技术的测序平台（NGS）。

“自华大基因利用测序技术起家以来，国内大大小小出现了好多家基因测序公司，这些年我们各类医学研讨会上，二代高通量基因测序技术不断被介绍，这些公司也派出医药代表到各大医院宣讲。”赵苏对财新记者说。华大基因（ 300676.SZ ）全称为深圳华大基因股份有限公司，原名北京华大基因研究中心，成立于1999年，先后完成了国际人类基因组计划中国部分、水稻和大熊猫基因组计划等多项具有国际先进水平的基因组研究工作。2017年7月以“基因测序第一股”登陆创业板，是全球最大的基因组学研发机构。

另一位武汉协和医院的医生也介绍，“测一次，600万个碱基序列，3000元，这3000元能查出来病原体究竟是什么病毒或者细菌，就可能救命。”

一般来说，基因测序公司应当在三天后，也就是12月27日反馈检测结果，但微远基因并没有给出书面报告。“他们只是电话通知我们，说是一种新的冠状病毒。”赵苏说。此时这名病人已经于12月25日转入武汉同济医院。

2020年2月21日，这个病例的基因检测信息，被微信公号“微远基因”的一篇文章披露出来。该篇公号文章写道，中华医学杂志（英文版）于1月27日发表论文，介绍新型冠状病毒发现始末，微远基因参与了新型冠状病毒早期发现工作。

前述发表于《中华医学杂志（英文版）》的论文，是指1月29日发表的“鉴定一种能引发人类严重肺炎的新型冠状病毒：一项描述性研究”一文。论文作者来自中国医学科学院/北京协和医学院病原生物学研究所（下称中国医学科学院病原所）、中日友好医院、湖北省疾控中心、武汉市金银潭医院、武汉市中心医院、广州微远基因科技有限公司等单位。微远基因的首席技术官许腾为该论文共同第一作者，CEO李永军和首席运营官王小锐为署名作者。李永军曾任中国医学科学院病原所生物信息分析员。

根据该论文，研究人员收集了湖北武汉金银潭医院5例重症肺炎患者的临床资料和支气管肺泡灌洗样本，进行了病原宏基因组学（mNGS）分析。结果在这些样本中都发现了一种此前从未报告过的、与SARS病毒核苷酸序列相似度达79%的冠状病毒。文中显示，这5名患者的样本中，最早进行基因测序的临床样本是12月24日采集到的一位65岁病人样本。他12月15日发病，症状为发高烧、咳嗽，少痰。18日入院，12月22日住进ICU。16天后仍持续高烧，并发展为严重的呼吸急促。

与上述信息同样高度契合的，是微信公号“小山狗”1月28日曾发布过的一篇题为“记录一下首次发现新型冠状病毒的经历”的文章。作者在留言区自称就职于位于广州黄埔的一家民营企业，文中记录：“2019年12月26日刚上班，还是如往常一样先大概浏览一下这一天的mNGS病原微生物自动解读结果。意外的是，发现有一个样本报出了敏感病原体——SARS冠状病毒，有几十条的序列，且这个样本只有这么一个有意义的病原体。心头一紧，赶紧后台查看详细的分析数据，发现相似度并不算很高，只有大约94.5%。为了确认结果的可靠性，开始了详细分析。探索版的分析结果提示这个病原体跟Bat SARS like coronavirus（蝙蝠类SARS冠状病毒）最相似，整体相似度在87%左右，而跟SARS的相似度是约81%。”

据作者透露，该患者样本的采集时间也是12月24日。文中提到，“前端反馈这个患者病重，着急要检测结果，但是这么一个重大的病原体确实不可轻易报出，中午跟几个领导紧急开了个会，决定继续深入分析，延迟发放报告，同时分享数据给中国医学科院病原所一块分析”。中国医学科院病原所，就是上文提到的《中华医学杂志（英文版）》论文作者单位之一、微远基因CEO李永军曾供职的中国医学科学院病原所，其直属上级中国医学科学院院长是中国工程院副院长王辰院士。

12月27日，该实验室组装出了接近完整的病毒基因组序列，数据同时也共享给了中国医学科学院病原所。“基本可以确认这个患者的样本里面确实有一个跟Bat SARS like coronavirus类似的新型病毒。”文章写道，“当时得到的信息是这个病人回过老家，不排除接触过蝙蝠。意识到了问题潜在的严重性，对实验室做了全面清理消毒，样本无害化销毁，实验操作相关人员进行了相关监测。中午前已经跟医生沟通了，患者也隔离了”。

“应该就是我们首次发现了这个新型冠状病毒吧。”“小山狗”一文还给出了GISAID数据库的截图，“从GISAID数据库网站上提交的数据来看，样本收集时间最早的也是我们。”

GISAID是一个全球流感病毒共享数据平台，科研工作者在注册后都可上传他们提取的病毒基因序列。每个毒株都会有个独一无二的编号，采集时间、提交日期、提交实验室等信息也都记录在案。财新记者核查发现，按照样本采集时间，GISAIDS上最早的一条新冠病毒基因序列是在2019年12月24日采集，并由中国医学科学院病原所于1月11日上传。比对编号、名称等可发现，这就是“小山狗”一文的截图中标记出来的他们公司参与检测的样本序列。

文章还提及，12月27日、28日该公司领导跟医院、疾控（部门）电话沟通，29日、30日甚至亲自去武汉跟医院、疾控中心领导当面汇报交流所有分析结果，“包括所有我们的分析结果以及医学科学院病原所的分析结果。一切都在紧张、保密、严格的调查中（此时医院和疾控的人早已经知道有多名类似患者，我们沟通了检测结果之后已经开始了应急处理）”。

上述已知最早完成基因测序的样本主人，之后在金银潭医院不治身亡。这例12月27日即已检测出新发病毒的研究成果，也未在当时起到任何作用。

## “SARS冠状病毒”引爆社交媒体

事实上，除了已知最早的这一例，2019年12月底，武汉市中心医院还有两例“不明原因肺炎”的患者样本被送往不同机构进行了基因测序。而这两例样本的检测结果，以不同路径对此次疫情的公开产生了重大影响。

12月27日，一名41岁的陈姓男子到武汉市中心医院南京路院区就诊。“他是一个会计，家住在武昌，完全没有去过汉口的华南海鲜市场，大概在12月16日无明显诱因开始发热，最高体温39.5°C，伴有心悸、胸闷、活动后呼吸困难，体力明显下降，先是12月22日在江夏区第一人民医院看病，没有好转。”赵苏向财新记者透露，“他是我们医院一个医生的熟人，27日就转到我们医院来了，也是急诊科收的。”12月27日傍晚，患者在该院呼吸科ICU做支气管镜取样，这次的样本送往了另一家从事NGS检测的北京博奥医学检验所有限公司。

12月30日，北京博奥医学检验所将这位病人的送检报告反馈给了医生，检测结果直接是“SARS coronavirus”（SARS冠状病毒）。

财新记者获得的该份北京博奥医学检验所的检测报告显示，在该名病人的样本中检出SARS冠状病毒和铜绿假单胞菌的高置信度阳性指标。其中对SARS冠状病毒的解释是：一种单股正链RNA病毒，该病毒传播方式为近距离飞沫传播或接触患者呼吸道分泌物，可引起一种具有明显传染性、可累及多个脏器系统的特殊肺炎，也称非典型肺炎。

“他们的基因库不够全，也可能是没做复核，所以犯了一个小错误，实际上跟SARS不是一回事，就是一种新型冠状病毒。”一位基因测序专家向财新记者透露。

然而，就是这份犯了一个小错误的检测报告，却直接引起了武汉医生们的注意，通过社交媒体吹响了对公众的警哨，在一定程度上挽救了相当多人的生命。

12月30日，北京博奥医学检验所的检测报告出现在武汉市中心医院医生的微信中。当天傍晚17时48分，武汉市中心医院眼科医生李文亮在同学群中发布信息：“华南水果海鲜市场确诊了7例SARS，在我们医院急诊科隔离”；19时39分，武汉市红十字会医院神经内科医生刘文在工作微信群“协和红会神内”发布信息称：“刚刚二医院（即武汉市中心医院）后湖院区确诊一例冠状感染性病毒肺炎，也许华南周边会隔离”，“SARS已基本确定，护士妹妹们别出去晃了”；20时48分，武汉协和医院肿瘤中心医生谢琳卡在肿瘤中心微信群发布消息称，“近期不要到华南海鲜市场去，那里现在发生了多人患不明原因肺炎（类似非典），今天我们医院已收治了多例华南海鲜市场的肺炎病人，大家注意戴口罩和通风”——这三位医生此后都遭到警方训诫。

当天，远在广州黄埔的“小山狗”文作者也获知了上述消息，他记述道：“到12月30号的时候，听到消息说类似症状的患者还有挺多个，神经又一下子绷紧了。特别是，大概是30号下午吧，一个友商在另一个患者的样本里面可能也检测到了同一种病毒，但他们直接发了检测到SARS冠状病毒的报告，瞬间把消息给引爆了……友商共享了序列给我们分析，我分析一看，确实就是同一种病毒！潜意识里的第一个想法就是‘这病毒具有传染性’！”

李文亮等人揭开的盖子，让基因公司测序这条线的故事，与另一条临床医生预警的故事产生了交集。在武汉市中心医院的医生们对不断出现的病毒性肺炎病人常规治疗无效、寄望通过基因测序公司寻求答案的同时，毗邻华南海鲜市场的湖北省新华医院呼吸与重症医学科主任张继先12月26日连续接诊了四名不明原因肺炎病例，12月27日，张继先将发现四名“不明原因病毒性肺炎”上报医院，医院上报给江汉区疾控中心。

12月28-29日，新华医院又收治了三位来自华南海鲜市场的病人，他们拥有相似的病毒性肺炎症状。根据《武汉晚报》等后来的报道，12月29日下午1点，新华医院副院长夏文广召集十名专家讨论这七名病例，专家一致认为情况不寻常，夏文广直接向省市两级卫健委疾控处报告。同日上报的还有武汉市中心医院公共卫生科。当日下午，湖北省、武汉市卫健委疾控处通知省、市、区三级疾控中心，新华医院、市中心医院后湖院区收治多名有海鲜市场暴露史的不明肺炎患者，要求启动应急处置工作流程。湖北省疾控中心、武汉市疾控中心会同江汉区、硚口区、东西湖区的疾控中心开始流行病学调查，武汉市金银潭医院业务副院长黄朝林等来到新华医院，接走六位病人，武汉市同济医院亦将前述在市中心医院第一位做基因检测的病人转入金银潭医院。

12月30日，三级疾控中心形成《关于医院报告华南海鲜市场多例肺炎病例情况的调查处置报告》。同日，武汉市卫健委发布内部通知，提及武汉多家医疗机构确实陆续出现多例不明原因肺炎病例，并与武汉华南海鲜批发市场有关联，要求各医疗机构上报近一周接诊过的具有类似特点的不明原因肺炎病人。

这份因为张继先坚持上报而触发的武汉市卫健委《关于做好不明原因肺炎救治工作的紧急通知》，很快被曝光于网上，与看到基因测序报告的李文亮等医生的微信预警一起，让发端于武汉的这场疫情信息第一次传递到外部世界。

## 来自上海的预警

武汉市中心医院的另一份病例样本来自同样毗邻华南海鲜市场的后湖院区，收治入院要更早一天。病人同样姓陈，是一名福建泉州籍的41岁海鲜市场个体经营者，12月20日受凉后出现高烧40°C、全身酸疼发力、咳嗽脓痰、胸闷气短等症状，12月26日在武汉市中心医院后湖院区以“发热查因、肺部感染”住院，12月30日医院对其进行支气管镜取样，呼吸道灌洗液样本中多留了一份放入冰箱在-80°C环境保存。

“之所以多留一份样本，是因为我们跟复旦大学附属上海市公共卫生临床中心（下称上海公卫中心）、武汉市疾控中心等一直有国家重大科技项目‘中国主要自然疫源性病毒资源’的课题合作，合作协议连续签了已经有五年了，武汉市疾控中心负责在华中片区的临床样本和环境标本的采集，定期送到上海公卫中心做病原体检测，他们有生物安全三级（BSL-3）实验室，有高通量测序和生物信息分析平台，而像我们医院是武汉市疾控中心的哨点医院。”武汉中心医院呼吸内科赵苏教授介绍。

12月30日下午，样本由武汉市疾控中心一位主任医师取走。1月2日，武汉市疾控中心另一位研究人员将样本用干冰、铁盒和泡沫箱重重包裹，和其他动物标本一起，经铁路快运送往上海。1月3日，上海公共卫生临床中心张永振教授团队收到样本。这家中心属复旦大学，张永振本人则是中国疾病预防控制中心传染病预防控制所研究员，复旦大学生物医学研究院、上海公卫中心兼职教授，近年来一直在国家自然基金、国家重大专项、国家重点研发计划等资助下从事人兽共患病、中国主要自然疫源性病毒资源的调查等科研工作，包括武汉市中心医院在内的多家医院和武汉市疾控中心以及澳大利亚悉尼大学等均为课题团队成员。

1月5日凌晨，张永振研究团队从样本中检测出一种新型SARS样冠状病毒，并通过高通量测序获得了该病毒的全基因组序列；根据测序数据绘制的进化树，也证实武汉新型冠状病毒是历史上从未有过的。上海公卫中心当日立即向上海市卫健委和国家卫健委等主管部门报告，提醒他们新病毒与SARS同源，应是经呼吸道传播，建议在公共场合采取相应疾控防疫措施。1月6日，中国疾控中心内部启动二级应急响应。

“我们与武汉市疾控中心、武汉市中心医院等一直在合作收集新的自然疫源性病毒，这就是我们的国家重大项目的一部分，包括P3实验室的使用也是获得中国合格评定国家认可委员会评审认可的。”上海公卫中心一位研究员对财新记者说，“我们是常规科研，偶然发现，事关重大，立即上报。”

## 至少九个样本去年底采集送检

财新记者证实，与广州微远基因科技有限公司和北京博奥医学检验所几乎是前后脚，还有数家基因测序公司从武汉医院获得了不明肺炎病例样本。这其中包括2019年12月26日从武汉当地医院收到一份基因测序委托的行业“龙头老大”华大基因。12月29日，华大基因对该病例样本完成的基因测序结果显示，病毒与SARS基因序列相似性高达80%，但不是SARS，而是一种之前未有的冠状病毒。华大基因还用他们的SARS检测试剂盒对病例进行检测，结果呈阴性，否定是SARS。

华大基因一位人士对财新记者介绍，他们12月底对不明原因病毒性肺炎病例的样本进行测序时，并不知情这个病毒在临床上已经造成了很多人的感染，甚至已经有同属一个家庭的聚集性感染。“我们是做基因测序的技术公司，每天会接受很多测序的委托，接触大量病毒，也会发现很多新病毒。像冠状病毒就有很多种，之前包括SARS在内也只有六种冠状病毒与人有关，对人感染性比较强的只有SARS和MERS。当时我们并不知道这个病毒是‘好’是‘坏’。”

华大基因与武汉当地医院有着常年合作，据财新记者调查，武汉当地医院2019年12月至少送了超过30例疑难肺炎的病例样本给华大基因委托测序。华大在其中一共发现了三例属于新冠病毒感染的肺炎，除了12月26日这一例，另外两例分别收样于12月29日和30日。他们将三例类SARS的冠状病毒混装，即将三个病毒基因序列片段合在一起形成了一个混装的病毒基因序列。1月1日，三份样本的检测报告上报武汉市卫健委。1月3日，华大基因对三个样本中的病毒都进行了高深度的全基因序列测序。

财新记者查知，截至2020年1月19日，GISAID平台上共上传有13条样本的新冠病毒基因组序列。除去日本、泰国的三条，剩下的10条全部由中国科研单位上传。从样本采集时间看，最早的是前述2019年12月24日采集并由中国医学科学院病原所上传的那一例。还有8个样本是在12月30日采集的，分别为武汉市金银潭医院与湖北省疾控中心（1条）、金银潭医院与中科院武汉病毒研究所（5条）、中国疾控中心病毒病预防控制所（2条）。此外，中国疾控中心病毒病预防控制所还上传了一条2020年1月1日完成采集样本的基因序列。

与之映证，据《湖北日报》报道，12月30日这天，金银潭医院院长张定宇带领大家采集了该院最早收治的7名病人的支气管肺泡灌洗液，并送往中科院武汉病毒所进行检测。

以行业平均检测周期三天来算，到1月2日左右，上述8个12月30日采集样本的基因测序结果应该已经得出。中科院武汉病毒所在一封公开信《武汉病毒所全力开展新冠病毒肺炎科研攻关》中曾称，12月30日晚病毒所收到金银潭医院送来的不明肺炎样本，72小时攻关后，于2020年1月2日确定新冠病毒的全基因组序列，1月11日上传至GISAID上。

上述《中华医学杂志（英文版）》发表的论文也显示，在2019年12月24日至2020年1月1日这九天内，有五名患者的肺泡灌洗液样本被采集并送去检测分析，并且这五名患者中有两人没有华南海鲜市场接触史。

五名患者中，除上述65岁患者样本，还有三位患者的样本采集时间为2019年12月30日。其中，2号患者是一名在华南海鲜市场工作的49岁女性，她12月22日开始发高烧、干咳，五天后出现呼吸困难并住院，12月29日住进ICU；3号患者同样为女性，52岁，12月22日发病，29日住院，但是她没有海鲜市场接触史；4号患者是一名41岁男性，他12月16日开始高烧、干咳，22日住院——这位也没有海鲜市场暴露史男性显然就是上文在武汉市中心医院就诊的武昌会计；5号患者的肺泡灌洗液样本则是在2020年1月1日采集的，他是一名在华南海鲜市场工作的61岁男性，本人患有慢性肝病和腹部粘液瘤，发烧、咳嗽、呼吸困难持续七天后住进当地一家医院，1月2日开始利用ECMO进行抢救，后不治身亡。

该论文称，一种新型冠状病毒就这样在实验室中被鉴别出来，它与SARS病毒核苷酸序列相似度达79%，在系统发育上最接近蝙蝠所携带的SARS样冠状病毒，但形成单独进化分支的冠状病毒β属毒株序列。在开展了病毒分离进行形态确认与血清学检测后，最终确认新发病原体是一种新型冠状病毒。这种病毒与受体结合的结构域，其氨基酸序列与SARS冠状病毒类似，表明两种病毒可能结合的是人体细胞上相同的受体。

回望2019年12月底至今年1月初的那几天，原本应是决定无数人命运的关键时刻。但彼时，公众对这种病毒日后会引发的后果还浑然不知。

一位基因测序公司人士透露，2020年1月1日，他接到湖北省卫健委一位官员电话，通知他武汉如有新冠肺炎的病例样本送检，不能再检；已有的病例样本必须销毁，不能对外透露样本信息，不能对外发布相关论文和相关数据，“如果你们在日后检测到了，一定要向我们报告”。

1月3日，国家卫健委办公厅发布了一份名为《关于在重大突发传染病防控工作中加强生物样本资源及相关科研活动管理工作的通知》，这份国卫办科教函（2020）3号文称，针对近期武汉肺炎病例样本，依据目前掌握的病原学特点、传播性、致病性、临床资料等信息，在进一步明确病原信息之前，暂按照高致病性病原微生物（第二类）进行管理，相关样本的运输应当按照原卫生部《可感染人类的高致病性病原微生物菌（毒）种或样本运输管理规定》要求进行；病原相关实验活动应当在具备相应防护级别的生物安全实验室开展。

3号文进一步规定，各相关机构应按省级以上卫生健康行政部门的要求，向指定病原检测机构提供生物样本开展病原学检测并做好交接手续；未经批准，不得擅自向其他机构和个人提供生物样本及其相关信息；已从有关医疗卫生机构取得相关病例生物样本的机构和个人，应立即将样本就地销毁或送交国家指定的保藏机构保管，并妥善保存有关实验活动记录及实验结果信息；疫情防控工作期间，各类机构承担病原学检测任务所产生的信息属于特殊公共资源，任何机构和个人不得擅自对外发布有关病原检测或实验活动结果等信息，相关论文、成果发表须经委托部门审核同意。

至于哪些机构属于“指定病原检测机构”，文件并未提及。有病毒学家透露，甚至中科院武汉病毒所都一度被要求停止病原检测，销毁已有样本，“因为按现行《传染病防治法》，开展传染病实验室检测、诊断、病原学鉴定是各级疾病预防控制机构的法定职责，仅有国家和省级的疾控系统机构才有权进行传染病病原学鉴定，中科院武汉病毒所显然不在此列，更何况那些未经授权的商业科研机构”。

或许正因如此，12月30日拿到病毒样本的中科院病毒所，2020年1月1日进行病毒分离，1月2日完成了病毒的基因测序，1月5日分离得到病毒毒株，1月9日完成国家病毒资源库入库及标准化保藏。这些显然日以继夜才能完成的研究工作，迟迟未对外公布，仅仅在2月份面临外界的传言攻讦时，才给出只言片语的披露。

1月9日，央视报道，以中国疾控中心为主的“武汉病毒性肺炎病原检测结果初步评估专家组”确定，病原体为新型冠状病毒，“截至2020年1月7日21时，实验室检出一种新型冠状病毒，获得该病毒的全基因组序列，经核酸检测方法共检出新型冠状病毒阳性结果15例，从1例阳性病人样本中分离出该病毒，电镜下呈现典型的冠状病毒形态。”

1月11日，张永振研究团队将该病毒基因组序列信息共享到“病毒学组织”Virologic.org网站和GenBank上，系全球最早公布该病毒序列的团队。

当日晚，国家卫健委宣布中国将与世卫组织分享新冠病毒基因序列信息。第二天，另外5个来自不同患者的病毒基因组序列由国家卫健委领导的小组在全球共享流感病毒数据库GISAID发布。对于这个向世卫组织分享的新冠病毒基因序列信息到底来自哪家机构？中国疾控中心主任高福回应财新记者称，基因序列来自三方机构，中国疾控中心、中国医学科学院以及中科院三方，此为联合攻关。世卫组织表示，已从中国国家卫健委获得更多有关武汉不明原因病毒性肺炎的详细信息，包括从病例中检测到的新型冠状病毒基因序列信息，这对其他国家开发特定诊断工具有重要意义。

此时再去细究谁第一个摘取了科学皇冠上的珍珠其实并无必要，因为距离第一例基因测序确定新冠病毒，已经过去了15天。

1月11日，停止更新多日的武汉卫健委通报，第一次将“不明原因的病毒性肺炎”更名为“新型冠状病毒感染的肺炎”，称截至2020年1月10日24时，初步诊断有新冠肺炎病例41例。同一天，湖北“两会”召开。至1月17日湖北“两会”结束，这个数字没有增加。

财新记者赵今朝、实习记者黄雨馨对此文亦有贡献
