---
layout: post
title: 腾讯大家｜比病毒可怕：被谣言操纵的人类暴力史
categories: Archive
tags: 谣言
image_feature: "https://i.loli.net/2020/02/20/Y4AeTEUqQFfjJKy.jpg"
date: 2020-02-19
description: "以此文致敬腾讯大家。"
---

~~大家｜比病毒可怕：被谣言操纵的人类暴力史~~

作者 维舟

---

谣言是一种特殊的社会现象，几乎伴随着人类历史始终。

可以说，没有一个社会能彻底禁绝谣言。虽然很多人痛恨谣言，但从某种意义上，一个没有任何谣言的社会才是不正常的。

这是因为，在某个事件发生之后，人们自然而然的心理便是——尽快传播尽可能多的信息。

法国学者卡普费雷在《谣言》一书中就此指出：“谣言总是从公众对事件自发地提出问题而未曾找到答案中产生的。”他概括提炼出一个简单的公式：谣言=（事件的）重要性×（事件的）含糊不清。

但他其实还遗漏了一个维度，那就是时间，因为谣言如果无法澄清，就会随着时间不断发酵。换句话说，如果一件事人们非常关心，但又无法迅速获知明确的答案，那就必定会产生谣言。

由于新的事件总是不断涌现，而又不可能每件事都在第一时间充分供给信息，因而谣言的产生可以说是必然的。

![](https://i.loli.net/2020/02/20/1Y6eEWkVGF8mNBP.jpg)

<figcaption>1894年香港鼠疫的悲剧之一，就是由于文化差异和信息不对称造成谣言，阻碍了有效措施的开展。一位记者曾经报道说：“中国人拒绝让欧洲人靠近他们……宣示说，洋鬼子因各种的理由故意用这些害虫来打击上天的子民……病人否认他们患病，死者被隐瞒，房屋挡起来对抗卫生当局。虽然洋鬼子积极地进行怀柔，但遭遇到的几乎是血战的宣言；少数中国人有勇气劝告他们的同胞，与港英政府合作来对抗共同的危险，则被结群围攻、丢石头，甚至几乎被杀死，而卫生行政人员也在背地里遭受了攻击。”</figcaption>

当然，或许很多人相信，现代技术足以确保真相快速传递，但这么说的人忘了，谣言同样可以利用这些技术手段，因而甚至比以往传播得更快了。

至于“真相”，很多信息说实话你无从分辨是真是假。

所谓“谣言止于智者”，那仅限于那种彼此知根知底、谣言也容易识破的传统时代，在现代社会，即便智者也不可能在自己缺乏专业知识的领域判断正确。

### 谣言是中立的

明了这一点，我们就能理解：谣言其实是中立的，它未必是不道德的，信谣传谣的人，也不见得就是愚昧无知的。

在中文里，“谣言”一词常附有一层道德贬义色彩，“造谣”被看作别有居心，而“信谣传谣”也被视为愚蠢可笑；但在英语里表示“谣言”的rumor一词，仅指人群中未经证实的说法，可能为假，但也未必不真——这层意思，其实与中文里“传言”、“流言”接近，而不是指“有意制造出来的虚假传闻”。英语里的fame（名声、名望）一词，直到19世纪都还有双重含义，既指谣言也指荣誉。

当然，有些谣言从现代理性的角度来看，似乎相当荒诞，无法理解当时怎么会有那么多人相信。

清末民初，东北铁路网初步建成，旅客货物大量流通，与此同时人们的卫生习惯又没跟上，而传统时代的政府又几乎不承担公共卫生职能，其结果，在东北造成鼠疫爆发。尽管中国现代医学先驱伍连德在1911年就深入哈尔滨疫区，在四个月内控制了疫情，然而，当地人并未就此接受相应理念。1920年瘟疫再度爆发，哈尔滨满城谣言，传闻防疫处的职员在井里和面粉里下毒，每死一人，获大洋三元。群情激愤之下，竟然围攻隔离所，接触者被释放，医生受到侮辱，防疫队员甚至被强迫喝消毒水。

1896年末，印度孟买发生瘟疫，由于不了解现代医疗环境，当地人普遍传闻，病人被送进医院后其实是为了杀死他们，以便医生解剖他们的身体。结果数千人逃跑——不仅是为躲避瘟疫，也为躲避他们认为政府要对他们的身体采取的那些措施。

之所以发生这类事，是因为在人们的观念中，那些全身严密防护的检疫人员显得陌生、神秘而可怕，也不知道自己被隔离的家人究竟发生了什么；此时，他们就只能依据自己原有的想法去凭空揣测。

这并不是说中国和印度的老百姓特别愚昧，因为这在每个国家的现代化过程中几乎都曾出现；而这些谣言被记载下来的目的常常就是为了表现民众的荒唐、无知和非理性。

日本在1868年明治维新后，比中国更早走上现代化道路，国民识字率也相当高，但当时人们难以理解的外国陌生新事物接踵而来，谣言也因而特别兴盛。

1877年日本发生霍乱，卫生局干预东京人的生活，这种做法没有先例，又没有几个被隔离的病人能生还，于是关于隔离医院的谣言四起，甚至传闻医生是魔鬼，他们抽取病人的血、挖取眼珠，将活的病人放进棺材后直接火化烧死。

1879年霍乱再度爆发，出现了更离奇的谣言，说当时美国前总统格兰特访问东京的真正目的是为了取霍乱病人的肝脏。此事闹到各地骚乱纷起，日本政府最后动用了军队才镇压下去。

![](https://i.loli.net/2020/02/20/Y4AeTEUqQFfjJKy.jpg)

<figcaption>1879年，美国前总统格兰特与李鸿章。两人见面之后，格兰特受李鸿章之托前往日本，调停因日本并吞琉球而发生的两国纠纷，但未能成功。</figcaption>

要说当时还“民智未开”，那后来“文明”多了的年代也还是有谣言：1923年关东大地震，大众传播几乎陷于瘫痪，人们无法从正式渠道获得消息，于是出现各种令人惊恐的谣言，最初是“富士山大爆发了！”“东京海湾发生海啸了！”最后是“大批朝鲜人来袭击了！”受这种恐惧情绪的驱使，自发组织起来的暴民杀害了多达三千多名无辜的在日朝鲜人。

1945年广岛原子弹爆炸之后，在很长时间里，核辐射的谣传让广岛人饱受歧视，男人到别处找老婆，而当地女孩子为了嫁出去，则想方设法隐瞒籍贯。

1973年的日本早已相当发达，但石油危机袭来，因为传闻没有石油将制造不出卫生纸，日本各大城市竟然出现了哄抢卫生纸的现象。

美国公认是最发达国家之一，然而美国社会也向来谣言不断，只不过它的很多谣言多指向大企业的不良行为或政府秘密。1914年出现了“可口可乐瓶中发现老鼠碎肉”的谣言，虽然未经证实，但此后至少出现了44例同样案件，这个逸闻不仅没有消亡，到后来甚至进入了美国口头传说的传统，流传至今。

1981年又有谣传说宝洁公司标志中，人物头像上的胡须是有数字666，这是基督教中表示撒旦或敌基督的数字，进而声称宝洁10%的利润都奉献给一个信奉撒旦的教派；不堪其扰的宝洁公司在四年后决定在所有产品上取消这一标志。

![](https://i.loli.net/2020/02/20/Vs6OerUQR7Wp28N.jpg)

1989年，美国CBS报道，一些大学实验室通过老鼠实验发现，广泛用以调节苹果成熟期的一种电酰肼Alar可能致癌，虽然事后证明这其实是安全的农药，但这一谣传乍看上去非常“科学合理”，引起巨大恐慌，造成当年苹果大滞销。

虽然美国政府的运作已经算得透明，但毕竟也有很多国家机密，因而一大类谣言就是关于暗中操控的阴谋论。2005年卡特里娜飓风重创美国南部，立刻就出现了一个谣言：堤坝并未崩溃，而是遭到秘密轰炸，目的是摧毁黑人区。

异曲同工的是，当时印尼大海啸发生后，斯里兰卡等地也谣传这其实是美国引爆的海底爆炸造成的，这样美国就可以找到借口派军到东南亚，完全掌控当地命脉。

当然，这类谣言中最经久不衰的还是所谓“51区”，即断言美国政府早就发现了外星人，只是从未公开——这个故事，是无数好莱坞电影中津津乐道的桥段。

也有一些谣言服务于社会控制，旨在让人们不敢打破禁忌与规则。

社会学家费孝通曾说，小时候老家吴江有一些湖南移民住在太湖边，不时就有谣言说这些外乡人会放蛊，说他们晚上会放出纸剪的小人来勾小孩的魂，“我幼年听见了就害怕，甚至不敢单独在床上睡”。这虽然包含了迷信与地域偏见，但客观效果却是防止孩子与外人接触产生的危险。

在美国内战之后，白人骑警和三K党徒在夜间装神弄鬼，以证实白人在黑奴中散布的谣言：如果奴隶们在晚上逃跑，鬼怪和攫人妖就会抓住他们。

这些谣言至少看起来都煞有介事，虽然有时披着阴谋论的外衣，但又显得像是能用一个简单的说法解释你心中的谜团。有时，它能很好地迎合人们内心的恐惧、偏见或愿望，以至被人信之不疑。

1925年德国汉诺威一个食人魔鬼被判处死刑，据说他杀了20多个男孩，切肉卖给民众，虽然这事难以置信，但在那之后好几年里，几乎所有汉诺威人都宁可信其有，坚持吃素。

![](https://i.loli.net/2020/02/20/dSXkvc7tRuB2QPU.jpg)

<figcaption>德国汉诺威连环杀手弗里茨·哈尔曼，于1918到1924期间猥亵、谋杀、肢解了至少24/27名10至22岁的年轻男性。警方确认了24/27起谋杀，但其本人供认了30至50（另有一说50至70）名受害者 。“汉诺威屠夫”的称号来源于他弃尸于莱茵河之前会先将尸体肢解，“吸血鬼”和“狼人”称号则来自他的惯用谋杀手段——撕咬受害者的嗓子。</figcaption>

不要以为我们现在就比他们更理性了，美国学者桑斯坦在《谣言》一书中强调，“每一个异常恶心的主题都会提高谣言在互联网上传播的概率”。

由于谣言往往包含着一个人们高度关切的核心，所以能够广泛传播，造成深远后果，到后来迫使公开渠道不得不出面辟谣或采取行动。

1944年初，仍深陷苦战的欧洲已逐渐看到纳粹德国败局已定，当时盛传苏联将统治整个欧洲，以至于美国总统罗斯福不得不出来说明：“我个人认为这是无稽之谈”，“苏联已得到了相当大一块‘面包’，即便没有更多其他令人头痛的事，这也足以让他们忙上好些年了”。

![](https://i.loli.net/2020/02/20/7FmQfjpzn9TiCMh.jpg)

<figcaption>雅尔塔会议三巨头，P图界最爱用的图片之一</figcaption>

1960年，因为一则谣言说古巴政府准备取代父母的职责，将孩子从家中带走集中抚养，美国发起了一场代号为“彼得·潘”的秘密行动，在两年多时间里将14,000名古巴儿童带离古巴和他们的父母。

谣言常常折射出广泛的社会心理，有时甚至是某种美好的期待。例如1938年日军已侵占山西全省，但太原乡绅刘大鹏在《退想斋日记》中认为他们会一败涂地，因为他发现山西“无论男女老少咸盼日军之败，且谣言日人都死在中国无一人能回其本国也”。说日本人都会“死在中国”显然不实，但却体现出人们的深层心理绝不认同侵略者，无疑也坚定了许多人的抵抗意志。谣言会召唤行动，引发改变。

### 谣言如何改变历史

虽然谣言往往是一种无组织的群体潜意识心理反映，但不可否认，历史上不止一次重大事件都是由谣言引发的。

历史学者苏萍在《谣言与近代教案》一书中研究了晚清的教案后发现：“几乎所有重大教案的发生，谣言作为最古老的大众传播媒介，都起了决定性的作用。”如众所知，义和团事变的重要社会土壤，就是当时华北底层百姓对西方事物的不满与困惑，这表现为当时广泛流传的各种谣言，如1900年京津铁路建成时，北京就传闻“孩子们被埋在枕木底下，或被杀死以加固桥梁”，正是这些促使人们起来“扶清灭洋”。

虽然谣言会一直伴随着人类社会，但如何对待谣言，本身也非常考验决策者的智慧，那些引发重大变故的谣言，归结起来一是因为社会早已处在无法压制、又高度不满的高压锅状态，二是决策者处置严重不当所致。

这方面，被研究得最透彻的无疑是法国大革命期间发生的一系列事件。

法国历史学家阿莱特·法尔热在《法国大革命前夕的舆论与谣言》一书中发现，当时法国的掌权者一方面认为民众冲动、不理智、愚昧无知，另一面又对公共舆论进行严密监控。这就造成一种困境：人们不得不通过非正式渠道的小道消息来了解自己迫切想知道、不如此又无从知道的重大事件。

结果，在后来的法国大革命期间，每一次变故几乎都伴随着谣言。1789年7月14日民众攻占巴士底狱，这一天后来被定为法国国庆日，但其起因也是因为谣传国王的军队将从巴士底狱炮轰巴黎。实际上，1979年伊朗国王被推翻，其导火索也是阿巴丹贫民窟电影院起火所引发的诸多阴谋论谣言。

![](https://i.loli.net/2020/02/20/gkdBZ5bGx8MfwHo.jpg)

<figcaption>在法国大革命中被推上断头台的王后玛丽·安托瓦内特。坊间传说，当大臣告知玛丽：“天下荒乱，百姓无面包而饿死。”玛丽曰：“让他们吃布莉欧好了”（布莉欧是一种甜点）。但是，历史上玛丽没有说过这句话，是后人将愤慨宣泄在这位热衷于打扮的王后身上。而且，后来有史家考证说，王后不仅长期实质救助贫者，根据解密后的通信档案，她与奥地利娘家通信时亦显现出对贫者的关怀。</figcaption>

倾覆英国东印度在印度统治基础的，也是一个谣言：1856年，英国恩菲尔德皇家轻兵器工厂研发的新型P52步枪配备到印度，因其子弹混用牛油和猪肉脂肪成分作为润滑剂，军中的印度籍士兵在接触到新型弹药包后谣言四起，因为印度教徒禁食牛肉，而穆斯林禁食猪肉。人们纷纷传说新步枪的其实是东印度公司一个惊天阴谋：通过玷污他们的信仰来达到让他们改信基督教的目的，这样士兵们将被迫放弃他们高种姓的社会地位。

虽然英国人事实上并无这一动机，但由于军官们普遍忽视基层士兵的想法，谁也没想到，印度人两百多年来对英国的统治逆来顺受，最后竟然为了这样一件小事引爆了规模空前的大起义。

正因谣言在动员民众时有时能形成巨大的力量，因而有些决策者反过来利用谣言。西方早期历史上最出名的一个故事，就是公元64年罗马城发生大火灾，当时谣传这是市民痛恨的皇帝尼禄点火引燃的，但尼禄得知后发起一个反谣言，嫁祸于比他更不受欢迎的基督徒。

![](https://i.loli.net/2020/02/20/hYtix2g89lZVvFu.jpg)

<figcaption>尼禄在罗马的大火中高歌吟唱，是许多画家乐于表现的题材。尼禄被认为是想利用这场大火，将大量地方烧成白地，以便他可以兴建富丽堂皇的金宫。这种描写与事实是否吻合，历来史学家是有相当大的争议的。有史料指出，火灾发生时尼禄并不在罗马城内（但尼禄在得知火灾发生时第一时间的驱车赶赴罗马指挥救灾），且敞开其私人花园让受难的民众进入。</figcaption>

![](https://i.loli.net/2020/02/20/gPGMhu13br2eCH6.jpg)

<figcaption>罗马大火事件后，尼禄下令逮捕基督徒，公开地将他们残酷折磨——史载的惩罚方式包括钉十字架、披兽皮让恶狗咬死、将他们钉上柱子做为蜡烛等。</figcaption>

二战前夕，一架法国商业飞机飞越德国纽伦堡，被谣传是来扔炸弹的轰炸机。法国历史学家马克·布洛赫事后谴责说：“德国当局拥有制止谣言的一些手段，却纵容这种谣传，非但不去辟谣，反而利用谎言作为宣战的借口。”

在俄国历史上，还有一件相当离奇的事：一个身世不明的人物在混乱中冒充伊凡四世的儿子季米特里，竟然在波兰军队支持下，于1605年成功登基为沙皇，还在皇位上坐了将近一年。不仅如此，在他死后，关于他死里逃生的谣言广为流传，只要打着他的旗号，就能纠集起一批人马。1689年彼得一世掌权后，因为推动的改革与传统处处反差剧烈，民间谣传说他其实是个外国人，真正的沙皇在国外旅行期间已经被人掉包了。这无疑反映出当时保守的俄国人对改革的敌视，但问题在于，彼得一世非黑即白的做法也大大刺激了这种谣言的盛行。

在中国历史上很早就注意到了谣言对社会群体的重要性，甚至很可能是最早建立起相应制度的国家。东汉光武帝出身民间，他建立起一个以民间歌谣为郡国长官考绩凭据的舆论监督制度，也称“举谣言”，是中国古代行政监督制度史上的一个创举。

值得注意的是，在秦汉乃至此后的很长一段时期内，“谣言”在汉语里还有一层特殊的意味：它不仅来历不明，而且带有某种预言性质的神秘性，因而民间流传的童谣会被视为是上天的启示。

《喻世明言》第二十二卷就提到南宋权相贾似道上奏皇帝：“谣言皆荧惑星化为小儿，教人间童子歌之，此乃天意，不可不察。”

![](https://i.loli.net/2020/02/20/AE87fqw9kLZJH4s.jpg)

<figcaption>中国古代星占家认为火星在位置及亮度上都常变不定，谓之“荧惑”，象征残、疾、丧、饥、兵等恶象。上图中的荧惑守心天象，是指火星在心宿内发生“留-逆行-留”的现象，在古代中国被认为大凶。</figcaption>

《在缅甸寻找乔治·奥威尔》一书中所提到的，在很大程度上也像是中国以往传统的写照：“缅甸最有诗意和神秘性的预言艺术是民谣（dabaung）。从王朝时代开始，民谣就提供诗歌和韵律形式的预言。它们不是出自智者或占卜者之口，而是由儿童和疯子传唱，有时是以戏剧性的表演来展现。没有人准确地知道民谣来自何处：它们只是出现在街头玩耍的孩子哼唱的小调里，或者出现在荒诞不经的疯子喃喃自语的韵文里。在古老的过去，国王想知道王国将会发生什么事情，会派遣占卜者到市场里搜集民谣，民谣通常会在大变动之前出现。”

也就是说，这既要求决策者了解谣言，同时又得掌控谣言。

在这种情况下，儒家政治思想既把谣言看作是民心、民意的表达，可以论证君主统治的正当性，同时又极为警惕伪造民谣、操控舆论之事，“造谣”就此带上“居心叵测”的恶意色彩。

![](https://i.loli.net/2020/02/20/1H2Pgq9vVMWbDRl.jpg)

<figcaption>经典作品《冰与火之歌》中，有一条主线就是：妖言/谣言最后是否应验</figcaption>

秦汉四百多年里，造作、传播“妖言”是重大罪行，必须受到“妖言令”所规定的惩处；此后历代也大体沿袭，《大清律例》中对“妖言惑众”的惩处仍是极为严厉的。原本“谣言”并不带有贬义，真正贬义的原本是“妖言”，然而在词义演变的过程中，现代汉语的“谣言”往往倒是带上了古人所说“妖言”的那种内涵。

到了现代社会，“谣言”所附带的那种神秘性、预言性早已逐渐消退，那不过是“未经证实的说法”。正如卡普费雷在《谣言》一书中所说的，“谣言的多寡和内容是一个极好的环境晴雨表”，由于“谣言的本质即官方发言之外的发言”，因而越是宽松、丰富的环境，单个谣言可能造成的后果越难引发严重后果。谣言就像洪水，“疏”是比“堵”更可取的做法。

这方面，率先实现现代化的英国可为借鉴。在16世纪的英国，印刷术初兴，尚无现代传媒和专业记者，那时的人们“信谣传谣”，新闻和谣言甚至边界相当模糊。伊丽莎白一世当公主时曾问家庭女教师：“伦敦有什么新鲜事？”当被告知外界谣传她将跟海军上将西摩勋爵成婚时，她答道：“只是伦敦新闻罢了。”

可见在当时，“伦敦新闻”一词差不多就是“谣言”的代名词。

不过，英国人并未去压制这些“谣言”，而相信它也能体现一部分社会真实。托马斯·麦考莱在五卷本《詹姆斯二世登基以来的英国史》中认为，正是通过言语粗糙、尖锐的民间歌谣，民众的爱憎、喜悦和痛苦才得以表达；不读民谣，无从获知民众的历史。

![](https://i.loli.net/2020/02/20/FUP7gWBnphHzSAZ.jpg)

<figcaption>《伦敦公报》（The London Gazette）自1665年11月7日开始刊行，声称为英格兰历史最悠久的报纸，和全英国连续刊行时间最长的报纸。</figcaption>

更重要的是，通过一套市场机制，英国人不仅把这些原本神秘化的谣言祛魅了，而且还把它商品化了。

近代早期的查尔斯·奈特曾写道：“伦敦这个地区是流言的神殿。世界各地的谣言与流言涌进这里，然后，在这个回音室里，经过古怪修饰的回应再回荡到欧洲所有地区。”

《伦敦传》中就此评论：当时的伦敦就像一个回音，“**在这里，一种被称为新闻的诡异商品向四面八方传播”。现代新闻业，就此诞生**。

这也是这段历史最值得我们记取的：对于谣言，与其敌视它，不如正视它，这样，专业的新闻记者才能成为真相的最后守夜人。
