---
layout: post
title: 非典幸存医护者现状：不是说不会忘了我们吗？
categories: Archive
tags: 新冠肺炎
image_feature: "https://i.loli.net/2020/02/16/nPADJI8LWfXczKT.jpg"
date: 2020-02-16
description: "当未知病毒侵袭人类的时候，我们采取了不讲条件的“全民动员”的方式将风险分摊于社会成员。当危机过后，那些曾经恪尽职守，在最危急的关头做出牺牲的人们，有没有得到精神上的抚慰？那些被无辜感染的普通人有没有得到全社会的理解和实实在在的物质帮助？"
---

原文来自「一条」：~~[非典幸存医护者现状：不是说不会忘了我们吗？](http://206.189.252.32:8088/)~~

---


每天一条独家原创视频

《SARS背影——非典后遗症人群纪实》，

是2006年至2009年间，

摄影师张立洁拍摄的系列照片。

她去了废弃的小汤山非典定点医院，

走访了数十个非典后遗症患者，

试图用影像，记录下这群逐渐被忘却的人。

![](https://i.loli.net/2020/02/16/4XYjM6tlUKBLSGy.jpg)

![](https://i.loli.net/2020/02/16/KWgD1NIZCVqOjs7.jpg)

<figcaption>非典后遗症患者</figcaption>

其中，很多是“因公感染”的医护人员，

因为非典后遗症，

他们失去了工作的能力，长期接受治疗，

有些人失去了爱情或婚姻，

最严重的家庭，9口人全部感染非典，

14天内去世了4个……

这些“非典幸存者们“，

转瞬沦为残疾、偏见、失业、贫穷的受害者。

![](https://i.loli.net/2020/02/16/7hiTQSnlGeX3cky.jpg)

![](https://i.loli.net/2020/02/16/TomtReCI59iLZSg.jpg)

<figcaption>非典后遗症患者</figcaption>

张立洁说：

“当未知病毒侵袭人类的时候，

我们采取了不讲条件的‘全民动员’的方式

将风险分摊于社会成员。

当危机过后，那些曾经恪尽职守，

在最危急的关头做出牺牲的人们，

有没有得到精神上的抚慰？

那些被无辜感染的普通人，

有没有得到全社会的理解和实实在在的物质帮助？

非典过后，我们做得并不好，

但这一次，我希望能够有所改变。”

自述   张立洁    编辑   倪楚娇

![](https://i.loli.net/2020/02/16/sym6PT52SivgJlk.jpg)
![](https://i.loli.net/2020/02/16/QNXBtjqc3spW1vm.jpg)

<figcaption>张立洁</figcaption>

我是张立洁，之前长期就职于《中国残疾人》杂志社。2003年非典的时候，我快大学毕业，那年我们都躲在宿舍里，没有答辩。

非典结束没多久，《南方周末》11月的头版刊登了一张照片，是一群在高压舱里做康复治疗的医护人员，他们都有非典后遗症。

这是我第一次听说“非典后遗症”，觉得神神秘秘的。

![](https://i.loli.net/2020/02/16/aNtXrlV5qAudOsU.jpg)

![](https://i.loli.net/2020/02/16/FsjwnAMvpxZ2IbR.jpg)

<figcaption>小汤山疗养院内</figcaption>

### 初访小汤山疗养院

2006年末，我偶然跟着残奥冠军平亚丽去了一次小汤山。

那时的北京小汤山疗养院里，住着正在进行康复治疗的非典后遗症患者，他们都是“因公感染”的医护人员。但当时，都已经停止了原有岗位的工作，“全职”治疗。绝大部分人都有严重的骨坏死症状，以及一些其他的后遗症，如肺纤维化、高血压等。

![](https://i.loli.net/2020/02/16/qO9GjH7ytkpYgri.jpg)

<figcaption>小汤山疗养院内</figcaption>

他们对台上平亚丽说的“身残志坚”的故事没什么兴趣，彼此之间也不说话，整个状态闷闷的。反而是报告结束以后，他们就抓住卫生局的工作人员，或者残联的人赶紧问：“我去哪能够买残摩？”“我这个报销的问题怎么解决？”

我没想到，他们在意的是这么实际的东西。于是，我悄悄留下了坐在我附近的几个人的手机号码。《SARS背影——非典后遗症人群纪实》这组照片，就是这么开始的。

![](https://i.loli.net/2020/02/16/Ok8BI9oPbplEUAW.jpg)

![](https://i.loli.net/2020/02/16/eCfsYjATQpDnI63.jpg)

<figcaption>小汤山疗养院内</figcaption>

### 歧视与偏见

我第一个联络的对象是一个女护士长，她曾经在某大医院的妇产科工作，因为接触非典病人的医疗物品而被感染。

对于采访，她患得患失的心态极具代表性，既希望有人关注，又怕关注多了，医院不满意，给她停药。后来，她打来电话说儿子找到女朋友了，希望不要再公开她的照片，为了儿子她不想再提了。

这些非典时期冲在第一线的英雄人物，从骨干变为毫无用处的包袱，人生轨迹被彻底改变，他们没有得到掌声和赞美，反而不得不活在歧视和无力改变的经济困境之中。

![](https://i.loli.net/2020/02/16/ENYDi3tsJ1cCLxb.jpg)

<figcaption>伤疤</figcaption>

非典刚来的时候，医护人员都不知道这种类型感冒的严重性，只戴着薄薄的一层纸口罩而已。

1981年出生的护士廖颖就是受害者之一，感染时她正在北大医院急诊当班，是最年轻的非典后遗症患者之一。

她偶尔会到小汤山疗养院接受治疗。泡温泉是缓解骨坏死病痛最好的方法之一，同时还能在浮力的帮助下锻炼肌肉，防止萎缩。

那天我去得早，廖颖和病友武震刚泡完温泉要换衣服，我说你们先别换，我马上过去。我就赶快从她们病房跑到后面的温泉房。

我知道她们身上有伤疤，以前也看过，但是一直没有合适的机会拍。她们的病症在骨头上，都是肉眼看不见的，但惟独腿上的两道伤疤是一种明证。

她们两个都做了试验性的骨头填充手术。武震的术后效果很不好，不但填进去的骨头塌了，而且还感染了。

![](https://i.loli.net/2020/02/16/AHtwnTSOjFDQdNy.jpg)

<figcaption>武震</figcaption>

武震原来是北京花乡医院内科护士。非典期间，她刚好在北京大学人民医院实习，接诊病人的时候感染了SARS。

她因为是实习，不能算是正式员工，所以在工伤认定、报销上都发生了一些纠结。

她当时有男朋友，后来因为这个腿的问题，她男朋友的妈妈就说：“先看看吧，看看以后能不能走路再说吧。”

很现实的问题，能不能走路，直接决定了人家能不能跟你继续相处。

![](https://i.loli.net/2020/02/16/eAr9a3kc8bySNg1.jpg)

![](https://i.loli.net/2020/02/16/blehZqPN3xVTEYW.jpg)

<figcaption>针对股骨头坏死的治疗</figcaption>

### 股骨头坏死：不死的癌症

小汤山疗养院里的日子和养老院差不多，会伴随一些治疗，有高压氧仓、按摩、针灸、游泳、spa、温泉等设施。

要治疗多久？效果如何？未来怎么样？当时谁也不知道。

在医学界，股骨头坏死被称为“不死的癌症”。

“人的股骨头就像个圆球，当它发生缺血性坏死后，圆球就不圆了，再也不能转动自如。股骨头坏掉40%后，圆球就不能用了，它会产生塌陷，这一塌就坏了。”北京宣武医院骨科主任沈惠良在接受《新京报》采访的时候这样解释。

我的受访者们这样形容：“你活多久，你就要受多久的痛苦。治这儿了那儿坏了，治那儿这儿坏了，没完没了。”“发作的时候，就跟骨头里长刺一样，连床都不敢沾。”

![](https://i.loli.net/2020/02/16/KEReJGxP9YUqOgo.jpg)

<figcaption>岳春河</figcaption>

### 自我救赎

面对这么大的落差，每个人的接受程度都不同。

岳春河是同仁医院的外科大夫。外科大夫啊，往往是最优秀的一批人。我前后两次见他，简直判若两人。之前他是有很多埋怨、牢骚的，说话也很直，很不客气。

但是当我后来约他拍照片时，他不但变瘦了，人也精神了，更主要的是他的想法完全变了。

他好像挺爱看书的，后来他就在家做饭、接送孩子。我感觉他好像从哲学精神层面帮自己解脱了，他变得感恩了，他甚至感谢这个病，让他停下了匆忙的脚步。

我特别喜欢他在日记里写的一段话：

“苍天在人们前行的路上，用单向透明玻璃将幸福的人与苦难的人分隔开……痛苦的人虽步履艰难，但他们不仅能品尝人生的痛苦，也能看到快乐是什么样子。从某种意义上说，不幸的人生更加丰富。”

![](https://i.loli.net/2020/02/16/ST24g3x7F8pUfGi.jpg)
![](https://i.loli.net/2020/02/16/poIND6n8T3Wy7qR.jpg)
<figcaption>非典后遗症患者</figcaption>

### “不是说不会忘了我们吗？”

这些“因公感染”的医务人员，其实还不是最惨的。他们有工伤的判定，生活上是有一定保障的。但社会上的一些非典后遗症者就不同了。

当年有些人只是去医院拿个药，就感染了非典。没有人能为他们这无辜感染，给个什么说法，所以他们觉得特别冤。即便是换了关节，也不能负重、不能爬楼，勉强可以生活自理，他们感觉完全就被落下了。

我拍照的时候，有一个受访者对我说了一句话让我印象很深刻：“不是说，不会忘了我们吗？可是我们疼得下不了床的时候，大家人呢？”

时间在慢慢冲淡人们对SARS的恐怖记忆，非典五周年之际正值5.12地震、2008年北京奥运会举办之际，人们无暇顾及。

![](https://i.loli.net/2020/02/16/LbhyQgBf7JWEuSi.jpg)

<figcaption>吴如欣</figcaption>

2003年5月，吴如欣被诊断出急性骨坏死和肺纤维化。由于家庭财产纠纷，她和80岁的老母亲被赶出家门，每个月2000元的收入，看病都不够，只能借债度日。

她在照片里抱着一条狗，用狗的体温热敷，起到类似狗皮膏药的作用，来缓解疼痛，又节约药费。

![](https://i.loli.net/2020/02/16/i78fqI3jtbzUQgu.jpg)

<figcaption>许瑞琴</figcaption>

许瑞琴的情况很复杂，她原来是医院急诊科管理护工的一个临时工，非典一来她也顶上去了，结果感染了，后来因为种种原因她的劳动合同就终止了。

当时采访的时候，她的治疗、夫妻关系、金钱的压力……一切都让她焦头烂额。一边是治疗不好的病情，一边是不可能打赢的官司。我要是她，我都不知道该怎么办。

![](https://i.loli.net/2020/02/16/GOFV8192BELXTq6.jpg)

<figcaption>张金萍</figcaption>

1958年出生的张金萍，在治疗其他疾病的过程中感染了SARS病毒。非典痊愈后的第二天，她就出现了后遗症，她先是眼睛干涩，视力退化，随后呼吸急促，心脑血管也出现问题。

她整天整天地靠在床角，没有表情，也不说话。因为疾病，她不能工作。女儿也因为脑瘤手术导致偏瘫，一家人全靠丈夫养活。看不到希望的时候，她会说，她不想等到眼睛失明之后，连自杀的门都找不着了。

![](https://i.loli.net/2020/02/16/ThdP8E1RyZWANOr.jpg)

<figcaption>刘秀芬</figcaption>

生命的无常，在拍这组照片的时候感觉特别强烈。很多家庭都是全家人交叉感染，“完了，家里这事儿大了”都是这种感觉。家里一下摆了3、4个人的遗像。

刘秀芬家中共有9人患非典，她和丈夫都因照顾家人感染非典，丈夫死了，她活了下来。

![](https://i.loli.net/2020/02/16/nPADJI8LWfXczKT.jpg)

<figcaption>张伟</figcaption>

这是张伟和他年近八十的老母亲，2003年母亲刚从非典的鬼门关闯了过来，就卧病在床。张伟自己也有多处骨坏死，但他全天候照顾着母亲，喂饭、导尿、擦身……

![](https://i.loli.net/2020/02/16/A1toIQTB5yZzVGD.jpg)

<figcaption>杨志霞</figcaption>

### “他去了趟厕所，就再也没起来”

最近我在看武汉疫情的报道，有一个治愈的病人在描述患病时的场景，她说“喘不过气”来，我一下就想到，当年一个叫杨志霞的大姐的描述。

她和他弟弟在胸科医院抢救，住在两个相邻的房间。夜里，她都能听见她弟弟在那儿，特别费劲喘气的声音。

在病房里，谁也不敢睡，困了病友间就聊一句，聊到天亮，就觉得又活过了一天。她讲述当中的那种恐惧，那种黑暗，那种无助，我永远记得。

她说她弟弟是1米8多的大个儿，就特别强壮的那种，最后是去了趟卫生间，就再也没有起来。而她老公去世的时候，她都不知道，还是听到楼道里有人喊：“杨志霞，给你爱人火化了。”她才知道的。

杨志霞共有9名亲人感染非典，其中4人死亡。她当时就给我数：“4月21日、4月26日、5月1日、5月3日。”14天，死了4个。

她后来也是股骨头坏死，每个月只有900元收入，还有一个正在念书的儿子，承担不起治疗的费用，最后咬牙把儿子供出来了。

![](https://i.loli.net/2020/02/16/8zZ2nF1SJja57oE.jpg)

<figcaption>非典后遗症患者</figcaption>

很多人会打着“难受”、“残忍”的幌子而拒绝正视他们的存在。难道看不见就不存在了吗？

跟他们相处，最开始会被怀疑，他们对记者没抱多大希望。但我一个外人，一直在问、不断地在拍，时间长了，他们就会觉得你是在努力做些什么的。一个外人的同情和认可对他们来说是一种支持。

最开始的时候，我会觉得我跟人聊一遍，然后人家痛哭流涕的，其实相当于揭了一遍伤疤。但是后来我也在反复思考，可能摄影更多的是一个中间的环节。

白岩松的节目，就是央视的《新闻1+1》，就是因为看到了我的照片，专门做了一期关于他们的报道，对于他们这个群体来说，是一个特别重要的转折点。

![](https://i.loli.net/2020/02/16/E9ba7q3RsYwL8lB.jpg)

<figcaption>小汤山非典定点医院</figcaption>

![](https://i.loli.net/2020/02/16/2rQpOKakAyC3MZY.jpg)

<figcaption>张立洁在现场</figcaption>

### 一切都不曾过去

2009年5月，我去了一趟小汤山非典定点医院，这座医院当时是在7天内搭建而成的，被称为“小汤山奇迹”。当时周围已经矗立起别墅楼盘…… 仿佛一切已经过去。

![](https://i.loli.net/2020/02/16/dNXpSvjZ4D6Oh8P.jpg)

荒草丛生。病房里面很黑，没有任何光线。

![](https://i.loli.net/2020/02/16/f1tRmOPkTzZhVBx.jpg)

你能看到一些当时治疗扔下来的瓶子、罐子。

![](https://i.loli.net/2020/02/16/KbVOD38BeSkW7fp.jpg)

有一间病房，病床、床垫、被子、枕头还都在。经过几个春夏秋冬以后，野草已经从门外面像手一样伸进来了。

![](https://i.loli.net/2020/02/16/hKECX9zB3MRI15d.jpg)

护士站那儿，有很多散落的档案。其中有一张X光片，上面特别清晰地写着2003年5月13号。你能看到一些纤维化的白色痕迹和片子上面尘土起的霉渍，形成了一个双重的效果。

![](https://i.loli.net/2020/02/16/o4t78jrZmOuDyeb.jpg)

我往外走的时候，有一个碎玻璃把我的腿拉了个口子，流了很多血。当时还有点恐怖，担心这里边要有脏东西进去怎么办？

这让我意识到其实我还是挺恐惧这件事的。非典是怎么爆发的？又是怎么结束的？其实我们到现在依然不那么清楚。

![](https://i.loli.net/2020/02/16/7uLqQ3tVYSZv2mp.jpg)

2010年，小汤山非典定点医院被拆除了。但是谁也无法保证非典还会不会再来，正如2009年，甲型H1N1流感在全球的大流行，也正如这次席卷全国的武汉新型冠状病毒。

当未知病毒侵袭人类的时候，我们采取了不讲条件的“全民动员”的方式将风险分摊于社会成员。当危机过后，那些曾经恪尽职守，在最危急的关头做出牺牲的人们，有没有得到精神上的抚慰？那些被无辜感染的普通人有没有得到全社会的理解和实实在在的物质帮助？

非典过后，我们做得并不好，但这一次，我希望能够有所改变。
