---
layout: post
title: 陈纯 | 新冠疫情下的饭圈与公民社会的回光返照
categories: Archive
tags: 新冠肺炎
image_feature: "https://i.loli.net/2020/02/15/iOZQR6lV5oDAb1t.jpg"
date: 2020-02-15
description: "他们对推动渐进的政治转型不再抱有期望，他们更多考虑的是，一旦政治秩序崩溃，从哪里可以产生新的秩序来源。"
---

原文来自「无逸说」：~~[陈纯 新冠疫情下的饭圈与公民社会的回光返照](http://206.189.252.32:8088)~~

---

新冠疫情以来，举国模式的优越性受到了严重的质疑。早在十二月下旬，八名身处武汉不同医院的医生就在自己所在的微信群审慎地发出警报，却遭到武汉警方的传唤和“训诫”，且被央视以“网络不是法外之地”通报羞辱；病毒分离在新年第一周内就完成了，国家卫健委、湖北及武汉有关部门却迟迟未能作出反应，甚至放任武汉市民大搞“万家宴”，导致疫情失控，不得不仓促封城；封城以后，公共交通停止，湖北官员信誓旦旦说物资充足，然而前线医生却要向社会各界呼吁医疗物资的捐助，大量疑似感染的市民得不到治疗，只能自生自灭。

![](https://i.loli.net/2020/02/15/nlMA9QjKWR5sNb4.jpg)

基于此，《纽约时报》专栏作家纪思道怒不可遏地宣称，现在全世界都在为中国的独#裁付出代价。

**与官僚系统的低效无能比起来，这次民间的一些志愿团体有着不俗的表现**：一些海外的留学生，通过网络迅速集结，在短时间内募集捐款、购买物资、联络物流、打通关系，将口罩和防护服等送到一线医院；1月31日，一批由DirectRelief捐赠，由武大和华中科大在北加州的校友会协助通关的应急医疗物资从旧金山飞跃太平洋，直接将20万个医用外科口罩、2.75万双医用手套和4000件防护服送到武汉协和医院；直到2月1日，韩红的基金会往武汉送了七批物资，总共收到1.4亿的善款，由于数额过大，还不得不暂停接受捐款。

![](https://i.loli.net/2020/02/15/agnjVCREGLfybsm.jpg)

**然而，最让人刮目相看的是各种饭圈后援会。**

前面说的志愿团体要么是临时集结起来的，默契度不太高，要么平时活跃度较低，执行能力有限，然而饭圈后援会人数庞大，组织严密，分工明确，平时打榜、控评、反黑，训练有素，纪律性强，到关键时刻，她们显示出惊人的爆发力。

根据微博上的募捐平台“微公益”上不同站子捐款数额的排名，前几的基本都是各种流量明星（个人或者组合）的应援站。而且早在1月21日，钟南山宣布病毒人传人的第二天，朱一龙的公益应援个站就募集到将近18万的善款，购置了30万个口罩、9万片酒精棉片和2000瓶洗手液，22号就送往疫区。

蔡徐坤的官方粉丝团也是第一时间就募集捐款、联系厂家、联系对点医院、找物流、拿相关证明，第一批物资大年初二就抵达武汉的顺丰网点。大部分饭圈后援会都在1月23日开始组织捐款和购买配送物质，反应速度比其他志愿团体要快不少。

**不仅如此，这些后援会的捐款账目清楚，一目了然，且工作细致，确保物资直接送到医院手上，不经过其他组织。**有微博上的人还戏称，TFBOYS后援会在声援武汉的过程发展出了“三\*权\*分\*立”的结构，说不定很快要出现饭圈的孟德斯鸠、卢梭和洛克。

**以“666联盟”为例，这是一个由来自内地、港台和海外等27家粉丝团体组成的饭圈公益联盟**，函括“鹿晗公益联合应援站”、“为王嘉尔打天下应援博”、“李荣浩吧”等不同平台聚集的粉丝群体。

联盟的大部分成员是所谓的饭圈“决策者”，有应对突发事件的经验。她们集结以后，首先认领各自擅长的领域，因为不同饭圈团体虽然功能具全，但也有自己擅长的部分，这次的应援，文案、作图和海外对接都是由不同的团体负责的。她们开了一个666联盟的微信群，确定各种所需物资的医用标准，然后在群里发动各个团体去找货，任何一边有消息马上在群里通气，有困难可以因地制宜地处理，也可以在线上一起解决。

这种组织方式很好地将统一性和灵活性、默契性和广泛性结合在一起。这些饭圈团体之间平时都有联系，具有某种“熟人社会”的特征，但她们的联合能够最大程度地动员世界各地的粉丝，为寻找各种物资提供了更多可能。她们的文案图片是共享的，消息是互通的，但资金是由各家团体自己募集，如何使用也是在内部自发调节，别的团体不干预；随着声援的展开，其中一些团体收到了武汉以外其他地方的医院发来的求助信息，她们对医院信息进行核准后，决定将既有目标拓展，对这些医院进行定点救助。

正是在这样的声势下，有人产生了这样的想法：**经过这一次疫情，说不定官方会看到政府组织工作的薄弱环节，会允许非政府组织发展起来，作为社会治理的有益补充**。有的人甚至幻想，既然饭圈影响如此巨大，饭圈文化也无处不在，那说不定饭圈可以成为未来公民社会的雏形，只要对这些饭圈团体施加引导，它们也未尝不可能成为以后社会自治的基础。

对于有这些想法的人，我要泼一下冷水：**他们不仅不了解公民社会的理念、中国以往的公民社会运动以及中国政治治理的逻辑，也不一定了解饭圈本身**。与其说这次疫情是中国公民社会东山再起的良机，不如说它是曾经的公民社会运动的回光返照。

**公民社会，从定义上来说，是一个政治实体中社会中层组织的总和。**这些中层组织介乎国家与个人、家庭之间，其成员能自由地加入和退出。根据康豪瑟的理论，社会中层组织有四个主要作用。

首先，它们可以承担国家管不了或管不好的，家庭又无法涉及的功能。其次，中层组织可以为组织内部成员的讨论，为中层组织之间以及中层组织与国家之间的对话提供平台。再次，它们能够促进认同感和利益的多元化。最后，民众可以通过中层组织的精英来与国家精英打交道。在安德烈亚斯·威默最新出版的《国家建构》中，他还认为志愿性组织可以帮助建立跨族群共同体和地区的联盟，以促进政治整合和国家建构。

**在中国语境下，“公民社会”一词有特殊的意涵，它曾代表一代自由派知识分子对于政治转型的热切期待，也代表着他们如今的失意和茫然失措。**

在毛时代，☭将宗族组织、江湖帮派和商会基本铲除，再通过各种渗透到基层的组织将民众纳入管控之中，不再允许任何不受国家控制的社会自组织的存在。

改开时期，市场经济的出现使得民众有了一定不受政治干预的空间（尽管是脆弱的），一些自由派知识分子希望这个空间能稳步扩大，最终推动中国政治的民主化。“公民社会”，就是这个扩大后的空间的理想形态。

在公民社会的形成中，公民意识的觉醒、社会中层组织的大量出现是必要的条件，自由派知识分子认为，等到公民意识和社会中层组织发展到一定程度，等民间具备相当程度的议价能力，就有可能对执政☭形成压力，在适当的条件下倒逼政治改革。

前“公\*盟”的领导人许志永是这一条路线的代表人。从2004年到2009年，许志永与郭玉闪等人合作参与了一系列具有公共影响力的事件，如陈光诚案、结石宝宝案、邓玉娇案等。2012年5月，许志永在《中国人.权.双周刊》上发表《中国新公民运动》，提出：**“新公民运动是一场政治运动，中国必然要完成政治文明转型，建立民主法治健全的自由中国。”**在这个旗帜下，许志永进一步推动了户籍教育平权、官员财产公示和公民同城饭醉等运动。他领导下的“公盟”（2010年3月“公盟”改名为“公民”）作为一个民间组织，在这些事件中发挥着不可或缺的作用，也培养了不少下一代的行动者。

![](https://i.loli.net/2020/02/15/AgiZBp6mtNl7Xju.jpg)

**正因为此，许志永的入狱，多少昭示着这一条“公民社会”路线的破灭。**2013年7月16日，许志永以“聚众扰乱公共场所秩序罪”在北京被刑事拘留，来年1月26日，被判有期徒刑四年。“公民”从此消失。接着，郭玉闪的“传知行”、陆军的“益仁平”和李英强的“立人大学”也被强制关闭，这些组织相对更“去政治化”，本来以为可以逃过一劫。2015年，曾经和许志永并肩作战的一批维权律师也锒铛入狱。翌年，《慈善法》和《境外非政府组织境内活动管理法》相继出台，基本上封杀了权利NGO和公益NGO的独立生存空间，一个时代结束了。

**然而“公民社会”的理念并没有随着“公民社会”路线的失败而被放弃。**其后的自由派知识分子，一部分依然愿意通过“启蒙”和“公共说理”来提高中国人的“公民意识”，另一部分开始物色比NGO更有韧性的组织类型并投身其中。他们对推动渐进的政治转型不再抱有期望，他们更多考虑的是，一旦政治秩序崩溃，从哪里可以产生新的秩序来源。

一种不依靠强力来维持的普遍秩序，既需要有能够团结足够数量的人群、能够承担互助功能的民间组织，也需要有能让这些组织之间进行沟通、协调和合作的共享规范。

在托克维尔眼中的美国1830年代，前者是各种基督教会，后者就是“民情”。或许是因为这样，一些自由派皈依了基督教，与其说他们对改变社会心灰意冷，只想求得灵魂得救，不如说他们重新选择了一条曲线救国的道路。

这些心思并没有逃过☭国的眼睛。2018年2月，新的《宗教事务条例》正式实施。同年12月，曾经的70后自由派的代表人物之一、秋雨之福教会的王怡牧师在成都被捕。2019年12月底，王牧师以“煽\*动颠\*覆国家政权”“非法经营”等罪名，被判有期徒刑九年。这两年来，其他宗教也开始变得敏感，宗教类的活动越来越难以公开进行，宗教类的书籍的出版愈发艰难。☭国的意思是相当明确的：它不能接受有不受它控制的组织的存在，更加不会容许其他具有秩序生产能力的组织的出现。

从这个角度去理解疫情宣布以来的治理乱象，那就清晰多了。由于一些医院和医生“越界”向公众求助，也由于一些志愿团体的行动快于当局的反应，起初海内外出现了百花齐放的声援武汉行动。

然而官方的慈善组织湖北省红十字会、湖北省慈善总会、湖北省青少年发展基金、武汉市慈善总会、武汉市红十字会开始垄断救助。这些官办组织强制将捐赠物资统一收集，任意分配，并以不合作或敷衍的态度应付物资的管理和发送，以至于作为第一战场的武汉协和医院只收到红会拨付的3000只口罩，而莆田系下的武汉仁爱医院却拿到了18000只口罩；协和的科室人员前往红会仓库申领物资均被拒绝，而鄂AW车辆的司机可以堂而皇之抱走一箱口罩；协和的医护人员裁减外科手术服做口罩，用医用垃圾袋做防护服，而淘宝、微商、闲鱼居然出现了来自捐赠口罩的货源。

![](https://i.loli.net/2020/02/15/Um2ST73blnVDCwo.jpg)

武汉市委书记马国强在1月27日的新闻发布会上强调过，所有捐赠物资一定要通过红十字会，这是为了“统一归口”，“避免在现在疫情防疫防治的这个过程中由于混乱，被某些人或者一些人来钻空子”。

**所谓的“混乱”和“空子”，无非是怕民间组织和民间慈善行动借机壮大。**一些影响力较大的志愿团体，已经被体制的某些部门找上，这是一种收编的尝试，也是一种监视和防范，尽管这些部门不一定明确向他们下达指令，但这些团体不敢将他们在助力物资过程遭遇到的体制性障碍向媒体透露，或在公开场合谈论，以防惹祸上身。

![](https://i.loli.net/2020/02/15/5kn4CWM9e7UhNVy.jpg)

这几日，网上开始有了针对韩红基金会的各种抹黑，从账目透明度、公益支出的比例到韩红本人的生活作风问题，大概和她流传甚广的那段对官办慈善机构的讽刺不无关系。武汉市市场监督管理局在2月7日发布了一个公告，其中有这样一句话：“对绕开红十字会直接向有关单位捐赠的防护用品，凡涉嫌违法违规的行为我们将依法处理。”已经将秋后算账提上了日程。

在这一片气压之下，各种饭圈团体处于一个什么样的地位？尽管有人拿她们的高效去奚落红十字会的无能，且她们的行动似乎出于高度的自发性，**但这些团体不可能成为真正的“社会中间组织”，也不可能成为创造任何意义上的公民社会。**

如果我们不至于太健忘，就应该记得在去年夏天，各种饭圈后援会就组织过一次规模浩大的集体出征，并创造出了“阿中\*哥哥”这个饭圈的集体偶像。在这次出征中，饭圈目标明确、动员迅速、分工细致、纪律性强的组织特征一样得到了凸显。她们为了翻墙和海外宣传，设立了技术指导、美术组、文案组和翻译组，其他的，屠版、控评、反黑，和平时的“训练”并无不同。

有人认为这种组织特征是中性的，它们既可以被国家主义利用，也可以被用于社会互助的目的，比如这一次的抗疫声援，也有人说两次“集体行动”虽然都来自饭圈，都并不是同一拨人，两拨人之间在价值观上可能差别甚大。



这种说法并不一定符合事实。微信公众号“荒原lab”上有一篇《[一场给武汉的粉圈应援](https://archive.li/o/KscCT/https://mp.weixin.qq.com/s/720ZpvHDYK9xNAH7gQaAcQ)》，其中采访了一个饭圈女孩小Z。小Z坦言自己就是去年饭圈出征的一员，并以此感到骄傲。实际上，小Z参加饭圈出征和这次的声援行动，动机并没有什么本质的不同，都有“替饭圈女孩正名”的目的，让公众知道她们也关心国家大事；除此之外，出征境外社交媒体和声援武汉，也都能为自己的偶像带来正面效应。

小Z的心态具有很强的代表性。**在参与饭圈的行动中，可能会形成一种“集体心理”**，一方面是对一个偶像的狂热的崇拜，这种崇拜超越了一切理性的目的，可以让她们不计较代价，不仅付出时间和精力，而且必要的时候可以撕掉自己平时的人设（比如一个平素温和的人为了偶像和别人撕逼），另一方面是一种投身某个群体的“归属感”，这种归属感同时也带来“同伴压力”，会让参与者做出自己在这个集体以外不会做的事。有的饭圈中人会在饭圈行动以外作出反思，但依然会不自觉地参与到这些行动中，原因正在这里。

![](https://i.loli.net/2020/02/15/iOZQR6lV5oDAb1t.jpg)

**这种偶像崇拜和集体主义可以轻易地上升到“国家”，国家既作为一个偶像，也作为一个最大的集体。**这就是为什么经常说“饭圈”和“小粉红”这两个群体是高度重合和同构的，也是为什么饭圈平时那么去政治化，关键时候却能迅速政治化。

饭圈里面的政治正确并不是欧美的Political Correctness，一些有女权倾向的女性加入饭圈并不能改变饭圈整体的**“父权－国家主义”**倾向。渗透整个中文互联网的“饭圈语言”带着“低幼化”和“拟人化”的特质，这与其说是对“男性气质”的反动，不如说一种语义学的鸦片。

事实上，和她们互动（管理她们）的官方组织对饭圈的文化心理已经了如指掌。武汉的火神山医院和雷神山医院宣布开工以后，央视频道的“疫情24小时”适时开了“云监工”功能，对施工现象进行直播。在评论开始将各种施工车辆拟人化，取上低幼化的昵称以后，该频道很快出现了“叉酱”、“呕泥酱”等图标，粉丝可以帮自己喜欢的“偶像”车辆助力。人民日报的官微也在自己的页面上推出了“挖掘机天团”。

**这并不是当局对饭圈文化的妥协，相反，这实实在在地说明当局在密切监视着饭圈年轻一代的一举一动。**和公民社会的中层组织相比，饭圈团体是不具独立性的。一方面，国家掌握着她们崇拜的idol在中国的职业发展命脉，官方媒体点名批评某个艺人，足以让这个艺人的职业生涯严重倒退甚至画上句号。

这也是为什么参与声援武汉的饭圈女孩，在采访时要拼命强调自己的偶像是正能量的，自己做这些事就是为了传播偶像的正能量。另一方面，她们也经常需要诉诸公权力和官方组织来解决彼此的矛盾，向官微“举报”在饭圈之中的盛行，并不是一种偶然。

有人将饭圈团体类比为托克维尔的基督教会，因为后者也有一些不太“自由主义”的特征，与饭圈类似。如果基督教会可以1830年代的美国社会的组织基础，那为什么饭圈不可以？这其中的差别在于，美国的基督教会尽管很少真正地远离政治，但在政权面前能保持很大程度的独立性，在大部分时候，它们坚持宗教权威要高于政治权威，当国家的法律和自己所理解的圣经教诲相冲突时，它们也很少轻易妥协。相比之下，饭圈女孩早早就宣布“国家面前无偶像”，如果偶像和国家利益发生冲突，她们会毫不犹豫地“脱粉”。

从组织特征、集体心理、价值观念、行为模式、功能作用和独立性来看，饭圈团体都和公民社会扯不上关系，然而它们和国家之间，并不完全是鱼肉和砧板的关系。对于饭圈团体，当局一方面要防范，另一方面也要利用，这就是为什么它们暂时没有遭遇公盟、传知行、立人大学等民间组织被强制解散的命运。

有的饭圈女孩对一些代表官方的组织高高在上颐指气使有意见，对国家“迎合”饭圈女孩的方式不满足，但这样的不满足并不蕴含她们希望或能够使国家往更进步的方向发展，她们更多是想改变她们和国家之间纯粹单方面付出的关系。即使她们和国家的关系发生了变化，国家整体的环境和趋势不会有什么真正的改变。

如果事情有可能是另外一种模样，我更倾向于认为，**国家和饭圈之间，是“互相渗透”的关系**。这种互相渗透的结果我们尚未得知，但饭圈不是没有可能变得比官方更加国家主义，如果有一天，上述的饭圈模式和流量偶像完全脱离，彻彻底底地政治化，那也没什么奇怪的。

饭圈具备轻松跨越美丽新世界和1984的灵活身段，目前它的潜力并没有完全展现，等它真正展现其“主体性”的时候，那应该就是她们用更极端的国家主义来反击官方的时候。如果饭圈能成为产生新的秩序的组织来源，那结果可能和那些公民社会的支持者设想的南辕北辙。

还有一种乐观的可能，那就是饭圈模式的大部分要件都是巧合。只是碰巧各种选秀节目发明了网络投票，百度出现了贴吧，微博开发了热搜、超话和打榜等功能，才培养起了这些饭圈团体强大的组织和动员能力，只是碰巧一部分追星的人也爱国，她们又恰好被官方组织看上，用来作为官民互动良好的宣传。一切都将止步于此。这里面有部分的事实，不过2012年以后，政治的逻辑要按照最坏的情况来设想。

如果这次的抗疫真的能对未来的公民社会有什么帮助，那应该是一种共同记忆的塑造。不是记住我们如何“万众一心”“众志成城”，也不是记住体制所歌颂的那些“最可爱的人”，而是记住我们如何落入今天的境地，记住拯救生命的人如何被荒谬的决策者所牺牲，记住远方的人和身边的人如何被权力羞辱、驱逐、遗弃、非人化，记住活生生的人命如何在无助与绝望之中陨灭，记住一个义人如何被利维坦所谋杀。

正如刘绍华所说，“中国幸存的众人”必须“关注与挖掘历史，明白配合主体意识形态的桎梏所付出的代价”，否则，“当下一次新兴疫情又来危及人口稠密的土地时，这个依然学不会历史教训的政府仍将搭上遮羞布，将依然无法保护你、以及你所钟爱的国与家”。

参考文献：

\[1\] 赵鼎新，《社会与政治运动讲义》，北京：社会科学文献出版社，2006年，第五章第一节，康豪瑟的大众社会理解。

\[2\] 安德烈亚斯·威默，《国家建构》，上海：上海人民出版社，2019年。

\[3\] 参见赵思乐，《覆巢：中国权利NGO的生死劫》，上中下三篇均发表于端传媒2015年9月15日。

\[4\] 刘绍华，《说给幸存者听》，原文链接已被删除。

说明：首发于端传媒，此为修订版，作者授权转载。
