---
layout: post
title: 用额温计测手腕温度，到底错在哪里？
categories: Archive
tags: 新冠肺炎
image_feature: "https://i.loli.net/2020/02/13/x9pEfFiCsURJtKW.jpg"
date: 2020-02-12
description: 此内容因违规无法查看
---

原文来自「iHealth」：~~[用额温计测手腕温度，到底错在哪里？](http://206.189.252.32:8083/%E7%94%A8%E9%A2%9D%E6%B8%A9%E8%AE%A1%E6%B5%8B%E6%89%8B%E8%85%95%E6%B8%A9%E5%BA%A6%EF%BC%8C%E5%88%B0%E5%BA%95%E9%94%99%E5%9C%A8%E5%93%AA%E9%87%8C%EF%BC%9F.html)~~

---

![](https://i.loli.net/2020/02/13/x9pEfFiCsURJtKW.jpg)

新闻中，医护人员用额温计测量腕部温度来进行体温筛查，这个错误的示范被广泛传播了。体温快速筛查是防疫之战的第一道防线，正确测量才能确保我们打赢这一仗。更多人应该明白如何正确测量。

### 为什么额温计测手腕，测不对体温？

新闻中的社区探访用的是红外额式体温计YMITF01（粤械注准20152200352）在地坛医院用得是红外额式体温计MC-720（苏械注准20152070153）都是国家批准的医疗器械。这两款额温计都明确指示了测量部位是前额而不是手腕，请看产品说明附图。

![](https://i.loli.net/2020/02/13/lwmx2j1QeGiVv8r.jpg)

<figcaption>图片来源于网络</figcaption>

**用错误的测量位置来进行体温筛查，会带来更多的错误模仿**。

根据国家《耳腔式医用红外体温计注册技术审查指导原则》、《GB/T21417.1医用红外体温计第1部分：耳腔式》、《JJF1576红外人体表面温度快速筛检仪型式评价大纲》、《GBT19146 红外人体表面温度快速筛检仪通用技术条件》等文件标准的描述：

医用红外体温计是一种通过探测器测量与被测对象之间的红外辐射交换和适当的修正值，输出显示身体某部位温度的一种医用光电仪器。

额温计作为医用红外体温计的一种，其优势是非接触，快速测温。其测量原理可以概括为先采集后补偿。

首先采集额头表面温度数据；第二步，应用补偿算法，将采集的温度数据折算成人体标准测量位置温度（口腔、腋下、直肠）这样才可以作为临床诊断依据。

采集补偿之后的测量体温是否符合临床检验标准，这是衡量额温计准确性的尺子，也是获得医疗器械批准文号的硬性条件。腋下测量的临床数据最多，多数额温计例如九安iHealth额温计，就选择以腋下体温来进行测量准确性校验，当然也有采用口腔温度临床数据的产品。但没有一个产品是用手腕温度来标示体温的，没有一家公司进行过这样的临床数据验证。

### 体温快速筛查，查的是什么？

在当前公共卫生防疫中，体温快速筛查就是通过体温测量查找发热的人，以控制疫情扩散风险。如果体温都测不对，那怎么能实现体温筛查工作的真正目的呢。正确使用额温计，才能筛查出发热的人。

**什么是发热？**

体温，通常分为内核温度和皮肤温度，皮肤温度可在身体各个部位获得，但不同部位的差异较大。在环境温度为23℃时测定，额部的皮肤平均温度为33～34℃，腋下为36-37.4℃，躯干为32℃，手为30℃，足为27℃。临床上通过表皮温度判断发热时，通常以腋窝作为判断，即大于等于37.5℃为发热，超过39℃就是高热。

**为什么测手腕筛查不靠谱？**

临床数据缺失是一个客观事实，发热时人体体温分布不匀是另一个客观事实。从手腕的生理结构看，血管密集，皮下组织薄，血管处与非血管处有明显的温差，经常会超过正负1度，无法输出稳定的测量值，单独评价手腕温度，这本身不具备测量价值。

人体体温波动时，会调节外周血管舒张或收缩，以调节体温。体温上升过程中，由于外周血管收缩，手足（包括手腕足腕）的温度都应该比平时凉，而体温达到低热稳定时，皮肤血管扩张，皮肤表面温度升高，故手腕处的温度有可能比平时高。所以，手腕温度无法准确表达机体在发热时的状态，临床上也从未把手腕温度作为临床判断依据。

**测量手腕做筛查，测量不规范，科学无依据，结果不确定。体温筛查要从正确测量开始。**

### 正确测量才能保证筛查可靠

以九安（iHealth）体温计为例：

**1.尽量在16℃到35℃之间的环境中进行测量，若遇到极寒环境请对机器进行保暖，或设置备用红外额温计替换使用。**

红外额温计对环境要求比较高，最好是在室内无风环境下使用，工作环境一般是在16℃到35℃之间。现在正值冬季，很多地方都是在室外环境使用其进行体温监控，所以容易出现偏差。

在使用间隙，可以将体温计放入口袋对其进行保暖，从而保证在寒冷条件下的使用，或将备用红外体温计存放于温暖环境中，轮换使用。

**2.测量时不要紧贴额头，保持3cm以内的有效距离**

很多人用额温计时都是紧贴着额头，生怕测得不准。实际上，这样测出来反倒不准，存在接触后带凉皮肤的问题。

![](https://i.loli.net/2020/02/13/aAnOZ9mSwXGEPx6.jpg)

**3.如果在入口处测体温，最好等被测者进入室内几分钟之后再测**

从室外进入到室内时，被测者搭乘的交通工具不同，会导致额头温度的暂时性变化，初筛不符合正常范围（偏低或偏高时）应该让被测者在室内停留至少3分钟再进行复测。

**4.定期保养清洁红外体温计非常重要**

特别是室外公共筛查点，应定期对探头进行处理，可以先用气囊或去头的针管吹去探头灰尘，然后再用75%的医用酒精深入探头内部进行清洁，确保没有污物后再消毒使用。

### 重点来了

如何克服天气挑战，保证公共体温筛查质量？

应对室外低温，每天筛查要注意：自测体温做起点，发现异常要复测

如果一直在低温室外测体温，可以考虑先以未发热人群（比如自己或同事）测出一个健康温度的参考温度，将其作为基准，一旦出现明显高于基准温度的，应进行复测筛查。

复测是务必正确测量，确保测量准确性，这样就能有效保障体温筛查工作质量。

向一线防控的所有参与者致敬，在当前的低温天气下日夜值守，构建了公共体温筛查网格。

非常时期，相互理解，相互支持，一起共渡难关，守护我们的家园。

防疫测温，请从正确方式开始！

![](https://i.loli.net/2020/02/13/wz1eQCHO9xPSYuJ.jpg)
