---
layout: post
title: 现场 |火神山开通：病床该留给谁？
categories: Archive
tags: 新冠肺炎
date: 2020-02-05
image_feature: "https://i.loli.net/2020/02/05/NjK2LBxMAZX8HaU.jpg"
description: 病床如何分配又是一个需要考量的问题，外面有着大量住不进院的患者，医务人员本身每天都有被感染的，病床应该给谁？一个病床的处置，在这里都对应着一条条眼巴巴渴求的生命，给谁，又不给谁呢？
---

原文来自公号：~~[三联生活周刊](http://206.189.252.32:8083/%E7%8E%B0%E5%9C%BA__%E7%81%AB%E7%A5%9E%E5%B1%B1%E5%BC%80%E9%80%9A%EF%BC%9A%E7%97%85%E5%BA%8A%E8%AF%A5%E7%95%99%E7%BB%99%E8%B0%81%EF%BC%9F.html)~~

记者：王珊 张从志

---

根据官方媒体报道，武汉火神山医院今天开始正式接诊新型冠状病毒感染的肺炎确诊患者，今日9时许收治首批患者。从1月23日决定建立，仅10天时间就开门接诊，可容纳1000张病床、建筑面积3.4万平方米的火神山医院，给武汉极为紧张的新冠肺炎患者就医状况，带来了希望。

病床应该给谁？一张病床，对应着一个眼巴巴渴求的生命。给谁，又不给谁呢？

这也是本刊记者在武汉多家医院看到的处境，有限的病床，该留给谁呢？更何况，绝大多数医院早已没有多余的病床。在对疫情逐渐有序的应对过程中，一线医护人员和患者仍然面临着严峻的现实。

### 火神山开门了，安排谁转院？

2月3日一早，武汉一家定点医院的协调人徐山就接到了上级的通知，火神山建设完毕，当天有可能安排患者转院。这对大家来说，是吃了一颗定心丸，整个疫情的应对，在逐步往有序的方向前进。

![](https://i.loli.net/2020/02/05/yRDYrjGzkUsuaTW.jpg)

<figcaption>建设中的火神山医院（远征 摄）</figcaption>

接到通知后，徐山和同事迅速讨论了一下。**转院已经是确定的事情，但具体的转院标准，还没有一个详细的阐释，那么应该转什么样的病人呢？**

轻症患者，他们觉得没必要转，医院就能处理和应对；危重症患者，也许没有转过去的必要了，话虽有些残忍，但如何给更多的人有生存的机会，是他们目前所想的。他们更倾向于把机会留给重症病人，“**重症患者，按照他们现在的情况，转到条件好的医院，各种支持条件、设备一上来，他们也许就能挺过这一关。**”

在2月3日这一天，徐山所在的医院，医生一直在病区梳理病人，“重症患者占所有患者的三分之二左右，现在火神山1000张床，我们要把最需要的病人转出去。”这一天，徐山从早上一直等到晚上，就等着一个电话告诉他，“可以转院了”。今天一早，他在新闻上看到有其他医院的患者已经被运送到火神山，“也许别的医院比我们更需要，先转了他们。”徐山仍然在等待中。

![](https://i.loli.net/2020/02/05/jmiplutWTshEr5n.jpg)

这家作为新冠肺炎定点医院的二级医院，目前有200多名新冠肺炎住院病人，其中三分之二为重症。医院于1月22日突然被宣布为武汉市七家定点医院之一，开诊第一天，涌进来的病人太多，他们只能收进重症和危重病人。**由于病床的周转率低，“新病人进不来，旧患者出不去，整个形成了一个堰塞湖现象。”**

本刊记者昨天在医院现场看到，这家二级医院的门诊楼排队的病人依然很多，也有一些已经确诊的病人因为住不进医院，央求医生开药，坐在医院门口的凳子上打点滴。一位患者家属陪着妻子已经来了11天，他们看起来50岁左右。因为交通不便，每天从3公里外的家里走过来，天一亮就出门。他向本刊展示了今天的号码牌，186号，“**医生不会一次性开几天的药，每来一次，就要重新挂一次号，排队两三个小时，拿药也要排两三个小时。**”

### 门外的病人

胡进的母亲坐在沙发上，一动也不动，这是她这几天一直以来的姿势，连睡觉也是，只要稍微动一下，她就喘不上气。她闭着眼睛，好像只有这样才能让她舒服一点。胡进站在一旁，看得眼泪直泛，他已经打遍了武汉所有医院的电话，定点医院，三级医院，甚至偏远到没听过名字的地方，一听到他说母亲可能得了新冠肺炎，有没有床位？对方有些无奈，会问上一句，“有没有做检查？”

检查是做了的。胡进的母亲1月29日，身体开始有些不适，第二天就呼吸困难，走路喘气。1月31号下午，胡进带着母亲到第三医院做了CT检查，发现母亲肺部感染已经很严重。第三医院不是定点医院，接收不了这样的患者。医生嘱咐胡进带母亲赶紧去住院，因为一旦出现呼吸衰竭的问题，她会随时有生命危险。

1月24日开始，武汉市新冠肺炎防控指挥部决定全面实行发热市民分级分类就医服务，由各社区负责，全面排查所服务辖区发热病人，并送社区医疗中心对病情进行筛选、分类；已确定或高度疑似的新型冠状病毒感染的肺炎病人，由市卫健委负责，安排车辆送至指定治疗点治疗。胡进回到家开始给社区打电话。社区却回复胡进必须要先做核酸检测确认病例。为了避免再感染儿子，胡进的父亲不让儿子插手这个事情，前天，70多岁的他扶着妻子走到了湖北省人民医院，又排队等了两个多小时，终于做了检测。

在我采访他之后的当天下午，胡进拨了我的电话，他说母亲的核酸检测呈阳性，这个结果甚至让他和母亲有些欣喜，确诊意味着母亲有住院的可能性了。看着母亲坐在家里却毫无办法，对他来说，那太残忍了。“所有医院都说没有床位，你是记者，能不能帮上忙？”他的声音里急迫又有一丝期待。我好久都没有吭声，我不敢说话，更不知道张嘴能说什么。**从来武汉采访到现在，我看到太多医院门口求助的患者，有人在跟医院争吵，有人苦苦哀求，有人则是沉默。许多人向我们发出求助。物资没了，我们能帮忙去找物资，可在一张病床面前，我竟毫无办法**。

![](https://i.loli.net/2020/02/05/jOVnDe6uColXE2A.jpg)

<figcaption>蔡小川 摄</figcaption>

徐平平的舅舅在住进医院的第三天去世了。1月12日开始，徐平平的舅舅开始发高烧，连续烧了半个月，经检查发现双肺已经变白，还出现了肾衰竭的迹象。在当时，核酸检测还只有疾控中心可以做，他一直申请不上核酸检测，医院排队的患者比他严重的要很多。家里人只好央求医生给他输头孢，一周过去病症没有减轻反倒加重了，呼吸都成了问题，只好买了吸氧机在家里吸氧。在向多方求救之后，终于有了床位。尽管医院进行了抢救，但因为病情进展迅速，一切措施都变得无力了。家里人甚至没有见到他的遗体，也不知道老人有没有火化。

### “医院每天最多门诊1000多人，只能腾出5张病床”

1月30日，王平哭了。他今年44岁，是一家三甲医院的医生。自从带着医院的支援到了现在所在的定点医院之后，王平的电话一直没有停下来过。这里面，很大一部分是向他求助床位的。有的是熟人，有的是朋友的朋友，当然也有陌生人。根据检查，这里很多都是新型冠状病毒感染的疑似患者，其中一个还是四五岁的孩子，“全是这样的电话，我真的爱莫能助，我能帮一个两个已经到极限了，我真的没有这个能力。”有时相熟的朋友说他心硬，他也只能回一句，“**国难当头，只能按次序来。”他藏在心里的一句话却是无法说出口的——按次序也不知道要等到何年何月**。

王平医院定点支援的定点医院是一家二级医院。武汉拥有二级医院接近30家，病床数量在100多张到800张不等，这家医院床位数量在二级医院中处于末流位置。眼前的医院，门诊楼只有两层，楼梯破旧斑驳，看起来还不如一个小县城的县医院。换句话说，在大病小病都扎堆大医院的背景下，基层小医院的衰落都能从我们所在的这家医院里看到。当地一名三甲医院的管理者告诉本刊，这家医院的软硬件条件并不好，院内管理也不及其他二级医院，平时接诊量很小，而且大多是感冒发烧等普通疾病。

此次疫情中，这家医院收治病人200人左右。该院的医生李红（化名）告诉本刊记者，这些已经耗尽了医院的人力和物力，“最高峰时医院每天的门诊量有1000多人次，接近一个普通三级医院的门诊量，80%以上是发热病人。”李红说，因为人手不够，退休的老医生、外科、产科的医护人员全都出来接诊了。

1月22日晚，湖北省肺炎防控指挥部指定包括市汉口医院、市红十字会医院、市七医院、市四医院西院区七家医院为定点医院。按照规定，所有发热在37.3度以上的病人全部到这七家定点医院就诊。这七家医院均为二级医院，根据2019年武汉市卫健委统计的数据，七家医院中床位数最多的是汉口医院和武汉市第五医院，拥有床位量均为800张，最少的是第七医院，只有305张病床。**截至2020年2月1日23:00，这几家定点医院接收的病人总床位使用量为2724人次，包括确诊和疑似病例**。

![](https://i.loli.net/2020/02/05/d7hHanM6LxZ5zuw.jpg)

<figcaption>蔡小川 摄</figcaption>

而另一组可以比对的数据是，截至2020年2月3日24时，武汉市累计报告新型冠状病毒感染的肺炎病例6384例，相比于2月1日的统计增加了2275例。一名三甲医院管理者冯明（化名）告诉本刊，当初政府层面这样设置是考虑到大医院还要收治其他疾病患者，要满足整个武汉的看病需求，所以预计将三级医院的病人全部转到这七家二级医院，“当时看是有一定的合理性，但显然没有考虑到患者的基数。”开诊之后，冯明所在医院的病例没有一例转到其对口支援的二级医院——对方收治当天直接爆满。

按照1月22日收到的通知，医院只接受疑似患者和轻症病人。然而开始收病人的当天，王平等人就发现，这个指令不具备操作性——**按通知医院1月23日开始收治病人，结果前一天晚上7点不到医院门口就是黑压压的人群，重症和危重症患者的数量非常大**。王平始终记得当时弥漫在人群里的恐慌和绝望，“我第一次觉得在大灾大难面前，个人是渺小的。”医院的医生李苏负责的病区最先准备好，最先收治病人。接收之前，他进入病区做最后的检查，却看到有个人坐在病床上等着他，完全不知道是怎么进来的，李苏软磨硬泡地劝了很久，患者才下床去办理手续。

面对医院门口望也望不到头的队伍，在跟同事商量之后，王平等人决定优先收重症和危重症患者，“这些患者不收进来，只会让人群更加恐慌。”李苏所在的病区最初有20多张床位，后来改了隔壁一个保卫室，床位增加到40多。李苏告诉本刊，他的病区除了4名危重症患者以外，病区里的患者以重症为主，其中不少人是有其他的基础疾病。他也面临着与王平同样的问题，每天电话响起来不分昼夜，求的都是病床，他也没有办法。无奈是写在这里医生和患者脸上共同的字眼。“**我们总共就两百张病床，刚一开始接收就住满了，哪里还有床。**”

我们到达这家二级医院当天，医院门口显著位置到处贴着“床位已满”的公告。医院门诊大楼到处都是人，取药和缴费窗口排了长队，输液室一眼望去尽是输液的人、CT室里待取的CT片子堆了几条长凳。不过比起刚开诊收治病人时的情况，医院的拥堵已经得到了很大的缓解，新来的就诊者已经能够进行采样送检，然后回家等消息。李苏告诉本刊，**现在医院每天的发热患者接诊人数仍在700多人左右，少的时候也有600多，四分之三以上存在肺部感染的状况，“可医院每天最多只能腾出5张病床，这里面多是因为去世。**”对于住不进来的患者，除了没有病床，李苏给不出更多的理由。

![](https://i.loli.net/2020/02/05/Q2tVmXdjl7khsb4.jpg)

<figcaption>蔡小川 摄</figcaption>

一张病床，将人的生与死就这么阻隔了起来。李苏提到有一天一个患者去世，病房里空出一张床，外面的患者和家属听到这个消息后，七八个患者和家属开始往里冲，最后各个部门的协调人出来做工作才将一帮人劝了回去，留下了最重的那个患者。这两天因为医疗队的到来，王平所在的医院可能要开一个新的病区，**病床如何分配又是一个需要考量的问题，外面有着大量住不进院的患者，医务人员本身每天都有被感染的，病床应该给谁？一个病床的处置，在这里都对应着一条条眼巴巴渴求的生命，给谁，又不给谁呢**？

### 低防护和救治

**进入医院的救治，又是一场人与疾病和各种客观条件的战争**。病房里的病人要么是确诊患者，要么是疑似病人，他们都有一个共同点，即肺部感染严重，表现出呼吸衰竭的症状，在尚未有特效药物的前提下，充足的氧气量是维持他们生命最关键的手段。“这家医院的中心供氧设施不知道为什么一直达不到标准，打个比方说，病人需要的氧流量是5升/分钟，但是医院的中心供氧只能达到4升/分钟，这导致的直接问题就是病人呼吸不畅，甚至出现休克。”王平告诉本刊，**为了保证病人的安全，他们只好用氧气罐代替中心供氧，但春节和疫情的前提下，根本没有搬运工，只能医护人员自己上**。

一个需要注意的情况是，并不只有王平的医院面临这种困难。我们在许多二级医院都看到医护人员拖着一人高左右的氧气罐往病房里去。这天上午王平就去拖了三次氧气罐。氧气罐更换期间会有短暂的间隙，一名另外一家二级医院援助的医生告诉本刊，有一天在换氧气罐的期间，病人眼看着喘不上气，他即刻拿着氧气罐对着病人吹了一会才缓过来，“我们来之前，病区几天内有7人去世，这几天这个数字没有增加。”

![](https://i.loli.net/2020/02/05/MLzl4qIC21mixUw.jpg)

<figcaption>大量的氧气瓶被送进医院（蔡小川 摄）</figcaption>

一个医生告诉我们，根据他的观察，有些患者最后离世，本身并不是因为病毒的问题，而是得了病之后得不到好的救治，“所以现在的病死率到底有多少，我们觉得很难估算，有些人甚至连医院都没进来，就去世了。”四川华西医院呼吸与危重症医学科副主任罗凤鸣告诉本刊，对于医院的这些患者，每个人的症状都略有不同，对病例的处理和评估几乎完全依靠医生的临床经验，“有些药物可能有用，有些可能没用，用多少，怎么用，都没有规定，只能自己下决定。可能这个药物对一个患者有作用，对另一个患者就没了作用，每个病人都是个体化的，这也是此次病毒要关注的特点。”

这些被感染的患者里，有许多是医院一线的医护人员，“每天都有人感染。”李苏说。王平是1月22日就到这家二级医院支援。刚一来，他就愣住了，这里哪能够做收治传染病人的医院。**按照传染病房的设定标准，病区必须严格划分为清洁区、潜在污染区、污染区。而王平眼前的医院，医护人员和病人来来回回在走廊里穿行，更不要说区域的划分了。医院也没有专门的发热门诊，各个科室的病人混在一起看病**。

“那时，这家医院就有不少医护人员被感染了。”王平说，这一方面是医院确实没有防护资源，防护设备都是他所在的医院来了之后支援的，医生就在没有准备的情况下迎来了几百个病人；另一方面则是防护意识的缺乏，他提到，就在前两天，这家医院有一个病区的医生，发烧之后一直也没有太在意，正常上班，前天确诊了，“他值夜班时，还睡在了别的病区的值班室。”

**王平来的第一件事就是对医院进行改造，努力把污染区和清洁区划分出来，这是很困难的**。医院走廊只有一米多，哪里能隔出两个通道，只能大家走路时注意，隔断勉强做了一些，但远达不到政府要求的疑似病例与确诊病例分开，两类患者只能混杂在一起。好在，医院的内外科门诊、小儿科门诊全部都合并了，只收发热患者，防止医护人员在无意识下被潜在感染者传染。**在改造上，各家医院自我发挥，“难也要改造，没有办法，现在没有子弹，只能肉搏**。”王平说话时俨然已经是一个战士的样子，而他迎接的不是子弹、不是大炮，而是一个个活生生的需要被保护、被救治的人。

### 送不出去的病人

我们见到李小明时，她一直在和王平、李苏讨论一个问题，即要不要在病人住进病区前就提前让家属签病危通知书？答案是一致的——如果不提前签，病人一旦确诊，接触的这张纸都有可能成为传染的渠道。那么怎么避免这张纸成为污染源呢？李小平开始讲自己的设想，还没讲完，李苏打断了她，“我们现在没有能力考虑这件事情。”李小平收了声，作为一个医生，她习惯了这种无奈，想挣扎一下，却也不知道该如何挣扎。

**他们眼前最需要解决的问题是病人出院的问题**。按照国家卫健委公布的第四版诊疗方案，确诊患者体温恢复正常3天以上、呼吸道症状明显好转，连续两次呼吸道病原核酸检测阴性（采样时间间隔至少1天）即符合出院标准。

尽管两次采样时间间隔最短可以缩至24小时，但在目前的条件下，临床医生要拿到两次采样的检测结果，至少要等一周左右。对于医生来讲，时间太长了，“根据我们的临床观测和检查，病人已经没有问题，达到了出院的标准，现在时间长，里面的病人出不去，医院外面的病人进不来。”李小明说，对于患者来说，及时出院，就能够快速让新的病人进来。

**另外一个情况也解决不了，有的病人已经做过两次检测，结果显示阴性，从指南的标准来说，病人已经没有传染性，但病毒引发的病情却是不断恶化的**。李小明说，按道理来讲，这样的病人应该送到其他大的医院，继续救治，“没有医院敢收，我们只能在病区里调配，床位还是腾不出来。”李小明还遇到了另一种情况，一个被确诊的小姑娘，经过治疗后，肺部病情好转恢复，各项指标也健康，但核酸检测一直显示阳性，“你也不能让她走。这时候就要考虑检测的假阳性、假阴性情况，可现在指南都没有说法。”一个个不断出现又亟待处理的情况摆在面前，怎么办、怎么做却都需要个人来决定。

一位医生担心的还有一件事，根据他的观察，如今来医院的就诊者分为两类：一种是情况很严重，已经到了非救治不行的地步；一种则是症状很轻的，心里怀疑自己可能被感染，来医院是想排除状况的。“**最危险的是已经出现症状的人，现在封城不方便，他们认为自己能够扛下去，就在家里做自我隔离，病情却在不断发展**。”这意味着，等封城结束，可能会有不少重症患者出现——现在所有的管制主要是为了防止疫情扩散，治疗的难题，他们希望引起更大的重视。

![](https://i.loli.net/2020/02/05/NjK2LBxMAZX8HaU.jpg)

<figcaption>2020年2月4日，武汉在建的三家方舱医院医疗隔离点之一武汉客厅，2000张床位准备就位。（远征 摄）</figcaption>

2月2日，湖北省开始对所有疑似患者集中隔离。在前期定点隔离、居家隔离的基础上，湖北省对四类人员集中隔离。2月3日，武汉开始在洪山体育馆、武汉客厅、武汉国际会展中心建设“方舱医院”，用于收治新冠肺炎的轻症患者。

（徐山、王平、李苏、李小明均为化名）
