---
layout: post
title: 高压的审查与承诺的破产，中国民众的耐心正在被耗尽
categories: Archive
tags: 言论审查
date: 2020-02-02
image_feature: "https://i.loli.net/2020/02/02/FjHVzdfCMYoXAGB.jpg"
description: 审查制度的高压化过程是清晰可见的，大部分的民众在很长一段时间内刻意忽视了审查的存在，甚至有部分群众利用审查制度以在辩论中获得优势；但是，随着疫情的爆发，民众长期以来被给予的承诺濒临破产，不断高压的审查制度最终让所有人为其付出代价。
---

原文来自公号：~~[失焦Defocusing](http://206.189.252.32:8083/%E9%AB%98%E5%8E%8B%E7%9A%84%E5%AE%A1%E6%9F%A5%E4%B8%8E%E6%89%BF%E8%AF%BA%E7%9A%84%E7%A0%B4%E4%BA%A7%EF%BC%8C%E4%B8%AD%E5%9B%BD%E6%B0%91%E4%BC%97%E7%9A%84%E8%80%90%E5%BF%83%E6%AD%A3%E5%9C%A8%E8%A2%AB%E8%80%97%E5%B0%BD.html)~~

---

在2020年的阳历新年来临之际，中国充满了节庆的气氛，购物商城、电影院和大都市的街头灯火通明，人们正在告别过去的十年：这十年对于中国、对于世界都是巨变的十年；之于中国民众，生活水平普遍且显著地提升——没有人会否认这一点。

在2019年12月31日的凌晨，一个由武汉市卫生健康委员会发布的发现“不明肺炎”的通告在中文互联网上引起了短暂的不安，但是随着新年的临近和“病人病情稳定，已采取有效的隔离措施”的说辞下，短暂的不安被新年的热烈氛围取代，这件事被人们抛之脑后，在接下来的将近20天内，“不明肺炎”没有再次进入公众的视野。而截至本文的写作日期，2020年2月1日，也就似乎中国农历新年的正月初八，湖北省内的12个地级市、1个自治州、3个省直辖县级市已经全部封城，国家媒体的大部分内容为肺炎疫情的报道，1月28日，在国家广电总局统筹下，全国卫视加强疫情防控报道，减少娱乐性节目。

一些中国民众抱怨道：“今年是最不像过年的一年了。”

![](https://i.loli.net/2020/02/02/cYsU6ae8tym7154.jpg)

<figcaption>武汉红十字会医院内穿着防护服的医护人员</figcaption>
<figcaption>by GETTY IMAGES</figcaption>

在观察近日民众铺天盖地的抱怨以及陷入十年以来前所未有的窘境的地方政府之前，有必要明确的是，在过去十年内日益高压的舆论审查并不是无辜的。

21世纪10年代的世界最醒目的成就是不断发展的科技，与民众关联最为紧密的无疑是智能手机和移动互联网。2010年6月8日是iPhone4正式发布的日期，iPhone4是第一部广泛地进入中国中产阶级家庭的智能手机，同年，华为等公司也推出了自己的智能手机系列。智能手机和移动信息系统的发展和普及彻底改变了人们的生活，信息的接收和传送在这十年内变得无比快捷。这件事一方面改善的是人们的通讯条件，但是在另一方面，**一些未曾被考虑的问题成为亟待解决的问题，中国的权力机构敏锐地意识到以往对网络信息的管控力度在社交配体时代不再适用**；于是一个机构被建立起来：中华人民共和国国家互联网信息办公室（后简称网信办），其主要职责包括：

> “落实互联网信息传播方针政策和推动互联网信息传播法制建设，指导、协调、督促有关部门加强互联网信息内容管理，负责网络新闻业务及其他相关业务的审批和日常监管，指导有关部门做好网络游戏、网络视听、网络出版等网络文化领域业务布局规划，协调有关部门做好网络文化阵地建设的规划和实施工作，负责重点新闻网站的规划建设，组织、协调网上宣传工作，依法查处违法违规网站等。”

网信办的职能范围非常广泛，基本涵盖了中文互联网使用频率最高的领域，网信办的成立改变了中文互联网的舆论风向，并导向了一个事实——一个在曾经的网络论坛（Bulletin Board System，BBS）时代并不热门的行业——审查行业在这一背景下迅速扩张自己的领地。**在这十年内，中国经历了有史以来最为严格的审查高压化过程，立法机构和行政机构不遗余力地宣传“网络不是法外之地”的口号，互联网的言论审查被视为维护社会稳定的政治任务之一**。

中国采取这样的高压态势并不是没有原因的，随着换届选举和宪法的修订，无论是党内还是民间，都出现了许多质疑和反对的声音，但是在后者发生之前，2015年出台的“不得妄议中央大政方针”的条例在实质上为压制异见提供了依据，各大社交平台对其积极响应，微博将“不得以任何方式损害各级国家机关及政府形象”列入《微博服务使用协议》；豆瓣将“不欢迎激进时政、意识形态方面的内容”列入《社区指导原则》等。但是许多网民发现，社交平台制定的条例存在许多问题，**一方面，针对政治言论的条款边界往往暧昧不清，给审查公司最大程度的解释权，而用户的言论则被最大程度地压制；另一方面，尽管许多用户根本不认可使用协议的合理性，但是在所有社交平台均被纳入网信办管控的背景下，用户没有其余的选择**。

互联网审查日益高压化的趋势并没有停止。2019年12月，国家互联网信息办公室发布了《网络信息内容生态治理规定》，自2020年3月1日起施行。该规定更为详尽地规定了“鼓励网络信息内容生产者制作、复制、发布的信息”以及“网络信息内容生产者不得制作、复制、发布的违法信息”等，《规定》的出台标志着网络安全内容审查的空前高度。

![](https://i.loli.net/2020/02/02/S49P3CBhHipKlGy.jpg)

<figcaption>在位于疫情中心武汉市的协和医院，工作人员到网上乞求获得医疗用品补给</figcaption>

<figcaption>by CHRIS BUCKLEY</figcaption>

**但是讽刺的是，在该规定正式施行之前，一场席卷整个中国乃至全世界的瘟疫迅速吸引了人们的注意力，并将互联网的言论审查推入一个让人尴尬的局面**。近日，“8名医生因‘造谣’被抓”的话题多次登上微博热搜榜，在12月30日，这8名医生曾以不同的方式提醒群友或公众新型冠状病毒的危险性，但是次日“平安武汉”发布通告称已对散布谣言的8名群众进行了处理。**生活饱受疫情影响的网民愤怒地声讨武汉市的行政机关，认为如果这8名医生的警告若在民间获得了足够的重视，疫情就不会像现在这样严重**；无论这样的假设是否正确，公众的愤怒已经开始指向审查制度和审查行业。审查的日益高压几乎开始侵吞公民最基本的言论自由权，虽然知识界的人士早已对言论自由和审查制度表现出深层次的忧虑，**疫情的蔓延让民众对“言论自由不是绝对的自由”这句不断被提及的口号开始感到反感，有一位微博用户写道：“现在的言论自由不是绝对的自由，而是绝对的不自由”**。

个体对于言论自由限度的感知是受其政治立场影响的，对于大部分的民众而言，人们普遍地希望与自己观点对立的人能够“闭嘴”，在过去的十年内，**随着审查制度的完善，部分支持政府决策的人巧妙地借着高压化审查的形势，通过网络平台举报等方式将异见纳入“审查—删除”的清单**；2020年的新型冠状病毒疫情在某种程度上改变了这一局面，**一些民众开始意识到自己曾经支持并利用其使异见噤声的审查制度的恶果，裹挟着极端的民族主义、民粹主义和极权主义的高压审查制度成为杀人的机器**——尽管许多人依然并不这么认为。

![](https://i.loli.net/2020/02/02/FjHVzdfCMYoXAGB.jpg)

<figcaption>被网友调侃的微博和豆瓣开屏</figcaption>

一些学者开始思考为何只有在新型冠状病毒的非常时期，审查制度的阴暗面才重新被提及。纽约时报的专栏作家袁莉在《疫情危机让中国稳定表象出现裂痕》一文中提到，**许多中国民众在过去的十年内让渡出一些权利，其中就包括完整的而非被曲解的言论自由权，来换取中国政治的一个不言自明的契约：经济的繁荣以及和平、稳定的发展**。

但是袁莉指出，肺炎疫情让许多民众对政府的执行能力感到失望，一方面，不同层级的政府之间的共谋行为导致疫情的未及时公开，最终导致疫情的扩大和医疗储备的短缺，武汉市市长在采访中提到，他曾向上级政府汇报情况，但是只能在授权后才能公开；另一方面，**不计其数的医院选择绕过官僚机构直接向公众募集物资和捐款，这让陷入焦虑中的民众更感到惊讶，他们曾经获得的承诺是由一个具有强大调度能力的政府给予的，这个承诺被给予的同时民众也被告知：在紧急情况下，政府将有能力解决民众的困难，民间的非营利组织有一定的生存空间，但会相对受到挤压**；在“后非典时代”，虽然他们对政府的信任感已经大打折扣，但是中国民众依然是留有希望的，民众相信在如此紧急的情况下政府在物资生产和调配的过程中确实陷入困境，以至于众多的医院需要向民间求助。但是让已经陷入焦虑和不满的民众更感到愤怒的是，湖北省的红十字会并没有及时向各定点医院发放民众捐献的物资，而是囤积于仓库之中；虽然湖北省红十字会后来发布声明道歉，但是这一系列的无法被接受的事实让民众大失所望，其中也包括曾经的审查制度的支持者以及政府决策的无条件拥护者。

![](https://i.loli.net/2020/02/02/FVny2LgQWt3BEKh.jpg)

<figcaption>2020年2月1日晚间微博热搜榜</figcaption>

虽然民众在近日陷入普遍的焦虑和愤怒中，立场的分野依然存在，除了少数依然不关心政治的民众之外，**许多民众对地方政府失去信任，让湖北省省长和武汉市市长以及其他相关官员下台的声音此起彼伏**，一位网友在转发《湖北省红十字会：深感痛心、自责和内疚》一文时评论道，“从红十字会到当地政府，每天都有新的失望”。**另外，也有少数民众以及许多知识界人士认为此次疫情在湖北省发生并不能够将所有责任归咎于地方政府之上，政治体制是应当被反思的对象**，在豆瓣，一位昵称为“吵”的用户认为：“武汉只是灾难和病毒随机选择的一座城市，但中国不是灾难随机选择的一个国家”；“然后国家会被解释，被证明，被信赖为唯一的拯救者，”作家李海鹏在微博上写道，“所以我们所有的故事都是一样的，以国家主义的失败开始，以国家主义的胜利告终。”

暂时搁置这些仍然存在的对于不同层级政府的态度分野，我们能够发现在过去十年中，**审查制度的高压化过程是清晰可见的，大部分的民众在很长一段时间内刻意忽视了审查的存在，甚至有部分群众利用审查制度以在辩论中获得优势；但是，随着疫情的爆发，民众长期以来被给予的承诺濒临破产，不断高压的审查制度最终让所有人为其付出代价**。

尽管“信任”对于相当大一部分的民众来说已经是遥远的记忆，但是中国民众的耐心——一个比信任更贴近生存底线的存在，仿佛也正在被耗尽。

*本文是笔者为《纽约时报》专栏作者袁莉于2020年1月29日撰写的《疫情危机让中国稳定表象出现裂痕》以及普利策奖获奖者纪思道（Nicholas Kristof）于2020年1月30日撰写的《Coronavirus Spreads, and the World Pays for China’s Dictatorship》两篇新闻评论所撰写的导读，原文中文版连接：

<https://cn.nytimes.com/china/20200129/china-coronavirus-communist-party/>；

<https://cn.nytimes.com/opinion/20200130/coronavirus-china-government/>

· 往期文章 ·

· 感谢关注 ·

“Freedom is a choice made”
