---
layout: post
title: 刘绍华：说给幸存者听“面子”治理下中国反复付出的防疫代价
categories: Archive
date: 2020-01-30
tags: 新冠肺炎
description: 从年前开始，看着武汉肺炎疫情的变化，我实在觉得太过熟悉了，从近年的SARS、爱滋，到1949年后的麻风防疫，中央、地方政府与民众的反应，熟悉到我曾经笔下的历史不断在政府与众人的日常生活中重演：矢口否认、疫情爆发、被迫承认、强迫且大规模隔离、污名恐慌比传染病蔓延得还要迅速、民生规划缺乏、医务人员被推到第一线却无政策做后盾、众人恐惧愤怒。
---

原文来自[木舟说](http://206.189.252.32:8083/%E5%88%98%E7%BB%8D%E5%8D%8E%EF%BC%9A%E8%AF%B4%E7%BB%99%E5%B9%B8%E5%AD%98%E8%80%85%E5%90%AC%E2%80%9C%E9%9D%A2%E5%AD%90%E2%80%9D%E6%B2%BB%E7%90%86%E4%B8%8B%E4%B8%AD%E5%9B%BD%E5%8F%8D%E5%A4%8D%E4%BB%98%E5%87%BA%E7%9A%84%E9%98%B2%E7%96%AB%E4%BB%A3%E4%BB%B7.html)

作者：刘绍华

---

> 当下一次新兴疫情又来危及人口稠密的土地时，这个依然学不会历史教训的政府仍将搭上遮羞布，将依然无法保护你、以及你所钟爱的国与家。

我的研究一直攸关1949年后中国的传染病防疫。长年深叹不论学者研究得如何尽心费力、如何提醒谨戒历史教训，中国却每逢大型防疫，混乱与苦难的历史总是如预言般地重演，就像以前从未发生过甚么事似的。而如我这般高度关注那块土地上广大生灵苦难的学者所写的历史与提醒，也依然被压抑消音无法面世。一个无法累绩朝向幸福所需的历史感的社会，如何能记取前车之鉴以造福后人?

从年前开始，看着武汉肺炎疫情的变化，我实在觉得太过熟悉了，从近年的SARS、爱滋，到1949年后的麻风防疫，中央、地方政府与民众的反应，熟悉到我曾经笔下的历史不断在政府与众人的日常生活中重演：矢口否认、疫情爆发、被迫承认、强迫且大规模隔离、污名恐慌比传染病蔓延得还要迅速、民生规划缺乏、医务人员被推到第一线却无政策做后盾、众人恐惧愤怒。

然后呢，待疫情经过慌乱暴力但有些效果的隔离防疫手段而终渐消退后，一切又回到矢口否认如常的日常生活状态，遗忘历史、禁绝历史......。唯一可能留下的只是对地区「他者」的污名，如河南与爱滋、凉山与毒品、武汉与肺炎，但至于那里的人为何身陷困境与如何摆脱困境，却未受检讨。灾区之外的人不关心这些，被污名的「他者」可能也只想着以否认与掩饰来摆脱污名，而不是挑战污名的根本原因与治理的冷漠无能。

我是有些动怒了。除夕那天我在家门前贴上一张春联，是圣严法师的法语「放下的幸福」，我想实行它，一直忍着没有泼文说话。今天初五开工，我也过了一个「放下」的年了，现在想写些话了。就当我自己的历史纪录，哪怕继续被禁绝。

武汉疫情发展与控制的荒腔走板，各方都在骂，谁都知道中国政府从中央到基层都是最大的问题。有人说关键问题是集权控制，有人说是地方官僚腐败。这些都是因素，但我想更进一步检讨，是甚么因素让这些每逢重大疫情就冒出的问题在1949年后的中国长存难改，混乱的防疫历史一再重演?

最关键的问题，用大白话讲就是民族主义或爱国主义的「面子」问题，用政治术语来讲就是中国面对心中之痛的「帝国」或「外侮」时的「主体性」问题。这也就是我在《麻风医生与巨变中国:后帝国实验下的疾病隐喻与防疫历史》中，以「后帝国」的意识形态来分析中国1949年后的麻风防疫关键。防疫的成功、失败、手段、消音或选择性荣耀，都因中国反帝反美的主体性心态主导，以致众人主动或被动地配合国家面子而隐匿丑闻、批评外界质疑、因人(的所在地而)废言、牺牲个人成就集体形象。

面子、主体性或意识型态的主导者自然是坚守中国主体性的中央政权，而拥护者就是广大的一样爱国爱面子的民众。在国家意识的大旗下，民族主义或爱国情节不必然高亢激昂，反而可能天真卑微得令人心疼。本来，讲究主体是各国各民族都会做的事，但关键是，如果只因主体为大的爱国情操或民族情结而让付出惨痛代价的历史教训一再灰飞湮灭，这一代人与后代人的生命代价就是永远都学不会教训，永远落入不断重来的疫情挑战。

人群可能学不会历史教训，病毒可是会因应环境而变异。哪个比较强?

仅以爱滋与麻风这两个我书写过的深入研究为例，即可点出因「主体性」为大的防疫通病：意识形态主导的面子主体性高于合理的科学防疫原则；意识形态主导的面子主体性，让国家丢脸的表现不得公开讨论乃至写成白纸黑字；失去历史感，就无法有效因应未来。

我在《我的凉山兄弟:毒品、爱滋与流动青年》的结论〈疾病治理的时空意义〉中提到，2000年之前中国也否认爱滋疫情已然严重，直到《纽约时报》大幅报导河南省境内，因不安全的输血贩卖导致疫情爆发的重大新闻，让国际组织火力全开，要求中国政府承认并应对这个巨大危机，开放并接受更多国际援助以遏止疫情散布。自此，中国中央政府终于广纳国际合作，公开疫情。然而，在地方上，基层政府的作为仍是面子为大，报喜不报忧。《我的凉山兄弟》即研究了中央与地方的不同调。这本书在中国出版之后，引起很大的关注。

「结果有改变任何的政府治理吗?」我经常这样被中国读者问到。我总是苦笑难以回答，我多么希望研究能对这个世界的苦难之人有所助益啊！只是，显然，疫病治理依然故我，而我的研究专书却因政府面子问题，欲透过阅读我的书以了解防疫处境与历史的读者，也看不见我的书了。一个殷鉴不远的历史教训就这样硬生生地被消音。

但我愈研究中国的传染病防疫，就愈发觉要了解当前的乱象，就愈须了解历史，了解究竟是甚么关键因素，种下与助长了今日恶果。

年前朋友圈不断传递感染武汉肺炎的病人被关进隔离箱中带走的新闻与画面。令我想起我在《麻风医生与巨变中国》书中写过的故事:

在新疆吧还是什么地方，发现了上海的人生了麻风，所以包了一个车厢把他运到上海来了，......。

那么在地方上，他的病人一路走，后面卫生防疫一路跟着消毒，病人在前面，后面在消毒就是这样怕的啦。

恐惧蔓延、污名标签、过度防疫、医师无助，这些反应与做法，历久不衰。人心如常，手段未变。

可想而知，疫情过后的代价也将不可免地惨烈。我的两本书都写过诸多防疫代价，我也没力气在此重述了。我只能难受地断言，如果未能公开检讨防疫手段与历史、未能放下面子障碍，起码的代价就是下列关键字的恶性循环：否认、污名、恐惧、持续无能、生灵涂炭。我在《麻风医生与巨变中国》的前言写下:

中国的防疫故事带给世人什么意义?这些不仅是医疗和公共卫生史的议题，从中国极具争议的「后帝国」实验观之，更是政治社会史的提问。

书写《麻风医生与巨变中国》时，我的心情比书写《我的凉山兄弟》还沉重，原因正是我看到1949年后防疫历史的关键问题及其一再重复的悲哀。我在《麻风医生与巨变中国》的结论，以〈历史的罗生门〉来反省官方版的历史与被消音的历史。

全球化下的中国防疫，不乏目标与方法孰轻孰重的拿捏失误。在麻风之后，如我曾研究过的爱滋与近期的SARS，也是类似案例。

人类从历史中获取的教训似乎有限。所幸，自由开放的社会主张透明机制与尊重个人的治理基调，对于这种一再发生的防疫混乱与无谓伤害，具有自我批判反省与修补错误的能力，让社会得以调整对个体造成无谓伤害的可能性与程度。......

相较之下，当代中国的麻风防治曾对无数患者与医师烙下的负面生命印记，至今仍鲜为人知。在此情况下，要期待社会主动修补既有伤痕，前路仍然漫长。

今天我说的这些话，对于疫情当前、生存饱受威胁的人们而言，实可谓废话。我觉得难受，我丝毫不想让有生存威胁的人感到站在安全之地的人只能说教。

这废话是要说给幸存者听的。如果能安然躲过这一波疫情，恳请中国幸存的众人关注与挖掘历史，明白配合主体意识形态的桎梏所付出的代价。如果平日就经常因爱国爱面子而容忍纵容有问题的治理措施、配合主体意识来攻击国际批评、当有人揭露令人愤怒的真相时却因家丑外扬以致指控的手指头不是朝向政府反倒是戳向揭露真相的人，那就只是紧抓着这块爱国主义主体性的遮羞布，不愿从历史中学到教训。那么，当下一次新兴疫情又来危及人口稠密的土地时，这个依然学不会历史教训的政府仍将搭上遮羞布，将依然无法保护你、以及你所钟爱的国与家。

「放下的幸福」是需要练习的。请在日常生活中时刻学习放下国家与民族的面子、主体性等二元对立的执着重担，才能空出力气与机会拾起真实福祉的希望。天佑众人!

作者刘绍华，台湾中央研究院民族研究所研究员，台湾知名人类学家。原刊于端传媒2020年1月29日，转载自豆瓣网友emma。
