---
layout: post
title: 余英时|《一滴泪》新版序
categories: Archive
date: 2019-08-11
tags: 一滴泪
image_feature: "https://i.loli.net/2019/08/11/LRqD8BedOsw32Vg.jpg"
description: 著名翻译家、英美文学研究专家巫宁坤于美国当地时间2019年8月10日逝世，享年99岁。在自传《一滴泪》中，把自己的前半生归纳为“I came. I suffered. I survived”.
---

作者：余英时

原文来自订阅号「[黄灿然小站](https://mp.weixin.qq.com/s?__biz=MjM5ODc1Mzg2NQ==&mid=202214144&idx=3&sn=481b6d657b5da8d18183161e43698351&scene=21)」，其它转载的已有~~[被删除](https://mp.weixin.qq.com/s/KEpN1Gs88Qt3SOMHti51PQ)~~

---

![a single tear](https://i.loli.net/2019/08/11/LRqD8BedOsw32Vg.jpg)

大约十年前，我便读了《一滴泪》的英文原本A Single Tear。当时感受很深，至今犹在记忆中。这是我读到的第一部“右派分子”的自述。运用高超的文学剪裁，把二、三十年的苦难──从个人、家庭到亲友──生动地勾勒了出来。作者文笔的流畅自然，显示出他在英美文学与语言上的深厚造诣。他将三十年的坎坷人生归结为"I came· I suffered· I survived"(“我归来、我受难、我幸存”)，尤使我为之击节。在中国文史传统中，这正是所谓“春秋笔法”。当然，作者的隽语是从恺撒（Julius Caesar）的名言："I came, saw and overcame"(拉丁原文是veni, vidi, vici)脱化而出的，经过莎翁的引用（As You Like It V·ii），在西方早已家喻户晓。但作者融合中西的文学修养和匠心独运，即此可见。

这是我在未识作者之前对于《一滴泪》的认识，应该说是相当客观的。我当时对作者Wu Ningkun的中文姓名也茫无所知，更不必说他的身世背景等等了。但在读《一滴泪》原本时，我发生了一点悬念，使我渴想一见作者其人。什么悬念呢？作者是应燕京大学的西语系教授赵萝蕤电召，回到燕大任教的，而我则恰好于一九四九年秋季考入燕大历史系二年级，读过一学期的书，当时教我英文的便是赵教授。一学期下来，我感到她是一位既热心又亲切的老师。我记得她曾请全班同学去她家中吃过一次饺子，也见到了她的先生陈梦家。后来我的专业使我时时有机会阅读陈梦家有关甲骨、金文、汉简的著作。阅览之际，我总不免怀念在她班上受教的情景。陈梦家不甘受辱而自杀后，我更想知道赵教授的处境。我曾听说她一度陷于精神崩溃的状态，但传闻不详，终成为我的一个悬念。我想《一滴泪》的作者一定会告诉我不少关于她的事情。

几年之后，我偶然在《吴宓日记》（第九册，页八六、一○八）中发现了“巫宁坤”三个字，下面注语说：“成都空军第三路司令部翻译”，我才确定了作者的中文姓名。但是我还是不知道他究竟是在大陆或海外。二○○五年十月我在华府国会图书馆读书期间，由于高克毅先生的介绍，我才有幸与巫先生同席，这给我带来了意外的惊喜。接谈之下，我不但知道了关于赵萝蕤老师后半生的遭遇，而且更欣幸结识了这样一位才华洋溢而宅心仁厚的前辈作家。当天听巫先生谈论，真有“咳唾成珠玉”之感。他心直口快，表里如一；一席话之后，我便完全懂得：他为什么绝对逃不过毛泽东的“阳谋”了。

回到普林斯顿之后，承巫先生寄赠《一滴泪》的中文本，我才知道他在二○○二年曾用中文将此书重写了一次。中文本的大纲领虽与英文本不殊，但在叙事方面则详细多了，使中国读者能由语境而深入情境，尽其曲折。所以从历史的角度出发，我断定中文本比英文原本具有更高的原料的价值。本书有五章是根据夫人李怡楷的口述而写成，其中事实都在作者的闻见之外。作者运用“花开两朵，各表一枝”的方式，把他全家苦难的经历完整地呈现了出来，好像是佛经上说的“两束芦苇，互倚不倒”。这不但是文学的技巧，而且有象征意义。巫先生之所以终能“幸存”下来，如果没有夫人的全心全意的支持，是不可想象的。如果不是夫人给他寄寒衣，恐怕他在北大荒非冻死不可；如果不是夫人千里迢迢的“探监”，送食品之外更为他的病情而向原单位要求早日释放，他也可能饿死在清河农场。（吴弘达《昨夜雨骤风狂》中所写清河农场的情况恰可印证。）作者和夫人在二十多年受难时期，也一直是“两束芦苇，互倚不倒”。

但是本书的最高价值并不止于保存了一人一家“受难”的真相。更重要的，它写出了中国知识人在历史上最黑暗期间的“心史”。在毛泽东“乾坤独御”的二十八年中（一九四九-一九七六），老、中、青三代知识人都在炼狱中受煎熬。大致说来，中共政权成立之初，五、六十岁的属于老一代，三四十岁的属于中年一代，二十岁前后的则是青年一代。但在一九八○年代左右，大陆思想气氛开始松动的时候，老一代知识人或死或衰，已发不出什么声音；中年一代则已进入晚景，惊魂甫定，战战兢兢地保持着刚刚得到的“皇恩浩荡”，不敢越雷池半步；青年一代此时正进入中年，精力虽然旺盛，但成长在一个绝对封闭的社会中，一时还没有足够的精神与思想的资源，作为反思三十年劫难的凭借。巫先生独能在一九八六年写成〈从半步桥到康桥〉自传初稿，五年以后又扩大成《一滴泪》，这不能不说是一个异数。从客观条件说，作者的“劫后余生录”不但是在英国和美国撰写的，而且用的也是英文。但是我们决不能因此得出结论说：由于具有这一客观的优势，作者才能捷足先登，写出这部深刻反思的名著来。这里必须重视的是作者的主观条件。

巫先生的《一滴泪》是中国数以百万计的知识人“泪海”中之“一滴”。然而这《一滴泪》也如实地折射出整个“泪海”的形势，也可以说是“泪海”的具体而微。这是我断定《一滴泪》是知识人“心史”的主要根据。能写出这样“心史”的作者，必须具备一项最重要的主观条件：即在精神和肉体都被践踏了三十年之后，还能很快地重整旗鼓，恢复了精神上的自我。一九七八年以来，我曾会见过不少老一代的知识人，而且还包括过去在哲学、史学、文学方面卓然成家者。稍一接谈，我便发现他们在精神世界中已到了方向莫辨的状态（disoriented）。在几十年以暴力为后盾的不断“思想改造”下，他们原有的精神自我竟彻底散灭了。就我所见到的文字记录而言，似乎也只有陈寅格、吴宓等极少数的人还能至死不失其故我。这使我不能不五体投地佩服巫先生的巨大而坚韧的精神抗力，能够数十年如一日，顶得住铺天盖地而来的胡言乱语。他并不是在一九八六年开始写自传时才神定气足：早在“右派”尚未彻底改正之前，他便已“故态复萌”了。一九八○年十二月在成都“全国外国文学会议”上，他语惊四座，发出了狮子吼──“选取自由的文学，谢绝奴役人的革命！”事实证明，他说出了人人心中想说而不敢说的话，所以会后许多同行纷纷向他致敬，有的还含着眼泪。正因如此，我才毫不迟疑地认定他的《一滴泪》写出了整整一代知识人的“心史”。

巫先生在一九五一年回国之前，已具备了深厚的中西文化修养；他的价值意识及由此而衍生的人生观与世界观也已大致定型。但难能可贵的是：他经过无数劫难而始终保持住原有的价值系统。他好像庖丁解牛所用的那把刀一样，“今臣之刀十九年矣，所解数千牛矣，而刀刃若新发于硎。”他也像庄子所描绘的“真人”：“登高不栗，入水不濡，入火不热。”他和大多数同难知识人的分别便在于此。我当然不是说，巫先生是唯一经得起“党天下”炼狱考验的知识人。仅仅就五十五万“右派”而言（事实上远不止此数），其中不肯向“党天下”屈服的人必然占有一个很高的比例，但他们却不像巫先生那样，能够“幸存”下来或留下文字的记录。最近受到大家高度注视的北大“右派”学生林昭，她为民主、自由而殉道的精神便足以惊天地而泣鬼神。青年一代“右派”写回忆录是最近几年才开始的。

但是我写这篇序文，却时时联想到今年出版的《吴宓日记续篇》（共十册，北京，三联，二○○六年）。这部晚年日记始于一九四九，终于一九七四，中间虽有残缺，但大体上延续了二十六年，恰好涵盖了毛泽东的当权时期。吴先生记述了每一次所谓“运动”的实况，包括“思想改造”和“检讨”中的种种胡言乱语；他也巨细不遗地写下了他自己和其它同事备受凌辱的经过。以个案而言，这是我见到的内容最丰富的一部记录，把中国知识人在这一时期的苦难镜头一一摄取了下来，使读者如身临其境。但更重要的是他自始至终都抱着“殉道”的精神与征服了中国的斯大林体制──“党天下”──相抗争。他所谓“道”即建立在对中西古典文化的体认之上的价值信仰。在《吴宓日记》前十册（一九一○-一九四八）中，他曾屡屡自誓“殉道”的决心，而《续编》则充满了实践的事迹，两相对照，他的“知行合一”是无可怀疑的。在暴力威胁之下，表面上他自然不能不向“党天下”低头。但是在日记中他则一再为此自责，而且自比于“身降心不降”的吴梅村。限于篇幅，让我举两三个实例来说明他的殉道精神。一九五一年八月二十八日他写道：宓4-6至柑园赴三组学习会，续研《实践论》。念古今东西哲学之伟大而奉此一册为不易之真理、无上之精思，竞事赞颂发挥，可笑尤可耻也。（《续编》第一册，页200）

能在日记中对毛的〈实践论〉作此大不敬之语，他非具有强大的自信力不可，而当时哲学名家如金岳霖、冯友兰则无不奉此文为“不易之真理、无上之精思”。相形之下，真信仰与观念游戏之辨已无所遁形。一九五二年十一月二十二日他在《日记》中说：

2:30-5:00大礼堂聆（1）郭豫才北碚市人民代表会议传达报告；（2）周西卜宣布“中苏友好月”庆祝办法；（3）张伯华“中苏友好”之意义，解释（i）花布倾销（ii）旅大占领（iii）长春铁路经营皆为助中国而非利苏俄之举动。末言庆祝及欢迎苏联文艺团办法，极详尽。呜呼，古今亡国之速且易，又其国人之甘心亡国，惟恐人之不我取，未有如今中国之亡于苏俄者也！（同上，页462-463）

当时毛泽东正在全力推行“一边倒”政策，从体制到作风，没有一处不是奉斯大林治下的苏联为楷模；至于苏联侵夺中国权益的种种举动，如日记所列的事实，中共则一概为之文过饰非。吴先生对此表现了最大的愤怒；他认定中共是心甘情愿地使“中国亡于苏俄”。以后几年他在日记中反复论述这一观点。一言以蔽之，他痛惜中国古典文化已彻底毁灭，而西方古典文化也不复有存身之地，他“心目中的中国”正在迅速地消失中，而“今日或未来的中国”或将成为“苏维埃联邦之一部分”，或“苏联之羽翼”。（见同书，第二册，页148-149；第三册，页138-139）“反右”运动展开之后，他写了一首〈记学习所得〉诗：

　　阶级为邦赖斗争，是非从此记分明。

　　层层制度休言改，处处服从莫妄评。

　　政治课先新理足，工农身贵老师轻。

　　中华文史原当废，仰首苏联百事精。

　　一九五七年七月十六日将晓作（同上第三册，页131）

中国的现况和知识人的处境都浓缩在这一首诗中。吴先生与“党天下”抗争从未停止过。文革时期，他屡遭毒打，右腿一度折成三截，日记中自不敢畅所欲言。但即使在这种极端恐怖气氛之下，他仍然坚持以曲折方式传达他的反抗。一九七三年十月二十六日，他在日记中写道：

宓读十月十九日至二十二日《参考消息》。台湾驻美大使沈剑虹在Detroit宣言：闻知国内“批孔”，使我心中悲痛云云。（第十册，页511）

这显然是借《参考消息》的报导来表示他反对当时的“批孔”运动；他自己未着一字，但满腔孤愤已藉此宣泄出来了。

我为什么要在这里郑重介绍《吴宓日记续编》呢？这有三重理由：第一、吴先生是巫先生的老师。我曾向巫先生求证过，他说他在西南联大时选过吴先生“欧洲文学史”的课程。第二、前面已指出，毛泽东虽能恃其“党天下”的暴力逼使大多数中国知识人“降志辱身”，但老、中、青三代中都有特立独行的豪杰之士，自始至终不为威势所屈。巫先生属于中年一代而吴先生则代表老年的一代。所以这部新出的《吴宓日记续编》正好与《一滴泪》互相印证。第三、巫先生之所以能写出一部知识人的“心史”，我深信是由于他原有的精神价值从未为政治上的狂风暴雨所撼动。这在上面已经说过了。吴先生晚年只要有机会便闭户读中西古典文学或重读早年师友以至自己的诗文集。这正说明，他必须不断地回到他的精神世界的源头，去汲取和增强与暴力抗争的动力。

巫先生在《一滴泪》中没有明确点出他的精神抗力从何而来。我最近曾向他提出一个很严肃的请求，希望他能再写一本劫难中的心路历程，与《一滴泪》互为表里。我盼望他不会让我失望。但是细心的读者并不难在《一滴泪》中找到线索。一九五八年四月十七日他向半步桥劳教所报到的时候，行囊中便带了英文本《哈姆雷特》和《杜甫诗选》。这两本书便是支持他渡过半步桥、北大荒、清河农场三处艰苦岁月的精神伴侣。他把女儿取名为“一毛”，即出于杜诗“万古云霄一羽毛”之句。在北大荒，他又从难友那里借到一些沈从文的小说，他的精神世界也更丰富了。从他在一九六二年的回忆，他在劳改营里，一直是“与《哈姆雷特》、杜甫的诗篇、和沈从文小说相依为命”的。（第十章〈暂回人间〉）这和吴宓先生的精神奋斗岂不如出一辙？

最后，我要借美国作家何伟（Peter Hessler）二○○二年六月对巫先生的访问，作为这篇序文的结束。但这必须从何伟的新书谈起。何伟是《纽约客》（New Yorker）驻北京的记者，他的第一本报导文学《江城》（River Town），通过许多小故事，写变动中的中国，十分生动深刻。其中单篇文字在《纽约客》上刊出时，早已脍炙人口，集结成书后更是好评如云。今年他又把最近的散篇集成《甲骨》一书（Oracle Bones, New York: HarperColins, 2006）。这部新书的有些篇章也是先在《纽约客》上刊出的。书名《甲骨》，因为其中一个主要故事是写陈梦家的。因陈梦家而涉及他的夫人赵萝蕤，再从赵萝蕤蔓延到《一滴泪》作者，所以才有对巫先生的专访。何伟的研究精神实在令人钦佩。他不但访问了陈梦家、赵萝蕤的亲友，而且连领头迫害陈梦家的人也不肯放过。由于陈梦家打成“右派”的罪状是他反对文字改革，何伟竟遍访与文字改革有直接关系的人，包括一位九十多岁老先生；他对有关陈梦家的每一件事都非追到水落石出不止。这件事恰好又与吴宓发生了瓜葛，让我引两条日记为《甲骨》一书添一点有趣的证据。一九五七年五月二十日吴宓记道：

午饭时，接张天授剪寄(1)一九五七年五月十七日上海《文汇报》陈梦家撰〈慎重一点改革汉字〉文，(2)一九五七年五月十七日上海《文汇报》专电〈首都学术界激烈争论“汉字要不要改革？”记〉。即复函申谢。宓读此剪报，始知宓一向太过慎重，太为畏怯，愧对自己平生之志事矣。即致唐兰、陈梦家一函，述感佩之意。写示“不死惊看汉字亡”一诗。（第三册，页88-89）

吴先生是誓死捍卫汉字的，陈的文章和唐的发言给他陡然增添了无限的勇气，竟写信去支持。但八月十六日他在日记中说：

北京有陈梦家，以反对文字改革为其罪。按宓于五月二十日致唐兰、陈梦家一函，似因浆糊潮湿，邮票脱落，该函竟以“欠资无人收领”退回，宓幸免牵连矣。然宓自愧不如梦家之因文字改革而得罪也。（同上页，152-153）

吴先生因“邮票脱落”而幸免打成“右派”的可能，这种事实在太巧了。但他并不“自幸”，而是“自愧”，这又是他“殉道”精神的充分体现。巫先生便是和陈梦家同时落入“阳谋”的陷阱的。

何伟“打破砂锅问到底”的精神尚不止此。由于甲骨的发现地是安阳，他亲到安阳考古站访问，希望找到和陈梦家相识的考古人员。皇天不负苦心人，他终于在那里找到了一位已退休的老杨，老杨是当时看守陈梦家的人员之一，他向何伟回忆了陈自杀前后的一些事迹。但是何伟并不照单全收，他要和其它的采访数据互相比勘，才试作推断或存疑。更不可思议的是，为了进一步理解安阳发掘，他竟于二○○一年十二月亲至台北中央研究院访问了百龄老人石璋如先生，因为他是当年参加发掘的仅存人证了。

只有介绍了《甲骨》一书是怎样写成的，我们才能认真对待何伟对巫先生的专访。巫先生初到燕京大学时，暂时寄居在陈梦家、赵萝蕤的家中，直接和陈先生交往过，并且亲身听到他说：“这是『一九八四』来了，这么快！”这一切何伟早已知道得一清二楚，他是有备而来的。但何伟此书并不是专写陈梦家一人；他不过是借陈的个案为线索，来探索在党天下的蹂躏下，几代中国知识人是怎样活下来的。因此他每访一位与陈有关的人，除了搜集资料之外，笔锋一转，便以被采访者为主体；对于巫先生，他也是如此。被采访者对于中共一浪高于一浪的“运动”，特别是“文革”，反应各有不同。他只作现象学的描述，不下任何道德判断。但对于巫先生，他显然另眼看待。他说，他特别尊敬巫先生的宁静。正是由于内心的宁静，他才能在回忆录中把自己的经历清理出来，并循此而寻求其苦难人生的意义所在。在这一方面《一滴泪》体现了极高的价值。何伟也很想知道：巫先生怎样在监狱和劳改营中还能保持住坚韧的精神。巫先生说，他常常想到杜甫、莎士比亚和迪伦·托玛斯。他特别引了托玛斯〈死亡也一定不会战胜〉的诗句，也就是他在《一滴泪》中译出的几句：

　　当筋疲腱松时在拉肢刑架上挣扎，

　　虽然绑在刑车上，他们却一定不会屈服；

　　死亡也一定不会战胜。

　　（见第三章）

这又再一次证实了上面在于他的精神世界源头的推测。

巫先生对于“我归来、我受难、我幸存”的人生并不悔恨，他对何伟说：

如果没有文化大革命或反右运动，我也许会是一个更有成就的学者，也许我会写出几部有关英、美文学的专著。但是那又怎么样呢？关于这一方面的专书早已汗牛充栋了。《一滴泪》也许是一部更重要的作品。（p·456）

我完全同意巫先生的看法。王国维曾引尼采的名言：“一切文学余爱以血书者。”（《人间词话》卷上）《一滴泪》便是“以血书者”，巫先生以“受难”的全部人生为中国史上最黑暗时代作见证，这是他个人的不朽的盛业，然而整个中华民族所付出的集体代价则是空前巨大的。我不禁想起了赵翼的两句诗，引之以为序文的结语：

国家不幸诗家幸，吟到沧桑句便工！

二○○六年耶诞日
