---

layout: post

title: 香港近期事件时间线与相关问答

categories: Archive

date: 2019-08-06

tags: 香港

description: 由《2019 年逃犯及刑事事宜相互法律协助法例（修订）条例草案》（以下简称《逃犯条例》）引起的香港社会动荡已经成为国际热点问题，热度持续数月不减。笔者秉持 “戏说不是胡说，改编不是乱编”“全面了解事件，理性看待同胞”的精神，写下这篇文章。

---

原文来自公号: ~~[我们是这世上的光](https://mp.weixin.qq.com/s/F_Zvx4nPIX_IhQRfUR7DxA)~~

---

由《2019 年逃犯及刑事事宜相互法律协助法例（修订）条例草案》（以下简称《逃犯条例》）引起的香港社会动荡已经成为国际热点问题，热度持续数月不减。笔者秉持 “戏说不是胡说，改编不是乱编”**“全面了解事件，理性看待同胞”** 的精神，写下这篇文章。

本文后续内容分为两部分，第一部分梳理时间线，第二部分尝试回答一些笔者认为重要或大家普遍关心的问题。

**第一部分  事件时间线**

**1858 年**

《中英天津条约》第 21 款规定香港殖民地政府须将逃到香港的中国犯人送至大清。香港殖民地政府订立《华人移提回籍条例》，规定过往 12 个月中未在香港殖民地住满 6 个月的中国籍犯人，可经裁判法院审讯后引渡到大清，亦曾与清政府官员订立《香港提犯章程》作为引渡逃犯至大清的方法。中华民国外交部曾向香港政府提出引渡要求，最后一次引用《华人引渡条例》是于 1930 年。1997 年，《华人移提回籍条例》因为不符合基本法，而被正式废除。

**1987 年**

香港特别行政区基本法咨询委员会法律专责小组提交报告，建议内地和香港特别行政区之间的法院管辖应以 “属地原则” 处理，指出：“如犯罪者，不论是香港居民还是内地公民，在香港作出犯罪行为，便应在香港受香港刑法检控和审判；如犯罪行为在内地发生，犯罪者，不论是香港居民还是内地公民，须在内地受内地刑法检控和审判。”

**1992 年**

英国为香港制订引渡协议及现行《逃犯条例》时，强调 “只与司法制度、刑罚制度、人权状况达标的政府建立引渡关系”， 英方立法原意并不视没有订立香港与中国内地间的引渡协议为 “漏洞”，此外，中方在 1988 年亦向英方承认引渡等法律未发展完善，建议实施初期只限于民事和商贸合作方面。

**2018 年**

2 月，一对香港情侣去台湾旅行，结果在旅行途中，20 岁的香港姑娘潘晓颖被其男友陈同佳杀害。3 月 5 日，迟迟联系不上女儿的潘晓颖父母分别在香港、台湾两地报警。3 月 13 日，陈同佳在香港被捕，并承认是自己杀害了潘晓颖。4 月，香港警方以盗窃现金、手机等行为，指控陈同佳 4 项洗黑钱罪外加 3 项盗窃罪，法院判处刑期 29 个月。

**2019 年 2 月 12 日**

香港政府召开记者招待会，宣布提交修订《逃犯条例》及《刑事事宜相互法律协助条例》的草案，但法案的公众咨询期却一反过往有最少一个月的常态，政府以 “极逼切修例” 为由缩短咨询期至只有 20 日。

**2019 年 2 月 21 日**

台湾陆委会提出反对意见，即不同意港府以 “一个中国” 为前提修改引渡法例，并以此与台方交涉。陆委会指出在命案发生后已用尽一切努力处理，台湾当局曾经向香港方面提出三次司法请求（2018 年 3/4/7 月），包括协助进行取证及台港司法互助协商，但香港特区政府均不作回应。

**2019 年 3 月 26 日**

香港政府在听取商界意见后，剔除了其中 9 项商业和个人罪行（包括破产、证券期货、侵权、电脑罪行等），并把引渡的门槛由公诉判入狱 1 年以上的罪行，提高至 3 年（或以上）。

**2019 年 3 月 31 日**

民间人权阵线（以下简称 “民阵”）举办首次反修例游行，主办方表示 12000 人参加，警方表示最高峰时有 5200 人。

**2019 年 4 月 3 日**

草案在香港立法会大会进行首读。

**2019 年 4 月 12 日**

法案委员会成立。

**2019 年 4 月 17 日**

法案委员会从 4 月 17 日至 5 月 14 日召开多次会议（建制派称 4 次，民主派称 5 次），未能取得任何成果并爆发肢体冲突。

**2019 年 4 月 28 日**

民阵发起第二次游行，主办方表示游行有 13 万人参加，警方则宣称高峰时有 22,800 人。

**2019 年 5 月 20 日**

保安局局长李家超正式去信立法会内务委员会主席李慧琼，要求立法会在 6 月 12 日就修订《逃犯条例》恢复二读，此举将绕过被指失效的法案委员会并直接提交上大会审理。5 月 24 日，立法会内务委员会召开会议讨论该建议，“不反对 6 月 12 日恢复二读”及 “撤销成立法案委员会的决定” 两项议案在建制派议员的支持下获得通过。

**2019 年 5 月 30 日**

立法会建制派 39 名议员联署去信保安局局长李家超，就草案提出两项建议。第一，提高移交门槛，将可判处最高刑罚由 3 年增至 7 年或以上。第二，向香港政府提出引渡要求的国家或地区，必须要由当地的中央机构提出。政府同日傍晚，便表示接纳他们就修例内容提出的建议，宣布对修例内容作出三方面共六项修订。

**2019 年 6 月 9 日**

民阵举办第 3 次反修例游行，主办方宣布游行有 103 万人参加，警方则宣称高峰时有 24 万人。当晚 11 点，香港政府发出新闻稿，宣布《逃犯条例》将如期 12 日在立法会恢复二读辩论。其后，有示威者与警方在立法会综合大楼、龙和道、告士打道一带发生冲突。当日，全球 12 个国家，29 个城市均举行反送中集会，以声援香港的行动，其中在澳大利亚悉尼有多达 2,000 人参加集会声援。

**2019 年 6 月 12 日**

民阵及民主派发动包围立法会行动。香港民众当日以罢工、罢市及罢课的方式走上街头，聚集在立法会、政府大楼及附近街道抗议。随着万名港人包围立法会大楼，迫使原定举行二读押后。市民在下午三时左右进攻立法会，有人向警察投掷砖头及铁枝，警察发射布袋铅弹镇压，逾 20 人受伤，港府将示威定性为 “有组织的暴动”。

**2019 年 6 月 14 日**

6 月 12 日的冲突后，无线电视于傍晚播出林郑月娥的专访。期间，她以妈妈无法纵容儿子吵闹的任性行为比喻示威浪潮，并对占领金钟的年轻人感到忧心。此 “母亲论” 引起社会反弹，一群香港的妈妈因而发起联署，表明一个妈妈并不会以具有杀伤力的武器攻击自己的孩子，也不会看到年轻人在警棍下血流披面仍无动于衷。该联署在发起 16 小时后，已有三万人签署。她们于 6 月 14 日在中环遮打花园举行 “香港妈妈反送中集气大会” 反对修例。

**2019 年 6 月 15 日**

特首林郑月娥在记者会宣布，特区政府决定暂缓修例工作，以便做更多解说，听更多意见。晚上 9 时，一位 35 岁名为梁凌杰的示威男子，在金钟太古广场外墙的高空平台挂横幅反对《逃犯条例》，疑因情绪激动发生意外坠下死亡。

**2019 年 6 月 16 日**

民阵方面估计，当天有近 200 万名市民再次走上街头抗议，警方称高峰期 33.8 万人。香港立法会 24 名民主派议员周日发表联署声明，提出五点诉求：1）完全撤回而不是 “暂缓”《逃犯条例》修订；2）成立独立调查委员会，追究 6 月 9 日及 6 月 12 日警察滥用武力镇压示威者的行为；3）取消 6 月 12 日立法会外警民冲突的“暴动” 定性，并承诺不检控涉事示威者；4）立即开展单次移交台湾杀人案疑犯工作，为死者及家属讨回公道；5）因林郑月娥及其团队已尽失民心，无法有效管治，特首必须马上辞职。

香港特别行政区政府发出新闻稿，表示已停止立法会大会对修订《逃犯条例》工作，同时行政长官承认由于政府工作上的不足，令香港社会出现很大的矛盾和纷争，令很多市民感到失望和痛心，行政长官为此向市民致歉，但该新闻稿并未回应五点诉求。

**2019 年 6 月 21 日**

民间与大专学界宣布将行动升级，包括号召早上 7 时在金钟包围政府总部、行政长官办公室、礼宾府、湾仔香港警察总部、以至进行罢工罢市罢课、不合作运动及堵路等。

**2019 年 6 月 22 日**

正义联盟等 “爱字头” 组织举行“支持香港警察祝福香港晚会”，约有 300 人参与。

**2019 年 6 月 30 日**

立法会议员何君尧在添马公园发起 “撑警队，护法治，保安宁” 集会，支持警察执法，主办方称有 16 万人参加。

**2019 年 7 月 3 日**

行政长官林郑月娥在 7 月 3 日透过科技大学高层，邀请香港科技大学学生会出席闭门会议。

7 月 4 日，科大学生会表明拒绝，表示 “不敢亦不可能代表所有抗争者”，并提出三项对话条件，回应五大诉求（完全撤回修例、收回暴动定义、撤销反送中抗争者控罪、成立独立调查委员会追究警队滥权责任、立即实践真双普选）、会面须包含各界别代表，以及公开对话。

7 月 5 日，八所大专院校学生代表召开联合记者会，向传媒表示拒绝与林郑月娥举行闭门会议，又指一边谈判，一边捉人毫无诚意。就与特首会晤，大专学界提出两个要求：1）政府永不追究 6 月 9 日至 7 月 1 日反修例的示威者，不以非法集会及暴动罪等 “不公条例” 检控示威者；2）会面须公开透明，需包括各界代表，会面内容需记录，作日后检讨会面成果有否达到，亦必须有传媒及公众在场。

**2019 年 7 月 7 日**

九龙区游行，组织者称参与人数 23 万，警方称高峰期有 5.6 万人，警察与记者发生冲突。香港摄影记者协会 7 月 8 日凌晨发表声明，严厉谴责警方于清场期间，多次推撞、喝骂、甚至袭击记者，阻碍采访，妨碍新闻自由。

**2019 年 7 月 14 日**

沙田游行期间，有人在主干道冲撞封锁线企图占据马路，并设立铁马阵，有组织地在沙田正街分发雨伞等物资，同时挖开路面砖头，大批防暴警员到场布防，双方展开对峙。

**2019 年 7 月 20 日**

新华社报导，有超过 30 万的市民在添马公园举行 “守护香港” 集会，以 “反暴力、撑警队、护法治、保安宁” 作为诉求，有多位名人和影星出席。

**2019 年 7 月 21 日**

激进分子包围中联办并向国徽泼墨。

有乡事及黑社会背景的人士晚间于元朗发动袭击，攻击市民。

**第二部分  问答**

**问**：上述时间线提取的原则是怎样的？

**答**：香港过去几个月发生了太多事情，不可能一一列举，在时间线提取上秉持如下原则：1）**不关注口述经历**，个别亲历者的口述经历受个人以往经历和政治倾向影响较大，且事件发生时间距今过近，口述经历也容易受到情绪影响，除非没有更可靠的信息源（例如元朗袭击第一时间发生了什么），本文尽量避免使用口述经历；2）**不着重描述一般冲突**，大量国内媒体描述了众多暴徒袭警的细节，而境外媒体则相反，渲染警察殴打市民的场景，本文秉持 “大规模游行抗议发生时，一定程度一定范围的警民冲突不可避免 “的观点，对一般警民冲突不做详细描述。对于元朗袭击、国徽泼墨等事件，由于性质特殊，单独列出。

**问**：《逃犯条例》是不是处理陈同佳杀人案唯一的方法？

**答**：仅从这起杀人案来看，《逃犯条例》甚至就不是一个方案，更不用说唯一方案。《逃犯条例》的逻辑是，通过修订该条例，将人犯引渡至台湾，进而审判。但谁都**无法脱离主权谈引渡问题**，台湾陆委会在 2 月就明确表示不会接受一国两制下的《逃犯条例》。换句话说，要通过引渡处理这一案件，等于要内地、香港和台湾三方面把主权问题搞清楚，这是明显的简单问题复杂化。单纯从陈同佳杀人案来说，更为合理的方法分短期和长远两种，短期方案是制定 “日落法案”，相当于专案专办；长远方案是将谋杀罪从” 属地原则 “的适用范围内移除，因为香港本来不是一切犯罪都适用于” 属地原则“的。

**问**：参与游行的民众为什么反对《逃犯条例》进入立法会审议？

**答**：很多内地民众因此指责香港民众在法治问题上 “两面派”，对自由有利就谈法治，对自己不利就闹游行。首先应当说明，这不是 “两面派”，因为根据《基本法》，香港人民有游行自由，游行也是法治的一部分（游行中的暴力冲突当然不在此列），因此无论是立法会审议还是民众游行反对进入立法会审议，都是香港法治的一部分。民众之所以反对，是因为有大量香港人认为立法会是橡皮图章，立法会也不能代表民众的意愿，因此，下面笔者对香港立法会的选举制度做简介。

香港立法会选举的组别分为地区直选和功能界别（自 2004 年以后，选举委员会只负责香港特别行政区行政长官选举的提名及投票，不再参与立法会的提名工作），功能界别即职业代表制，是在 20 世纪前半代表不同职业阶层意见的方法，例如中华民国修宪前的国民大会代表有职业、妇女、海外华人团体选出代表，立法委员亦有职业团体选出者，过去 1929 年奥地利的上议院、法西斯时代的意大利及佛朗哥时期的西班牙议会等。由于现今资讯、舆论发达，多元意见可表达，目前实行此种选举的国家或地区屈指可数，除爱尔兰上议院、斯洛文尼亚上议院外，香港和澳门是少数仍用功能团体选举方法产生部分立法机关成员的地方。根据 2004 年的数据，香港地区直选选民数字为 320 万，功能界别选民数字为 19 万，当前（2012 年后）立法会共有 70 席，地区直选和功能界别各占一半（35 席）。在分组点票（由议员提出的个人议案或法案修订，表决时须以分组点票方式点算，要同时得到地区直选及功能界别界别的过半数出席议员赞成，议案才获通过；而政府提出的法案，只须获得过半数出席议员投票赞成，即为通过）制度下，代表全港选民的直选议员提出的议案，通常被选民基础少的功能界别议员否决。

功能界别是香港过渡阶段的产物，因为《基本法》第 68 条指明最终目标是全部议席由普选产生。**立法会现存的选举及投票方式和民众意愿之间的矛盾，已经导致香港立法会的执行能力陷入瘫痪（民主派提出的议案会被建制派否决，政府提出的议案会因民众游行抗议而无法审议）。**

**问**：如何看待运动中的越界行为？

**答**：港府于 6 月 12 日将运动定性为暴动是欠考虑的，因为暴动是一个有明确含义的词，即具有政治目的的集体武装行为，有暴力冲突不等于暴动，有暴徒也不等于暴动。从 6 月 15 日前港府加速推进法案二读的行为方式来看，该定性的目的应当是吓退参与运动的民众，但结果事与愿违反而直接将民众推到了政府的对立面，之后虽然没有回应民众 “收回暴动定性” 的诉求，却再也不敢重提这两个字。运动至今为止，虽然警民冲突不断，但无论是规模还是恶性程度，都达不到暴动的程度。说句不恰当的话，香港 800 万人，如果真的有 100 万人暴动，那也就不叫暴动了。

但运动中确实存在大量的越界行为，包括冲击政府机关、攻击警察、侮辱国徽、阻碍交通等，如何看待这些越界行为进而如何看待游行本身就成为一个重要的问题。笔者在此引用中国社会科学院大学马岭教授在她的著作《宪法权利解读》第八章《集会游行示威自由》中的观点：集会游行示威活动往往由于参加的人数多、参加的事由涉及切身利益或公平正义等价值判断，因此容易群情激愤，热血沸腾，进而引发暴力。但尽管如此，“政府亦不能以扰乱治安为由而一味拒绝批准”，毕竟使用暴力只是一种可能性而不具有必然性，即使可能性高于其他权利行使引发暴力的机率，也只能通过教育、法制等各种手段进行弥补，而不能因此取消、禁止或进行严格的事先审查制。何况在现实生活中，和平的集会游行示威恐怕远远多于引发暴力的集会游行示威，法治社会是文明社会，各方民众的自我克制能力及理性是文明教养的标志之一，**易冲动、行为没有分寸（如动辄行为过激、使用暴力）是一国人民在法制现代化的进程中需要克服的习性，是需要在实践中学习（所以应该提供学习场所）、需要逐步改进提高的（所以应该不断提供改进提高的机会）。**从美国 20 世纪 60 年代民权运动的情况来看，美国人并非天生就具有文明、和平、克制的美德，但他们通过后天的学习和实践逐步掌握了民主的程序和技术，以及在这些程序和技术中所蕴涵的理性和文明。

**问**：究竟有多少人参加了运动？怎样看待这个数字？

**答**：以规模较大的 6 月 9 日游行为例，组织者说 100 万人参加，警方说高峰时有 24 万人。组织者当然有虚报人数以壮声势的意图，警方则不可避免在数字上趋于保守，双方也有可能关注点不同，组织者说的是多少人参与了，警方说的是最多有多少人同时在场。抛开这些不去争论，我们假设参与了这场游行的人有 40 万，也就是香港总人口的 5%，现在来讨论这个数字意味着什么。可能很多人的直观感受是好像没什么，甚至会萌生 “真让他们去投票也翻不了天” 的想法。笔者在这里不去分析这 5% 的人后面牵连着多少人以求增大其数值，只分享一项海外学术研究的成果。哈佛大学政治学家 Erica Chenoweth 通过研究 20 世纪的数百场群众运动发现，当有超过 3.5% 的民众参与抗议时，就能带来重大的政治变革，有兴趣的读者可以自行了解详细内容。

**问**：《逃犯条例》在执行层面有没有漏洞？

**答**：可以说有。经常被提及的多重保障包括：1）适用于移交到内地的罪犯必须是犯有 37 种国际公认、且刑期都在 7 年或以上的罪犯；2）移交必须经过特区法院和特首双批准才能实施；3）条例中明确规定有 “八不移交”——不符合 “双重犯罪” 原则的不移交、政治罪行不移交、死刑犯不移交，并且不涉及新闻、言论、学术、出版等方面的行为，所以并不会影响香港的新闻自由和言论自由。

但这些保障并不是牢不可破。首先，所谓 “37 种国际公认” 的说法不知从何而来，香港逃犯条例中提及的罪犯共有 46 种，但香港与不同国家签署引渡协议时却没有统一的定数，有些超过 37 种，有些却要少于 37 种；其次，**双批准中法院有权审视案件有否表面证供，却无权盘问证人**；最后，**八不移交无法排除诬告**。举例而言，如果想要引渡一个政治犯，只需要诬陷他是一个杀人犯，并提供伪证，香港法院只能按照受到的证据决定是否批准，如果法院批准，特首也认同，引渡就完成了。笔者并不认为上述事件会发生，但这并不影响香港人可以这样想，而香港人会这样想的根源在于香港人不信任内地的司法体系。中国内地的法治水平低于香港，这几乎没有什么可争辩的，至于差距有多大，就不在这里讨论了。

**问**：为什么民众不接受 “暂缓” 或“寿终正寝”的说法？

**答**：这个问题的另一面是，为什么林郑特首不愿意用 “撤回” 的说法呢？从法理而言，**根据立法会《议事规则》第 64 款，法案提交立法会首读后，只有押后或撤回法案**，使用别的描述都属于有法不依。这就如同法院在判决死刑时不会说 “把犯人弄死” 而是 “判处死刑“，中国对台湾的主权声明也不会说“台湾是中国的地盘” 而是“台湾是中国领土不可分割的一部分”。从 6 月 15 日至 7 月 9 日，特首使用过暂缓、已停止、即时停止、完全停止、自动失效、已停止、寿终正寝等各种表述，却唯独不使用“撤回“，这也绝不是偶然。双方胶着于此，就是民众认为港府没有诚意，而港府出于某些原因不愿意以此方式展现诚意。

**问**：本次运动是否具有 “港独” 色彩？

**答**：提到 “港独”，应当明确以下几点：1）**“港独” 在香港民众中比例较低**，即使是香港民主派，其主体的行动方针也一向是非暴力且不隔绝于中国，这一点从 “港独” 人士参选议员从未成功即可看出；2）就个体而言，“港独”思想主要出现在香港的年轻人中间，但**个体思想的转变是经常发生的**，他们中的绝大多数并不极端；3）就运动而言，一次运动在不同的时间节点，由于港府和中央政府处理方式的不同，“港独” 思想的蔓延程度也不同。

具体到反送中运动，“港独”分子当然从运动开始的第一天就有所行动，但参与历次游行的多数民众深知 “港独” 问题的敏感性，因此在相当长的时间里，“港独”作为群体的声音几乎是没有的，这点从民众的口号就能看出。最初阶段具有代表性的口号是 “不撤不散” 并延续至今，强调的是运动的决心；6 月 12 日流血事件发生后，“不受伤、不流血、不被捕 / 不割席、不笃灰、不指责”的口号出现，其主旨是 “避免流血冲突” 和“内部团结不割裂”；6 月 16 日，由于前一天示威者梁凌杰自杀身亡，“齐上齐落 / 一个都不能少”的口号与黑色外衣出现，传达出示威群体悲伤和愤怒的情绪；直到七月中下旬，随着包围中联办、侮辱国徽、元朗袭击等事件的发生，警民冲突一再加剧，“光复香港，时代革命”这样的口号出现了，“港独”思想浮上水面。

“港独”思想是可恶的，但同时也是危险的，如果 800 万香港人都变成了 “港独” 分子，那香港也就不复存在了，真让人民解放军筛一遍网，香港就不再是香港，“一国两制”也就宣告失败了。因此，内地民众应该看到，**多数香港民众在反 “港独” 的问题上同样坚定，但持续的对峙会诱使 “港独” 思想蔓延**，如果只是因为极少数 “港独” 作妖，就不加分辨地仇恨全体香港人，甚至为元朗袭击这样的恶性事件喝彩，只会让香港与内地渐行渐远。

**问**：如何看待其他国家领导人对香港问题的表态？

**答**：中国外交部对此的回复一贯是 “干涉中国内政”，笔者认为这个回答是没有问题的，属于降维打击。但对于具体的问题，还是要讲清楚，为了给读者直观感受，后面我们以美国作为其他国家的代表。

第一，美国是否可以对中国正在发生的某些事件发表观点，笔者认为在一定范围内是可以的，因为中美是建交国家，有大量美国公民正在中国工作和生活，仅从这一点考虑，美国就可以对中国发生的某些事情发表言论，正如中国外交部也曾发布的 “xx 国正处于 xx 状态，外交部建议中国公民谨慎前往” 是一个道理，像当年外交部指责美国大使馆发布 pm2.5 数据为干涉中国内政就不甚妥当，当然，发表观点必须遵守相关原则，否则就是干涉内政了。

第二，美国关注中国的 “一国两制” 有否落实是不是干涉中国内政，笔者认为有待商榷。换一个场景谈，每个国家都有关税自主权，但如果一个国家加入了 WTO，就应当遵守相关协议，而其他国家也有权敦促其遵守相关协议，这与关税自主是不违背的，在当前的中美贸易战中，中方也是以此为原则要求美方遵守 WTO 相关规定的。同样，香港是中国领土，中央政府和港府执行怎样的政策是中国内政，但**包括美国在内的国际社会在香港回归后承认香港在诸多领域可以享受不同于中国内地的优惠待遇，是以中国奉行 “一国两制” 政策为前提的**，不仅是香港，内地也从这种优惠待遇中获得了利益，在此背景下，美国关注中国有否落实 “一国两制” 政策就不能不加判别地指斥为 “干涉中国内政” 了。

第三，对事件地评价不应双标，如果 “批判中国不奉行一国两制” 是干涉内政，那么 “赞扬中国奉行一国两制” 也是干涉内政，甚至于 “高度评价中国改革开放取得的辉煌成就” 同样是干涉内政，**“希望你在前面路口转弯”和 “希望你在前面路口直行” 的性质是一样的**。

当然，**欧美各国长期对中国持偏见，且长久以来习惯对别国内政指手画脚的行径仍然应当引起我们的警觉。**  

**问**：《中英联合声明》是否是一个不具有任何现实意义的历史文件？

**答**：中国外交部发言人陆慷在 2017 年表示，《中英联合声明》（全称《中华人民共和国政府和大不列颠及北爱尔兰联合王国政府关于香港问题的联合声明》，以下简称《声明》）是历史文件，不再具有任何现实意义，对中国中央政府对香港特区的管理不具备任何约束力。笔者认为，这是值得商榷的，原因如下：1）**《声明》是一份国际文件，是中英双方以各自的国家信誉为担保向全世界发出的 Joint Declaration，而不只是中国政府对英国政府的声明，也不只是中国中央政府对香港人民的声明**，《基本法》是香港的宪法，是香港内部的法律，除非有明确的条文规定，否则所谓的 “香港回归后《中英联合声明》自动失效，其内容由《基本法》继承” 的观点是站不住脚的；2）《声明》本身内容并不包含对失效日期的描述，而《声明》中附件一明确提出 **“保持香港原有的资本主义制度和生活方式，五十年不变”，这是中方的承诺****，至今尚未完成（因为五十年还没到）**，此时就说《声明》“是历史文件，不再具有任何现实意义，对中国中央政府对香港特区的管理不具备任何约束力” 等同于背弃承诺，是对中国国家信誉的伤害。

**问**：为什么香港终审法院的 17 名大法官中多数是外国人？

**答**：首先，明确香港的国籍制度， **“双重国籍” 在香港是不存在的**，中华人民共和国的公民只能持有中国国籍，这一点同样适用于港澳，所谓认为法官中有 “双重国籍” 的读者请参考 1996 年 5 月 15 日“全国人民代表大会常务委员会关于《中华人民共和国国籍法》在香港特别行政区实施的几个问题的解释”，简单来说就是，香港公民可以持有别国护照，你拿着别国护照在其他国家获得什么便利中国政府不管，但在中国国土上，只给予你香港公民的待遇，也只认你是中国公民。

其次，哪些人可以当选香港终审法院大法官呢？你当然得是个法官，没当过法官就想当香港终审法院的大法官是做梦。那么，要在哪里当过法官呢？有基本法学常识的人应该知道，**香港是普通法系，中国内地和台湾是大陆法系，两种法系的法官资质是不同的**，因此，要在香港当法官，要么是香港本地（或澳门）的法官，要么是其他普通法系国家或地区的法官，要么是中国内地或台湾出身却有在普通国家或地区当法官经历的法官，最后一种实在太少，几乎可以忽略不计。因此，能在香港当大法官的人基本上不是香港人就是外国人。

最后，为什么香港籍大法官远少于外籍大法官？先回答是不是，再回答为什么。单纯看人数，当然是这样的，但究其原理，却又不是。依据《香港终审法院条例》，不考虑有人无法出席的特殊情况，香港终审法院审判庭由 5 名法官构成，庭长由首席法官担任，另外四人是三名常任法官（本来就只有 3 名）和一名非常任法官或其他普通法适用地区法官。**首席法官依法必须由香港籍法官担任，现在担任常任法官的 3 名法官也都是香港籍，就是说，哪怕非常任法官全是外国人，到了审判庭上，也就能上场 1 名，前面 4 名法官是固定的。**因此，只要前 4 名法官是香港籍，后面哪怕有一万个外国人，终审法院也变不了天。更何况所有外籍法官都是名声显赫的法官，而且他们在担任香港大法官期间是不能拥有别国官方身份的，这跟美国司法部派几个官员来担任香港法官是完全不同的。如果有读者至此还是不甘心，觉得这五分之一的审判权让外国人持有都不能接受，请考虑一下独立董事制度，中国法律规定，上市公司至少要有三分之一的董事是独立董事（既不持股也不在公司担任职务），这实际上是行使监督的职权。**香港作为国际化的都市，外籍法官的存在，恰恰是香港高法治水平的体现，而不是所谓 “香港法律掌握在外国人手中 “的污点证据。**

**问**：中国内地和中央政府是否 “有恩” 于香港及香港人民？

**答**：内地民众普遍持有一种观点：中央政府为香港提供了众多政策支持，充分尊重香港人民的民主自由诉求，在食品、电力等必需品供应上也给予香港优待，但部分香港人不知感恩，整天游行示威，简直就是白眼狼。先说结论，**这是一种片面强调内地对香港的支持且对社会分工缺乏基本认知的错误观点。**

首先，内地民众眼中的优待有一些是不能称为优待的：1）**正常的社会分工，不能因为深圳为香港供给水电等必需品就认为这是一种恩惠**，如果按照这样的逻辑，俄罗斯向中国供天然气、中国向美国出口衬衫、美国向中国出口大豆都变成了恩惠，各国家和地区资源优势不同，分工是人类社会进步的产物，还有 “天朝物产丰盈，无所不有，原不借外荑以通有无” 想法的人该醒醒了，你的大清已经亡了；2）**《基本法》保障之权利是香港人民应有的权利，不是任何个人和组织的恩惠，不能因为香港人民在《基本法》的框架下享有内地人民暂时不享有的某些权利，就想当然地认为中央政府给予了香港人民特别优待。**

其次，中央政府为香港提供了强有力的支持，但**香港也为新中国的发展和改革开放事业做出难以替代、无法磨灭的贡献。**改革开放以前，爱国港商协助内地突破西方国家封锁，大量海外物资通过香港进入内地，一些无法经由正常途径进行的外交活动因香港的存在得以实现；改革开放之后，香港的作用更是巨大：1）改革开放初期，内地投资环境差、政策不完善、投资前景不清晰，外资犹豫观望，是香港同胞怀着赤诚的爱国之心和敢为天下先的精神，率先大胆到内地投资建厂；2）1979 年至 2007 年，内地累计吸收香港直接投资项目 28.85 万个，实际使用港资累计 3085.33 亿美元，**占内地引进外资项目和实际利用外资的 45.2% 和 40.4%，八十年代中期甚至达到 60%**；3）在内地从高度集中的计划经济体制向社会主义市场经济体制转型的过程中，香港市场经济的理念、管理模式和规范做法提供了有益的借鉴；4）香港是全球第三大金融中心，重要的国际金融、贸易、航运中心和国际创新科技中心，也是全球最自由经济体和最具竞争力城市之一，在世界享有极高声誉，即使在内地城市开放程度不断提高的今天，香港仍然是内地与国际市场联系的重要桥梁，不可替代。

前国家主席江泽民在中英两国政府举行的香港交接仪式上的讲话中提到：“**香港今日的繁荣，归根到底是香港同胞创造的，也是同祖国内地的发展和支持分不开的。**“前国家主席胡锦涛在纪念中国改革开放 30 周年的讲话中提到：“**在我国改革开放的历史进程中，广大香港同胞、澳门同胞发挥了重要作用，做出了突出贡献。**” 这两句话就是香港与内地互相支持、共同前进的最好写照。
