---

layout: post

title: “我们就是人民”——观念与东欧转型

categories: Archive

date: 2019-06-03

tags: 社会转型

image_feature: "https://i.loli.net/2019/06/03/5cf52d41ba6bd44070.jpg"

description: 全世界目睹了这一连串令人目瞪口呆的多米诺坍塌，即使相信历史是偶然的人，也不得不承认其中有着某种必然性。

---

原文来自订阅号「东方历史评论」：~~[“我们就是人民”——观念与东欧转型](http://wechatscope.jmsc.hku.hk:8000/html?fn=gh_ff1623af2f0e_2019-06-03_2654517677_lf89bZQWyJ.y.tar.gz)~~

撰文：景凯旋

《东方历史评论》微信公号：ohistory

---

## 1

1989年，东欧各国相继发生剧变。此年1月，波兰总统雅鲁泽尔斯基提议与反对派组织“团结工会”举行圆桌会议，双方在此后的谈判中同意议会由选举产生，这为团结工会在8月上台组阁奠定了基础。同年2月，匈牙利党内改革派借助反对派“自由民主战士同盟”的压力，击败党内保守派，宣布实行多党制与议会自由选举，并于9月开放与奥地利之间的边界，由此引发东德政权的崩溃。大量东德人拖家带口，通过捷奥边界逃往西德。年初，东德国家安全部长还估计反对派只有几千人，到了9月中旬，各地相继爆发大规模和平示威，昂纳克被迫下台。11月9日，冷战的象征柏林墙轰然倒塌。

![01.jpg](https://i.loli.net/2019/06/03/5cf52d41ba6bd44070.jpg)

<figcaption>柏林墙</figcaption>

接着，捷克斯洛伐克爆发“天鹅绒革命”。11月17日，布拉格的学生举行游行，要求大赦政治犯，七七宪章运动的知识分子也加入了队伍，随后他们成立了“公民论坛”来领导抗议运动。12月10日，胡萨克总统辞职。12月29日，议会选举哈维尔担任总统。11月10日，保加利亚党内发生“宫廷政变”，将总书记日夫科夫赶下台，并向社会做出举行自由选举的承诺。12月21日，罗马尼亚的齐奥赛斯库被民众起义推翻，由罗共中的改革派组成“救国阵线”接管政权。接下来，南斯拉夫的民族矛盾全面爆发，联盟在解体过程中陷入长期内战。最终，与世隔绝的阿尔巴尼亚政权亦未能幸免，允许成立独立的党派。到了90年代初，东欧各国全都实现了制度转型。

全世界目睹了这一连串令人目瞪口呆的多米诺坍塌，即使相信历史是偶然的人，也不得不承认其中有着某种必然性。不可否认，东欧剧变与苏联领导人戈尔巴乔夫的“新思维”有着密切关系，但却不是由“新思维”引导的， 而是源于东欧各国长期的内部危机，是东欧人民自身追求的结果。当戈尔巴乔夫在1987年宣布不再干涉东欧各国人民的自由选择时，这些国家的领导层感觉到这次只有靠自己了。他们做出了不同的反应，但结果全都一样，这是因为他们的起点是一样的。第二次世界大战后，东欧各国政权都是在苏联的扶持下，以人民的名义建立起来的，而在1989年的示威浪潮中，匈牙利游行队伍打出的标语是“我们要生活”，东德莱比锡示威人群高喊的口号是“我们就是人民”， 在1990年的新年献辞中，哈维尔对着广场上的公众畅谈捷克未来的民主道路，同样以这样的语言结束：“人民，你们的政府还给你们了！” 这表明，东欧各国人民在这场运动中提出的要求已经不是权力的限制，而是权力的来源。

![02.jpg](https://i.loli.net/2019/06/03/5cf52d4191c6e19135.jpg)

<figcaption>哈维尔</figcaption>

许多历史学家都相信，东欧各国执政党失去权力是由于计划经济的低效率，不能满足人民的生活需求，因此一旦遇到经济危机就会引发社会不满。的确，按照苏联式社会主义理论，计划经济可以集中国家力量，保持经济高速增长，但计划经济依靠政府的主观意志，无法避免人为设计的局限。为了尽快实现现代化，东欧国家的计划经济是以重工业和基础建设为主，无视消费品生产。国民经济发展依靠的是投资与积累，而不是消费，从而形成缺乏市场供需的短缺经济，因而难以赶上西方的经济发展和生活水平。根据数据统计，在东欧各国政权初期，物质产品净值年均增长率为6%至7%；六十年代降至2%至3%，然后又出现反弹，直到七十年代中期才又出现下滑趋势。 英国历史学家福凯斯即认为，东欧各国在八十年代普遍出现贸易和债务危机，对外贸易转向西方、国际石油暴涨是一个重要原因，东南亚经济崛起使东欧国家出口大为减少，加重了经济危机。按照《欧洲经济评论》在1989年的结论，这一年，东欧国家的经济产出是1947年以来最糟的。

然而，问题并非如此简单。一方面，与西方市场经济相比，东欧的确属于一种消费品匮乏的短缺经济，商店里常常缺乏日用品，人们日常生活的主要内容就是排队购物。但另一方面，东欧各国的生活水平多年来一直在持续改善，比世界许多贫穷国家要好得多。对于东欧国家是否在八十年代出现经济停滞的趋势，西方经济学家也一直存在争论。从统计数据看，1985至1989年，东欧各国的经济始终保持着低增长。 西方经济学家迈耶克就认为：“从增长百分比来看，东欧的经济表现还是不错的”。 更重要的是，东欧国家生活水平虽然较西方国家低，但基尼指数却没有西方国家高，整个社会并没有突出的贫富差距。如西方政治学家罗文达斯基和伍德尔在1987年写道：“由于东欧各国已经成功地在整个社会中建立起社会主义信念，如果他们能够实现自己所承诺的社会平等的话，确立社会主义政权的合法性是可能的。” 因此，东欧的崩溃不能完全从经济问题的单一线性思维加以解释。

不管怎样，贸易与外债危机只能说明民众生活水平下降会带来执政难题，却不可能造成政权崩溃。东欧国家是一个经济平等的社会，但同时又是一个没有自由的社会。就此而言，经济崩溃的说法在东欧国家是不存在的，如果一个政权毫不在乎个体的生命，并拥有强大的国家机器，再大的经济危机都可以靠突破底线的生活水平来消解掉，因此对于政权来说，永远不存在经济崩溃的可能。何况当时东欧集团的经济基本上仍然运行正常，人们的工资水平、出口量以及大部分经济指标都保持着增长。 几个重要的东欧国家，除了波兰发生严重的通货膨胀，东德靠着西德的经济支援，匈牙利和捷克斯洛伐克依靠增加消费品生产，公众在表面上对自己的命运并没有表现出非常不满。换言之，当时东欧各国即使经济不是太好，也不足以使人民走上街头。

有意思的是，经济因素诱发社会危机也是当时东欧各国许多高级官员的看法，直到面对不断发生的群众示威和大批民众逃往西德的浪潮时，东德安全部的哈内尔将军还认为：“这是因为人民对政府工作感到不满，对他们的住房条件和国家经济状况感到不满造成的。” 但是，这样的解释缺乏说服力，东德1959年的工业增长率曾高达12%，当时仍有大量人员出逃，仅在1961年上半年就有15﹒5万人出逃西德，最终迫使东德当局在1961年8月13日建立“柏林墙”。 到1988年，东德的国民生产总值人均达到11873美元，人民的纯收入从1970年的794亿马克增加到了1988年的1620亿马克，人民生活水平居世界第24位。捷克1966-1970年的经济增长率是6.9%，国民收入1966年增加5.7%，1967年增加7.5， 可在1968年却爆发了布拉格之春。波兰、匈牙利等国在八十年代初期就开始实行市场经济改革，八十年代东欧许多国家都出现了“第二经济”，如1980年代中期，匈牙利私营经济的产值已占国民生产总值的1/3强，包括约60%的服务业、80%的建筑业以及15%的工业。 但到了1989年，所有东欧国家的人民都突然走上街头示威，要求改变现行制度。

**很少有东、西方的政要和学者预见到东欧会发生剧变，反倒是身处其中的东欧知识分子预见到事物的发展，他们不是从国际政治或经济的角度，而是从思想观念的角度观察到东欧社会正在酝酿着变化**。在他们看来，东欧社会的主要问题并不在于物质匮乏，而是在于缺乏自由，导致社会道德功能失范，成为一个失败的社会。七、八十年代，东欧各国都奉行“现实的社会主义”，这意味着执政者自己也不再信仰他们最初的信念了，匈牙利政治学家亚诺什·基斯在1979年即指出：“意识形态的要求这时完全是消极的：不要向官方最高的意识挑战，或者说在某些不常见的时刻在形式上庆祝庆祝，说愿意服从这种意识形态。” 捷克作家哈维尔也在1978年指出，在东欧国家，由于制度目标和生活目标之间存在着根本冲突，它每天都发生在社会的每一个层面，当一个人想要生活在真实中时，他就自然成了制度的对立面。 这种情况下，物质越是不太匮乏的时期，人们对自由的渴望反而越是迫切。换言之，当局已经无法用谎言持续地垄断权力，社会转变的那一天一定会到来。

如果我们阅读托克维尔考察法国大革命的著作就可以发现，这种无法采用实证研究的社会观念的变化往往更具历史运动的驱动力，尽管东、西方的政要和学者都看到了东欧的经济问题，并且这也的确反映了部分事实，但却缺乏观念层面的考察。事实上，东欧各国的兴衰在本质上是一种社会观念的变化所造成的，它是全球现代性进程的一个部分，需要从历史的长时段去寻找原因。东欧现代性不仅意味着社会物质丰富和个人精神自由，同时还意味着某种非人化现象的出现。换句话说，东欧各国的思想基础是对自由个人主义的否定，而个人自由的观念在十八、十九世纪的西方曾广为传播，甚至可以追溯到文艺复兴、启蒙运动和宗教改革时期。然而，正是在非人化方面，东欧国家表现出现代性最坏的一面，将人类个体完全视作制度目标的工具，对此没有一个民族是愿意长期忍耐下去的。

## 2

必须指出，罗文达斯基和伍德尔没有理解错东欧政权的制度目标与承诺，也没有忽略东欧人民在二战后的诉求，以及此后近半个世纪的社会实践，那就是**社会平等的理想**。从更远的历史角度看，东欧各国当初建立的政权既是苏联式的，也是法国式的，具有这两次革命追求社会平等的主要特征，并且采取了经由人民赞同的暴力方式去剥夺有产者。而早在一百多年前，托克维尔针对法国大革命前知识阶层的思想与整个社会的情绪，就已指出：“他们对平等的热爱是那样明确，对自由的爱好是那样不明朗。简直就像是我们同时代人。” 应当补充一句，这简直就像是四十年代末的东欧各国人。

在《旧制度与大革命》中，托克维尔对于大革命的起因与结果有一个重要结论：法国大革命的基调是追求平等，但却忘记了自由。自由的主张是法国革命前最后才提出的，也是第一个消失的。 对法国革命产生很大影响的经济学派强调公益，却无视契约与个人权利，“他们热爱平等，哪怕是奴役中的平等。” 事实上，革命前王朝政府已经较前更加尊重自由，社会矛盾主要是阶级区隔产生的不平等现象，导致革命爆发时所有阶层都反对王朝专制，并且都希望建立起新的中央集权，以实现启蒙思想家们的社会平等理想，建立一个“人人彼此相像、地位平等”的社会。

托克维尔在其研究中观察到一个普遍的社会心态，即人们对平等的渴望永远比自由更强烈，也更长久。 某种程度上讲，自由更多的关涉个人，而平等更多的关涉群体，平等可以给下层社会带来现实的物质利益，也更符合知识阶层心中的社会正义和道德观念。就此而言，任何社会中自由都远不如平等有吸引力。普通人往往热爱平等，但却未必热爱自由。对一个政权来说，平等显然也更容易与专制结合起来，因为人人平等的实现必须依靠政府权力，而任何自由都只会削弱政府权力。在托克维尔看来，法国大革命建立起来的专制最终取消了思想言论自由，也使得人们的公益品德完全被窒息。

历史竟然是如此相似。第二次世界大战结束后，东欧各国人民同样面临要自由还是要平等的选择。尽管东欧各国采用苏联模式有着外部强加的因素，但也有着自身选择的因素。二战前，捷克就已实现了民主制度，东德、波兰和匈牙利则经历过政治自由主义、立宪政府和选举，罗马尼亚、保加利亚、阿尔巴尼亚则是非民主国家，但有一点各国则是相同的，自十九世纪末以降，社会平等的观念已成为东欧各国人民的主要诉求。匈牙利作家马洛依·山多尔描写世纪初社会的作品就反映了这一时代精神的潮流，下层阶级并不关心自由，却对不平等心怀怨恨，就连贵族阶层也以崇尚平等为荣。 东欧知识分子普遍受社会民主主义影响，同情下层阶级的处境，如捷克作家哈维尔出生大资本家家庭，可终其一生都痛恨社会不平等现象。

**尽管东欧社会主义是外部政权强加的，但其理论的核心是追求社会平等**，因此建立强大的中央集权，实行公有制和计划经济，并不与东欧知识分子及多数民众的基本诉求相悖。战后，整个欧洲普遍认为，自由资本主义是二战的祸根。即使西德的基督教民主联盟和英国的保守党都支持政府在经济中扮演重要角色，包括工业国有化，发展福利国家。东欧国家在三十年代的经济大萧条中受到的损害最为严重，经历了世界大战之后，一代人仍然保有贫穷、失业和饥饿的记忆。战争结束后几个月，匈牙利影院播放了一部雅尔塔会议的新闻片，当看到罗斯福对斯大林讲话时，影院里的观众高喊：“管好你自己的事！”在波兰，孩子们在大街上对着苏联士兵喊叫：“请关怀我！”**经历过长期的外来强权欺凌，东欧人普遍具有一种解放情结。他们对民族、阶级的平等充满正义的渴望，同时却缺乏对自由的真正理解**，这使得他们更倾向于受法国的浪漫主义影响，而不是受英国的经验主义影响，因而将新社会的来临看作是人类的曙光，充满激情地抛弃了西方的民主制度。

一个明显的例子就是，战后东欧各个党派组成的民族阵线都主张工业国有化，如保加利亚的“火炬”集团就主张“通过自上而下的政治指导使保加利亚现代化”， 这一纲领与保共是一致的。有的国家的社会党、社会民主党甚至比共产党还要激进，如捷克左翼社会党甚至主张由工人直接控制企业。 既然所有阶层、所有党派都支持社会主义的平等主张，支持建立强有力的中央集权政府，不同党派之间的分歧只是多党制与一党制之争。一般来说，东欧各国建立一党制的过程大同小异，先是成立一个联合政府，接着清洗联合政府中的非党人士，然后从政治生活中摒除所有其他党派，最后建立起一党统治。

在建立一党制的过程中，东欧各国全都是采用了民主投票的程序。1945年的选举中，保共控制的“祖国阵线”获得88%的选票。1947年的议会选举，波共领导的“民主派集团”获得80%的选票。匈共领导的“人民阵线”在1947年获得22%的选票，在1949年则赢得了95.6%的选票。在南斯拉夫，则是一开始就由南共主导国家重建，当时绝大多数民众都拥护南共。在1945年的大选中，捷共获得38%的选票，1948年的“二月革命”，捷共在250万工人总罢工的支持下，逼迫其他党派退出政府。在回顾这段历史时，作家昆德拉写道，当时“既没有流血也没有暴力，而是得到半个民族的欢呼致意。”

![03.jpg](https://i.loli.net/2019/06/03/5cf52d41a483519834.jpg)

<figcaption>1948年，捷共逼迫其他党派退出政府</figcaption>

这次政变也得到了广大知识分子的支持，剧作家帕维尔·科胡特回忆道，当时二十岁的他在广场上看到哥特瓦尔德站在主席台上，激动地写下一首颂歌：

> 鲜花盛开的五月，/远处古堡的上方/胜利的旗帜高高飘扬：/“真理战胜一切！”/工人阶级的话光芒四射！/工人的真理战胜一切！/我们走向辉煌的未来。

对此，作家克里玛解释道：

> 他们通过将乌托邦景象和煽动性的许诺相结合，也通过诉诸普通市民关于社会的秩序和正义组织的观念，而获得了声望。对于陷入暗淡的日常生活中的人们来说，他们提供了一个伟大的理想，而且还提供了一个具有超凡魅力的领袖，他把人们从不得不自己做出决定或不得不承担责任和风险的重负中解救出来，并且领导人们朝着一个赋予他们生活以意义的目标前进。

可以说，**正是新政权的社会平等主张吸引了整个社会和所有民族**，使得民众相信，通过当政者无私的服务，在国家的统一计划下，从此可以实现社会的普遍平等。正如托克维尔早已揭示的，在法国革命中，对平等的追求使民众站在自由的对立面，无视政权摧毁与自由相悖的许多制度、思想和习惯。“在他们的理想社会中，只承认人民，没有其他贵族，除了公务员贵族；只有一个唯一的、拥有无限权力的政府，由它领导国家，保护个人。” 显然，二战后东欧各国的群众心理同样也是如此，大多数人愿意放弃个人自由去实现社会平等，并把自己奉献于这个伟大的事业。

对于捷克人来说，共和国第一任总统托马斯·马萨里克的儿子、时任外交部长的扬·马萨里克的死亡仍然引起了他们的哀悼，他和他的父亲曾代表着一个很有希望的时期。扬·马萨里克死于1948年3月10日，他是跳窗自杀还是被人从窗口抛下去，这在后来一直都存在争议，但他的死却无疑标志着一战后的捷克及东欧其他一些自由主义政府的终结，代之以一个新时代的到来。

从四十年代末到五十年代初，所有东欧国家都按照苏联模式，没收资本家和旧官僚的财产，对工业、银行和私人保险公司全部实行国有化，在农村进行土地改革，把富农的土地分配给贫苦农民并鼓励他们建立农业合作社。自1948年底至1950年，东欧各国工业国有化比重分别是：东德76%，匈牙利81%，波兰92%，罗马尼亚95%，保加利亚95%，捷克斯洛伐克96%，阿尔巴尼亚97%，南斯拉夫甚至高达100%。中央集权的政府完全控制了国家的经济生活，指令性经济和五年计划很快就恢复了战后经济，人民生活得到了改善。

新政府的确践行了社会平等的承诺，大批工人被提拔为官员，从前的官员则变成工人。如在1951年，捷克有近八万旧政府雇员被赶出政府部门，安排到工厂当工人。在工资收入上，政府官员、知识分子和工人的差别并不大。到六十年代初，捷克斯洛伐克的收入分配是最平等的一个国家。 在匈牙利，一半以上的各级官员是从前的工人、农民，普通官员的工资仅比技术工人高12%。在波兰，许多工人的工资甚至比知识分子要高。

在东欧各国，社会平等的诉求早已深入人心，充分就业、廉价商品、免费教育、公费医疗都被视作理所当然。工农子女有了更多的机会接受高等教育，在波兰，工农出身的学生占比由1946年的11%上升到1950年的63%，而知识分子家庭的学生则由1936年的35﹒5%下降至1960年的1﹒2%。 在匈牙利，工农子弟占大学生的比例分别是65%和55%。 捷克工人子女的比例从1938年的10%上升到1956年的31%，到1963年更是接近40%。此外，男女平等也得到了实现，妇女进入了所有的职业领域，以捷克斯洛伐克为例，从1950年到1970年，妇女参加工作的比例从54%上升到85%，受过高等教育的专家有46%是女性。

正如克里玛所指出：“早期阶段的极权主义制度在很多方面是令人钦佩的：它的果断、它的明确纲领以及处理问题的能力。这些问题是一个民主制度因其特性而无法以那种方式解决的。” 也就是说，这一切都是在完全平等的名义下，通过强迫的方式来实行的。如波兰在1952年逮捕了成千上万的农民，因为他们不愿向国家上交粮食。捷克斯洛伐克将反对农业集体化的农民戴上富农帽子，仅斯洛伐克就有2400农民被判处反国家罪，瓦楚里克的小说《斧子》即描写了集体化对乡村传统价值与亲情关系的摧毁。罗马尼亚在1949年有3000地主被驱离故土， 有八万农民因反对集体化被捕。 在匈牙利，一大批旧官员、工厂主、银行家以及富裕的律师、职员、医生等被没收财产。1951年，布达佩斯有5893个家庭被勒令限期搬迁出首都。富农则成为农村的打击对象，备受歧视，对那些不愿意加入合作社的农民，当局随意殴打和罚款。1948年至1953年，匈牙利全国就有四十万农民因不愿交公粮而被逮捕，八十万农民被罚款。

五十年代初，东欧各国政权都赞同这样的理论，即在社会主义建立之后，阶级斗争仍在日益尖锐化。捷共领导人斯兰斯基就曾强调：“发现我们中间的敌人，因为他们是最危险的敌人。” 这个理论先是用来清洗非党人士，反集体化的农民与投机倒把的小商小贩，坚持自由民主理念的知识分子，后来又用来清洗党内反对派。如捷克的斯兰斯基和胡萨克、波兰的哥穆尔卡、匈牙利的拉伊克和卡达尔、保加利亚的科斯托夫、罗马尼亚的巴特拉斯卡努、卢卡和特奥哈里、阿尔巴尼亚的多德捷、南斯拉夫的吉拉斯等，尽管缺乏任何证据，这些人或者被处死，或者遭到长期监禁。当然，受害者中绝大多数还是一般民众，对他们的清洗并没有举行公审，有的甚至没有经过司法程序。

执政党控制了政治、经济和文化所有领域，议会虽然给其他党派保留部分席位，但却是橡皮图章，国家权力掌握在党和政府手上。为了全面摧毁民间社会，成立了由国家控制的工会、青年组织、妇女组织和作家协会等群众团体，将全体国民纳入一个划一的社会。同时，实行强制性的劳动组织和义务劳动，南斯拉夫、保加利亚和阿尔巴尼亚是建立“劳动营”，波兰是建立“为波兰服务”组织，每年六个月义务劳动。政府还不断增加劳动时间，提高劳动定额，降低实际工资，强化劳动纪律，同时经常宣传劳动模范，供全社会仿效。 东德的电台则宣称：“有必要在每一件事情、每一个计划、每一个部门讨论党的路线并在日常工作中执行它。”凡是对生活感到不满的人，都会被视作是反对政府而遭到威胁和镇压。

事实表明，由于实现平等的途径往往需要通过政府的力量，因此在平等的名义下，这个制度建立的只能是一个限制自由而不是限制权力的政权。

那些领导了这场革命的人告诉人们，他们与大多数人民的理想是一致的，目的是实现一个完全平等的社会。事实上，对于多数东欧民众来说，他们对自由的理解就像法国大革命中的民众一样，“**人们似乎热爱自由，其实只是痛恨主子**”。 换言之，他们并不拒绝自己当国家的主人。可他们没有意识到，自由实际上与社会地位和物质利益无关，它本身就是幸福，正如托维克尔所说：“谁在自由中寻找自由本身以外的其他东西，谁就只配受奴役。” 如今东欧民众终于明白，原来劳动就是自由，就是光荣。

## 3

在东欧剧变之后，英国历史学家福凯斯曾总结东欧国家的八个特征：苏联模式，意识形态控制，一党统治，没有法治，国家控制经济活动，实行计划经济，优先发展重工业和忽视消费，产生了一个新的特权阶级。

在历史的意义上，这些国家正在实现法国革命开始的理想，即“财产公有制、劳动权利、绝对平等、一切事物的划一、一切个人活动的刻板安排、一切由上级规定的专制制度和公民个性完全并入社会整体。” 新制度建立的中央集权似乎缩小了阶级差别，扩大了社会平等，但却比任何旧制度都更不自由。它所建立的是一个如托克维尔所称的“人人彼此想像、地位平等”的一致性社会。在这个人人相似并依附国家的社会里，社会主要矛盾不再是表现在社会各阶层之间，而是表现在权力者与无权者之间。

事实上，**没有自由也就意味着没有真正的平等**，平均主义并没有产生一个无阶级的社会，反而产生了德吉拉斯所说的一个“新阶级”，他们“把国家资产当作它自己的财产,把‘社会主义社会’和‘国家’变成了一句空话。新阶级害怕动摇极权权威会动摇其【财产】占有。所以新阶级以维护‘社会主义’所有制为名,反对任何形式的自由。” 那些高级官员享受着特供商店、特殊医疗服务、休假胜地、高级住宅和别墅，子女有优先受最好教育的保证等。正如英国学者福凯斯所说：“他们不但要保住自己的地位，而且要把他们的特权传给子孙后代。” 一位匈牙利高级官员也在回忆录中自嘲地说，他觉得自己似乎已生活在按需分配的共产主义社会。 而一位波兰官方作家则于1987年在党刊《新道路》上公开承认：“四十年的社会主义既没有消灭人对人的剥削，也没有实现社会公正。”

国家不仅垄断了经济，而且还垄断了权力和思想。这种总体性的社会垄断再次证明了托克维尔的结论，中央集权的国家是最难产生自由法治的国家。当一个政府全面控制社会，甚至消灭社会之后，法律也就成了一纸空文，无视法律的事屡见不鲜。另一方面，随着全社会各阶层地位的平等化，自由的欲求必然会渐渐显露出来，因为从十九世纪至今，东欧各国人民毕竟是享受过自由或知道过自由而后又丧失自由的。克里玛曾写道，极权的根本原则就是思想统一，压制精神活动，“它不但一定会跟许多个人的需求发生冲突，而且也跟整个社会的需求发生冲突。” 就此而言，计划经济的弊病还不在于其低效率，而是在于其缺乏劳动的自由。最初看上去曾充满生气的体制，如今却变成压制自由的体制，社会的物质和精神活动的空间变得越来越狭窄，令人窒息。可以说，在此后的几十年间，东欧国家的社会矛盾不是由于平等的问题，而是由于自由的问题。因此，在各国发生的历次社会抗议中，自由不仅是知识分子的目标，而且也是民众的主要诉求。

当然，在当局对社会的严厉控制下，知识分子往往会首当其冲，因为知识分子对自由更加敏感，这使得知识分子的被迫害成为东欧国家令人注目的现象。例如，1952年捷克有15位作家总共被判220年的刑期，到1960年获得释放时，他们已经服了大约130年刑期。1956年匈牙利事件失败后，许多知识分子遭到逮捕，作家协会和记者协会被停止工作。波兰在1957天也曾大规模整肃知识分子，如《新文化》编辑部的大部分编辑被开除。六十年代，由于反对当局迫害哲学家科拉科夫斯基，就有22名著名作家被开除出党。1968年捷克布拉格之春后，更是有高达900名大学教师（包括65%的马列教员）、40%的记者被开除公职，231名作家被禁止发表作品。根据米兰·希麦尔的回忆，清洗的标准是“具有独立思考的头脑、慷慨、能容忍、受教育多，有高度的道德原则，有勇气，等等。” 显然，当局的目的就是要让独立思考的知识分子完全脱离公共生活。

今天看来，1956年的匈牙利事件和1968年的布拉格之春已经预示了苏联集团的最终瓦解，自那以后，政权在理论与道义上就已经破产，从此民众对政权的服从就不再是出于热情，而仅仅是出于恐惧。这两次运动的党内改革派都提出“人道的社会主义”口号，而知识分子和青年学生则要求得更多，其最主要的诉求就是自由民主。不待说，社会平等无疑是一个美好的人类理想，但绝对的经济平等同时也意味着消灭人与人之间的差异。东欧知识分子和民众渐渐意识到，就人类生活的多样性而言，凡是追求一致性的社会，都会摧毁一切个人自由，正如科拉科夫斯基所指出：“平等主义乌托邦的梦想是要消灭一切能够将一个人与其他人区别开来的东西，一个人们居住在相同的房子、相同的城镇、相同的地理条件中，穿着相同的衣服，分享相同的观念的世界是人们熟知的乌托邦画面。鼓吹这样的理想等于在暗示，主张一个人自己的个性的行为中存在着一种内在的恶，即使没有伤害其他人——换句话说，成为人就存在着某种本质性的错误。”

![04.jpg](https://i.loli.net/2019/06/03/5cf52d417e52898078.jpg)

<figcaption>布拉格之春</figcaption>

匈牙利革命的宗旨就是争取自由，争取人之为人的权利，发起者是知识分子为主的裴多菲俱乐部，他们和工人群众要求清算大清洗的恶果，给工人更多的自治，作家协会要求民主选举领导班子，自治学生会更是提出多党选举、思想言论自由、释放政治犯的要求。1956年10月匈牙利《共产主义青年报》的一篇社论就宣称：“我们进行的是一场为获得自由的斗争，这同我们的祖先在1848年进行的斗争是完全一样的。” 在10月23日的集会上，人们朗读了斐多菲歌颂自由的诗歌，一些著名作家走在游行队伍的前列。

苏联军队用坦克镇压了这场民主运动，匈牙利人民进行了殊死的武装抵抗。布达佩斯与其他城市的工人成为这场抵抗运动的主力。此次事件导致2700多人死亡，20万人逃往西方。 匈牙利人民在这场运动中表现出了人的全部尊严，纳吉在临终前的遗言中写道：“我相信，历史将宣判杀害我的刽子手。只有一点是违背我的意愿的：将来杀害我的人来替我平反昭雪。” 当苏军进入国会大厦时，政治学家、国务部长伊斯特万·毕波独自留在那里，他镇静地撰写了一份宣言，号召匈牙利人民坚持抵抗外国入侵。在其去世后出版的《政治必读》中，这位思想家指出自由不是一个相对的概念，如果自由意味着一个团体以损害其他团体的自由为代价所获得的自由，那么这种自由只是徒有虚名。 人类自由与尊严是不可分割的，为此，毕波提出应当重建道德现实主义，进行“人类尊严的革命”。 后来的年轻政治学家亚诺什·基斯受到启发，同样从人类尊严的角度去探讨人权理论，他在1986年的一篇讨论人权的文章中写道：“应当抗议，因为人的尊严受到侵犯。应当抗议，因为不作反抗将损害我们自身的尊严。应当抗议，这是为了将这种损害尊严的行为公诸于世，为了我们能够说出公民的基本权利并不归功于国家的仁慈，公民本身就拥有人权。这是我们最基本的权利。”他们的论述是对匈牙利革命最精辟的阐释。

捷克的布拉格之春同样是由知识分子发起的，前此一年的第四届作协大会上，作家们公开要求创作自由，瓦楚里克的发言甚至提到民主制度，他认为民主制度固然比较偏袒被统治者，但当政府垮台时，却能保护统治者免遭处死，“政府倒下去，公民就会重新站起来。反之，在政府长期站住的地方，公民就倒下去。”但是，在捷克已经没有真正意义的公民了，瓦楚里克说道：“我站在这里说话时，并没有得到那种喜欢说什么就说什么的自由感，而这种自由感是每个人都应该有的。” 瓦楚里克的此番发言表明，经历了多年的专制之后，东欧作家对于民主自由的理解并非一无所知，而是有着深刻的认识。

在知识分子与公众的支持下，捷共改革派在1968年4月提出“行动纲领”，包括减少权力集中，让各阶层参政，建立责任内阁，保证公民权利，为大清洗中受迫害的人恢复名誉，引进市场机制，企业自主经营，保证集会、言论、结社自由以及扩大企业自治等。6月，瓦楚里克应一批科学家的要求，撰写了《两千言》宣言，进一步明确提出民主化的主张，得到社会各阶层的一致支持。当苏联军队入侵时，捷克人民展开了抵抗。一夜间，所有路标都改了方向，村镇换了名称，占领军找不到地方，苏联士兵只能啃地里的马铃薯。大街上，人们围着苏联军人抗议，穿着迷你裙的姑娘们故意在坦克前露出大腿，挑逗手足无措的年轻士兵。地下电台的女播音员告诉人们：“布拉格终将成为一座沉默之城，但我们的语言还在空中，他们的子弹无法击落我们的声音。”此后的一年多时间，捷克民众一直在零星地抗议所谓的“正常化”。1969年1月16日，查理大学学生扬·帕勒克为抗议苏联入侵，在瓦茨拉夫广场自焚。在他的去世公告上，帕勒克的父母引用了中世纪宗教改革家扬·胡斯的名言：“坚守真理，至死方休，因真理将令你自由”。许多布拉格市民自发参加了他的葬礼，从此将对自由的追求埋藏在内心深处。

其他东欧国家也不断发生反抗事件。早在1956年的波兰文学艺术理事会上，作家安东尼·斯沃尼姆斯基就发言批评苏联提倡的“社会主义现实主义”创作方法，并且要求“公共生活的真正民主化……和恢复合理的不受约束的思想”。同年六月爆发了波兹南事件，工人们因反对增加生产定额而罢工，他们在示威中喊出的口号是“我们要自由”、“结束苏联占领”等。 由于波兰领导人哥穆尔卡顶住了苏联的干预企图，波兹南事件最终没有导致苏军入侵，当局释放了关押三年的大主教维辛斯基，允许学校恢复宗教课程，并暂时放弃了农业全面集体化的政策。事件的平息没有解决波兰社会的根本问题，当局甚至在第二年即发动清洗和审查，清算党内修正主义者，其中包括波兰最著名的哲学家科拉科夫斯基，但这次事件却激发了匈牙利革命，并为波兰1980年的工人运动埋下了伏笔。

在东德、南斯拉夫、阿尔巴尼亚、罗马尼亚、保加利亚等国，虽然没有发生过大规模的反抗，但各种形式的抗议却是不绝如缕。1970年，由于东德在世界经济中跃升第九位，昂纳克于1972年宣布艺术和文学领域没有禁区，作家、艺术家们于是借机用作品来表达不满，文艺开放政策只好中缀。那些控制更严的东欧国家同样不时发生反抗行动，在罗马尼亚，有1977的丘河矿山罢工，1987年的布拉索夫红星拖拉机厂罢工。在保加利亚，农民们充分表现了他们的聪慧和幽默。如在一次合作社的会议上，官员作了报告后，主持人请听众提问题。所有人都像通常一样沉默。主持人坚持说：“请提问，同志们！请自由提问，同志们！”仍是沉默。终于，一位叫乌特的农民站了起来，问道：“我们的粮食到哪儿去了？”下一次会议上，主持人再次请听众表达看法，人们又一次保持沉默。主持人重复了一遍要求。终于，一个农民举起手，问道：“乌特到哪儿去了？” 而南斯拉夫学者米哈耶罗夫在1971年写道：“当我们沮丧地看到大量西方年轻人倾向于极权主义时，在已经建立的极权主义体制里，那儿的年轻人却开始明确地提出相反的要求，他们追求西方年轻人认为‘过时的’、‘布尔乔亚的偏见’的所有东西：言论自由、出版自由、法治。”

东欧各国的掌权者终于发现，他们宣扬的所谓社会平等，已经不再吸引工农大众，更不用说知识分子了。

## 4

面对越来越频繁的社会反抗，当局意识到自己陷入空前的孤立，同时又绝不愿轻易放弃权力，于是只能一方面继续采用强制手段，另一方面则利用物质诱惑，制造表面上的社会稳定，但这一切都不过是在往后拖延时间罢了，正如捷克哲学家克哈克所说：“今天强制性的稳定必然会导致明天的不稳定。” 就制度的性质而言，当局面临着一个无法解决的难题，国家与社会从来都是两个不同的人类机制，但现代极权的基础即是用国家取代社会，它所追求的一致性社会在本质上是与人性相悖的，并最终导致社会价值功能失范，因而它不得不同一代又一代人的人性搏斗，把一切个人权利都看作是对政权的威胁。有时候，它可以利用人性的弱点，暂时取得某些效果，但更多时候，它必须压制人性对自由的本能诉求，而这往往是徒劳的，不可能永远维持下去。

克里玛在谈到父辈与自己这代人的区别时，曾指出上一代人经历了三十年代的经济大萧条和第二次世界大战的纳粹占领，所以普遍向往社会平等的理想，但几十年后，时代的核心问题已经转移：“我们父辈关注的是社会问题，我这代人关注的则是正义问题。” 克里玛本人就因参与布拉格之春，有二十年时间不能公开发表作品。渐渐地，越来越多的人想要摆脱僵化窒息的环境。七十年代，东欧各国政权普遍实行“现实的社会主义”，试图在提高人民生活水平的同时维护绝对权力，但专制的裂罅已经越来越大。这个时期捷克、波兰和匈牙利等国都出现了独立于官方之外的萨米亚特、读书会、讲座和音乐会，尤其是青年人的嬉皮士运动、爵士运动、乡村音乐等，形成一种独立于官方文化之外的“第二文化”现象，参与者主要是青年人。

在捷克斯洛伐克，摇滚乐成为叛逆的象征。如“宇宙塑料人”摇滚乐队曾风靡一时，其中一首《百分百》唱道：“他们害怕老人的记忆/他们害怕年轻人的思想和理想/ 他们害怕葬礼，和墓上的鲜花/他们害怕工人，害怕教堂，害怕所有的快乐时光/ 他们害怕艺术，他们害怕艺术/ 他们害怕语言这沟通的桥梁……那么我们到底为什么要怕他们？”八十年代初，朋克运动在西方兴起时，东欧也出现了许多乐队，如波兰的“朋克小姐”、匈牙利的“科特斯朋克”、捷克斯洛伐克的“塔腾特”、东德的“潘科”等。他们的歌往往具有政治反抗意味，表现出更年轻一代人对自由的渴望。

![05.jpg](https://i.loli.net/2019/06/03/5cf52d4199bc092845.jpg)

<figcaption>“宇宙塑料人”摇滚乐队</figcaption>

青年人的文化反叛得到知识分子的大力支持。1976年，民谣作者沃尔夫·比尔曼在西德旅行时发表言论，抨击体制对艺术的控制，被东德政府剥夺公民权，12位知名作家为此写了抗议信，100多名知识分子加入签名，其中有东德当代最具国际影响的官方女作家克里斯塔·沃尔夫。同年，捷克“宇宙塑料人”摇滚乐队遭到审判和监禁，知识分子意识到这是对所有人的自由的威胁，用哈维尔的话说，这些年轻人的粗俗言行背后，有着“一种严肃和真诚的东西，是对现实生活经历发自内心的自由抒发”， 同时也是年轻人突破生活的一致性，追求“生活在真实中”的具体表现，当局对他们的审判即意味着对生活本身的侵犯。在他看来，“如果不挺身捍卫他人的自由，便是放弃自身的自由。” 于是他组织了一些萨米亚特作家和学者发表公开信表示声援，参与者包括后来的诺贝尔文学奖得主塞弗尔特和一些改革派共产党人。这次抗争的结果产生了著名的七七宪章，这一历史文件最初以宣言的形式刊登在西德的报纸上，公开要求当局兑现在1975年赫尔辛基协议中对人权的承诺。

布拉格之春后，波兰哲学家科拉科夫斯基也曾发表一篇文章《希望与无望》，指出这个制度是刚性的，不能再把希望寄托在上层的改革愿望上，但这个制度又不是绝对刚性的，希望在于社会的压力。“第二文化”体现了捷克学者瓦茨拉夫·本达所说的“平行政体”，即在文化、教育与经济等领域，建立起独立于国家之外的平行社会结构，以实现公众的自我管理。这实际上就是托克维尔在《论美国的民主》中曾经描述过的市民社会。这个时期，知识分子对于当局的改革已经不抱希望，认为真正的改变只能寄望于市民社会的重建和成长。重要的是不再是建议当局做什么，而是建议国民做什么。从“生活在真实中”到“平行政体”，东欧知识分子的认识在逐渐深化。

在八十年代，捷克、匈牙利和波兰都出现了“第二文化”和“第二经济”。所谓“第二经济”，亦即私人经济。布拉格之春后，东欧各国当局都意识到，不能再依靠制度的远景来吸引人们，必须在商店的橱窗里摆满商品，而实现这一目标只能借助个体经济。例如，匈牙利在1982年通过了一系列私人产权合法化的规定，扩大了私人企业家的经营范围。据估计，八十年代初，在匈牙利就有8﹒4万个个体从业人员，满足了国内近60%的服务需求。 这表明，计划经济导致的物质短缺并不仅仅是一个经济问题，而是与社会的自由相关。因此，这些私人企业家并不满足于此，他们成立了代表自身利益的独立组织，并联合其他社会团体向政府施压，要求被赋予法律地位，从而向国家的权力垄断提出了挑战。 在波兰，米奇尼克等知识分子甚至直接介入了工人运动，成为团结工会的指导者。

在东欧各国民众的抗争中，知识分子发挥了巨大影响。当局的制度目标在四十年代曾经得到广大知识分子的支持，对于追求时代精神的知识分子来说，社会平等比个人自由更重要，也更具历史的进步意义。他们讴歌美好未来，为平等提供理论，但却无视了自由的重要性。正如克里玛所指出，当年政权许诺给民众社会福利和物质保障时，知识分子“没有捍卫他们生活中不可或缺的自由，而是帮助消灭了自由。” 经历了乌托邦幻想的破灭之后，正是这些知识分子中最具有独立思考能力的人开始了反思，并在严酷的压制下表现出罕见的道德勇气。哈维尔、米奇尼克等人提出“如同”（as if ）的思维，即如同一个自由的人那样去谈论自由，进行非暴力抗争。尽管这些知识分子手无寸铁，却在道德上占据了优势，成为使生活变得更好的希望。他们的努力无形中影响了许多青年人，在那些渴望真实生活的年轻一代眼里，甚至认为被迫害是件值得荣耀的事。

东欧知识分子的论述不同于西方的现代性批判，很少涉及到市场和法治，主要聚焦于普遍的人性危机和严重的社会道德失范，强调个人道德责任对社会重建的作用，如科拉科夫斯基提出的“生活在尊严中”，哈维尔提出的“生活在真实中”，都是在阐释人性、存在和伦理的自由。由于当局曾许诺社会平等的美好前景，结果却摧毁了组织社会的所有方式，使多数人丧失了高尚的道德情感，这比物质匮乏还要糟糕。社会的物质匮乏还可以改变，但人心坏了就很难恢复了。东欧知识分子对于人人相似而又彼此冷漠的社会道德的思考，再次印证了托克维尔一百多年前的名言：“只要平等与专制结合在一起，心灵与精神的普遍水准便将永远不断地下降。” 对于多数民众来说，这些看似抽象和超越的思考实际上反映了自己的真实感受，与每个人的日常生活密切相关，从而使他们渐渐意识到，这种剥夺个人自由和摧毁社会道德基础的制度再也不能存在下去了。

正是知识分子的思考启迪了整个社会的观念，为1989年东欧各国的制度转型奠定了基础。令人惊奇的是，在东欧各国相继发生示威的那些日子里，平日里沉默谨慎的民众和嬉笑玩闹的青年人突然都充满了激情，将自由的诉求作为最重要的目标，充分体现了阿伦特所说的那种“真理的时刻”。克里玛在1990年的一篇文章中写道，1989年的剧变与1948年的剧变是很相似的，这两次事件都没有流血，1948年的民众示威是要求结束民主，四十年后，民众示威是要求结束极权。当年的印刷厂工人拒绝为其他党派排字，捷共成为唯一影响公众舆论的政党；如今印刷厂工人却威胁着要罢工，因为他们的报纸不能真实地报道正在发生的事件的真相。 这一切都表明，经历了四十年的极权统治，民众的观念已经发生了巨大的变化。尤其是年轻一代已经对当年匈牙利事件和布拉格之春所提出的目标不感兴趣，而是要求彻底的制度改变。值得注意的是，除了罗马尼亚和南斯拉夫，东欧各国的制度转型基本上是和平有序的，当局早已丧失了维持制度运行的一切手段和号召力。剧变发生时，很少有人站在当局一边，也很少有人呼吁暴力。

可以说，**1989年东欧各国的制度转型实际上是一场观念的革命，其中蕴含着东欧人民对历史的回顾，剧变不过是践行了他们几十年来的沉痛反思**。当然，在东欧各国建立起自由民主制度，确立以私有制为基础的自由市场经济后，社会平等的问题又将成为主要的矛盾。正如捷克哲学家卡莱尔·科西克所指出：“我们只是从一个被利刺包裹的岩洞来到了一个舒适安逸、被天花乱坠的宣传所照亮的巢穴。” 事实上，东欧国家转型后曾一度面临经济衰退和贫富差距，导致政治纷争不断。同时，追逐财富成为新的集体目标，而民主则因为视作理所当然而不被重视，甚至在某些地方，民主还被认为是一种障碍。 这表明，自由与市场绝不是一种万应灵丹，能解决一切社会问题，给人们带来永久的福祉。

但是，正如不能完全用经济因素来解释东欧的剧变一样，也不能用经济因素来证明东欧人的选择又一次错了，东欧各国宁愿满足欧盟的苛刻经济标准也要坚持加入欧洲一体化进程，坚决维护民主自由体制，甚至不惜付出巨大的社会成本。这一事实表明，东欧各国人民或许已经懂得，人类问题永远没有完美的解决方案，他们应当不会再为了平等而牺牲自由，为了消除贫富差距和不安全感而重新乞灵于国家主义。如果他们能牢牢记住历史的教训，那么他们就不应当忘记托克维尔一百多年前的告诫：

只有自由才能在这类社会中与社会固有的种种弊病进行斗争，使社会不至于沿着斜坡滑下去。事实上，唯有自由才能使公民摆脱孤立，促使他们彼此接近，因为公民地位的独立性使他们生活在孤立状态中。只有自由才能使他们感到温暖，并一天天联合起来，因为在公共事务中，必须相互理解，说服对方，与人为善。

![06.jpg](https://i.loli.net/2019/06/03/5cf52d415f96564978.jpg)

![07.jpg](https://i.loli.net/2019/06/03/5cf52d414768313551.jpg)
