---

layout: post

title: 陶崇园：被遮蔽与被损害的 | 谷雨

tags: 陶崇园之死

categories: Archive

date: 2019-03-26

image_feature: "https://i.loli.net/2019/03/26/5c9a4808d3aef.jpg"

description: 我们也再无法得知陶崇园生前残酷真相的答案。但我们清楚，在陶崇园2018年春天离开之前的那段日子里，有一些事情实实在在地发生了。

---

谷雨实验室：~~[陶崇园：被遮蔽与被损害的 \| 谷雨](http://archive.li/qyJX5#selection-21.1-21.18)~~

撰文 \| 葛佳男

编辑 \| 王天挺 

事实核查 \| 刘洋

---

![](https://i.loli.net/2019/03/26/5c9a4808d3aef.jpg)

2019年3月25日——在陶崇园一周年祭日的前一天，他的家人和陶崇园生前的研究生导师王攀签订了和解协议。协议包括王攀赔偿陶的家人抚慰金人民币65万元，同时当面向陶的家人道歉。时隔一年，王攀最终认错道歉：“我，王攀，对陶崇园在教育培养过程中自己的不当言行表示道歉，我对失去陶崇园这名优秀学生深表痛心，对陶崇园的悲剧表示惋惜。”

与此同时，我们也再无法得知陶崇园生前残酷真相的答案。但我们清楚，在陶崇园2018年春天离开之前的那段日子里，有一些事情实实在在地发生了。故事硬核作者用半年的时间，找到他曾经的朋友、同学和恋人，回顾他的过往，体察他的世界。在那段日子里，他是不安、惶恐和孤立无援的。我们最大程度地接近他，也以此纪念他——他作为一个被伤害的人曾经真实地存在在我们身边，而多数人视若无睹。

## 1

2018年春天和冬天交叠的时候，陶崇园告诉好朋友们自己已经好起来了。或者，至少，在好起来的路上。大部分朋友都相信了。没有不信的理由。

过去大半年他们知道陶崇园过得很糟。成为出色的研究者是他进大学就立下的志愿，然而追随5年的导师用尽手段阻拦他去国外更好的学校读博，非要留他在身边。他备受煎熬，生活滞重不前，时常向他们诉苦。但一些人诉苦是小动物在凄风冷雨中瑟瑟发抖，需要人抱进怀里取暖，而另一些人，他们诉苦像强台风过境的清晨，一面哀叹雨骤风疾、损失惨重，一面已经准备好收拾残枝败叶了——“他表达痛苦，你也会觉得他有办法应对。”

尊师重道。成绩出色。严谨沉稳。善良友爱。从15岁起，陶崇园就是那种你遇到问题会去找他聊很长的天的人。他们甚至有些能理解那个王老师，谁会轻易放走陶崇园这样的学生呢。班里公认难相处的男生也要求换到跟他同桌。理科生没什么了不起的形容词，只会讲当年高三两天一大考，神经都给磨细一圈儿，男生逮住大扫除的机会逃难般溜出去打篮球，就陶崇园不走，一人干完五个人的活儿。他的名字萤火虫一样出现在高中女生熄灯后的寝室，代表着“德行很好很好”，“就是那种心里很干净的”。他爱笑。眼睛眯成两道窄缝，在女生看来有一种腼腆之情，在男生看来有一种和煦之意。陶崇园就是这样的人。

春节过完，陶崇园约喜欢的女孩子谢雨瑶和她的好友郭玥吃饭——三人都是高中同学，陶崇园像所有暖男一样长情——聊到他决定放弃读博、先去工作的事儿。我可能工作两年就想去结婚了，陶崇园说，好好教育一个小孩，不走应试道路，给小孩多一点自由。我不确定会不会要小孩，谢雨瑶说。她有一张非常漂亮的少女的脸，个性却正相反，为反抗上司的骚扰和欺压辞掉人人称羡的国企工作，四处云游，陶崇园给她的每一条朋友圈点赞。很多年来，他们之间的联结建立在他欣赏她却无法真的认同她。他私下对学心理学的郭玥讲过，雨瑶是不是该有规划一点。我也不确定是否会要小孩，郭玥说。我一定要，陶崇园说。两个女孩揶揄他，万一以后你结婚，非常喜欢你的妻子，但妻子就是不想要小孩怎么办？陶崇园郑重其事思考了很长时间，说，那我领养一个吧。

要到很后来她们才能反应过来这其中的寄望是什么意思。好好教育一个小孩，给他多一点自由少一点控制，多漂亮的希望，那是无上美德。当时她们只觉得陶崇园可爱。3月份开学她们还隔着电话线讨论，陶子这阵子发朋友圈比以前频繁许多啊，天气风景花草，乃至路边的小狗，都给配上最积极的形容词，好像世间万物突然间皆可以让他感到无比喜悦了似的。谢雨瑶莫名有点担心，生活中真能有那么多喜悦吗？

3月26日那天电话从晚上开始打进来。陶崇园的高中兼大学校友打给曹维，就是那个要跟他换到同桌的男生（他们成了最好的朋友），曹维像是要找什么人否定他似的，打给一圈人。郭玥在小组讨论，摁掉了，对方再打，再摁掉，再打，她回过去。每一个字都让人无法理解：陶崇园出事了。自杀，跳楼，今天一大早。半个班的高中同学赶回了武汉，殡仪馆隔壁的小旅馆惨白如纸。陶崇园的妈妈和姐姐没有声音地流眼泪，姐弟俩曾是他们村子第一个和第二个大学生、第一个和第二个研究生，若陶崇园顺利读博还将是第一个和第二个博士生，他们的妈妈给自己微信取名“甜蜜如斯”。任什么安慰都显得太轻浮了。但是，到底是什么地方出了错？曹维凌晨从宿舍抢出了陶崇园的电脑，一开始他们什么都没找到。又不死心地里里外外翻找一遍，连“2018毕业资料”这种看起来乏善可陈的文件夹都打开查验，没想到居然在这里。是一个文件夹，建立于2017年11月，打开全是和那个叫王攀的老师的聊天记录截图，以一种做研究式的严谨分好类，整整齐齐排列着。最底下有一篇关于高校性骚扰的论文，保存者欲盖弥彰地改掉了它的文件名。

2017年12月16日22时39分，短信——“晚安前等这六个字。”“我还是不习惯这么说，个人认为说出来感觉很假，我的方式是看行动和表现。”“你的确在做人的灵活性方面很有问题，这必将限制你的发展。你毕竟比不过xxx，但是我还会教化你。”2017年12月26日22时52分，QQ——“陶崇园！”“到！”“坦坦荡荡说出那六个字！”“爸我永远爱你。”

一群人翻着翻着，像拼一块被拆解到无限碎的拼图，小片小片，无论怎么努力，绝望和空白也比能看明白的多。每个人都发现自己在哭。陶崇园说过老师管得太严让人有压迫感，他们当时以为是学术上要求过高；说过总有一天要把一切曝光出来，以为是指老师研究水平不行——为什么你没有告诉我们？谢雨瑶想到那天吃饭他不断强调自己已经好了，已经找到解决方案了。现在她明白当一个人竭尽全力想让自己相信什么的时候才会那般不断把话语翻面。陶崇园说，王老师这个人就是争强好胜，所以你就表现得像个懦夫，像个手下败将，像已经被他死死踩在脚下，这样他就不屑于跟你玩了，他就会放过你。

就像书里写的：故事从未被真正了解。

## 2

武汉理工11级自动化3班的男生们第一次见王攀是在南湖校区的学生宿舍。也不知道谁先喊起来，班主任来了班主任来了，紧接着进来一位男老师，留到脖颈的长头发很齐整地全部往后梳，看起来不大像寻常老师的样子。所有男生被叫到一起，跟在后面的一个学长先介绍了一通，总不过是老师如何厉害、实验室成果如何丰硕之类。接着发给每个人一张表格，让填生日、籍贯、兴趣爱好等等。时隔7年，之所以还有人回忆得起来，完全源自表格末端那个古怪的问题：“是否接受军事化管理？”新生军训刚刚结束，一张张十八九岁的脸青春得就像是青春本体。有人心想最多是再训一轮嘛，大小伙子也不怕这个，吃点苦什么的呗，顺手填上了“是”。

稚鸟出樊笼，一切都新鲜，一切都展开在广阔的阳光之下，青春的丰盛诱人之处就在于这种近乎无所谓的勇敢。王老师总是最会挑时机的。

![](https://i.loli.net/2019/03/26/5c9a480b295f7.jpg)

<figcaption>武汉理工大学南湖校区现场集合了约7000名新生参与军训。图片 | 视觉中国</figcaption>

新学期正式开始，王攀越来越显出与众不同。首先感受到的是几个班委。班长赵宇楠收到王老师转的一笔钱，说是学校给班主任的劳务津贴，他分文不取，全投入班级事务里；团支书陆青接到任务统计贫困生和外省离家远的同学名单，王老师要用自己的工资报销车票。陶崇园是学习委员，他自告奋勇担任这个职务，竞选宣言是“希望带着大家一起学习”。他被派去统计同学们有什么想看的书，王老师出钱买。对比其他班主任一问三不管，根本不存在似的，三个男生私下讨论，都对这位老师产生了尊敬之情。王老师可真慷慨。王攀单独带他们参观自己创立的“决策与控制”实验室，又问最近上什么课，学习怎么样，班里情况怎么样。王老师对班级真上心。

第二次，王攀直接把他们叫去了家里。房子在东院校区，老旧的教师公寓面积不大，客厅可能没铺地板吧，印象中是这样——他们一进门就被王老师喊住了。站好！他说。才军训过的学生遵循这样的口令几乎是条件反射。然而脑子是愣住的。王老师让他们站成直线，稍息，立正，左转，右转，动作必须同步。一边做动作，老师一边坐在老板椅上定定地看，一边又问，最近上什么课，学习怎么样，班里情况怎么样。语气如常，一位关怀学生的班主任的语气。

那天骑车回南湖的路上，出于某种至今难以被准确描述的原因，他们都没有起头为刚刚的事情交谈。赵宇楠默默在心里想，表格是填了，怎么着，还真给我们来这套啊？拥有东北人粗壮神经的陆青不是多想的人，就感觉挺好玩儿，“这老师挺有意思”。至于陶崇园怎么想的，事到如今已经没有人知道了。辅导员告诉过班委，王攀老师属于我们学院里“性格比较特殊”的一位老师，如果遇到什么事情可以来找辅导员讲。只有赵宇楠去找过辅导员，讲的是王老师给班里的经费应不应该接受。他总觉得收老师的钱怪怪的。

整个大一，王攀的与众不同收获了众多学生的仰慕。他给本科生只上一门课，花大量时间谈论文章诗词、获奖经历，还有他热爱的体育运动。他们都知道老师羽毛球、乒乓球和网球打得极好。他甚至拥有一支足球队，与实验室同名。经常和他打球可以获得额外照顾。王老师的长头发永远光亮水滑。又听闻王老师不用手机，不在乎世俗眼光，没找过老婆。每个月工资花光，全用在学生身上。多么卓尔不群。多么遗世独立。很多时候理工科的学生比文科生更需要一个校园传奇，就像科学家在实验最艰难的阶段需要音乐和诗。而传奇的效用之一，就是让许多不好理解的事情变成了合情合理的。

让学生去家里“训练”是合情合理的。它是传奇的一部分，优秀学生才有资格了解的部分。后来的训练已经不总是三人一起，他们被加入一个叫“知微见著”的QQ群，王攀会单对单用QQ通知时间。进老师家门必须敲三下，进去必须先“站好”，两手必须紧贴裤缝，脚尖必须分开呈60度。王老师跟你训着话，聊着天，冷不走过来拨弄你的手臂，摇晃你的肩膀——老师说，这是要检查你站得标不标准，意志力坚不坚定。王老师每次都强调，注意力要集中，要服从军事化的风格。老师说得有道理。

一回，赵宇楠和陆青一起被叫去训练，站军姿时嘻嘻哈哈玩闹，被罚蹲马步。两个大男生用半蹲的姿势面对着面，都从对方眼里看到了尴尬。那次之后不久赵宇楠下了决心，用他能想到最委婉的方法表示不想参加这种“训练”了。王攀没说什么，后来真的不怎么再叫他去。陆青练得不好。他很瘦，有一次头晕得站不住，不得不半途坐下来休息。他也被叫去的少了。

他们都是被筛掉的人。陶崇园是最好的——尊师重道、严谨沉稳、善良友爱的陶崇园。平日他一个脏字都不会说，连“我靠”也不说。赵宇楠和陶崇园轮流占领班里第一名，他欣赏他，又觉得不好意思像对待陆青一样乱开玩笑，总归少了一层亲近。只知道陶崇园去王老师家频繁许多。那时候陶崇园喜欢一个在校园通讯社做编辑的女孩，他喜欢人的方式是非常努力地写文章，走很长的路陪她值班，在女孩子失恋的时候带她去校门口吃麦旋风。他没买自己的。大家都知道他是农村考出来的小孩。没过多久，陶崇园的一个室友间接收到王老师指示，意思是陶崇园同学爱好文学，但囿于家庭条件没有电脑，请室友每天把电脑借他用两小时。王老师坚持为此给室友付钱。

再见面，高中好友们发现陶崇园开始频繁提起一位王老师：学术能力强，文章写得好，擅长各项运动，思想境界很高，并且非常器重自己。谢雨瑶找陶崇园吃饭，吃着吃着王老师的电话打进来，问陶崇园在哪里、在做什么。他一一回答了。谢雨瑶问他，你们老师还打电话看你在干嘛啊？忍住了没说这很奇怪。这不是私人生活吗。陶崇园说，我们老师对学生很关心的。

后来曹维他们会在电脑里读到那段时间，陶崇园写道：“老师想把我培养成人才……老师说我要有远大的理想，要和别人不一样，要出众，身体素质要好，成绩要好。”

“前不久，老师看我接触的知识面窄，没有电脑，总是用别人的，就资助我一台，虽然是很普通的，但却够用。我只有感叹，他年轻有为，我却如一颗孤星般渺小。他心胸宽广，达则兼济他人，我却毫无能力。如若有一天，我也有所作为，定当也有助于他人。”

![](https://i.loli.net/2019/03/26/5c9a480c3adbd.jpg)

<figcaption>陶崇园。供图 | 陶崇园的姐姐</figcaption>

## 3

乔辛加入“决策与控制”实验室是因为朋友陶崇园的缘故。大二大三，课业紧张起来，学校又把他们从南湖搬到东院，宿舍条件一落千丈，每间屋四对铁架子床，六张住人，两张放行李。如果有个能让人好好待着的地方，简直是值得感恩的事情。王老师根本没什么项目给本科生做，可以在实验室自习、上网、看电影，从早待到晚。陶崇园来问想不想加入，当然了，怎么可能不想。

他知道陶崇园也问了别人。班长赵宇楠，第一个拿国家奖学金的；陆青，一入学就是团支书；刘昊，也是班里前几名。相形之下，他不是班委，成绩不好不坏，一度纳闷自己为什么被选中。他和陶崇园是经常一起上自习结下的友谊，俩人一样是农村考上来的，都是话不多那种。他很佩服陶崇园不声不响考出了C语言证书，他觉得太难了，没报名。后来熟起来，在宿舍联机打英雄联盟。不过两人打得都很克制。陶崇园来问的时候说，你性格好。

什么叫“性格好”？乔辛说，当时大家都天真得很。

乔辛曾认认真真想过老师究竟喜欢陶崇园什么。思考结果是，在他做了那么多事情之后，“亲近也是一种该有的回报”。

自进实验室，从一百多人的“知微见著”群升级进入十几人的“C&D进行时”群，他们愈发意识到被当成“自己人”之后王老师便不那么好相处了。学会适应规矩是最好的办法。比如被老师叫到（不管线上线下）要答“到！”，不可以答别的，不可以敷衍，更不可以不回答。否则老师要骂人。老师非常会骂人。想不通一个人“语文功底”好成什么样才能达到这种程度，不挑明骂，但每一句都找准最痛的地方说。

研究生石立眼睛不大，群里发合照，王老师说：“没办法，XXX和石立的眼睛睁不开，只找到上面这么一张大家眼睛都睁开的。想睡觉，不能忍一忍？”足球队网站不慎被挂了黑链接，年终总结，王老师说管网站的学生：“我们准备授予你最奇葩网站管理员奖。提名理由：把球队网站办成了一个涉嫌赌博网站。”足球场上骂人则真正是恐怖。丢了球，冲着屁股就是一大脚，让你“滚回去”。几乎没人为自己辩解。王老师最讨厌不同意见。

其实在很长时间里，他们几个本科生都认为无妨把一切看作卓尔不群之人附带的“怪脾气”。只要略微忍耐那么一下，忍成习惯，便能继续拥有不用排队的专属位置，时不时下发的慷慨补贴，以及本科即入选实验室的、微小却足向外人道的光荣。除开刘昊是真喜欢足球，乔辛、赵宇楠和陆青都委婉而坚决地拒绝了王老师几次三番的入队邀请。

陶崇园没有拒绝。他几乎不拒绝老师任何事。中晚两餐，他和一位邓东师兄通常轮番为老师送去家里。邓师兄长得身宽体胖，却神奇地擅长乒乓球，其时是王老师另一大爱徒。后来听说某次打球连赢了老师几盘，遂遭“冷冻”一年。他研究生一毕业就去工作了。王攀有一次在研究所群里点他名，“和你打球，客观上我充当了减肥师的角色。”“你的每一次大范围跑动，效果都不是减肥药可比拟的。”他回，“一般人反应都比较慢，王老师太快了。所以打球不出汗，效果不佳。希望学生在未来的道路上能够一直不让您失望吧。”王攀说，“很难，而且我很被动。你已经山高皇帝远了。”他回，“没有王老师的天赋，只能依靠后天努力了。”乔辛一直觉得这人可比陶崇园圆滑许多。

陶崇园在群里极少说话，他只是默默把事情做好。他很久没有在晚上跟他们一起回宿舍了，临走去隔壁找他，常常看到屋里已经黑了灯。难免好奇，赵宇楠问，你都干啥去啊？心想若是训练未免太晚了些。陶崇园说反正就是去老师家干活儿。他看起来似乎有点不好意思。不过这种种，无非学生为老师出力，说到底也没什么。乔辛原本是这么认为的。

就是有那么一天，突如其来，王老师要求去家里的消息发到了乔辛QQ上。不问他意见安排，一个具体时间横在那，没有拒绝的余地。接着每一天、每一天都被叫去。太频繁了，他开始感到烦躁。站军姿，踢正步，做俯卧撑，略有松懈，王老师马上起身扳直他的肩膀，按紧他的手，一遍又一遍讲那些不可能有人记得的大道理。到后面老师一开口他就感觉是要“洗脑”。狭小的空间，只有他和老师两个人，一天又一天，他感到自己快要窒息了。但与此同时，老师发过的补助，给过的回乡路费，以及越来越频繁带他出去吃饭也横在脑子里。他理解陶崇园了。他们这样的人，受人恩惠，怎么说得出口推脱。后来知道老师问过很多同门对他的评价。也终于知道“性格好”是什么意思——“怎么说呢，农村出来的人，特别容易感恩”。于是用尽力气掩饰住心底的抵触，时时紧绷，处处恭敬，甚至生出面对封建皇帝的错觉。隔天还去。再隔天亦然。

![](https://i.loli.net/2019/03/26/5c9a480d4ad77.jpg)

<figcaption>武汉郊区农村。图片 | 视觉中国</figcaption>

半个多月后的一天，王老师叫了他和陶崇园一起去家里。乔辛很奇怪，他以为这种事情向来是一对一的。做完训练，老师没有立刻放他们走，而是说今天运动累了，要“放松”一下。陶崇园很了然的样子，走过去熟练地为老师捶背、捏腿。乔辛愣在旁边，脑袋嗡的一下。没人解释。回到宿舍他才从懵然中醒过来。再去王老师家，重又变回他一个人，做完训练老师自然而然对他说，今天踢球/打球累了，要“放松”一下。这下他全懂了。原来是循序渐进的试探。

“放松”的规矩，肩和背是用捶的，老师坐着，学生站着。可他从小到大都没有做过这种事情，给爸妈都没有过。接下来是胳膊和手，王老师最在意自己这一双手，常夸赞它们是最巧的、最灵活的，按起来不能轻、不能重，要让它们保持弹性。他为与同性的身体接触感到本能抗拒，意识晚一步才反应过来，那是屈辱的感觉。再往下到了小腹、大腿，改用按捏，老师半躺着，学生跪着或者坐小板凳，老师说这些位置有重要穴位。他要憋坏了，他需要找人聊聊这件事。可是他要怎么说？别人会怎么看他？连自己都认为不该发生，他说不出口，更无法允许自己说出口。有段时间王老师显然颇为满意，告诉他最近正步踢得不错，很像个军人，给你买一套军装吧。这也算“恩惠”。可又不是真的军人，哪有场合穿得上军装？无非是到老师家里穿。他又能对谁说？最后是小腿。对了，他还有一个同病相怜的朋友陶崇园。他知道陶崇园一样每天要来，有时老师让他离开便是因为接下来陶崇园要来。谁也不知道王攀为什么需要这么多“放松”。

因为不愿任何人知晓这一切，基于同理心，乔辛从未问过陶崇园去老师家的事。唯一的一次忍耐不住，他极其小心地选择了措辞：去王老师家里感觉怎么样？以为他应该明了自己问的什么。以为他同样需要一个出口。然而，陶崇园的回答轻描淡写到乔辛已经想不起来了。他们是同样自尊的人。况且陶崇园比他更骄傲，那种优秀成习惯的人才会散发的骄傲曾一度令他羡慕。乔辛明白了，他们之间再不会谈起这个话题。

那是他们上大三时候的事情。

![](https://i.loli.net/2019/03/26/5c9a480e09152.jpg)

<figcaption>给王攀“放松”的部位图。供图 | 王攀的学生</figcaption>

## 4

到下一届研究生入门，陶崇园已经是那个去讲王老师如何厉害、实验室成果如何丰硕的师兄。开学前的暑假，王攀让他领着新挑的学生搞“训练”。高中同学陈卓来找陶崇园玩，看到那三个男生在他面前腼腆畏缩的样子，非常诧异。又觉得好笑，怎么会有学生连“陶崇园这种人”都怕？认识这么多年，陶子是他见过脾气最好的人。他心想，这些研究生，真是怂得不行了。

石立那时候的确怕陶师兄。这是实话。他的怕就像欲穿马路的行人躲避红袖章，不是腼腆畏缩的怕，而是不愿惹麻烦的怕。除了公认优秀的师兄，陶崇园还是研究所的“陶总管”，足球队的“陶队”，王攀财务的管理者，所有人都在传，陶崇园就是王攀的儿子。他很少参加他们私下活动，说要留在学校帮老师买饭。连每日开车接送王老师的“副队长”高洋也说自己只是个“打杂的”——他是另一个学院的博后，王攀承诺帮他留校任教——陶崇园才可算“亲信”。快递来了，他能帮陶崇园取却不好开口让陶崇园帮他取：不能随便用“王老师的人”。

夏日傍晚，操场人来人往，他们跟着口令站队、跑步、打复合拳，愈发显得人像傻瓜。结束要写汇报给老师，日日不能重样。日日尴尬。石立无时无刻不想吐槽，然而——陶崇园是“王老师的人”——不敢跟他说。

事实上他们不敢跟任何同门说。王老师挑选他喜欢和信任的学生，交叉获取信息，联系一对一进行，谁也不知道还有谁是老师的“亲信”。他们三个新入门的男生尚未开学便被召来学校，王攀找一处两居室小公寓，补贴几百块房租，叫他们跟四位师兄合租在一起。读研期间石立一直住在那里，没见王老师来过。但王老师什么都知道。王老师喜欢强调集体，要感恩集体，获得奖学金捐一部分出来，为集体做贡献。他在群里宣布某某同学自愿捐款多少多少元，剩下的人也不好不捐。捐款都打到陶崇园支付宝上。研究所，小公寓，球队，集体是他们的学业前程，他们的娱乐，他们的社交生活。集体里唯独没有——或者说不能有——哪怕一个真正交心的朋友。

王攀在群里发儿时照片，集体跟着在下面排队：“王老师从小帅到大！”“王老师这个照片看着像一名宇航员！”“确实很帅，不过大家觉得王老师现在比小时候又帅了很多！”就像跟王老师打乒乓球不容易，那个曾被“冷冻”一年的邓师兄总结，同学们相互之间也不容易。二者都需要些“技术掌握”。

陶崇园跟郭玥见面，看似不经意地说，我觉得我导师很擅长心理学，比较会操纵人的心理。郭玥一时懵住，专业反射地想到许多心理学古怪电影。陶崇园不再往下讲。她回想他关于那位王老师的描述，似乎说过是个特立独行、不受世俗眼光约束的人。那么怪一点也能理解吧。郭玥没往下问。很久以后才发觉，若再问下去就好了。顾华和陶崇园一样立志做研究，研究生遇到一个完全不管他的放养式导师，找陶崇园诉苦，对王攀器重他流露出羡慕之意。陶崇园说，管得太严也不一定是好事。顾华只当是安慰。好友从来不是爱抱怨的人。

本科毕业季，大家本来已经看到陶崇园发朋友圈，预备跟女朋友曹欣然保研去同一个学校，成双成对，无限美好。过几天看竟给删掉了，都很奇怪。事过境迁，曹维他们在陶崇园电脑看到和王攀的邮件往来，发现陶崇园已然严肃告知了离开的决定。王攀当天把他叫去了家里。电脑里还储存着王攀的一纸承诺：陶崇园同学读研期间每年补贴5000元，毕业时优先推荐去国外读博。

曹欣然看过那份承诺书。她是个实心眼的姑娘，当时正非常认真地跟陶崇园交往，陶崇园郑重对她说，将来咱们一起当老师，工资全交给你，家里脏活累活都给我干。他的浪漫跟一般男生不一样。王攀知道他们在一起，在实验室留好一个位子给她，有补助福利，也多发她的一份。她一度真心认为这老师对陶崇园好，支持他留在王攀身边读研。而有其他人回忆起来，多少看出些借她“稳住”陶崇园的意思。她没觉察。到他出事才听闻，王攀常对陶崇园讲她配不上他；不许陶崇园帮她拎包，因为“这样是掉陶崇园的底子，进而一步是掉我的底子”。曹欣然想起大四那年，陶崇园告诉她自己和王老师之间的确是“义父子”关系。她问他，不怕别人知道吗？陶崇园答，只要他不对外承认，学院里再怎么传也只是传闻而已。他叮嘱她千万不要告诉别人。

如果没有后来那件事，石立很可能像陶师兄当年一样——适应、习惯、顺流而下。他按指示加入了足球队，尽管从未喜欢过足球。王老师在运动场上判断人的能力，如果你是个男生，还有志做出点科研成绩，几乎等同于你非挑一项陪老师运动不可。周一、周四和周六羽毛球，周三、周日足球，周二、周五乒乓球，天天不落，排成惯例，排成课程表之外的另一套课程表。身处一个包围你社交圈的集体，由服从权威衍生出从众实在太容易了。反正大家都是这样的。

球队几乎每个人都与王攀起过冲突，与此同时又会告诉你，老师待自己很好。具体怎么好法？想许久，除了经济上，好像也想不出别的。夏季有“高温补助”，冬季有“寒冷天气补助”，踢一场球10块钱，期末考“营养补助”200元，圣诞也有“节日福利”100元……小流积成江海，潜意识总感到领受了老师无限大的恩情。于是对外说什么，做什么，都不敢“忘恩负义”了。私下聚餐才敢相互讲段子：分两队踢比赛，被王老师挑中和他一队的多半要挨骂倒霉，做他敌人比较开心；他们总能想出办法让王老师“一过九”，一人连过九人，梅西也没这种能耐……喝了酒，讲得笑泼出来，久而久之，倒像是他们包容了老师近乎变态的好胜心。王老师得知他们私下聚餐，主动给报销了。

直到那一天，老师突然让石立签了一张聘为“球队特别助理”的打印纸。隔两日又交代，特别助理有一项特别的任务：为自己“放松”。部位愈发尴尬，老师进退自如，而他啼笑两难。第四次，把饭放下，立正站好，他对老师说：我不想做。王老师训了他大半个小时。一句听不懂，亦不想听。最后仿佛自己也觉得无趣了，笑一下，终于放他走人。

回来之后石立马上告诉整个研究所的同门，直截了当讲王攀是如何招自己去按摩的。这样的事情让他浑身难受。任何道理都不应该让人理所当然接受这些。师兄师弟们听了，迅速说，换了他们肯定也不会做——直到陶师兄出事石立才看明白，在这个集体，自尊心会封牢他们的嘴。

石立也被筛掉了。从那以后研究所的好事似乎不再跟他有关系。王老师没让他参与任何项目，他心想那些研究早过时了，本来也不想做。足球场上，王老师骂他越来越凶，动辄当着所有人哄他下场。一年后的一天他终于忍够了，调头离场，对王攀说要退出球队。陶崇园师兄打电话劝他，回来吧。那其中的情分、无奈，石立不是不明白——真跟老师闹翻才是真的麻烦。

陶师兄正上研三，跟王老师矛盾已经翻到明面上，听说导火索是师兄想去国外读博而王攀坚决阻拦，说他背叛研究所。他们眼看着王老师成日铺陈陶崇园的不是，今天是“研究能力勉强好于后30%”，明天是“情商很低，令人不快”，后天是“道德水准已经滑落到底线之下”。从前日日挂在嘴边的爱徒，一夜之间被扔进道德的幽谷。说尽兴了，把他从群里踢出去，过两天重新加回来，好继续说。陶师兄从来不响。除非被问到事务性工作，陶崇园在群里几乎不讲话，尤其不会讲那种漂亮话。不像高洋卢琛他们，总是很活跃。卢琛是传闻中王老师的另一个“儿子”，留任学校青年教师，王攀据说“出了力”。高洋白天接送王老师，晚上回实验室便讲他各种段子，玩笑说这些发到微博都能赚上一笔。而陶崇园对王老师有过真心敬重。他所看重的恰恰是老师口中那一点道德，而如今，老师要拿这道德把他捆起来。正如人人都知道陶队是最恪尽职守的“铁后卫”，永无可能抢到球门跟前出风头。再踢球，王老师依然每次要陶崇园跟自己一队。

那半年，陶师兄开始参加他们的活动，甚至主动约几个师弟吃饭聊天，与石立聊得尤其多。他看得出陶崇园努力掩饰的苦闷、尽可能维持的“师兄感”，给他讲这些年许许多多与王攀相处的“教训”，用的是传授经验的口吻。而他自己，打消原先那一点“怕”对陶崇园敞开心扉，不能说没有一点同为天涯沦落人的成分。这建立在废墟上的信任真残酷。虽然师兄真的是很好的人。毋庸置疑，每个认识他的人心里都这么想。于是这友谊便愈加显得残酷了。

石立一直记得2018年初那个晚上。他和陶师兄在实验室晚自习，王老师突然闯进来，看样子明显喝得醉了。他不由分说把他们拎起来训话，用手来来回回拍打他的脸。石立屈辱难抑。他感到心里有火要爆发，那种还没想清楚自己要怎么做、但就是控制不住要喷出来的火。师兄在旁边用力拉住了他。终于熬到王攀离开，陶崇园对他说，该忍的时候还是忍一下，忍到毕业就可以走了。然而两个月之后，终归无法再忍下去的是师兄自己。

![](https://i.loli.net/2019/03/26/5c9a480f56ccc.jpg)

## 5

陶崇园和王攀的矛盾闹得很大。基于前者找了他能找到的所有人去劝老师请别生气，让他顺利毕业就好，连抗议看起来都得体；后者则永远在提及此事时表示， “如果陶崇园放弃武汉理工大学的硕士学位，则我无权做任何建议”“研究所力量很强，他根本就算不了什么”——但凡在研究所待过，想装不知道都难。邓东已经毕业快三年，远在千里之外，做着与本专业毫不相干的工作。他看着最欣赏的小师弟被从群里踢出去，加回来，再踢出去，被影响他最深的老师公开评价为“道德败坏”，说不上是什么心情。他终于点开王老师的对话框。

邓东：一方面是自己的前途，一方面是对研究所的感情，这种矛盾使他有这种纠结心态，在大事面前又不够成熟。并不是像您想象的那样，就是道德败坏啊。您可以去做民意调查，看看到底他人怎么样。

王攀：每个人的认识都是片面的，而我做多目标决策，各种目标、复杂场景、多种因素，只有我能清晰给出最准确的判断。

王攀：我是有意为之。绝对是要让他认识到一个团队对他的重要性。

应该是这么说的，他记得。关于王老师想从陶崇园身上获得什么，寻求什么，邓东一下子全部了然了。几年前，老师对自己说过几乎一模一样的话。

其实师弟们传闻有误，那天他并没有连赢王老师好几盘。他这样的聪明人，早早洞悉跟老师运动的压力远比做研究多。当初在足球队，他被骂了几回即自称天分不足，主动退队，转而用更擅长的乒乓球代偿。又摸索出“对抗”和“放水”之间的完美平衡，从每日送餐的学生，逐渐升级为王老师离不开的学生。那次他的确接连胜了几盘，但并非王老师——“如果那样的话，我可完了”——是来球室玩的另一位老师。跟旁人打球他不会多想。不想王老师在一旁看着脸就垮下来。夺过拍子与他对打，每一拍都“往死里呼”，像一种惩罚，呼到球都打不到快输的时候于他就更像一种惩罚。王老师不参与人际交往，运动就是他的社交方式，他的资源库。他全部精力用来经营那些各式各样的群，关键时刻截图说一句“上面一个群是羽毛球群，有中科院院士、国际学术组织的主席（注：不是副主席）、长江学者等一干人。在我的治下，都比较规矩。”学生老师，全震慑住了。

这是邓东许久以后想明白的。那时他只知道王老师突然对自己冷淡下来。不必每日守候送餐，也不用掏空心思琢磨今天球如何打、心得体会如何写，他竟有一种从高处跌落的感觉。于是找了实习，王老师问也没问。直到大半年后实习结束，有一天，老师像什么都没发生过一样把他叫去了乒乓球室。“通过这种方式让你切身体会到团队这种东西，”王老师说，“让你到外面去吃吃苦。”他心中居然庆幸，想这总归是一件好事。

周二、周五的打球恢复了。每次交汇报分析王老师球技的高明之处，老师又对他说：为了更好地培养你，给我做点“放松”。把我调理健康，训练你打球的时间才能更长。他能怎么想？老师让他们做事总有个顺理成章的缘由。乒乓球室只有他和老师两个人，他一米八几的个子折叠了，跪下来，为老师按摩大腿根，想如果球技能持续提升那也不错。就像当初老师说精确到分钟送饭是为了锻炼他“守时”，他想能成为一个时间观念强的人那也不错。还能怎么想呢？若不学会一点自我调节那就太辛苦了。如此几个月，一回王老师大比分赢了他，又说：你每次输这么多球，我还定点定期陪你练，没让你交学费就算客气了，你赶紧拜个师父。他依言双膝跪地，对老师磕了一个头。那是叩拜菩萨的姿势。他想，老师的确比自己打得好，那怎么办呢，跟着他学习。再后来，他快要毕业了，老师给他讲“张良拾鞋”的典故，脱下鞋子向远处扔出去，命令他像张良对姜太公那样为他捡回来。他对自己说，反正时间不长，坚持一下就过去了。

王老师的“理论体系”多完善啊。邓东想，恐怕很少有人比他更了解老师多么擅长此道。“决策与控制”，他是这圈子里的头儿，他要掌控一切。哪怕那些“理论”再不被社会认可，在这个圈子里，他制定的规矩就是最高准则。老师喜欢用几年甚至十几年的时间去“考验”一个人。研究生最多三年，到了博士至少就有四五年，所以他会用各种方法留住你。他还会承诺帮你留校，毕业仍留在他身边，那就成了一辈子剪不断的关系。

邓东跟王攀聊过就给陶崇园发消息。不知该如何讲破，只能劝他，哪怕委曲求全，也一定要在取得老师支持的情况下出去。他读研时陶崇园上大二，两人同时间进研究所，同用一间屋，同时期成为王攀最倚重的学生。陶崇园在他心里一直有个特殊位置：这孩子人品太好了。“这些都不是事儿，”他对陶崇园说，“你各方面都那么优秀，肯定能挺过去。”

那阵子陶崇园几乎浸泡在这类安慰里。然而不知不觉，秋天到了冬天，朋友们依旧发现他脸上的笑意像武汉的温度一样矮下去。他在和曹维、顾华的群里讲很多话。最初说，王攀学术水准实在不高，博士绝不再这么“混”过去；后来开始讨论如何越过导师申请公派留学。到最冷的时候见到他，那么爱笑的一个人，身上居然萌出焦虑退弃之意，再不提读博的事情，四处问他们找工作的经验。但无论如何，看上去他永远在想办法解决问题，就像从前每一次一样——“他表达痛苦，你也会觉得他有办法应对。”偶尔听他说“为王攀做了四年服务”，“他们都说我儿子以后就是他的孙子”，都没当成多大的问题。再忍一忍就毕业了，朋友们这么劝他，不要跟老师起正面冲突。他们当时真的不知道。

高洋想通过王老师留校的事儿黄了。这是当时研究所另一件人人皆知的事。由于王攀承诺时的口吻过于有诱惑力，且严禁他另找渠道，高洋一并错过了其他机会。他非常懊恼，懊恼到对陶崇园产生了难兄难弟之情。后来大家在陶崇园电脑里看到他们的对话。高洋说，“陶队，我感觉亏大了，心里不平衡啊，想弄人。”“我现在给他办事+挣钱，他还那个样子，真无语。他的给予必须自己给，别人不能要。”“等过段时间，我把跟他接触的种种写一封材料，如果他敢动，我立马弄死他。”陶崇园总是劝慰。他仍是最安全的树洞，最靠谱的朋友。他接纳、安慰、化解别人的痛苦，合着自己的痛苦一同咬烂了，吞下去，深深锁起来。本科室友与导师相处不顺，回学校找他们这帮哥们喝酒浇愁，几杯黑啤下去，要浇愁的人没醉，陶崇园倒喝醉了。他从车上一路吐回学校，跌进宿舍，把衣柜上的镜子踢得粉碎。深秋的夜，凉意潮水般一浪一浪侵上来，陶崇园一遍又一遍对室友低吼：你是不是嫌弃我？

他们从未见过他这个样子——那个最温文尔雅、脏话都不会说的陶崇园。那是人们印象中他唯一一次失控。直到很久以后才有人意识到，或许，有那么几次，他差一点就说出口了。或许他也在等着有人问他，你怎么了？你要讲吗？曹维2017年失去至亲，痛苦难当之际只想跟陶崇园倾吐。陶崇园陪着他，安慰很长时间，突然说，我的痛苦跟你有过之而无不及。曹维被自己的痛苦压倒，他没有问。2018年2月9日，寒假离校前的最后一天，陶崇园和球队的杜斌博士一起健完身，相约去吃宵夜。走在路上，他拿手机给杜斌看：杜博，王老师又叫我到他家里去。我去不去？杜斌说，那你去吧，快去快回，我们等你。“我不想去，我知道他要干什么。”陶崇园顿了顿，“还有些别的事情，我不好跟你们说。”杜斌一直知道陶崇园要给王老师“放松”，也知道他在那边不开心、不快乐——他自己早吸取经验，把跟王攀的相处牢牢“约束到足球场上”。再多的不知道了。他也没有问。

三年前，离毕业只剩一两周的时候，邓东再一次被叫去老师家。原以为只是送餐，按惯例敲三下，立正站好，王老师笔直对他说道：经过对你的长期考察，我愿意把你再晋升一级，做我的干儿子。你有两天时间考虑，可以给出三个答案，一个是同意，一个是不同意，一个是暂缓。老师的用词、语气亦像是在说话：我正授予你至高无上的恩惠。

邓东发现自己竟没有多少意外的感觉。他想到王老师这些年一言一行，想到自己有过“非常崇拜”老师的时候。他的高深莫测，他的格格不入，他所标榜的“至高无上的道德境界”：那无懈可击的“理论体系”啊。从普通学生中筛选出值得器重的学生，再晋级为徒弟，现在又晋级到“儿子”——再往上还会有什么东西？这个“级”，一直可以晋到什么程度？不敢去想。而他可以笃定，一旦成为“儿子”，老师必然要行使所谓做“父亲”的控制方法了。邓东没有感到意外。他感到恐怖。

![](https://i.loli.net/2019/03/26/5c9a48106a10a.jpg)

<figcaption>武汉理工大学南湖校区，自主招生考核现场。图片 | 视觉中国</figcaption>

## 6

3月26日手机响时邱红已经睡着了。迷迷糊糊摸起来，凌晨2点，来电显示儿子陶崇园。“妈，我有点不舒服，我睡不着。”儿子说。“是不是最近写论文呢？”“反正我就是睡不着，我脑子里不停地想东西。”儿子焦躁的声音让她彻底醒了。“我现在过来。”她说。坐起来穿衣服，一会儿陶崇园又打来了，“妈你不用过来，我没事，我没事。”“你确定吗？妈妈衣服穿好了。”“没事，你不放心的话明天一早来。”

挂掉电话邱红再也睡不着了。儿子一向身体强健，从没出过这样的事。儿子想申请国外的博士，他导师坚决不允许，邱红多少也知道。在她看来这老师虽然自私了些，到底是看重他，总劝儿子忍一忍，毕业在即，不要跟老师起冲突。儿子上大学以后，她在隔壁学校的食堂找了一份工作，四天前的中午，大雨如注，陶崇园接连到她这里打了两回饭。她很奇怪，问你不是刚刚吃了吗，怎么又来？刚刚是送给老师吃的，他说，跟老师吵了一架，老师怪我没有按规定敲门，非逼着作揖道歉。陶崇园眼睛红红的。她追问，为什么作揖？怎么还要作揖道歉呢？陶崇园说，他就是这样，控制欲特别强，别人都离他远远的。她心里突突跳。

早上六点多，邱红去了陶崇园宿舍。儿子就在楼下，她迎上去，看到他脸上覆盖着一层憔悴的灰。

“园园你究竟怎么了？你是有什么事瞒着我们了？你把妈妈吓死。” 儿子看起来真的就是一夜没睡的样子。

“我不知道为什么，我反正睁眼闭眼都是王攀，总是想着王攀的种种。”

“王攀又怎么了？”邱红心里发慌。

“他叫我签一个承诺书，工作之后还要为他服务，还要为他出钱出力，而且读博还要第一时间联系他。”

“他为什么要你写这个承诺书？”她心想，我的儿子，由你一个老师来分配，世上哪有这种事情，“你为什么写？”

“毕业要他签字，我是缓兵之计，”陶崇园说，“但他现在还要发到研究所的群上。如果以后我不信守这个承诺，别人怎么看我？我痛恨不守信用的人！”

邱红更慌了。她唯一能想到的就是带他去吃饭。校门口早餐铺才开门，蒸腾而起的水汽给人希望的感觉。她给儿子叫了一碗热干面，自己叫了一杯豆浆。她没胃口，儿子也是。他一直看手机，他们都没有说话。他突然起身走了出去，吓了她一跳。

“园园你怎么了？园园你究竟怎么了？”她急急跟在后面追。“我受不了，我真的受不了，我不知道怎么摆脱王老师。”陶崇园嘴里重复着，径直往宿舍方向走。邱红听到这些瞬间流出泪来。“你怎么说得这么严重？你是不是有什么事瞒着我了？”她一把将儿子拉住，一面祈祷女儿快点到，清晨出门时她给女儿小庆打了电话，“姐姐马上就来了，我们一起看有什么事，委屈跟我们说。”“好，”陶崇园拖着母亲走向校门口，“那你在这里等我一下，我去拿几本书。”“等姐姐来了再一起去。”她死命拽住他。“我现在去拿，你就在这里等着我。”陶崇园把母亲甩脱了。

他先是继续往前走，然后加快了脚步，最后干脆奔跑起来。

跑过门口广场边的小径。曹维来找他的时候无数次经过这里。开学回来他对曹维说买了几千块的新衣服，细细解释购买每一件的缘由。这件显得人挺拔，那件看起来线条好。他说他看透了，要重新规划个人形象，重新开始生活。还说要改名。他不喜欢“园”，更喜欢“源”，桃花源的“源”。

跑过连接宿舍区的回廊。那里枝蔓缠绕，开着零星叫不出名字的花。陶崇园喜欢花。3月开始，云游到大理的谢雨瑶常收到陶崇园信息，他说学校死气沉沉，可否多给他拍些好看的风景。从前他们平均每月深聊一次，那两周，每天有几十条陶崇园的消息涌进她的手机。全是赞美。赞美她的勇敢、洒脱、自由，你真好，喜欢你，谢谢你……而过年见面他尚在问她因为领导骚扰就辞去工作，是不是草率了些。那些过头的赞美让谢雨瑶不知怎么回应。她甚至有些害怕，担心自己成了陶崇园对某种美好生活的投射。3月25号晚上11点多，又收到陶崇园信息，她回：我没有那么好。每个人都有不好的一面，我只是不想呈现出来给人看。早上看到陶崇园的回复：感觉太虚了，太空了，又迷茫了。时间是凌晨2点。她没有再回。

跑过宿舍楼的转角。斑驳的白墙上有四个鲜红大字：育人为本。邱红追不上儿子的速度，她被落在后面，看不到他了。监控录像记录了接下来发生的事情：陶崇园跑进宿舍楼，一直向上跑，没有任何停留，跑到了6层大楼的最顶上。等邱红转过拐角跑过来，儿子已经坠落在回型楼群的天井中。他的灰色运动鞋委顿在地上。邱红尖叫着“救命”闯过栏杆，感到自己马上就要昏厥过去。然而仅存的意识残酷地提醒着她：凌晨那两个电话，是儿子想见妈妈最后一面。

![](https://i.loli.net/2019/03/26/5c9a4811911bd.jpg)

<figcaption>陶崇园跟妈妈吃最后一顿早餐的小饭馆。图片 | 葛佳男</figcaption>

## 7

陶小庆看完陶崇园的电脑和日记本，她不是过去的自己了。过去她自以为了解弟弟就像了解自己的手掌心。她最优秀最亲爱的弟弟在她旁边、在他们寄予理想的高等学府被压迫，被使唤，被当成奴隶。母亲总在夜里哭。再走进理工校园她会不断回头看：我到底是在哪里没拉住我儿子的？父亲从弟弟离开那天起失去了睡眠，整夜整夜枯睁着眼睛。陶小庆把日记翻到快烂了：“信赖别人就是自己的一个错误。”“伪善者，给你的都是要还的！”“奴隶4年整整，一把辛酸泪，血与泪的教训！”那些感叹号仿佛直接叹进她的血肉。陶崇园的手机至今下落不明，她去打印通话短信记录，发现王攀几乎每晚都跟弟弟有十几、几十条短信往来，时间大多在夜里10点以后。那个王攀不是号称遗世独立，不用手机的吗？有记者介绍了律师，她和父母一齐去见。4月过了中旬，武汉气温已然逼近30度，每个人额上都黏着一层细密的汗。律师说证据关联性不够。什么叫关联性？就是王攀究竟对陶崇园做了什么，直接导致他自杀的证据。这早熟的春天要将人烧透了。

她用弟弟的QQ给“研究所”和“球队”列表一个挨一个留言。联系几十人，回复者十几个，答应帮忙者以个位数计。

卢琛说，我什么都不知道，陶崇园和王老师关系特别好。他挂断了电话。

高洋主动说要把手上的材料整理好寄来，过几日又让妻子打电话说，对不起，帮不了你了。他是有办法的人，找途径成功留了校。记者在学校找到他，他全程不肯直呼王攀的名字，代之以“某某”。他说，他这里什么都没有，要是有实锤，就是工作不要也会帮陶队讨个公道。但他知道这一点点东西都是琐事、杂事。他就放弃这“小小的正义”了。

赵宇楠想起王攀至少有两回让陶崇园在实验室当众脱掉上衣，向大家展示训练成果。陶崇园立刻脱了，看起来毫无抗拒，“一直在执行他所给的命令”。但问题是——“他为什么知道陶崇园练得不错？他肯定是在他家见过呀，他肯定在他家让陶崇园脱过衣服。这才是后面的问题：他为什么要陶崇园在他家脱衣服？”

邓东告诉陶小庆，他有模糊的印象听陶崇园提过王攀训练的升级。从他们都知道的体能训练，慢慢加码，升级成一种常人不敢想“特训”。陶崇园当时举了两个例子：看着大便吃东西，在坟山上睡觉。他不知道他是不是真的做过。有阵子他走在校园总觉得毛骨悚然，会神经质地突然停下，回头张望。王攀是不是跟在自己后面？那个人走路没有声音。“希望你们也再去查一下这里面的一些真相，”他悲伤地管陶小庆叫姐姐，“我觉得咱们自己听了这些东西都要做一些（心理）咨询，不然自己都有可能受不了。”

直到跟大家怀念陶崇园的时候，乔辛才知道给王攀“放松”的不止他和陶崇园两人。他想是他那张藏不住情绪的脸救了自己。当年王攀在两个月之后突然不再找他，他至今记得那种解脱的感觉。而石立自始至终明白他不是一个人。他不止一回看到过那个大二的小师弟走进王攀办公室，半天不出来，“猜也猜到了”。小师弟性格跟陶崇园非常像，班里前三名，民主投票选出的班长。王攀是他们的班主任。出事当天下午乔辛给研究所打了一个电话，恰巧被王攀接起来。王攀不紧不慢地问他：你觉得我有错吗？

曹维失去了最好的朋友。半年后他终于入他梦来，他们像以往每个高兴的日子一样逛街、打球、吃饭，曹维穷尽了一生的语言劝他留下。他说生活多好，未来多好，活着多好。陶崇园露出他最熟悉的那种笑容，然后趁梦里的曹维睡着了，再次从楼顶一跃而下。现实中醒来又是清晨。他第二次经历了失去好友的清晨。曹维觉得世界上再也没有人可以让他说说心里话。

![](https://i.loli.net/2019/03/26/5c9a481277c83.jpg)

谢雨瑶在陶崇园死后被诊断出抑郁症。每到最痛苦的时刻她就开始想象一个动作，一直往上跑，一直往上跑，跑到不管哪里的最高点，跳下去。“那个瞬间真的特别，整个人都放松下来了，就是只用靠幻想这一点，幻想这个动作。然后我觉得好像我能理解他。”真善美是什么？理解是什么？最后一个晚上我对你说了丧气话，是不是打碎了你用力建造起来、试图自我疗愈的桃花源。可自我疗愈和自我欺骗的界限在哪里？你谁都不讲，是接受不了那样的自己吧。如果我好到让你觉得可以讲，我想，我会劝你像我当时一样去正面抗争。如果那样的话你还会死吗？

郭玥永远记得2016年的暑假，她和陈卓、陶崇园整日玩在一起，下午游泳，晚上去私人影院的小包间看鬼片。陶崇园选片总要看豆瓣评分，他说，鬼片也要看好的，别浪费时间。陈卓大部分都看过，鬼快出来的时候冷不丁站起来伸个懒腰，吓他们一跳。那是他们生命中的流光带。聚会在半夜结束，零星未眠的汽车尾灯在马路上流转摇曳，她在天桥正中央高声呼喊I’m the king of the world，陶崇园站在她旁边，大笑着回应。那时候真奢侈。整个世界都是他们的。郭玥知道自己以后会毕业，做一份特殊或者平凡的工作，谈恋爱，跟别人结婚，也许有小孩。她明明白白地知道自己的生活将继续向前滚动。但是在某一个小憩醒来的黄昏，或是走在路上一个最庸常无奇的时刻，她会突然想到陶崇园，然后莫名其妙哭起来。

世界不再是他们的。故事中的每个人都被陶崇园的死截停、打断，撞向世界的背面。她明白——他们都明白——自己将永远忘不掉他。

[![](https://i.loli.net/2019/03/26/5c9a4812e6013.jpg)](https://mp.weixin.qq.com/s?__biz=MzUxMzY4NTE2MQ==&mid=2247483999&idx=1&sn=f732e26254574a9f9d0f341fa5dd698f&scene=21%23wechat_redirect)

（应被访者要求，文中所涉采访对象均为化名。故事硬核工作室致力于讲述最好的非虚构故事。本文由腾讯谷雨计划支持，腾讯新闻出品。未经允许禁止转载。）

运营 \| 张琳悦 任倩

校对 \| 阿犁

统筹 \| 王波

[![](https://i.loli.net/2019/03/26/5c9a4819489d4.jpg)](https://mp.weixin.qq.com/s?__biz=MzU2MDEwMTIwMg==&mid=2247489728&idx=1&sn=afddb7823cf62b9ec52bfd54e57a00d4&chksm=fc0c7afdcb7bf3eb154ee5d87761ca49cb8cdaceef835e6e9fdd84e9310cf2f9dda4ddb05ecd&scene=21%23wechat_redirect)

[![](https://i.loli.net/2019/03/26/5c9a4819d97dd.jpg)](https://mp.weixin.qq.com/s?__biz=MzU2MDEwMTIwMg==&mid=2247489702&idx=1&sn=7ab124ce895c975cbf82c33028ac2a2e&chksm=fc0c7a9bcb7bf38d633f857ee0f8c7dae6adbb9a26d1509653eebb5c18338b55c28c36aa8bad&scene=21%23wechat_redirect)

[![](https://i.loli.net/2019/03/26/5c9a481aaf147.jpg)](https://mp.weixin.qq.com/s?__biz=MzU2MDEwMTIwMg==&mid=2247489662&idx=1&sn=358f629e20e105f5b64ef296e4b04d43&chksm=fc0c7a43cb7bf355d878893e1dbadd32f976e0ae8c2183035c7bc89cd6f4e0cbf2b49e0fd0fb&scene=21%23wechat_redirect)

[![](https://i.loli.net/2019/03/26/5c9a481ba5548.jpg)](https://5137c7b63c71d9927aa82a780f48c4c3ff3feb24)
